#version 3

#include "colors.inc"
#include "textures.inc"

#declare Full_Flag  = 1
#declare Bat_Flag   = (1 | Full_Flag)
#declare Cap_Flag   = 0
#declare Plate_Flag = (0 | Full_Flag)
#declare Base_Flag  = (0 | Full_Flag)
#declare Field_Flag = (0 | Full_Flag)
#declare Ball_Flag  = (1 | Full_Flag)
#declare Scene_Flag = (1 | Full_Flag)
#declare Fence_Flag = (0 | Full_Flag)
#declare Poles_Flag = (0 | Full_Flag)
#declare Sky_Flag   = (0 | Full_Flag)
#declare Fence_Circular_Flag = 1
#declare Score_Flag = (0 | Full_Flag)
#declare Scoreboard_Blurred_Flag = 1    // avoid aliasing from long range : use blurred imagemap
#declare Pole_Blur_Flag = 1             // avoid aliasing from long range : use blurred line
#declare Foot = 12

#declare Top_View = 0
#declare Elevated_View = 0

#if (Top_View)
  #declare Camera_Target   = <0, 0, 280> * Foot
  #declare Camera_Location = Camera_Target + 350 * Foot * y
  #declare Camera_Rotate   = 0
  light_source { Camera_Location color White }
  #declare Bat_Flag   = 0
  #declare Plate_Flag = 0
#else
#if (Elevated_View)
  #declare Camera_Target   = <0, 0, 60.5> * Foot
  #declare Camera_Location = Camera_Target + <0, 40, -100> * Foot
  light_source { Camera_Location color White }
  #declare Camera_Rotate   = 0
#else
  #declare Camera_Target   = <0, 2, 10.5>
  #declare Camera_Location = Camera_Target + <5, 4, -16.5>
  // #declare Camera_Angle = 25
  #declare Camera_Rotate   = 0
#end
#end

///////////////////////////////////////////////////
// include header to define parameters
// and textures
//

#include "header.inc"


////////////////////////////////////////////////////
// infield
// Define the crowned infield in terms of a quartic
// function.
//

// infield crown
// initial quartic : x (x - 1) z (z - 1)  - y/(16 ymax) = 0
// x^2 z^2 - x^2 z - x z^2 + x z - (1/16 ymax) y = 0
//
// from documentation:
// a07 x^2 z^2 +
// a08 x^2 z +
// a17 x z^2 +
// a18 x z +
// a29 y
// = 0

#declare InfieldBound =
  box {
    <0, 0, 0>,
    <1, 1.1, 1>
  }

#declare Infield =
  union{
    quartic {
      <0,  0, 0,  0, 0, 0, 0,     // a00 .... a06
       1, -1, 0,  0, 0, 0, 0,     // a07 .... a13
       0,  0, 0, -1, 1, 0, 0,     // a14 .... a20
       0,  0, 0,  0, 0, 0, 0,     // a21 .... a27
       0, -1/16, 0, 0, 0, 0, 0 >  // a22 .... a34
      sturm

      #declare Box =
        box {
          <0, 0, 0>,
          <1, 1.1, 1>
        }
      inverse  // needed for CSG
      clipped_by { object { Box } }
      bounded_by { object { Box } }
    }
    box {
      <0, -1, 0>,
      <1, 0, 1>
    }

    clipped_by { object { InfieldBound } }
    bounded_by { object { InfieldBound } }

    scale <0, Infield_Crown, 0> + <1, 0, 1> * (Base_Distance - 2 * BasePath_R)
    translate <1, 0, 1> * BasePath_R
    rotate -45 * y
  }


//////////////////////////////////////////////////////////
// dirt areas
//

#declare Dirt_Areas =
  union {
    intersection {
      cylinder {
        Infield_C - dY * y,
        Infield_C + dY * y,
        Infield_R
      }
      intersection {
        box {
          <-BasePath_R, -dY, -BasePath_R>,
          <BasePath_X, dY, BasePath_X>
        }
        box {
          <BasePath_R , -2 * dY, BasePath_R>,
          <Base_Distance - BasePath_R, 2 * dY, Base_Distance - BasePath_R>
          inverse
        }
        rotate -45 * y
      }
    }
    intersection {
      union {
        intersection {
          union {
            cylinder {
              First_Position - dY * y,
              First_Position + Infield_Crown * y,
              Base_Circle_R
            }
            cylinder {
              Second_Position - dY * y,
              Second_Position + Infield_Crown * y,
              Base_Circle_R
            }
            cylinder {
              Third_Position - dY * y,
              Third_Position + Infield_Crown * y,
              Base_Circle_R
            }
          }
          box {
            <-BasePath_R, -dY, -BasePath_R>,
            <BasePath_X, Infield_Crown, BasePath_X>
            rotate -45 * y
          }
        }

        // home
        cylinder {
          Home_Position - dY * y,
          Home_Position + Infield_Crown * y,
          Base_Circle_R
        }
      }

      union {
        object { Infield }
        plane { y, 0 }
        translate dY * y
      }
    }



    #declare H = Mound_H - Infield_Crown
    #declare R = ( Mound_R * Mound_R / H + H ) / 2
    sphere {
      Mound_Position + (Mound_H - R) * y,
      R
      clipped_by { plane { -y, 0 } }
    }

    #render "\nMound Info\n"
    #render concat("Mound Height = ", str(Mound_H, 6, 4), "\n")
    #render concat("Mound Radius = ", str(Mound_R, 6, 4), "\n")
    #render concat("R            = ", str(R, 6, 4), "\n")
    #render concat("calculated R = ", str(sqrt(R * R - pow(R - H, 2) ), 6, 4), "\n")


    // warning track
    #if (Fence_Circular_Flag)
      difference {
        cylinder {
          Fence_C - dY * y,
          Fence_C + dY * y,
          Fence_R
        }
        cylinder {
          Fence_C - 2 * dY * y,
          Fence_C + 2 * dY * y,
          Fence_R - Warning_Track
        }
      }
    #end

    texture { Dirt_Texture }
  }



//////////////////////////////////////////////////////////
// home plate
//

#if (Plate_Flag)


  //
  // construct home plate object out of triangle primitives
  //


  mesh {
    // bottom pentagon
    triangle {<0, 0, 0>,  <Xplate, 0, Xplate>,  <-Xplate, 0, Xplate>}
    triangle {<-Xplate, 0, Xplate>, <Xplate, 0, Xplate>,  <Xplate, 0, Xplate2>}
    triangle {<-Xplate, 0, Xplate>, <Xplate, 0, Xplate2>, <-Xplate, 0, Xplate2>}

    // top pentagon
    triangle {<0, Y, 2*dXplate>,  <Xplate-dXplate, Y, Xplate+dXplate>,  <-Xplate+dXplate, Y, Xplate+dXplate>}
    triangle {<-Xplate+dXplate, Y, Xplate+dXplate>, <Xplate-dXplate, Y, Xplate+dXplate>,  <Xplate-dXplate, Y, Xplate2-dXplate>}
    triangle {<-Xplate+dXplate, Y, Xplate+dXplate>, <Xplate-dXplate, Y, Xplate2-dXplate>, <-Xplate+dXplate, Y, Xplate2-dXplate>}

    // bevels  : baseline pair
    triangle {<0, 0, 0>,  <Xplate, 0, Xplate>,  <Xplate-dXplate, Y, Xplate+dXplate>}
    triangle {<0, 0, 0>,  <Xplate-dXplate, Y, Xplate+dXplate>, <0, Y, 2*dXplate>}
    triangle {<0, 0, 0>,  <-Xplate+dXplate, Y, Xplate+dXplate>,  <-Xplate, 0, Xplate>}
    triangle {<0, 0, 0>, <0, Y, 2*dXplate>,  <-Xplate+dXplate, Y, Xplate+dXplate>}

    // bevels : side
    triangle {<Xplate, 0, Xplate>, <Xplate, 0, Xplate2>, <Xplate-dXplate, Y, Xplate2-dXplate>}
    triangle {<Xplate, 0, Xplate>, <Xplate-dXplate, Y, Xplate2-dXplate>, <Xplate-dXplate, Y, Xplate+dXplate>}
    triangle {<-Xplate, 0, Xplate>, <-Xplate+dXplate, Y, Xplate+dXplate>, <-Xplate+dXplate, Y, Xplate2-dXplate>}
    triangle {<-Xplate, 0, Xplate>, <-Xplate+dXplate, Y, Xplate2-dXplate>, <-Xplate, 0, Xplate2>}

    // bevels : facing pitcher
    triangle {<-Xplate, 0, Xplate2>, <Xplate-dXplate, Y, Xplate2-dXplate>, <Xplate, 0, Xplate2>}
    triangle {<-Xplate, 0, Xplate2>, <-Xplate+dXplate, Y, Xplate2-dXplate>, <Xplate-dXplate, Y, Xplate2-dXplate>}

    texture { Plate_Texture }
    translate <0, -0.9*Y, 0>
  }
#end

////////////////////////////////////////////////////
// bases
//

#if (Base_Flag)
  #declare Base =
    superellipsoid {
      <0.3, 0.5>
      scale <Base_X, Base_Y, Base_X>
    }

  // first base
  object {
    Base
    translate <Base_Distance - Base_X, Base_Y, Base_X>
    texture { Base_Texture }
    rotate -45 * y
  }

  // second base
  object {
    Base
    translate <Base_Distance, Base_Y, Base_Distance>
    texture { Base_Texture }
    rotate -45 * y
  }

  // third base
  object {
    Base
    translate <-Base_Distance + Base_X, Base_Y, Base_X>
    texture { Base_Texture }
    rotate 45 * y
  }


////////////////////////////////////////////////////
// Pitcher's Plate
//


  superellipsoid {
    <0.2, 0.2>
    scale < PitchersPlate_X, PitchersPlate_Y, PitchersPlate_Z >
    translate Mound_Position + y * Mound_H
    texture { Plate_Texture }
  }

#end   // Base_Flag

////////////////////////////////////////////////////
// ground
//

#if (Field_Flag)

  // planar portion
  plane {
    <0, 1, 0>,
    0
    texture { Worn_Grass }
  }

  object {
    Infield
    texture { Worn_Grass }
  }

  object {
    Dirt_Areas
  }




  ////////////////////////////////////////////////////
  // batter's box
  //

  #declare Box_Vline =
     box {
      <0, 0, Bbox + Wline>,
      <Wline, Zbox, Tbox - Wline>
    }

  #declare Box_Hline =
    box {
      <Xbox, 0, 0>,
      <Xbox+Wbox, Zbox, Wline>
    }

  #declare Box =
    union {
      object {
        Box_Vline
        translate <Xbox, 0, 0>
      }
      object {
        Box_Vline
        translate <Xbox + Wbox - Wline, 0, 0>
      }
      object {
        Box_Hline
        translate <0, 0, Bbox>
      }
      object {
        Box_Hline
        translate <0, 0, Tbox - Wline>
      }
    }

    #declare Boxes =
      union {
        object {
          Box
        }
        object {
          Box
          scale <-1, 1, 1>
        }
      }

  ////////////////////////////////////////////////////
  // foul lines
  //

  #declare Lfoulline = 380 * Foot
  #declare Foul_Line =
    box {
      <0, 0, 0>,
      <Lfoulline, Zbox, Wline>
      rotate <0, -45, 0>
    }
  #declare Foul_Lines =
    union {
      object {
        Foul_Line
      }
      object {
        Foul_Line
        scale <-1, 1, 1>
      }
      clipped_by {
        box {
          <-Wbox - Xbox - Wline/2, -Tbox, Bbox>,
          <Wbox + Xbox + Wline/2, 2*Tbox, Tbox-Wline/2>
          inverse
        }
      }
    }


  union {
    object { Boxes }
    object { Foul_Lines }
    texture { Chalk_Texture }
  }

#end


/////////////////////////////////////////////////////
// fence
//

#if (Fence_Flag)
  #if (Fence_Circular_Flag)
    #render "\nCircular Fence :\n"
    #render concat("Fence_C.z = ", str(Fence_C.z/12, 6, 4), " feet\n")
    #render concat("Fence_R = ", str(Fence_R/12, 6, 4), " feet\n")

    cylinder {
      Fence_C - Fence_H * y,
      Fence_C + Fence_H * y,
      Fence_R
      open
      inverse
      texture { Fence_Texture }
    }
  #else
    #render "\nSquare Fence\n"
    #render concat("Fence_X = ", str(Fence_X/12, 6, 4), " feet\n")
    #render concat("Fence_Z = ", str(Fence_Z/12, 6, 4), " feet\n")

    box {
      <Fence_Lines, 0, -Fence_Lines>,
      <Fence_Lines + Fence_T, Fence_H, Fence_Lines>
      texture { Fence_R_Texture }
      rotate -45 * y
    }
    box {
      <-Fence_Lines, 0, -Fence_Lines>,
      <-Fence_Lines - Fence_T, Fence_H, Fence_Lines>
      texture { Fence_L_Texture }
      rotate 45 * y
    }
    box {
      <-Fence_X, 0, Fence_Center>,
      <Fence_X, Fence_H, Fence_Center>
      texture { Fence_C_Texture }
    }
  #end
  #render concat("Fence_H = ", str(Fence_H/12, 6, 4), " feet\n")
#end

/////////////////////////////////////////////////////
// score board
//

#if (Score_Flag)
  #include "scoreboard.pov"

  object {
    Score

    #if (Fence_Circular_Flag)
      translate <0, 0, Fence_R>
      rotate Score_Theta * y
      translate Fence_C
    #else
      rotate -90 * y
      translate <-Fence_Lines, 0, Score_Z>
      rotate 45 * y
    #end

  }
#end


/////////////////////////////////////////////////////
// foul poles
//

#if (Poles_Flag)
  #declare FoulPole =
  union {
    polygon {
      5,
      #if (Pole_Blur_Flag)
        <-0.5 * Wline, 0>, <1.5 * Wline, 0>, <1.5 * Wline, FoulPole_H>, <-0.5 * Wline, FoulPole_H>, <-0.5 * Wline, 0>
        texture { pigment { color rgbt <1, 1, 1, 0.5> } }
      #else
        <0, 0>, <Wline, 0>, <Wline, FoulPole_H>, <0, FoulPole_H>, <0, 0>
        texture { pigment { color rgb 1 } }
      #end
    }
    polygon {
      5,
      <Wline, 0>, <FoulPole_W, 0>, <FoulPole_W, FoulPole_H>, <Wline, FoulPole_H>, <Wline, 0>
      texture { FoulPole_Texture }
    }
  }

  object {
    FoulPole
    translate <0, 0, Fence_Lines + 2 * FoulPole_W>
    rotate -45 * y
  }

  object {
    FoulPole
    translate <0, 0, Fence_Lines + 2 * FoulPole_W>
    rotate -45 * y
    scale <-1, 1, 1>
  }
#end

/////////////////////////////////////////////////////
// baseball bat
//

#if (Bat_Flag)
  // Note attempts to model this using a faster sov object
  // resulted in anomalies which appeared to represent POVRAY
  // bugs in the implementation of that object type.
  // Coordinates were taken from a commercial GIF.

  #declare Unit_Bat =
    lathe {
      cubic_spline
      11,
      <-0.0240, 0.0040>,
      <0.0000, 0.0000>,
      <0.0240, 0.0040>,
      <0.0251, 0.0175>,
      <0.0177, 0.0224>,
      <0.0094, 0.1970>,
      <0.0166, 0.4115>,
      <0.0292, 0.6783>,
      <0.0347, 0.9800>,
      <0.0000, 1.0000>,
      <-0.0347, 0.9800>
      sturm

    }

  // define bat
  object {
    Unit_Bat
    texture { Bat_Texture }
    scale Bat_Length
    rotate 67 * y
    rotate <90 - Bat_Theta, 45, 0>
    translate <-5, Bat_X0, 5>
  }

#end

/////////////////////////////////////////////////////
// ball
//

#if (Ball_Flag)
  #declare Ball_Location = <-1, Ball_R, 36>
  #declare D = vnormalize( Ball_Location - Camera_Location )

  sphere {
    <0, 0, 0>,
    Ball_R
    texture { Ball_Texture }
    rotate 180 * z
    rotate <0, degrees(atan2(D.x, D.z)), degrees(atan2(-D.y, vlength( <D.x, D.y, 0> ) ) )>
    translate Ball_Location
  }

#end

/////////////////////////////////////////////////////
// cap
//

#if (Cap_Flag)
  #declare IMPORT_SPATCH = 1
  #include "cap.pov"

  #ifdef (Ball_Location)
    #declare Cap_Location = Ball_Location * <1, 0, 1> + <15, 4 * dY, 24>
  #else
    #declare Cap_Location = <-15, dY, 24>
  #end

  object {
    Cap
    rotate -30 * y
    translate Cap_Location
  }
#end

////////////////////////////////////////////////////////
// sky
//

#if (Sky_Flag)
  #include "sky.inc"

  object {
    Sky
    rotate -40 * y
  }
#end

////////////////////////////////////////////////////////
// render
//

#if (Scene_Flag)
  camera {
    perspective
    location Camera_Location - Camera_Target
    right <4/3, 0, 0>
    up <0, 1, 0>
    look_at  <0, 0, 0>
    #ifdef (Camera_Angle)
      angle Camera_Angle
    #end
    rotate Camera_Rotate
    translate Camera_Target
  }

  light_source {
   <-100, 100, -100>
   color rgb 0.5
   fade_distance 40 * Foot
   fade_power 2
  }
#end
