#include "consts.inc"
#include "header.inc"


#declare Score =
 union {

  // main board
  box {
    <-Score_W/2, -Score_H/2, 0>,
    <Score_W/2, Score_H/2, Score_D/2>
    texture {
      pigment {
        image_map {
           #ifndef (Scoreboard_Blurred_Flag)
             #declare Scoreboard_Blurred_Flag = 0
           #end
           #if (Scoreboard_Blurred_Flag)
             png "scoreboard_blurred.png"
           #else
             png "scoreboard.png"
           #end
          interpolate 2
        }
        translate <-0.5, -0.5, 0>
        scale <Score_W, Score_H, Score_D>
      }
    }
  }
  box {
    <-Score_W/2, -Score_H/2, Score_D/2>,
    <Score_W/2, Score_H/2, Score_D>
  }

  // border
  box {
    <-Score_W/2 - Score_Border_X, -Score_H/2 - Score_Border_X, -Score_Border_Z>,
    <-Score_W/2, Score_H/2 + Score_Border_X, Score_D>
  }
  box {
    <Score_W/2 + Score_Border_X, -Score_H/2 - Score_Border_X, -Score_Border_Z>,
    <Score_W/2, Score_H/2 + Score_Border_X, Score_D>
  }
  box {
    <-Score_W/2, -Score_H/2 - Score_Border_X, -Score_Border_Z>,
   <Score_W/2, -Score_H/2, Score_D>
  }
  box {
    <-Score_W/2, Score_H/2, -Score_Border_Z>,
    <Score_W/2, Score_H/2 + Score_Border_X, Score_D>
  }

  // support
  box {
    <-Score_W/2, 0, Score_D/2>,
    <-Score_W/2 + Score_Support_X, -Score_P.y, Score_D/2 + Score_Support_X>
  }
  box {
    <Score_W/2, 0, Score_D/2>,
    <Score_W/2 - Score_Support_X, -Score_P.y, Score_D/2 + Score_Support_X>
  }

  #declare Y = vlength( <0, Score_P.y, Score_Support_Z> )
  #declare T = -degrees( atan2(Score_Support_Z, Score_P.y) )
  box {
   <0, 0, 0>,
   <-Score_Support_X, -Y, Score_Support_X>
   rotate T * x
   translate <Score_W/2, 0, Score_D/2>
  }
  box {
   <0, 0, 0>,
   <Score_Support_X, -Y, Score_Support_X>
   rotate T * x
   translate <-Score_W/2, 0, Score_D/2>
  }

  #declare Y = vlength( <Score_W - Score_Support_X, Score_P.y, 0> )
  #declare T = -degrees( atan2(Score_W - Score_Support_X, Score_P.y) )

  union {
    box {
      <-Score_Support_X/2, -Y/2, Score_D/2>,
      <Score_Support_X/2, Y/2, Score_D/2 + Score_Support_X>
      rotate T * z
    }
    box {
      <-Score_Support_X/2, -Y/2, Score_D/2>,
      <Score_Support_X/2, Y/2, Score_D/2 + Score_Support_X>
      rotate -T * z
    }
    translate <0, -0.5, 0> * Score_P
  }


  translate Score_P

  texture { Score_Texture }
 }

#ifndef (Camera_Target)
  #declare Camera_Target   = Score_P * <1, 0.7, 1>
  #declare Camera_Location = Camera_Target + 10 * <-35, -10, -20>

  plane {
    y,
    0
    texture { pigment { color rgb <0, 0.5, 0> } }
  }

  object { Score }

  light_source  {
  	  Camera_Location
	  color rgb 1
	  fade_distance 20
  }

  camera {
  	  location Camera_Location
	  look_at Camera_Target
  }
#end

