
///////////////////////////////////////////////
// include textures and parameters associated
// with this project
//

#include "header.inc"


///////////////////////////////////////////////
// camera
//

#declare Camera_Target   = <0, 5, 10> * Foot
#declare Camera_Location = Camera_Target + <-10, 0, -20> * Foot

camera {
    location Camera_Location
	look_at Camera_Target
}


////////////////////////////////////////////////
// ground plane

plane {
	y,
	0
	texture {
        pigment  {
                        checker
 			            color rgb <0, 0.5, 0>
                        color rgb <0, 0.3, 0>
                        scale 30 * Foot
        }
        finish { ambient 0.3 }
	}
}


////////////////////////////////////////////
// boxes to show depth effects
//

#declare dZ = 18 * Foot
#declare Count = 20
#while (Count)
  #declare Count = Count - 1

  box {
    <-1, -1, -1> * Foot,
    <1, 1, 1> * Foot
    rotate 90 * < rand(Seed), rand(Seed), rand(Seed) >
    translate <0, 1, 0> * Camera_Target + z * dZ * Count
    texture { pigment { color rgb <1, 1, 0> } }
  }
#end


////////////////////////////////////////////
// chalk lines
//

#declare Xline = 3

box {
  <-Xline, -2 * dY, -100 * Foot>,
  <Xline,  2 * dY, 1000 * Foot>
  texture { Chalk_Texture }
}

box {
  <-4 * Xline, -dY, -100 * Foot>,
  <4 * Xline,  dY, 1000 * Foot>
  texture { Dirt_Texture }
}

#include "sky.inc"
object {
  Sky
}



light_source {
	Camera_Location
	color rgb 1
	fade_distance 12 * Foot
        fade_power    2
}



