/**
 *  Source:	nature.pov
 *  Revision:	1.2
 *  Date:	1998-06-24
 *  Author:	Tor Andersson
 *
 *  two tooth beasts by lakeside
 *  ruin of a tower, two large tree trunks, a bug and som birds
 *  hazy blue sky
 *  pink flowers
 *
 *  IRTC May/June 1998 -- Nature
 *
 *
 */

// ==== Includes ====
#debug "Loading...\n"

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "grid.inc"

// ==== Studio ====================================
light_source {<2000,2000,-2000> color White*0.8}        // main sun
light_source {<1500,7500,-1000> color White*0.5}    // back up sun
light_source {<2000,1100,-2000> color White*0.3 shadowless} // trees
light_source {<-300,1600,-1500> color White*0.4}    // back up sun (tower)

camera {
  location <-3,1.7,0>
  look_at  <-3.5,1.05,5>
}

fog {
  fog_type 2      // ground fog
  distance 35
  fog_alt 5
  color rgb <0.5,0.5,0.7>
  turbulence 3
}

sky_sphere {
  S_Cloud1
  rotate y*180
}


// ==== Textures ===================================

#declare T_Water = texture {
//    pigment { color red 0.11 green 0.4 blue 0.42 }
//    finish  { reflection .45  specular 1 }
//    normal  { ripples .35  turbulence .5  scale 0.3 }

    pigment { color rgb <0.11,0.4,0.42>*0.2 }
    finish  { reflection .66  specular 1 }
    normal  { ripples .35  turbulence .5  scale 0.3}
 }

#declare T_Bark =  texture {
    pigment {color rgb<.56 .56 .4>}
    normal {wrinkles .6 scale .15}
    finish {crand .05 ambient 0.1}
    scale <1,5,1>
  }

#declare T_Foliage = texture {
    pigment { color rgb <0.2,0.8,0.0> } }

#declare T_Grass = texture {
    pigment { image_map { tga "grass.tga" /*interpolate 2*/ }
    rotate x*90 scale 6 }
  }

#declare T_TowerStone = // T_Stone8, but without phong, and less ambient
  texture{pigment{color White}
          finish{ambient 0.2 crand 0.06 diffuse 0.7}
  }
  texture{T_Grnt0a scale <2, 3, 2> rotate <0, 0, -30>}
  texture{T_Grnt9a scale <5, 3, 4> rotate <0, 0, 40>
          finish{ambient 0.1 diffuse 0.5}
  }


//----- From stones1.inc, slightly darkened
#declare df = 0.8
#declare My_Grnt9a = texture { pigment { granite turbulence 0.6 color_map {
    [0.000, 0.216   color rgbf <0.812, 0.812, 0.812, 0.835>*df
                    color rgbf <0.745, 0.843, 0.835, 0.847>*df]
    [0.216, 0.241   color rgbf <0.745, 0.843, 0.835, 0.847>*df
                    color rgbf <0.404, 0.337, 0.337, 0.463>*df]
    [0.241, 0.267   color rgbf <0.404, 0.337, 0.337, 0.463>*df
                    color rgbf <0.773, 0.729, 0.745, 0.622>*df]
    [0.267, 0.759   color rgbf <0.773, 0.729, 0.745, 0.622>*df
                    color rgbf <0.914, 0.843, 0.725, 0.651>*df]
    [0.759, 0.784   color rgbf <0.914, 0.843, 0.725, 0.651>*df
                    color rgbf <0.153, 0.133, 0.208, 0.437>*df]
    [0.784, 0.810   color rgbf <0.153, 0.133, 0.208, 0.437>*df
                    color rgbf <0.812, 0.812, 0.812, 0.835>*df]
    [0.810, 1.001   color rgbf <0.812, 0.812, 0.812, 0.835>*df
                    color rgbf <0.812, 0.812, 0.812, 0.835>*df]
   } } }
#declare My_Grnt0a = texture { pigment { granite turbulence 0.6 color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.306>*df
                    color rgbf <0.769, 0.686, 0.592, 0.792>*df]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.792>*df
                    color rgbf <0.843, 0.753, 0.718, 0.396>*df]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.396>*df
                    color rgbf <0.780, 0.667, 0.561, 0.976>*df]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.976>*df
                    color rgbf <0.741, 0.659, 0.576, 0.820>*df]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.820>*df
                    color rgbf <0.729, 0.502, 0.451, 0.306>*df]
   } } }

#declare T_Stone =
  texture{pigment{color White} finish{ambient 0.2 crand 0.06 diffuse 0.7} scale 0.3 }
  texture{My_Grnt0a scale <2, 3, 2> rotate <0, 0, -30> scale 0.3 }
  texture{My_Grnt9a scale <5, 3, 4> rotate <0, 0, 40> finish{ambient 0.1 diffuse 0.5} scale 0.3 }


#declare T_ToothSkin =  texture {  // pink leathery skin
	pigment {color (Pink*4+SpicyPink)/5}
	normal {bumps scale 0.05}
	finish {phong 0.3} }
#declare T_ToothTeeth = texture {  // bone white shiny teeth
	pigment {color rgb <1,1,0.8>}
	finish {phong 0.7 phong_size 60} }

#declare T_BugBody = texture {      // green metallic sheen
	pigment { color Green*0.3 }
	finish { specular 0.9 } } 
#declare T_BugHead = texture {      // black shiny chitin
	pigment { color White*0.1 }
	finish { specular 0.9 } }
#declare T_BugEyes = texture {      // red bug eyes
	pigment { color Red*0.3 }
	finish { phong 0.9 } }

#declare T_Gull = texture { pigment { color White*0.9 } }
#declare T_Raven = texture { pigment { color White*0.3 } }

// ==== Objects ====================================

// ==== Land ====
#declare SwampWater = object {
  plane { y,0 }
  texture { T_Water }
}

#debug "  Land...\n"
#declare SwampLand = height_field {
  tga "swamphf.tga"
  smooth

  texture {
    material_map {
      gif "texmap.gif"
      //interpolate 2
      texture { pigment { color Brown } }                                       // mud
      texture { T_Stone scale <1/100,1/5,1/100> rotate -x*90 }                  // rock
      texture { T_Grass scale <1/100,1/5,1/100> rotate -x*90 }                  // dk grass
      texture { T_Grass scale <1/100,1/5,1/100> rotate -x*90 }                  // grass
    }
    rotate x*90
  }

  translate <-0.5,0,-0.5>
  scale <100,5,100>
  translate <0,-0.1,0>
  //texture { pigment {color DarkGreen} }
  //texture { T_Grid }
}

// ==== Creatures ====
#declare IMPORT_SPATCH = on

#debug "  ToothBeast...\n"
#declare ToothBeast = union {
  object { #include "tooth1.inc" texture { T_ToothSkin } }  // body
  object { #include "tooth2.inc" texture { T_ToothTeeth } } // teeth + hooves
}

#debug "  Beetle...\n"
#declare Beetle = union {
  object { #include "bug1.inc" texture { T_BugBody } }  // body
  object { #include "bug2.inc" texture { T_BugHead } }  // head
  object { #include "bug3.inc" texture { T_BugEyes } }  // eyes
  object { #include "bug4.inc" texture { T_BugHead } }  // jaws + antennas
}

/*
#debug "  Raven...\n"
#declare Raven = object {
  #include "raven.inc"
  texture { T_Raven }
}
*/

#debug "  Gull...\n"
#declare Gull = object {
  #include "gull.inc"
  texture { T_Gull }
}


// ==== Plants ====
#debug "  Flower...\n"
#include "flower.inc"
#declare Flower = object { TheFormObject translate <0,0.2,0> scale 3 }

#debug "  Tree...\n"
#declare Tree = union {
  object { #include "tree1.inc" texture { T_Bark } }
  object { #include "tree2.inc" texture { T_Foliage } }
}

// ==== Tower ====
#debug "  Tower...\n"
#include "tower.inc"


// ==== Assemblage =====================================
#debug "Assembling...\n"

// landscape
#debug "  (land)...\n"
object { SwampWater }
object { SwampLand }

// creatures
#debug "  (creatures)...\n"
object { Beetle scale 0.5 rotate -z*9 rotate -y*40 translate <-4.5,0.33,3.0> }                // giant beetle (fgnd)

object { ToothBeast rotate -z*5 rotate -x*10 rotate y*45 rotate -z*2 translate <-2,0.5,7.6> } // right toothbeast (mdgnd)
object { ToothBeast rotate -y*60 translate <-7,0.5,12> }                                      // left toothbeast (bgnd)

//object { Raven scale 0.65 rotate y*20 translate <-15.5,7.6,21.3> }                          // raven on tower

object { Gull rotate y*20 translate <2, 12, 50> }					      // sea gulls in bgnd
object { Gull rotate y*45 translate <0, 9, 50> }
object { Gull rotate y*70 translate <2, 9, 30> }

// plants
#debug "  (vegetation)...\n"
object { Flower translate <-1.9,0,2.4> }
object { Flower translate <-6,0,4> }
object { Flower translate <-0.5,0,6> }
object { Tree scale <3,2.7,3> translate <-4.5, 0, 15> }
object { Tree scale <3,3,3> rotate y*90 translate <5, 0, 20> }

// Tower + rubble
#debug "  (building)...\n"
object { Tower rotate -x*90 scale <0.4,0.4,-0.4>
  rotate -y*25 rotate -z*6 translate <-16,1,24>
  texture { T_TowerStone }
}
superellipsoid {
  <0.3, 0.3>
  scale 0.3
  rotate x*30
  rotate -y*40
  rotate z*10
  translate <-12,1.1,18>
  texture { T_TowerStone }
  texture { pigment { color rgbt <0.4,0.4,0.4,0.5> } }

}
superellipsoid {
  <0.3, 0.3>
  scale 0.3
  rotate x*20
  rotate -y*20
  rotate z*20
  translate <-15,0.9,20>
  texture { T_TowerStone }
  texture { pigment { color rgbt <0.4,0.4,0.4,0.5> } }
}
superellipsoid {
  <0.3, 0.3>
  scale 0.3
  rotate x*20
  rotate -y*20
  rotate z*20
  translate <-14,1.0,21>
  texture { T_TowerStone }
  texture { pigment { color rgbt <0.4,0.4,0.4,0.5> } }
}

#debug "Done\n"
