//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 13 textures and 62 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 06/24/1998    (24.06.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.114,0.114,0.369> }

fog {
  fog_type 2    // Ground Fog
  distance     8.5
  color <0.145098,0.243137,1.0,0.101961,0.0>
  turbulence   <0.5,0.5,0.5>
    omega      0.5
    lambda     2.0
    octaves    2
    turb_depth 0.5
  up           <0,0,1>
  fog_offset   -1.5
  fog_alt      2.0
}

camera {  //  Camera StdCam
  location  <-3.591, -5.105, -1.500>
  direction <0.0,     0.0,  1.6095>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.011, 0.469, -0.251>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <0.000, -0.001, 0.000>
  direction <0.0,     0.0,  0.3680>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, -0.001, -0.001>
}

*/

/*
camera {  //  Camera SpotCam002
  location  <-0.641, 7.264, 2.668> // Attached to SpotLite001
  direction <0.0,     0.0,  0.5501>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-0.457, 7.070, 1.705> // Following SpotLite001
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight SpotLite001
  <-0.641, 7.264, 2.668>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-0.457, 7.070, 1.705>
    falloff   42.27  // outer radius (in deg)
      radius    32.01  // inner radius
}

light_source {   // Light002
  <0.340, -2.000, -0.670>
  color rgb <0.702, 0.702, 0.702>
  shadowless
  fade_distance  1.0
  fade_power 1.0
}

light_source {   // Light001
  <-2.092, -1.434, 2.540>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  6.0
  fade_power 1.0
}


//
// ********  TEXTURES  *******
//

#include "drdolph.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

box { // Cube002
  <-1, -1, -1>, <1, 1, 1>
  texture {
    JetTrail
  }
  no_shadow
  hollow
  scale <0.5, 4.3, 0.2>
  rotate 10.0*z
  translate  <0.3, 10.0, 3.7>
}


#declare HgtFld4 = object {
  height_field {
    gif "C:\graphics\PovRAY\scenes\PovWin3\teeth.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    TeethTexture
  }
  no_shadow
  scale <0.5, 0.3, 0.075>
  rotate <180.0, 0.0, -90.0>
  translate  <0.34, -1.65, -0.575>
}
#declare CSG6 = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.25, 0.075>
    translate  <0.34, -1.4, -0.575>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.5, 0.15>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.34, -1.65, -0.5>
  }
  no_shadow
}
#declare CSG7 = intersection {
  object { HgtFld4 }
  object { CSG6 }
  no_shadow
}
#declare Fin7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, 0.299302, 0.011328>, <-1.662989, 0.801911, 0.022657>, <1.757702, 0.801911, 0.022657>, <1.757702, 0.299302, 0.011328>,
      <-1.000000, 0.031243, 2.000000>, <-1.000000, 0.265792, 2.000000>, <1.000000, 0.032699, 2.000000>, <1.000000, 0.032664, 2.000000>,
      <-2.168124, -0.693179, 3.205520>, <-2.168124, -0.458629, 3.205520>, <-0.104982, -0.458629, 3.836938>, <-0.104982, -0.693179, 3.836938>,
      <0.406362, -1.616020, 5.750199>, <0.406362, -1.615985, 5.750199>, <1.000000, -1.615985, 5.903382>, <1.000000, -1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, 0.299302, 0.011328>, <1.757702, -0.203307, 0.000000>, <-1.662989, -0.203307, 0.000000>, <-1.662989, 0.299302, 0.011328>,
      <1.000000, 0.032664, 2.000000>, <1.000000, 0.032630, 2.000000>, <-1.000000, -0.203307, 2.000000>, <-1.000000, 0.031243, 2.000000>,
      <-0.104982, -0.693179, 3.836938>, <-0.104982, -0.927728, 3.836938>, <-2.168124, -0.927728, 3.205520>, <-2.168124, -0.693179, 3.205520>,
      <1.000000, -1.616020, 5.903382>, <1.000000, -1.616054, 5.903382>, <0.406362, -1.616054, 5.750199>, <0.406362, -1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound10
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, -0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <90.0, 0.0, 90.0>
  translate  <0.6, 0.3, -0.7>
}
#declare Fin8 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, -0.299302, 0.011328>, <-1.662989, -0.801911, 0.022657>, <1.757702, -0.801911, 0.022657>, <1.757702, -0.299302, 0.011328>,
      <-1.000000, -0.031243, 2.000000>, <-1.000000, -0.265792, 2.000000>, <1.000000, -0.032699, 2.000000>, <1.000000, -0.032664, 2.000000>,
      <-2.168124, 0.693179, 3.205520>, <-2.168124, 0.458629, 3.205520>, <-0.104982, 0.458629, 3.836938>, <-0.104982, 0.693179, 3.836938>,
      <0.406362, 1.616020, 5.750199>, <0.406362, 1.615985, 5.750199>, <1.000000, 1.615985, 5.903382>, <1.000000, 1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, -0.299302, 0.011328>, <1.757702, 0.203307, 0.000000>, <-1.662989, 0.203307, 0.000000>, <-1.662989, -0.299302, 0.011328>,
      <1.000000, -0.032664, 2.000000>, <1.000000, -0.032630, 2.000000>, <-1.000000, 0.203307, 2.000000>, <-1.000000, -0.031243, 2.000000>,
      <-0.104982, 0.693179, 3.836938>, <-0.104982, 0.927728, 3.836938>, <-2.168124, 0.927728, 3.205520>, <-2.168124, 0.693179, 3.205520>,
      <1.000000, 1.616020, 5.903382>, <1.000000, 1.616054, 5.903382>, <0.406362, 1.616054, 5.750199>, <0.406362, 1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound11
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, 0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.3, -0.7>
}
#declare Main_Fin3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.203307, -0.414108, 0.000000>, <-0.203307, -2.242323, 0.000000>, <0.140821, -2.242323, 0.000000>, <0.140821, -0.414108, 0.000000>,
      <-0.203307, -0.234661, 2.069018>, <-0.203307, -1.027607, 2.414108>, <0.140821, -1.027607, 2.414108>, <0.140821, -0.234661, 2.069018>,
      <-0.185583, 0.879966, 3.521728>, <-0.185583, 0.086802, 3.396359>, <0.158544, 0.086802, 3.396359>, <0.183186, 0.879966, 3.521728>,
      <-0.022838, 1.620578, 3.575788>, <-0.022838, 1.621293, 3.575026>, <-0.022828, 1.621293, 3.575026>, <-0.022828, 1.620578, 3.575788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.140821, -0.414108, 0.000000>, <0.140821, 1.414108, 0.000000>, <-0.203307, 1.414108, 0.000000>, <-0.203307, -0.414108, 0.000000>,
      <0.140821, -0.234661, 2.069018>, <0.140821, 0.558285, 1.723928>, <-0.203307, 0.558285, 1.723928>, <-0.203307, -0.234661, 2.069018>,
      <0.183186, 0.879966, 3.521728>, <0.207827, 1.673130, 3.647098>, <-0.185583, 1.673130, 3.647098>, <-0.185583, 0.879966, 3.521728>,
      <-0.022828, 1.620578, 3.575788>, <-0.022828, 1.619863, 3.576549>, <-0.022838, 1.619863, 3.576549>, <-0.022838, 1.620578, 3.575788>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound12
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.219972, 1.662025, 1.854809>
      translate  <-0.031243, -0.171151, 1.806901>
    }
  }
  no_shadow
  scale <0.5, 0.5, 0.375>
  translate  <0.3, 1.101036, 0.6>
}
#declare Body4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.023747, -1.180468, -0.470738>, <-0.023747, -1.180836, -0.477953>, <-0.028414, -1.174768, -0.474769>, <0.335151, -1.181475, -0.472643>,
      <-0.197457, -1.668304, -0.581803>, <-0.107480, -3.244363, -0.681593>, <0.118307, -3.396770, -0.472394>, <0.299517, -3.396770, -0.472394>,
      <0.192247, -1.321241, -0.480613>, <0.192247, -1.309056, -0.465774>, <0.246668, -1.357761, -0.649736>, <0.321497, -1.357761, -0.649736>,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.335151, -1.181475, -0.472643>, <0.698715, -1.188182, -0.470518>, <0.723848, -1.188563, -0.469092>, <0.723848, -1.188728, -0.472322>,
      <0.299517, -3.396770, -0.472394>, <0.480727, -3.396770, -0.472394>, <0.794872, -3.244363, -0.681593>, <0.871563, -1.668304, -0.581803>,
      <0.321497, -1.357761, -0.649736>, <0.396326, -1.357761, -0.649736>, <0.464352, -1.309056, -0.465774>, <0.464352, -1.321241, -0.480613>,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.723848, -1.188728, -0.472322>, <0.723848, -1.188892, -0.475552>, <0.706197, -1.188545, -0.472167>, <0.330536, -1.181250, -0.471626>,
      <0.871563, -1.668304, -0.581803>, <0.948254, -0.092245, -0.482013>, <1.041198, -3.407551, -1.035376>, <0.294076, -3.415045, -1.066969>,
      <0.464352, -1.321241, -0.480613>, <0.464352, -1.333425, -0.495452>, <0.396326, -1.221629, -0.873738>, <0.321497, -1.221629, -0.873738>,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.330536, -1.181250, -0.471626>, <-0.045124, -1.173955, -0.471084>, <-0.023747, -1.180100, -0.463524>, <-0.023747, -1.180468, -0.470738>,
      <0.294076, -3.415045, -1.066969>, <-0.453046, -3.422540, -1.098563>, <-0.287435, -0.092245, -0.482013>, <-0.197457, -1.668304, -0.581803>,
      <0.321497, -1.221629, -0.873738>, <0.246668, -1.221629, -0.873738>, <0.192247, -1.333425, -0.495452>, <0.192247, -1.321241, -0.480613>,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>,
      <-0.881936, -0.446649, -0.130056>, <-0.881936, -0.438055, 0.804813>, <-0.346199, -0.431805, 1.291932>, <0.249966, -0.431805, 1.291932>,
      <-0.697936, 2.838230, -0.077669>, <-0.697936, 2.846824, 0.504750>, <-0.297936, 2.853074, 0.904701>, <0.252064, 2.853074, 0.904701>,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>,
      <0.249966, -0.431805, 1.291932>, <0.846130, -0.431805, 1.291932>, <1.507289, -0.438055, 0.804813>, <1.507289, -0.446649, -0.130056>,
      <0.252064, 2.853074, 0.904701>, <0.802064, 2.853074, 0.904701>, <1.302064, 2.846824, 0.504750>, <1.302064, 2.838230, -0.077669>,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>,
      <1.507289, -0.446649, -0.130056>, <1.507289, -0.455242, -1.064924>, <0.846130, 0.557907, -1.436813>, <0.249966, 0.557907, -1.436813>,
      <1.302064, 2.838230, -0.077669>, <1.302064, 2.829637, -0.660088>, <0.802064, 2.821824, -1.160027>, <0.252064, 2.821824, -1.160027>,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>,
      <0.249966, 0.557907, -1.436813>, <-0.346199, 0.557907, -1.436813>, <-0.881936, -0.455242, -1.064924>, <-0.881936, -0.446649, -0.130056>,
      <0.252064, 2.821824, -1.160027>, <-0.297936, 2.821824, -1.160027>, <-0.697936, 2.829637, -0.660088>, <-0.697936, 2.838230, -0.077669>,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>,
      <0.230161, 6.063951, 0.094498>, <0.230161, 6.064703, 0.173160>, <0.285405, 6.067249, 0.230368>, <0.286460, 6.067426, 0.230368>,
      <-0.338272, 6.145586, 0.565650>, <0.274083, 7.098475, 1.053933>, <-0.068203, 7.865803, 1.941383>, <0.312276, 7.862923, 1.941383>,
      <-1.378208, 7.555183, 1.105684>, <-1.378208, 7.555202, 1.105936>, <0.250605, 6.998767, 1.024354>, <0.277646, 6.998767, 1.024354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>,
      <0.286460, 6.067426, 0.230368>, <0.287515, 6.067603, 0.230368>, <0.369565, 6.067056, 0.173160>, <0.369565, 6.066304, 0.094498>,
      <0.312276, 7.862923, 1.941383>, <0.692755, 7.860042, 1.941383>, <0.283162, 7.100495, 1.053277>, <0.792479, 6.173308, 0.565453>,
      <0.277646, 6.998767, 1.024354>, <0.304686, 6.998767, 1.024354>, <1.972202, 7.476926, 1.109407>, <1.972202, 7.476875, 1.108701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>,
      <0.369565, 6.066304, 0.094498>, <0.369565, 6.065552, 0.015837>, <0.287515, 6.064869, -0.055673>, <0.286460, 6.064692, -0.055673>,
      <0.792479, 6.173308, 0.565453>, <1.301797, 5.246120, 0.077629>, <0.473034, 7.151016, 0.798678>, <0.293246, 7.147999, 0.798678>,
      <1.972202, 7.476875, 1.108701>, <1.972202, 7.476824, 1.107995>, <0.304686, 6.995919, 1.032281>, <0.277646, 6.995919, 1.032281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>,
      <0.286460, 6.064692, -0.055673>, <0.285405, 6.064515, -0.055673>, <0.230161, 6.063199, 0.015837>, <0.230161, 6.063951, 0.094498>,
      <0.293246, 7.147999, 0.798678>, <0.113457, 7.144981, 0.798678>, <-0.950626, 5.192697, 0.077368>, <-0.338272, 6.145586, 0.565650>,
      <0.277646, 6.995919, 1.032281>, <0.250605, 6.995919, 1.032281>, <-1.378208, 7.555165, 1.105431>, <-1.378208, 7.555183, 1.105684>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound13
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.926769, 5.07338, 1.41653>
      translate  <0.288547, 2.770868, -0.106075>
    }
  }
  no_shadow
}
union { // Dolphin3
  disc { // Disc4
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Mouth
    }
    no_shadow
    scale <0.3, 0.5, 1.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.34, -1.65, -0.505>
  }
  object { CSG7 }
  object { Fin7 }
  sphere { // Eyeball7
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate 30.0*z
    translate  <0.772316, -0.751552, 0.0>
  }
  sphere { // Eyeball8
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate -30.0*z
    translate  <-0.122316, -0.765395, 0.0>
  }
  object { Fin8 }
  object { Main_Fin3 }
  object { Body4 }
  scale 0.5
  rotate <-10.0, -75.0, 80.0>
  translate  <5.0, 7.0, -2.0>
}


#declare HgtFld3 = object {
  height_field {
    gif "C:\graphics\PovRAY\scenes\PovWin3\teeth.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    TeethTexture
  }
  no_shadow
  scale <0.5, 0.3, 0.075>
  rotate <180.0, 0.0, -90.0>
  translate  <0.34, -1.65, -0.575>
}
#declare CSG4 = union {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.25, 0.075>
    translate  <0.34, -1.4, -0.575>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.5, 0.15>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.34, -1.65, -0.5>
  }
  no_shadow
}
#declare CSG5 = intersection {
  object { HgtFld3 }
  object { CSG4 }
  no_shadow
}
#declare Fin5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, 0.299302, 0.011328>, <-1.662989, 0.801911, 0.022657>, <1.757702, 0.801911, 0.022657>, <1.757702, 0.299302, 0.011328>,
      <-1.000000, 0.031243, 2.000000>, <-1.000000, 0.265792, 2.000000>, <1.000000, 0.032699, 2.000000>, <1.000000, 0.032664, 2.000000>,
      <-2.168124, -0.693179, 3.205520>, <-2.168124, -0.458629, 3.205520>, <-0.104982, -0.458629, 3.836938>, <-0.104982, -0.693179, 3.836938>,
      <0.406362, -1.616020, 5.750199>, <0.406362, -1.615985, 5.750199>, <1.000000, -1.615985, 5.903382>, <1.000000, -1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, 0.299302, 0.011328>, <1.757702, -0.203307, 0.000000>, <-1.662989, -0.203307, 0.000000>, <-1.662989, 0.299302, 0.011328>,
      <1.000000, 0.032664, 2.000000>, <1.000000, 0.032630, 2.000000>, <-1.000000, -0.203307, 2.000000>, <-1.000000, 0.031243, 2.000000>,
      <-0.104982, -0.693179, 3.836938>, <-0.104982, -0.927728, 3.836938>, <-2.168124, -0.927728, 3.205520>, <-2.168124, -0.693179, 3.205520>,
      <1.000000, -1.616020, 5.903382>, <1.000000, -1.616054, 5.903382>, <0.406362, -1.616054, 5.750199>, <0.406362, -1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound7
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, -0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <90.0, 0.0, 90.0>
  translate  <0.6, 0.3, -0.7>
}
#declare Fin6 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, -0.299302, 0.011328>, <-1.662989, -0.801911, 0.022657>, <1.757702, -0.801911, 0.022657>, <1.757702, -0.299302, 0.011328>,
      <-1.000000, -0.031243, 2.000000>, <-1.000000, -0.265792, 2.000000>, <1.000000, -0.032699, 2.000000>, <1.000000, -0.032664, 2.000000>,
      <-2.168124, 0.693179, 3.205520>, <-2.168124, 0.458629, 3.205520>, <-0.104982, 0.458629, 3.836938>, <-0.104982, 0.693179, 3.836938>,
      <0.406362, 1.616020, 5.750199>, <0.406362, 1.615985, 5.750199>, <1.000000, 1.615985, 5.903382>, <1.000000, 1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, -0.299302, 0.011328>, <1.757702, 0.203307, 0.000000>, <-1.662989, 0.203307, 0.000000>, <-1.662989, -0.299302, 0.011328>,
      <1.000000, -0.032664, 2.000000>, <1.000000, -0.032630, 2.000000>, <-1.000000, 0.203307, 2.000000>, <-1.000000, -0.031243, 2.000000>,
      <-0.104982, 0.693179, 3.836938>, <-0.104982, 0.927728, 3.836938>, <-2.168124, 0.927728, 3.205520>, <-2.168124, 0.693179, 3.205520>,
      <1.000000, 1.616020, 5.903382>, <1.000000, 1.616054, 5.903382>, <0.406362, 1.616054, 5.750199>, <0.406362, 1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound3
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, 0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.3, -0.7>
}
#declare Main_Fin2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.203307, -0.414108, 0.000000>, <-0.203307, -2.242323, 0.000000>, <0.140821, -2.242323, 0.000000>, <0.140821, -0.414108, 0.000000>,
      <-0.203307, -0.234661, 2.069018>, <-0.203307, -1.027607, 2.414108>, <0.140821, -1.027607, 2.414108>, <0.140821, -0.234661, 2.069018>,
      <-0.185583, 0.879966, 3.521728>, <-0.185583, 0.086802, 3.396359>, <0.158544, 0.086802, 3.396359>, <0.183186, 0.879966, 3.521728>,
      <-0.022838, 1.620578, 3.575788>, <-0.022838, 1.621293, 3.575026>, <-0.022828, 1.621293, 3.575026>, <-0.022828, 1.620578, 3.575788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.140821, -0.414108, 0.000000>, <0.140821, 1.414108, 0.000000>, <-0.203307, 1.414108, 0.000000>, <-0.203307, -0.414108, 0.000000>,
      <0.140821, -0.234661, 2.069018>, <0.140821, 0.558285, 1.723928>, <-0.203307, 0.558285, 1.723928>, <-0.203307, -0.234661, 2.069018>,
      <0.183186, 0.879966, 3.521728>, <0.207827, 1.673130, 3.647098>, <-0.185583, 1.673130, 3.647098>, <-0.185583, 0.879966, 3.521728>,
      <-0.022828, 1.620578, 3.575788>, <-0.022828, 1.619863, 3.576549>, <-0.022838, 1.619863, 3.576549>, <-0.022838, 1.620578, 3.575788>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound8
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.219972, 1.662025, 1.854809>
      translate  <-0.031243, -0.171151, 1.806901>
    }
  }
  no_shadow
  scale <0.5, 0.5, 0.375>
  translate  <0.3, 1.101036, 0.6>
}
#declare Body3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.023747, -1.180468, -0.470738>, <-0.023747, -1.180836, -0.477953>, <-0.028414, -1.174768, -0.474769>, <0.335151, -1.181475, -0.472643>,
      <-0.197457, -1.668304, -0.581803>, <-0.107480, -3.244363, -0.681593>, <0.118307, -3.396770, -0.472394>, <0.299517, -3.396770, -0.472394>,
      <0.192247, -1.321241, -0.480613>, <0.192247, -1.309056, -0.465774>, <0.246668, -1.357761, -0.649736>, <0.321497, -1.357761, -0.649736>,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.335151, -1.181475, -0.472643>, <0.698715, -1.188182, -0.470518>, <0.723848, -1.188563, -0.469092>, <0.723848, -1.188728, -0.472322>,
      <0.299517, -3.396770, -0.472394>, <0.480727, -3.396770, -0.472394>, <0.794872, -3.244363, -0.681593>, <0.871563, -1.668304, -0.581803>,
      <0.321497, -1.357761, -0.649736>, <0.396326, -1.357761, -0.649736>, <0.464352, -1.309056, -0.465774>, <0.464352, -1.321241, -0.480613>,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.723848, -1.188728, -0.472322>, <0.723848, -1.188892, -0.475552>, <0.706197, -1.188545, -0.472167>, <0.330536, -1.181250, -0.471626>,
      <0.871563, -1.668304, -0.581803>, <0.948254, -0.092245, -0.482013>, <1.041198, -3.407551, -1.035376>, <0.294076, -3.415045, -1.066969>,
      <0.464352, -1.321241, -0.480613>, <0.464352, -1.333425, -0.495452>, <0.396326, -1.221629, -0.873738>, <0.321497, -1.221629, -0.873738>,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.330536, -1.181250, -0.471626>, <-0.045124, -1.173955, -0.471084>, <-0.023747, -1.180100, -0.463524>, <-0.023747, -1.180468, -0.470738>,
      <0.294076, -3.415045, -1.066969>, <-0.453046, -3.422540, -1.098563>, <-0.287435, -0.092245, -0.482013>, <-0.197457, -1.668304, -0.581803>,
      <0.321497, -1.221629, -0.873738>, <0.246668, -1.221629, -0.873738>, <0.192247, -1.333425, -0.495452>, <0.192247, -1.321241, -0.480613>,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>,
      <-0.881936, -0.446649, -0.130056>, <-0.881936, -0.438055, 0.804813>, <-0.346199, -0.431805, 1.291932>, <0.249966, -0.431805, 1.291932>,
      <-0.697936, 2.838230, -0.077669>, <-0.697936, 2.846824, 0.504750>, <-0.297936, 2.853074, 0.904701>, <0.252064, 2.853074, 0.904701>,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>,
      <0.249966, -0.431805, 1.291932>, <0.846130, -0.431805, 1.291932>, <1.507289, -0.438055, 0.804813>, <1.507289, -0.446649, -0.130056>,
      <0.252064, 2.853074, 0.904701>, <0.802064, 2.853074, 0.904701>, <1.302064, 2.846824, 0.504750>, <1.302064, 2.838230, -0.077669>,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>,
      <1.507289, -0.446649, -0.130056>, <1.507289, -0.455242, -1.064924>, <0.846130, 0.557907, -1.436813>, <0.249966, 0.557907, -1.436813>,
      <1.302064, 2.838230, -0.077669>, <1.302064, 2.829637, -0.660088>, <0.802064, 2.821824, -1.160027>, <0.252064, 2.821824, -1.160027>,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>,
      <0.249966, 0.557907, -1.436813>, <-0.346199, 0.557907, -1.436813>, <-0.881936, -0.455242, -1.064924>, <-0.881936, -0.446649, -0.130056>,
      <0.252064, 2.821824, -1.160027>, <-0.297936, 2.821824, -1.160027>, <-0.697936, 2.829637, -0.660088>, <-0.697936, 2.838230, -0.077669>,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>,
      <0.230161, 6.063951, 0.094498>, <0.230161, 6.064703, 0.173160>, <0.285405, 6.067249, 0.230368>, <0.286460, 6.067426, 0.230368>,
      <-0.338272, 6.145586, 0.565650>, <0.274083, 7.098475, 1.053933>, <-0.068203, 7.865803, 1.941383>, <0.312276, 7.862923, 1.941383>,
      <-1.378208, 7.555183, 1.105684>, <-1.378208, 7.555202, 1.105936>, <0.250605, 6.998767, 1.024354>, <0.277646, 6.998767, 1.024354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>,
      <0.286460, 6.067426, 0.230368>, <0.287515, 6.067603, 0.230368>, <0.369565, 6.067056, 0.173160>, <0.369565, 6.066304, 0.094498>,
      <0.312276, 7.862923, 1.941383>, <0.692755, 7.860042, 1.941383>, <0.283162, 7.100495, 1.053277>, <0.792479, 6.173308, 0.565453>,
      <0.277646, 6.998767, 1.024354>, <0.304686, 6.998767, 1.024354>, <1.972202, 7.476926, 1.109407>, <1.972202, 7.476875, 1.108701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>,
      <0.369565, 6.066304, 0.094498>, <0.369565, 6.065552, 0.015837>, <0.287515, 6.064869, -0.055673>, <0.286460, 6.064692, -0.055673>,
      <0.792479, 6.173308, 0.565453>, <1.301797, 5.246120, 0.077629>, <0.473034, 7.151016, 0.798678>, <0.293246, 7.147999, 0.798678>,
      <1.972202, 7.476875, 1.108701>, <1.972202, 7.476824, 1.107995>, <0.304686, 6.995919, 1.032281>, <0.277646, 6.995919, 1.032281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>,
      <0.286460, 6.064692, -0.055673>, <0.285405, 6.064515, -0.055673>, <0.230161, 6.063199, 0.015837>, <0.230161, 6.063951, 0.094498>,
      <0.293246, 7.147999, 0.798678>, <0.113457, 7.144981, 0.798678>, <-0.950626, 5.192697, 0.077368>, <-0.338272, 6.145586, 0.565650>,
      <0.277646, 6.995919, 1.032281>, <0.250605, 6.995919, 1.032281>, <-1.378208, 7.555165, 1.105431>, <-1.378208, 7.555183, 1.105684>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound9
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.926769, 5.07338, 1.41653>
      translate  <0.288547, 2.770868, -0.106075>
    }
  }
  no_shadow
}
union { // Dolphin2
  disc { // Disc3
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Mouth
    }
    no_shadow
    scale <0.3, 0.5, 1.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.34, -1.65, -0.505>
  }
  object { CSG5 }
  object { Fin5 }
  sphere { // Eyeball5
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate 25.0*z
    translate  <0.772316, -0.745, 0.0>
  }
  sphere { // Eyeball6
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate -30.0*z
    translate  <-0.122316, -0.765395, 0.0>
  }
  object { Fin6 }
  object { Main_Fin2 }
  object { Body3 }
  scale 0.8
  rotate <-10.0, 0.0, -20.0>
  translate  <6.5, 4.0, -1.5>
}


#declare HgtFld2 = object {
  height_field {
    gif "C:\graphics\PovRAY\scenes\PovWin3\teeth.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    TeethTexture
  }
  no_shadow
  scale <0.5, 0.3, 0.075>
  rotate <180.0, 0.0, -90.0>
  translate  <0.34, -1.65, -0.575>
}
#declare CSG3 = union {
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.25, 0.075>
    translate  <0.34, -1.4, -0.575>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.5, 0.15>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.34, -1.65, -0.5>
  }
  no_shadow
}
#declare CSG2 = intersection {
  object { HgtFld2 }
  object { CSG3 }
  no_shadow
}
#declare Fin3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, 0.299302, 0.011328>, <-1.662989, 0.801911, 0.022657>, <1.757702, 0.801911, 0.022657>, <1.757702, 0.299302, 0.011328>,
      <-1.000000, 0.031243, 2.000000>, <-1.000000, 0.265792, 2.000000>, <1.000000, 0.032699, 2.000000>, <1.000000, 0.032664, 2.000000>,
      <-2.168124, -0.693179, 3.205520>, <-2.168124, -0.458629, 3.205520>, <-0.104982, -0.458629, 3.836938>, <-0.104982, -0.693179, 3.836938>,
      <0.406362, -1.616020, 5.750199>, <0.406362, -1.615985, 5.750199>, <1.000000, -1.615985, 5.903382>, <1.000000, -1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, 0.299302, 0.011328>, <1.757702, -0.203307, 0.000000>, <-1.662989, -0.203307, 0.000000>, <-1.662989, 0.299302, 0.011328>,
      <1.000000, 0.032664, 2.000000>, <1.000000, 0.032630, 2.000000>, <-1.000000, -0.203307, 2.000000>, <-1.000000, 0.031243, 2.000000>,
      <-0.104982, -0.693179, 3.836938>, <-0.104982, -0.927728, 3.836938>, <-2.168124, -0.927728, 3.205520>, <-2.168124, -0.693179, 3.205520>,
      <1.000000, -1.616020, 5.903382>, <1.000000, -1.616054, 5.903382>, <0.406362, -1.616054, 5.750199>, <0.406362, -1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound4
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, -0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <90.0, 0.0, 90.0>
  translate  <0.6, 0.3, -0.7>
}
#declare Fin4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, -0.299302, 0.011328>, <-1.662989, -0.801911, 0.022657>, <1.757702, -0.801911, 0.022657>, <1.757702, -0.299302, 0.011328>,
      <-1.000000, -0.031243, 2.000000>, <-1.000000, -0.265792, 2.000000>, <1.000000, -0.032699, 2.000000>, <1.000000, -0.032664, 2.000000>,
      <-2.168124, 0.693179, 3.205520>, <-2.168124, 0.458629, 3.205520>, <-0.104982, 0.458629, 3.836938>, <-0.104982, 0.693179, 3.836938>,
      <0.406362, 1.616020, 5.750199>, <0.406362, 1.615985, 5.750199>, <1.000000, 1.615985, 5.903382>, <1.000000, 1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, -0.299302, 0.011328>, <1.757702, 0.203307, 0.000000>, <-1.662989, 0.203307, 0.000000>, <-1.662989, -0.299302, 0.011328>,
      <1.000000, -0.032664, 2.000000>, <1.000000, -0.032630, 2.000000>, <-1.000000, 0.203307, 2.000000>, <-1.000000, -0.031243, 2.000000>,
      <-0.104982, 0.693179, 3.836938>, <-0.104982, 0.927728, 3.836938>, <-2.168124, 0.927728, 3.205520>, <-2.168124, 0.693179, 3.205520>,
      <1.000000, 1.616020, 5.903382>, <1.000000, 1.616054, 5.903382>, <0.406362, 1.616054, 5.750199>, <0.406362, 1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound2
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, 0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.3, -0.7>
}
#declare Main_Fin1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.203307, -0.414108, 0.000000>, <-0.203307, -2.242323, 0.000000>, <0.140821, -2.242323, 0.000000>, <0.140821, -0.414108, 0.000000>,
      <-0.203307, -0.234661, 2.069018>, <-0.203307, -1.027607, 2.414108>, <0.140821, -1.027607, 2.414108>, <0.140821, -0.234661, 2.069018>,
      <-0.185583, 0.879966, 3.521728>, <-0.185583, 0.086802, 3.396359>, <0.158544, 0.086802, 3.396359>, <0.183186, 0.879966, 3.521728>,
      <-0.022838, 1.620578, 3.575788>, <-0.022838, 1.621293, 3.575026>, <-0.022828, 1.621293, 3.575026>, <-0.022828, 1.620578, 3.575788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.140821, -0.414108, 0.000000>, <0.140821, 1.414108, 0.000000>, <-0.203307, 1.414108, 0.000000>, <-0.203307, -0.414108, 0.000000>,
      <0.140821, -0.234661, 2.069018>, <0.140821, 0.558285, 1.723928>, <-0.203307, 0.558285, 1.723928>, <-0.203307, -0.234661, 2.069018>,
      <0.183186, 0.879966, 3.521728>, <0.207827, 1.673130, 3.647098>, <-0.185583, 1.673130, 3.647098>, <-0.185583, 0.879966, 3.521728>,
      <-0.022828, 1.620578, 3.575788>, <-0.022828, 1.619863, 3.576549>, <-0.022838, 1.619863, 3.576549>, <-0.022838, 1.620578, 3.575788>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound5
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.219972, 1.662025, 1.854809>
      translate  <-0.031243, -0.171151, 1.806901>
    }
  }
  no_shadow
  scale <0.5, 0.5, 0.375>
  translate  <0.3, 1.101036, 0.6>
}
#declare Body2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.023747, -1.180468, -0.470738>, <-0.023747, -1.180836, -0.477953>, <-0.028414, -1.174768, -0.474769>, <0.335151, -1.181475, -0.472643>,
      <-0.197457, -1.668304, -0.581803>, <-0.107480, -3.244363, -0.681593>, <0.118307, -3.396770, -0.472394>, <0.299517, -3.396770, -0.472394>,
      <0.192247, -1.321241, -0.480613>, <0.192247, -1.309056, -0.465774>, <0.246668, -1.357761, -0.649736>, <0.321497, -1.357761, -0.649736>,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.335151, -1.181475, -0.472643>, <0.698715, -1.188182, -0.470518>, <0.723848, -1.188563, -0.469092>, <0.723848, -1.188728, -0.472322>,
      <0.299517, -3.396770, -0.472394>, <0.480727, -3.396770, -0.472394>, <0.794872, -3.244363, -0.681593>, <0.871563, -1.668304, -0.581803>,
      <0.321497, -1.357761, -0.649736>, <0.396326, -1.357761, -0.649736>, <0.464352, -1.309056, -0.465774>, <0.464352, -1.321241, -0.480613>,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.723848, -1.188728, -0.472322>, <0.723848, -1.188892, -0.475552>, <0.706197, -1.188545, -0.472167>, <0.330536, -1.181250, -0.471626>,
      <0.871563, -1.668304, -0.581803>, <0.948254, -0.092245, -0.482013>, <1.041198, -3.407551, -1.035376>, <0.294076, -3.415045, -1.066969>,
      <0.464352, -1.321241, -0.480613>, <0.464352, -1.333425, -0.495452>, <0.396326, -1.221629, -0.873738>, <0.321497, -1.221629, -0.873738>,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.330536, -1.181250, -0.471626>, <-0.045124, -1.173955, -0.471084>, <-0.023747, -1.180100, -0.463524>, <-0.023747, -1.180468, -0.470738>,
      <0.294076, -3.415045, -1.066969>, <-0.453046, -3.422540, -1.098563>, <-0.287435, -0.092245, -0.482013>, <-0.197457, -1.668304, -0.581803>,
      <0.321497, -1.221629, -0.873738>, <0.246668, -1.221629, -0.873738>, <0.192247, -1.333425, -0.495452>, <0.192247, -1.321241, -0.480613>,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>,
      <-0.881936, -0.446649, -0.130056>, <-0.881936, -0.438055, 0.804813>, <-0.346199, -0.431805, 1.291932>, <0.249966, -0.431805, 1.291932>,
      <-0.697936, 2.838230, -0.077669>, <-0.697936, 2.846824, 0.504750>, <-0.297936, 2.853074, 0.904701>, <0.252064, 2.853074, 0.904701>,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>,
      <0.249966, -0.431805, 1.291932>, <0.846130, -0.431805, 1.291932>, <1.507289, -0.438055, 0.804813>, <1.507289, -0.446649, -0.130056>,
      <0.252064, 2.853074, 0.904701>, <0.802064, 2.853074, 0.904701>, <1.302064, 2.846824, 0.504750>, <1.302064, 2.838230, -0.077669>,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>,
      <1.507289, -0.446649, -0.130056>, <1.507289, -0.455242, -1.064924>, <0.846130, 0.557907, -1.436813>, <0.249966, 0.557907, -1.436813>,
      <1.302064, 2.838230, -0.077669>, <1.302064, 2.829637, -0.660088>, <0.802064, 2.821824, -1.160027>, <0.252064, 2.821824, -1.160027>,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>,
      <0.249966, 0.557907, -1.436813>, <-0.346199, 0.557907, -1.436813>, <-0.881936, -0.455242, -1.064924>, <-0.881936, -0.446649, -0.130056>,
      <0.252064, 2.821824, -1.160027>, <-0.297936, 2.821824, -1.160027>, <-0.697936, 2.829637, -0.660088>, <-0.697936, 2.838230, -0.077669>,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>,
      <0.230161, 6.063951, 0.094498>, <0.230161, 6.064703, 0.173160>, <0.285405, 6.067249, 0.230368>, <0.286460, 6.067426, 0.230368>,
      <-0.338272, 6.145586, 0.565650>, <0.274083, 7.098475, 1.053933>, <-0.068203, 7.865803, 1.941383>, <0.312276, 7.862923, 1.941383>,
      <-1.378208, 7.555183, 1.105684>, <-1.378208, 7.555202, 1.105936>, <0.250605, 6.998767, 1.024354>, <0.277646, 6.998767, 1.024354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>,
      <0.286460, 6.067426, 0.230368>, <0.287515, 6.067603, 0.230368>, <0.369565, 6.067056, 0.173160>, <0.369565, 6.066304, 0.094498>,
      <0.312276, 7.862923, 1.941383>, <0.692755, 7.860042, 1.941383>, <0.283162, 7.100495, 1.053277>, <0.792479, 6.173308, 0.565453>,
      <0.277646, 6.998767, 1.024354>, <0.304686, 6.998767, 1.024354>, <1.972202, 7.476926, 1.109407>, <1.972202, 7.476875, 1.108701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>,
      <0.369565, 6.066304, 0.094498>, <0.369565, 6.065552, 0.015837>, <0.287515, 6.064869, -0.055673>, <0.286460, 6.064692, -0.055673>,
      <0.792479, 6.173308, 0.565453>, <1.301797, 5.246120, 0.077629>, <0.473034, 7.151016, 0.798678>, <0.293246, 7.147999, 0.798678>,
      <1.972202, 7.476875, 1.108701>, <1.972202, 7.476824, 1.107995>, <0.304686, 6.995919, 1.032281>, <0.277646, 6.995919, 1.032281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>,
      <0.286460, 6.064692, -0.055673>, <0.285405, 6.064515, -0.055673>, <0.230161, 6.063199, 0.015837>, <0.230161, 6.063951, 0.094498>,
      <0.293246, 7.147999, 0.798678>, <0.113457, 7.144981, 0.798678>, <-0.950626, 5.192697, 0.077368>, <-0.338272, 6.145586, 0.565650>,
      <0.277646, 6.995919, 1.032281>, <0.250605, 6.995919, 1.032281>, <-1.378208, 7.555165, 1.105431>, <-1.378208, 7.555183, 1.105684>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound6
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.926769, 5.07338, 1.41653>
      translate  <0.288547, 2.770868, -0.106075>
    }
  }
  no_shadow
}
union { // Dolphin1
  disc { // Disc2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Mouth
    }
    no_shadow
    scale <0.3, 0.5, 1.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.34, -1.65, -0.505>
  }
  object { CSG2 }
  object { Fin3 }
  sphere { // Eyeball3
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate 30.0*z
    translate  <0.772316, -0.751552, 0.0>
  }
  sphere { // Eyeball4
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate -30.0*z
    translate  <-0.122316, -0.765395, 0.0>
  }
  object { Fin4 }
  object { Main_Fin1 }
  object { Body2 }
  scale 0.5
  rotate <60.0, 0.0, -60.0>
  translate  <0.5, 10.0, -1.5>
}


#declare HgtFld001 = object {
  height_field {
    gif "C:\graphics\PovRAY\scenes\PovWin3\teeth.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    TeethTexture
  }
  no_shadow
  scale <0.5, 0.3, 0.075>
  rotate <180.0, 0.0, -90.0>
  translate  <0.34, -1.65, -0.575>
}
#declare CSG002 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.25, 0.075>
    translate  <0.34, -1.4, -0.575>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      Transparent
    }
    no_shadow
    scale <0.3, 0.5, 0.15>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.34, -1.65, -0.5>
  }
  no_shadow
}
#declare CSG001 = intersection {
  object { HgtFld001 }
  object { CSG002 }
  no_shadow
}
#declare Fin2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, 0.299302, 0.011328>, <-1.662989, 0.801911, 0.022657>, <1.757702, 0.801911, 0.022657>, <1.757702, 0.299302, 0.011328>,
      <-1.000000, 0.031243, 2.000000>, <-1.000000, 0.265792, 2.000000>, <1.000000, 0.032699, 2.000000>, <1.000000, 0.032664, 2.000000>,
      <-2.168124, -0.693179, 3.205520>, <-2.168124, -0.458629, 3.205520>, <-0.104982, -0.458629, 3.836938>, <-0.104982, -0.693179, 3.836938>,
      <0.406362, -1.616020, 5.750199>, <0.406362, -1.615985, 5.750199>, <1.000000, -1.615985, 5.903382>, <1.000000, -1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, 0.299302, 0.011328>, <1.757702, -0.203307, 0.000000>, <-1.662989, -0.203307, 0.000000>, <-1.662989, 0.299302, 0.011328>,
      <1.000000, 0.032664, 2.000000>, <1.000000, 0.032630, 2.000000>, <-1.000000, -0.203307, 2.000000>, <-1.000000, 0.031243, 2.000000>,
      <-0.104982, -0.693179, 3.836938>, <-0.104982, -0.927728, 3.836938>, <-2.168124, -0.927728, 3.205520>, <-2.168124, -0.693179, 3.205520>,
      <1.000000, -1.616020, 5.903382>, <1.000000, -1.616054, 5.903382>, <0.406362, -1.616054, 5.750199>, <0.406362, -1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, -0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <90.0, 0.0, 90.0>
  translate  <0.6, 0.3, -0.7>
}
#declare Fin1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662989, -0.299302, 0.011328>, <-1.662989, -0.801911, 0.022657>, <1.757702, -0.801911, 0.022657>, <1.757702, -0.299302, 0.011328>,
      <-1.000000, -0.031243, 2.000000>, <-1.000000, -0.265792, 2.000000>, <1.000000, -0.032699, 2.000000>, <1.000000, -0.032664, 2.000000>,
      <-2.168124, 0.693179, 3.205520>, <-2.168124, 0.458629, 3.205520>, <-0.104982, 0.458629, 3.836938>, <-0.104982, 0.693179, 3.836938>,
      <0.406362, 1.616020, 5.750199>, <0.406362, 1.615985, 5.750199>, <1.000000, 1.615985, 5.903382>, <1.000000, 1.616020, 5.903382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.757702, -0.299302, 0.011328>, <1.757702, 0.203307, 0.000000>, <-1.662989, 0.203307, 0.000000>, <-1.662989, -0.299302, 0.011328>,
      <1.000000, -0.032664, 2.000000>, <1.000000, -0.032630, 2.000000>, <-1.000000, 0.203307, 2.000000>, <-1.000000, -0.031243, 2.000000>,
      <-0.104982, 0.693179, 3.836938>, <-0.104982, 0.927728, 3.836938>, <-2.168124, 0.927728, 3.205520>, <-2.168124, 0.693179, 3.205520>,
      <1.000000, 1.616020, 5.903382>, <1.000000, 1.616054, 5.903382>, <0.406362, 1.616054, 5.750199>, <0.406362, 1.616020, 5.750199>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.787769, 1.223575, 3.027699>
      translate  <0.047356, 0.469893, 2.953107>
    }
  }
  no_shadow
  scale <0.35, 0.45, 0.3>
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.3, -0.7>
}
#declare Main_Fin = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.203307, -0.414108, 0.000000>, <-0.203307, -2.242323, 0.000000>, <0.140821, -2.242323, 0.000000>, <0.140821, -0.414108, 0.000000>,
      <-0.203307, -0.234661, 2.069018>, <-0.203307, -1.027607, 2.414108>, <0.140821, -1.027607, 2.414108>, <0.140821, -0.234661, 2.069018>,
      <-0.185583, 0.879966, 3.521728>, <-0.185583, 0.086802, 3.396359>, <0.158544, 0.086802, 3.396359>, <0.183186, 0.879966, 3.521728>,
      <-0.022838, 1.620578, 3.575788>, <-0.022838, 1.621293, 3.575026>, <-0.022828, 1.621293, 3.575026>, <-0.022828, 1.620578, 3.575788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.140821, -0.414108, 0.000000>, <0.140821, 1.414108, 0.000000>, <-0.203307, 1.414108, 0.000000>, <-0.203307, -0.414108, 0.000000>,
      <0.140821, -0.234661, 2.069018>, <0.140821, 0.558285, 1.723928>, <-0.203307, 0.558285, 1.723928>, <-0.203307, -0.234661, 2.069018>,
      <0.183186, 0.879966, 3.521728>, <0.207827, 1.673130, 3.647098>, <-0.185583, 1.673130, 3.647098>, <-0.185583, 0.879966, 3.521728>,
      <-0.022828, 1.620578, 3.575788>, <-0.022828, 1.619863, 3.576549>, <-0.022838, 1.619863, 3.576549>, <-0.022838, 1.620578, 3.575788>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound00004
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.219972, 1.662025, 1.854809>
      translate  <-0.031243, -0.171151, 1.806901>
    }
  }
  no_shadow
  scale <0.5, 0.5, 0.375>
  translate  <0.3, 1.101036, 0.6>
}
#declare Body1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.023747, -1.180468, -0.470738>, <-0.023747, -1.180836, -0.477953>, <-0.028414, -1.174768, -0.474769>, <0.335151, -1.181475, -0.472643>,
      <-0.197457, -1.668304, -0.581803>, <-0.107480, -3.244363, -0.681593>, <0.118307, -3.396770, -0.472394>, <0.299517, -3.396770, -0.472394>,
      <0.192247, -1.321241, -0.480613>, <0.192247, -1.309056, -0.465774>, <0.246668, -1.357761, -0.649736>, <0.321497, -1.357761, -0.649736>,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.335151, -1.181475, -0.472643>, <0.698715, -1.188182, -0.470518>, <0.723848, -1.188563, -0.469092>, <0.723848, -1.188728, -0.472322>,
      <0.299517, -3.396770, -0.472394>, <0.480727, -3.396770, -0.472394>, <0.794872, -3.244363, -0.681593>, <0.871563, -1.668304, -0.581803>,
      <0.321497, -1.357761, -0.649736>, <0.396326, -1.357761, -0.649736>, <0.464352, -1.309056, -0.465774>, <0.464352, -1.321241, -0.480613>,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.723848, -1.188728, -0.472322>, <0.723848, -1.188892, -0.475552>, <0.706197, -1.188545, -0.472167>, <0.330536, -1.181250, -0.471626>,
      <0.871563, -1.668304, -0.581803>, <0.948254, -0.092245, -0.482013>, <1.041198, -3.407551, -1.035376>, <0.294076, -3.415045, -1.066969>,
      <0.464352, -1.321241, -0.480613>, <0.464352, -1.333425, -0.495452>, <0.396326, -1.221629, -0.873738>, <0.321497, -1.221629, -0.873738>,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.330536, -1.181250, -0.471626>, <-0.045124, -1.173955, -0.471084>, <-0.023747, -1.180100, -0.463524>, <-0.023747, -1.180468, -0.470738>,
      <0.294076, -3.415045, -1.066969>, <-0.453046, -3.422540, -1.098563>, <-0.287435, -0.092245, -0.482013>, <-0.197457, -1.668304, -0.581803>,
      <0.321497, -1.221629, -0.873738>, <0.246668, -1.221629, -0.873738>, <0.192247, -1.333425, -0.495452>, <0.192247, -1.321241, -0.480613>,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.344845, -0.883945, -0.305334>, <-0.344845, -0.873556, 0.169520>, <-0.049766, -0.894783, 0.321098>, <0.285731, -0.894783, 0.321098>,
      <-0.881936, -0.446649, -0.130056>, <-0.881936, -0.438055, 0.804813>, <-0.346199, -0.431805, 1.291932>, <0.249966, -0.431805, 1.291932>,
      <-0.697936, 2.838230, -0.077669>, <-0.697936, 2.846824, 0.504750>, <-0.297936, 2.853074, 0.904701>, <0.252064, 2.853074, 0.904701>,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.894783, 0.321098>, <0.621228, -0.894783, 0.321098>, <0.985820, -0.873556, 0.169520>, <0.985820, -0.883945, -0.305334>,
      <0.249966, -0.431805, 1.291932>, <0.846130, -0.431805, 1.291932>, <1.507289, -0.438055, 0.804813>, <1.507289, -0.446649, -0.130056>,
      <0.252064, 2.853074, 0.904701>, <0.802064, 2.853074, 0.904701>, <1.302064, 2.846824, 0.504750>, <1.302064, 2.838230, -0.077669>,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.985820, -0.883945, -0.305334>, <0.985820, -0.894334, -0.780188>, <0.621228, -0.331861, -1.155276>, <0.285731, -0.331861, -1.155276>,
      <1.507289, -0.446649, -0.130056>, <1.507289, -0.455242, -1.064924>, <0.846130, 0.557907, -1.436813>, <0.249966, 0.557907, -1.436813>,
      <1.302064, 2.838230, -0.077669>, <1.302064, 2.829637, -0.660088>, <0.802064, 2.821824, -1.160027>, <0.252064, 2.821824, -1.160027>,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.285731, -0.331861, -1.155276>, <-0.049766, -0.331861, -1.155276>, <-0.344845, -0.894334, -0.780188>, <-0.344845, -0.883945, -0.305334>,
      <0.249966, 0.557907, -1.436813>, <-0.346199, 0.557907, -1.436813>, <-0.881936, -0.455242, -1.064924>, <-0.881936, -0.446649, -0.130056>,
      <0.252064, 2.821824, -1.160027>, <-0.297936, 2.821824, -1.160027>, <-0.697936, 2.829637, -0.660088>, <-0.697936, 2.838230, -0.077669>,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.233887, 4.451091, 0.008415>, <-0.233887, 4.455763, 0.338955>, <-0.006266, 4.460162, 0.567535>, <0.269262, 4.460250, 0.567535>,
      <0.230161, 6.063951, 0.094498>, <0.230161, 6.064703, 0.173160>, <0.285405, 6.067249, 0.230368>, <0.286460, 6.067426, 0.230368>,
      <-0.338272, 6.145586, 0.565650>, <0.274083, 7.098475, 1.053933>, <-0.068203, 7.865803, 1.941383>, <0.312276, 7.862923, 1.941383>,
      <-1.378208, 7.555183, 1.105684>, <-1.378208, 7.555202, 1.105936>, <0.250605, 6.998767, 1.024354>, <0.277646, 6.998767, 1.024354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.460250, 0.567535>, <0.544790, 4.460339, 0.567535>, <0.835814, 4.456940, 0.338955>, <0.835814, 4.452267, 0.008415>,
      <0.286460, 6.067426, 0.230368>, <0.287515, 6.067603, 0.230368>, <0.369565, 6.067056, 0.173160>, <0.369565, 6.066304, 0.094498>,
      <0.312276, 7.862923, 1.941383>, <0.692755, 7.860042, 1.941383>, <0.283162, 7.100495, 1.053277>, <0.792479, 6.173308, 0.565453>,
      <0.277646, 6.998767, 1.024354>, <0.304686, 6.998767, 1.024354>, <1.972202, 7.476926, 1.109407>, <1.972202, 7.476875, 1.108701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.835814, 4.452267, 0.008415>, <0.835814, 4.447595, -0.322125>, <0.544790, 4.443347, -0.607850>, <0.269262, 4.443258, -0.607850>,
      <0.369565, 6.066304, 0.094498>, <0.369565, 6.065552, 0.015837>, <0.287515, 6.064869, -0.055673>, <0.286460, 6.064692, -0.055673>,
      <0.792479, 6.173308, 0.565453>, <1.301797, 5.246120, 0.077629>, <0.473034, 7.151016, 0.798678>, <0.293246, 7.147999, 0.798678>,
      <1.972202, 7.476875, 1.108701>, <1.972202, 7.476824, 1.107995>, <0.304686, 6.995919, 1.032281>, <0.277646, 6.995919, 1.032281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.269262, 4.443258, -0.607850>, <-0.006266, 4.443169, -0.607850>, <-0.233887, 4.446418, -0.322125>, <-0.233887, 4.451091, 0.008415>,
      <0.286460, 6.064692, -0.055673>, <0.285405, 6.064515, -0.055673>, <0.230161, 6.063199, 0.015837>, <0.230161, 6.063951, 0.094498>,
      <0.293246, 7.147999, 0.798678>, <0.113457, 7.144981, 0.798678>, <-0.950626, 5.192697, 0.077368>, <-0.338272, 6.145586, 0.565650>,
      <0.277646, 6.995919, 1.032281>, <0.250605, 6.995919, 1.032281>, <-1.378208, 7.555165, 1.105431>, <-1.378208, 7.555183, 1.105684>
    }
  }
  texture {
    Gray_Skin1
  }
  bounded_by { // Bound00005
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.926769, 5.07338, 1.41653>
      translate  <0.288547, 2.770868, -0.106075>
    }
  }
  no_shadow
}
union { // Dolphin
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Mouth
    }
    no_shadow
    scale <0.3, 0.5, 1.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.34, -1.65, -0.505>
  }
  object { CSG001 }
  object { Fin2 }
  sphere { // Eyeball2
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate 17.0*z
    translate  <0.772316, -0.745, 0.0>
  }
  sphere { // Eyeball1
    <0,0,0>,1
    texture {
      Eye
    }
    no_shadow
    scale 0.2
    rotate -30.0*z
    translate  <-0.122316, -0.765395, 0.0>
  }
  object { Fin1 }
  object { Main_Fin }
  object { Body1 }
}


plane { // Water
  z,0
  texture {
    Water_Top
  }
  no_shadow
  hollow
  rotate -180.0*y
  translate  <0.27, 0.85, 1.1>
}






plane { // Plane001
  z,0
  texture {
    Tropics_Cloud_Sky
  }
  rotate -180.0*y
  translate  3.876174*z
}




plane { // Ground
  z,0
  texture {
    SandstP
  }
  translate  <0.264285, 0.0, -3.0>
}


#declare Wing1 = difference {
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WrinkleGray
    }
    no_shadow
    scale <5.0, 1.5, 0.2>
    translate  6.0*x
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WrinkleGray
    }
    no_shadow
    scale <5.5, 1.0, 0.25>
    rotate 7.0*z
    translate  <6.0, -1.6, 0.0>
  }
  texture {
    WrinkleGray
  }
  no_shadow
}
#declare WingWithProp1 = merge {
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    texture {
      WrinkleGray
    }
    no_shadow
    scale <0.75, 0.75, 2.0>
    rotate -90.0*x
    translate  <7.0, -0.5, 0.8>
  }
  object { Wing1 }
  texture {
    WrinkleGray
  }
  no_shadow
  rotate <180.0, 0.0, 180.0>
  translate  5.0*y
}
#declare TailFin = difference {
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.5, 0.2>
    translate  6.0*x
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 1.0, 0.25>
    rotate 7.0*z
    translate  <6.0, -1.6, 0.0>
  }
  no_shadow
  scale <0.3, 0.5, 0.3>
  rotate -90.0*y
  translate  <0.0, 14.0, 0.4>
}
#declare PlaneFin1 = difference {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.5, 0.2>
    translate  6.0*x
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 1.0, 0.25>
    rotate 7.0*z
    translate  <6.0, -1.6, 0.0>
  }
  no_shadow
  scale <0.3, 0.5, 0.3>
  rotate <180.0, 0.0, 180.0>
  translate  <-0.5, 14.0, 0.0>
}
#declare PlaneFin = difference {
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.5, 0.2>
    translate  6.0*x
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 1.0, 0.25>
    rotate 7.0*z
    translate  <6.0, -1.6, 0.0>
  }
  no_shadow
  scale <0.3, 0.5, 0.3>
  translate  <0.5, 14.0, 0.0>
}
#declare Wing = difference {
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.5, 0.2>
    translate  6.0*x
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 1.0, 0.25>
    rotate 7.0*z
    translate  <6.0, -1.6, 0.0>
  }
  no_shadow
}
#declare WingWithProp = merge {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    no_shadow
    scale <0.75, 0.75, 2.0>
    rotate -90.0*x
    translate  <7.0, -0.5, -0.8>
  }
  object { Wing }
  translate  5.0*y
}
merge { // Plane
  sphere { // Sphere001
    <0,0,0>,1
    scale <1.0, 2.5, 1.0>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 15.0>
    rotate -90.0*x
  }
  object { WingWithProp1 }
  object { TailFin }
  object { PlaneFin1 }
  object { PlaneFin }
  object { WingWithProp }
  cone { // Cone001
    <0,0,0>, 0.3, <0,0,1>, 1.0
    no_shadow
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate  17.0*y
  }
  texture {
    WrinkleGray
  }
  no_shadow
  scale 0.1
  rotate 10.0*z
  translate  <1.3, 4.4, 3.7>
}


