
#include "colors.inc"
#include "glass.inc"

global_settings {
//	ambient_light color rgb <0,0,0>
	max_trace_level 6

}


#declare glaspos=<53.5, 278.42, 2064.5>
#declare glaspos=glaspos+<5000,0,0>
#declare campos = glaspos + <0,1.1,-1.8>
#declare campoint=campos+<0,-2500,10000>

// ******************************************Cams

camera { location campos look_at campoint } // Glascam
//camera { location glaspos + <0,.00006,-.00004> look_at campoint }	//Kegelfucam
//camera { location campos+<0,1000,0> look_at campoint } // berblick


//camera {location <-100,200000,100> look_at <0,0,0>}
//camera {location <50000,20000,0> look_at <50000,0,100000>}
//camera { location campos look_at campos+<0,-1,1> } // Texcam


// ****************************************Gummi

#declare Gummi = difference{
	union {
		cylinder {<0,0,0>,<0,0.01,0>,0.54}

		cylinder {<0,0,0.54>,<0,0.01,0.54>,0.1*.54/.575}
		difference {
			cylinder {<0,0,0>,<0,0.01,0>,0.6350726791}
			union{
				plane { +x ,0 rotate y*(-19.91190346)}
				plane { -x ,0 rotate y*(+19.91190346)}
				cylinder { <-0.2724599136,-0.1, 0.7521739130>,<-0.2724599136,0.1, 0.7521739130>,0.225 }
				cylinder { < 0.2724599136,-0.1, 0.7521739130>,< 0.2724599136,0.1, 0.7521739130>,0.225 }
			}
			scale <54/57.5,1,54/57.5>
		}
	}
	cylinder {<0,-.1,0>,<0,0.1,0>,0.475}

	rotate y*120
	translate <0,1.2365,0.01>
	pigment {color rgb <1,.48,.34>}
}

// *****************************************Deckel

#declare Deckel=

	difference{ 																	//Deckel
		merge{
			merge{
				#declare Riffelz=40
				#declare RiffelI=0
				#declare drad=0.52
				#declare Riffelges=10*Riffelz
				#declare Riffel=0
			  #while (RiffelI < Riffelz)

					#declare RiffelI=RiffelI+1
					#declare RiffelII=0

					merge{
						#while (RiffelII<10)
							#declare RiffelII=RiffelII+1
							#declare Riffel=Riffel+1
							cylinder{<drad,0.035,0>,<drad,0.085,0>,pi*drad/2/Riffelges
								rotate y*Riffel/Riffelges*360
							}
						#end
						bounded_by{
							cylinder {<drad,0.035,0>,<drad,0.085,0>,pi*drad/Riffelz
								rotate y*RiffelI+.55/Riffelz*360
							}
						}
					}

				#end

				cylinder {<0,0.03,0>,<0,0.09,0>,drad }
				bounded_by{cylinder {<0,0.03,0>,<0,0.09,0>,drad+pi*drad/2/Riffelges}	}
			}

			difference{
				cone{
					<0,0.09,0>,drad,<0,0.16,0>,0.43
				}
				sor{
					6
					<0,0.15>
					<0,0.15>
					<0.2,0.1502>
					<0.38,0.153>
					<0.43,0.16>
					<1,0.2>
					sturm
					bounded_by{cylinder{<0,0.15,0>,<0,0.16,0>,0.43}}
				}
			}
			sor{
				7
				<0.49,0>
				<0.505,0>
				<0.509,0.01>
				<0.511,0.02>
				<0.514,0.0299>
				<0.52,0.03>
				<0.53,0.03>
 				bounded_by{cylinder{<0,0,0>,<0,0.03,0>,0.52}}
			}

		}
		sor{
			12
			<0.505,0>
			<0.495,0>
			<0.488,0.015>
			<0.484,0.016>
			<0.484,0.017>
			<0.48,0.04>
			<0.47,0.08>
			<0.45,0.1>
			<0.42,0.113>
			<0.38,0.115>
			<0.,0.12>
			<0.,0.12>
		}

//pigment{color rgb <1,1,1>}
//texture {T_Glass2}
	}


// ****************************************Innenglas
#declare Innenglas = sor {
	14
	<0.0, 0.05>
	<0.2, 0.056>
 	<0.386, 0.05607>
 	<0.46683, 0.0671>
	<0.52974, 0.15162>
 	<0.55352, 0.4143>
 	<0.5507, 0.76022>
 	<0.53992, 0.94461>
 	<0.44, 1.10051>
 	<0.43, 1.19>
	<0.43,1.21>
 	<0.431, 1.255>
	<0.445, 1.28>
	<1,1.5>
}

// ***********************************Wasser
#declare Wasser = intersection {
	plane {y,0
		translate <0,.525,0>
		pigment {
    	color rgbft <0.8, 1, 0.9, 1,0>
		}
		finish {
	 		diffuse 0
	 		reflection 0.5
	 		refraction 1
	 		ior 1.9
	 		phong 0.3
		 	phong_size 60
			fade_distance .006
			fade_power 1
			caustics 1
		}
		normal{
			ripples 0.2
	   	frequency 20
			translate <-.5,0,-.5>
			scale 1
		}
	}
	object {
		Innenglas //scale <1,1,1>
			pigment {
    	color rgbft <0.8, 1, 0.9, 1,0>
		}
		normal {
			granite .1
			scale 9
			scallop_wave
			//sine_wave
		}
 		finish {
	 		diffuse 0
	 		reflection 0.2
	 		refraction 1
	 		ior 1.9
	 		phong 0.3
		 	phong_size 60
			fade_distance .006
			fade_power 1
//			caustics 1
		}
	}
	bounded_by {cylinder {<0,.05125,0>,<0,0.7,0>,0.55353}}
}

// *****************************************Glas


#declare Glas=
	union{
	difference{
		sor {
			24
			<0,0>
		  <0.23503, 0.000>
      <0.3935, 0.00248>
			<0.41664, 0.00265>
 		 	<0.43835, 0.00287>
 		  <0.45045, 0.01307>
  		<0.52013, 0.03259>
 			<0.53101, 0.04764>
  		<0.56778, 0.15244>
 			<0.57921, 0.41593>
  		<0.57508, 0.75817>
  		<0.56039, 0.95167>
  		<0.45994, 1.11192>
  		<0.47351, 1.17348>
  		<0.54672, 1.18649>
  	  <0.55919, 1.20208>
  		<0.55899, 1.2271>
	  	<0.5355, 1.23403>
	  	<0.47191, 1.23598>
			<0.47,1.255>
			<0.46,1.26>
			<0.455,1.275>
			<0.445,1.28>
	  	<0.1, 1.4>
		}
		Innenglas
	}
	object{Deckel translate <0,1.25,0>}
	texture {
		pigment { color rgbft<1.0, 1.0, 1.0, 0.42, .42> }
		normal {
			granite .1
			scale 9
			scallop_wave
			//sine_wave
		}
    finish  {
	    ambient 0
	    diffuse .1
	    reflection 0.2
	    refraction 1
	    ior 1.5
	    phong 0.3
 	 	  phong_size 60
			caustics .99
		}
	}
	clipped_by {
		intersection {
			plane {y,0
				translate <0,.525,0>
			}
			object {
				Innenglas
			}
			inverse
		}
		scale <1.01,1,1.01>
	}
}
// *****************************************Erde

#declare Erde = intersection {
	height_field {
		tga
		"earth3.tga"
		smooth
		translate <-.5,0,-.5>
		scale <1.2,.2,1.2>
		translate <0,.5,0>
		rotate y*150
	}
	object { Innenglas scale <.997,1,.997> }
	//pigment {color rgb <.7,.4,.2>}

	texture {
		pigment {
			wrinkles
      scale .0031
			color_map {
        [0.00 color rgb <0.00, 0.00, 0.00> ]
 		    [0.20 color rgb <0.25, 0.05, 0.05> ]
				[0.40 color rgb <0.40, 0.20, 0.15> ]
				[0.99 color rgb <0.70, 0.40, 0.20> ]
        [1.00 color rgb <0.60, 0.35, 0.25> ]
			}
			sine_wave
			/*
      color_map {
        [0.00 color rgb <0.00, 0.00, 0.00> ]
 		    [0.20 color rgb <0.25, 0.05, 0.05> ]
				[0.40 color rgb <0.25, 0.05, 0.05> ]
				[0.99 color rgb <0.30, 0.20, 0.15> ]
        [1.00 color rgb <0.60, 0.35, 0.25> ]
			}*/

			//	color rgb <0.30, 0.20, 0.15>
			/*gradient y
			scale .01
			color_map {
				[0 color rgb <1,1,1>]
				[.8 color rgb <1,1,1>]
				[.8 color rgb <1,0,0>]
				[1 color rgb <1,0,0>]
			}*/
		}
	}
	bounded_by { cylinder { <0,.05,0>,<0,0.7,0>,0.55353}}
}
// ***********************************Sterne******************************

#declare sterneN=50000
#declare sterneI=0
#declare Sr=seed(42412)
#while (sterneI<sterneN)
	#declare sterneI=sterneI+1
	#declare lpos=<50000,0,0>
	#declare lpos=vaxis_rotate(lpos,y,360*rand(Sr))
	#declare lpos=vaxis_rotate(lpos,x,360*rand(Sr))
	#declare lpos=vaxis_rotate(lpos,z,360*rand(Sr))

	#if (lpos.y<0)
		#declare lpos=<lpos.x,-lpos.y,lpos.z>
	#end
//	#if (vdot(campoint-campos,lpos-campos)<0)
//		#declare lpos=2*campos-lpos
//	#end


	sphere{lpos,100*(rand(Sr)*pow(rand(Sr),2)*pow(rand(Sr),2))+20
		#declare rotblau =(rand(Sr)+rand(Sr))/5-.2
		pigment { color rgb<1+rotblau,1,1-rotblau>}
		finish { ambient rgb<1+rotblau,1,1-rotblau>*1 }
		no_shadow
	}
#end


// **************************** P f l a n z e n ************************************
 
// ***********Strandgras***************

#declare Strandgras = union{
		#declare Grasn=400
		#declare Grashvar= .4
		#declare Grasrotvar= 30
	union {
		#include "10gras2.inc"
		scale 	<.15,.3,.15>
		translate <-.01,.523,-.37>
		bounded_by {
			cylinder {
				<-.01,.523,-.37>,<-.01,.673,-.37>,.15
			}
		}
	}
		#declare Grasn=120
		#declare Grashvar= .3
		#declare Grasrotvar= 20
	union {
		#include "10gras2.inc"
		scale <.09,.24,.09>
		translate<.32,.52,-.34>
		bounded_by {
			cylinder {
				<.32,.52,-.34>,<.32,.78,-.34>,.09
			}
		}
	}
		#declare Grasn=120
		#declare Grashvar= .3
		#declare Grasrotvar= 20
	union {//
		#include "10gras2.inc"
		scale <.1,.26,.1>
		translate<.41,.525,.06>
		bounded_by {
			cylinder {
				<.41,.525,.06>,<.41,.655,.06>,.1
			}
		}
	}
	#declare Grasn=300
		#declare Grashvar= .4
		#declare Grasrotvar= 40
	union {
		#include "10gras2.inc"
		scale <.15,.3,.15>
		translate<.2,.525,.05>
		bounded_by {
			cylinder {
				<.2,.525,.05>,<.2,.675,.05>,.15
			}
		}
	}
		#declare Grasn=180
		#declare Grashvar= .4
		#declare Grasrotvar= 40
	union {
		#include "10gras2.inc"
		scale <.1,.25,.1>
		translate<.19,.525,-.10>
		bounded_by {
			cylinder {
				<.19,.525,-.10>,<.19,.65,-.10>,.1
			}
		}
	}
		#declare Grasn=100
		#declare Grashvar= .4
		#declare Grasrotvar= 40
	union {
		#include "10gras2.inc"
		scale <.1,.2,.1>
		translate<.08,.522,-.16>
		bounded_by {
			cylinder {
				<.08,.522,-.16>,<.08,.622,-.16>,.1
			}
		}
	}
		#declare Grasn=60
		#declare Grashvar= .4
		#declare Grasrotvar= 40
	union {
		#include "10gras2.inc"
		scale <.06,.18,.06>
		translate<-.12,.52,-.49>
		bounded_by {
			cylinder {
				<-.12,.52,-.49>,<-.12,.61,-.49>,.06
			}
		}
	}
	clipped_by {Innenglas}
}
// *******************Buschzeug****************

#declare Buschzeug= union {
	union{
		#include "10busch.inc"
		scale <.15,.15,.15>
		translate <-.3,.58,-.3>
	}
	union{
		#include "10busch.inc"
		scale <.25,.2,.25>
		translate <-.2,.65,.32>
	}
	union{
		#include "10busch.inc"
		scale <.2,.25,.2>
		translate <-.3,.6,.3>
	}
	union{
		#include "10busch.inc"
		scale <.2,.2,.2>
		translate <-.4,.6,.15>
	}
	union{
		#include "10busch.inc"
		scale <.2,.2,.2>
		translate <-.43,.58,.03>
	}
	union{
		#include "10busch.inc"
		scale <.2,.2,.15>
		translate <.25,.58,.25>
	}
	clipped_by {Innenglas}
}


//***********************Blumen
#declare Blumen = union {
	union {
		#include "10blume.inc"
		rotate y*60
		scale .1
		translate <-.05,.53,.16>
	}
	union {
		#include "10blume.inc"
		rotate -y*75
		scale .1
		translate <0,.53,0>
	}
	union {
		#include "10blume.inc"
		rotate -y*35
		scale .1
		translate <0.12,.53,0.1>
	}
	union {
		#include "10blume.inc"
		rotate y*10
		scale .1
		translate <-.1,.53,.05>
	}
	union {
		#include "10blume.inc"
		rotate -y*170
		scale .1
		translate <.01,.53,-.07>
	}
	union {
		#include "10blume.inc"
		rotate -y*70
		scale .1
		translate <.0,.53,-.07>
	}
	union {
		#include "10blume.inc"
		rotate y*70
		scale .1
		translate <-.01,.53,-.27>
	}
	union {
		#include "10blume.inc"
		rotate -y*23
		scale .1
		translate <-.15,.53,-.17>
	}
	union {
		#include "10blume.inc"
		rotate y*40
		scale .1
		translate <-.18,.53,.06>
	}
	union {
		#include "10blume.inc"
		rotate y*103
		scale .1
		translate <-.25,.53,.27>
	}	
}
//****************************Lichter********************************

//light_source { glaspos+<0, 1000, 0> rgb<1,1,1>*1 }
light_source { <1000000, 1000000,700000> rgb<1,1,1>*1
	looks_like {
		sphere {<		0,0,0>,200000
			pigment{color rgb<1,.9,.6>}
			finish{ ambient 1.4 diffuse 0}
		}
	}
}

//****************************Berge*******************************

#declare voxmap=
	height_field
	{
		tga
		"moon3ks.tga"
		smooth
	}

union{
	object {voxmap }
	object {voxmap scale<-1,1,-1>translate<0,0,2> }
	object {voxmap scale<1,1,-1>translate<0,0,2> }
	object {voxmap scale<-1,1,-1>translate <2,0,2> }
	object{voxmap translate<0,0,2> }
	object {voxmap scale<-1,1,1>translate <0,0,2> }
	object {voxmap scale<-1,1,1>translate <2,0,2> }
	scale <10000, 450, 10000>
	pigment {
		bozo
		color_map {
			[.33, color rgb<.7,0.65,0.65>]
			[.66,color rgb<.8,.6,.6>]
			[.99,color rgb<.75,.60,.65>]
		}
		frequency 1
		omega .4
		lambda 2
		turbulence <10,10,10>
		octaves 10
		scale <700,150,2000>
		rotate x*10
		rotate z*20
		rotate y*190
  }
//	normal{ bumps .4 scale .01}
	normal {bozo .020 scale 0.04 }

}


//cylinder { glaspos,glaspos+<0,.14,0>,.05 pigment {color rgbft<1,1,1,.1,.8>} finish {ambient .81}}
//cone { glaspos,0,glaspos+<0,.14,0>,.05 pigment {color rgbt<1,1,1,.8>} finish {ambient .81}}
object {Glas translate glaspos}
object {Gummi translate glaspos}
object { Erde translate glaspos}
object {Wasser translate glaspos }
object {Strandgras translate glaspos }
object {Buschzeug translate glaspos}
object {Blumen translate glaspos}
