#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

double Random(double dRange) {
  return double(rand()) / double(RAND_MAX) * dRange;
}

int main(int argc, char *argv[]) {
  FILE *fp;

  fp = fopen("Drops.pov", "w");

  /*
  for(int i = 0; i < 2500; ++i) {
    fprintf(fp, 
            "sphere{ <%.4lf, 0, %.4lf>, %.4lf scale <1, %.4lf, 1> texture{ WaterTexture}}\n", 
            -5.0 + Random(10.0), 
            -5.0 + Random(10.0),
            0.03 + Random(0.02),
            0.7 + Random(0.3));
  }
  */

  double d1stRotate;

  for(int i = 0; i < 1500; ++i) {
    d1stRotate = Random(360.0);
    if((d1stRotate > 110.0) &&
       (d1stRotate < 280.0))
      continue;
    if(Random(1.0) > 0.5) {
      // Create very small droplet      
      fprintf(fp,
              "sphere{ <1, 0, 0>, %.4lf rotate <0, 0, %.3lf> translate <0.6, 0, 0> rotate<0, %.3lf, 0> texture{ WaterTexture}}\n",
              0.01 + Random(0.01),
              d1stRotate,
              Random(360.0));
    } else {
      // Create moderate droplet
      fprintf(fp,
              "sphere{ <0, 0, 0>, %.4lf scale <%.3lf, 1, 1> translate <1, 0, 0> rotate <0, 0, %.3lf> translate <0.6, 0, 0> rotate<0, %.3lf, 0> texture{ WaterTexture}}\n",
              0.06 + Random(0.02),
              0.4 + Random(0.3),
              d1stRotate,
              Random(360.0));
    }
  }

  fclose(fp);
  return 0;
}
