#include "colors.inc"
#include "textures.inc"

/********************************************/

camera
{
  location <0.02, 0.0, -0.3>
  look_at <0.0, 0.0, 0.0>
  aperture 0.04
  blur_samples 100  //avant on avait 50... mais plus maintenant...
  focal_point <0.0, 0.0, 0.0>
}

light_source
{
  <1.0, 1.0, -2.0>
  color rgb <2.3, 2.3, 1.4>
  spotlight
  point_at <0.0, 0.0, 0.0>
  radius 8
  tightness 0.1
  falloff 10
}

atmosphere
{
    type 2
    samples 2
    distance 1.0
    scattering 1.5
    aa_level 4
    aa_threshold 0.01
    jitter 0.5
}

//background { Blue }

/********************************************/

#declare NbFil = 17.0
#declare EpaisseurFil = 0.0001
#declare LongueurFil = 0.3
#declare EcartTourFil = 0.01
#declare AngleElementaire = 360.0/NbFil
#declare CC = cos(AngleElementaire*pi/180.0)
#declare SS = sin(AngleElementaire*pi/180.0)
#declare NbBlobs = 10
#declare NbBlobs2 = 5
#declare S1 = seed(101)

/********************************************/

#declare Spirale = merge
{
  #declare NoFil = 0.0
  #declare Rayon = 0.0
  #while (Rayon < LongueurFil)
    #declare NouveauRayon = Rayon+EcartTourFil/NbFil
    cylinder
    {
      <Rayon, 0.0, 0.0>
      <NouveauRayon*CC, NouveauRayon*SS, 0.0>
      EpaisseurFil
      rotate AngleElementaire*NoFil*z
    }
    #declare Rayon = NouveauRayon
    #declare NoFil = NoFil+1.0
    #if (NoFil = NbFil)
      #declare NoFil = 0.0
    #end
  #end
}

#declare Armature = merge
{
  #declare Count = 1.0
  #while (Count <= NbFil)
    #declare Angle = 360.0*Count/NbFil
    cylinder
    {
      <0.0, 0.0, 0.0>
      <LongueurFil, 0.0, 0.0>
      EpaisseurFil
      rotate Angle*z
    }
    #declare Count = Count+1.0
  #end
}


#declare Rosee = blob
{
  threshold 0.99
  #declare Count = 1.0
  #while (Count <= NbFil)
    #declare Angle = 360.0*Count/NbFil
    #declare Count2 = 0.0
    #while (Count2 < NbBlobs)
      #declare R1 = 0.005*(1.0+rand(S1))
      sphere
      {
        <LongueurFil*Count2/NbBlobs, 0.0, 0.0>
        R1, 0.55   //plus que 0.5 et moins que 1.0, 0.6 par exemple
        rotate Angle*z
      }
      #declare Count2 = Count2+1.0
    #end
    #declare Count = Count+1.0
  #end
  #declare NoFil = 0.0
  #declare Rayon = 0.0
  #while (Rayon < LongueurFil)
    #declare NouveauRayon = Rayon+EcartTourFil/NbFil
    #declare Count2 = 0.0
    #while (Count2 < NbBlobs2)
      #declare R1 = 0.005*(1.0+rand(S1))  //0.005
      sphere
      {
        <Rayon+(NouveauRayon*CC-Rayon)*Count2/NbBlobs2, NouveauRayon*SS*Count2/NbBlobs2, 0.0>
        R1, 0.5 //0.5 c'est pas mal...
        rotate AngleElementaire*NoFil*z
      }
      #declare Count2 = Count2+1.0
    #end
    #declare Rayon = NouveauRayon
    #declare NoFil = NoFil+1.0
    #if (NoFil = NbFil)
      #declare NoFil = 0.0
    #end
  #end
  sturm
  texture
  {
    pigment { White filter 1.0 }
    finish
    {
      ambient 0.0
      diffuse 0.0
      reflection 0.25
      refraction 1.0
      ior 1.33
      specular 1.0
      roughness 0.001
      fade_distance 5.0
      fade_power 1.0
      caustics 1.0
      irid
      { 0.35 thickness 0.5 turbulence 0.5 }
    }
  }
}

#declare Fond = plane
{
  z, -0.4
  rotate 180.0*y
  texture
  {
    pigment
    {
      image_map
      {
        gif "r17a.gif"
        map_type 0
        interpolate 2
        once
      }
    }
    translate <-0.5, -0.5, 0.0>
  }
}

/********************************************/

#declare Toile = merge
{
  object { Spirale }
  object { Armature }
  pigment { White }
}

/********************************************/

#declare R_feuille = 1.0
#declare E_feuille = 0.005
#declare D_feuille = 0.1
#declare A_feuille = 5.0

#declare Feuille = difference
{
  sphere
  {
    <0.0, 0.0, 0.0>
    R_feuille
  }
  sphere
  {
    <0.0, 0.0, 0.0>
    R_feuille-E_feuille
  }
  box
  {
    <-2.0*R_feuille, 0.0, -2.0*R_feuille>
    <2.0*R_feuille, -2.0*R_feuille, 2.0*R_feuille>
  }
  box
  {
    <D_feuille, -2.0*R_feuille, -2.0*R_feuille>
    <2.0*R_feuille, 2.0*R_feuille, 2.0*R_feuille>
    rotate A_feuille*z
  }
  box
  {
    <-D_feuille, -2.0*R_feuille, -2.0*R_feuille>
    <-2.0*R_feuille, 2.0*R_feuille, 2.0*R_feuille>
    rotate -A_feuille*z
  }
  box
  {
    <-2.0*R_feuille, -2.0*R_feuille, 0.0>
    <2.0*R_feuille, 2.0*R_feuille, 2.0*R_feuille>
  }
  texture
  {
    pigment
    {
      gradient x
      pigment_map
      {
        [ 0.0 rgb <0.3, 0.3, 0.0> ]
        [ 0.5 rgb <0.0, 0.3, 0.0> ]
        [ 1.0 rgb <0.3, 0.3, 0.3> ]
      }
    }
    normal
    {
      bumps 0.5
    }
    finish
    {
      reflection 0.04
    }
    scale 0.2
  }
}

#declare Feuille2 = object
{
  Feuille
  scale 0.1
  rotate 90.0*x
  rotate -90.0*y
}

#declare Groupe_Feuilles = merge
{
  object { Feuille2 rotate -45.0*y translate -0.1*z translate 0.15*x translate -0.12*y }
  object { Feuille2 rotate -35.0*y translate -0.1*z translate 0.15*x translate -0.10*y }
  object { Feuille2 rotate -47.0*y translate -0.1*z translate 0.145*x translate -0.09*y }
  object { Feuille2 scale 1.1 rotate -35.0*y translate -0.1*z translate 0.15*x translate -0.095*y }
  object { Feuille2 rotate -35.0*y translate -0.1*z translate 0.12*x translate -0.11*y }
  object { Feuille2 scale 1.05 rotate -32.0*y translate -0.1*z translate 0.12*x translate -0.105*y }
}

#declare Arbre = merge
{
  object { Groupe_Feuilles }
  object { Groupe_Feuilles translate 0.08*y translate 0.05*x }
  object { Groupe_Feuilles translate 0.03*y translate -0.01*x }
  object { Groupe_Feuilles translate 0.12*y }
  object { Groupe_Feuilles translate 0.09*y translate -0.005*x }
  object { Groupe_Feuilles translate 0.05*y translate -0.02*x }
  object { Groupe_Feuilles translate 0.01*y translate -0.03*x }
}


/*****************************************/

#declare Univers = difference
{
  box
  {
    <-4.0, -4.0, -4.0>
    <4.0, 4.0, 4.0>
  }
  box
  {
    <-3.0, -3.0, -3.0>
    <3.0, 3.0, 3.0>
  }
  pigment { Black }
}

/*****************************************/

object { Toile }
object { Rosee }
object { Fond }
object { Arbre }
object { Univers }
