#include "colors.inc" #include "mestex.inc" #include "woods.inc" #include "whiteash.map"
#declare r1=seed(0)

camera {location <80,140,-60> direction <0,0,2.5> look_at <0,80,-20>}

#declare AreaSwitch=on
#declare TexSwitch=on
#declare TexSwitchTablette=on
#declare HoneySwitch=on
#declare HoneyGlassSwitch=on
#declare AdapValue=1
#declare CacSwitch=on
#declare VerreSwitch=on
#declare FlowerSwitch=on
#declare ThonetSwitch=on
#declare BeeSwitch=on

#declare FloTrans=<0,92,-25>

#declare TigeFleur=union {
cylinder {<0,0,0>,<0,-19,0>,.2}
#include "feuille.inc"
object {Feuille scale 5 rotate y*-90 translate y*-7}
pigment {MediumSeaGreen} finish {phong .4 specular .2} normal {crackle .2 scale .3}
}

#include "wasp_n.pov"
#declare Abeille=object {WASP00_f scale .3 rotate x*90 translate <0,2.5,-4>}

#if (VerreSwitch=on)
#declare VerreTry=texture {pigment {rgb <.9,.9,1>/20 transmit .9}finish {phong .2 refraction 1 ior 1.5 reflection .2}normal {bumps .005}}
#else 
#declare VerreTry=texture {pigment {rgb <.9,.9,1> transmit .9}}
#end

global_settings {max_trace_level 20 adc_bailout 1/16}
//====================================================================================
//     CLOUS
//====================================================================================
#declare boucle=0
#while (boucle < 100)
cylinder {<2.01,1.5,-40>,<0,1.5,-40>,.15 
translate <rand(r1)*.05,boucle*3+rand(r1)*.3,rand(r1)*.4> 
texture {pigment {CornflowerBlue} finish {metallic specular .3 reflection .2}}}
#declare boucle=boucle+1
#end
//====================================================================================
//      ROTIN
//====================================================================================
#if (ThonetSwitch=on)
#declare r_t = 1.5   //rayon tresse
#declare e_t = 5     //ecart tresse
#declare ea_t = 18   //entre-axe tresse
#declare ez = ea_t/2
#declare PaireTresse=union {
cylinder {<-e_t/2,0,0>,<-e_t/2,0,ea_t*3>,r_t}
cylinder {<e_t/2,0,0>,<e_t/2,0,ea_t*3>,r_t}}

#declare ModuleTresse9=union {
object {PaireTresse}object {PaireTresse translate x*ea_t}object {PaireTresse translate x*ea_t*2}
object {PaireTresse rotate y*90}object {PaireTresse rotate y*90 translate z*ea_t}object {PaireTresse rotate y*90 translate z*ea_t*2}

cylinder {<ez,0,0>,<0,0,ez>,r_t}cylinder {<ez*3,0,0>,<0,0,ez*3>,r_t}cylinder {<ez*5,0,0>,<0,0,ez*5>,r_t}
union {cylinder {<ez,0,0>,<0,0,ez>,r_t}cylinder {<ez*3,0,0>,<0,0,ez*3>,r_t}cylinder {<ez*5,0,0>,<0,0,ez*5>,r_t}
scale <1,1,-1> translate z*ez*6}
union {cylinder {<ez,0,0>,<0,0,ez>,r_t}cylinder {<ez*3,0,0>,<0,0,ez*3>,r_t}cylinder {<ez*5,0,0>,<0,0,ez*5>,r_t}
scale <-1,1,1> translate x*ez*6}
union {cylinder {<ez,0,0>,<0,0,ez>,r_t}cylinder {<ez*3,0,0>,<0,0,ez*3>,r_t}cylinder {<ez*5,0,0>,<0,0,ez*5>,r_t}
scale <-1,1,1> translate x*ez*6 scale <1,1,-1> translate z*ez*6}
pigment {NewTan} finish {phong 0}
bounded_by { box {<0,2,0>,<ea_t*3,-2,ea_t*3>} }
}

#declare RotinComp = 
union {
#declare boucle1=0
#while (boucle1 < 7)
#declare boucle2=0 
#while (boucle2 < 7)
object {ModuleTresse9 translate <boucle1*ea_t*3,0,boucle2*ea_t*3>}
#declare boucle2=boucle2+1
#end
#declare boucle1=boucle1+1
#end
translate <-200,0,-200>
bounded_by {cylinder {<0,-5,0>,<0,5,0>,170}}
clipped_by {cylinder {<0,-5,0>,<0,5,0>,170}}
scale .1
} 
//====================================================================================
//     CHAISE THONET
//====================================================================================
#declare Thonet = union {
torus {15.5 1 translate <0,31,-16>}

difference {
union {cylinder {<0,0,0>,<0,3,0>,18} cylinder {<0,0,0>,<0,4,0>,17} torus {17 1 translate y*3}}
cylinder {<0,-1,0>,<0,5,0>,16}
translate <0,39,-16>}

object {RotinComp translate <0,42.8,-16>}
texture {T_Wood2 scale 10}
finish {phong .6 phong_size 25}
}

object {Thonet translate <20,0,40>}
#else #end
//==============================================================================
//      A LITTLE CACTUS
//==============================================================================
#if (CacSwitch=on)
#declare PiqUnit = union { 
  cone {<0,0,0>,.02,<0,1,0>,0 pigment {Wheat} rotate <rand(r1)*50,rand(r1)*30,rand(r1)*30>}
  cone {<0,0,0>,.02,<0,1,0>,0 pigment {Wheat} rotate <rand(r1)*50,rand(r1)*30,rand(r1)*30>}
  cone {<0,0,0>,.02,<0,1,0>,0 pigment {Wheat} rotate <rand(r1)*50,rand(r1)*30,rand(r1)*30>}
  translate y*2.8
  bounded_by {cylinder {<0,2.5,0>,<0,4,0>,1}}
  //no_shadow
  }

#declare CacUnit=union {
intersection {
sphere {<0,0, 3>,3.5}
sphere {<0,0,-3>,3.5} pigment {SeaGreen} finish {phong .3} normal {bumps .2} scale 1.5}
#declare boucle=0
#while (boucle < 24)
object {PiqUnit rotate z*(360/24*boucle)}
#declare boucle=boucle+1
#end
}

#declare Cactus=union {
#declare boucle=0
#while (boucle < 12)
object {CacUnit rotate y*(360/12*boucle)}
#declare boucle=boucle+1
#end
}

#declare PetitPot1=union {
cone {<0,0,0>,2.5,<0,5.1,0>,3}
cone {<0,4.9,0>,3.3,<0,6.5,0>,3.6}
}
#declare PetitPot=union {
difference {
object {PetitPot1}
object {PetitPot1 scale .95 translate y*.4}
pigment {Firebrick+Orange/4} finish {phong .2 specular .4}
normal {ripples .1 scale <1,.1,1>}}
cone {<0,0,0>,2.4,<0,4.7,0>,2.9 pigment {Gray10}}
}

union {
object {PetitPot}
object {Cactus bounded_by {sphere {0,4}} translate y*7}                   
translate <-4,70,10>
}
#else #end

//==============================================================================
//      TEXTURE DECLARATIONS
//==============================================================================
#if (VerreSwitch=on)
#declare VerreTry=texture {pigment {rgb <.9,.9,1>/20 transmit .9}finish {phong .2 refraction 1 ior 1.5 reflection .2}normal {bumps .005}}
#else 
#declare VerreTry=texture {pigment {rgb <.9,.9,1> transmit .9}}
#end

#declare FlowerPig=pigment {onion color_map {
[0 .3 color Pink*2 color Pink filter .3]
[.6 .9 color SpicyPink filter .4 color SpicyPink]
[.9 .99 color SpicyPink color Pink*2]
}turbulence .4 omega .7 octaves 7 lambda 2
scale 5}

#declare r1=seed(0)    

#if (TexSwitchTablette=on)
#declare Wash=texture {
        pigment {wood color_map { M_WhiteAsh } turbulence .03 omega .7} 
        normal {wood .2 turbulence .03 omega .7} 
        finish {specular .15 phong .3 reflection .25} scale .4 rotate x*2}
#else
#declare Wash=texture {pigment {Tan}}
#end

#if (TexSwitch=on)
#declare EMBW =texture {T_Wood23 finish {specular .2 phong .4 reflection .2} scale 10 rotate <rand(r1)*20,rand(r1)*20,rand(r1)*20> translate <rand(r1)*30,rand(r1)*30,rand(r1)*30> normal {bumps .3 scale <.1,.1,30>}}
#else
#declare EMBW =texture {pigment {Orange}}
#end

 #if (TexSwitch=on)   
 #declare HoneyWood1 =
    texture {  pigment{ P_WoodGrain1A color_map { M_Wood14A }} normal {wood .15 turbulence <0.1, 0.5, 1> octaves 5 lambda 3.25 scale <0.15, .5, 1> rotate <5, 10, 5> translate -x*2}}
    texture {  pigment{ P_WoodGrain1B color_map { M_Wood13B }} finish {phong .1 specular .04 reflection .1}normal {wood .1 turbulence 0.04 octaves 3 scale <0.05, .05, 1>}}
 #else
#declare HoneyWood1 = texture {pigment {Brown}}
 #end
   
#declare HoneyWood = texture {HoneyWood1   
        rotate <10,5,6> translate <60,40,20> scale 4}

//==============================================================================
//      UNE TACHE RONDE
//==============================================================================
disc {<0,0,0>,y,10 pigment {image_map{gif "tache" once filter all 1} rotate x*90 translate <-.5,0,-.5> scale <13,1,13>}
translate <-2,70.12,-5>}
//==============================================================================
//      ...WITH FLOWERS IN THEIR HAIR...
//==============================================================================
#if (FlowerSwitch=on)
#declare petale = 
sphere {<0,0,0>,.1 translate x*.1 scale <30,.5,2> }

#declare r1=seed(0)

union {
sphere {<0,0,0>,2.5 pigment {rgb <.973,.902,.702> scale <1,.3,1> 
translate y*-.3} 
normal {crackle .4 scale .2}}

#declare boucle=0
#declare maxboucle=90
#while (boucle < maxboucle)
object {petale scale <1+(rand(r1)*.2),1,1>  rotate z*rand(r1)*2 rotate y*boucle*(360/maxboucle)}
object {petale scale <.7+(rand(r1)*.2),1,1> rotate z*(rand(r1)*3+5) rotate y*boucle*(360/maxboucle)}
object {petale scale <.4+(rand(r1)*.2),1,1> rotate z*(rand(r1)*3+9) rotate y*boucle*(360/maxboucle)}
object {petale scale <1+(rand(r1)*.2),1,1>  rotate z*(rand(r1)*3-9) rotate y*boucle*(360/maxboucle)}
#declare boucle=boucle+1
#end
object {TigeFleur rotate <-10,0,20>}

#if (BeeSwitch=on)
object {Abeille}
#else #end
pigment {FlowerPig} 
rotate <-10,0,-30> translate FloTrans
}
#else #end
//==============================================================================
//      A POT OF HONEY
//==============================================================================
#if (HoneySwitch=on)
#declare HoneyPot= union {
cylinder {<0,1.6,0>,<0,6.5,0>,4.43 pigment {image_map {gif "honey2" map_type 2 filter 215,1} scale <1,5,1> rotate y*90 translate y*1.6} finish {ambient .4 specular .2} normal {bumps .4}}
difference {
merge {
torus {3.5 .2 translate y*.2}
cylinder {<0,0,0>,<0,.4,0>,3.5}
torus {3.5 1 translate y*1.2}
torus {4.3 .2 translate y*1.4}
cylinder {<0,1.4,0>,<0,7,0>,4.4}
torus {4.3 .2 translate y*7}
torus {3.3 1 translate y*7}    
cylinder {<0,7.8,0>,<0,9,0>,3.2}
torus {3.2 .1 rotate x*2 translate y*8}
torus {3.2 .1 rotate x*2 translate y*8.4}
torus {3.2 .1 rotate x*2 translate y*8.8}
}
merge {
        cylinder {<0,.6,0>,<0,9.1,0>,2.9}
        torus {3 1 translate y*7}
        cylinder {<0,1.4,0>,<0,7,0>,4.2}
        torus {3.2 1 translate y*1.2}

}
}

#if (HoneyGlassSwitch=on)
pigment {LightBlue*1.1 filter .95} 
finish {refraction 1 ior 1.3 specular .2 phong.6 reflection .2 caustics 1}
normal {crackle .2 scale 5}
#else
pigment {LightBlue filter .9}
#end

scale <.8,1,.8>*1.5
}

object {HoneyPot translate <0,70.15,-20>}
#else #end

//==============================================================================
//      DEFINITION OF BROKEN GLASS
//==============================================================================
#declare Casse=prism { linear_sweep linear_spline -.1,.5,12,
<0,0>,<0,9.7>,<1.5,9>,<2.8,8.2>,<4.4,7.4>,<5.2,6.3>,<6.7,5.5>,<7.3,4.3>,<7.6,2.5>,<8.4,1.4>,<8.3,0>,<0,0>}

#declare CarreauCasse=union {
intersection {
object {Casse scale .999}
box {<0,0,0>,<15,.4,15>}
texture {VerreTry}
}

difference {
box {<0,0,0>,<15,.4,15>}
object {Casse scale 1}
texture {VerreTry}}
}

//==============================================================================
//      BOARD AND BATTEN
//==============================================================================

#declare Bbaten=union {
box {<0,0,0>,<2,13,62> texture {EMBW} finish {phong .1}}
box {<0,13,0>,<1.5,15,62> texture {T_Wood1}}
}
#declare Bbaten2=union {
box {<0,0,-2>,<2,13,30> texture {EMBW} finish {phong .1}}
box {<0,13,-2>,<1.5,15,30> texture {T_Wood1}}
}

#declare boucle=0
#while (boucle < 10)
difference {
object {Bbaten translate <0,-5+boucle*15,-100>}
plane {x,0 rotate y*45 translate z*-40 pigment {White}}}
#declare boucle=boucle+1 #end

union {
#declare boucle=0
#while (boucle < 10)
difference {
object {Bbaten2 translate <0,-5+boucle*15,0>}
plane {z,0 rotate y*45 pigment {White}}}
#declare boucle=boucle+1 #end
rotate y*-90 
translate z*-40
}

union {
#declare boucle=0
#while (boucle < 10)
difference {
object {Bbaten2 translate <0,-5+boucle*15,0>}
plane {z,0 rotate y*45 pigment {White}}}
#declare boucle=boucle+1 #end
rotate y*-90 
translate z*-40
scale <1,1,-1>
}

#declare boucle=0
#while (boucle < 5)
object {Bbaten translate <0,-5+boucle*15,-40>}
#declare boucle=boucle+1 #end

#declare boucle=0
#while (boucle < 5)
object {Bbaten translate <0,-5+boucle*15,20>}
#declare boucle=boucle+1 #end
//==============================================================================
//      DEFINITION FENETRE
//==============================================================================
#declare Profile1=union { //1cm ready to extrude along +z
box {<0,0,0>,<4,.5,1>}
box {<2,0,0>,<3.5,1,1>}
box {<2,0,0>,<3,1.5,1>}
box {<2,0,0>,<2.5,2,1>}
difference {box {<0,.5,0>,<1.6,2,1>} plane {y,0 rotate z*45 translate y*.5 inverse} pigment {NewTan}}
}

#declare Carreau=union {
object {Profile1 scale <1,1,15> texture {HoneyWood}}
object {Profile1 rotate x*90 scale <1,-15,1> texture {HoneyWood rotate x*90}}
object {Profile1 rotate x*90 scale <1,-15,1> texture {HoneyWood rotate x*90} scale <1,1,-1> translate z*15}
object {Profile1 scale <1,1,15> texture {HoneyWood} scale <1,-1,1> translate y*15}
box {<1.6,0,0>,<2,15,15> texture {VerreTry}}
}

#declare CarreauSpec=union {
object {Profile1 scale <1,1,15> texture {HoneyWood}}
object {Profile1 rotate x*90 scale <1,-15,1> texture {HoneyWood rotate x*90}}
object {Profile1 rotate x*90 scale <1,-15,1> texture {HoneyWood rotate x*90} scale <1,1,-1> translate z*15}
object {Profile1 scale <1,1,15> texture {HoneyWood} scale <1,-1,1> translate y*15}
object {CarreauCasse rotate z*-90 translate <1.6,15,0>}
}

#declare Ouvrant=union {
box {<0,2,0>,<4,4,39.5> texture {HoneyWood}}
box {<2,0,0>,<4,4,39.5> texture {HoneyWood}}
box {<0,0,2>,<4,70,5> texture {HoneyWood rotate x*90}}
box {<0,0,40>,<4,70,35> texture {HoneyWood rotate x*90}}
object {Carreau translate <0,4,5>}
object {Carreau translate <0,4,5> translate y*15}
object {Carreau translate <0,4,5> translate y*30}
object {Carreau translate <0,4,5> translate y*45}
object {Carreau translate <0,4,5> translate z*15}
object {Carreau translate <0,4,5> translate y*15 translate z*15}
object {Carreau translate <0,4,5> translate y*30 translate z*15}
object {Carreau translate <0,4,5> translate y*45 translate z*15}
}
#declare Ouvrant2=union {
union {
box {<0,2,0>,<4,4,39.5> texture {HoneyWood}}
box {<2,0,0>,<4,4,39.5> texture {HoneyWood}}
box {<0,0,2>,<4,70,5> texture {HoneyWood rotate x*90}}
box {<0,2,40>,<4,70,35> texture {HoneyWood rotate x*90}}
object {Carreau translate <0,4,5>}
object {Carreau translate <0,4,5> translate y*15}
object {Carreau translate <0,4,5> translate y*30}
object {Carreau translate <0,4,5> translate y*45}
object {CarreauSpec translate <0,4,5> translate z*15}
object {Carreau translate <0,4,5> translate y*15 translate z*15}
object {Carreau translate <0,4,5> translate y*30 translate z*15}
object {Carreau translate <0,4,5> translate y*45 translate z*15}
scale <1,1,-1>}
box {<5,0,-38>,<4,70,-42> texture {HoneyWood rotate x*90}}
}


//==============================================================================
//      ROOM
//==============================================================================
//room is 200*350*200, centered on x axis, running from x=0 to x=200
//window in the yz plane 80 wide 120 high starting at y=70
plane {y,0 pigment {image_map {gif "pelouse"} rotate x*90 scale <100,1,100>}}
box {<-30,0,130>,<230,.3,-130> pigment {Tan}}
box {<-30,349,130>,<230,350,-130> pigment {White}} //plafond
box {<-30,0,-100>,<200,350,-130> pigment {Tan}} //mur later
box {<200,0,130>,<230,350,-130> pigment {Tan}} //mur fond
box {<-30,0,100>,<200,350,130> pigment {Tan}} //mur later
box {<-30,0,130>,<0,350,40> pigment {Tan}} //baie
box {<-30,0,-130>,<0,350,-40> pigment {Tan}} //baie
 box {<-30,0,40>,<0,67,-40> pigment {LightBlue}} //allge
box {<6,66,-40>,<-30,67,40> texture {Wash scale 1 translate <0,70,0> }}
 height_field {gif "tablette.gif"  rotate y*-90 translate <1,0,-.5> scale <36,4,80>
 translate <-30,66.1,0> texture {Wash scale 1 translate <0,70,0> }}
union {box {<2,70,-40>,<4,71.8,40>}
box {<0,68,-40>,<2,74,40>} texture {HoneyWood} translate x*-20}

object {Ouvrant               translate <-20,72,-40>}
object {Ouvrant2 rotate y*-10 translate <-20,72,40>}

//==============================================================================
//      LIGHT PLEASE !
//==============================================================================
#declare SunDistance=149000000*1000*100
light_source {<-SunDistance,0,0> White*2  
        #if (AreaSwitch=on) area_light y*139000000000,z*139000000000,5,5 adaptive AdapValue jitter #else #end
        rotate z*-45}
light_source {<100,300,0> White*1.5 
        #if (AreaSwitch=on) area_light x*100,z*100,5,5 adaptive AdapValue jitter  #else #end
        }

