//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 19 textures and 4724 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 06/26/1998    (26.06.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     2000.0
  color <0.94902,0.94902,0.94902,0.0,0.2>
  up           <0,0,1>
  fog_offset   100.0
  fog_alt      20.0
}

camera {  //  Camera StdCam
  location  <-15.358, -50.741, -1.175>
  direction <0.0,     0.0,  1.6095>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <2.330, -1.550, -0.015>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <-11.000, -70.000, -4.000> // Attached to SpotLite001
  direction <0.0,     0.0,  2.3523>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-11.000, -69.000, -4.000> // Following SpotLite001
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight SpotLite001
  <-11.000, -70.000, -4.000>
  color  rgb <0.500, 0.500, 0.500>
  spotlight
    point_at  <-11.000, -69.000, -4.000>
    falloff   12.00  // outer radius (in deg)
      radius    10.40  // inner radius
  shadowless
}

light_source {   // Luz2
  <-32.930, 11.580, 35.640>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Luz1
  <-32.930, 11.830, 35.250>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  TEXTURES  *******
//

#include "ger_pa01.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare PiedraMA1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.817474, -2.051098, -2.258725>, <-1.974357, -2.879555, -2.887037>, <-0.394636, -2.974289, -2.897824>, <0.221595, -2.974289, -2.735594>, 
      <-2.862085, -1.857899, -0.806394>, <-1.857899, -2.553196, -1.067942>, <-0.555108, -2.650554, -0.980791>, <0.246130, -2.650903, -0.983292>, 
      <-2.921699, -1.244137, -2.367446>, <-1.952633, -1.899975, 0.000000>, <-0.952633, -1.899975, 0.000000>, <0.060223, -1.781557, 0.346497>, 
      <-2.960850, -0.512988, -1.979041>, <-1.994569, -1.030261, 0.441210>, <-0.994569, -1.030261, 0.441210>, <0.011859, -0.971052, 0.614458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.960850, -0.512988, -1.979041>, <-1.994569, -1.030261, 0.441210>, <-0.994569, -1.030261, 0.441210>, <0.011859, -0.971052, 0.614458>, 
      <-3.000000, 0.218162, -1.590636>, <-2.036505, -0.160547, 0.882420>, <-1.036505, -0.160547, 0.882420>, <-0.036505, -0.160547, 0.882420>, 
      <-3.000000, 1.002482, -0.296559>, <-1.826752, 0.786803, 1.572963>, <-0.715797, 1.073056, 3.094195>, <0.185413, 1.010809, 2.903050>, 
      <-2.821279, 1.914743, -2.432233>, <-2.036505, 2.409570, 0.976444>, <-1.000000, 2.463490, -1.135976>, <0.000000, 2.369130, -0.879857>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.221595, -2.974289, -2.735594>, <0.837827, -2.974289, -2.573364>, <1.534983, -2.784821, -2.472016>, <1.910557, -2.737454, -1.645860>, 
      <0.246130, -2.650903, -0.983292>, <1.047367, -2.651251, -0.985792>, <2.000000, -2.367048, -0.985792>, <2.431595, -1.838240, -1.294077>, 
      <0.060223, -1.781557, 0.346497>, <1.073078, -1.663139, 0.692994>, <2.094734, -1.615772, 0.000000>, <2.551076, -1.299554, -1.589617>, 
      <0.011859, -0.971052, 0.614458>, <1.018286, -0.911843, 0.787707>, <2.029114, -0.722375, 0.441210>, <2.574759, -0.662016, -1.333497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.011859, -0.971052, 0.614458>, <1.018286, -0.911843, 0.787707>, <2.029114, -0.722375, 0.441210>, <2.574759, -0.662016, -1.333497>, 
      <-0.036505, -0.160547, 0.882420>, <0.963495, -0.160547, 0.882420>, <1.963495, 0.171023, 0.882420>, <2.598443, -0.024478, -1.077378>, 
      <0.185413, 1.010809, 2.903050>, <1.086624, 0.948562, 2.711906>, <2.000000, 1.213106, 1.941116>, <2.483434, 0.881537, -1.322166>, 
      <0.000000, 2.369130, -0.879857>, <1.000000, 2.274770, -0.623738>, <2.173248, 2.409570, 0.333570>, <2.257382, 1.989819, -1.228188>
    }
  }
  texture {
    PiedraTex1
  }
  translate  <-2.899996, -21.48724, -6.851832>
}


#declare BezPtch3 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.481044, -67.402256, 0.497603>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <1.518956, -67.402256, 0.532319>, 
      <-1.517977, 20.527027, -16.968995>, <-0.517977, 20.527027, -17.466597>, <0.482023, 20.527027, -17.466597>, <1.482023, 20.527027, -16.934278>, 
      <-1.468198, 59.400883, -43.470039>, <-0.468198, 59.400883, -43.967642>, <0.531802, 59.400883, -43.967642>, <1.531802, 59.400883, -43.435322>, 
      <-0.108355, 83.672947, -105.401881>, <-0.142962, 83.708623, -105.401881>, <-0.141892, 83.708623, -105.401881>, <-0.105146, 83.708623, -105.401881>
    }
  }
  scale <4.0, 1.0, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <3.387052, 0.008233, 68.143007>
}
#declare Petalo1 = object {
  sphere { // Petalo1
    <0,0,0>,1
    texture {
      PetaloTex1
    }
    scale <10.0, 3.0, 0.1>
    rotate -8.0*y
    translate  <12.537103, 0.267964, 1.159211>
  }
}
#declare Flor1 = union {
  object { Petalo1 }
  sphere { // Centro1
    <0,0,0>,1
    texture {
      CentroTex1_1
    }
    scale <10.0, 10.0, 2.5>
  }
  object { // Petalo2->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <0.0, -0.0, -30.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo3->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, -60.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo4->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo5->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <0.0, -0.0, -120.0>
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Petalo6->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, -150.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo7->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, 180.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Petalo8->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, 150.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Petalo9->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, 120.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Petalo10->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, 90.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Petalo11->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, 60.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Petalo12->Petalo1
    Petalo1
    texture {
      PetaloTex1
    }
    scale 1.25
    rotate <-0.0, -0.0, 30.0>
    translate  <0.0, -0.0, -0.0>
  }
  texture {
    PetaloTex1_1
  }
  rotate 29.145224*x
  translate  <-0.785313, -35.666562, 152.804423>
}
#declare Tallo = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, -49.629356>, <-1.000000, -1.333333, -49.629356>, <1.000000, -1.333333, -49.629356>, <1.000000, -0.000000, -49.629356>, 
      <-1.000000, -3.071645, 17.644075>, <-1.000000, -4.567863, 17.481188>, <1.000000, -4.567863, 17.481188>, <1.000000, -3.071643, 17.644075>, 
      <-1.000000, -10.065533, 51.712972>, <-1.000000, -11.283748, 51.194946>, <1.000000, -11.283748, 51.194946>, <1.000000, -10.065531, 51.712972>, 
      <-1.000000, -35.511580, 103.054388>, <-1.000000, -36.724221, 102.450937>, <1.000000, -36.724221, 102.450937>, <1.000000, -35.511578, 103.054388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, -49.629356>, <1.000000, 1.333333, -49.629356>, <-1.000000, 1.333330, -49.629356>, <-1.000000, -0.000002, -49.629356>, 
      <1.000000, -3.071643, 17.644075>, <1.000000, -1.575424, 17.806961>, <-1.000000, -1.575427, 17.806961>, <-1.000000, -3.071645, 17.644075>, 
      <1.000000, -10.065531, 51.712972>, <1.000000, -8.847315, 52.230998>, <-1.000000, -8.847318, 52.230998>, <-1.000000, -10.065533, 51.712972>, 
      <1.000000, -35.511578, 103.054388>, <1.000000, -34.298935, 103.657838>, <-1.000000, -34.298938, 103.657838>, <-1.000000, -35.511580, 103.054388>
    }
  }
  translate  <0.316149, 0.0, 49.536957>
}
#declare BezPtch8 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.481044, -67.402256, 0.497603>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <1.518956, -67.402256, 0.532319>, 
      <-1.517977, 20.527027, -16.968995>, <-0.517977, 20.527027, -17.466597>, <0.482023, 20.527027, -17.466597>, <1.482023, 20.527027, -16.934278>, 
      <-1.468198, 59.400883, -43.470039>, <-0.468198, 59.400883, -43.967642>, <0.531802, 59.400883, -43.967642>, <1.531802, 59.400883, -43.435322>, 
      <-0.108355, 83.672947, -105.401881>, <-0.142962, 83.708623, -105.401881>, <-0.141892, 83.708623, -105.401881>, <-0.105146, 83.708623, -105.401881>
    }
  }
  scale <4.0, 1.0, 1.0>
  rotate <78.714996, 1.765044, -30.0>
  translate  <12.352714, 9.635906, 67.080242>
}
#declare PlantaMA1 = union {
  object { BezPtch3 }
  object { // BezPtch4->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, -60.0>
    translate  0.0*z
  }
  object { // BezPtch5->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, -120.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // BezPtch6->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // BezPtch7->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, 120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { Flor1 }
  object { Tallo }
  object { BezPtch8 }
  texture {
    HojasTex1
  }
  scale 0.01
  translate  <-9.824219, -21.186504, -8.002458>
}
#declare Pasto1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.429497, -67.402256, 1.977393>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.353579, -67.402256, 1.815408>, 
      <-2.466429, 19.981616, 0.327710>, <-0.517977, 19.981616, -1.649684>, <0.482023, 19.981616, -1.649684>, <2.316646, 19.981616, 0.165724>, 
      <-2.416650, 57.764651, -3.811491>, <-0.468198, 57.764651, -5.788884>, <0.531802, 57.764651, -5.788884>, <2.366425, 57.764651, -3.973477>, 
      <-0.108355, 79.855072, -10.500398>, <-0.142962, 79.890748, -10.500398>, <-0.141892, 79.890748, -10.500398>, <-0.105146, 79.890748, -10.500398>
    }
  }
  texture {
    HojasTex1
  }
  scale <0.005, 0.0075, 0.005>
  rotate <90.0, 0.0, -90.0>
  translate  <-0.216219, 0.0, 0.502788>
}
#declare Grupo7 = union {
  object { // Pasto2->Pasto1
    Pasto1
    rotate <-0.0, -0.0, -50.0>
    translate  <0.122764, -0.165633, 0.0>
  }
  object { // Pasto3->Pasto1
    Pasto1
    rotate <-0.0, -0.0, -100.0>
    translate  <0.442349, 0.252388, 0.0>
  }
  object { // Pasto4->Pasto1
    Pasto1
    rotate <-0.0, -0.0, -150.0>
    translate  <0.086545, 0.120321, 0.0>
  }
  object { // Pasto5->Pasto1
    Pasto1
    rotate <-0.0, -0.0, 160.0>
    translate  <0.262156, 0.082412, 0.0>
  }
  object { // Pasto6->Pasto1
    Pasto1
    rotate <-0.0, -0.0, 110.0>
    translate  <0.430637, 0.380848, 0.0>
  }
  object { // Pasto7->Pasto1
    Pasto1
    rotate <-0.0, -0.0, 60.0>
    translate  <0.110484, 0.644113, 0.0>
  }
  object { // Pasto8->Pasto1
    Pasto1
    rotate <-0.0, -0.0, 10.0>
    translate  <0.44069, 0.435185, 0.0>
  }
  object { // Pasto9->Pasto1
    Pasto1
    rotate <-0.0, -0.0, -40.0>
    translate  <0.17883, 0.123289, 0.0>
  }
  object { // Pasto10->Pasto1
    Pasto1
    rotate <-0.0, -0.0, -90.0>
    translate  <0.120132, -0.131615, 0.0>
  }
  object { // Pasto11->Pasto1
    Pasto1
    rotate <-0.0, -0.0, -140.0>
    translate  <0.103737, -0.113602, 0.0>
  }
  texture {
    HojasTex1
  }
}
#declare Pasto12 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.308070, -67.933887, 1.764368>, <-0.481044, -67.933887, 0.531631>, <0.518956, -67.933887, 0.531631>, <2.254090, -67.933887, 1.707193>, 
      <-2.345003, 19.449985, 0.114684>, <-0.517977, 19.449985, -1.118053>, <0.482023, 19.449985, -1.118053>, <2.217157, 19.449985, 0.057509>, 
      <-2.295224, 131.114936, -9.071170>, <-0.468198, 131.114936, -10.303907>, <0.531802, 131.114936, -10.303907>, <2.266937, 131.114936, -9.128345>, 
      <-0.108355, 39.451131, -28.044215>, <-0.142962, 39.486807, -28.044215>, <-0.141892, 39.486807, -28.044215>, <-0.105146, 39.486807, -28.044215>
    }
  }
  scale <0.005, 0.0075, 0.005>
  rotate <90.0, 0.0, -90.0>
  translate  <0.341741, 0.070195, 0.502788>
}
#declare Grupo13 = union {
  object { Pasto12 }
  object { // Pasto13->Pasto12
    Pasto12
    rotate <0.0, -0.0, -50.0>
    translate  <0.398559, 0.481031, -0.0>
  }
  object { // Pasto14->Pasto12
    Pasto12
    rotate <0.0, -0.0, -100.0>
    translate  <0.674446, 0.367098, -0.0>
  }
  object { // Pasto15->Pasto12
    Pasto12
    rotate <0.0, -0.0, -150.0>
    translate  <0.843542, 0.063108, -0.0>
  }
  object { // Pasto16->Pasto12
    Pasto12
    rotate <0.0, -0.0, 160.0>
    translate  <0.977144, -0.437135, -0.0>
  }
  object { // Pasto17->Pasto12
    Pasto12
    rotate <0.0, -0.0, 110.0>
    translate  <0.920458, -0.739505, -0.0>
  }
  object { // Pasto18->Pasto12
    Pasto12
    rotate <0.0, -0.0, 60.0>
    translate  <0.159198, -0.740674, -0.0>
  }
  object { // Pasto19->Pasto12
    Pasto12
    rotate <0.0, -0.0, 10.0>
    translate  <-0.278429, -0.404794, -0.0>
  }
  object { // Pasto20->Pasto12
    Pasto12
    rotate <0.0, -0.0, -40.0>
    translate  <-0.233411, 0.445349, -0.0>
  }
  object { // Pasto21->Pasto12
    Pasto12
    rotate <0.0, -0.0, -90.0>
    translate  <0.328692, 0.645072, -0.0>
  }
  object { // Pasto22->Pasto12
    Pasto12
    rotate <0.0, -0.0, -140.0>
    translate  <1.279235, 0.216155, 0.037536>
  }
  texture {
    HojasTex1
  }
  scale 1.15
  translate  <-0.583767, -0.033842, 0.0>
}
#declare Pasto23 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.383650, -67.402256, 1.824965>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.421562, -67.402256, 1.624167>, 
      <-2.420583, 16.791831, -7.267550>, <-0.517977, 16.791831, -9.092515>, <0.482023, 16.791831, -9.092515>, <2.384629, 16.791831, -7.468348>, 
      <-2.370804, 57.764651, -3.963920>, <-0.468198, 57.764651, -5.788884>, <0.531802, 57.764651, -5.788884>, <2.434408, 57.764651, -4.164718>, 
      <-0.108355, 79.855072, -10.500398>, <-0.142962, 79.890748, -10.500398>, <-0.141892, 79.890748, -10.500398>, <-0.105146, 79.890748, -10.500398>
    }
  }
  scale <0.007, 0.009, 0.005>
  rotate <90.0, 0.0, -90.0>
  translate  <-0.287027, 0.265572, 0.604861>
}
#declare Pasto24 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.338923, -67.402256, 1.443469>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.505669, -67.402256, 1.548053>, 
      <-2.375856, -16.700909, 35.413049>, <-0.517977, -16.700909, 33.969580>, <0.482023, -16.700909, 33.969580>, <2.468736, -16.700909, 35.517633>, 
      <-2.326076, 57.764651, -4.345415>, <-0.468198, 57.764651, -5.788884>, <0.531802, 57.764651, -5.788884>, <2.518515, 57.764651, -4.240831>, 
      <-0.108355, 79.855072, -10.500398>, <-0.142962, 79.890748, -10.500398>, <-0.141892, 79.890748, -10.500398>, <-0.105146, 79.890748, -10.500398>
    }
  }
  scale <0.0065, 0.0085, 0.005>
  rotate <90.0, -0.0, -169.933853>
  translate  <-0.597848, -0.290645, 0.580409>
}
#declare Pasto25 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.484353, -68.465518, 1.289176>, <-0.481044, -68.465518, -0.531631>, <0.518956, -68.465518, -0.531631>, <2.450317, -68.465518, 1.345987>, 
      <-1.776750, 8.817369, -21.838644>, <0.226559, 8.817369, -23.659451>, <1.226559, 8.817369, -23.659451>, <3.157919, 8.817369, -21.781833>, 
      <-2.471506, 56.701389, -4.499708>, <-0.468198, 56.701389, -6.320515>, <0.531802, 56.701389, -6.320515>, <2.463163, 56.701389, -4.442897>, 
      <1.939117, 80.918333, -40.538169>, <1.904511, 80.954009, -40.538169>, <1.905581, 80.954009, -40.538169>, <1.942327, 80.954009, -40.538169>
    }
  }
  scale <0.008, 0.011, 0.005>
  rotate <85.492119, 6.023574, -140.23732>
  translate  <-0.334315, -0.622726, 0.736767>
}
#declare Pasto26 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.486458, -67.402256, 1.412980>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.505654, -67.402256, 1.387458>, 
      <-2.523391, -52.320173, -11.400951>, <-0.517977, -52.320173, -12.813930>, <0.482023, -52.320173, -12.813930>, <2.468721, -52.320173, -11.426473>, 
      <-2.473612, 35.436157, 28.585205>, <-0.468198, 35.436157, 27.172225>, <0.531802, 35.436157, 27.172225>, <2.518501, 35.436157, 28.559683>, 
      <-0.108355, 79.855072, -10.500398>, <-0.142962, 79.890748, -10.500398>, <-0.141892, 79.890748, -10.500398>, <-0.105146, 79.890748, -10.500398>
    }
  }
  scale <0.008, 0.009, 0.006>
  rotate <90.0, 0.0, 170.0>
  translate  <-0.634512, -0.077779, 0.608635>
}
#declare Pasto27 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.437806, -67.933887, 0.759089>, <-0.481044, -67.933887, -1.063262>, <0.518956, -67.933887, -1.063262>, <2.523781, -67.933887, 0.580455>, 
      <-2.474739, 23.703031, 0.704298>, <-0.517977, 23.703031, -1.118053>, <0.482023, 23.703031, -1.118053>, <2.486848, 23.703031, 0.525663>, 
      <-2.424960, 49.258558, -15.662411>, <-0.468198, 49.258558, -17.484762>, <0.531802, 49.258558, -17.484762>, <2.536627, 49.258558, -15.841046>, 
      <-0.108355, 83.576487, -78.017510>, <-0.142962, 83.612163, -78.017510>, <-0.141892, 83.612163, -78.017510>, <-0.105146, 83.612163, -78.017510>
    }
  }
  scale <0.008, 0.01, 0.007>
  rotate <90.0, 0.0, 152.166138>
  translate  <-0.52253, -0.42313, 0.672143>
}
#declare Pasto28 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.481298, -67.402256, 1.690677>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.442981, -67.402256, 1.535546>, 
      <-2.518231, 19.981616, 0.040994>, <-0.517977, 19.981616, -1.649684>, <0.482023, 19.981616, -1.649684>, <2.406048, 19.981616, -0.114137>, 
      <-2.468452, 59.891174, -30.679747>, <-0.468198, 59.891174, -32.370424>, <0.531802, 59.891174, -32.370424>, <2.455827, 59.891174, -30.834878>, 
      <-0.108355, 80.386702, -51.967601>, <-0.142962, 80.422379, -51.967601>, <-0.141892, 80.422379, -51.967601>, <-0.105146, 80.422379, -51.967601>
    }
  }
  scale <0.006, 0.008, 0.006>
  rotate <74.022133, -0.037558, 179.86879>
  translate  <0.565052, -0.55728, 0.53807>
}
#declare Pasto29 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.455511, -67.402256, 1.409604>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.533882, -67.402256, 1.575051>, 
      <-2.492444, 20.513247, 4.012967>, <-0.517977, 20.513247, 2.603363>, <0.482023, 20.513247, 2.603363>, <2.496949, 20.513247, 4.178414>, 
      <-2.442665, 60.422805, -29.365928>, <-0.468198, 60.422805, -30.775532>, <0.531802, 60.422805, -30.775532>, <2.546728, 60.422805, -29.200481>, 
      <-0.108355, 82.513226, -35.487046>, <-0.142962, 82.548902, -35.487046>, <-0.141892, 82.548902, -35.487046>, <-0.105146, 82.548902, -35.487046>
    }
  }
  scale <0.0065, 0.0098, 0.0065>
  rotate <89.491554, 0.185055, 19.99918>
  translate  <-0.503861, -0.121842, 0.652867>
}
#declare Pasto30 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.499164, -68.465518, 2.440721>, <-0.481044, -68.465518, 1.063262>, <0.518956, -68.465518, 1.063262>, <2.474229, -68.465518, 2.337174>, 
      <-2.536097, 18.918354, 0.791037>, <-0.517977, 18.918354, -0.586422>, <0.482023, 18.918354, -0.586422>, <2.437296, 18.918354, 0.687491>, 
      <-2.486317, 124.506328, 0.312080>, <-0.468198, 124.506328, -1.065379>, <0.531802, 124.506328, -1.065379>, <2.487075, 124.506328, 0.208533>, 
      <-0.108355, 61.779624, -42.929877>, <-0.142962, 61.815301, -42.929877>, <-0.141892, 61.815301, -42.929877>, <-0.105146, 61.815301, -42.929877>
    }
  }
  scale <0.008, 0.0105, 0.008>
  rotate <90.0, -0.0, -147.554138>
  translate  <0.32225, -0.699655, 0.721538>
}
#declare Pasto31 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.389861, -62.085948, -0.006386>, <-0.481044, -62.085948, -1.063262>, <0.518956, -62.085948, -1.063262>, <2.567592, -62.085948, 0.168148>, 
      <-2.426794, 14.133677, 8.444915>, <-0.517977, 14.133677, 7.388040>, <0.482023, 14.133677, 7.388040>, <2.530659, 14.133677, 8.619450>, 
      <-2.377015, 52.979974, -15.364625>, <-0.468198, 52.979974, -16.421500>, <0.531802, 52.979974, -16.421500>, <2.580438, 52.979974, -15.190091>, 
      <-0.108355, 75.070394, -21.133014>, <-0.142962, 75.106071, -21.133014>, <-0.141892, 75.106071, -21.133014>, <-0.105146, 75.106071, -21.133014>
    }
  }
  scale <0.007, 0.0103, 0.007>
  rotate <90.0, -0.0, -161.689423>
  translate  <0.046457, -0.705601, 0.643917>
}
#declare Pasto32 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.383650, -67.402256, 1.240925>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.421562, -67.402256, 0.957075>, 
      <-2.420583, 19.981616, -0.408758>, <-0.517977, 19.981616, -1.649684>, <0.482023, 19.981616, -1.649684>, <2.384629, 19.981616, -0.692609>, 
      <-2.370804, 57.764651, -4.547959>, <-0.468198, 57.764651, -5.788884>, <0.531802, 57.764651, -5.788884>, <2.434408, 57.764651, -4.831809>, 
      <-0.108355, 79.855072, -10.500398>, <-0.142962, 79.890748, -10.500398>, <-0.141892, 79.890748, -10.500398>, <-0.105146, 79.890748, -10.500398>
    }
  }
  scale <0.009, 0.0095, 0.007>
  rotate <83.586952, 9.711835, -130.545364>
  translate  <-0.51609, 0.048832, 0.620063>
}
#declare Pasto33 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.381463, -67.402256, 1.698161>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.419375, -67.402256, 1.832924>, 
      <-2.418396, 16.791831, -18.558600>, <-0.517977, 16.791831, -20.256762>, <0.482023, 16.791831, -20.256762>, <2.382442, 16.791831, -18.423837>, 
      <-2.368616, 57.764651, -4.090723>, <-0.468198, 57.764651, -5.788884>, <0.531802, 57.764651, -5.788884>, <2.432221, 57.764651, -3.955960>, 
      <-0.108355, 79.855072, -10.500398>, <-0.142962, 79.890748, -10.500398>, <-0.141892, 79.890748, -10.500398>, <-0.105146, 79.890748, -10.500398>
    }
  }
  scale <0.008, 0.0112, 0.008>
  rotate <90.0, -0.0, 130.525696>
  translate  <-0.201069, -0.477608, 0.749764>
}
#declare Pasto34 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.470611, -67.402256, 1.639411>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <2.584643, -67.402256, 1.521886>, 
      <-2.507544, 19.981616, -4.794950>, <-0.517977, 19.981616, -6.434361>, <0.482023, 19.981616, -6.434361>, <2.547710, 19.981616, -4.912475>, 
      <-2.457764, 57.764651, -8.934151>, <-0.468198, 57.764651, -10.573562>, <0.531802, 57.764651, -10.573562>, <2.597490, 57.764651, -9.051676>, 
      <-0.108355, 79.855072, -15.285076>, <-0.142962, 79.890748, -15.285076>, <-0.141892, 79.890748, -15.285076>, <-0.105146, 79.890748, -15.285076>
    }
  }
  scale <0.0075, 0.0115, 0.008>
  rotate <85.882362, 0.731889, -169.281036>
  translate  <-0.416326, -0.151888, 0.764084>
}
#declare GrupoML1 = union {
  object { Pasto23 }
  object { Pasto24 }
  object { Pasto25 }
  object { Pasto26 }
  object { Pasto27 }
  object { Pasto28 }
  object { Pasto29 }
  object { Pasto30 }
  object { Pasto31 }
  object { Pasto32 }
  object { Pasto33 }
  object { Pasto34 }
  texture {
    HojasTex1
  }
}
#declare PlantaMB1 = union {
  object { Pasto1 }
  object { Grupo7 }
  object { Grupo13 }
  object { // Grupo14->Grupo7
    Grupo7
    rotate -50.0*z
    translate  0.02*x
  }
  object { // Grupo15->Grupo7
    Grupo7
    rotate -100.0*z
    translate  0.04*x
  }
  object { // Grupo16->Grupo7
    Grupo7
    rotate -150.0*z
    translate  0.06*x
  }
  object { // Grupo17->Grupo7
    Grupo7
    rotate 160.0*z
    translate  0.08*x
  }
  object { // Grupo18->Grupo7
    Grupo7
    rotate 110.0*z
    translate  0.1*x
  }
  object { // Grupo19->Grupo7
    Grupo7
    rotate 60.0*z
    translate  <0.12, -0.098024, 0.0>
  }
  object { // Grupo20->Grupo7
    Grupo7
    rotate 10.0*z
    translate  0.14*x
  }
  object { // Grupo21->Grupo7
    Grupo7
    rotate -40.0*z
    translate  0.16*x
  }
  object { // Grupo22->Grupo7
    Grupo7
    rotate -90.0*z
    translate  <0.149368, 0.085771, 0.0>
  }
  object { // Grupo23->Grupo7
    Grupo7
    rotate -140.0*z
    translate  <0.2, 0.067391, 0.0>
  }
  object { GrupoML1 }
  object { // GrupoML2->Grupo-L1
    GrupoML1
    rotate -120.0*z
    translate  <0.0341, -0.091212, 0.0>
  }
  scale 2.0
  translate  <-6.827888, -24.791458, -8.540876>
}
#declare Tallo1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.009477, 0.000045, 0.000000>, <-0.009468, -0.012535, 0.000000>, <0.009448, -0.012466, 0.000000>, <0.009507, 0.000147, 0.000000>, 
      <-0.007458, 0.000045, 0.231274>, <-0.007449, -0.012535, 0.231274>, <0.011466, -0.012466, 0.231274>, <0.011525, 0.000147, 0.231274>, 
      <0.012724, 0.000045, 0.604904>, <0.012733, -0.012535, 0.604904>, <0.031648, -0.012466, 0.604904>, <0.031708, 0.000147, 0.604904>, 
      <0.051071, 0.000045, 0.842805>, <0.051080, -0.012535, 0.842805>, <0.069743, -0.012466, 0.839780>, <0.069803, 0.000147, 0.839780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.009507, 0.000147, 0.000000>, <0.009566, 0.012759, 0.000000>, <-0.009486, 0.012626, 0.000000>, <-0.009477, 0.000045, 0.000000>, 
      <0.011525, 0.000147, 0.231274>, <0.011585, 0.012759, 0.231274>, <-0.007467, 0.012626, 0.231274>, <-0.007458, 0.000045, 0.231274>, 
      <0.031708, 0.000147, 0.604904>, <0.031767, 0.012759, 0.604904>, <0.012715, 0.012626, 0.604904>, <0.012724, 0.000045, 0.604904>, 
      <0.069803, 0.000147, 0.839780>, <0.069862, 0.012759, 0.839780>, <0.051063, 0.012626, 0.842805>, <0.051071, 0.000045, 0.842805>
    }
  }
  texture {
    HojasTex3
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.100000, -3.000000>, <0.120000, 1.925996, -2.434057>, <0.349180, 1.939255, -1.545498>, <0.400000, 1.519987, -1.113525>, 
      <-0.120000, 1.925996, -2.434057>, <0.000000, 1.751992, -1.868115>, <0.229180, 1.909255, -1.575498>, <0.280000, 1.489987, -1.143525>, 
      <-0.348871, 1.939243, -1.545472>, <-0.228871, 1.909243, -1.575472>, <0.000000, 1.419987, -1.213525>, <0.127279, 1.419987, -1.213525>, 
      <-0.400000, 1.519987, -1.113525>, <-0.280000, 1.489987, -1.143525>, <-0.127279, 1.419987, -1.213525>, <0.000000, 1.419987, -1.213525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.100000, -3.000000>, <0.000000, 1.895996, -2.464057>, <0.000000, 1.825526, -1.618975>, <0.000000, 1.419987, -1.213525>, 
      <0.000000, 2.100000, -3.000000>, <0.120000, 1.721992, -1.898115>, <0.127279, 1.825526, -1.618975>, <0.127279, 1.419987, -1.213525>, 
      <0.000000, 2.100000, -3.000000>, <0.120000, 1.721992, -1.898115>, <0.229180, 1.909255, -1.575498>, <0.280000, 1.489987, -1.143525>, 
      <0.000000, 2.100000, -3.000000>, <0.120000, 1.925996, -2.434057>, <0.349180, 1.939255, -1.545498>, <0.400000, 1.519987, -1.113525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.100000, -3.000000>, <-0.120000, 1.925996, -2.434057>, <-0.348871, 1.939243, -1.545472>, <-0.400000, 1.519987, -1.113525>, 
      <0.000000, 2.100000, -3.000000>, <-0.120000, 1.721992, -1.898115>, <-0.228871, 1.909243, -1.575472>, <-0.280000, 1.489987, -1.143525>, 
      <0.000000, 2.100000, -3.000000>, <-0.120000, 1.721992, -1.898115>, <-0.127279, 1.825526, -1.618975>, <-0.127279, 1.419987, -1.213525>, 
      <0.000000, 2.100000, -3.000000>, <0.000000, 1.895996, -2.464057>, <0.000000, 1.825526, -1.618975>, <0.000000, 1.419987, -1.213525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.179999, 0.279281>, <0.125408, -1.183134, 0.282529>, <0.280000, -1.194000, 0.363784>, <0.400000, -1.200000, 0.400000>, 
      <0.000000, -0.281521, 0.238127>, <0.125408, -0.284657, 0.241375>, <0.347295, -0.263088, 0.333902>, <0.467295, -0.269089, 0.370118>, 
      <0.000000, 0.783932, -0.577609>, <0.127279, 0.783932, -0.577609>, <0.358555, 0.841910, -0.475810>, <0.478555, 0.871910, -0.445810>, 
      <0.000000, 1.419987, -1.213525>, <0.127279, 1.419987, -1.213525>, <0.280000, 1.489987, -1.143525>, <0.400000, 1.519987, -1.113525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.400000, -1.179999, 0.379281>, <-0.280000, -1.179999, 0.349281>, <-0.123613, -1.176908, 0.276080>, <0.000000, -1.179999, 0.279281>, 
      <-0.466700, -0.257324, 0.349663>, <-0.346700, -0.257324, 0.319663>, <-0.123613, -0.278431, 0.234926>, <0.000000, -0.281521, 0.238127>, 
      <-0.478332, 0.877661, -0.451757>, <-0.358332, 0.847661, -0.481757>, <-0.127279, 0.783932, -0.577609>, <0.000000, 0.783932, -0.577609>, 
      <-0.400000, 1.519987, -1.113525>, <-0.280000, 1.489987, -1.143525>, <-0.127279, 1.419987, -1.213525>, <0.000000, 1.419987, -1.213525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.579980, -1.030312>, <0.036742, -2.579980, -1.030312>, <0.070000, -2.614980, -0.995312>, <0.100000, -2.629980, -0.980312>, 
      <0.000000, -2.159986, -0.637434>, <0.036742, -2.159986, -0.637434>, <0.160000, -2.185986, -0.581218>, <0.190000, -2.200986, -0.566218>, 
      <0.000000, -1.754504, 0.305595>, <0.125408, -1.757639, 0.308843>, <0.236545, -1.795123, 0.383080>, <0.356545, -1.801123, 0.419296>, 
      <0.000000, -1.179999, 0.279281>, <0.125408, -1.183134, 0.282529>, <0.280000, -1.194000, 0.363784>, <0.400000, -1.200000, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.100000, -2.629980, -0.980312>, <-0.070000, -2.614980, -0.995312>, <-0.036742, -2.579980, -1.030312>, <0.000000, -2.579980, -1.030312>, 
      <-0.190000, -2.194986, -0.572434>, <-0.160000, -2.179986, -0.587434>, <-0.036742, -2.159986, -0.637434>, <0.000000, -2.159986, -0.637434>, 
      <-0.356540, -1.781184, 0.398579>, <-0.236540, -1.781184, 0.368579>, <-0.123613, -1.751413, 0.302394>, <0.000000, -1.754504, 0.305595>, 
      <-0.400000, -1.179999, 0.379281>, <-0.280000, -1.179999, 0.349281>, <-0.123613, -1.176908, 0.276080>, <0.000000, -1.179999, 0.279281>
    }
  }
  scale 0.04
  translate  <0.0, 0.114938, 0.040517>
}
#declare GMHojas1 = union {
  object { sPatchObj1 }
  object { // sPatchObj2->sPatchObj1
    sPatchObj1
    rotate -120.0*z
    translate  -0.0*x
  }
  object { // sPatchObj3->sPatchObj1
    sPatchObj1
    rotate 120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    HojasTex3
  }
  rotate 4.0*y
  translate  <0.019899, 0.0, 0.497513>
}
#declare sPatchObj10 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.625000, -2.750000>, <0.251558, 1.625000, -2.750000>, <0.358052, 2.179026, -2.695179>, <0.500000, 2.250000, -2.500000>, 
      <-0.251558, 1.625000, -2.750000>, <0.000000, 1.625000, -2.750000>, <0.208052, 2.141526, -2.657679>, <0.350000, 2.212500, -2.462500>, 
      <-0.358052, 2.179026, -2.695179>, <-0.208052, 2.141526, -2.657679>, <0.000000, 2.125000, -2.375000>, <0.159099, 2.125000, -2.375000>, 
      <-0.500000, 2.250000, -2.500000>, <-0.350000, 2.212500, -2.462500>, <-0.159099, 2.125000, -2.375000>, <0.000000, 2.125000, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.625000, -2.750000>, <0.000000, 1.775000, -2.637500>, <0.000000, 2.071122, -2.554592>, <0.000000, 2.125000, -2.375000>, 
      <0.000000, 1.625000, -2.750000>, <0.251558, 1.775000, -2.637500>, <0.159099, 2.071122, -2.554592>, <0.159099, 2.125000, -2.375000>, 
      <0.000000, 1.625000, -2.750000>, <0.251558, 1.775000, -2.637500>, <0.208052, 2.141526, -2.657679>, <0.350000, 2.212500, -2.462500>, 
      <0.000000, 1.625000, -2.750000>, <0.251558, 1.625000, -2.750000>, <0.358052, 2.179026, -2.695179>, <0.500000, 2.250000, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.625000, -2.750000>, <-0.251558, 1.625000, -2.750000>, <-0.358052, 2.179026, -2.695179>, <-0.500000, 2.250000, -2.500000>, 
      <0.000000, 1.625000, -2.750000>, <-0.251558, 1.775000, -2.637500>, <-0.208052, 2.141526, -2.657679>, <-0.350000, 2.212500, -2.462500>, 
      <0.000000, 1.625000, -2.750000>, <-0.251558, 1.775000, -2.637500>, <-0.159099, 2.071122, -2.554592>, <-0.159099, 2.125000, -2.375000>, 
      <0.000000, 1.625000, -2.750000>, <0.000000, 1.775000, -2.637500>, <0.000000, 2.071122, -2.554592>, <0.000000, 2.125000, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.000000, -1.500000>, <0.304652, 2.000000, -1.500000>, <0.700000, 2.087500, -1.412500>, <1.000000, 2.125000, -1.375000>, 
      <0.000000, 2.181357, -1.693448>, <0.304652, 2.181357, -1.693448>, <0.669433, 2.316750, -1.702883>, <0.969433, 2.354250, -1.665383>, 
      <0.000000, 2.201195, -2.121018>, <0.159099, 2.201195, -2.121018>, <0.559477, 2.317239, -2.174469>, <0.709477, 2.354738, -2.211969>, 
      <0.000000, 2.125000, -2.375000>, <0.159099, 2.125000, -2.375000>, <0.350000, 2.212500, -2.462500>, <0.500000, 2.250000, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, 2.125000, -1.375000>, <-0.700000, 2.087500, -1.412500>, <-0.304652, 2.000000, -1.500000>, <0.000000, 2.000000, -1.500000>, 
      <-0.969433, 2.354250, -1.665383>, <-0.669433, 2.316750, -1.702883>, <-0.304652, 2.181357, -1.693448>, <0.000000, 2.181357, -1.693448>, 
      <-0.709477, 2.354738, -2.211969>, <-0.559477, 2.317239, -2.174469>, <-0.159099, 2.201195, -2.121018>, <0.000000, 2.201195, -2.121018>, 
      <-0.500000, 2.250000, -2.500000>, <-0.350000, 2.212500, -2.462500>, <-0.159099, 2.125000, -2.375000>, <0.000000, 2.125000, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.250000, -0.375000>, <0.240117, 0.250000, -0.375000>, <0.525000, 0.337500, -0.200000>, <0.750000, 0.375000, -0.125000>, 
      <0.000000, 0.850110, -0.546460>, <0.240117, 0.850110, -0.546460>, <0.611517, 0.957539, -0.373034>, <0.836517, 0.995039, -0.298034>, 
      <0.000000, 1.573136, -1.044678>, <0.304652, 1.573136, -1.044678>, <0.753481, 1.686396, -0.904435>, <1.053481, 1.723896, -0.866935>, 
      <0.000000, 2.000000, -1.500000>, <0.304652, 2.000000, -1.500000>, <0.700000, 2.087500, -1.412500>, <1.000000, 2.125000, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750000, 0.375000, -0.125000>, <-0.525000, 0.337500, -0.200000>, <-0.240117, 0.250000, -0.375000>, <0.000000, 0.250000, -0.375000>, 
      <-0.836517, 0.995039, -0.298034>, <-0.611517, 0.957539, -0.373034>, <-0.240117, 0.850110, -0.546460>, <0.000000, 0.850110, -0.546460>, 
      <-1.053481, 1.723896, -0.866935>, <-0.753481, 1.686396, -0.904435>, <-0.304652, 1.573136, -1.044678>, <0.000000, 1.573136, -1.044678>, 
      <-1.000000, 2.125000, -1.375000>, <-0.700000, 2.087500, -1.412500>, <-0.304652, 2.000000, -1.500000>, <0.000000, 2.000000, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.250000, 0.000000>, <0.083853, -3.250000, 0.000000>, <0.175000, -3.250000, 0.087500>, <0.250000, -3.250000, 0.125000>, 
      <0.000000, -2.200000, -0.112500>, <0.083853, -2.200000, -0.112500>, <0.325000, -2.162500, 0.012500>, <0.400000, -2.162500, 0.050000>, 
      <0.000000, -0.765378, -0.084892>, <0.240117, -0.765378, -0.084892>, <0.378431, -0.712913, 0.093139>, <0.603431, -0.675414, 0.168139>, 
      <0.000000, 0.250000, -0.375000>, <0.240117, 0.250000, -0.375000>, <0.525000, 0.337500, -0.200000>, <0.750000, 0.375000, -0.125000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.250000, -3.250000, 0.125000>, <-0.175000, -3.250000, 0.087500>, <-0.083853, -3.250000, 0.000000>, <0.000000, -3.250000, 0.000000>, 
      <-0.400000, -2.162500, 0.050000>, <-0.325000, -2.162500, 0.012500>, <-0.083853, -2.200000, -0.112500>, <0.000000, -2.200000, -0.112500>, 
      <-0.603431, -0.675414, 0.168139>, <-0.378431, -0.712913, 0.093139>, <-0.240117, -0.765378, -0.084892>, <0.000000, -0.765378, -0.084892>, 
      <-0.750000, 0.375000, -0.125000>, <-0.525000, 0.337500, -0.200000>, <-0.240117, 0.250000, -0.375000>, <0.000000, 0.250000, -0.375000>
    }
  }
  texture {
    PetaloTex1
  }
  scale 0.04
  rotate 88.879028*x
  translate  <0.0, 0.009004, 0.13055>
}
#declare Flor = union {
  object { // sPatchObj5->sPatchObj10
    sPatchObj10
    rotate -72.0*z
    translate  -0.0*x
  }
  object { // sPatchObj6->sPatchObj10
    sPatchObj10
    rotate -144.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // sPatchObj8->sPatchObj10
    sPatchObj10
    rotate 144.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // sPatchObj9->sPatchObj10
    sPatchObj10
    rotate 72.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { sPatchObj10 }
  torus { // Torus21
    0.008, 0.005  rotate -x*90
    texture {
      CentroTex1
    }
    scale 1.666667
    rotate <-178.056, 6.334844, -179.574081>
    translate  <-0.002767, 0.000223, 0.194828>
  }
  rotate <-0.0, 83.759949, 15.18092>
  translate  <0.233628, 0.00017, 0.956161>
}
#declare Tallito = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.440131, -0.259971, 0.000000>, <3.502774, 6.011608, 0.000000>, <10.841293, 12.110489, 0.000000>, <19.663215, 7.027764, 0.000000>, 
      <0.440131, -0.259971, -0.272899>, <3.502774, 6.011608, -0.272899>, <10.841293, 12.110489, -0.272899>, <19.663215, 7.027764, -0.272899>, 
      <0.240223, -0.152215, -0.500000>, <3.318338, 6.144114, -0.500000>, <10.789780, 12.331670, -0.500000>, <19.719250, 7.247843, -0.500000>, 
      <0.000000, -0.022727, -0.500000>, <3.096707, 6.303343, -0.500000>, <10.727879, 12.597457, -0.500000>, <19.786585, 7.512305, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.022727, 0.500000>, <3.096707, 6.303343, 0.500000>, <10.727879, 12.597457, 0.500000>, <19.786585, 7.512305, 0.500000>, 
      <0.240223, -0.152215, 0.500000>, <3.318338, 6.144114, 0.500000>, <10.789780, 12.331670, 0.500000>, <19.719250, 7.247843, 0.500000>, 
      <0.440131, -0.259971, 0.272899>, <3.502774, 6.011608, 0.272899>, <10.841293, 12.110489, 0.272899>, <19.663215, 7.027764, 0.272899>, 
      <0.440131, -0.259971, 0.000000>, <3.502774, 6.011608, 0.000000>, <10.841293, 12.110489, 0.000000>, <19.663215, 7.027764, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.440131, 0.214518, 0.000000>, <2.690640, 6.595078, 0.000000>, <10.614464, 13.084424, 0.000000>, <19.909954, 7.996846, 0.000000>, 
      <-0.440131, 0.214518, 0.272899>, <2.690640, 6.595078, 0.272899>, <10.614464, 13.084424, 0.272899>, <19.909954, 7.996846, 0.272899>, 
      <-0.240223, 0.106761, 0.500000>, <2.875076, 6.462571, 0.500000>, <10.665977, 12.863243, 0.500000>, <19.853920, 7.776767, 0.500000>, 
      <0.000000, -0.022727, 0.500000>, <3.096707, 6.303343, 0.500000>, <10.727879, 12.597457, 0.500000>, <19.786585, 7.512305, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.440131, 0.214518, 0.000000>, <-0.440131, 0.214518, -0.272899>, <-0.240223, 0.106761, -0.500000>, <0.000000, -0.022727, -0.500000>, 
      <2.690640, 6.595078, 0.000000>, <2.690640, 6.595078, -0.272899>, <2.875076, 6.462571, -0.500000>, <3.096707, 6.303343, -0.500000>, 
      <10.614464, 13.084424, 0.000000>, <10.614464, 13.084424, -0.272899>, <10.665977, 12.863243, -0.500000>, <10.727879, 12.597457, -0.500000>, 
      <19.909954, 7.996846, 0.000000>, <19.909954, 7.996846, -0.272899>, <19.853920, 7.776767, -0.500000>, <19.786585, 7.512305, -0.500000>
    }
  }
  texture {
    HojasTex3
  }
  scale 0.01
  rotate <90.0, -13.968977, -0.0>
  translate  <0.06026, 0.000545, 0.83656>
}
#declare PlantaMC1 = union {
  object { Tallo1 }
  object { GMHojas1 }
  object { // GMHojas2->G-Hojas1
    GMHojas1
    rotate 3.0*y
    translate  <0.016268, 0.0, 0.341775>
  }
  object { Flor }
  object { Tallito }
  scale 3.0
  rotate -45.0*z
  translate  <-13.941451, -29.519593, -8.33177>
}
#declare sPatchObj11 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225000, -0.225000, 0.400000>, <-0.189662, -0.401688, 0.329325>, <-0.102500, -0.557500, 0.120000>, <-0.050000, -0.700000, 0.000000>, 
      <-0.225000, -0.225000, 0.400000>, <-0.230565, -0.422791, 0.324947>, <-0.192500, -0.437500, 0.225000>, <-0.140000, -0.580000, 0.105000>, 
      <-0.225000, -0.225000, 0.400000>, <-0.230565, -0.422791, 0.324947>, <-0.247828, -0.439180, 0.308412>, <-0.285328, -0.461680, 0.293412>, 
      <-0.225000, -0.225000, 0.400000>, <-0.265903, -0.246102, 0.395622>, <-0.312500, -0.277500, 0.365000>, <-0.350000, -0.300000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.250000, 0.300000, 0.400000>, <-0.311652, 0.300447, 0.395112>, <-0.390000, 0.300000, 0.365000>, <-0.450000, 0.300000, 0.350000>, 
      <-0.250000, 0.300000, 0.400000>, <-0.284928, 0.441702, 0.364571>, <-0.340063, 0.466457, 0.340031>, <-0.400063, 0.466457, 0.325031>, 
      <-0.250000, 0.300000, 0.400000>, <-0.284928, 0.441702, 0.364571>, <-0.230000, 0.460000, 0.305000>, <-0.170000, 0.580000, 0.245000>, 
      <-0.250000, 0.300000, 0.400000>, <-0.223276, 0.441255, 0.369458>, <-0.110000, 0.580000, 0.260000>, <-0.050000, 0.700000, 0.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.250000, 0.300000, 0.400000>, <-0.278671, 0.148452, 0.432767>, <-0.253788, -0.081060, 0.457576>, <-0.225000, -0.225000, 0.400000>, 
      <-0.311652, 0.300447, 0.395112>, <-0.340323, 0.148899, 0.427879>, <-0.294691, -0.102162, 0.453198>, <-0.265903, -0.246102, 0.395622>, 
      <-0.390000, 0.300000, 0.365000>, <-0.441903, 0.126990, 0.390952>, <-0.376955, -0.116364, 0.421398>, <-0.312500, -0.277500, 0.365000>, 
      <-0.450000, 0.300000, 0.350000>, <-0.501903, 0.126990, 0.375951>, <-0.414455, -0.138864, 0.406398>, <-0.350000, -0.300000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.050046, 0.297103, 0.381709>, <-0.050032, 0.417972, 0.327196>, <-0.050014, 0.579131, 0.254513>, <-0.050000, 0.700000, 0.200000>, 
      <-0.050046, 0.297103, 0.381709>, <-0.110275, 0.417972, 0.327196>, <-0.110014, 0.459131, 0.314513>, <-0.110000, 0.580000, 0.260000>, 
      <-0.050046, 0.297103, 0.381709>, <-0.110275, 0.417972, 0.327196>, <-0.163223, 0.440820, 0.374219>, <-0.223276, 0.441255, 0.369458>, 
      <-0.050046, 0.297103, 0.381709>, <-0.110289, 0.297103, 0.381709>, <-0.189947, 0.299565, 0.404761>, <-0.250000, 0.300000, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.050046, 0.297103, 0.381709>, <-0.050032, 0.417972, 0.327196>, <-0.050014, 0.579131, 0.254513>, <-0.050000, 0.700000, 0.200000>, 
      <-0.110289, 0.297103, 0.381709>, <-0.110275, 0.417972, 0.327196>, <-0.170014, 0.459131, 0.299513>, <-0.170000, 0.580000, 0.245000>, 
      <-0.189947, 0.299565, 0.404761>, <-0.251599, 0.300012, 0.399873>, <-0.340063, 0.466457, 0.340031>, <-0.400063, 0.466457, 0.325031>, 
      <-0.250000, 0.300000, 0.400000>, <-0.311652, 0.300447, 0.395112>, <-0.390000, 0.300000, 0.365000>, <-0.450000, 0.300000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.049962, -0.145207, 0.382113>, <-0.049953, -0.333945, 0.309861>, <-0.049989, -0.533562, 0.114634>, <-0.050000, -0.700000, 0.000000>, 
      <-0.049962, -0.145207, 0.382113>, <-0.107912, -0.333945, 0.309861>, <-0.102489, -0.391062, 0.234634>, <-0.102500, -0.557500, 0.120000>, 
      <-0.049962, -0.145207, 0.382113>, <-0.107912, -0.333945, 0.309861>, <-0.138385, -0.375234, 0.334813>, <-0.189662, -0.401688, 0.329325>, 
      <-0.049962, -0.145207, 0.382113>, <-0.107921, -0.145207, 0.382113>, <-0.173723, -0.198546, 0.405488>, <-0.225000, -0.225000, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.049962, -0.145207, 0.382113>, <-0.107921, -0.145207, 0.382113>, <-0.173723, -0.198546, 0.405488>, <-0.225000, -0.225000, 0.400000>, 
      <-0.049968, -0.021284, 0.429553>, <-0.107927, -0.021284, 0.429553>, <-0.202511, -0.054606, 0.463064>, <-0.253788, -0.081060, 0.457576>, 
      <-0.050021, 0.164410, 0.381830>, <-0.110264, 0.164410, 0.381830>, <-0.218618, 0.148017, 0.437528>, <-0.278671, 0.148452, 0.432767>, 
      <-0.050046, 0.297103, 0.381709>, <-0.110289, 0.297103, 0.381709>, <-0.189947, 0.299565, 0.404761>, <-0.250000, 0.300000, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.049962, -0.145207, 0.382113>, <-0.049953, -0.333945, 0.309861>, <-0.049989, -0.533562, 0.114634>, <-0.050000, -0.700000, 0.000000>, 
      <-0.107921, -0.145207, 0.382113>, <-0.107912, -0.333945, 0.309861>, <-0.139989, -0.413562, 0.219634>, <-0.140000, -0.580000, 0.105000>, 
      <-0.173723, -0.198546, 0.405488>, <-0.214626, -0.219648, 0.401110>, <-0.247828, -0.439180, 0.308412>, <-0.285328, -0.461680, 0.293412>, 
      <-0.225000, -0.225000, 0.400000>, <-0.265903, -0.246102, 0.395622>, <-0.312500, -0.277500, 0.365000>, <-0.350000, -0.300000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, -0.225000, 0.400000>, <0.114267, -0.403667, 0.328533>, <0.010000, -0.557500, 0.120000>, <-0.050000, -0.700000, 0.000000>, 
      <0.150000, -0.225000, 0.400000>, <0.155841, -0.423471, 0.324425>, <0.107500, -0.437500, 0.225000>, <0.047500, -0.580000, 0.105000>, 
      <0.150000, -0.225000, 0.400000>, <0.155841, -0.423471, 0.324425>, <0.171486, -0.442536, 0.307238>, <0.208986, -0.465036, 0.292237>, 
      <0.150000, -0.225000, 0.400000>, <0.191575, -0.244804, 0.395892>, <0.237500, -0.277500, 0.365000>, <0.275000, -0.300000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, -0.225000, 0.400000>, <0.114267, -0.403667, 0.328533>, <0.010000, -0.557500, 0.120000>, <-0.050000, -0.700000, 0.000000>, 
      <0.150000, -0.225000, 0.400000>, <0.055986, -0.375906, 0.334292>, <0.010011, -0.391062, 0.234634>, <-0.049989, -0.533562, 0.114634>, 
      <0.150000, -0.225000, 0.400000>, <0.055986, -0.375906, 0.334292>, <0.014858, -0.333945, 0.309861>, <-0.049953, -0.333945, 0.309861>, 
      <0.150000, -0.225000, 0.400000>, <0.091720, -0.197239, 0.405759>, <0.014849, -0.145207, 0.382113>, <-0.049962, -0.145207, 0.382113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, -0.225000, 0.400000>, <0.191575, -0.244804, 0.395892>, <0.237500, -0.277500, 0.365000>, <0.275000, -0.300000, 0.350000>, 
      <0.091720, -0.197239, 0.405759>, <0.133294, -0.217042, 0.401651>, <0.171486, -0.442536, 0.307238>, <0.208986, -0.465036, 0.292237>, 
      <0.014849, -0.145207, 0.382113>, <0.014858, -0.333945, 0.309861>, <0.047511, -0.413562, 0.219634>, <0.047500, -0.580000, 0.105000>, 
      <-0.049962, -0.145207, 0.382113>, <-0.049953, -0.333945, 0.309861>, <-0.049989, -0.533562, 0.114634>, <-0.050000, -0.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, -0.225000, 0.400000>, <0.114267, -0.403667, 0.328533>, <0.010000, -0.557500, 0.120000>, <-0.050000, -0.700000, 0.000000>, 
      <0.091720, -0.197239, 0.405759>, <0.055986, -0.375906, 0.334292>, <-0.042500, -0.415000, 0.240000>, <-0.102500, -0.557500, 0.120000>, 
      <0.014849, -0.145207, 0.382113>, <-0.043110, -0.145207, 0.382113>, <-0.138385, -0.375234, 0.334813>, <-0.189662, -0.401688, 0.329325>, 
      <-0.049962, -0.145207, 0.382113>, <-0.107921, -0.145207, 0.382113>, <-0.173723, -0.198546, 0.405488>, <-0.225000, -0.225000, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, 0.300000, 0.400000>, <0.182566, 0.149384, 0.432566>, <0.178756, -0.081223, 0.457511>, <0.150000, -0.225000, 0.400000>, 
      <0.211652, 0.300447, 0.395113>, <0.244217, 0.149830, 0.427679>, <0.220330, -0.101027, 0.453402>, <0.191575, -0.244804, 0.395892>, 
      <0.290000, 0.300000, 0.365000>, <0.345506, 0.129211, 0.390618>, <0.301572, -0.117319, 0.421063>, <0.237500, -0.277500, 0.365000>, 
      <0.350000, 0.300000, 0.350000>, <0.405506, 0.129211, 0.375618>, <0.339072, -0.139819, 0.406063>, <0.275000, -0.300000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, 0.300000, 0.400000>, <0.119612, 0.440546, 0.369612>, <0.010000, 0.580000, 0.260000>, <-0.050000, 0.700000, 0.200000>, 
      <0.150000, 0.300000, 0.400000>, <0.181263, 0.440992, 0.364725>, <0.130000, 0.460000, 0.305000>, <0.070000, 0.580000, 0.245000>, 
      <0.150000, 0.300000, 0.400000>, <0.181263, 0.440992, 0.364725>, <0.236278, 0.465300, 0.340205>, <0.296278, 0.465300, 0.325205>, 
      <0.150000, 0.300000, 0.400000>, <0.211652, 0.300447, 0.395113>, <0.290000, 0.300000, 0.365000>, <0.350000, 0.300000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, 0.300000, 0.400000>, <0.119612, 0.440546, 0.369612>, <0.010000, 0.580000, 0.260000>, <-0.050000, 0.700000, 0.200000>, 
      <0.150000, 0.300000, 0.400000>, <0.059531, 0.440111, 0.374374>, <0.009986, 0.459131, 0.314513>, <-0.050014, 0.579131, 0.254513>, 
      <0.150000, 0.300000, 0.400000>, <0.059531, 0.440111, 0.374374>, <0.010238, 0.417972, 0.327196>, <-0.050032, 0.417972, 0.327196>, 
      <0.150000, 0.300000, 0.400000>, <0.089920, 0.299565, 0.404762>, <0.010224, 0.297103, 0.381709>, <-0.050046, 0.297103, 0.381709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, 0.300000, 0.400000>, <0.211652, 0.300447, 0.395113>, <0.290000, 0.300000, 0.365000>, <0.350000, 0.300000, 0.350000>, 
      <0.089920, 0.299565, 0.404762>, <0.151571, 0.300011, 0.399875>, <0.236278, 0.465300, 0.340205>, <0.296278, 0.465300, 0.325205>, 
      <0.010224, 0.297103, 0.381709>, <0.010238, 0.417972, 0.327196>, <0.069986, 0.459131, 0.299513>, <0.070000, 0.580000, 0.245000>, 
      <-0.050046, 0.297103, 0.381709>, <-0.050032, 0.417972, 0.327196>, <-0.050014, 0.579131, 0.254513>, <-0.050000, 0.700000, 0.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, 0.300000, 0.400000>, <0.182566, 0.149384, 0.432566>, <0.178756, -0.081223, 0.457511>, <0.150000, -0.225000, 0.400000>, 
      <0.089920, 0.299565, 0.404762>, <0.122485, 0.148949, 0.437328>, <0.120475, -0.053462, 0.463270>, <0.091720, -0.197239, 0.405759>, 
      <0.010224, 0.297103, 0.381709>, <0.010250, 0.164410, 0.381830>, <0.014843, -0.021284, 0.429553>, <0.014849, -0.145207, 0.382113>, 
      <-0.050046, 0.297103, 0.381709>, <-0.050021, 0.164410, 0.381830>, <-0.049968, -0.021284, 0.429553>, <-0.049962, -0.145207, 0.382113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.150000, 0.300000, 0.400000>, <0.089920, 0.299565, 0.404762>, <0.010224, 0.297103, 0.381709>, <-0.050046, 0.297103, 0.381709>, 
      <0.119612, 0.440546, 0.369612>, <0.059531, 0.440111, 0.374374>, <-0.050019, 0.297103, 0.381709>, <-0.110289, 0.297103, 0.381709>, 
      <0.010000, 0.580000, 0.260000>, <-0.050000, 0.460000, 0.320000>, <-0.163223, 0.440820, 0.374219>, <-0.189947, 0.299565, 0.404761>, 
      <-0.050000, 0.700000, 0.200000>, <-0.110000, 0.580000, 0.260000>, <-0.223276, 0.441255, 0.369458>, <-0.250000, 0.300000, 0.400000>
    }
  }
  scale 0.15
  translate  <0.007695, 0.11, -0.000453>
}
#declare Hojas = union {
  object { sPatchObj11 }
  object { // sPatchObj12->sPatchObj11
    sPatchObj11
    rotate -60.0*z
    translate  0.0*x
  }
  object { // sPatchObj13->sPatchObj11
    sPatchObj11
    rotate -120.0*z
    translate  0.0*y
  }
  object { // sPatchObj14->sPatchObj11
    sPatchObj11
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // sPatchObj15->sPatchObj11
    sPatchObj11
    rotate 120.0*z
    translate  0.0*x
  }
  object { // sPatchObj16->sPatchObj11
    sPatchObj11
    rotate 60.0*z
    translate  -0.0*x
  }
  texture {
    HojasTex2
  }
}
#declare PlantaMD1 = union {
  object { Hojas }
  sphere { // Centro
    <0,0,0>,1
    texture {
      CentroTex2
    }
    scale <0.06, 0.06, 0.02>
    translate  0.05*z
  }
  scale 6.0
  rotate <10.315038, -0.0, -0.0>
  translate  <-10.623232, -19.570089, -7.072948>
}
#declare BezPtch9 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.481044, -67.402256, 0.497603>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <1.518956, -67.402256, 0.532319>, 
      <-1.517977, 20.527027, -16.968995>, <-0.517977, 20.527027, -17.466597>, <0.482023, 20.527027, -17.466597>, <1.482023, 20.527027, -16.934278>, 
      <-1.468198, 59.400883, -43.470039>, <-0.468198, 59.400883, -43.967642>, <0.531802, 59.400883, -43.967642>, <1.531802, 59.400883, -43.435322>, 
      <-0.108355, 83.672947, -105.401881>, <-0.142962, 83.708623, -105.401881>, <-0.141892, 83.708623, -105.401881>, <-0.105146, 83.708623, -105.401881>
    }
  }
  scale <4.0, 1.0, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <3.387052, 0.008233, 68.143007>
}
#declare Flor2 = union {
  sphere { // Petalo13
    <0,0,0>,1
    texture {
      PetaloTex2
    }
    scale <10.0, 3.0, 0.1>
    rotate -8.0*y
    translate  <12.537103, 0.267964, 1.159211>
  }
  sphere { // Centro2
    <0,0,0>,1
    texture {
      CentroTex1_1
    }
    scale <10.0, 10.0, 2.5>
  }
  object { // Petalo14->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <0.0, -0.0, -30.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo15->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, -60.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo16->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo17->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <0.0, -0.0, -120.0>
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Petalo18->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, -150.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Petalo19->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, 180.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Petalo20->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, 150.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Petalo21->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, 120.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Petalo22->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, 90.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Petalo23->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, 60.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Petalo24->Petalo1
    Petalo1
    texture {
      PetaloTex2
    }
    scale 1.25
    rotate <-0.0, -0.0, 30.0>
    translate  <0.0, -0.0, -0.0>
  }
  texture {
    PetaloTex1_1
  }
  rotate 29.145224*x
  translate  <-0.785313, -35.666562, 152.804423>
}
#declare Tallo2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, -49.629356>, <-1.000000, -1.333333, -49.629356>, <1.000000, -1.333333, -49.629356>, <1.000000, -0.000000, -49.629356>, 
      <-1.000000, -3.071645, 17.644075>, <-1.000000, -4.567863, 17.481188>, <1.000000, -4.567863, 17.481188>, <1.000000, -3.071643, 17.644075>, 
      <-1.000000, -10.065533, 51.712972>, <-1.000000, -11.283748, 51.194946>, <1.000000, -11.283748, 51.194946>, <1.000000, -10.065531, 51.712972>, 
      <-1.000000, -35.511580, 103.054388>, <-1.000000, -36.724221, 102.450937>, <1.000000, -36.724221, 102.450937>, <1.000000, -35.511578, 103.054388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, -49.629356>, <1.000000, 1.333333, -49.629356>, <-1.000000, 1.333330, -49.629356>, <-1.000000, -0.000002, -49.629356>, 
      <1.000000, -3.071643, 17.644075>, <1.000000, -1.575424, 17.806961>, <-1.000000, -1.575427, 17.806961>, <-1.000000, -3.071645, 17.644075>, 
      <1.000000, -10.065531, 51.712972>, <1.000000, -8.847315, 52.230998>, <-1.000000, -8.847318, 52.230998>, <-1.000000, -10.065533, 51.712972>, 
      <1.000000, -35.511578, 103.054388>, <1.000000, -34.298935, 103.657838>, <-1.000000, -34.298938, 103.657838>, <-1.000000, -35.511580, 103.054388>
    }
  }
  translate  <0.316149, 0.0, 49.536957>
}
#declare BezPtch14 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.481044, -67.402256, 0.497603>, <-0.481044, -67.402256, 0.000000>, <0.518956, -67.402256, 0.000000>, <1.518956, -67.402256, 0.532319>, 
      <-1.517977, 20.527027, -16.968995>, <-0.517977, 20.527027, -17.466597>, <0.482023, 20.527027, -17.466597>, <1.482023, 20.527027, -16.934278>, 
      <-1.468198, 59.400883, -43.470039>, <-0.468198, 59.400883, -43.967642>, <0.531802, 59.400883, -43.967642>, <1.531802, 59.400883, -43.435322>, 
      <-0.108355, 83.672947, -105.401881>, <-0.142962, 83.708623, -105.401881>, <-0.141892, 83.708623, -105.401881>, <-0.105146, 83.708623, -105.401881>
    }
  }
  scale <4.0, 1.0, 1.0>
  rotate <78.714996, 1.765044, -30.0>
  translate  <12.352714, 9.635906, 67.080242>
}
#declare PlantaMA8 = union {
  object { BezPtch9 }
  object { // BezPtch10->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, -60.0>
    translate  0.0*z
  }
  object { // BezPtch11->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, -120.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // BezPtch12->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // BezPtch13->BezPtch3
    BezPtch3
    rotate <0.0, -0.0, 120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { Flor2 }
  object { Tallo2 }
  object { BezPtch14 }
  texture {
    HojasTex1
  }
  scale 0.01
  translate  <-15.182027, -29.074818, -8.002458>
}
#declare PlantaMB3 = object {
  object { // PlantaMB3->Planta-B1
    PlantaMB1
    rotate -4.356941*z
    translate  <-1.250281, -3.016669, 0.015731>
  }
}


#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.100000, 4.100000>, <0.000000, 0.160000, 3.200000>, <0.000000, 0.252592, 2.000751>, <0.000000, 0.300000, 1.100000>, 
      <0.000000, 0.100000, 4.100000>, <0.120000, 0.070000, 2.300000>, <0.192094, 0.252592, 2.000751>, <0.192094, 0.300000, 1.100000>, 
      <0.000000, 0.100000, 4.100000>, <0.120000, 0.070000, 2.300000>, <0.184777, 0.021417, 2.004617>, <0.280000, -0.050000, 1.100000>, 
      <0.000000, 0.100000, 4.100000>, <0.120000, 0.010000, 3.200000>, <0.304777, -0.128583, 2.004617>, <0.400000, -0.200000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.100000, 4.100000>, <0.000000, 0.160000, 3.200000>, <0.000000, 0.252592, 2.000751>, <0.000000, 0.300000, 1.100000>, 
      <0.000000, 0.100000, 4.100000>, <-0.120000, 0.070000, 2.300000>, <-0.192094, 0.252592, 2.000751>, <-0.192094, 0.300000, 1.100000>, 
      <0.000000, 0.100000, 4.100000>, <-0.120000, 0.070000, 2.300000>, <-0.184777, 0.021417, 2.004617>, <-0.280000, -0.050000, 1.100000>, 
      <0.000000, 0.100000, 4.100000>, <-0.120000, 0.010000, 3.200000>, <-0.304777, -0.128583, 2.004617>, <-0.400000, -0.200000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.100000, 4.100000>, <-0.120000, 0.010000, 3.200000>, <-0.304777, -0.128583, 2.004617>, <-0.400000, -0.200000, 1.100000>, 
      <0.120000, 0.010000, 3.200000>, <0.000000, -0.080000, 2.300000>, <-0.184777, 0.021417, 2.004617>, <-0.280000, -0.050000, 1.100000>, 
      <0.304777, -0.128583, 2.004617>, <0.184777, 0.021417, 2.004617>, <0.000000, 0.300000, 1.100000>, <-0.192094, 0.300000, 1.100000>, 
      <0.400000, -0.200000, 1.100000>, <0.280000, -0.050000, 1.100000>, <0.192094, 0.300000, 1.100000>, <0.000000, 0.300000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.300000, 0.300000>, <0.192094, 0.300000, 0.300000>, <0.280000, -0.050000, 0.300000>, <0.400000, -0.200000, 0.300000>, 
      <0.000000, 0.323881, 0.538809>, <0.192094, 0.323881, 0.538809>, <0.326567, -0.084925, 0.532834>, <0.446567, -0.234925, 0.532834>, 
      <0.000000, 0.312614, 0.860332>, <0.192094, 0.312614, 0.860332>, <0.305047, -0.068785, 0.862051>, <0.425047, -0.218785, 0.862051>, 
      <0.000000, 0.300000, 1.100000>, <0.192094, 0.300000, 1.100000>, <0.280000, -0.050000, 1.100000>, <0.400000, -0.200000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.400000, -0.200000, 0.300000>, <-0.280000, -0.050000, 0.300000>, <-0.192094, 0.300000, 0.300000>, <0.000000, 0.300000, 0.300000>, 
      <-0.446567, -0.234925, 0.532834>, <-0.326567, -0.084925, 0.532834>, <-0.192094, 0.323881, 0.538809>, <0.000000, 0.323881, 0.538809>, 
      <-0.425047, -0.218785, 0.862051>, <-0.305047, -0.068785, 0.862051>, <-0.192094, 0.312614, 0.860332>, <0.000000, 0.312614, 0.860332>, 
      <-0.400000, -0.200000, 1.100000>, <-0.280000, -0.050000, 1.100000>, <-0.192094, 0.300000, 1.100000>, <0.000000, 0.300000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.100000, -0.900000>, <-0.120000, 0.010000, -0.540000>, <-0.324329, -0.143247, -0.078356>, <-0.400000, -0.200000, 0.300000>, 
      <0.000000, 0.100000, -0.900000>, <-0.120000, 0.070000, -0.180000>, <-0.204329, 0.006753, -0.078356>, <-0.280000, -0.050000, 0.300000>, 
      <0.000000, 0.100000, -0.900000>, <-0.120000, 0.070000, -0.180000>, <-0.192094, 0.263685, -0.063155>, <-0.192094, 0.300000, 0.300000>, 
      <0.000000, 0.100000, -0.900000>, <0.000000, 0.160000, -0.540000>, <0.000000, 0.263685, -0.063155>, <0.000000, 0.300000, 0.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.100000, -0.900000>, <0.000000, 0.160000, -0.540000>, <0.000000, 0.263685, -0.063155>, <0.000000, 0.300000, 0.300000>, 
      <0.000000, 0.100000, -0.900000>, <0.120000, 0.070000, -0.180000>, <0.192094, 0.263685, -0.063155>, <0.192094, 0.300000, 0.300000>, 
      <0.000000, 0.100000, -0.900000>, <0.120000, 0.070000, -0.180000>, <0.204329, 0.006753, -0.078356>, <0.280000, -0.050000, 0.300000>, 
      <0.000000, 0.100000, -0.900000>, <0.120000, 0.010000, -0.540000>, <0.324329, -0.143247, -0.078356>, <0.400000, -0.200000, 0.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.100000, -0.900000>, <0.120000, 0.010000, -0.540000>, <0.324329, -0.143247, -0.078356>, <0.400000, -0.200000, 0.300000>, 
      <-0.120000, 0.010000, -0.540000>, <0.000000, -0.080000, -0.180000>, <0.204329, 0.006753, -0.078356>, <0.280000, -0.050000, 0.300000>, 
      <-0.324329, -0.143247, -0.078356>, <-0.204329, 0.006753, -0.078356>, <0.000000, 0.300000, 0.300000>, <0.192094, 0.300000, 0.300000>, 
      <-0.400000, -0.200000, 0.300000>, <-0.280000, -0.050000, 0.300000>, <-0.192094, 0.300000, 0.300000>, <0.000000, 0.300000, 0.300000>
    }
  }
  rotate <-70.0, -0.0, -90.0>
  translate  <0.8, 0.0, 0.398419>
}




//
// ********  OBJECTS  *******
//



#declare PiedraMA3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.058838, -4.896043, -2.659978>, <-2.310269, -5.907369, -0.874477>, <-0.394636, -6.665339, -2.349934>, <0.221595, -6.665339, -2.014686>, 
      <-5.255399, -4.682525, -0.200831>, <-4.454401, -5.377822, -0.087507>, <-0.723064, -5.649532, -1.121138>, <0.162152, -5.361517, -0.707429>, 
      <-4.315353, -1.301810, -1.521376>, <-3.215789, -3.696550, -0.383768>, <-0.918735, -3.284118, -0.601729>, <0.077172, -3.208955, -0.040877>, 
      <-4.320912, -0.512988, -1.238807>, <-3.375892, -1.870876, 0.278162>, <-0.876693, -1.707914, -0.926599>, <0.128469, -1.648706, -0.220837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.320912, -0.512988, -1.238807>, <-3.375892, -1.870876, 0.278162>, <-0.876693, -1.707914, -0.926599>, <0.128469, -1.648706, -0.220837>, 
      <-4.326471, 0.275834, -0.956237>, <-3.535994, -0.045202, 0.940092>, <-0.834651, -0.131711, -1.251468>, <0.179767, -0.088456, -0.400797>, 
      <-4.787852, 1.117828, -0.815613>, <-3.326241, 0.902148, 1.313436>, <-0.513943, 1.188401, 1.565870>, <0.401686, 1.270336, 1.230543>, 
      <-4.147750, 2.030089, -2.547578>, <-3.535994, 2.524915, 0.716917>, <-0.798146, 2.578835, -1.568521>, <0.216272, 2.484476, -1.153802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.221595, -6.665339, -2.014686>, <0.837827, -6.665339, -1.679438>, <3.596286, -5.368391, -2.388421>, <3.971860, -5.321024, -2.456190>, 
      <0.162152, -5.361517, -0.707429>, <1.047367, -5.073502, -0.293721>, <4.759123, -6.373143, 0.912343>, <5.190718, -5.844335, 0.604059>, 
      <0.077172, -3.208955, -0.040877>, <1.073078, -3.133792, 0.519976>, <2.094734, -3.086425, -0.605563>, <4.222355, -1.299554, -0.465614>, 
      <0.128469, -1.648706, -0.220837>, <1.133632, -1.589497, 0.484925>, <2.144460, -1.400028, -0.077844>, <4.361384, -0.604343, -0.267167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.128469, -1.648706, -0.220837>, <1.133632, -1.589497, 0.484925>, <2.144460, -1.400028, -0.077844>, <4.361384, -0.604343, -0.267167>, 
      <0.179767, -0.088456, -0.400797>, <1.194185, -0.045202, 0.449875>, <2.194185, 0.286368, 0.449875>, <4.500413, 0.090868, -0.068720>, 
      <0.401686, 1.270336, 1.230543>, <1.317315, 1.352271, 0.895217>, <2.230691, 1.328452, 1.825770>, <4.385404, 0.996882, -0.313508>, 
      <0.216272, 2.484476, -1.153802>, <1.230691, 2.390116, -0.739083>, <2.403939, 2.524915, 0.218224>, <4.159352, 2.105164, -0.219531>
    }
  }
  texture {
    PiedraTex2
  }
  scale <3.0, 2.0, 1.5>
  rotate <-60.0, 0.0, 180.0>
  translate  <28.166083, 5.187636, -14.45401>
}
union { // Piedras
  object { PiedraMA1 }
  object { // PiedraMA2->Piedra-A1
    PiedraMA1
    scale <0.5, 0.4, 0.5>
    rotate <-0.0, 0.0, -70.0>
    translate  <1.185252, -18.167037, -3.826895>
  }
  object { // PiedraMA4->Piedra-A1
    PiedraMA1
    scale 0.8
    translate  <26.45867, 25.156807, -3.696468>
  }
  object { PiedraMA3 }
  object { // PiedraMA5->Piedra-A1
    PiedraMA1
    texture {
      PiedraTex2
    }
    rotate -120.0*z
    translate  <51.944336, -3.90028, -2.41074>
  }
  translate  <-0.765429, 0.0, 0.0>
}


union { // Plantas
  object { PlantaMA1 }
  object { PlantaMB1 }
  object { // PlantaMA3->Planta-A1
    PlantaMA1
    translate  <15.260608, 3.318031, -0.313662>
  }
  object { // PlantaMA4->Planta-A1
    PlantaMA1
    rotate <0.0, 0.0, 43.738342>
    translate  <-6.802635, 2.652464, -0.310079>
  }
  object { PlantaMC1 }
  object { // PlantaMC2->Planta-C1
    PlantaMC1
    rotate <-0.0, -0.0, -120.0>
    translate  <4.036318, -57.375311, 0.0>
  }
  object { PlantaMD1 }
  object { // PlantaMD2->Planta-D1
    PlantaMD1
    rotate <-0.0, -0.0, -0.0>
    translate  <-1.892427, -5.452203, -0.418639>
  }
  object { // PlantaMD3->Planta-D1
    PlantaMD1
    rotate <0.177576, -0.0, -0.0>
    translate  <1.688989, 2.662759, 0.81325>
  }
  object { // PlantaMA2->Planta-A8
    PlantaMA8
    rotate <0.0, 0.0, -0.0>
    translate  <18.464925, 10.511749, 0.0>
  }
  object { // PlantaMA5->Planta-A8
    PlantaMA8
    rotate <0.0, 0.0, -0.0>
    translate  <5.404517, 6.370508, 0.0>
  }
  object { // PlantaMA6->Planta-A8
    PlantaMA8
    rotate <0.0, 0.0, -0.0>
    translate  <3.742495, 3.553916, 0.347265>
  }
  object { // PlantaMA7->Planta-A8
    PlantaMA8
    rotate <0.0, 0.0, -0.0>
    translate  <2.321517, 1.004123, 0.0>
  }
  object { PlantaMA8 }
  object { // PlantaMB2->Planta-B3
    PlantaMB3
    rotate <0.0, 0.0, 0.0>
    translate  <-2.006898, -3.356908, 0.0>
  }
  object { PlantaMB3 }
}






object {   // Montana
  height_field {
    gif "C:\MORAY\MAPS\monthf2.gif"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Pasto
  }
  scale <50.0, 30.0, 10.0>
}


union { // CieloMAgua
  plane { // SuperficieAgua
    z,0
    texture {
      AguaTex2
    }
    hollow
    translate  -9.0*z
  }
  plane { // FondoAgua
    z,0
    texture {
      FondoAguaTex
    }
    hollow
    translate  -9.6*z
  }
  sphere { // CieloMFondo
    <0,0,0>,1
    texture {
      CieloFondoTex
    }
    hollow
    scale 15000.0
  }
}


#include "C:\MORAY FOR WINDOWS\POVScn\arbola_limbs.inc"

#declare _Limb1_Ref = object {
  _Limb1
}
#declare _Limb1B1_1_Ref = object {
  _Limb1B1_1
  rotate <0.0, 50.0, 15.0>
  translate  4.0*z
}
#declare _Secund1_Limb1B1_1B1_1_Ref = object {
  _Secund1_Limb1B1_1B1_1
  rotate <0.0, 74.988297, 15.87496>
  translate  <2.21983, 0.5948, 5.92836>
}
#declare _Limb1B1_1B1_2_Ref = object {
  _Limb1B1_1B1_2
  rotate <0.0, 80.986061, 16.042801>
  translate  <5.00693, 1.38741, 6.70541>
}
#declare _Limb1B1_1B1_2B1_1_Ref = object {
  _Limb1B1_1B1_2B1_1
  rotate <0.0, 83.039299, 66.527046>
  translate  <5.00693, 1.38741, 6.70541>
}
#declare _Limb1B1_1B1_2B2_1_Ref = object {
  _Limb1B1_1B1_2B2_1
  rotate <0.0, 130.965027, 17.61639>
  translate  <5.38661, 1.49659, 6.76808>
}
#declare _Limb1B1_1B1_2B3_1_Ref = object {
  _Limb1B1_1B1_2B3_1
  rotate <0.0, 31.016899, 13.73653>
  translate  <5.95612, 1.66035, 6.86209>
}
#declare _Limb1B1_1B1_2B4_1_Ref = object {
  _Limb1B1_1B1_2B4_1
  rotate <0.0, 85.398293, 325.84668>
  translate  <6.14596, 1.71494, 6.89342>
}
#declare _Limb1B1_1B1_2B5_1_Ref = object {
  _Limb1B1_1B1_2B5_1
  rotate <0.0, 80.986061, 16.042801>
  translate  <6.43071, 1.79683, 6.94042>
}
#declare _Limb1B1_1B1_1B1_1_Ref = object {
  _Limb1B1_1B1_1B1_1
  rotate <0.0, 124.968483, 17.35763>
  translate  <3.42757, 0.93827, 6.26508>
}
#declare _Limb1B1_1B1_1B2_1_Ref = object {
  _Limb1B1_1B1_1B2_1
  rotate <0.0, 58.763931, 323.876862>
  translate  <3.89209, 1.07037, 6.39459>
}
#declare _Limb1B1_1B1_1B3_1_Ref = object {
  _Limb1B1_1B1_1B3_1
  rotate <0.0, 56.355549, 67.490448>
  translate  <4.0779, 1.12321, 6.4464>
}
#declare _Secund1_Limb1B1_1B2_1_Ref = object {
  _Secund1_Limb1B1_1B2_1
  rotate <0.0, 40.567421, 55.692661>
  translate  <2.21983, 0.5948, 5.92836>
}
#declare _Limb1B1_1B2_2_Ref = object {
  _Limb1B1_1B2_2
  rotate <0.0, 40.6562, 64.91497>
  translate  <3.31949, 2.2064, 8.20729>
}
#declare _Limb1B1_1B2_2B1_1_Ref = object {
  _Limb1B1_1B2_2B1_1
  rotate <0.0, 9.83803, 225.038544>
  translate  <3.31949, 2.2064, 8.20729>
}
#declare _Limb1B1_1B2_2B2_1_Ref = object {
  _Limb1B1_1B2_2B2_1
  rotate <0.0, 63.269699, 123.700607>
  translate  <3.42998, 2.44243, 8.51074>
}
#declare _Limb1B1_1B2_2B3_1_Ref = object {
  _Limb1B1_1B2_2B3_1
  rotate <0.0, 58.298908, 1.04622>
  translate  <3.59571, 2.79647, 8.96592>
}
#declare _Limb1B1_1B2_2B4_1_Ref = object {
  _Limb1B1_1B2_2B4_1
  rotate <0.0, 90.573853, 61.58448>
  translate  <3.65095, 2.91448, 9.11765>
}
#declare _Limb1B1_1B2_2B5_1_Ref = object {
  _Limb1B1_1B2_2B5_1
  rotate <0.0, 40.6562, 64.91497>
  translate  <3.73382, 3.0915, 9.34524>
}
#declare _Limb1B1_1B2_1B1_1_Ref = object {
  _Limb1B1_1B2_1B1_1
  rotate <0.0, 59.243309, 118.624687>
  translate  <2.69635, 1.29316, 6.9159>
}
#declare _Limb1B1_1B2_1B2_1_Ref = object {
  _Limb1B1_1B2_1B2_1
  rotate <0.0, 87.377609, 35.070068>
  translate  <2.87962, 1.56176, 7.29572>
}
#declare _Limb1B1_1B2_1B3_1_Ref = object {
  _Limb1B1_1B2_1B3_1
  rotate <0.0, 24.808241, 315.827393>
  translate  <2.95293, 1.6692, 7.44765>
}
#declare _Secund1_Limb1B1_1B3_1_Ref = object {
  _Secund1_Limb1B1_1B3_1
  rotate <0.0, 42.56686, 334.259583>
  translate  <2.21983, 0.5948, 5.92836>
}
#declare _Limb1B1_1B3_2_Ref = object {
  _Limb1B1_1B3_2
  rotate <0.0, 42.994862, 325.443329>
  translate  <4.04781, -0.28654, 8.13783>
}
#declare _Limb1B1_1B3_2B1_1_Ref = object {
  _Limb1B1_1B3_2B1_1
  rotate <0.0, 92.75071, 331.049866>
  translate  <4.04781, -0.28654, 8.13783>
}
#declare _Limb1B1_1B3_2B2_1_Ref = object {
  _Limb1B1_1B3_2B2_1
  rotate <0.0, 66.196663, 269.29892>
  translate  <4.27245, -0.44126, 8.43039>
}
#declare _Limb1B1_1B3_2B3_1_Ref = object {
  _Limb1B1_1B3_2B3_1
  rotate <0.0, 57.541389, 29.664101>
  translate  <4.60942, -0.67334, 8.86924>
}
#declare _Limb1B1_1B3_2B4_1_Ref = object {
  _Limb1B1_1B3_2B4_1
  rotate <0.0, 8.78089, 185.178543>
  translate  <4.72175, -0.7507, 9.01553>
}
#declare _Limb1B1_1B3_2B5_1_Ref = object {
  _Limb1B1_1B3_2B5_1
  rotate <0.0, 42.994862, 325.443329>
  translate  <4.89023, -0.86675, 9.23495>
}
#declare _Limb1B1_1B3_1B1_1_Ref = object {
  _Limb1B1_1B3_1B1_1
  rotate <0.0, 62.238548, 274.308685>
  translate  <3.01195, 0.21289, 6.8858>
}
#declare _Limb1B1_1B3_1B2_1_Ref = object {
  _Limb1B1_1B3_1B2_1
  rotate <0.0, 22.190861, 73.073936>
  translate  <3.31661, 0.066, 7.25404>
}
#declare _Limb1B1_1B3_1B3_1_Ref = object {
  _Limb1B1_1B3_1B3_1
  rotate <0.0, 88.367149, 357.393921>
  translate  <3.43848, 0.00724, 7.40134>
}
#declare _Punta3_Limb1B1_1B4_1_Ref = object {
  _Punta3_Limb1B1_1B4_1
  rotate <0.0, 64.337128, 353.430969>
  translate  <3.69971, 0.99133, 7.21394>
}
#declare _Limb1B1_1B4_2_Ref = object {
  _Limb1B1_1B4_2
  rotate <0.0, 68.568398, 348.788727>
  translate  <6.38603, 0.68199, 8.51316>
}
#declare _Limb1B1_1B4_2B1_1_Ref = object {
  _Limb1B1_1B4_2B1_1
  rotate <0.0, 105.235481, 23.44298>
  translate  <6.38603, 0.68199, 8.51316>
}
#declare _Limb1B1_1B4_2B2_1_Ref = object {
  _Limb1B1_1B4_2B2_1
  rotate <0.0, 106.011711, 314.995361>
  translate  <6.75127, 0.60959, 8.65932>
}
#declare _Limb1B1_1B4_2B3_1_Ref = object {
  _Limb1B1_1B4_2B3_1
  rotate <0.0, 41.791882, 42.131481>
  translate  <7.29912, 0.501, 8.87855>
}
#declare _Limb1B1_1B4_2B4_1_Ref = object {
  _Limb1B1_1B4_2B4_1
  rotate <0.0, 42.901642, 295.087494>
  translate  <7.48174, 0.46481, 8.95163>
}
#declare _Limb1B1_1B4_2B5_1_Ref = object {
  _Limb1B1_1B4_2B5_1
  rotate <0.0, 68.568398, 348.788727>
  translate  <7.75567, 0.41051, 9.06125>
}
#declare _Limb1B1_1B4_1B1_1_Ref = object {
  _Limb1B1_1B4_1B1_1
  rotate <0.0, 101.552811, 319.130432>
  translate  <4.86378, 0.85728, 7.77694>
}
#declare _Limb1B1_1B4_1B2_1_Ref = object {
  _Limb1B1_1B4_1B2_1
  rotate <0.0, 18.43548, 317.889618>
  translate  <5.3115, 0.80573, 7.99347>
}
#declare _Limb1B1_1B4_1B3_1_Ref = object {
  _Limb1B1_1B4_1B3_1
  rotate <0.0, 85.025261, 41.053909>
  translate  <5.49059, 0.7851, 8.08009>
}
#declare _Punta2_Limb1B1_1B5_1_Ref = object {
  _Punta2_Limb1B1_1B5_1
  rotate <0.0, 61.887009, 36.023129>
  translate  <3.69971, 0.99133, 7.21394>
}
#declare _Limb1B1_1B5_2_Ref = object {
  _Limb1B1_1B5_2
  rotate <0.0, 65.8293, 41.06366>
  translate  <5.83979, 2.54751, 8.62757>
}
#declare _Limb1B1_1B5_2B1_1_Ref = object {
  _Limb1B1_1B5_2B1_1
  rotate <0.0, 38.617619, 96.520416>
  translate  <5.83979, 2.54751, 8.62757>
}
#declare _Limb1B1_1B5_2B2_1_Ref = object {
  _Limb1B1_1B5_2B2_1
  rotate <0.0, 101.87767, 76.538887>
  translate  <6.11494, 2.78724, 8.79136>
}
#declare _Limb1B1_1B5_2B3_1_Ref = object {
  _Limb1B1_1B5_2B3_1
  rotate <0.0, 42.928001, 344.566223>
  translate  <6.52767, 3.14682, 9.03703>
}
#declare _Limb1B1_1B5_2B4_1_Ref = object {
  _Limb1B1_1B5_2B4_1
  rotate <0.0, 104.770111, 8.94636>
  translate  <6.66524, 3.26668, 9.11892>
}
#declare _Limb1B1_1B5_2B5_1_Ref = object {
  _Limb1B1_1B5_2B5_1
  rotate <0.0, 65.8293, 41.06366>
  translate  <6.87161, 3.44647, 9.24176>
}
#declare _Limb1B1_1B5_1B1_1_Ref = object {
  _Limb1B1_1B5_1B1_1
  rotate <0.0, 97.514168, 72.359848>
  translate  <4.62708, 1.66568, 7.82651>
}
#declare _Limb1B1_1B5_1B2_1_Ref = object {
  _Limb1B1_1B5_1B2_1
  rotate <0.0, 85.92849, 349.858093>
  translate  <4.98376, 1.92504, 8.06212>
}
#declare _Limb1B1_1B5_1B3_1_Ref = object {
  _Limb1B1_1B5_1B3_1
  rotate <0.0, 14.43353, 68.020416>
  translate  <5.12643, 2.02879, 8.15636>
}
#declare _Punta1_Limb1B1_1B6_1_Ref = object {
  _Punta1_Limb1B1_1B6_1
  rotate <0.0, 38.009029, 14.32485>
  translate  <3.69971, 0.99133, 7.21394>
}
#declare _Limb1B1_1B6_2_Ref = object {
  _Limb1B1_1B6_2
  rotate <0.0, 32.015591, 13.83438>
  translate  <5.48963, 1.44841, 9.57768>
}
#declare _Limb1B1_1B6_2B1_1_Ref = object {
  _Limb1B1_1B6_2B1_1
  rotate <0.0, 58.362572, 309.85733>
  translate  <5.48963, 1.44841, 9.57768>
}
#declare _Limb1B1_1B6_2B2_1_Ref = object {
  _Limb1B1_1B6_2B2_1
  rotate <0.0, 18.08005, 200.984833>
  translate  <5.69554, 1.49911, 9.91684>
}
#declare _Limb1B1_1B6_2B3_1_Ref = object {
  _Limb1B1_1B6_2B3_1
  rotate <0.0, 81.985687, 16.070141>
  translate  <6.0044, 1.57517, 10.42558>
}
#declare _Limb1B1_1B6_2B4_1_Ref = object {
  _Limb1B1_1B6_2B4_1
  rotate <0.0, 55.56284, 81.904541>
  translate  <6.10736, 1.60053, 10.59516>
}
#declare _Limb1B1_1B6_2B5_1_Ref = object {
  _Limb1B1_1B6_2B5_1
  rotate <0.0, 32.015591, 13.83438>
  translate  <6.26179, 1.63856, 10.84954>
}
#declare _Limb1B1_1B6_1B1_1_Ref = object {
  _Limb1B1_1B6_1B1_1
  rotate <0.0, 12.11302, 203.444229>
  translate  <4.47534, 1.1894, 8.23823>
}
#declare _Limb1B1_1B6_1B2_1_Ref = object {
  _Limb1B1_1B6_1B2_1
  rotate <0.0, 73.228233, 59.527451>
  translate  <4.77366, 1.26558, 8.63218>
}
#declare _Limb1B1_1B6_1B3_1_Ref = object {
  _Limb1B1_1B6_1B3_1
  rotate <0.0, 75.339691, 332.419342>
  translate  <4.89299, 1.29605, 8.78977>
}
#declare _Limb1B2_1_Ref = object {
  _Limb1B2_1
  rotate <0.0, 50.0, 87.0>
  translate  4.0*z
}
#declare _Secund1_Limb1B2_1B1_1_Ref = object {
  _Secund1_Limb1B2_1B1_1
  rotate <0.0, 74.988297, 87.874962>
  translate  <0.12028, 2.29498, 5.92836>
}
#declare _Limb1B2_1B1_2_Ref = object {
  _Limb1B2_1B1_2
  rotate <0.0, 80.986061, 88.042801>
  translate  <0.22772, 5.19061, 6.70541>
}
#declare _Limb1B2_1B1_2B1_1_Ref = object {
  _Limb1B2_1B1_2B1_1
  rotate <0.0, 83.039299, 138.527054>
  translate  <0.22772, 5.19061, 6.70541>
}
#declare _Limb1B2_1B1_2B2_1_Ref = object {
  _Limb1B2_1B1_2B2_1
  rotate <0.0, 130.965027, 89.616386>
  translate  <0.24121, 5.58544, 6.76808>
}
#declare _Limb1B2_1B1_2B3_1_Ref = object {
  _Limb1B2_1B1_2B3_1
  rotate <0.0, 31.016899, 85.736526>
  translate  <0.26145, 6.17768, 6.86209>
}
#declare _Limb1B2_1B1_2B4_1_Ref = object {
  _Limb1B2_1B1_2B4_1
  rotate <0.0, 85.398293, 37.84668>
  translate  <0.2682, 6.3751, 6.89342>
}
#declare _Limb1B2_1B1_2B5_1_Ref = object {
  _Limb1B2_1B1_2B5_1
  rotate <0.0, 80.986061, 88.042801>
  translate  <0.27832, 6.67122, 6.94042>
}
#declare _Limb1B2_1B1_1B1_1_Ref = object {
  _Limb1B2_1B1_1B1_1
  rotate <0.0, 124.968483, 89.357628>
  translate  <0.16683, 3.54976, 6.26508>
}
#declare _Limb1B2_1B1_1B2_1_Ref = object {
  _Limb1B2_1B1_1B2_1
  rotate <0.0, 58.763931, 35.876869>
  translate  <0.18474, 4.03236, 6.39459>
}
#declare _Limb1B2_1B1_1B3_1_Ref = object {
  _Limb1B2_1B1_1B3_1
  rotate <0.0, 56.355549, 139.490448>
  translate  <0.19191, 4.2254, 6.4464>
}
#declare _Secund1_Limb1B2_1B2_1_Ref = object {
  _Secund1_Limb1B2_1B2_1
  rotate <0.0, 40.567421, 127.692657>
  translate  <0.12028, 2.29498, 5.92836>
}
#declare _Limb1B2_1B2_2_Ref = object {
  _Limb1B2_1B2_2
  rotate <0.0, 40.6562, 136.914963>
  translate  <-1.07263, 3.83884, 8.20729>
}
#declare _Limb1B2_1B2_2B1_1_Ref = object {
  _Limb1B2_1B2_2B1_1
  rotate <0.0, 9.83803, 297.038544>
  translate  <-1.07263, 3.83884, 8.20729>
}
#declare _Limb1B2_1B2_2B2_1_Ref = object {
  _Limb1B2_1B2_2B2_1
  rotate <0.0, 63.269699, 195.700607>
  translate  <-1.26297, 4.01685, 8.51074>
}
#declare _Limb1B2_1B2_2B3_1_Ref = object {
  _Limb1B2_1B2_2B3_1
  rotate <0.0, 58.298908, 73.046219>
  translate  <-1.54846, 4.28388, 8.96592>
}
#declare _Limb1B2_1B2_2B4_1_Ref = object {
  _Limb1B2_1B2_2B4_1
  rotate <0.0, 90.573853, 133.584473>
  translate  <-1.64363, 4.37288, 9.11765>
}
#declare _Limb1B2_1B2_2B5_1_Ref = object {
  _Limb1B2_1B2_2B5_1
  rotate <0.0, 40.6562, 136.914963>
  translate  <-1.78638, 4.5064, 9.34524>
}
#declare _Limb1B2_1B2_1B1_1_Ref = object {
  _Limb1B2_1B2_1B1_1
  rotate <0.0, 59.243309, 190.624695>
  translate  <-0.39665, 2.96399, 6.9159>
}
#declare _Limb1B2_1B2_1B2_1_Ref = object {
  _Limb1B2_1B2_1B2_1
  rotate <0.0, 87.377609, 107.070068>
  translate  <-0.59547, 3.22129, 7.29572>
}
#declare _Limb1B2_1B2_1B3_1_Ref = object {
  _Limb1B2_1B2_1B3_1
  rotate <0.0, 24.808241, 27.827379>
  translate  <-0.675, 3.32422, 7.44765>
}
#declare _Secund1_Limb1B2_1B3_1_Ref = object {
  _Secund1_Limb1B2_1B3_1
  rotate <0.0, 42.56686, 46.259571>
  translate  <0.12028, 2.29498, 5.92836>
}
#declare _Limb1B2_1B3_2_Ref = object {
  _Limb1B2_1B3_2
  rotate <0.0, 42.994862, 37.443321>
  translate  <1.52335, 3.76115, 8.13783>
}
#declare _Limb1B2_1B3_2B1_1_Ref = object {
  _Limb1B2_1B3_2B1_1
  rotate <0.0, 92.75071, 43.04987>
  translate  <1.52335, 3.76115, 8.13783>
}
#declare _Limb1B2_1B3_2B2_1_Ref = object {
  _Limb1B2_1B3_2B2_1
  rotate <0.0, 66.196663, 341.29892>
  translate  <1.73992, 3.92699, 8.43039>
}
#declare _Limb1B2_1B3_2B3_1_Ref = object {
  _Limb1B2_1B3_2B3_1
  rotate <0.0, 57.541389, 101.664101>
  translate  <2.06478, 4.17575, 8.86924>
}
#declare _Limb1B2_1B3_2B4_1_Ref = object {
  _Limb1B2_1B3_2B4_1
  rotate <0.0, 8.78089, 257.178558>
  translate  <2.17306, 4.25867, 9.01553>
}
#declare _Limb1B2_1B3_2B5_1_Ref = object {
  _Limb1B2_1B3_2B5_1
  rotate <0.0, 42.994862, 37.443321>
  translate  <2.33549, 4.38305, 9.23495>
}
#declare _Limb1B2_1B3_1B1_1_Ref = object {
  _Limb1B2_1B3_1B1_1
  rotate <0.0, 62.238548, 346.308685>
  translate  <0.72828, 2.93032, 6.8858>
}
#declare _Limb1B2_1B3_1B2_1_Ref = object {
  _Limb1B2_1B3_1B2_1
  rotate <0.0, 22.190861, 145.073944>
  translate  <0.96212, 3.17468, 7.25404>
}
#declare _Limb1B2_1B3_1B3_1_Ref = object {
  _Limb1B2_1B3_1B3_1
  rotate <0.0, 88.367149, 69.393929>
  translate  <1.05566, 3.27243, 7.40134>
}
#declare _Punta3_Limb1B2_1B4_1_Ref = object {
  _Punta3_Limb1B2_1B4_1
  rotate <0.0, 64.337128, 65.430977>
  translate  <0.20046, 3.82497, 7.21394>
}
#declare _Limb1B2_1B4_2_Ref = object {
  _Limb1B2_1B4_2
  rotate <0.0, 68.568398, 60.788738>
  translate  <1.32478, 6.28422, 8.51316>
}
#declare _Limb1B2_1B4_2B1_1_Ref = object {
  _Limb1B2_1B4_2B1_1
  rotate <0.0, 105.235481, 95.442978>
  translate  <1.32478, 6.28422, 8.51316>
}
#declare _Limb1B2_1B4_2B2_1_Ref = object {
  _Limb1B2_1B4_2B2_1
  rotate <0.0, 106.011711, 26.995371>
  translate  <1.5065, 6.60921, 8.65932>
}
#declare _Limb1B2_1B4_2B3_1_Ref = object {
  _Limb1B2_1B4_2B3_1
  rotate <0.0, 41.791882, 114.131477>
  translate  <1.77907, 7.0967, 8.87855>
}
#declare _Limb1B2_1B4_2B4_1_Ref = object {
  _Limb1B2_1B4_2B4_1
  rotate <0.0, 42.901642, 7.08748>
  translate  <1.86993, 7.25919, 8.95163>
}
#declare _Limb1B2_1B4_2B5_1_Ref = object {
  _Limb1B2_1B4_2B5_1
  rotate <0.0, 68.568398, 60.788738>
  translate  <2.00621, 7.50293, 9.06125>
}
#declare _Limb1B2_1B4_1B1_1_Ref = object {
  _Limb1B2_1B4_1B1_1
  rotate <0.0, 101.552811, 31.13043>
  translate  <0.68767, 4.89065, 7.77694>
}
#declare _Limb1B2_1B4_1B2_1_Ref = object {
  _Limb1B2_1B4_1B2_1
  rotate <0.0, 18.43548, 29.88962>
  translate  <0.87505, 5.30052, 7.99347>
}
#declare _Limb1B2_1B4_1B3_1_Ref = object {
  _Limb1B2_1B4_1B3_1
  rotate <0.0, 85.025261, 113.053909>
  translate  <0.95001, 5.46447, 8.08009>
}
#declare _Punta2_Limb1B2_1B5_1_Ref = object {
  _Punta2_Limb1B2_1B5_1
  rotate <0.0, 61.887009, 108.023132>
  translate  <0.20046, 3.82497, 7.21394>
}
#declare _Limb1B2_1B5_2_Ref = object {
  _Limb1B2_1B5_2
  rotate <0.0, 65.8293, 113.06366>
  translate  <-0.61824, 6.3412, 8.62757>
}
#declare _Limb1B2_1B5_2B1_1_Ref = object {
  _Limb1B2_1B5_2B1_1
  rotate <0.0, 38.617619, 168.520416>
  translate  <-0.61824, 6.3412, 8.62757>
}
#declare _Limb1B2_1B5_2B2_1_Ref = object {
  _Limb1B2_1B5_2B2_1
  rotate <0.0, 101.87767, 148.538895>
  translate  <-0.7612, 6.67696, 8.79136>
}
#declare _Limb1B2_1B5_2B3_1_Ref = object {
  _Limb1B2_1B5_2B3_1
  rotate <0.0, 42.928001, 56.566219>
  translate  <-0.97564, 7.1806, 9.03703>
}
#declare _Limb1B2_1B5_2B4_1_Ref = object {
  _Limb1B2_1B5_2B4_1
  rotate <0.0, 104.770111, 80.946358>
  translate  <-1.04713, 7.34848, 9.11892>
}
#declare _Limb1B2_1B5_2B5_1_Ref = object {
  _Limb1B2_1B5_2B5_1
  rotate <0.0, 65.8293, 113.06366>
  translate  <-1.15435, 7.60031, 9.24176>
}
#declare _Limb1B2_1B5_1B1_1_Ref = object {
  _Limb1B2_1B5_1B1_1
  rotate <0.0, 97.514168, 144.359848>
  translate  <-0.15431, 4.91534, 7.82651>
}
#declare _Limb1B2_1B5_1B2_1_Ref = object {
  _Limb1B2_1B5_1B2_1
  rotate <0.0, 85.92849, 61.858101>
  translate  <-0.29076, 5.33471, 8.06212>
}
#declare _Limb1B2_1B5_1B3_1_Ref = object {
  _Limb1B2_1B5_1B3_1
  rotate <0.0, 14.43353, 140.020416>
  translate  <-0.34534, 5.50245, 8.15636>
}
#declare _Punta1_Limb1B2_1B6_1_Ref = object {
  _Punta1_Limb1B2_1B6_1
  rotate <0.0, 38.009029, 86.324852>
  translate  <0.20046, 3.82497, 7.21394>
}
#declare _Limb1B2_1B6_2_Ref = object {
  _Limb1B2_1B6_2
  rotate <0.0, 32.015591, 85.834381>
  translate  <0.31887, 5.66853, 9.57768>
}
#declare _Limb1B2_1B6_2B1_1_Ref = object {
  _Limb1B2_1B6_2B1_1
  rotate <0.0, 58.362572, 21.857321>
  translate  <0.31887, 5.66853, 9.57768>
}
#declare _Limb1B2_1B6_2B2_1_Ref = object {
  _Limb1B2_1B6_2B2_1
  rotate <0.0, 18.08005, 272.984833>
  translate  <0.33428, 5.88003, 9.91684>
}
#declare _Limb1B2_1B6_2B3_1_Ref = object {
  _Limb1B2_1B6_2B3_1
  rotate <0.0, 81.985687, 88.070137>
  translate  <0.35738, 6.19728, 10.42558>
}
#declare _Limb1B2_1B6_2B4_1_Ref = object {
  _Limb1B2_1B6_2B4_1
  rotate <0.0, 55.56284, 153.904541>
  translate  <0.36508, 6.30303, 10.59516>
}
#declare _Limb1B2_1B6_2B5_1_Ref = object {
  _Limb1B2_1B6_2B5_1
  rotate <0.0, 32.015591, 85.834381>
  translate  <0.37664, 6.46166, 10.84954>
}
#declare _Limb1B2_1B6_1B1_1_Ref = object {
  _Limb1B2_1B6_1B1_1
  rotate <0.0, 12.11302, 275.444244>
  translate  <0.25177, 4.62385, 8.23823>
}
#declare _Limb1B2_1B6_1B2_1_Ref = object {
  _Limb1B2_1B6_1B2_1
  rotate <0.0, 73.228233, 131.527451>
  translate  <0.27151, 4.93111, 8.63218>
}
#declare _Limb1B2_1B6_1B3_1_Ref = object {
  _Limb1B2_1B6_1B3_1
  rotate <0.0, 75.339691, 44.419338>
  translate  <0.2794, 5.05401, 8.78977>
}
#declare _Limb1B3_1_Ref = object {
  _Limb1B3_1
  rotate <0.0, 50.0, 159.0>
  translate  4.0*z
}
#declare _Secund1_Limb1B3_1B1_1_Ref = object {
  _Secund1_Limb1B3_1B1_1
  rotate <0.0, 74.988297, 159.874954>
  translate  <-2.14549, 0.82358, 5.92836>
}
#declare _Limb1B3_1B1_2_Ref = object {
  _Limb1B3_1B1_2
  rotate <0.0, 80.986061, 160.042801>
  translate  <-4.86619, 1.82056, 6.70541>
}
#declare _Limb1B3_1B1_2B1_1_Ref = object {
  _Limb1B3_1B1_2B1_1
  rotate <0.0, 83.039299, 210.527054>
  translate  <-4.86619, 1.82056, 6.70541>
}
#declare _Limb1B3_1B1_2B2_1_Ref = object {
  _Limb1B3_1B1_2B2_1
  rotate <0.0, 130.965027, 161.616394>
  translate  <-5.23753, 1.9554, 6.76808>
}
#declare _Limb1B3_1B1_2B3_1_Ref = object {
  _Limb1B3_1B1_2B3_1
  rotate <0.0, 31.016899, 157.736526>
  translate  <-5.79453, 2.15766, 6.86209>
}
#declare _Limb1B3_1B1_2B4_1_Ref = object {
  _Limb1B3_1B1_2B4_1
  rotate <0.0, 85.398293, 109.84668>
  translate  <-5.9802, 2.22508, 6.89342>
}
#declare _Limb1B3_1B1_2B5_1_Ref = object {
  _Limb1B3_1B1_2B5_1
  rotate <0.0, 80.986061, 160.042801>
  translate  <-6.2587, 2.32622, 6.94042>
}
#declare _Limb1B3_1B1_1B1_1_Ref = object {
  _Limb1B3_1B1_1B1_1
  rotate <0.0, 124.968483, 161.357635>
  translate  <-3.32446, 1.2556, 6.26508>
}
#declare _Limb1B3_1B1_1B2_1_Ref = object {
  _Limb1B3_1B1_1B2_1
  rotate <0.0, 58.763931, 107.876869>
  translate  <-3.77791, 1.42177, 6.39459>
}
#declare _Limb1B3_1B1_1B3_1_Ref = object {
  _Limb1B3_1B1_1B3_1
  rotate <0.0, 56.355549, 211.490448>
  translate  <-3.95929, 1.48823, 6.4464>
}
#declare _Secund1_Limb1B3_1B2_1_Ref = object {
  _Secund1_Limb1B3_1B2_1
  rotate <0.0, 40.567421, 199.692657>
  translate  <-2.14549, 0.82358, 5.92836>
}
#declare _Limb1B3_1B2_2_Ref = object {
  _Limb1B3_1B2_2
  rotate <0.0, 40.6562, 208.914963>
  translate  <-3.98241, 0.16613, 8.20729>
}
#declare _Limb1B3_1B2_2B1_1_Ref = object {
  _Limb1B3_1B2_2B1_1
  rotate <0.0, 9.83803, 9.03855>
  translate  <-3.98241, 0.16613, 8.20729>
}
#declare _Limb1B3_1B2_2B2_1_Ref = object {
  _Limb1B3_1B2_2B2_1
  rotate <0.0, 63.269699, 267.700623>
  translate  <-4.21053, 0.04012, 8.51074>
}
#declare _Limb1B3_1B2_2B3_1_Ref = object {
  _Limb1B3_1B2_2B3_1
  rotate <0.0, 58.298908, 145.046219>
  translate  <-4.55271, -0.14889, 8.96592>
}
#declare _Limb1B3_1B2_2B4_1_Ref = object {
  _Limb1B3_1B2_2B4_1
  rotate <0.0, 90.573853, 205.584473>
  translate  <-4.66677, -0.21189, 9.11765>
}
#declare _Limb1B3_1B2_2B5_1_Ref = object {
  _Limb1B3_1B2_2B5_1
  rotate <0.0, 40.6562, 208.914963>
  translate  <-4.83786, -0.30639, 9.34524>
}
#declare _Limb1B3_1B2_1B1_1_Ref = object {
  _Limb1B3_1B2_1B1_1
  rotate <0.0, 59.243309, 262.624695>
  translate  <-2.94149, 0.53868, 6.9159>
}
#declare _Limb1B3_1B2_1B2_1_Ref = object {
  _Limb1B3_1B2_1B2_1
  rotate <0.0, 87.377609, 179.070068>
  translate  <-3.24764, 0.42911, 7.29572>
}
#declare _Limb1B3_1B2_1B3_1_Ref = object {
  _Limb1B3_1B2_1B3_1
  rotate <0.0, 24.808241, 99.827377>
  translate  <-3.3701, 0.38528, 7.44765>
}
#declare _Secund1_Limb1B3_1B3_1_Ref = object {
  _Secund1_Limb1B3_1B3_1
  rotate <0.0, 42.56686, 118.259567>
  translate  <-2.14549, 0.82358, 5.92836>
}
#declare _Limb1B3_1B3_2_Ref = object {
  _Limb1B3_1B3_2
  rotate <0.0, 42.994862, 109.443321>
  translate  <-3.10632, 2.61105, 8.13783>
}
#declare _Limb1B3_1B3_2B1_1_Ref = object {
  _Limb1B3_1B3_2B1_1
  rotate <0.0, 92.75071, 115.049873>
  translate  <-3.10632, 2.61105, 8.13783>
}
#declare _Limb1B3_1B3_2B2_1_Ref = object {
  _Limb1B3_1B3_2B2_1
  rotate <0.0, 66.196663, 53.298908>
  translate  <-3.19712, 2.86827, 8.43039>
}
#declare _Limb1B3_1B3_2B3_1_Ref = object {
  _Limb1B3_1B3_2B3_1
  rotate <0.0, 57.541389, 173.664093>
  translate  <-3.33332, 3.2541, 8.86924>
}
#declare _Limb1B3_1B3_2B4_1_Ref = object {
  _Limb1B3_1B3_2B4_1
  rotate <0.0, 8.78089, 329.178558>
  translate  <-3.37872, 3.3827, 9.01553>
}
#declare _Limb1B3_1B3_2B5_1_Ref = object {
  _Limb1B3_1B3_2B5_1
  rotate <0.0, 42.994862, 109.443321>
  translate  <-3.44682, 3.57562, 9.23495>
}
#declare _Limb1B3_1B3_1B1_1_Ref = object {
  _Limb1B3_1B3_1B1_1
  rotate <0.0, 62.238548, 58.308681>
  translate  <-2.56185, 1.59815, 6.8858>
}
#declare _Limb1B3_1B3_1B2_1_Ref = object {
  _Limb1B3_1B3_1B2_1
  rotate <0.0, 22.190861, 217.073944>
  translate  <-2.72199, 1.89606, 7.25404>
}
#declare _Limb1B3_1B3_1B3_1_Ref = object {
  _Limb1B3_1B3_1B3_1
  rotate <0.0, 88.367149, 141.393936>
  translate  <-2.78605, 2.01523, 7.40134>
}
#declare _Punta3_Limb1B3_1B4_1_Ref = object {
  _Punta3_Limb1B3_1B4_1
  rotate <0.0, 64.337128, 137.430984>
  translate  <-3.57582, 1.37263, 7.21394>
}
#declare _Limb1B3_1B4_2_Ref = object {
  _Limb1B3_1B4_2
  rotate <0.0, 68.568398, 132.788742>
  translate  <-5.56727, 3.20187, 8.51316>
}
#declare _Limb1B3_1B4_2B1_1_Ref = object {
  _Limb1B3_1B4_2B1_1
  rotate <0.0, 105.235481, 167.442978>
  translate  <-5.56727, 3.20187, 8.51316>
}
#declare _Limb1B3_1B4_2B2_1_Ref = object {
  _Limb1B3_1B4_2B2_1
  rotate <0.0, 106.011711, 98.995369>
  translate  <-5.8202, 3.47512, 8.65932>
}
#declare _Limb1B3_1B4_2B3_1_Ref = object {
  _Limb1B3_1B4_2B3_1
  rotate <0.0, 41.791882, 186.131485>
  translate  <-6.1996, 3.88499, 8.87855>
}
#declare _Limb1B3_1B4_2B4_1_Ref = object {
  _Limb1B3_1B4_2B4_1
  rotate <0.0, 42.901642, 79.087479>
  translate  <-6.32606, 4.02162, 8.95163>
}
#declare _Limb1B3_1B4_2B5_1_Ref = object {
  _Limb1B3_1B4_2B5_1
  rotate <0.0, 68.568398, 132.788742>
  translate  <-6.51576, 4.22655, 9.06125>
}
#declare _Limb1B3_1B4_1B1_1_Ref = object {
  _Limb1B3_1B4_1B1_1
  rotate <0.0, 101.552811, 103.130432>
  translate  <-4.43878, 2.1653, 7.77694>
}
#declare _Limb1B3_1B4_1B2_1_Ref = object {
  _Limb1B3_1B4_1B2_1
  rotate <0.0, 18.43548, 101.889618>
  translate  <-4.77069, 2.47018, 7.99347>
}
#declare _Limb1B3_1B4_1B3_1_Ref = object {
  _Limb1B3_1B4_1B3_1
  rotate <0.0, 85.025261, 185.053909>
  translate  <-4.90345, 2.59213, 8.08009>
}
#declare _Punta2_Limb1B3_1B5_1_Ref = object {
  _Punta2_Limb1B3_1B5_1
  rotate <0.0, 61.887009, 180.023132>
  translate  <-3.57582, 1.37263, 7.21394>
}
#declare _Limb1B3_1B5_2_Ref = object {
  _Limb1B3_1B5_2
  rotate <0.0, 65.8293, 185.06366>
  translate  <-6.22188, 1.37156, 8.62757>
}
#declare _Limb1B3_1B5_2B1_1_Ref = object {
  _Limb1B3_1B5_2B1_1
  rotate <0.0, 38.617619, 240.520416>
  translate  <-6.22188, 1.37156, 8.62757>
}
#declare _Limb1B3_1B5_2B2_1_Ref = object {
  _Limb1B3_1B5_2B2_1
  rotate <0.0, 101.87767, 220.538895>
  translate  <-6.58539, 1.33935, 8.79136>
}
#declare _Limb1B3_1B5_2B3_1_Ref = object {
  _Limb1B3_1B5_2B3_1
  rotate <0.0, 42.928001, 128.566223>
  translate  <-7.13065, 1.29104, 9.03703>
}
#declare _Limb1B3_1B5_2B4_1_Ref = object {
  _Limb1B3_1B5_2B4_1
  rotate <0.0, 104.770111, 152.946365>
  translate  <-7.3124, 1.27493, 9.11892>
}
#declare _Limb1B3_1B5_2B5_1_Ref = object {
  _Limb1B3_1B5_2B5_1
  rotate <0.0, 65.8293, 185.06366>
  translate  <-7.58503, 1.25077, 9.24176>
}
#declare _Limb1B3_1B5_1B1_1_Ref = object {
  _Limb1B3_1B5_1B1_1
  rotate <0.0, 97.514168, 216.359848>
  translate  <-4.72245, 1.37217, 7.82651>
}
#declare _Limb1B3_1B5_1B2_1_Ref = object {
  _Limb1B3_1B5_1B2_1
  rotate <0.0, 85.92849, 133.858093>
  translate  <-5.16346, 1.37199, 8.06212>
}
#declare _Limb1B3_1B5_1B3_1_Ref = object {
  _Limb1B3_1B5_1B3_1
  rotate <0.0, 14.43353, 212.020416>
  translate  <-5.33986, 1.37192, 8.15636>
}
#declare _Punta1_Limb1B3_1B6_1_Ref = object {
  _Punta1_Limb1B3_1B6_1
  rotate <0.0, 38.009029, 158.324844>
  translate  <-3.57582, 1.37263, 7.21394>
}
#declare _Limb1B3_1B6_2_Ref = object {
  _Limb1B3_1B6_2
  rotate <0.0, 32.015591, 157.834381>
  translate  <-5.29256, 2.05494, 9.57768>
}
#declare _Limb1B3_1B6_2B1_1_Ref = object {
  _Limb1B3_1B6_2B1_1
  rotate <0.0, 58.362572, 93.857323>
  translate  <-5.29256, 2.05494, 9.57768>
}
#declare _Limb1B3_1B6_2B2_1_Ref = object {
  _Limb1B3_1B6_2B2_1
  rotate <0.0, 18.08005, 344.984833>
  translate  <-5.48894, 2.13495, 9.91684>
}
#declare _Limb1B3_1B6_2B3_1_Ref = object {
  _Limb1B3_1B6_2B3_1
  rotate <0.0, 81.985687, 160.070145>
  translate  <-5.78353, 2.25496, 10.42558>
}
#declare _Limb1B3_1B6_2B4_1_Ref = object {
  _Limb1B3_1B6_2B4_1
  rotate <0.0, 55.56284, 225.904541>
  translate  <-5.88172, 2.29496, 10.59516>
}
#declare _Limb1B3_1B6_2B5_1_Ref = object {
  _Limb1B3_1B6_2B5_1
  rotate <0.0, 32.015591, 157.834381>
  translate  <-6.02901, 2.35497, 10.84954>
}
#declare _Limb1B3_1B6_1B1_1_Ref = object {
  _Limb1B3_1B6_1B1_1
  rotate <0.0, 12.11302, 347.444244>
  translate  <-4.31974, 1.6683, 8.23823>
}
#declare _Limb1B3_1B6_1B2_1_Ref = object {
  _Limb1B3_1B6_1B2_1
  rotate <0.0, 73.228233, 203.527451>
  translate  <-4.60586, 1.78201, 8.63218>
}
#declare _Limb1B3_1B6_1B3_1_Ref = object {
  _Limb1B3_1B6_1B3_1
  rotate <0.0, 75.339691, 116.419342>
  translate  <-4.72031, 1.8275, 8.78977>
}
#declare _Limb1B4_1_Ref = object {
  _Limb1B4_1
  rotate <0.0, 25.0, 51.0>
  translate  4.0*z
}
#declare _Secund1_Limb1B4_1B1_1_Ref = object {
  _Secund1_Limb1B4_1B1_1
  rotate <0.0, 49.991859, 52.103352>
  translate  <0.79789, 0.98531, 6.71892>
}
#declare _Limb1B4_1B1_2_Ref = object {
  _Limb1B4_1B1_2
  rotate <0.0, 55.990841, 52.242481>
  translate  <2.20932, 2.7986, 8.64761>
}
#declare _Limb1B4_1B1_2B1_1_Ref = object {
  _Limb1B4_1B1_2B1_1
  rotate <0.0, 68.233429, 107.803001>
  translate  <2.20932, 2.7986, 8.64761>
}
#declare _Limb1B4_1B1_2B2_1_Ref = object {
  _Limb1B4_1B1_2B2_1
  rotate <0.0, 105.98484, 53.054852>
  translate  <2.41235, 3.06074, 8.87134>
}
#declare _Limb1B4_1B1_2B3_1_Ref = object {
  _Limb1B4_1B1_2B3_1
  rotate <0.0, 6.04577, 44.806919>
  translate  <2.7169, 3.45397, 9.20694>
}
#declare _Limb1B4_1B1_2B4_1_Ref = object {
  _Limb1B4_1B1_2B4_1
  rotate <0.0, 69.620972, 357.450562>
  translate  <2.81842, 3.58504, 9.3188>
}
#declare _Limb1B4_1B1_2B5_1_Ref = object {
  _Limb1B4_1B1_2B5_1
  rotate <0.0, 55.990841, 52.242481>
  translate  <2.9707, 3.78166, 9.4866>
}
#declare _Limb1B4_1B1_1B1_1_Ref = object {
  _Limb1B4_1B1_1B1_1
  rotate <0.0, 99.985527, 52.961552>
  translate  <1.40951, 1.77107, 7.55469>
}
#declare _Limb1B4_1B1_1B2_1_Ref = object {
  _Limb1B4_1B1_1B2_1
  rotate <0.0, 45.830471, 342.873322>
  translate  <1.64475, 2.07328, 7.87614>
}
#declare _Limb1B4_1B1_1B3_1_Ref = object {
  _Limb1B4_1B1_1B3_1
  rotate <0.0, 44.245781, 122.165031>
  translate  <1.73884, 2.19417, 8.00472>
}
#declare _Secund1_Limb1B4_1B2_1_Ref = object {
  _Secund1_Limb1B4_1B2_1
  rotate <0.0, 26.25135, 124.467522>
  translate  <0.79789, 0.98531, 6.71892>
}
#declare _Limb1B4_1B2_2_Ref = object {
  _Limb1B4_1B2_2
  rotate <0.0, 30.13385, 134.180634>
  translate  <0.04693, 2.07929, 9.40951>
}
#declare _Limb1B4_1B2_2B1_1_Ref = object {
  _Limb1B4_1B2_2B1_1
  rotate <0.0, 33.853069, 239.832077>
  translate  <0.04693, 2.07929, 9.40951>
}
#declare _Limb1B4_1B2_2B2_1_Ref = object {
  _Limb1B4_1B2_2B2_1
  rotate <0.0, 73.343758, 168.989594>
  translate  <-0.09302, 2.2233, 9.75545>
}
#declare _Limb1B4_1B2_2B3_1_Ref = object {
  _Limb1B4_1B2_2B3_1
  rotate <0.0, 34.390491, 29.7015>
  translate  <-0.30294, 2.43931, 10.27437>
}
#declare _Limb1B4_1B2_2B4_1_Ref = object {
  _Limb1B4_1B2_2B4_1
  rotate <0.0, 73.658173, 100.194481>
  translate  <-0.37292, 2.51132, 10.44734>
}
#declare _Limb1B4_1B2_2B5_1_Ref = object {
  _Limb1B4_1B2_2B5_1
  rotate <0.0, 30.13385, 134.180634>
  translate  <-0.47788, 2.61933, 10.70679>
}
#declare _Limb1B4_1B2_1B1_1_Ref = object {
  _Limb1B4_1B2_1B1_1
  rotate <0.0, 67.794487, 166.568909>
  translate  <0.47247, 1.45937, 7.88484>
}
#declare _Limb1B4_1B2_1B2_1_Ref = object {
  _Limb1B4_1B2_1B2_1
  rotate <0.0, 64.023331, 73.416412>
  translate  <0.34731, 1.6417, 8.33328>
}
#declare _Limb1B4_1B2_1B3_1_Ref = object {
  _Limb1B4_1B2_1B3_1
  rotate <0.0, 24.00062, 293.351868>
  translate  <0.29725, 1.71463, 8.51265>
}
#declare _Secund1_Limb1B4_1B3_1_Ref = object {
  _Secund1_Limb1B4_1B3_1
  rotate <0.0, 27.860359, 340.144165>
  translate  <0.79789, 0.98531, 6.71892>
}
#declare _Limb1B4_1B3_2_Ref = object {
  _Limb1B4_1B3_2
  rotate <0.0, 31.805811, 331.032135>
  translate  <2.1165, 0.50913, 9.37119>
}
#declare _Limb1B4_1B3_2B1_1_Ref = object {
  _Limb1B4_1B3_2B1_1
  rotate <0.0, 74.905197, 5.10989>
  translate  <2.1165, 0.50913, 9.37119>
}
#declare _Limb1B4_1B3_2B2_1_Ref = object {
  _Limb1B4_1B3_2B2_1
  rotate <0.0, 74.862, 296.847473>
  translate  <2.30094, 0.40703, 9.71113>
}
#declare _Limb1B4_1B3_2B3_1_Ref = object {
  _Limb1B4_1B3_2B3_1
  rotate <0.0, 33.758469, 73.606041>
  translate  <2.5776, 0.25387, 10.22103>
}
#declare _Limb1B4_1B3_2B4_1_Ref = object {
  _Limb1B4_1B3_2B4_1
  rotate <0.0, 33.683338, 228.308838>
  translate  <2.66982, 0.20282, 10.391>
}
#declare _Limb1B4_1B3_2B5_1_Ref = object {
  _Limb1B4_1B3_2B5_1
  rotate <0.0, 31.805811, 331.032135>
  translate  <2.80815, 0.12624, 10.64595>
}
#declare _Limb1B4_1B3_1B1_1_Ref = object {
  _Limb1B4_1B3_1B1_1
  rotate <0.0, 69.343063, 299.322449>
  translate  <1.36928, 0.77896, 7.86824>
}
#declare _Limb1B4_1B3_1B2_1_Ref = object {
  _Limb1B4_1B3_1B2_1
  rotate <0.0, 22.543421, 174.265884>
  translate  <1.58905, 0.6996, 8.31028>
}
#declare _Limb1B4_1B3_1B3_1_Ref = object {
  _Limb1B4_1B3_1B3_1
  rotate <0.0, 64.628632, 31.45042>
  translate  <1.67696, 0.66785, 8.4871>
}
#declare _Punta3_Limb1B4_1B4_1_Ref = object {
  _Punta3_Limb1B4_1B4_1
  rotate <0.0, 41.68993, 21.11838>
  translate  <1.32981, 1.64218, 8.53154>
}
#declare _Limb1B4_1B4_2_Ref = object {
  _Limb1B4_1B4_2
  rotate <0.0, 46.835152, 16.689301>
  translate  <3.1911, 2.36108, 10.7718>
}
#declare _Limb1B4_1B4_2B1_1_Ref = object {
  _Limb1B4_1B4_2B1_1
  rotate <0.0, 80.492302, 59.258411>
  translate  <3.1911, 2.36108, 10.7718>
}
#declare _Limb1B4_1B4_2B2_1_Ref = object {
  _Limb1B4_1B4_2B2_1
  rotate <0.0, 92.688568, 354.552032>
  translate  <3.47057, 2.44486, 11.04544>
}
#declare _Limb1B4_1B4_2B3_1_Ref = object {
  _Limb1B4_1B4_2B3_1
  rotate <0.0, 22.1243, 104.799522>
  translate  <3.88976, 2.57055, 11.4559>
}
#declare _Limb1B4_1B4_2B4_1_Ref = object {
  _Limb1B4_1B4_2B4_1
  rotate <0.0, 44.415642, 304.265442>
  translate  <4.0295, 2.61244, 11.59272>
}
#declare _Limb1B4_1B4_2B5_1_Ref = object {
  _Limb1B4_1B4_2B5_1
  rotate <0.0, 46.835152, 16.689301>
  translate  <4.2391, 2.67528, 11.79795>
}
#declare _Limb1B4_1B4_1B1_1_Ref = object {
  _Limb1B4_1B4_1B1_1
  rotate <0.0, 87.087502, 356.704132>
  translate  <2.13637, 1.9537, 9.50232>
}
#declare _Limb1B4_1B4_1B2_1_Ref = object {
  _Limb1B4_1B4_1B2_1
  rotate <0.0, 21.192699, 278.270508>
  translate  <2.44658, 2.07352, 9.8757>
}
#declare _Limb1B4_1B4_1B3_1_Ref = object {
  _Limb1B4_1B4_1B3_1
  rotate <0.0, 62.817001, 80.464912>
  translate  <2.57067, 2.12145, 10.02505>
}
#declare _Punta2_Limb1B4_1B5_1_Ref = object {
  _Punta2_Limb1B4_1B5_1
  rotate <0.0, 39.19421, 81.046562>
  translate  <1.32981, 1.64218, 8.53154>
}
#declare _Limb1B4_1B5_2_Ref = object {
  _Limb1B4_1B5_2
  rotate <0.0, 44.15556, 86.129768>
  translate  <1.62487, 3.51493, 10.85656>
}
#declare _Limb1B4_1B5_2B1_1_Ref = object {
  _Limb1B4_1B5_2B1_1
  rotate <0.0, 41.667271, 162.791534>
  translate  <1.62487, 3.51493, 10.85656>
}
#declare _Limb1B4_1B5_2B2_1_Ref = object {
  _Limb1B4_1B5_2B2_1
  rotate <0.0, 89.395363, 110.357658>
  translate  <1.64367, 3.79294, 11.14354>
}
#declare _Limb1B4_1B5_2B3_1_Ref = object {
  _Limb1B4_1B5_2B3_1
  rotate <0.0, 24.246849, 353.851288>
  translate  <1.67189, 4.20995, 11.57402>
}
#declare _Limb1B4_1B5_2B4_1_Ref = object {
  _Limb1B4_1B5_2B4_1
  rotate <0.0, 79.902748, 45.054691>
  translate  <1.68129, 4.34896, 11.71751>
}
#declare _Limb1B4_1B5_2B5_1_Ref = object {
  _Limb1B4_1B5_2B5_1
  rotate <0.0, 44.15556, 86.129768>
  translate  <1.69539, 4.55746, 11.93274>
}
#declare _Limb1B4_1B5_1B1_1_Ref = object {
  _Limb1B4_1B5_1B1_1
  rotate <0.0, 83.830673, 108.109131>
  translate  <1.45767, 2.45371, 9.53905>
}
#declare _Limb1B4_1B5_1B2_1_Ref = object {
  _Limb1B4_1B5_1B2_1
  rotate <0.0, 63.515072, 22.739559>
  translate  <1.50684, 2.76583, 9.92655>
}
#declare _Limb1B4_1B5_1B3_1_Ref = object {
  _Limb1B4_1B5_1B3_1
  rotate <0.0, 19.76833, 194.933121>
  translate  <1.52651, 2.89068, 10.08156>
}
#declare _Punta1_Limb1B4_1B6_1_Ref = object {
  _Punta1_Limb1B4_1B6_1
  rotate <0.0, 13.01363, 49.15345>
  translate  <1.32981, 1.64218, 8.53154>
}
#declare _Limb1B4_1B6_2_Ref = object {
  _Limb1B4_1B6_2
  rotate <0.0, 7.0373, 45.949951>
  translate  <1.77164, 2.15321, 11.45449>
}
#declare _Limb1B4_1B6_2B1_1_Ref = object {
  _Limb1B4_1B6_2B1_1
  rotate <0.0, 51.19685, 328.570892>
  translate  <1.77164, 2.15321, 11.45449>
}
#declare _Limb1B4_1B6_2B2_1_Ref = object {
  _Limb1B4_1B6_2B2_1
  rotate <0.0, 43.02005, 233.718475>
  translate  <1.80572, 2.18843, 11.85148>
}
#declare _Limb1B4_1B6_2B3_1_Ref = object {
  _Limb1B4_1B6_2B3_1
  rotate <0.0, 56.990681, 52.263691>
  translate  <1.85683, 2.24126, 12.44696>
}
#declare _Limb1B4_1B6_2B4_1_Ref = object {
  _Limb1B4_1B6_2B4_1
  rotate <0.0, 49.515388, 136.912354>
  translate  <1.87386, 2.25888, 12.64545>
}
#declare _Limb1B4_1B6_2B5_1_Ref = object {
  _Limb1B4_1B6_2B5_1
  rotate <0.0, 7.0373, 45.949951>
  translate  <1.89942, 2.28529, 12.94319>
}
#declare _Limb1B4_1B6_1B1_1_Ref = object {
  _Limb1B4_1B6_1B1_1
  rotate <0.0, 37.021641, 233.933502>
  translate  <1.52127, 1.86363, 9.79815>
}
#declare _Limb1B4_1B6_1B2_1_Ref = object {
  _Limb1B4_1B6_1B2_1
  rotate <0.0, 56.63308, 104.507767>
  translate  <1.59491, 1.9488, 10.28531>
}
#declare _Limb1B4_1B6_1B3_1_Ref = object {
  _Limb1B4_1B6_1B3_1
  rotate <0.0, 57.965549, 0.45004>
  translate  <1.62437, 1.98287, 10.48017>
}
#declare _Limb1B5_1_Ref = object {
  _Limb1B5_1
  rotate <0.0, 25.0, 123.0>
  translate  4.0*z
}
#declare _Secund1_Limb1B5_1B1_1_Ref = object {
  _Secund1_Limb1B5_1B1_1
  rotate <0.0, 49.991859, 124.103348>
  translate  <-0.69052, 1.06331, 6.71892>
}
#declare _Limb1B5_1B1_2_Ref = object {
  _Limb1B5_1B1_2
  rotate <0.0, 55.990841, 124.242477>
  translate  <-1.9789, 2.966, 8.64761>
}
#declare _Limb1B5_1B1_2B1_1_Ref = object {
  _Limb1B5_1B1_2B1_1
  rotate <0.0, 68.233429, 179.802994>
  translate  <-1.9789, 2.966, 8.64761>
}
#declare _Limb1B5_1B1_2B2_1_Ref = object {
  _Limb1B5_1B1_2B2_1
  rotate <0.0, 105.98484, 125.054848>
  translate  <-2.16548, 3.24011, 8.87134>
}
#declare _Limb1B5_1B1_2B3_1_Ref = object {
  _Limb1B5_1B1_2B3_1
  rotate <0.0, 6.04577, 116.806923>
  translate  <-2.44535, 3.65126, 9.20694>
}
#declare _Limb1B5_1B1_2B4_1_Ref = object {
  _Limb1B5_1B1_2B4_1
  rotate <0.0, 69.620972, 69.450562>
  translate  <-2.53864, 3.78832, 9.3188>
}
#declare _Limb1B5_1B1_2B5_1_Ref = object {
  _Limb1B5_1B1_2B5_1
  rotate <0.0, 55.990841, 124.242477>
  translate  <-2.67857, 3.9939, 9.4866>
}
#declare _Limb1B5_1B1_1B1_1_Ref = object {
  _Limb1B5_1B1_1B1_1
  rotate <0.0, 99.985527, 124.961548>
  translate  <-1.24882, 1.88781, 7.55469>
}
#declare _Limb1B5_1B1_1B2_1_Ref = object {
  _Limb1B5_1B1_1B2_1
  rotate <0.0, 45.830471, 54.873322>
  translate  <-1.46355, 2.20493, 7.87614>
}
#declare _Limb1B5_1B1_1B3_1_Ref = object {
  _Limb1B5_1B1_1B3_1
  rotate <0.0, 44.245781, 194.165024>
  translate  <-1.54944, 2.33177, 8.00472>
}
#declare _Secund1_Limb1B5_1B2_1_Ref = object {
  _Secund1_Limb1B5_1B2_1
  rotate <0.0, 26.25135, 196.467514>
  translate  <-0.69052, 1.06331, 6.71892>
}
#declare _Limb1B5_1B2_2_Ref = object {
  _Limb1B5_1B2_2
  rotate <0.0, 30.13385, 206.180634>
  translate  <-1.96302, 0.68717, 9.40951>
}
#declare _Limb1B5_1B2_2B1_1_Ref = object {
  _Limb1B5_1B2_2B1_1
  rotate <0.0, 33.853069, 311.832092>
  translate  <-1.96302, 0.68717, 9.40951>
}
#declare _Limb1B5_1B2_2B2_1_Ref = object {
  _Limb1B5_1B2_2B2_1
  rotate <0.0, 73.343758, 240.989594>
  translate  <-2.14323, 0.59857, 9.75545>
}
#declare _Limb1B5_1B2_2B3_1_Ref = object {
  _Limb1B5_1B2_2B3_1
  rotate <0.0, 34.390491, 101.7015>
  translate  <-2.41354, 0.46567, 10.27437>
}
#declare _Limb1B5_1B2_2B4_1_Ref = object {
  _Limb1B5_1B2_2B4_1
  rotate <0.0, 73.658173, 172.194473>
  translate  <-2.50364, 0.42137, 10.44734>
}
#declare _Limb1B5_1B2_2B5_1_Ref = object {
  _Limb1B5_1B2_2B5_1
  rotate <0.0, 30.13385, 206.180634>
  translate  <-2.6388, 0.35493, 10.70679>
}
#declare _Limb1B5_1B2_1B1_1_Ref = object {
  _Limb1B5_1B2_1B1_1
  rotate <0.0, 67.794487, 238.568909>
  translate  <-1.24194, 0.90032, 7.88484>
}
#declare _Limb1B5_1B2_1B2_1_Ref = object {
  _Limb1B5_1B2_1B2_1
  rotate <0.0, 64.023331, 145.416412>
  translate  <-1.45402, 0.83762, 8.33328>
}
#declare _Limb1B5_1B2_1B3_1_Ref = object {
  _Limb1B5_1B2_1B3_1
  rotate <0.0, 24.00062, 5.35188>
  translate  <-1.53886, 0.81255, 8.51265>
}
#declare _Secund1_Limb1B5_1B3_1_Ref = object {
  _Secund1_Limb1B5_1B3_1
  rotate <0.0, 27.860359, 52.144169>
  translate  <-0.69052, 1.06331, 6.71892>
}
#declare _Limb1B5_1B3_2_Ref = object {
  _Limb1B5_1B3_2
  rotate <0.0, 31.805811, 43.03215>
  translate  <0.16982, 2.17024, 9.37119>
}
#declare _Limb1B5_1B3_2B1_1_Ref = object {
  _Limb1B5_1B3_2B1_1
  rotate <0.0, 74.905197, 77.109894>
  translate  <0.16982, 2.17024, 9.37119>
}
#declare _Limb1B5_1B3_2B2_1_Ref = object {
  _Limb1B5_1B3_2B2_1
  rotate <0.0, 74.862, 8.84747>
  translate  <0.32392, 2.3141, 9.71113>
}
#declare _Limb1B5_1B3_2B3_1_Ref = object {
  _Limb1B5_1B3_2B3_1
  rotate <0.0, 33.758469, 145.606033>
  translate  <0.55508, 2.52989, 10.22103>
}
#declare _Limb1B5_1B3_2B4_1_Ref = object {
  _Limb1B5_1B3_2B4_1
  rotate <0.0, 33.683338, 300.308838>
  translate  <0.63213, 2.60183, 10.391>
}
#declare _Limb1B5_1B3_2B5_1_Ref = object {
  _Limb1B5_1B3_2B5_1
  rotate <0.0, 31.805811, 43.03215>
  translate  <0.7477, 2.70972, 10.64595>
}
#declare _Limb1B5_1B3_1B1_1_Ref = object {
  _Limb1B5_1B3_1B1_1
  rotate <0.0, 69.343063, 11.32246>
  translate  <-0.31771, 1.54298, 7.86824>
}
#declare _Limb1B5_1B3_1B2_1_Ref = object {
  _Limb1B5_1B3_1B2_1
  rotate <0.0, 22.543421, 246.265884>
  translate  <-0.17432, 1.72747, 8.31028>
}
#declare _Limb1B5_1B3_1B3_1_Ref = object {
  _Limb1B5_1B3_1B3_1
  rotate <0.0, 64.628632, 103.450417>
  translate  <-0.11696, 1.80126, 8.4871>
}
#declare _Punta3_Limb1B5_1B4_1_Ref = object {
  _Punta3_Limb1B5_1B4_1
  rotate <0.0, 41.68993, 93.118378>
  translate  <-1.15087, 1.77219, 8.53154>
}
#declare _Limb1B5_1B4_2_Ref = object {
  _Limb1B5_1B4_2
  rotate <0.0, 46.835152, 88.689301>
  translate  <-1.25941, 3.76453, 10.7718>
}
#declare _Limb1B5_1B4_2B1_1_Ref = object {
  _Limb1B5_1B4_2B1_1
  rotate <0.0, 80.492302, 131.258408>
  translate  <-1.25941, 3.76453, 10.7718>
}
#declare _Limb1B5_1B4_2B2_1_Ref = object {
  _Limb1B5_1B4_2B2_1
  rotate <0.0, 92.688568, 66.552017>
  translate  <-1.25274, 4.05621, 11.04544>
}
#declare _Limb1B5_1B4_2B3_1_Ref = object {
  _Limb1B5_1B4_2B3_1
  rotate <0.0, 22.1243, 176.799515>
  translate  <-1.24273, 4.49373, 11.4559>
}
#declare _Limb1B5_1B4_2B4_1_Ref = object {
  _Limb1B5_1B4_2B4_1
  rotate <0.0, 44.415642, 16.26544>
  translate  <-1.23939, 4.63957, 11.59272>
}
#declare _Limb1B5_1B4_2B5_1_Ref = object {
  _Limb1B5_1B4_2B5_1
  rotate <0.0, 46.835152, 88.689301>
  translate  <-1.23439, 4.85833, 11.79795>
}
#declare _Limb1B5_1B4_1B1_1_Ref = object {
  _Limb1B5_1B4_1B1_1
  rotate <0.0, 87.087502, 68.70414>
  translate  <-1.19791, 2.63554, 9.50232>
}
#declare _Limb1B5_1B4_1B2_1_Ref = object {
  _Limb1B5_1B4_1B2_1
  rotate <0.0, 21.192699, 350.270508>
  translate  <-1.216, 2.96759, 9.8757>
}
#declare _Limb1B5_1B4_1B3_1_Ref = object {
  _Limb1B5_1B4_1B3_1
  rotate <0.0, 62.817001, 152.464905>
  translate  <-1.22323, 3.10042, 10.02505>
}
#declare _Punta2_Limb1B5_1B5_1_Ref = object {
  _Punta2_Limb1B5_1B5_1
  rotate <0.0, 39.19421, 153.046555>
  translate  <-1.15087, 1.77219, 8.53154>
}
#declare _Limb1B5_1B5_2_Ref = object {
  _Limb1B5_1B5_2
  rotate <0.0, 44.15556, 158.129776>
  translate  <-2.84079, 2.63151, 10.85656>
}
#declare _Limb1B5_1B5_2B1_1_Ref = object {
  _Limb1B5_1B5_2B1_1
  rotate <0.0, 41.667271, 234.791534>
  translate  <-2.84079, 2.63151, 10.85656>
}
#declare _Limb1B5_1B5_2B2_1_Ref = object {
  _Limb1B5_1B5_2B2_1
  rotate <0.0, 89.395363, 182.357666>
  translate  <-3.09938, 2.73531, 11.14354>
}
#declare _Limb1B5_1B5_2B3_1_Ref = object {
  _Limb1B5_1B5_2B3_1
  rotate <0.0, 24.246849, 65.851303>
  translate  <-3.48726, 2.891, 11.57402>
}
#declare _Limb1B5_1B5_2B4_1_Ref = object {
  _Limb1B5_1B5_2B4_1
  rotate <0.0, 79.902748, 117.054688>
  translate  <-3.61656, 2.9429, 11.71751>
}
#declare _Limb1B5_1B5_2B5_1_Ref = object {
  _Limb1B5_1B5_2B5_1
  rotate <0.0, 44.15556, 158.129776>
  translate  <-3.8105, 3.02075, 11.93274>
}
#declare _Limb1B5_1B5_1B1_1_Ref = object {
  _Limb1B5_1B5_1B1_1
  rotate <0.0, 83.830673, 180.109131>
  translate  <-1.88317, 2.14456, 9.53905>
}
#declare _Limb1B5_1B5_1B2_1_Ref = object {
  _Limb1B5_1B5_1B2_1
  rotate <0.0, 63.515072, 94.739563>
  translate  <-2.16482, 2.28778, 9.92655>
}
#declare _Limb1B5_1B5_1B3_1_Ref = object {
  _Limb1B5_1B5_1B3_1
  rotate <0.0, 19.76833, 266.933105>
  translate  <-2.27748, 2.34507, 10.08156>
}
#declare _Punta1_Limb1B5_1B6_1_Ref = object {
  _Punta1_Limb1B5_1B6_1
  rotate <0.0, 13.01363, 121.15345>
  translate  <-1.15087, 1.77219, 8.53154>
}
#declare _Limb1B5_1B6_2_Ref = object {
  _Limb1B5_1B6_2
  rotate <0.0, 7.0373, 117.949951>
  translate  <-1.50035, 2.35031, 11.45449>
}
#declare _Limb1B5_1B6_2B1_1_Ref = object {
  _Limb1B5_1B6_2B1_1
  rotate <0.0, 51.19685, 40.5709>
  translate  <-1.50035, 2.35031, 11.45449>
}
#declare _Limb1B5_1B6_2B2_1_Ref = object {
  _Limb1B5_1B6_2B2_1
  rotate <0.0, 43.02005, 305.718475>
  translate  <-1.52332, 2.3936, 11.85148>
}
#declare _Limb1B5_1B6_2B3_1_Ref = object {
  _Limb1B5_1B6_2B3_1
  rotate <0.0, 56.990681, 124.263687>
  translate  <-1.55778, 2.45854, 12.44696>
}
#declare _Limb1B5_1B6_2B4_1_Ref = object {
  _Limb1B5_1B6_2B4_1
  rotate <0.0, 49.515388, 208.912354>
  translate  <-1.56926, 2.48018, 12.64545>
}
#declare _Limb1B5_1B6_2B5_1_Ref = object {
  _Limb1B5_1B6_2B5_1
  rotate <0.0, 7.0373, 117.949951>
  translate  <-1.58649, 2.51265, 12.94319>
}
#declare _Limb1B5_1B6_1B1_1_Ref = object {
  _Limb1B5_1B6_1B1_1
  rotate <0.0, 37.021641, 305.933502>
  translate  <-1.30231, 2.02271, 9.79815>
}
#declare _Limb1B5_1B6_1B2_1_Ref = object {
  _Limb1B5_1B6_1B2_1
  rotate <0.0, 56.63308, 176.507767>
  translate  <-1.36056, 2.11906, 10.28531>
}
#declare _Limb1B5_1B6_1B3_1_Ref = object {
  _Limb1B5_1B6_1B3_1
  rotate <0.0, 57.965549, 72.450043>
  translate  <-1.38386, 2.1576, 10.48017>
}
#declare ArbolA_Limbs = union {
  object { _Limb1_Ref }
  object { _Limb1B1_1_Ref }
  object { _Secund1_Limb1B1_1B1_1_Ref }
  object { _Limb1B1_1B1_2_Ref }
  object { _Limb1B1_1B1_2B1_1_Ref }
  object { _Limb1B1_1B1_2B2_1_Ref }
  object { _Limb1B1_1B1_2B3_1_Ref }
  object { _Limb1B1_1B1_2B4_1_Ref }
  object { _Limb1B1_1B1_2B5_1_Ref }
  object { _Limb1B1_1B1_1B1_1_Ref }
  object { _Limb1B1_1B1_1B2_1_Ref }
  object { _Limb1B1_1B1_1B3_1_Ref }
  object { _Secund1_Limb1B1_1B2_1_Ref }
  object { _Limb1B1_1B2_2_Ref }
  object { _Limb1B1_1B2_2B1_1_Ref }
  object { _Limb1B1_1B2_2B2_1_Ref }
  object { _Limb1B1_1B2_2B3_1_Ref }
  object { _Limb1B1_1B2_2B4_1_Ref }
  object { _Limb1B1_1B2_2B5_1_Ref }
  object { _Limb1B1_1B2_1B1_1_Ref }
  object { _Limb1B1_1B2_1B2_1_Ref }
  object { _Limb1B1_1B2_1B3_1_Ref }
  object { _Secund1_Limb1B1_1B3_1_Ref }
  object { _Limb1B1_1B3_2_Ref }
  object { _Limb1B1_1B3_2B1_1_Ref }
  object { _Limb1B1_1B3_2B2_1_Ref }
  object { _Limb1B1_1B3_2B3_1_Ref }
  object { _Limb1B1_1B3_2B4_1_Ref }
  object { _Limb1B1_1B3_2B5_1_Ref }
  object { _Limb1B1_1B3_1B1_1_Ref }
  object { _Limb1B1_1B3_1B2_1_Ref }
  object { _Limb1B1_1B3_1B3_1_Ref }
  object { _Punta3_Limb1B1_1B4_1_Ref }
  object { _Limb1B1_1B4_2_Ref }
  object { _Limb1B1_1B4_2B1_1_Ref }
  object { _Limb1B1_1B4_2B2_1_Ref }
  object { _Limb1B1_1B4_2B3_1_Ref }
  object { _Limb1B1_1B4_2B4_1_Ref }
  object { _Limb1B1_1B4_2B5_1_Ref }
  object { _Limb1B1_1B4_1B1_1_Ref }
  object { _Limb1B1_1B4_1B2_1_Ref }
  object { _Limb1B1_1B4_1B3_1_Ref }
  object { _Punta2_Limb1B1_1B5_1_Ref }
  object { _Limb1B1_1B5_2_Ref }
  object { _Limb1B1_1B5_2B1_1_Ref }
  object { _Limb1B1_1B5_2B2_1_Ref }
  object { _Limb1B1_1B5_2B3_1_Ref }
  object { _Limb1B1_1B5_2B4_1_Ref }
  object { _Limb1B1_1B5_2B5_1_Ref }
  object { _Limb1B1_1B5_1B1_1_Ref }
  object { _Limb1B1_1B5_1B2_1_Ref }
  object { _Limb1B1_1B5_1B3_1_Ref }
  object { _Punta1_Limb1B1_1B6_1_Ref }
  object { _Limb1B1_1B6_2_Ref }
  object { _Limb1B1_1B6_2B1_1_Ref }
  object { _Limb1B1_1B6_2B2_1_Ref }
  object { _Limb1B1_1B6_2B3_1_Ref }
  object { _Limb1B1_1B6_2B4_1_Ref }
  object { _Limb1B1_1B6_2B5_1_Ref }
  object { _Limb1B1_1B6_1B1_1_Ref }
  object { _Limb1B1_1B6_1B2_1_Ref }
  object { _Limb1B1_1B6_1B3_1_Ref }
  object { _Limb1B2_1_Ref }
  object { _Secund1_Limb1B2_1B1_1_Ref }
  object { _Limb1B2_1B1_2_Ref }
  object { _Limb1B2_1B1_2B1_1_Ref }
  object { _Limb1B2_1B1_2B2_1_Ref }
  object { _Limb1B2_1B1_2B3_1_Ref }
  object { _Limb1B2_1B1_2B4_1_Ref }
  object { _Limb1B2_1B1_2B5_1_Ref }
  object { _Limb1B2_1B1_1B1_1_Ref }
  object { _Limb1B2_1B1_1B2_1_Ref }
  object { _Limb1B2_1B1_1B3_1_Ref }
  object { _Secund1_Limb1B2_1B2_1_Ref }
  object { _Limb1B2_1B2_2_Ref }
  object { _Limb1B2_1B2_2B1_1_Ref }
  object { _Limb1B2_1B2_2B2_1_Ref }
  object { _Limb1B2_1B2_2B3_1_Ref }
  object { _Limb1B2_1B2_2B4_1_Ref }
  object { _Limb1B2_1B2_2B5_1_Ref }
  object { _Limb1B2_1B2_1B1_1_Ref }
  object { _Limb1B2_1B2_1B2_1_Ref }
  object { _Limb1B2_1B2_1B3_1_Ref }
  object { _Secund1_Limb1B2_1B3_1_Ref }
  object { _Limb1B2_1B3_2_Ref }
  object { _Limb1B2_1B3_2B1_1_Ref }
  object { _Limb1B2_1B3_2B2_1_Ref }
  object { _Limb1B2_1B3_2B3_1_Ref }
  object { _Limb1B2_1B3_2B4_1_Ref }
  object { _Limb1B2_1B3_2B5_1_Ref }
  object { _Limb1B2_1B3_1B1_1_Ref }
  object { _Limb1B2_1B3_1B2_1_Ref }
  object { _Limb1B2_1B3_1B3_1_Ref }
  object { _Punta3_Limb1B2_1B4_1_Ref }
  object { _Limb1B2_1B4_2_Ref }
  object { _Limb1B2_1B4_2B1_1_Ref }
  object { _Limb1B2_1B4_2B2_1_Ref }
  object { _Limb1B2_1B4_2B3_1_Ref }
  object { _Limb1B2_1B4_2B4_1_Ref }
  object { _Limb1B2_1B4_2B5_1_Ref }
  object { _Limb1B2_1B4_1B1_1_Ref }
  object { _Limb1B2_1B4_1B2_1_Ref }
  object { _Limb1B2_1B4_1B3_1_Ref }
  object { _Punta2_Limb1B2_1B5_1_Ref }
  object { _Limb1B2_1B5_2_Ref }
  object { _Limb1B2_1B5_2B1_1_Ref }
  object { _Limb1B2_1B5_2B2_1_Ref }
  object { _Limb1B2_1B5_2B3_1_Ref }
  object { _Limb1B2_1B5_2B4_1_Ref }
  object { _Limb1B2_1B5_2B5_1_Ref }
  object { _Limb1B2_1B5_1B1_1_Ref }
  object { _Limb1B2_1B5_1B2_1_Ref }
  object { _Limb1B2_1B5_1B3_1_Ref }
  object { _Punta1_Limb1B2_1B6_1_Ref }
  object { _Limb1B2_1B6_2_Ref }
  object { _Limb1B2_1B6_2B1_1_Ref }
  object { _Limb1B2_1B6_2B2_1_Ref }
  object { _Limb1B2_1B6_2B3_1_Ref }
  object { _Limb1B2_1B6_2B4_1_Ref }
  object { _Limb1B2_1B6_2B5_1_Ref }
  object { _Limb1B2_1B6_1B1_1_Ref }
  object { _Limb1B2_1B6_1B2_1_Ref }
  object { _Limb1B2_1B6_1B3_1_Ref }
  object { _Limb1B3_1_Ref }
  object { _Secund1_Limb1B3_1B1_1_Ref }
  object { _Limb1B3_1B1_2_Ref }
  object { _Limb1B3_1B1_2B1_1_Ref }
  object { _Limb1B3_1B1_2B2_1_Ref }
  object { _Limb1B3_1B1_2B3_1_Ref }
  object { _Limb1B3_1B1_2B4_1_Ref }
  object { _Limb1B3_1B1_2B5_1_Ref }
  object { _Limb1B3_1B1_1B1_1_Ref }
  object { _Limb1B3_1B1_1B2_1_Ref }
  object { _Limb1B3_1B1_1B3_1_Ref }
  object { _Secund1_Limb1B3_1B2_1_Ref }
  object { _Limb1B3_1B2_2_Ref }
  object { _Limb1B3_1B2_2B1_1_Ref }
  object { _Limb1B3_1B2_2B2_1_Ref }
  object { _Limb1B3_1B2_2B3_1_Ref }
  object { _Limb1B3_1B2_2B4_1_Ref }
  object { _Limb1B3_1B2_2B5_1_Ref }
  object { _Limb1B3_1B2_1B1_1_Ref }
  object { _Limb1B3_1B2_1B2_1_Ref }
  object { _Limb1B3_1B2_1B3_1_Ref }
  object { _Secund1_Limb1B3_1B3_1_Ref }
  object { _Limb1B3_1B3_2_Ref }
  object { _Limb1B3_1B3_2B1_1_Ref }
  object { _Limb1B3_1B3_2B2_1_Ref }
  object { _Limb1B3_1B3_2B3_1_Ref }
  object { _Limb1B3_1B3_2B4_1_Ref }
  object { _Limb1B3_1B3_2B5_1_Ref }
  object { _Limb1B3_1B3_1B1_1_Ref }
  object { _Limb1B3_1B3_1B2_1_Ref }
  object { _Limb1B3_1B3_1B3_1_Ref }
  object { _Punta3_Limb1B3_1B4_1_Ref }
  object { _Limb1B3_1B4_2_Ref }
  object { _Limb1B3_1B4_2B1_1_Ref }
  object { _Limb1B3_1B4_2B2_1_Ref }
  object { _Limb1B3_1B4_2B3_1_Ref }
  object { _Limb1B3_1B4_2B4_1_Ref }
  object { _Limb1B3_1B4_2B5_1_Ref }
  object { _Limb1B3_1B4_1B1_1_Ref }
  object { _Limb1B3_1B4_1B2_1_Ref }
  object { _Limb1B3_1B4_1B3_1_Ref }
  object { _Punta2_Limb1B3_1B5_1_Ref }
  object { _Limb1B3_1B5_2_Ref }
  object { _Limb1B3_1B5_2B1_1_Ref }
  object { _Limb1B3_1B5_2B2_1_Ref }
  object { _Limb1B3_1B5_2B3_1_Ref }
  object { _Limb1B3_1B5_2B4_1_Ref }
  object { _Limb1B3_1B5_2B5_1_Ref }
  object { _Limb1B3_1B5_1B1_1_Ref }
  object { _Limb1B3_1B5_1B2_1_Ref }
  object { _Limb1B3_1B5_1B3_1_Ref }
  object { _Punta1_Limb1B3_1B6_1_Ref }
  object { _Limb1B3_1B6_2_Ref }
  object { _Limb1B3_1B6_2B1_1_Ref }
  object { _Limb1B3_1B6_2B2_1_Ref }
  object { _Limb1B3_1B6_2B3_1_Ref }
  object { _Limb1B3_1B6_2B4_1_Ref }
  object { _Limb1B3_1B6_2B5_1_Ref }
  object { _Limb1B3_1B6_1B1_1_Ref }
  object { _Limb1B3_1B6_1B2_1_Ref }
  object { _Limb1B3_1B6_1B3_1_Ref }
  object { _Limb1B4_1_Ref }
  object { _Secund1_Limb1B4_1B1_1_Ref }
  object { _Limb1B4_1B1_2_Ref }
  object { _Limb1B4_1B1_2B1_1_Ref }
  object { _Limb1B4_1B1_2B2_1_Ref }
  object { _Limb1B4_1B1_2B3_1_Ref }
  object { _Limb1B4_1B1_2B4_1_Ref }
  object { _Limb1B4_1B1_2B5_1_Ref }
  object { _Limb1B4_1B1_1B1_1_Ref }
  object { _Limb1B4_1B1_1B2_1_Ref }
  object { _Limb1B4_1B1_1B3_1_Ref }
  object { _Secund1_Limb1B4_1B2_1_Ref }
  object { _Limb1B4_1B2_2_Ref }
  object { _Limb1B4_1B2_2B1_1_Ref }
  object { _Limb1B4_1B2_2B2_1_Ref }
  object { _Limb1B4_1B2_2B3_1_Ref }
  object { _Limb1B4_1B2_2B4_1_Ref }
  object { _Limb1B4_1B2_2B5_1_Ref }
  object { _Limb1B4_1B2_1B1_1_Ref }
  object { _Limb1B4_1B2_1B2_1_Ref }
  object { _Limb1B4_1B2_1B3_1_Ref }
  object { _Secund1_Limb1B4_1B3_1_Ref }
  object { _Limb1B4_1B3_2_Ref }
  object { _Limb1B4_1B3_2B1_1_Ref }
  object { _Limb1B4_1B3_2B2_1_Ref }
  object { _Limb1B4_1B3_2B3_1_Ref }
  object { _Limb1B4_1B3_2B4_1_Ref }
  object { _Limb1B4_1B3_2B5_1_Ref }
  object { _Limb1B4_1B3_1B1_1_Ref }
  object { _Limb1B4_1B3_1B2_1_Ref }
  object { _Limb1B4_1B3_1B3_1_Ref }
  object { _Punta3_Limb1B4_1B4_1_Ref }
  object { _Limb1B4_1B4_2_Ref }
  object { _Limb1B4_1B4_2B1_1_Ref }
  object { _Limb1B4_1B4_2B2_1_Ref }
  object { _Limb1B4_1B4_2B3_1_Ref }
  object { _Limb1B4_1B4_2B4_1_Ref }
  object { _Limb1B4_1B4_2B5_1_Ref }
  object { _Limb1B4_1B4_1B1_1_Ref }
  object { _Limb1B4_1B4_1B2_1_Ref }
  object { _Limb1B4_1B4_1B3_1_Ref }
  object { _Punta2_Limb1B4_1B5_1_Ref }
  object { _Limb1B4_1B5_2_Ref }
  object { _Limb1B4_1B5_2B1_1_Ref }
  object { _Limb1B4_1B5_2B2_1_Ref }
  object { _Limb1B4_1B5_2B3_1_Ref }
  object { _Limb1B4_1B5_2B4_1_Ref }
  object { _Limb1B4_1B5_2B5_1_Ref }
  object { _Limb1B4_1B5_1B1_1_Ref }
  object { _Limb1B4_1B5_1B2_1_Ref }
  object { _Limb1B4_1B5_1B3_1_Ref }
  object { _Punta1_Limb1B4_1B6_1_Ref }
  object { _Limb1B4_1B6_2_Ref }
  object { _Limb1B4_1B6_2B1_1_Ref }
  object { _Limb1B4_1B6_2B2_1_Ref }
  object { _Limb1B4_1B6_2B3_1_Ref }
  object { _Limb1B4_1B6_2B4_1_Ref }
  object { _Limb1B4_1B6_2B5_1_Ref }
  object { _Limb1B4_1B6_1B1_1_Ref }
  object { _Limb1B4_1B6_1B2_1_Ref }
  object { _Limb1B4_1B6_1B3_1_Ref }
  object { _Limb1B5_1_Ref }
  object { _Secund1_Limb1B5_1B1_1_Ref }
  object { _Limb1B5_1B1_2_Ref }
  object { _Limb1B5_1B1_2B1_1_Ref }
  object { _Limb1B5_1B1_2B2_1_Ref }
  object { _Limb1B5_1B1_2B3_1_Ref }
  object { _Limb1B5_1B1_2B4_1_Ref }
  object { _Limb1B5_1B1_2B5_1_Ref }
  object { _Limb1B5_1B1_1B1_1_Ref }
  object { _Limb1B5_1B1_1B2_1_Ref }
  object { _Limb1B5_1B1_1B3_1_Ref }
  object { _Secund1_Limb1B5_1B2_1_Ref }
  object { _Limb1B5_1B2_2_Ref }
  object { _Limb1B5_1B2_2B1_1_Ref }
  object { _Limb1B5_1B2_2B2_1_Ref }
  object { _Limb1B5_1B2_2B3_1_Ref }
  object { _Limb1B5_1B2_2B4_1_Ref }
  object { _Limb1B5_1B2_2B5_1_Ref }
  object { _Limb1B5_1B2_1B1_1_Ref }
  object { _Limb1B5_1B2_1B2_1_Ref }
  object { _Limb1B5_1B2_1B3_1_Ref }
  object { _Secund1_Limb1B5_1B3_1_Ref }
  object { _Limb1B5_1B3_2_Ref }
  object { _Limb1B5_1B3_2B1_1_Ref }
  object { _Limb1B5_1B3_2B2_1_Ref }
  object { _Limb1B5_1B3_2B3_1_Ref }
  object { _Limb1B5_1B3_2B4_1_Ref }
  object { _Limb1B5_1B3_2B5_1_Ref }
  object { _Limb1B5_1B3_1B1_1_Ref }
  object { _Limb1B5_1B3_1B2_1_Ref }
  object { _Limb1B5_1B3_1B3_1_Ref }
  object { _Punta3_Limb1B5_1B4_1_Ref }
  object { _Limb1B5_1B4_2_Ref }
  object { _Limb1B5_1B4_2B1_1_Ref }
  object { _Limb1B5_1B4_2B2_1_Ref }
  object { _Limb1B5_1B4_2B3_1_Ref }
  object { _Limb1B5_1B4_2B4_1_Ref }
  object { _Limb1B5_1B4_2B5_1_Ref }
  object { _Limb1B5_1B4_1B1_1_Ref }
  object { _Limb1B5_1B4_1B2_1_Ref }
  object { _Limb1B5_1B4_1B3_1_Ref }
  object { _Punta2_Limb1B5_1B5_1_Ref }
  object { _Limb1B5_1B5_2_Ref }
  object { _Limb1B5_1B5_2B1_1_Ref }
  object { _Limb1B5_1B5_2B2_1_Ref }
  object { _Limb1B5_1B5_2B3_1_Ref }
  object { _Limb1B5_1B5_2B4_1_Ref }
  object { _Limb1B5_1B5_2B5_1_Ref }
  object { _Limb1B5_1B5_1B1_1_Ref }
  object { _Limb1B5_1B5_1B2_1_Ref }
  object { _Limb1B5_1B5_1B3_1_Ref }
  object { _Punta1_Limb1B5_1B6_1_Ref }
  object { _Limb1B5_1B6_2_Ref }
  object { _Limb1B5_1B6_2B1_1_Ref }
  object { _Limb1B5_1B6_2B2_1_Ref }
  object { _Limb1B5_1B6_2B3_1_Ref }
  object { _Limb1B5_1B6_2B4_1_Ref }
  object { _Limb1B5_1B6_2B5_1_Ref }
  object { _Limb1B5_1B6_1B1_1_Ref }
  object { _Limb1B5_1B6_1B2_1_Ref }
  object { _Limb1B5_1B6_1B3_1_Ref }
  texture {
    TroncoTex1
  }
}
#include "C:\MORAY FOR WINDOWS\POVScn\arbola_leafs.inc"

#declare _Leaf1B1_1B1_2B1_1B1_Ref = object {
  _Leaf1B1_1B1_2B1_1B1
  scale 0.7
  rotate <0.0, 112.243111, 73.535179>
  translate  <5.11697, 1.66742, 6.7182>
}
#declare _Leaf1B1_1B1_2B1_1B2_Ref = object {
  _Leaf1B1_1B1_2B1_1B2
  scale 0.7
  rotate <0.0, 89.256409, 111.22435>
  translate  <5.18345, 1.85217, 6.76361>
}
#declare _Leaf1B1_1B1_2B1_1B3_Ref = object {
  _Leaf1B1_1B1_2B1_1B3
  scale 0.7
  rotate <0.0, 113.424377, 353.976837>
  translate  <5.26412, 1.92474, 6.78039>
}
#declare _Leaf1B1_1B1_2B1_1B4_Ref = object {
  _Leaf1B1_1B1_2B1_1B4
  scale 0.7
  rotate <0.0, 146.000854, 258.827667>
  translate  <5.25687, 1.93054, 6.76045>
}
#declare _Leaf1B1_1B1_2B1_1B5_Ref = object {
  _Leaf1B1_1B1_2B1_1B5
  scale 0.7
  rotate <0.0, 36.524811, 166.015198>
  translate  <5.27176, 2.02773, 6.80685>
}
#declare _Leaf1B1_1B1_2B1_1B6_Ref = object {
  _Leaf1B1_1B1_2B1_1B6
  scale 0.7
  rotate <0.0, 32.264851, 25.13377>
  translate  <5.40781, 2.2935, 6.84171>
}
#declare _Leaf1B1_1B1_2B1_1B7_Ref = object {
  _Leaf1B1_1B1_2B1_1B7
  scale 0.7
  rotate <0.0, 89.59726, 145.494171>
  translate  <5.42794, 2.3952, 6.83714>
}
#declare _Leaf1B1_1B1_2B1_1B8_Ref = object {
  _Leaf1B1_1B1_2B1_1B8
  scale 0.7
  rotate <0.0, 124.74482, 145.484695>
  translate  <5.51188, 2.57596, 6.85558>
}
#declare _Leaf1B1_1B1_2B1_1B9_Ref = object {
  _Leaf1B1_1B1_2B1_1B9
  scale 0.7
  rotate <0.0, 39.571178, 328.031616>
  translate  <5.51912, 2.57017, 6.87546>
}
#declare _Leaf1B1_1B1_2B1_1B10_Ref = object {
  _Leaf1B1_1B1_2B1_1B10
  scale 0.7
  rotate <0.0, 66.65271, 40.36684>
  translate  <5.60715, 2.74927, 6.89302>
}
#declare _Leaf1B1_1B1_2B1_1B11_Ref = object {
  _Leaf1B1_1B1_2B1_1B11
  scale 0.7
  rotate <0.0, 110.887451, 30.530729>
  translate  <5.60858, 2.74996, 6.88315>
}
#declare _Leaf1B1_1B1_2B1_1B12_Ref = object {
  _Leaf1B1_1B1_2B1_1B12
  scale 0.7
  rotate <0.0, 162.034988, 47.21085>
  translate  <5.60143, 2.75384, 6.87732>
}
#declare _Leaf1B1_1B1_2B2_1B1_Ref = object {
  _Leaf1B1_1B1_2B2_1B1
  scale 0.7
  rotate <0.0, 134.688049, 336.586823>
  translate  <5.60057, 1.5414, 6.56099>
}
#declare _Leaf1B1_1B1_2B2_1B2_Ref = object {
  _Leaf1B1_1B1_2B2_1B2
  scale 0.7
  rotate <0.0, 175.701065, 37.12674>
  translate  <5.73164, 1.60701, 6.42267>
}
#declare _Leaf1B1_1B1_2B2_1B3_Ref = object {
  _Leaf1B1_1B1_2B2_1B3
  scale 0.7
  rotate <0.0, 62.465401, 339.670258>
  translate  <5.8324, 1.63733, 6.39132>
}
#declare _Leaf1B1_1B1_2B2_1B4_Ref = object {
  _Leaf1B1_1B1_2B2_1B4
  scale 0.7
  rotate <0.0, 64.455421, 255.710342>
  translate  <5.83075, 1.61723, 6.38251>
}
#declare _Leaf1B1_1B1_2B2_1B5_Ref = object {
  _Leaf1B1_1B1_2B2_1B5
  scale 0.7
  rotate <0.0, 110.74231, 126.812592>
  translate  <5.87882, 1.67203, 6.30184>
}
#declare _Leaf1B1_1B1_2B2_1B6_Ref = object {
  _Leaf1B1_1B1_2B2_1B6
  scale 0.7
  rotate <0.0, 88.910217, 64.86718>
  translate  <6.10755, 1.74034, 6.11916>
}
#declare _Leaf1B1_1B1_2B2_1B7_Ref = object {
  _Leaf1B1_1B1_2B2_1B7
  scale 0.7
  rotate <0.0, 149.401993, 183.966248>
  translate  <6.16854, 1.74545, 6.03535>
}
#declare _Leaf1B1_1B1_2B2_1B8_Ref = object {
  _Leaf1B1_1B1_2B2_1B8
  scale 0.7
  rotate <0.0, 136.178726, 240.055145>
  translate  <6.31702, 1.78579, 5.90736>
}
#declare _Leaf1B1_1B1_2B2_1B9_Ref = object {
  _Leaf1B1_1B1_2B2_1B9
  scale 0.7
  rotate <0.0, 56.460419, 72.480186>
  translate  <6.31866, 1.80583, 5.91614>
}
#declare _Leaf1B1_1B1_2B2_1B10_Ref = object {
  _Leaf1B1_1B1_2B2_1B10
  scale 0.7
  rotate <0.0, 103.55117, 31.57542>
  translate  <6.47025, 1.8456, 5.79135>
}
#declare _Leaf1B1_1B1_2B2_1B11_Ref = object {
  _Leaf1B1_1B1_2B2_1B11
  scale 0.7
  rotate <0.0, 95.717682, 346.285736>
  translate  <6.47306, 1.83601, 5.79109>
}
#declare _Leaf1B1_1B1_2B2_1B12_Ref = object {
  _Leaf1B1_1B1_2B2_1B12
  scale 0.7
  rotate <0.0, 98.057793, 293.893921>
  translate  <6.46896, 1.82979, 5.78442>
}
#declare _Leaf1B1_1B1_2B3_1B1_Ref = object {
  _Leaf1B1_1B1_2B3_1B1
  scale 0.7
  rotate <0.0, 33.006969, 72.077606>
  translate  <6.08933, 1.71537, 7.12648>
}
#declare _Leaf1B1_1B1_2B3_1B2_Ref = object {
  _Leaf1B1_1B1_2B3_1B2
  scale 0.7
  rotate <0.0, 14.09899, 202.398376>
  translate  <6.18728, 1.71562, 7.3026>
}
#declare _Leaf1B1_1B1_2B3_1B3_Ref = object {
  _Leaf1B1_1B1_2B3_1B3
  scale 0.7
  rotate <0.0, 102.628418, 48.651451>
  translate  <6.27447, 1.73935, 7.36497>
}
#declare _Leaf1B1_1B1_2B3_1B4_Ref = object {
  _Leaf1B1_1B1_2B3_1B4
  scale 0.7
  rotate <0.0, 123.439629, 127.100449>
  translate  <6.26012, 1.75484, 7.37114>
}
#declare _Leaf1B1_1B1_2B3_1B5_Ref = object {
  _Leaf1B1_1B1_2B3_1B5
  scale 0.7
  rotate <0.0, 76.45874, 260.123444>
  translate  <6.30306, 1.72621, 7.46684>
}
#declare _Leaf1B1_1B1_2B3_1B6_Ref = object {
  _Leaf1B1_1B1_2B3_1B6
  scale 0.7
  rotate <0.0, 79.302147, 326.05835>
  translate  <6.46754, 1.77098, 7.71443>
}
#declare _Leaf1B1_1B1_2B3_1B7_Ref = object {
  _Leaf1B1_1B1_2B3_1B7
  scale 0.7
  rotate <0.0, 48.359161, 204.235397>
  translate  <6.49417, 1.79106, 7.81269>
}
#declare _Leaf1B1_1B1_2B3_1B8_Ref = object {
  _Leaf1B1_1B1_2B3_1B8
  scale 0.7
  rotate <0.0, 57.861462, 161.420883>
  translate  <6.59608, 1.82272, 7.98202>
}
#declare _Leaf1B1_1B1_2B3_1B9_Ref = object {
  _Leaf1B1_1B1_2B3_1B9
  scale 0.7
  rotate <0.0, 112.505928, 327.296112>
  translate  <6.61039, 1.80727, 7.97587>
}
#declare _Leaf1B1_1B1_2B3_1B10_Ref = object {
  _Leaf1B1_1B1_2B3_1B10
  scale 0.7
  rotate <0.0, 59.157059, 358.392059>
  translate  <6.71544, 1.84129, 8.14302>
}
#declare _Leaf1B1_1B1_2B3_1B11_Ref = object {
  _Leaf1B1_1B1_2B3_1B11
  scale 0.7
  rotate <0.0, 68.772614, 48.034779>
  translate  <6.71264, 1.85089, 8.14329>
}
#declare _Leaf1B1_1B1_2B3_1B12_Ref = object {
  _Leaf1B1_1B1_2B3_1B12
  scale 0.7
  rotate <0.0, 79.91275, 101.076576>
  translate  <6.70414, 1.85349, 8.14788>
}
#declare _Leaf1B1_1B1_2B4_1B1_Ref = object {
  _Leaf1B1_1B1_2B4_1B1
  scale 0.7
  rotate <0.0, 59.07637, 310.550507>
  translate  <6.38309, 1.53477, 6.93794>
}
#declare _Leaf1B1_1B1_2B4_1B2_Ref = object {
  _Leaf1B1_1B1_2B4_1B2
  scale 0.7
  rotate <0.0, 92.308952, 281.343811>
  translate  <6.54563, 1.41587, 6.93033>
}
#declare _Leaf1B1_1B1_2B4_1B3_Ref = object {
  _Leaf1B1_1B1_2B4_1B3
  scale 0.7
  rotate <0.0, 50.118992, 42.735741>
  translate  <6.65291, 1.39735, 6.94458>
}
#declare _Leaf1B1_1B1_2B4_1B4_Ref = object {
  _Leaf1B1_1B1_2B4_1B4
  scale 0.7
  rotate <0.0, 44.830059, 151.184906>
  translate  <6.64417, 1.38695, 6.96188>
}
#declare _Leaf1B1_1B1_2B4_1B5_Ref = object {
  _Leaf1B1_1B1_2B4_1B5
  scale 0.7
  rotate <0.0, 157.461029, 247.029633>
  translate  <6.72027, 1.31593, 6.93049>
}
#declare _Leaf1B1_1B1_2B4_1B6_Ref = object {
  _Leaf1B1_1B1_2B4_1B6
  scale 0.7
  rotate <0.0, 129.861984, 9.73409>
  translate  <6.97745, 1.16323, 6.96054>
}
#declare _Leaf1B1_1B1_2B4_1B7_Ref = object {
  _Leaf1B1_1B1_2B4_1B7
  scale 0.7
  rotate <0.0, 101.731743, 248.099457>
  translate  <7.04493, 1.08672, 6.97957>
}
#declare _Leaf1B1_1B1_2B4_1B8_Ref = object {
  _Leaf1B1_1B1_2B4_1B8
  scale 0.7
  rotate <0.0, 67.642303, 239.369125>
  translate  <7.21138, 0.97797, 7.00247>
}
#declare _Leaf1B1_1B1_2B4_1B9_Ref = object {
  _Leaf1B1_1B1_2B4_1B9
  scale 0.7
  rotate <0.0, 126.948723, 52.375912>
  translate  <7.2201, 0.98834, 6.98521>
}
#declare _Leaf1B1_1B1_2B4_1B10_Ref = object {
  _Leaf1B1_1B1_2B4_1B10
  scale 0.7
  rotate <0.0, 96.77269, 353.657837>
  translate  <7.38871, 0.88304, 7.01002>
}
#declare _Leaf1B1_1B1_2B4_1B11_Ref = object {
  _Leaf1B1_1B1_2B4_1B11
  scale 0.7
  rotate <0.0, 51.758549, 358.729492>
  translate  <7.38728, 0.88235, 7.01989>
}
#declare _Leaf1B1_1B1_2B4_1B12_Ref = object {
  _Leaf1B1_1B1_2B4_1B12
  scale 0.7
  rotate <0.0, 9.52247, 270.821869>
  translate  <7.38183, 0.87485, 7.02364>
}
#declare _Leaf1B1_1B1_2B5_1B1_Ref = object {
  _Leaf1B1_1B1_2B5_1B1
  scale 0.7
  rotate <0.0, 92.158813, 348.105042>
  translate  <6.72364, 1.858, 6.97399>
}
#declare _Leaf1B1_1B1_2B5_1B2_Ref = object {
  _Leaf1B1_1B1_2B5_1B2
  scale 0.7
  rotate <0.0, 125.967941, 17.39794>
  translate  <6.90864, 1.93491, 6.99572>
}
#declare _Leaf1B1_1B1_2B5_1B3_Ref = object {
  _Leaf1B1_1B1_2B5_1B3
  scale 0.7
  rotate <0.0, 33.14925, 296.042084>
  translate  <6.99708, 1.95907, 7.05615>
}
#declare _Leaf1B1_1B1_2B5_1B4_Ref = object {
  _Leaf1B1_1B1_2B5_1B4
  scale 0.7
  rotate <0.0, 94.679298, 246.249695>
  translate  <7.00399, 1.94155, 7.04478>
}
#declare _Leaf1B1_1B1_2B5_1B5_Ref = object {
  _Leaf1B1_1B1_2B5_1B5
  scale 0.7
  rotate <0.0, 118.0662, 101.190788>
  translate  <7.0916, 2.00578, 7.04037>
}
#declare _Leaf1B1_1B1_2B5_1B6_Ref = object {
  _Leaf1B1_1B1_2B5_1B6
  scale 0.7
  rotate <0.0, 58.27137, 76.232971>
  translate  <7.37466, 2.08304, 7.10571>
}
#declare _Leaf1B1_1B1_2B5_1B7_Ref = object {
  _Leaf1B1_1B1_2B5_1B7
  scale 0.7
  rotate <0.0, 158.951843, 34.212189>
  translate  <7.47701, 2.09812, 7.09763>
}
#declare _Leaf1B1_1B1_2B5_1B8_Ref = object {
  _Leaf1B1_1B1_2B5_1B8
  scale 0.7
  rotate <0.0, 148.366943, 311.242645>
  translate  <7.668, 2.14633, 7.1331>
}
#declare _Leaf1B1_1B1_2B5_1B9_Ref = object {
  _Leaf1B1_1B1_2B5_1B9
  scale 0.7
  rotate <0.0, 44.190811, 115.43428>
  translate  <7.6611, 2.1638, 7.14444>
}
#declare _Leaf1B1_1B1_2B5_1B10_Ref = object {
  _Leaf1B1_1B1_2B5_1B10
  scale 0.7
  rotate <0.0, 55.258389, 32.89241>
  translate  <7.85185, 2.21044, 7.18412>
}
#declare _Leaf1B1_1B1_2B5_1B11_Ref = object {
  _Leaf1B1_1B1_2B5_1B11
  scale 0.7
  rotate <0.0, 53.76754, 336.517548>
  translate  <7.85466, 2.20084, 7.18385>
}
#declare _Leaf1B1_1B1_2B5_1B12_Ref = object {
  _Leaf1B1_1B1_2B5_1B12
  scale 0.7
  rotate <0.0, 89.949699, 296.161041>
  translate  <7.8573, 2.19664, 7.17517>
}
#declare _Leaf1B1_1B1_1B1_1B1_Ref = object {
  _Leaf1B1_1B1_1B1_1B1
  scale 0.7
  rotate <0.0, 129.963959, 339.799896>
  translate  <3.6613, 0.98819, 6.0819>
}
#declare _Leaf1B1_1B1_1B1_1B2_Ref = object {
  _Leaf1B1_1B1_1B1_1B2
  scale 0.7
  rotate <0.0, 169.867523, 24.89249>
  translate  <3.80566, 1.05724, 5.95941>
}
#declare _Leaf1B1_1B1_1B1_1B3_Ref = object {
  _Leaf1B1_1B1_1B1_1B3
  scale 0.7
  rotate <0.0, 57.720718, 337.395447>
  translate  <3.9091, 1.08803, 5.93923>
}
#declare _Leaf1B1_1B1_1B1_1B4_Ref = object {
  _Leaf1B1_1B1_1B1_1B4
  scale 0.7
  rotate <0.0, 67.617828, 253.281662>
  translate  <3.90832, 1.06821, 5.92971>
}
#declare _Leaf1B1_1B1_1B1_1B5_Ref = object {
  _Leaf1B1_1B1_1B1_1B5
  scale 0.7
  rotate <0.0, 112.728371, 124.393318>
  translate  <3.96431, 1.12513, 5.85591>
}
#declare _Leaf1B1_1B1_1B1_1B6_Ref = object {
  _Leaf1B1_1B1_1B1_1B6
  scale 0.7
  rotate <0.0, 84.943443, 64.948471>
  translate  <4.21031, 1.19776, 5.69917>
}
#declare _Leaf1B1_1B1_1B1_1B7_Ref = object {
  _Leaf1B1_1B1_1B1_1B7
  scale 0.7
  rotate <0.0, 155.229614, 181.083633>
  translate  <4.2794, 1.20505, 5.62209>
}
#declare _Leaf1B1_1B1_1B1_1B8_Ref = object {
  _Leaf1B1_1B1_1B1_1B8
  scale 0.7
  rotate <0.0, 140.342255, 244.745544>
  translate  <4.44004, 1.24847, 5.51087>
}
#declare _Leaf1B1_1B1_1B1_1B9_Ref = object {
  _Leaf1B1_1B1_1B1_1B9
  scale 0.7
  rotate <0.0, 53.269871, 75.899178>
  translate  <4.44082, 1.26824, 5.52036>
}
#declare _Leaf1B1_1B1_1B1_1B10_Ref = object {
  _Leaf1B1_1B1_1B1_1B10
  scale 0.7
  rotate <0.0, 97.75901, 31.121349>
  translate  <4.60421, 1.31099, 5.41262>
}
#declare _Leaf1B1_1B1_1B1_1B11_Ref = object {
  _Leaf1B1_1B1_1B1_1B11
  scale 0.7
  rotate <0.0, 90.522133, 346.288788>
  translate  <4.60702, 1.30139, 5.41235>
}
#declare _Leaf1B1_1B1_1B1_1B12_Ref = object {
  _Leaf1B1_1B1_1B1_1B12
  scale 0.7
  rotate <0.0, 97.229881, 294.531342>
  translate  <4.6036, 1.29538, 5.40513>
}
#declare _Leaf1B1_1B1_1B2_1B1_Ref = object {
  _Leaf1B1_1B1_1B2_1B1
  scale 0.7
  rotate <0.0, 29.945669, 311.370392>
  translate  <4.08319, 0.91807, 6.57055>
}
#declare _Leaf1B1_1B1_1B2_1B2_Ref = object {
  _Leaf1B1_1B1_1B2_1B2
  scale 0.7
  rotate <0.0, 64.197212, 272.584839>
  translate  <4.22264, 0.80042, 6.65614>
}
#declare _Leaf1B1_1B1_1B2_1B3_Ref = object {
  _Leaf1B1_1B1_1B2_1B3
  scale 0.7
  rotate <0.0, 61.632061, 55.509541>
  translate  <4.32042, 0.78482, 6.7036>
}
#declare _Leaf1B1_1B1_1B2_1B4_Ref = object {
  _Leaf1B1_1B1_1B2_1B4
  scale 0.7
  rotate <0.0, 71.780418, 136.216156>
  translate  <4.3068, 0.78391, 6.72085>
}
#declare _Leaf1B1_1B1_1B2_1B5_Ref = object {
  _Leaf1B1_1B1_1B2_1B5
  scale 0.7
  rotate <0.0, 133.408905, 268.885529>
  translate  <4.37526, 0.70251, 6.74339>
}
#declare _Leaf1B1_1B1_1B2_1B6_Ref = object {
  _Leaf1B1_1B1_1B2_1B6
  scale 0.7
  rotate <0.0, 114.825768, 346.227203>
  translate  <4.59307, 0.567, 6.90009>
}
#declare _Leaf1B1_1B1_1B2_1B7_Ref = object {
  _Leaf1B1_1B1_1B2_1B7
  scale 0.7
  rotate <0.0, 83.042747, 242.550537>
  translate  <4.64211, 0.50412, 6.9665>
}
#declare _Leaf1B1_1B1_1B2_1B8_Ref = object {
  _Leaf1B1_1B1_1B2_1B8
  scale 0.7
  rotate <0.0, 56.49371, 217.660156>
  translate  <4.78079, 0.40917, 7.07517>
}
#declare _Leaf1B1_1B1_1B2_1B9_Ref = object {
  _Leaf1B1_1B1_1B2_1B9
  scale 0.7
  rotate <0.0, 132.012543, 20.76198>
  translate  <4.79437, 0.41008, 7.05797>
}
#declare _Leaf1B1_1B1_1B2_1B10_Ref = object {
  _Leaf1B1_1B1_1B2_1B10
  scale 0.7
  rotate <0.0, 78.772423, 348.062531>
  translate  <4.93531, 0.31894, 7.16735>
}
#declare _Leaf1B1_1B1_1B2_1B11_Ref = object {
  _Leaf1B1_1B1_1B2_1B11
  scale 0.7
  rotate <0.0, 42.01783, 19.65889>
  translate  <4.93182, 0.3229, 7.17585>
}
#declare _Leaf1B1_1B1_1B2_1B12_Ref = object {
  _Leaf1B1_1B1_1B2_1B12
  scale 0.7
  rotate <0.0, 22.080111, 126.58564>
  translate  <4.92459, 0.31823, 7.18094>
}
#declare _Leaf1B1_1B1_1B3_1B1_Ref = object {
  _Leaf1B1_1B1_1B3_1B1
  scale 0.7
  rotate <0.0, 83.600014, 81.043007>
  translate  <4.16277, 1.37054, 6.59573>
}
#declare _Leaf1B1_1B1_1B3_1B2_Ref = object {
  _Leaf1B1_1B1_1B3_1B2
  scale 0.7
  rotate <0.0, 61.222832, 120.366501>
  translate  <4.21519, 1.51475, 6.72637>
}
#declare _Leaf1B1_1B1_1B3_1B3_Ref = object {
  _Leaf1B1_1B1_1B3_1B3
  scale 0.7
  rotate <0.0, 113.88829, 13.66763>
  translate  <4.28992, 1.57804, 6.77603>
}
#declare _Leaf1B1_1B1_1B3_1B4_Ref = object {
  _Leaf1B1_1B1_1B3_1B4
  scale 0.7
  rotate <0.0, 172.152634, 213.227097>
  translate  <4.28084, 1.59209, 6.76175>
}
#declare _Leaf1B1_1B1_1B3_1B5_Ref = object {
  _Leaf1B1_1B1_1B3_1B5
  scale 0.7
  rotate <0.0, 39.110001, 212.438004>
  translate  <4.28999, 1.65456, 6.85026>
}
#declare _Leaf1B1_1B1_1B3_1B6_Ref = object {
  _Leaf1B1_1B1_1B3_1B6
  scale 0.7
  rotate <0.0, 32.942959, 341.930206>
  translate  <4.40349, 1.88163, 7.01125>
}
#declare _Leaf1B1_1B1_1B3_1B7_Ref = object {
  _Leaf1B1_1B1_1B3_1B7
  scale 0.7
  rotate <0.0, 72.537811, 155.718506>
  translate  <4.41398, 1.97379, 7.05778>
}
#declare _Leaf1B1_1B1_1B3_1B8_Ref = object {
  _Leaf1B1_1B1_1B3_1B8
  scale 0.7
  rotate <0.0, 104.605911, 141.133743>
  translate  <4.48229, 2.12987, 7.16282>
}
#declare _Leaf1B1_1B1_1B3_1B9_Ref = object {
  _Leaf1B1_1B1_1B3_1B9
  scale 0.7
  rotate <0.0, 60.5177, 315.388245>
  translate  <4.49135, 2.11585, 7.17707>
}
#declare _Leaf1B1_1B1_1B3_1B10_Ref = object {
  _Leaf1B1_1B1_1B3_1B10
  scale 0.7
  rotate <0.0, 50.904652, 30.586029>
  translate  <4.5638, 2.27139, 7.28047>
}
#declare _Leaf1B1_1B1_1B3_1B11_Ref = object {
  _Leaf1B1_1B1_1B3_1B11
  scale 0.7
  rotate <0.0, 94.76178, 42.688869>
  translate  <4.56449, 2.27703, 7.27224>
}
#declare _Leaf1B1_1B1_1B3_1B12_Ref = object {
  _Leaf1B1_1B1_1B3_1B12
  scale 0.7
  rotate <0.0, 135.567459, 79.859947>
  translate  <4.55665, 2.28245, 7.26922>
}
#declare _Leaf1B1_1B2_2B1_1B1_Ref = object {
  _Leaf1B1_1B2_2B1_1B1
  scale 0.7
  rotate <0.0, 36.552952, 182.128296>
  translate  <3.25748, 2.16949, 8.49964>
}
#declare _Leaf1B1_1B2_2B1_1B2_Ref = object {
  _Leaf1B1_1B2_2B1_1B2
  scale 0.7
  rotate <0.0, 54.475479, 239.588943>
  translate  <3.24834, 2.12561, 8.69612>
}
#declare _Leaf1B1_1B2_2B1_1B3_Ref = object {
  _Leaf1B1_1B2_2B1_1B3
  scale 0.7
  rotate <0.0, 70.653069, 96.034477>
  translate  <3.25721, 2.15304, 8.80206>
}
#declare _Leaf1B1_1B2_2B1_1B4_Ref = object {
  _Leaf1B1_1B2_2B1_1B4
  scale 0.7
  rotate <0.0, 131.649643, 140.437912>
  translate  <3.23538, 2.1525, 8.79932>
}
#declare _Leaf1B1_1B2_2B1_1B5_Ref = object {
  _Leaf1B1_1B2_2B1_1B5
  scale 0.7
  rotate <0.0, 92.234756, 302.033752>
  translate  <3.24592, 2.10426, 8.89619>
}
#declare _Leaf1B1_1B2_2B1_1B6_Ref = object {
  _Leaf1B1_1B2_2B1_1B6
  scale 0.7
  rotate <0.0, 53.092258, 357.195984>
  translate  <3.21528, 2.08591, 9.19466>
}
#declare _Leaf1B1_1B2_2B1_1B7_Ref = object {
  _Leaf1B1_1B2_2B1_1B7
  scale 0.7
  rotate <0.0, 88.150047, 246.437485>
  translate  <3.17959, 2.06004, 9.2886>
}
#declare _Leaf1B1_1B2_2B1_1B8_Ref = object {
  _Leaf1B1_1B2_2B1_1B8
  scale 0.7
  rotate <0.0, 94.579788, 211.854645>
  translate  <3.1519, 2.04267, 9.48606>
}
#declare _Leaf1B1_1B2_2B1_1B9_Ref = object {
  _Leaf1B1_1B2_2B1_1B9
  scale 0.7
  rotate <0.0, 81.338669, 16.49151>
  translate  <3.17366, 2.04322, 9.4888>
}
#declare _Leaf1B1_1B2_2B1_1B10_Ref = object {
  _Leaf1B1_1B2_2B1_1B10
  scale 0.7
  rotate <0.0, 20.53347, 26.053341>
  translate  <3.14677, 2.03023, 9.68689>
}
#declare _Leaf1B1_1B2_2B1_1B11_Ref = object {
  _Leaf1B1_1B2_2B1_1B11
  scale 0.7
  rotate <0.0, 41.080509, 116.555038>
  translate  <3.13799, 2.03497, 9.6864>
}
#declare _Leaf1B1_1B2_2B1_1B12_Ref = object {
  _Leaf1B1_1B2_2B1_1B12
  scale 0.7
  rotate <0.0, 82.967178, 153.254791>
  translate  <3.12959, 2.0298, 9.68473>
}
#declare _Leaf1B1_1B2_2B2_1B1_Ref = object {
  _Leaf1B1_1B2_2B2_1B1
  scale 0.7
  rotate <0.0, 90.99498, 111.809471>
  translate  <3.27998, 2.67813, 8.62308>
}
#declare _Leaf1B1_1B2_2B2_1B2_Ref = object {
  _Leaf1B1_1B2_2B2_1B2
  scale 0.7
  rotate <0.0, 96.623154, 154.884537>
  translate  <3.16408, 2.81052, 8.72133>
}
#declare _Leaf1B1_1B2_2B2_1B3_Ref = object {
  _Leaf1B1_1B2_2B2_1B3
  scale 0.7
  rotate <0.0, 74.204941, 40.551739>
  translate  <3.14972, 2.89148, 8.7941>
}
#declare _Leaf1B1_1B2_2B2_1B4_Ref = object {
  _Leaf1B1_1B2_2B2_1B4
  scale 0.7
  rotate <0.0, 139.598465, 2.45562>
  translate  <3.1486, 2.90231, 8.77498>
}
#declare _Leaf1B1_1B2_2B2_1B5_Ref = object {
  _Leaf1B1_1B2_2B2_1B5
  scale 0.7
  rotate <0.0, 75.15799, 221.369873>
  translate  <3.06809, 2.94935, 8.83089>
}
#declare _Leaf1B1_1B2_2B2_1B6_Ref = object {
  _Leaf1B1_1B2_2B2_1B6
  scale 0.7
  rotate <0.0, 12.17088, 195.01738>
  translate  <2.93527, 3.17727, 8.97502>
}
#declare _Leaf1B1_1B2_2B2_1B7_Ref = object {
  _Leaf1B1_1B2_2B2_1B7
  scale 0.7
  rotate <0.0, 117.254929, 183.716995>
  translate  <2.87296, 3.25752, 8.99611>
}
#declare _Leaf1B1_1B2_2B2_1B8_Ref = object {
  _Leaf1B1_1B2_2B2_1B8
  scale 0.7
  rotate <0.0, 144.405304, 153.09874>
  translate  <2.7797, 3.41091, 9.08463>
}
#declare _Leaf1B1_1B2_2B2_1B9_Ref = object {
  _Leaf1B1_1B2_2B2_1B9
  scale 0.7
  rotate <0.0, 26.7784, 307.402069>
  translate  <2.78082, 3.40011, 9.1037>
}
#declare _Leaf1B1_1B2_2B2_1B10_Ref = object {
  _Leaf1B1_1B2_2B2_1B10
  scale 0.7
  rotate <0.0, 35.180901, 109.288597>
  translate  <2.69141, 3.55499, 9.19398>
}
#declare _Leaf1B1_1B2_2B2_1B11_Ref = object {
  _Leaf1B1_1B2_2B2_1B11
  scale 0.7
  rotate <0.0, 72.561508, 75.896049>
  translate  <2.69531, 3.56152, 9.18749>
}
#declare _Leaf1B1_1B2_2B2_1B12_Ref = object {
  _Leaf1B1_1B2_2B2_1B12
  scale 0.7
  rotate <0.0, 124.171204, 68.931862>
  translate  <2.69053, 3.56352, 9.17893>
}
#declare _Leaf1B1_1B2_2B3_1B1_Ref = object {
  _Leaf1B1_1B2_2B3_1B1
  scale 0.7
  rotate <0.0, 47.718102, 325.551758>
  translate  <3.84673, 2.77658, 9.13105>
}
#declare _Leaf1B1_1B2_2B3_1B2_Ref = object {
  _Leaf1B1_1B2_2B3_1B2
  scale 0.7
  rotate <0.0, 90.968338, 328.36261>
  translate  <4.02928, 2.78657, 9.21584>
}
#declare _Leaf1B1_1B2_2B3_1B3_Ref = object {
  _Leaf1B1_1B2_2B3_1B3
  scale 0.7
  rotate <0.0, 24.822861, 135.915634>
  translate  <4.09833, 2.82245, 9.2933>
}
#declare _Leaf1B1_1B2_2B3_1B4_Ref = object {
  _Leaf1B1_1B2_2B3_1B4
  scale 0.7
  rotate <0.0, 79.559067, 209.156418>
  translate  <4.0948, 2.80168, 9.29963>
}
#declare _Leaf1B1_1B2_2B3_1B5_Ref = object {
  _Leaf1B1_1B2_2B3_1B5
  scale 0.7
  rotate <0.0, 146.856186, 19.98349>
  translate  <4.20179, 2.8112, 9.31646>
}
#declare _Leaf1B1_1B2_2B3_1B6_Ref = object {
  _Leaf1B1_1B2_2B3_1B6
  scale 0.7
  rotate <0.0, 89.231987, 55.634022>
  translate  <4.44904, 2.82774, 9.48661>
}
#declare _Leaf1B1_1B2_2B3_1B7_Ref = object {
  _Leaf1B1_1B2_2B3_1B7
  scale 0.7
  rotate <0.0, 119.508583, 308.43811>
  translate  <4.53685, 2.80194, 9.53553>
}
#declare _Leaf1B1_1B2_2B3_1B8_Ref = object {
  _Leaf1B1_1B2_2B3_1B8
  scale 0.7
  rotate <0.0, 96.003479, 280.715393>
  translate  <4.70297, 2.80422, 9.64714>
}
#declare _Leaf1B1_1B2_2B3_1B9_Ref = object {
  _Leaf1B1_1B2_2B3_1B9
  scale 0.7
  rotate <0.0, 94.065147, 88.530403>
  translate  <4.7065, 2.82493, 9.64082>
}
#declare _Leaf1B1_1B2_2B3_1B10_Ref = object {
  _Leaf1B1_1B2_2B3_1B10
  scale 0.7
  rotate <0.0, 57.956219, 36.532719>
  translate  <4.87058, 2.82959, 9.75566>
}
#declare _Leaf1B1_1B2_2B3_1B11_Ref = object {
  _Leaf1B1_1B2_2B3_1B11
  scale 0.7
  rotate <0.0, 13.81033, 15.33557>
  translate  <4.86669, 2.82306, 9.76216>
}
#declare _Leaf1B1_1B2_2B3_1B12_Ref = object {
  _Leaf1B1_1B2_2B3_1B12
  scale 0.7
  rotate <0.0, 43.027771, 249.787384>
  translate  <4.8678, 2.81324, 9.76065>
}
#declare _Leaf1B1_1B2_2B4_1B1_Ref = object {
  _Leaf1B1_1B2_2B4_1B1
  scale 0.7
  rotate <0.0, 98.504837, 32.535019>
  translate  <3.81399, 3.16721, 9.10277>
}
#declare _Leaf1B1_1B2_2B4_1B2_Ref = object {
  _Leaf1B1_1B2_2B4_1B2
  scale 0.7
  rotate <0.0, 135.503204, 58.727131>
  translate  <3.88977, 3.35346, 9.08933>
}
#declare _Leaf1B1_1B2_2B4_1B3_Ref = object {
  _Leaf1B1_1B2_2B4_1B3
  scale 0.7
  rotate <0.0, 31.94895, 357.764252>
  translate  <3.9356, 3.44288, 9.13361>
}
#declare _Leaf1B1_1B2_2B4_1B4_Ref = object {
  _Leaf1B1_1B2_2B4_1B4
  scale 0.7
  rotate <0.0, 85.16568, 291.473694>
  translate  <3.95277, 3.43347, 9.12356>
}
#declare _Leaf1B1_1B2_2B4_1B5_Ref = object {
  _Leaf1B1_1B2_2B4_1B5
  scale 0.7
  rotate <0.0, 122.830269, 151.954742>
  translate  <3.96871, 3.53828, 9.09943>
}
#declare _Leaf1B1_1B2_2B4_1B6_Ref = object {
  _Leaf1B1_1B2_2B4_1B6
  scale 0.7
  rotate <0.0, 67.020683, 118.397614>
  translate  <4.11378, 3.80108, 9.11524>
}
#declare _Leaf1B1_1B2_2B4_1B7_Ref = object {
  _Leaf1B1_1B2_2B4_1B7
  scale 0.7
  rotate <0.0, 169.353714, 73.17952>
  translate  <4.17497, 3.88141, 9.09132>
}
#declare _Leaf1B1_1B2_2B4_1B8_Ref = object {
  _Leaf1B1_1B2_2B4_1B8
  scale 0.7
  rotate <0.0, 146.918625, 339.881714>
  translate  <4.27553, 4.05444, 9.09398>
}
#declare _Leaf1B1_1B2_2B4_1B9_Ref = object {
  _Leaf1B1_1B2_2B4_1B9
  scale 0.7
  rotate <0.0, 47.834728, 151.064758>
  translate  <4.25841, 4.06381, 9.104>
}
#declare _Leaf1B1_1B2_2B4_1B10_Ref = object {
  _Leaf1B1_1B2_2B4_1B10
  scale 0.7
  rotate <0.0, 65.70488, 78.887833>
  translate  <4.35998, 4.23635, 9.11102>
}
#declare _Leaf1B1_1B2_2B4_1B11_Ref = object {
  _Leaf1B1_1B2_2B4_1B11
  scale 0.7
  rotate <0.0, 58.869709, 27.905319>
  translate  <4.36877, 4.2316, 9.11152>
}
#declare _Leaf1B1_1B2_2B4_1B12_Ref = object {
  _Leaf1B1_1B2_2B4_1B12
  scale 0.7
  rotate <0.0, 87.310829, 341.623505>
  translate  <4.3735, 4.22895, 9.10312>
}
#declare _Leaf1B1_1B2_2B5_1B1_Ref = object {
  _Leaf1B1_1B2_2B5_1B1
  scale 0.7
  rotate <0.0, 70.011719, 72.648743>
  translate  <3.81403, 3.2894, 9.55756>
}
#declare _Leaf1B1_1B2_2B5_1B2_Ref = object {
  _Leaf1B1_1B2_2B5_1B2
  scale 0.7
  rotate <0.0, 59.900841, 119.498466>
  translate  <3.85142, 3.39761, 9.7234>
}
#declare _Leaf1B1_1B2_2B5_1B3_Ref = object {
  _Leaf1B1_1B2_2B5_1B3
  scale 0.7
  rotate <0.0, 97.120331, 4.4799>
  translate  <3.91888, 3.43509, 9.8015>
}
#declare _Leaf1B1_1B2_2B5_1B4_Ref = object {
  _Leaf1B1_1B2_2B5_1B4
  scale 0.7
  rotate <0.0, 169.305893, 33.04081>
  translate  <3.91663, 3.45276, 9.78858>
}
#declare _Leaf1B1_1B2_2B5_1B5_Ref = object {
  _Leaf1B1_1B2_2B5_1B5
  scale 0.7
  rotate <0.0, 57.458981, 202.900986>
  translate  <3.91112, 3.49777, 9.8874>
}
#declare _Leaf1B1_1B2_2B5_1B6_Ref = object {
  _Leaf1B1_1B2_2B5_1B6
  scale 0.7
  rotate <0.0, 27.384199, 299.508118>
  translate  <4.01174, 3.66819, 10.11366>
}
#declare _Leaf1B1_1B2_2B5_1B7_Ref = object {
  _Leaf1B1_1B2_2B5_1B7
  scale 0.7
  rotate <0.0, 81.256073, 148.18335>
  translate  <4.02419, 3.74786, 10.17897>
}
#declare _Leaf1B1_1B2_2B5_1B8_Ref = object {
  _Leaf1B1_1B2_2B5_1B8
  scale 0.7
  rotate <0.0, 107.463081, 124.480812>
  translate  <4.08573, 3.86793, 10.3268>
}
#declare _Leaf1B1_1B2_2B5_1B9_Ref = object {
  _Leaf1B1_1B2_2B5_1B9
  scale 0.7
  rotate <0.0, 60.376209, 293.453613>
  translate  <4.08797, 3.85032, 10.33969>
}
#declare _Leaf1B1_1B2_2B5_1B10_Ref = object {
  _Leaf1B1_1B2_2B5_1B10
  scale 0.7
  rotate <0.0, 32.77533, 15.22484>
  translate  <4.15381, 3.96922, 10.48686>
}
#declare _Leaf1B1_1B2_2B5_1B11_Ref = object {
  _Leaf1B1_1B2_2B5_1B11
  scale 0.7
  rotate <0.0, 76.33075, 31.40271>
  translate  <4.1577, 3.97575, 10.48036>
}
#declare _Leaf1B1_1B2_2B5_1B12_Ref = object {
  _Leaf1B1_1B2_2B5_1B12
  scale 0.7
  rotate <0.0, 120.533218, 59.940891>
  translate  <4.15204, 3.98313, 10.47669>
}
#declare _Leaf1B1_1B2_1B1_1B1_Ref = object {
  _Leaf1B1_1B2_1B1_1B1
  scale 0.7
  rotate <0.0, 87.467621, 107.870743>
  translate  <2.5709, 1.53327, 7.04737>
}
#declare _Leaf1B1_1B2_1B1_1B2_Ref = object {
  _Leaf1B1_1B2_1B1_1B2
  scale 0.7
  rotate <0.0, 92.072258, 150.962036>
  translate  <2.47128, 1.66872, 7.15847>
}
#declare _Leaf1B1_1B2_1B1_1B3_Ref = object {
  _Leaf1B1_1B2_1B1_1B3
  scale 0.7
  rotate <0.0, 75.85183, 35.51384>
  translate  <2.46746, 1.74725, 7.23511>
}
#declare _Leaf1B1_1B2_1B1_1B4_Ref = object {
  _Leaf1B1_1B2_1B1_1B4
  scale 0.7
  rotate <0.0, 143.430771, 1.67137>
  translate  <2.46582, 1.75894, 7.21654>
}
#declare _Leaf1B1_1B2_1B1_1B5_Ref = object {
  _Leaf1B1_1B2_1B1_1B5
  scale 0.7
  rotate <0.0, 73.659721, 218.672638>
  translate  <2.39268, 1.80879, 7.27969>
}
#declare _Leaf1B1_1B2_1B1_1B6_Ref = object {
  _Leaf1B1_1B2_1B1_1B6
  scale 0.7
  rotate <0.0, 9.42116, 210.456146>
  translate  <2.2859, 2.03862, 7.44135>
}
#declare _Leaf1B1_1B2_1B1_1B7_Ref = object {
  _Leaf1B1_1B2_1B1_1B7
  scale 0.7
  rotate <0.0, 113.386787, 178.672852>
  translate  <2.23086, 2.12186, 7.4698>
}
#declare _Leaf1B1_1B2_1B1_1B8_Ref = object {
  _Leaf1B1_1B2_1B1_1B8
  scale 0.7
  rotate <0.0, 139.847137, 149.008072>
  translate  <2.15458, 2.27716, 7.57042>
}
#declare _Leaf1B1_1B2_1B1_1B9_Ref = object {
  _Leaf1B1_1B2_1B1_1B9
  scale 0.7
  rotate <0.0, 31.00345, 306.62381>
  translate  <2.15622, 2.2655, 7.58894>
}
#declare _Leaf1B1_1B2_1B1_1B10_Ref = object {
  _Leaf1B1_1B2_1B1_1B10
  scale 0.7
  rotate <0.0, 31.91065, 100.584824>
  translate  <2.084, 2.42196, 7.69111>
}
#declare _Leaf1B1_1B2_1B1_1B11_Ref = object {
  _Leaf1B1_1B2_1B1_1B11
  scale 0.7
  rotate <0.0, 71.454712, 70.558472>
  translate  <2.0879, 2.42849, 7.68461>
}
#declare _Leaf1B1_1B2_1B1_1B12_Ref = object {
  _Leaf1B1_1B2_1B1_1B12
  scale 0.7
  rotate <0.0, 123.433617, 68.047058>
  translate  <2.08271, 2.43116, 7.67649>
}
#declare _Leaf1B1_1B2_1B2_1B1_Ref = object {
  _Leaf1B1_1B2_1B2_1B1
  scale 0.7
  rotate <0.0, 88.529457, 5.0721>
  translate  <3.13969, 1.71334, 7.30378>
}
#declare _Leaf1B1_1B2_1B2_1B2_Ref = object {
  _Leaf1B1_1B2_1B2_1B2
  scale 0.7
  rotate <0.0, 129.918457, 19.067591>
  translate  <3.29326, 1.84362, 7.29635>
}
#declare _Leaf1B1_1B2_1B2_1B3_Ref = object {
  _Leaf1B1_1B2_1B2_1B3
  scale 0.7
  rotate <0.0, 17.7859, 341.541962>
  translate  <3.36561, 1.91098, 7.34414>
}
#declare _Leaf1B1_1B2_1B2_1B4_Ref = object {
  _Leaf1B1_1B2_1B2_1B4
  scale 0.7
  rotate <0.0, 76.272072, 262.726715>
  translate  <3.37813, 1.89353, 7.33935>
}
#declare _Leaf1B1_1B2_1B2_1B5_Ref = object {
  _Leaf1B1_1B2_1B2_1B5
  scale 0.7
  rotate <0.0, 137.333145, 122.221764>
  translate  <3.44447, 1.97539, 7.31255>
}
#declare _Leaf1B1_1B2_1B2_1B6_Ref = object {
  _Leaf1B1_1B2_1B2_1B6
  scale 0.7
  rotate <0.0, 77.782654, 94.924042>
  translate  <3.68773, 2.14895, 7.3451>
}
#declare _Leaf1B1_1B2_1B2_1B7_Ref = object {
  _Leaf1B1_1B2_1B2_1B7
  scale 0.7
  rotate <0.0, 161.622513, 353.118591>
  translate  <3.78216, 2.18977, 7.33143>
}
#declare _Leaf1B1_1B2_1B2_1B8_Ref = object {
  _Leaf1B1_1B2_1B2_1B8
  scale 0.7
  rotate <0.0, 132.038315, 314.205505>
  translate  <3.94817, 2.30052, 7.34663>
}
#declare _Leaf1B1_1B2_1B2_1B9_Ref = object {
  _Leaf1B1_1B2_1B2_1B9
  scale 0.7
  rotate <0.0, 62.429722, 126.440376>
  translate  <3.93569, 2.31792, 7.35141>
}
#declare _Leaf1B1_1B2_1B2_1B10_Ref = object {
  _Leaf1B1_1B2_1B2_1B10
  scale 0.7
  rotate <0.0, 67.807617, 58.49107>
  translate  <4.10153, 2.42857, 7.37111>
}
#declare _Leaf1B1_1B2_1B2_1B11_Ref = object {
  _Leaf1B1_1B2_1B2_1B11
  scale 0.7
  rotate <0.0, 48.82756, 9.2696>
  translate  <4.1069, 2.42068, 7.3741>
}
#declare _Leaf1B1_1B2_1B2_1B12_Ref = object {
  _Leaf1B1_1B2_1B2_1B12
  scale 0.7
  rotate <0.0, 72.415787, 314.732056>
  translate  <4.11138, 2.41484, 7.36733>
}
#declare _Leaf1B1_1B2_1B3_1B1_Ref = object {
  _Leaf1B1_1B2_1B3_1B1
  scale 0.7
  rotate <0.0, 23.85371, 238.022842>
  translate  <3.01942, 1.57224, 7.72487>
}
#declare _Leaf1B1_1B2_1B3_1B2_Ref = object {
  _Leaf1B1_1B2_1B3_1B2
  scale 0.7
  rotate <0.0, 61.364529, 273.462372>
  translate  <3.09813, 1.50093, 7.89614>
}
#declare _Leaf1B1_1B2_1B3_1B3_Ref = object {
  _Leaf1B1_1B2_1B3_1B3
  scale 0.7
  rotate <0.0, 54.870338, 105.892014>
  translate  <3.13847, 1.5146, 7.99734>
}
#declare _Leaf1B1_1B2_1B3_1B4_Ref = object {
  _Leaf1B1_1B2_1B3_1B4
  scale 0.7
  rotate <0.0, 107.805107, 159.729324>
  translate  <3.11833, 1.50678, 8.00149>
}
#declare _Leaf1B1_1B2_1B3_1B5_Ref = object {
  _Leaf1B1_1B2_1B3_1B5
  scale 0.7
  rotate <0.0, 114.765984, 319.392914>
  translate  <3.17784, 1.45232, 8.07439>
}
#declare _Leaf1B1_1B2_1B3_1B6_Ref = object {
  _Leaf1B1_1B2_1B3_1B6
  scale 0.7
  rotate <0.0, 73.128014, 9.73196>
  translate  <3.26913, 1.38275, 8.35221>
}
#declare _Leaf1B1_1B2_1B3_1B7_Ref = object {
  _Leaf1B1_1B2_1B3_1B7
  scale 0.7
  rotate <0.0, 94.687202, 265.148102>
  translate  <3.28051, 1.33307, 8.44261>
}
#declare _Leaf1B1_1B2_1B3_1B8_Ref = object {
  _Leaf1B1_1B2_1B3_1B8
  scale 0.7
  rotate <0.0, 86.817932, 230.86261>
  translate  <3.33581, 1.27959, 8.62738>
}
#declare _Leaf1B1_1B2_1B3_1B9_Ref = object {
  _Leaf1B1_1B2_1B3_1B9
  scale 0.7
  rotate <0.0, 94.906853, 35.12381>
  translate  <3.35589, 1.28739, 8.62323>
}
#declare _Leaf1B1_1B2_1B3_1B10_Ref = object {
  _Leaf1B1_1B2_1B3_1B10
  scale 0.7
  rotate <0.0, 37.064919, 11.74671>
  translate  <3.41094, 1.23816, 8.80946>
}
#declare _Leaf1B1_1B2_1B3_1B11_Ref = object {
  _Leaf1B1_1B2_1B3_1B11
  scale 0.7
  rotate <0.0, 21.201839, 112.337509>
  translate  <3.40167, 1.23952, 8.81297>
}
#declare _Leaf1B1_1B2_1B3_1B12_Ref = object {
  _Leaf1B1_1B2_1B3_1B12
  scale 0.7
  rotate <0.0, 59.785801, 174.48291>
  translate  <3.39508, 1.232, 8.81273>
}
#declare _Leaf1B1_1B3_2B1_1B1_Ref = object {
  _Leaf1B1_1B3_2B1_1B1
  scale 0.7
  rotate <0.0, 104.158768, 302.942688>
  translate  <4.29908, -0.44988, 8.10854>
}
#declare _Leaf1B1_1B3_2B1_1B2_Ref = object {
  _Leaf1B1_1B3_2B1_1B2
  scale 0.7
  rotate <0.0, 137.523148, 336.274872>
  translate  <4.48483, -0.52597, 8.09061>
}
#declare _Leaf1B1_1B3_2B1_1B3_Ref = object {
  _Leaf1B1_1B3_2B1_1B3
  scale 0.7
  rotate <0.0, 39.9519, 265.133698>
  translate  <4.57222, -0.57881, 8.13093>
}
#declare _Leaf1B1_1B3_2B1_1B4_Ref = object {
  _Leaf1B1_1B3_2B1_1B4
  scale 0.7
  rotate <0.0, 89.754379, 201.009369>
  translate  <4.56297, -0.59429, 8.11832>
}
#declare _Leaf1B1_1B3_2B1_1B5_Ref = object {
  _Leaf1B1_1B3_2B1_1B5
  scale 0.7
  rotate <0.0, 114.979912, 62.33247>
  translate  <4.66833, -0.60839, 8.09551>
}
#declare _Leaf1B1_1B3_2B1_1B6_Ref = object {
  _Leaf1B1_1B3_2B1_1B6
  scale 0.7
  rotate <0.0, 61.83374, 24.64109>
  translate  <4.92885, -0.7583, 8.09938>
}
#declare _Leaf1B1_1B3_2B1_1B7_Ref = object {
  _Leaf1B1_1B3_2B1_1B7
  scale 0.7
  rotate <0.0, 167.107147, 20.791189>
  translate  <5.00925, -0.81685, 8.06978>
}
#declare _Leaf1B1_1B3_2B1_1B8_Ref = object {
  _Leaf1B1_1B3_2B1_1B8
  scale 0.7
  rotate <0.0, 154.947845, 246.977585>
  translate  <5.18097, -0.91949, 8.06397>
}
#declare _Leaf1B1_1B3_2B1_1B9_Ref = object {
  _Leaf1B1_1B3_2B1_1B9
  scale 0.7
  rotate <0.0, 40.089291, 57.777771>
  translate  <5.1902, -0.90406, 8.07654>
}
#declare _Leaf1B1_1B3_2B1_1B10_Ref = object {
  _Leaf1B1_1B3_2B1_1B10
  scale 0.7
  rotate <0.0, 65.730362, 344.458099>
  translate  <5.36128, -1.00828, 8.07489>
}
#declare _Leaf1B1_1B3_2B1_1B11_Ref = object {
  _Leaf1B1_1B3_2B1_1B11
  scale 0.7
  rotate <0.0, 65.155151, 294.40686>
  translate  <5.35642, -1.01698, 8.07403>
}
#declare _Leaf1B1_1B3_2B1_1B12_Ref = object {
  _Leaf1B1_1B3_2B1_1B12
  scale 0.7
  rotate <0.0, 95.387039, 250.842865>
  translate  <5.354, -1.02047, 8.06497>
}
#declare _Leaf1B1_1B3_2B2_1B1_Ref = object {
  _Leaf1B1_1B3_2B2_1B1
  scale 0.7
  rotate <0.0, 55.31995, 237.057877>
  translate  <4.24436, -0.71223, 8.55869>
}
#declare _Leaf1B1_1B3_2B2_1B2_Ref = object {
  _Leaf1B1_1B3_2B2_1B2
  scale 0.7
  rotate <0.0, 98.643494, 237.378418>
  translate  <4.24953, -0.90482, 8.61782>
}
#declare _Leaf1B1_1B3_2B2_1B3_Ref = object {
  _Leaf1B1_1B3_2B2_1B3
  scale 0.7
  rotate <0.0, 18.35042, 32.594051>
  translate  <4.28207, -0.9844, 8.68611>
}
#declare _Leaf1B1_1B3_2B2_1B4_Ref = object {
  _Leaf1B1_1B3_2B2_1B4
  scale 0.7
  rotate <0.0, 73.578667, 119.708>
  translate  <4.26114, -0.98145, 8.69222>
}
#declare _Leaf1B1_1B3_2B2_1B5_Ref = object {
  _Leaf1B1_1B3_2B2_1B5
  scale 0.7
  rotate <0.0, 153.358185, 297.741241>
  translate  <4.26893, -1.08987, 8.69444>
}
#declare _Leaf1B1_1B3_2B2_1B6_Ref = object {
  _Leaf1B1_1B3_2B2_1B6
  scale 0.7
  rotate <0.0, 92.217293, 324.967773>
  translate  <4.27711, -1.35836, 8.82936>
}
#declare _Leaf1B1_1B3_2B2_1B7_Ref = object {
  _Leaf1B1_1B3_2B2_1B7
  scale 0.7
  rotate <0.0, 125.68792, 214.300964>
  translate  <4.24875, -1.45164, 8.86491>
}
#declare _Leaf1B1_1B3_2B2_1B8_Ref = object {
  _Leaf1B1_1B3_2B2_1B8
  scale 0.7
  rotate <0.0, 99.176743, 188.956299>
  translate  <4.24551, -1.63153, 8.9526>
}
#declare _Leaf1B1_1B3_2B2_1B9_Ref = object {
  _Leaf1B1_1B3_2B2_1B9
  scale 0.7
  rotate <0.0, 92.441406, 358.221252>
  translate  <4.26638, -1.63447, 8.9465>
}
#declare _Leaf1B1_1B3_2B2_1B10_Ref = object {
  _Leaf1B1_1B3_2B2_1B10
  scale 0.7
  rotate <0.0, 63.43412, 302.400391>
  translate  <4.26544, -1.81282, 9.03775>
}
#declare _Leaf1B1_1B3_2B2_1B11_Ref = object {
  _Leaf1B1_1B3_2B2_1B11
  scale 0.7
  rotate <0.0, 21.30756, 274.497009>
  translate  <4.25874, -1.80975, 9.04451>
}
#declare _Leaf1B1_1B3_2B2_1B12_Ref = object {
  _Leaf1B1_1B3_2B2_1B12
  scale 0.7
  rotate <0.0, 42.59251, 167.796585>
  translate  <4.24896, -1.81049, 9.04256>
}
#declare _Leaf1B1_1B3_2B3_1B1_Ref = object {
  _Leaf1B1_1B3_2B3_1B1
  scale 0.7
  rotate <0.0, 86.393356, 20.89488>
  translate  <4.84293, -0.54385, 9.00846>
}
#declare _Leaf1B1_1B3_2B3_1B2_Ref = object {
  _Leaf1B1_1B3_2B3_1B2
  scale 0.7
  rotate <0.0, 88.694008, 64.203102>
  translate  <4.97327, -0.44458, 9.12582>
}
#declare _Leaf1B1_1B3_2B3_1B3_Ref = object {
  _Leaf1B1_1B3_2B3_1B3
  scale 0.7
  rotate <0.0, 79.144661, 308.261261>
  translate  <5.05193, -0.4416, 9.20236>
}
#declare _Leaf1B1_1B3_2B3_1B4_Ref = object {
  _Leaf1B1_1B3_2B3_1B4
  scale 0.7
  rotate <0.0, 147.370834, 274.869293>
  translate  <5.0634, -0.43803, 9.18392>
}
#declare _Leaf1B1_1B3_2B3_1B5_Ref = object {
  _Leaf1B1_1B3_2B3_1B5
  scale 0.7
  rotate <0.0, 70.516769, 132.668716>
  translate  <5.10945, -0.3667, 9.25182>
}
#declare _Leaf1B1_1B3_2B3_1B6_Ref = object {
  _Leaf1B1_1B3_2B3_1B6
  scale 0.7
  rotate <0.0, 6.24568, 141.07106>
  translate  <5.33393, -0.25845, 9.4199>
}
#declare _Leaf1B1_1B3_2B3_1B7_Ref = object {
  _Leaf1B1_1B3_2B3_1B7
  scale 0.7
  rotate <0.0, 109.45295, 91.987671>
  translate  <5.41413, -0.20087, 9.45187>
}
#declare _Leaf1B1_1B3_2B3_1B8_Ref = object {
  _Leaf1B1_1B3_2B3_1B8
  scale 0.7
  rotate <0.0, 136.496872, 64.555588>
  translate  <5.56552, -0.12302, 9.55712>
}
#declare _Leaf1B1_1B3_2B3_1B9_Ref = object {
  _Leaf1B1_1B3_2B3_1B9
  scale 0.7
  rotate <0.0, 33.386631, 224.841827>
  translate  <5.55409, -0.12658, 9.57551>
}
#declare _Leaf1B1_1B3_2B3_1B10_Ref = object {
  _Leaf1B1_1B3_2B3_1B10
  scale 0.7
  rotate <0.0, 31.53528, 7.46157>
  translate  <5.70689, -0.05282, 9.68203>
}
#declare _Leaf1B1_1B3_2B3_1B11_Ref = object {
  _Leaf1B1_1B3_2B3_1B11
  scale 0.7
  rotate <0.0, 72.93013, 342.611877>
  translate  <5.71358, -0.05588, 9.67527>
}
#declare _Leaf1B1_1B3_2B3_1B12_Ref = object {
  _Leaf1B1_1B3_2B3_1B12
  scale 0.7
  rotate <0.0, 124.953133, 343.745941>
  translate  <5.71591, -0.05001, 9.66751>
}
#declare _Leaf1B1_1B3_2B4_1B1_Ref = object {
  _Leaf1B1_1B3_2B4_1B1
  scale 0.7
  rotate <0.0, 28.775909, 95.014458>
  translate  <4.67589, -0.72884, 9.31233>
}
#declare _Leaf1B1_1B3_2B4_1B2_Ref = object {
  _Leaf1B1_1B3_2B4_1B2
  scale 0.7
  rotate <0.0, 52.406429, 154.659363>
  translate  <4.62565, -0.74608, 9.50674>
}
#declare _Leaf1B1_1B3_2B4_1B3_Ref = object {
  _Leaf1B1_1B3_2B4_1B3
  scale 0.7
  rotate <0.0, 68.229172, 2.36222>
  translate  <4.64946, -0.76983, 9.61126>
}
#declare _Leaf1B1_1B3_2B4_1B4_Ref = object {
  _Leaf1B1_1B3_2B4_1B4
  scale 0.7
  rotate <0.0, 124.316673, 52.40197>
  translate  <4.64925, -0.74783, 9.61153>
}
#declare _Leaf1B1_1B3_2B4_1B5_Ref = object {
  _Leaf1B1_1B3_2B4_1B5
  scale 0.7
  rotate <0.0, 97.931892, 210.756485>
  translate  <4.59773, -0.77082, 9.70447>
}
#declare _Leaf1B1_1B3_2B4_1B6_Ref = object {
  _Leaf1B1_1B3_2B4_1B6
  scale 0.7
  rotate <0.0, 61.096001, 265.563477>
  translate  <4.56987, -0.78115, 10.0036>
}
#declare _Leaf1B1_1B3_2B4_1B7_Ref = object {
  _Leaf1B1_1B3_2B4_1B7
  scale 0.7
  rotate <0.0, 86.652809, 156.038193>
  translate  <4.54131, -0.7583, 10.10071>
}
#declare _Leaf1B1_1B3_2B4_1B8_Ref = object {
  _Leaf1B1_1B3_2B4_1B8
  scale 0.7
  rotate <0.0, 88.790649, 120.925011>
  translate  <4.51774, -0.7577, 10.29946>
}
#declare _Leaf1B1_1B3_2B4_1B9_Ref = object {
  _Leaf1B1_1B3_2B4_1B9
  scale 0.7
  rotate <0.0, 88.433517, 285.376038>
  translate  <4.51795, -0.77963, 10.29919>
}
#declare _Leaf1B1_1B3_2B4_1B10_Ref = object {
  _Leaf1B1_1B3_2B4_1B10
  scale 0.7
  rotate <0.0, 27.31295, 285.104431>
  translate  <4.49872, -0.77999, 10.4986>
}
#declare _Leaf1B1_1B3_2B4_1B11_Ref = object {
  _Leaf1B1_1B3_2B4_1B11
  scale 0.7
  rotate <0.0, 36.387959, 17.50272>
  translate  <4.50358, -0.7713, 10.49947>
}
#declare _Leaf1B1_1B3_2B4_1B12_Ref = object {
  _Leaf1B1_1B3_2B4_1B12
  scale 0.7
  rotate <0.0, 75.098244, 62.107239>
  translate  <4.49855, -0.76267, 10.49881>
}
#declare _Leaf1B1_1B3_2B5_1B1_Ref = object {
  _Leaf1B1_1B3_2B5_1B1
  scale 0.7
  rotate <0.0, 20.10796, 285.291473>
  translate  <5.03732, -0.98719, 9.46848>
}
#declare _Leaf1B1_1B3_2B5_1B2_Ref = object {
  _Leaf1B1_1B3_2B5_1B2
  scale 0.7
  rotate <0.0, 62.88599, 273.449951>
  translate  <5.1597, -1.08044, 9.59863>
}
#declare _Leaf1B1_1B3_2B5_1B3_Ref = object {
  _Leaf1B1_1B3_2B5_1B3
  scale 0.7
  rotate <0.0, 54.157959, 77.024628>
  translate  <5.23789, -1.0797, 9.67571>
}
#declare _Leaf1B1_1B3_2B5_1B4_Ref = object {
  _Leaf1B1_1B3_2B5_1B4
  scale 0.7
  rotate <0.0, 87.09024, 148.754562>
  translate  <5.21978, -1.08342, 9.68764>
}
#declare _Leaf1B1_1B3_2B5_1B5_Ref = object {
  _Leaf1B1_1B3_2B5_1B5
  scale 0.7
  rotate <0.0, 128.990707, 295.69986>
  translate  <5.29033, -1.15198, 9.73394>
}
#declare _Leaf1B1_1B3_2B5_1B6_Ref = object {
  _Leaf1B1_1B3_2B5_1B6
  scale 0.7
  rotate <0.0, 95.967239, 357.30603>
  translate  <5.46556, -1.25073, 9.95733>
}
#declare _Leaf1B1_1B3_2B5_1B7_Ref = object {
  _Leaf1B1_1B3_2B5_1B7
  scale 0.7
  rotate <0.0, 90.186523, 251.900543>
  translate  <5.50056, -1.30557, 10.03817>
}
#declare _Leaf1B1_1B3_2B5_1B8_Ref = object {
  _Leaf1B1_1B3_2B5_1B8
  scale 0.7
  rotate <0.0, 70.991783, 221.892563>
  translate  <5.61076, -1.37719, 10.18912>
}
#declare _Leaf1B1_1B3_2B5_1B9_Ref = object {
  _Leaf1B1_1B3_2B5_1B9
  scale 0.7
  rotate <0.0, 114.635551, 25.980261>
  translate  <5.62881, -1.37348, 10.17722>
}
#declare _Leaf1B1_1B3_2B5_1B10_Ref = object {
  _Leaf1B1_1B3_2B5_1B10
  scale 0.7
  rotate <0.0, 59.871231, 357.678345>
  translate  <5.74021, -1.44096, 10.32944>
}
#declare _Leaf1B1_1B3_2B5_1B11_Ref = object {
  _Leaf1B1_1B3_2B5_1B11
  scale 0.7
  rotate <0.0, 25.9977, 45.871922>
  translate  <5.73351, -1.43789, 10.33621>
}
#declare _Leaf1B1_1B3_2B5_1B12_Ref = object {
  _Leaf1B1_1B3_2B5_1B12
  scale 0.7
  rotate <0.0, 37.522869, 157.329605>
  translate  <5.72596, -1.44389, 10.33884>
}
#declare _Leaf1B1_1B3_1B1_1B1_Ref = object {
  _Leaf1B1_1B3_1B1_1B1
  scale 0.7
  rotate <0.0, 50.929909, 240.74263>
  translate  <3.0072, -0.04957, 7.03335>
}
#declare _Leaf1B1_1B3_1B1_1B2_Ref = object {
  _Leaf1B1_1B3_1B1_1B2
  scale 0.7
  rotate <0.0, 94.249008, 241.490631>
  translate  <3.02793, -0.23664, 7.10538>
}
#declare _Leaf1B1_1B3_1B1_1B3_Ref = object {
  _Leaf1B1_1B3_1B1_1B3
  scale 0.7
  rotate <0.0, 22.257641, 42.26115>
  translate  <3.06811, -0.3087, 7.17783>
}
#declare _Leaf1B1_1B3_1B1_1B4_Ref = object {
  _Leaf1B1_1B3_1B1_1B4
  scale 0.7
  rotate <0.0, 76.060623, 122.77578>
  translate  <3.04722, -0.30678, 7.18444>
}
#declare _Leaf1B1_1B3_1B1_1B5_Ref = object {
  _Leaf1B1_1B3_1B1_1B5
  scale 0.7
  rotate <0.0, 150.580383, 295.333038>
  translate  <3.06283, -0.41396, 7.19385>
}
#declare _Leaf1B1_1B3_1B1_1B6_Ref = object {
  _Leaf1B1_1B3_1B1_1B6
  scale 0.7
  rotate <0.0, 91.565643, 328.883636>
  translate  <3.09426, -0.67096, 7.34658>
}
#declare _Leaf1B1_1B3_1B1_1B7_Ref = object {
  _Leaf1B1_1B3_1B1_1B7
  scale 0.7
  rotate <0.0, 121.799454, 219.764465>
  translate  <3.07374, -0.76322, 7.38942>
}
#declare _Leaf1B1_1B3_1B1_1B8_Ref = object {
  _Leaf1B1_1B3_1B1_1B8
  scale 0.7
  rotate <0.0, 96.589302, 193.512817>
  translate  <3.08602, -0.9362, 7.48935>
}
#declare _Leaf1B1_1B3_1B1_1B9_Ref = object {
  _Leaf1B1_1B3_1B1_1B9
  scale 0.7
  rotate <0.0, 94.290619, 2.04536>
  translate  <3.10686, -0.93811, 7.48276>
}
#declare _Leaf1B1_1B3_1B1_1B10_Ref = object {
  _Leaf1B1_1B3_1B1_1B10
  scale 0.7
  rotate <0.0, 61.22588, 308.468781>
  translate  <3.12143, -1.10914, 7.58604>
}
#declare _Leaf1B1_1B3_1B1_1B11_Ref = object {
  _Leaf1B1_1B3_1B1_1B11
  scale 0.7
  rotate <0.0, 17.666559, 285.670074>
  translate  <3.11473, -1.10608, 7.59281>
}
#declare _Leaf1B1_1B3_1B1_1B12_Ref = object {
  _Leaf1B1_1B3_1B1_1B12
  scale 0.7
  rotate <0.0, 41.670101, 167.075867>
  translate  <3.10498, -1.10764, 7.59125>
}
#declare _Leaf1B1_1B3_1B2_1B1_Ref = object {
  _Leaf1B1_1B3_1B2_1B1
  scale 0.7
  rotate <0.0, 51.972561, 66.597298>
  translate  <3.35628, 0.19753, 7.522>
}
#declare _Leaf1B1_1B3_1B2_1B2_Ref = object {
  _Leaf1B1_1B3_1B2_1B2
  scale 0.7
  rotate <0.0, 58.379372, 119.510193>
  translate  <3.35519, 0.26269, 7.7127>
}
#declare _Leaf1B1_1B3_1B2_1B3_Ref = object {
  _Leaf1B1_1B3_1B2_1B3
  scale 0.7
  rotate <0.0, 79.015488, 350.593445>
  translate  <3.39806, 0.26769, 7.81366>
}
#declare _Leaf1B1_1B3_1B2_1B4_Ref = object {
  _Leaf1B1_1B3_1B2_1B4
  scale 0.7
  rotate <0.0, 147.130447, 24.23242>
  translate  <3.40371, 0.28726, 7.80535>
}
#declare _Leaf1B1_1B3_1B2_1B5_Ref = object {
  _Leaf1B1_1B3_1B2_1B5
  scale 0.7
  rotate <0.0, 78.86097, 191.936356>
  translate  <3.37375, 0.31474, 7.90619>
}
#declare _Leaf1B1_1B3_1B2_1B6_Ref = object {
  _Leaf1B1_1B3_1B2_1B6
  scale 0.7
  rotate <0.0, 37.811852, 254.153>
  translate  <3.42229, 0.4125, 8.18627>
}
#declare _Leaf1B1_1B3_1B2_1B7_Ref = object {
  _Leaf1B1_1B3_1B2_1B7
  scale 0.7
  rotate <0.0, 88.597137, 136.630737>
  translate  <3.42679, 0.47399, 8.26974>
}
#declare _Leaf1B1_1B3_1B2_1B8_Ref = object {
  _Leaf1B1_1B3_1B2_1B8
  scale 0.7
  rotate <0.0, 104.040642, 104.758797>
  translate  <3.4563, 0.54726, 8.45364>
}
#declare _Leaf1B1_1B3_1B2_1B9_Ref = object {
  _Leaf1B1_1B3_1B2_1B9
  scale 0.7
  rotate <0.0, 68.68544, 270.028931>
  translate  <3.45066, 0.52774, 8.46193>
}
#declare _Leaf1B1_1B3_1B2_1B10_Ref = object {
  _Leaf1B1_1B3_1B2_1B10
  scale 0.7
  rotate <0.0, 15.38774, 327.615479>
  translate  <3.48413, 0.5989, 8.64618>
}
#declare _Leaf1B1_1B3_1B2_1B11_Ref = object {
  _Leaf1B1_1B3_1B2_1B11
  scale 0.7
  rotate <0.0, 54.39624, 16.251989>
  translate  <3.49116, 0.6052, 8.64289>
}
#declare _Leaf1B1_1B3_1B2_1B12_Ref = object {
  _Leaf1B1_1B3_1B2_1B12
  scale 0.7
  rotate <0.0, 99.426781, 43.892651>
  translate  <3.48858, 0.6143, 8.63964>
}
#declare _Leaf1B1_1B3_1B3_1B1_Ref = object {
  _Leaf1B1_1B3_1B3_1B1
  scale 0.7
  rotate <0.0, 106.970871, 333.531891>
  translate  <3.73786, -0.02301, 7.38989>
}
#declare _Leaf1B1_1B3_1B3_1B2_Ref = object {
  _Leaf1B1_1B3_1B3_1B2
  scale 0.7
  rotate <0.0, 129.998596, 16.07128>
  translate  <3.93875, -0.00742, 7.39371>
}
#declare _Leaf1B1_1B3_1B3_1B3_Ref = object {
  _Leaf1B1_1B3_1B3_1B3
  scale 0.7
  rotate <0.0, 52.985291, 282.484497>
  translate  <4.03668, -0.02763, 7.43906>
}
#declare _Leaf1B1_1B3_1B3_1B4_Ref = object {
  _Leaf1B1_1B3_1B3_1B4
  scale 0.7
  rotate <0.0, 104.242561, 226.382828>
  translate  <4.03652, -0.04169, 7.42214>
}
#declare _Leaf1B1_1B3_1B3_1B5_Ref = object {
  _Leaf1B1_1B3_1B3_1B5
  scale 0.7
  rotate <0.0, 99.695908, 87.114868>
  translate  <4.1385, -0.00423, 7.41781>
}
#declare _Leaf1B1_1B3_1B3_1B6_Ref = object {
  _Leaf1B1_1B3_1B3_1B6
  scale 0.7
  rotate <0.0, 47.133099, 46.39798>
  translate  <4.43716, -0.02756, 7.44265>
}
#declare _Leaf1B1_1B3_1B3_1B7_Ref = object {
  _Leaf1B1_1B3_1B3_1B7
  scale 0.7
  rotate <0.0, 151.844925, 60.14835>
  translate  <4.53755, -0.03746, 7.41831>
}
#declare _Leaf1B1_1B3_1B3_1B8_Ref = object {
  _Leaf1B1_1B3_1B3_1B8
  scale 0.7
  rotate <0.0, 168.257095, 301.834412>
  translate  <4.73687, -0.05399, 7.4259>
}
#declare _Leaf1B1_1B3_1B3_1B9_Ref = object {
  _Leaf1B1_1B3_1B3_1B9
  scale 0.7
  rotate <0.0, 24.75042, 90.939018>
  translate  <4.73702, -0.03997, 7.44278>
}
#declare _Leaf1B1_1B3_1B3_1B10_Ref = object {
  _Leaf1B1_1B3_1B3_1B10
  scale 0.7
  rotate <0.0, 58.846741, 3.04328>
  translate  <4.93612, -0.05924, 7.45393>
}
#declare _Leaf1B1_1B3_1B3_1B11_Ref = object {
  _Leaf1B1_1B3_1B3_1B11
  scale 0.7
  rotate <0.0, 71.608742, 314.785004>
  translate  <4.93579, -0.06861, 7.45047>
}
#declare _Leaf1B1_1B3_1B3_1B12_Ref = object {
  _Leaf1B1_1B3_1B3_1B12
  scale 0.7
  rotate <0.0, 109.668648, 278.619476>
  translate  <4.93599, -0.07031, 7.44061>
}
#declare _Leaf1B1_1B4_2B1_1B1_Ref = object {
  _Leaf1B1_1B4_2B1_1B1
  scale 0.7
  rotate <0.0, 131.018005, 5.75223>
  translate  <6.64848, 0.78784, 8.41025>
}
#declare _Leaf1B1_1B4_2B1_1B2_Ref = object {
  _Leaf1B1_1B4_2B1_1B2
  scale 0.7
  rotate <0.0, 132.766815, 65.166039>
  translate  <6.81816, 0.88694, 8.3655>
}
#declare _Leaf1B1_1B4_2B1_1B3_Ref = object {
  _Leaf1B1_1B4_2B1_1B3
  scale 0.7
  rotate <0.0, 80.037727, 309.975159>
  translate  <6.92704, 0.90002, 8.37084>
}
#declare _Leaf1B1_1B4_2B1_1B4_Ref = object {
  _Leaf1B1_1B4_2B1_1B4
  scale 0.7
  rotate <0.0, 108.24752, 241.138168>
  translate  <6.9244, 0.89215, 8.35046>
}
#declare _Leaf1B1_1B4_2B1_1B5_Ref = object {
  _Leaf1B1_1B4_2B1_1B5
  scale 0.7
  rotate <0.0, 76.784561, 109.775917>
  translate  <6.99887, 0.96962, 8.33394>
}
#declare _Leaf1B1_1B4_2B1_1B6_Ref = object {
  _Leaf1B1_1B4_2B1_1B6
  scale 0.7
  rotate <0.0, 47.884048, 42.563431>
  translate  <7.27324, 1.0718, 8.26581>
}
#declare _Leaf1B1_1B4_2B1_1B7_Ref = object {
  _Leaf1B1_1B4_2B1_1B7
  scale 0.7
  rotate <0.0, 132.467529, 112.365593>
  translate  <7.35288, 1.11279, 8.2134>
}
#declare _Leaf1B1_1B4_2B1_1B8_Ref = object {
  _Leaf1B1_1B4_2B1_1B8
  scale 0.7
  rotate <0.0, 163.080627, 149.243439>
  translate  <7.53265, 1.18247, 8.15967>
}
#declare _Leaf1B1_1B4_2B1_1B9_Ref = object {
  _Leaf1B1_1B4_2B1_1B9
  scale 0.7
  rotate <0.0, 15.28903, 28.355709>
  translate  <7.53527, 1.19031, 8.17999>
}
#declare _Leaf1B1_1B4_2B1_1B10_Ref = object {
  _Leaf1B1_1B4_2B1_1B10
  scale 0.7
  rotate <0.0, 76.047974, 16.431299>
  translate  <7.71713, 1.25661, 8.12836>
}
#declare _Leaf1B1_1B4_2B1_1B11_Ref = object {
  _Leaf1B1_1B4_2B1_1B11
  scale 0.7
  rotate <0.0, 99.81176, 337.601105>
  translate  <7.71834, 1.24926, 8.12169>
}
#declare _Leaf1B1_1B4_2B1_1B12_Ref = object {
  _Leaf1B1_1B4_2B1_1B12
  scale 0.7
  rotate <0.0, 134.602036, 292.53595>
  translate  <7.71506, 1.25041, 8.11232>
}
#declare _Leaf1B1_1B4_2B2_1B1_Ref = object {
  _Leaf1B1_1B4_2B2_1B1
  scale 0.7
  rotate <0.0, 92.69828, 287.675018>
  translate  <6.9383, 0.38663, 8.58199>
}
#declare _Leaf1B1_1B4_2B2_1B2_Ref = object {
  _Leaf1B1_1B4_2B2_1B2
  scale 0.7
  rotate <0.0, 134.105621, 273.270477>
  translate  <7.07657, 0.26193, 8.50487>
}
#declare _Leaf1B1_1B4_2B2_1B3_Ref = object {
  _Leaf1B1_1B4_2B2_1B3
  scale 0.7
  rotate <0.0, 30.82073, 335.315033>
  translate  <7.17272, 0.20911, 8.5094>
}
#declare _Leaf1B1_1B4_2B2_1B4_Ref = object {
  _Leaf1B1_1B4_2B2_1B4
  scale 0.7
  rotate <0.0, 45.35775, 183.963943>
  translate  <7.15846, 0.19299, 8.51399>
}
#declare _Leaf1B1_1B4_2B2_1B5_Ref = object {
  _Leaf1B1_1B4_2B2_1B5
  scale 0.7
  rotate <0.0, 156.466171, 86.212448>
  translate  <7.22755, 0.14202, 8.44729>
}
#declare _Leaf1B1_1B4_2B2_1B6_Ref = object {
  _Leaf1B1_1B4_2B2_1B6
  scale 0.7
  rotate <0.0, 108.56543, 18.100571>
  translate  <7.44169, -0.05793, 8.38001>
}
#declare _Leaf1B1_1B4_2B2_1B7_Ref = object {
  _Leaf1B1_1B4_2B2_1B7
  scale 0.7
  rotate <0.0, 143.224197, 221.994156>
  translate  <7.48932, -0.14323, 8.34504>
}
#declare _Leaf1B1_1B4_2B2_1B8_Ref = object {
  _Leaf1B1_1B4_2B2_1B8
  scale 0.7
  rotate <0.0, 108.158302, 225.070267>
  translate  <7.62549, -0.28185, 8.29708>
}
#declare _Leaf1B1_1B4_2B2_1B9_Ref = object {
  _Leaf1B1_1B4_2B2_1B9
  scale 0.7
  rotate <0.0, 87.617378, 44.31123>
  translate  <7.63971, -0.26578, 8.29251>
}
#declare _Leaf1B1_1B4_2B2_1B10_Ref = object {
  _Leaf1B1_1B4_2B2_1B10
  scale 0.7
  rotate <0.0, 95.424171, 343.619354>
  translate  <7.77803, -0.40384, 8.24846>
}
#declare _Leaf1B1_1B4_2B2_1B11_Ref = object {
  _Leaf1B1_1B4_2B2_1B11
  scale 0.7
  rotate <0.0, 61.05336, 312.992554>
  translate  <7.77413, -0.41037, 8.25495>
}
#declare _Leaf1B1_1B4_2B2_1B12_Ref = object {
  _Leaf1B1_1B4_2B2_1B12
  scale 0.7
  rotate <0.0, 53.70982, 250.771347>
  translate  <7.7668, -0.41653, 8.25207>
}
#declare _Leaf1B1_1B4_2B3_1B1_Ref = object {
  _Leaf1B1_1B4_2B3_1B1
  scale 0.7
  rotate <0.0, 68.73069, 58.596081>
  translate  <7.44605, 0.65777, 9.08953>
}
#declare _Leaf1B1_1B4_2B3_1B2_Ref = object {
  _Leaf1B1_1B4_2B3_1B2
  scale 0.7
  rotate <0.0, 50.780609, 104.970306>
  translate  <7.5281, 0.7388, 9.25481>
}
#declare _Leaf1B1_1B4_2B3_1B3_Ref = object {
  _Leaf1B1_1B4_2B3_1B3
  scale 0.7
  rotate <0.0, 106.889603, 355.955597>
  translate  <7.61276, 0.75579, 9.32263>
}
#declare _Leaf1B1_1B4_2B3_1B4_Ref = object {
  _Leaf1B1_1B4_2B3_1B4
  scale 0.7
  rotate <0.0, 169.165756, 86.53598>
  translate  <7.61163, 0.77496, 9.31188>
}
#declare _Leaf1B1_1B4_2B3_1B5_Ref = object {
  _Leaf1B1_1B4_2B3_1B5
  scale 0.7
  rotate <0.0, 50.437519, 199.692093>
  translate  <7.63008, 0.80858, 9.41362>
}
#declare _Leaf1B1_1B4_2B3_1B6_Ref = object {
  _Leaf1B1_1B4_2B3_1B6
  scale 0.7
  rotate <0.0, 37.282291, 298.779846>
  translate  <7.79421, 0.93355, 9.63226>
}
#declare _Leaf1B1_1B4_2B3_1B7_Ref = object {
  _Leaf1B1_1B4_2B3_1B7
  scale 0.7
  rotate <0.0, 69.929253, 138.097061>
  translate  <7.83085, 1.00215, 9.70096>
}
#declare _Leaf1B1_1B4_2B3_1B8_Ref = object {
  _Leaf1B1_1B4_2B3_1B8
  scale 0.7
  rotate <0.0, 97.491638, 115.929291>
  translate  <7.93556, 1.09303, 9.84531>
}
#declare _Leaf1B1_1B4_2B3_1B9_Ref = object {
  _Leaf1B1_1B4_2B3_1B9
  scale 0.7
  rotate <0.0, 69.251099, 287.054535>
  translate  <7.93669, 1.07391, 9.85602>
}
#declare _Leaf1B1_1B4_2B3_1B10_Ref = object {
  _Leaf1B1_1B4_2B3_1B10
  scale 0.7
  rotate <0.0, 41.949261, 356.500061>
  translate  <8.04525, 1.16304, 9.99887>
}
#declare _Leaf1B1_1B4_2B3_1B11_Ref = object {
  _Leaf1B1_1B4_2B3_1B11
  scale 0.7
  rotate <0.0, 82.64225, 19.858521>
  translate  <8.04914, 1.16957, 9.99237>
}
#declare _Leaf1B1_1B4_2B3_1B12_Ref = object {
  _Leaf1B1_1B4_2B3_1B12
  scale 0.7
  rotate <0.0, 120.684219, 56.927879>
  translate  <8.04436, 1.17813, 9.99041>
}
#declare _Leaf1B1_1B4_2B4_1B1_Ref = object {
  _Leaf1B1_1B4_2B4_1B1
  scale 0.7
  rotate <0.0, 13.59734, 279.339539>
  translate  <7.55326, 0.29276, 9.18819>
}
#declare _Leaf1B1_1B4_2B4_1B2_Ref = object {
  _Leaf1B1_1B4_2B4_1B2
  scale 0.7
  rotate <0.0, 52.02449, 233.626175>
  translate  <7.6039, 0.14999, 9.32111>
}
#declare _Leaf1B1_1B4_2B4_1B3_Ref = object {
  _Leaf1B1_1B4_2B4_1B3
  scale 0.7
  rotate <0.0, 66.718651, 31.014999>
  translate  <7.67582, 0.10108, 9.38812>
}
#declare _Leaf1B1_1B4_2B4_1B4_Ref = object {
  _Leaf1B1_1B4_2B4_1B4
  scale 0.7
  rotate <0.0, 88.073036, 103.895927>
  translate  <7.66306, 0.112, 9.40233>
}
#declare _Leaf1B1_1B4_2B4_1B5_Ref = object {
  _Leaf1B1_1B4_2B4_1B5
  scale 0.7
  rotate <0.0, 120.565193, 244.544678>
  translate  <7.67614, 0.01718, 9.45389>
}
#declare _Leaf1B1_1B4_2B4_1B6_Ref = object {
  _Leaf1B1_1B4_2B4_1B6
  scale 0.7
  rotate <0.0, 101.148933, 311.205658>
  translate  <7.78004, -0.15999, 9.67338>
}
#declare _Leaf1B1_1B4_2B4_1B7_Ref = object {
  _Leaf1B1_1B4_2B4_1B7
  scale 0.7
  rotate <0.0, 77.445488, 207.811737>
  translate  <7.78468, -0.21768, 9.75952>
}
#declare _Leaf1B1_1B4_2B4_1B8_Ref = object {
  _Leaf1B1_1B4_2B4_1B8
  scale 0.7
  rotate <0.0, 59.023239, 175.30928>
  translate  <7.84578, -0.3351, 9.90964>
}
#declare _Leaf1B1_1B4_2B4_1B9_Ref = object {
  _Leaf1B1_1B4_2B4_1B9
  scale 0.7
  rotate <0.0, 124.663963, 337.005402>
  translate  <7.8585, -0.34599, 9.89547>
}
#declare _Leaf1B1_1B4_2B4_1B10_Ref = object {
  _Leaf1B1_1B4_2B4_1B10
  scale 0.7
  rotate <0.0, 65.914497, 319.237183>
  translate  <7.92352, -0.46122, 10.04589>
}
#declare _Leaf1B1_1B4_2B4_1B11_Ref = object {
  _Leaf1B1_1B4_2B4_1B11
  scale 0.7
  rotate <0.0, 38.51263, 6.66919>
  translate  <7.92231, -0.45386, 10.05256>
}
#declare _Leaf1B1_1B4_2B4_1B12_Ref = object {
  _Leaf1B1_1B4_2B4_1B12
  scale 0.7
  rotate <0.0, 38.395031, 96.382927>
  translate  <7.91348, -0.45262, 10.05708>
}
#declare _Leaf1B1_1B4_2B5_1B1_Ref = object {
  _Leaf1B1_1B4_2B5_1B1
  scale 0.7
  rotate <0.0, 59.000019, 316.948944>
  translate  <8.0224, 0.33195, 9.17683>
}
#declare _Leaf1B1_1B4_2B5_1B2_Ref = object {
  _Leaf1B1_1B4_2B5_1B2
  scale 0.7
  rotate <0.0, 102.30056, 318.451782>
  translate  <8.21504, 0.30286, 9.22839>
}
#declare _Leaf1B1_1B4_2B5_1B3_Ref = object {
  _Leaf1B1_1B4_2B5_1B3
  scale 0.7
  rotate <0.0, 14.4166, 112.591423>
  translate  <8.30086, 0.3181, 9.29515>
}
#declare _Leaf1B1_1B4_2B5_1B4_Ref = object {
  _Leaf1B1_1B4_2B5_1B4
  scale 0.7
  rotate <0.0, 73.211906, 201.680328>
  translate  <8.29477, 0.29757, 9.30019>
}
#declare _Leaf1B1_1B4_2B5_1B5_Ref = object {
  _Leaf1B1_1B4_2B5_1B5
  scale 0.7
  rotate <0.0, 153.629944, 26.43565>
  translate  <8.40305, 0.28791, 9.29851>
}
#declare _Leaf1B1_1B4_2B5_1B6_Ref = object {
  _Leaf1B1_1B4_2B5_1B6
  scale 0.7
  rotate <0.0, 90.908653, 45.87101>
  translate  <8.67337, 0.24508, 9.42282>
}
#declare _Leaf1B1_1B4_2B5_1B7_Ref = object {
  _Leaf1B1_1B4_2B5_1B7
  scale 0.7
  rotate <0.0, 129.627625, 295.030212>
  translate  <8.76192, 0.20015, 9.45296>
}
#declare _Leaf1B1_1B4_2B5_1B8_Ref = object {
  _Leaf1B1_1B4_2B5_1B8
  scale 0.7
  rotate <0.0, 102.6931, 269.414124>
  translate  <8.94155, 0.16303, 9.53306>
}
#declare _Leaf1B1_1B4_2B5_1B9_Ref = object {
  _Leaf1B1_1B4_2B5_1B9
  scale 0.7
  rotate <0.0, 89.309959, 79.059608>
  translate  <8.94762, 0.18351, 9.52803>
}
#declare _Leaf1B1_1B4_2B5_1B10_Ref = object {
  _Leaf1B1_1B4_2B5_1B10
  scale 0.7
  rotate <0.0, 63.7234, 21.248529>
  translate  <9.1262, 0.14867, 9.61186>
}
#declare _Leaf1B1_1B4_2B5_1B11_Ref = object {
  _Leaf1B1_1B4_2B5_1B11
  scale 0.7
  rotate <0.0, 23.57629, 347.478119>
  translate  <9.12231, 0.14214, 9.61836>
}
#declare _Leaf1B1_1B4_2B5_1B12_Ref = object {
  _Leaf1B1_1B4_2B5_1B12
  scale 0.7
  rotate <0.0, 45.313889, 251.557693>
  translate  <9.12141, 0.13251, 9.61583>
}
#declare _Leaf1B1_1B4_1B1_1B1_Ref = object {
  _Leaf1B1_1B4_1B1_1B1
  scale 0.7
  rotate <0.0, 89.18058, 291.622559>
  translate  <5.07017, 0.64501, 7.72195>
}
#declare _Leaf1B1_1B4_1B1_1B2_Ref = object {
  _Leaf1B1_1B4_1B1_1B2
  scale 0.7
  rotate <0.0, 131.314804, 280.503723>
  translate  <5.22145, 0.52733, 7.65969>
}
#declare _Leaf1B1_1B4_1B1_1B3_Ref = object {
  _Leaf1B1_1B4_1B1_1B3
  scale 0.7
  rotate <0.0, 26.31242, 340.483978>
  translate  <5.32035, 0.48151, 7.67291>
}
#declare _Leaf1B1_1B4_1B1_1B4_Ref = object {
  _Leaf1B1_1B4_1B1_1B4
  scale 0.7
  rotate <0.0, 49.072201, 185.411438>
  translate  <5.30691, 0.46463, 7.67722>
}
#declare _Leaf1B1_1B4_1B1_1B5_Ref = object {
  _Leaf1B1_1B4_1B1_1B5
  scale 0.7
  rotate <0.0, 158.326004, 80.084106>
  translate  <5.38371, 0.41605, 7.61754>
}
#declare _Leaf1B1_1B4_1B1_1B6_Ref = object {
  _Leaf1B1_1B4_1B1_1B6
  scale 0.7
  rotate <0.0, 105.652473, 20.91951>
  translate  <5.61484, 0.22899, 7.5734>
}
#declare _Leaf1B1_1B4_1B1_1B7_Ref = object {
  _Leaf1B1_1B4_1B1_1B7
  scale 0.7
  rotate <0.0, 144.190445, 231.969788>
  translate  <5.67036, 0.14591, 7.54539>
}
#declare _Leaf1B1_1B4_1B1_1B8_Ref = object {
  _Leaf1B1_1B4_1B1_1B8
  scale 0.7
  rotate <0.0, 109.061577, 230.476318>
  translate  <5.81846, 0.01532, 7.51265>
}
#declare _Leaf1B1_1B4_1B1_1B9_Ref = object {
  _Leaf1B1_1B4_1B1_1B9
  scale 0.7
  rotate <0.0, 86.605179, 48.435661>
  translate  <5.83186, 0.03215, 7.50835>
}
#declare _Leaf1B1_1B4_1B1_1B10_Ref = object {
  _Leaf1B1_1B4_1B1_1B10
  scale 0.7
  rotate <0.0, 91.047699, 347.446655>
  translate  <5.98179, -0.09758, 7.47963>
}
#declare _Leaf1B1_1B4_1B1_1B11_Ref = object {
  _Leaf1B1_1B4_1B1_1B11
  scale 0.7
  rotate <0.0, 56.63974, 316.197388>
  translate  <5.9779, -0.10411, 7.48613>
}
#declare _Leaf1B1_1B4_1B1_1B12_Ref = object {
  _Leaf1B1_1B4_1B1_1B12
  scale 0.7
  rotate <0.0, 52.77142, 251.335098>
  translate  <5.97121, -0.11087, 7.48303>
}
#declare _Leaf1B1_1B4_1B2_1B1_Ref = object {
  _Leaf1B1_1B4_1B2_1B1
  scale 0.7
  rotate <0.0, 15.97305, 79.821388>
  translate  <5.36942, 0.76353, 8.28595>
}
#declare _Leaf1B1_1B4_1B2_1B2_Ref = object {
  _Leaf1B1_1B4_1B2_1B2
  scale 0.7
  rotate <0.0, 33.493698, 199.101135>
  translate  <5.40612, 0.69869, 8.4732>
}
#declare _Leaf1B1_1B4_1B2_1B3_Ref = object {
  _Leaf1B1_1B4_1B2_1B3
  scale 0.7
  rotate <0.0, 82.272621, 29.78256>
  translate  <5.47365, 0.67945, 8.55761>
}
#declare _Leaf1B1_1B4_1B2_1B4_Ref = object {
  _Leaf1B1_1B4_1B2_1B4
  scale 0.7
  rotate <0.0, 116.973846, 96.821037>
  translate  <5.46311, 0.69757, 8.56426>
}
#declare _Leaf1B1_1B4_1B2_1B5_Ref = object {
  _Leaf1B1_1B4_1B2_1B5
  scale 0.7
  rotate <0.0, 94.127083, 240.390884>
  translate  <5.46554, 0.63937, 8.65606>
}
#declare _Leaf1B1_1B4_1B2_1B6_Ref = object {
  _Leaf1B1_1B4_1B2_1B6
  scale 0.7
  rotate <0.0, 77.747337, 303.008423>
  translate  <5.55409, 0.57994, 8.93711>
}
#declare _Leaf1B1_1B4_1B2_1B7_Ref = object {
  _Leaf1B1_1B4_1B2_1B7
  scale 0.7
  rotate <0.0, 67.163094, 190.399384>
  translate  <5.55466, 0.5718, 9.04056>
}
#declare _Leaf1B1_1B4_1B2_1B8_Ref = object {
  _Leaf1B1_1B4_1B2_1B8
  scale 0.7
  rotate <0.0, 67.07975, 152.139252>
  translate  <5.60587, 0.53576, 9.23066>
}
#declare _Leaf1B1_1B4_1B2_1B9_Ref = object {
  _Leaf1B1_1B4_1B2_1B9
  scale 0.7
  rotate <0.0, 108.425568, 315.944458>
  translate  <5.61639, 0.51769, 9.22402>
}
#declare _Leaf1B1_1B4_1B2_1B10_Ref = object {
  _Leaf1B1_1B4_1B2_1B10
  scale 0.7
  rotate <0.0, 48.11697, 326.681061>
  translate  <5.67178, 0.48314, 9.41341>
}
#declare _Leaf1B1_1B4_1B2_1B11_Ref = object {
  _Leaf1B1_1B4_1B2_1B11
  scale 0.7
  rotate <0.0, 48.42366, 28.754539>
  translate  <5.67186, 0.4929, 9.41558>
}
#declare _Leaf1B1_1B4_1B2_1B12_Ref = object {
  _Leaf1B1_1B4_1B2_1B12
  scale 0.7
  rotate <0.0, 67.805832, 87.001419>
  translate  <5.66348, 0.49741, 9.41866>
}
#declare _Leaf1B1_1B4_1B3_1B1_Ref = object {
  _Leaf1B1_1B4_1B3_1B1
  scale 0.7
  rotate <0.0, 114.485641, 35.235661>
  translate  <5.71756, 0.983, 8.0802>
}
#declare _Leaf1B1_1B4_1B3_1B2_Ref = object {
  _Leaf1B1_1B4_1B3_1B2
  scale 0.7
  rotate <0.0, 106.677582, 80.966331>
  translate  <5.85365, 1.1282, 8.11195>
}
#declare _Leaf1B1_1B4_1B3_1B3_Ref = object {
  _Leaf1B1_1B4_1B3_1B3
  scale 0.7
  rotate <0.0, 91.179703, 324.212189>
  translate  <5.95319, 1.16264, 8.14295>
}
#declare _Leaf1B1_1B4_1B3_1B4_Ref = object {
  _Leaf1B1_1B4_1B3_1B4
  scale 0.7
  rotate <0.0, 134.301224, 256.307892>
  translate  <5.95454, 1.164, 8.12104>
}
#declare _Leaf1B1_1B4_1B3_1B5_Ref = object {
  _Leaf1B1_1B4_1B3_1B5
  scale 0.7
  rotate <0.0, 59.759079, 133.962585>
  translate  <6.00407, 1.25596, 8.1512>
}
#declare _Leaf1B1_1B4_1B3_1B6_Ref = object {
  _Leaf1B1_1B4_1B3_1B6
  scale 0.7
  rotate <0.0, 25.02766, 40.301998>
  translate  <6.24082, 1.43837, 8.18341>
}
#declare _Leaf1B1_1B4_1B3_1B7_Ref = object {
  _Leaf1B1_1B4_1B3_1B7
  scale 0.7
  rotate <0.0, 113.020119, 116.866966>
  translate  <6.30871, 1.51531, 8.16792>
}
#declare _Leaf1B1_1B4_1B3_1B8_Ref = object {
  _Leaf1B1_1B4_1B3_1B8
  scale 0.7
  rotate <0.0, 148.073105, 113.288147>
  translate  <6.46373, 1.64114, 8.18193>
}
#declare _Leaf1B1_1B4_1B3_1B9_Ref = object {
  _Leaf1B1_1B4_1B3_1B9
  scale 0.7
  rotate <0.0, 16.13398, 293.542084>
  translate  <6.46238, 1.63978, 8.20379>
}
#declare _Leaf1B1_1B4_1B3_1B10_Ref = object {
  _Leaf1B1_1B4_1B3_1B10
  scale 0.7
  rotate <0.0, 59.67696, 24.02631>
  translate  <6.62022, 1.76224, 8.21876>
}
#declare _Leaf1B1_1B4_1B3_1B11_Ref = object {
  _Leaf1B1_1B4_1B3_1B11
  scale 0.7
  rotate <0.0, 97.201759, 357.641296>
  translate  <6.62404, 1.75901, 8.2101>
}
#declare _Leaf1B1_1B4_1B3_1B12_Ref = object {
  _Leaf1B1_1B4_1B3_1B12
  scale 0.7
  rotate <0.0, 146.900635, 337.971893>
  translate  <6.62128, 1.76331, 8.2015>
}
#declare _Leaf1B1_1B5_2B1_1B1_Ref = object {
  _Leaf1B1_1B5_2B1_1B1
  scale 0.7
  rotate <0.0, 65.988876, 112.496887>
  translate  <5.79978, 2.74678, 8.84976>
}
#declare _Leaf1B1_1B5_2B1_1B2_Ref = object {
  _Leaf1B1_1B5_2B1_1B2
  scale 0.7
  rotate <0.0, 50.348461, 160.801941>
  translate  <5.78201, 2.85144, 9.02106>
}
#declare _Leaf1B1_1B5_2B1_1B3_Ref = object {
  _Leaf1B1_1B5_2B1_1B3
  scale 0.7
  rotate <0.0, 103.91259, 49.475559>
  translate  <5.81833, 2.92533, 9.09371>
}
#declare _Leaf1B1_1B5_2B1_1B4_Ref = object {
  _Leaf1B1_1B5_2B1_1B4
  scale 0.7
  rotate <0.0, 167.279892, 126.225319>
  translate  <5.80247, 2.93653, 9.08337>
}
#declare _Leaf1B1_1B5_2B1_1B5_Ref = object {
  _Leaf1B1_1B5_2B1_1B5
  scale 0.7
  rotate <0.0, 53.787411, 252.963928>
  translate  <5.78529, 2.96563, 9.18671>
}
#declare _Leaf1B1_1B5_2B1_1B6_Ref = object {
  _Leaf1B1_1B5_2B1_1B6
  scale 0.7
  rotate <0.0, 37.11581, 347.450836>
  translate  <5.78093, 3.15911, 9.41673>
}
#declare _Leaf1B1_1B5_2B1_1B7_Ref = object {
  _Leaf1B1_1B5_2B1_1B7
  scale 0.7
  rotate <0.0, 71.343529, 192.259628>
  translate  <5.74715, 3.22559, 9.48889>
}
#declare _Leaf1B1_1B5_2B1_1B8_Ref = object {
  _Leaf1B1_1B5_2B1_1B8
  scale 0.7
  rotate <0.0, 97.607483, 168.576263>
  translate  <5.73538, 3.35543, 9.64075>
}
#declare _Leaf1B1_1B5_2B1_1B9_Ref = object {
  _Leaf1B1_1B5_2B1_1B9
  scale 0.7
  rotate <0.0, 69.677902, 338.898407>
  translate  <5.7512, 3.34425, 9.65106>
}
#declare _Leaf1B1_1B5_2B1_1B10_Ref = object {
  _Leaf1B1_1B5_2B1_1B10
  scale 0.7
  rotate <0.0, 38.98827, 47.733891>
  translate  <5.74317, 3.47621, 9.80158>
}
#declare _Leaf1B1_1B5_2B1_1B11_Ref = object {
  _Leaf1B1_1B5_2B1_1B11
  scale 0.7
  rotate <0.0, 79.292137, 72.914169>
  translate  <5.74037, 3.4836, 9.79546>
}
#declare _Leaf1B1_1B5_2B1_1B12_Ref = object {
  _Leaf1B1_1B5_2B1_1B12
  scale 0.7
  rotate <0.0, 117.857857, 109.002953>
  translate  <5.73068, 3.48503, 9.79344>
}
#declare _Leaf1B1_1B5_2B2_1B1_Ref = object {
  _Leaf1B1_1B5_2B2_1B1
  scale 0.7
  rotate <0.0, 127.81649, 59.67709>
  translate  <6.18917, 3.06606, 8.70519>
}
#declare _Leaf1B1_1B5_2B2_1B2_Ref = object {
  _Leaf1B1_1B5_2B2_1B2
  scale 0.7
  rotate <0.0, 130.211746, 116.32975>
  translate  <6.21235, 3.26347, 8.67194>
}
#declare _Leaf1B1_1B5_2B2_1B3_Ref = object {
  _Leaf1B1_1B5_2B2_1B3
  scale 0.7
  rotate <0.0, 79.114868, 2.47291>
  translate  <6.26717, 3.3579, 8.68342>
}
#declare _Leaf1B1_1B5_2B2_1B4_Ref = object {
  _Leaf1B1_1B5_2B2_1B4
  scale 0.7
  rotate <0.0, 110.902031, 294.961639>
  translate  <6.27216, 3.35224, 8.66276>
}
#declare _Leaf1B1_1B5_2B2_1B5_Ref = object {
  _Leaf1B1_1B5_2B2_1B5
  scale 0.7
  rotate <0.0, 76.576141, 163.661469>
  translate  <6.25511, 3.45909, 8.65208>
}
#declare _Leaf1B1_1B5_2B2_1B6_Ref = object {
  _Leaf1B1_1B5_2B2_1B6
  scale 0.7
  rotate <0.0, 44.715931, 96.719627>
  translate  <6.33897, 3.74323, 8.60119>
}
#declare _Leaf1B1_1B5_2B2_1B7_Ref = object {
  _Leaf1B1_1B5_2B2_1B7
  scale 0.7
  rotate <0.0, 132.297806, 162.395859>
  translate  <6.35469, 3.83436, 8.55411>
}
#declare _Leaf1B1_1B5_2B2_1B8_Ref = object {
  _Leaf1B1_1B5_2B2_1B8
  scale 0.7
  rotate <0.0, 164.790833, 192.270172>
  translate  <6.40757, 4.02269, 8.51174>
}
#declare _Leaf1B1_1B5_2B2_1B9_Ref = object {
  _Leaf1B1_1B5_2B2_1B9
  scale 0.7
  rotate <0.0, 11.94512, 82.719002>
  translate  <6.4026, 4.02834, 8.53235>
}
#declare _Leaf1B1_1B5_2B2_1B10_Ref = object {
  _Leaf1B1_1B5_2B2_1B10
  scale 0.7
  rotate <0.0, 72.717758, 69.402908>
  translate  <6.45942, 4.21619, 8.49213>
}
#declare _Leaf1B1_1B5_2B2_1B11_Ref = object {
  _Leaf1B1_1B5_2B2_1B11
  scale 0.7
  rotate <0.0, 97.476563, 31.059931>
  translate  <6.46611, 4.21312, 8.48536>
}
#declare _Leaf1B1_1B5_2B2_1B12_Ref = object {
  _Leaf1B1_1B5_2B2_1B12
  scale 0.7
  rotate <0.0, 134.574997, 348.939056>
  translate  <6.46334, 4.21173, 8.47586>
}
#declare _Leaf1B1_1B5_2B3_1B1_Ref = object {
  _Leaf1B1_1B5_2B3_1B1
  scale 0.7
  rotate <0.0, 14.7871, 319.976166>
  translate  <6.70503, 3.0872, 9.27296>
}
#declare _Leaf1B1_1B5_2B3_1B2_Ref = object {
  _Leaf1B1_1B5_2B3_1B2
  scale 0.7
  rotate <0.0, 54.953491, 285.501709>
  translate  <6.84783, 3.03439, 9.405>
}
#declare _Leaf1B1_1B5_2B3_1B3_Ref = object {
  _Leaf1B1_1B5_2B3_1B3
  scale 0.7
  rotate <0.0, 63.38863, 84.307701>
  translate  <6.92922, 3.05863, 9.4746>
}
#declare _Leaf1B1_1B5_2B3_1B4_Ref = object {
  _Leaf1B1_1B5_2B3_1B4
  scale 0.7
  rotate <0.0, 87.503036, 157.115646>
  translate  <6.91264, 3.05419, 9.48836>
}
#declare _Leaf1B1_1B5_2B3_1B5_Ref = object {
  _Leaf1B1_1B5_2B3_1B5
  scale 0.7
  rotate <0.0, 123.080368, 299.017883>
  translate  <6.99563, 3.0048, 9.5383>
}
#declare _Leaf1B1_1B5_2B3_1B6_Ref = object {
  _Leaf1B1_1B5_2B3_1B6
  scale 0.7
  rotate <0.0, 100.123528, 4.8982>
  translate  <7.19675, 2.96893, 9.75881>
}
#declare _Leaf1B1_1B5_2B3_1B7_Ref = object {
  _Leaf1B1_1B5_2B3_1B7
  scale 0.7
  rotate <0.0, 80.794922, 260.85791>
  translate  <7.24452, 2.93312, 9.84369>
}
#declare _Leaf1B1_1B5_2B3_1B8_Ref = object {
  _Leaf1B1_1B5_2B3_1B8
  scale 0.7
  rotate <0.0, 61.988998, 229.292374>
  translate  <7.37309, 2.90288, 9.99406>
}
#declare _Leaf1B1_1B5_2B3_1B9_Ref = object {
  _Leaf1B1_1B5_2B3_1B9
  scale 0.7
  rotate <0.0, 122.327728, 31.69429>
  translate  <7.38963, 2.90731, 9.98034>
}
#declare _Leaf1B1_1B5_2B3_1B10_Ref = object {
  _Leaf1B1_1B5_2B3_1B10
  scale 0.7
  rotate <0.0, 64.505463, 10.92084>
  translate  <7.5188, 2.8815, 10.13127>
}
#declare _Leaf1B1_1B5_2B3_1B11_Ref = object {
  _Leaf1B1_1B5_2B3_1B11
  scale 0.7
  rotate <0.0, 35.31419, 58.398441>
  translate  <7.5121, 2.88457, 10.13804>
}
#declare _Leaf1B1_1B5_2B3_1B12_Ref = object {
  _Leaf1B1_1B5_2B3_1B12
  scale 0.7
  rotate <0.0, 37.50988, 153.630127>
  translate  <7.50575, 2.87801, 10.14211>
}
#declare _Leaf1B1_1B5_2B4_1B1_Ref = object {
  _Leaf1B1_1B5_2B4_1B1
  scale 0.7
  rotate <0.0, 93.047707, 340.93454>
  translate  <6.95685, 3.28661, 9.0465>
}
#declare _Leaf1B1_1B5_2B4_1B2_Ref = object {
  _Leaf1B1_1B5_2B4_1B2
  scale 0.7
  rotate <0.0, 135.19342, 329.502014>
  translate  <7.14059, 3.32656, 8.97399>
}
#declare _Leaf1B1_1B5_2B4_1B3_Ref = object {
  _Leaf1B1_1B5_2B4_1B3
  scale 0.7
  rotate <0.0, 28.69138, 23.859921>
  translate  <7.24048, 3.37134, 8.98242>
}
#declare _Leaf1B1_1B5_2B4_1B4_Ref = object {
  _Leaf1B1_1B5_2B4_1B4
  scale 0.7
  rotate <0.0, 48.528099, 238.090485>
  translate  <7.24475, 3.35003, 8.98585>
}
#declare _Leaf1B1_1B5_2B4_1B5_Ref = object {
  _Leaf1B1_1B5_2B4_1B5
  scale 0.7
  rotate <0.0, 154.748642, 132.932373>
  translate  <7.32787, 3.3784, 8.92177>
}
#declare _Leaf1B1_1B5_2B4_1B6_Ref = object {
  _Leaf1B1_1B5_2B4_1B6
  scale 0.7
  rotate <0.0, 105.22348, 71.291634>
  translate  <7.6172, 3.43319, 8.86138>
}
#declare _Leaf1B1_1B5_2B4_1B7_Ref = object {
  _Leaf1B1_1B5_2B4_1B7
  scale 0.7
  rotate <0.0, 146.398712, 276.640106>
  translate  <7.71448, 3.42203, 8.82701>
}
#declare _Leaf1B1_1B5_2B4_1B8_Ref = object {
  _Leaf1B1_1B5_2B4_1B8
  scale 0.7
  rotate <0.0, 111.281326, 278.604584>
  translate  <7.90771, 3.45028, 8.78317>
}
#declare _Leaf1B1_1B5_2B4_1B9_Ref = object {
  _Leaf1B1_1B5_2B4_1B9
  scale 0.7
  rotate <0.0, 84.474571, 97.484871>
  translate  <7.90345, 3.47153, 8.77974>
}
#declare _Leaf1B1_1B5_2B4_1B10_Ref = object {
  _Leaf1B1_1B5_2B4_1B10
  scale 0.7
  rotate <0.0, 92.852837, 36.867538>
  translate  <8.09747, 3.50162, 8.73993>
}
#declare _Leaf1B1_1B5_2B4_1B11_Ref = object {
  _Leaf1B1_1B5_2B4_1B11
  scale 0.7
  rotate <0.0, 59.995209, 4.28255>
  translate  <8.10027, 3.49422, 8.74605>
}
#declare _Leaf1B1_1B5_2B4_1B12_Ref = object {
  _Leaf1B1_1B5_2B4_1B12
  scale 0.7
  rotate <0.0, 56.03503, 302.157959>
  translate  <8.10083, 3.48484, 8.74263>
}
#declare _Leaf1B1_1B5_2B5_1B1_Ref = object {
  _Leaf1B1_1B5_2B5_1B1
  scale 0.7
  rotate <0.0, 93.717072, 29.70232>
  translate  <7.08941, 3.62898, 9.34141>
}
#declare _Leaf1B1_1B5_2B5_1B2_Ref = object {
  _Leaf1B1_1B5_2B5_1B2
  scale 0.7
  rotate <0.0, 98.244751, 73.049187>
  translate  <7.20902, 3.76338, 9.4322>
}
#declare _Leaf1B1_1B5_2B5_1B3_Ref = object {
  _Leaf1B1_1B5_2B5_1B3
  scale 0.7
  rotate <0.0, 75.594368, 319.070526>
  translate  <7.29049, 3.78979, 9.5009>
}
#declare _Leaf1B1_1B5_2B5_1B4_Ref = object {
  _Leaf1B1_1B5_2B5_1B4
  scale 0.7
  rotate <0.0, 139.119125, 277.143524>
  translate  <7.30017, 3.79208, 9.48128>
}
#declare _Leaf1B1_1B5_2B5_1B5_Ref = object {
  _Leaf1B1_1B5_2B5_1B5
  scale 0.7
  rotate <0.0, 73.761818, 138.574493>
  translate  <7.33824, 3.87912, 9.53416>
}
#declare _Leaf1B1_1B5_2B5_1B6_Ref = object {
  _Leaf1B1_1B5_2B5_1B6
  scale 0.7
  rotate <0.0, 12.27824, 100.069221>
  translate  <7.55215, 4.04404, 9.66608>
}
#declare _Leaf1B1_1B5_2B5_1B7_Ref = object {
  _Leaf1B1_1B5_2B5_1B7
  scale 0.7
  rotate <0.0, 117.563187, 103.017464>
  translate  <7.62398, 4.11705, 9.68277>
}
#declare _Leaf1B1_1B5_2B5_1B8_Ref = object {
  _Leaf1B1_1B5_2B5_1B8
  scale 0.7
  rotate <0.0, 146.040024, 74.197441>
  translate  <7.76702, 4.23174, 9.76305>
}
#declare _Leaf1B1_1B5_2B5_1B9_Ref = object {
  _Leaf1B1_1B5_2B5_1B9
  scale 0.7
  rotate <0.0, 24.327971, 227.992355>
  translate  <7.75737, 4.22946, 9.78262>
}
#declare _Leaf1B1_1B5_2B5_1B10_Ref = object {
  _Leaf1B1_1B5_2B5_1B10
  scale 0.7
  rotate <0.0, 37.92561, 26.625469>
  translate  <7.9025, 4.34056, 9.86463>
}
#declare _Leaf1B1_1B5_2B5_1B11_Ref = object {
  _Leaf1B1_1B5_2B5_1B11
  scale 0.7
  rotate <0.0, 75.080017, 354.104004>
  translate  <7.9092, 4.3375, 9.85786>
}
#declare _Leaf1B1_1B5_2B5_1B12_Ref = object {
  _Leaf1B1_1B5_2B5_1B12
  scale 0.7
  rotate <0.0, 126.512627, 345.748779>
  translate  <7.91012, 4.34237, 9.84918>
}
#declare _Leaf1B1_1B5_1B1_1B1_Ref = object {
  _Leaf1B1_1B5_1B1_1B1
  scale 0.7
  rotate <0.0, 123.436302, 56.032921>
  translate  <4.72346, 1.94372, 7.76263>
}
#declare _Leaf1B1_1B5_1B1_1B2_Ref = object {
  _Leaf1B1_1B5_1B1_1B2
  scale 0.7
  rotate <0.0, 127.230164, 109.652481>
  translate  <4.76145, 2.14077, 7.74421>
}
#declare _Leaf1B1_1B5_1B1_1B3_Ref = object {
  _Leaf1B1_1B5_1B1_1B3
  scale 0.7
  rotate <0.0, 77.273361, 357.572632>
  translate  <4.82228, 2.23001, 7.764>
}
#declare _Leaf1B1_1B5_1B1_1B4_Ref = object {
  _Leaf1B1_1B5_1B1_1B4
  scale 0.7
  rotate <0.0, 113.847641, 292.258148>
  translate  <4.82757, 2.22544, 7.74314>
}
#declare _Leaf1B1_1B5_1B1_1B5_Ref = object {
  _Leaf1B1_1B5_1B1_1B5
  scale 0.7
  rotate <0.0, 77.095131, 160.628006>
  translate  <4.81838, 2.33372, 7.73959>
}
#declare _Leaf1B1_1B5_1B1_1B6_Ref = object {
  _Leaf1B1_1B5_1B1_1B6
  scale 0.7
  rotate <0.0, 40.907478, 95.081284>
  translate  <4.92351, 2.61394, 7.71155>
}
#declare _Leaf1B1_1B5_1B1_1B7_Ref = object {
  _Leaf1B1_1B5_1B1_1B7
  scale 0.7
  rotate <0.0, 132.525146, 154.301895>
  translate  <4.94714, 2.70673, 7.67155>
}
#declare _Leaf1B1_1B5_1B1_1B8_Ref = object {
  _Leaf1B1_1B5_1B1_1B8
  scale 0.7
  rotate <0.0, 166.818375, 172.594543>
  translate  <5.01444, 2.89324, 7.64428>
}
#declare _Leaf1B1_1B5_1B1_1B9_Ref = object {
  _Leaf1B1_1B5_1B1_1B9
  scale 0.7
  rotate <0.0, 7.76957, 87.17804>
  translate  <5.00916, 2.8978, 7.66508>
}
#declare _Leaf1B1_1B5_1B1_1B10_Ref = object {
  _Leaf1B1_1B5_1B1_1B10
  scale 0.7
  rotate <0.0, 68.30204, 65.397171>
  translate  <5.08026, 3.0834, 7.64002>
}
#declare _Leaf1B1_1B5_1B1_1B11_Ref = object {
  _Leaf1B1_1B5_1B1_1B11
  scale 0.7
  rotate <0.0, 93.912392, 27.26026>
  translate  <5.08696, 3.08034, 7.63325>
}
#declare _Leaf1B1_1B5_1B1_1B12_Ref = object {
  _Leaf1B1_1B5_1B1_1B12
  scale 0.7
  rotate <0.0, 133.53595, 349.037231>
  translate  <5.08443, 3.07981, 7.62359>
}
#declare _Leaf1B1_1B5_1B2_1B1_Ref = object {
  _Leaf1B1_1B5_1B2_1B1
  scale 0.7
  rotate <0.0, 68.73317, 324.541229>
  translate  <5.27341, 1.84952, 8.09485>
}
#declare _Leaf1B1_1B5_1B2_1B2_Ref = object {
  _Leaf1B1_1B5_1B2_1B2
  scale 0.7
  rotate <0.0, 110.036873, 311.167023>
  translate  <5.4722, 1.81798, 8.08466>
}
#declare _Leaf1B1_1B5_1B2_1B3_Ref = object {
  _Leaf1B1_1B5_1B2_1B3
  scale 0.7
  rotate <0.0, 25.473301, 57.837379>
  translate  <5.57525, 1.8378, 8.11694>
}
#declare _Leaf1B1_1B5_1B2_1B4_Ref = object {
  _Leaf1B1_1B5_1B2_1B4
  scale 0.7
  rotate <0.0, 52.382099, 199.584335>
  translate  <5.5711, 1.81848, 8.12662>
}
#declare _Leaf1B1_1B5_1B2_1B5_Ref = object {
  _Leaf1B1_1B5_1B2_1B5
  scale 0.7
  rotate <0.0, 174.401947, 33.288132>
  translate  <5.67277, 1.8032, 8.09125>
}
#declare _Leaf1B1_1B5_1B2_1B6_Ref = object {
  _Leaf1B1_1B5_1B2_1B6
  scale 0.7
  rotate <0.0, 110.198723, 45.781528>
  translate  <5.9688, 1.76403, 8.12579>
}
#declare _Leaf1B1_1B5_1B2_1B7_Ref = object {
  _Leaf1B1_1B5_1B2_1B7
  scale 0.7
  rotate <0.0, 126.91243, 276.878754>
  translate  <6.06219, 1.71919, 8.1317>
}
#declare _Leaf1B1_1B5_1B2_1B8_Ref = object {
  _Leaf1B1_1B5_1B2_1B8
  scale 0.7
  rotate <0.0, 93.465637, 265.127991>
  translate  <6.25805, 1.68426, 8.15357>
}
#declare _Leaf1B1_1B5_1B2_1B9_Ref = object {
  _Leaf1B1_1B5_1B2_1B9
  scale 0.7
  rotate <0.0, 101.126228, 79.055992>
  translate  <6.26219, 1.70352, 8.14393>
}
#declare _Leaf1B1_1B5_1B2_1B10_Ref = object {
  _Leaf1B1_1B5_1B2_1B10
  scale 0.7
  rotate <0.0, 84.552399, 19.933411>
  translate  <6.4583, 1.67141, 8.16929>
}
#declare _Leaf1B1_1B5_1B2_1B11_Ref = object {
  _Leaf1B1_1B5_1B2_1B11
  scale 0.7
  rotate <0.0, 42.080582, 1.63613>
  translate  <6.45674, 1.66603, 8.17758>
}
#declare _Leaf1B1_1B5_1B2_1B12_Ref = object {
  _Leaf1B1_1B5_1B2_1B12
  scale 0.7
  rotate <0.0, 34.08654, 271.713165>
  translate  <6.45503, 1.6562, 8.17691>
}
#declare _Leaf1B1_1B5_1B3_1B1_Ref = object {
  _Leaf1B1_1B5_1B3_1B1
  scale 0.7
  rotate <0.0, 36.97036, 120.017662>
  translate  <5.13176, 2.11086, 8.44604>
}
#declare _Leaf1B1_1B5_1B3_1B2_Ref = object {
  _Leaf1B1_1B5_1B3_1B2
  scale 0.7
  rotate <0.0, 34.468578, 198.356277>
  translate  <5.15317, 2.13308, 8.64519>
}
#declare _Leaf1B1_1B5_1B3_1B3_Ref = object {
  _Leaf1B1_1B5_1B3_1B3
  scale 0.7
  rotate <0.0, 91.36718, 62.565979>
  translate  <5.20117, 2.1781, 8.73308>
}
#declare _Leaf1B1_1B5_1B3_1B4_Ref = object {
  _Leaf1B1_1B5_1B3_1B4
  scale 0.7
  rotate <0.0, 138.309753, 129.011765>
  translate  <5.182, 2.18888, 8.73235>
}
#declare _Leaf1B1_1B5_1B3_1B5_Ref = object {
  _Leaf1B1_1B5_1B3_1B5
  scale 0.7
  rotate <0.0, 76.676788, 271.078491>
  translate  <5.19211, 2.17048, 8.83903>
}
#declare _Leaf1B1_1B5_1B3_1B6_Ref = object {
  _Leaf1B1_1B5_1B3_1B6
  scale 0.7
  rotate <0.0, 59.152431, 338.938293>
  translate  <5.23424, 2.25177, 9.12535>
}
#declare _Leaf1B1_1B5_1B3_1B7_Ref = object {
  _Leaf1B1_1B5_1B3_1B7
  scale 0.7
  rotate <0.0, 66.988068, 212.952606>
  translate  <5.21597, 2.27563, 9.22467>
}
#declare _Leaf1B1_1B5_1B3_1B8_Ref = object {
  _Leaf1B1_1B5_1B3_1B8
  scale 0.7
  rotate <0.0, 79.686111, 178.60849>
  translate  <5.2351, 2.32932, 9.41653>
}
#declare _Leaf1B1_1B5_1B3_1B9_Ref = object {
  _Leaf1B1_1B5_1B3_1B9
  scale 0.7
  rotate <0.0, 91.840492, 345.192474>
  translate  <5.25421, 2.31857, 9.41726>
}
#declare _Leaf1B1_1B5_1B3_1B10_Ref = object {
  _Leaf1B1_1B5_1B3_1B10
  scale 0.7
  rotate <0.0, 37.702881, 18.919371>
  translate  <5.27632, 2.37546, 9.60807>
}
#declare _Leaf1B1_1B5_1B3_1B11_Ref = object {
  _Leaf1B1_1B5_1B3_1B11
  scale 0.7
  rotate <0.0, 59.335709, 74.100769>
  translate  <5.27119, 2.3839, 9.60655>
}
#declare _Leaf1B1_1B5_1B3_1B12_Ref = object {
  _Leaf1B1_1B5_1B3_1B12
  scale 0.7
  rotate <0.0, 88.945351, 119.319389>
  translate  <5.26123, 2.38394, 9.6075>
}
#declare _Leaf1B1_1B6_2B1_1B1_Ref = object {
  _Leaf1B1_1B6_2B1_1B1
  scale 0.7
  rotate <0.0, 53.412441, 273.902161>
  translate  <5.63229, 1.2374, 9.7383>
}
#declare _Leaf1B1_1B6_2B1_1B2_Ref = object {
  _Leaf1B1_1B6_2B1_1B2
  scale 0.7
  rotate <0.0, 95.769836, 283.626495>
  translate  <5.75745, 1.10497, 9.82439>
}
#declare _Leaf1B1_1B6_2B1_1B3_Ref = object {
  _Leaf1B1_1B6_2B1_1B3
  scale 0.7
  rotate <0.0, 19.55839, 110.757477>
  translate  <5.82172, 1.07198, 9.90707>
}
#declare _Leaf1B1_1B6_2B1_1B4_Ref = object {
  _Leaf1B1_1B6_2B1_1B4
  scale 0.7
  rotate <0.0, 84.571327, 165.077408>
  translate  <5.80393, 1.05933, 9.90983>
}
#declare _Leaf1B1_1B6_2B1_1B5_Ref = object {
  _Leaf1B1_1B6_2B1_1B5
  scale 0.7
  rotate <0.0, 142.363205, 346.825775>
  translate  <5.88386, 0.98804, 9.92849>
}
#declare _Leaf1B1_1B6_2B1_1B6_Ref = object {
  _Leaf1B1_1B6_2B1_1B6
  scale 0.7
  rotate <0.0, 81.149239, 9.96186>
  translate  <6.04874, 0.80443, 10.10014>
}
#declare _Leaf1B1_1B6_2B1_1B7_Ref = object {
  _Leaf1B1_1B6_2B1_1B7
  scale 0.7
  rotate <0.0, 126.6688, 267.428864>
  translate  <6.08654, 0.71854, 10.14445>
}
#declare _Leaf1B1_1B6_2B1_1B8_Ref = object {
  _Leaf1B1_1B6_2B1_1B8
  scale 0.7
  rotate <0.0, 105.411484, 235.880371>
  translate  <6.19147, 0.58936, 10.25562>
}
#declare _Leaf1B1_1B6_2B1_1B9_Ref = object {
  _Leaf1B1_1B6_2B1_1B9
  scale 0.7
  rotate <0.0, 84.431007, 43.301319>
  translate  <6.20922, 0.60196, 10.25288>
}
#declare _Leaf1B1_1B6_2B1_1B10_Ref = object {
  _Leaf1B1_1B6_2B1_1B10
  scale 0.7
  rotate <0.0, 52.36747, 345.819061>
  translate  <6.31399, 0.47551, 10.36762>
}
#declare _Leaf1B1_1B6_2B1_1B11_Ref = object {
  _Leaf1B1_1B6_2B1_1B11
  scale 0.7
  rotate <0.0, 14.30285, 290.816071>
  translate  <6.30588, 0.47299, 10.37291>
}
#declare _Leaf1B1_1B6_2B1_1B12_Ref = object {
  _Leaf1B1_1B6_2B1_1B12
  scale 0.7
  rotate <0.0, 52.228249, 207.184341>
  translate  <6.29998, 0.46555, 10.36979>
}
#declare _Leaf1B1_1B6_2B2_1B1_Ref = object {
  _Leaf1B1_1B6_2B2_1B1
  scale 0.7
  rotate <0.0, 38.226398, 149.370132>
  translate  <5.5904, 1.48401, 10.19861>
}
#declare _Leaf1B1_1B6_2B2_1B2_Ref = object {
  _Leaf1B1_1B6_2B2_1B2
  scale 0.7
  rotate <0.0, 63.027618, 197.065735>
  translate  <5.5293, 1.43751, 10.38494>
}
#declare _Leaf1B1_1B6_2B2_1B3_Ref = object {
  _Leaf1B1_1B6_2B2_1B3
  scale 0.7
  rotate <0.0, 61.109509, 51.398529>
  translate  <5.54181, 1.43812, 10.49402>
}
#declare _Leaf1B1_1B6_2B2_1B4_Ref = object {
  _Leaf1B1_1B6_2B2_1B4
  scale 0.7
  rotate <0.0, 125.324142, 89.403549>
  translate  <5.52641, 1.45356, 10.49113>
}
#declare _Leaf1B1_1B6_2B2_1B5_Ref = object {
  _Leaf1B1_1B6_2B2_1B5
  scale 0.7
  rotate <0.0, 100.238663, 257.392853>
  translate  <5.48827, 1.40147, 10.5786>
}
#declare _Leaf1B1_1B6_2B2_1B6_Ref = object {
  _Leaf1B1_1B6_2B2_1B6
  scale 0.7
  rotate <0.0, 53.903641, 304.841034>
  translate  <5.41745, 1.37628, 10.86966>
}
#declare _Leaf1B1_1B6_2B2_1B7_Ref = object {
  _Leaf1B1_1B6_2B2_1B7
  scale 0.7
  rotate <0.0, 97.08004, 201.042358>
  translate  <5.36277, 1.37289, 10.95779>
}
#declare _Leaf1B1_1B6_2B2_1B8_Ref = object {
  _Leaf1B1_1B6_2B2_1B8
  scale 0.7
  rotate <0.0, 99.821564, 165.600952>
  translate  <5.30703, 1.35787, 11.14943>
}
#declare _Leaf1B1_1B6_2B2_1B9_Ref = object {
  _Leaf1B1_1B6_2B2_1B9
  scale 0.7
  rotate <0.0, 78.478981, 329.620667>
  translate  <5.3224, 1.34248, 11.15231>
}
#declare _Leaf1B1_1B6_2B2_1B10_Ref = object {
  _Leaf1B1_1B6_2B2_1B10
  scale 0.7
  rotate <0.0, 18.1094, 313.866791>
  translate  <5.27022, 1.32984, 11.34532>
}
#declare _Leaf1B1_1B6_2B2_1B11_Ref = object {
  _Leaf1B1_1B6_2B2_1B11
  scale 0.7
  rotate <0.0, 32.84343, 78.02755>
  translate  <5.26742, 1.33944, 11.34559>
}
#declare _Leaf1B1_1B6_2B2_1B12_Ref = object {
  _Leaf1B1_1B6_2B2_1B12
  scale 0.7
  rotate <0.0, 78.965363, 109.42276>
  translate  <5.25809, 1.342, 11.34304>
}
#declare _Leaf1B1_1B6_2B3_1B1_Ref = object {
  _Leaf1B1_1B6_2B3_1B1
  scale 0.7
  rotate <0.0, 93.039993, 348.110352>
  translate  <6.29782, 1.63664, 10.45394>
}
#declare _Leaf1B1_1B6_2B3_1B2_Ref = object {
  _Leaf1B1_1B6_2B3_1B2
  scale 0.7
  rotate <0.0, 126.967392, 17.43928>
  translate  <6.48312, 1.71373, 10.4722>
}
#declare _Leaf1B1_1B6_2B3_1B3_Ref = object {
  _Leaf1B1_1B6_2B3_1B3
  scale 0.7
  rotate <0.0, 33.331779, 297.568512>
  translate  <6.57254, 1.73822, 10.53101>
}
#declare _Leaf1B1_1B6_2B3_1B4_Ref = object {
  _Leaf1B1_1B6_2B3_1B4
  scale 0.7
  rotate <0.0, 94.036041, 246.218124>
  translate  <6.57927, 1.72065, 10.51961>
}
#declare _Leaf1B1_1B6_2B3_1B5_Ref = object {
  _Leaf1B1_1B6_2B3_1B5
  scale 0.7
  rotate <0.0, 118.150124, 101.749603>
  translate  <6.66677, 1.78489, 10.51343>
}
#declare _Leaf1B1_1B6_2B3_1B6_Ref = object {
  _Leaf1B1_1B6_2B3_1B6
  scale 0.7
  rotate <0.0, 58.775791, 75.7313>
  translate  <6.95084, 1.8626, 10.57364>
}
#declare _Leaf1B1_1B6_2B3_1B7_Ref = object {
  _Leaf1B1_1B6_2B3_1B7
  scale 0.7
  rotate <0.0, 159.900635, 35.077789>
  translate  <7.05303, 1.87768, 10.56377>
}
#declare _Leaf1B1_1B6_2B3_1B8_Ref = object {
  _Leaf1B1_1B6_2B3_1B8
  scale 0.7
  rotate <0.0, 148.777145, 309.777466>
  translate  <7.24456, 1.92615, 10.5958>
}
#declare _Leaf1B1_1B6_2B3_1B9_Ref = object {
  _Leaf1B1_1B6_2B3_1B9
  scale 0.7
  rotate <0.0, 44.040421, 114.441719>
  translate  <7.23785, 1.94367, 10.60717>
}
#declare _Leaf1B1_1B6_2B3_1B10_Ref = object {
  _Leaf1B1_1B6_2B3_1B10
  scale 0.7
  rotate <0.0, 56.216759, 32.725479>
  translate  <7.42921, 1.99058, 10.64342>
}
#declare _Leaf1B1_1B6_2B3_1B11_Ref = object {
  _Leaf1B1_1B6_2B3_1B11
  scale 0.7
  rotate <0.0, 54.538631, 337.003937>
  translate  <7.43202, 1.98098, 10.64315>
}
#declare _Leaf1B1_1B6_2B3_1B12_Ref = object {
  _Leaf1B1_1B6_2B3_1B12
  scale 0.7
  rotate <0.0, 90.121368, 296.187195>
  translate  <7.43451, 1.97674, 10.63445>
}
#declare _Leaf1B1_1B6_2B4_1B1_Ref = object {
  _Leaf1B1_1B6_2B4_1B1
  scale 0.7
  rotate <0.0, 82.155296, 66.810478>
  translate  <6.15297, 1.8579, 10.74467>
}
#declare _Leaf1B1_1B6_2B4_1B2_Ref = object {
  _Leaf1B1_1B6_2B4_1B2
  scale 0.7
  rotate <0.0, 92.709198, 108.934753>
  translate  <6.15202, 2.02092, 10.86316>
}
#declare _Leaf1B1_1B6_2B4_1B3_Ref = object {
  _Leaf1B1_1B6_2B4_1B3
  scale 0.7
  rotate <0.0, 67.892906, 352.814178>
  translate  <6.18968, 2.07901, 10.94838>
}
#declare _Leaf1B1_1B6_2B4_1B4_Ref = object {
  _Leaf1B1_1B6_2B4_1B4
  scale 0.7
  rotate <0.0, 138.004013, 328.124207>
  translate  <6.1988, 2.08952, 10.93133>
}
#declare _Leaf1B1_1B6_2B4_1B5_Ref = object {
  _Leaf1B1_1B6_2B4_1B5
  scale 0.7
  rotate <0.0, 81.815247, 177.564255>
  translate  <6.16822, 2.17297, 10.99396>
}
#declare _Leaf1B1_1B6_2B4_1B6_Ref = object {
  _Leaf1B1_1B6_2B4_1B6
  scale 0.7
  rotate <0.0, 17.508551, 181.018723>
  translate  <6.21659, 2.4091, 11.17358>
}
#declare _Leaf1B1_1B6_2B4_1B7_Ref = object {
  _Leaf1B1_1B6_2B4_1B7
  scale 0.7
  rotate <0.0, 117.720932, 133.467484>
  translate  <6.2263, 2.50668, 11.20752>
}
#declare _Leaf1B1_1B6_2B4_1B8_Ref = object {
  _Leaf1B1_1B6_2B4_1B8
  scale 0.7
  rotate <0.0, 139.463196, 97.246552>
  translate  <6.25717, 2.66931, 11.32003>
}
#declare _Leaf1B1_1B6_2B4_1B9_Ref = object {
  _Leaf1B1_1B6_2B4_1B9
  scale 0.7
  rotate <0.0, 34.761471, 253.005707>
  translate  <6.24808, 2.65883, 11.33702>
}
#declare _Leaf1B1_1B6_2B4_1B10_Ref = object {
  _Leaf1B1_1B6_2B4_1B10
  scale 0.7
  rotate <0.0, 26.372841, 70.700912>
  translate  <6.28249, 2.81956, 11.45154>
}
#declare _Leaf1B1_1B6_2B4_1B11_Ref = object {
  _Leaf1B1_1B6_2B4_1B11
  scale 0.7
  rotate <0.0, 63.172482, 29.78396>
  translate  <6.2906, 2.82208, 11.44625>
}
#declare _Leaf1B1_1B6_2B4_1B12_Ref = object {
  _Leaf1B1_1B6_2B4_1B12
  scale 0.7
  rotate <0.0, 115.038879, 25.455971>
  translate  <6.28967, 2.82783, 11.43812>
}
#declare _Leaf1B1_1B6_2B5_1B1_Ref = object {
  _Leaf1B1_1B6_2B5_1B1
  scale 0.7
  rotate <0.0, 33.577808, 70.854599>
  translate  <6.39937, 1.69492, 11.11139>
}
#declare _Leaf1B1_1B6_2B5_1B2_Ref = object {
  _Leaf1B1_1B6_2B5_1B2
  scale 0.7
  rotate <0.0, 13.10548, 202.88237>
  translate  <6.50027, 1.69607, 11.28584>
}
#declare _Leaf1B1_1B6_2B5_1B3_Ref = object {
  _Leaf1B1_1B6_2B5_1B3
  scale 0.7
  rotate <0.0, 103.472069, 48.802479>
  translate  <6.58847, 1.72015, 11.34663>
}
#declare _Leaf1B1_1B6_2B5_1B4_Ref = object {
  _Leaf1B1_1B6_2B5_1B4
  scale 0.7
  rotate <0.0, 123.079201, 127.738731>
  translate  <6.57422, 1.73567, 11.35296>
}
#declare _Leaf1B1_1B6_2B5_1B5_Ref = object {
  _Leaf1B1_1B6_2B5_1B5
  scale 0.7
  rotate <0.0, 76.019897, 260.370117>
  translate  <6.61877, 1.70752, 11.44806>
}
#declare _Leaf1B1_1B6_2B5_1B6_Ref = object {
  _Leaf1B1_1B6_2B5_1B6
  scale 0.7
  rotate <0.0, 79.942787, 326.225616>
  translate  <6.78736, 1.75357, 11.69264>
}
#declare _Leaf1B1_1B6_2B5_1B7_Ref = object {
  _Leaf1B1_1B6_2B5_1B7
  scale 0.7
  rotate <0.0, 47.369308, 204.388412>
  translate  <6.81561, 1.77415, 11.79035>
}
#declare _Leaf1B1_1B6_2B5_1B8_Ref = object {
  _Leaf1B1_1B6_2B5_1B8
  scale 0.7
  rotate <0.0, 57.042931, 161.081329>
  translate  <6.92033, 1.80667, 11.95779>
}
#declare _Leaf1B1_1B6_2B5_1B9_Ref = object {
  _Leaf1B1_1B6_2B5_1B9
  scale 0.7
  rotate <0.0, 113.159981, 327.004547>
  translate  <6.93454, 1.7912, 11.95147>
}
#declare _Leaf1B1_1B6_2B5_1B10_Ref = object {
  _Leaf1B1_1B6_2B5_1B10
  scale 0.7
  rotate <0.0, 60.108898, 358.597778>
  translate  <7.04236, 1.82609, 12.11667>
}
#declare _Leaf1B1_1B6_2B5_1B11_Ref = object {
  _Leaf1B1_1B6_2B5_1B11
  scale 0.7
  rotate <0.0, 69.623466, 47.862171>
  translate  <7.03956, 1.83568, 12.11694>
}
#declare _Leaf1B1_1B6_2B5_1B12_Ref = object {
  _Leaf1B1_1B6_2B5_1B12
  scale 0.7
  rotate <0.0, 80.004822, 100.927063>
  translate  <7.03114, 1.8383, 12.12166>
}
#declare _Leaf1B1_1B6_1B1_1B1_Ref = object {
  _Leaf1B1_1B6_1B1_1B1
  scale 0.7
  rotate <0.0, 34.360531, 143.268616>
  translate  <4.39905, 1.18246, 8.52944>
}
#declare _Leaf1B1_1B6_1B1_1B2_Ref = object {
  _Leaf1B1_1B6_1B1_1B2
  scale 0.7
  rotate <0.0, 57.030479, 197.279877>
  translate  <4.35714, 1.14138, 8.72224>
}
#declare _Leaf1B1_1B6_1B1_1B3_Ref = object {
  _Leaf1B1_1B6_1B1_1B3
  scale 0.7
  rotate <0.0, 66.063263, 49.87645>
  translate  <4.38052, 1.14522, 8.82945>
}
#declare _Leaf1B1_1B6_1B1_1B4_Ref = object {
  _Leaf1B1_1B6_1B1_1B4
  scale 0.7
  rotate <0.0, 126.847, 93.797531>
  translate  <4.36484, 1.16055, 8.82767>
}
#declare _Leaf1B1_1B6_1B1_1B5_Ref = object {
  _Leaf1B1_1B6_1B1_1B5
  scale 0.7
  rotate <0.0, 97.308868, 256.74472>
  translate  <4.33588, 1.11101, 8.92001>
}
#declare _Leaf1B1_1B6_1B1_1B6_Ref = object {
  _Leaf1B1_1B6_1B1_1B6
  scale 0.7
  rotate <0.0, 56.017471, 308.94278>
  translate  <4.29471, 1.0943, 9.21731>
}
#declare _Leaf1B1_1B6_1B1_1B7_Ref = object {
  _Leaf1B1_1B6_1B1_1B7
  scale 0.7
  rotate <0.0, 91.103348, 201.16684>
  translate  <4.24915, 1.09344, 9.31054>
}
#declare _Leaf1B1_1B6_1B1_1B8_Ref = object {
  _Leaf1B1_1B6_1B1_1B8
  scale 0.7
  rotate <0.0, 94.647713, 166.147278>
  translate  <4.21298, 1.08399, 9.50717>
}
#declare _Leaf1B1_1B6_1B1_1B9_Ref = object {
  _Leaf1B1_1B6_1B1_1B9
  scale 0.7
  rotate <0.0, 82.630569, 330.50235>
  translate  <4.22862, 1.06871, 9.50894>
}
#declare _Leaf1B1_1B6_1B1_1B10_Ref = object {
  _Leaf1B1_1B6_1B1_1B10
  scale 0.7
  rotate <0.0, 21.53657, 327.779175>
  translate  <4.19611, 1.0617, 9.7065>
}
#declare _Leaf1B1_1B6_1B1_1B11_Ref = object {
  _Leaf1B1_1B6_1B1_1B11
  scale 0.7
  rotate <0.0, 36.021519, 70.748268>
  translate  <4.19331, 1.0713, 9.70677>
}
#declare _Leaf1B1_1B6_1B1_1B12_Ref = object {
  _Leaf1B1_1B6_1B1_1B12
  scale 0.7
  rotate <0.0, 78.690399, 108.39888>
  translate  <4.18376, 1.07376, 9.7051>
}
#declare _Leaf1B1_1B6_1B2_1B1_Ref = object {
  _Leaf1B1_1B6_1B2_1B1
  scale 0.7
  rotate <0.0, 97.834587, 42.175919>
  translate  <4.93232, 1.51337, 8.69623>
}
#declare _Leaf1B1_1B6_1B2_1B2_Ref = object {
  _Leaf1B1_1B6_1B2_1B2
  scale 0.7
  rotate <0.0, 110.612053, 85.054039>
  translate  <5.00777, 1.6897, 8.75811>
}
#declare _Leaf1B1_1B6_1B2_1B3_Ref = object {
  _Leaf1B1_1B6_1B2_1B3
  scale 0.7
  rotate <0.0, 64.358368, 336.185516>
  translate  <5.07317, 1.74985, 8.82262>
}
#declare _Leaf1B1_1B6_1B2_1B4_Ref = object {
  _Leaf1B1_1B6_1B2_1B4
  scale 0.7
  rotate <0.0, 124.87278, 292.063782>
  translate  <5.08416, 1.75004, 8.80356>
}
#declare _Leaf1B1_1B6_1B2_1B5_Ref = object {
  _Leaf1B1_1B6_1B2_1B5
  scale 0.7
  rotate <0.0, 85.424583, 150.909454>
  translate  <5.09555, 1.85324, 8.83582>
}
#declare _Leaf1B1_1B6_1B2_1B6_Ref = object {
  _Leaf1B1_1B6_1B2_1B6
  scale 0.7
  rotate <0.0, 26.56575, 115.129639>
  translate  <5.25089, 2.09064, 8.93518>
}
#declare _Leaf1B1_1B6_1B2_1B7_Ref = object {
  _Leaf1B1_1B6_1B2_1B7
  scale 0.7
  rotate <0.0, 131.854858, 117.011017>
  translate  <5.30208, 2.18088, 8.93754>
}
#declare _Leaf1B1_1B6_1B2_1B8_Ref = object {
  _Leaf1B1_1B6_1B2_1B8
  scale 0.7
  rotate <0.0, 157.721573, 72.173691>
  translate  <5.40582, 2.34202, 8.99523>
}
#declare _Leaf1B1_1B6_1B2_1B9_Ref = object {
  _Leaf1B1_1B6_1B2_1B9
  scale 0.7
  rotate <0.0, 19.564011, 207.528656>
  translate  <5.39486, 2.34183, 9.01423>
}
#declare _Leaf1B1_1B6_1B2_1B10_Ref = object {
  _Leaf1B1_1B6_1B2_1B10
  scale 0.7
  rotate <0.0, 43.36729, 56.0494>
  translate  <5.50125, 2.50049, 9.07456>
}
#declare _Leaf1B1_1B6_1B2_1B11_Ref = object {
  _Leaf1B1_1B6_1B2_1B11
  scale 0.7
  rotate <0.0, 71.08432, 12.16855>
  translate  <5.50917, 2.49774, 9.0691>
}
#declare _Leaf1B1_1B6_1B2_1B12_Ref = object {
  _Leaf1B1_1B6_1B2_1B12
  scale 0.7
  rotate <0.0, 119.19249, 351.621857>
  translate  <5.50991, 2.50065, 9.05956>
}
#declare _Leaf1B1_1B6_1B3_1B1_Ref = object {
  _Leaf1B1_1B6_1B3_1B1
  scale 0.7
  rotate <0.0, 70.61721, 301.391418>
  translate  <5.13796, 1.13878, 8.86678>
}
#declare _Leaf1B1_1B6_1B3_1B2_Ref = object {
  _Leaf1B1_1B6_1B3_1B2
  scale 0.7
  rotate <0.0, 113.463699, 307.971558>
  translate  <5.32036, 1.05868, 8.89727>
}
#declare _Leaf1B1_1B6_1B3_1B3_Ref = object {
  _Leaf1B1_1B6_1B3_1B3
  scale 0.7
  rotate <0.0, 1.72255, 136.913483>
  translate  <5.4088, 1.03994, 8.95957>
}
#declare _Leaf1B1_1B6_1B3_1B4_Ref = object {
  _Leaf1B1_1B6_1B3_1B4
  scale 0.7
  rotate <0.0, 74.490936, 192.767914>
  translate  <5.39841, 1.02057, 8.96049>
}
#declare _Leaf1B1_1B6_1B3_1B5_Ref = object {
  _Leaf1B1_1B6_1B3_1B5
  scale 0.7
  rotate <0.0, 149.083664, 36.517712>
  translate  <5.50178, 0.98882, 8.9492>
}
#declare _Leaf1B1_1B6_1B3_1B6_Ref = object {
  _Leaf1B1_1B6_1B3_1B6
  scale 0.7
  rotate <0.0, 84.813423, 32.73608>
  translate  <5.75836, 0.8628, 9.04216>
}
#declare _Leaf1B1_1B6_1B3_1B7_Ref = object {
  _Leaf1B1_1B6_1B3_1B7
  scale 0.7
  rotate <0.0, 142.587769, 284.22821>
  translate  <5.83533, 0.79452, 9.05565>
}
#declare _Leaf1B1_1B6_1B3_1B8_Ref = object {
  _Leaf1B1_1B6_1B3_1B8
  scale 0.7
  rotate <0.0, 115.047363, 255.227768>
  translate  <6.00386, 0.70311, 9.11312>
}
#declare _Leaf1B1_1B6_1B3_1B9_Ref = object {
  _Leaf1B1_1B6_1B3_1B9
  scale 0.7
  rotate <0.0, 77.886703, 65.638>
  translate  <6.01422, 0.72242, 9.1122>
}
#declare _Leaf1B1_1B6_1B3_1B10_Ref = object {
  _Leaf1B1_1B6_1B3_1B10
  scale 0.7
  rotate <0.0, 63.720921, 2.05629>
  translate  <6.18231, 0.63257, 9.17387>
}
#declare _Leaf1B1_1B6_1B3_1B11_Ref = object {
  _Leaf1B1_1B6_1B3_1B11
  scale 0.7
  rotate <0.0, 32.13908, 315.662231>
  translate  <6.1772, 0.62572, 9.17906>
}
#declare _Leaf1B1_1B6_1B3_1B12_Ref = object {
  _Leaf1B1_1B6_1B3_1B12
  scale 0.7
  rotate <0.0, 56.256699, 244.774948>
  translate  <6.17413, 0.61732, 9.17459>
}
#declare _Leaf1B2_1B1_2B1_1B1_Ref = object {
  _Leaf1B2_1B1_2B1_1B1
  scale 0.7
  rotate <0.0, 112.243111, 145.535187>
  translate  <-0.00458, 5.38179, 6.7182>
}
#declare _Leaf1B2_1B1_2B1_1B2_Ref = object {
  _Leaf1B2_1B1_2B1_1B2
  scale 0.7
  rotate <0.0, 89.256409, 183.22435>
  translate  <-0.15974, 5.50211, 6.76361>
}
#declare _Leaf1B2_1B1_2B1_1B3_Ref = object {
  _Leaf1B2_1B1_2B1_1B3
  scale 0.7
  rotate <0.0, 113.424377, 65.97683>
  translate  <-0.20383, 5.60125, 6.78039>
}
#declare _Leaf1B2_1B1_2B1_1B4_Ref = object {
  _Leaf1B2_1B1_2B1_1B4
  scale 0.7
  rotate <0.0, 146.000854, 330.827667>
  translate  <-0.21159, 5.59615, 6.76045>
}
#declare _Leaf1B2_1B1_2B1_1B5_Ref = object {
  _Leaf1B2_1B1_2B1_1B5
  scale 0.7
  rotate <0.0, 36.524811, 238.015198>
  translate  <-0.29942, 5.64035, 6.80685>
}
#declare _Leaf1B2_1B1_2B1_1B6_Ref = object {
  _Leaf1B2_1B1_2B1_1B6
  scale 0.7
  rotate <0.0, 32.264851, 97.133774>
  translate  <-0.51015, 5.85186, 6.84171>
}
#declare _Leaf1B2_1B1_2B1_1B7_Ref = object {
  _Leaf1B2_1B1_2B1_1B7
  scale 0.7
  rotate <0.0, 89.59726, 217.494171>
  translate  <-0.60064, 5.90243, 6.83714>
}
#declare _Leaf1B2_1B1_2B1_1B8_Ref = object {
  _Leaf1B2_1B1_2B1_1B8
  scale 0.7
  rotate <0.0, 124.74482, 217.484695>
  translate  <-0.74662, 6.03812, 6.85558>
}
#declare _Leaf1B2_1B1_2B1_1B9_Ref = object {
  _Leaf1B2_1B1_2B1_1B9
  scale 0.7
  rotate <0.0, 39.571178, 40.031609>
  translate  <-0.73887, 6.04322, 6.87546>
}
#declare _Leaf1B2_1B1_2B1_1B10_Ref = object {
  _Leaf1B2_1B1_2B1_1B10
  scale 0.7
  rotate <0.0, 66.65271, 112.366837>
  translate  <-0.882, 6.18228, 6.89302>
}
#declare _Leaf1B2_1B1_2B1_1B11_Ref = object {
  _Leaf1B2_1B1_2B1_1B11
  scale 0.7
  rotate <0.0, 110.887451, 102.530731>
  translate  <-0.88222, 6.18386, 6.88315>
}
#declare _Leaf1B2_1B1_2B1_1B12_Ref = object {
  _Leaf1B2_1B1_2B1_1B12
  scale 0.7
  rotate <0.0, 162.034988, 119.210854>
  translate  <-0.88812, 6.17826, 6.87732>
}
#declare _Leaf1B2_1B1_2B2_1B1_Ref = object {
  _Leaf1B2_1B1_2B2_1B1
  scale 0.7
  rotate <0.0, 134.688049, 48.586811>
  translate  <0.26471, 5.80278, 6.56099>
}
#declare _Leaf1B2_1B1_2B2_1B2_Ref = object {
  _Leaf1B2_1B1_2B2_1B2
  scale 0.7
  rotate <0.0, 175.701065, 109.12674>
  translate  <0.24281, 5.9477, 6.42267>
}
#declare _Leaf1B2_1B1_2B2_1B3_Ref = object {
  _Leaf1B2_1B1_2B2_1B3
  scale 0.7
  rotate <0.0, 62.465401, 51.670269>
  translate  <0.24512, 6.0529, 6.39132>
}
#declare _Leaf1B2_1B1_2B2_1B4_Ref = object {
  _Leaf1B2_1B1_2B2_1B4
  scale 0.7
  rotate <0.0, 64.455421, 327.710327>
  translate  <0.26372, 6.04513, 6.38251>
}
#declare _Leaf1B2_1B1_2B2_1B5_Ref = object {
  _Leaf1B2_1B1_2B2_1B5
  scale 0.7
  rotate <0.0, 110.74231, 198.812592>
  translate  <0.22646, 6.10777, 6.30184>
}
#declare _Leaf1B2_1B1_2B2_1B6_Ref = object {
  _Leaf1B2_1B1_2B2_1B6
  scale 0.7
  rotate <0.0, 88.910217, 136.867188>
  translate  <0.23218, 6.34642, 6.11916>
}
#declare _Leaf1B2_1B1_2B2_1B7_Ref = object {
  _Leaf1B2_1B1_2B2_1B7
  scale 0.7
  rotate <0.0, 149.401993, 255.966248>
  translate  <0.24616, 6.406, 6.03535>
}
#declare _Leaf1B2_1B1_2B2_1B8_Ref = object {
  _Leaf1B2_1B1_2B2_1B8
  scale 0.7
  rotate <0.0, 136.178726, 312.055145>
  translate  <0.25368, 6.55969, 5.90736>
}
#declare _Leaf1B2_1B1_2B2_1B9_Ref = object {
  _Leaf1B2_1B1_2B2_1B9
  scale 0.7
  rotate <0.0, 56.460419, 144.480194>
  translate  <0.23513, 6.56744, 5.91614>
}
#declare _Leaf1B2_1B1_2B2_1B10_Ref = object {
  _Leaf1B2_1B1_2B2_1B10
  scale 0.7
  rotate <0.0, 103.55117, 103.575417>
  translate  <0.24414, 6.7239, 5.79135>
}
#declare _Leaf1B2_1B1_2B2_1B11_Ref = object {
  _Leaf1B2_1B1_2B2_1B11
  scale 0.7
  rotate <0.0, 95.717682, 58.285751>
  translate  <0.25414, 6.7236, 5.79109>
}
#declare _Leaf1B2_1B1_2B2_1B12_Ref = object {
  _Leaf1B2_1B1_2B2_1B12
  scale 0.7
  rotate <0.0, 98.057793, 5.89391>
  translate  <0.25879, 6.71778, 5.78442>
}
#declare _Leaf1B2_1B1_2B3_1B1_Ref = object {
  _Leaf1B2_1B1_2B3_1B1
  scale 0.7
  rotate <0.0, 33.006969, 144.077606>
  translate  <0.25029, 6.32137, 7.12648>
}
#declare _Leaf1B2_1B1_2B3_1B2_Ref = object {
  _Leaf1B2_1B1_2B3_1B2
  scale 0.7
  rotate <0.0, 14.09899, 274.398376>
  translate  <0.28033, 6.41461, 7.3026>
}
#declare _Leaf1B2_1B1_2B3_1B3_Ref = object {
  _Leaf1B2_1B1_2B3_1B3
  scale 0.7
  rotate <0.0, 102.628418, 120.651451>
  translate  <0.2847, 6.50486, 7.36497>
}
#declare _Leaf1B2_1B1_2B3_1B4_Ref = object {
  _Leaf1B2_1B1_2B3_1B4
  scale 0.7
  rotate <0.0, 123.439629, 199.100449>
  translate  <0.26553, 6.496, 7.37114>
}
#declare _Leaf1B2_1B1_2B3_1B5_Ref = object {
  _Leaf1B2_1B1_2B3_1B5
  scale 0.7
  rotate <0.0, 76.45874, 332.123444>
  translate  <0.30603, 6.52799, 7.46684>
}
#declare _Leaf1B2_1B1_2B3_1B6_Ref = object {
  _Leaf1B2_1B1_2B3_1B6
  scale 0.7
  rotate <0.0, 79.302147, 38.05835>
  translate  <0.31428, 6.69826, 7.71443>
}
#declare _Leaf1B2_1B1_2B3_1B7_Ref = object {
  _Leaf1B2_1B1_2B3_1B7
  scale 0.7
  rotate <0.0, 48.359161, 276.235413>
  translate  <0.30341, 6.72979, 7.81269>
}
#declare _Leaf1B2_1B1_2B3_1B8_Ref = object {
  _Leaf1B2_1B1_2B3_1B8
  scale 0.7
  rotate <0.0, 57.861462, 233.420883>
  translate  <0.30479, 6.83649, 7.98202>
}
#declare _Leaf1B2_1B1_2B3_1B9_Ref = object {
  _Leaf1B2_1B1_2B3_1B9
  scale 0.7
  rotate <0.0, 112.505928, 39.29612>
  translate  <0.32391, 6.84533, 7.97587>
}
#declare _Leaf1B2_1B1_2B3_1B10_Ref = object {
  _Leaf1B2_1B1_2B3_1B10
  scale 0.7
  rotate <0.0, 59.157059, 70.392067>
  translate  <0.32401, 6.95576, 8.14302>
}
#declare _Leaf1B2_1B1_2B3_1B11_Ref = object {
  _Leaf1B2_1B1_2B3_1B11
  scale 0.7
  rotate <0.0, 68.772614, 120.034782>
  translate  <0.31402, 6.95606, 8.14329>
}
#declare _Leaf1B2_1B1_2B3_1B12_Ref = object {
  _Leaf1B2_1B1_2B3_1B12
  scale 0.7
  rotate <0.0, 79.91275, 173.076584>
  translate  <0.30892, 6.94878, 8.14788>
}
#declare _Leaf1B2_1B1_2B4_1B1_Ref = object {
  _Leaf1B2_1B1_2B4_1B1
  scale 0.7
  rotate <0.0, 59.07637, 22.55051>
  translate  <0.51283, 6.54495, 6.93794>
}
#declare _Leaf1B2_1B1_2B4_1B2_Ref = object {
  _Leaf1B2_1B1_2B4_1B2
  scale 0.7
  rotate <0.0, 92.308952, 353.343811>
  translate  <0.67614, 6.66279, 6.93033>
}
#declare _Leaf1B2_1B1_2B4_1B3_Ref = object {
  _Leaf1B2_1B1_2B4_1B3
  scale 0.7
  rotate <0.0, 50.118992, 114.735741>
  translate  <0.7269, 6.7591, 6.94458>
}
#declare _Leaf1B2_1B1_2B4_1B4_Ref = object {
  _Leaf1B2_1B1_2B4_1B4
  scale 0.7
  rotate <0.0, 44.830059, 223.184906>
  translate  <0.7341, 6.74757, 6.96188>
}
#declare _Leaf1B2_1B1_2B4_1B5_Ref = object {
  _Leaf1B2_1B1_2B4_1B5
  scale 0.7
  rotate <0.0, 157.461029, 319.029633>
  translate  <0.82516, 6.79801, 6.93049>
}
#declare _Leaf1B2_1B1_2B4_1B6_Ref = object {
  _Leaf1B2_1B1_2B4_1B6
  scale 0.7
  rotate <0.0, 129.861984, 81.734093>
  translate  <1.04986, 6.99541, 6.96054>
}
#declare _Leaf1B2_1B1_2B4_1B7_Ref = object {
  _Leaf1B2_1B1_2B4_1B7
  scale 0.7
  rotate <0.0, 101.731743, 320.099457>
  translate  <1.14347, 7.03594, 6.97957>
}
#declare _Leaf1B2_1B1_2B4_1B8_Ref = object {
  _Leaf1B2_1B1_2B4_1B8
  scale 0.7
  rotate <0.0, 67.642303, 311.36911>
  translate  <1.29834, 7.16064, 7.00247>
}
#declare _Leaf1B2_1B1_2B4_1B9_Ref = object {
  _Leaf1B2_1B1_2B4_1B9
  scale 0.7
  rotate <0.0, 126.948723, 124.375908>
  translate  <1.29117, 7.17214, 6.98521>
}
#declare _Leaf1B2_1B1_2B4_1B10_Ref = object {
  _Leaf1B2_1B1_2B4_1B10
  scale 0.7
  rotate <0.0, 96.77269, 65.657829>
  translate  <1.44342, 7.29996, 7.01002>
}
#declare _Leaf1B2_1B1_2B4_1B11_Ref = object {
  _Leaf1B2_1B1_2B4_1B11
  scale 0.7
  rotate <0.0, 51.758549, 70.7295>
  translate  <1.44363, 7.29839, 7.01989>
}
#declare _Leaf1B2_1B1_2B4_1B12_Ref = object {
  _Leaf1B2_1B1_2B4_1B12
  scale 0.7
  rotate <0.0, 9.52247, 342.821869>
  translate  <1.44908, 7.29088, 7.02364>
}
#declare _Leaf1B2_1B1_2B5_1B1_Ref = object {
  _Leaf1B2_1B1_2B5_1B1
  scale 0.7
  rotate <0.0, 92.158813, 60.105042>
  translate  <0.31065, 6.96872, 6.97399>
}
#declare _Leaf1B2_1B1_2B5_1B2_Ref = object {
  _Leaf1B2_1B1_2B5_1B2
  scale 0.7
  rotate <0.0, 125.967941, 89.397942>
  translate  <0.29468, 7.16843, 6.99572>
}
#declare _Leaf1B2_1B1_2B5_1B3_Ref = object {
  _Leaf1B2_1B1_2B5_1B3
  scale 0.7
  rotate <0.0, 33.14925, 8.04208>
  translate  <0.29903, 7.26, 7.05615>
}
#declare _Leaf1B2_1B1_2B5_1B4_Ref = object {
  _Leaf1B2_1B1_2B5_1B4
  scale 0.7
  rotate <0.0, 94.679298, 318.249695>
  translate  <0.31783, 7.26116, 7.04478>
}
#declare _Leaf1B2_1B1_2B5_1B5_Ref = object {
  _Leaf1B2_1B1_2B5_1B5
  scale 0.7
  rotate <0.0, 118.0662, 173.190796>
  translate  <0.28382, 7.36434, 7.04037>
}
#declare _Leaf1B2_1B1_2B5_1B6_Ref = object {
  _Leaf1B2_1B1_2B5_1B6
  scale 0.7
  rotate <0.0, 58.27137, 148.232971>
  translate  <0.29781, 7.65741, 7.10571>
}
#declare _Leaf1B2_1B1_2B5_1B7_Ref = object {
  _Leaf1B2_1B1_2B5_1B7
  scale 0.7
  rotate <0.0, 158.951843, 106.212189>
  translate  <0.31509, 7.75942, 7.09763>
}
#declare _Leaf1B2_1B1_2B5_1B8_Ref = object {
  _Leaf1B2_1B1_2B5_1B8
  scale 0.7
  rotate <0.0, 148.366943, 23.242661>
  translate  <0.32826, 7.95596, 7.1331>
}
#declare _Leaf1B2_1B1_2B5_1B9_Ref = object {
  _Leaf1B2_1B1_2B5_1B9
  scale 0.7
  rotate <0.0, 44.190811, 187.43428>
  translate  <0.30951, 7.9548, 7.14444>
}
#declare _Leaf1B2_1B1_2B5_1B10_Ref = object {
  _Leaf1B2_1B1_2B5_1B10
  scale 0.7
  rotate <0.0, 55.258389, 104.89241>
  translate  <0.32411, 8.15062, 7.18412>
}
#declare _Leaf1B2_1B1_2B5_1B11_Ref = object {
  _Leaf1B2_1B1_2B5_1B11
  scale 0.7
  rotate <0.0, 53.76754, 48.517551>
  translate  <0.3341, 8.15032, 7.18385>
}
#declare _Leaf1B2_1B1_2B5_1B12_Ref = object {
  _Leaf1B2_1B1_2B5_1B12
  scale 0.7
  rotate <0.0, 89.949699, 8.16105>
  translate  <0.33891, 8.15153, 7.17517>
}
#declare _Leaf1B2_1B1_1B1_1B1_Ref = object {
  _Leaf1B2_1B1_1B1_1B1
  scale 0.7
  rotate <0.0, 129.963959, 51.799889>
  translate  <0.19158, 3.78747, 6.0819>
}
#declare _Leaf1B2_1B1_1B1_1B2_Ref = object {
  _Leaf1B2_1B1_1B1_1B2
  scale 0.7
  rotate <0.0, 169.867523, 96.892487>
  translate  <0.17052, 3.94611, 5.95941>
}
#declare _Leaf1B2_1B1_1B1_1B3_Ref = object {
  _Leaf1B2_1B1_1B1_1B3
  scale 0.7
  rotate <0.0, 57.720718, 49.395439>
  translate  <0.17321, 4.054, 5.93923>
}
#declare _Leaf1B2_1B1_1B1_1B4_Ref = object {
  _Leaf1B2_1B1_1B1_1B4
  scale 0.7
  rotate <0.0, 67.617828, 325.281647>
  translate  <0.19181, 4.04713, 5.92971>
}
#declare _Leaf1B2_1B1_1B1_1B5_Ref = object {
  _Leaf1B2_1B1_1B1_1B5
  scale 0.7
  rotate <0.0, 112.728371, 196.393326>
  translate  <0.15498, 4.11797, 5.85591>
}
#declare _Leaf1B2_1B1_1B1_1B6_Ref = object {
  _Leaf1B2_1B1_1B1_1B6
  scale 0.7
  rotate <0.0, 84.943443, 136.948471>
  translate  <0.16192, 4.37437, 5.69917>
}
#declare _Leaf1B2_1B1_1B1_1B7_Ref = object {
  _Leaf1B2_1B1_1B1_1B7
  scale 0.7
  rotate <0.0, 155.229614, 253.083633>
  translate  <0.17634, 4.44234, 5.62209>
}
#declare _Leaf1B2_1B1_1B1_1B8_Ref = object {
  _Leaf1B2_1B1_1B1_1B8
  scale 0.7
  rotate <0.0, 140.342255, 316.745544>
  translate  <0.18468, 4.60853, 5.51087>
}
#declare _Leaf1B2_1B1_1B1_1B9_Ref = object {
  _Leaf1B2_1B1_1B1_1B9
  scale 0.7
  rotate <0.0, 53.269871, 147.899185>
  translate  <0.16612, 4.61537, 5.52036>
}
#declare _Leaf1B2_1B1_1B1_1B10_Ref = object {
  _Leaf1B2_1B1_1B1_1B10
  scale 0.7
  rotate <0.0, 97.75901, 103.121353>
  translate  <0.17596, 4.78399, 5.41262>
}
#declare _Leaf1B2_1B1_1B1_1B11_Ref = object {
  _Leaf1B2_1B1_1B1_1B11
  scale 0.7
  rotate <0.0, 90.522133, 58.288799>
  translate  <0.18595, 4.78369, 5.41235>
}
#declare _Leaf1B2_1B1_1B1_1B12_Ref = object {
  _Leaf1B2_1B1_1B1_1B12
  scale 0.7
  rotate <0.0, 97.229881, 6.53135>
  translate  <0.19061, 4.77858, 5.40513>
}
#declare _Leaf1B2_1B1_1B2_1B1_Ref = object {
  _Leaf1B2_1B1_1B2_1B1
  scale 0.7
  rotate <0.0, 29.945669, 23.37038>
  translate  <0.38864, 4.16704, 6.57055>
}
#declare _Leaf1B2_1B1_1B2_1B2_Ref = object {
  _Leaf1B2_1B1_1B2_1B2
  scale 0.7
  rotate <0.0, 64.197212, 344.584839>
  translate  <0.54363, 4.26332, 6.65614>
}
#declare _Leaf1B2_1B1_1B2_1B3_Ref = object {
  _Leaf1B2_1B1_1B2_1B3
  scale 0.7
  rotate <0.0, 61.632061, 127.509537>
  translate  <0.58867, 4.35148, 6.7036>
}
#declare _Leaf1B2_1B1_1B2_1B4_Ref = object {
  _Leaf1B2_1B1_1B2_1B4
  scale 0.7
  rotate <0.0, 71.780418, 208.216156>
  translate  <0.58533, 4.33825, 6.72085>
}
#declare _Leaf1B2_1B1_1B2_1B5_Ref = object {
  _Leaf1B2_1B1_1B2_1B5
  scale 0.7
  rotate <0.0, 133.408905, 340.885529>
  translate  <0.6839, 4.37821, 6.74339>
}
#declare _Leaf1B2_1B1_1B2_1B6_Ref = object {
  _Leaf1B2_1B1_1B2_1B6
  scale 0.7
  rotate <0.0, 114.825768, 58.227188>
  translate  <0.88009, 4.54348, 6.90009>
}
#declare _Leaf1B2_1B1_1B2_1B7_Ref = object {
  _Leaf1B2_1B1_1B2_1B7
  scale 0.7
  rotate <0.0, 83.042747, 314.550537>
  translate  <0.95504, 4.57069, 6.9665>
}
#declare _Leaf1B2_1B1_1B2_1B8_Ref = object {
  _Leaf1B2_1B1_1B2_1B8
  scale 0.7
  rotate <0.0, 56.49371, 289.660156>
  translate  <1.08821, 4.67324, 7.07517>
}
#declare _Leaf1B2_1B1_1B2_1B9_Ref = object {
  _Leaf1B2_1B1_1B2_1B9
  scale 0.7
  rotate <0.0, 132.012543, 92.761978>
  translate  <1.09154, 4.68644, 7.05797>
}
#declare _Leaf1B2_1B1_1B2_1B10_Ref = object {
  _Leaf1B2_1B1_1B2_1B10
  scale 0.7
  rotate <0.0, 78.772423, 60.062531>
  translate  <1.22176, 4.79232, 7.16735>
}
#declare _Leaf1B2_1B1_1B2_1B11_Ref = object {
  _Leaf1B2_1B1_1B2_1B11
  scale 0.7
  rotate <0.0, 42.01783, 91.65889>
  translate  <1.21692, 4.79022, 7.17585>
}
#declare _Leaf1B2_1B1_1B2_1B12_Ref = object {
  _Leaf1B2_1B1_1B2_1B12
  scale 0.7
  rotate <0.0, 22.080111, 198.585648>
  translate  <1.21913, 4.7819, 7.18094>
}
#declare _Leaf1B2_1B1_1B3_1B1_Ref = object {
  _Leaf1B2_1B1_1B3_1B1
  scale 0.7
  rotate <0.0, 83.600014, 153.043015>
  translate  <-0.01709, 4.38255, 6.59573>
}
#declare _Leaf1B2_1B1_1B3_1B2_Ref = object {
  _Leaf1B2_1B1_1B3_1B2
  scale 0.7
  rotate <0.0, 61.222832, 192.366501>
  translate  <-0.13805, 4.47697, 6.72637>
}
#declare _Leaf1B2_1B1_1B3_1B3_Ref = object {
  _Leaf1B2_1B1_1B3_1B3
  scale 0.7
  rotate <0.0, 113.88829, 85.667633>
  translate  <-0.17515, 4.5676, 6.77603>
}
#declare _Leaf1B2_1B1_1B3_1B4_Ref = object {
  _Leaf1B2_1B1_1B3_1B4
  scale 0.7
  rotate <0.0, 172.152634, 285.227112>
  translate  <-0.19132, 4.5633, 6.76175>
}
#declare _Leaf1B2_1B1_1B3_1B5_Ref = object {
  _Leaf1B2_1B1_1B3_1B5
  scale 0.7
  rotate <0.0, 39.110001, 284.438019>
  translate  <-0.2479, 4.59131, 6.85026>
}
#declare _Leaf1B2_1B1_1B3_1B6_Ref = object {
  _Leaf1B2_1B1_1B3_1B6
  scale 0.7
  rotate <0.0, 32.942959, 53.930199>
  translate  <-0.42878, 4.76942, 7.01125>
}
#declare _Leaf1B2_1B1_1B3_1B7_Ref = object {
  _Leaf1B2_1B1_1B3_1B7
  scale 0.7
  rotate <0.0, 72.537811, 227.718506>
  translate  <-0.51319, 4.80788, 7.05778>
}
#declare _Leaf1B2_1B1_1B3_1B8_Ref = object {
  _Leaf1B2_1B1_1B3_1B8
  scale 0.7
  rotate <0.0, 104.605911, 213.133743>
  translate  <-0.64052, 4.92107, 7.16282>
}
#declare _Leaf1B2_1B1_1B3_1B9_Ref = object {
  _Leaf1B2_1B1_1B3_1B9
  scale 0.7
  rotate <0.0, 60.5177, 27.388229>
  translate  <-0.62439, 4.92536, 7.17707>
}
#declare _Leaf1B2_1B1_1B3_1B10_Ref = object {
  _Leaf1B2_1B1_1B3_1B10
  scale 0.7
  rotate <0.0, 50.904652, 102.586029>
  translate  <-0.74993, 5.04233, 7.28047>
}
#declare _Leaf1B2_1B1_1B3_1B11_Ref = object {
  _Leaf1B2_1B1_1B3_1B11
  scale 0.7
  rotate <0.0, 94.76178, 114.688873>
  translate  <-0.75508, 5.04473, 7.27224>
}
#declare _Leaf1B2_1B1_1B3_1B12_Ref = object {
  _Leaf1B2_1B1_1B3_1B12
  scale 0.7
  rotate <0.0, 135.567459, 151.859955>
  translate  <-0.76266, 5.03895, 7.26922>
}
#declare _Leaf1B2_1B2_2B1_1B1_Ref = object {
  _Leaf1B2_1B2_2B1_1B1
  scale 0.7
  rotate <0.0, 36.552952, 254.128296>
  translate  <-1.05669, 3.76845, 8.49964>
}
#declare _Leaf1B2_1B2_2B1_1B2_Ref = object {
  _Leaf1B2_1B2_2B1_1B2
  scale 0.7
  rotate <0.0, 54.475479, 311.588928>
  translate  <-1.01778, 3.74621, 8.69612>
}
#declare _Leaf1B2_1B2_2B1_1B3_Ref = object {
  _Leaf1B2_1B2_2B1_1B3
  scale 0.7
  rotate <0.0, 70.653069, 168.034485>
  translate  <-1.04113, 3.76311, 8.80206>
}
#declare _Leaf1B2_1B2_2B1_1B4_Ref = object {
  _Leaf1B2_1B2_2B1_1B4
  scale 0.7
  rotate <0.0, 131.649643, 212.437912>
  translate  <-1.04736, 3.74219, 8.79932>
}
#declare _Leaf1B2_1B2_2B1_1B5_Ref = object {
  _Leaf1B2_1B2_2B1_1B5
  scale 0.7
  rotate <0.0, 92.234756, 14.03374>
  translate  <-0.99823, 3.73731, 8.89619>
}
#declare _Leaf1B2_1B2_2B1_1B6_Ref = object {
  _Leaf1B2_1B2_2B1_1B6
  scale 0.7
  rotate <0.0, 53.092258, 69.195976>
  translate  <-0.99024, 3.7025, 9.19466>
}
#declare _Leaf1B2_1B2_2B1_1B7_Ref = object {
  _Leaf1B2_1B2_2B1_1B7
  scale 0.7
  rotate <0.0, 88.150047, 318.4375>
  translate  <-0.97667, 3.66056, 9.2886>
}
#declare _Leaf1B2_1B2_2B1_1B8_Ref = object {
  _Leaf1B2_1B2_2B1_1B8
  scale 0.7
  rotate <0.0, 94.579788, 283.854645>
  translate  <-0.96871, 3.62885, 9.48606>
}
#declare _Leaf1B2_1B2_2B1_1B9_Ref = object {
  _Leaf1B2_1B2_2B1_1B9
  scale 0.7
  rotate <0.0, 81.338669, 88.491508>
  translate  <-0.9625, 3.64972, 9.4888>
}
#declare _Leaf1B2_1B2_2B1_1B10_Ref = object {
  _Leaf1B2_1B2_2B1_1B10
  scale 0.7
  rotate <0.0, 20.53347, 98.053337>
  translate  <-0.95845, 3.62013, 9.68689>
}
#declare _Leaf1B2_1B2_2B1_1B11_Ref = object {
  _Leaf1B2_1B2_2B1_1B11
  scale 0.7
  rotate <0.0, 41.080509, 188.555038>
  translate  <-0.96568, 3.61325, 9.6864>
}
#declare _Leaf1B2_1B2_2B1_1B12_Ref = object {
  _Leaf1B2_1B2_2B1_1B12
  scale 0.7
  rotate <0.0, 82.967178, 225.254791>
  translate  <-0.96336, 3.60366, 9.68473>
}
#declare _Leaf1B2_1B2_2B2_1B1_Ref = object {
  _Leaf1B2_1B2_2B2_1B1
  scale 0.7
  rotate <0.0, 90.99498, 183.809464>
  translate  <-1.53349, 3.94704, 8.62308>
}
#declare _Leaf1B2_1B2_2B2_1B2_Ref = object {
  _Leaf1B2_1B2_2B2_1B2
  scale 0.7
  rotate <0.0, 96.623154, 226.884537>
  translate  <-1.69521, 3.87772, 8.72133>
}
#declare _Leaf1B2_1B2_2B2_1B3_Ref = object {
  _Leaf1B2_1B2_2B2_1B3
  scale 0.7
  rotate <0.0, 74.204941, 112.551743>
  translate  <-1.77664, 3.88908, 8.7941>
}
#declare _Leaf1B2_1B2_2B2_1B4_Ref = object {
  _Leaf1B2_1B2_2B2_1B4
  scale 0.7
  rotate <0.0, 139.598465, 74.45562>
  translate  <-1.78729, 3.89136, 8.77498>
}
#declare _Leaf1B2_1B2_2B2_1B5_Ref = object {
  _Leaf1B2_1B2_2B2_1B5
  scale 0.7
  rotate <0.0, 75.15799, 293.369873>
  translate  <-1.85691, 3.82933, 8.83089>
}
#declare _Leaf1B2_1B2_2B2_1B6_Ref = object {
  _Leaf1B2_1B2_2B2_1B6
  scale 0.7
  rotate <0.0, 12.17088, 267.017395>
  translate  <-2.11471, 3.77343, 8.97502>
}
#declare _Leaf1B2_1B2_2B2_1B7_Ref = object {
  _Leaf1B2_1B2_2B2_1B7
  scale 0.7
  rotate <0.0, 117.254929, 255.716995>
  translate  <-2.21029, 3.73897, 8.99611>
}
#declare _Leaf1B2_1B2_2B2_1B8_Ref = object {
  _Leaf1B2_1B2_2B2_1B8
  scale 0.7
  rotate <0.0, 144.405304, 225.09874>
  translate  <-2.38499, 3.69768, 9.08463>
}
#declare _Leaf1B2_1B2_2B2_1B9_Ref = object {
  _Leaf1B2_1B2_2B2_1B9
  scale 0.7
  rotate <0.0, 26.7784, 19.40206>
  translate  <-2.37438, 3.69541, 9.1037>
}
#declare _Leaf1B2_1B2_2B2_1B10_Ref = object {
  _Leaf1B2_1B2_2B2_1B10
  scale 0.7
  rotate <0.0, 35.180901, 181.288605>
  translate  <-2.54931, 3.65824, 9.19398>
}
#declare _Leaf1B2_1B2_2B2_1B11_Ref = object {
  _Leaf1B2_1B2_2B2_1B11
  scale 0.7
  rotate <0.0, 72.561508, 147.896057>
  translate  <-2.55431, 3.66396, 9.18749>
}
#declare _Leaf1B2_1B2_2B2_1B12_Ref = object {
  _Leaf1B2_1B2_2B2_1B12
  scale 0.7
  rotate <0.0, 124.171204, 140.931854>
  translate  <-2.55769, 3.66004, 9.17893>
}
#declare _Leaf1B2_1B2_2B3_1B1_Ref = object {
  _Leaf1B2_1B2_2B3_1B1
  scale 0.7
  rotate <0.0, 47.718102, 37.55175>
  translate  <-1.45198, 4.51647, 9.13105>
}
#declare _Leaf1B2_1B2_2B3_1B2_Ref = object {
  _Leaf1B2_1B2_2B3_1B2
  scale 0.7
  rotate <0.0, 90.968338, 40.36261>
  translate  <-1.40507, 4.69317, 9.21584>
}
#declare _Leaf1B2_1B2_2B3_1B3_Ref = object {
  _Leaf1B2_1B2_2B3_1B3
  scale 0.7
  rotate <0.0, 24.822861, 207.915634>
  translate  <-1.41785, 4.76993, 9.2933>
}
#declare _Leaf1B2_1B2_2B3_1B4_Ref = object {
  _Leaf1B2_1B2_2B3_1B4
  scale 0.7
  rotate <0.0, 79.559067, 281.156433>
  translate  <-1.39919, 4.76015, 9.29963>
}
#declare _Leaf1B2_1B2_2B3_1B5_Ref = object {
  _Leaf1B2_1B2_2B3_1B5
  scale 0.7
  rotate <0.0, 146.856186, 91.98349>
  translate  <-1.37519, 4.86485, 9.31646>
}
#declare _Leaf1B2_1B2_2B3_1B6_Ref = object {
  _Leaf1B2_1B2_2B3_1B6
  scale 0.7
  rotate <0.0, 89.231987, 127.634018>
  translate  <-1.31451, 5.10511, 9.48661>
}
#declare _Leaf1B2_1B2_2B3_1B7_Ref = object {
  _Leaf1B2_1B2_2B3_1B7
  scale 0.7
  rotate <0.0, 119.508583, 20.438101>
  translate  <-1.26284, 5.18065, 9.53553>
}
#declare _Leaf1B2_1B2_2B3_1B8_Ref = object {
  _Leaf1B2_1B2_2B3_1B8
  scale 0.7
  rotate <0.0, 96.003479, 352.715393>
  translate  <-1.21367, 5.33934, 9.64714>
}
#declare _Leaf1B2_1B2_2B3_1B9_Ref = object {
  _Leaf1B2_1B2_2B3_1B9
  scale 0.7
  rotate <0.0, 94.065147, 160.530396>
  translate  <-1.23228, 5.3491, 9.64082>
}
#declare _Leaf1B2_1B2_2B3_1B10_Ref = object {
  _Leaf1B2_1B2_2B3_1B10
  scale 0.7
  rotate <0.0, 57.956219, 108.532722>
  translate  <-1.18601, 5.50659, 9.75566>
}
#declare _Leaf1B2_1B2_2B3_1B11_Ref = object {
  _Leaf1B2_1B2_2B3_1B11
  scale 0.7
  rotate <0.0, 13.81033, 87.335571>
  translate  <-1.181, 5.50087, 9.76216>
}
#declare _Leaf1B2_1B2_2B3_1B12_Ref = object {
  _Leaf1B2_1B2_2B3_1B12
  scale 0.7
  rotate <0.0, 43.027771, 321.787384>
  translate  <-1.17132, 5.49889, 9.76065>
}
#declare _Leaf1B2_1B2_2B4_1B1_Ref = object {
  _Leaf1B2_1B2_2B4_1B1
  scale 0.7
  rotate <0.0, 98.504837, 104.535019>
  translate  <-1.83361, 4.60604, 9.10277>
}
#declare _Leaf1B2_1B2_2B4_1B2_Ref = object {
  _Leaf1B2_1B2_2B4_1B2
  scale 0.7
  rotate <0.0, 135.503204, 130.727127>
  translate  <-1.98733, 4.73567, 9.08933>
}
#declare _Leaf1B2_1B2_2B4_1B3_Ref = object {
  _Leaf1B2_1B2_2B4_1B3
  scale 0.7
  rotate <0.0, 31.94895, 69.764236>
  translate  <-2.0582, 4.80689, 9.13361>
}
#declare _Leaf1B2_1B2_2B4_1B4_Ref = object {
  _Leaf1B2_1B2_2B4_1B4
  scale 0.7
  rotate <0.0, 85.16568, 3.47369>
  translate  <-2.04396, 4.82031, 9.12356>
}
#declare _Leaf1B2_1B2_2B4_1B5_Ref = object {
  _Leaf1B2_1B2_2B4_1B5
  scale 0.7
  rotate <0.0, 122.830269, 223.954742>
  translate  <-2.1387, 4.86786, 9.09943>
}
#declare _Leaf1B2_1B2_2B4_1B6_Ref = object {
  _Leaf1B2_1B2_2B4_1B6
  scale 0.7
  rotate <0.0, 67.020683, 190.397614>
  translate  <-2.34381, 5.08704, 9.11524>
}
#declare _Leaf1B2_1B2_2B4_1B7_Ref = object {
  _Leaf1B2_1B2_2B4_1B7
  scale 0.7
  rotate <0.0, 169.353714, 145.17952>
  translate  <-2.4013, 5.17005, 9.09132>
}
#declare _Leaf1B2_1B2_2B4_1B8_Ref = object {
  _Leaf1B2_1B2_2B4_1B8
  scale 0.7
  rotate <0.0, 146.918625, 51.881721>
  translate  <-2.53479, 5.31916, 9.09398>
}
#declare _Leaf1B2_1B2_2B4_1B9_Ref = object {
  _Leaf1B2_1B2_2B4_1B9
  scale 0.7
  rotate <0.0, 47.834728, 223.064758>
  translate  <-2.54899, 5.30578, 9.104>
}
#declare _Leaf1B2_1B2_2B4_1B10_Ref = object {
  _Leaf1B2_1B2_2B4_1B10
  scale 0.7
  rotate <0.0, 65.70488, 150.887833>
  translate  <-2.6817, 5.45569, 9.11102>
}
#declare _Leaf1B2_1B2_2B4_1B11_Ref = object {
  _Leaf1B2_1B2_2B4_1B11
  scale 0.7
  rotate <0.0, 58.869709, 99.905319>
  translate  <-2.67447, 5.46258, 9.11152>
}
#declare _Leaf1B2_1B2_2B4_1B12_Ref = object {
  _Leaf1B2_1B2_2B4_1B12
  scale 0.7
  rotate <0.0, 87.310829, 53.623501>
  translate  <-2.67048, 5.46626, 9.10312>
}
#declare _Leaf1B2_1B2_2B5_1B1_Ref = object {
  _Leaf1B2_1B2_2B5_1B1
  scale 0.7
  rotate <0.0, 70.011719, 144.648743>
  translate  <-1.9498, 4.64384, 9.55756>
}
#declare _Leaf1B2_1B2_2B5_1B2_Ref = object {
  _Leaf1B2_1B2_2B5_1B2
  scale 0.7
  rotate <0.0, 59.900841, 191.498474>
  translate  <-2.04117, 4.71284, 9.7234>
}
#declare _Leaf1B2_1B2_2B5_1B3_Ref = object {
  _Leaf1B2_1B2_2B5_1B3
  scale 0.7
  rotate <0.0, 97.120331, 76.479897>
  translate  <-2.05597, 4.78858, 9.8015>
}
#declare _Leaf1B2_1B2_2B5_1B4_Ref = object {
  _Leaf1B2_1B2_2B5_1B4
  scale 0.7
  rotate <0.0, 169.305893, 105.04081>
  translate  <-2.07346, 4.7919, 9.78858>
}
#declare _Leaf1B2_1B2_2B5_1B5_Ref = object {
  _Leaf1B2_1B2_2B5_1B5
  scale 0.7
  rotate <0.0, 57.458981, 274.90097>
  translate  <-2.11797, 4.80057, 9.8874>
}
#declare _Leaf1B2_1B2_2B5_1B6_Ref = object {
  _Leaf1B2_1B2_2B5_1B6
  scale 0.7
  rotate <0.0, 27.384199, 11.50812>
  translate  <-2.24896, 4.94892, 10.11366>
}
#declare _Leaf1B2_1B2_2B5_1B7_Ref = object {
  _Leaf1B2_1B2_2B5_1B7
  scale 0.7
  rotate <0.0, 81.256073, 220.18335>
  translate  <-2.32088, 4.98538, 10.17897>
}
#declare _Leaf1B2_1B2_2B5_1B8_Ref = object {
  _Leaf1B2_1B2_2B5_1B8
  scale 0.7
  rotate <0.0, 107.463081, 196.480804>
  translate  <-2.41606, 5.08102, 10.3268>
}
#declare _Leaf1B2_1B2_2B5_1B9_Ref = object {
  _Leaf1B2_1B2_2B5_1B9
  scale 0.7
  rotate <0.0, 60.376209, 5.45361>
  translate  <-2.39862, 5.0777, 10.33969>
}
#declare _Leaf1B2_1B2_2B5_1B10_Ref = object {
  _Leaf1B2_1B2_2B5_1B10
  scale 0.7
  rotate <0.0, 32.77533, 87.224838>
  translate  <-2.49136, 5.17706, 10.48686>
}
#declare _Leaf1B2_1B2_2B5_1B11_Ref = object {
  _Leaf1B2_1B2_2B5_1B11
  scale 0.7
  rotate <0.0, 76.33075, 103.40271>
  translate  <-2.49637, 5.18279, 10.48036>
}
#declare _Leaf1B2_1B2_2B5_1B12_Ref = object {
  _Leaf1B2_1B2_2B5_1B12
  scale 0.7
  rotate <0.0, 120.533218, 131.940887>
  translate  <-2.50513, 5.17968, 10.47669>
}
#declare _Leaf1B2_1B2_1B1_1B1_Ref = object {
  _Leaf1B2_1B2_1B1_1B1
  scale 0.7
  rotate <0.0, 87.467621, 179.870743>
  translate  <-0.66377, 2.91887, 7.04737>
}
#declare _Leaf1B2_1B2_1B1_1B2_Ref = object {
  _Leaf1B2_1B2_1B1_1B2
  scale 0.7
  rotate <0.0, 92.072258, 222.962036>
  translate  <-0.82338, 2.86599, 7.15847>
}
#declare _Leaf1B2_1B2_1B1_1B3_Ref = object {
  _Leaf1B2_1B2_1B1_1B3
  scale 0.7
  rotate <0.0, 75.85183, 107.51384>
  translate  <-0.89925, 2.88663, 7.23511>
}
#declare _Leaf1B2_1B2_1B1_1B4_Ref = object {
  _Leaf1B2_1B2_1B1_1B4
  scale 0.7
  rotate <0.0, 143.430771, 73.671371>
  translate  <-0.91087, 2.88867, 7.21654>
}
#declare _Leaf1B2_1B2_1B1_1B5_Ref = object {
  _Leaf1B2_1B2_1B1_1B5
  scale 0.7
  rotate <0.0, 73.659721, 290.672638>
  translate  <-0.98088, 2.83452, 7.27969>
}
#declare _Leaf1B2_1B2_1B1_1B6_Ref = object {
  _Leaf1B2_1B2_1B1_1B6
  scale 0.7
  rotate <0.0, 9.42116, 282.456146>
  translate  <-1.23246, 2.80399, 7.44135>
}
#declare _Leaf1B2_1B2_1B1_1B7_Ref = object {
  _Leaf1B2_1B2_1B1_1B7
  scale 0.7
  rotate <0.0, 113.386787, 250.672852>
  translate  <-1.32864, 2.77736, 7.4698>
}
#declare _Leaf1B2_1B2_1B1_1B8_Ref = object {
  _Leaf1B2_1B2_1B1_1B8
  scale 0.7
  rotate <0.0, 139.847137, 221.008072>
  translate  <-1.4999, 2.75281, 7.57042>
}
#declare _Leaf1B2_1B2_1B1_1B9_Ref = object {
  _Leaf1B2_1B2_1B1_1B9
  scale 0.7
  rotate <0.0, 31.00345, 18.623819>
  translate  <-1.48831, 2.75076, 7.58894>
}
#declare _Leaf1B2_1B2_1B1_1B10_Ref = object {
  _Leaf1B2_1B2_1B1_1B10
  scale 0.7
  rotate <0.0, 31.91065, 172.584824>
  translate  <-1.65943, 2.73043, 7.69111>
}
#declare _Leaf1B2_1B2_1B1_1B11_Ref = object {
  _Leaf1B2_1B2_1B1_1B11
  scale 0.7
  rotate <0.0, 71.454712, 142.558472>
  translate  <-1.66443, 2.73615, 7.68461>
}
#declare _Leaf1B2_1B2_1B1_1B12_Ref = object {
  _Leaf1B2_1B2_1B1_1B12
  scale 0.7
  rotate <0.0, 123.433617, 140.047058>
  translate  <-1.66858, 2.73204, 7.67649>
}
#declare _Leaf1B2_1B2_1B2_1B1_Ref = object {
  _Leaf1B2_1B2_1B2_1B1
  scale 0.7
  rotate <0.0, 88.529457, 77.072098>
  translate  <-0.65926, 3.51547, 7.30378>
}
#declare _Leaf1B2_1B2_1B2_1B2_Ref = object {
  _Leaf1B2_1B2_1B2_1B2
  scale 0.7
  rotate <0.0, 129.918457, 91.067589>
  translate  <-0.73572, 3.70179, 7.29635>
}
#declare _Leaf1B2_1B2_1B2_1B3_Ref = object {
  _Leaf1B2_1B2_1B2_1B3
  scale 0.7
  rotate <0.0, 17.7859, 53.541969>
  translate  <-0.77742, 3.79141, 7.34414>
}
#declare _Leaf1B2_1B2_1B2_1B4_Ref = object {
  _Leaf1B2_1B2_1B2_1B4
  scale 0.7
  rotate <0.0, 76.272072, 334.726715>
  translate  <-0.75696, 3.79792, 7.33935>
}
#declare _Leaf1B2_1B2_1B2_1B5_Ref = object {
  _Leaf1B2_1B2_1B2_1B5
  scale 0.7
  rotate <0.0, 137.333145, 194.221756>
  translate  <-0.81431, 3.88632, 7.31255>
}
#declare _Leaf1B2_1B2_1B2_1B6_Ref = object {
  _Leaf1B2_1B2_1B2_1B6
  scale 0.7
  rotate <0.0, 77.782654, 166.924042>
  translate  <-0.9042, 4.17131, 7.3451>
}
#declare _Leaf1B2_1B2_1B2_1B7_Ref = object {
  _Leaf1B2_1B2_1B2_1B7
  scale 0.7
  rotate <0.0, 161.622513, 65.118599>
  translate  <-0.91384, 4.27372, 7.33143>
}
#declare _Leaf1B2_1B2_1B2_1B8_Ref = object {
  _Leaf1B2_1B2_1B2_1B8
  scale 0.7
  rotate <0.0, 132.038315, 26.2055>
  translate  <-0.96788, 4.46584, 7.34663>
}
#declare _Leaf1B2_1B2_1B2_1B9_Ref = object {
  _Leaf1B2_1B2_1B2_1B9
  scale 0.7
  rotate <0.0, 62.429722, 198.440384>
  translate  <-0.98828, 4.45934, 7.35141>
}
#declare _Leaf1B2_1B2_1B2_1B10_Ref = object {
  _Leaf1B2_1B2_1B2_1B10
  scale 0.7
  rotate <0.0, 67.807617, 130.491074>
  translate  <-1.04227, 4.65126, 7.37111>
}
#declare _Leaf1B2_1B2_1B2_1B11_Ref = object {
  _Leaf1B2_1B2_1B2_1B11
  scale 0.7
  rotate <0.0, 48.82756, 81.2696>
  translate  <-1.0331, 4.65393, 7.3741>
}
#declare _Leaf1B2_1B2_1B2_1B12_Ref = object {
  _Leaf1B2_1B2_1B2_1B12
  scale 0.7
  rotate <0.0, 72.415787, 26.732071>
  translate  <-1.02616, 4.65638, 7.36733>
}
#declare _Leaf1B2_1B2_1B3_1B1_Ref = object {
  _Leaf1B2_1B2_1B3_1B1
  scale 0.7
  rotate <0.0, 23.85371, 310.022858>
  translate  <-0.56224, 3.35749, 7.72487>
}
#declare _Leaf1B2_1B2_1B3_1B2_Ref = object {
  _Leaf1B2_1B2_1B3_1B2
  scale 0.7
  rotate <0.0, 61.364529, 345.462372>
  translate  <-0.47009, 3.41031, 7.89614>
}
#declare _Leaf1B2_1B2_1B3_1B3_Ref = object {
  _Leaf1B2_1B2_1B3_1B3
  scale 0.7
  rotate <0.0, 54.870338, 177.892014>
  translate  <-0.47063, 3.4529, 7.99734>
}
#declare _Leaf1B2_1B2_1B3_1B4_Ref = object {
  _Leaf1B2_1B2_1B3_1B4
  scale 0.7
  rotate <0.0, 107.805107, 231.729324>
  translate  <-0.46941, 3.43133, 8.00149>
}
#declare _Leaf1B2_1B2_1B3_1B5_Ref = object {
  _Leaf1B2_1B2_1B3_1B5
  scale 0.7
  rotate <0.0, 114.765984, 31.39291>
  translate  <-0.39924, 3.4711, 8.07439>
}
#declare _Leaf1B2_1B2_1B3_1B6_Ref = object {
  _Leaf1B2_1B2_1B3_1B6
  scale 0.7
  rotate <0.0, 73.128014, 81.731956>
  translate  <-0.30486, 3.53642, 8.35221>
}
#declare _Leaf1B2_1B2_1B3_1B7_Ref = object {
  _Leaf1B2_1B2_1B3_1B7
  scale 0.7
  rotate <0.0, 94.687202, 337.148102>
  translate  <-0.2541, 3.53189, 8.44261>
}
#declare _Leaf1B2_1B2_1B3_1B8_Ref = object {
  _Leaf1B2_1B2_1B3_1B8
  scale 0.7
  rotate <0.0, 86.817932, 302.86261>
  translate  <-0.18614, 3.56796, 8.62738>
}
#declare _Leaf1B2_1B2_1B3_1B9_Ref = object {
  _Leaf1B2_1B2_1B3_1B9
  scale 0.7
  rotate <0.0, 94.906853, 107.12381>
  translate  <-0.18735, 3.58947, 8.62323>
}
#declare _Leaf1B2_1B2_1B3_1B10_Ref = object {
  _Leaf1B2_1B2_1B3_1B10
  scale 0.7
  rotate <0.0, 37.064919, 83.746712>
  translate  <-0.12352, 3.62661, 8.80946>
}
#declare _Leaf1B2_1B2_1B3_1B11_Ref = object {
  _Leaf1B2_1B2_1B3_1B11
  scale 0.7
  rotate <0.0, 21.201839, 184.337509>
  translate  <-0.12767, 3.61821, 8.81297>
}
#declare _Leaf1B2_1B2_1B3_1B12_Ref = object {
  _Leaf1B2_1B2_1B3_1B12
  scale 0.7
  rotate <0.0, 59.785801, 246.48291>
  translate  <-0.12256, 3.60962, 8.81273>
}
#declare _Leaf1B2_1B3_2B1_1B1_Ref = object {
  _Leaf1B2_1B3_2B1_1B1
  scale 0.7
  rotate <0.0, 104.158768, 14.94268>
  translate  <1.75635, 3.94965, 8.10854>
}
#declare _Leaf1B2_1B3_2B1_1B2_Ref = object {
  _Leaf1B2_1B3_2B1_1B2
  scale 0.7
  rotate <0.0, 137.523148, 48.27486>
  translate  <1.88611, 4.10279, 8.09061>
}
#declare _Leaf1B2_1B3_2B1_1B3_Ref = object {
  _Leaf1B2_1B3_2B1_1B3
  scale 0.7
  rotate <0.0, 39.9519, 337.133698>
  translate  <1.96338, 4.16958, 8.13093>
}
#declare _Leaf1B2_1B3_2B1_1B4_Ref = object {
  _Leaf1B2_1B3_2B1_1B4
  scale 0.7
  rotate <0.0, 89.754379, 273.009369>
  translate  <1.97524, 4.15599, 8.11832>
}
#declare _Leaf1B2_1B3_2B1_1B5_Ref = object {
  _Leaf1B2_1B3_2B1_1B5
  scale 0.7
  rotate <0.0, 114.979912, 134.332474>
  translate  <2.0212, 4.25184, 8.09551>
}
#declare _Leaf1B2_1B3_2B1_1B6_Ref = object {
  _Leaf1B2_1B3_2B1_1B6
  scale 0.7
  rotate <0.0, 61.83374, 96.64109>
  translate  <2.24428, 4.45329, 8.09938>
}
#declare _Leaf1B2_1B3_2B1_1B7_Ref = object {
  _Leaf1B2_1B3_2B1_1B7
  scale 0.7
  rotate <0.0, 167.107147, 92.791191>
  translate  <2.32482, 4.51165, 8.06978>
}
#declare _Leaf1B2_1B3_2B1_1B8_Ref = object {
  _Leaf1B2_1B3_2B1_1B8
  scale 0.7
  rotate <0.0, 154.947845, 318.97757>
  translate  <2.4755, 4.64326, 8.06397>
}
#declare _Leaf1B2_1B3_2B1_1B9_Ref = object {
  _Leaf1B2_1B3_2B1_1B9
  scale 0.7
  rotate <0.0, 40.089291, 129.777771>
  translate  <2.46367, 4.65681, 8.07654>
}
#declare _Leaf1B2_1B3_2B1_1B10_Ref = object {
  _Leaf1B2_1B3_2B1_1B10
  scale 0.7
  rotate <0.0, 65.730362, 56.458111>
  translate  <2.61566, 4.78731, 8.07489>
}
#declare _Leaf1B2_1B3_2B1_1B11_Ref = object {
  _Leaf1B2_1B3_2B1_1B11
  scale 0.7
  rotate <0.0, 65.155151, 6.40687>
  translate  <2.62243, 4.78, 8.07403>
}
#declare _Leaf1B2_1B3_2B1_1B12_Ref = object {
  _Leaf1B2_1B3_2B1_1B12
  scale 0.7
  rotate <0.0, 95.387039, 322.842865>
  translate  <2.625, 4.77661, 8.06497>
}
#declare _Leaf1B2_1B3_2B2_1B1_Ref = object {
  _Leaf1B2_1B3_2B2_1B1
  scale 0.7
  rotate <0.0, 55.31995, 309.057892>
  translate  <1.98895, 3.81654, 8.55869>
}
#declare _Leaf1B2_1B3_2B2_1B2_Ref = object {
  _Leaf1B2_1B3_2B2_1B2
  scale 0.7
  rotate <0.0, 98.643494, 309.378418>
  translate  <2.17371, 3.76194, 8.61782>
}
#declare _Leaf1B2_1B3_2B2_1B3_Ref = object {
  _Leaf1B2_1B3_2B2_1B3
  scale 0.7
  rotate <0.0, 18.35042, 104.594048>
  translate  <2.25945, 3.7683, 8.68611>
}
#declare _Leaf1B2_1B3_2B2_1B4_Ref = object {
  _Leaf1B2_1B3_2B2_1B4
  scale 0.7
  rotate <0.0, 73.578667, 191.707993>
  translate  <2.25018, 3.7493, 8.69222>
}
#declare _Leaf1B2_1B3_2B2_1B5_Ref = object {
  _Leaf1B2_1B3_2B2_1B5
  scale 0.7
  rotate <0.0, 153.358185, 9.74123>
  translate  <2.3557, 3.72321, 8.69444>
}
#declare _Leaf1B2_1B3_2B2_1B6_Ref = object {
  _Leaf1B2_1B3_2B2_1B6
  scale 0.7
  rotate <0.0, 92.217293, 36.967758>
  translate  <2.61358, 3.64802, 8.82936>
}
#declare _Leaf1B2_1B3_2B2_1B7_Ref = object {
  _Leaf1B2_1B3_2B2_1B7
  scale 0.7
  rotate <0.0, 125.68792, 286.300964>
  translate  <2.69353, 3.59222, 8.86491>
}
#declare _Leaf1B2_1B3_2B2_1B8_Ref = object {
  _Leaf1B2_1B3_2B2_1B8
  scale 0.7
  rotate <0.0, 99.176743, 260.956299>
  translate  <2.86361, 3.53355, 8.9526>
}
#declare _Leaf1B2_1B3_2B2_1B9_Ref = object {
  _Leaf1B2_1B3_2B2_1B9
  scale 0.7
  rotate <0.0, 92.441406, 70.221237>
  translate  <2.87286, 3.55249, 8.9465>
}
#declare _Leaf1B2_1B3_2B2_1B10_Ref = object {
  _Leaf1B2_1B3_2B2_1B10
  scale 0.7
  rotate <0.0, 63.43412, 14.40039>
  translate  <3.04218, 3.49648, 9.03775>
}
#declare _Leaf1B2_1B3_2B2_1B11_Ref = object {
  _Leaf1B2_1B3_2B2_1B11
  scale 0.7
  rotate <0.0, 21.30756, 346.497009>
  translate  <3.0372, 3.49106, 9.04451>
}
#declare _Leaf1B2_1B3_2B2_1B12_Ref = object {
  _Leaf1B2_1B3_2B2_1B12
  scale 0.7
  rotate <0.0, 42.59251, 239.796585>
  translate  <3.03488, 3.48153, 9.04256>
}
#declare _Leaf1B2_1B3_2B3_1B1_Ref = object {
  _Leaf1B2_1B3_2B3_1B1
  scale 0.7
  rotate <0.0, 86.393356, 92.894882>
  translate  <2.01378, 4.43784, 9.00846>
}
#declare _Leaf1B2_1B3_2B3_1B2_Ref = object {
  _Leaf1B2_1B3_2B3_1B2
  scale 0.7
  rotate <0.0, 88.694008, 136.203094>
  translate  <1.95965, 4.59248, 9.12582>
}
#declare _Leaf1B2_1B3_2B3_1B3_Ref = object {
  _Leaf1B2_1B3_2B3_1B3
  scale 0.7
  rotate <0.0, 79.144661, 20.26125>
  translate  <1.98112, 4.66821, 9.20236>
}
#declare _Leaf1B2_1B3_2B3_1B4_Ref = object {
  _Leaf1B2_1B3_2B3_1B4
  scale 0.7
  rotate <0.0, 147.370834, 346.869293>
  translate  <1.98127, 4.68022, 9.18392>
}
#declare _Leaf1B2_1B3_2B3_1B5_Ref = object {
  _Leaf1B2_1B3_2B3_1B5
  scale 0.7
  rotate <0.0, 70.516769, 204.668716>
  translate  <1.92766, 4.74606, 9.25182>
}
#declare _Leaf1B2_1B3_2B3_1B6_Ref = object {
  _Leaf1B2_1B3_2B3_1B6
  scale 0.7
  rotate <0.0, 6.24568, 213.07106>
  translate  <1.89407, 4.99301, 9.4199>
}
#declare _Leaf1B2_1B3_2B3_1B7_Ref = object {
  _Leaf1B2_1B3_2B3_1B7
  scale 0.7
  rotate <0.0, 109.45295, 163.987671>
  translate  <1.8641, 5.08707, 9.45187>
}
#declare _Leaf1B2_1B3_2B3_1B8_Ref = object {
  _Leaf1B2_1B3_2B3_1B8
  scale 0.7
  rotate <0.0, 136.496872, 136.555588>
  translate  <1.83684, 5.25511, 9.55712>
}
#declare _Leaf1B2_1B3_2B3_1B9_Ref = object {
  _Leaf1B2_1B3_2B3_1B9
  scale 0.7
  rotate <0.0, 33.386631, 296.841827>
  translate  <1.83669, 5.24314, 9.57551>
}
#declare _Leaf1B2_1B3_2B3_1B10_Ref = object {
  _Leaf1B2_1B3_2B3_1B10
  scale 0.7
  rotate <0.0, 31.53528, 79.461571>
  translate  <1.81376, 5.41125, 9.68203>
}
#declare _Leaf1B2_1B3_2B3_1B11_Ref = object {
  _Leaf1B2_1B3_2B3_1B11
  scale 0.7
  rotate <0.0, 72.93013, 54.611889>
  translate  <1.81874, 5.41667, 9.67527>
}
#declare _Leaf1B2_1B3_2B3_1B12_Ref = object {
  _Leaf1B2_1B3_2B3_1B12
  scale 0.7
  rotate <0.0, 124.953133, 55.74593>
  translate  <1.81388, 5.4207, 9.66751>
}
#declare _Leaf1B2_1B3_2B4_1B1_Ref = object {
  _Leaf1B2_1B3_2B4_1B1
  scale 0.7
  rotate <0.0, 28.775909, 167.014465>
  translate  <2.1381, 4.22181, 9.31233>
}
#declare _Leaf1B2_1B3_2B4_1B2_Ref = object {
  _Leaf1B2_1B3_2B4_1B2
  scale 0.7
  rotate <0.0, 52.406429, 226.659363>
  translate  <2.13897, 4.1687, 9.50674>
}
#declare _Leaf1B2_1B3_2B4_1B3_Ref = object {
  _Leaf1B2_1B3_2B4_1B3
  scale 0.7
  rotate <0.0, 68.229172, 74.362221>
  translate  <2.16891, 4.18401, 9.61126>
}
#declare _Leaf1B2_1B3_2B4_1B4_Ref = object {
  _Leaf1B2_1B3_2B4_1B4
  scale 0.7
  rotate <0.0, 124.316673, 124.40197>
  translate  <2.14792, 4.19061, 9.61153>
}
#declare _Leaf1B2_1B3_2B4_1B5_Ref = object {
  _Leaf1B2_1B3_2B4_1B5
  scale 0.7
  rotate <0.0, 97.931892, 282.7565>
  translate  <2.15387, 4.13451, 9.70447>
}
#declare _Leaf1B2_1B3_2B4_1B6_Ref = object {
  _Leaf1B2_1B3_2B4_1B6
  scale 0.7
  rotate <0.0, 61.096001, 337.563477>
  translate  <2.15508, 4.10482, 10.0036>
}
#declare _Leaf1B2_1B3_2B4_1B7_Ref = object {
  _Leaf1B2_1B3_2B4_1B7
  scale 0.7
  rotate <0.0, 86.652809, 228.038193>
  translate  <2.12452, 4.08472, 10.10071>
}
#declare _Leaf1B2_1B3_2B4_1B8_Ref = object {
  _Leaf1B2_1B3_2B4_1B8
  scale 0.7
  rotate <0.0, 88.790649, 192.925003>
  translate  <2.11667, 4.06248, 10.29946>
}
#declare _Leaf1B2_1B3_2B4_1B9_Ref = object {
  _Leaf1B2_1B3_2B4_1B9
  scale 0.7
  rotate <0.0, 88.433517, 357.376038>
  translate  <2.1376, 4.0559, 10.29919>
}
#declare _Leaf1B2_1B3_2B4_1B10_Ref = object {
  _Leaf1B2_1B3_2B4_1B10
  scale 0.7
  rotate <0.0, 27.31295, 357.104431>
  translate  <2.132, 4.03751, 10.4986>
}
#declare _Leaf1B2_1B3_2B4_1B11_Ref = object {
  _Leaf1B2_1B3_2B4_1B11
  scale 0.7
  rotate <0.0, 36.387959, 89.502724>
  translate  <2.12523, 4.04481, 10.49947>
}
#declare _Leaf1B2_1B3_2B4_1B12_Ref = object {
  _Leaf1B2_1B3_2B4_1B12
  scale 0.7
  rotate <0.0, 75.098244, 134.107239>
  translate  <2.11548, 4.0427, 10.49881>
}
#declare _Leaf1B2_1B3_2B5_1B1_Ref = object {
  _Leaf1B2_1B3_2B5_1B1
  scale 0.7
  rotate <0.0, 20.10796, 357.291473>
  translate  <2.49549, 4.48572, 9.46848>
}
#declare _Leaf1B2_1B3_2B5_1B2_Ref = object {
  _Leaf1B2_1B3_2B5_1B2
  scale 0.7
  rotate <0.0, 62.88599, 345.449951>
  translate  <2.622, 4.57329, 9.59863>
}
#declare _Leaf1B2_1B3_2B5_1B3_Ref = object {
  _Leaf1B2_1B3_2B5_1B3
  scale 0.7
  rotate <0.0, 54.157959, 149.024628>
  translate  <2.64545, 4.64788, 9.67571>
}
#declare _Leaf1B2_1B3_2B5_1B4_Ref = object {
  _Leaf1B2_1B3_2B5_1B4
  scale 0.7
  rotate <0.0, 87.09024, 220.754562>
  translate  <2.6434, 4.62951, 9.68764>
}
#declare _Leaf1B2_1B3_2B5_1B5_Ref = object {
  _Leaf1B2_1B3_2B5_1B5
  scale 0.7
  rotate <0.0, 128.990707, 7.69987>
  translate  <2.7304, 4.67542, 9.73394>
}
#declare _Leaf1B2_1B3_2B5_1B6_Ref = object {
  _Leaf1B2_1B3_2B5_1B6
  scale 0.7
  rotate <0.0, 95.967239, 69.30603>
  translate  <2.87847, 4.81156, 9.95733>
}
#declare _Leaf1B2_1B3_2B5_1B7_Ref = object {
  _Leaf1B2_1B3_2B5_1B7
  scale 0.7
  rotate <0.0, 90.186523, 323.900543>
  translate  <2.94144, 4.8279, 10.03817>
}
#declare _Leaf1B2_1B3_2B5_1B8_Ref = object {
  _Leaf1B2_1B3_2B5_1B8
  scale 0.7
  rotate <0.0, 70.991783, 293.892548>
  translate  <3.04361, 4.91057, 10.18912>
}
#declare _Leaf1B2_1B3_2B5_1B9_Ref = object {
  _Leaf1B2_1B3_2B5_1B9
  scale 0.7
  rotate <0.0, 114.635551, 97.980263>
  translate  <3.04565, 4.92889, 10.17722>
}
#declare _Leaf1B2_1B3_2B5_1B10_Ref = object {
  _Leaf1B2_1B3_2B5_1B10
  scale 0.7
  rotate <0.0, 59.871231, 69.678352>
  translate  <3.14425, 5.01399, 10.32944>
}
#declare _Leaf1B2_1B3_2B5_1B11_Ref = object {
  _Leaf1B2_1B3_2B5_1B11
  scale 0.7
  rotate <0.0, 25.9977, 117.871918>
  translate  <3.13927, 5.00856, 10.33621>
}
#declare _Leaf1B2_1B3_2B5_1B12_Ref = object {
  _Leaf1B2_1B3_2B5_1B12
  scale 0.7
  rotate <0.0, 37.522869, 229.329605>
  translate  <3.14264, 4.99952, 10.33884>
}
#declare _Leaf1B2_1B3_1B1_1B1_Ref = object {
  _Leaf1B2_1B3_1B1_1B1
  scale 0.7
  rotate <0.0, 50.929909, 312.742615>
  translate  <0.97642, 2.8447, 7.03335>
}
#declare _Leaf1B2_1B3_1B1_1B2_Ref = object {
  _Leaf1B2_1B3_1B1_1B2
  scale 0.7
  rotate <0.0, 94.249008, 313.490631>
  translate  <1.16074, 2.80661, 7.10538>
}
#declare _Leaf1B2_1B3_1B1_1B3_Ref = object {
  _Leaf1B2_1B3_1B1_1B3
  scale 0.7
  rotate <0.0, 22.257641, 114.261147>
  translate  <1.24169, 2.82256, 7.17783>
}
#declare _Leaf1B2_1B3_1B1_1B4_Ref = object {
  _Leaf1B2_1B3_1B1_1B4
  scale 0.7
  rotate <0.0, 76.060623, 194.775787>
  translate  <1.23341, 2.80327, 7.18444>
}
#declare _Leaf1B2_1B3_1B1_1B5_Ref = object {
  _Leaf1B2_1B3_1B1_1B5
  scale 0.7
  rotate <0.0, 150.580383, 7.33303>
  translate  <1.34017, 2.785, 7.19385>
}
#declare _Leaf1B2_1B3_1B1_1B6_Ref = object {
  _Leaf1B2_1B3_1B1_1B6
  scale 0.7
  rotate <0.0, 91.565643, 40.88364>
  translate  <1.5943, 2.73548, 7.34658>
}
#declare _Leaf1B2_1B3_1B1_1B7_Ref = object {
  _Leaf1B2_1B3_1B1_1B7
  scale 0.7
  rotate <0.0, 121.799454, 291.764465>
  translate  <1.6757, 2.68745, 7.38942>
}
#declare _Leaf1B2_1B3_1B1_1B8_Ref = object {
  _Leaf1B2_1B3_1B1_1B8
  scale 0.7
  rotate <0.0, 96.589302, 265.512817>
  translate  <1.84401, 2.64568, 7.48935>
}
#declare _Leaf1B2_1B3_1B1_1B9_Ref = object {
  _Leaf1B2_1B3_1B1_1B9
  scale 0.7
  rotate <0.0, 94.290619, 74.045357>
  translate  <1.85227, 2.66491, 7.48276>
}
#declare _Leaf1B2_1B3_1B1_1B10_Ref = object {
  _Leaf1B2_1B3_1B1_1B10
  scale 0.7
  rotate <0.0, 61.22588, 20.46879>
  translate  <2.01943, 2.62591, 7.58604>
}
#declare _Leaf1B2_1B3_1B1_1B11_Ref = object {
  _Leaf1B2_1B3_1B1_1B11
  scale 0.7
  rotate <0.0, 17.666559, 357.670074>
  translate  <2.01445, 2.62049, 7.59281>
}
#declare _Leaf1B2_1B3_1B1_1B12_Ref = object {
  _Leaf1B2_1B3_1B1_1B12
  scale 0.7
  rotate <0.0, 41.670101, 239.075867>
  translate  <2.01292, 2.61073, 7.59125>
}
#declare _Leaf1B2_1B3_1B2_1B1_Ref = object {
  _Leaf1B2_1B3_1B2_1B1
  scale 0.7
  rotate <0.0, 51.972561, 138.597305>
  translate  <0.84929, 3.25305, 7.522>
}
#declare _Leaf1B2_1B3_1B2_1B2_Ref = object {
  _Leaf1B2_1B3_1B2_1B2
  scale 0.7
  rotate <0.0, 58.379372, 191.510193>
  translate  <0.78698, 3.27215, 7.7127>
}
#declare _Leaf1B2_1B3_1B2_1B3_Ref = object {
  _Leaf1B2_1B3_1B2_1B3
  scale 0.7
  rotate <0.0, 79.015488, 62.593449>
  translate  <0.79547, 3.31447, 7.81366>
}
#declare _Leaf1B2_1B3_1B2_1B4_Ref = object {
  _Leaf1B2_1B3_1B2_1B4
  scale 0.7
  rotate <0.0, 147.130447, 96.232422>
  translate  <0.7786, 3.32589, 7.80535>
}
#declare _Leaf1B2_1B3_1B2_1B5_Ref = object {
  _Leaf1B2_1B3_1B2_1B5
  scale 0.7
  rotate <0.0, 78.86097, 263.936371>
  translate  <0.74321, 3.30588, 7.90619>
}
#declare _Leaf1B2_1B3_1B2_1B6_Ref = object {
  _Leaf1B2_1B3_1B2_1B6
  scale 0.7
  rotate <0.0, 37.811852, 326.153015>
  translate  <0.66523, 3.38227, 8.18627>
}
#declare _Leaf1B2_1B3_1B2_1B7_Ref = object {
  _Leaf1B2_1B3_1B2_1B7
  scale 0.7
  rotate <0.0, 88.597137, 208.630737>
  translate  <0.60814, 3.40554, 8.26974>
}
#declare _Leaf1B2_1B3_1B2_1B8_Ref = object {
  _Leaf1B2_1B3_1B2_1B8
  scale 0.7
  rotate <0.0, 104.040642, 176.758804>
  translate  <0.54758, 3.45625, 8.45364>
}
#declare _Leaf1B2_1B3_1B2_1B9_Ref = object {
  _Leaf1B2_1B3_1B2_1B9
  scale 0.7
  rotate <0.0, 68.68544, 342.028931>
  translate  <0.5644, 3.44486, 8.46193>
}
#declare _Leaf1B2_1B3_1B2_1B10_Ref = object {
  _Leaf1B2_1B3_1B2_1B10
  scale 0.7
  rotate <0.0, 15.38774, 39.615471>
  translate  <0.50707, 3.49868, 8.64618>
}
#declare _Leaf1B2_1B3_1B2_1B11_Ref = object {
  _Leaf1B2_1B3_1B2_1B11
  scale 0.7
  rotate <0.0, 54.39624, 88.251991>
  translate  <0.50324, 3.50731, 8.64289>
}
#declare _Leaf1B2_1B3_1B2_1B12_Ref = object {
  _Leaf1B2_1B3_1B2_1B12
  scale 0.7
  rotate <0.0, 99.426781, 115.892647>
  translate  <0.49379, 3.50767, 8.63964>
}
#declare _Leaf1B2_1B3_1B3_1B1_Ref = object {
  _Leaf1B2_1B3_1B3_1B1
  scale 0.7
  rotate <0.0, 106.970871, 45.531898>
  translate  <1.17695, 3.54781, 7.38989>
}
#declare _Leaf1B2_1B3_1B3_1B2_Ref = object {
  _Leaf1B2_1B3_1B3_1B2
  scale 0.7
  rotate <0.0, 129.998596, 88.071281>
  translate  <1.2242, 3.74368, 7.39371>
}
#declare _Leaf1B2_1B3_1B3_1B3_Ref = object {
  _Leaf1B2_1B3_1B3_1B3
  scale 0.7
  rotate <0.0, 52.985291, 354.484497>
  translate  <1.27368, 3.83058, 7.43906>
}
#declare _Leaf1B2_1B3_1B3_1B4_Ref = object {
  _Leaf1B2_1B3_1B3_1B4
  scale 0.7
  rotate <0.0, 104.242561, 298.382843>
  translate  <1.287, 3.82608, 7.42214>
}
#declare _Leaf1B2_1B3_1B3_1B5_Ref = object {
  _Leaf1B2_1B3_1B3_1B5
  scale 0.7
  rotate <0.0, 99.695908, 159.114868>
  translate  <1.28289, 3.93464, 7.41781>
}
#declare _Leaf1B2_1B3_1B3_1B6_Ref = object {
  _Leaf1B2_1B3_1B3_1B6
  scale 0.7
  rotate <0.0, 47.133099, 118.39798>
  translate  <1.39736, 4.21147, 7.44265>
}
#declare _Leaf1B2_1B3_1B3_1B7_Ref = object {
  _Leaf1B2_1B3_1B3_1B7
  scale 0.7
  rotate <0.0, 151.844925, 132.148346>
  translate  <1.4378, 4.30389, 7.41831>
}
#declare _Leaf1B2_1B3_1B3_1B8_Ref = object {
  _Leaf1B2_1B3_1B3_1B8
  scale 0.7
  rotate <0.0, 168.257095, 13.8344>
  translate  <1.51512, 4.48834, 7.4259>
}
#declare _Leaf1B2_1B3_1B3_1B9_Ref = object {
  _Leaf1B2_1B3_1B3_1B9
  scale 0.7
  rotate <0.0, 24.75042, 162.939026>
  translate  <1.50183, 4.49283, 7.44278>
}
#declare _Leaf1B2_1B3_1B3_1B10_Ref = object {
  _Leaf1B2_1B3_1B3_1B10
  scale 0.7
  rotate <0.0, 58.846741, 75.043282>
  translate  <1.58168, 4.67622, 7.45393>
}
#declare _Leaf1B2_1B3_1B3_1B11_Ref = object {
  _Leaf1B2_1B3_1B3_1B11
  scale 0.7
  rotate <0.0, 71.608742, 26.785>
  translate  <1.59049, 4.67301, 7.45047>
}
#declare _Leaf1B2_1B3_1B3_1B12_Ref = object {
  _Leaf1B2_1B3_1B3_1B12
  scale 0.7
  rotate <0.0, 109.668648, 350.619476>
  translate  <1.59217, 4.67268, 7.44061>
}
#declare _Leaf1B2_1B4_2B1_1B1_Ref = object {
  _Leaf1B2_1B4_2B1_1B1
  scale 0.7
  rotate <0.0, 131.018005, 77.752228>
  translate  <1.30521, 6.56654, 8.41025>
}
#declare _Leaf1B2_1B4_2B1_1B2_Ref = object {
  _Leaf1B2_1B4_2B1_1B2
  scale 0.7
  rotate <0.0, 132.766815, 137.166046>
  translate  <1.26339, 6.75853, 8.3655>
}
#declare _Leaf1B2_1B4_2B1_1B3_Ref = object {
  _Leaf1B2_1B4_2B1_1B3
  scale 0.7
  rotate <0.0, 80.037727, 21.975161>
  translate  <1.28461, 6.86613, 8.37084>
}
#declare _Leaf1B2_1B4_2B1_1B4_Ref = object {
  _Leaf1B2_1B4_2B1_1B4
  scale 0.7
  rotate <0.0, 108.24752, 313.138184>
  translate  <1.29128, 6.86119, 8.35046>
}
#declare _Leaf1B2_1B4_2B1_1B5_Ref = object {
  _Leaf1B2_1B4_2B1_1B5
  scale 0.7
  rotate <0.0, 76.784561, 181.775925>
  translate  <1.24061, 6.95595, 8.33394>
}
#declare _Leaf1B2_1B4_2B1_1B6_Ref = object {
  _Leaf1B2_1B4_2B1_1B6
  scale 0.7
  rotate <0.0, 47.884048, 114.563431>
  translate  <1.22821, 7.24847, 8.26581>
}
#declare _Leaf1B2_1B4_2B1_1B7_Ref = object {
  _Leaf1B2_1B4_2B1_1B7
  scale 0.7
  rotate <0.0, 132.467529, 184.365585>
  translate  <1.21384, 7.33687, 8.2134>
}
#declare _Leaf1B2_1B4_2B1_1B8_Ref = object {
  _Leaf1B2_1B4_2B1_1B8
  scale 0.7
  rotate <0.0, 163.080627, 221.243439>
  translate  <1.20312, 7.52937, 8.15967>
}
#declare _Leaf1B2_1B4_2B1_1B9_Ref = object {
  _Leaf1B2_1B4_2B1_1B9
  scale 0.7
  rotate <0.0, 15.28903, 100.355713>
  translate  <1.19647, 7.5343, 8.17999>
}
#declare _Leaf1B2_1B4_2B1_1B10_Ref = object {
  _Leaf1B2_1B4_2B1_1B10
  scale 0.7
  rotate <0.0, 76.047974, 88.431297>
  translate  <1.18962, 7.72774, 8.12836>
}
#declare _Leaf1B2_1B4_2B1_1B11_Ref = object {
  _Leaf1B2_1B4_2B1_1B11
  scale 0.7
  rotate <0.0, 99.81176, 49.601089>
  translate  <1.19699, 7.72662, 8.12169>
}
#declare _Leaf1B2_1B4_2B1_1B12_Ref = object {
  _Leaf1B2_1B4_2B1_1B12
  scale 0.7
  rotate <0.0, 134.602036, 4.53594>
  translate  <1.19487, 7.72386, 8.11232>
}
#declare _Leaf1B2_1B4_2B2_1B1_Ref = object {
  _Leaf1B2_1B4_2B2_1B1
  scale 0.7
  rotate <0.0, 92.69828, 359.675018>
  translate  <1.77635, 6.71819, 8.58199>
}
#declare _Leaf1B2_1B4_2B2_1B2_Ref = object {
  _Leaf1B2_1B4_2B2_1B2
  scale 0.7
  rotate <0.0, 134.105621, 345.270477>
  translate  <1.93767, 6.81116, 8.50487>
}
#declare _Leaf1B2_1B4_2B2_1B3_Ref = object {
  _Leaf1B2_1B4_2B2_1B3
  scale 0.7
  rotate <0.0, 30.82073, 47.315029>
  translate  <2.01762, 6.88628, 8.5094>
}
#declare _Leaf1B2_1B4_2B2_1B4_Ref = object {
  _Leaf1B2_1B4_2B2_1B4
  scale 0.7
  rotate <0.0, 45.35775, 255.963943>
  translate  <2.02854, 6.86774, 8.51399>
}
#declare _Leaf1B2_1B4_2B2_1B5_Ref = object {
  _Leaf1B2_1B4_2B2_1B5
  scale 0.7
  rotate <0.0, 156.466171, 158.212448>
  translate  <2.09837, 6.91769, 8.44729>
}
#declare _Leaf1B2_1B4_2B2_1B6_Ref = object {
  _Leaf1B2_1B4_2B2_1B6
  scale 0.7
  rotate <0.0, 108.56543, 90.100571>
  translate  <2.3547, 7.05957, 8.38001>
}
#declare _Leaf1B2_1B4_2B2_1B7_Ref = object {
  _Leaf1B2_1B4_2B2_1B7
  scale 0.7
  rotate <0.0, 143.224197, 293.994141>
  translate  <2.45055, 7.0785, 8.34504>
}
#declare _Leaf1B2_1B4_2B2_1B8_Ref = object {
  _Leaf1B2_1B4_2B2_1B8
  scale 0.7
  rotate <0.0, 108.158302, 297.070282>
  translate  <2.62446, 7.16517, 8.29708>
}
#declare _Leaf1B2_1B4_2B2_1B9_Ref = object {
  _Leaf1B2_1B4_2B2_1B9
  scale 0.7
  rotate <0.0, 87.617378, 116.311234>
  translate  <2.61357, 7.18366, 8.29251>
}
#declare _Leaf1B2_1B4_2B2_1B10_Ref = object {
  _Leaf1B2_1B4_2B2_1B10
  scale 0.7
  rotate <0.0, 95.424171, 55.619339>
  translate  <2.78762, 7.27255, 8.24846>
}
#declare _Leaf1B2_1B4_2B2_1B11_Ref = object {
  _Leaf1B2_1B4_2B2_1B11
  scale 0.7
  rotate <0.0, 61.05336, 24.99254>
  translate  <2.79263, 7.26683, 8.25495>
}
#declare _Leaf1B2_1B4_2B2_1B12_Ref = object {
  _Leaf1B2_1B4_2B2_1B12
  scale 0.7
  rotate <0.0, 53.70982, 322.771362>
  translate  <2.79622, 7.25795, 8.25207>
}
#declare _Leaf1B2_1B4_2B3_1B1_Ref = object {
  _Leaf1B2_1B4_2B3_1B1
  scale 0.7
  rotate <0.0, 68.73069, 130.596085>
  translate  <1.67538, 7.28488, 9.08953>
}
#declare _Leaf1B2_1B4_2B3_1B2_Ref = object {
  _Leaf1B2_1B4_2B3_1B2
  scale 0.7
  rotate <0.0, 50.780609, 176.970306>
  translate  <1.62367, 7.38795, 9.25481>
}
#declare _Leaf1B2_1B4_2B3_1B3_Ref = object {
  _Leaf1B2_1B4_2B3_1B3
  scale 0.7
  rotate <0.0, 106.889603, 67.955589>
  translate  <1.63367, 7.47372, 9.32263>
}
#declare _Leaf1B2_1B4_2B3_1B4_Ref = object {
  _Leaf1B2_1B4_2B3_1B4
  scale 0.7
  rotate <0.0, 169.165756, 158.53598>
  translate  <1.61509, 7.47856, 9.31188>
}
#declare _Leaf1B2_1B4_2B3_1B5_Ref = object {
  _Leaf1B2_1B4_2B3_1B5
  scale 0.7
  rotate <0.0, 50.437519, 271.692108>
  translate  <1.58882, 7.5065, 9.41362>
}
#declare _Leaf1B2_1B4_2B3_1B6_Ref = object {
  _Leaf1B2_1B4_2B3_1B6
  scale 0.7
  rotate <0.0, 37.282291, 10.77986>
  translate  <1.52069, 7.70121, 9.63226>
}
#declare _Leaf1B2_1B4_2B3_1B7_Ref = object {
  _Leaf1B2_1B4_2B3_1B7
  scale 0.7
  rotate <0.0, 69.929253, 210.097061>
  translate  <1.46677, 7.75727, 9.70096>
}
#declare _Leaf1B2_1B4_2B3_1B8_Ref = object {
  _Leaf1B2_1B4_2B3_1B8
  scale 0.7
  rotate <0.0, 97.491638, 187.929291>
  translate  <1.41269, 7.88493, 9.84531>
}
#declare _Leaf1B2_1B4_2B3_1B9_Ref = object {
  _Leaf1B2_1B4_2B3_1B9
  scale 0.7
  rotate <0.0, 69.251099, 359.054535>
  translate  <1.43122, 7.88009, 9.85602>
}
#declare _Leaf1B2_1B4_2B3_1B10_Ref = object {
  _Leaf1B2_1B4_2B3_1B10
  scale 0.7
  rotate <0.0, 41.949261, 68.500069>
  translate  <1.38, 8.01088, 9.99887>
}
#declare _Leaf1B2_1B4_2B3_1B11_Ref = object {
  _Leaf1B2_1B4_2B3_1B11
  scale 0.7
  rotate <0.0, 82.64225, 91.858521>
  translate  <1.375, 8.0166, 9.99237>
}
#declare _Leaf1B2_1B4_2B3_1B12_Ref = object {
  _Leaf1B2_1B4_2B3_1B12
  scale 0.7
  rotate <0.0, 120.684219, 128.927887>
  translate  <1.36538, 8.0147, 9.99041>
}
#declare _Leaf1B2_1B4_2B4_1B1_Ref = object {
  _Leaf1B2_1B4_2B4_1B1
  scale 0.7
  rotate <0.0, 13.59734, 351.339539>
  translate  <2.05566, 7.27404, 9.18819>
}
#declare _Leaf1B2_1B4_2B4_1B2_Ref = object {
  _Leaf1B2_1B4_2B4_1B2
  scale 0.7
  rotate <0.0, 52.02449, 305.62619>
  translate  <2.20709, 7.27808, 9.32111>
}
#declare _Leaf1B2_1B4_2B4_1B3_Ref = object {
  _Leaf1B2_1B4_2B4_1B3
  scale 0.7
  rotate <0.0, 66.718651, 103.014999>
  translate  <2.27583, 7.33137, 9.38812>
}
#declare _Leaf1B2_1B4_2B4_1B4_Ref = object {
  _Leaf1B2_1B4_2B4_1B4
  scale 0.7
  rotate <0.0, 88.073036, 175.895935>
  translate  <2.2615, 7.32262, 9.40233>
}
#declare _Leaf1B2_1B4_2B4_1B5_Ref = object {
  _Leaf1B2_1B4_2B4_1B5
  scale 0.7
  rotate <0.0, 120.565193, 316.544678>
  translate  <2.35572, 7.30575, 9.45389>
}
#declare _Leaf1B2_1B4_2B4_1B6_Ref = object {
  _Leaf1B2_1B4_2B4_1B6
  scale 0.7
  rotate <0.0, 101.148933, 23.20566>
  translate  <2.55632, 7.34982, 9.67338>
}
#declare _Leaf1B2_1B4_2B4_1B7_Ref = object {
  _Leaf1B2_1B4_2B4_1B7
  scale 0.7
  rotate <0.0, 77.445488, 279.811737>
  translate  <2.61262, 7.3364, 9.75952>
}
#declare _Leaf1B2_1B4_2B4_1B8_Ref = object {
  _Leaf1B2_1B4_2B4_1B8
  scale 0.7
  rotate <0.0, 59.023239, 247.30928>
  translate  <2.74317, 7.35823, 9.90964>
}
#declare _Leaf1B2_1B4_2B4_1B9_Ref = object {
  _Leaf1B2_1B4_2B4_1B9
  scale 0.7
  rotate <0.0, 124.663963, 49.005402>
  translate  <2.75746, 7.36696, 9.89547>
}
#declare _Leaf1B2_1B4_2B4_1B10_Ref = object {
  _Leaf1B2_1B4_2B4_1B10
  scale 0.7
  rotate <0.0, 65.914497, 31.237181>
  translate  <2.88715, 7.39319, 10.04589>
}
#declare _Leaf1B2_1B4_2B4_1B11_Ref = object {
  _Leaf1B2_1B4_2B4_1B11
  scale 0.7
  rotate <0.0, 38.51263, 78.669189>
  translate  <2.87978, 7.39432, 10.05256>
}
#declare _Leaf1B2_1B4_2B4_1B12_Ref = object {
  _Leaf1B2_1B4_2B4_1B12
  scale 0.7
  rotate <0.0, 38.395031, 168.382935>
  translate  <2.87587, 7.3863, 10.05708>
}
#declare _Leaf1B2_1B4_2B5_1B1_Ref = object {
  _Leaf1B2_1B4_2B5_1B1
  scale 0.7
  rotate <0.0, 59.000019, 28.94894>
  translate  <2.16335, 7.73234, 9.17683>
}
#declare _Leaf1B2_1B4_2B5_1B2_Ref = object {
  _Leaf1B2_1B4_2B5_1B2
  scale 0.7
  rotate <0.0, 102.30056, 30.45179>
  translate  <2.25055, 7.90655, 9.22839>
}
#declare _Leaf1B2_1B4_2B5_1B3_Ref = object {
  _Leaf1B2_1B4_2B5_1B3
  scale 0.7
  rotate <0.0, 14.4166, 184.591415>
  translate  <2.26257, 7.99289, 9.29515>
}
#declare _Leaf1B2_1B4_2B5_1B4_Ref = object {
  _Leaf1B2_1B4_2B5_1B4
  scale 0.7
  rotate <0.0, 73.211906, 273.680328>
  translate  <2.28022, 7.98075, 9.30019>
}
#declare _Leaf1B2_1B4_2B5_1B5_Ref = object {
  _Leaf1B2_1B4_2B5_1B5
  scale 0.7
  rotate <0.0, 153.629944, 98.435654>
  translate  <2.32287, 8.08075, 9.29851>
}
#declare _Leaf1B2_1B4_2B5_1B6_Ref = object {
  _Leaf1B2_1B4_2B5_1B6
  scale 0.7
  rotate <0.0, 90.908653, 117.87101>
  translate  <2.44713, 8.3246, 9.42282>
}
#declare _Leaf1B2_1B4_2B5_1B7_Ref = object {
  _Leaf1B2_1B4_2B5_1B7
  scale 0.7
  rotate <0.0, 129.627625, 7.03021>
  translate  <2.51722, 8.39494, 9.45296>
}
#declare _Leaf1B2_1B4_2B5_1B8_Ref = object {
  _Leaf1B2_1B4_2B5_1B8
  scale 0.7
  rotate <0.0, 102.6931, 341.414124>
  translate  <2.60804, 8.5543, 9.53306>
}
#declare _Leaf1B2_1B4_2B5_1B9_Ref = object {
  _Leaf1B2_1B4_2B5_1B9
  scale 0.7
  rotate <0.0, 89.309959, 151.059616>
  translate  <2.59044, 8.5664, 9.52803>
}
#declare _Leaf1B2_1B4_2B5_1B10_Ref = object {
  _Leaf1B2_1B4_2B5_1B10
  scale 0.7
  rotate <0.0, 63.7234, 93.248528>
  translate  <2.67876, 8.72548, 9.61186>
}
#declare _Leaf1B2_1B4_2B5_1B11_Ref = object {
  _Leaf1B2_1B4_2B5_1B11
  scale 0.7
  rotate <0.0, 23.57629, 59.478111>
  translate  <2.68376, 8.71976, 9.61836>
}
#declare _Leaf1B2_1B4_2B5_1B12_Ref = object {
  _Leaf1B2_1B4_2B5_1B12
  scale 0.7
  rotate <0.0, 45.313889, 323.557709>
  translate  <2.69265, 8.71592, 9.61583>
}
#declare _Leaf1B2_1B4_1B1_1B1_Ref = object {
  _Leaf1B2_1B4_1B1_1B1
  scale 0.7
  rotate <0.0, 89.18058, 3.62256>
  translate  <0.95332, 5.02133, 7.72195>
}
#declare _Leaf1B2_1B4_1B1_1B2_Ref = object {
  _Leaf1B2_1B4_1B1_1B2
  scale 0.7
  rotate <0.0, 131.314804, 352.503723>
  translate  <1.112, 5.12885, 7.65969>
}
#declare _Leaf1B2_1B4_1B1_1B3_Ref = object {
  _Leaf1B2_1B4_1B1_1B3
  scale 0.7
  rotate <0.0, 26.31242, 52.48399>
  translate  <1.18614, 5.20875, 7.67291>
}
#declare _Leaf1B2_1B4_1B1_1B4_Ref = object {
  _Leaf1B2_1B4_1B1_1B4
  scale 0.7
  rotate <0.0, 49.072201, 257.411438>
  translate  <1.19804, 5.19075, 7.67722>
}
#declare _Leaf1B2_1B4_1B1_1B5_Ref = object {
  _Leaf1B2_1B4_1B1_1B5
  scale 0.7
  rotate <0.0, 158.326004, 152.084106>
  translate  <1.26798, 5.24878, 7.61754>
}
#declare _Leaf1B2_1B4_1B1_1B6_Ref = object {
  _Leaf1B2_1B4_1B1_1B6
  scale 0.7
  rotate <0.0, 105.652473, 92.91951>
  translate  <1.5173, 5.4108, 7.5734>
}
#declare _Leaf1B2_1B4_1B1_1B7_Ref = object {
  _Leaf1B2_1B4_1B1_1B7
  scale 0.7
  rotate <0.0, 144.190445, 303.969788>
  translate  <1.61347, 5.43792, 7.54539>
}
#declare _Leaf1B2_1B4_1B1_1B8_Ref = object {
  _Leaf1B2_1B4_1B1_1B8
  scale 0.7
  rotate <0.0, 109.061577, 302.476318>
  translate  <1.78344, 5.53842, 7.51265>
}
#declare _Leaf1B2_1B4_1B1_1B9_Ref = object {
  _Leaf1B2_1B4_1B1_1B9
  scale 0.7
  rotate <0.0, 86.605179, 120.435661>
  translate  <1.77157, 5.55636, 7.50835>
}
#declare _Leaf1B2_1B4_1B1_1B10_Ref = object {
  _Leaf1B2_1B4_1B1_1B10
  scale 0.7
  rotate <0.0, 91.047699, 59.446659>
  translate  <1.94128, 5.65887, 7.47963>
}
#declare _Leaf1B2_1B4_1B1_1B11_Ref = object {
  _Leaf1B2_1B4_1B1_1B11
  scale 0.7
  rotate <0.0, 56.63974, 28.19738>
  translate  <1.94629, 5.65315, 7.48613>
}
#declare _Leaf1B2_1B4_1B1_1B12_Ref = object {
  _Leaf1B2_1B4_1B1_1B12
  scale 0.7
  rotate <0.0, 52.77142, 323.335114>
  translate  <1.95065, 5.6447, 7.48303>
}
#declare _Leaf1B2_1B4_1B2_1B1_Ref = object {
  _Leaf1B2_1B4_1B2_1B1
  scale 0.7
  rotate <0.0, 15.97305, 151.821396>
  translate  <0.93308, 5.34257, 8.28595>
}
#declare _Leaf1B2_1B4_1B2_1B2_Ref = object {
  _Leaf1B2_1B4_1B2_1B2
  scale 0.7
  rotate <0.0, 33.493698, 271.101135>
  translate  <1.00609, 5.35743, 8.4732>
}
#declare _Leaf1B2_1B4_1B2_1B3_Ref = object {
  _Leaf1B2_1B4_1B2_1B3
  scale 0.7
  rotate <0.0, 82.272621, 101.782562>
  translate  <1.04526, 5.41571, 8.55761>
}
#declare _Leaf1B2_1B4_1B2_1B4_Ref = object {
  _Leaf1B2_1B4_1B2_1B4
  scale 0.7
  rotate <0.0, 116.973846, 168.821045>
  translate  <1.02476, 5.41128, 8.56426>
}
#declare _Leaf1B2_1B4_1B2_1B5_Ref = object {
  _Leaf1B2_1B4_1B2_1B5
  scale 0.7
  rotate <0.0, 94.127083, 312.3909>
  translate  <1.08087, 5.39561, 8.65606>
}
#declare _Leaf1B2_1B4_1B2_1B6_Ref = object {
  _Leaf1B2_1B4_1B2_1B6
  scale 0.7
  rotate <0.0, 77.747337, 15.00841>
  translate  <1.16475, 5.46147, 8.93711>
}
#declare _Leaf1B2_1B4_1B2_1B7_Ref = object {
  _Leaf1B2_1B4_1B2_1B7
  scale 0.7
  rotate <0.0, 67.163094, 262.399384>
  translate  <1.17267, 5.45949, 9.04056>
}
#declare _Leaf1B2_1B4_1B2_1B8_Ref = object {
  _Leaf1B2_1B4_1B2_1B8
  scale 0.7
  rotate <0.0, 67.07975, 224.139252>
  translate  <1.22277, 5.49706, 9.23066>
}
#declare _Leaf1B2_1B4_1B2_1B9_Ref = object {
  _Leaf1B2_1B4_1B2_1B9
  scale 0.7
  rotate <0.0, 108.425568, 27.94445>
  translate  <1.24321, 5.50147, 9.22402>
}
#declare _Leaf1B2_1B4_1B2_1B10_Ref = object {
  _Leaf1B2_1B4_1B2_1B10
  scale 0.7
  rotate <0.0, 48.11697, 38.681068>
  translate  <1.29319, 5.54348, 9.41341>
}
#declare _Leaf1B2_1B4_1B2_1B11_Ref = object {
  _Leaf1B2_1B4_1B2_1B11
  scale 0.7
  rotate <0.0, 48.42366, 100.754539>
  translate  <1.28393, 5.54658, 9.41558>
}
#declare _Leaf1B2_1B4_1B2_1B12_Ref = object {
  _Leaf1B2_1B4_1B2_1B12
  scale 0.7
  rotate <0.0, 67.805832, 159.001419>
  translate  <1.27705, 5.54, 9.41866>
}
#declare _Leaf1B2_1B4_1B3_1B1_Ref = object {
  _Leaf1B2_1B4_1B3_1B1
  scale 0.7
  rotate <0.0, 114.485641, 107.235657>
  translate  <0.83194, 5.74148, 8.0802>
}
#declare _Leaf1B2_1B4_1B3_1B2_Ref = object {
  _Leaf1B2_1B4_1B3_1B2
  scale 0.7
  rotate <0.0, 106.677582, 152.966324>
  translate  <0.73589, 5.91579, 8.11195>
}
#declare _Leaf1B2_1B4_1B3_1B3_Ref = object {
  _Leaf1B2_1B4_1B3_1B3
  scale 0.7
  rotate <0.0, 91.179703, 36.212189>
  translate  <0.7339, 6.0211, 8.14295>
}
#declare _Leaf1B2_1B4_1B3_1B4_Ref = object {
  _Leaf1B2_1B4_1B3_1B4
  scale 0.7
  rotate <0.0, 134.301224, 328.307892>
  translate  <0.73302, 6.0228, 8.12104>
}
#declare _Leaf1B2_1B4_1B3_1B5_Ref = object {
  _Leaf1B2_1B4_1B3_1B5
  scale 0.7
  rotate <0.0, 59.759079, 205.962585>
  translate  <0.66087, 6.09833, 8.1512>
}
#declare _Leaf1B2_1B4_1B3_1B6_Ref = object {
  _Leaf1B2_1B4_1B3_1B6
  scale 0.7
  rotate <0.0, 25.02766, 112.302002>
  translate  <0.56055, 6.37986, 8.18341>
}
#declare _Leaf1B2_1B4_1B3_1B7_Ref = object {
  _Leaf1B2_1B4_1B3_1B7
  scale 0.7
  rotate <0.0, 113.020119, 188.866974>
  translate  <0.50835, 6.4682, 8.16792>
}
#declare _Leaf1B2_1B4_1B3_1B8_Ref = object {
  _Leaf1B2_1B4_1B3_1B8
  scale 0.7
  rotate <0.0, 148.073105, 185.288147>
  translate  <0.43659, 6.65451, 8.18193>
}
#declare _Leaf1B2_1B4_1B3_1B9_Ref = object {
  _Leaf1B2_1B4_1B3_1B9
  scale 0.7
  rotate <0.0, 16.13398, 5.54208>
  translate  <0.43746, 6.65281, 8.20379>
}
#declare _Leaf1B2_1B4_1B3_1B10_Ref = object {
  _Leaf1B2_1B4_1B3_1B10
  scale 0.7
  rotate <0.0, 59.67696, 96.026314>
  translate  <0.36977, 6.84077, 8.21876>
}
#declare _Leaf1B2_1B4_1B3_1B11_Ref = object {
  _Leaf1B2_1B4_1B3_1B11
  scale 0.7
  rotate <0.0, 97.201759, 69.641312>
  translate  <0.37402, 6.8434, 8.2101>
}
#declare _Leaf1B2_1B4_1B3_1B12_Ref = object {
  _Leaf1B2_1B4_1B3_1B12
  scale 0.7
  rotate <0.0, 146.900635, 49.971889>
  translate  <0.36908, 6.84211, 8.2015>
}
#declare _Leaf1B2_1B5_2B1_1B1_Ref = object {
  _Leaf1B2_1B5_2B1_1B1
  scale 0.7
  rotate <0.0, 65.988876, 184.496887>
  translate  <-0.82011, 6.36472, 8.84976>
}
#declare _Leaf1B2_1B5_2B1_1B2_Ref = object {
  _Leaf1B2_1B5_2B1_1B2
  scale 0.7
  rotate <0.0, 50.348461, 232.801941>
  translate  <-0.92514, 6.38017, 9.02106>
}
#declare _Leaf1B2_1B5_2B1_1B3_Ref = object {
  _Leaf1B2_1B5_2B1_1B3
  scale 0.7
  rotate <0.0, 103.91259, 121.475563>
  translate  <-0.98419, 6.43754, 9.09371>
}
#declare _Leaf1B2_1B5_2B1_1B4_Ref = object {
  _Leaf1B2_1B5_2B1_1B4
  scale 0.7
  rotate <0.0, 167.279892, 198.225327>
  translate  <-0.99975, 6.42591, 9.08337>
}
#declare _Leaf1B2_1B5_2B1_1B5_Ref = object {
  _Leaf1B2_1B5_2B1_1B5
  scale 0.7
  rotate <0.0, 53.787411, 324.963928>
  translate  <-1.03273, 6.41857, 9.18671>
}
#declare _Leaf1B2_1B5_2B1_1B6_Ref = object {
  _Leaf1B2_1B5_2B1_1B6
  scale 0.7
  rotate <0.0, 37.11581, 59.45084>
  translate  <-1.21808, 6.47421, 9.41673>
}
#declare _Leaf1B2_1B5_2B1_1B7_Ref = object {
  _Leaf1B2_1B5_2B1_1B7
  scale 0.7
  rotate <0.0, 71.343529, 264.259644>
  translate  <-1.29175, 6.46262, 9.48889>
}
#declare _Leaf1B2_1B5_2B1_1B8_Ref = object {
  _Leaf1B2_1B5_2B1_1B8
  scale 0.7
  rotate <0.0, 97.607483, 240.576263>
  translate  <-1.41887, 6.49156, 9.64075>
}
#declare _Leaf1B2_1B5_2B1_1B9_Ref = object {
  _Leaf1B2_1B5_2B1_1B9
  scale 0.7
  rotate <0.0, 69.677902, 50.898399>
  translate  <-1.40336, 6.50315, 9.65106>
}
#declare _Leaf1B2_1B5_2B1_1B10_Ref = object {
  _Leaf1B2_1B5_2B1_1B10
  scale 0.7
  rotate <0.0, 38.98827, 119.733887>
  translate  <-1.53133, 6.53629, 9.80158>
}
#declare _Leaf1B2_1B5_2B1_1B11_Ref = object {
  _Leaf1B2_1B5_2B1_1B11
  scale 0.7
  rotate <0.0, 79.292137, 144.914169>
  translate  <-1.53923, 6.53591, 9.79546>
}
#declare _Leaf1B2_1B5_2B1_1B12_Ref = object {
  _Leaf1B2_1B5_2B1_1B12
  scale 0.7
  rotate <0.0, 117.857857, 181.002945>
  translate  <-1.54359, 6.52714, 9.79344>
}
#declare _Leaf1B2_1B5_2B2_1B1_Ref = object {
  _Leaf1B2_1B5_2B2_1B1
  scale 0.7
  rotate <0.0, 127.81649, 131.677094>
  translate  <-1.00343, 6.83372, 8.70519>
}
#declare _Leaf1B2_1B5_2B2_1B2_Ref = object {
  _Leaf1B2_1B5_2B2_1B2
  scale 0.7
  rotate <0.0, 130.211746, 188.329742>
  translate  <-1.18402, 6.91676, 8.67194>
}
#declare _Leaf1B2_1B5_2B2_1B3_Ref = object {
  _Leaf1B2_1B5_2B2_1B3
  scale 0.7
  rotate <0.0, 79.114868, 74.472908>
  translate  <-1.25689, 6.99808, 8.68342>
}
#declare _Leaf1B2_1B5_2B2_1B4_Ref = object {
  _Leaf1B2_1B5_2B2_1B4
  scale 0.7
  rotate <0.0, 110.902031, 6.96164>
  translate  <-1.24997, 7.00107, 8.66276>
}
#declare _Leaf1B2_1B5_2B2_1B5_Ref = object {
  _Leaf1B2_1B5_2B2_1B5
  scale 0.7
  rotate <0.0, 76.576141, 235.661469>
  translate  <-1.35685, 7.01788, 8.65208>
}
#declare _Leaf1B2_1B5_2B2_1B6_Ref = object {
  _Leaf1B2_1B5_2B2_1B6
  scale 0.7
  rotate <0.0, 44.715931, 168.719635>
  translate  <-1.60118, 7.18544, 8.60119>
}
#declare _Leaf1B2_1B5_2B2_1B7_Ref = object {
  _Leaf1B2_1B5_2B2_1B7
  scale 0.7
  rotate <0.0, 132.297806, 234.395859>
  translate  <-1.68299, 7.22855, 8.55411>
}
#declare _Leaf1B2_1B5_2B2_1B8_Ref = object {
  _Leaf1B2_1B5_2B2_1B8
  scale 0.7
  rotate <0.0, 164.790833, 264.270172>
  translate  <-1.84576, 7.33704, 8.51174>
}
#declare _Leaf1B2_1B5_2B2_1B9_Ref = object {
  _Leaf1B2_1B5_2B2_1B9
  scale 0.7
  rotate <0.0, 11.94512, 154.718994>
  translate  <-1.85266, 7.33406, 8.53235>
}
#declare _Leaf1B2_1B5_2B2_1B10_Ref = object {
  _Leaf1B2_1B5_2B2_1B10
  scale 0.7
  rotate <0.0, 72.717758, 141.402908>
  translate  <-2.01376, 7.44614, 8.49213>
}
#declare _Leaf1B2_1B5_2B2_1B11_Ref = object {
  _Leaf1B2_1B5_2B2_1B11
  scale 0.7
  rotate <0.0, 97.476563, 103.059929>
  translate  <-2.00878, 7.45157, 8.48536>
}
#declare _Leaf1B2_1B5_2B2_1B12_Ref = object {
  _Leaf1B2_1B5_2B2_1B12
  scale 0.7
  rotate <0.0, 134.574997, 60.939072>
  translate  <-2.00831, 7.4485, 8.47586>
}
#declare _Leaf1B2_1B5_2B3_1B1_Ref = object {
  _Leaf1B2_1B5_2B3_1B1
  scale 0.7
  rotate <0.0, 14.7871, 31.97616>
  translate  <-0.86413, 7.33086, 9.27296>
}
#declare _Leaf1B2_1B5_2B3_1B2_Ref = object {
  _Leaf1B2_1B5_2B3_1B2
  scale 0.7
  rotate <0.0, 54.953491, 357.501709>
  translate  <-0.76978, 7.45035, 9.405>
}
#declare _Leaf1B2_1B5_2B3_1B3_Ref = object {
  _Leaf1B2_1B5_2B3_1B3
  scale 0.7
  rotate <0.0, 63.38863, 156.307693>
  translate  <-0.76768, 7.53524, 9.4746>
}
#declare _Leaf1B2_1B5_2B3_1B4_Ref = object {
  _Leaf1B2_1B5_2B3_1B4
  scale 0.7
  rotate <0.0, 87.503036, 229.115646>
  translate  <-0.76858, 7.51811, 9.48836>
}
#declare _Leaf1B2_1B5_2B3_1B5_Ref = object {
  _Leaf1B2_1B5_2B3_1B5
  scale 0.7
  rotate <0.0, 123.080368, 11.01788>
  translate  <-0.69597, 7.58178, 9.5383>
}
#declare _Leaf1B2_1B5_2B3_1B6_Ref = object {
  _Leaf1B2_1B5_2B3_1B6
  scale 0.7
  rotate <0.0, 100.123528, 76.898201>
  translate  <-0.5997, 7.76196, 9.75881>
}
#declare _Leaf1B2_1B5_2B3_1B7_Ref = object {
  _Leaf1B2_1B5_2B3_1B7
  scale 0.7
  rotate <0.0, 80.794922, 332.85791>
  translate  <-0.55088, 7.79633, 9.84369>
}
#declare _Leaf1B2_1B5_2B3_1B8_Ref = object {
  _Leaf1B2_1B5_2B3_1B8
  scale 0.7
  rotate <0.0, 61.988998, 301.292358>
  translate  <-0.4824, 7.90927, 9.99406>
}
#declare _Leaf1B2_1B5_2B3_1B9_Ref = object {
  _Leaf1B2_1B5_2B3_1B9
  scale 0.7
  rotate <0.0, 122.327728, 103.69429>
  translate  <-0.4815, 7.92636, 9.98034>
}
#declare _Leaf1B2_1B5_2B3_1B10_Ref = object {
  _Leaf1B2_1B5_2B3_1B10
  scale 0.7
  rotate <0.0, 64.505463, 82.920837>
  translate  <-0.41703, 8.04124, 10.13127>
}
#declare _Leaf1B2_1B5_2B3_1B11_Ref = object {
  _Leaf1B2_1B5_2B3_1B11
  scale 0.7
  rotate <0.0, 35.31419, 130.398438>
  translate  <-0.42202, 8.03582, 10.13804>
}
#declare _Leaf1B2_1B5_2B3_1B12_Ref = object {
  _Leaf1B2_1B5_2B3_1B12
  scale 0.7
  rotate <0.0, 37.50988, 225.630127>
  translate  <-0.41775, 8.02774, 10.14211>
}
#declare _Leaf1B2_1B5_2B4_1B1_Ref = object {
  _Leaf1B2_1B5_2B4_1B1
  scale 0.7
  rotate <0.0, 93.047707, 52.934528>
  translate  <-0.97597, 7.63198, 9.0465>
}
#declare _Leaf1B2_1B5_2B4_1B2_Ref = object {
  _Leaf1B2_1B5_2B4_1B2
  scale 0.7
  rotate <0.0, 135.19342, 41.50201>
  translate  <-0.95718, 7.81907, 8.97399>
}
#declare _Leaf1B2_1B5_2B4_1B3_Ref = object {
  _Leaf1B2_1B5_2B4_1B3
  scale 0.7
  rotate <0.0, 28.69138, 95.859917>
  translate  <-0.9689, 7.92791, 8.98242>
}
#declare _Leaf1B2_1B5_2B4_1B4_Ref = object {
  _Leaf1B2_1B5_2B4_1B4
  scale 0.7
  rotate <0.0, 48.528099, 310.090485>
  translate  <-0.94732, 7.92539, 8.98585>
}
#declare _Leaf1B2_1B5_2B4_1B5_Ref = object {
  _Leaf1B2_1B5_2B4_1B5
  scale 0.7
  rotate <0.0, 154.748642, 204.932373>
  translate  <-0.94861, 8.0132, 8.92177>
}
#declare _Leaf1B2_1B5_2B4_1B6_Ref = object {
  _Leaf1B2_1B5_2B4_1B6
  scale 0.7
  rotate <0.0, 105.22348, 143.291626>
  translate  <-0.91132, 8.30531, 8.86138>
}
#declare _Leaf1B2_1B5_2B4_1B7_Ref = object {
  _Leaf1B2_1B5_2B4_1B7
  scale 0.7
  rotate <0.0, 146.398712, 348.640106>
  translate  <-0.87064, 8.39437, 8.82701>
}
#declare _Leaf1B2_1B5_2B4_1B8_Ref = object {
  _Leaf1B2_1B5_2B4_1B8
  scale 0.7
  rotate <0.0, 111.281326, 350.604584>
  translate  <-0.8378, 8.58687, 8.78317>
}
#declare _Leaf1B2_1B5_2B4_1B9_Ref = object {
  _Leaf1B2_1B5_2B4_1B9
  scale 0.7
  rotate <0.0, 84.474571, 169.484863>
  translate  <-0.85932, 8.58939, 8.77974>
}
#declare _Leaf1B2_1B5_2B4_1B10_Ref = object {
  _Leaf1B2_1B5_2B4_1B10
  scale 0.7
  rotate <0.0, 92.852837, 108.867538>
  translate  <-0.82798, 8.78321, 8.73993>
}
#declare _Leaf1B2_1B5_2B4_1B11_Ref = object {
  _Leaf1B2_1B5_2B4_1B11
  scale 0.7
  rotate <0.0, 59.995209, 76.282547>
  translate  <-0.82008, 8.78359, 8.74605>
}
#declare _Leaf1B2_1B5_2B4_1B12_Ref = object {
  _Leaf1B2_1B5_2B4_1B12
  scale 0.7
  rotate <0.0, 56.03503, 14.15796>
  translate  <-0.81099, 8.78122, 8.74263>
}
#declare _Leaf1B2_1B5_2B5_1B1_Ref = object {
  _Leaf1B2_1B5_2B5_1B1
  scale 0.7
  rotate <0.0, 93.717072, 101.702316>
  translate  <-1.26061, 7.86385, 9.34141>
}
#declare _Leaf1B2_1B5_2B5_1B2_Ref = object {
  _Leaf1B2_1B5_2B5_1B2
  scale 0.7
  rotate <0.0, 98.244751, 145.049194>
  translate  <-1.35148, 8.01913, 9.4322>
}
#declare _Leaf1B2_1B5_2B5_1B3_Ref = object {
  _Leaf1B2_1B5_2B5_1B3
  scale 0.7
  rotate <0.0, 75.594368, 31.07052>
  translate  <-1.35142, 8.10478, 9.5009>
}
#declare _Leaf1B2_1B5_2B5_1B4_Ref = object {
  _Leaf1B2_1B5_2B5_1B4
  scale 0.7
  rotate <0.0, 139.119125, 349.143524>
  translate  <-1.35061, 8.11469, 9.48128>
}
#declare _Leaf1B2_1B5_2B5_1B5_Ref = object {
  _Leaf1B2_1B5_2B5_1B5
  scale 0.7
  rotate <0.0, 73.761818, 210.574493>
  translate  <-1.42162, 8.1778, 9.53416>
}
#declare _Leaf1B2_1B5_2B5_1B6_Ref = object {
  _Leaf1B2_1B5_2B5_1B6
  scale 0.7
  rotate <0.0, 12.27824, 172.069214>
  translate  <-1.51237, 8.4322, 9.66608>
}
#declare _Leaf1B2_1B5_2B5_1B7_Ref = object {
  _Leaf1B2_1B5_2B5_1B7
  scale 0.7
  rotate <0.0, 117.563187, 175.017456>
  translate  <-1.55961, 8.52308, 9.68277>
}
#declare _Leaf1B2_1B5_2B5_1B8_Ref = object {
  _Leaf1B2_1B5_2B5_1B8
  scale 0.7
  rotate <0.0, 146.040024, 146.197433>
  translate  <-1.62448, 8.69456, 9.76305>
}
#declare _Leaf1B2_1B5_2B5_1B9_Ref = object {
  _Leaf1B2_1B5_2B5_1B9
  scale 0.7
  rotate <0.0, 24.327971, 299.99234>
  translate  <-1.62529, 8.68467, 9.78262>
}
#declare _Leaf1B2_1B5_2B5_1B10_Ref = object {
  _Leaf1B2_1B5_2B5_1B10
  scale 0.7
  rotate <0.0, 37.92561, 98.625473>
  translate  <-1.68611, 8.85703, 9.86463>
}
#declare _Leaf1B2_1B5_2B5_1B11_Ref = object {
  _Leaf1B2_1B5_2B5_1B11
  scale 0.7
  rotate <0.0, 75.080017, 66.103989>
  translate  <-1.68113, 8.86245, 9.85786>
}
#declare _Leaf1B2_1B5_2B5_1B12_Ref = object {
  _Leaf1B2_1B5_2B5_1B12
  scale 0.7
  rotate <0.0, 126.512627, 57.748779>
  translate  <-1.68548, 8.86484, 9.84918>
}
#declare _Leaf1B2_1B5_1B1_1B1_Ref = object {
  _Leaf1B2_1B5_1B1_1B1
  scale 0.7
  rotate <0.0, 123.436302, 128.032913>
  translate  <-0.38896, 5.09292, 7.76263>
}
#declare _Leaf1B2_1B5_1B1_1B2_Ref = object {
  _Leaf1B2_1B5_1B1_1B2
  scale 0.7
  rotate <0.0, 127.230164, 181.652481>
  translate  <-0.56463, 5.18994, 7.74421>
}
#declare _Leaf1B2_1B5_1B1_1B3_Ref = object {
  _Leaf1B2_1B5_1B1_1B3
  scale 0.7
  rotate <0.0, 77.273361, 69.572639>
  translate  <-0.6307, 5.27537, 7.764>
}
#declare _Leaf1B2_1B5_1B1_1B4_Ref = object {
  _Leaf1B2_1B5_1B1_1B4
  scale 0.7
  rotate <0.0, 113.847641, 4.25814>
  translate  <-0.62472, 5.27899, 7.74314>
}
#declare _Leaf1B2_1B5_1B1_1B5_Ref = object {
  _Leaf1B2_1B5_1B1_1B5
  scale 0.7
  rotate <0.0, 77.095131, 232.628006>
  translate  <-0.73054, 5.30371, 7.73959>
}
#declare _Leaf1B2_1B5_1B1_1B6_Ref = object {
  _Leaf1B2_1B5_1B1_1B6
  scale 0.7
  rotate <0.0, 40.907478, 167.081284>
  translate  <-0.96455, 5.49028, 7.71155>
}
#declare _Leaf1B2_1B5_1B1_1B7_Ref = object {
  _Leaf1B2_1B5_1B1_1B7
  scale 0.7
  rotate <0.0, 132.525146, 226.301895>
  translate  <-1.0455, 5.54144, 7.67155>
}
#declare _Leaf1B2_1B5_1B1_1B8_Ref = object {
  _Leaf1B2_1B5_1B1_1B8
  scale 0.7
  rotate <0.0, 166.818375, 244.594543>
  translate  <-1.20209, 5.66307, 7.64428>
}
#declare _Leaf1B2_1B5_1B1_1B9_Ref = object {
  _Leaf1B2_1B5_1B1_1B9
  scale 0.7
  rotate <0.0, 7.76957, 159.17804>
  translate  <-1.20805, 5.65946, 7.66508>
}
#declare _Leaf1B2_1B5_1B1_1B10_Ref = object {
  _Leaf1B2_1B5_1B1_1B10
  scale 0.7
  rotate <0.0, 68.30204, 137.397171>
  translate  <-1.3626, 5.78444, 7.64002>
}
#declare _Leaf1B2_1B5_1B1_1B11_Ref = object {
  _Leaf1B2_1B5_1B1_1B11
  scale 0.7
  rotate <0.0, 93.912392, 99.260262>
  translate  <-1.35762, 5.78986, 7.63325>
}
#declare _Leaf1B2_1B5_1B1_1B12_Ref = object {
  _Leaf1B2_1B5_1B1_1B12
  scale 0.7
  rotate <0.0, 133.53595, 61.037239>
  translate  <-1.35789, 5.78729, 7.62359>
}
#declare _Leaf1B2_1B5_1B2_1B1_Ref = object {
  _Leaf1B2_1B5_1B2_1B1
  scale 0.7
  rotate <0.0, 68.73317, 36.541222>
  translate  <-0.12942, 5.58685, 8.09485>
}
#declare _Leaf1B2_1B5_1B2_1B2_Ref = object {
  _Leaf1B2_1B5_1B2_1B2
  scale 0.7
  rotate <0.0, 110.036873, 23.16703>
  translate  <-0.038, 5.76616, 8.08466>
}
#declare _Leaf1B2_1B5_1B2_1B3_Ref = object {
  _Leaf1B2_1B5_1B2_1B3
  scale 0.7
  rotate <0.0, 25.473301, 129.837387>
  translate  <-0.025, 5.87029, 8.11694>
}
#declare _Leaf1B2_1B5_1B2_1B4_Ref = object {
  _Leaf1B2_1B5_1B2_1B4
  scale 0.7
  rotate <0.0, 52.382099, 271.58432>
  translate  <-0.00791, 5.86037, 8.12662>
}
#declare _Leaf1B2_1B5_1B2_1B5_Ref = object {
  _Leaf1B2_1B5_1B2_1B5
  scale 0.7
  rotate <0.0, 174.401947, 105.288132>
  translate  <0.03804, 5.95234, 8.09125>
}
#declare _Leaf1B2_1B5_1B2_1B6_Ref = object {
  _Leaf1B2_1B5_1B2_1B6
  scale 0.7
  rotate <0.0, 110.198723, 117.781532>
  translate  <0.16676, 6.22178, 8.12579>
}
#declare _Leaf1B2_1B5_1B2_1B7_Ref = object {
  _Leaf1B2_1B5_1B2_1B7
  scale 0.7
  rotate <0.0, 126.91243, 348.878754>
  translate  <0.23827, 6.29675, 8.1317>
}
#declare _Leaf1B2_1B5_1B2_1B8_Ref = object {
  _Leaf1B2_1B5_1B2_1B8
  scale 0.7
  rotate <0.0, 93.465637, 337.127991>
  translate  <0.33202, 6.47222, 8.15357>
}
#declare _Leaf1B2_1B5_1B2_1B9_Ref = object {
  _Leaf1B2_1B5_1B2_1B9
  scale 0.7
  rotate <0.0, 101.126228, 151.055984>
  translate  <0.31498, 6.48212, 8.14393>
}
#declare _Leaf1B2_1B5_1B2_1B10_Ref = object {
  _Leaf1B2_1B5_1B2_1B10
  scale 0.7
  rotate <0.0, 84.552399, 91.933411>
  translate  <0.40612, 6.65871, 8.16929>
}
#declare _Leaf1B2_1B5_1B2_1B11_Ref = object {
  _Leaf1B2_1B5_1B2_1B11
  scale 0.7
  rotate <0.0, 42.080582, 73.636131>
  translate  <0.41075, 6.65556, 8.17758>
}
#declare _Leaf1B2_1B5_1B2_1B12_Ref = object {
  _Leaf1B2_1B5_1B2_1B12
  scale 0.7
  rotate <0.0, 34.08654, 343.713165>
  translate  <0.41957, 6.65089, 8.17691>
}
#declare _Leaf1B2_1B5_1B3_1B1_Ref = object {
  _Leaf1B2_1B5_1B3_1B1
  scale 0.7
  rotate <0.0, 36.97036, 192.017654>
  translate  <-0.42175, 5.53289, 8.44604>
}
#declare _Leaf1B2_1B5_1B3_1B2_Ref = object {
  _Leaf1B2_1B5_1B3_1B2
  scale 0.7
  rotate <0.0, 34.468578, 270.356293>
  translate  <-0.43626, 5.56012, 8.64519>
}
#declare _Leaf1B2_1B5_1B3_1B3_Ref = object {
  _Leaf1B2_1B5_1B3_1B3
  scale 0.7
  rotate <0.0, 91.36718, 134.565979>
  translate  <-0.46425, 5.61968, 8.73308>
}
#declare _Leaf1B2_1B5_1B3_1B4_Ref = object {
  _Leaf1B2_1B5_1B3_1B4
  scale 0.7
  rotate <0.0, 138.309753, 201.011765>
  translate  <-0.48042, 5.60478, 8.73235>
}
#declare _Leaf1B2_1B5_1B3_1B5_Ref = object {
  _Leaf1B2_1B5_1B3_1B5
  scale 0.7
  rotate <0.0, 76.676788, 343.078491>
  translate  <-0.4598, 5.60871, 8.83903>
}
#declare _Leaf1B2_1B5_1B3_1B6_Ref = object {
  _Leaf1B2_1B5_1B3_1B6
  scale 0.7
  rotate <0.0, 59.152431, 50.93829>
  translate  <-0.52409, 5.67389, 9.12535>
}
#declare _Leaf1B2_1B5_1B3_1B7_Ref = object {
  _Leaf1B2_1B5_1B3_1B7
  scale 0.7
  rotate <0.0, 66.988068, 284.952606>
  translate  <-0.55243, 5.66389, 9.22467>
}
#declare _Leaf1B2_1B5_1B3_1B8_Ref = object {
  _Leaf1B2_1B5_1B3_1B8
  scale 0.7
  rotate <0.0, 79.686111, 250.60849>
  translate  <-0.59758, 5.69867, 9.41653>
}
#declare _Leaf1B2_1B5_1B3_1B9_Ref = object {
  _Leaf1B2_1B5_1B3_1B9
  scale 0.7
  rotate <0.0, 91.840492, 57.192459>
  translate  <-0.58145, 5.71353, 9.41726>
}
#declare _Leaf1B2_1B5_1B3_1B10_Ref = object {
  _Leaf1B2_1B5_1B3_1B10
  scale 0.7
  rotate <0.0, 37.702881, 90.919373>
  translate  <-0.62872, 5.75214, 9.60807>
}
#declare _Leaf1B2_1B5_1B3_1B11_Ref = object {
  _Leaf1B2_1B5_1B3_1B11
  scale 0.7
  rotate <0.0, 59.335709, 146.100769>
  translate  <-0.63834, 5.74986, 9.60655>
}
#declare _Leaf1B2_1B5_1B3_1B12_Ref = object {
  _Leaf1B2_1B5_1B3_1B12
  scale 0.7
  rotate <0.0, 88.945351, 191.319397>
  translate  <-0.64145, 5.74041, 9.6075>
}
#declare _Leaf1B2_1B6_2B1_1B1_Ref = object {
  _Leaf1B2_1B6_2B1_1B1
  scale 0.7
  rotate <0.0, 53.412441, 345.902161>
  translate  <0.56364, 5.73901, 9.7383>
}
#declare _Leaf1B2_1B6_2B1_1B2_Ref = object {
  _Leaf1B2_1B6_2B1_1B2
  scale 0.7
  rotate <0.0, 95.769836, 355.626495>
  translate  <0.72826, 5.81712, 9.82439>
}
#declare _Leaf1B2_1B6_2B1_1B3_Ref = object {
  _Leaf1B2_1B6_2B1_1B3
  scale 0.7
  rotate <0.0, 19.55839, 182.757477>
  translate  <0.7795, 5.86805, 9.90707>
}
#declare _Leaf1B2_1B6_2B1_1B4_Ref = object {
  _Leaf1B2_1B6_2B1_1B4
  scale 0.7
  rotate <0.0, 84.571327, 237.077408>
  translate  <0.78603, 5.84722, 9.90983>
}
#declare _Leaf1B2_1B6_2B1_1B5_Ref = object {
  _Leaf1B2_1B6_2B1_1B5
  scale 0.7
  rotate <0.0, 142.363205, 58.82579>
  translate  <0.87853, 5.90121, 9.92849>
}
#declare _Leaf1B2_1B6_2B1_1B6_Ref = object {
  _Leaf1B2_1B6_2B1_1B6
  scale 0.7
  rotate <0.0, 81.149239, 81.961861>
  translate  <1.10411, 6.00128, 10.10014>
}
#declare _Leaf1B2_1B6_2B1_1B7_Ref = object {
  _Leaf1B2_1B6_2B1_1B7
  scale 0.7
  rotate <0.0, 126.6688, 339.428864>
  translate  <1.19747, 6.01069, 10.14445>
}
#declare _Leaf1B2_1B6_2B1_1B8_Ref = object {
  _Leaf1B2_1B6_2B1_1B8
  scale 0.7
  rotate <0.0, 105.411484, 307.880371>
  translate  <1.35276, 6.07056, 10.25562>
}
#declare _Leaf1B2_1B6_2B1_1B9_Ref = object {
  _Leaf1B2_1B6_2B1_1B9
  scale 0.7
  rotate <0.0, 84.431007, 115.301323>
  translate  <1.34625, 6.09133, 10.25288>
}
#declare _Leaf1B2_1B6_2B1_1B10_Ref = object {
  _Leaf1B2_1B6_2B1_1B10
  scale 0.7
  rotate <0.0, 52.36747, 57.819061>
  translate  <1.49889, 6.1519, 10.36762>
}
#declare _Leaf1B2_1B6_2B1_1B11_Ref = object {
  _Leaf1B2_1B6_2B1_1B11
  scale 0.7
  rotate <0.0, 14.30285, 2.81606>
  translate  <1.49878, 6.14342, 10.37291>
}
#declare _Leaf1B2_1B6_2B1_1B12_Ref = object {
  _Leaf1B2_1B6_2B1_1B12
  scale 0.7
  rotate <0.0, 52.228249, 279.184326>
  translate  <1.50403, 6.1355, 10.36979>
}
#declare _Leaf1B2_1B6_2B2_1B1_Ref = object {
  _Leaf1B2_1B6_2B2_1B1
  scale 0.7
  rotate <0.0, 38.226398, 221.370132>
  translate  <0.31615, 5.77537, 10.19861>
}
#declare _Leaf1B2_1B6_2B2_1B2_Ref = object {
  _Leaf1B2_1B6_2B2_1B2
  scale 0.7
  rotate <0.0, 63.027618, 269.065735>
  translate  <0.3415, 5.70289, 10.38494>
}
#declare _Leaf1B2_1B6_2B2_1B3_Ref = object {
  _Leaf1B2_1B6_2B2_1B3
  scale 0.7
  rotate <0.0, 61.109509, 123.398529>
  translate  <0.34478, 5.71498, 10.49402>
}
#declare _Leaf1B2_1B6_2B2_1B4_Ref = object {
  _Leaf1B2_1B6_2B2_1B4
  scale 0.7
  rotate <0.0, 125.324142, 161.403549>
  translate  <0.32534, 5.7051, 10.49113>
}
#declare _Leaf1B2_1B6_2B2_1B5_Ref = object {
  _Leaf1B2_1B6_2B2_1B5
  scale 0.7
  rotate <0.0, 100.238663, 329.392853>
  translate  <0.36309, 5.65273, 10.5786>
}
#declare _Leaf1B2_1B6_2B2_1B6_Ref = object {
  _Leaf1B2_1B6_2B2_1B6
  scale 0.7
  rotate <0.0, 53.903641, 16.841021>
  translate  <0.36517, 5.57759, 10.86966>
}
#declare _Leaf1B2_1B6_2B2_1B7_Ref = object {
  _Leaf1B2_1B6_2B2_1B7
  scale 0.7
  rotate <0.0, 97.08004, 273.042358>
  translate  <0.35149, 5.52454, 10.95779>
}
#declare _Leaf1B2_1B6_2B2_1B8_Ref = object {
  _Leaf1B2_1B6_2B2_1B8
  scale 0.7
  rotate <0.0, 99.821564, 237.600952>
  translate  <0.34855, 5.46689, 11.14943>
}
#declare _Leaf1B2_1B6_2B2_1B9_Ref = object {
  _Leaf1B2_1B6_2B2_1B9
  scale 0.7
  rotate <0.0, 78.478981, 41.620659>
  translate  <0.36794, 5.47675, 11.15231>
}
#declare _Leaf1B2_1B6_2B2_1B10_Ref = object {
  _Leaf1B2_1B6_2B2_1B10
  scale 0.7
  rotate <0.0, 18.1094, 25.8668>
  translate  <0.36383, 5.42322, 11.34532>
}
#declare _Leaf1B2_1B6_2B2_1B11_Ref = object {
  _Leaf1B2_1B6_2B2_1B11
  scale 0.7
  rotate <0.0, 32.84343, 150.027557>
  translate  <0.35384, 5.42352, 11.34559>
}
#declare _Leaf1B2_1B6_2B2_1B12_Ref = object {
  _Leaf1B2_1B6_2B2_1B12
  scale 0.7
  rotate <0.0, 78.965363, 181.42276>
  translate  <0.34853, 5.41544, 11.34304>
}
#declare _Leaf1B2_1B6_2B3_1B1_Ref = object {
  _Leaf1B2_1B6_2B3_1B1
  scale 0.7
  rotate <0.0, 93.039993, 60.11034>
  translate  <0.3896, 6.49533, 10.45394>
}
#declare _Leaf1B2_1B6_2B3_1B2_Ref = object {
  _Leaf1B2_1B6_2B3_1B2
  scale 0.7
  rotate <0.0, 126.967392, 89.439278>
  translate  <0.37354, 6.69539, 10.4722>
}
#declare _Leaf1B2_1B6_2B3_1B3_Ref = object {
  _Leaf1B2_1B6_2B3_1B3
  scale 0.7
  rotate <0.0, 33.331779, 9.56852>
  translate  <0.37788, 6.788, 10.53101>
}
#declare _Leaf1B2_1B6_2B3_1B4_Ref = object {
  _Leaf1B2_1B6_2B3_1B4
  scale 0.7
  rotate <0.0, 94.036041, 318.218109>
  translate  <0.39667, 6.78897, 10.51961>
}
#declare _Leaf1B2_1B6_2B3_1B5_Ref = object {
  _Leaf1B2_1B6_2B3_1B5
  scale 0.7
  rotate <0.0, 118.150124, 173.749603>
  translate  <0.36261, 6.89203, 10.51343>
}
#declare _Leaf1B2_1B6_2B3_1B6_Ref = object {
  _Leaf1B2_1B6_2B3_1B6
  scale 0.7
  rotate <0.0, 58.775791, 147.731293>
  translate  <0.37649, 7.18622, 10.57364>
}
#declare _Leaf1B2_1B6_2B3_1B7_Ref = object {
  _Leaf1B2_1B6_2B3_1B7
  scale 0.7
  rotate <0.0, 159.900635, 107.077789>
  translate  <0.39372, 7.28807, 10.56377>
}
#declare _Leaf1B2_1B6_2B3_1B8_Ref = object {
  _Leaf1B2_1B6_2B3_1B8
  scale 0.7
  rotate <0.0, 148.777145, 21.777479>
  translate  <0.40682, 7.4852, 10.5958>
}
#declare _Leaf1B2_1B6_2B3_1B9_Ref = object {
  _Leaf1B2_1B6_2B3_1B9
  scale 0.7
  rotate <0.0, 44.040421, 186.441727>
  translate  <0.38808, 7.48423, 10.60717>
}
#declare _Leaf1B2_1B6_2B3_1B10_Ref = object {
  _Leaf1B2_1B6_2B3_1B10
  scale 0.7
  rotate <0.0, 56.216759, 104.725479>
  translate  <0.4026, 7.68072, 10.64342>
}
#declare _Leaf1B2_1B6_2B3_1B11_Ref = object {
  _Leaf1B2_1B6_2B3_1B11
  scale 0.7
  rotate <0.0, 54.538631, 49.003929>
  translate  <0.41259, 7.68042, 10.64315>
}
#declare _Leaf1B2_1B6_2B3_1B12_Ref = object {
  _Leaf1B2_1B6_2B3_1B12
  scale 0.7
  rotate <0.0, 90.121368, 8.18718>
  translate  <0.4174, 7.68149, 10.63445>
}
#declare _Leaf1B2_1B6_2B4_1B1_Ref = object {
  _Leaf1B2_1B6_2B4_1B1
  scale 0.7
  rotate <0.0, 82.155296, 138.810486>
  translate  <0.1344, 6.42595, 10.74467>
}
#declare _Leaf1B2_1B6_2B4_1B2_Ref = object {
  _Leaf1B2_1B6_2B4_1B2
  scale 0.7
  rotate <0.0, 92.709198, 180.934753>
  translate  <-0.02093, 6.47542, 10.86316>
}
#declare _Leaf1B2_1B6_2B4_1B3_Ref = object {
  _Leaf1B2_1B6_2B4_1B3
  scale 0.7
  rotate <0.0, 67.892906, 64.814178>
  translate  <-0.06454, 6.52919, 10.94838>
}
#declare _Leaf1B2_1B6_2B4_1B4_Ref = object {
  _Leaf1B2_1B6_2B4_1B4
  scale 0.7
  rotate <0.0, 138.004013, 40.12421>
  translate  <-0.07172, 6.5411, 10.93133>
}
#declare _Leaf1B2_1B6_2B4_1B5_Ref = object {
  _Leaf1B2_1B6_2B4_1B5
  scale 0.7
  rotate <0.0, 81.815247, 249.564255>
  translate  <-0.16053, 6.53781, 10.99396>
}
#declare _Leaf1B2_1B6_2B4_1B6_Ref = object {
  _Leaf1B2_1B6_2B4_1B6
  scale 0.7
  rotate <0.0, 17.508551, 253.018723>
  translate  <-0.37015, 6.65678, 11.17358>
}
#declare _Leaf1B2_1B6_2B4_1B7_Ref = object {
  _Leaf1B2_1B6_2B4_1B7
  scale 0.7
  rotate <0.0, 117.720932, 205.467484>
  translate  <-0.45996, 6.69617, 11.20752>
}
#declare _Leaf1B2_1B6_2B4_1B8_Ref = object {
  _Leaf1B2_1B6_2B4_1B8
  scale 0.7
  rotate <0.0, 139.463196, 169.246552>
  translate  <-0.60509, 6.77578, 11.32003>
}
#declare _Leaf1B2_1B6_2B4_1B9_Ref = object {
  _Leaf1B2_1B6_2B4_1B9
  scale 0.7
  rotate <0.0, 34.761471, 325.005707>
  translate  <-0.59793, 6.7639, 11.33702>
}
#declare _Leaf1B2_1B6_2B4_1B10_Ref = object {
  _Leaf1B2_1B6_2B4_1B10
  scale 0.7
  rotate <0.0, 26.372841, 142.700912>
  translate  <-0.74016, 6.8463, 11.45154>
}
#declare _Leaf1B2_1B6_2B4_1B11_Ref = object {
  _Leaf1B2_1B6_2B4_1B11
  scale 0.7
  rotate <0.0, 63.172482, 101.783958>
  translate  <-0.74005, 6.85478, 11.44625>
}
#declare _Leaf1B2_1B6_2B4_1B12_Ref = object {
  _Leaf1B2_1B6_2B4_1B12
  scale 0.7
  rotate <0.0, 115.038879, 97.455971>
  translate  <-0.74581, 6.85568, 11.43812>
}
#declare _Leaf1B2_1B6_2B5_1B1_Ref = object {
  _Leaf1B2_1B6_2B5_1B1
  scale 0.7
  rotate <0.0, 33.577808, 142.854599>
  translate  <0.36555, 6.60993, 11.11139>
}
#declare _Leaf1B2_1B6_2B5_1B2_Ref = object {
  _Leaf1B2_1B6_2B5_1B2
  scale 0.7
  rotate <0.0, 13.10548, 274.882385>
  translate  <0.39563, 6.70624, 11.28584>
}
#declare _Leaf1B2_1B6_2B5_1B3_Ref = object {
  _Leaf1B2_1B6_2B5_1B3
  scale 0.7
  rotate <0.0, 103.472069, 120.802483>
  translate  <0.39999, 6.79757, 11.34663>
}
#declare _Leaf1B2_1B6_2B5_1B4_Ref = object {
  _Leaf1B2_1B6_2B5_1B4
  scale 0.7
  rotate <0.0, 123.079201, 199.738724>
  translate  <0.38083, 6.78881, 11.35296>
}
#declare _Leaf1B2_1B6_2B5_1B5_Ref = object {
  _Leaf1B2_1B6_2B5_1B5
  scale 0.7
  rotate <0.0, 76.019897, 332.370117>
  translate  <0.42136, 6.82248, 11.44806>
}
#declare _Leaf1B2_1B6_2B5_1B6_Ref = object {
  _Leaf1B2_1B6_2B5_1B6
  scale 0.7
  rotate <0.0, 79.942787, 38.22562>
  translate  <0.42966, 6.99704, 11.69264>
}
#declare _Leaf1B2_1B6_2B5_1B7_Ref = object {
  _Leaf1B2_1B6_2B5_1B7
  scale 0.7
  rotate <0.0, 47.369308, 276.388397>
  translate  <0.41883, 7.03027, 11.79035>
}
#declare _Leaf1B2_1B6_2B5_1B8_Ref = object {
  _Leaf1B2_1B6_2B5_1B8
  scale 0.7
  rotate <0.0, 57.042931, 233.081329>
  translate  <0.42025, 7.13991, 11.95779>
}
#declare _Leaf1B2_1B6_2B5_1B9_Ref = object {
  _Leaf1B2_1B6_2B5_1B9
  scale 0.7
  rotate <0.0, 113.159981, 39.004539>
  translate  <0.43936, 7.14865, 11.95147>
}
#declare _Leaf1B2_1B6_2B5_1B10_Ref = object {
  _Leaf1B2_1B6_2B5_1B10
  scale 0.7
  rotate <0.0, 60.108898, 70.597771>
  translate  <0.4395, 7.26198, 12.11667>
}
#declare _Leaf1B2_1B6_2B5_1B11_Ref = object {
  _Leaf1B2_1B6_2B5_1B11
  scale 0.7
  rotate <0.0, 69.623466, 119.862167>
  translate  <0.4295, 7.26227, 12.11694>
}
#declare _Leaf1B2_1B6_2B5_1B12_Ref = object {
  _Leaf1B2_1B6_2B5_1B12
  scale 0.7
  rotate <0.0, 80.004822, 172.927063>
  translate  <0.42441, 7.25508, 12.12166>
}
#declare _Leaf1B2_1B6_1B1_1B1_Ref = object {
  _Leaf1B2_1B6_1B1_1B1
  scale 0.7
  rotate <0.0, 34.360531, 215.268616>
  translate  <0.23479, 4.54915, 8.52944>
}
#declare _Leaf1B2_1B6_1B1_1B2_Ref = object {
  _Leaf1B2_1B6_1B1_1B2
  scale 0.7
  rotate <0.0, 57.030479, 269.279877>
  translate  <0.26091, 4.49659, 8.72224>
}
#declare _Leaf1B2_1B6_1B1_1B3_Ref = object {
  _Leaf1B2_1B6_1B1_1B3
  scale 0.7
  rotate <0.0, 66.063263, 121.87645>
  translate  <0.26448, 4.52002, 8.82945>
}
#declare _Leaf1B2_1B6_1B1_1B4_Ref = object {
  _Leaf1B2_1B6_1B1_1B4
  scale 0.7
  rotate <0.0, 126.847, 165.797531>
  translate  <0.24506, 4.50983, 8.82767>
}
#declare _Leaf1B2_1B6_1B1_1B5_Ref = object {
  _Leaf1B2_1B6_1B1_1B5
  scale 0.7
  rotate <0.0, 97.308868, 328.74472>
  translate  <0.28323, 4.46699, 8.92001>
}
#declare _Leaf1B2_1B6_1B1_1B6_Ref = object {
  _Leaf1B2_1B6_1B1_1B6
  scale 0.7
  rotate <0.0, 56.017471, 20.94277>
  translate  <0.28639, 4.42267, 9.21731>
}
#declare _Leaf1B2_1B6_1B1_1B7_Ref = object {
  _Leaf1B2_1B6_1B1_1B7
  scale 0.7
  rotate <0.0, 91.103348, 273.16684>
  translate  <0.27314, 4.37908, 9.31054>
}
#declare _Leaf1B2_1B6_1B1_1B8_Ref = object {
  _Leaf1B2_1B6_1B1_1B8
  scale 0.7
  rotate <0.0, 94.647713, 238.147278>
  translate  <0.27094, 4.34175, 9.50717>
}
#declare _Leaf1B2_1B6_1B1_1B9_Ref = object {
  _Leaf1B2_1B6_1B1_1B9
  scale 0.7
  rotate <0.0, 82.630569, 42.50235>
  translate  <0.29031, 4.35191, 9.50894>
}
#declare _Leaf1B2_1B6_1B1_1B10_Ref = object {
  _Leaf1B2_1B6_1B1_1B10
  scale 0.7
  rotate <0.0, 21.53657, 39.779179>
  translate  <0.28693, 4.31882, 9.7065>
}
#declare _Leaf1B2_1B6_1B1_1B11_Ref = object {
  _Leaf1B2_1B6_1B1_1B11
  scale 0.7
  rotate <0.0, 36.021519, 142.748276>
  translate  <0.27694, 4.31912, 9.70677>
}
#declare _Leaf1B2_1B6_1B1_1B12_Ref = object {
  _Leaf1B2_1B6_1B1_1B12
  scale 0.7
  rotate <0.0, 78.690399, 180.39888>
  translate  <0.27164, 4.31081, 9.7051>
}
#declare _Leaf1B2_1B6_1B2_1B1_Ref = object {
  _Leaf1B2_1B6_1B2_1B1
  scale 0.7
  rotate <0.0, 97.834587, 114.175919>
  translate  <0.08487, 5.15857, 8.69623>
}
#declare _Leaf1B2_1B6_1B2_1B2_Ref = object {
  _Leaf1B2_1B6_1B2_1B2
  scale 0.7
  rotate <0.0, 110.612053, 157.054047>
  translate  <-0.05951, 5.28482, 8.75811>
}
#declare _Leaf1B2_1B6_1B2_1B3_Ref = object {
  _Leaf1B2_1B6_1B2_1B3
  scale 0.7
  rotate <0.0, 64.358368, 48.185532>
  translate  <-0.09651, 5.3656, 8.82262>
}
#declare _Leaf1B2_1B6_1B2_1B4_Ref = object {
  _Leaf1B2_1B6_1B2_1B4
  scale 0.7
  rotate <0.0, 124.87278, 4.06378>
  translate  <-0.0933, 5.37611, 8.80356>
}
#declare _Leaf1B2_1B6_1B2_1B5_Ref = object {
  _Leaf1B2_1B6_1B2_1B5
  scale 0.7
  rotate <0.0, 85.424583, 222.909454>
  translate  <-0.18793, 5.41884, 8.83582>
}
#declare _Leaf1B2_1B6_1B2_1B6_Ref = object {
  _Leaf1B2_1B6_1B2_1B6
  scale 0.7
  rotate <0.0, 26.56575, 187.129639>
  translate  <-0.3657, 5.63993, 8.93518>
}
#declare _Leaf1B2_1B6_1B2_1B7_Ref = object {
  _Leaf1B2_1B6_1B2_1B7
  scale 0.7
  rotate <0.0, 131.854858, 189.011017>
  translate  <-0.4357, 5.7165, 8.93754>
}
#declare _Leaf1B2_1B6_1B2_1B8_Ref = object {
  _Leaf1B2_1B6_1B2_1B8
  scale 0.7
  rotate <0.0, 157.721573, 144.173691>
  translate  <-0.55691, 5.86497, 8.99523>
}
#declare _Leaf1B2_1B6_1B2_1B9_Ref = object {
  _Leaf1B2_1B6_1B2_1B9
  scale 0.7
  rotate <0.0, 19.564011, 279.528656>
  translate  <-0.56011, 5.85448, 9.01423>
}
#declare _Leaf1B2_1B6_1B2_1B10_Ref = object {
  _Leaf1B2_1B6_1B2_1B10
  scale 0.7
  rotate <0.0, 43.36729, 128.049393>
  translate  <-0.67813, 6.0047, 9.07456>
}
#declare _Leaf1B2_1B6_1B2_1B11_Ref = object {
  _Leaf1B2_1B6_1B2_1B11
  scale 0.7
  rotate <0.0, 71.08432, 84.168549>
  translate  <-0.67307, 6.01137, 9.0691>
}
#declare _Leaf1B2_1B6_1B2_1B12_Ref = object {
  _Leaf1B2_1B6_1B2_1B12
  scale 0.7
  rotate <0.0, 119.19249, 63.621868>
  translate  <-0.6756, 6.01297, 9.05956>
}
#declare _Leaf1B2_1B6_1B3_1B1_Ref = object {
  _Leaf1B2_1B6_1B3_1B1
  scale 0.7
  rotate <0.0, 70.61721, 13.39142>
  translate  <0.50467, 5.2384, 8.86678>
}
#declare _Leaf1B2_1B6_1B3_1B2_Ref = object {
  _Leaf1B2_1B6_1B3_1B2
  scale 0.7
  rotate <0.0, 113.463699, 19.97156>
  translate  <0.63722, 5.38711, 8.89727>
}
#declare _Leaf1B2_1B6_1B3_1B3_Ref = object {
  _Leaf1B2_1B6_1B3_1B3
  scale 0.7
  rotate <0.0, 1.72255, 208.913483>
  translate  <0.68237, 5.46543, 8.95957>
}
#declare _Leaf1B2_1B6_1B3_1B4_Ref = object {
  _Leaf1B2_1B6_1B3_1B4
  scale 0.7
  rotate <0.0, 74.490936, 264.767914>
  translate  <0.69758, 5.44956, 8.96049>
}
#declare _Leaf1B2_1B6_1B3_1B5_Ref = object {
  _Leaf1B2_1B6_1B3_1B5
  scale 0.7
  rotate <0.0, 149.083664, 108.517708>
  translate  <0.75972, 5.53806, 8.9492>
}
#declare _Leaf1B2_1B6_1B3_1B6_Ref = object {
  _Leaf1B2_1B6_1B3_1B6
  scale 0.7
  rotate <0.0, 84.813423, 104.736076>
  translate  <0.95886, 5.74315, 9.04216>
}
#declare _Leaf1B2_1B6_1B3_1B7_Ref = object {
  _Leaf1B2_1B6_1B3_1B7
  scale 0.7
  rotate <0.0, 142.587769, 356.22821>
  translate  <1.04758, 5.79525, 9.05565>
}
#declare _Leaf1B2_1B6_1B3_1B8_Ref = object {
  _Leaf1B2_1B6_1B3_1B8
  scale 0.7
  rotate <0.0, 115.047363, 327.227783>
  translate  <1.1866, 5.92728, 9.11312>
}
#declare _Leaf1B2_1B6_1B3_1B9_Ref = object {
  _Leaf1B2_1B6_1B3_1B9
  scale 0.7
  rotate <0.0, 77.886703, 137.638>
  translate  <1.17143, 5.9431, 9.1122>
}
#declare _Leaf1B2_1B6_1B3_1B10_Ref = object {
  _Leaf1B2_1B6_1B3_1B10
  scale 0.7
  rotate <0.0, 63.720921, 74.05629>
  translate  <1.30883, 6.0752, 9.17387>
}
#declare _Leaf1B2_1B6_1B3_1B11_Ref = object {
  _Leaf1B2_1B6_1B3_1B11
  scale 0.7
  rotate <0.0, 32.13908, 27.662239>
  translate  <1.31377, 6.06823, 9.17906>
}
#declare _Leaf1B2_1B6_1B3_1B12_Ref = object {
  _Leaf1B2_1B6_1B3_1B12
  scale 0.7
  rotate <0.0, 56.256699, 316.774963>
  translate  <1.32081, 6.06271, 9.17459>
}
#declare _Leaf1B3_1B1_2B1_1B1_Ref = object {
  _Leaf1B3_1B1_2B1_1B1
  scale 0.7
  rotate <0.0, 112.243111, 217.535187>
  translate  <-5.1198, 1.65871, 6.7182>
}
#declare _Leaf1B3_1B1_2B1_1B2_Ref = object {
  _Leaf1B3_1B1_2B1_1B2
  scale 0.7
  rotate <0.0, 89.256409, 255.22435>
  translate  <-5.28218, 1.54832, 6.76361>
}
#declare _Leaf1B3_1B1_2B1_1B3_Ref = object {
  _Leaf1B3_1B1_2B1_1B3
  scale 0.7
  rotate <0.0, 113.424377, 137.976837>
  translate  <-5.3901, 1.53703, 6.78039>
}
#declare _Leaf1B3_1B1_2B1_1B4_Ref = object {
  _Leaf1B3_1B1_2B1_1B4
  scale 0.7
  rotate <0.0, 146.000854, 42.827679>
  translate  <-5.38764, 1.52807, 6.76045>
}
#declare _Leaf1B3_1B1_2B1_1B5_Ref = object {
  _Leaf1B3_1B1_2B1_1B5
  scale 0.7
  rotate <0.0, 36.524811, 310.015198>
  translate  <-5.45681, 1.4582, 6.80685>
}
#declare _Leaf1B3_1B1_2B1_1B6_Ref = object {
  _Leaf1B3_1B1_2B1_1B6
  scale 0.7
  rotate <0.0, 32.264851, 169.133774>
  translate  <-5.7231, 1.32315, 6.84171>
}
#declare _Leaf1B3_1B1_2B1_1B7_Ref = object {
  _Leaf1B3_1B1_2B1_1B7
  scale 0.7
  rotate <0.0, 89.59726, 289.494171>
  translate  <-5.79916, 1.25271, 6.83714>
}
#declare _Leaf1B3_1B1_2B1_1B8_Ref = object {
  _Leaf1B3_1B1_2B1_1B8
  scale 0.7
  rotate <0.0, 124.74482, 289.48468>
  translate  <-5.97331, 1.15581, 6.85558>
}
#declare _Leaf1B3_1B1_2B1_1B9_Ref = object {
  _Leaf1B3_1B1_2B1_1B9
  scale 0.7
  rotate <0.0, 39.571178, 112.031609>
  translate  <-5.97577, 1.16474, 6.87546>
}
#declare _Leaf1B3_1B1_2B1_1B10_Ref = object {
  _Leaf1B3_1B1_2B1_1B10
  scale 0.7
  rotate <0.0, 66.65271, 184.366837>
  translate  <-6.15225, 1.07159, 6.89302>
}
#declare _Leaf1B3_1B1_2B1_1B11_Ref = object {
  _Leaf1B3_1B1_2B1_1B11
  scale 0.7
  rotate <0.0, 110.887451, 174.530731>
  translate  <-6.15382, 1.07187, 6.88315>
}
#declare _Leaf1B3_1B1_2B1_1B12_Ref = object {
  _Leaf1B3_1B1_2B1_1B12
  scale 0.7
  rotate <0.0, 162.034988, 191.210846>
  translate  <-6.15032, 1.06454, 6.87732>
}
#declare _Leaf1B3_1B1_2B2_1B1_Ref = object {
  _Leaf1B3_1B1_2B2_1B1
  scale 0.7
  rotate <0.0, 134.688049, 120.586807>
  translate  <-5.43697, 2.04491, 6.56099>
}
#declare _Leaf1B3_1B1_2B2_1B2_Ref = object {
  _Leaf1B3_1B1_2B2_1B2
  scale 0.7
  rotate <0.0, 175.701065, 181.12674>
  translate  <-5.58157, 2.06887, 6.42267>
}
#declare _Leaf1B3_1B1_2B2_1B3_Ref = object {
  _Leaf1B3_1B1_2B2_1B3
  scale 0.7
  rotate <0.0, 62.465401, 123.670273>
  translate  <-5.68091, 2.10357, 6.39132>
}
#declare _Leaf1B3_1B1_2B2_1B4_Ref = object {
  _Leaf1B3_1B1_2B2_1B4
  scale 0.7
  rotate <0.0, 64.455421, 39.710339>
  translate  <-5.66777, 2.11886, 6.38251>
}
#declare _Leaf1B3_1B1_2B2_1B5_Ref = object {
  _Leaf1B3_1B1_2B2_1B5
  scale 0.7
  rotate <0.0, 110.74231, 270.812592>
  translate  <-5.73886, 2.10278, 6.30184>
}
#declare _Leaf1B3_1B1_2B2_1B6_Ref = object {
  _Leaf1B3_1B1_2B2_1B6
  scale 0.7
  rotate <0.0, 88.910217, 208.867188>
  translate  <-5.96406, 2.18197, 6.11916>
}
#declare _Leaf1B3_1B1_2B2_1B7_Ref = object {
  _Leaf1B3_1B1_2B2_1B7
  scale 0.7
  rotate <0.0, 149.401993, 327.966248>
  translate  <-6.0164, 2.21368, 6.03535>
}
#declare _Leaf1B3_1B1_2B2_1B8_Ref = object {
  _Leaf1B3_1B1_2B2_1B8
  scale 0.7
  rotate <0.0, 136.178726, 24.05514>
  translate  <-6.16024, 2.26832, 5.90736>
}
#declare _Leaf1B3_1B1_2B2_1B9_Ref = object {
  _Leaf1B3_1B1_2B2_1B9
  scale 0.7
  rotate <0.0, 56.460419, 216.480194>
  translate  <-6.17335, 2.25307, 5.91614>
}
#declare _Leaf1B3_1B1_2B2_1B10_Ref = object {
  _Leaf1B3_1B1_2B2_1B10
  scale 0.7
  rotate <0.0, 103.55117, 175.575424>
  translate  <-6.31936, 2.30999, 5.79135>
}
#declare _Leaf1B3_1B1_2B2_1B11_Ref = object {
  _Leaf1B3_1B1_2B2_1B11
  scale 0.7
  rotate <0.0, 95.717682, 130.285751>
  translate  <-6.31599, 2.31941, 5.79109>
}
#declare _Leaf1B3_1B1_2B2_1B12_Ref = object {
  _Leaf1B3_1B1_2B2_1B12
  scale 0.7
  rotate <0.0, 98.057793, 77.893913>
  translate  <-6.30902, 2.32203, 5.78442>
}
#declare _Leaf1B3_1B1_2B3_1B1_Ref = object {
  _Leaf1B3_1B1_2B3_1B1
  scale 0.7
  rotate <0.0, 33.006969, 216.077606>
  translate  <-5.93464, 2.19145, 7.12648>
}
#declare _Leaf1B3_1B1_2B3_1B2_Ref = object {
  _Leaf1B3_1B1_2B3_1B2
  scale 0.7
  rotate <0.0, 14.09899, 346.398376>
  translate  <-6.01403, 2.24883, 7.3026>
}
#declare _Leaf1B3_1B1_2B3_1B3_Ref = object {
  _Leaf1B3_1B1_2B3_1B3
  scale 0.7
  rotate <0.0, 102.628418, 192.651443>
  translate  <-6.09852, 2.28088, 7.36497>
}
#declare _Leaf1B3_1B1_2B3_1B4_Ref = object {
  _Leaf1B3_1B1_2B3_1B4
  scale 0.7
  rotate <0.0, 123.439629, 271.100464>
  translate  <-6.09601, 2.25991, 7.37114>
}
#declare _Leaf1B3_1B1_2B3_1B5_Ref = object {
  _Leaf1B3_1B1_2B3_1B5
  scale 0.7
  rotate <0.0, 76.45874, 44.123428>
  translate  <-6.11392, 2.30831, 7.46684>
}
#declare _Leaf1B3_1B1_2B3_1B6_Ref = object {
  _Leaf1B3_1B1_2B3_1B6
  scale 0.7
  rotate <0.0, 79.302147, 110.05835>
  translate  <-6.27331, 2.36878, 7.71443>
}
#declare _Leaf1B3_1B1_2B3_1B7_Ref = object {
  _Leaf1B3_1B1_2B3_1B7
  scale 0.7
  rotate <0.0, 48.359161, 348.235413>
  translate  <-6.30665, 2.36818, 7.81269>
}
#declare _Leaf1B3_1B1_2B3_1B8_Ref = object {
  _Leaf1B3_1B1_2B3_1B8
  scale 0.7
  rotate <0.0, 57.861462, 305.420868>
  translate  <-6.4077, 2.40247, 7.98202>
}
#declare _Leaf1B3_1B1_2B3_1B9_Ref = object {
  _Leaf1B3_1B1_2B3_1B9
  scale 0.7
  rotate <0.0, 112.505928, 111.29612>
  translate  <-6.4102, 2.42338, 7.97587>
}
#declare _Leaf1B3_1B1_2B3_1B10_Ref = object {
  _Leaf1B3_1B1_2B3_1B10
  scale 0.7
  rotate <0.0, 59.157059, 142.392075>
  translate  <-6.51519, 2.4576, 8.14302>
}
#declare _Leaf1B3_1B1_2B3_1B11_Ref = object {
  _Leaf1B3_1B1_2B3_1B11
  scale 0.7
  rotate <0.0, 68.772614, 192.034775>
  translate  <-6.51856, 2.44819, 8.14329>
}
#declare _Leaf1B3_1B1_2B3_1B12_Ref = object {
  _Leaf1B3_1B1_2B3_1B12
  scale 0.7
  rotate <0.0, 79.91275, 245.076584>
  translate  <-6.51322, 2.44109, 8.14788>
}
#declare _Leaf1B3_1B1_2B4_1B1_Ref = object {
  _Leaf1B3_1B1_2B4_1B1
  scale 0.7
  rotate <0.0, 59.07637, 94.550507>
  translate  <-6.06614, 2.51023, 6.93794>
}
#declare _Leaf1B3_1B1_2B4_1B2_Ref = object {
  _Leaf1B3_1B1_2B4_1B2
  scale 0.7
  rotate <0.0, 92.308952, 65.343811>
  translate  <-6.12776, 2.70196, 6.93033>
}
#declare _Leaf1B3_1B1_2B4_1B3_Ref = object {
  _Leaf1B3_1B1_2B4_1B3
  scale 0.7
  rotate <0.0, 50.118992, 186.735733>
  translate  <-6.20366, 2.78, 6.94458>
}
#declare _Leaf1B3_1B1_2B4_1B4_Ref = object {
  _Leaf1B3_1B1_2B4_1B4
  scale 0.7
  rotate <0.0, 44.830059, 295.184906>
  translate  <-6.19047, 2.78328, 6.96188>
}
#declare _Leaf1B3_1B1_2B4_1B5_Ref = object {
  _Leaf1B3_1B1_2B4_1B5
  scale 0.7
  rotate <0.0, 157.461029, 31.02964>
  translate  <-6.2103, 2.88547, 6.93049>
}
#declare _Leaf1B3_1B1_2B4_1B6_Ref = object {
  _Leaf1B3_1B1_2B4_1B6
  scale 0.7
  rotate <0.0, 129.861984, 153.734085>
  translate  <-6.3286, 3.16017, 6.96054>
}
#declare _Leaf1B3_1B1_2B4_1B7_Ref = object {
  _Leaf1B3_1B1_2B4_1B7
  scale 0.7
  rotate <0.0, 101.731743, 32.099461>
  translate  <-6.33822, 3.26173, 6.97957>
}
#declare _Leaf1B3_1B1_2B4_1B8_Ref = object {
  _Leaf1B3_1B1_2B4_1B8
  scale 0.7
  rotate <0.0, 67.642303, 23.36912>
  translate  <-6.40897, 3.44755, 7.00247>
}
#declare _Leaf1B3_1B1_2B4_1B9_Ref = object {
  _Leaf1B3_1B1_2B4_1B9
  scale 0.7
  rotate <0.0, 126.948723, 196.375916>
  translate  <-6.42212, 3.44428, 6.98521>
}
#declare _Leaf1B3_1B1_2B4_1B10_Ref = object {
  _Leaf1B3_1B1_2B4_1B10
  scale 0.7
  rotate <0.0, 96.77269, 137.657837>
  translate  <-6.49663, 3.62858, 7.01002>
}
#declare _Leaf1B3_1B1_2B4_1B11_Ref = object {
  _Leaf1B3_1B1_2B4_1B11
  scale 0.7
  rotate <0.0, 51.758549, 142.729507>
  translate  <-6.49507, 3.6283, 7.01989>
}
#declare _Leaf1B3_1B1_2B4_1B12_Ref = object {
  _Leaf1B3_1B1_2B4_1B12
  scale 0.7
  rotate <0.0, 9.52247, 54.821869>
  translate  <-6.48625, 3.63116, 7.02364>
}
#declare _Leaf1B3_1B1_2B5_1B1_Ref = object {
  _Leaf1B3_1B1_2B5_1B1
  scale 0.7
  rotate <0.0, 92.158813, 132.105042>
  translate  <-6.53165, 2.4489, 6.97399>
}
#declare _Leaf1B3_1B1_2B5_1B2_Ref = object {
  _Leaf1B3_1B1_2B5_1B2
  scale 0.7
  rotate <0.0, 125.967941, 161.397934>
  translate  <-6.72652, 2.49542, 6.99572>
}
#declare _Leaf1B3_1B1_2B5_1B3_Ref = object {
  _Leaf1B3_1B1_2B5_1B3
  scale 0.7
  rotate <0.0, 33.14925, 80.042084>
  translate  <-6.81227, 2.52786, 7.05615>
}
#declare _Leaf1B3_1B1_2B5_1B4_Ref = object {
  _Leaf1B3_1B1_2B5_1B4
  scale 0.7
  rotate <0.0, 94.679298, 30.249701>
  translate  <-6.80756, 2.5461, 7.04478>
}
#declare _Leaf1B3_1B1_2B5_1B5_Ref = object {
  _Leaf1B3_1B1_2B5_1B5
  scale 0.7
  rotate <0.0, 118.0662, 245.190796>
  translate  <-6.91619, 2.54563, 7.04037>
}
#declare _Leaf1B3_1B1_2B5_1B6_Ref = object {
  _Leaf1B3_1B1_2B5_1B6
  scale 0.7
  rotate <0.0, 58.27137, 220.232971>
  translate  <-7.19061, 2.6495, 7.10571>
}
#declare _Leaf1B3_1B1_2B5_1B7_Ref = object {
  _Leaf1B3_1B1_2B5_1B7
  scale 0.7
  rotate <0.0, 158.951843, 178.212189>
  translate  <-7.28228, 2.69746, 7.09763>
}
#declare _Leaf1B3_1B1_2B5_1B8_Ref = object {
  _Leaf1B3_1B1_2B5_1B8
  scale 0.7
  rotate <0.0, 148.366943, 95.242661>
  translate  <-7.46513, 2.77072, 7.1331>
}
#declare _Leaf1B3_1B1_2B5_1B9_Ref = object {
  _Leaf1B3_1B1_2B5_1B9
  scale 0.7
  rotate <0.0, 44.190811, 259.434265>
  translate  <-7.46982, 2.75253, 7.14444>
}
#declare _Leaf1B3_1B1_2B5_1B10_Ref = object {
  _Leaf1B3_1B1_2B5_1B10
  scale 0.7
  rotate <0.0, 55.258389, 176.89241>
  translate  <-7.65154, 2.82692, 7.18412>
}
#declare _Leaf1B3_1B1_2B5_1B11_Ref = object {
  _Leaf1B3_1B1_2B5_1B11
  scale 0.7
  rotate <0.0, 53.76754, 120.517548>
  translate  <-7.64817, 2.83633, 7.18385>
}
#declare _Leaf1B3_1B1_2B5_1B12_Ref = object {
  _Leaf1B3_1B1_2B5_1B12
  scale 0.7
  rotate <0.0, 89.949699, 80.161049>
  translate  <-7.64784, 2.84128, 7.17517>
}
#declare _Leaf1B3_1B1_1B1_1B1_Ref = object {
  _Leaf1B3_1B1_1B1_1B1
  scale 0.7
  rotate <0.0, 129.963959, 123.799889>
  translate  <-3.54289, 1.3526, 6.0819>
}
#declare _Leaf1B3_1B1_1B1_1B2_Ref = object {
  _Leaf1B3_1B1_1B1_1B2
  scale 0.7
  rotate <0.0, 169.867523, 168.892487>
  translate  <-3.70028, 1.38159, 5.95941>
}
#declare _Leaf1B3_1B1_1B1_1B3_Ref = object {
  _Leaf1B3_1B1_1B1_1B3
  scale 0.7
  rotate <0.0, 57.720718, 121.395439>
  translate  <-3.80206, 1.41748, 5.93923>
}
#declare _Leaf1B3_1B1_1B1_1B4_Ref = object {
  _Leaf1B3_1B1_1B1_1B4
  scale 0.7
  rotate <0.0, 67.617828, 37.281658>
  translate  <-3.78978, 1.43306, 5.92971>
}
#declare _Leaf1B3_1B1_1B1_1B5_Ref = object {
  _Leaf1B3_1B1_1B1_1B5
  scale 0.7
  rotate <0.0, 112.728371, 268.393311>
  translate  <-3.86853, 1.41992, 5.85591>
}
#declare _Leaf1B3_1B1_1B1_1B6_Ref = object {
  _Leaf1B3_1B1_1B1_1B6
  scale 0.7
  rotate <0.0, 84.943443, 208.948471>
  translate  <-4.11024, 1.50576, 5.69917>
}
#declare _Leaf1B3_1B1_1B1_1B7_Ref = object {
  _Leaf1B3_1B1_1B1_1B7
  scale 0.7
  rotate <0.0, 155.229614, 325.083649>
  translate  <-4.17042, 1.54047, 5.62209>
}
#declare _Leaf1B3_1B1_1B1_1B8_Ref = object {
  _Leaf1B3_1B1_1B1_1B8
  scale 0.7
  rotate <0.0, 140.342255, 28.74555>
  translate  <-4.3259, 1.59975, 5.51087>
}
#declare _Leaf1B3_1B1_1B1_1B9_Ref = object {
  _Leaf1B3_1B1_1B1_1B9
  scale 0.7
  rotate <0.0, 53.269871, 219.899185>
  translate  <-4.33815, 1.58422, 5.52036>
}
#declare _Leaf1B3_1B1_1B1_1B10_Ref = object {
  _Leaf1B3_1B1_1B1_1B10
  scale 0.7
  rotate <0.0, 97.75901, 175.121353>
  translate  <-4.49547, 1.64568, 5.41262>
}
#declare _Leaf1B3_1B1_1B1_1B11_Ref = object {
  _Leaf1B3_1B1_1B1_1B11
  scale 0.7
  rotate <0.0, 90.522133, 130.288803>
  translate  <-4.4921, 1.65509, 5.41235>
}
#declare _Leaf1B3_1B1_1B1_1B12_Ref = object {
  _Leaf1B3_1B1_1B1_1B12
  scale 0.7
  rotate <0.0, 97.229881, 78.531349>
  translate  <-4.4858, 1.65794, 5.40513>
}
#declare _Leaf1B3_1B1_1B2_1B1_Ref = object {
  _Leaf1B3_1B1_1B2_1B1
  scale 0.7
  rotate <0.0, 29.945669, 95.370377>
  translate  <-3.843, 1.65731, 6.57055>
}
#declare _Leaf1B3_1B1_1B2_1B2_Ref = object {
  _Leaf1B3_1B1_1B2_1B2
  scale 0.7
  rotate <0.0, 64.197212, 56.584839>
  translate  <-3.88667, 1.83446, 6.65614>
}
#declare _Leaf1B3_1B1_1B2_1B3_Ref = object {
  _Leaf1B3_1B1_1B2_1B3
  scale 0.7
  rotate <0.0, 61.632061, 199.509537>
  translate  <-3.9566, 1.90454, 6.7036>
}
#declare _Leaf1B3_1B1_1B2_1B4_Ref = object {
  _Leaf1B3_1B1_1B2_1B4
  scale 0.7
  rotate <0.0, 71.780418, 280.216156>
  translate  <-3.94504, 1.89728, 6.72085>
}
#declare _Leaf1B3_1B1_1B2_1B5_Ref = object {
  _Leaf1B3_1B1_1B2_1B5
  scale 0.7
  rotate <0.0, 133.408905, 52.88554>
  translate  <-3.95259, 2.00337, 6.74339>
}
#declare _Leaf1B3_1B1_1B2_1B6_Ref = object {
  _Leaf1B3_1B1_1B2_1B6
  scale 0.7
  rotate <0.0, 114.825768, 130.227188>
  translate  <-4.04914, 2.24103, 6.90009>
}
#declare _Leaf1B3_1B1_1B2_1B7_Ref = object {
  _Leaf1B3_1B1_1B2_1B7
  scale 0.7
  rotate <0.0, 83.042747, 26.550541>
  translate  <-4.05186, 2.32072, 6.9665>
}
#declare _Leaf1B3_1B1_1B2_1B8_Ref = object {
  _Leaf1B3_1B1_1B2_1B8
  scale 0.7
  rotate <0.0, 56.49371, 1.66015>
  translate  <-4.10824, 2.47906, 7.07517>
}
#declare _Leaf1B3_1B1_1B2_1B9_Ref = object {
  _Leaf1B3_1B1_1B2_1B9
  scale 0.7
  rotate <0.0, 132.012543, 164.761978>
  translate  <-4.11976, 2.4863, 7.05797>
}
#declare _Leaf1B3_1B1_1B2_1B10_Ref = object {
  _Leaf1B3_1B1_1B2_1B10
  scale 0.7
  rotate <0.0, 78.772423, 132.062531>
  translate  <-4.18022, 2.64287, 7.16735>
}
#declare _Leaf1B3_1B1_1B2_1B11_Ref = object {
  _Leaf1B3_1B1_1B2_1B11
  scale 0.7
  rotate <0.0, 42.01783, 163.65889>
  translate  <-4.17972, 2.63762, 7.17585>
}
#declare _Leaf1B3_1B1_1B2_1B12_Ref = object {
  _Leaf1B3_1B1_1B2_1B12
  scale 0.7
  rotate <0.0, 22.080111, 270.585632>
  translate  <-4.17112, 2.63715, 7.18094>
}
#declare _Leaf1B3_1B1_1B3_1B1_Ref = object {
  _Leaf1B3_1B1_1B3_1B1
  scale 0.7
  rotate <0.0, 83.600014, 225.043015>
  translate  <-4.17334, 1.33803, 6.59573>
}
#declare _Leaf1B3_1B1_1B3_1B2_Ref = object {
  _Leaf1B3_1B1_1B3_1B2
  scale 0.7
  rotate <0.0, 61.222832, 264.366486>
  translate  <-4.30051, 1.25217, 6.72637>
}
#declare _Leaf1B3_1B1_1B3_1B3_Ref = object {
  _Leaf1B3_1B1_1B3_1B3
  scale 0.7
  rotate <0.0, 113.88829, 157.667633>
  translate  <-4.39817, 1.24489, 6.77603>
}
#declare _Leaf1B3_1B1_1B3_1B4_Ref = object {
  _Leaf1B3_1B1_1B3_1B4
  scale 0.7
  rotate <0.0, 172.152634, 357.227112>
  translate  <-4.39908, 1.22818, 6.76175>
}
#declare _Leaf1B3_1B1_1B3_1B5_Ref = object {
  _Leaf1B3_1B1_1B3_1B5
  scale 0.7
  rotate <0.0, 39.110001, 356.438019>
  translate  <-4.4432, 1.18302, 6.85026>
}
#declare _Leaf1B3_1B1_1B3_1B6_Ref = object {
  _Leaf1B3_1B1_1B3_1B6
  scale 0.7
  rotate <0.0, 32.942959, 125.930199>
  translate  <-4.66849, 1.06603, 7.01125>
}
#declare _Leaf1B3_1B1_1B3_1B7_Ref = object {
  _Leaf1B3_1B1_1B3_1B7
  scale 0.7
  rotate <0.0, 72.537811, 299.718506>
  translate  <-4.73115, 0.99764, 7.05778>
}
#declare _Leaf1B3_1B1_1B3_1B8_Ref = object {
  _Leaf1B3_1B1_1B3_1B8
  scale 0.7
  rotate <0.0, 104.605911, 285.133728>
  translate  <-4.87815, 0.91152, 7.16282>
}
#declare _Leaf1B3_1B1_1B3_1B9_Ref = object {
  _Leaf1B3_1B1_1B3_1B9
  scale 0.7
  rotate <0.0, 60.5177, 99.388229>
  translate  <-4.87724, 0.92819, 7.17707>
}
#declare _Leaf1B3_1B1_1B3_1B10_Ref = object {
  _Leaf1B3_1B1_1B3_1B10
  scale 0.7
  rotate <0.0, 50.904652, 174.586029>
  translate  <-5.02728, 0.84494, 7.28047>
}
#declare _Leaf1B3_1B1_1B3_1B11_Ref = object {
  _Leaf1B3_1B1_1B3_1B11
  scale 0.7
  rotate <0.0, 94.76178, 186.688873>
  translate  <-5.03116, 0.84079, 7.27224>
}
#declare _Leaf1B3_1B1_1B3_1B12_Ref = object {
  _Leaf1B3_1B1_1B3_1B12
  scale 0.7
  rotate <0.0, 135.567459, 223.859955>
  translate  <-5.028, 0.83179, 7.26922>
}
#declare _Leaf1B3_1B2_2B1_1B1_Ref = object {
  _Leaf1B3_1B2_2B1_1B1
  scale 0.7
  rotate <0.0, 36.552952, 326.128296>
  translate  <-3.91055, 0.15954, 8.49964>
}
#declare _Leaf1B3_1B2_2B1_1B2_Ref = object {
  _Leaf1B3_1B2_2B1_1B2
  scale 0.7
  rotate <0.0, 54.475479, 23.58894>
  translate  <-3.87737, 0.18967, 8.69612>
}
#declare _Leaf1B3_1B2_2B1_1B3_Ref = object {
  _Leaf1B3_1B2_2B1_1B3
  scale 0.7
  rotate <0.0, 70.653069, 240.034485>
  translate  <-3.90066, 0.17269, 8.80206>
}
#declare _Leaf1B3_1B2_2B1_1B4_Ref = object {
  _Leaf1B3_1B2_2B1_1B4
  scale 0.7
  rotate <0.0, 131.649643, 284.437897>
  translate  <-3.88269, 0.16031, 8.79932>
}
#declare _Leaf1B3_1B2_2B1_1B5_Ref = object {
  _Leaf1B3_1B2_2B1_1B5
  scale 0.7
  rotate <0.0, 92.234756, 86.033737>
  translate  <-3.86286, 0.20552, 8.89619>
}
#declare _Leaf1B3_1B2_2B1_1B6_Ref = object {
  _Leaf1B3_1B2_2B1_1B6
  scale 0.7
  rotate <0.0, 53.092258, 141.195984>
  translate  <-3.82728, 0.20236, 9.19466>
}
#declare _Leaf1B3_1B2_2B1_1B7_Ref = object {
  _Leaf1B3_1B2_2B1_1B7
  scale 0.7
  rotate <0.0, 88.150047, 30.43749>
  translate  <-3.78321, 0.20231, 9.2886>
}
#declare _Leaf1B3_1B2_2B1_1B8_Ref = object {
  _Leaf1B3_1B2_2B1_1B8
  scale 0.7
  rotate <0.0, 94.579788, 355.854645>
  translate  <-3.75059, 0.20008, 9.48606>
}
#declare _Leaf1B3_1B2_2B1_1B9_Ref = object {
  _Leaf1B3_1B2_2B1_1B9
  scale 0.7
  rotate <0.0, 81.338669, 160.491516>
  translate  <-3.76852, 0.21243, 9.4888>
}
#declare _Leaf1B3_1B2_2B1_1B10_Ref = object {
  _Leaf1B3_1B2_2B1_1B10
  scale 0.7
  rotate <0.0, 20.53347, 170.053345>
  translate  <-3.73913, 0.20714, 9.68689>
}
#declare _Leaf1B3_1B2_2B1_1B11_Ref = object {
  _Leaf1B3_1B2_2B1_1B11
  scale 0.7
  rotate <0.0, 41.080509, 260.555054>
  translate  <-3.73481, 0.19813, 9.6864>
}
#declare _Leaf1B3_1B2_2B1_1B12_Ref = object {
  _Leaf1B3_1B2_2B1_1B12
  scale 0.7
  rotate <0.0, 82.967178, 297.254791>
  translate  <-3.72498, 0.19739, 9.68473>
}
#declare _Leaf1B3_1B2_2B2_1B1_Ref = object {
  _Leaf1B3_1B2_2B2_1B1
  scale 0.7
  rotate <0.0, 90.99498, 255.809464>
  translate  <-4.22773, -0.23873, 8.62308>
}
#declare _Leaf1B3_1B2_2B2_1B2_Ref = object {
  _Leaf1B3_1B2_2B2_1B2
  scale 0.7
  rotate <0.0, 96.623154, 298.884521>
  translate  <-4.21178, -0.41396, 8.72133>
}
#declare _Leaf1B3_1B2_2B2_1B3_Ref = object {
  _Leaf1B3_1B2_2B2_1B3
  scale 0.7
  rotate <0.0, 74.204941, 184.551743>
  translate  <-4.24775, -0.4879, 8.7941>
}
#declare _Leaf1B3_1B2_2B2_1B4_Ref = object {
  _Leaf1B3_1B2_2B2_1B4
  scale 0.7
  rotate <0.0, 139.598465, 146.455627>
  translate  <-4.2532, -0.49731, 8.77498>
}
#declare _Leaf1B3_1B2_2B2_1B5_Ref = object {
  _Leaf1B3_1B2_2B2_1B5
  scale 0.7
  rotate <0.0, 75.15799, 5.36988>
  translate  <-4.21572, -0.5827, 8.83089>
}
#declare _Leaf1B3_1B2_2B2_1B6_Ref = object {
  _Leaf1B3_1B2_2B2_1B6
  scale 0.7
  rotate <0.0, 12.17088, 339.017395>
  translate  <-4.24223, -0.84516, 8.97502>
}
#declare _Leaf1B3_1B2_2B2_1B7_Ref = object {
  _Leaf1B3_1B2_2B2_1B7
  scale 0.7
  rotate <0.0, 117.254929, 327.71701>
  translate  <-4.23899, -0.94671, 8.99611>
}
#declare _Leaf1B3_1B2_2B2_1B8_Ref = object {
  _Leaf1B3_1B2_2B2_1B8
  scale 0.7
  rotate <0.0, 144.405304, 297.098755>
  translate  <-4.2537, -1.12561, 9.08463>
}
#declare _Leaf1B3_1B2_2B2_1B9_Ref = object {
  _Leaf1B3_1B2_2B2_1B9
  scale 0.7
  rotate <0.0, 26.7784, 91.402061>
  translate  <-4.24826, -1.11622, 9.1037>
}
#declare _Leaf1B3_1B2_2B2_1B10_Ref = object {
  _Leaf1B3_1B2_2B2_1B10
  scale 0.7
  rotate <0.0, 35.180901, 253.288605>
  translate  <-4.26697, -1.29408, 9.19398>
}
#declare _Leaf1B3_1B2_2B2_1B11_Ref = object {
  _Leaf1B3_1B2_2B2_1B11
  scale 0.7
  rotate <0.0, 72.561508, 219.896057>
  translate  <-4.27396, -1.29707, 9.18749>
}
#declare _Leaf1B3_1B2_2B2_1B12_Ref = object {
  _Leaf1B3_1B2_2B2_1B12
  scale 0.7
  rotate <0.0, 124.171204, 212.931854>
  translate  <-4.27127, -1.30149, 9.17893>
}
#declare _Leaf1B3_1B2_2B3_1B1_Ref = object {
  _Leaf1B3_1B2_2B3_1B1
  scale 0.7
  rotate <0.0, 47.718102, 109.55175>
  translate  <-4.7441, 0.01475, 9.13105>
}
#declare _Leaf1B3_1B2_2B3_1B2_Ref = object {
  _Leaf1B3_1B2_2B3_1B2
  scale 0.7
  rotate <0.0, 90.968338, 112.36261>
  translate  <-4.89766, 0.11397, 9.21584>
}
#declare _Leaf1B3_1B2_2B3_1B3_Ref = object {
  _Leaf1B3_1B2_2B3_1B3
  scale 0.7
  rotate <0.0, 24.822861, 279.915619>
  translate  <-4.97461, 0.12553, 9.2933>
}
#declare _Leaf1B3_1B2_2B3_1B4_Ref = object {
  _Leaf1B3_1B2_2B3_1B4
  scale 0.7
  rotate <0.0, 79.559067, 353.156433>
  translate  <-4.95955, 0.14026, 9.29963>
}
#declare _Leaf1B3_1B2_2B3_1B5_Ref = object {
  _Leaf1B3_1B2_2B3_1B5
  scale 0.7
  rotate <0.0, 146.856186, 163.98349>
  translate  <-5.0517, 0.19544, 9.31646>
}
#declare _Leaf1B3_1B2_2B3_1B6_Ref = object {
  _Leaf1B3_1B2_2B3_1B6
  scale 0.7
  rotate <0.0, 89.231987, 199.634018>
  translate  <-5.26145, 0.32739, 9.48661>
}
#declare _Leaf1B3_1B2_2B3_1B7_Ref = object {
  _Leaf1B3_1B2_2B3_1B7
  scale 0.7
  rotate <0.0, 119.508583, 92.438103>
  translate  <-5.31733, 0.39987, 9.53553>
}
#declare _Leaf1B3_1B2_2B3_1B8_Ref = object {
  _Leaf1B3_1B2_2B3_1B8
  scale 0.7
  rotate <0.0, 96.003479, 64.715393>
  translate  <-5.45306, 0.49568, 9.64714>
}
#declare _Leaf1B3_1B2_2B3_1B9_Ref = object {
  _Leaf1B3_1B2_2B3_1B9
  scale 0.7
  rotate <0.0, 94.065147, 232.530396>
  translate  <-5.46809, 0.48099, 9.64082>
}
#declare _Leaf1B3_1B2_2B3_1B10_Ref = object {
  _Leaf1B3_1B2_2B3_1B10
  scale 0.7
  rotate <0.0, 57.956219, 180.532715>
  translate  <-5.60358, 0.57367, 9.75566>
}
#declare _Leaf1B3_1B2_2B3_1B11_Ref = object {
  _Leaf1B3_1B2_2B3_1B11
  scale 0.7
  rotate <0.0, 13.81033, 159.335571>
  translate  <-5.59659, 0.57666, 9.76216>
}
#declare _Leaf1B3_1B2_2B3_1B12_Ref = object {
  _Leaf1B3_1B2_2B3_1B12
  scale 0.7
  rotate <0.0, 43.027771, 33.787392>
  translate  <-5.59172, 0.58526, 9.76065>
}
#declare _Leaf1B3_1B2_2B4_1B1_Ref = object {
  _Leaf1B3_1B2_2B4_1B1
  scale 0.7
  rotate <0.0, 98.504837, 176.535019>
  translate  <-4.94722, -0.32052, 9.10277>
}
#declare _Leaf1B3_1B2_2B4_1B2_Ref = object {
  _Leaf1B3_1B2_2B4_1B2
  scale 0.7
  rotate <0.0, 135.503204, 202.727127>
  translate  <-5.11801, -0.42666, 9.08933>
}
#declare _Leaf1B3_1B2_2B4_1B3_Ref = object {
  _Leaf1B3_1B2_2B4_1B3
  scale 0.7
  rotate <0.0, 31.94895, 141.764236>
  translate  <-5.20764, -0.47206, 9.13361>
}
#declare _Leaf1B3_1B2_2B4_1B4_Ref = object {
  _Leaf1B3_1B2_2B4_1B4
  scale 0.7
  rotate <0.0, 85.16568, 75.473686>
  translate  <-5.216, -0.45436, 9.12356>
}
#declare _Leaf1B3_1B2_2B4_1B5_Ref = object {
  _Leaf1B3_1B2_2B4_1B5
  scale 0.7
  rotate <0.0, 122.830269, 295.954742>
  translate  <-5.2905, -0.52978, 9.09943>
}
#declare _Leaf1B3_1B2_2B4_1B6_Ref = object {
  _Leaf1B3_1B2_2B4_1B6
  scale 0.7
  rotate <0.0, 67.020683, 262.397614>
  translate  <-5.56234, -0.65712, 9.11524>
}
#declare _Leaf1B3_1B2_2B4_1B7_Ref = object {
  _Leaf1B3_1B2_2B4_1B7
  scale 0.7
  rotate <0.0, 169.353714, 217.17952>
  translate  <-5.65905, -0.68614, 9.09132>
}
#declare _Leaf1B3_1B2_2B4_1B8_Ref = object {
  _Leaf1B3_1B2_2B4_1B8
  scale 0.7
  rotate <0.0, 146.918625, 123.881721>
  translate  <-5.84212, -0.76701, 9.09398>
}
#declare _Leaf1B3_1B2_2B4_1B9_Ref = object {
  _Leaf1B3_1B2_2B4_1B9
  scale 0.7
  rotate <0.0, 47.834728, 295.064758>
  translate  <-5.83378, -0.78466, 9.104>
}
#declare _Leaf1B3_1B2_2B4_1B10_Ref = object {
  _Leaf1B3_1B2_2B4_1B10
  scale 0.7
  rotate <0.0, 65.70488, 222.887833>
  translate  <-6.01736, -0.86455, 9.11102>
}
#declare _Leaf1B3_1B2_2B4_1B11_Ref = object {
  _Leaf1B3_1B2_2B4_1B11
  scale 0.7
  rotate <0.0, 58.869709, 171.905319>
  translate  <-6.02168, -0.85554, 9.11152>
}
#declare _Leaf1B3_1B2_2B4_1B12_Ref = object {
  _Leaf1B3_1B2_2B4_1B12
  scale 0.7
  rotate <0.0, 87.310829, 125.623497>
  translate  <-6.02394, -0.85061, 9.10312>
}
#declare _Leaf1B3_1B2_2B5_1B1_Ref = object {
  _Leaf1B3_1B2_2B5_1B1
  scale 0.7
  rotate <0.0, 70.011719, 216.648743>
  translate  <-5.01907, -0.41935, 9.55756>
}
#declare _Leaf1B3_1B2_2B5_1B2_Ref = object {
  _Leaf1B3_1B2_2B5_1B2
  scale 0.7
  rotate <0.0, 59.900841, 263.498474>
  translate  <-5.11293, -0.48492, 9.7234>
}
#declare _Leaf1B3_1B2_2B5_1B3_Ref = object {
  _Leaf1B3_1B2_2B5_1B3
  scale 0.7
  rotate <0.0, 97.120331, 148.479904>
  translate  <-5.18954, -0.47559, 9.8015>
}
#declare _Leaf1B3_1B2_2B5_1B4_Ref = object {
  _Leaf1B3_1B2_2B5_1B4
  scale 0.7
  rotate <0.0, 169.305893, 177.040817>
  translate  <-5.1981, -0.4912, 9.78858>
}
#declare _Leaf1B3_1B2_2B5_1B5_Ref = object {
  _Leaf1B3_1B2_2B5_1B5
  scale 0.7
  rotate <0.0, 57.458981, 346.90097>
  translate  <-5.2201, -0.53085, 9.8874>
}
#declare _Leaf1B3_1B2_2B5_1B6_Ref = object {
  _Leaf1B3_1B2_2B5_1B6
  scale 0.7
  rotate <0.0, 27.384199, 83.508118>
  translate  <-5.40167, -0.60958, 10.11366>
}
#declare _Leaf1B3_1B2_2B5_1B7_Ref = object {
  _Leaf1B3_1B2_2B5_1B7
  scale 0.7
  rotate <0.0, 81.256073, 292.18335>
  translate  <-5.45857, -0.66672, 10.17897>
}
#declare _Leaf1B3_1B2_2B5_1B8_Ref = object {
  _Leaf1B3_1B2_2B5_1B8
  scale 0.7
  rotate <0.0, 107.463081, 268.480804>
  translate  <-5.57894, -0.72769, 10.3268>
}
#declare _Leaf1B3_1B2_2B5_1B9_Ref = object {
  _Leaf1B3_1B2_2B5_1B9
  scale 0.7
  rotate <0.0, 60.376209, 77.453613>
  translate  <-5.5704, -0.71212, 10.33969>
}
#declare _Leaf1B3_1B2_2B5_1B10_Ref = object {
  _Leaf1B3_1B2_2B5_1B10
  scale 0.7
  rotate <0.0, 32.77533, 159.224838>
  translate  <-5.69355, -0.76962, 10.48686>
}
#declare _Leaf1B3_1B2_2B5_1B11_Ref = object {
  _Leaf1B3_1B2_2B5_1B11
  scale 0.7
  rotate <0.0, 76.33075, 175.40271>
  translate  <-5.70054, -0.77262, 10.48036>
}
#declare _Leaf1B3_1B2_2B5_1B12_Ref = object {
  _Leaf1B3_1B2_2B5_1B12
  scale 0.7
  rotate <0.0, 120.533218, 203.940887>
  translate  <-5.7003, -0.78191, 10.47669>
}
#declare _Leaf1B3_1B2_1B1_1B1_Ref = object {
  _Leaf1B3_1B2_1B1_1B1
  scale 0.7
  rotate <0.0, 87.467621, 251.870743>
  translate  <-2.98113, 0.27069, 7.04737>
}
#declare _Leaf1B3_1B2_1B1_1B2_Ref = object {
  _Leaf1B3_1B2_1B1_1B2
  scale 0.7
  rotate <0.0, 92.072258, 294.962036>
  translate  <-2.98016, 0.10255, 7.15847>
}
#declare _Leaf1B3_1B2_1B1_1B3_Ref = object {
  _Leaf1B3_1B2_1B1_1B3
  scale 0.7
  rotate <0.0, 75.85183, 179.51384>
  translate  <-3.02323, 0.03678, 7.23511>
}
#declare _Leaf1B3_1B2_1B1_1B4_Ref = object {
  _Leaf1B3_1B2_1B1_1B4
  scale 0.7
  rotate <0.0, 143.430771, 145.671371>
  translate  <-3.02877, 0.02636, 7.21654>
}
#declare _Leaf1B3_1B2_1B1_1B5_Ref = object {
  _Leaf1B3_1B2_1B1_1B5
  scale 0.7
  rotate <0.0, 73.659721, 2.67264>
  translate  <-2.9989, -0.05696, 7.27969>
}
#declare _Leaf1B3_1B2_1B1_1B6_Ref = object {
  _Leaf1B3_1B2_1B1_1B6
  scale 0.7
  rotate <0.0, 9.42116, 354.456146>
  translate  <-3.04761, -0.30566, 7.44135>
}
#declare _Leaf1B3_1B2_1B1_1B7_Ref = object {
  _Leaf1B3_1B2_1B1_1B7
  scale 0.7
  rotate <0.0, 113.386787, 322.672852>
  translate  <-3.052, -0.40536, 7.4698>
}
#declare _Leaf1B3_1B2_1B1_1B8_Ref = object {
  _Leaf1B3_1B2_1B1_1B8
  scale 0.7
  rotate <0.0, 139.847137, 293.008057>
  translate  <-3.08157, -0.57583, 7.57042>
}
#declare _Leaf1B3_1B2_1B1_1B9_Ref = object {
  _Leaf1B3_1B2_1B1_1B9
  scale 0.7
  rotate <0.0, 31.00345, 90.623817>
  translate  <-3.07605, -0.56543, 7.58894>
}
#declare _Leaf1B3_1B2_1B1_1B10_Ref = object {
  _Leaf1B3_1B2_1B1_1B10
  scale 0.7
  rotate <0.0, 31.91065, 244.584824>
  translate  <-3.10959, -0.73446, 7.69111>
}
#declare _Leaf1B3_1B2_1B1_1B11_Ref = object {
  _Leaf1B3_1B2_1B1_1B11
  scale 0.7
  rotate <0.0, 71.454712, 214.558472>
  translate  <-3.11657, -0.73745, 7.68461>
}
#declare _Leaf1B3_1B2_1B1_1B12_Ref = object {
  _Leaf1B3_1B2_1B1_1B12
  scale 0.7
  rotate <0.0, 123.433617, 212.047058>
  translate  <-3.11395, -0.74267, 7.67649>
}
#declare _Leaf1B3_1B2_1B2_1B1_Ref = object {
  _Leaf1B3_1B2_1B2_1B1
  scale 0.7
  rotate <0.0, 88.529457, 149.072098>
  translate  <-3.54714, 0.45935, 7.30378>
}
#declare _Leaf1B3_1B2_1B2_1B2_Ref = object {
  _Leaf1B3_1B2_1B2_1B2
  scale 0.7
  rotate <0.0, 129.918457, 163.067596>
  translate  <-3.74796, 0.44421, 7.29635>
}
#declare _Leaf1B3_1B2_1B2_1B3_Ref = object {
  _Leaf1B3_1B2_1B2_1B3
  scale 0.7
  rotate <0.0, 17.7859, 125.541969>
  translate  <-3.84608, 0.43224, 7.34414>
}
#declare _Leaf1B3_1B2_1B2_1B4_Ref = object {
  _Leaf1B3_1B2_1B2_1B4
  scale 0.7
  rotate <0.0, 76.272072, 46.7267>
  translate  <-3.84595, 0.45371, 7.33935>
}
#declare _Leaf1B3_1B2_1B2_1B5_Ref = object {
  _Leaf1B3_1B2_1B2_1B5
  scale 0.7
  rotate <0.0, 137.333145, 266.221771>
  translate  <-3.94774, 0.42648, 7.31255>
}
#declare _Leaf1B3_1B2_1B2_1B6_Ref = object {
  _Leaf1B3_1B2_1B2_1B6
  scale 0.7
  rotate <0.0, 77.782654, 238.924042>
  translate  <-4.24656, 0.42906, 7.3451>
}
#declare _Leaf1B3_1B2_1B2_1B7_Ref = object {
  _Leaf1B3_1B2_1B2_1B7
  scale 0.7
  rotate <0.0, 161.622513, 137.118607>
  translate  <-4.34694, 0.45154, 7.33143>
}
#declare _Leaf1B3_1B2_1B2_1B8_Ref = object {
  _Leaf1B3_1B2_1B2_1B8
  scale 0.7
  rotate <0.0, 132.038315, 98.205498>
  translate  <-4.54635, 0.45951, 7.34663>
}
#declare _Leaf1B3_1B2_1B2_1B9_Ref = object {
  _Leaf1B3_1B2_1B2_1B9
  scale 0.7
  rotate <0.0, 62.429722, 270.440369>
  translate  <-4.54648, 0.4381, 7.35141>
}
#declare _Leaf1B3_1B2_1B2_1B10_Ref = object {
  _Leaf1B3_1B2_1B2_1B10
  scale 0.7
  rotate <0.0, 67.807617, 202.491074>
  translate  <-4.74569, 0.44606, 7.37111>
}
#declare _Leaf1B3_1B2_1B2_1B11_Ref = object {
  _Leaf1B3_1B2_1B2_1B11
  scale 0.7
  rotate <0.0, 48.82756, 153.269608>
  translate  <-4.74539, 0.4556, 7.3741>
}
#declare _Leaf1B3_1B2_1B2_1B12_Ref = object {
  _Leaf1B3_1B2_1B2_1B12
  scale 0.7
  rotate <0.0, 72.415787, 98.732071>
  translate  <-4.74558, 0.46297, 7.36733>
}
#declare _Leaf1B3_1B2_1B3_1B1_Ref = object {
  _Leaf1B3_1B2_1B3_1B1
  scale 0.7
  rotate <0.0, 23.85371, 22.02285>
  translate  <-3.3669, 0.5028, 7.72487>
}
#declare _Leaf1B3_1B2_1B3_1B2_Ref = object {
  _Leaf1B3_1B2_1B3_1B2
  scale 0.7
  rotate <0.0, 61.364529, 57.462379>
  translate  <-3.38866, 0.60676, 7.89614>
}
#declare _Leaf1B3_1B2_1B3_1B3_Ref = object {
  _Leaf1B3_1B2_1B3_1B3
  scale 0.7
  rotate <0.0, 54.870338, 249.892014>
  translate  <-3.42934, 0.61941, 7.99734>
}
#declare _Leaf1B3_1B2_1B3_1B4_Ref = object {
  _Leaf1B3_1B2_1B3_1B4
  scale 0.7
  rotate <0.0, 107.805107, 303.72934>
  translate  <-3.40845, 0.6139, 8.00149>
}
#declare _Leaf1B3_1B2_1B3_1B5_Ref = object {
  _Leaf1B3_1B2_1B3_1B5
  scale 0.7
  rotate <0.0, 114.765984, 103.392906>
  translate  <-3.42458, 0.69293, 8.07439>
}
#declare _Leaf1B3_1B2_1B3_1B6_Ref = object {
  _Leaf1B3_1B2_1B3_1B6
  scale 0.7
  rotate <0.0, 73.128014, 153.731964>
  translate  <-3.45754, 0.80288, 8.35221>
}
#declare _Leaf1B3_1B2_1B3_1B7_Ref = object {
  _Leaf1B3_1B2_1B3_1B7
  scale 0.7
  rotate <0.0, 94.687202, 49.148102>
  translate  <-3.43755, 0.84975, 8.44261>
}
#declare _Leaf1B3_1B2_1B3_1B8_Ref = object {
  _Leaf1B3_1B2_1B3_1B8
  scale 0.7
  rotate <0.0, 86.817932, 14.86261>
  translate  <-3.45085, 0.92553, 8.62738>
}
#declare _Leaf1B3_1B2_1B3_1B9_Ref = object {
  _Leaf1B3_1B2_1B3_1B9
  scale 0.7
  rotate <0.0, 94.906853, 179.12381>
  translate  <-3.47169, 0.93102, 8.62323>
}
#declare _Leaf1B3_1B2_1B3_1B10_Ref = object {
  _Leaf1B3_1B2_1B3_1B10
  scale 0.7
  rotate <0.0, 37.064919, 155.746704>
  translate  <-3.48728, 1.00321, 8.80946>
}
#declare _Leaf1B3_1B2_1B3_1B11_Ref = object {
  _Leaf1B3_1B2_1B3_1B11
  scale 0.7
  rotate <0.0, 21.201839, 256.337524>
  translate  <-3.48058, 0.99666, 8.81297>
}
#declare _Leaf1B3_1B2_1B3_1B12_Ref = object {
  _Leaf1B3_1B2_1B3_1B12
  scale 0.7
  rotate <0.0, 59.785801, 318.48291>
  translate  <-3.47083, 0.99887, 8.81273>
}
#declare _Leaf1B3_1B3_2B1_1B1_Ref = object {
  _Leaf1B3_1B3_2B1_1B1
  scale 0.7
  rotate <0.0, 104.158768, 86.94268>
  translate  <-3.2136, 2.89089, 8.10854>
}
#declare _Leaf1B3_1B3_2B1_1B2_Ref = object {
  _Leaf1B3_1B3_2B1_1B2
  scale 0.7
  rotate <0.0, 137.523148, 120.274857>
  translate  <-3.31915, 3.06163, 8.09061>
}
#declare _Leaf1B3_1B3_2B1_1B3_Ref = object {
  _Leaf1B3_1B3_2B1_1B3
  scale 0.7
  rotate <0.0, 39.9519, 49.133709>
  translate  <-3.35879, 3.15575, 8.13093>
}
#declare _Leaf1B3_1B3_2B1_1B4_Ref = object {
  _Leaf1B3_1B3_2B1_1B4
  scale 0.7
  rotate <0.0, 89.754379, 345.009369>
  translate  <-3.3422, 3.16284, 8.11832>
}
#declare _Leaf1B3_1B3_2B1_1B5_Ref = object {
  _Leaf1B3_1B3_2B1_1B5
  scale 0.7
  rotate <0.0, 114.979912, 206.332474>
  translate  <-3.41916, 3.23617, 8.09551>
}
#declare _Leaf1B3_1B3_2B1_1B6_Ref = object {
  _Leaf1B3_1B3_2B1_1B6
  scale 0.7
  rotate <0.0, 61.83374, 168.641083>
  translate  <-3.54181, 3.51058, 8.09938>
}
#declare _Leaf1B3_1B3_2B1_1B7_Ref = object {
  _Leaf1B3_1B3_2B1_1B7
  scale 0.7
  rotate <0.0, 167.107147, 164.791183>
  translate  <-3.57243, 3.60521, 8.06978>
}
#declare _Leaf1B3_1B3_2B1_1B8_Ref = object {
  _Leaf1B3_1B3_2B1_1B8
  scale 0.7
  rotate <0.0, 154.947845, 30.977579>
  translate  <-3.65103, 3.78919, 8.06397>
}
#declare _Leaf1B3_1B3_2B1_1B9_Ref = object {
  _Leaf1B3_1B3_2B1_1B9
  scale 0.7
  rotate <0.0, 40.089291, 201.777771>
  translate  <-3.66757, 3.78212, 8.07654>
}
#declare _Leaf1B3_1B3_2B1_1B10_Ref = object {
  _Leaf1B3_1B3_2B1_1B10
  scale 0.7
  rotate <0.0, 65.730362, 128.458115>
  translate  <-3.74472, 3.967, 8.07489>
}
#declare _Leaf1B3_1B3_2B1_1B11_Ref = object {
  _Leaf1B3_1B3_2B1_1B11
  scale 0.7
  rotate <0.0, 65.155151, 78.406868>
  translate  <-3.73567, 3.97118, 8.07403>
}
#declare _Leaf1B3_1B3_2B1_1B12_Ref = object {
  _Leaf1B3_1B3_2B1_1B12
  scale 0.7
  rotate <0.0, 95.387039, 34.842869>
  translate  <-3.73166, 3.97258, 8.06497>
}
#declare _Leaf1B3_1B3_2B2_1B1_Ref = object {
  _Leaf1B3_1B3_2B2_1B1
  scale 0.7
  rotate <0.0, 55.31995, 21.05788>
  translate  <-3.01512, 3.07098, 8.55869>
}
#declare _Leaf1B3_1B3_2B2_1B2_Ref = object {
  _Leaf1B3_1B3_2B2_1B2
  scale 0.7
  rotate <0.0, 98.643494, 21.37842>
  translate  <-2.9061, 3.22983, 8.61782>
}
#declare _Leaf1B3_1B3_2B2_1B3_Ref = object {
  _Leaf1B3_1B3_2B2_1B3
  scale 0.7
  rotate <0.0, 18.35042, 176.594055>
  translate  <-2.88565, 3.31333, 8.68611>
}
#declare _Leaf1B3_1B3_2B2_1B4_Ref = object {
  _Leaf1B3_1B3_2B2_1B4
  scale 0.7
  rotate <0.0, 73.578667, 263.708008>
  translate  <-2.87046, 3.29865, 8.69222>
}
#declare _Leaf1B3_1B3_2B2_1B5_Ref = object {
  _Leaf1B3_1B3_2B2_1B5
  scale 0.7
  rotate <0.0, 153.358185, 81.741226>
  translate  <-2.81303, 3.39094, 8.69444>
}
#declare _Leaf1B3_1B3_2B2_1B6_Ref = object {
  _Leaf1B3_1B3_2B2_1B6
  scale 0.7
  rotate <0.0, 92.217293, 108.967758>
  translate  <-2.66183, 3.61296, 8.82936>
}
#declare _Leaf1B3_1B3_2B2_1B7_Ref = object {
  _Leaf1B3_1B3_2B2_1B7
  scale 0.7
  rotate <0.0, 125.68792, 358.300964>
  translate  <-2.58406, 3.67176, 8.86491>
}
#declare _Leaf1B3_1B3_2B2_1B8_Ref = object {
  _Leaf1B3_1B3_2B2_1B8
  scale 0.7
  rotate <0.0, 99.176743, 332.956299>
  translate  <-2.4757, 3.81538, 8.9526>
}
#declare _Leaf1B3_1B3_2B2_1B9_Ref = object {
  _Leaf1B3_1B3_2B2_1B9
  scale 0.7
  rotate <0.0, 92.441406, 142.221237>
  translate  <-2.49086, 3.83003, 8.9465>
}
#declare _Leaf1B3_1B3_2B2_1B10_Ref = object {
  _Leaf1B3_1B3_2B2_1B10
  scale 0.7
  rotate <0.0, 63.43412, 86.400391>
  translate  <-2.38527, 3.97376, 9.03775>
}
#declare _Leaf1B3_1B3_2B2_1B11_Ref = object {
  _Leaf1B3_1B3_2B2_1B11
  scale 0.7
  rotate <0.0, 21.30756, 58.497009>
  translate  <-2.38165, 3.96735, 9.04451>
}
#declare _Leaf1B3_1B3_2B2_1B12_Ref = object {
  _Leaf1B3_1B3_2B2_1B12
  scale 0.7
  rotate <0.0, 42.59251, 311.7966>
  translate  <-2.3733, 3.9622, 9.04256>
}
#declare _Leaf1B3_1B3_2B3_1B1_Ref = object {
  _Leaf1B3_1B3_2B3_1B1
  scale 0.7
  rotate <0.0, 86.393356, 164.894882>
  translate  <-3.59835, 3.28658, 9.00846>
}
#declare _Leaf1B3_1B3_2B3_1B2_Ref = object {
  _Leaf1B3_1B3_2B3_1B2
  scale 0.7
  rotate <0.0, 88.694008, 208.203094>
  translate  <-3.76214, 3.28289, 9.12582>
}
#declare _Leaf1B3_1B3_2B3_1B3_Ref = object {
  _Leaf1B3_1B3_2B3_1B3
  scale 0.7
  rotate <0.0, 79.144661, 92.261253>
  translate  <-3.82753, 3.32671, 9.20236>
}
#declare _Leaf1B3_1B3_2B3_1B4_Ref = object {
  _Leaf1B3_1B3_2B3_1B4
  scale 0.7
  rotate <0.0, 147.370834, 58.869282>
  translate  <-3.8389, 3.33057, 9.18392>
}
#declare _Leaf1B3_1B3_2B3_1B5_Ref = object {
  _Leaf1B3_1B3_2B3_1B5
  scale 0.7
  rotate <0.0, 70.516769, 276.668701>
  translate  <-3.9181, 3.29993, 9.25182>
}
#declare _Leaf1B3_1B3_2B3_1B6_Ref = object {
  _Leaf1B3_1B3_2B3_1B6
  scale 0.7
  rotate <0.0, 6.24568, 285.071045>
  translate  <-4.16333, 3.3443, 9.4199>
}
#declare _Leaf1B3_1B3_2B3_1B7_Ref = object {
  _Leaf1B3_1B3_2B3_1B7
  scale 0.7
  rotate <0.0, 109.45295, 235.987671>
  translate  <-4.26205, 3.34485, 9.45187>
}
#declare _Leaf1B3_1B3_2B3_1B8_Ref = object {
  _Leaf1B3_1B3_2B3_1B8
  scale 0.7
  rotate <0.0, 136.496872, 208.555588>
  translate  <-4.43029, 3.37086, 9.55712>
}
#declare _Leaf1B3_1B3_2B3_1B9_Ref = object {
  _Leaf1B3_1B3_2B3_1B9
  scale 0.7
  rotate <0.0, 33.386631, 8.84182>
  translate  <-4.41895, 3.36702, 9.57551>
}
#declare _Leaf1B3_1B3_2B3_1B10_Ref = object {
  _Leaf1B3_1B3_2B3_1B10
  scale 0.7
  rotate <0.0, 31.53528, 151.461563>
  translate  <-4.58592, 3.39716, 9.68203>
}
#declare _Leaf1B3_1B3_2B3_1B11_Ref = object {
  _Leaf1B3_1B3_2B3_1B11
  scale 0.7
  rotate <0.0, 72.93013, 126.611893>
  translate  <-4.58954, 3.40357, 9.67527>
}
#declare _Leaf1B3_1B3_2B3_1B12_Ref = object {
  _Leaf1B3_1B3_2B3_1B12
  scale 0.7
  rotate <0.0, 124.953133, 127.745934>
  translate  <-4.59487, 3.40019, 9.66751>
}
#declare _Leaf1B3_1B3_2B4_1B1_Ref = object {
  _Leaf1B3_1B3_2B4_1B1
  scale 0.7
  rotate <0.0, 28.775909, 239.014465>
  translate  <-3.35447, 3.33806, 9.31233>
}
#declare _Leaf1B3_1B3_2B4_1B2_Ref = object {
  _Leaf1B3_1B3_2B4_1B2
  scale 0.7
  rotate <0.0, 52.406429, 298.659363>
  translate  <-3.30369, 3.32248, 9.50674>
}
#declare _Leaf1B3_1B3_2B4_1B3_Ref = object {
  _Leaf1B3_1B3_2B4_1B3
  scale 0.7
  rotate <0.0, 68.229172, 146.362213>
  translate  <-3.309, 3.35569, 9.61126>
}
#declare _Leaf1B3_1B3_2B4_1B4_Ref = object {
  _Leaf1B3_1B3_2B4_1B4
  scale 0.7
  rotate <0.0, 124.316673, 196.401978>
  translate  <-3.32176, 3.33777, 9.61153>
}
#declare _Leaf1B3_1B3_2B4_1B5_Ref = object {
  _Leaf1B3_1B3_2B4_1B5
  scale 0.7
  rotate <0.0, 97.931892, 354.7565>
  translate  <-3.26657, 3.32608, 9.70447>
}
#declare _Leaf1B3_1B3_2B4_1B6_Ref = object {
  _Leaf1B3_1B3_2B4_1B6
  scale 0.7
  rotate <0.0, 61.096001, 49.563492>
  translate  <-3.23796, 3.31806, 10.0036>
}
#declare _Leaf1B3_1B3_2B4_1B7_Ref = object {
  _Leaf1B3_1B3_2B4_1B7
  scale 0.7
  rotate <0.0, 86.652809, 300.038208>
  translate  <-3.22828, 3.28279, 10.10071>
}
#declare _Leaf1B3_1B3_2B4_1B8_Ref = object {
  _Leaf1B3_1B3_2B4_1B8
  scale 0.7
  rotate <0.0, 88.790649, 264.925018>
  translate  <-3.20956, 3.26845, 10.29946>
}
#declare _Leaf1B3_1B3_2B4_1B9_Ref = object {
  _Leaf1B3_1B3_2B4_1B9
  scale 0.7
  rotate <0.0, 88.433517, 69.376038>
  translate  <-3.19684, 3.28632, 10.29919>
}
#declare _Leaf1B3_1B3_2B4_1B10_Ref = object {
  _Leaf1B3_1B3_2B4_1B10
  scale 0.7
  rotate <0.0, 27.31295, 69.104424>
  translate  <-3.18107, 3.27531, 10.4986>
}
#declare _Leaf1B3_1B3_2B4_1B11_Ref = object {
  _Leaf1B3_1B3_2B4_1B11
  scale 0.7
  rotate <0.0, 36.387959, 161.502716>
  translate  <-3.19012, 3.27113, 10.49947>
}
#declare _Leaf1B3_1B3_2B4_1B12_Ref = object {
  _Leaf1B3_1B3_2B4_1B12
  scale 0.7
  rotate <0.0, 75.098244, 206.107239>
  translate  <-3.19112, 3.2612, 10.49881>
}
#declare _Leaf1B3_1B3_2B5_1B1_Ref = object {
  _Leaf1B3_1B3_2B5_1B1
  scale 0.7
  rotate <0.0, 20.10796, 69.291473>
  translate  <-3.49502, 3.75952, 9.46848>
}
#declare _Leaf1B3_1B3_2B5_1B2_Ref = object {
  _Leaf1B3_1B3_2B5_1B2
  scale 0.7
  rotate <0.0, 62.88599, 57.449959>
  translate  <-3.53922, 3.90689, 9.59863>
}
#declare _Leaf1B3_1B3_2B5_1B3_Ref = object {
  _Leaf1B3_1B3_2B5_1B3
  scale 0.7
  rotate <0.0, 54.157959, 221.024628>
  translate  <-3.60291, 3.95225, 9.67571>
}
#declare _Leaf1B3_1B3_2B5_1B4_Ref = object {
  _Leaf1B3_1B3_2B5_1B4
  scale 0.7
  rotate <0.0, 87.09024, 292.754547>
  translate  <-3.58608, 3.94462, 9.68764>
}
#declare _Leaf1B3_1B3_2B5_1B5_Ref = object {
  _Leaf1B3_1B3_2B5_1B5
  scale 0.7
  rotate <0.0, 128.990707, 79.699867>
  translate  <-3.60285, 4.04155, 9.73394>
}
#declare _Leaf1B3_1B3_2B5_1B6_Ref = object {
  _Leaf1B3_1B3_2B5_1B6
  scale 0.7
  rotate <0.0, 95.967239, 141.30603>
  translate  <-3.68657, 4.22444, 9.95733>
}
#declare _Leaf1B3_1B3_2B5_1B7_Ref = object {
  _Leaf1B3_1B3_2B5_1B7
  scale 0.7
  rotate <0.0, 90.186523, 35.900539>
  translate  <-3.68265, 4.28937, 10.03817>
}
#declare _Leaf1B3_1B3_2B5_1B8_Ref = object {
  _Leaf1B3_1B3_2B5_1B8
  scale 0.7
  rotate <0.0, 70.991783, 5.89256>
  translate  <-3.72971, 4.41209, 10.18912>
}
#declare _Leaf1B3_1B3_2B5_1B9_Ref = object {
  _Leaf1B3_1B3_2B5_1B9
  scale 0.7
  rotate <0.0, 114.635551, 169.980255>
  translate  <-3.7465, 4.4197, 10.17722>
}
#declare _Leaf1B3_1B3_2B5_1B10_Ref = object {
  _Leaf1B3_1B3_2B5_1B10
  scale 0.7
  rotate <0.0, 59.871231, 141.678345>
  translate  <-3.79696, 4.53977, 10.32944>
}
#declare _Leaf1B3_1B3_2B5_1B11_Ref = object {
  _Leaf1B3_1B3_2B5_1B11
  scale 0.7
  rotate <0.0, 25.9977, 189.871918>
  translate  <-3.79334, 4.53335, 10.33621>
}
#declare _Leaf1B3_1B3_2B5_1B12_Ref = object {
  _Leaf1B3_1B3_2B5_1B12
  scale 0.7
  rotate <0.0, 37.522869, 301.32959>
  translate  <-3.7837, 4.53376, 10.33884>
}
#declare _Leaf1B3_1B3_1B1_1B1_Ref = object {
  _Leaf1B3_1B3_1B1_1B1
  scale 0.7
  rotate <0.0, 50.929909, 24.74263>
  translate  <-2.40374, 1.80769, 7.03335>
}
#declare _Leaf1B3_1B3_1B1_1B2_Ref = object {
  _Leaf1B3_1B3_1B1_1B2
  scale 0.7
  rotate <0.0, 94.249008, 25.490629>
  translate  <-2.31056, 1.97122, 7.10538>
}
#declare _Leaf1B3_1B3_1B1_1B3_Ref = object {
  _Leaf1B3_1B3_1B1_1B3
  scale 0.7
  rotate <0.0, 22.257641, 186.261154>
  translate  <-2.30071, 2.05313, 7.17783>
}
#declare _Leaf1B3_1B3_1B1_1B4_Ref = object {
  _Leaf1B3_1B3_1B1_1B4
  scale 0.7
  rotate <0.0, 76.060623, 266.775787>
  translate  <-2.28493, 2.0393, 7.18444>
}
#declare _Leaf1B3_1B3_1B1_1B5_Ref = object {
  _Leaf1B3_1B3_1B1_1B5
  scale 0.7
  rotate <0.0, 150.580383, 79.333031>
  translate  <-2.23456, 2.13519, 7.19385>
}
#declare _Leaf1B3_1B3_1B1_1B6_Ref = object {
  _Leaf1B3_1B3_1B1_1B6
  scale 0.7
  rotate <0.0, 91.565643, 112.883636>
  translate  <-2.10893, 2.36158, 7.34658>
}
#declare _Leaf1B3_1B3_1B1_1B7_Ref = object {
  _Leaf1B3_1B3_1B1_1B7
  scale 0.7
  rotate <0.0, 121.799454, 3.76446>
  translate  <-2.0381, 2.42415, 7.38942>
}
#declare _Leaf1B3_1B3_1B1_1B8_Ref = object {
  _Leaf1B3_1B3_1B1_1B8
  scale 0.7
  rotate <0.0, 96.589302, 337.512817>
  translate  <-1.94636, 2.57132, 7.48935>
}
#declare _Leaf1B3_1B3_1B1_1B9_Ref = object {
  _Leaf1B3_1B3_1B1_1B9
  scale 0.7
  rotate <0.0, 94.290619, 146.045364>
  translate  <-1.9621, 2.58511, 7.48276>
}
#declare _Leaf1B3_1B3_1B1_1B10_Ref = object {
  _Leaf1B3_1B3_1B1_1B10
  scale 0.7
  rotate <0.0, 61.22588, 92.468788>
  translate  <-1.87335, 2.73205, 7.58604>
}
#declare _Leaf1B3_1B3_1B1_1B11_Ref = object {
  _Leaf1B3_1B3_1B1_1B11
  scale 0.7
  rotate <0.0, 17.666559, 69.670067>
  translate  <-1.86973, 2.72563, 7.59281>
}
#declare _Leaf1B3_1B3_1B1_1B12_Ref = object {
  _Leaf1B3_1B3_1B1_1B12
  scale 0.7
  rotate <0.0, 41.670101, 311.075867>
  translate  <-1.86093, 2.72116, 7.59125>
}
#declare _Leaf1B3_1B3_1B2_1B1_Ref = object {
  _Leaf1B3_1B3_1B2_1B1
  scale 0.7
  rotate <0.0, 51.972561, 210.597305>
  translate  <-2.83139, 1.81297, 7.522>
}
#declare _Leaf1B3_1B3_1B2_1B2_Ref = object {
  _Leaf1B3_1B3_1B2_1B2
  scale 0.7
  rotate <0.0, 58.379372, 263.510193>
  translate  <-2.86881, 1.75961, 7.7127>
}
#declare _Leaf1B3_1B3_1B2_1B3_Ref = object {
  _Leaf1B3_1B3_1B2_1B3
  scale 0.7
  rotate <0.0, 79.015488, 134.593445>
  translate  <-2.90643, 1.78076, 7.81366>
}
#declare _Leaf1B3_1B3_1B2_1B4_Ref = object {
  _Leaf1B3_1B3_1B2_1B4
  scale 0.7
  rotate <0.0, 147.130447, 168.232422>
  translate  <-2.92251, 1.76825, 7.80535>
}
#declare _Leaf1B3_1B3_1B2_1B5_Ref = object {
  _Leaf1B3_1B3_1B2_1B5
  scale 0.7
  rotate <0.0, 78.86097, 335.936371>
  translate  <-2.91442, 1.72841, 7.90619>
}
#declare _Leaf1B3_1B3_1B2_1B6_Ref = object {
  _Leaf1B3_1B3_1B2_1B6
  scale 0.7
  rotate <0.0, 37.811852, 38.153>
  translate  <-3.01116, 1.67785, 8.18627>
}
#declare _Leaf1B3_1B3_1B2_1B7_Ref = object {
  _Leaf1B3_1B3_1B2_1B7
  scale 0.7
  rotate <0.0, 88.597137, 280.630737>
  translate  <-3.05094, 1.63075, 8.26974>
}
#declare _Leaf1B3_1B3_1B2_1B8_Ref = object {
  _Leaf1B3_1B3_1B2_1B8
  scale 0.7
  rotate <0.0, 104.040642, 248.758804>
  translate  <-3.11787, 1.58882, 8.45364>
}
#declare _Leaf1B3_1B3_1B2_1B9_Ref = object {
  _Leaf1B3_1B3_1B2_1B9
  scale 0.7
  rotate <0.0, 68.68544, 54.028931>
  translate  <-3.10184, 1.6013, 8.46193>
}
#declare _Leaf1B3_1B3_1B2_1B10_Ref = object {
  _Leaf1B3_1B3_1B2_1B10
  scale 0.7
  rotate <0.0, 15.38774, 111.615471>
  translate  <-3.17074, 1.5634, 8.64618>
}
#declare _Leaf1B3_1B3_1B2_1B11_Ref = object {
  _Leaf1B3_1B3_1B2_1B11
  scale 0.7
  rotate <0.0, 54.39624, 160.251984>
  translate  <-3.18014, 1.56243, 8.64289>
}
#declare _Leaf1B3_1B3_1B2_1B12_Ref = object {
  _Leaf1B3_1B3_1B2_1B12
  scale 0.7
  rotate <0.0, 99.426781, 187.892654>
  translate  <-3.1834, 1.55355, 8.63964>
}
#declare _Leaf1B3_1B3_1B3_1B1_Ref = object {
  _Leaf1B3_1B3_1B3_1B1
  scale 0.7
  rotate <0.0, 106.970871, 117.531898>
  translate  <-3.01047, 2.21567, 7.38989>
}
#declare _Leaf1B3_1B3_1B3_1B2_Ref = object {
  _Leaf1B3_1B3_1B3_1B2
  scale 0.7
  rotate <0.0, 129.998596, 160.071274>
  translate  <-3.18215, 2.32115, 7.39371>
}
#declare _Leaf1B3_1B3_1B3_1B3_Ref = object {
  _Leaf1B3_1B3_1B3_1B3
  scale 0.7
  rotate <0.0, 52.985291, 66.484497>
  translate  <-3.24951, 2.39505, 7.43906>
}
#declare _Leaf1B3_1B3_1B3_1B4_Ref = object {
  _Leaf1B3_1B3_1B3_1B4
  scale 0.7
  rotate <0.0, 104.242561, 10.38283>
  translate  <-3.24111, 2.40633, 7.42214>
}
#declare _Leaf1B3_1B3_1B3_1B5_Ref = object {
  _Leaf1B3_1B3_1B3_1B5
  scale 0.7
  rotate <0.0, 99.695908, 231.114868>
  translate  <-3.34563, 2.43597, 7.41781>
}
#declare _Leaf1B3_1B3_1B3_1B6_Ref = object {
  _Leaf1B3_1B3_1B3_1B6
  scale 0.7
  rotate <0.0, 47.133099, 190.39798>
  translate  <-3.57354, 2.63039, 7.44265>
}
#declare _Leaf1B3_1B3_1B3_1B7_Ref = object {
  _Leaf1B3_1B3_1B3_1B7
  scale 0.7
  rotate <0.0, 151.844925, 204.148346>
  translate  <-3.64894, 2.69741, 7.41831>
}
#declare _Leaf1B3_1B3_1B3_1B8_Ref = object {
  _Leaf1B3_1B3_1B3_1B8
  scale 0.7
  rotate <0.0, 168.257095, 85.834396>
  translate  <-3.80047, 2.82794, 7.4259>
}
#declare _Leaf1B3_1B3_1B3_1B9_Ref = object {
  _Leaf1B3_1B3_1B3_1B9
  scale 0.7
  rotate <0.0, 24.75042, 234.939026>
  translate  <-3.80884, 2.81669, 7.44278>
}
#declare _Leaf1B3_1B3_1B3_1B10_Ref = object {
  _Leaf1B3_1B3_1B3_1B10
  scale 0.7
  rotate <0.0, 58.846741, 147.043274>
  translate  <-3.95858, 2.9493, 7.45393>
}
#declare _Leaf1B3_1B3_1B3_1B11_Ref = object {
  _Leaf1B3_1B3_1B3_1B11
  scale 0.7
  rotate <0.0, 71.608742, 98.785004>
  translate  <-3.95281, 2.95669, 7.45047>
}
#declare _Leaf1B3_1B3_1B3_1B12_Ref = object {
  _Leaf1B3_1B3_1B3_1B12
  scale 0.7
  rotate <0.0, 109.668648, 62.619469>
  translate  <-3.95198, 2.95818, 7.44061>
}
#declare _Leaf1B3_1B4_2B1_1B1_Ref = object {
  _Leaf1B3_1B4_2B1_1B1
  scale 0.7
  rotate <0.0, 131.018005, 149.752228>
  translate  <-5.84182, 3.2705, 8.41025>
}
#declare _Leaf1B3_1B4_2B1_1B2_Ref = object {
  _Leaf1B3_1B4_2B1_1B2
  scale 0.7
  rotate <0.0, 132.766815, 209.166046>
  translate  <-6.03734, 3.29006, 8.3655>
}
#declare _Leaf1B3_1B4_2B1_1B3_Ref = object {
  _Leaf1B3_1B4_2B1_1B3
  scale 0.7
  rotate <0.0, 80.037727, 93.975159>
  translate  <-6.13311, 3.34348, 8.37084>
}
#declare _Leaf1B3_1B4_2B1_1B4_Ref = object {
  _Leaf1B3_1B4_2B1_1B4
  scale 0.7
  rotate <0.0, 108.24752, 25.13817>
  translate  <-6.12635, 3.3483, 8.35046>
}
#declare _Leaf1B3_1B4_2B1_1B5_Ref = object {
  _Leaf1B3_1B4_2B1_1B5
  scale 0.7
  rotate <0.0, 76.784561, 253.775925>
  translate  <-6.23213, 3.3294, 8.33394>
}
#declare _Leaf1B3_1B4_2B1_1B6_Ref = object {
  _Leaf1B3_1B4_2B1_1B6
  scale 0.7
  rotate <0.0, 47.884048, 186.563431>
  translate  <-6.51417, 3.40799, 8.26581>
}
#declare _Leaf1B3_1B4_2B1_1B7_Ref = object {
  _Leaf1B3_1B4_2B1_1B7
  scale 0.7
  rotate <0.0, 132.467529, 256.365601>
  translate  <-6.60268, 3.42165, 8.2134>
}
#declare _Leaf1B3_1B4_2B1_1B8_Ref = object {
  _Leaf1B3_1B4_2B1_1B8
  scale 0.7
  rotate <0.0, 163.080627, 293.243439>
  translate  <-6.78907, 3.47094, 8.15967>
}
#declare _Leaf1B3_1B4_2B1_1B9_Ref = object {
  _Leaf1B3_1B4_2B1_1B9
  scale 0.7
  rotate <0.0, 15.28903, 172.355713>
  translate  <-6.79581, 3.46614, 8.17999>
}
#declare _Leaf1B3_1B4_2B1_1B10_Ref = object {
  _Leaf1B3_1B4_2B1_1B10
  scale 0.7
  rotate <0.0, 76.047974, 160.431305>
  translate  <-6.98191, 3.5194, 8.12836>
}
#declare _Leaf1B3_1B4_2B1_1B11_Ref = object {
  _Leaf1B3_1B4_2B1_1B11
  scale 0.7
  rotate <0.0, 99.81176, 121.601089>
  translate  <-6.97857, 3.52606, 8.12169>
}
#declare _Leaf1B3_1B4_2B1_1B12_Ref = object {
  _Leaf1B3_1B4_2B1_1B12
  scale 0.7
  rotate <0.0, 134.602036, 76.535942>
  translate  <-6.97659, 3.52319, 8.11232>
}
#declare _Leaf1B3_1B4_2B2_1B1_Ref = object {
  _Leaf1B3_1B4_2B2_1B1
  scale 0.7
  rotate <0.0, 92.69828, 71.675018>
  translate  <-5.84046, 3.76544, 8.58199>
}
#declare _Leaf1B3_1B4_2B2_1B2_Ref = object {
  _Leaf1B3_1B4_2B2_1B2
  scale 0.7
  rotate <0.0, 134.105621, 57.270481>
  translate  <-5.87903, 3.9476, 8.50487>
}
#declare _Leaf1B3_1B4_2B2_1B3_Ref = object {
  _Leaf1B3_1B4_2B2_1B3
  scale 0.7
  rotate <0.0, 30.82073, 119.315033>
  translate  <-5.92576, 4.04685, 8.5094>
}
#declare _Leaf1B3_1B4_2B2_1B4_Ref = object {
  _Leaf1B3_1B4_2B2_1B4
  scale 0.7
  rotate <0.0, 45.35775, 327.963959>
  translate  <-5.90475, 4.0515, 8.51399>
}
#declare _Leaf1B3_1B4_2B2_1B5_Ref = object {
  _Leaf1B3_1B4_2B2_1B5
  scale 0.7
  rotate <0.0, 156.466171, 230.212448>
  translate  <-5.93068, 4.13335, 8.44729>
}
#declare _Leaf1B3_1B4_2B2_1B6_Ref = object {
  _Leaf1B3_1B4_2B2_1B6
  scale 0.7
  rotate <0.0, 108.56543, 162.100571>
  translate  <-5.9864, 4.42098, 8.38001>
}
#declare _Leaf1B3_1B4_2B2_1B7_Ref = object {
  _Leaf1B3_1B4_2B2_1B7
  scale 0.7
  rotate <0.0, 143.224197, 5.99415>
  translate  <-5.9748, 4.51799, 8.34504>
}
#declare _Leaf1B3_1B4_2B2_1B8_Ref = object {
  _Leaf1B3_1B4_2B2_1B8
  scale 0.7
  rotate <0.0, 108.158302, 9.07027>
  translate  <-6.00348, 4.71017, 8.29708>
}
#declare _Leaf1B3_1B4_2B2_1B9_Ref = object {
  _Leaf1B3_1B4_2B2_1B9
  scale 0.7
  rotate <0.0, 87.617378, 188.311234>
  translate  <-6.02443, 4.70553, 8.29251>
}
#declare _Leaf1B3_1B4_2B2_1B10_Ref = object {
  _Leaf1B3_1B4_2B2_1B10
  scale 0.7
  rotate <0.0, 95.424171, 127.619339>
  translate  <-6.05519, 4.89852, 8.24846>
}
#declare _Leaf1B3_1B4_2B2_1B11_Ref = object {
  _Leaf1B3_1B4_2B2_1B11
  scale 0.7
  rotate <0.0, 61.05336, 96.992538>
  translate  <-6.0482, 4.90152, 8.25495>
}
#declare _Leaf1B3_1B4_2B2_1B12_Ref = object {
  _Leaf1B3_1B4_2B2_1B12
  scale 0.7
  rotate <0.0, 53.70982, 34.771351>
  translate  <-6.03865, 4.90219, 8.25207>
}
#declare _Leaf1B3_1B4_2B3_1B1_Ref = object {
  _Leaf1B3_1B4_2B3_1B1
  scale 0.7
  rotate <0.0, 68.73069, 202.596085>
  translate  <-6.41061, 3.84453, 9.08953>
}
#declare _Leaf1B3_1B4_2B3_1B2_Ref = object {
  _Leaf1B3_1B4_2B3_1B2
  scale 0.7
  rotate <0.0, 50.780609, 248.970306>
  translate  <-6.52462, 3.8272, 9.25481>
}
#declare _Leaf1B3_1B4_2B3_1B3_Ref = object {
  _Leaf1B3_1B4_2B3_1B3
  scale 0.7
  rotate <0.0, 106.889603, 139.955597>
  translate  <-6.60309, 3.86322, 9.32263>
}
#declare _Leaf1B3_1B4_2B3_1B4_Ref = object {
  _Leaf1B3_1B4_2B3_1B4
  scale 0.7
  rotate <0.0, 169.165756, 230.53598>
  translate  <-6.61344, 3.84705, 9.31188>
}
#declare _Leaf1B3_1B4_2B3_1B5_Ref = object {
  _Leaf1B3_1B4_2B3_1B5
  scale 0.7
  rotate <0.0, 50.437519, 343.692108>
  translate  <-6.64814, 3.83069, 9.41362>
}
#declare _Leaf1B3_1B4_2B3_1B6_Ref = object {
  _Leaf1B3_1B4_2B3_1B6
  scale 0.7
  rotate <0.0, 37.282291, 82.779861>
  translate  <-6.85437, 3.82606, 9.63226>
}
#declare _Leaf1B3_1B4_2B3_1B7_Ref = object {
  _Leaf1B3_1B4_2B3_1B7
  scale 0.7
  rotate <0.0, 69.929253, 282.097046>
  translate  <-6.92434, 3.79211, 9.70096>
}
#declare _Leaf1B3_1B4_2B3_1B8_Ref = object {
  _Leaf1B3_1B4_2B3_1B8
  scale 0.7
  rotate <0.0, 97.491638, 259.929291>
  translate  <-7.06247, 3.78013, 9.84531>
}
#declare _Leaf1B3_1B4_2B3_1B9_Ref = object {
  _Leaf1B3_1B4_2B3_1B9
  scale 0.7
  rotate <0.0, 69.251099, 71.054543>
  translate  <-7.05214, 3.79625, 9.85602>
}
#declare _Leaf1B3_1B4_2B3_1B10_Ref = object {
  _Leaf1B3_1B4_2B3_1B10
  scale 0.7
  rotate <0.0, 41.949261, 140.500076>
  translate  <-7.19236, 3.78796, 9.99887>
}
#declare _Leaf1B3_1B4_2B3_1B11_Ref = object {
  _Leaf1B3_1B4_2B3_1B11
  scale 0.7
  rotate <0.0, 82.64225, 163.858521>
  translate  <-7.19935, 3.78497, 9.99237>
}
#declare _Leaf1B3_1B4_2B3_1B12_Ref = object {
  _Leaf1B3_1B4_2B3_1B12
  scale 0.7
  rotate <0.0, 120.684219, 200.927887>
  translate  <-7.20051, 3.77523, 9.99041>
}
#declare _Leaf1B3_1B4_2B4_1B1_Ref = object {
  _Leaf1B3_1B4_2B4_1B1
  scale 0.7
  rotate <0.0, 13.59734, 63.339539>
  translate  <-6.28279, 4.20285, 9.18819>
}
#declare _Leaf1B3_1B4_2B4_1B2_Ref = object {
  _Leaf1B3_1B4_2B4_1B2
  scale 0.7
  rotate <0.0, 52.02449, 17.626181>
  translate  <-6.23984, 4.34811, 9.32111>
}
#declare _Leaf1B3_1B4_2B4_1B3_Ref = object {
  _Leaf1B3_1B4_2B4_1B3
  scale 0.7
  rotate <0.0, 66.718651, 175.014999>
  translate  <-6.26928, 4.42996, 9.38812>
}
#declare _Leaf1B3_1B4_2B4_1B4_Ref = object {
  _Leaf1B3_1B4_2B4_1B4
  scale 0.7
  rotate <0.0, 88.073036, 247.895935>
  translate  <-6.26538, 4.41363, 9.40233>
}
#declare _Leaf1B3_1B4_2B4_1B5_Ref = object {
  _Leaf1B3_1B4_2B4_1B5
  scale 0.7
  rotate <0.0, 120.565193, 28.54468>
  translate  <-6.22022, 4.49802, 9.45389>
}
#declare _Leaf1B3_1B4_2B4_1B6_Ref = object {
  _Leaf1B3_1B4_2B4_1B6
  scale 0.7
  rotate <0.0, 101.148933, 95.205658>
  translate  <-6.20014, 4.70242, 9.67338>
}
#declare _Leaf1B3_1B4_2B4_1B7_Ref = object {
  _Leaf1B3_1B4_2B4_1B7
  scale 0.7
  rotate <0.0, 77.445488, 351.811737>
  translate  <-6.16999, 4.75182, 9.75952>
}
#declare _Leaf1B3_1B4_2B4_1B8_Ref = object {
  _Leaf1B3_1B4_2B4_1B8
  scale 0.7
  rotate <0.0, 59.023239, 319.309265>
  translate  <-6.15041, 4.88273, 9.90964>
}
#declare _Leaf1B3_1B4_2B4_1B9_Ref = object {
  _Leaf1B3_1B4_2B4_1B9
  scale 0.7
  rotate <0.0, 124.663963, 121.005402>
  translate  <-6.15429, 4.89902, 9.89547>
}
#declare _Leaf1B3_1B4_2B4_1B10_Ref = object {
  _Leaf1B3_1B4_2B4_1B10
  scale 0.7
  rotate <0.0, 65.914497, 103.237183>
  translate  <-6.13917, 5.03046, 10.04589>
}
#declare _Leaf1B3_1B4_2B4_1B11_Ref = object {
  _Leaf1B3_1B4_2B4_1B11
  scale 0.7
  rotate <0.0, 38.51263, 150.669189>
  translate  <-6.14251, 5.0238, 10.05256>
}
#declare _Leaf1B3_1B4_2B4_1B12_Ref = object {
  _Leaf1B3_1B4_2B4_1B12
  scale 0.7
  rotate <0.0, 38.395031, 240.382935>
  translate  <-6.1361, 5.01761, 10.05708>
}
#declare _Leaf1B3_1B4_2B5_1B1_Ref = object {
  _Leaf1B3_1B4_2B5_1B1
  scale 0.7
  rotate <0.0, 59.000019, 100.948936>
  translate  <-6.68538, 4.44689, 9.17683>
}
#declare _Leaf1B3_1B4_2B5_1B2_Ref = object {
  _Leaf1B3_1B4_2B5_1B2
  scale 0.7
  rotate <0.0, 102.30056, 102.45179>
  translate  <-6.82412, 4.58366, 9.22839>
}
#declare _Leaf1B3_1B4_2B5_1B3_Ref = object {
  _Leaf1B3_1B4_2B5_1B3
  scale 0.7
  rotate <0.0, 14.4166, 256.591431>
  translate  <-6.90251, 4.62177, 9.29515>
}
#declare _Leaf1B3_1B4_2B5_1B4_Ref = object {
  _Leaf1B3_1B4_2B5_1B4
  scale 0.7
  rotate <0.0, 73.211906, 345.680328>
  translate  <-6.88552, 4.6348, 9.30019>
}
#declare _Leaf1B3_1B4_2B5_1B5_Ref = object {
  _Leaf1B3_1B4_2B5_1B5
  scale 0.7
  rotate <0.0, 153.629944, 170.435654>
  translate  <-6.96744, 4.70626, 9.29851>
}
#declare _Leaf1B3_1B4_2B5_1B6_Ref = object {
  _Leaf1B3_1B4_2B5_1B6
  scale 0.7
  rotate <0.0, 90.908653, 189.871017>
  translate  <-7.16096, 4.8998, 9.42282>
}
#declare _Leaf1B3_1B4_2B5_1B7_Ref = object {
  _Leaf1B3_1B4_2B5_1B7
  scale 0.7
  rotate <0.0, 129.627625, 79.030212>
  translate  <-7.20619, 4.9882, 9.45296>
}
#declare _Leaf1B3_1B4_2B5_1B8_Ref = object {
  _Leaf1B3_1B4_2B5_1B8
  scale 0.7
  rotate <0.0, 102.6931, 53.414108>
  translate  <-7.32969, 5.12381, 9.53306>
}
#declare _Leaf1B3_1B4_2B5_1B9_Ref = object {
  _Leaf1B3_1B4_2B5_1B9
  scale 0.7
  rotate <0.0, 89.309959, 223.059616>
  translate  <-7.34664, 5.11082, 9.52803>
}
#declare _Leaf1B3_1B4_2B5_1B10_Ref = object {
  _Leaf1B3_1B4_2B5_1B10
  scale 0.7
  rotate <0.0, 63.7234, 165.248535>
  translate  <-7.47064, 5.24397, 9.61186>
}
#declare _Leaf1B3_1B4_2B5_1B11_Ref = object {
  _Leaf1B3_1B4_2B5_1B11
  scale 0.7
  rotate <0.0, 23.57629, 131.478104>
  translate  <-7.46365, 5.24696, 9.61836>
}
#declare _Leaf1B3_1B4_2B5_1B12_Ref = object {
  _Leaf1B3_1B4_2B5_1B12
  scale 0.7
  rotate <0.0, 45.313889, 35.557701>
  translate  <-7.45726, 5.25423, 9.61583>
}
#declare _Leaf1B3_1B4_1B1_1B1_Ref = object {
  _Leaf1B3_1B4_1B1_1B1
  scale 0.7
  rotate <0.0, 89.18058, 75.622559>
  translate  <-4.48098, 2.45834, 7.72195>
}
#declare _Leaf1B3_1B4_1B1_1B2_Ref = object {
  _Leaf1B3_1B4_1B1_1B2
  scale 0.7
  rotate <0.0, 131.314804, 64.503708>
  translate  <-4.5342, 2.64247, 7.65969>
}
#declare _Leaf1B3_1B4_1B1_1B3_Ref = object {
  _Leaf1B3_1B4_1B1_1B3
  scale 0.7
  rotate <0.0, 26.31242, 124.483994>
  translate  <-4.58728, 2.73768, 7.67291>
}
#declare _Leaf1B3_1B4_1B1_1B4_Ref = object {
  _Leaf1B3_1B4_1B1_1B4
  scale 0.7
  rotate <0.0, 49.072201, 329.411438>
  translate  <-4.56649, 2.74343, 7.67722>
}
#declare _Leaf1B3_1B4_1B1_1B5_Ref = object {
  _Leaf1B3_1B4_1B1_1B5
  scale 0.7
  rotate <0.0, 158.326004, 224.084106>
  translate  <-4.60006, 2.82788, 7.61754>
}
#declare _Leaf1B3_1B4_1B1_1B6_Ref = object {
  _Leaf1B3_1B4_1B1_1B6
  scale 0.7
  rotate <0.0, 105.652473, 164.91951>
  translate  <-4.6771, 3.11507, 7.5734>
}
#declare _Leaf1B3_1B4_1B1_1B7_Ref = object {
  _Leaf1B3_1B4_1B1_1B7
  scale 0.7
  rotate <0.0, 144.190445, 15.96979>
  translate  <-4.67318, 3.21491, 7.54539>
}
#declare _Leaf1B3_1B4_1B1_1B8_Ref = object {
  _Leaf1B3_1B4_1B1_1B8
  scale 0.7
  rotate <0.0, 109.061577, 14.47632>
  translate  <-4.71624, 3.40761, 7.51265>
}
#declare _Leaf1B3_1B4_1B1_1B9_Ref = object {
  _Leaf1B3_1B4_1B1_1B9
  scale 0.7
  rotate <0.0, 86.605179, 192.435654>
  translate  <-4.73697, 3.40187, 7.50835>
}
#declare _Leaf1B3_1B4_1B1_1B10_Ref = object {
  _Leaf1B3_1B4_1B1_1B10
  scale 0.7
  rotate <0.0, 91.047699, 131.446655>
  translate  <-4.78201, 3.59495, 7.47963>
}
#declare _Leaf1B3_1B4_1B1_1B11_Ref = object {
  _Leaf1B3_1B4_1B1_1B11
  scale 0.7
  rotate <0.0, 56.63974, 100.19738>
  translate  <-4.77502, 3.59795, 7.48613>
}
#declare _Leaf1B3_1B4_1B1_1B12_Ref = object {
  _Leaf1B3_1B4_1B1_1B12
  scale 0.7
  rotate <0.0, 52.77142, 35.335098>
  translate  <-4.76564, 3.59948, 7.48303>
}
#declare _Leaf1B3_1B4_1B2_1B1_Ref = object {
  _Leaf1B3_1B4_1B2_1B1
  scale 0.7
  rotate <0.0, 15.97305, 223.821396>
  translate  <-4.79275, 2.53836, 8.28595>
}
#declare _Leaf1B3_1B4_1B2_1B2_Ref = object {
  _Leaf1B3_1B4_1B2_1B2
  scale 0.7
  rotate <0.0, 33.493698, 343.101135>
  translate  <-4.78432, 2.61239, 8.4732>
}
#declare _Leaf1B3_1B4_1B2_1B3_Ref = object {
  _Leaf1B3_1B4_1B2_1B3
  scale 0.7
  rotate <0.0, 82.272621, 173.782562>
  translate  <-4.82764, 2.66765, 8.55761>
}
#declare _Leaf1B3_1B4_1B2_1B4_Ref = object {
  _Leaf1B3_1B4_1B2_1B4
  scale 0.7
  rotate <0.0, 116.973846, 240.821045>
  translate  <-4.82977, 2.64679, 8.56426>
}
#declare _Leaf1B3_1B4_1B2_1B5_Ref = object {
  _Leaf1B3_1B4_1B2_1B5
  scale 0.7
  rotate <0.0, 94.127083, 24.39089>
  translate  <-4.79752, 2.69531, 8.65606>
}
#declare _Leaf1B3_1B4_1B2_1B6_Ref = object {
  _Leaf1B3_1B4_1B2_1B6
  scale 0.7
  rotate <0.0, 77.747337, 87.008408>
  translate  <-4.83424, 2.79543, 8.93711>
}
#declare _Leaf1B3_1B4_1B2_1B7_Ref = object {
  _Leaf1B3_1B4_1B2_1B7
  scale 0.7
  rotate <0.0, 67.163094, 334.399384>
  translate  <-4.82991, 2.80235, 9.04056>
}
#declare _Leaf1B3_1B4_1B2_1B8_Ref = object {
  _Leaf1B3_1B4_1B2_1B8
  scale 0.7
  rotate <0.0, 67.07975, 296.139252>
  translate  <-4.85016, 2.86161, 9.23066>
}
#declare _Leaf1B3_1B4_1B2_1B9_Ref = object {
  _Leaf1B3_1B4_1B2_1B9
  scale 0.7
  rotate <0.0, 108.425568, 99.94445>
  translate  <-4.84804, 2.88241, 9.22402>
}
#declare _Leaf1B3_1B4_1B2_1B10_Ref = object {
  _Leaf1B3_1B4_1B2_1B10
  scale 0.7
  rotate <0.0, 48.11697, 110.681068>
  translate  <-4.87255, 2.94293, 9.41341>
}
#declare _Leaf1B3_1B4_1B2_1B11_Ref = object {
  _Leaf1B3_1B4_1B2_1B11
  scale 0.7
  rotate <0.0, 48.42366, 172.754547>
  translate  <-4.87835, 2.93507, 9.41558>
}
#declare _Leaf1B3_1B4_1B2_1B12_Ref = object {
  _Leaf1B3_1B4_1B2_1B12
  scale 0.7
  rotate <0.0, 67.805832, 231.001419>
  translate  <-4.87422, 2.9265, 9.41866>
}
#declare _Leaf1B3_1B4_1B3_1B1_Ref = object {
  _Leaf1B3_1B4_1B3_1B1
  scale 0.7
  rotate <0.0, 114.485641, 179.235657>
  translate  <-5.20339, 2.56543, 8.0802>
}
#declare _Leaf1B3_1B4_1B3_1B2_Ref = object {
  _Leaf1B3_1B4_1B3_1B2
  scale 0.7
  rotate <0.0, 106.677582, 224.966324>
  translate  <-5.39884, 2.52795, 8.11195>
}
#declare _Leaf1B3_1B4_1B3_1B3_Ref = object {
  _Leaf1B3_1B4_1B3_1B3
  scale 0.7
  rotate <0.0, 91.179703, 108.212189>
  translate  <-5.49961, 2.5586, 8.14295>
}
#declare _Leaf1B3_1B4_1B3_1B4_Ref = object {
  _Leaf1B3_1B4_1B3_1B4
  scale 0.7
  rotate <0.0, 134.301224, 40.30788>
  translate  <-5.5015, 2.55829, 8.12104>
}
#declare _Leaf1B3_1B4_1B3_1B5_Ref = object {
  _Leaf1B3_1B4_1B3_1B5
  scale 0.7
  rotate <0.0, 59.759079, 277.962585>
  translate  <-5.59563, 2.51301, 8.1512>
}
#declare _Leaf1B3_1B4_1B3_1B6_Ref = object {
  _Leaf1B3_1B4_1B3_1B6
  scale 0.7
  rotate <0.0, 25.02766, 184.302002>
  translate  <-5.89438, 2.5046, 8.18341>
}
#declare _Leaf1B3_1B4_1B3_1B7_Ref = object {
  _Leaf1B3_1B4_1B3_1B7
  scale 0.7
  rotate <0.0, 113.020119, 260.866974>
  translate  <-5.99453, 2.48225, 8.16792>
}
#declare _Leaf1B3_1B4_1B3_1B8_Ref = object {
  _Leaf1B3_1B4_1B3_1B8
  scale 0.7
  rotate <0.0, 148.073105, 257.288147>
  translate  <-6.1939, 2.47157, 8.18193>
}
#declare _Leaf1B3_1B4_1B3_1B9_Ref = object {
  _Leaf1B3_1B4_1B3_1B9
  scale 0.7
  rotate <0.0, 16.13398, 77.542084>
  translate  <-6.19202, 2.47188, 8.20379>
}
#declare _Leaf1B3_1B4_1B3_1B10_Ref = object {
  _Leaf1B3_1B4_1B3_1B10
  scale 0.7
  rotate <0.0, 59.67696, 168.026306>
  translate  <-6.39169, 2.46559, 8.21876>
}
#declare _Leaf1B3_1B4_1B3_1B11_Ref = object {
  _Leaf1B3_1B4_1B3_1B11
  scale 0.7
  rotate <0.0, 97.201759, 141.641312>
  translate  <-6.39288, 2.47044, 8.2101>
}
#declare _Leaf1B3_1B4_1B3_1B12_Ref = object {
  _Leaf1B3_1B4_1B3_1B12
  scale 0.7
  rotate <0.0, 146.900635, 121.971893>
  translate  <-6.39318, 2.46534, 8.2015>
}
#declare _Leaf1B3_1B5_2B1_1B1_Ref = object {
  _Leaf1B3_1B5_2B1_1B1
  scale 0.7
  rotate <0.0, 65.988876, 256.496887>
  translate  <-6.30664, 1.18683, 8.84976>
}
#declare _Leaf1B3_1B5_2B1_1B2_Ref = object {
  _Leaf1B3_1B5_2B1_1B2
  scale 0.7
  rotate <0.0, 50.348461, 304.801941>
  translate  <-6.35378, 1.09172, 9.02106>
}
#declare _Leaf1B3_1B5_2B1_1B3_Ref = object {
  _Leaf1B3_1B5_2B1_1B3
  scale 0.7
  rotate <0.0, 103.91259, 193.475555>
  translate  <-6.42659, 1.05329, 9.09371>
}
#declare _Leaf1B3_1B5_2B1_1B4_Ref = object {
  _Leaf1B3_1B5_2B1_1B4
  scale 0.7
  rotate <0.0, 167.279892, 270.225311>
  translate  <-6.42035, 1.0349, 9.08337>
}
#declare _Leaf1B3_1B5_2B1_1B5_Ref = object {
  _Leaf1B3_1B5_2B1_1B5
  scale 0.7
  rotate <0.0, 53.787411, 36.963928>
  translate  <-6.42355, 1.00127, 9.18671>
}
#declare _Leaf1B3_1B5_2B1_1B6_Ref = object {
  _Leaf1B3_1B5_2B1_1B6
  scale 0.7
  rotate <0.0, 37.11581, 131.450836>
  translate  <-6.53375, 0.84218, 9.41673>
}
#declare _Leaf1B3_1B5_2B1_1B7_Ref = object {
  _Leaf1B3_1B5_2B1_1B7
  scale 0.7
  rotate <0.0, 71.343529, 336.259644>
  translate  <-6.54549, 0.76853, 9.48889>
}
#declare _Leaf1B3_1B5_2B1_1B8_Ref = object {
  _Leaf1B3_1B5_2B1_1B8
  scale 0.7
  rotate <0.0, 97.607483, 312.576263>
  translate  <-6.61229, 0.65657, 9.64075>
}
#declare _Leaf1B3_1B5_2B1_1B9_Ref = object {
  _Leaf1B3_1B5_2B1_1B9
  scale 0.7
  rotate <0.0, 69.677902, 122.898399>
  translate  <-6.61852, 0.67491, 9.65106>
}
#declare _Leaf1B3_1B5_2B1_1B10_Ref = object {
  _Leaf1B3_1B5_2B1_1B10
  scale 0.7
  rotate <0.0, 38.98827, 191.733887>
  translate  <-6.68959, 0.56344, 9.80158>
}
#declare _Leaf1B3_1B5_2B1_1B11_Ref = object {
  _Leaf1B3_1B5_2B1_1B11
  scale 0.7
  rotate <0.0, 79.292137, 216.914169>
  translate  <-6.69167, 0.55581, 9.79546>
}
#declare _Leaf1B3_1B5_2B1_1B12_Ref = object {
  _Leaf1B3_1B5_2B1_1B12
  scale 0.7
  rotate <0.0, 117.857857, 253.002945>
  translate  <-6.68467, 0.54896, 9.79344>
}
#declare _Leaf1B3_1B5_2B2_1B1_Ref = object {
  _Leaf1B3_1B5_2B2_1B1
  scale 0.7
  rotate <0.0, 127.81649, 203.677094>
  translate  <-6.80933, 1.15741, 8.70519>
}
#declare _Leaf1B3_1B5_2B2_1B2_Ref = object {
  _Leaf1B3_1B5_2B2_1B2
  scale 0.7
  rotate <0.0, 130.211746, 260.329742>
  translate  <-6.94411, 1.01133, 8.67194>
}
#declare _Leaf1B3_1B5_2B2_1B3_Ref = object {
  _Leaf1B3_1B5_2B2_1B3
  scale 0.7
  rotate <0.0, 79.114868, 146.472916>
  translate  <-7.04397, 0.96715, 8.68342>
}
#declare _Leaf1B3_1B5_2B2_1B4_Ref = object {
  _Leaf1B3_1B5_2B2_1B4
  scale 0.7
  rotate <0.0, 110.902031, 78.961639>
  translate  <-7.04468, 0.97466, 8.66276>
}
#declare _Leaf1B3_1B5_2B2_1B5_Ref = object {
  _Leaf1B3_1B5_2B2_1B5
  scale 0.7
  rotate <0.0, 76.576141, 307.661469>
  translate  <-7.09369, 0.8782, 8.65208>
}
#declare _Leaf1B3_1B5_2B2_1B6_Ref = object {
  _Leaf1B3_1B5_2B2_1B6
  scale 0.7
  rotate <0.0, 44.715931, 240.719635>
  translate  <-7.32855, 0.69761, 8.60119>
}
#declare _Leaf1B3_1B5_2B2_1B7_Ref = object {
  _Leaf1B3_1B5_2B2_1B7
  scale 0.7
  rotate <0.0, 132.297806, 306.395874>
  translate  <-7.39483, 0.63313, 8.55411>
}
#declare _Leaf1B3_1B5_2B2_1B8_Ref = object {
  _Leaf1B3_1B5_2B2_1B8
  scale 0.7
  rotate <0.0, 164.790833, 336.270172>
  translate  <-7.54831, 0.51185, 8.51174>
}
#declare _Leaf1B3_1B5_2B2_1B9_Ref = object {
  _Leaf1B3_1B5_2B2_1B9
  scale 0.7
  rotate <0.0, 11.94512, 226.718994>
  translate  <-7.54761, 0.50436, 8.53235>
}
#declare _Leaf1B3_1B5_2B2_1B10_Ref = object {
  _Leaf1B3_1B5_2B2_1B10
  scale 0.7
  rotate <0.0, 72.717758, 213.402908>
  translate  <-7.70399, 0.38578, 8.49213>
}
#declare _Leaf1B3_1B5_2B2_1B11_Ref = object {
  _Leaf1B3_1B5_2B2_1B11
  scale 0.7
  rotate <0.0, 97.476563, 175.059937>
  translate  <-7.70761, 0.3922, 8.48536>
}
#declare _Leaf1B3_1B5_2B2_1B12_Ref = object {
  _Leaf1B3_1B5_2B2_1B12
  scale 0.7
  rotate <0.0, 134.574997, 132.939072>
  translate  <-7.70454, 0.3917, 8.47586>
}
#declare _Leaf1B3_1B5_2B3_1B1_Ref = object {
  _Leaf1B3_1B5_2B3_1B1
  scale 0.7
  rotate <0.0, 14.7871, 103.976158>
  translate  <-7.2391, 1.44352, 9.27296>
}
#declare _Leaf1B3_1B5_2B3_1B2_Ref = object {
  _Leaf1B3_1B5_2B3_1B2
  scale 0.7
  rotate <0.0, 54.953491, 69.501701>
  translate  <-7.32358, 1.57018, 9.405>
}
#declare _Leaf1B3_1B5_2B3_1B3_Ref = object {
  _Leaf1B3_1B5_2B3_1B3
  scale 0.7
  rotate <0.0, 63.38863, 228.307693>
  translate  <-7.40367, 1.59841, 9.4746>
}
#declare _Leaf1B3_1B5_2B3_1B4_Ref = object {
  _Leaf1B3_1B5_2B3_1B4
  scale 0.7
  rotate <0.0, 87.503036, 301.115662>
  translate  <-7.38765, 1.59226, 9.48836>
}
#declare _Leaf1B3_1B5_2B3_1B5_Ref = object {
  _Leaf1B3_1B5_2B3_1B5
  scale 0.7
  rotate <0.0, 123.080368, 83.017883>
  translate  <-7.42576, 1.68099, 9.5383>
}
#declare _Leaf1B3_1B5_2B3_1B6_Ref = object {
  _Leaf1B3_1B5_2B3_1B6
  scale 0.7
  rotate <0.0, 100.123528, 148.898193>
  translate  <-7.56738, 1.82823, 9.75881>
}
#declare _Leaf1B3_1B5_2B3_1B7_Ref = object {
  _Leaf1B3_1B5_2B3_1B7
  scale 0.7
  rotate <0.0, 80.794922, 44.857922>
  translate  <-7.58498, 1.88528, 9.84369>
}
#declare _Leaf1B3_1B5_2B3_1B8_Ref = object {
  _Leaf1B3_1B5_2B3_1B8
  scale 0.7
  rotate <0.0, 61.988998, 13.29237>
  translate  <-7.67123, 1.98531, 9.99406>
}
#declare _Leaf1B3_1B5_2B3_1B9_Ref = object {
  _Leaf1B3_1B5_2B3_1B9
  scale 0.7
  rotate <0.0, 122.327728, 175.69429>
  translate  <-7.68721, 1.99145, 9.98034>
}
#declare _Leaf1B3_1B5_2B3_1B10_Ref = object {
  _Leaf1B3_1B5_2B3_1B10
  scale 0.7
  rotate <0.0, 64.505463, 154.920837>
  translate  <-7.77654, 2.08826, 10.13127>
}
#declare _Leaf1B3_1B5_2B3_1B11_Ref = object {
  _Leaf1B3_1B5_2B3_1B11
  scale 0.7
  rotate <0.0, 35.31419, 202.398438>
  translate  <-7.77293, 2.08184, 10.13804>
}
#declare _Leaf1B3_1B5_2B3_1B12_Ref = object {
  _Leaf1B3_1B5_2B3_1B12
  scale 0.7
  rotate <0.0, 37.50988, 297.630127>
  translate  <-7.76393, 2.08341, 10.14211>
}
#declare _Leaf1B3_1B5_2B4_1B1_Ref = object {
  _Leaf1B3_1B5_2B4_1B1
  scale 0.7
  rotate <0.0, 93.047707, 124.934532>
  translate  <-7.56003, 1.43021, 9.0465>
}
#declare _Leaf1B3_1B5_2B4_1B2_Ref = object {
  _Leaf1B3_1B5_2B4_1B2
  scale 0.7
  rotate <0.0, 135.19342, 113.502007>
  translate  <-7.73216, 1.50589, 8.97399>
}
#declare _Leaf1B3_1B5_2B4_1B3_Ref = object {
  _Leaf1B3_1B5_2B4_1B3
  scale 0.7
  rotate <0.0, 28.69138, 167.859924>
  translate  <-7.8393, 1.52838, 8.98242>
}
#declare _Leaf1B3_1B5_2B4_1B4_Ref = object {
  _Leaf1B3_1B5_2B4_1B4
  scale 0.7
  rotate <0.0, 48.528099, 22.09049>
  translate  <-7.83023, 1.54812, 8.98585>
}
#declare _Leaf1B3_1B5_2B4_1B5_Ref = object {
  _Leaf1B3_1B5_2B4_1B5
  scale 0.7
  rotate <0.0, 154.748642, 276.932373>
  translate  <-7.91415, 1.57404, 8.92177>
}
#declare _Leaf1B3_1B5_2B4_1B6_Ref = object {
  _Leaf1B3_1B5_2B4_1B6
  scale 0.7
  rotate <0.0, 105.22348, 215.291626>
  translate  <-8.18043, 1.69977, 8.86138>
}
#declare _Leaf1B3_1B5_2B4_1B7_Ref = object {
  _Leaf1B3_1B5_2B4_1B7
  scale 0.7
  rotate <0.0, 146.398712, 60.640099>
  translate  <-8.25256, 1.76598, 8.82701>
}
#declare _Leaf1B3_1B5_2B4_1B8_Ref = object {
  _Leaf1B3_1B5_2B4_1B8
  scale 0.7
  rotate <0.0, 111.281326, 62.604591>
  translate  <-8.4255, 1.8567, 8.78317>
}
#declare _Leaf1B3_1B5_2B4_1B9_Ref = object {
  _Leaf1B3_1B5_2B4_1B9
  scale 0.7
  rotate <0.0, 84.474571, 241.484863>
  translate  <-8.43454, 1.837, 8.77974>
}
#declare _Leaf1B3_1B5_2B4_1B10_Ref = object {
  _Leaf1B3_1B5_2B4_1B10
  scale 0.7
  rotate <0.0, 92.852837, 180.867538>
  translate  <-8.60919, 1.9267, 8.73993>
}
#declare _Leaf1B3_1B5_2B4_1B11_Ref = object {
  _Leaf1B3_1B5_2B4_1B11
  scale 0.7
  rotate <0.0, 59.995209, 148.282547>
  translate  <-8.60711, 1.93433, 8.74605>
}
#declare _Leaf1B3_1B5_2B4_1B12_Ref = object {
  _Leaf1B3_1B5_2B4_1B12
  scale 0.7
  rotate <0.0, 56.03503, 86.157959>
  translate  <-8.60205, 1.94225, 8.74263>
}
#declare _Leaf1B3_1B5_2B5_1B1_Ref = object {
  _Leaf1B3_1B5_2B5_1B1
  scale 0.7
  rotate <0.0, 93.717072, 173.702316>
  translate  <-7.86851, 1.23115, 9.34141>
}
#declare _Leaf1B3_1B5_2B5_1B2_Ref = object {
  _Leaf1B3_1B5_2B5_1B2
  scale 0.7
  rotate <0.0, 98.244751, 217.049194>
  translate  <-8.04428, 1.19271, 9.4322>
}
#declare _Leaf1B3_1B5_2B5_1B3_Ref = object {
  _Leaf1B3_1B5_2B5_1B3
  scale 0.7
  rotate <0.0, 75.594368, 103.070518>
  translate  <-8.12571, 1.21924, 9.5009>
}
#declare _Leaf1B3_1B5_2B5_1B4_Ref = object {
  _Leaf1B3_1B5_2B5_1B4
  scale 0.7
  rotate <0.0, 139.119125, 61.14352>
  translate  <-8.13489, 1.22307, 9.48128>
}
#declare _Leaf1B3_1B5_2B5_1B5_Ref = object {
  _Leaf1B3_1B5_2B5_1B5
  scale 0.7
  rotate <0.0, 73.761818, 282.574493>
  translate  <-8.21685, 1.17504, 9.53416>
}
#declare _Leaf1B3_1B5_2B5_1B6_Ref = object {
  _Leaf1B3_1B5_2B5_1B6
  scale 0.7
  rotate <0.0, 12.27824, 244.069214>
  translate  <-8.48685, 1.16734, 9.66608>
}
#declare _Leaf1B3_1B5_2B5_1B7_Ref = object {
  _Leaf1B3_1B5_2B5_1B7
  scale 0.7
  rotate <0.0, 117.563187, 247.017456>
  translate  <-8.58787, 1.1505, 9.68277>
}
#declare _Leaf1B3_1B5_2B5_1B8_Ref = object {
  _Leaf1B3_1B5_2B5_1B8
  scale 0.7
  rotate <0.0, 146.040024, 218.197433>
  translate  <-8.77101, 1.14179, 9.76305>
}
#declare _Leaf1B3_1B5_2B5_1B9_Ref = object {
  _Leaf1B3_1B5_2B5_1B9
  scale 0.7
  rotate <0.0, 24.327971, 11.99235>
  translate  <-8.76185, 1.13796, 9.78262>
}
#declare _Leaf1B3_1B5_2B5_1B10_Ref = object {
  _Leaf1B3_1B5_2B5_1B10
  scale 0.7
  rotate <0.0, 37.92561, 170.625473>
  translate  <-8.94458, 1.13338, 9.86463>
}
#declare _Leaf1B3_1B5_2B5_1B11_Ref = object {
  _Leaf1B3_1B5_2B5_1B11
  scale 0.7
  rotate <0.0, 75.080017, 138.103989>
  translate  <-8.94819, 1.1398, 9.85786>
}
#declare _Leaf1B3_1B5_2B5_1B12_Ref = object {
  _Leaf1B3_1B5_2B5_1B12
  scale 0.7
  rotate <0.0, 126.512627, 129.748779>
  translate  <-8.9518, 1.1364, 9.84918>
}
#declare _Leaf1B3_1B5_1B1_1B1_Ref = object {
  _Leaf1B3_1B5_1B1_1B1
  scale 0.7
  rotate <0.0, 123.436302, 200.032913>
  translate  <-4.96385, 1.20388, 7.76263>
}
#declare _Leaf1B3_1B5_1B1_1B2_Ref = object {
  _Leaf1B3_1B5_1B1_1B2
  scale 0.7
  rotate <0.0, 127.230164, 253.652481>
  translate  <-5.11041, 1.06679, 7.74421>
}
#declare _Leaf1B3_1B5_1B1_1B3_Ref = object {
  _Leaf1B3_1B5_1B1_1B3
  scale 0.7
  rotate <0.0, 77.273361, 141.572647>
  translate  <-5.21207, 1.03035, 7.764>
}
#declare _Leaf1B3_1B5_1B1_1B4_Ref = object {
  _Leaf1B3_1B5_1B1_1B4
  scale 0.7
  rotate <0.0, 113.847641, 76.258141>
  translate  <-5.21367, 1.03715, 7.74314>
}
#declare _Leaf1B3_1B5_1B1_1B5_Ref = object {
  _Leaf1B3_1B5_1B1_1B5
  scale 0.7
  rotate <0.0, 77.095131, 304.627991>
  translate  <-5.26988, 0.94416, 7.73959>
}
#declare _Leaf1B3_1B5_1B1_1B6_Ref = object {
  _Leaf1B3_1B5_1B1_1B6
  scale 0.7
  rotate <0.0, 40.907478, 239.081284>
  translate  <-5.51963, 0.77925, 7.71155>
}
#declare _Leaf1B3_1B5_1B1_1B7_Ref = object {
  _Leaf1B3_1B5_1B1_1B7
  scale 0.7
  rotate <0.0, 132.525146, 298.30191>
  translate  <-5.5933, 0.71807, 7.67155>
}
#declare _Leaf1B3_1B5_1B1_1B8_Ref = object {
  _Leaf1B3_1B5_1B1_1B8
  scale 0.7
  rotate <0.0, 166.818375, 316.594543>
  translate  <-5.75737, 0.60673, 7.64428>
}
#declare _Leaf1B3_1B5_1B1_1B9_Ref = object {
  _Leaf1B3_1B5_1B1_1B9
  scale 0.7
  rotate <0.0, 7.76957, 231.17804>
  translate  <-5.75578, 0.59995, 7.66508>
}
#declare _Leaf1B3_1B5_1B1_1B10_Ref = object {
  _Leaf1B3_1B5_1B1_1B10
  scale 0.7
  rotate <0.0, 68.30204, 209.397171>
  translate  <-5.9224, 0.49158, 7.64002>
}
#declare _Leaf1B3_1B5_1B1_1B11_Ref = object {
  _Leaf1B3_1B5_1B1_1B11
  scale 0.7
  rotate <0.0, 93.912392, 171.260254>
  translate  <-5.92601, 0.498, 7.63325>
}
#declare _Leaf1B3_1B5_1B1_1B12_Ref = object {
  _Leaf1B3_1B5_1B1_1B12
  scale 0.7
  rotate <0.0, 133.53595, 133.037247>
  translate  <-5.92365, 0.49694, 7.62359>
}
#declare _Leaf1B3_1B5_1B2_1B1_Ref = object {
  _Leaf1B3_1B5_1B2_1B1
  scale 0.7
  rotate <0.0, 68.73317, 108.541222>
  translate  <-5.3534, 1.60334, 8.09485>
}
#declare _Leaf1B3_1B5_1B2_1B2_Ref = object {
  _Leaf1B3_1B5_1B2_1B2
  scale 0.7
  rotate <0.0, 110.036873, 95.16703>
  translate  <-5.49569, 1.7457, 8.08466>
}
#declare _Leaf1B3_1B5_1B2_1B3_Ref = object {
  _Leaf1B3_1B5_1B2_1B3
  scale 0.7
  rotate <0.0, 25.473301, 201.837387>
  translate  <-5.5907, 1.79024, 8.11694>
}
#declare _Leaf1B3_1B5_1B2_1B4_Ref = object {
  _Leaf1B3_1B5_1B2_1B4
  scale 0.7
  rotate <0.0, 52.382099, 343.58432>
  translate  <-5.57599, 1.80343, 8.12662>
}
#declare _Leaf1B3_1B5_1B2_1B5_Ref = object {
  _Leaf1B3_1B5_1B2_1B5
  scale 0.7
  rotate <0.0, 174.401947, 177.288132>
  translate  <-5.64926, 1.87555, 8.09125>
}
#declare _Leaf1B3_1B5_1B2_1B6_Ref = object {
  _Leaf1B3_1B5_1B2_1B6
  scale 0.7
  rotate <0.0, 110.198723, 189.781525>
  translate  <-5.86573, 2.08124, 8.12579>
}
#declare _Leaf1B3_1B5_1B2_1B7_Ref = object {
  _Leaf1B3_1B5_1B2_1B7
  scale 0.7
  rotate <0.0, 126.91243, 60.878761>
  translate  <-5.91493, 2.17241, 8.1317>
}
#declare _Leaf1B3_1B5_1B2_1B8_Ref = object {
  _Leaf1B3_1B5_1B2_1B8
  scale 0.7
  rotate <0.0, 93.465637, 49.127979>
  translate  <-6.05285, 2.3158, 8.15357>
}
#declare _Leaf1B3_1B5_1B2_1B9_Ref = object {
  _Leaf1B3_1B5_1B2_1B9
  scale 0.7
  rotate <0.0, 101.126228, 223.055984>
  translate  <-6.06752, 2.30265, 8.14393>
}
#declare _Leaf1B3_1B5_1B2_1B10_Ref = object {
  _Leaf1B3_1B5_1B2_1B10
  scale 0.7
  rotate <0.0, 84.552399, 163.933411>
  translate  <-6.20731, 2.4439, 8.16929>
}
#declare _Leaf1B3_1B5_1B2_1B11_Ref = object {
  _Leaf1B3_1B5_1B2_1B11
  scale 0.7
  rotate <0.0, 42.080582, 145.636124>
  translate  <-6.20288, 2.44733, 8.17758>
}
#declare _Leaf1B3_1B5_1B2_1B12_Ref = object {
  _Leaf1B3_1B5_1B2_1B12
  scale 0.7
  rotate <0.0, 34.08654, 55.713169>
  translate  <-6.19572, 2.45428, 8.17691>
}
#declare _Leaf1B3_1B5_1B3_1B1_Ref = object {
  _Leaf1B3_1B5_1B3_1B1
  scale 0.7
  rotate <0.0, 36.97036, 264.01767>
  translate  <-5.39242, 1.30865, 8.44604>
}
#declare _Leaf1B3_1B5_1B3_1B2_Ref = object {
  _Leaf1B3_1B5_1B3_1B2
  scale 0.7
  rotate <0.0, 34.468578, 342.356293>
  translate  <-5.4228, 1.30326, 8.64519>
}
#declare _Leaf1B3_1B5_1B3_1B3_Ref = object {
  _Leaf1B3_1B5_1B3_1B3
  scale 0.7
  rotate <0.0, 91.36718, 206.565979>
  translate  <-5.48809, 1.29505, 8.73308>
}
#declare _Leaf1B3_1B5_1B3_1B4_Ref = object {
  _Leaf1B3_1B5_1B3_1B4
  scale 0.7
  rotate <0.0, 138.309753, 273.011749>
  translate  <-5.47892, 1.27507, 8.73235>
}
#declare _Leaf1B3_1B5_1B3_1B5_Ref = object {
  _Leaf1B3_1B5_1B3_1B5
  scale 0.7
  rotate <0.0, 76.676788, 55.078499>
  translate  <-5.47628, 1.29589, 8.83903>
}
#declare _Leaf1B3_1B5_1B3_1B6_Ref = object {
  _Leaf1B3_1B5_1B3_1B6
  scale 0.7
  rotate <0.0, 59.152431, 122.938293>
  translate  <-5.55815, 1.25489, 9.12535>
}
#declare _Leaf1B3_1B5_1B3_1B7_Ref = object {
  _Leaf1B3_1B5_1B3_1B7
  scale 0.7
  rotate <0.0, 66.988068, 356.952606>
  translate  <-5.55739, 1.22485, 9.22467>
}
#declare _Leaf1B3_1B5_1B3_1B8_Ref = object {
  _Leaf1B3_1B5_1B3_1B8
  scale 0.7
  rotate <0.0, 79.686111, 322.60849>
  translate  <-5.60442, 1.19266, 9.41653>
}
#declare _Leaf1B3_1B5_1B3_1B9_Ref = object {
  _Leaf1B3_1B5_1B3_1B9
  scale 0.7
  rotate <0.0, 91.840492, 129.192459>
  translate  <-5.61357, 1.21258, 9.41726>
}
#declare _Leaf1B3_1B5_1B3_1B10_Ref = object {
  _Leaf1B3_1B5_1B3_1B10
  scale 0.7
  rotate <0.0, 37.702881, 162.919373>
  translate  <-5.66489, 1.17956, 9.60807>
}
#declare _Leaf1B3_1B5_1B3_1B11_Ref = object {
  _Leaf1B3_1B5_1B3_1B11
  scale 0.7
  rotate <0.0, 59.335709, 218.100769>
  translate  <-5.6657, 1.16971, 9.60655>
}
#declare _Leaf1B3_1B5_1B3_1B12_Ref = object {
  _Leaf1B3_1B5_1B3_1B12
  scale 0.7
  rotate <0.0, 88.945351, 263.319397>
  translate  <-5.65767, 1.16382, 9.6075>
}
#declare _Leaf1B3_1B6_2B1_1B1_Ref = object {
  _Leaf1B3_1B6_2B1_1B1
  scale 0.7
  rotate <0.0, 53.412441, 57.902168>
  translate  <-5.28394, 2.3095, 9.7383>
}
#declare _Leaf1B3_1B6_2B1_1B2_Ref = object {
  _Leaf1B3_1B6_2B1_1B2
  scale 0.7
  rotate <0.0, 95.769836, 67.626488>
  translate  <-5.30736, 2.49021, 9.82439>
}
#declare _Leaf1B3_1B6_2B1_1B3_Ref = object {
  _Leaf1B3_1B6_2B1_1B3
  scale 0.7
  rotate <0.0, 19.55839, 254.757477>
  translate  <-5.33996, 2.55468, 9.90707>
}
#declare _Leaf1B3_1B6_2B1_1B4_Ref = object {
  _Leaf1B3_1B6_2B1_1B4
  scale 0.7
  rotate <0.0, 84.571327, 309.077423>
  translate  <-5.31814, 2.55445, 9.90983>
}
#declare _Leaf1B3_1B6_2B1_1B5_Ref = object {
  _Leaf1B3_1B6_2B1_1B5
  scale 0.7
  rotate <0.0, 142.363205, 130.82579>
  translate  <-5.3409, 2.65911, 9.92849>
}
#declare _Leaf1B3_1B6_2B1_1B6_Ref = object {
  _Leaf1B3_1B6_2B1_1B6
  scale 0.7
  rotate <0.0, 81.149239, 153.961853>
  translate  <-5.36637, 2.90457, 10.10014>
}
#declare _Leaf1B3_1B6_2B1_1B7_Ref = object {
  _Leaf1B3_1B6_2B1_1B7
  scale 0.7
  rotate <0.0, 126.6688, 51.428848>
  translate  <-5.34647, 2.99627, 10.14445>
}
#declare _Leaf1B3_1B6_2B1_1B8_Ref = object {
  _Leaf1B3_1B6_2B1_1B8
  scale 0.7
  rotate <0.0, 105.411484, 19.880369>
  translate  <-5.35542, 3.16246, 10.25562>
}
#declare _Leaf1B3_1B6_2B1_1B9_Ref = object {
  _Leaf1B3_1B6_2B1_1B9
  scale 0.7
  rotate <0.0, 84.431007, 187.301315>
  translate  <-5.37719, 3.16269, 10.25288>
}
#declare _Leaf1B3_1B6_2B1_1B10_Ref = object {
  _Leaf1B3_1B6_2B1_1B10
  scale 0.7
  rotate <0.0, 52.36747, 129.819061>
  translate  <-5.38762, 3.32657, 10.36762>
}
#declare _Leaf1B3_1B6_2B1_1B11_Ref = object {
  _Leaf1B3_1B6_2B1_1B11
  scale 0.7
  rotate <0.0, 14.30285, 74.816063>
  translate  <-5.37959, 3.32385, 10.37291>
}
#declare _Leaf1B3_1B6_2B1_1B12_Ref = object {
  _Leaf1B3_1B6_2B1_1B12
  scale 0.7
  rotate <0.0, 52.228249, 351.184326>
  translate  <-5.37043, 3.32639, 10.36979>
}
#declare _Leaf1B3_1B6_2B2_1B1_Ref = object {
  _Leaf1B3_1B6_2B2_1B1
  scale 0.7
  rotate <0.0, 38.226398, 293.370148>
  translate  <-5.39501, 2.08536, 10.19861>
}
#declare _Leaf1B3_1B6_2B2_1B2_Ref = object {
  _Leaf1B3_1B6_2B2_1B2
  scale 0.7
  rotate <0.0, 63.027618, 341.065735>
  translate  <-5.31825, 2.08708, 10.38494>
}
#declare _Leaf1B3_1B6_2B2_1B3_Ref = object {
  _Leaf1B3_1B6_2B2_1B3
  scale 0.7
  rotate <0.0, 61.109509, 195.398529>
  translate  <-5.32873, 2.09393, 10.49402>
}
#declare _Leaf1B3_1B6_2B2_1B4_Ref = object {
  _Leaf1B3_1B6_2B2_1B4
  scale 0.7
  rotate <0.0, 125.324142, 233.403549>
  translate  <-5.32534, 2.07239, 10.49113>
}
#declare _Leaf1B3_1B6_2B2_1B5_Ref = object {
  _Leaf1B3_1B6_2B2_1B5
  scale 0.7
  rotate <0.0, 100.238663, 41.392841>
  translate  <-5.26386, 2.09211, 10.5786>
}
#declare _Leaf1B3_1B6_2B2_1B6_Ref = object {
  _Leaf1B3_1B6_2B2_1B6
  scale 0.7
  rotate <0.0, 53.903641, 88.841019>
  translate  <-5.19176, 2.07086, 10.86966>
}
#declare _Leaf1B3_1B6_2B2_1B7_Ref = object {
  _Leaf1B3_1B6_2B2_1B7
  scale 0.7
  rotate <0.0, 97.08004, 345.042358>
  translate  <-5.14554, 2.04146, 10.95779>
}
#declare _Leaf1B3_1B6_2B2_1B8_Ref = object {
  _Leaf1B3_1B6_2B2_1B8
  scale 0.7
  rotate <0.0, 99.821564, 309.600952>
  translate  <-5.09162, 2.02086, 11.14943>
}
#declare _Leaf1B3_1B6_2B2_1B9_Ref = object {
  _Leaf1B3_1B6_2B2_1B9
  scale 0.7
  rotate <0.0, 78.478981, 113.620659>
  translate  <-5.095, 2.04234, 11.15231>
}
#declare _Leaf1B3_1B6_2B2_1B10_Ref = object {
  _Leaf1B3_1B6_2B2_1B10
  scale 0.7
  rotate <0.0, 18.1094, 97.866798>
  translate  <-5.04536, 2.02189, 11.34532>
}
#declare _Leaf1B3_1B6_2B2_1B11_Ref = object {
  _Leaf1B3_1B6_2B2_1B11
  scale 0.7
  rotate <0.0, 32.84343, 222.027557>
  translate  <-5.04873, 2.01248, 11.34559>
}
#declare _Leaf1B3_1B6_2B2_1B12_Ref = object {
  _Leaf1B3_1B6_2B2_1B12
  scale 0.7
  rotate <0.0, 78.965363, 253.42276>
  translate  <-5.04269, 2.00493, 11.34304>
}
#declare _Leaf1B3_1B6_2B3_1B1_Ref = object {
  _Leaf1B3_1B6_2B3_1B1
  scale 0.7
  rotate <0.0, 93.039993, 132.110336>
  translate  <-6.05704, 2.3777, 10.45394>
}
#declare _Leaf1B3_1B6_2B3_1B2_Ref = object {
  _Leaf1B3_1B6_2B3_1B2
  scale 0.7
  rotate <0.0, 126.967392, 161.439285>
  translate  <-6.25226, 2.42424, 10.4722>
}
#declare _Leaf1B3_1B6_2B3_1B3_Ref = object {
  _Leaf1B3_1B6_2B3_1B3
  scale 0.7
  rotate <0.0, 33.331779, 81.56852>
  translate  <-6.339, 2.45699, 10.53101>
}
#declare _Leaf1B3_1B6_2B3_1B4_Ref = object {
  _Leaf1B3_1B6_2B3_1B4
  scale 0.7
  rotate <0.0, 94.036041, 30.218121>
  translate  <-6.33412, 2.47517, 10.51961>
}
#declare _Leaf1B3_1B6_2B3_1B5_Ref = object {
  _Leaf1B3_1B6_2B3_1B5
  scale 0.7
  rotate <0.0, 118.150124, 245.749603>
  translate  <-6.44266, 2.47462, 10.51343>
}
#declare _Leaf1B3_1B6_2B3_1B6_Ref = object {
  _Leaf1B3_1B6_2B3_1B6
  scale 0.7
  rotate <0.0, 58.775791, 219.731293>
  translate  <-6.71815, 2.57873, 10.57364>
}
#declare _Leaf1B3_1B6_2B3_1B7_Ref = object {
  _Leaf1B3_1B6_2B3_1B7
  scale 0.7
  rotate <0.0, 159.900635, 179.077789>
  translate  <-6.8097, 2.62659, 10.56377>
}
#declare _Leaf1B3_1B6_2B3_1B8_Ref = object {
  _Leaf1B3_1B6_2B3_1B8
  scale 0.7
  rotate <0.0, 148.777145, 93.777481>
  translate  <-6.99314, 2.69996, 10.5958>
}
#declare _Leaf1B3_1B6_2B3_1B9_Ref = object {
  _Leaf1B3_1B6_2B3_1B9
  scale 0.7
  rotate <0.0, 44.040421, 258.441711>
  translate  <-6.99801, 2.68184, 10.60717>
}
#declare _Leaf1B3_1B6_2B3_1B10_Ref = object {
  _Leaf1B3_1B6_2B3_1B10
  scale 0.7
  rotate <0.0, 56.216759, 176.725479>
  translate  <-7.18039, 2.75637, 10.64342>
}
#declare _Leaf1B3_1B6_2B3_1B11_Ref = object {
  _Leaf1B3_1B6_2B3_1B11
  scale 0.7
  rotate <0.0, 54.538631, 121.003929>
  translate  <-7.17702, 2.76578, 10.64315>
}
#declare _Leaf1B3_1B6_2B3_1B12_Ref = object {
  _Leaf1B3_1B6_2B3_1B12
  scale 0.7
  rotate <0.0, 90.121368, 80.18718>
  translate  <-7.17655, 2.77068, 10.63445>
}
#declare _Leaf1B3_1B6_2B4_1B1_Ref = object {
  _Leaf1B3_1B6_2B4_1B1
  scale 0.7
  rotate <0.0, 82.155296, 210.810486>
  translate  <-6.06991, 2.11355, 10.74467>
}
#declare _Leaf1B3_1B6_2B4_1B2_Ref = object {
  _Leaf1B3_1B6_2B4_1B2
  scale 0.7
  rotate <0.0, 92.709198, 252.934753>
  translate  <-6.16495, 1.98111, 10.86316>
}
#declare _Leaf1B3_1B6_2B4_1B3_Ref = object {
  _Leaf1B3_1B6_2B4_1B3
  scale 0.7
  rotate <0.0, 67.892906, 136.814178>
  translate  <-6.22957, 1.95625, 10.94838>
}
#declare _Leaf1B3_1B6_2B4_1B4_Ref = object {
  _Leaf1B3_1B6_2B4_1B4
  scale 0.7
  rotate <0.0, 138.004013, 112.124207>
  translate  <-6.24312, 1.95311, 10.93133>
}
#declare _Leaf1B3_1B6_2B4_1B5_Ref = object {
  _Leaf1B3_1B6_2B4_1B5
  scale 0.7
  rotate <0.0, 81.815247, 321.56424>
  translate  <-6.26743, 1.86762, 10.99396>
}
#declare _Leaf1B3_1B6_2B4_1B6_Ref = object {
  _Leaf1B3_1B6_2B4_1B6
  scale 0.7
  rotate <0.0, 17.508551, 325.018738>
  translate  <-6.44536, 1.70502, 11.17358>
}
#declare _Leaf1B3_1B6_2B4_1B7_Ref = object {
  _Leaf1B3_1B6_2B4_1B7
  scale 0.7
  rotate <0.0, 117.720932, 277.467468>
  translate  <-6.51057, 1.63179, 11.20752>
}
#declare _Leaf1B3_1B6_2B4_1B8_Ref = object {
  _Leaf1B3_1B6_2B4_1B8
  scale 0.7
  rotate <0.0, 139.463196, 241.246552>
  translate  <-6.63114, 1.51836, 11.32003>
}
#declare _Leaf1B3_1B6_2B4_1B9_Ref = object {
  _Leaf1B3_1B6_2B4_1B9
  scale 0.7
  rotate <0.0, 34.761471, 37.005699>
  translate  <-6.61762, 1.52149, 11.33702>
}
#declare _Leaf1B3_1B6_2B4_1B10_Ref = object {
  _Leaf1B3_1B6_2B4_1B10
  scale 0.7
  rotate <0.0, 26.372841, 214.700912>
  translate  <-6.73994, 1.41168, 11.45154>
}
#declare _Leaf1B3_1B6_2B4_1B11_Ref = object {
  _Leaf1B3_1B6_2B4_1B11
  scale 0.7
  rotate <0.0, 63.172482, 173.783966>
  translate  <-6.74797, 1.41441, 11.44625>
}
#declare _Leaf1B3_1B6_2B4_1B12_Ref = object {
  _Leaf1B3_1B6_2B4_1B12
  scale 0.7
  rotate <0.0, 115.038879, 169.455963>
  translate  <-6.75061, 1.40921, 11.43812>
}
#declare _Leaf1B3_1B6_2B5_1B1_Ref = object {
  _Leaf1B3_1B6_2B5_1B1
  scale 0.7
  rotate <0.0, 33.577808, 214.854599>
  translate  <-6.17345, 2.39023, 11.11139>
}
#declare _Leaf1B3_1B6_2B5_1B2_Ref = object {
  _Leaf1B3_1B6_2B5_1B2
  scale 0.7
  rotate <0.0, 13.10548, 346.882385>
  translate  <-6.25575, 2.44861, 11.28584>
}
#declare _Leaf1B3_1B6_2B5_1B3_Ref = object {
  _Leaf1B3_1B6_2B5_1B3
  scale 0.7
  rotate <0.0, 103.472069, 192.802475>
  translate  <-6.34127, 2.48098, 11.34663>
}
#declare _Leaf1B3_1B6_2B5_1B4_Ref = object {
  _Leaf1B3_1B6_2B5_1B4
  scale 0.7
  rotate <0.0, 123.079201, 271.738739>
  translate  <-6.33885, 2.46005, 11.35296>
}
#declare _Leaf1B3_1B6_2B5_1B5_Ref = object {
  _Leaf1B3_1B6_2B5_1B5
  scale 0.7
  rotate <0.0, 76.019897, 44.370129>
  translate  <-6.35836, 2.509, 11.44806>
}
#declare _Leaf1B3_1B6_2B5_1B6_Ref = object {
  _Leaf1B3_1B6_2B5_1B6
  scale 0.7
  rotate <0.0, 79.942787, 110.225616>
  translate  <-6.52181, 2.57084, 11.69264>
}
#declare _Leaf1B3_1B6_2B5_1B7_Ref = object {
  _Leaf1B3_1B6_2B5_1B7
  scale 0.7
  rotate <0.0, 47.369308, 348.388397>
  translate  <-6.55676, 2.5708, 11.79035>
}
#declare _Leaf1B3_1B6_2B5_1B8_Ref = object {
  _Leaf1B3_1B6_2B5_1B8
  scale 0.7
  rotate <0.0, 57.042931, 305.081329>
  translate  <-6.6606, 2.60604, 11.95779>
}
#declare _Leaf1B3_1B6_2B5_1B9_Ref = object {
  _Leaf1B3_1B6_2B5_1B9
  scale 0.7
  rotate <0.0, 113.159981, 111.004539>
  translate  <-6.663, 2.62691, 11.95147>
}
#declare _Leaf1B3_1B6_2B5_1B10_Ref = object {
  _Leaf1B3_1B6_2B5_1B10
  scale 0.7
  rotate <0.0, 60.108898, 142.597763>
  translate  <-6.77074, 2.66206, 12.11667>
}
#declare _Leaf1B3_1B6_2B5_1B11_Ref = object {
  _Leaf1B3_1B6_2B5_1B11
  scale 0.7
  rotate <0.0, 69.623466, 191.862167>
  translate  <-6.77411, 2.65265, 12.11694>
}
#declare _Leaf1B3_1B6_2B5_1B12_Ref = object {
  _Leaf1B3_1B6_2B5_1B12
  scale 0.7
  rotate <0.0, 80.004822, 244.927063>
  translate  <-6.76884, 2.64558, 12.12166>
}
#declare _Leaf1B3_1B6_1B1_1B1_Ref = object {
  _Leaf1B3_1B6_1B1_1B1
  scale 0.7
  rotate <0.0, 34.360531, 287.268616>
  translate  <-4.25394, 1.62906, 8.52944>
}
#declare _Leaf1B3_1B6_1B1_1B2_Ref = object {
  _Leaf1B3_1B6_1B1_1B2
  scale 0.7
  rotate <0.0, 57.030479, 341.279877>
  translate  <-4.19589, 1.63767, 8.72224>
}
#declare _Leaf1B3_1B6_1B1_1B3_Ref = object {
  _Leaf1B3_1B6_1B1_1B3
  scale 0.7
  rotate <0.0, 66.063263, 193.87645>
  translate  <-4.21706, 1.6483, 8.82945>
}
#declare _Leaf1B3_1B6_1B1_1B4_Ref = object {
  _Leaf1B3_1B6_1B1_1B4
  scale 0.7
  rotate <0.0, 126.847, 237.797531>
  translate  <-4.21338, 1.62668, 8.82767>
}
#declare _Leaf1B3_1B6_1B1_1B5_Ref = object {
  _Leaf1B3_1B6_1B1_1B5
  scale 0.7
  rotate <0.0, 97.308868, 40.74472>
  translate  <-4.16083, 1.64974, 8.92001>
}
#declare _Leaf1B3_1B6_1B1_1B6_Ref = object {
  _Leaf1B3_1B6_1B1_1B6
  scale 0.7
  rotate <0.0, 56.017471, 92.942772>
  translate  <-4.11771, 1.63906, 9.21731>
}
#declare _Leaf1B3_1B6_1B1_1B7_Ref = object {
  _Leaf1B3_1B6_1B1_1B7
  scale 0.7
  rotate <0.0, 91.103348, 345.16684>
  translate  <-4.08035, 1.61298, 9.31054>
}
#declare _Leaf1B3_1B6_1B1_1B8_Ref = object {
  _Leaf1B3_1B6_1B1_1B8
  scale 0.7
  rotate <0.0, 94.647713, 310.147278>
  translate  <-4.04553, 1.59936, 9.50717>
}
#declare _Leaf1B3_1B6_1B1_1B9_Ref = object {
  _Leaf1B3_1B6_1B1_1B9
  scale 0.7
  rotate <0.0, 82.630569, 114.50235>
  translate  <-4.0492, 1.62091, 9.50894>
}
#declare _Leaf1B3_1B6_1B1_1B10_Ref = object {
  _Leaf1B3_1B6_1B1_1B10
  scale 0.7
  rotate <0.0, 21.53657, 111.779182>
  translate  <-4.01878, 1.60748, 9.7065>
}
#declare _Leaf1B3_1B6_1B1_1B11_Ref = object {
  _Leaf1B3_1B6_1B1_1B11
  scale 0.7
  rotate <0.0, 36.021519, 214.748276>
  translate  <-4.02215, 1.59807, 9.70677>
}
#declare _Leaf1B3_1B6_1B1_1B12_Ref = object {
  _Leaf1B3_1B6_1B1_1B12
  scale 0.7
  rotate <0.0, 78.690399, 252.39888>
  translate  <-4.01588, 1.59046, 9.7051>
}
#declare _Leaf1B3_1B6_1B2_1B1_Ref = object {
  _Leaf1B3_1B6_1B2_1B1
  scale 0.7
  rotate <0.0, 97.834587, 186.175919>
  translate  <-4.87987, 1.6748, 8.69623>
}
#declare _Leaf1B3_1B6_1B2_1B2_Ref = object {
  _Leaf1B3_1B6_1B2_1B2
  scale 0.7
  rotate <0.0, 110.612053, 229.054047>
  translate  <-5.04455, 1.5765, 8.75811>
}
#declare _Leaf1B3_1B6_1B2_1B3_Ref = object {
  _Leaf1B3_1B6_1B2_1B3
  scale 0.7
  rotate <0.0, 64.358368, 120.185532>
  translate  <-5.13281, 1.56628, 8.82262>
}
#declare _Leaf1B3_1B6_1B2_1B4_Ref = object {
  _Leaf1B3_1B6_1B2_1B4
  scale 0.7
  rotate <0.0, 124.87278, 76.063782>
  translate  <-5.14182, 1.57258, 8.80356>
}
#declare _Leaf1B3_1B6_1B2_1B5_Ref = object {
  _Leaf1B3_1B6_1B2_1B5
  scale 0.7
  rotate <0.0, 85.424583, 294.909454>
  translate  <-5.21169, 1.49579, 8.83582>
}
#declare _Leaf1B3_1B6_1B2_1B6_Ref = object {
  _Leaf1B3_1B6_1B2_1B6
  scale 0.7
  rotate <0.0, 26.56575, 259.129639>
  translate  <-5.4769, 1.39503, 8.93518>
}
#declare _Leaf1B3_1B6_1B2_1B7_Ref = object {
  _Leaf1B3_1B6_1B2_1B7
  scale 0.7
  rotate <0.0, 131.854858, 261.011017>
  translate  <-5.57136, 1.35212, 8.93754>
}
#declare _Leaf1B3_1B6_1B2_1B8_Ref = object {
  _Leaf1B3_1B6_1B2_1B8
  scale 0.7
  rotate <0.0, 157.721573, 216.173691>
  translate  <-5.75001, 1.28272, 8.99523>
}
#declare _Leaf1B3_1B6_1B2_1B9_Ref = object {
  _Leaf1B3_1B6_1B2_1B9
  scale 0.7
  rotate <0.0, 19.564011, 351.528656>
  translate  <-5.74102, 1.27644, 9.01423>
}
#declare _Leaf1B3_1B6_1B2_1B10_Ref = object {
  _Leaf1B3_1B6_1B2_1B10
  scale 0.7
  rotate <0.0, 43.36729, 200.049393>
  translate  <-5.92036, 1.21062, 9.07456>
}
#declare _Leaf1B3_1B6_1B2_1B11_Ref = object {
  _Leaf1B3_1B6_1B2_1B11
  scale 0.7
  rotate <0.0, 71.08432, 156.168549>
  translate  <-5.92515, 1.21749, 9.0691>
}
#declare _Leaf1B3_1B6_1B2_1B12_Ref = object {
  _Leaf1B3_1B6_1B2_1B12
  scale 0.7
  rotate <0.0, 119.19249, 135.621872>
  translate  <-5.92745, 1.21558, 9.05956>
}
#declare _Leaf1B3_1B6_1B3_1B1_Ref = object {
  _Leaf1B3_1B6_1B3_1B1
  scale 0.7
  rotate <0.0, 70.61721, 85.391418>
  translate  <-4.82606, 2.09873, 8.86678>
}
#declare _Leaf1B3_1B6_1B3_1B2_Ref = object {
  _Leaf1B3_1B6_1B3_1B2
  scale 0.7
  rotate <0.0, 113.463699, 91.971558>
  translate  <-4.92653, 2.27074, 8.89727>
}
#declare _Leaf1B3_1B6_1B3_1B3_Ref = object {
  _Leaf1B3_1B6_1B3_1B3
  scale 0.7
  rotate <0.0, 1.72255, 280.913483>
  translate  <-4.98707, 2.33788, 8.95957>
}
#declare _Leaf1B3_1B6_1B3_1B4_Ref = object {
  _Leaf1B3_1B6_1B3_1B4
  scale 0.7
  rotate <0.0, 74.490936, 336.767914>
  translate  <-4.96728, 2.34745, 8.96049>
}
#declare _Leaf1B3_1B6_1B3_1B5_Ref = object {
  _Leaf1B3_1B6_1B3_1B5
  scale 0.7
  rotate <0.0, 149.083664, 180.517715>
  translate  <-5.03224, 2.43389, 8.9492>
}
#declare _Leaf1B3_1B6_1B3_1B6_Ref = object {
  _Leaf1B3_1B6_1B3_1B6
  scale 0.7
  rotate <0.0, 84.813423, 176.736084>
  translate  <-5.16576, 2.68666, 9.04216>
}
#declare _Leaf1B3_1B6_1B3_1B7_Ref = object {
  _Leaf1B3_1B6_1B3_1B7
  scale 0.7
  rotate <0.0, 142.587769, 68.228218>
  translate  <-5.18789, 2.78714, 9.05565>
}
#declare _Leaf1B3_1B6_1B3_1B8_Ref = object {
  _Leaf1B3_1B6_1B3_1B8
  scale 0.7
  rotate <0.0, 115.047363, 39.227772>
  translate  <-5.2705, 2.96015, 9.11312>
}
#declare _Leaf1B3_1B6_1B3_1B9_Ref = object {
  _Leaf1B3_1B6_1B3_1B9
  scale 0.7
  rotate <0.0, 77.886703, 209.638>
  translate  <-5.29023, 2.95062, 9.1122>
}
#declare _Leaf1B3_1B6_1B3_1B10_Ref = object {
  _Leaf1B3_1B6_1B3_1B10
  scale 0.7
  rotate <0.0, 63.720921, 146.05629>
  translate  <-5.37341, 3.12212, 9.17387>
}
#declare _Leaf1B3_1B6_1B3_1B11_Ref = object {
  _Leaf1B3_1B6_1B3_1B11
  scale 0.7
  rotate <0.0, 32.13908, 99.662239>
  translate  <-5.36525, 3.12465, 9.17906>
}
#declare _Leaf1B3_1B6_1B3_1B12_Ref = object {
  _Leaf1B3_1B6_1B3_1B12
  scale 0.7
  rotate <0.0, 56.256699, 28.77495>
  translate  <-5.35783, 3.12965, 9.17459>
}
#declare _Leaf1B4_1B1_2B1_1B1_Ref = object {
  _Leaf1B4_1B1_2B1_1B1
  scale 0.7
  rotate <0.0, 97.983658, 103.865013>
  translate  <2.11982, 3.07259, 8.73475>
}
#declare _Leaf1B4_1B1_2B1_1B2_Ref = object {
  _Leaf1B4_1B1_2B1_1B2
  scale 0.7
  rotate <0.0, 91.951607, 146.958038>
  translate  <2.04633, 3.23806, 8.82325>
}
#declare _Leaf1B4_1B1_2B1_1B3_Ref = object {
  _Leaf1B4_1B1_2B1_1B3
  scale 0.7
  rotate <0.0, 89.903557, 31.780991>
  translate  <2.05877, 3.33163, 8.87933>
}
#declare _Leaf1B4_1B1_2B1_1B4_Ref = object {
  _Leaf1B4_1B1_2B1_1B4
  scale 0.7
  rotate <0.0, 148.82663, 335.184113>
  translate  <2.05512, 3.33901, 8.85893>
}
#declare _Leaf1B4_1B1_2B1_1B5_Ref = object {
  _Leaf1B4_1B1_2B1_1B5
  scale 0.7
  rotate <0.0, 59.450489, 211.433975>
  translate  <1.99537, 3.40827, 8.9177>
}
#declare _Leaf1B4_1B1_2B1_1B6_Ref = object {
  _Leaf1B4_1B1_2B1_1B6
  scale 0.7
  rotate <0.0, 8.71561, 89.305412>
  translate  <1.92814, 3.67723, 9.03389>
}
#declare _Leaf1B4_1B1_2B1_1B7_Ref = object {
  _Leaf1B4_1B1_2B1_1B7
  scale 0.7
  rotate <0.0, 105.548782, 178.876022>
  translate  <1.88317, 3.76951, 9.0491>
}
#declare _Leaf1B4_1B1_2B1_1B8_Ref = object {
  _Leaf1B4_1B1_2B1_1B8
  scale 0.7
  rotate <0.0, 137.900787, 162.218475>
  translate  <1.83239, 3.94972, 9.11984>
}
#declare _Leaf1B4_1B1_2B1_1B9_Ref = object {
  _Leaf1B4_1B1_2B1_1B9
  scale 0.7
  rotate <0.0, 28.07515, 329.33429>
  translate  <1.83603, 3.94236, 9.14018>
}
#declare _Leaf1B4_1B1_2B1_1B10_Ref = object {
  _Leaf1B4_1B1_2B1_1B10
  scale 0.7
  rotate <0.0, 44.78331, 84.94339>
  translate  <1.78956, 4.12366, 9.21162>
}
#declare _Leaf1B4_1B1_2B1_1B11_Ref = object {
  _Leaf1B4_1B1_2B1_1B11
  scale 0.7
  rotate <0.0, 86.71521, 65.511292>
  translate  <1.79285, 4.12819, 9.20334>
}
#declare _Leaf1B4_1B1_2B1_1B12_Ref = object {
  _Leaf1B4_1B1_2B1_1B12
  scale 0.7
  rotate <0.0, 138.749329, 65.438843>
  translate  <1.78669, 4.12947, 9.19556>
}
#declare _Leaf1B4_1B1_2B2_1B1_Ref = object {
  _Leaf1B4_1B1_2B2_1B1
  scale 0.7
  rotate <0.0, 113.699081, 22.15687>
  translate  <2.60132, 3.27489, 8.7759>
}
#declare _Leaf1B4_1B1_2B2_1B2_Ref = object {
  _Leaf1B4_1B1_2B2_1B2
  scale 0.7
  rotate <0.0, 150.975388, 54.33609>
  translate  <2.69711, 3.43998, 8.71122>
}
#declare _Leaf1B4_1B1_2B2_1B3_Ref = object {
  _Leaf1B4_1B1_2B2_1B3
  scale 0.7
  rotate <0.0, 43.555592, 2.91166>
  translate  <2.76295, 3.52637, 8.72726>
}
#declare _Leaf1B4_1B1_2B2_1B4_Ref = object {
  _Leaf1B4_1B1_2B2_1B4
  scale 0.7
  rotate <0.0, 78.213417, 284.499664>
  translate  <2.77617, 3.51254, 8.71641>
}
#declare _Leaf1B4_1B1_2B2_1B5_Ref = object {
  _Leaf1B4_1B1_2B2_1B5
  scale 0.7
  rotate <0.0, 117.89402, 151.776474>
  translate  <2.80073, 3.6072, 8.66891>
}
#declare _Leaf1B4_1B1_2B2_1B6_Ref = object {
  _Leaf1B4_1B1_2B2_1B6
  scale 0.7
  rotate <0.0, 73.166496, 103.999969>
  translate  <2.98015, 3.83953, 8.60418>
}
#declare _Leaf1B4_1B1_2B2_1B7_Ref = object {
  _Leaf1B4_1B1_2B2_1B7
  scale 0.7
  rotate <0.0, 172.416794, 183.421036>
  translate  <3.04522, 3.90265, 8.55368>
}
#declare _Leaf1B4_1B1_2B2_1B8_Ref = object {
  _Leaf1B4_1B1_2B2_1B8
  scale 0.7
  rotate <0.0, 149.38652, 305.231415>
  translate  <3.1666, 4.05341, 8.50271>
}
#declare _Leaf1B4_1B1_2B2_1B9_Ref = object {
  _Leaf1B4_1B1_2B2_1B9
  scale 0.7
  rotate <0.0, 46.360748, 127.202118>
  translate  <3.15342, 4.0672, 8.51353>
}
#declare _Leaf1B4_1B1_2B2_1B10_Ref = object {
  _Leaf1B4_1B1_2B2_1B10
  scale 0.7
  rotate <0.0, 79.547539, 67.380524>
  translate  <3.27663, 4.21806, 8.46667>
}
#declare _Leaf1B4_1B1_2B2_1B11_Ref = object {
  _Leaf1B4_1B1_2B2_1B11
  scale 0.7
  rotate <0.0, 73.828651, 21.14904>
  translate  <3.28459, 4.21201, 8.46652>
}
#declare _Leaf1B4_1B1_2B2_1B12_Ref = object {
  _Leaf1B4_1B1_2B2_1B12
  scale 0.7
  rotate <0.0, 93.574417, 332.441162>
  translate  <3.28704, 4.20717, 8.45812>
}
#declare _Leaf1B4_1B1_2B3_1B1_Ref = object {
  _Leaf1B4_1B1_2B3_1B1
  scale 0.7
  rotate <0.0, 27.729099, 151.661346>
  translate  <2.71359, 3.47953, 9.50696>
}
#declare _Leaf1B4_1B1_2B3_1B2_Ref = object {
  _Leaf1B4_1B1_2B3_1B2
  scale 0.7
  rotate <0.0, 39.021061, 233.855698>
  translate  <2.74027, 3.47257, 9.70659>
}
#declare _Leaf1B4_1B1_2B3_1B3_Ref = object {
  _Leaf1B4_1B1_2B3_1B3
  scale 0.7
  rotate <0.0, 81.654419, 84.12867>
  translate  <2.77494, 3.51595, 9.80131>
}
#declare _Leaf1B4_1B1_2B3_1B4_Ref = object {
  _Leaf1B4_1B1_2B3_1B4
  scale 0.7
  rotate <0.0, 129.205994, 144.82196>
  translate  <2.75316, 3.51874, 9.80273>
}
#declare _Leaf1B4_1B1_2B3_1B5_Ref = object {
  _Leaf1B4_1B1_2B3_1B5
  scale 0.7
  rotate <0.0, 87.743721, 292.967499>
  translate  <2.77727, 3.48691, 9.90386>
}
#declare _Leaf1B4_1B1_2B3_1B6_Ref = object {
  _Leaf1B4_1B1_2B3_1B6
  scale 0.7
  rotate <0.0, 63.832272, 355.355835>
  translate  <2.80813, 3.52608, 10.20029>
}
#declare _Leaf1B4_1B1_2B3_1B7_Ref = object {
  _Leaf1B4_1B1_2B3_1B7
  scale 0.7
  rotate <0.0, 73.114182, 238.200577>
  translate  <2.7899, 3.52345, 10.30242>
}
#declare _Leaf1B4_1B1_2B3_1B8_Ref = object {
  _Leaf1B4_1B1_2B3_1B8
  scale 0.7
  rotate <0.0, 79.397903, 202.544952>
  translate  <2.80242, 3.54559, 10.50094>
}
#declare _Leaf1B4_1B1_2B3_1B9_Ref = object {
  _Leaf1B4_1B1_2B3_1B9
  scale 0.7
  rotate <0.0, 94.828293, 7.70331>
  translate  <2.82414, 3.5428, 10.49952>
}
#declare _Leaf1B4_1B1_2B3_1B10_Ref = object {
  _Leaf1B4_1B1_2B3_1B10
  scale 0.7
  rotate <0.0, 35.67239, 26.113859>
  translate  <2.83817, 3.56915, 10.69762>
}
#declare _Leaf1B4_1B1_2B3_1B11_Ref = object {
  _Leaf1B4_1B1_2B3_1B11
  scale 0.7
  rotate <0.0, 48.821579, 93.465782>
  translate  <2.8302, 3.5752, 10.69777>
}
#declare _Leaf1B4_1B1_2B3_1B12_Ref = object {
  _Leaf1B4_1B1_2B3_1B12
  scale 0.7
  rotate <0.0, 79.210136, 141.756332>
  translate  <2.82103, 3.57135, 10.69874>
}
#declare _Leaf1B4_1B1_2B4_1B1_Ref = object {
  _Leaf1B4_1B1_2B4_1B1
  scale 0.7
  rotate <0.0, 51.529259, 329.679565>
  translate  <3.09357, 3.55076, 9.43624>
}
#declare _Leaf1B4_1B1_2B4_1B2_Ref = object {
  _Leaf1B4_1B1_2B4_1B2
  scale 0.7
  rotate <0.0, 93.637367, 318.661469>
  translate  <3.28954, 3.54342, 9.4827>
}
#declare _Leaf1B4_1B1_2B4_1B3_Ref = object {
  _Leaf1B4_1B1_2B4_1B3
  scale 0.7
  rotate <0.0, 29.75375, 97.023941>
  translate  <3.3776, 3.57962, 9.53738>
}
#declare _Leaf1B4_1B1_2B4_1B4_Ref = object {
  _Leaf1B4_1B1_2B4_1B4
  scale 0.7
  rotate <0.0, 64.674431, 198.316513>
  translate  <3.3727, 3.56119, 9.54835>
}
#declare _Leaf1B4_1B1_2B4_1B5_Ref = object {
  _Leaf1B4_1B1_2B4_1B5
  scale 0.7
  rotate <0.0, 159.512878, 351.303223>
  translate  <3.48111, 3.55476, 9.5432>
}
#declare _Leaf1B4_1B1_2B4_1B6_Ref = object {
  _Leaf1B4_1B1_2B4_1B6
  scale 0.7
  rotate <0.0, 104.943169, 46.818642>
  translate  <3.75862, 3.55731, 9.65872>
}
#declare _Leaf1B4_1B1_2B4_1B7_Ref = object {
  _Leaf1B4_1B1_2B4_1B7
  scale 0.7
  rotate <0.0, 115.640953, 291.284912>
  translate  <3.85044, 3.52552, 9.69514>
}
#declare _Leaf1B4_1B1_2B4_1B8_Ref = object {
  _Leaf1B4_1B1_2B4_1B8
  scale 0.7
  rotate <0.0, 86.253036, 271.398254>
  translate  <4.03512, 3.5182, 9.77195>
}
#declare _Leaf1B4_1B1_2B4_1B9_Ref = object {
  _Leaf1B4_1B1_2B4_1B9
  scale 0.7
  rotate <0.0, 106.044601, 81.317757>
  translate  <4.04001, 3.53658, 9.761>
}
#declare _Leaf1B4_1B1_2B4_1B10_Ref = object {
  _Leaf1B4_1B1_2B4_1B10
  scale 0.7
  rotate <0.0, 73.50042, 28.85709>
  translate  <4.22372, 3.53248, 9.8408>
}
#declare _Leaf1B4_1B1_2B4_1B11_Ref = object {
  _Leaf1B4_1B1_2B4_1B11
  scale 0.7
  rotate <0.0, 28.40369, 23.444969>
  translate  <4.22043, 3.52794, 9.84908>
}
#declare _Leaf1B4_1B1_2B4_1B12_Ref = object {
  _Leaf1B4_1B1_2B4_1B12
  scale 0.7
  rotate <0.0, 28.75383, 250.477036>
  translate  <4.21986, 3.51797, 9.84943>
}
#declare _Leaf1B4_1B1_2B5_1B1_Ref = object {
  _Leaf1B4_1B1_2B5_1B1
  scale 0.7
  rotate <0.0, 69.970787, 22.240431>
  translate  <3.14518, 3.97055, 9.64329>
}
#declare _Leaf1B4_1B1_2B5_1B2_Ref = object {
  _Leaf1B4_1B1_2B5_1B2
  scale 0.7
  rotate <0.0, 100.98542, 52.97681>
  translate  <3.23215, 4.11991, 9.74692>
}
#declare _Leaf1B4_1B1_2B5_1B3_Ref = object {
  _Leaf1B4_1B1_2B5_1B3
  scale 0.7
  rotate <0.0, 36.575989, 295.246185>
  translate  <3.26802, 4.16491, 9.84043>
}
#declare _Leaf1B4_1B1_2B5_1B4_Ref = object {
  _Leaf1B4_1B1_2B5_1B4
  scale 0.7
  rotate <0.0, 109.729622, 286.665314>
  translate  <3.28681, 4.15838, 9.83103>
}
#declare _Leaf1B4_1B1_2B5_1B5_Ref = object {
  _Leaf1B4_1B1_2B5_1B5
  scale 0.7
  rotate <0.0, 113.68045, 125.029991>
  translate  <3.31514, 4.25592, 9.86983>
}
#declare _Leaf1B4_1B1_2B5_1B6_Ref = object {
  _Leaf1B4_1B1_2B5_1B6
  scale 0.7
  rotate <0.0, 49.487579, 129.719177>
  translate  <3.46404, 4.44198, 10.05305>
}
#declare _Leaf1B4_1B1_2B5_1B7_Ref = object {
  _Leaf1B4_1B1_2B5_1B7
  scale 0.7
  rotate <0.0, 134.628494, 60.55917>
  translate  <3.53407, 4.50951, 10.08915>
}
#declare _Leaf1B4_1B1_2B5_1B8_Ref = object {
  _Leaf1B4_1B1_2B5_1B8
  scale 0.7
  rotate <0.0, 132.348877, 11.46773>
  translate  <3.6392, 4.63478, 10.20454>
}
#declare _Leaf1B4_1B1_2B5_1B9_Ref = object {
  _Leaf1B4_1B1_2B5_1B9
  scale 0.7
  rotate <0.0, 53.380981, 172.33876>
  translate  <3.62046, 4.6413, 10.21391>
}
#declare _Leaf1B4_1B1_2B5_1B10_Ref = object {
  _Leaf1B4_1B1_2B5_1B10
  scale 0.7
  rotate <0.0, 32.116852, 79.35054>
  translate  <3.72524, 4.76382, 10.33284>
}
#declare _Leaf1B4_1B1_2B5_1B11_Ref = object {
  _Leaf1B4_1B1_2B5_1B11
  scale 0.7
  rotate <0.0, 36.626968, 353.718628>
  translate  <3.73321, 4.75777, 10.33269>
}
#declare _Leaf1B4_1B1_2B5_1B12_Ref = object {
  _Leaf1B4_1B1_2B5_1B12
  scale 0.7
  rotate <0.0, 85.261932, 331.117126>
  translate  <3.74003, 4.75867, 10.32544>
}
#declare _Leaf1B4_1B1_1B1_1B1_Ref = object {
  _Leaf1B4_1B1_1B1_1B1
  scale 0.7
  rotate <0.0, 108.508263, 23.23123>
  translate  <1.6039, 1.99162, 7.48954>
}
#declare _Leaf1B4_1B1_1B1_1B2_Ref = object {
  _Leaf1B4_1B1_1B1_1B2
  scale 0.7
  rotate <0.0, 144.977737, 54.018848>
  translate  <1.70341, 2.16112, 7.44501>
}
#declare _Leaf1B4_1B1_1B1_1B3_Ref = object {
  _Leaf1B4_1B1_1B1_1B3
  scale 0.7
  rotate <0.0, 39.907421, 357.471466>
  translate  <1.768, 2.2456, 7.47231>
}
#declare _Leaf1B4_1B1_1B1_1B4_Ref = object {
  _Leaf1B4_1B1_1B1_1B4
  scale 0.7
  rotate <0.0, 81.972061, 283.593323>
  translate  <1.7819, 2.23266, 7.4612>
}
#declare _Leaf1B4_1B1_1B1_1B5_Ref = object {
  _Leaf1B4_1B1_1B1_1B5
  scale 0.7
  rotate <0.0, 118.659111, 148.483688>
  translate  <1.80931, 2.33084, 7.4234>
}
#declare _Leaf1B4_1B1_1B1_1B6_Ref = object {
  _Leaf1B4_1B1_1B1_1B6
  scale 0.7
  rotate <0.0, 69.465729, 105.510361>
  translate  <1.99221, 2.56701, 7.38971>
}
#declare _Leaf1B4_1B1_1B1_1B7_Ref = object {
  _Leaf1B4_1B1_1B1_1B7
  scale 0.7
  rotate <0.0, 174.151382, 132.447906>
  translate  <2.06027, 2.63384, 7.34885>
}
#declare _Leaf1B4_1B1_1B1_1B8_Ref = object {
  _Leaf1B4_1B1_1B1_1B8
  scale 0.7
  rotate <0.0, 150.694809, 315.325684>
  translate  <2.18447, 2.7878, 7.31837>
}
#declare _Leaf1B4_1B1_1B1_1B9_Ref = object {
  _Leaf1B4_1B1_1B1_1B9
  scale 0.7
  rotate <0.0, 45.029202, 132.831253>
  translate  <2.17061, 2.8007, 7.32946>
}
#declare _Leaf1B4_1B1_1B1_1B10_Ref = object {
  _Leaf1B4_1B1_1B1_1B10
  scale 0.7
  rotate <0.0, 73.744308, 67.65377>
  translate  <2.29637, 2.95442, 7.30319>
}
#declare _Leaf1B4_1B1_1B1_1B11_Ref = object {
  _Leaf1B4_1B1_1B1_1B11
  scale 0.7
  rotate <0.0, 68.753319, 19.975281>
  translate  <2.30434, 2.94837, 7.30304>
}
#declare _Leaf1B4_1B1_1B1_1B12_Ref = object {
  _Leaf1B4_1B1_1B1_1B12
  scale 0.7
  rotate <0.0, 92.558281, 332.669617>
  translate  <2.30731, 2.94423, 7.29444>
}
#declare _Leaf1B4_1B1_1B2_1B1_Ref = object {
  _Leaf1B4_1B1_1B2_1B1
  scale 0.7
  rotate <0.0, 28.47583, 300.721008>
  translate  <1.83351, 1.99403, 8.09696>
}
#declare _Leaf1B4_1B1_1B2_1B2_Ref = object {
  _Leaf1B4_1B1_1B2_1B2
  scale 0.7
  rotate <0.0, 71.778473, 298.768433>
  translate  <1.98658, 1.94512, 8.21859>
}
#declare _Leaf1B4_1B1_1B2_1B3_Ref = object {
  _Leaf1B4_1B1_1B2_1B3
  scale 0.7
  rotate <0.0, 44.49218, 105.645042>
  translate  <2.05689, 1.9678, 8.29981>
}
#declare _Leaf1B4_1B1_1B2_1B4_Ref = object {
  _Leaf1B4_1B1_1B2_1B4
  scale 0.7
  rotate <0.0, 85.68055, 176.44664>
  translate  <2.04261, 1.95436, 8.30978>
}
#declare _Leaf1B4_1B1_1B2_1B5_Ref = object {
  _Leaf1B4_1B1_1B2_1B5
  scale 0.7
  rotate <0.0, 135.074875, 329.770691>
  translate  <2.13719, 1.91807, 8.34925>
}
#declare _Leaf1B4_1B1_1B2_1B6_Ref = object {
  _Leaf1B4_1B1_1B2_1B6
  scale 0.7
  rotate <0.0, 92.539932, 25.06913>
  translate  <2.34104, 1.87223, 8.56536>
}
#declare _Leaf1B4_1B1_1B2_1B7_Ref = object {
  _Leaf1B4_1B1_1B2_1B7
  scale 0.7
  rotate <0.0, 99.98333, 279.047638>
  translate  <2.39817, 1.82611, 8.6387>
}
#declare _Leaf1B4_1B1_1B2_1B8_Ref = object {
  _Leaf1B4_1B1_1B2_1B8
  scale 0.7
  rotate <0.0, 79.914337, 250.043457>
  translate  <2.53083, 1.78715, 8.78341>
}
#declare _Leaf1B4_1B1_1B2_1B9_Ref = object {
  _Leaf1B4_1B1_1B2_1B9
  scale 0.7
  rotate <0.0, 107.107628, 55.476341>
  translate  <2.54507, 1.80055, 8.77346>
}
#declare _Leaf1B4_1B1_1B2_1B10_Ref = object {
  _Leaf1B4_1B1_1B2_1B10
  scale 0.7
  rotate <0.0, 56.905731, 18.9681>
  translate  <2.67693, 1.76554, 8.92016>
}
#declare _Leaf1B4_1B1_1B2_1B11_Ref = object {
  _Leaf1B4_1B1_1B2_1B11
  scale 0.7
  rotate <0.0, 17.19986, 61.594559>
  translate  <2.66966, 1.76407, 8.92687>
}
#declare _Leaf1B4_1B1_1B2_1B12_Ref = object {
  _Leaf1B4_1B1_1B2_1B12
  scale 0.7
  rotate <0.0, 38.611622, 196.935471>
  translate  <2.66569, 1.75496, 8.92802>
}
#declare _Leaf1B4_1B1_1B3_1B1_Ref = object {
  _Leaf1B4_1B1_1B3_1B1
  scale 0.7
  rotate <0.0, 74.242882, 121.667793>
  translate  <1.61381, 2.38447, 8.20176>
}
#declare _Leaf1B4_1B1_1B3_1B2_Ref = object {
  _Leaf1B4_1B1_1B3_1B2
  scale 0.7
  rotate <0.0, 70.236351, 167.095215>
  translate  <1.53152, 2.48264, 8.35734>
}
#declare _Leaf1B4_1B1_1B3_1B3_Ref = object {
  _Leaf1B4_1B1_1B3_1B3
  scale 0.7
  rotate <0.0, 88.894279, 49.781551>
  translate  <1.53634, 2.55501, 8.43977>
}
#declare _Leaf1B4_1B1_1B3_1B4_Ref = object {
  _Leaf1B4_1B1_1B3_1B4
  scale 0.7
  rotate <0.0, 162.293533, 42.92815>
  translate  <1.52483, 2.5661, 8.42465>
}
#declare _Leaf1B4_1B1_1B3_1B5_Ref = object {
  _Leaf1B4_1B1_1B3_1B5
  scale 0.7
  rotate <0.0, 63.327068, 243.213196>
  translate  <1.47051, 2.59113, 8.51544>
}
#declare _Leaf1B4_1B1_1B3_1B6_Ref = object {
  _Leaf1B4_1B1_1B3_1B6
  scale 0.7
  rotate <0.0, 17.60268, 332.124451>
  translate  <1.37611, 2.77641, 8.73252>
}
#declare _Leaf1B4_1B1_1B3_1B7_Ref = object {
  _Leaf1B4_1B1_1B3_1B7
  scale 0.7
  rotate <0.0, 92.297508, 193.811508>
  translate  <1.31605, 2.83938, 8.78905>
}
#declare _Leaf1B4_1B1_1B3_1B8_Ref = object {
  _Leaf1B4_1B1_1B3_1B8
  scale 0.7
  rotate <0.0, 118.014526, 168.715134>
  translate  <1.24537, 2.96355, 8.92921>
}
#declare _Leaf1B4_1B1_1B3_1B9_Ref = object {
  _Leaf1B4_1B1_1B3_1B9
  scale 0.7
  rotate <0.0, 50.791489, 335.278137>
  translate  <1.25684, 2.95249, 8.94428>
}
#declare _Leaf1B4_1B1_1B3_1B10_Ref = object {
  _Leaf1B4_1B1_1B3_1B10
  scale 0.7
  rotate <0.0, 27.44404, 77.900948>
  translate  <1.19004, 3.07892, 9.08459>
}
#declare _Leaf1B4_1B1_1B3_1B11_Ref = object {
  _Leaf1B4_1B1_1B3_1B11
  scale 0.7
  rotate <0.0, 72.680809, 80.016281>
  translate  <1.18934, 3.08644, 9.07803>
}
#declare _Leaf1B4_1B1_1B3_1B12_Ref = object {
  _Leaf1B4_1B1_1B3_1B12
  scale 0.7
  rotate <0.0, 121.431587, 98.965347>
  translate  <1.18098, 3.08765, 9.07269>
}
#declare _Leaf1B4_1B2_2B1_1B1_Ref = object {
  _Leaf1B4_1B2_2B1_1B1
  scale 0.7
  rotate <0.0, 61.139992, 222.286835>
  translate  <-0.05521, 1.92202, 9.64512>
}
#declare _Leaf1B4_1B2_2B1_1B2_Ref = object {
  _Leaf1B4_1B2_2B1_1B2
  scale 0.7
  rotate <0.0, 73.640709, 267.545044>
  translate  <-0.08787, 1.81809, 9.81466>
}
#declare _Leaf1B4_1B2_2B1_1B3_Ref = object {
  _Leaf1B4_1B2_2B1_1B3
  scale 0.7
  rotate <0.0, 68.752953, 141.414642>
  translate  <-0.12592, 1.80955, 9.9173>
}
#declare _Leaf1B4_1B2_2B1_1B4_Ref = object {
  _Leaf1B4_1B2_2B1_1B4
  scale 0.7
  rotate <0.0, 141.758606, 151.406036>
  translate  <-0.14128, 1.79873, 9.90585>
}
#declare _Leaf1B4_1B2_2B1_1B5_Ref = object {
  _Leaf1B4_1B2_2B1_1B5
  scale 0.7
  rotate <0.0, 84.930458, 337.431763>
  translate  <-0.13003, 1.73426, 9.99266>
}
#declare _Leaf1B4_1B2_2B1_1B6_Ref = object {
  _Leaf1B4_1B2_2B1_1B6
  scale 0.7
  rotate <0.0, 30.002171, 21.72876>
  translate  <-0.22139, 1.60587, 10.24865>
}
#declare _Leaf1B4_1B2_2B1_1B7_Ref = object {
  _Leaf1B4_1B2_2B1_1B7
  scale 0.7
  rotate <0.0, 103.535744, 284.499207>
  translate  <-0.25761, 1.53611, 10.3164>
}
#declare _Leaf1B4_1B2_2B1_1B8_Ref = object {
  _Leaf1B4_1B2_2B1_1B8
  scale 0.7
  rotate <0.0, 118.39444, 250.18045>
  translate  <-0.32049, 1.4432, 10.48215>
}
#declare _Leaf1B4_1B2_2B1_1B9_Ref = object {
  _Leaf1B4_1B2_2B1_1B9
  scale 0.7
  rotate <0.0, 56.348419, 52.77142>
  translate  <-0.30517, 1.45399, 10.49357>
}
#declare _Leaf1B4_1B2_2B1_1B10_Ref = object {
  _Leaf1B4_1B2_2B1_1B10
  scale 0.7
  rotate <0.0, 6.16695, 192.24501>
  translate  <-0.37024, 1.36476, 10.66071>
}
#declare _Leaf1B4_1B2_2B1_1B11_Ref = object {
  _Leaf1B4_1B2_2B1_1B11
  scale 0.7
  rotate <0.0, 51.1315, 175.220215>
  translate  <-0.37958, 1.36412, 10.6572>
}
#declare _Leaf1B4_1B2_2B1_1B12_Ref = object {
  _Leaf1B4_1B2_2B1_1B12
  scale 0.7
  rotate <0.0, 101.652893, 188.567886>
  translate  <-0.38233, 1.35624, 10.6517>
}
#declare _Leaf1B4_1B2_2B2_1B1_Ref = object {
  _Leaf1B4_1B2_2B2_1B1
  scale 0.7
  rotate <0.0, 93.775047, 146.757706>
  translate  <-0.37785, 2.29504, 9.82182>
}
#declare _Leaf1B4_1B2_2B2_1B2_Ref = object {
  _Leaf1B4_1B2_2B2_1B2
  scale 0.7
  rotate <0.0, 115.186836, 185.986435>
  translate  <-0.57098, 2.3074, 9.87804>
}
#declare _Leaf1B4_1B2_2B2_1B3_Ref = object {
  _Leaf1B4_1B2_2B2_1B3
  scale 0.7
  rotate <0.0, 52.15102, 82.70948>
  translate  <-0.64995, 2.34005, 9.94698>
}
#declare _Leaf1B4_1B2_2B2_1B4_Ref = object {
  _Leaf1B4_1B2_2B2_1B4
  scale 0.7
  rotate <0.0, 115.0112, 42.063469>
  translate  <-0.65224, 2.3543, 9.93037>
}
#declare _Leaf1B4_1B2_2B2_1B5_Ref = object {
  _Leaf1B4_1B2_2B2_1B5
  scale 0.7
  rotate <0.0, 97.692413, 256.673615>
  translate  <-0.75603, 2.33145, 9.95333>
}
#declare _Leaf1B4_1B2_2B2_1B6_Ref = object {
  _Leaf1B4_1B2_2B2_1B6
  scale 0.7
  rotate <0.0, 37.170879, 231.006073>
  translate  <-1.0317, 2.39548, 10.05466>
}
#declare _Leaf1B4_1B2_2B2_1B7_Ref = object {
  _Leaf1B4_1B2_2B2_1B7
  scale 0.7
  rotate <0.0, 141.580414, 214.74588>
  translate  <-1.13257, 2.41972, 10.05712>
}
#declare _Leaf1B4_1B2_2B2_1B8_Ref = object {
  _Leaf1B4_1B2_2B2_1B8
  scale 0.7
  rotate <0.0, 156.933899, 148.180649>
  translate  <-1.31874, 2.46359, 10.11605>
}
#declare _Leaf1B4_1B2_2B2_1B9_Ref = object {
  _Leaf1B4_1B2_2B2_1B9
  scale 0.7
  rotate <0.0, 28.15477, 292.978424>
  translate  <-1.31646, 2.44938, 10.13261>
}
#declare _Leaf1B4_1B2_2B2_1B10_Ref = object {
  _Leaf1B4_1B2_2B2_1B10
  scale 0.7
  rotate <0.0, 43.73457, 174.789307>
  translate  <-1.50111, 2.49585, 10.19488>
}
#declare _Leaf1B4_1B2_2B2_1B11_Ref = object {
  _Leaf1B4_1B2_2B2_1B11
  scale 0.7
  rotate <0.0, 62.113869, 121.57785>
  translate  <-1.50039, 2.50516, 10.1913>
}
#declare _Leaf1B4_1B2_2B2_1B12_Ref = object {
  _Leaf1B4_1B2_2B2_1B12
  scale 0.7
  rotate <0.0, 107.648888, 95.57193>
  translate  <-1.50291, 2.50707, 10.18181>
}
#declare _Leaf1B4_1B2_2B3_1B1_Ref = object {
  _Leaf1B4_1B2_2B3_1B1
  scale 0.7
  rotate <0.0, 35.607632, 336.092834>
  translate  <-0.14609, 2.49926, 10.52432>
}
#declare _Leaf1B4_1B2_2B3_1B2_Ref = object {
  _Leaf1B4_1B2_2B3_1B2
  scale 0.7
  rotate <0.0, 74.048866, 1.88465>
  translate  <-0.03737, 2.57376, 10.67678>
}
#declare _Leaf1B4_1B2_2B3_1B3_Ref = object {
  _Leaf1B4_1B2_2B3_1B3
  scale 0.7
  rotate <0.0, 42.99448, 199.118576>
  translate  <-0.02768, 2.61241, 10.77909>
}
#declare _Leaf1B4_1B2_2B3_1B4_Ref = object {
  _Leaf1B4_1B2_2B3_1B4
  scale 0.7
  rotate <0.0, 103.813141, 245.340485>
  translate  <-0.01949, 2.59208, 10.78112>
}
#declare _Leaf1B4_1B2_2B3_1B5_Ref = object {
  _Leaf1B4_1B2_2B3_1B5
  scale 0.7
  rotate <0.0, 121.915131, 54.20755>
  translate  <0.05075, 2.64945, 10.84108>
}
#declare _Leaf1B4_1B2_2B3_1B6_Ref = object {
  _Leaf1B4_1B2_2B3_1B6
  scale 0.7
  rotate <0.0, 70.558891, 94.672722>
  translate  <0.18148, 2.73457, 11.09804>
}
#declare _Leaf1B4_1B2_2B3_1B7_Ref = object {
  _Leaf1B4_1B2_2B3_1B7
  scale 0.7
  rotate <0.0, 107.464279, 354.169037>
  translate  <0.25005, 2.74356, 11.1754>
}
#declare _Leaf1B4_1B2_2B3_1B8_Ref = object {
  _Leaf1B4_1B2_2B3_1B8
  scale 0.7
  rotate <0.0, 97.249519, 319.663452>
  translate  <0.34393, 2.79466, 11.34462>
}
#declare _Leaf1B4_1B2_2B3_1B9_Ref = object {
  _Leaf1B4_1B2_2B3_1B9
  scale 0.7
  rotate <0.0, 86.83194, 124.33976>
  translate  <0.33577, 2.81493, 11.3426>
}
#declare _Leaf1B4_1B2_2B3_1B10_Ref = object {
  _Leaf1B4_1B2_2B3_1B10
  scale 0.7
  rotate <0.0, 35.50301, 83.39222>
  translate  <0.42583, 2.8658, 11.51417>
}
#declare _Leaf1B4_1B2_2B3_1B11_Ref = object {
  _Leaf1B4_1B2_2B3_1B11
  scale 0.7
  rotate <0.0, 11.19018, 230.587234>
  translate  <0.42511, 2.85649, 11.51775>
}
#declare _Leaf1B4_1B2_2B3_1B12_Ref = object {
  _Leaf1B4_1B2_2B3_1B12
  scale 0.7
  rotate <0.0, 60.247688, 270.951752>
  translate  <0.43227, 2.8498, 11.51576>
}
#declare _Leaf1B4_1B2_2B4_1B1_Ref = object {
  _Leaf1B4_1B2_2B4_1B1
  scale 0.7
  rotate <0.0, 74.66201, 68.99781>
  translate  <-0.39875, 2.80027, 10.52805>
}
#declare _Leaf1B4_1B2_2B4_1B2_Ref = object {
  _Leaf1B4_1B2_2B4_1B2
  scale 0.7
  rotate <0.0, 115.62085, 83.49913>
  translate  <-0.45051, 2.99107, 10.56719>
}
#declare _Leaf1B4_1B2_2B4_1B3_Ref = object {
  _Leaf1B4_1B2_2B4_1B3
  scale 0.7
  rotate <0.0, 10.70032, 353.385529>
  translate  <-0.48173, 3.07089, 10.6358>
}
#declare _Leaf1B4_1B2_2B4_1B4_Ref = object {
  _Leaf1B4_1B2_2B4_1B4
  scale 0.7
  rotate <0.0, 82.88517, 324.82547>
  translate  <-0.46048, 3.07565, 10.63268>
}
#declare _Leaf1B4_1B2_2B4_1B5_Ref = object {
  _Leaf1B4_1B2_2B4_1B5
  scale 0.7
  rotate <0.0, 138.666855, 170.721146>
  translate  <-0.50528, 3.17464, 10.62878>
}
#declare _Leaf1B4_1B2_2B4_1B6_Ref = object {
  _Leaf1B4_1B2_2B4_1B6
  scale 0.7
  rotate <0.0, 74.712151, 162.806213>
  translate  <-0.55886, 3.45217, 10.73107>
}
#declare _Leaf1B4_1B2_2B4_1B7_Ref = object {
  _Leaf1B4_1B2_2B4_1B7
  scale 0.7
  rotate <0.0, 148.161713, 68.312119>
  translate  <-0.55492, 3.55516, 10.74315>
}
#declare _Leaf1B4_1B2_2B4_1B8_Ref = object {
  _Leaf1B4_1B2_2B4_1B8
  scale 0.7
  rotate <0.0, 124.799431, 28.518499>
  translate  <-0.58435, 3.74304, 10.80555>
}
#declare _Leaf1B4_1B2_2B4_1B9_Ref = object {
  _Leaf1B4_1B2_2B4_1B9
  scale 0.7
  rotate <0.0, 67.492783, 197.172928>
  translate  <-0.60554, 3.7383, 10.80866>
}
#declare _Leaf1B4_1B2_2B4_1B10_Ref = object {
  _Leaf1B4_1B2_2B4_1B10
  scale 0.7
  rotate <0.0, 57.151321, 127.95079>
  translate  <-0.63507, 3.92489, 10.87536>
}
#declare _Leaf1B4_1B2_2B4_1B11_Ref = object {
  _Leaf1B4_1B2_2B4_1B11
  scale 0.7
  rotate <0.0, 34.797989, 70.572411>
  translate  <-0.62573, 3.92552, 10.87888>
}
#declare _Leaf1B4_1B2_2B4_1B12_Ref = object {
  _Leaf1B4_1B2_2B4_1B12
  scale 0.7
  rotate <0.0, 66.730881, 14.25966>
  translate  <-0.61834, 3.92863, 10.8729>
}
#declare _Leaf1B4_1B2_2B5_1B1_Ref = object {
  _Leaf1B4_1B2_2B5_1B1
  scale 0.7
  rotate <0.0, 58.511639, 119.589218>
  translate  <-0.59337, 2.74747, 10.95361>
}
#declare _Leaf1B4_1B2_2B5_1B2_Ref = object {
  _Leaf1B4_1B2_2B5_1B2
  scale 0.7
  rotate <0.0, 68.717041, 166.984344>
  translate  <-0.67461, 2.79786, 11.13102>
}
#declare _Leaf1B4_1B2_2B5_1B3_Ref = object {
  _Leaf1B4_1B2_2B5_1B3
  scale 0.7
  rotate <0.0, 72.544212, 40.051979>
  translate  <-0.66725, 2.83673, 11.23344>
}
#declare _Leaf1B4_1B2_2B5_1B4_Ref = object {
  _Leaf1B4_1B2_2B5_1B4
  scale 0.7
  rotate <0.0, 144.686264, 56.705631>
  translate  <-0.67616, 2.85377, 11.22274>
}
#declare _Leaf1B4_1B2_2B5_1B5_Ref = object {
  _Leaf1B4_1B2_2B5_1B5
  scale 0.7
  rotate <0.0, 82.263474, 237.715836>
  translate  <-0.73373, 2.85403, 11.31497>
}
#declare _Leaf1B4_1B2_2B5_1B6_Ref = object {
  _Leaf1B4_1B2_2B5_1B6
  scale 0.7
  rotate <0.0, 31.411539, 289.691498>
  translate  <-0.821, 2.96644, 11.57975>
}
#declare _Leaf1B4_1B2_2B5_1B7_Ref = object {
  _Leaf1B4_1B2_2B5_1B7
  scale 0.7
  rotate <0.0, 98.515411, 184.220276>
  translate  <-0.87706, 3.01438, 11.65274>
}
#declare _Leaf1B4_1B2_2B5_1B8_Ref = object {
  _Leaf1B4_1B2_2B5_1B8
  scale 0.7
  rotate <0.0, 113.980049, 151.180313>
  translate  <-0.9425, 3.09256, 11.82498>
}
#declare _Leaf1B4_1B2_2B5_1B9_Ref = object {
  _Leaf1B4_1B2_2B5_1B9
  scale 0.7
  rotate <0.0, 59.86771, 314.821564>
  translate  <-0.93362, 3.07557, 11.83564>
}
#declare _Leaf1B4_1B2_2B5_1B10_Ref = object {
  _Leaf1B4_1B2_2B5_1B10
  scale 0.7
  rotate <0.0, 7.77607, 51.899632>
  translate  <-0.99496, 3.15525, 12.00891>
}
#declare _Leaf1B4_1B2_2B5_1B11_Ref = object {
  _Leaf1B4_1B2_2B5_1B11
  scale 0.7
  rotate <0.0, 52.546989, 71.220978>
  translate  <-0.99424, 3.16456, 12.00533>
}
#declare _Leaf1B4_1B2_2B5_1B12_Ref = object {
  _Leaf1B4_1B2_2B5_1B12
  scale 0.7
  rotate <0.0, 101.699287, 89.413689>
  translate  <-1.00197, 3.16867, 12.00049>
}
#declare _Leaf1B4_1B2_1B1_1B1_Ref = object {
  _Leaf1B4_1B2_1B1_1B1
  scale 0.7
  rotate <0.0, 88.917099, 144.671188>
  translate  <0.19836, 1.541, 7.97906>
}
#declare _Leaf1B4_1B2_1B1_1B2_Ref = object {
  _Leaf1B4_1B2_1B1_1B2
  scale 0.7
  rotate <0.0, 109.656769, 183.466843>
  translate  <0.01221, 1.56, 8.05389>
}
#declare _Leaf1B4_1B2_1B1_1B3_Ref = object {
  _Leaf1B4_1B2_1B1_1B3
  scale 0.7
  rotate <0.0, 52.746559, 76.271469>
  translate  <-0.0584, 1.5949, 8.13038>
}
#declare _Leaf1B4_1B2_1B1_1B4_Ref = object {
  _Leaf1B4_1B2_1B1_1B4
  scale 0.7
  rotate <0.0, 118.873596, 41.975868>
  translate  <-0.06175, 1.60938, 8.11416>
}
#declare _Leaf1B4_1B2_1B1_1B5_Ref = object {
  _Leaf1B4_1B2_1B1_1B5
  scale 0.7
  rotate <0.0, 96.686737, 253.825851>
  translate  <-0.16361, 1.59019, 8.14699>
}
#declare _Leaf1B4_1B2_1B1_1B6_Ref = object {
  _Leaf1B4_1B2_1B1_1B6
  scale 0.7
  rotate <0.0, 34.166752, 235.455048>
  translate  <-0.42551, 1.66344, 8.27506>
}
#declare _Leaf1B4_1B2_1B1_1B7_Ref = object {
  _Leaf1B4_1B2_1B1_1B7
  scale 0.7
  rotate <0.0, 137.054489, 208.745285>
  translate  <-0.52467, 1.69139, 8.28748>
}
#declare _Leaf1B4_1B2_1B1_1B8_Ref = object {
  _Leaf1B4_1B2_1B1_1B8
  scale 0.7
  rotate <0.0, 151.890503, 151.147324>
  translate  <-0.70245, 1.74158, 8.36452>
}
#declare _Leaf1B4_1B2_1B1_1B9_Ref = object {
  _Leaf1B4_1B2_1B1_1B9
  scale 0.7
  rotate <0.0, 31.013149, 299.335541>
  translate  <-0.69911, 1.72714, 8.38069>
}
#declare _Leaf1B4_1B2_1B1_1B10_Ref = object {
  _Leaf1B4_1B2_1B1_1B10
  scale 0.7
  rotate <0.0, 38.136829, 172.413483>
  translate  <-0.87494, 1.77985, 8.46092>
}
#declare _Leaf1B4_1B2_1B1_1B11_Ref = object {
  _Leaf1B4_1B2_1B1_1B11
  scale 0.7
  rotate <0.0, 59.01181, 116.790649>
  translate  <-0.87423, 1.78915, 8.45734>
}
#declare _Leaf1B4_1B2_1B1_1B12_Ref = object {
  _Leaf1B4_1B2_1B1_1B12
  scale 0.7
  rotate <0.0, 106.698112, 95.127151>
  translate  <-0.87758, 1.79125, 8.44816>
}
#declare _Leaf1B4_1B2_1B2_1B1_Ref = object {
  _Leaf1B4_1B2_1B2_1B1
  scale 0.7
  rotate <0.0, 63.933681, 39.93821>
  translate  <0.44935, 1.8934, 8.46332>
}
#declare _Leaf1B4_1B2_1B2_1B2_Ref = object {
  _Leaf1B4_1B2_1B2_1B2
  scale 0.7
  rotate <0.0, 104.966881, 54.228222>
  translate  <0.48825, 2.07825, 8.53354>
}
#declare _Leaf1B4_1B2_1B2_1B3_Ref = object {
  _Leaf1B4_1B2_1B2_1B3
  scale 0.7
  rotate <0.0, 13.9059, 275.486786>
  translate  <0.48933, 2.15321, 8.61375>
}
#declare _Leaf1B4_1B2_1B2_1B4_Ref = object {
  _Leaf1B4_1B2_1B2_1B4
  scale 0.7
  rotate <0.0, 86.590584, 295.229828>
  translate  <0.51054, 2.14748, 8.61261>
}
#declare _Leaf1B4_1B2_1B2_1B5_Ref = object {
  _Leaf1B4_1B2_1B2_1B5
  scale 0.7
  rotate <0.0, 138.695801, 129.738846>
  translate  <0.5182, 2.25529, 8.62435>
}
#declare _Leaf1B4_1B2_1B2_1B6_Ref = object {
  _Leaf1B4_1B2_1B2_1B6
  scale 0.7
  rotate <0.0, 74.689041, 137.103897>
  translate  <0.58782, 2.50762, 8.77215>
}
#declare _Leaf1B4_1B2_1B2_1B7_Ref = object {
  _Leaf1B4_1B2_1B2_1B7
  scale 0.7
  rotate <0.0, 137.429337, 40.99773>
  translate  <0.63786, 2.59322, 8.80276>
}
#declare _Leaf1B4_1B2_1B2_1B8_Ref = object {
  _Leaf1B4_1B2_1B2_1B8
  scale 0.7
  rotate <0.0, 116.983521, 4.32468>
  translate  <0.69188, 2.76165, 8.89643>
}
#declare _Leaf1B4_1B2_1B2_1B9_Ref = object {
  _Leaf1B4_1B2_1B2_1B9
  scale 0.7
  rotate <0.0, 73.588531, 171.667145>
  translate  <0.67073, 2.76737, 8.89757>
}
#declare _Leaf1B4_1B2_1B2_1B10_Ref = object {
  _Leaf1B4_1B2_1B2_1B10
  scale 0.7
  rotate <0.0, 51.228401, 105.821854>
  translate  <0.72348, 2.93415, 8.99522>
}
#declare _Leaf1B4_1B2_1B2_1B11_Ref = object {
  _Leaf1B4_1B2_1B2_1B11
  scale 0.7
  rotate <0.0, 24.052031, 40.373379>
  translate  <0.73149, 2.92971, 8.99926>
}
#declare _Leaf1B4_1B2_1B2_1B12_Ref = object {
  _Leaf1B4_1B2_1B2_1B12
  scale 0.7
  rotate <0.0, 61.73151, 340.970245>
  translate  <0.74018, 2.92963, 8.99432>
}
#declare _Leaf1B4_1B2_1B3_1B1_Ref = object {
  _Leaf1B4_1B2_1B3_1B1
  scale 0.7
  rotate <0.0, 45.255699, 253.859955>
  translate  <0.33198, 1.58137, 8.78044>
}
#declare _Leaf1B4_1B2_1B3_1B2_Ref = object {
  _Leaf1B4_1B2_1B3_1B2
  scale 0.7
  rotate <0.0, 68.890877, 298.191895>
  translate  <0.38864, 1.5095, 8.95999>
}
#declare _Leaf1B4_1B2_1B3_1B3_Ref = object {
  _Leaf1B4_1B2_1B3_1B3
  scale 0.7
  rotate <0.0, 58.92667, 158.301559>
  translate  <0.38382, 1.50794, 9.06967>
}
#declare _Leaf1B4_1B2_1B3_1B4_Ref = object {
  _Leaf1B4_1B2_1B3_1B4
  scale 0.7
  rotate <0.0, 127.275192, 187.297836>
  translate  <0.37228, 1.48997, 9.06436>
}
#declare _Leaf1B4_1B2_1B3_1B5_Ref = object {
  _Leaf1B4_1B2_1B3_1B5
  scale 0.7
  rotate <0.0, 99.375153, 1.58584>
  translate  <0.43049, 1.45379, 9.14876>
}
#declare _Leaf1B4_1B2_1B3_1B6_Ref = object {
  _Leaf1B4_1B2_1B3_1B6
  scale 0.7
  rotate <0.0, 48.259319, 44.237579>
  translate  <0.46721, 1.35481, 9.43021>
}
#declare _Leaf1B4_1B2_1B3_1B7_Ref = object {
  _Leaf1B4_1B2_1B3_1B7
  scale 0.7
  rotate <0.0, 102.538559, 304.807831>
  translate  <0.48168, 1.29175, 9.51135>
}
#declare _Leaf1B4_1B2_1B3_1B8_Ref = object {
  _Leaf1B4_1B2_1B3_1B8
  scale 0.7
  rotate <0.0, 106.957588, 268.700165>
  translate  <0.50638, 1.21743, 9.69553>
}
#declare _Leaf1B4_1B2_1B3_1B9_Ref = object {
  _Leaf1B4_1B2_1B3_1B9
  scale 0.7
  rotate <0.0, 71.467552, 72.194611>
  translate  <0.51788, 1.23534, 9.70082>
}
#declare _Leaf1B4_1B2_1B3_1B10_Ref = object {
  _Leaf1B4_1B2_1B3_1B10
  scale 0.7
  rotate <0.0, 12.17693, 41.667782>
  translate  <0.53944, 1.16376, 9.88669>
}
#declare _Leaf1B4_1B2_1B3_1B11_Ref = object {
  _Leaf1B4_1B2_1B3_1B11
  scale 0.7
  rotate <0.0, 34.366699, 191.548004>
  translate  <0.53072, 1.15889, 9.88623>
}
#declare _Leaf1B4_1B2_1B3_1B12_Ref = object {
  _Leaf1B4_1B2_1B3_1B12
  scale 0.7
  rotate <0.0, 83.451439, 213.250122>
  translate  <0.53036, 1.14961, 9.88251>
}
#declare _Leaf1B4_1B3_2B1_1B1_Ref = object {
  _Leaf1B4_1B3_2B1_1B1
  scale 0.7
  rotate <0.0, 95.477379, 343.074554>
  translate  <2.41176, 0.5197, 9.42935>
}
#declare _Leaf1B4_1B3_2B1_1B2_Ref = object {
  _Leaf1B4_1B3_2B1_1B2
  scale 0.7
  rotate <0.0, 116.474419, 22.839451>
  translate  <2.60211, 0.56158, 9.48061>
}
#declare _Leaf1B4_1B3_2B1_1B3_Ref = object {
  _Leaf1B4_1B3_2B1_1B3
  scale 0.7
  rotate <0.0, 52.948101, 280.17572>
  translate  <2.68898, 0.55181, 9.54704>
}
#declare _Leaf1B4_1B3_2B1_1B4_Ref = object {
  _Leaf1B4_1B3_2B1_1B4
  scale 0.7
  rotate <0.0, 114.607941, 237.612167>
  translate  <2.69471, 0.53893, 9.53015>
}
#declare _Leaf1B4_1B3_2B1_1B5_Ref = object {
  _Leaf1B4_1B3_2B1_1B5
  scale 0.7
  rotate <0.0, 97.071114, 93.192551>
  translate  <2.78851, 0.5898, 9.55094>
}
#declare _Leaf1B4_1B3_2B1_1B6_Ref = object {
  _Leaf1B4_1B3_2B1_1B6
  scale 0.7
  rotate <0.0, 37.333752, 65.090408>
  translate  <3.07382, 0.60488, 9.6444>
}
#declare _Leaf1B4_1B3_2B1_1B7_Ref = object {
  _Leaf1B4_1B3_2B1_1B7
  scale 0.7
  rotate <0.0, 142.152054, 53.102901>
  translate  <3.17746, 0.60994, 9.64399>
}
#declare _Leaf1B4_1B3_2B1_1B8_Ref = object {
  _Leaf1B4_1B3_2B1_1B8
  scale 0.7
  rotate <0.0, 158.634537, 344.705688>
  translate  <3.37006, 0.6196, 9.6976>
}
#declare _Leaf1B4_1B3_2B1_1B9_Ref = object {
  _Leaf1B4_1B3_2B1_1B9
  scale 0.7
  rotate <0.0, 26.73134, 127.491463>
  translate  <3.36434, 0.63245, 9.71445>
}
#declare _Leaf1B4_1B3_2B1_1B10_Ref = object {
  _Leaf1B4_1B3_2B1_1B10
  scale 0.7
  rotate <0.0, 45.224091, 10.26232>
  translate  <3.5563, 0.63916, 9.77139>
}
#declare _Leaf1B4_1B3_2B1_1B11_Ref = object {
  _Leaf1B4_1B3_2B1_1B11
  scale 0.7
  rotate <0.0, 63.673988, 318.240723>
  translate  <3.55812, 0.63006, 9.76767>
}
#declare _Leaf1B4_1B3_2B1_1B12_Ref = object {
  _Leaf1B4_1B3_2B1_1B12
  scale 0.7
  rotate <0.0, 108.743019, 291.456512>
  translate  <3.56081, 0.62902, 9.75809>
}
#declare _Leaf1B4_1B3_2B2_1B1_Ref = object {
  _Leaf1B4_1B3_2B2_1B1
  scale 0.7
  rotate <0.0, 75.069458, 265.758545>
  translate  <2.4091, 0.13624, 9.7863>
}
#declare _Leaf1B4_1B3_2B2_1B2_Ref = object {
  _Leaf1B4_1B3_2B2_1B2
  scale 0.7
  rotate <0.0, 116.413841, 279.077057>
  translate  <2.5134, -0.03269, 9.82093>
}
#declare _Leaf1B4_1B3_2B2_1B3_Ref = object {
  _Leaf1B4_1B3_2B2_1B3
  scale 0.7
  rotate <0.0, 9.23121, 194.614334>
  translate  <2.5677, -0.10116, 9.8874>
}
#declare _Leaf1B4_1B3_2B2_1B4_Ref = object {
  _Leaf1B4_1B3_2B2_1B4
  scale 0.7
  rotate <0.0, 81.182426, 161.136703>
  translate  <2.54856, -0.11166, 9.88472>
}
#declare _Leaf1B4_1B3_2B2_1B5_Ref = object {
  _Leaf1B4_1B3_2B2_1B5
  scale 0.7
  rotate <0.0, 140.200317, 7.89966>
  translate  <2.6192, -0.19403, 9.87805>
}
#declare _Leaf1B4_1B3_2B2_1B6_Ref = object {
  _Leaf1B4_1B3_2B2_1B6
  scale 0.7
  rotate <0.0, 76.337402, 358.988556>
  translate  <2.75139, -0.44627, 9.9743>
}
#declare _Leaf1B4_1B3_2B2_1B7_Ref = object {
  _Leaf1B4_1B3_2B2_1B7
  scale 0.7
  rotate <0.0, 148.503677, 261.920776>
  translate  <2.77686, -0.54632, 9.98474>
}
#declare _Leaf1B4_1B3_2B2_1B8_Ref = object {
  _Leaf1B4_1B3_2B2_1B8
  scale 0.7
  rotate <0.0, 124.016289, 223.79628>
  translate  <2.85958, -0.71894, 10.04321>
}
#declare _Leaf1B4_1B3_2B2_1B9_Ref = object {
  _Leaf1B4_1B3_2B2_1B9
  scale 0.7
  rotate <0.0, 68.552277, 32.948421>
  translate  <2.87867, -0.70847, 10.04589>
}
#declare _Leaf1B4_1B3_2B2_1B10_Ref = object {
  _Leaf1B4_1B3_2B2_1B10
  scale 0.7
  rotate <0.0, 58.777401, 324.580658>
  translate  <2.96124, -0.87985, 10.10869>
}
#declare _Leaf1B4_1B3_2B2_1B11_Ref = object {
  _Leaf1B4_1B3_2B2_1B11
  scale 0.7
  rotate <0.0, 35.27774, 269.216431>
  translate  <2.95256, -0.88311, 10.11242>
}
#declare _Leaf1B4_1B3_2B2_1B12_Ref = object {
  _Leaf1B4_1B3_2B2_1B12
  scale 0.7
  rotate <0.0, 65.617378, 211.142166>
  translate  <2.94617, -0.88812, 10.10658>
}
#declare _Leaf1B4_1B3_2B3_1B1_Ref = object {
  _Leaf1B4_1B3_2B3_1B1
  scale 0.7
  rotate <0.0, 61.538818, 57.695419>
  translate  <2.63809, 0.4313, 10.45669>
}
#declare _Leaf1B4_1B3_2B3_1B2_Ref = object {
  _Leaf1B4_1B3_2B3_1B2
  scale 0.7
  rotate <0.0, 72.739609, 103.422028>
  translate  <2.64505, 0.53863, 10.62712>
}
#declare _Leaf1B4_1B3_2B3_1B3_Ref = object {
  _Leaf1B4_1B3_2B3_1B3
  scale 0.7
  rotate <0.0, 70.451752, 337.771698>
  translate  <2.68205, 0.55656, 10.72892>
}
#declare _Leaf1B4_1B3_2B3_1B4_Ref = object {
  _Leaf1B4_1B3_2B3_1B4
  scale 0.7
  rotate <0.0, 143.451645, 347.958099>
  translate  <2.69342, 0.57137, 10.71728>
}
#declare _Leaf1B4_1B3_2B3_1B5_Ref = object {
  _Leaf1B4_1B3_2B3_1B5
  scale 0.7
  rotate <0.0, 83.265282, 173.782104>
  translate  <2.66698, 0.62927, 10.80543>
}
#declare _Leaf1B4_1B3_2B3_1B6_Ref = object {
  _Leaf1B4_1B3_2B3_1B6
  scale 0.7
  rotate <0.0, 29.089951, 220.579636>
  translate  <2.72582, 0.77576, 11.06124>
}
#declare _Leaf1B4_1B3_2B3_1B7_Ref = object {
  _Leaf1B4_1B3_2B3_1B7
  scale 0.7
  rotate <0.0, 102.245743, 121.067146>
  translate  <2.74291, 0.85225, 11.12924>
}
#declare _Leaf1B4_1B3_2B3_1B8_Ref = object {
  _Leaf1B4_1B3_2B3_1B8
  scale 0.7
  rotate <0.0, 117.946732, 87.373894>
  translate  <2.78183, 0.95753, 11.29495>
}
#declare _Leaf1B4_1B3_2B3_1B9_Ref = object {
  _Leaf1B4_1B3_2B3_1B9
  scale 0.7
  rotate <0.0, 56.287788, 250.219193>
  translate  <2.77049, 0.94277, 11.30656>
}
#declare _Leaf1B4_1B3_2B3_1B10_Ref = object {
  _Leaf1B4_1B3_2B3_1B10
  scale 0.7
  rotate <0.0, 7.43534, 18.97875>
  translate  <2.81259, 1.04513, 11.47354>
}
#declare _Leaf1B4_1B3_2B3_1B11_Ref = object {
  _Leaf1B4_1B3_2B3_1B11
  scale 0.7
  rotate <0.0, 52.61343, 10.87531>
  translate  <2.82127, 1.0484, 11.46981>
}
#declare _Leaf1B4_1B3_2B3_1B12_Ref = object {
  _Leaf1B4_1B3_2B3_1B12
  scale 0.7
  rotate <0.0, 102.891869, 25.13554>
  translate  <2.82154, 1.05679, 11.46438>
}
#declare _Leaf1B4_1B3_2B4_1B1_Ref = object {
  _Leaf1B4_1B3_2B4_1B1
  scale 0.7
  rotate <0.0, 33.93578, 172.872162>
  translate  <2.54321, 0.09888, 10.64367>
}
#declare _Leaf1B4_1B3_2B4_1B2_Ref = object {
  _Leaf1B4_1B3_2B4_1B2
  scale 0.7
  rotate <0.0, 72.6828, 198.501923>
  translate  <2.46412, -0.00459, 10.79746>
}
#declare _Leaf1B4_1B3_2B4_1B3_Ref = object {
  _Leaf1B4_1B3_2B4_1B3
  scale 0.7
  rotate <0.0, 44.018841, 33.998779>
  translate  <2.46855, -0.04535, 10.89931>
}
#declare _Leaf1B4_1B3_2B4_1B4_Ref = object {
  _Leaf1B4_1B3_2B4_1B4
  scale 0.7
  rotate <0.0, 103.512581, 82.06147>
  translate  <2.45505, -0.02817, 10.90188>
}
#declare _Leaf1B4_1B3_2B4_1B5_Ref = object {
  _Leaf1B4_1B3_2B4_1B5
  scale 0.7
  rotate <0.0, 121.864594, 249.46196>
  translate  <2.40545, -0.10352, 10.96257>
}
#declare _Leaf1B4_1B3_2B4_1B6_Ref = object {
  _Leaf1B4_1B3_2B4_1B6
  scale 0.7
  rotate <0.0, 71.642509, 291.436005>
  translate  <2.31117, -0.22434, 11.22117>
}
#declare _Leaf1B4_1B3_2B4_1B7_Ref = object {
  _Leaf1B4_1B3_2B4_1B7
  scale 0.7
  rotate <0.0, 105.970169, 190.237183>
  translate  <2.25008, -0.25296, 11.30002>
}
#declare _Leaf1B4_1B3_2B4_1B8_Ref = object {
  _Leaf1B4_1B3_2B4_1B8
  scale 0.7
  rotate <0.0, 95.555138, 155.995987>
  translate  <2.17913, -0.32996, 11.4706>
}
#declare _Leaf1B4_1B3_2B4_1B9_Ref = object {
  _Leaf1B4_1B3_2B4_1B9
  scale 0.7
  rotate <0.0, 88.421402, 320.678619>
  translate  <2.19259, -0.3471, 11.46803>
}
#declare _Leaf1B4_1B3_2B4_1B10_Ref = object {
  _Leaf1B4_1B3_2B4_1B10
  scale 0.7
  rotate <0.0, 36.329811, 281.761353>
  translate  <2.12531, -0.42282, 11.64087>
}
#declare _Leaf1B4_1B3_2B4_1B11_Ref = object {
  _Leaf1B4_1B3_2B4_1B11
  scale 0.7
  rotate <0.0, 11.45715, 58.49366>
  translate  <2.12349, -0.41372, 11.64459>
}
#declare _Leaf1B4_1B3_2B4_1B12_Ref = object {
  _Leaf1B4_1B3_2B4_1B12
  scale 0.7
  rotate <0.0, 59.26685, 106.453659>
  translate  <2.11469, -0.40929, 11.64289>
}
#declare _Leaf1B4_1B3_2B5_1B1_Ref = object {
  _Leaf1B4_1B3_2B5_1B1
  scale 0.7
  rotate <0.0, 31.591539, 272.014862>
  translate  <2.9293, 0.03049, 10.90447>
}
#declare _Leaf1B4_1B3_2B5_1B2_Ref = object {
  _Leaf1B4_1B3_2B5_1B2
  scale 0.7
  rotate <0.0, 70.26062, 298.898804>
  translate  <3.04296, -0.02262, 11.06218>
}
#declare _Leaf1B4_1B3_2B5_1B3_Ref = object {
  _Leaf1B4_1B3_2B5_1B3
  scale 0.7
  rotate <0.0, 46.259232, 133.270584>
  translate  <3.08081, -0.00689, 11.16404>
}
#declare _Leaf1B4_1B3_2B5_1B4_Ref = object {
  _Leaf1B4_1B3_2B5_1B4
  scale 0.7
  rotate <0.0, 104.23423, 182.907303>
  translate  <3.06627, -0.02312, 11.16706>
}
#declare _Leaf1B4_1B3_2B5_1B5_Ref = object {
  _Leaf1B4_1B3_2B5_1B5
  scale 0.7
  rotate <0.0, 120.614349, 348.44809>
  translate  <3.14835, -0.056, 11.23031>
}
#declare _Leaf1B4_1B3_2B5_1B6_Ref = object {
  _Leaf1B4_1B3_2B5_1B6
  scale 0.7
  rotate <0.0, 72.168159, 32.485729>
  translate  <3.28027, -0.11672, 11.4935>
}
#declare _Leaf1B4_1B3_2B5_1B7_Ref = object {
  _Leaf1B4_1B3_2B5_1B7
  scale 0.7
  rotate <0.0, 103.517273, 290.495087>
  translate  <3.31816, -0.16849, 11.57507>
}
#declare _Leaf1B4_1B3_2B5_1B8_Ref = object {
  _Leaf1B4_1B3_2B5_1B8
  scale 0.7
  rotate <0.0, 93.507217, 256.36969>
  translate  <3.40409, -0.21764, 11.74902>
}
#declare _Leaf1B4_1B3_2B5_1B9_Ref = object {
  _Leaf1B4_1B3_2B5_1B9
  scale 0.7
  rotate <0.0, 90.038498, 60.97007>
  translate  <3.41859, -0.20145, 11.74601>
}
#declare _Leaf1B4_1B3_2B5_1B10_Ref = object {
  _Leaf1B4_1B3_2B5_1B10
  scale 0.7
  rotate <0.0, 36.4995, 25.34659>
  translate  <3.50257, -0.24713, 11.92207>
}
#declare _Leaf1B4_1B3_2B5_1B11_Ref = object {
  _Leaf1B4_1B3_2B5_1B11
  scale 0.7
  rotate <0.0, 13.19427, 150.805862>
  translate  <3.49389, -0.25039, 11.9258>
}
#declare _Leaf1B4_1B3_2B5_1B12_Ref = object {
  _Leaf1B4_1B3_2B5_1B12
  scale 0.7
  rotate <0.0, 58.998951, 205.262573>
  translate  <3.49112, -0.25991, 11.92444>
}
#declare _Leaf1B4_1B3_1B1_1B1_Ref = object {
  _Leaf1B4_1B3_1B1_1B1
  scale 0.7
  rotate <0.0, 69.986801, 267.283813>
  translate  <1.48474, 0.52066, 7.97132>
}
#declare _Leaf1B4_1B3_1B1_1B2_Ref = object {
  _Leaf1B4_1B3_1B1_1B2
  scale 0.7
  rotate <0.0, 110.93515, 281.749695>
  translate  <1.59399, 0.35991, 8.0246>
}
#declare _Leaf1B4_1B3_1B1_1B3_Ref = object {
  _Leaf1B4_1B3_1B1_1B3
  scale 0.7
  rotate <0.0, 11.16465, 167.360336>
  translate  <1.64839, 0.29997, 8.09878>
}
#declare _Leaf1B4_1B3_1B1_1B4_Ref = object {
  _Leaf1B4_1B3_1B1_1B4
  scale 0.7
  rotate <0.0, 84.65789, 162.836746>
  translate  <1.62976, 0.2885, 8.09645>
}
#declare _Leaf1B4_1B3_1B1_1B5_Ref = object {
  _Leaf1B4_1B3_1B1_1B5
  scale 0.7
  rotate <0.0, 138.781326, 3.8313>
  translate  <1.70364, 0.2088, 8.09963>
}
#declare _Leaf1B4_1B3_1B1_1B6_Ref = object {
  _Leaf1B4_1B3_1B1_1B6
  scale 0.7
  rotate <0.0, 74.449623, 2.59507>
  translate  <1.84164, -0.02817, 8.22278>
}
#declare _Leaf1B4_1B3_1B1_1B7_Ref = object {
  _Leaf1B4_1B3_1B1_1B7
  scale 0.7
  rotate <0.0, 143.487564, 267.751373>
  translate  <1.87045, -0.12576, 8.24313>
}
#declare _Leaf1B4_1B3_1B1_1B8_Ref = object {
  _Leaf1B4_1B3_1B1_1B8
  scale 0.7
  rotate <0.0, 121.579781, 229.265747>
  translate  <1.95742, -0.28891, 8.31979>
}
#declare _Leaf1B4_1B3_1B1_1B9_Ref = object {
  _Leaf1B4_1B3_1B1_1B9
  scale 0.7
  rotate <0.0, 69.946251, 37.23267>
  translate  <1.976, -0.27747, 8.32212>
}
#declare _Leaf1B4_1B3_1B1_1B10_Ref = object {
  _Leaf1B4_1B3_1B1_1B10
  scale 0.7
  rotate <0.0, 54.282879, 328.995941>
  translate  <2.06262, -0.43901, 8.40296>
}
#declare _Leaf1B4_1B3_1B1_1B11_Ref = object {
  _Leaf1B4_1B3_1B1_1B11
  scale 0.7
  rotate <0.0, 30.109859, 268.221985>
  translate  <2.05394, -0.44227, 8.40669>
}
#declare _Leaf1B4_1B3_1B1_1B12_Ref = object {
  _Leaf1B4_1B3_1B1_1B12
  scale 0.7
  rotate <0.0, 64.612442, 210.840942>
  translate  <2.04796, -0.44804, 8.40113>
}
#declare _Leaf1B4_1B3_1B2_1B1_Ref = object {
  _Leaf1B4_1B3_1B2_1B1
  scale 0.7
  rotate <0.0, 40.082771, 124.477089>
  translate  <1.4683, 0.73605, 8.58372>
}
#declare _Leaf1B4_1B3_1B2_1B2_Ref = object {
  _Leaf1B4_1B3_1B2_1B2
  scale 0.7
  rotate <0.0, 67.356079, 167.71788>
  translate  <1.37746, 0.72434, 8.76323>
}
#declare _Leaf1B4_1B3_1B2_1B3_Ref = object {
  _Leaf1B4_1B3_1B2_1B3
  scale 0.7
  rotate <0.0, 56.599239, 21.929411>
  translate  <1.37984, 0.71732, 8.87278>
}
#declare _Leaf1B4_1B3_1B2_1B4_Ref = object {
  _Leaf1B4_1B3_1B2_1B4
  scale 0.7
  rotate <0.0, 122.331711, 56.914928>
  translate  <1.37449, 0.73843, 8.86969>
}
#declare _Leaf1B4_1B3_1B2_1B5_Ref = object {
  _Leaf1B4_1B3_1B2_1B5
  scale 0.7
  rotate <0.0, 103.825996, 227.904343>
  translate  <1.30857, 0.71152, 8.95186>
}
#declare _Leaf1B4_1B3_1B2_1B6_Ref = object {
  _Leaf1B4_1B3_1B2_1B6
  scale 0.7
  rotate <0.0, 54.326988, 271.385162>
  translate  <1.21164, 0.72191, 9.23621>
}
#declare _Leaf1B4_1B3_1B2_1B7_Ref = object {
  _Leaf1B4_1B3_1B2_1B7
  scale 0.7
  rotate <0.0, 101.500961, 170.700012>
  translate  <1.15573, 0.74541, 9.32042>
}
#declare _Leaf1B4_1B3_1B2_1B8_Ref = object {
  _Leaf1B4_1B3_1B2_1B8
  scale 0.7
  rotate <0.0, 102.600601, 134.750717>
  translate  <1.08483, 0.75817, 9.50715>
}
#declare _Leaf1B4_1B3_1B2_1B9_Ref = object {
  _Leaf1B4_1B3_1B2_1B9
  scale 0.7
  rotate <0.0, 76.836884, 298.557251>
  translate  <1.09016, 0.73711, 9.51023>
}
#declare _Leaf1B4_1B3_1B2_1B10_Ref = object {
  _Leaf1B4_1B3_1B2_1B10
  scale 0.7
  rotate <0.0, 18.241249, 269.597351>
  translate  <1.02342, 0.75013, 9.69867>
}
#declare _Leaf1B4_1B3_1B2_1B11_Ref = object {
  _Leaf1B4_1B3_1B2_1B11
  scale 0.7
  rotate <0.0, 29.405809, 53.07354>
  translate  <1.02577, 0.75984, 9.69924>
}
#declare _Leaf1B4_1B3_1B2_1B12_Ref = object {
  _Leaf1B4_1B3_1B2_1B12
  scale 0.7
  rotate <0.0, 77.49205, 80.22451>
  translate  <1.01921, 0.76676, 9.69624>
}
#declare _Leaf1B4_1B3_1B3_1B1_Ref = object {
  _Leaf1B4_1B3_1B3_1B1
  scale 0.7
  rotate <0.0, 87.80217, 11.66656>
  translate  <1.9234, 0.80263, 8.59563>
}
#declare _Leaf1B4_1B3_1B3_1B2_Ref = object {
  _Leaf1B4_1B3_1B3_1B2
  scale 0.7
  rotate <0.0, 105.001961, 51.849602>
  translate  <2.06407, 0.91764, 8.6828>
}
#declare _Leaf1B4_1B3_1B3_1B3_Ref = object {
  _Leaf1B4_1B3_1B3_1B3
  scale 0.7
  rotate <0.0, 57.940151, 301.264099>
  translate  <2.13784, 0.93746, 8.76167>
}
#declare _Leaf1B4_1B3_1B3_1B4_Ref = object {
  _Leaf1B4_1B3_1B3_1B4
  scale 0.7
  rotate <0.0, 124.937248, 269.003601>
  translate  <2.1507, 0.93182, 8.74474>
}
#declare _Leaf1B4_1B3_1B3_1B5_Ref = object {
  _Leaf1B4_1B3_1B3_1B5
  scale 0.7
  rotate <0.0, 91.415543, 120.778976>
  translate  <2.20595, 1.01561, 8.78653>
}
#declare _Leaf1B4_1B3_1B3_1B6_Ref = object {
  _Leaf1B4_1B3_1B3_1B6
  scale 0.7
  rotate <0.0, 28.242359, 104.797798>
  translate  <2.43803, 1.14356, 8.92842>
}
#declare _Leaf1B4_1B3_1B3_1B7_Ref = object {
  _Leaf1B4_1B3_1B3_1B7
  scale 0.7
  rotate <0.0, 131.179825, 77.388496>
  translate  <2.52597, 1.19568, 8.94625>
}
#declare _Leaf1B4_1B3_1B3_1B8_Ref = object {
  _Leaf1B4_1B3_1B3_1B8
  scale 0.7
  rotate <0.0, 149.590515, 28.365971>
  translate  <2.68382, 1.28326, 9.03269>
}
#declare _Leaf1B4_1B3_1B3_1B9_Ref = object {
  _Leaf1B4_1B3_1B3_1B9
  scale 0.7
  rotate <0.0, 29.99811, 176.679657>
  translate  <2.671, 1.28888, 9.04958>
}
#declare _Leaf1B4_1B3_1B3_1B10_Ref = object {
  _Leaf1B4_1B3_1B3_1B10
  scale 0.7
  rotate <0.0, 34.645649, 32.828281>
  translate  <2.82938, 1.37301, 9.13886>
}
#declare _Leaf1B4_1B3_1B3_1B11_Ref = object {
  _Leaf1B4_1B3_1B3_1B11
  scale 0.7
  rotate <0.0, 60.977329, 340.637909>
  translate  <2.83571, 1.36657, 9.13456>
}
#declare _Leaf1B4_1B3_1B3_1B12_Ref = object {
  _Leaf1B4_1B3_1B3_1B12
  scale 0.7
  rotate <0.0, 110.442734, 323.899719>
  translate  <2.8395, 1.36857, 9.12553>
}
#declare _Leaf1B4_1B4_2B1_1B1_Ref = object {
  _Leaf1B4_1B4_2B1_1B1
  scale 0.7
  rotate <0.0, 106.265221, 43.743752>
  translate  <3.35202, 2.61433, 10.79725>
}
#declare _Leaf1B4_1B4_2B1_1B2_Ref = object {
  _Leaf1B4_1B4_2B1_1B2
  scale 0.7
  rotate <0.0, 114.623901, 89.325569>
  translate  <3.43176, 2.79513, 10.83679>
}
#declare _Leaf1B4_1B4_2B1_1B3_Ref = object {
  _Leaf1B4_1B4_2B1_1B3
  scale 0.7
  rotate <0.0, 70.576958, 339.790894>
  translate  <3.50435, 2.86005, 10.88751>
}
#declare _Leaf1B4_1B4_2B1_1B4_Ref = object {
  _Leaf1B4_1B4_2B1_1B4
  scale 0.7
  rotate <0.0, 124.187347, 286.872803>
  translate  <3.51253, 2.85916, 10.86711>
}
#declare _Leaf1B4_1B4_2B1_1B5_Ref = object {
  _Leaf1B4_1B4_2B1_1B5
  scale 0.7
  rotate <0.0, 80.04126, 150.943542>
  translate  <3.52621, 2.96434, 10.891>
}
#declare _Leaf1B4_1B4_2B1_1B6_Ref = object {
  _Leaf1B4_1B4_2B1_1B6
  scale 0.7
  rotate <0.0, 27.66074, 98.678993>
  translate  <3.68905, 3.20943, 10.95244>
}
#declare _Leaf1B4_1B4_2B1_1B7_Ref = object {
  _Leaf1B4_1B4_2B1_1B7
  scale 0.7
  rotate <0.0, 130.683502, 125.736687>
  translate  <3.73816, 3.30023, 10.94193>
}
#declare _Leaf1B4_1B4_2B1_1B8_Ref = object {
  _Leaf1B4_1B4_2B1_1B8
  scale 0.7
  rotate <0.0, 162.343414, 94.42189>
  translate  <3.84563, 3.46596, 10.97424>
}
#declare _Leaf1B4_1B4_2B1_1B9_Ref = object {
  _Leaf1B4_1B4_2B1_1B9
  scale 0.7
  rotate <0.0, 10.68626, 211.823273>
  translate  <3.83747, 3.46685, 10.99458>
}
#declare _Leaf1B4_1B4_2B1_1B10_Ref = object {
  _Leaf1B4_1B4_2B1_1B10
  scale 0.7
  rotate <0.0, 51.0574, 52.78606>
  translate  <3.94799, 3.6303, 11.02928>
}
#declare _Leaf1B4_1B4_2B1_1B11_Ref = object {
  _Leaf1B4_1B4_2B1_1B11
  scale 0.7
  rotate <0.0, 79.840874, 13.55429>
  translate  <3.95511, 3.6273, 11.02293>
}
#declare _Leaf1B4_1B4_2B1_1B12_Ref = object {
  _Leaf1B4_1B4_2B1_1B12
  scale 0.7
  rotate <0.0, 126.650101, 349.383026>
  translate  <3.95444, 3.6296, 11.01322>
}
#declare _Leaf1B4_1B4_2B2_1B1_Ref = object {
  _Leaf1B4_1B4_2B2_1B1
  scale 0.7
  rotate <0.0, 91.315842, 324.563965>
  translate  <3.76625, 2.39087, 11.02732>
}
#declare _Leaf1B4_1B4_2B2_1B2_Ref = object {
  _Leaf1B4_1B4_2B2_1B2
  scale 0.7
  rotate <0.0, 133.825699, 333.962982>
  translate  <3.96595, 2.38921, 11.00023>
}
#declare _Leaf1B4_1B4_2B2_1B3_Ref = object {
  _Leaf1B4_1B4_2B2_1B3
  scale 0.7
  rotate <0.0, 19.10008, 320.021973>
  translate  <4.06891, 2.39573, 11.03781>
}
#declare _Leaf1B4_1B4_2B2_1B4_Ref = object {
  _Leaf1B4_1B4_2B2_1B4
  scale 0.7
  rotate <0.0, 70.019096, 222.667053>
  translate  <4.06668, 2.37411, 11.03438>
}
#declare _Leaf1B4_1B4_2B2_1B5_Ref = object {
  _Leaf1B4_1B4_2B2_1B5
  scale 0.7
  rotate <0.0, 140.948349, 87.8703>
  translate  <4.16712, 2.39149, 10.99656>
}
#declare _Leaf1B4_1B4_2B2_1B6_Ref = object {
  _Leaf1B4_1B4_2B2_1B6
  scale 0.7
  rotate <0.0, 83.599243, 53.95752>
  translate  <4.46664, 2.3664, 11.00113>
}
#declare _Leaf1B4_1B4_2B2_1B7_Ref = object {
  _Leaf1B4_1B4_2B2_1B7
  scale 0.7
  rotate <0.0, 162.06163, 292.921112>
  translate  <4.5632, 2.33513, 10.97955>
}
#declare _Leaf1B4_1B4_2B2_1B8_Ref = object {
  _Leaf1B4_1B4_2B2_1B8
  scale 0.7
  rotate <0.0, 129.047867, 268.810516>
  translate  <4.76196, 2.31181, 10.97651>
}
#declare _Leaf1B4_1B4_2B2_1B9_Ref = object {
  _Leaf1B4_1B4_2B2_1B9
  scale 0.7
  rotate <0.0, 66.054291, 83.357071>
  translate  <4.76418, 2.33337, 10.97992>
}
#declare _Leaf1B4_1B4_2B2_1B10_Ref = object {
  _Leaf1B4_1B4_2B2_1B10
  scale 0.7
  rotate <0.0, 74.126572, 18.38846>
  translate  <4.96318, 2.31032, 10.98137>
}
#declare _Leaf1B4_1B4_2B2_1B11_Ref = object {
  _Leaf1B4_1B4_2B2_1B11
  scale 0.7
  rotate <0.0, 52.249352, 333.24472>
  translate  <4.96246, 2.30101, 10.98495>
}
#declare _Leaf1B4_1B4_2B2_1B12_Ref = object {
  _Leaf1B4_1B4_2B2_1B12
  scale 0.7
  rotate <0.0, 69.829781, 276.232117>
  translate  <4.96143, 2.2933, 10.97867>
}
#declare _Leaf1B4_1B4_2B3_1B1_Ref = object {
  _Leaf1B4_1B4_2B3_1B1
  scale 0.7
  rotate <0.0, 52.12175, 105.500633>
  translate  <3.84962, 2.70116, 11.72424>
}
#declare _Leaf1B4_1B4_2B3_1B2_Ref = object {
  _Leaf1B4_1B4_2B3_1B2
  scale 0.7
  rotate <0.0, 55.024899, 160.006149>
  translate  <3.8185, 2.75336, 11.91639>
}
#declare _Leaf1B4_1B4_2B3_1B3_Ref = object {
  _Leaf1B4_1B4_2B3_1B3
  scale 0.7
  rotate <0.0, 83.168663, 32.671848>
  translate  <3.85388, 2.78831, 12.01427>
}
#declare _Leaf1B4_1B4_2B3_1B4_Ref = object {
  _Leaf1B4_1B4_2B3_1B4
  scale 0.7
  rotate <0.0, 149.882004, 71.812927>
  translate  <3.84433, 2.8064, 12.00617>
}
#declare _Leaf1B4_1B4_2B3_1B5_Ref = object {
  _Leaf1B4_1B4_2B3_1B5
  scale 0.7
  rotate <0.0, 75.372871, 234.736923>
  translate  <3.81088, 2.8091, 12.10958>
}
#declare _Leaf1B4_1B4_2B3_1B6_Ref = object {
  _Leaf1B4_1B4_2B3_1B6
  scale 0.7
  rotate <0.0, 38.547649, 301.745697>
  translate  <3.8008, 2.92097, 12.38841>
}
#declare _Leaf1B4_1B4_2B3_1B7_Ref = object {
  _Leaf1B4_1B4_2B3_1B7
  scale 0.7
  rotate <0.0, 84.590843, 178.778061>
  translate  <3.76872, 2.97157, 12.47314>
}
#declare _Leaf1B4_1B4_2B3_1B8_Ref = object {
  _Leaf1B4_1B4_2B3_1B8
  scale 0.7
  rotate <0.0, 101.397179, 147.752686>
  translate  <3.75427, 3.05015, 12.65664>
}
#declare _Leaf1B4_1B4_2B3_1B9_Ref = object {
  _Leaf1B4_1B4_2B3_1B9
  scale 0.7
  rotate <0.0, 70.412323, 313.7229>
  translate  <3.76379, 3.03212, 12.66472>
}
#declare _Leaf1B4_1B4_2B3_1B10_Ref = object {
  _Leaf1B4_1B4_2B3_1B10
  scale 0.7
  rotate <0.0, 19.615879, 11.8158>
  translate  <3.7537, 3.1118, 12.84825>
}
#declare _Leaf1B4_1B4_2B3_1B11_Ref = object {
  _Leaf1B4_1B4_2B3_1B11
  scale 0.7
  rotate <0.0, 57.744339, 56.700409>
  translate  <3.75442, 3.12111, 12.84467>
}
#declare _Leaf1B4_1B4_2B3_1B12_Ref = object {
  _Leaf1B4_1B4_2B3_1B12
  scale 0.7
  rotate <0.0, 101.074982, 86.841667>
  translate  <3.74618, 3.12604, 12.84187>
}
#declare _Leaf1B4_1B4_2B4_1B1_Ref = object {
  _Leaf1B4_1B4_2B4_1B1
  scale 0.7
  rotate <0.0, 29.41259, 259.449585>
  translate  <4.12412, 2.4358, 11.81749>
}
#declare _Leaf1B4_1B4_2B4_1B2_Ref = object {
  _Leaf1B4_1B4_2B4_1B2
  scale 0.7
  rotate <0.0, 72.697678, 262.023621>
  translate  <4.21295, 2.30554, 11.94301>
}
#declare _Leaf1B4_1B4_2B4_1B3_Ref = object {
  _Leaf1B4_1B4_2B4_1B3
  scale 0.7
  rotate <0.0, 42.999882, 72.813858>
  translate  <4.27871, 2.2821, 12.02775>
}
#declare _Leaf1B4_1B4_2B4_1B4_Ref = object {
  _Leaf1B4_1B4_2B4_1B4
  scale 0.7
  rotate <0.0, 87.787048, 140.814087>
  translate  <4.25875, 2.27946, 12.03663>
}
#declare _Leaf1B4_1B4_2B4_1B5_Ref = object {
  _Leaf1B4_1B4_2B4_1B5
  scale 0.7
  rotate <0.0, 134.185989, 297.019287>
  translate  <4.31206, 2.19436, 12.07832>
}
#declare _Leaf1B4_1B4_2B4_1B6_Ref = object {
  _Leaf1B4_1B4_2B4_1B6
  scale 0.7
  rotate <0.0, 89.549629, 349.320251>
  translate  <4.43866, 2.03605, 12.30028>
}
#declare _Leaf1B4_1B4_2B4_1B7_Ref = object {
  _Leaf1B4_1B4_2B4_1B7
  scale 0.7
  rotate <0.0, 101.84359, 243.776825>
  translate  <4.45403, 1.96458, 12.37393>
}
#declare _Leaf1B4_1B4_2B4_1B8_Ref = object {
  _Leaf1B4_1B4_2B4_1B8
  scale 0.7
  rotate <0.0, 82.80117, 214.071274>
  translate  <4.53086, 1.85411, 12.52209>
}
#declare _Leaf1B4_1B4_2B4_1B9_Ref = object {
  _Leaf1B4_1B4_2B4_1B9
  scale 0.7
  rotate <0.0, 103.977303, 19.54891>
  translate  <4.55077, 1.85674, 12.51324>
}
#declare _Leaf1B4_1B4_2B4_1B10_Ref = object {
  _Leaf1B4_1B4_2B4_1B10
  scale 0.7
  rotate <0.0, 54.06012, 342.219696>
  translate  <4.62915, 1.74993, 12.66351>
}
#declare _Leaf1B4_1B4_2B4_1B11_Ref = object {
  _Leaf1B4_1B4_2B4_1B11
  scale 0.7
  rotate <0.0, 14.17751, 29.38579>
  translate  <4.62203, 1.75292, 12.66987>
}
#declare _Leaf1B4_1B4_2B4_1B12_Ref = object {
  _Leaf1B4_1B4_2B4_1B12
  scale 0.7
  rotate <0.0, 41.440491, 162.90274>
  translate  <4.61344, 1.74785, 12.6705>
}
#declare _Leaf1B4_1B4_2B5_1B1_Ref = object {
  _Leaf1B4_1B4_2B5_1B1
  scale 0.7
  rotate <0.0, 48.816349, 335.892212>
  translate  <4.45633, 2.71327, 12.003>
}
#declare _Leaf1B4_1B4_2B5_1B2_Ref = object {
  _Leaf1B4_1B4_2B5_1B2
  scale 0.7
  rotate <0.0, 88.020943, 356.345093>
  translate  <4.60504, 2.77302, 12.12518>
}
#declare _Leaf1B4_1B4_2B5_1B3_Ref = object {
  _Leaf1B4_1B4_2B5_1B3
  scale 0.7
  rotate <0.0, 30.24621, 201.663727>
  translate  <4.64263, 2.80755, 12.22239>
}
#declare _Leaf1B4_1B4_2B5_1B4_Ref = object {
  _Leaf1B4_1B4_2B5_1B4
  scale 0.7
  rotate <0.0, 98.052917, 237.458344>
  translate  <4.6491, 2.78652, 12.22223>
}
#declare _Leaf1B4_1B4_2B5_1B5_Ref = object {
  _Leaf1B4_1B4_2B5_1B5
  scale 0.7
  rotate <0.0, 128.903793, 57.497688>
  translate  <4.7368, 2.83547, 12.26384>
}
#declare _Leaf1B4_1B4_2B5_1B6_Ref = object {
  _Leaf1B4_1B4_2B5_1B6
  scale 0.7
  rotate <0.0, 69.615067, 84.183289>
  translate  <4.93287, 2.90068, 12.48217>
}
#declare _Leaf1B4_1B4_2B5_1B7_Ref = object {
  _Leaf1B4_1B4_2B5_1B7
  scale 0.7
  rotate <0.0, 121.422638, 348.279907>
  translate  <5.01854, 2.9011, 12.54072>
}
#declare _Leaf1B4_1B4_2B5_1B8_Ref = object {
  _Leaf1B4_1B4_2B5_1B8
  scale 0.7
  rotate <0.0, 108.05423, 312.246155>
  translate  <5.15471, 2.9384, 12.68258>
}
#declare _Leaf1B4_1B4_2B5_1B9_Ref = object {
  _Leaf1B4_1B4_2B5_1B9
  scale 0.7
  rotate <0.0, 78.710297, 117.480904>
  translate  <5.14827, 2.95938, 12.68274>
}
#declare _Leaf1B4_1B4_2B5_1B10_Ref = object {
  _Leaf1B4_1B4_2B5_1B10
  scale 0.7
  rotate <0.0, 38.929138, 59.935162>
  translate  <5.28129, 2.99673, 12.82781>
}
#declare _Leaf1B4_1B4_2B5_1B11_Ref = object {
  _Leaf1B4_1B4_2B5_1B11
  scale 0.7
  rotate <0.0, 11.31527, 301.384552>
  translate  <5.28057, 2.98742, 12.8314>
}
#declare _Leaf1B4_1B4_2B5_1B12_Ref = object {
  _Leaf1B4_1B4_2B5_1B12
  scale 0.7
  rotate <0.0, 61.85215, 273.286407>
  translate  <5.28637, 2.98017, 12.82769>
}
#declare _Leaf1B4_1B4_1B1_1B1_Ref = object {
  _Leaf1B4_1B4_1B1_1B1
  scale 0.7
  rotate <0.0, 86.46283, 326.661804>
  translate  <2.43422, 1.91083, 9.51352>
}
#declare _Leaf1B4_1B4_1B1_1B2_Ref = object {
  _Leaf1B4_1B4_1B1_1B2
  scale 0.7
  rotate <0.0, 128.552017, 337.770203>
  translate  <2.63552, 1.91657, 9.50598>
}
#declare _Leaf1B4_1B4_1B1_1B3_Ref = object {
  _Leaf1B4_1B4_1B1_1B3
  scale 0.7
  rotate <0.0, 14.81394, 310.221832>
  translate  <2.73402, 1.92719, 9.55332>
}
#declare _Leaf1B4_1B4_1B1_1B4_Ref = object {
  _Leaf1B4_1B4_1B1_1B4
  scale 0.7
  rotate <0.0, 73.806229, 223.469696>
  translate  <2.73294, 1.90549, 9.54989>
}
#declare _Leaf1B4_1B4_1B1_1B5_Ref = object {
  _Leaf1B4_1B4_1B1_1B5
  scale 0.7
  rotate <0.0, 140.939056, 83.109863>
  translate  <2.83587, 1.92644, 9.52184>
}
#declare _Leaf1B4_1B4_1B1_1B6_Ref = object {
  _Leaf1B4_1B4_1B1_1B6
  scale 0.7
  rotate <0.0, 80.778442, 56.77412>
  translate  <3.13424, 1.91273, 9.55573>
}
#declare _Leaf1B4_1B4_1B1_1B7_Ref = object {
  _Leaf1B4_1B4_1B1_1B7
  scale 0.7
  rotate <0.0, 158.834732, 308.046509>
  translate  <3.23354, 1.88501, 9.54392>
}
#declare _Leaf1B4_1B4_1B1_1B8_Ref = object {
  _Leaf1B4_1B4_1B1_1B8
  scale 0.7
  rotate <0.0, 128.409393, 275.430054>
  translate  <3.43238, 1.8692, 9.56042>
}
#declare _Leaf1B4_1B4_1B1_1B9_Ref = object {
  _Leaf1B4_1B4_1B1_1B9
  scale 0.7
  rotate <0.0, 66.063362, 87.998238>
  translate  <3.43345, 1.89085, 9.56383>
}
#declare _Leaf1B4_1B4_1B1_1B10_Ref = object {
  _Leaf1B4_1B4_1B1_1B10
  scale 0.7
  rotate <0.0, 69.019447, 21.30805>
  translate  <3.63208, 1.87536, 9.58482>
}
#declare _Leaf1B4_1B4_1B1_1B11_Ref = object {
  _Leaf1B4_1B4_1B1_1B11
  scale 0.7
  rotate <0.0, 47.06086, 333.600616>
  translate  <3.63136, 1.86605, 9.5884>
}
#declare _Leaf1B4_1B4_1B1_1B12_Ref = object {
  _Leaf1B4_1B4_1B1_1B12
  scale 0.7
  rotate <0.0, 68.790512, 276.303772>
  translate  <3.63124, 1.85827, 9.58212>
}
#declare _Leaf1B4_1B4_1B2_1B1_Ref = object {
  _Leaf1B4_1B4_1B2_1B1
  scale 0.7
  rotate <0.0, 22.957491, 191.321274>
  translate  <2.4378, 1.97409, 10.1598>
}
#declare _Leaf1B4_1B4_1B2_1B2_Ref = object {
  _Leaf1B4_1B4_1B2_1B2
  scale 0.7
  rotate <0.0, 58.45356, 233.654343>
  translate  <2.45471, 1.88034, 10.33739>
}
#declare _Leaf1B4_1B4_1B2_1B3_Ref = object {
  _Leaf1B4_1B4_1B2_1B3
  scale 0.7
  rotate <0.0, 58.211769, 68.304619>
  translate  <2.49464, 1.87236, 10.43935>
}
#declare _Leaf1B4_1B4_1B2_1B4_Ref = object {
  _Leaf1B4_1B4_1B2_1B4
  scale 0.7
  rotate <0.0, 110.946938, 121.834419>
  translate  <2.47401, 1.87904, 10.44307>
}
#declare _Leaf1B4_1B4_1B2_1B5_Ref = object {
  _Leaf1B4_1B4_1B2_1B5
  scale 0.7
  rotate <0.0, 111.176788, 280.595856>
  translate  <2.48653, 1.80415, 10.52089>
}
#declare _Leaf1B4_1B4_1B2_1B6_Ref = object {
  _Leaf1B4_1B4_1B2_1B6
  scale 0.7
  rotate <0.0, 71.33596, 332.206116>
  translate  <2.51422, 1.71071, 10.80526>
}
#declare _Leaf1B4_1B4_1B2_1B7_Ref = object {
  _Leaf1B4_1B4_1B2_1B7
  scale 0.7
  rotate <0.0, 92.091141, 226.757874>
  translate  <2.49204, 1.6706, 10.89835>
}
#declare _Leaf1B4_1B4_1B2_1B8_Ref = object {
  _Leaf1B4_1B4_1B2_1B8
  scale 0.7
  rotate <0.0, 86.121773, 192.1008>
  translate  <2.50173, 1.60619, 11.08761>
}
#declare _Leaf1B4_1B4_1B2_1B9_Ref = object {
  _Leaf1B4_1B4_1B2_1B9
  scale 0.7
  rotate <0.0, 94.605026, 356.280609>
  translate  <2.5223, 1.59953, 11.0839>
}
#declare _Leaf1B4_1B4_1B2_1B10_Ref = object {
  _Leaf1B4_1B4_1B2_1B10
  scale 0.7
  rotate <0.0, 35.482319, 337.674927>
  translate  <2.53443, 1.53869, 11.27439>
}
#declare _Leaf1B4_1B4_1B2_1B11_Ref = object {
  _Leaf1B4_1B4_1B2_1B11
  scale 0.7
  rotate <0.0, 24.697781, 76.193893>
  translate  <2.52802, 1.54573, 11.27745>
}
#declare _Leaf1B4_1B4_1B2_1B12_Ref = object {
  _Leaf1B4_1B4_1B2_1B12
  scale 0.7
  rotate <0.0, 62.401958, 134.543671>
  translate  <2.51818, 1.54394, 11.27731>
}
#declare _Leaf1B4_1B4_1B3_1B1_Ref = object {
  _Leaf1B4_1B4_1B3_1B1
  scale 0.7
  rotate <0.0, 90.845818, 69.349319>
  translate  <2.62199, 2.39522, 10.13945>
}
#declare _Leaf1B4_1B4_1B3_1B2_Ref = object {
  _Leaf1B4_1B4_1B3_1B2
  scale 0.7
  rotate <0.0, 95.463783, 112.507683>
  translate  <2.62834, 2.56995, 10.23966>
}
#declare _Leaf1B4_1B4_1B3_1B3_Ref = object {
  _Leaf1B4_1B4_1B3_1B3
  scale 0.7
  rotate <0.0, 75.613541, 357.896301>
  translate  <2.67418, 2.63849, 10.31216>
}
#declare _Leaf1B4_1B4_1B3_1B4_Ref = object {
  _Leaf1B4_1B4_1B3_1B4
  scale 0.7
  rotate <0.0, 141.096436, 319.518494>
  translate  <2.6802, 2.64746, 10.293>
}
#declare _Leaf1B4_1B4_1B3_1B5_Ref = object {
  _Leaf1B4_1B4_1B3_1B5
  scale 0.7
  rotate <0.0, 73.76059, 179.067764>
  translate  <2.65398, 2.73585, 10.35061>
}
#declare _Leaf1B4_1B4_1B3_1B6_Ref = object {
  _Leaf1B4_1B4_1B3_1B6
  scale 0.7
  rotate <0.0, 10.62716, 152.351852>
  translate  <2.71346, 2.99191, 10.4964>
}
#declare _Leaf1B4_1B4_1B3_1B7_Ref = object {
  _Leaf1B4_1B4_1B3_1B7
  scale 0.7
  rotate <0.0, 115.747261, 141.398529>
  translate  <2.72224, 3.09292, 10.5185>
}
#declare _Leaf1B4_1B4_1B3_1B8_Ref = object {
  _Leaf1B4_1B4_1B3_1B8
  scale 0.7
  rotate <0.0, 143.266113, 112.040352>
  translate  <2.75922, 3.26796, 10.60824>
}
#declare _Leaf1B4_1B4_1B3_1B9_Ref = object {
  _Leaf1B4_1B4_1B3_1B9
  scale 0.7
  rotate <0.0, 27.369989, 267.708221>
  translate  <2.75321, 3.25902, 10.62735>
}
#declare _Leaf1B4_1B4_1B3_1B10_Ref = object {
  _Leaf1B4_1B4_1B3_1B10
  scale 0.7
  rotate <0.0, 35.129318, 64.612099>
  translate  <2.79409, 3.43254, 10.71874>
}
#declare _Leaf1B4_1B4_1B3_1B11_Ref = object {
  _Leaf1B4_1B4_1B3_1B11
  scale 0.7
  rotate <0.0, 73.347282, 33.00362>
  translate  <2.80121, 3.4348, 10.7121>
}
#declare _Leaf1B4_1B4_1B3_1B12_Ref = object {
  _Leaf1B4_1B4_1B3_1B12
  scale 0.7
  rotate <0.0, 125.098839, 27.29981>
  translate  <2.79883, 3.4396, 10.70366>
}
#declare _Leaf1B4_1B5_2B1_1B1_Ref = object {
  _Leaf1B4_1B5_2B1_1B1
  scale 0.7
  rotate <0.0, 71.432564, 158.179047>
  translate  <1.41551, 3.57871, 11.0634>
}
#declare _Leaf1B4_1B5_2B1_1B2_Ref = object {
  _Leaf1B4_1B5_2B1_1B2
  scale 0.7
  rotate <0.0, 71.988983, 203.932022>
  translate  <1.29348, 3.59595, 11.22285>
}
#declare _Leaf1B4_1B5_2B1_1B3_Ref = object {
  _Leaf1B4_1B5_2B1_1B3
  scale 0.7
  rotate <0.0, 83.092979, 84.60508>
  translate  <1.25691, 3.64927, 11.31159>
}
#declare _Leaf1B4_1B5_2B1_1B4_Ref = object {
  _Leaf1B4_1B5_2B1_1B4
  scale 0.7
  rotate <0.0, 156.59993, 82.118721>
  translate  <1.24097, 3.65331, 11.29697>
}
#declare _Leaf1B4_1B5_2B1_1B5_Ref = object {
  _Leaf1B4_1B5_2B1_1B5
  scale 0.7
  rotate <0.0, 69.233719, 278.010864>
  translate  <1.18303, 3.63347, 11.3868>
}
#declare _Leaf1B4_1B5_2B1_1B6_Ref = object {
  _Leaf1B4_1B5_2B1_1B6
  scale 0.7
  rotate <0.0, 18.41201, 348.917236>
  translate  <1.0019, 3.70855, 11.61465>
}
#declare _Leaf1B4_1B5_2B1_1B7_Ref = object {
  _Leaf1B4_1B5_2B1_1B7
  scale 0.7
  rotate <0.0, 96.317131, 228.387848>
  translate  <0.91721, 3.7199, 11.67353>
}
#declare _Leaf1B4_1B5_2B1_1B8_Ref = object {
  _Leaf1B4_1B5_2B1_1B8
  scale 0.7
  rotate <0.0, 119.67749, 200.490295>
  translate  <0.78967, 3.76653, 11.82056>
}
#declare _Leaf1B4_1B5_2B1_1B9_Ref = object {
  _Leaf1B4_1B5_2B1_1B9
  scale 0.7
  rotate <0.0, 50.582371, 5.3379>
  translate  <0.80556, 3.7625, 11.83514>
}
#declare _Leaf1B4_1B5_2B1_1B10_Ref = object {
  _Leaf1B4_1B5_2B1_1B10
  scale 0.7
  rotate <0.0, 21.856569, 117.042702>
  translate  <0.67991, 3.81318, 11.98271>
}
#declare _Leaf1B4_1B5_2B1_1B11_Ref = object {
  _Leaf1B4_1B5_2B1_1B11
  scale 0.7
  rotate <0.0, 67.109291, 115.644119>
  translate  <0.67498, 3.81959, 11.97683>
}
#declare _Leaf1B4_1B5_2B1_1B12_Ref = object {
  _Leaf1B4_1B5_2B1_1B12
  scale 0.7
  rotate <0.0, 116.716888, 131.882294>
  translate  <0.66737, 3.81636, 11.97121>
}
#declare _Leaf1B4_1B5_2B2_1B1_Ref = object {
  _Leaf1B4_1B5_2B2_1B1
  scale 0.7
  rotate <0.0, 108.559402, 86.867523>
  translate  <1.55428, 4.07997, 11.12625>
}
#declare _Leaf1B4_1B5_2B2_1B2_Ref = object {
  _Leaf1B4_1B5_2B2_1B2
  scale 0.7
  rotate <0.0, 130.430786, 130.640594>
  translate  <1.4615, 4.25887, 11.12717>
}
#declare _Leaf1B4_1B5_2B2_1B3_Ref = object {
  _Leaf1B4_1B5_2B2_1B3
  scale 0.7
  rotate <0.0, 54.810532, 35.892658>
  translate  <1.44273, 4.35809, 11.17029>
}
#declare _Leaf1B4_1B5_2B2_1B4_Ref = object {
  _Leaf1B4_1B5_2B2_1B4
  scale 0.7
  rotate <0.0, 104.77639, 338.903076>
  translate  <1.45539, 4.36298, 11.15297>
}
#declare _Leaf1B4_1B5_2B2_1B5_Ref = object {
  _Leaf1B4_1B5_2B2_1B5
  scale 0.7
  rotate <0.0, 98.088257, 200.271729>
  translate  <1.38098, 4.44209, 11.14802>
}
#declare _Leaf1B4_1B5_2B2_1B6_Ref = object {
  _Leaf1B4_1B5_2B2_1B6
  scale 0.7
  rotate <0.0, 46.618771, 157.669144>
  translate  <1.28622, 4.72672, 11.16721>
}
#declare _Leaf1B4_1B5_2B2_1B7_Ref = object {
  _Leaf1B4_1B5_2B2_1B7
  scale 0.7
  rotate <0.0, 150.840057, 176.118881>
  translate  <1.25561, 4.82233, 11.14093>
}
#declare _Leaf1B4_1B5_2B2_1B8_Ref = object {
  _Leaf1B4_1B5_2B2_1B8
  scale 0.7
  rotate <0.0, 170.166855, 55.195599>
  translate  <1.19308, 5.01242, 11.14472>
}
#declare _Leaf1B4_1B5_2B2_1B9_Ref = object {
  _Leaf1B4_1B5_2B2_1B9
  scale 0.7
  rotate <0.0, 23.096201, 201.775681>
  translate  <1.18046, 5.00754, 11.16199>
}
#declare _Leaf1B4_1B5_2B2_1B10_Ref = object {
  _Leaf1B4_1B5_2B2_1B10
  scale 0.7
  rotate <0.0, 59.72591, 115.030296>
  translate  <1.1206, 5.19858, 11.16927>
}
#declare _Leaf1B4_1B5_2B2_1B11_Ref = object {
  _Leaf1B4_1B5_2B2_1B11
  scale 0.7
  rotate <0.0, 73.456543, 67.62674>
  translate  <1.12929, 5.20185, 11.16554>
}
#declare _Leaf1B4_1B5_2B2_1B12_Ref = object {
  _Leaf1B4_1B5_2B2_1B12
  scale 0.7
  rotate <0.0, 111.447487, 31.35268>
  translate  <1.13057, 5.20244, 11.15564>
}
#declare _Leaf1B4_1B5_2B3_1B1_Ref = object {
  _Leaf1B4_1B5_2B3_1B1
  scale 0.7
  rotate <0.0, 20.26128, 268.149689>
  translate  <1.77848, 4.17713, 11.85372>
}
#declare _Leaf1B4_1B5_2B3_1B2_Ref = object {
  _Leaf1B4_1B5_2B3_1B2
  scale 0.7
  rotate <0.0, 58.434769, 304.906769>
  translate  <1.8826, 4.16593, 12.02591>
}
#declare _Leaf1B4_1B5_2B3_1B3_Ref = object {
  _Leaf1B4_1B5_2B3_1B3
  scale 0.7
  rotate <0.0, 57.351711, 134.383896>
  translate  <1.91068, 4.20433, 12.12486>
}
#declare _Leaf1B4_1B5_2B3_1B4_Ref = object {
  _Leaf1B4_1B5_2B3_1B4
  scale 0.7
  rotate <0.0, 107.082657, 191.073715>
  translate  <1.89723, 4.18773, 12.13008>
}
#declare _Leaf1B4_1B5_2B3_1B5_Ref = object {
  _Leaf1B4_1B5_2B3_1B5
  scale 0.7
  rotate <0.0, 114.135818, 348.022186>
  translate  <1.97615, 4.17525, 12.20381>
}
#declare _Leaf1B4_1B5_2B3_1B6_Ref = object {
  _Leaf1B4_1B5_2B3_1B6
  scale 0.7
  rotate <0.0, 75.505539, 40.72673>
  translate  <2.09038, 4.17855, 12.48184>
}
#declare _Leaf1B4_1B5_2B3_1B7_Ref = object {
  _Leaf1B4_1B5_2B3_1B7
  scale 0.7
  rotate <0.0, 91.469482, 295.300232>
  translate  <2.12533, 4.14709, 12.57435>
}
#declare _Leaf1B4_1B5_2B3_1B8_Ref = object {
  _Leaf1B4_1B5_2B3_1B8
  scale 0.7
  rotate <0.0, 83.25882, 261.058167>
  translate  <2.20027, 4.14035, 12.75982>
}
#declare _Leaf1B4_1B5_2B3_1B9_Ref = object {
  _Leaf1B4_1B5_2B3_1B9
  scale 0.7
  rotate <0.0, 98.19812, 65.196373>
  translate  <2.21368, 4.15691, 12.75461>
}
#declare _Leaf1B4_1B5_2B3_1B10_Ref = object {
  _Leaf1B4_1B5_2B3_1B10
  scale 0.7
  rotate <0.0, 39.592419, 45.217831>
  translate  <2.28625, 4.15378, 12.94131>
}
#declare _Leaf1B4_1B5_2B3_1B11_Ref = object {
  _Leaf1B4_1B5_2B3_1B11
  scale 0.7
  rotate <0.0, 23.501751, 135.848206>
  translate  <2.27757, 4.15052, 12.94504>
}
#declare _Leaf1B4_1B5_2B3_1B12_Ref = object {
  _Leaf1B4_1B5_2B3_1B12
  scale 0.7
  rotate <0.0, 58.27718, 202.763397>
  translate  <2.27566, 4.14071, 12.94542>
}
#declare _Leaf1B4_1B5_2B4_1B1_Ref = object {
  _Leaf1B4_1B5_2B4_1B1
  scale 0.7
  rotate <0.0, 72.45739, 15.08178>
  translate  <1.90784, 4.53938, 11.77308>
}
#declare _Leaf1B4_1B5_2B4_1B2_Ref = object {
  _Leaf1B4_1B5_2B4_1B2
  scale 0.7
  rotate <0.0, 115.738197, 17.08379>
  translate  <2.04122, 4.68984, 11.78674>
}
#declare _Leaf1B4_1B5_2B4_1B3_Ref = object {
  _Leaf1B4_1B5_2B4_1B3
  scale 0.7
  rotate <0.0, 5.43498, 102.323318>
  translate  <2.08709, 4.77414, 11.84007>
}
#declare _Leaf1B4_1B5_2B4_1B4_Ref = object {
  _Leaf1B4_1B5_2B4_1B4
  scale 0.7
  rotate <0.0, 68.34877, 264.417023>
  translate  <2.10224, 4.75839, 11.84259>
}
#declare _Leaf1B4_1B5_2B4_1B5_Ref = object {
  _Leaf1B4_1B5_2B4_1B5
  scale 0.7
  rotate <0.0, 154.709869, 112.913269>
  translate  <2.16469, 4.84486, 11.82154>
}
#declare _Leaf1B4_1B5_2B4_1B6_Ref = object {
  _Leaf1B4_1B5_2B4_1B6
  scale 0.7
  rotate <0.0, 90.668892, 104.39222>
  translate  <2.3653, 5.05771, 11.89091>
}
#declare _Leaf1B4_1B5_2B4_1B7_Ref = object {
  _Leaf1B4_1B5_2B4_1B7
  scale 0.7
  rotate <0.0, 142.080582, 348.008301>
  translate  <2.45434, 5.11051, 11.89825>
}
#declare _Leaf1B4_1B5_2B4_1B8_Ref = object {
  _Leaf1B4_1B5_2B4_1B8
  scale 0.7
  rotate <0.0, 111.888863, 324.665314>
  translate  <2.59428, 5.24723, 11.94049>
}
#declare _Leaf1B4_1B5_2B4_1B9_Ref = object {
  _Leaf1B4_1B5_2B4_1B9
  scale 0.7
  rotate <0.0, 81.820038, 136.5215>
  translate  <2.57917, 5.26294, 11.93797>
}
#declare _Leaf1B4_1B5_2B4_1B10_Ref = object {
  _Leaf1B4_1B5_2B4_1B10
  scale 0.7
  rotate <0.0, 69.719528, 74.364922>
  translate  <2.71753, 5.40018, 11.98438>
}
#declare _Leaf1B4_1B5_2B4_1B11_Ref = object {
  _Leaf1B4_1B5_2B4_1B11
  scale 0.7
  rotate <0.0, 35.628029, 34.950981>
  translate  <2.72247, 5.39378, 11.99026>
}
#declare _Leaf1B4_1B5_2B4_1B12_Ref = object {
  _Leaf1B4_1B5_2B4_1B12
  scale 0.7
  rotate <0.0, 52.42897, 319.961731>
  translate  <2.72946, 5.38778, 11.98637>
}
#declare _Leaf1B4_1B5_2B5_1B1_Ref = object {
  _Leaf1B4_1B5_2B5_1B1
  scale 0.7
  rotate <0.0, 69.563728, 66.680573>
  translate  <1.72264, 4.78165, 12.13193>
}
#declare _Leaf1B4_1B5_2B5_1B2_Ref = object {
  _Leaf1B4_1B5_2B5_1B2
  scale 0.7
  rotate <0.0, 84.75769, 108.486008>
  translate  <1.70739, 4.91992, 12.27774>
}
#declare _Leaf1B4_1B5_2B5_1B3_Ref = object {
  _Leaf1B4_1B5_2B5_1B3
  scale 0.7
  rotate <0.0, 62.9487, 346.728851>
  translate  <1.73446, 4.96038, 12.37615>
}
#declare _Leaf1B4_1B5_2B5_1B4_Ref = object {
  _Leaf1B4_1B5_2B5_1B4
  scale 0.7
  rotate <0.0, 136.306274, 341.192505>
  translate  <1.74558, 4.97365, 12.36257>
}
#declare _Leaf1B4_1B5_2B5_1B5_Ref = object {
  _Leaf1B4_1B5_2B5_1B5
  scale 0.7
  rotate <0.0, 88.335983, 177.844315>
  translate  <1.70766, 5.04475, 12.43556>
}
#declare _Leaf1B4_1B5_2B5_1B6_Ref = object {
  _Leaf1B4_1B5_2B5_1B6
  scale 0.7
  rotate <0.0, 26.70883, 202.875015>
  translate  <1.73399, 5.24243, 12.66048>
}
#declare _Leaf1B4_1B5_2B5_1B7_Ref = object {
  _Leaf1B4_1B5_2B5_1B7
  scale 0.7
  rotate <0.0, 113.979622, 126.850647>
  translate  <1.73955, 5.33181, 12.71292>
}
#declare _Leaf1B4_1B5_2B5_1B8_Ref = object {
  _Leaf1B4_1B5_2B5_1B8
  scale 0.7
  rotate <0.0, 129.110992, 89.19767>
  translate  <1.75661, 5.47008, 12.85661>
}
#declare _Leaf1B4_1B5_2B5_1B9_Ref = object {
  _Leaf1B4_1B5_2B5_1B9
  scale 0.7
  rotate <0.0, 47.17173, 248.810486>
  translate  <1.74552, 5.45685, 12.87015>
}
#declare _Leaf1B4_1B5_2B5_1B10_Ref = object {
  _Leaf1B4_1B5_2B5_1B10
  scale 0.7
  rotate <0.0, 14.22632, 81.264549>
  translate  <1.76586, 5.59281, 13.01588>
}
#declare _Leaf1B4_1B5_2B5_1B11_Ref = object {
  _Leaf1B4_1B5_2B5_1B11
  scale 0.7
  rotate <0.0, 52.058369, 25.086281>
  translate  <1.77454, 5.59608, 13.01215>
}
#declare _Leaf1B4_1B5_2B5_1B12_Ref = object {
  _Leaf1B4_1B5_2B5_1B12
  scale 0.7
  rotate <0.0, 104.057571, 27.11783>
  translate  <1.77461, 5.60326, 13.00519>
}
#declare _Leaf1B4_1B5_1B1_1B1_Ref = object {
  _Leaf1B4_1B5_1B1_1B1
  scale 0.7
  rotate <0.0, 103.494408, 85.290993>
  translate  <1.37947, 2.74426, 9.55091>
}
#declare _Leaf1B4_1B5_1B1_1B2_Ref = object {
  _Leaf1B4_1B5_1B1_1B2
  scale 0.7
  rotate <0.0, 125.143509, 127.047821>
  translate  <1.29411, 2.92567, 9.57128>
}
#declare _Leaf1B4_1B5_1B1_1B3_Ref = object {
  _Leaf1B4_1B5_1B1_1B3
  scale 0.7
  rotate <0.0, 53.63179, 29.72748>
  translate  <1.28078, 3.02117, 9.6238>
}
#declare _Leaf1B4_1B5_1B1_1B4_Ref = object {
  _Leaf1B4_1B5_1B1_1B4
  scale 0.7
  rotate <0.0, 108.517281, 337.896362>
  translate  <1.29306, 3.02714, 9.60656>
}
#declare _Leaf1B4_1B5_1B1_1B5_Ref = object {
  _Leaf1B4_1B5_1B1_1B5
  scale 0.7
  rotate <0.0, 97.909332, 197.248672>
  translate  <1.2218, 3.10911, 9.61143>
}
#declare _Leaf1B4_1B5_1B1_1B6_Ref = object {
  _Leaf1B4_1B5_1B1_1B6
  scale 0.7
  rotate <0.0, 42.892811, 159.607086>
  translate  <1.13934, 3.39414, 9.65958>
}
#declare _Leaf1B4_1B5_1B1_1B7_Ref = object {
  _Leaf1B4_1B5_1B1_1B7
  scale 0.7
  rotate <0.0, 148.072968, 165.671188>
  translate  <1.11179, 3.49283, 9.64313>
}
#declare _Leaf1B4_1B5_1B1_1B8_Ref = object {
  _Leaf1B4_1B5_1B1_1B8
  scale 0.7
  rotate <0.0, 166.294525, 72.521683>
  translate  <1.05718, 3.68398, 9.66629>
}
#declare _Leaf1B4_1B5_1B1_1B9_Ref = object {
  _Leaf1B4_1B5_1B1_1B9
  scale 0.7
  rotate <0.0, 23.72687, 212.345917>
  translate  <1.04493, 3.67802, 9.68348>
}
#declare _Leaf1B4_1B5_1B1_1B10_Ref = object {
  _Leaf1B4_1B5_1B1_1B10
  scale 0.7
  rotate <0.0, 54.16951, 113.005699>
  translate  <0.99314, 3.86971, 9.7101>
}
#declare _Leaf1B4_1B5_1B1_1B11_Ref = object {
  _Leaf1B4_1B5_1B1_1B11
  scale 0.7
  rotate <0.0, 69.50174, 64.072212>
  translate  <1.00183, 3.87297, 9.70637>
}
#declare _Leaf1B4_1B5_1B1_1B12_Ref = object {
  _Leaf1B4_1B5_1B1_1B12
  scale 0.7
  rotate <0.0, 110.415123, 31.20595>
  translate  <1.00281, 3.87441, 9.69652>
}
#declare _Leaf1B4_1B5_1B2_1B1_Ref = object {
  _Leaf1B4_1B5_1B2_1B1
  scale 0.7
  rotate <0.0, 54.587479, 349.142242>
  translate  <1.76152, 2.84529, 10.0662>
}
#declare _Leaf1B4_1B5_1B2_1B2_Ref = object {
  _Leaf1B4_1B5_1B2_1B2
  scale 0.7
  rotate <0.0, 97.783707, 352.676239>
  translate  <1.93275, 2.92658, 10.13466>
}
#declare _Leaf1B4_1B5_1B2_1B3_Ref = object {
  _Leaf1B4_1B5_1B2_1B3
  scale 0.7
  rotate <0.0, 17.920019, 159.121765>
  translate  <1.98972, 2.98496, 10.20816>
}
#declare _Leaf1B4_1B5_1B2_1B4_Ref = object {
  _Leaf1B4_1B5_1B2_1B4
  scale 0.7
  rotate <0.0, 77.319206, 234.720673>
  translate  <1.99567, 2.96437, 10.21311>
}
#declare _Leaf1B4_1B5_1B2_1B5_Ref = object {
  _Leaf1B4_1B5_1B2_1B5
  scale 0.7
  rotate <0.0, 149.637146, 54.47184>
  translate  <2.09075, 3.01652, 10.2209>
}
#declare _Leaf1B4_1B5_1B2_1B6_Ref = object {
  _Leaf1B4_1B5_1B2_1B6
  scale 0.7
  rotate <0.0, 88.405533, 79.716667>
  translate  <2.32782, 3.12741, 10.36876>
}
#declare _Leaf1B4_1B5_1B2_1B7_Ref = object {
  _Leaf1B4_1B5_1B2_1B7
  scale 0.7
  rotate <0.0, 126.3032, 331.832092>
  translate  <2.42353, 3.13836, 10.40734>
}
#declare _Leaf1B4_1B5_1B2_1B8_Ref = object {
  _Leaf1B4_1B5_1B2_1B8
  scale 0.7
  rotate <0.0, 101.430557, 304.281647>
  translate  <2.58607, 3.20492, 10.50329>
}
#declare _Leaf1B4_1B5_1B2_1B9_Ref = object {
  _Leaf1B4_1B5_1B2_1B9
  scale 0.7
  rotate <0.0, 89.626091, 112.925858>
  translate  <2.58014, 3.22545, 10.49835>
}
#declare _Leaf1B4_1B5_1B2_1B10_Ref = object {
  _Leaf1B4_1B5_1B2_1B10
  scale 0.7
  rotate <0.0, 59.65593, 56.69305>
  translate  <2.74025, 3.29323, 10.59788>
}
#declare _Leaf1B4_1B5_1B2_1B11_Ref = object {
  _Leaf1B4_1B5_1B2_1B11
  scale 0.7
  rotate <0.0, 18.51811, 21.80946>
  translate  <2.74011, 3.28545, 10.60416>
}
#declare _Leaf1B4_1B5_1B2_1B12_Ref = object {
  _Leaf1B4_1B5_1B2_1B12
  scale 0.7
  rotate <0.0, 45.880138, 280.44574>
  translate  <2.74493, 3.27702, 10.60178>
}
#declare _Leaf1B4_1B5_1B3_1B1_Ref = object {
  _Leaf1B4_1B5_1B3_1B1
  scale 0.7
  rotate <0.0, 48.834702, 180.503357>
  translate  <1.40399, 2.86316, 10.35525>
}
#declare _Leaf1B4_1B5_1B3_1B2_Ref = object {
  _Leaf1B4_1B5_1B3_1B2
  scale 0.7
  rotate <0.0, 59.441292, 233.205154>
  translate  <1.35372, 2.82638, 10.54691>
}
#declare _Leaf1B4_1B5_1B3_1B3_Ref = object {
  _Leaf1B4_1B5_1B3_1B3
  scale 0.7
  rotate <0.0, 74.724983, 100.895042>
  translate  <1.33929, 2.85793, 10.65108>
}
#declare _Leaf1B4_1B5_1B3_1B4_Ref = object {
  _Leaf1B4_1B5_1B3_1B4
  scale 0.7
  rotate <0.0, 142.294678, 134.399429>
  translate  <1.31858, 2.85676, 10.64378>
}
#declare _Leaf1B4_1B5_1B3_1B5_Ref = object {
  _Leaf1B4_1B5_1B3_1B5
  scale 0.7
  rotate <0.0, 83.689812, 302.852844>
  translate  <1.3089, 2.81242, 10.74257>
}
#declare _Leaf1B4_1B5_1B3_1B6_Ref = object {
  _Leaf1B4_1B5_1B3_1B6
  scale 0.7
  rotate <0.0, 40.709839, 0.20824>
  translate  <1.21542, 2.80441, 11.02816>
}
#declare _Leaf1B4_1B5_1B3_1B7_Ref = object {
  _Leaf1B4_1B5_1B3_1B7
  scale 0.7
  rotate <0.0, 90.902573, 247.483383>
  translate  <1.16087, 2.78119, 11.11333>
}
#declare _Leaf1B4_1B5_1B3_1B8_Ref = object {
  _Leaf1B4_1B5_1B3_1B8
  scale 0.7
  rotate <0.0, 103.68737, 214.396057>
  translate  <1.09185, 2.7705, 11.30089>
}
#declare _Leaf1B4_1B5_1B3_1B9_Ref = object {
  _Leaf1B4_1B5_1B3_1B9
  scale 0.7
  rotate <0.0, 70.280922, 19.1443>
  translate  <1.11251, 2.77166, 11.30818>
}
#declare _Leaf1B4_1B5_1B3_1B10_Ref = object {
  _Leaf1B4_1B5_1B3_1B10
  scale 0.7
  rotate <0.0, 12.85944, 61.825851>
  translate  <1.04408, 2.76538, 11.49636>
}
#declare _Leaf1B4_1B5_1B3_1B11_Ref = object {
  _Leaf1B4_1B5_1B3_1B11
  scale 0.7
  rotate <0.0, 49.541031, 126.943527>
  translate  <1.03553, 2.7699, 11.4938>
}
#declare _Leaf1B4_1B5_1B3_1B12_Ref = object {
  _Leaf1B4_1B5_1B3_1B12
  scale 0.7
  rotate <0.0, 95.038528, 154.461655>
  translate  <1.02777, 2.76446, 11.49061>
}
#declare _Leaf1B4_1B6_2B1_1B1_Ref = object {
  _Leaf1B4_1B6_2B1_1B1
  scale 0.7
  rotate <0.0, 61.64798, 294.550812>
  translate  <1.96347, 2.00754, 11.63521>
}
#declare _Leaf1B4_1B6_2B1_1B2_Ref = object {
  _Leaf1B4_1B6_2B1_1B2
  scale 0.7
  rotate <0.0, 95.807831, 322.202179>
  translate  <2.11455, 1.93939, 11.74985>
}
#declare _Leaf1B4_1B6_2B1_1B3_Ref = object {
  _Leaf1B4_1B6_2B1_1B3
  scale 0.7
  rotate <0.0, 32.8787, 193.152634>
  translate  <2.1608, 1.91942, 11.84741>
}
#declare _Leaf1B4_1B6_2B1_1B4_Ref = object {
  _Leaf1B4_1B6_2B1_1B4
  scale 0.7
  rotate <0.0, 106.194443, 199.861359>
  translate  <2.15431, 1.89932, 11.84126>
}
#declare _Leaf1B4_1B6_2B1_1B5_Ref = object {
  _Leaf1B4_1B6_2B1_1B5
  scale 0.7
  rotate <0.0, 119.354179, 31.68298>
  translate  <2.25245, 1.87822, 11.88301>
}
#declare _Leaf1B4_1B6_2B1_1B6_Ref = object {
  _Leaf1B4_1B6_2B1_1B6
  scale 0.7
  rotate <0.0, 56.260471, 45.01038>
  translate  <2.44153, 1.76207, 12.08579>
}
#declare _Leaf1B4_1B6_2B1_1B7_Ref = object {
  _Leaf1B4_1B6_2B1_1B7
  scale 0.7
  rotate <0.0, 130.058685, 323.465393>
  translate  <2.50996, 1.69922, 12.132>
}
#declare _Leaf1B4_1B6_2B1_1B8_Ref = object {
  _Leaf1B4_1B6_2B1_1B8
  scale 0.7
  rotate <0.0, 123.291107, 280.009613>
  translate  <2.63721, 1.61492, 12.26146>
}
#declare _Leaf1B4_1B6_2B1_1B9_Ref = object {
  _Leaf1B4_1B6_2B1_1B9
  scale 0.7
  rotate <0.0, 62.72274, 83.066841>
  translate  <2.64368, 1.63497, 12.26759>
}
#declare _Leaf1B4_1B6_2B1_1B10_Ref = object {
  _Leaf1B4_1B6_2B1_1B10
  scale 0.7
  rotate <0.0, 32.263809, 4.66987>
  translate  <2.76822, 1.55157, 12.40052>
}
#declare _Leaf1B4_1B6_2B1_1B11_Ref = object {
  _Leaf1B4_1B6_2B1_1B11
  scale 0.7
  rotate <0.0, 27.277731, 263.430176>
  translate  <2.76224, 1.54365, 12.40173>
}
#declare _Leaf1B4_1B6_2B1_1B12_Ref = object {
  _Leaf1B4_1B6_2B1_1B12
  scale 0.7
  rotate <0.0, 76.785759, 240.867462>
  translate  <2.76311, 1.53575, 12.39567>
}
#declare _Leaf1B4_1B6_2B2_1B1_Ref = object {
  _Leaf1B4_1B6_2B2_1B1
  scale 0.7
  rotate <0.0, 58.055149, 199.583115>
  translate  <1.66081, 2.02955, 12.06227>
}
#declare _Leaf1B4_1B6_2B2_1B2_Ref = object {
  _Leaf1B4_1B6_2B2_1B2
  scale 0.7
  rotate <0.0, 88.013588, 232.842056>
  translate  <1.59336, 1.89999, 12.20112>
}
#declare _Leaf1B4_1B6_2B2_1B3_Ref = object {
  _Leaf1B4_1B6_2B2_1B3
  scale 0.7
  rotate <0.0, 42.63324, 101.09256>
  translate  <1.57338, 1.87113, 12.30515>
}
#declare _Leaf1B4_1B6_2B2_1B4_Ref = object {
  _Leaf1B4_1B6_2B2_1B4
  scale 0.7
  rotate <0.0, 115.551514, 111.579948>
  translate  <1.55325, 1.8763, 12.29793>
}
#declare _Leaf1B4_1B6_2B2_1B5_Ref = object {
  _Leaf1B4_1B6_2B2_1B5
  scale 0.7
  rotate <0.0, 110.721184, 299.803345>
  translate  <1.53272, 1.78667, 12.35594>
}
#declare _Leaf1B4_1B6_2B2_1B6_Ref = object {
  _Leaf1B4_1B6_2B2_1B6
  scale 0.7
  rotate <0.0, 49.469608, 320.967957>
  translate  <1.41724, 1.63453, 12.58806>
}
#declare _Leaf1B4_1B6_2B2_1B7_Ref = object {
  _Leaf1B4_1B6_2B2_1B7
  scale 0.7
  rotate <0.0, 121.922623, 238.06958>
  translate  <1.35472, 1.57462, 12.64524>
}
#declare _Leaf1B4_1B6_2B2_1B8_Ref = object {
  _Leaf1B4_1B6_2B2_1B8
  scale 0.7
  rotate <0.0, 121.157761, 196.581619>
  translate  <1.27089, 1.47096, 12.79454>
}
#declare _Leaf1B4_1B6_2B2_1B9_Ref = object {
  _Leaf1B4_1B6_2B2_1B9
  scale 0.7
  rotate <0.0, 61.8433, 358.716858>
  translate  <1.29096, 1.4658, 12.80174>
}
#declare _Leaf1B4_1B6_2B2_1B10_Ref = object {
  _Leaf1B4_1B6_2B2_1B10
  scale 0.7
  rotate <0.0, 22.35688, 276.695374>
  translate  <1.20801, 1.36543, 12.95398>
}
#declare _Leaf1B4_1B6_2B2_1B11_Ref = object {
  _Leaf1B4_1B6_2B2_1B11
  scale 0.7
  rotate <0.0, 30.071779, 156.288437>
  translate  <1.20004, 1.37148, 12.95413>
}
#declare _Leaf1B4_1B6_2B2_1B12_Ref = object {
  _Leaf1B4_1B6_2B2_1B12
  scale 0.7
  rotate <0.0, 81.866386, 149.685287>
  translate  <1.19216, 1.36951, 12.9483>
}
#declare _Leaf1B4_1B6_2B3_1B1_Ref = object {
  _Leaf1B4_1B6_2B3_1B1
  scale 0.7
  rotate <0.0, 70.832558, 22.43574>
  translate  <2.03289, 2.43235, 12.59916>
}
#declare _Leaf1B4_1B6_2B3_1B2_Ref = object {
  _Leaf1B4_1B6_2B3_1B2
  scale 0.7
  rotate <0.0, 101.985313, 52.992161>
  translate  <2.1209, 2.58316, 12.69978>
}
#declare _Leaf1B4_1B6_2B3_1B3_Ref = object {
  _Leaf1B4_1B6_2B3_1B3
  scale 0.7
  rotate <0.0, 36.122742, 296.472137>
  translate  <2.15774, 2.62946, 12.79227>
}
#declare _Leaf1B4_1B6_2B3_1B4_Ref = object {
  _Leaf1B4_1B6_2B3_1B4
  scale 0.7
  rotate <0.0, 109.137909, 286.39566>
  translate  <2.17643, 2.6228, 12.78276>
}
#declare _Leaf1B4_1B6_2B3_1B5_Ref = object {
  _Leaf1B4_1B6_2B3_1B5
  scale 0.7
  rotate <0.0, 113.982208, 125.46582>
  translate  <2.20514, 2.72087, 12.8199>
}
#declare _Leaf1B4_1B6_2B3_1B6_Ref = object {
  _Leaf1B4_1B6_2B3_1B6
  scale 0.7
  rotate <0.0, 49.721008, 128.906555>
  translate  <2.3559, 2.90949, 12.99893>
}
#declare _Leaf1B4_1B6_2B3_1B7_Ref = object {
  _Leaf1B4_1B6_2B3_1B7
  scale 0.7
  rotate <0.0, 135.61908, 60.710602>
  translate  <2.42629, 2.97753, 13.03335>
}
#declare _Leaf1B4_1B6_2B3_1B8_Ref = object {
  _Leaf1B4_1B6_2B3_1B8
  scale 0.7
  rotate <0.0, 133.0961, 10.86885>
  translate  <2.53258, 3.10441, 13.14587>
}
#declare _Leaf1B4_1B6_2B3_1B9_Ref = object {
  _Leaf1B4_1B6_2B3_1B9
  scale 0.7
  rotate <0.0, 52.89307, 171.699066>
  translate  <2.51394, 3.11105, 13.15535>
}
#declare _Leaf1B4_1B6_2B3_1B10_Ref = object {
  _Leaf1B4_1B6_2B3_1B10
  scale 0.7
  rotate <0.0, 33.01403, 78.674072>
  translate  <2.61993, 3.23523, 13.27145>
}
#declare _Leaf1B4_1B6_2B3_1B11_Ref = object {
  _Leaf1B4_1B6_2B3_1B11
  scale 0.7
  rotate <0.0, 37.14917, 354.869629>
  translate  <2.6279, 3.22919, 13.27131>
}
#declare _Leaf1B4_1B6_2B3_1B12_Ref = object {
  _Leaf1B4_1B6_2B3_1B12
  scale 0.7
  rotate <0.0, 85.407173, 331.212616>
  translate  <2.63465, 3.22999, 13.26397>
}
#declare _Leaf1B4_1B6_2B4_1B1_Ref = object {
  _Leaf1B4_1B6_2B4_1B1
  scale 0.7
  rotate <0.0, 67.50856, 108.427849>
  translate  <1.7132, 2.43675, 12.82772>
}
#declare _Leaf1B4_1B6_2B4_1B2_Ref = object {
  _Leaf1B4_1B6_2B4_1B2
  scale 0.7
  rotate <0.0, 94.117729, 143.421753>
  translate  <1.58266, 2.52615, 12.95255>
}
#declare _Leaf1B4_1B6_2B4_1B3_Ref = object {
  _Leaf1B4_1B6_2B4_1B3
  scale 0.7
  rotate <0.0, 45.280338, 21.504181>
  translate  <1.55329, 2.56355, 13.05151>
}
#declare _Leaf1B4_1B6_2B4_1B4_Ref = object {
  _Leaf1B4_1B6_2B4_1B4
  scale 0.7
  rotate <0.0, 118.702873, 17.16827>
  translate  <1.55834, 2.58217, 13.04094>
}
#declare _Leaf1B4_1B6_2B4_1B5_Ref = object {
  _Leaf1B4_1B6_2B4_1B5
  scale 0.7
  rotate <0.0, 105.668228, 213.059448>
  translate  <1.46837, 2.61172, 13.09434>
}
#declare _Leaf1B4_1B6_2B4_1B6_Ref = object {
  _Leaf1B4_1B6_2B4_1B6
  scale 0.7
  rotate <0.0, 42.188179, 224.786484>
  translate  <1.31458, 2.76434, 13.3027>
}
#declare _Leaf1B4_1B6_2B4_1B7_Ref = object {
  _Leaf1B4_1B6_2B4_1B7
  scale 0.7
  rotate <0.0, 126.863251, 154.430573>
  translate  <1.25401, 2.83532, 13.3481>
}
#declare _Leaf1B4_1B6_2B4_1B8_Ref = object {
  _Leaf1B4_1B6_2B4_1B8
  scale 0.7
  rotate <0.0, 130.671936, 109.112709>
  translate  <1.14923, 2.94285, 13.48046>
}
#declare _Leaf1B4_1B6_2B4_1B9_Ref = object {
  _Leaf1B4_1B6_2B4_1B9
  scale 0.7
  rotate <0.0, 51.91045, 268.907623>
  translate  <1.14419, 2.92428, 13.49101>
}
#declare _Leaf1B4_1B6_2B4_1B10_Ref = object {
  _Leaf1B4_1B6_2B4_1B10
  scale 0.7
  rotate <0.0, 23.397699, 163.46875>
  translate  <1.04268, 3.03148, 13.62642>
}
#declare _Leaf1B4_1B6_2B4_1B11_Ref = object {
  _Leaf1B4_1B6_2B4_1B11
  scale 0.7
  rotate <0.0, 39.315498, 72.063171>
  translate  <1.04867, 3.0394, 13.62521>
}
#declare _Leaf1B4_1B6_2B4_1B12_Ref = object {
  _Leaf1B4_1B6_2B4_1B12
  scale 0.7
  rotate <0.0, 90.403183, 60.464039>
  translate  <1.04666, 3.04614, 13.6181>
}
#declare _Leaf1B4_1B6_2B5_1B1_Ref = object {
  _Leaf1B4_1B6_2B5_1B1
  scale 0.7
  rotate <0.0, 27.591459, 149.786392>
  translate  <1.89926, 2.31502, 13.24284>
}
#declare _Leaf1B4_1B6_2B5_1B2_Ref = object {
  _Leaf1B4_1B6_2B5_1B2
  scale 0.7
  rotate <0.0, 38.021339, 233.893723>
  translate  <1.92805, 2.31084, 13.44226>
}
#declare _Leaf1B4_1B6_2B5_1B3_Ref = object {
  _Leaf1B4_1B6_2B5_1B3
  scale 0.7
  rotate <0.0, 82.508911, 84.07119>
  translate  <1.9637, 2.35555, 13.53599>
}
#declare _Leaf1B4_1B6_2B5_1B4_Ref = object {
  _Leaf1B4_1B6_2B5_1B4
  scale 0.7
  rotate <0.0, 129.163712, 145.651062>
  translate  <1.94194, 2.35835, 13.53761>
}
#declare _Leaf1B4_1B6_2B5_1B5_Ref = object {
  _Leaf1B4_1B6_2B5_1B5
  scale 0.7
  rotate <0.0, 87.246498, 293.020203>
  translate  <1.96712, 2.32793, 13.63891>
}
#declare _Leaf1B4_1B6_2B5_1B6_Ref = object {
  _Leaf1B4_1B6_2B5_1B6
  scale 0.7
  rotate <0.0, 64.373268, 355.77887>
  translate  <2.00109, 2.37122, 13.93443>
}
#declare _Leaf1B4_1B6_2B5_1B7_Ref = object {
  _Leaf1B4_1B6_2B5_1B7
  scale 0.7
  rotate <0.0, 72.118736, 238.244827>
  translate  <1.98394, 2.37001, 14.03677>
}
#declare _Leaf1B4_1B6_2B5_1B8_Ref = object {
  _Leaf1B4_1B6_2B5_1B8
  scale 0.7
  rotate <0.0, 78.534683, 202.461304>
  translate  <1.99855, 2.39491, 14.23482>
}
#declare _Leaf1B4_1B6_2B5_1B9_Ref = object {
  _Leaf1B4_1B6_2B5_1B9
  scale 0.7
  rotate <0.0, 95.533669, 7.6538>
  translate  <2.02025, 2.39211, 14.23321>
}
#declare _Leaf1B4_1B6_2B5_1B10_Ref = object {
  _Leaf1B4_1B6_2B5_1B10
  scale 0.7
  rotate <0.0, 36.56813, 26.737579>
  translate  <2.03636, 2.42121, 14.43076>
}
#declare _Leaf1B4_1B6_2B5_1B11_Ref = object {
  _Leaf1B4_1B6_2B5_1B11
  scale 0.7
  rotate <0.0, 49.583271, 92.921402>
  translate  <2.02839, 2.42726, 14.43091>
}
#declare _Leaf1B4_1B6_2B5_1B12_Ref = object {
  _Leaf1B4_1B6_2B5_1B12
  scale 0.7
  rotate <0.0, 79.23011, 141.580734>
  translate  <2.01923, 2.42342, 14.43204>
}
#declare _Leaf1B4_1B6_1B1_1B1_Ref = object {
  _Leaf1B4_1B6_1B1_1B1
  scale 0.7
  rotate <0.0, 53.099369, 197.349823>
  translate  <1.39063, 1.72302, 10.03018>
}
#declare _Leaf1B4_1B6_1B1_1B2_Ref = object {
  _Leaf1B4_1B6_1B1_1B2
  scale 0.7
  rotate <0.0, 82.014236, 232.931305>
  translate  <1.33261, 1.60555, 10.18331>
}
#declare _Leaf1B4_1B6_1B1_1B3_Ref = object {
  _Leaf1B4_1B6_1B1_1B3
  scale 0.7
  rotate <0.0, 46.795399, 96.80719>
  translate  <1.31936, 1.58548, 10.29044>
}
#declare _Leaf1B4_1B6_1B1_1B4_Ref = object {
  _Leaf1B4_1B6_1B1_1B4
  scale 0.7
  rotate <0.0, 118.541237, 114.32753>
  translate  <1.29879, 1.59005, 10.2841>
}
#declare _Leaf1B4_1B6_1B1_1B5_Ref = object {
  _Leaf1B4_1B6_1B1_1B5
  scale 0.7
  rotate <0.0, 108.284828, 297.947968>
  translate  <1.28233, 1.50559, 10.35055>
}
#declare _Leaf1B4_1B6_1B1_1B6_Ref = object {
  _Leaf1B4_1B6_1B1_1B6
  scale 0.7
  rotate <0.0, 49.549709, 326.184662>
  translate  <1.18237, 1.37345, 10.60136>
}
#declare _Leaf1B4_1B6_1B1_1B7_Ref = object {
  _Leaf1B4_1B6_1B1_1B7
  scale 0.7
  rotate <0.0, 115.947449, 237.860046>
  translate  <1.12384, 1.31857, 10.66717>
}
#declare _Leaf1B4_1B6_1B1_1B8_Ref = object {
  _Leaf1B4_1B6_1B1_1B8
  scale 0.7
  rotate <0.0, 116.255562, 198.567642>
  translate  <1.05003, 1.22781, 10.82957>
}
#declare _Leaf1B4_1B6_1B1_1B9_Ref = object {
  _Leaf1B4_1B6_1B1_1B9
  scale 0.7
  rotate <0.0, 65.46785, 1.17623>
  translate  <1.07054, 1.22325, 10.83589>
}
#declare _Leaf1B4_1B6_1B1_1B10_Ref = object {
  _Leaf1B4_1B6_1B1_1B10
  scale 0.7
  rotate <0.0, 18.486139, 289.186005>
  translate  <0.99778, 1.136, 11.0009>
}
#declare _Leaf1B4_1B6_1B1_1B11_Ref = object {
  _Leaf1B4_1B6_1B1_1B11
  scale 0.7
  rotate <0.0, 29.202311, 145.918274>
  translate  <0.98981, 1.14204, 11.00105>
}
#declare _Leaf1B4_1B6_1B1_1B12_Ref = object {
  _Leaf1B4_1B6_1B1_1B12
  scale 0.7
  rotate <0.0, 81.189484, 148.885117>
  translate  <0.98159, 1.1396, 10.99591>
}
#declare _Leaf1B4_1B6_1B2_1B1_Ref = object {
  _Leaf1B4_1B6_1B2_1B1
  scale 0.7
  rotate <0.0, 75.586777, 78.850403>
  translate  <1.54777, 2.20566, 10.43523>
}
#declare _Leaf1B4_1B6_1B2_1B2_Ref = object {
  _Leaf1B4_1B6_1B2_1B2
  scale 0.7
  rotate <0.0, 100.609528, 114.526802>
  translate  <1.48172, 2.36371, 10.5414>
}
#declare _Leaf1B4_1B6_1B2_1B3_Ref = object {
  _Leaf1B4_1B6_1B2_1B3
  scale 0.7
  rotate <0.0, 46.444069, 359.764099>
  translate  <1.47747, 2.42388, 10.63314>
}
#declare _Leaf1B4_1B6_1B2_1B4_Ref = object {
  _Leaf1B4_1B6_1B2_1B4
  scale 0.7
  rotate <0.0, 118.395088, 343.248566>
  translate  <1.49069, 2.43599, 10.62037>
}
#declare _Leaf1B4_1B6_1B2_1B5_Ref = object {
  _Leaf1B4_1B6_1B2_1B5
  scale 0.7
  rotate <0.0, 103.313393, 185.542404>
  translate  <1.42844, 2.51283, 10.66555>
}
#declare _Leaf1B4_1B6_1B2_1B6_Ref = object {
  _Leaf1B4_1B6_1B2_1B6
  scale 0.7
  rotate <0.0, 38.978699, 186.581757>
  translate  <1.37568, 2.74816, 10.84498>
}
#declare _Leaf1B4_1B6_1B2_1B7_Ref = object {
  _Leaf1B4_1B6_1B2_1B7
  scale 0.7
  rotate <0.0, 132.085297, 130.007584>
  translate  <1.35913, 2.84518, 10.87788>
}
#declare _Leaf1B4_1B6_1B2_1B8_Ref = object {
  _Leaf1B4_1B6_1B2_1B8
  scale 0.7
  rotate <0.0, 138.746613, 79.890022>
  translate  <1.32463, 3.00725, 10.99014>
}
#declare _Leaf1B4_1B6_1B2_1B9_Ref = object {
  _Leaf1B4_1B6_1B2_1B9
  scale 0.7
  rotate <0.0, 44.288181, 236.971252>
  translate  <1.31145, 2.99518, 11.00287>
}
#declare _Leaf1B4_1B6_1B2_1B10_Ref = object {
  _Leaf1B4_1B6_1B2_1B10
  scale 0.7
  rotate <0.0, 28.632839, 121.227921>
  translate  <1.27974, 3.15579, 11.11833>
}
#declare _Leaf1B4_1B6_1B2_1B11_Ref = object {
  _Leaf1B4_1B6_1B2_1B11
  scale 0.7
  rotate <0.0, 46.123119, 47.283001>
  translate  <1.2888, 3.15951, 11.11631>
}
#declare _Leaf1B4_1B6_1B2_1B12_Ref = object {
  _Leaf1B4_1B6_1B2_1B12
  scale 0.7
  rotate <0.0, 95.934708, 30.61875>
  translate  <1.29014, 3.16532, 11.10829>
}
#declare _Leaf1B4_1B6_1B3_1B1_Ref = object {
  _Leaf1B4_1B6_1B3_1B1
  scale 0.7
  rotate <0.0, 65.588577, 327.368408>
  translate  <1.88296, 1.96006, 10.63277>
}
#declare _Leaf1B4_1B6_1B3_1B2_Ref = object {
  _Leaf1B4_1B6_1B3_1B2
  scale 0.7
  rotate <0.0, 102.096802, 351.259949>
  translate  <2.06033, 1.98114, 10.72609>
}
#declare _Leaf1B4_1B6_1B3_1B3_Ref = object {
  _Leaf1B4_1B6_1B3_1B3
  scale 0.7
  rotate <0.0, 25.949169, 227.657043>
  translate  <2.12157, 1.99163, 10.81662>
}
#declare _Leaf1B4_1B6_1B3_1B4_Ref = object {
  _Leaf1B4_1B6_1B3_1B4
  scale 0.7
  rotate <0.0, 99.472992, 228.819473>
  translate  <2.12519, 1.97065, 10.81109>
}
#declare _Leaf1B4_1B6_1B3_1B5_Ref = object {
  _Leaf1B4_1B6_1B3_1B5
  scale 0.7
  rotate <0.0, 125.137207, 64.323158>
  translate  <2.22508, 2.00276, 10.83958>
}
#declare _Leaf1B4_1B6_1B3_1B6_Ref = object {
  _Leaf1B4_1B6_1B3_1B6
  scale 0.7
  rotate <0.0, 61.130741, 71.269722>
  translate  <2.46932, 2.00542, 11.01479>
}
#declare _Leaf1B4_1B6_1B3_1B7_Ref = object {
  _Leaf1B4_1B6_1B3_1B7
  scale 0.7
  rotate <0.0, 136.329697, 349.384949>
  translate  <2.5648, 1.98687, 11.05097>
}
#declare _Leaf1B4_1B6_1B3_1B8_Ref = object {
  _Leaf1B4_1B6_1B3_1B8
  scale 0.7
  rotate <0.0, 125.016937, 304.778351>
  translate  <2.73138, 1.98296, 11.16185>
}
#declare _Leaf1B4_1B6_1B3_1B9_Ref = object {
  _Leaf1B4_1B6_1B3_1B9
  scale 0.7
  rotate <0.0, 63.111938, 108.948227>
  translate  <2.72777, 2.00389, 11.16736>
}
#declare _Leaf1B4_1B6_1B3_1B10_Ref = object {
  _Leaf1B4_1B6_1B3_1B10
  scale 0.7
  rotate <0.0, 39.594582, 32.631809>
  translate  <2.89197, 1.99961, 11.28204>
}
#declare _Leaf1B4_1B6_1B3_1B11_Ref = object {
  _Leaf1B4_1B6_1B3_1B11
  scale 0.7
  rotate <0.0, 28.105841, 307.24939>
  translate  <2.89088, 1.98985, 11.28391>
}
#declare _Leaf1B4_1B6_1B3_1B12_Ref = object {
  _Leaf1B4_1B6_1B3_1B12
  scale 0.7
  rotate <0.0, 73.949509, 272.348755>
  translate  <2.89483, 1.98309, 11.27769>
}
#declare _Leaf1B5_1B1_2B1_1B1_Ref = object {
  _Leaf1B5_1B1_2B1_1B1
  scale 0.7
  rotate <0.0, 97.983658, 175.865005>
  translate  <-2.26714, 2.96555, 8.73475>
}
#declare _Leaf1B5_1B1_2B1_1B2_Ref = object {
  _Leaf1B5_1B1_2B1_1B2
  scale 0.7
  rotate <0.0, 91.951607, 218.958038>
  translate  <-2.44723, 2.94679, 8.82325>
}
#declare _Leaf1B5_1B1_2B1_1B3_Ref = object {
  _Leaf1B5_1B1_2B1_1B3
  scale 0.7
  rotate <0.0, 89.903557, 103.780991>
  translate  <-2.53237, 2.98754, 8.87933>
}
#declare _Leaf1B5_1B1_2B1_1B4_Ref = object {
  _Leaf1B5_1B1_2B1_1B4
  scale 0.7
  rotate <0.0, 148.82663, 47.184101>
  translate  <-2.54052, 2.98635, 8.85893>
}
#declare _Leaf1B5_1B1_2B1_1B5_Ref = object {
  _Leaf1B5_1B1_2B1_1B5
  scale 0.7
  rotate <0.0, 59.450489, 283.43399>
  translate  <-2.62486, 2.95093, 8.9177>
}
#declare _Leaf1B5_1B1_2B1_1B6_Ref = object {
  _Leaf1B5_1B1_2B1_1B6
  scale 0.7
  rotate <0.0, 8.71561, 161.305405>
  translate  <-2.90143, 2.9701, 9.03389>
}
#declare _Leaf1B5_1B1_2B1_1B7_Ref = object {
  _Leaf1B5_1B1_2B1_1B7
  scale 0.7
  rotate <0.0, 105.548782, 250.876022>
  translate  <-3.00308, 2.95584, 9.0491>
}
#declare _Leaf1B5_1B1_2B1_1B8_Ref = object {
  _Leaf1B5_1B1_2B1_1B8
  scale 0.7
  rotate <0.0, 137.900787, 234.218475>
  translate  <-3.19017, 2.96324, 9.11984>
}
#declare _Leaf1B5_1B1_2B1_1B9_Ref = object {
  _Leaf1B5_1B1_2B1_1B9
  scale 0.7
  rotate <0.0, 28.07515, 41.33429>
  translate  <-3.18204, 2.96443, 9.14018>
}
#declare _Leaf1B5_1B1_2B1_1B10_Ref = object {
  _Leaf1B5_1B1_2B1_1B10
  scale 0.7
  rotate <0.0, 44.78331, 156.94339>
  translate  <-3.36883, 2.97626, 9.21162>
}
#declare _Leaf1B5_1B1_2B1_1B11_Ref = object {
  _Leaf1B5_1B1_2B1_1B11
  scale 0.7
  rotate <0.0, 86.71521, 137.511292>
  translate  <-3.37212, 2.98078, 9.20334>
}
#declare _Leaf1B5_1B1_2B1_1B12_Ref = object {
  _Leaf1B5_1B1_2B1_1B12
  scale 0.7
  rotate <0.0, 138.749329, 137.438843>
  translate  <-3.37524, 2.97532, 9.19556>
}
#declare _Leaf1B5_1B1_2B2_1B1_Ref = object {
  _Leaf1B5_1B1_2B2_1B1
  scale 0.7
  rotate <0.0, 113.699081, 94.156868>
  translate  <-2.31075, 3.486, 8.7759>
}
#declare _Leaf1B5_1B1_2B2_1B2_Ref = object {
  _Leaf1B5_1B1_2B2_1B2
  scale 0.7
  rotate <0.0, 150.975388, 126.33609>
  translate  <-2.43816, 3.62812, 8.71122>
}
#declare _Leaf1B5_1B1_2B2_1B3_Ref = object {
  _Leaf1B5_1B1_2B2_1B3
  scale 0.7
  rotate <0.0, 43.555592, 74.911659>
  translate  <-2.49998, 3.71743, 8.72726>
}
#declare _Leaf1B5_1B1_2B2_1B4_Ref = object {
  _Leaf1B5_1B1_2B2_1B4
  scale 0.7
  rotate <0.0, 78.213417, 356.499664>
  translate  <-2.48273, 3.72573, 8.71641>
}
#declare _Leaf1B5_1B1_2B2_1B5_Ref = object {
  _Leaf1B5_1B1_2B2_1B5
  scale 0.7
  rotate <0.0, 117.89402, 223.776474>
  translate  <-2.56518, 3.77834, 8.66891>
}
#declare _Leaf1B5_1B1_2B2_1B6_Ref = object {
  _Leaf1B5_1B1_2B2_1B6
  scale 0.7
  rotate <0.0, 73.166496, 175.999969>
  translate  <-2.7307, 4.02077, 8.60418>
}
#declare _Leaf1B5_1B1_2B2_1B7_Ref = object {
  _Leaf1B5_1B1_2B2_1B7
  scale 0.7
  rotate <0.0, 172.416794, 255.421036>
  translate  <-2.77062, 4.10216, 8.55368>
}
#declare _Leaf1B5_1B1_2B2_1B8_Ref = object {
  _Leaf1B5_1B1_2B2_1B8
  scale 0.7
  rotate <0.0, 149.38652, 17.2314>
  translate  <-2.87648, 4.26419, 8.50271>
}
#declare _Leaf1B5_1B1_2B2_1B9_Ref = object {
  _Leaf1B5_1B1_2B2_1B9
  scale 0.7
  rotate <0.0, 46.360748, 199.202118>
  translate  <-2.89368, 4.25591, 8.51353>
}
#declare _Leaf1B5_1B1_2B2_1B10_Ref = object {
  _Leaf1B5_1B1_2B2_1B10
  scale 0.7
  rotate <0.0, 79.547539, 139.380524>
  translate  <-2.99908, 4.41971, 8.46667>
}
#declare _Leaf1B5_1B1_2B2_1B11_Ref = object {
  _Leaf1B5_1B1_2B2_1B11
  scale 0.7
  rotate <0.0, 73.828651, 93.14904>
  translate  <-2.99087, 4.42542, 8.46652>
}
#declare _Leaf1B5_1B1_2B2_1B12_Ref = object {
  _Leaf1B5_1B1_2B2_1B12
  scale 0.7
  rotate <0.0, 93.574417, 44.44117>
  translate  <-2.9855, 4.42624, 8.45812>
}
#declare _Leaf1B5_1B1_2B3_1B1_Ref = object {
  _Leaf1B5_1B1_2B3_1B1
  scale 0.7
  rotate <0.0, 27.729099, 223.661346>
  translate  <-2.47069, 3.65601, 9.50696>
}
#declare _Leaf1B5_1B1_2B3_1B2_Ref = object {
  _Leaf1B5_1B1_2B3_1B2
  scale 0.7
  rotate <0.0, 39.021061, 305.855713>
  translate  <-2.45582, 3.67923, 9.70659>
}
#declare _Leaf1B5_1B1_2B3_1B3_Ref = object {
  _Leaf1B5_1B1_2B3_1B3
  scale 0.7
  rotate <0.0, 81.654419, 156.128677>
  translate  <-2.48637, 3.72561, 9.80131>
}
#declare _Leaf1B5_1B1_2B3_1B4_Ref = object {
  _Leaf1B5_1B1_2B3_1B4
  scale 0.7
  rotate <0.0, 129.205994, 216.82196>
  translate  <-2.49575, 3.70576, 9.80273>
}
#declare _Leaf1B5_1B1_2B3_1B5_Ref = object {
  _Leaf1B5_1B1_2B3_1B5
  scale 0.7
  rotate <0.0, 87.743721, 4.96751>
  translate  <-2.45803, 3.71886, 9.90386>
}
#declare _Leaf1B5_1B1_2B3_1B6_Ref = object {
  _Leaf1B5_1B1_2B3_1B6
  scale 0.7
  rotate <0.0, 63.832272, 67.35585>
  translate  <-2.48574, 3.76031, 10.20029>
}
#declare _Leaf1B5_1B1_2B3_1B7_Ref = object {
  _Leaf1B5_1B1_2B3_1B7
  scale 0.7
  rotate <0.0, 73.114182, 310.200562>
  translate  <-2.48887, 3.74216, 10.30242>
}
#declare _Leaf1B5_1B1_2B3_1B8_Ref = object {
  _Leaf1B5_1B1_2B3_1B8
  scale 0.7
  rotate <0.0, 79.397903, 274.544952>
  translate  <-2.50606, 3.76091, 10.50094>
}
#declare _Leaf1B5_1B1_2B3_1B9_Ref = object {
  _Leaf1B5_1B1_2B3_1B9
  scale 0.7
  rotate <0.0, 94.828293, 79.703308>
  translate  <-2.4967, 3.7807, 10.49952>
}
#declare _Leaf1B5_1B1_2B3_1B10_Ref = object {
  _Leaf1B5_1B1_2B3_1B10
  scale 0.7
  rotate <0.0, 35.67239, 98.113861>
  translate  <-2.51742, 3.80219, 10.69762>
}
#declare _Leaf1B5_1B1_2B3_1B11_Ref = object {
  _Leaf1B5_1B1_2B3_1B11
  scale 0.7
  rotate <0.0, 48.821579, 165.465775>
  translate  <-2.52563, 3.79648, 10.69777>
}
#declare _Leaf1B5_1B1_2B3_1B12_Ref = object {
  _Leaf1B5_1B1_2B3_1B12
  scale 0.7
  rotate <0.0, 79.210136, 213.756332>
  translate  <-2.52481, 3.78656, 10.69874>
}
#declare _Leaf1B5_1B1_2B4_1B1_Ref = object {
  _Leaf1B5_1B1_2B4_1B1
  scale 0.7
  rotate <0.0, 51.529259, 41.679581>
  translate  <-2.421, 4.03941, 9.43624>
}
#declare _Leaf1B5_1B1_2B4_1B2_Ref = object {
  _Leaf1B5_1B1_2B4_1B2
  scale 0.7
  rotate <0.0, 93.637367, 30.66148>
  translate  <-2.35347, 4.22351, 9.4827>
}
#declare _Leaf1B5_1B1_2B4_1B3_Ref = object {
  _Leaf1B5_1B1_2B4_1B3
  scale 0.7
  rotate <0.0, 29.75375, 169.023941>
  translate  <-2.36068, 4.31845, 9.53738>
}
#declare _Leaf1B5_1B1_2B4_1B4_Ref = object {
  _Leaf1B5_1B1_2B4_1B4
  scale 0.7
  rotate <0.0, 64.674431, 270.316528>
  translate  <-2.34467, 4.30809, 9.54835>
}
#declare _Leaf1B5_1B1_2B4_1B5_Ref = object {
  _Leaf1B5_1B1_2B4_1B5
  scale 0.7
  rotate <0.0, 159.512878, 63.30323>
  translate  <-2.30506, 4.40921, 9.5432>
}
#declare _Leaf1B5_1B1_2B4_1B6_Ref = object {
  _Leaf1B5_1B1_2B4_1B6
  scale 0.7
  rotate <0.0, 104.943169, 118.818642>
  translate  <-2.22172, 4.67392, 9.65872>
}
#declare _Leaf1B5_1B1_2B4_1B7_Ref = object {
  _Leaf1B5_1B1_2B4_1B7
  scale 0.7
  rotate <0.0, 115.640953, 3.2849>
  translate  <-2.16312, 4.75143, 9.69514>
}
#declare _Leaf1B5_1B1_2B4_1B8_Ref = object {
  _Leaf1B5_1B1_2B4_1B8
  scale 0.7
  rotate <0.0, 86.253036, 343.398254>
  translate  <-2.09909, 4.92481, 9.77195>
}
#declare _Leaf1B5_1B1_2B4_1B9_Ref = object {
  _Leaf1B5_1B1_2B4_1B9
  scale 0.7
  rotate <0.0, 106.044601, 153.317764>
  translate  <-2.11505, 4.93514, 9.761>
}
#declare _Leaf1B5_1B1_2B4_1B10_Ref = object {
  _Leaf1B5_1B1_2B4_1B10
  scale 0.7
  rotate <0.0, 73.50042, 100.857094>
  translate  <-2.05438, 5.10859, 9.8408>
}
#declare _Leaf1B5_1B1_2B4_1B11_Ref = object {
  _Leaf1B5_1B1_2B4_1B11
  scale 0.7
  rotate <0.0, 28.40369, 95.444969>
  translate  <-2.05109, 5.10407, 9.84908>
}
#declare _Leaf1B5_1B1_2B4_1B12_Ref = object {
  _Leaf1B5_1B1_2B4_1B12
  scale 0.7
  rotate <0.0, 28.75383, 322.47702>
  translate  <-2.04178, 5.10044, 9.84943>
}
#declare _Leaf1B5_1B1_2B5_1B1_Ref = object {
  _Leaf1B5_1B1_2B5_1B1
  scale 0.7
  rotate <0.0, 69.970787, 94.240433>
  translate  <-2.8043, 4.21821, 9.64329>
}
#declare _Leaf1B5_1B1_2B5_1B2_Ref = object {
  _Leaf1B5_1B1_2B5_1B2
  scale 0.7
  rotate <0.0, 100.98542, 124.976807>
  translate  <-2.91948, 4.34708, 9.74692>
}
#declare _Leaf1B5_1B1_2B5_1B3_Ref = object {
  _Leaf1B5_1B1_2B5_1B3
  scale 0.7
  rotate <0.0, 36.575989, 7.24619>
  translate  <-2.95119, 4.3951, 9.84043>
}
#declare _Leaf1B5_1B1_2B5_1B4_Ref = object {
  _Leaf1B5_1B1_2B5_1B4
  scale 0.7
  rotate <0.0, 109.729622, 358.665314>
  translate  <-2.93918, 4.41095, 9.83103>
}
#declare _Leaf1B5_1B1_2B5_1B5_Ref = object {
  _Leaf1B5_1B1_2B5_1B5
  scale 0.7
  rotate <0.0, 113.68045, 197.029984>
  translate  <-3.02318, 4.46804, 9.86983>
}
#declare _Leaf1B5_1B1_2B5_1B6_Ref = object {
  _Leaf1B5_1B1_2B5_1B6
  scale 0.7
  rotate <0.0, 49.487579, 201.719177>
  translate  <-3.15412, 4.66715, 10.05305>
}
#declare _Leaf1B5_1B1_2B5_1B7_Ref = object {
  _Leaf1B5_1B1_2B5_1B7
  scale 0.7
  rotate <0.0, 134.628494, 132.559174>
  translate  <-3.19671, 4.75462, 10.08915>
}
#declare _Leaf1B5_1B1_2B5_1B8_Ref = object {
  _Leaf1B5_1B1_2B5_1B8
  scale 0.7
  rotate <0.0, 132.348877, 83.467728>
  translate  <-3.28337, 4.89331, 10.20454>
}
#declare _Leaf1B5_1B1_2B5_1B9_Ref = object {
  _Leaf1B5_1B1_2B5_1B9
  scale 0.7
  rotate <0.0, 53.380981, 244.33876>
  translate  <-3.29535, 4.8775, 10.21391>
}
#declare _Leaf1B5_1B1_2B5_1B10_Ref = object {
  _Leaf1B5_1B1_2B5_1B10
  scale 0.7
  rotate <0.0, 32.116852, 151.35054>
  translate  <-3.37949, 5.01502, 10.33284>
}
#declare _Leaf1B5_1B1_2B5_1B11_Ref = object {
  _Leaf1B5_1B1_2B5_1B11
  scale 0.7
  rotate <0.0, 36.626968, 65.718628>
  translate  <-3.37129, 5.02072, 10.33269>
}
#declare _Leaf1B5_1B1_2B5_1B12_Ref = object {
  _Leaf1B5_1B1_2B5_1B12
  scale 0.7
  rotate <0.0, 85.261932, 43.117119>
  translate  <-3.37003, 5.0275, 10.32544>
}
#declare _Leaf1B5_1B1_1B1_1B1_Ref = object {
  _Leaf1B5_1B1_1B1_1B1
  scale 0.7
  rotate <0.0, 108.508263, 95.231232>
  translate  <-1.39851, 2.14084, 7.48954>
}
#declare _Leaf1B5_1B1_1B1_1B2_Ref = object {
  _Leaf1B5_1B1_1B1_1B2
  scale 0.7
  rotate <0.0, 144.977737, 126.018852>
  translate  <-1.52896, 2.28786, 7.44501>
}
#declare _Leaf1B5_1B1_1B1_1B3_Ref = object {
  _Leaf1B5_1B1_1B1_1B3
  scale 0.7
  rotate <0.0, 39.907421, 69.471458>
  translate  <-1.58935, 2.3754, 7.47231>
}
#declare _Leaf1B5_1B1_1B1_1B4_Ref = object {
  _Leaf1B5_1B1_1B1_1B4
  scale 0.7
  rotate <0.0, 81.972061, 355.593323>
  translate  <-1.57275, 2.38462, 7.4612>
}
#declare _Leaf1B5_1B1_1B1_1B5_Ref = object {
  _Leaf1B5_1B1_1B1_1B5
  scale 0.7
  rotate <0.0, 118.659111, 220.483688>
  translate  <-1.65766, 2.44102, 7.4234>
}
#declare _Leaf1B5_1B1_1B1_1B6_Ref = object {
  _Leaf1B5_1B1_1B1_1B6
  scale 0.7
  rotate <0.0, 69.465729, 177.510361>
  translate  <-1.82574, 2.68795, 7.38971>
}
#declare _Leaf1B5_1B1_1B1_1B7_Ref = object {
  _Leaf1B5_1B1_1B1_1B7
  scale 0.7
  rotate <0.0, 174.151382, 204.447906>
  translate  <-1.86827, 2.77334, 7.34885>
}
#declare _Leaf1B5_1B1_1B1_1B8_Ref = object {
  _Leaf1B5_1B1_1B1_1B8
  scale 0.7
  rotate <0.0, 150.694809, 27.32568>
  translate  <-1.97632, 2.93903, 7.31837>
}
#declare _Leaf1B5_1B1_1B1_1B9_Ref = object {
  _Leaf1B5_1B1_1B1_1B9
  scale 0.7
  rotate <0.0, 45.029202, 204.831253>
  translate  <-1.99287, 2.92984, 7.32946>
}
#declare _Leaf1B5_1B1_1B1_1B10_Ref = object {
  _Leaf1B5_1B1_1B1_1B10
  scale 0.7
  rotate <0.0, 73.744308, 139.653763>
  translate  <-2.1002, 3.09695, 7.30319>
}
#declare _Leaf1B5_1B1_1B1_1B11_Ref = object {
  _Leaf1B5_1B1_1B1_1B11
  scale 0.7
  rotate <0.0, 68.753319, 91.975281>
  translate  <-2.09199, 3.10265, 7.30304>
}
#declare _Leaf1B5_1B1_1B1_1B12_Ref = object {
  _Leaf1B5_1B1_1B1_1B12
  scale 0.7
  rotate <0.0, 92.558281, 44.669628>
  translate  <-2.08713, 3.1042, 7.29444>
}
#declare _Leaf1B5_1B1_1B2_1B1_Ref = object {
  _Leaf1B5_1B1_1B2_1B1
  scale 0.7
  rotate <0.0, 28.47583, 12.72102>
  translate  <-1.32985, 2.35996, 8.09696>
}
#declare _Leaf1B5_1B1_1B2_1B2_Ref = object {
  _Leaf1B5_1B1_1B2_1B2
  scale 0.7
  rotate <0.0, 71.778473, 10.76842>
  translate  <-1.23603, 2.49042, 8.21859>
}
#declare _Leaf1B5_1B1_1B2_1B3_Ref = object {
  _Leaf1B5_1B1_1B2_1B3
  scale 0.7
  rotate <0.0, 44.49218, 177.645035>
  translate  <-1.23588, 2.5643, 8.29981>
}
#declare _Leaf1B5_1B1_1B2_1B4_Ref = object {
  _Leaf1B5_1B1_1B2_1B4
  scale 0.7
  rotate <0.0, 85.68055, 248.44664>
  translate  <-1.22751, 2.54657, 8.30978>
}
#declare _Leaf1B5_1B1_1B2_1B5_Ref = object {
  _Leaf1B5_1B1_1B2_1B5
  scale 0.7
  rotate <0.0, 135.074875, 41.770691>
  translate  <-1.16377, 2.62531, 8.34925>
}
#declare _Leaf1B5_1B1_1B2_1B6_Ref = object {
  _Leaf1B5_1B1_1B2_1B6
  scale 0.7
  rotate <0.0, 92.539932, 97.06913>
  translate  <-1.05718, 2.80501, 8.56536>
}
#declare _Leaf1B5_1B1_1B2_1B7_Ref = object {
  _Leaf1B5_1B1_1B2_1B7
  scale 0.7
  rotate <0.0, 99.98333, 351.047638>
  translate  <-0.99566, 2.8451, 8.6387>
}
#declare _Leaf1B5_1B1_1B2_1B8_Ref = object {
  _Leaf1B5_1B1_1B2_1B8
  scale 0.7
  rotate <0.0, 79.914337, 322.043457>
  translate  <-0.91761, 2.95922, 8.78341>
}
#declare _Leaf1B5_1B1_1B2_1B9_Ref = object {
  _Leaf1B5_1B1_1B2_1B9
  scale 0.7
  rotate <0.0, 107.107628, 127.476341>
  translate  <-0.92595, 2.97691, 8.77346>
}
#declare _Leaf1B5_1B1_1B2_1B10_Ref = object {
  _Leaf1B5_1B1_1B2_1B10
  scale 0.7
  rotate <0.0, 56.905731, 90.968102>
  translate  <-0.85191, 3.0915, 8.92016>
}
#declare _Leaf1B5_1B1_1B2_1B11_Ref = object {
  _Leaf1B5_1B1_1B2_1B11
  scale 0.7
  rotate <0.0, 17.19986, 133.594559>
  translate  <-0.85276, 3.08413, 8.92687>
}
#declare _Leaf1B5_1B1_1B2_1B12_Ref = object {
  _Leaf1B5_1B1_1B2_1B12
  scale 0.7
  rotate <0.0, 38.611622, 268.935455>
  translate  <-0.84533, 3.07753, 8.92802>
}
#declare _Leaf1B5_1B1_1B3_1B1_Ref = object {
  _Leaf1B5_1B1_1B3_1B1
  scale 0.7
  rotate <0.0, 74.242882, 193.667786>
  translate  <-1.76907, 2.27166, 8.20176>
}
#declare _Leaf1B5_1B1_1B3_1B2_Ref = object {
  _Leaf1B5_1B1_1B3_1B2
  scale 0.7
  rotate <0.0, 70.236351, 239.095215>
  translate  <-1.88787, 2.22374, 8.35734>
}
#declare _Leaf1B5_1B1_1B3_1B3_Ref = object {
  _Leaf1B5_1B1_1B3_1B3
  scale 0.7
  rotate <0.0, 88.894279, 121.781548>
  translate  <-1.9552, 2.25069, 8.43977>
}
#declare _Leaf1B5_1B1_1B3_1B4_Ref = object {
  _Leaf1B5_1B1_1B3_1B4
  scale 0.7
  rotate <0.0, 162.293533, 114.928146>
  translate  <-1.96931, 2.24317, 8.42465>
}
#declare _Leaf1B5_1B1_1B3_1B5_Ref = object {
  _Leaf1B5_1B1_1B3_1B5
  scale 0.7
  rotate <0.0, 63.327068, 315.213196>
  translate  <-2.0099, 2.19924, 8.51544>
}
#declare _Leaf1B5_1B1_1B3_1B6_Ref = object {
  _Leaf1B5_1B1_1B3_1B6
  scale 0.7
  rotate <0.0, 17.60268, 44.124439>
  translate  <-2.21528, 2.16672, 8.73252>
}
#declare _Leaf1B5_1B1_1B3_1B7_Ref = object {
  _Leaf1B5_1B1_1B3_1B7
  scale 0.7
  rotate <0.0, 92.297508, 265.811523>
  translate  <-2.29373, 2.12906, 8.78905>
}
#declare _Leaf1B5_1B1_1B3_1B8_Ref = object {
  _Leaf1B5_1B1_1B3_1B8
  scale 0.7
  rotate <0.0, 118.014526, 240.715134>
  translate  <-2.43366, 2.1002, 8.92921>
}
#declare _Leaf1B5_1B1_1B3_1B9_Ref = object {
  _Leaf1B5_1B1_1B3_1B9
  scale 0.7
  rotate <0.0, 50.791489, 47.278149>
  translate  <-2.4196, 2.1077, 8.94428>
}
#declare _Leaf1B5_1B1_1B3_1B10_Ref = object {
  _Leaf1B5_1B1_1B3_1B10
  scale 0.7
  rotate <0.0, 27.44404, 149.900955>
  translate  <-2.56049, 2.08323, 9.08459>
}
#declare _Leaf1B5_1B1_1B3_1B11_Ref = object {
  _Leaf1B5_1B1_1B3_1B11
  scale 0.7
  rotate <0.0, 72.680809, 152.016281>
  translate  <-2.56785, 2.08489, 9.07803>
}
#declare _Leaf1B5_1B1_1B3_1B12_Ref = object {
  _Leaf1B5_1B1_1B3_1B12
  scale 0.7
  rotate <0.0, 121.431587, 170.965347>
  translate  <-2.57159, 2.07731, 9.07269>
}
#declare _Leaf1B5_1B2_2B1_1B1_Ref = object {
  _Leaf1B5_1B2_2B1_1B1
  scale 0.7
  rotate <0.0, 61.139992, 294.286835>
  translate  <-1.84501, 0.54143, 9.64512>
}
#declare _Leaf1B5_1B2_2B1_1B2_Ref = object {
  _Leaf1B5_1B2_2B1_1B2
  scale 0.7
  rotate <0.0, 73.640709, 339.545044>
  translate  <-1.75626, 0.47825, 9.81466>
}
#declare _Leaf1B5_1B2_2B1_1B3_Ref = object {
  _Leaf1B5_1B2_2B1_1B3
  scale 0.7
  rotate <0.0, 68.752953, 213.414642>
  translate  <-1.7599, 0.43942, 9.9173>
}
#declare _Leaf1B5_1B2_2B1_1B4_Ref = object {
  _Leaf1B5_1B2_2B1_1B4
  scale 0.7
  rotate <0.0, 141.758606, 223.406036>
  translate  <-1.75435, 0.42148, 9.90585>
}
#declare _Leaf1B5_1B2_2B1_1B5_Ref = object {
  _Leaf1B5_1B2_2B1_1B5
  scale 0.7
  rotate <0.0, 84.930458, 49.43177>
  translate  <-1.68956, 0.41225, 9.99266>
}
#declare _Leaf1B5_1B2_2B1_1B6_Ref = object {
  _Leaf1B5_1B2_2B1_1B6
  scale 0.7
  rotate <0.0, 30.002171, 93.72876>
  translate  <-1.59569, 0.28569, 10.24865>
}
#declare _Leaf1B5_1B2_2B1_1B7_Ref = object {
  _Leaf1B5_1B2_2B1_1B7
  scale 0.7
  rotate <0.0, 103.535744, 356.499207>
  translate  <-1.54054, 0.22968, 10.3164>
}
#declare _Leaf1B5_1B2_2B1_1B8_Ref = object {
  _Leaf1B5_1B2_2B1_1B8
  scale 0.7
  rotate <0.0, 118.39444, 322.18045>
  translate  <-1.4716, 0.14118, 10.48215>
}
#declare _Leaf1B5_1B2_2B1_1B9_Ref = object {
  _Leaf1B5_1B2_2B1_1B9
  scale 0.7
  rotate <0.0, 56.348419, 124.771423>
  translate  <-1.47713, 0.15907, 10.49357>
}
#declare _Leaf1B5_1B2_2B1_1B10_Ref = object {
  _Leaf1B5_1B2_2B1_1B10
  scale 0.7
  rotate <0.0, 6.16695, 264.244995>
  translate  <-1.41237, 0.06961, 10.66071>
}
#declare _Leaf1B5_1B2_2B1_1B11_Ref = object {
  _Leaf1B5_1B2_2B1_1B11
  scale 0.7
  rotate <0.0, 51.1315, 247.220215>
  translate  <-1.41466, 0.06053, 10.6572>
}
#declare _Leaf1B5_1B2_2B1_1B12_Ref = object {
  _Leaf1B5_1B2_2B1_1B12
  scale 0.7
  rotate <0.0, 101.652893, 260.567871>
  translate  <-1.40801, 0.05548, 10.6517>
}
#declare _Leaf1B5_1B2_2B2_1B1_Ref = object {
  _Leaf1B5_1B2_2B2_1B1
  scale 0.7
  rotate <0.0, 93.775047, 218.757706>
  translate  <-2.29947, 0.34985, 9.82182>
}
#declare _Leaf1B5_1B2_2B2_1B2_Ref = object {
  _Leaf1B5_1B2_2B2_1B2
  scale 0.7
  rotate <0.0, 115.186836, 257.98642>
  translate  <-2.37091, 0.16999, 9.87804>
}
#declare _Leaf1B5_1B2_2B2_1B3_Ref = object {
  _Leaf1B5_1B2_2B2_1B3
  scale 0.7
  rotate <0.0, 52.15102, 154.709473>
  translate  <-2.42636, 0.10497, 9.94698>
}
#declare _Leaf1B5_1B2_2B2_1B4_Ref = object {
  _Leaf1B5_1B2_2B2_1B4
  scale 0.7
  rotate <0.0, 115.0112, 114.063469>
  translate  <-2.44063, 0.1072, 9.93037>
}
#declare _Leaf1B5_1B2_2B2_1B5_Ref = object {
  _Leaf1B5_1B2_2B2_1B5
  scale 0.7
  rotate <0.0, 97.692413, 328.673615>
  translate  <-2.45097, 0.00143, 9.95333>
}
#declare _Leaf1B5_1B2_2B2_1B6_Ref = object {
  _Leaf1B5_1B2_2B2_1B6
  scale 0.7
  rotate <0.0, 37.170879, 303.006073>
  translate  <-2.59705, -0.24096, 10.05466>
}
#declare _Leaf1B5_1B2_2B2_1B7_Ref = object {
  _Leaf1B5_1B2_2B2_1B7
  scale 0.7
  rotate <0.0, 141.580414, 286.74588>
  translate  <-2.65127, -0.3294, 10.05712>
}
#declare _Leaf1B5_1B2_2B2_1B8_Ref = object {
  _Leaf1B5_1B2_2B2_1B8
  scale 0.7
  rotate <0.0, 156.933899, 220.180649>
  translate  <-2.75053, -0.49291, 10.11605>
}
#declare _Leaf1B5_1B2_2B2_1B9_Ref = object {
  _Leaf1B5_1B2_2B2_1B9
  scale 0.7
  rotate <0.0, 28.15477, 4.97843>
  translate  <-2.7363, -0.49513, 10.13261>
}
#declare _Leaf1B5_1B2_2B2_1B10_Ref = object {
  _Leaf1B5_1B2_2B2_1B10
  scale 0.7
  rotate <0.0, 43.73457, 246.789307>
  translate  <-2.83756, -0.65638, 10.19488>
}
#declare _Leaf1B5_1B2_2B2_1B11_Ref = object {
  _Leaf1B5_1B2_2B2_1B11
  scale 0.7
  rotate <0.0, 62.113869, 193.57785>
  translate  <-2.84619, -0.65282, 10.1913>
}
#declare _Leaf1B5_1B2_2B2_1B12_Ref = object {
  _Leaf1B5_1B2_2B2_1B12
  scale 0.7
  rotate <0.0, 107.648888, 167.57193>
  translate  <-2.84879, -0.65463, 10.18181>
}
#declare _Leaf1B5_1B2_2B3_1B1_Ref = object {
  _Leaf1B5_1B2_2B3_1B1
  scale 0.7
  rotate <0.0, 35.607632, 48.092838>
  translate  <-2.42208, 0.63338, 10.52432>
}
#declare _Leaf1B5_1B2_2B3_1B2_Ref = object {
  _Leaf1B5_1B2_2B3_1B2
  scale 0.7
  rotate <0.0, 74.048866, 73.884651>
  translate  <-2.45934, 0.75979, 10.67678>
}
#declare _Leaf1B5_1B2_2B3_1B3_Ref = object {
  _Leaf1B5_1B2_2B3_1B3
  scale 0.7
  rotate <0.0, 42.99448, 271.118591>
  translate  <-2.4931, 0.78096, 10.77909>
}
#declare _Leaf1B5_1B2_2B3_1B4_Ref = object {
  _Leaf1B5_1B2_2B3_1B4
  scale 0.7
  rotate <0.0, 103.813141, 317.340485>
  translate  <-2.47124, 0.78246, 10.78112>
}
#declare _Leaf1B5_1B2_2B3_1B5_Ref = object {
  _Leaf1B5_1B2_2B3_1B5
  scale 0.7
  rotate <0.0, 121.915131, 126.20755>
  translate  <-2.50409, 0.86699, 10.84108>
}
#declare _Leaf1B5_1B2_2B3_1B6_Ref = object {
  _Leaf1B5_1B2_2B3_1B6
  scale 0.7
  rotate <0.0, 70.558891, 166.672714>
  translate  <-2.54465, 1.01762, 11.09804>
}
#declare _Leaf1B5_1B2_2B3_1B7_Ref = object {
  _Leaf1B5_1B2_2B3_1B7
  scale 0.7
  rotate <0.0, 107.464279, 66.169029>
  translate  <-2.53201, 1.08562, 11.1754>
}
#declare _Leaf1B5_1B2_2B3_1B8_Ref = object {
  _Leaf1B5_1B2_2B3_1B8
  scale 0.7
  rotate <0.0, 97.249519, 31.66345>
  translate  <-2.5516, 1.1907, 11.34462>
}
#declare _Leaf1B5_1B2_2B3_1B9_Ref = object {
  _Leaf1B5_1B2_2B3_1B9
  scale 0.7
  rotate <0.0, 86.83194, 196.339767>
  translate  <-2.57339, 1.1892, 11.3426>
}
#declare _Leaf1B5_1B2_2B3_1B10_Ref = object {
  _Leaf1B5_1B2_2B3_1B10
  scale 0.7
  rotate <0.0, 35.50301, 155.392227>
  translate  <-2.59395, 1.29057, 11.51417>
}
#declare _Leaf1B5_1B2_2B3_1B11_Ref = object {
  _Leaf1B5_1B2_2B3_1B11
  scale 0.7
  rotate <0.0, 11.19018, 302.587219>
  translate  <-2.58532, 1.28701, 11.51775>
}
#declare _Leaf1B5_1B2_2B3_1B12_Ref = object {
  _Leaf1B5_1B2_2B3_1B12
  scale 0.7
  rotate <0.0, 60.247688, 342.951752>
  translate  <-2.57674, 1.29175, 11.51576>
}
#declare _Leaf1B5_1B2_2B4_1B1_Ref = object {
  _Leaf1B5_1B2_2B4_1B1
  scale 0.7
  rotate <0.0, 74.66201, 140.997803>
  translate  <-2.78644, 0.48609, 10.52805>
}
#declare _Leaf1B5_1B2_2B4_1B2_Ref = object {
  _Leaf1B5_1B2_2B4_1B2
  scale 0.7
  rotate <0.0, 115.62085, 155.49913>
  translate  <-2.98389, 0.49583, 10.56719>
}
#declare _Leaf1B5_1B2_2B4_1B3_Ref = object {
  _Leaf1B5_1B2_2B4_1B3
  scale 0.7
  rotate <0.0, 10.70032, 65.385529>
  translate  <-3.06946, 0.4908, 10.6358>
}
#declare _Leaf1B5_1B2_2B4_1B4_Ref = object {
  _Leaf1B5_1B2_2B4_1B4
  scale 0.7
  rotate <0.0, 82.88517, 36.825481>
  translate  <-3.06741, 0.51248, 10.63268>
}
#declare _Leaf1B5_1B2_2B4_1B5_Ref = object {
  _Leaf1B5_1B2_2B4_1B5
  scale 0.7
  rotate <0.0, 138.666855, 242.721146>
  translate  <-3.1754, 0.50047, 10.62878>
}
#declare _Leaf1B5_1B2_2B4_1B6_Ref = object {
  _Leaf1B5_1B2_2B4_1B6
  scale 0.7
  rotate <0.0, 74.712151, 234.806213>
  translate  <-3.4559, 0.53527, 10.73107>
}
#declare _Leaf1B5_1B2_2B4_1B7_Ref = object {
  _Leaf1B5_1B2_2B4_1B7
  scale 0.7
  rotate <0.0, 148.161713, 140.312119>
  translate  <-3.55264, 0.57084, 10.74315>
}
#declare _Leaf1B5_1B2_2B4_1B8_Ref = object {
  _Leaf1B5_1B2_2B4_1B8
  scale 0.7
  rotate <0.0, 124.799431, 100.518501>
  translate  <-3.74042, 0.60092, 10.80555>
}
#declare _Leaf1B5_1B2_2B4_1B9_Ref = object {
  _Leaf1B5_1B2_2B4_1B9
  scale 0.7
  rotate <0.0, 67.492783, 269.172943>
  translate  <-3.74246, 0.5793, 10.80866>
}
#declare _Leaf1B5_1B2_2B4_1B10_Ref = object {
  _Leaf1B5_1B2_2B4_1B10
  scale 0.7
  rotate <0.0, 57.151321, 199.95079>
  translate  <-3.92904, 0.60887, 10.87536>
}
#declare _Leaf1B5_1B2_2B4_1B11_Ref = object {
  _Leaf1B5_1B2_2B4_1B11
  scale 0.7
  rotate <0.0, 34.797989, 142.572403>
  translate  <-3.92675, 0.61795, 10.87888>
}
#declare _Leaf1B5_1B2_2B4_1B12_Ref = object {
  _Leaf1B5_1B2_2B4_1B12
  scale 0.7
  rotate <0.0, 66.730881, 86.259659>
  translate  <-3.92742, 0.62594, 10.8729>
}
#declare _Leaf1B5_1B2_2B5_1B1_Ref = object {
  _Leaf1B5_1B2_2B5_1B1
  scale 0.7
  rotate <0.0, 58.511639, 191.589218>
  translate  <-2.79636, 0.28469, 10.95361>
}
#declare _Leaf1B5_1B2_2B5_1B2_Ref = object {
  _Leaf1B5_1B2_2B5_1B2
  scale 0.7
  rotate <0.0, 68.717041, 238.984344>
  translate  <-2.86939, 0.223, 11.13102>
}
#declare _Leaf1B5_1B2_2B5_1B3_Ref = object {
  _Leaf1B5_1B2_2B5_1B3
  scale 0.7
  rotate <0.0, 72.544212, 112.051979>
  translate  <-2.90408, 0.242, 11.23344>
}
#declare _Leaf1B5_1B2_2B5_1B4_Ref = object {
  _Leaf1B5_1B2_2B5_1B4
  scale 0.7
  rotate <0.0, 144.686264, 128.705627>
  translate  <-2.92304, 0.2388, 11.22274>
}
#declare _Leaf1B5_1B2_2B5_1B5_Ref = object {
  _Leaf1B5_1B2_2B5_1B5
  scale 0.7
  rotate <0.0, 82.263474, 309.715851>
  translate  <-2.94108, 0.18413, 11.31497>
}
#declare _Leaf1B5_1B2_2B5_1B6_Ref = object {
  _Leaf1B5_1B2_2B5_1B6
  scale 0.7
  rotate <0.0, 31.411539, 1.6915>
  translate  <-3.07496, 0.13586, 11.57975>
}
#declare _Leaf1B5_1B2_2B5_1B7_Ref = object {
  _Leaf1B5_1B2_2B5_1B7
  scale 0.7
  rotate <0.0, 98.515411, 256.220276>
  translate  <-3.13787, 0.09736, 11.65274>
}
#declare _Leaf1B5_1B2_2B5_1B8_Ref = object {
  _Leaf1B5_1B2_2B5_1B8
  scale 0.7
  rotate <0.0, 113.980049, 223.180313>
  translate  <-3.23245, 0.05928, 11.82498>
}
#declare _Leaf1B5_1B2_2B5_1B9_Ref = object {
  _Leaf1B5_1B2_2B5_1B9
  scale 0.7
  rotate <0.0, 59.86771, 26.821569>
  translate  <-3.21354, 0.06248, 11.83564>
}
#declare _Leaf1B5_1B2_2B5_1B10_Ref = object {
  _Leaf1B5_1B2_2B5_1B10
  scale 0.7
  rotate <0.0, 7.77607, 123.899628>
  translate  <-3.30828, 0.02877, 12.00891>
}
#declare _Leaf1B5_1B2_2B5_1B11_Ref = object {
  _Leaf1B5_1B2_2B5_1B11
  scale 0.7
  rotate <0.0, 52.546989, 143.220978>
  translate  <-3.31691, 0.03233, 12.00533>
}
#declare _Leaf1B5_1B2_2B5_1B12_Ref = object {
  _Leaf1B5_1B2_2B5_1B12
  scale 0.7
  rotate <0.0, 101.699287, 161.413696>
  translate  <-3.32321, 0.02625, 12.00049>
}
#declare _Leaf1B5_1B2_1B1_1B1_Ref = object {
  _Leaf1B5_1B2_1B1_1B1
  scale 0.7
  rotate <0.0, 88.917099, 216.671188>
  translate  <-1.40428, 0.66485, 7.97906>
}
#declare _Leaf1B5_1B2_1B1_1B2_Ref = object {
  _Leaf1B5_1B2_1B1_1B2
  scale 0.7
  rotate <0.0, 109.656769, 255.466843>
  translate  <-1.47987, 0.49368, 8.05389>
}
#declare _Leaf1B5_1B2_1B1_1B3_Ref = object {
  _Leaf1B5_1B2_1B1_1B3
  scale 0.7
  rotate <0.0, 52.746559, 148.271469>
  translate  <-1.53489, 0.43731, 8.13038>
}
#declare _Leaf1B5_1B2_1B1_1B4_Ref = object {
  _Leaf1B5_1B2_1B1_1B4
  scale 0.7
  rotate <0.0, 118.873596, 113.975868>
  translate  <-1.5497, 0.4386, 8.11416>
}
#declare _Leaf1B5_1B2_1B1_1B5_Ref = object {
  _Leaf1B5_1B2_1B1_1B5
  scale 0.7
  rotate <0.0, 96.686737, 325.825836>
  translate  <-1.56292, 0.3358, 8.14699>
}
#declare _Leaf1B5_1B2_1B1_1B6_Ref = object {
  _Leaf1B5_1B2_1B1_1B6
  scale 0.7
  rotate <0.0, 34.166752, 307.455048>
  translate  <-1.71352, 0.10935, 8.27506>
}
#declare _Leaf1B5_1B2_1B1_1B7_Ref = object {
  _Leaf1B5_1B2_1B1_1B7
  scale 0.7
  rotate <0.0, 137.054489, 280.74527>
  translate  <-1.77074, 0.02368, 8.28748>
}
#declare _Leaf1B5_1B2_1B1_1B8_Ref = object {
  _Leaf1B5_1B2_1B1_1B8
  scale 0.7
  rotate <0.0, 151.890503, 223.147324>
  translate  <-1.87341, -0.12989, 8.36452>
}
#declare _Leaf1B5_1B2_1B1_1B9_Ref = object {
  _Leaf1B5_1B2_1B1_1B9
  scale 0.7
  rotate <0.0, 31.013149, 11.33553>
  translate  <-1.85864, -0.13117, 8.38069>
}
#declare _Leaf1B5_1B2_1B1_1B10_Ref = object {
  _Leaf1B5_1B2_1B1_1B10
  scale 0.7
  rotate <0.0, 38.136829, 244.413483>
  translate  <-1.96311, -0.28212, 8.46092>
}
#declare _Leaf1B5_1B2_1B1_1B11_Ref = object {
  _Leaf1B5_1B2_1B1_1B11
  scale 0.7
  rotate <0.0, 59.01181, 188.790649>
  translate  <-1.97174, -0.27856, 8.45734>
}
#declare _Leaf1B5_1B2_1B1_1B12_Ref = object {
  _Leaf1B5_1B2_1B1_1B12
  scale 0.7
  rotate <0.0, 106.698112, 167.127151>
  translate  <-1.97477, -0.2811, 8.44816>
}
#declare _Leaf1B5_1B2_1B2_1B1_Ref = object {
  _Leaf1B5_1B2_1B2_1B1
  scale 0.7
  rotate <0.0, 63.933681, 111.93821>
  translate  <-1.66187, 1.01245, 8.46332>
}
#declare _Leaf1B5_1B2_1B2_1B2_Ref = object {
  _Leaf1B5_1B2_1B2_1B2
  scale 0.7
  rotate <0.0, 104.966881, 126.228218>
  translate  <-1.82566, 1.10657, 8.53354>
}
#declare _Leaf1B5_1B2_1B2_1B3_Ref = object {
  _Leaf1B5_1B2_1B2_1B3
  scale 0.7
  rotate <0.0, 13.9059, 347.486786>
  translate  <-1.89662, 1.13076, 8.61375>
}
#declare _Leaf1B5_1B2_1B2_1B4_Ref = object {
  _Leaf1B5_1B2_1B2_1B4
  scale 0.7
  rotate <0.0, 86.590584, 7.22984>
  translate  <-1.88461, 1.14916, 8.61261>
}
#declare _Leaf1B5_1B2_1B2_1B5_Ref = object {
  _Leaf1B5_1B2_1B2_1B5
  scale 0.7
  rotate <0.0, 138.695801, 201.738846>
  translate  <-1.98478, 1.18976, 8.62435>
}
#declare _Leaf1B5_1B2_1B2_1B6_Ref = object {
  _Leaf1B5_1B2_1B2_1B6
  scale 0.7
  rotate <0.0, 74.689041, 209.103897>
  translate  <-2.20324, 1.33395, 8.77215>
}
#declare _Leaf1B5_1B2_1B2_1B7_Ref = object {
  _Leaf1B5_1B2_1B2_1B7
  scale 0.7
  rotate <0.0, 137.429337, 112.997726>
  translate  <-2.26919, 1.40799, 8.80276>
}
#declare _Leaf1B5_1B2_1B2_1B8_Ref = object {
  _Leaf1B5_1B2_1B2_1B8
  scale 0.7
  rotate <0.0, 116.983521, 76.324677>
  translate  <-2.41268, 1.51141, 8.89643>
}
#declare _Leaf1B5_1B2_1B2_1B9_Ref = object {
  _Leaf1B5_1B2_1B2_1B9
  scale 0.7
  rotate <0.0, 73.588531, 243.667145>
  translate  <-2.42466, 1.49306, 8.89757>
}
#declare _Leaf1B5_1B2_1B2_1B10_Ref = object {
  _Leaf1B5_1B2_1B2_1B10
  scale 0.7
  rotate <0.0, 51.228401, 177.821854>
  translate  <-2.56697, 1.59477, 8.99522>
}
#declare _Leaf1B5_1B2_1B2_1B11_Ref = object {
  _Leaf1B5_1B2_1B2_1B11
  scale 0.7
  rotate <0.0, 24.052031, 112.373383>
  translate  <-2.56028, 1.60101, 8.99926>
}
#declare _Leaf1B5_1B2_1B2_1B12_Ref = object {
  _Leaf1B5_1B2_1B2_1B12
  scale 0.7
  rotate <0.0, 61.73151, 52.970249>
  translate  <-2.55752, 1.60926, 8.99432>
}
#declare _Leaf1B5_1B2_1B3_1B1_Ref = object {
  _Leaf1B5_1B2_1B3_1B1
  scale 0.7
  rotate <0.0, 45.255699, 325.859955>
  translate  <-1.40138, 0.80441, 8.78044>
}
#declare _Leaf1B5_1B2_1B3_1B2_Ref = object {
  _Leaf1B5_1B2_1B3_1B2
  scale 0.7
  rotate <0.0, 68.890877, 10.1919>
  translate  <-1.31552, 0.83608, 8.95999>
}
#declare _Leaf1B5_1B2_1B3_1B3_Ref = object {
  _Leaf1B5_1B2_1B3_1B3
  scale 0.7
  rotate <0.0, 58.92667, 230.301559>
  translate  <-1.31553, 0.83101, 9.06967>
}
#declare _Leaf1B5_1B2_1B3_1B4_Ref = object {
  _Leaf1B5_1B2_1B3_1B4
  scale 0.7
  rotate <0.0, 127.275192, 259.297821>
  translate  <-1.30201, 0.81449, 9.06436>
}
#declare _Leaf1B5_1B2_1B3_1B5_Ref = object {
  _Leaf1B5_1B2_1B3_1B5
  scale 0.7
  rotate <0.0, 99.375153, 73.585838>
  translate  <-1.24961, 0.85866, 9.14876>
}
#declare _Leaf1B5_1B2_1B3_1B6_Ref = object {
  _Leaf1B5_1B2_1B3_1B6
  scale 0.7
  rotate <0.0, 48.259319, 116.237579>
  translate  <-1.14413, 0.863, 9.43021>
}
#declare _Leaf1B5_1B2_1B3_1B7_Ref = object {
  _Leaf1B5_1B2_1B3_1B7
  scale 0.7
  rotate <0.0, 102.538559, 16.807819>
  translate  <-1.07968, 0.85728, 9.51135>
}
#declare _Leaf1B5_1B2_1B3_1B8_Ref = object {
  _Leaf1B5_1B2_1B3_1B8
  scale 0.7
  rotate <0.0, 106.957588, 340.700165>
  translate  <-1.00136, 0.85781, 9.69553>
}
#declare _Leaf1B5_1B2_1B3_1B9_Ref = object {
  _Leaf1B5_1B2_1B3_1B9
  scale 0.7
  rotate <0.0, 71.467552, 144.194611>
  translate  <-1.01485, 0.87428, 9.70082>
}
#declare _Leaf1B5_1B2_1B3_1B10_Ref = object {
  _Leaf1B5_1B2_1B3_1B10
  scale 0.7
  rotate <0.0, 12.17693, 113.667778>
  translate  <-0.9401, 0.87266, 9.88669>
}
#declare _Leaf1B5_1B2_1B3_1B11_Ref = object {
  _Leaf1B5_1B2_1B3_1B11
  scale 0.7
  rotate <0.0, 34.366699, 263.548004>
  translate  <-0.93816, 0.86286, 9.88623>
}
#declare _Leaf1B5_1B2_1B3_1B12_Ref = object {
  _Leaf1B5_1B2_1B3_1B12
  scale 0.7
  rotate <0.0, 83.451439, 285.250122>
  translate  <-0.92946, 0.85966, 9.88251>
}
#declare _Leaf1B5_1B3_2B1_1B1_Ref = object {
  _Leaf1B5_1B3_2B1_1B1
  scale 0.7
  rotate <0.0, 95.477379, 55.074558>
  translate  <0.25101, 2.45432, 9.42935>
}
#declare _Leaf1B5_1B3_2B1_1B2_Ref = object {
  _Leaf1B5_1B3_2B1_1B2
  scale 0.7
  rotate <0.0, 116.474419, 94.839447>
  translate  <0.27, 2.64829, 9.48061>
}
#declare _Leaf1B5_1B3_2B1_1B3_Ref = object {
  _Leaf1B5_1B3_2B1_1B3
  scale 0.7
  rotate <0.0, 52.948101, 352.17572>
  translate  <0.30614, 2.72789, 9.54704>
}
#declare _Leaf1B5_1B3_2B1_1B4_Ref = object {
  _Leaf1B5_1B3_2B1_1B4
  scale 0.7
  rotate <0.0, 114.607941, 309.612152>
  translate  <0.32016, 2.72936, 9.53015>
}
#declare _Leaf1B5_1B3_2B1_1B5_Ref = object {
  _Leaf1B5_1B3_2B1_1B5
  scale 0.7
  rotate <0.0, 97.071114, 165.192551>
  translate  <0.30076, 2.83429, 9.55094>
}
#declare _Leaf1B5_1B3_2B1_1B6_Ref = object {
  _Leaf1B5_1B3_2B1_1B6
  scale 0.7
  rotate <0.0, 37.333752, 137.090408>
  translate  <0.37459, 3.11029, 9.6444>
}
#declare _Leaf1B5_1B3_2B1_1B7_Ref = object {
  _Leaf1B5_1B3_2B1_1B7
  scale 0.7
  rotate <0.0, 142.152054, 125.102898>
  translate  <0.40181, 3.21043, 9.64399>
}
#declare _Leaf1B5_1B3_2B1_1B8_Ref = object {
  _Leaf1B5_1B3_2B1_1B8
  scale 0.7
  rotate <0.0, 158.634537, 56.7057>
  translate  <0.45213, 3.39658, 9.6976>
}
#declare _Leaf1B5_1B3_2B1_1B9_Ref = object {
  _Leaf1B5_1B3_2B1_1B9
  scale 0.7
  rotate <0.0, 26.73134, 199.491455>
  translate  <0.43815, 3.39512, 9.71445>
}
#declare _Leaf1B5_1B3_2B1_1B10_Ref = object {
  _Leaf1B5_1B3_2B1_1B10
  scale 0.7
  rotate <0.0, 45.224091, 82.262321>
  translate  <0.49108, 3.57975, 9.77139>
}
#declare _Leaf1B5_1B3_2B1_1B11_Ref = object {
  _Leaf1B5_1B3_2B1_1B11
  scale 0.7
  rotate <0.0, 63.673988, 30.240709>
  translate  <0.5003, 3.57867, 9.76767>
}
#declare _Leaf1B5_1B3_2B1_1B12_Ref = object {
  _Leaf1B5_1B3_2B1_1B12
  scale 0.7
  rotate <0.0, 108.743019, 3.45652>
  translate  <0.50212, 3.5809, 9.75809>
}
#declare _Leaf1B5_1B3_2B2_1B1_Ref = object {
  _Leaf1B5_1B3_2B2_1B1
  scale 0.7
  rotate <0.0, 75.069458, 337.758545>
  translate  <0.61488, 2.33329, 9.7863>
}
#declare _Leaf1B5_1B3_2B2_1B2_Ref = object {
  _Leaf1B5_1B3_2B2_1B2
  scale 0.7
  rotate <0.0, 116.413841, 351.077057>
  translate  <0.80777, 2.38028, 9.82093>
}
#declare _Leaf1B5_1B3_2B2_1B3_Ref = object {
  _Leaf1B5_1B3_2B2_1B3
  scale 0.7
  rotate <0.0, 9.23121, 266.614349>
  translate  <0.88967, 2.41077, 9.8874>
}
#declare _Leaf1B5_1B3_2B2_1B4_Ref = object {
  _Leaf1B5_1B3_2B2_1B4
  scale 0.7
  rotate <0.0, 81.182426, 233.136703>
  translate  <0.89374, 2.38932, 9.88472>
}
#declare _Leaf1B5_1B3_2B2_1B5_Ref = object {
  _Leaf1B5_1B3_2B2_1B5
  scale 0.7
  rotate <0.0, 140.200317, 79.899658>
  translate  <0.99391, 2.43105, 9.87805>
}
#declare _Leaf1B5_1B3_2B2_1B6_Ref = object {
  _Leaf1B5_1B3_2B2_1B6
  scale 0.7
  rotate <0.0, 76.337402, 70.988564>
  translate  <1.27465, 2.47882, 9.9743>
}
#declare _Leaf1B5_1B3_2B2_1B7_Ref = object {
  _Leaf1B5_1B3_2B2_1B7
  scale 0.7
  rotate <0.0, 148.503677, 333.920776>
  translate  <1.37768, 2.47212, 9.98474>
}
#declare _Leaf1B5_1B3_2B2_1B8_Ref = object {
  _Leaf1B5_1B3_2B2_1B8
  scale 0.7
  rotate <0.0, 124.016289, 295.796295>
  translate  <1.56741, 2.49745, 10.04321>
}
#declare _Leaf1B5_1B3_2B2_1B9_Ref = object {
  _Leaf1B5_1B3_2B2_1B9
  scale 0.7
  rotate <0.0, 68.552277, 104.948418>
  translate  <1.56335, 2.51885, 10.04589>
}
#declare _Leaf1B5_1B3_2B2_1B10_Ref = object {
  _Leaf1B5_1B3_2B2_1B10
  scale 0.7
  rotate <0.0, 58.777401, 36.58065>
  translate  <1.75186, 2.54442, 10.10869>
}
#declare _Leaf1B5_1B3_2B2_1B11_Ref = object {
  _Leaf1B5_1B3_2B2_1B11
  scale 0.7
  rotate <0.0, 35.27774, 341.216431>
  translate  <1.75228, 2.53515, 10.11242>
}
#declare _Leaf1B5_1B3_2B2_1B12_Ref = object {
  _Leaf1B5_1B3_2B2_1B12
  scale 0.7
  rotate <0.0, 65.617378, 283.142151>
  translate  <1.75507, 2.52753, 10.10658>
}
#declare _Leaf1B5_1B3_2B3_1B1_Ref = object {
  _Leaf1B5_1B3_2B3_1B1
  scale 0.7
  rotate <0.0, 61.538818, 129.695419>
  translate  <0.40503, 2.64225, 10.45669>
}
#declare _Leaf1B5_1B3_2B3_1B2_Ref = object {
  _Leaf1B5_1B3_2B3_1B2
  scale 0.7
  rotate <0.0, 72.739609, 175.422028>
  translate  <0.30509, 2.68203, 10.62712>
}
#declare _Leaf1B5_1B3_2B3_1B3_Ref = object {
  _Leaf1B5_1B3_2B3_1B3
  scale 0.7
  rotate <0.0, 70.451752, 49.771702>
  translate  <0.29948, 2.72277, 10.72892>
}
#declare _Leaf1B5_1B3_2B3_1B4_Ref = object {
  _Leaf1B5_1B3_2B3_1B4
  scale 0.7
  rotate <0.0, 143.451645, 59.958092>
  translate  <0.28891, 2.73816, 10.71728>
}
#declare _Leaf1B5_1B3_2B3_1B5_Ref = object {
  _Leaf1B5_1B3_2B3_1B5
  scale 0.7
  rotate <0.0, 83.265282, 245.782104>
  translate  <0.22568, 2.73091, 10.80543>
}
#declare _Leaf1B5_1B3_2B3_1B6_Ref = object {
  _Leaf1B5_1B3_2B3_1B6
  scale 0.7
  rotate <0.0, 29.089951, 292.579651>
  translate  <0.10454, 2.83213, 11.06124>
}
#declare _Leaf1B5_1B3_2B3_1B7_Ref = object {
  _Leaf1B5_1B3_2B3_1B7
  scale 0.7
  rotate <0.0, 102.245743, 193.067154>
  translate  <0.03707, 2.87202, 11.12924>
}
#declare _Leaf1B5_1B3_2B3_1B8_Ref = object {
  _Leaf1B5_1B3_2B3_1B8
  scale 0.7
  rotate <0.0, 117.946732, 159.373886>
  translate  <-0.05103, 2.94157, 11.29495>
}
#declare _Leaf1B5_1B3_2B3_1B9_Ref = object {
  _Leaf1B5_1B3_2B3_1B9
  scale 0.7
  rotate <0.0, 56.287788, 322.219177>
  translate  <-0.0405, 2.92622, 11.30656>
}
#declare _Leaf1B5_1B3_2B3_1B10_Ref = object {
  _Leaf1B5_1B3_2B3_1B10
  scale 0.7
  rotate <0.0, 7.43534, 90.978752>
  translate  <-0.12484, 2.99789, 11.47354>
}
#declare _Leaf1B5_1B3_2B3_1B11_Ref = object {
  _Leaf1B5_1B3_2B3_1B11
  scale 0.7
  rotate <0.0, 52.61343, 82.875313>
  translate  <-0.12526, 3.00716, 11.46981>
}
#declare _Leaf1B5_1B3_2B3_1B12_Ref = object {
  _Leaf1B5_1B3_2B3_1B12
  scale 0.7
  rotate <0.0, 102.891869, 97.135536>
  translate  <-0.13316, 3.01001, 11.46438>
}
#declare _Leaf1B5_1B3_2B4_1B1_Ref = object {
  _Leaf1B5_1B3_2B4_1B1
  scale 0.7
  rotate <0.0, 33.93578, 244.872162>
  translate  <0.69185, 2.44929, 10.64367>
}
#declare _Leaf1B5_1B3_2B4_1B2_Ref = object {
  _Leaf1B5_1B3_2B4_1B2
  scale 0.7
  rotate <0.0, 72.6828, 270.501923>
  translate  <0.76581, 2.3421, 10.79746>
}
#declare _Leaf1B5_1B3_2B4_1B3_Ref = object {
  _Leaf1B5_1B3_2B4_1B3
  scale 0.7
  rotate <0.0, 44.018841, 105.998779>
  translate  <0.80596, 2.33371, 10.89931>
}
#declare _Leaf1B5_1B3_2B4_1B4_Ref = object {
  _Leaf1B5_1B3_2B4_1B4
  scale 0.7
  rotate <0.0, 103.512581, 154.061462>
  translate  <0.78544, 2.32619, 10.90188>
}
#declare _Leaf1B5_1B3_2B4_1B5_Ref = object {
  _Leaf1B5_1B3_2B4_1B5
  scale 0.7
  rotate <0.0, 121.864594, 321.461975>
  translate  <0.84178, 2.25573, 10.96257>
}
#declare _Leaf1B5_1B3_2B4_1B6_Ref = object {
  _Leaf1B5_1B3_2B4_1B6
  scale 0.7
  rotate <0.0, 71.642509, 3.436>
  translate  <0.92755, 2.12873, 11.22117>
}
#declare _Leaf1B5_1B3_2B4_1B7_Ref = object {
  _Leaf1B5_1B3_2B4_1B7
  scale 0.7
  rotate <0.0, 105.970169, 262.237183>
  translate  <0.93589, 2.06179, 11.30002>
}
#declare _Leaf1B5_1B3_2B4_1B8_Ref = object {
  _Leaf1B5_1B3_2B4_1B8
  scale 0.7
  rotate <0.0, 95.555138, 227.995987>
  translate  <0.9872, 1.97051, 11.4706>
}
#declare _Leaf1B5_1B3_2B4_1B9_Ref = object {
  _Leaf1B5_1B3_2B4_1B9
  scale 0.7
  rotate <0.0, 88.421402, 32.678612>
  translate  <1.00766, 1.97802, 11.46803>
}
#declare _Leaf1B5_1B3_2B4_1B10_Ref = object {
  _Leaf1B5_1B3_2B4_1B10
  scale 0.7
  rotate <0.0, 36.329811, 353.761353>
  translate  <1.05889, 1.89063, 11.64087>
}
#declare _Leaf1B5_1B3_2B4_1B11_Ref = object {
  _Leaf1B5_1B3_2B4_1B11
  scale 0.7
  rotate <0.0, 11.45715, 130.493668>
  translate  <1.04967, 1.89171, 11.64459>
}
#declare _Leaf1B5_1B3_2B4_1B12_Ref = object {
  _Leaf1B5_1B3_2B4_1B12
  scale 0.7
  rotate <0.0, 59.26685, 178.453659>
  translate  <1.04274, 1.88471, 11.64289>
}
#declare _Leaf1B5_1B3_2B5_1B1_Ref = object {
  _Leaf1B5_1B3_2B5_1B1
  scale 0.7
  rotate <0.0, 31.591539, 344.014862>
  translate  <0.87621, 2.79535, 10.90447>
}
#declare _Leaf1B5_1B3_2B5_1B2_Ref = object {
  _Leaf1B5_1B3_2B5_1B2
  scale 0.7
  rotate <0.0, 70.26062, 10.89879>
  translate  <0.96184, 2.88703, 11.06218>
}
#declare _Leaf1B5_1B3_2B5_1B3_Ref = object {
  _Leaf1B5_1B3_2B5_1B3
  scale 0.7
  rotate <0.0, 46.259232, 205.270584>
  translate  <0.95857, 2.92789, 11.16404>
}
#declare _Leaf1B5_1B3_2B5_1B4_Ref = object {
  _Leaf1B5_1B3_2B5_1B4
  scale 0.7
  rotate <0.0, 104.23423, 254.907303>
  translate  <0.96952, 2.90905, 11.16706>
}
#declare _Leaf1B5_1B3_2B5_1B5_Ref = object {
  _Leaf1B5_1B3_2B5_1B5
  scale 0.7
  rotate <0.0, 120.614349, 60.44809>
  translate  <1.02615, 2.97696, 11.23031>
}
#declare _Leaf1B5_1B3_2B5_1B6_Ref = object {
  _Leaf1B5_1B3_2B5_1B6
  scale 0.7
  rotate <0.0, 72.168159, 104.485733>
  translate  <1.12466, 3.08366, 11.4935>
}
#declare _Leaf1B5_1B3_2B5_1B7_Ref = object {
  _Leaf1B5_1B3_2B5_1B7
  scale 0.7
  rotate <0.0, 103.517273, 2.4951>
  translate  <1.18561, 3.10369, 11.57507>
}
#declare _Leaf1B5_1B3_2B5_1B8_Ref = object {
  _Leaf1B5_1B3_2B5_1B8
  scale 0.7
  rotate <0.0, 93.507217, 328.36969>
  translate  <1.25891, 3.17022, 11.74902>
}
#declare _Leaf1B5_1B3_2B5_1B9_Ref = object {
  _Leaf1B5_1B3_2B5_1B9
  scale 0.7
  rotate <0.0, 90.038498, 132.970078>
  translate  <1.248, 3.18902, 11.74601>
}
#declare _Leaf1B5_1B3_2B5_1B10_Ref = object {
  _Leaf1B5_1B3_2B5_1B10
  scale 0.7
  rotate <0.0, 36.4995, 97.346588>
  translate  <1.31739, 3.25478, 11.92207>
}
#declare _Leaf1B5_1B3_2B5_1B11_Ref = object {
  _Leaf1B5_1B3_2B5_1B11
  scale 0.7
  rotate <0.0, 13.19427, 222.805862>
  translate  <1.31781, 3.24551, 11.9258>
}
#declare _Leaf1B5_1B3_2B5_1B12_Ref = object {
  _Leaf1B5_1B3_2B5_1B12
  scale 0.7
  rotate <0.0, 58.998951, 277.262573>
  translate  <1.326, 3.23994, 11.92444>
}
#declare _Leaf1B5_1B3_1B1_1B1_Ref = object {
  _Leaf1B5_1B3_1B1_1B1
  scale 0.7
  rotate <0.0, 69.986801, 339.283813>
  translate  <-0.03637, 1.57297, 7.97132>
}
#declare _Leaf1B5_1B3_1B1_1B2_Ref = object {
  _Leaf1B5_1B3_1B1_1B2
  scale 0.7
  rotate <0.0, 110.93515, 353.749695>
  translate  <0.15027, 1.62719, 8.0246>
}
#declare _Leaf1B5_1B3_1B1_1B3_Ref = object {
  _Leaf1B5_1B3_1B1_1B3
  scale 0.7
  rotate <0.0, 11.16465, 239.360336>
  translate  <0.22409, 1.66041, 8.09878>
}
#declare _Leaf1B5_1B3_1B1_1B4_Ref = object {
  _Leaf1B5_1B3_1B1_1B4
  scale 0.7
  rotate <0.0, 84.65789, 234.836746>
  translate  <0.22924, 1.63915, 8.09645>
}
#declare _Leaf1B5_1B3_1B1_1B5_Ref = object {
  _Leaf1B5_1B3_1B1_1B5
  scale 0.7
  rotate <0.0, 138.781326, 75.831299>
  translate  <0.32788, 1.68478, 8.09963>
}
#declare _Leaf1B5_1B3_1B1_1B6_Ref = object {
  _Leaf1B5_1B3_1B1_1B6
  scale 0.7
  rotate <0.0, 74.449623, 74.59507>
  translate  <0.59589, 1.74279, 8.22278>
}
#declare _Leaf1B5_1B3_1B1_1B7_Ref = object {
  _Leaf1B5_1B3_1B1_1B7
  scale 0.7
  rotate <0.0, 143.487564, 339.751373>
  translate  <0.69761, 1.74004, 8.24313>
}
#declare _Leaf1B5_1B3_1B1_1B8_Ref = object {
  _Leaf1B5_1B3_1B1_1B8
  scale 0.7
  rotate <0.0, 121.579781, 301.265747>
  translate  <0.87965, 1.77234, 8.31979>
}
#declare _Leaf1B5_1B3_1B1_1B9_Ref = object {
  _Leaf1B5_1B3_1B1_1B9
  scale 0.7
  rotate <0.0, 69.946251, 109.232674>
  translate  <0.87451, 1.79354, 8.32212>
}
#declare _Leaf1B5_1B3_1B1_1B10_Ref = object {
  _Leaf1B5_1B3_1B1_1B10
  scale 0.7
  rotate <0.0, 54.282879, 40.995949>
  translate  <1.05491, 1.82601, 8.40296>
}
#declare _Leaf1B5_1B3_1B1_1B11_Ref = object {
  _Leaf1B5_1B3_1B1_1B11
  scale 0.7
  rotate <0.0, 30.109859, 340.221985>
  translate  <1.05533, 1.81674, 8.40669>
}
#declare _Leaf1B5_1B3_1B1_1B12_Ref = object {
  _Leaf1B5_1B3_1B1_1B12
  scale 0.7
  rotate <0.0, 64.612442, 282.840942>
  translate  <1.05896, 1.80927, 8.40113>
}
#declare _Leaf1B5_1B3_1B2_1B1_Ref = object {
  _Leaf1B5_1B3_1B2_1B1
  scale 0.7
  rotate <0.0, 40.082771, 196.477097>
  translate  <-0.24629, 1.62388, 8.58372>
}
#declare _Leaf1B5_1B3_1B2_1B2_Ref = object {
  _Leaf1B5_1B3_1B2_1B2
  scale 0.7
  rotate <0.0, 67.356079, 239.71788>
  translate  <-0.26323, 1.53388, 8.76323>
}
#declare _Leaf1B5_1B3_1B2_1B3_Ref = object {
  _Leaf1B5_1B3_1B2_1B3
  scale 0.7
  rotate <0.0, 56.599239, 93.929413>
  translate  <-0.25582, 1.53397, 8.87278>
}
#declare _Leaf1B5_1B3_1B2_1B4_Ref = object {
  _Leaf1B5_1B3_1B2_1B4
  scale 0.7
  rotate <0.0, 122.331711, 128.914932>
  translate  <-0.27755, 1.53541, 8.86969>
}
#declare _Leaf1B5_1B3_1B2_1B5_Ref = object {
  _Leaf1B5_1B3_1B2_1B5
  scale 0.7
  rotate <0.0, 103.825996, 299.904358>
  translate  <-0.27233, 1.4644, 8.95186>
}
#declare _Leaf1B5_1B3_1B2_1B6_Ref = object {
  _Leaf1B5_1B3_1B2_1B6
  scale 0.7
  rotate <0.0, 54.326988, 343.385162>
  translate  <-0.31216, 1.37542, 9.23621>
}
#declare _Leaf1B5_1B3_1B2_1B7_Ref = object {
  _Leaf1B5_1B3_1B2_1B7
  scale 0.7
  rotate <0.0, 101.500961, 242.700012>
  translate  <-0.35178, 1.32951, 9.32042>
}
#declare _Leaf1B5_1B3_1B2_1B8_Ref = object {
  _Leaf1B5_1B3_1B2_1B8
  scale 0.7
  rotate <0.0, 102.600601, 206.750717>
  translate  <-0.38583, 1.26602, 9.50715>
}
#declare _Leaf1B5_1B3_1B2_1B9_Ref = object {
  _Leaf1B5_1B3_1B2_1B9
  scale 0.7
  rotate <0.0, 76.836884, 10.55724>
  translate  <-0.36415, 1.26459, 9.51023>
}
#declare _Leaf1B5_1B3_1B2_1B10_Ref = object {
  _Leaf1B5_1B3_1B2_1B10
  scale 0.7
  rotate <0.0, 18.241249, 341.597351>
  translate  <-0.39717, 1.20513, 9.69867>
}
#declare _Leaf1B5_1B3_1B2_1B11_Ref = object {
  _Leaf1B5_1B3_1B2_1B11
  scale 0.7
  rotate <0.0, 29.405809, 125.07354>
  translate  <-0.40566, 1.21037, 9.69924>
}
#declare _Leaf1B5_1B3_1B2_1B12_Ref = object {
  _Leaf1B5_1B3_1B2_1B12
  scale 0.7
  rotate <0.0, 77.49205, 152.224503>
  translate  <-0.41428, 1.20627, 9.69624>
}
#declare _Leaf1B5_1B3_1B3_1B1_Ref = object {
  _Leaf1B5_1B3_1B3_1B1
  scale 0.7
  rotate <0.0, 87.80217, 83.666557>
  translate  <-0.16898, 2.07729, 8.59563>
}
#declare _Leaf1B5_1B3_1B3_1B2_Ref = object {
  _Leaf1B5_1B3_1B3_1B2
  scale 0.7
  rotate <0.0, 105.001961, 123.849602>
  translate  <-0.23489, 2.24661, 8.6828>
}
#declare _Leaf1B5_1B3_1B3_1B3_Ref = object {
  _Leaf1B5_1B3_1B3_1B3
  scale 0.7
  rotate <0.0, 57.940151, 13.26409>
  translate  <-0.23094, 2.3229, 8.76167>
}
#declare _Leaf1B5_1B3_1B3_1B4_Ref = object {
  _Leaf1B5_1B3_1B3_1B4
  scale 0.7
  rotate <0.0, 124.937248, 341.003601>
  translate  <-0.22161, 2.33339, 8.74474>
}
#declare _Leaf1B5_1B3_1B3_1B5_Ref = object {
  _Leaf1B5_1B3_1B3_1B5
  scale 0.7
  rotate <0.0, 91.415543, 192.778976>
  translate  <-0.28423, 2.41183, 8.78653>
}
#declare _Leaf1B5_1B3_1B3_1B6_Ref = object {
  _Leaf1B5_1B3_1B3_1B6
  scale 0.7
  rotate <0.0, 28.242359, 176.797806>
  translate  <-0.3342, 2.67208, 8.92842>
}
#declare _Leaf1B5_1B3_1B3_1B7_Ref = object {
  _Leaf1B5_1B3_1B3_1B7
  scale 0.7
  rotate <0.0, 131.179825, 149.388504>
  translate  <-0.35659, 2.77183, 8.94625>
}
#declare _Leaf1B5_1B3_1B3_1B8_Ref = object {
  _Leaf1B5_1B3_1B3_1B8
  scale 0.7
  rotate <0.0, 149.590515, 100.365967>
  translate  <-0.3911, 2.94902, 9.03269>
}
#declare _Leaf1B5_1B3_1B3_1B9_Ref = object {
  _Leaf1B5_1B3_1B3_1B9
  scale 0.7
  rotate <0.0, 29.99811, 248.679657>
  translate  <-0.40041, 2.93855, 9.04958>
}
#declare _Leaf1B5_1B3_1B3_1B10_Ref = object {
  _Leaf1B5_1B3_1B3_1B10
  scale 0.7
  rotate <0.0, 34.645649, 104.828278>
  translate  <-0.43148, 3.11518, 9.13886>
}
#declare _Leaf1B5_1B3_1B3_1B11_Ref = object {
  _Leaf1B5_1B3_1B3_1B11
  scale 0.7
  rotate <0.0, 60.977329, 52.637901>
  translate  <-0.4234, 3.11921, 9.13456>
}
#declare _Leaf1B5_1B3_1B3_1B12_Ref = object {
  _Leaf1B5_1B3_1B3_1B12
  scale 0.7
  rotate <0.0, 110.442734, 35.899731>
  translate  <-0.42413, 3.12344, 9.12553>
}
#declare _Leaf1B5_1B4_2B1_1B1_Ref = object {
  _Leaf1B5_1B4_2B1_1B1
  scale 0.7
  rotate <0.0, 106.265221, 115.743752>
  translate  <-1.45054, 3.99583, 10.79725>
}
#declare _Leaf1B5_1B4_2B1_1B2_Ref = object {
  _Leaf1B5_1B4_2B1_1B2
  scale 0.7
  rotate <0.0, 114.623901, 161.325577>
  translate  <-1.59786, 4.12754, 10.83679>
}
#declare _Leaf1B5_1B4_2B1_1B3_Ref = object {
  _Leaf1B5_1B4_2B1_1B3
  scale 0.7
  rotate <0.0, 70.576958, 51.790901>
  translate  <-1.63717, 4.21664, 10.88751>
}
#declare _Leaf1B5_1B4_2B1_1B4_Ref = object {
  _Leaf1B5_1B4_2B1_1B4
  scale 0.7
  rotate <0.0, 124.187347, 358.872803>
  translate  <-1.63379, 4.22414, 10.86711>
}
#declare _Leaf1B5_1B4_2B1_1B5_Ref = object {
  _Leaf1B5_1B4_2B1_1B5
  scale 0.7
  rotate <0.0, 80.04126, 222.943542>
  translate  <-1.72959, 4.26965, 10.891>
}
#declare _Leaf1B5_1B4_2B1_1B6_Ref = object {
  _Leaf1B5_1B4_2B1_1B6
  scale 0.7
  rotate <0.0, 27.66074, 170.678986>
  translate  <-1.91237, 4.50026, 10.95244>
}
#declare _Leaf1B5_1B4_2B1_1B7_Ref = object {
  _Leaf1B5_1B4_2B1_1B7
  scale 0.7
  rotate <0.0, 130.683502, 197.736694>
  translate  <-1.98355, 4.57503, 10.94193>
}
#declare _Leaf1B5_1B4_2B1_1B8_Ref = object {
  _Leaf1B5_1B4_2B1_1B8
  scale 0.7
  rotate <0.0, 162.343414, 166.42189>
  translate  <-2.10796, 4.72846, 10.97424>
}
#declare _Leaf1B5_1B4_2B1_1B9_Ref = object {
  _Leaf1B5_1B4_2B1_1B9
  scale 0.7
  rotate <0.0, 10.68626, 283.823273>
  translate  <-2.11133, 4.72097, 10.99458>
}
#declare _Leaf1B5_1B4_2B1_1B10_Ref = object {
  _Leaf1B5_1B4_2B1_1B10
  scale 0.7
  rotate <0.0, 51.0574, 124.786057>
  translate  <-2.23262, 4.87659, 11.02928>
}
#declare _Leaf1B5_1B4_2B1_1B11_Ref = object {
  _Leaf1B5_1B4_2B1_1B11
  scale 0.7
  rotate <0.0, 79.840874, 85.554291>
  translate  <-2.22757, 4.88243, 11.02293>
}
#declare _Leaf1B5_1B4_2B1_1B12_Ref = object {
  _Leaf1B5_1B4_2B1_1B12
  scale 0.7
  rotate <0.0, 126.650101, 61.38303>
  translate  <-2.22996, 4.8825, 11.01322>
}
#declare _Leaf1B5_1B4_2B2_1B1_Ref = object {
  _Leaf1B5_1B4_2B2_1B1
  scale 0.7
  rotate <0.0, 91.315842, 36.56398>
  translate  <-1.11001, 4.32074, 11.02732>
}
#declare _Leaf1B5_1B4_2B2_1B2_Ref = object {
  _Leaf1B5_1B4_2B2_1B2
  scale 0.7
  rotate <0.0, 133.825699, 45.962978>
  translate  <-1.04673, 4.51015, 11.00023>
}
#declare _Leaf1B5_1B4_2B2_1B3_Ref = object {
  _Leaf1B5_1B4_2B2_1B3
  scale 0.7
  rotate <0.0, 19.10008, 32.021961>
  translate  <-1.02111, 4.61008, 11.03781>
}
#declare _Leaf1B5_1B4_2B2_1B4_Ref = object {
  _Leaf1B5_1B4_2B2_1B4
  scale 0.7
  rotate <0.0, 70.019096, 294.667053>
  translate  <-1.00124, 4.60129, 11.03438>
}
#declare _Leaf1B5_1B4_2B2_1B5_Ref = object {
  _Leaf1B5_1B4_2B2_1B5
  scale 0.7
  rotate <0.0, 140.948349, 159.8703>
  translate  <-0.98673, 4.70218, 10.99656>
}
#declare _Leaf1B5_1B4_2B2_1B6_Ref = object {
  _Leaf1B5_1B4_2B2_1B6
  scale 0.7
  rotate <0.0, 83.599243, 125.95752>
  translate  <-0.87032, 4.97928, 11.00113>
}
#declare _Leaf1B5_1B4_2B2_1B7_Ref = object {
  _Leaf1B5_1B4_2B2_1B7
  scale 0.7
  rotate <0.0, 162.06163, 4.9211>
  translate  <-0.81073, 5.06146, 10.97955>
}
#declare _Leaf1B5_1B4_2B2_1B8_Ref = object {
  _Leaf1B5_1B4_2B2_1B8
  scale 0.7
  rotate <0.0, 129.047867, 340.810516>
  translate  <-0.72713, 5.24328, 10.97651>
}
#declare _Leaf1B5_1B4_2B2_1B9_Ref = object {
  _Leaf1B5_1B4_2B2_1B9
  scale 0.7
  rotate <0.0, 66.054291, 155.357071>
  translate  <-0.74695, 5.25205, 10.97992>
}
#declare _Leaf1B5_1B4_2B2_1B10_Ref = object {
  _Leaf1B5_1B4_2B2_1B10
  scale 0.7
  rotate <0.0, 74.126572, 90.388458>
  translate  <-0.66354, 5.43419, 10.98137>
}
#declare _Leaf1B5_1B4_2B2_1B11_Ref = object {
  _Leaf1B5_1B4_2B2_1B11
  scale 0.7
  rotate <0.0, 52.249352, 45.244709>
  translate  <-0.65491, 5.43063, 10.98495>
}
#declare _Leaf1B5_1B4_2B2_1B12_Ref = object {
  _Leaf1B5_1B4_2B2_1B12
  scale 0.7
  rotate <0.0, 69.829781, 348.232117>
  translate  <-0.64789, 5.42727, 10.97867>
}
#declare _Leaf1B5_1B4_2B3_1B1_Ref = object {
  _Leaf1B5_1B4_2B3_1B1
  scale 0.7
  rotate <0.0, 52.12175, 177.500626>
  translate  <-1.37936, 4.49591, 11.72424>
}
#declare _Leaf1B5_1B4_2B3_1B2_Ref = object {
  _Leaf1B5_1B4_2B3_1B2
  scale 0.7
  rotate <0.0, 55.024899, 232.006149>
  translate  <-1.43862, 4.48244, 11.91639>
}
#declare _Leaf1B5_1B4_2B3_1B3_Ref = object {
  _Leaf1B5_1B4_2B3_1B3
  scale 0.7
  rotate <0.0, 83.168663, 104.671852>
  translate  <-1.46093, 4.5269, 12.01427>
}
#declare _Leaf1B5_1B4_2B3_1B4_Ref = object {
  _Leaf1B5_1B4_2B3_1B4
  scale 0.7
  rotate <0.0, 149.882004, 143.812927>
  translate  <-1.48108, 4.5234, 12.00617>
}
#declare _Leaf1B5_1B4_2B3_1B5_Ref = object {
  _Leaf1B5_1B4_2B3_1B5
  scale 0.7
  rotate <0.0, 75.372871, 306.736908>
  translate  <-1.49399, 4.49242, 12.10958>
}
#declare _Leaf1B5_1B4_2B3_1B6_Ref = object {
  _Leaf1B5_1B4_2B3_1B6
  scale 0.7
  rotate <0.0, 38.547649, 13.7457>
  translate  <-1.60349, 4.5174, 12.38841>
}
#declare _Leaf1B5_1B4_2B3_1B7_Ref = object {
  _Leaf1B5_1B4_2B3_1B7
  scale 0.7
  rotate <0.0, 84.590843, 250.778061>
  translate  <-1.66154, 4.50253, 12.47314>
}
#declare _Leaf1B5_1B4_2B3_1B8_Ref = object {
  _Leaf1B5_1B4_2B3_1B8
  scale 0.7
  rotate <0.0, 101.397179, 219.752686>
  translate  <-1.74074, 4.51307, 12.65664>
}
#declare _Leaf1B5_1B4_2B3_1B9_Ref = object {
  _Leaf1B5_1B4_2B3_1B9
  scale 0.7
  rotate <0.0, 70.412323, 25.7229>
  translate  <-1.72064, 4.51655, 12.66472>
}
#declare _Leaf1B5_1B4_2B3_1B10_Ref = object {
  _Leaf1B5_1B4_2B3_1B10
  scale 0.7
  rotate <0.0, 19.615879, 83.815804>
  translate  <-1.79954, 4.53158, 12.84825>
}
#declare _Leaf1B5_1B4_2B3_1B11_Ref = object {
  _Leaf1B5_1B4_2B3_1B11
  scale 0.7
  rotate <0.0, 57.744339, 128.700409>
  translate  <-1.80817, 4.53514, 12.84467>
}
#declare _Leaf1B5_1B4_2B3_1B12_Ref = object {
  _Leaf1B5_1B4_2B3_1B12
  scale 0.7
  rotate <0.0, 101.074982, 158.841675>
  translate  <-1.81541, 4.52883, 12.84187>
}
#declare _Leaf1B5_1B4_2B4_1B1_Ref = object {
  _Leaf1B5_1B4_2B4_1B1
  scale 0.7
  rotate <0.0, 29.41259, 331.449585>
  translate  <-1.04216, 4.67498, 11.81749>
}
#declare _Leaf1B5_1B4_2B4_1B2_Ref = object {
  _Leaf1B5_1B4_2B4_1B2
  scale 0.7
  rotate <0.0, 72.697678, 334.023621>
  translate  <-0.89082, 4.71921, 11.94301>
}
#declare _Leaf1B5_1B4_2B4_1B3_Ref = object {
  _Leaf1B5_1B4_2B4_1B3
  scale 0.7
  rotate <0.0, 42.999882, 144.813858>
  translate  <-0.84821, 4.7745, 12.02775>
}
#declare _Leaf1B5_1B4_2B4_1B4_Ref = object {
  _Leaf1B5_1B4_2B4_1B4
  scale 0.7
  rotate <0.0, 87.787048, 212.814087>
  translate  <-0.85187, 4.75471, 12.03663>
}
#declare _Leaf1B5_1B4_2B4_1B5_Ref = object {
  _Leaf1B5_1B4_2B4_1B5
  scale 0.7
  rotate <0.0, 134.185989, 9.01929>
  translate  <-0.75446, 4.77911, 12.07832>
}
#declare _Leaf1B5_1B4_2B4_1B6_Ref = object {
  _Leaf1B5_1B4_2B4_1B6
  scale 0.7
  rotate <0.0, 89.549629, 61.320259>
  translate  <-0.56478, 4.85059, 12.30028>
}
#declare _Leaf1B5_1B4_2B4_1B7_Ref = object {
  _Leaf1B5_1B4_2B4_1B7
  scale 0.7
  rotate <0.0, 101.84359, 315.776825>
  translate  <-0.49205, 4.84312, 12.37393>
}
#declare _Leaf1B5_1B4_2B4_1B8_Ref = object {
  _Leaf1B5_1B4_2B4_1B8
  scale 0.7
  rotate <0.0, 82.80117, 286.071259>
  translate  <-0.36325, 4.88206, 12.52209>
}
#declare _Leaf1B5_1B4_2B4_1B9_Ref = object {
  _Leaf1B5_1B4_2B4_1B9
  scale 0.7
  rotate <0.0, 103.977303, 91.548912>
  translate  <-0.3596, 4.9018, 12.51324>
}
#declare _Leaf1B5_1B4_2B4_1B10_Ref = object {
  _Leaf1B5_1B4_2B4_1B10
  scale 0.7
  rotate <0.0, 54.06012, 54.2197>
  translate  <-0.23379, 4.94334, 12.66351>
}
#declare _Leaf1B5_1B4_2B4_1B11_Ref = object {
  _Leaf1B5_1B4_2B4_1B11
  scale 0.7
  rotate <0.0, 14.17751, 101.385788>
  translate  <-0.23884, 4.9375, 12.66987>
}
#declare _Leaf1B5_1B4_2B4_1B12_Ref = object {
  _Leaf1B5_1B4_2B4_1B12
  scale 0.7
  rotate <0.0, 41.440491, 234.90274>
  translate  <-0.23667, 4.92776, 12.6705>
}
#declare _Leaf1B5_1B4_2B5_1B1_Ref = object {
  _Leaf1B5_1B4_2B5_1B1
  scale 0.7
  rotate <0.0, 48.816349, 47.89222>
  translate  <-1.20339, 5.07667, 12.003>
}
#declare _Leaf1B5_1B4_2B5_1B2_Ref = object {
  _Leaf1B5_1B4_2B5_1B2
  scale 0.7
  rotate <0.0, 88.020943, 68.345078>
  translate  <-1.21427, 5.23656, 12.12518>
}
#declare _Leaf1B5_1B4_2B5_1B3_Ref = object {
  _Leaf1B5_1B4_2B5_1B3
  scale 0.7
  rotate <0.0, 30.24621, 273.663727>
  translate  <-1.23549, 5.28299, 12.22239>
}
#declare _Leaf1B5_1B4_2B5_1B4_Ref = object {
  _Leaf1B5_1B4_2B5_1B4
  scale 0.7
  rotate <0.0, 98.052917, 309.458344>
  translate  <-1.21349, 5.28263, 12.22223>
}
#declare _Leaf1B5_1B4_2B5_1B5_Ref = object {
  _Leaf1B5_1B4_2B5_1B5
  scale 0.7
  rotate <0.0, 128.903793, 129.497696>
  translate  <-1.23294, 5.38118, 12.26384>
}
#declare _Leaf1B5_1B4_2B5_1B6_Ref = object {
  _Leaf1B5_1B4_2B5_1B6
  scale 0.7
  rotate <0.0, 69.615067, 156.183289>
  translate  <-1.23437, 5.58779, 12.48217>
}
#declare _Leaf1B5_1B4_2B5_1B7_Ref = object {
  _Leaf1B5_1B4_2B5_1B7
  scale 0.7
  rotate <0.0, 121.422638, 60.279919>
  translate  <-1.20829, 5.66941, 12.54072>
}
#declare _Leaf1B5_1B4_2B5_1B8_Ref = object {
  _Leaf1B5_1B4_2B5_1B8
  scale 0.7
  rotate <0.0, 108.05423, 24.24614>
  translate  <-1.20169, 5.81044, 12.68258>
}
#declare _Leaf1B5_1B4_2B5_1B9_Ref = object {
  _Leaf1B5_1B4_2B5_1B9
  scale 0.7
  rotate <0.0, 78.710297, 189.480896>
  translate  <-1.22363, 5.81079, 12.68274>
}
#declare _Leaf1B5_1B4_2B5_1B10_Ref = object {
  _Leaf1B5_1B4_2B5_1B10
  scale 0.7
  rotate <0.0, 38.929138, 131.935165>
  translate  <-1.21805, 5.94884, 12.82781>
}
#declare _Leaf1B5_1B4_2B5_1B11_Ref = object {
  _Leaf1B5_1B4_2B5_1B11
  scale 0.7
  rotate <0.0, 11.31527, 13.38456>
  translate  <-1.20942, 5.94528, 12.8314>
}
#declare _Leaf1B5_1B4_2B5_1B12_Ref = object {
  _Leaf1B5_1B4_2B5_1B12
  scale 0.7
  rotate <0.0, 61.85215, 345.286407>
  translate  <-1.20073, 5.94856, 12.82769>
}
#declare _Leaf1B5_1B4_1B1_1B1_Ref = object {
  _Leaf1B5_1B4_1B1_1B1
  scale 0.7
  rotate <0.0, 86.46283, 38.6618>
  translate  <-1.06509, 2.90555, 9.51352>
}
#declare _Leaf1B5_1B4_1B1_1B2_Ref = object {
  _Leaf1B5_1B4_1B1_1B2
  scale 0.7
  rotate <0.0, 128.552017, 49.77021>
  translate  <-1.00835, 3.09878, 9.50598>
}
#declare _Leaf1B5_1B4_1B1_1B3_Ref = object {
  _Leaf1B5_1B4_1B1_1B3
  scale 0.7
  rotate <0.0, 14.81394, 22.22183>
  translate  <-0.98801, 3.19574, 9.55332>
}
#declare _Leaf1B5_1B4_1B1_1B4_Ref = object {
  _Leaf1B5_1B4_1B1_1B4
  scale 0.7
  rotate <0.0, 73.806229, 295.469696>
  translate  <-0.9677, 3.18801, 9.54989>
}
#declare _Leaf1B5_1B4_1B1_1B5_Ref = object {
  _Leaf1B5_1B4_1B1_1B5
  scale 0.7
  rotate <0.0, 140.939056, 155.109863>
  translate  <-0.95582, 3.29238, 9.52184>
}
#declare _Leaf1B5_1B4_1B1_1B6_Ref = object {
  _Leaf1B5_1B4_1B1_1B6
  scale 0.7
  rotate <0.0, 80.778442, 128.774124>
  translate  <-0.85058, 3.57191, 9.55573>
}
#declare _Leaf1B5_1B4_1B1_1B7_Ref = object {
  _Leaf1B5_1B4_1B1_1B7
  scale 0.7
  rotate <0.0, 158.834732, 20.04652>
  translate  <-0.79353, 3.65778, 9.54392>
}
#declare _Leaf1B5_1B4_1B1_1B8_Ref = object {
  _Leaf1B5_1B4_1B1_1B8
  scale 0.7
  rotate <0.0, 128.409393, 347.430054>
  translate  <-0.71706, 3.842, 9.56042>
}
#declare _Leaf1B5_1B4_1B1_1B9_Ref = object {
  _Leaf1B5_1B4_1B1_1B9
  scale 0.7
  rotate <0.0, 66.063362, 159.998245>
  translate  <-0.73731, 3.84971, 9.56383>
}
#declare _Leaf1B5_1B4_1B1_1B10_Ref = object {
  _Leaf1B5_1B4_1B1_1B10
  scale 0.7
  rotate <0.0, 69.019447, 93.308052>
  translate  <-0.66119, 4.03383, 9.58482>
}
#declare _Leaf1B5_1B4_1B1_1B11_Ref = object {
  _Leaf1B5_1B4_1B1_1B11
  scale 0.7
  rotate <0.0, 47.06086, 45.600609>
  translate  <-0.65256, 4.03027, 9.5884>
}
#declare _Leaf1B5_1B4_1B1_1B12_Ref = object {
  _Leaf1B5_1B4_1B1_1B12
  scale 0.7
  rotate <0.0, 68.790512, 348.303772>
  translate  <-0.6452, 4.02775, 9.58212>
}
#declare _Leaf1B5_1B4_1B2_1B1_Ref = object {
  _Leaf1B5_1B4_1B2_1B1
  scale 0.7
  rotate <0.0, 22.957491, 263.321259>
  translate  <-1.12415, 2.92852, 10.1598>
}
#declare _Leaf1B5_1B4_1B2_1B2_Ref = object {
  _Leaf1B5_1B4_1B2_1B2
  scale 0.7
  rotate <0.0, 58.45356, 305.654327>
  translate  <-1.02977, 2.91562, 10.33739>
}
#declare _Leaf1B5_1B4_1B2_1B3_Ref = object {
  _Leaf1B5_1B4_1B2_1B3
  scale 0.7
  rotate <0.0, 58.211769, 140.304626>
  translate  <-1.00983, 2.95114, 10.43935>
}
#declare _Leaf1B5_1B4_1B2_1B4_Ref = object {
  _Leaf1B5_1B4_1B2_1B4
  scale 0.7
  rotate <0.0, 110.946938, 193.834427>
  translate  <-1.02256, 2.93358, 10.44307>
}
#declare _Leaf1B5_1B4_1B2_1B5_Ref = object {
  _Leaf1B5_1B4_1B2_1B5
  scale 0.7
  rotate <0.0, 111.176788, 352.595856>
  translate  <-0.94747, 2.92234, 10.52089>
}
#declare _Leaf1B5_1B4_1B2_1B6_Ref = object {
  _Leaf1B5_1B4_1B2_1B6
  scale 0.7
  rotate <0.0, 71.33596, 44.206131>
  translate  <-0.85005, 2.9198, 10.80526>
}
#declare _Leaf1B5_1B4_1B2_1B7_Ref = object {
  _Leaf1B5_1B4_1B2_1B7
  scale 0.7
  rotate <0.0, 92.091141, 298.757874>
  translate  <-0.81875, 2.88631, 10.89835>
}
#declare _Leaf1B5_1B4_1B2_1B8_Ref = object {
  _Leaf1B5_1B4_1B2_1B8
  scale 0.7
  rotate <0.0, 86.121773, 264.1008>
  translate  <-0.7545, 2.87562, 11.08761>
}
#declare _Leaf1B5_1B4_1B2_1B9_Ref = object {
  _Leaf1B5_1B4_1B2_1B9
  scale 0.7
  rotate <0.0, 94.605026, 68.280602>
  translate  <-0.74181, 2.89313, 11.0839>
}
#declare _Leaf1B5_1B4_1B2_1B10_Ref = object {
  _Leaf1B5_1B4_1B2_1B10
  scale 0.7
  rotate <0.0, 35.482319, 49.674931>
  translate  <-0.6802, 2.88586, 11.27439>
}
#declare _Leaf1B5_1B4_1B2_1B11_Ref = object {
  _Leaf1B5_1B4_1B2_1B11
  scale 0.7
  rotate <0.0, 24.697781, 148.193893>
  translate  <-0.68888, 2.88195, 11.27745>
}
#declare _Leaf1B5_1B4_1B2_1B12_Ref = object {
  _Leaf1B5_1B4_1B2_1B12
  scale 0.7
  rotate <0.0, 62.401958, 206.543671>
  translate  <-0.69022, 2.87204, 11.27731>
}
#declare _Leaf1B5_1B4_1B3_1B1_Ref = object {
  _Leaf1B5_1B4_1B3_1B1
  scale 0.7
  rotate <0.0, 90.845818, 141.349319>
  translate  <-1.46775, 3.23383, 10.13945>
}
#declare _Leaf1B5_1B4_1B3_1B2_Ref = object {
  _Leaf1B5_1B4_1B3_1B2
  scale 0.7
  rotate <0.0, 95.463783, 184.507675>
  translate  <-1.63197, 3.29386, 10.23966>
}
#declare _Leaf1B5_1B4_1B3_1B3_Ref = object {
  _Leaf1B5_1B4_1B3_1B3
  scale 0.7
  rotate <0.0, 75.613541, 69.896294>
  translate  <-1.68299, 3.35864, 10.31216>
}
#declare _Leaf1B5_1B4_1B3_1B4_Ref = object {
  _Leaf1B5_1B4_1B3_1B4
  scale 0.7
  rotate <0.0, 141.096436, 31.51848>
  translate  <-1.68965, 3.36714, 10.293>
}
#declare _Leaf1B5_1B4_1B3_1B5_Ref = object {
  _Leaf1B5_1B4_1B3_1B5
  scale 0.7
  rotate <0.0, 73.76059, 251.067764>
  translate  <-1.78182, 3.36951, 10.35061>
}
#declare _Leaf1B5_1B4_1B3_1B6_Ref = object {
  _Leaf1B5_1B4_1B3_1B6
  scale 0.7
  rotate <0.0, 10.62716, 224.351852>
  translate  <-2.00697, 3.50521, 10.4964>
}
#declare _Leaf1B5_1B4_1B3_1B7_Ref = object {
  _Leaf1B5_1B4_1B3_1B7
  scale 0.7
  rotate <0.0, 115.747261, 213.398529>
  translate  <-2.10033, 3.54477, 10.5185>
}
#declare _Leaf1B5_1B4_1B3_1B8_Ref = object {
  _Leaf1B5_1B4_1B3_1B8
  scale 0.7
  rotate <0.0, 143.266113, 184.040344>
  translate  <-2.25537, 3.63403, 10.60824>
}
#declare _Leaf1B5_1B4_1B3_1B9_Ref = object {
  _Leaf1B5_1B4_1B3_1B9
  scale 0.7
  rotate <0.0, 27.369989, 339.708221>
  translate  <-2.24872, 3.62555, 10.62735>
}
#declare _Leaf1B5_1B4_1B3_1B10_Ref = object {
  _Leaf1B5_1B4_1B3_1B10
  scale 0.7
  rotate <0.0, 35.129318, 136.612106>
  translate  <-2.40112, 3.71805, 10.71874>
}
#declare _Leaf1B5_1B4_1B3_1B11_Ref = object {
  _Leaf1B5_1B4_1B3_1B11
  scale 0.7
  rotate <0.0, 73.347282, 105.003616>
  translate  <-2.40107, 3.72552, 10.7121>
}
#declare _Leaf1B5_1B4_1B3_1B12_Ref = object {
  _Leaf1B5_1B4_1B3_1B12
  scale 0.7
  rotate <0.0, 125.098839, 99.299812>
  translate  <-2.40637, 3.72474, 10.70366>
}
#declare _Leaf1B5_1B5_2B1_1B1_Ref = object {
  _Leaf1B5_1B5_2B1_1B1
  scale 0.7
  rotate <0.0, 71.432564, 230.179047>
  translate  <-2.96614, 2.45212, 11.0634>
}
#declare _Leaf1B5_1B5_2B1_1B2_Ref = object {
  _Leaf1B5_1B5_2B1_1B2
  scale 0.7
  rotate <0.0, 71.988983, 275.932007>
  translate  <-3.02025, 2.34138, 11.22285>
}
#declare _Leaf1B5_1B5_2B1_1B3_Ref = object {
  _Leaf1B5_1B5_2B1_1B3
  scale 0.7
  rotate <0.0, 83.092979, 156.605087>
  translate  <-3.08226, 2.32308, 11.31159>
}
#declare _Leaf1B5_1B5_2B1_1B4_Ref = object {
  _Leaf1B5_1B5_2B1_1B4
  scale 0.7
  rotate <0.0, 156.59993, 154.118713>
  translate  <-3.09102, 2.30917, 11.29697>
}
#declare _Leaf1B5_1B5_2B1_1B5_Ref = object {
  _Leaf1B5_1B5_2B1_1B5
  scale 0.7
  rotate <0.0, 69.233719, 350.010864>
  translate  <-3.09006, 2.24793, 11.3868>
}
#declare _Leaf1B5_1B5_2B1_1B6_Ref = object {
  _Leaf1B5_1B5_2B1_1B6
  scale 0.7
  rotate <0.0, 18.41201, 60.917229>
  translate  <-3.21744, 2.09887, 11.61465>
}
#declare _Leaf1B5_1B5_2B1_1B7_Ref = object {
  _Leaf1B5_1B5_2B1_1B7
  scale 0.7
  rotate <0.0, 96.317131, 300.387848>
  translate  <-3.2544, 2.02183, 11.67353>
}
#declare _Leaf1B5_1B5_2B1_1B8_Ref = object {
  _Leaf1B5_1B5_2B1_1B8
  scale 0.7
  rotate <0.0, 119.67749, 272.490295>
  translate  <-3.33817, 1.91494, 11.82056>
}
#declare _Leaf1B5_1B5_2B1_1B9_Ref = object {
  _Leaf1B5_1B5_2B1_1B9
  scale 0.7
  rotate <0.0, 50.582371, 77.337898>
  translate  <-3.32942, 1.92881, 11.83514>
}
#declare _Leaf1B5_1B5_2B1_1B10_Ref = object {
  _Leaf1B5_1B5_2B1_1B10
  scale 0.7
  rotate <0.0, 21.856569, 189.042694>
  translate  <-3.41644, 1.82497, 11.98271>
}
#declare _Leaf1B5_1B5_2B1_1B11_Ref = object {
  _Leaf1B5_1B5_2B1_1B11
  scale 0.7
  rotate <0.0, 67.109291, 187.644119>
  translate  <-3.42406, 1.82226, 11.97683>
}
#declare _Leaf1B5_1B5_2B1_1B12_Ref = object {
  _Leaf1B5_1B5_2B1_1B12
  scale 0.7
  rotate <0.0, 116.716888, 203.882294>
  translate  <-3.42335, 1.81402, 11.97121>
}
#declare _Leaf1B5_1B5_2B2_1B1_Ref = object {
  _Leaf1B5_1B5_2B2_1B1
  scale 0.7
  rotate <0.0, 108.559402, 158.867523>
  translate  <-3.39998, 2.73899, 11.12625>
}
#declare _Leaf1B5_1B5_2B2_1B2_Ref = object {
  _Leaf1B5_1B5_2B2_1B2
  scale 0.7
  rotate <0.0, 130.430786, 202.640594>
  translate  <-3.5988, 2.70603, 11.12717>
}
#declare _Leaf1B5_1B5_2B2_1B3_Ref = object {
  _Leaf1B5_1B5_2B2_1B3
  scale 0.7
  rotate <0.0, 54.810532, 107.892662>
  translate  <-3.69896, 2.71884, 11.17029>
}
#declare _Leaf1B5_1B5_2B2_1B4_Ref = object {
  _Leaf1B5_1B5_2B2_1B4
  scale 0.7
  rotate <0.0, 104.77639, 50.903091>
  translate  <-3.6997, 2.73239, 11.15297>
}
#declare _Leaf1B5_1B5_2B2_1B5_Ref = object {
  _Leaf1B5_1B5_2B2_1B5
  scale 0.7
  rotate <0.0, 98.088257, 272.271729>
  translate  <-3.79794, 2.68607, 11.14802>
}
#declare _Leaf1B5_1B5_2B2_1B6_Ref = object {
  _Leaf1B5_1B5_2B2_1B6
  scale 0.7
  rotate <0.0, 46.618771, 229.669144>
  translate  <-4.09791, 2.68391, 11.16721>
}
#declare _Leaf1B5_1B5_2B2_1B7_Ref = object {
  _Leaf1B5_1B5_2B2_1B7
  scale 0.7
  rotate <0.0, 150.840057, 248.118881>
  translate  <-4.1983, 2.68434, 11.14093>
}
#declare _Leaf1B5_1B5_2B2_1B8_Ref = object {
  _Leaf1B5_1B5_2B2_1B8
  scale 0.7
  rotate <0.0, 170.166855, 127.195602>
  translate  <-4.39841, 2.68361, 11.14472>
}
#declare _Leaf1B5_1B5_2B2_1B9_Ref = object {
  _Leaf1B5_1B5_2B2_1B9
  scale 0.7
  rotate <0.0, 23.096201, 273.775665>
  translate  <-4.39767, 2.67009, 11.16199>
}
#declare _Leaf1B5_1B5_2B2_1B10_Ref = object {
  _Leaf1B5_1B5_2B2_1B10
  scale 0.7
  rotate <0.0, 59.72591, 187.030304>
  translate  <-4.59786, 2.67221, 11.16927>
}
#declare _Leaf1B5_1B5_2B2_1B11_Ref = object {
  _Leaf1B5_1B5_2B2_1B11
  scale 0.7
  rotate <0.0, 73.456543, 139.62674>
  translate  <-4.59828, 2.68147, 11.16554>
}
#declare _Leaf1B5_1B5_2B2_1B12_Ref = object {
  _Leaf1B5_1B5_2B2_1B12
  scale 0.7
  rotate <0.0, 111.447487, 103.352676>
  translate  <-4.59845, 2.68288, 11.15564>
}
#declare _Leaf1B5_1B5_2B3_1B1_Ref = object {
  _Leaf1B5_1B5_2B3_1B1
  scale 0.7
  rotate <0.0, 20.26128, 340.149689>
  translate  <-3.42311, 2.98224, 11.85372>
}
#declare _Leaf1B5_1B5_2B3_1B2_Ref = object {
  _Leaf1B5_1B5_2B3_1B2
  scale 0.7
  rotate <0.0, 58.434769, 16.906759>
  translate  <-3.38028, 3.0778, 12.02591>
}
#declare _Leaf1B5_1B5_2B3_1B3_Ref = object {
  _Leaf1B5_1B5_2B3_1B3
  scale 0.7
  rotate <0.0, 57.351711, 206.383896>
  translate  <-3.40813, 3.11638, 12.12486>
}
#declare _Leaf1B5_1B5_2B3_1B4_Ref = object {
  _Leaf1B5_1B5_2B3_1B4
  scale 0.7
  rotate <0.0, 107.082657, 263.0737>
  translate  <-3.39649, 3.09845, 12.13008>
}
#declare _Leaf1B5_1B5_2B3_1B5_Ref = object {
  _Leaf1B5_1B5_2B3_1B5
  scale 0.7
  rotate <0.0, 114.135818, 60.02219>
  translate  <-3.36023, 3.16965, 12.20381>
}
#declare _Leaf1B5_1B5_2B3_1B6_Ref = object {
  _Leaf1B5_1B5_2B3_1B6
  scale 0.7
  rotate <0.0, 75.505539, 112.72673>
  translate  <-3.32807, 3.27931, 12.48184>
}
#declare _Leaf1B5_1B5_2B3_1B7_Ref = object {
  _Leaf1B5_1B5_2B3_1B7
  scale 0.7
  rotate <0.0, 91.469482, 7.30024>
  translate  <-3.28735, 3.30283, 12.57435>
}
#declare _Leaf1B5_1B5_2B3_1B8_Ref = object {
  _Leaf1B5_1B5_2B3_1B8
  scale 0.7
  rotate <0.0, 83.25882, 333.058167>
  translate  <-3.25778, 3.37202, 12.75982>
}
#declare _Leaf1B5_1B5_2B3_1B9_Ref = object {
  _Leaf1B5_1B5_2B3_1B9
  scale 0.7
  rotate <0.0, 98.19812, 137.196365>
  translate  <-3.26939, 3.38989, 12.75461>
}
#declare _Leaf1B5_1B5_2B3_1B10_Ref = object {
  _Leaf1B5_1B5_2B3_1B10
  scale 0.7
  rotate <0.0, 39.592419, 117.217827>
  translate  <-3.24399, 3.45794, 12.94131>
}
#declare _Leaf1B5_1B5_2B3_1B11_Ref = object {
  _Leaf1B5_1B5_2B3_1B11
  scale 0.7
  rotate <0.0, 23.501751, 207.848206>
  translate  <-3.24357, 3.44868, 12.94504>
}
#declare _Leaf1B5_1B5_2B3_1B12_Ref = object {
  _Leaf1B5_1B5_2B3_1B12
  scale 0.7
  rotate <0.0, 58.27718, 274.763397>
  translate  <-3.23483, 3.44383, 12.94542>
}
#declare _Leaf1B5_1B5_2B4_1B1_Ref = object {
  _Leaf1B5_1B5_2B4_1B1
  scale 0.7
  rotate <0.0, 72.45739, 87.081779>
  translate  <-3.72766, 3.21721, 11.77308>
}
#declare _Leaf1B5_1B5_2B4_1B2_Ref = object {
  _Leaf1B5_1B5_2B4_1B2
  scale 0.7
  rotate <0.0, 115.738197, 89.083794>
  translate  <-3.82953, 3.39055, 11.78674>
}
#declare _Leaf1B5_1B5_2B4_1B3_Ref = object {
  _Leaf1B5_1B5_2B4_1B3
  scale 0.7
  rotate <0.0, 5.43498, 174.323318>
  translate  <-3.89553, 3.46024, 11.84007>
}
#declare _Leaf1B5_1B5_2B4_1B4_Ref = object {
  _Leaf1B5_1B5_2B4_1B4
  scale 0.7
  rotate <0.0, 68.34877, 336.417023>
  translate  <-3.87587, 3.46977, 11.84259>
}
#declare _Leaf1B5_1B5_2B4_1B5_Ref = object {
  _Leaf1B5_1B5_2B4_1B5
  scale 0.7
  rotate <0.0, 154.709869, 184.913269>
  translate  <-3.93881, 3.55589, 11.82154>
}
#declare _Leaf1B5_1B5_2B4_1B6_Ref = object {
  _Leaf1B5_1B5_2B4_1B6
  scale 0.7
  rotate <0.0, 90.668892, 176.392227>
  translate  <-4.07925, 3.81246, 11.89091>
}
#declare _Leaf1B5_1B5_2B4_1B7_Ref = object {
  _Leaf1B5_1B5_2B4_1B7
  scale 0.7
  rotate <0.0, 142.080582, 60.008301>
  translate  <-4.10195, 3.91345, 11.89825>
}
#declare _Leaf1B5_1B5_2B4_1B8_Ref = object {
  _Leaf1B5_1B5_2B4_1B8
  scale 0.7
  rotate <0.0, 111.888863, 36.665298>
  translate  <-4.18873, 4.08879, 11.94049>
}
#declare _Leaf1B5_1B5_2B4_1B9_Ref = object {
  _Leaf1B5_1B5_2B4_1B9
  scale 0.7
  rotate <0.0, 81.820038, 208.5215>
  translate  <-4.20834, 4.07928, 11.93797>
}
#declare _Leaf1B5_1B5_2B4_1B10_Ref = object {
  _Leaf1B5_1B5_2B4_1B10
  scale 0.7
  rotate <0.0, 69.719528, 146.364914>
  translate  <-4.29611, 4.25328, 11.98438>
}
#declare _Leaf1B5_1B5_2B4_1B11_Ref = object {
  _Leaf1B5_1B5_2B4_1B11
  scale 0.7
  rotate <0.0, 35.628029, 106.950981>
  translate  <-4.2885, 4.25599, 11.99026>
}
#declare _Leaf1B5_1B5_2B4_1B12_Ref = object {
  _Leaf1B5_1B5_2B4_1B12
  scale 0.7
  rotate <0.0, 52.42897, 31.961729>
  translate  <-4.28063, 4.26079, 11.98637>
}
#declare _Leaf1B5_1B5_2B5_1B1_Ref = object {
  _Leaf1B5_1B5_2B5_1B1
  scale 0.7
  rotate <0.0, 69.563728, 138.680573>
  translate  <-4.01529, 3.11594, 12.13193>
}
#declare _Leaf1B5_1B5_2B5_1B2_Ref = object {
  _Leaf1B5_1B5_2B5_1B2
  scale 0.7
  rotate <0.0, 84.75769, 180.486008>
  translate  <-4.15151, 3.14416, 12.27774>
}
#declare _Leaf1B5_1B5_2B5_1B3_Ref = object {
  _Leaf1B5_1B5_2B5_1B3
  scale 0.7
  rotate <0.0, 62.9487, 58.728851>
  translate  <-4.18162, 3.18242, 12.37615>
}
#declare _Leaf1B5_1B5_2B5_1B4_Ref = object {
  _Leaf1B5_1B5_2B5_1B4
  scale 0.7
  rotate <0.0, 136.306274, 53.19252>
  translate  <-4.19081, 3.19709, 12.36257>
}
#declare _Leaf1B5_1B5_2B5_1B5_Ref = object {
  _Leaf1B5_1B5_2B5_1B5
  scale 0.7
  rotate <0.0, 88.335983, 249.844315>
  translate  <-4.27015, 3.183, 12.43556>
}
#declare _Leaf1B5_1B5_2B5_1B6_Ref = object {
  _Leaf1B5_1B5_2B5_1B6
  scale 0.7
  rotate <0.0, 26.70883, 274.875031>
  translate  <-4.45002, 3.26912, 12.66048>
}
#declare _Leaf1B5_1B5_2B5_1B7_Ref = object {
  _Leaf1B5_1B5_2B5_1B7
  scale 0.7
  rotate <0.0, 113.979622, 198.850647>
  translate  <-4.5333, 3.30203, 12.71292>
}
#declare _Leaf1B5_1B5_2B5_1B8_Ref = object {
  _Leaf1B5_1B5_2B5_1B8
  scale 0.7
  rotate <0.0, 129.110992, 161.197678>
  translate  <-4.65954, 3.36098, 12.85661>
}
#declare _Leaf1B5_1B5_2B5_1B9_Ref = object {
  _Leaf1B5_1B5_2B5_1B9
  scale 0.7
  rotate <0.0, 47.17173, 320.810486>
  translate  <-4.65038, 3.34635, 12.87015>
}
#declare _Leaf1B5_1B5_2B5_1B10_Ref = object {
  _Leaf1B5_1B5_2B5_1B10
  scale 0.7
  rotate <0.0, 14.22632, 153.264557>
  translate  <-4.7734, 3.4077, 13.01588>
}
#declare _Leaf1B5_1B5_2B5_1B11_Ref = object {
  _Leaf1B5_1B5_2B5_1B11
  scale 0.7
  rotate <0.0, 52.058369, 97.086281>
  translate  <-4.77382, 3.41697, 13.01215>
}
#declare _Leaf1B5_1B5_2B5_1B12_Ref = object {
  _Leaf1B5_1B5_2B5_1B12
  scale 0.7
  rotate <0.0, 104.057571, 99.117828>
  translate  <-4.78063, 3.41925, 13.00519>
}
#declare _Leaf1B5_1B5_1B1_1B1_Ref = object {
  _Leaf1B5_1B5_1B1_1B1
  scale 0.7
  rotate <0.0, 103.494408, 157.290985>
  translate  <-2.18366, 2.15998, 9.55091>
}
#declare _Leaf1B5_1B5_1B1_1B2_Ref = object {
  _Leaf1B5_1B5_1B1_1B2
  scale 0.7
  rotate <0.0, 125.143509, 199.047821>
  translate  <-2.38258, 2.13485, 9.57128>
}
#declare _Leaf1B5_1B5_1B1_1B3_Ref = object {
  _Leaf1B5_1B5_1B1_1B3
  scale 0.7
  rotate <0.0, 53.63179, 101.727478>
  translate  <-2.47752, 2.15169, 9.6238>
}
#declare _Leaf1B5_1B5_1B1_1B4_Ref = object {
  _Leaf1B5_1B5_1B1_1B4
  scale 0.7
  rotate <0.0, 108.517281, 49.896351>
  translate  <-2.47941, 2.16521, 9.60656>
}
#declare _Leaf1B5_1B5_1B1_1B5_Ref = object {
  _Leaf1B5_1B5_1B1_1B5
  scale 0.7
  rotate <0.0, 97.909332, 269.248688>
  translate  <-2.57938, 2.12277, 9.61143>
}
#declare _Leaf1B5_1B5_1B1_1B6_Ref = object {
  _Leaf1B5_1B5_1B1_1B6
  scale 0.7
  rotate <0.0, 42.892811, 231.607086>
  translate  <-2.87594, 2.13242, 9.65958>
}
#declare _Leaf1B5_1B5_1B1_1B7_Ref = object {
  _Leaf1B5_1B5_1B1_1B7
  scale 0.7
  rotate <0.0, 148.072968, 237.671188>
  translate  <-2.97831, 2.13672, 9.64313>
}
#declare _Leaf1B5_1B5_1B1_1B8_Ref = object {
  _Leaf1B5_1B5_1B1_1B8
  scale 0.7
  rotate <0.0, 166.294525, 144.521683>
  translate  <-3.17699, 2.14385, 9.66629>
}
#declare _Leaf1B5_1B5_1B1_1B9_Ref = object {
  _Leaf1B5_1B5_1B1_1B9
  scale 0.7
  rotate <0.0, 23.72687, 284.345917>
  translate  <-3.1751, 2.13036, 9.68348>
}
#declare _Leaf1B5_1B5_1B1_1B10_Ref = object {
  _Leaf1B5_1B5_1B1_1B10
  scale 0.7
  rotate <0.0, 54.16951, 185.005707>
  translate  <-3.37341, 2.14034, 9.7101>
}
#declare _Leaf1B5_1B5_1B1_1B11_Ref = object {
  _Leaf1B5_1B5_1B1_1B11
  scale 0.7
  rotate <0.0, 69.50174, 136.072205>
  translate  <-3.37383, 2.14961, 9.70637>
}
#declare _Leaf1B5_1B5_1B1_1B12_Ref = object {
  _Leaf1B5_1B5_1B1_1B12
  scale 0.7
  rotate <0.0, 110.415123, 103.205948>
  translate  <-3.3749, 2.15099, 9.69652>
}
#declare _Leaf1B5_1B5_1B2_1B1_Ref = object {
  _Leaf1B5_1B5_1B2_1B1
  scale 0.7
  rotate <0.0, 54.587479, 61.142231>
  translate  <-2.16169, 2.55455, 10.0662>
}
#declare _Leaf1B5_1B5_1B2_1B2_Ref = object {
  _Leaf1B5_1B5_1B2_1B2
  scale 0.7
  rotate <0.0, 97.783707, 64.676239>
  translate  <-2.18609, 2.74252, 10.13466>
}
#declare _Leaf1B5_1B5_1B2_1B3_Ref = object {
  _Leaf1B5_1B5_1B2_1B3
  scale 0.7
  rotate <0.0, 17.920019, 231.121765>
  translate  <-2.22401, 2.81474, 10.20816>
}
#declare _Leaf1B5_1B5_1B2_1B4_Ref = object {
  _Leaf1B5_1B5_1B2_1B4
  scale 0.7
  rotate <0.0, 77.319206, 306.720673>
  translate  <-2.20258, 2.81404, 10.21311>
}
#declare _Leaf1B5_1B5_1B2_1B5_Ref = object {
  _Leaf1B5_1B5_1B2_1B5
  scale 0.7
  rotate <0.0, 149.637146, 126.47184>
  translate  <-2.2228, 2.92058, 10.2209>
}
#declare _Leaf1B5_1B5_1B2_1B6_Ref = object {
  _Leaf1B5_1B5_1B2_1B6
  scale 0.7
  rotate <0.0, 88.405533, 151.716675>
  translate  <-2.25501, 3.18031, 10.36876>
}
#declare _Leaf1B5_1B5_1B2_1B7_Ref = object {
  _Leaf1B5_1B5_1B2_1B7
  scale 0.7
  rotate <0.0, 126.3032, 43.832081>
  translate  <-2.23585, 3.27472, 10.40734>
}
#declare _Leaf1B5_1B5_1B2_1B8_Ref = object {
  _Leaf1B5_1B5_1B2_1B8
  scale 0.7
  rotate <0.0, 101.430557, 16.281639>
  translate  <-2.24892, 3.44988, 10.50329>
}
#declare _Leaf1B5_1B5_1B2_1B9_Ref = object {
  _Leaf1B5_1B5_1B2_1B9
  scale 0.7
  rotate <0.0, 89.626091, 184.925858>
  translate  <-2.27028, 3.45058, 10.49835>
}
#declare _Leaf1B5_1B5_1B2_1B10_Ref = object {
  _Leaf1B5_1B5_1B2_1B10
  scale 0.7
  rotate <0.0, 59.65593, 128.693054>
  translate  <-2.28526, 3.62379, 10.59788>
}
#declare _Leaf1B5_1B5_1B2_1B11_Ref = object {
  _Leaf1B5_1B5_1B2_1B11
  scale 0.7
  rotate <0.0, 18.51811, 93.809464>
  translate  <-2.27791, 3.62126, 10.60416>
}
#declare _Leaf1B5_1B5_1B2_1B12_Ref = object {
  _Leaf1B5_1B5_1B2_1B12
  scale 0.7
  rotate <0.0, 45.880138, 352.44574>
  translate  <-2.2684, 3.62324, 10.60178>
}
#declare _Leaf1B5_1B5_1B3_1B1_Ref = object {
  _Leaf1B5_1B5_1B3_1B1
  scale 0.7
  rotate <0.0, 48.834702, 252.503357>
  translate  <-2.28917, 2.22004, 10.35525>
}
#declare _Leaf1B5_1B5_1B3_1B2_Ref = object {
  _Leaf1B5_1B5_1B3_1B2
  scale 0.7
  rotate <0.0, 59.441292, 305.20517>
  translate  <-2.26973, 2.16087, 10.54691>
}
#declare _Leaf1B5_1B5_1B3_1B3_Ref = object {
  _Leaf1B5_1B5_1B3_1B3
  scale 0.7
  rotate <0.0, 74.724983, 172.895035>
  translate  <-2.30418, 2.15689, 10.65108>
}
#declare _Leaf1B5_1B5_1B3_1B4_Ref = object {
  _Leaf1B5_1B5_1B3_1B4
  scale 0.7
  rotate <0.0, 142.294678, 206.399429>
  translate  <-2.30948, 2.13683, 10.64378>
}
#declare _Leaf1B5_1B5_1B3_1B5_Ref = object {
  _Leaf1B5_1B5_1B3_1B5
  scale 0.7
  rotate <0.0, 83.689812, 14.85283>
  translate  <-2.27029, 2.11392, 10.74257>
}
#declare _Leaf1B5_1B5_1B3_1B6_Ref = object {
  _Leaf1B5_1B5_1B3_1B6
  scale 0.7
  rotate <0.0, 40.709839, 72.208237>
  translate  <-2.29157, 2.02254, 11.02816>
}
#declare _Leaf1B5_1B5_1B3_1B7_Ref = object {
  _Leaf1B5_1B5_1B3_1B7
  scale 0.7
  rotate <0.0, 90.902573, 319.483398>
  translate  <-2.28635, 1.96349, 11.11333>
}
#declare _Leaf1B5_1B5_1B3_1B8_Ref = object {
  _Leaf1B5_1B5_1B3_1B8
  scale 0.7
  rotate <0.0, 103.68737, 286.396057>
  translate  <-2.2975, 1.89454, 11.30089>
}
#declare _Leaf1B5_1B5_1B3_1B9_Ref = object {
  _Leaf1B5_1B5_1B3_1B9
  scale 0.7
  rotate <0.0, 70.280922, 91.144302>
  translate  <-2.29222, 1.91455, 11.30818>
}
#declare _Leaf1B5_1B5_1B3_1B10_Ref = object {
  _Leaf1B5_1B5_1B3_1B10
  scale 0.7
  rotate <0.0, 12.85944, 133.825851>
  translate  <-2.30739, 1.84753, 11.49636>
}
#declare _Leaf1B5_1B5_1B3_1B11_Ref = object {
  _Leaf1B5_1B5_1B3_1B11
  scale 0.7
  rotate <0.0, 49.541031, 198.943527>
  translate  <-2.31433, 1.8408, 11.4938>
}
#declare _Leaf1B5_1B5_1B3_1B12_Ref = object {
  _Leaf1B5_1B5_1B3_1B12
  scale 0.7
  rotate <0.0, 95.038528, 226.461655>
  translate  <-2.31156, 1.83173, 11.49061>
}
#declare _Leaf1B5_1B6_2B1_1B1_Ref = object {
  _Leaf1B5_1B6_2B1_1B1
  scale 0.7
  rotate <0.0, 61.64798, 6.5508>
  translate  <-1.30254, 2.48773, 11.63521>
}
#declare _Leaf1B5_1B6_2B1_1B2_Ref = object {
  _Leaf1B5_1B6_2B1_1B2
  scale 0.7
  rotate <0.0, 95.807831, 34.202179>
  translate  <-1.19104, 2.61036, 11.74985>
}
#declare _Leaf1B5_1B6_2B1_1B3_Ref = object {
  _Leaf1B5_1B6_2B1_1B3
  scale 0.7
  rotate <0.0, 32.8787, 265.152649>
  translate  <-1.15776, 2.64817, 11.84741>
}
#declare _Leaf1B5_1B6_2B1_1B4_Ref = object {
  _Leaf1B5_1B6_2B1_1B4
  scale 0.7
  rotate <0.0, 106.194443, 271.861359>
  translate  <-1.14064, 2.63579, 11.84126>
}
#declare _Leaf1B5_1B6_2B1_1B5_Ref = object {
  _Leaf1B5_1B6_2B1_1B5
  scale 0.7
  rotate <0.0, 119.354179, 103.682983>
  translate  <-1.09024, 2.72261, 11.88301>
}
#declare _Leaf1B5_1B6_2B1_1B6_Ref = object {
  _Leaf1B5_1B6_2B1_1B6
  scale 0.7
  rotate <0.0, 56.260471, 117.010384>
  translate  <-0.92136, 2.86654, 12.08579>
}
#declare _Leaf1B5_1B6_2B1_1B7_Ref = object {
  _Leaf1B5_1B6_2B1_1B7
  scale 0.7
  rotate <0.0, 130.058685, 35.465389>
  translate  <-0.84043, 2.9122, 12.132>
}
#declare _Leaf1B5_1B6_2B1_1B8_Ref = object {
  _Leaf1B5_1B6_2B1_1B8
  scale 0.7
  rotate <0.0, 123.291107, 352.009613>
  translate  <-0.72094, 3.00718, 12.26146>
}
#declare _Leaf1B5_1B6_2B1_1B9_Ref = object {
  _Leaf1B5_1B6_2B1_1B9
  scale 0.7
  rotate <0.0, 62.72274, 155.066833>
  translate  <-0.738, 3.01953, 12.26759>
}
#declare _Leaf1B5_1B6_2B1_1B10_Ref = object {
  _Leaf1B5_1B6_2B1_1B10
  scale 0.7
  rotate <0.0, 32.263809, 76.669868>
  translate  <-0.62021, 3.1122, 12.40052>
}
#declare _Leaf1B5_1B6_2B1_1B11_Ref = object {
  _Leaf1B5_1B6_2B1_1B11
  scale 0.7
  rotate <0.0, 27.277731, 335.430176>
  translate  <-0.61452, 3.10406, 12.40173>
}
#declare _Leaf1B5_1B6_2B1_1B12_Ref = object {
  _Leaf1B5_1B6_2B1_1B12
  scale 0.7
  rotate <0.0, 76.785759, 312.867462>
  translate  <-0.60673, 3.10245, 12.39567>
}
#declare _Leaf1B5_1B6_2B2_1B1_Ref = object {
  _Leaf1B5_1B6_2B2_1B1
  scale 0.7
  rotate <0.0, 58.055149, 271.58313>
  translate  <-1.417, 2.20669, 12.06227>
}
#declare _Leaf1B5_1B6_2B2_1B2_Ref = object {
  _Leaf1B5_1B6_2B2_1B2
  scale 0.7
  rotate <0.0, 88.013588, 304.842072>
  translate  <-1.31463, 2.1025, 12.20112>
}
#declare _Leaf1B5_1B6_2B2_1B3_Ref = object {
  _Leaf1B5_1B6_2B2_1B3
  scale 0.7
  rotate <0.0, 42.63324, 173.09256>
  translate  <-1.29334, 2.07458, 12.30515>
}
#declare _Leaf1B5_1B6_2B2_1B4_Ref = object {
  _Leaf1B5_1B6_2B2_1B4
  scale 0.7
  rotate <0.0, 115.551514, 183.579956>
  translate  <-1.30448, 2.05704, 12.29793>
}
#declare _Leaf1B5_1B6_2B2_1B5_Ref = object {
  _Leaf1B5_1B6_2B2_1B5
  scale 0.7
  rotate <0.0, 110.721184, 11.80335>
  translate  <-1.22559, 2.00981, 12.35594>
}
#declare _Leaf1B5_1B6_2B2_1B6_Ref = object {
  _Leaf1B5_1B6_2B2_1B6
  scale 0.7
  rotate <0.0, 49.469608, 32.96796>
  translate  <-1.11658, 1.85297, 12.58806>
}
#declare _Leaf1B5_1B6_2B2_1B7_Ref = object {
  _Leaf1B5_1B6_2B2_1B7
  scale 0.7
  rotate <0.0, 121.922623, 310.06958>
  translate  <-1.07892, 1.775, 12.64524>
}
#declare _Leaf1B5_1B6_2B2_1B8_Ref = object {
  _Leaf1B5_1B6_2B2_1B8
  scale 0.7
  rotate <0.0, 121.157761, 268.581635>
  translate  <-1.00624, 1.66324, 12.79454>
}
#declare _Leaf1B5_1B6_2B2_1B9_Ref = object {
  _Leaf1B5_1B6_2B2_1B9
  scale 0.7
  rotate <0.0, 61.8433, 70.716873>
  translate  <-0.99513, 1.68074, 12.80174>
}
#declare _Leaf1B5_1B6_2B2_1B10_Ref = object {
  _Leaf1B5_1B6_2B2_1B10
  scale 0.7
  rotate <0.0, 22.35688, 348.695374>
  translate  <-0.92531, 1.57083, 12.95398>
}
#declare _Leaf1B5_1B6_2B2_1B11_Ref = object {
  _Leaf1B5_1B6_2B2_1B11
  scale 0.7
  rotate <0.0, 30.071779, 228.288437>
  translate  <-0.93352, 1.56512, 12.95413>
}
#declare _Leaf1B5_1B6_2B2_1B12_Ref = object {
  _Leaf1B5_1B6_2B2_1B12
  scale 0.7
  rotate <0.0, 81.866386, 221.685287>
  translate  <-0.93408, 1.55701, 12.9483>
}
#declare _Leaf1B5_1B6_2B3_1B1_Ref = object {
  _Leaf1B5_1B6_2B3_1B1
  scale 0.7
  rotate <0.0, 70.832558, 94.435738>
  translate  <-1.68511, 2.68503, 12.59916>
}
#declare _Leaf1B5_1B6_2B3_1B2_Ref = object {
  _Leaf1B5_1B6_2B3_1B2
  scale 0.7
  rotate <0.0, 101.985313, 124.992157>
  translate  <-1.80133, 2.81533, 12.69978>
}
#declare _Leaf1B5_1B6_2B3_1B3_Ref = object {
  _Leaf1B5_1B6_2B3_1B3
  scale 0.7
  rotate <0.0, 36.122742, 8.47213>
  translate  <-1.83399, 2.86468, 12.79227>
}
#declare _Leaf1B5_1B6_2B3_1B4_Ref = object {
  _Leaf1B5_1B6_2B3_1B4
  scale 0.7
  rotate <0.0, 109.137909, 358.39566>
  translate  <-1.82188, 2.8804, 12.78276>
}
#declare _Leaf1B5_1B6_2B3_1B5_Ref = object {
  _Leaf1B5_1B6_2B3_1B5
  scale 0.7
  rotate <0.0, 113.982208, 197.46582>
  translate  <-1.90628, 2.938, 12.8199>
}
#declare _Leaf1B5_1B6_2B3_1B6_Ref = object {
  _Leaf1B5_1B6_2B3_1B6
  scale 0.7
  rotate <0.0, 49.721008, 200.906555>
  translate  <-2.03907, 3.13968, 12.99893>
}
#declare _Leaf1B5_1B6_2B3_1B7_Ref = object {
  _Leaf1B5_1B6_2B3_1B7
  scale 0.7
  rotate <0.0, 135.61908, 132.710602>
  translate  <-2.08204, 3.22764, 13.03335>
}
#declare _Leaf1B5_1B6_2B3_1B8_Ref = object {
  _Leaf1B5_1B6_2B3_1B8
  scale 0.7
  rotate <0.0, 133.0961, 82.868851>
  translate  <-2.16986, 3.36795, 13.14587>
}
#declare _Leaf1B5_1B6_2B3_1B9_Ref = object {
  _Leaf1B5_1B6_2B3_1B9
  scale 0.7
  rotate <0.0, 52.89307, 243.699066>
  translate  <-2.18194, 3.35227, 13.15535>
}
#declare _Leaf1B5_1B6_2B3_1B10_Ref = object {
  _Leaf1B5_1B6_2B3_1B10
  scale 0.7
  rotate <0.0, 33.01403, 150.674072>
  translate  <-2.26729, 3.49145, 13.27145>
}
#declare _Leaf1B5_1B6_2B3_1B11_Ref = object {
  _Leaf1B5_1B6_2B3_1B11
  scale 0.7
  rotate <0.0, 37.14917, 66.869629>
  translate  <-2.25908, 3.49715, 13.27131>
}
#declare _Leaf1B5_1B6_2B3_1B12_Ref = object {
  _Leaf1B5_1B6_2B3_1B12
  scale 0.7
  rotate <0.0, 85.407173, 43.212608>
  translate  <-2.25775, 3.50382, 13.26397>
}
#declare _Leaf1B5_1B6_2B4_1B1_Ref = object {
  _Leaf1B5_1B6_2B4_1B1
  scale 0.7
  rotate <0.0, 67.50856, 180.427856>
  translate  <-1.78808, 2.38234, 12.82772>
}
#declare _Leaf1B5_1B6_2B4_1B2_Ref = object {
  _Leaf1B5_1B6_2B4_1B2
  scale 0.7
  rotate <0.0, 94.117729, 215.421753>
  translate  <-1.91344, 2.28583, 12.95255>
}
#declare _Leaf1B5_1B6_2B4_1B3_Ref = object {
  _Leaf1B5_1B6_2B4_1B3
  scale 0.7
  rotate <0.0, 45.280338, 93.504181>
  translate  <-1.95809, 2.26945, 13.05151>
}
#declare _Leaf1B5_1B6_2B4_1B4_Ref = object {
  _Leaf1B5_1B6_2B4_1B4
  scale 0.7
  rotate <0.0, 118.702873, 89.168266>
  translate  <-1.97424, 2.28001, 13.04094>
}
#declare _Leaf1B5_1B6_2B4_1B5_Ref = object {
  _Leaf1B5_1B6_2B4_1B5
  scale 0.7
  rotate <0.0, 105.668228, 285.059448>
  translate  <-2.03014, 2.20356, 13.09434>
}
#declare _Leaf1B5_1B6_2B4_1B6_Ref = object {
  _Leaf1B5_1B6_2B4_1B6
  scale 0.7
  rotate <0.0, 42.188179, 296.786499>
  translate  <-2.22281, 2.10446, 13.3027>
}
#declare _Leaf1B5_1B6_2B4_1B7_Ref = object {
  _Leaf1B5_1B6_2B4_1B7
  scale 0.7
  rotate <0.0, 126.863251, 226.430573>
  translate  <-2.30904, 2.06879, 13.3481>
}
#declare _Leaf1B5_1B6_2B4_1B8_Ref = object {
  _Leaf1B5_1B6_2B4_1B8
  scale 0.7
  rotate <0.0, 130.671936, 181.112717>
  translate  <-2.44368, 2.00237, 13.48046>
}
#declare _Leaf1B5_1B6_2B4_1B9_Ref = object {
  _Leaf1B5_1B6_2B4_1B9
  scale 0.7
  rotate <0.0, 51.91045, 340.907623>
  translate  <-2.42758, 1.99184, 13.49101>
}
#declare _Leaf1B5_1B6_2B4_1B10_Ref = object {
  _Leaf1B5_1B6_2B4_1B10
  scale 0.7
  rotate <0.0, 23.397699, 235.46875>
  translate  <-2.56091, 1.92843, 13.62642>
}
#declare _Leaf1B5_1B6_2B4_1B11_Ref = object {
  _Leaf1B5_1B6_2B4_1B11
  scale 0.7
  rotate <0.0, 39.315498, 144.063171>
  translate  <-2.56659, 1.93657, 13.62521>
}
#declare _Leaf1B5_1B6_2B4_1B12_Ref = object {
  _Leaf1B5_1B6_2B4_1B12
  scale 0.7
  rotate <0.0, 90.403183, 132.464035>
  translate  <-2.57362, 1.93674, 13.6181>
}
#declare _Leaf1B5_1B6_2B5_1B1_Ref = object {
  _Leaf1B5_1B6_2B5_1B1
  scale 0.7
  rotate <0.0, 27.591459, 221.786392>
  translate  <-1.61482, 2.52168, 13.24284>
}
#declare _Leaf1B5_1B6_2B5_1B2_Ref = object {
  _Leaf1B5_1B6_2B5_1B2
  scale 0.7
  rotate <0.0, 38.021339, 305.893738>
  translate  <-1.60194, 2.54777, 13.44226>
}
#declare _Leaf1B5_1B6_2B5_1B3_Ref = object {
  _Leaf1B5_1B6_2B5_1B3
  scale 0.7
  rotate <0.0, 82.508911, 156.071198>
  translate  <-1.63344, 2.59549, 13.53599>
}
#declare _Leaf1B5_1B6_2B5_1B4_Ref = object {
  _Leaf1B5_1B6_2B5_1B4
  scale 0.7
  rotate <0.0, 129.163712, 217.651062>
  translate  <-1.64283, 2.57566, 13.53761>
}
#declare _Leaf1B5_1B6_2B5_1B5_Ref = object {
  _Leaf1B5_1B6_2B5_1B5
  scale 0.7
  rotate <0.0, 87.246498, 5.02021>
  translate  <-1.60612, 2.59021, 13.63891>
}
#declare _Leaf1B5_1B6_2B5_1B6_Ref = object {
  _Leaf1B5_1B6_2B5_1B6
  scale 0.7
  rotate <0.0, 64.373268, 67.778877>
  translate  <-1.6368, 2.6359, 13.93443>
}
#declare _Leaf1B5_1B6_2B5_1B7_Ref = object {
  _Leaf1B5_1B6_2B5_1B7
  scale 0.7
  rotate <0.0, 72.118736, 310.244843>
  translate  <-1.64094, 2.61922, 14.03677>
}
#declare _Leaf1B5_1B6_2B5_1B8_Ref = object {
  _Leaf1B5_1B6_2B5_1B8
  scale 0.7
  rotate <0.0, 78.534683, 274.461304>
  translate  <-1.66011, 2.6408, 14.23482>
}
#declare _Leaf1B5_1B6_2B5_1B9_Ref = object {
  _Leaf1B5_1B6_2B5_1B9
  scale 0.7
  rotate <0.0, 95.533669, 79.653801>
  translate  <-1.65074, 2.66057, 14.23321>
}
#declare _Leaf1B5_1B6_2B5_1B10_Ref = object {
  _Leaf1B5_1B6_2B5_1B10
  scale 0.7
  rotate <0.0, 36.56813, 98.737579>
  translate  <-1.67344, 2.68489, 14.43076>
}
#declare _Leaf1B5_1B6_2B5_1B11_Ref = object {
  _Leaf1B5_1B6_2B5_1B11
  scale 0.7
  rotate <0.0, 49.583271, 164.921402>
  translate  <-1.68165, 2.67918, 14.43091>
}
#declare _Leaf1B5_1B6_2B5_1B12_Ref = object {
  _Leaf1B5_1B6_2B5_1B12
  scale 0.7
  rotate <0.0, 79.23011, 213.580734>
  translate  <-1.68083, 2.66928, 14.43204>
}
#declare _Leaf1B5_1B6_1B1_1B1_Ref = object {
  _Leaf1B5_1B6_1B1_1B1
  scale 0.7
  rotate <0.0, 53.099369, 269.349823>
  translate  <-1.20896, 1.85501, 10.03018>
}
#declare _Leaf1B5_1B6_1B1_1B2_Ref = object {
  _Leaf1B5_1B6_1B1_1B2
  scale 0.7
  rotate <0.0, 82.014236, 304.931305>
  translate  <-1.11517, 1.76353, 10.18331>
}
#declare _Leaf1B5_1B6_1B1_1B3_Ref = object {
  _Leaf1B5_1B6_1B1_1B3
  scale 0.7
  rotate <0.0, 46.795399, 168.80719>
  translate  <-1.10017, 1.74472, 10.29044>
}
#declare _Leaf1B5_1B6_1B1_1B4_Ref = object {
  _Leaf1B5_1B6_1B1_1B4
  scale 0.7
  rotate <0.0, 118.541237, 186.32753>
  translate  <-1.11088, 1.72658, 10.2841>
}
#declare _Leaf1B5_1B6_1B1_1B5_Ref = object {
  _Leaf1B5_1B6_1B1_1B5
  scale 0.7
  rotate <0.0, 108.284828, 9.94797>
  translate  <-1.03564, 1.68482, 10.35055>
}
#declare _Leaf1B5_1B6_1B1_1B6_Ref = object {
  _Leaf1B5_1B6_1B1_1B6
  scale 0.7
  rotate <0.0, 49.549709, 38.18465>
  translate  <-0.94085, 1.54892, 10.60136>
}
#declare _Leaf1B5_1B6_1B1_1B7_Ref = object {
  _Leaf1B5_1B6_1B1_1B7
  scale 0.7
  rotate <0.0, 115.947449, 309.860046>
  translate  <-0.90675, 1.47629, 10.66717>
}
#declare _Leaf1B5_1B6_1B1_1B8_Ref = object {
  _Leaf1B5_1B6_1B1_1B8
  scale 0.7
  rotate <0.0, 116.255562, 270.567627>
  translate  <-0.84324, 1.37805, 10.82957>
}
#declare _Leaf1B5_1B6_1B1_1B9_Ref = object {
  _Leaf1B5_1B6_1B1_1B9
  scale 0.7
  rotate <0.0, 65.46785, 73.176231>
  translate  <-0.83256, 1.39615, 10.83589>
}
#declare _Leaf1B5_1B6_1B1_1B10_Ref = object {
  _Leaf1B5_1B6_1B1_1B10
  scale 0.7
  rotate <0.0, 18.486139, 1.18601>
  translate  <-0.77207, 1.29998, 11.0009>
}
#declare _Leaf1B5_1B6_1B1_1B11_Ref = object {
  _Leaf1B5_1B6_1B1_1B11
  scale 0.7
  rotate <0.0, 29.202311, 217.918274>
  translate  <-0.78028, 1.29428, 11.00105>
}
#declare _Leaf1B5_1B6_1B1_1B12_Ref = object {
  _Leaf1B5_1B6_1B1_1B12
  scale 0.7
  rotate <0.0, 81.189484, 220.885117>
  translate  <-0.7805, 1.2857, 10.99591>
}
#declare _Leaf1B5_1B6_1B2_1B1_Ref = object {
  _Leaf1B5_1B6_1B2_1B1
  scale 0.7
  rotate <0.0, 75.586777, 150.850403>
  translate  <-1.61942, 2.1536, 10.43523>
}
#declare _Leaf1B5_1B6_1B2_1B2_Ref = object {
  _Leaf1B5_1B6_1B2_1B2
  scale 0.7
  rotate <0.0, 100.609528, 186.526794>
  translate  <-1.79014, 2.13962, 10.5414>
}
#declare _Leaf1B5_1B6_1B2_1B3_Ref = object {
  _Leaf1B5_1B6_1B2_1B3
  scale 0.7
  rotate <0.0, 46.444069, 71.764091>
  translate  <-1.84869, 2.15418, 10.63314>
}
#declare _Leaf1B5_1B6_1B2_1B4_Ref = object {
  _Leaf1B5_1B6_1B2_1B4
  scale 0.7
  rotate <0.0, 118.395088, 55.248569>
  translate  <-1.85611, 2.17049, 10.62037>
}
#declare _Leaf1B5_1B6_1B2_1B5_Ref = object {
  _Leaf1B5_1B6_1B2_1B5
  scale 0.7
  rotate <0.0, 103.313393, 257.542419>
  translate  <-1.94843, 2.13503, 10.66555>
}
#declare _Leaf1B5_1B6_1B2_1B6_Ref = object {
  _Leaf1B5_1B6_1B2_1B6
  scale 0.7
  rotate <0.0, 38.978699, 258.581757>
  translate  <-2.18855, 2.15758, 10.84498>
}
#declare _Leaf1B5_1B6_1B2_1B7_Ref = object {
  _Leaf1B5_1B6_1B2_1B7
  scale 0.7
  rotate <0.0, 132.085297, 202.007584>
  translate  <-2.28593, 2.17182, 10.87788>
}
#declare _Leaf1B5_1B6_1B2_1B8_Ref = object {
  _Leaf1B5_1B6_1B2_1B8
  scale 0.7
  rotate <0.0, 138.746613, 151.890015>
  translate  <-2.45073, 2.18909, 10.99014>
}
#declare _Leaf1B5_1B6_1B2_1B9_Ref = object {
  _Leaf1B5_1B6_1B2_1B9
  scale 0.7
  rotate <0.0, 44.288181, 308.971252>
  translate  <-2.44333, 2.17283, 11.00287>
}
#declare _Leaf1B5_1B6_1B2_1B10_Ref = object {
  _Leaf1B5_1B6_1B2_1B10
  scale 0.7
  rotate <0.0, 28.632839, 193.227921>
  translate  <-2.60587, 2.1923, 11.11833>
}
#declare _Leaf1B5_1B6_1B2_1B11_Ref = object {
  _Leaf1B5_1B6_1B2_1B11
  scale 0.7
  rotate <0.0, 46.123119, 119.282997>
  translate  <-2.60661, 2.20206, 11.11631>
}
#declare _Leaf1B5_1B6_1B2_1B12_Ref = object {
  _Leaf1B5_1B6_1B2_1B12
  scale 0.7
  rotate <0.0, 95.934708, 102.618752>
  translate  <-2.61172, 2.20514, 11.10829>
}
#declare _Leaf1B5_1B6_1B3_1B1_Ref = object {
  _Leaf1B5_1B6_1B3_1B1
  scale 0.7
  rotate <0.0, 65.588577, 39.368408>
  translate  <-1.28227, 2.39649, 10.63277>
}
#declare _Leaf1B5_1B6_1B3_1B2_Ref = object {
  _Leaf1B5_1B6_1B3_1B2
  scale 0.7
  rotate <0.0, 102.096802, 63.259949>
  translate  <-1.2475, 2.57169, 10.72609>
}
#declare _Leaf1B5_1B6_1B3_1B3_Ref = object {
  _Leaf1B5_1B6_1B3_1B3
  scale 0.7
  rotate <0.0, 25.949169, 299.657043>
  translate  <-1.23855, 2.63318, 10.81662>
}
#declare _Leaf1B5_1B6_1B3_1B4_Ref = object {
  _Leaf1B5_1B6_1B3_1B4
  scale 0.7
  rotate <0.0, 99.472992, 300.819458>
  translate  <-1.21748, 2.63014, 10.81109>
}
#declare _Leaf1B5_1B6_1B3_1B5_Ref = object {
  _Leaf1B5_1B6_1B3_1B5
  scale 0.7
  rotate <0.0, 125.137207, 136.323166>
  translate  <-1.21715, 2.73506, 10.83958>
}
#declare _Leaf1B5_1B6_1B3_1B6_Ref = object {
  _Leaf1B5_1B6_1B3_1B6
  scale 0.7
  rotate <0.0, 61.130741, 143.269714>
  translate  <-1.14421, 2.96818, 11.01479>
}
#declare _Leaf1B5_1B6_1B3_1B7_Ref = object {
  _Leaf1B5_1B6_1B3_1B7
  scale 0.7
  rotate <0.0, 136.329697, 61.384949>
  translate  <-1.09706, 3.05324, 11.05097>
}
#declare _Leaf1B5_1B6_1B3_1B8_Ref = object {
  _Leaf1B5_1B6_1B3_1B8
  scale 0.7
  rotate <0.0, 125.016937, 16.77836>
  translate  <-1.04187, 3.21047, 11.16185>
}
#declare _Leaf1B5_1B6_1B3_1B9_Ref = object {
  _Leaf1B5_1B6_1B3_1B9
  scale 0.7
  rotate <0.0, 63.111938, 180.948227>
  translate  <-1.06288, 3.2135, 11.16736>
}
#declare _Leaf1B5_1B6_1B3_1B10_Ref = object {
  _Leaf1B5_1B6_1B3_1B10
  scale 0.7
  rotate <0.0, 39.594582, 104.631813>
  translate  <-1.00808, 3.36834, 11.28204>
}
#declare _Leaf1B5_1B6_1B3_1B11_Ref = object {
  _Leaf1B5_1B6_1B3_1B11
  scale 0.7
  rotate <0.0, 28.105841, 19.249399>
  translate  <-0.99913, 3.36429, 11.28391>
}
#declare _Leaf1B5_1B6_1B3_1B12_Ref = object {
  _Leaf1B5_1B6_1B3_1B12
  scale 0.7
  rotate <0.0, 73.949509, 344.348755>
  translate  <-0.99148, 3.36595, 11.27769>
}
#declare ArbolA_Leafs = union {
  object { _Leaf1B1_1B1_2B1_1B1_Ref }
  object { _Leaf1B1_1B1_2B1_1B2_Ref }
  object { _Leaf1B1_1B1_2B1_1B3_Ref }
  object { _Leaf1B1_1B1_2B1_1B4_Ref }
  object { _Leaf1B1_1B1_2B1_1B5_Ref }
  object { _Leaf1B1_1B1_2B1_1B6_Ref }
  object { _Leaf1B1_1B1_2B1_1B7_Ref }
  object { _Leaf1B1_1B1_2B1_1B8_Ref }
  object { _Leaf1B1_1B1_2B1_1B9_Ref }
  object { _Leaf1B1_1B1_2B1_1B10_Ref }
  object { _Leaf1B1_1B1_2B1_1B11_Ref }
  object { _Leaf1B1_1B1_2B1_1B12_Ref }
  object { _Leaf1B1_1B1_2B2_1B1_Ref }
  object { _Leaf1B1_1B1_2B2_1B2_Ref }
  object { _Leaf1B1_1B1_2B2_1B3_Ref }
  object { _Leaf1B1_1B1_2B2_1B4_Ref }
  object { _Leaf1B1_1B1_2B2_1B5_Ref }
  object { _Leaf1B1_1B1_2B2_1B6_Ref }
  object { _Leaf1B1_1B1_2B2_1B7_Ref }
  object { _Leaf1B1_1B1_2B2_1B8_Ref }
  object { _Leaf1B1_1B1_2B2_1B9_Ref }
  object { _Leaf1B1_1B1_2B2_1B10_Ref }
  object { _Leaf1B1_1B1_2B2_1B11_Ref }
  object { _Leaf1B1_1B1_2B2_1B12_Ref }
  object { _Leaf1B1_1B1_2B3_1B1_Ref }
  object { _Leaf1B1_1B1_2B3_1B2_Ref }
  object { _Leaf1B1_1B1_2B3_1B3_Ref }
  object { _Leaf1B1_1B1_2B3_1B4_Ref }
  object { _Leaf1B1_1B1_2B3_1B5_Ref }
  object { _Leaf1B1_1B1_2B3_1B6_Ref }
  object { _Leaf1B1_1B1_2B3_1B7_Ref }
  object { _Leaf1B1_1B1_2B3_1B8_Ref }
  object { _Leaf1B1_1B1_2B3_1B9_Ref }
  object { _Leaf1B1_1B1_2B3_1B10_Ref }
  object { _Leaf1B1_1B1_2B3_1B11_Ref }
  object { _Leaf1B1_1B1_2B3_1B12_Ref }
  object { _Leaf1B1_1B1_2B4_1B1_Ref }
  object { _Leaf1B1_1B1_2B4_1B2_Ref }
  object { _Leaf1B1_1B1_2B4_1B3_Ref }
  object { _Leaf1B1_1B1_2B4_1B4_Ref }
  object { _Leaf1B1_1B1_2B4_1B5_Ref }
  object { _Leaf1B1_1B1_2B4_1B6_Ref }
  object { _Leaf1B1_1B1_2B4_1B7_Ref }
  object { _Leaf1B1_1B1_2B4_1B8_Ref }
  object { _Leaf1B1_1B1_2B4_1B9_Ref }
  object { _Leaf1B1_1B1_2B4_1B10_Ref }
  object { _Leaf1B1_1B1_2B4_1B11_Ref }
  object { _Leaf1B1_1B1_2B4_1B12_Ref }
  object { _Leaf1B1_1B1_2B5_1B1_Ref }
  object { _Leaf1B1_1B1_2B5_1B2_Ref }
  object { _Leaf1B1_1B1_2B5_1B3_Ref }
  object { _Leaf1B1_1B1_2B5_1B4_Ref }
  object { _Leaf1B1_1B1_2B5_1B5_Ref }
  object { _Leaf1B1_1B1_2B5_1B6_Ref }
  object { _Leaf1B1_1B1_2B5_1B7_Ref }
  object { _Leaf1B1_1B1_2B5_1B8_Ref }
  object { _Leaf1B1_1B1_2B5_1B9_Ref }
  object { _Leaf1B1_1B1_2B5_1B10_Ref }
  object { _Leaf1B1_1B1_2B5_1B11_Ref }
  object { _Leaf1B1_1B1_2B5_1B12_Ref }
  object { _Leaf1B1_1B1_1B1_1B1_Ref }
  object { _Leaf1B1_1B1_1B1_1B2_Ref }
  object { _Leaf1B1_1B1_1B1_1B3_Ref }
  object { _Leaf1B1_1B1_1B1_1B4_Ref }
  object { _Leaf1B1_1B1_1B1_1B5_Ref }
  object { _Leaf1B1_1B1_1B1_1B6_Ref }
  object { _Leaf1B1_1B1_1B1_1B7_Ref }
  object { _Leaf1B1_1B1_1B1_1B8_Ref }
  object { _Leaf1B1_1B1_1B1_1B9_Ref }
  object { _Leaf1B1_1B1_1B1_1B10_Ref }
  object { _Leaf1B1_1B1_1B1_1B11_Ref }
  object { _Leaf1B1_1B1_1B1_1B12_Ref }
  object { _Leaf1B1_1B1_1B2_1B1_Ref }
  object { _Leaf1B1_1B1_1B2_1B2_Ref }
  object { _Leaf1B1_1B1_1B2_1B3_Ref }
  object { _Leaf1B1_1B1_1B2_1B4_Ref }
  object { _Leaf1B1_1B1_1B2_1B5_Ref }
  object { _Leaf1B1_1B1_1B2_1B6_Ref }
  object { _Leaf1B1_1B1_1B2_1B7_Ref }
  object { _Leaf1B1_1B1_1B2_1B8_Ref }
  object { _Leaf1B1_1B1_1B2_1B9_Ref }
  object { _Leaf1B1_1B1_1B2_1B10_Ref }
  object { _Leaf1B1_1B1_1B2_1B11_Ref }
  object { _Leaf1B1_1B1_1B2_1B12_Ref }
  object { _Leaf1B1_1B1_1B3_1B1_Ref }
  object { _Leaf1B1_1B1_1B3_1B2_Ref }
  object { _Leaf1B1_1B1_1B3_1B3_Ref }
  object { _Leaf1B1_1B1_1B3_1B4_Ref }
  object { _Leaf1B1_1B1_1B3_1B5_Ref }
  object { _Leaf1B1_1B1_1B3_1B6_Ref }
  object { _Leaf1B1_1B1_1B3_1B7_Ref }
  object { _Leaf1B1_1B1_1B3_1B8_Ref }
  object { _Leaf1B1_1B1_1B3_1B9_Ref }
  object { _Leaf1B1_1B1_1B3_1B10_Ref }
  object { _Leaf1B1_1B1_1B3_1B11_Ref }
  object { _Leaf1B1_1B1_1B3_1B12_Ref }
  object { _Leaf1B1_1B2_2B1_1B1_Ref }
  object { _Leaf1B1_1B2_2B1_1B2_Ref }
  object { _Leaf1B1_1B2_2B1_1B3_Ref }
  object { _Leaf1B1_1B2_2B1_1B4_Ref }
  object { _Leaf1B1_1B2_2B1_1B5_Ref }
  object { _Leaf1B1_1B2_2B1_1B6_Ref }
  object { _Leaf1B1_1B2_2B1_1B7_Ref }
  object { _Leaf1B1_1B2_2B1_1B8_Ref }
  object { _Leaf1B1_1B2_2B1_1B9_Ref }
  object { _Leaf1B1_1B2_2B1_1B10_Ref }
  object { _Leaf1B1_1B2_2B1_1B11_Ref }
  object { _Leaf1B1_1B2_2B1_1B12_Ref }
  object { _Leaf1B1_1B2_2B2_1B1_Ref }
  object { _Leaf1B1_1B2_2B2_1B2_Ref }
  object { _Leaf1B1_1B2_2B2_1B3_Ref }
  object { _Leaf1B1_1B2_2B2_1B4_Ref }
  object { _Leaf1B1_1B2_2B2_1B5_Ref }
  object { _Leaf1B1_1B2_2B2_1B6_Ref }
  object { _Leaf1B1_1B2_2B2_1B7_Ref }
  object { _Leaf1B1_1B2_2B2_1B8_Ref }
  object { _Leaf1B1_1B2_2B2_1B9_Ref }
  object { _Leaf1B1_1B2_2B2_1B10_Ref }
  object { _Leaf1B1_1B2_2B2_1B11_Ref }
  object { _Leaf1B1_1B2_2B2_1B12_Ref }
  object { _Leaf1B1_1B2_2B3_1B1_Ref }
  object { _Leaf1B1_1B2_2B3_1B2_Ref }
  object { _Leaf1B1_1B2_2B3_1B3_Ref }
  object { _Leaf1B1_1B2_2B3_1B4_Ref }
  object { _Leaf1B1_1B2_2B3_1B5_Ref }
  object { _Leaf1B1_1B2_2B3_1B6_Ref }
  object { _Leaf1B1_1B2_2B3_1B7_Ref }
  object { _Leaf1B1_1B2_2B3_1B8_Ref }
  object { _Leaf1B1_1B2_2B3_1B9_Ref }
  object { _Leaf1B1_1B2_2B3_1B10_Ref }
  object { _Leaf1B1_1B2_2B3_1B11_Ref }
  object { _Leaf1B1_1B2_2B3_1B12_Ref }
  object { _Leaf1B1_1B2_2B4_1B1_Ref }
  object { _Leaf1B1_1B2_2B4_1B2_Ref }
  object { _Leaf1B1_1B2_2B4_1B3_Ref }
  object { _Leaf1B1_1B2_2B4_1B4_Ref }
  object { _Leaf1B1_1B2_2B4_1B5_Ref }
  object { _Leaf1B1_1B2_2B4_1B6_Ref }
  object { _Leaf1B1_1B2_2B4_1B7_Ref }
  object { _Leaf1B1_1B2_2B4_1B8_Ref }
  object { _Leaf1B1_1B2_2B4_1B9_Ref }
  object { _Leaf1B1_1B2_2B4_1B10_Ref }
  object { _Leaf1B1_1B2_2B4_1B11_Ref }
  object { _Leaf1B1_1B2_2B4_1B12_Ref }
  object { _Leaf1B1_1B2_2B5_1B1_Ref }
  object { _Leaf1B1_1B2_2B5_1B2_Ref }
  object { _Leaf1B1_1B2_2B5_1B3_Ref }
  object { _Leaf1B1_1B2_2B5_1B4_Ref }
  object { _Leaf1B1_1B2_2B5_1B5_Ref }
  object { _Leaf1B1_1B2_2B5_1B6_Ref }
  object { _Leaf1B1_1B2_2B5_1B7_Ref }
  object { _Leaf1B1_1B2_2B5_1B8_Ref }
  object { _Leaf1B1_1B2_2B5_1B9_Ref }
  object { _Leaf1B1_1B2_2B5_1B10_Ref }
  object { _Leaf1B1_1B2_2B5_1B11_Ref }
  object { _Leaf1B1_1B2_2B5_1B12_Ref }
  object { _Leaf1B1_1B2_1B1_1B1_Ref }
  object { _Leaf1B1_1B2_1B1_1B2_Ref }
  object { _Leaf1B1_1B2_1B1_1B3_Ref }
  object { _Leaf1B1_1B2_1B1_1B4_Ref }
  object { _Leaf1B1_1B2_1B1_1B5_Ref }
  object { _Leaf1B1_1B2_1B1_1B6_Ref }
  object { _Leaf1B1_1B2_1B1_1B7_Ref }
  object { _Leaf1B1_1B2_1B1_1B8_Ref }
  object { _Leaf1B1_1B2_1B1_1B9_Ref }
  object { _Leaf1B1_1B2_1B1_1B10_Ref }
  object { _Leaf1B1_1B2_1B1_1B11_Ref }
  object { _Leaf1B1_1B2_1B1_1B12_Ref }
  object { _Leaf1B1_1B2_1B2_1B1_Ref }
  object { _Leaf1B1_1B2_1B2_1B2_Ref }
  object { _Leaf1B1_1B2_1B2_1B3_Ref }
  object { _Leaf1B1_1B2_1B2_1B4_Ref }
  object { _Leaf1B1_1B2_1B2_1B5_Ref }
  object { _Leaf1B1_1B2_1B2_1B6_Ref }
  object { _Leaf1B1_1B2_1B2_1B7_Ref }
  object { _Leaf1B1_1B2_1B2_1B8_Ref }
  object { _Leaf1B1_1B2_1B2_1B9_Ref }
  object { _Leaf1B1_1B2_1B2_1B10_Ref }
  object { _Leaf1B1_1B2_1B2_1B11_Ref }
  object { _Leaf1B1_1B2_1B2_1B12_Ref }
  object { _Leaf1B1_1B2_1B3_1B1_Ref }
  object { _Leaf1B1_1B2_1B3_1B2_Ref }
  object { _Leaf1B1_1B2_1B3_1B3_Ref }
  object { _Leaf1B1_1B2_1B3_1B4_Ref }
  object { _Leaf1B1_1B2_1B3_1B5_Ref }
  object { _Leaf1B1_1B2_1B3_1B6_Ref }
  object { _Leaf1B1_1B2_1B3_1B7_Ref }
  object { _Leaf1B1_1B2_1B3_1B8_Ref }
  object { _Leaf1B1_1B2_1B3_1B9_Ref }
  object { _Leaf1B1_1B2_1B3_1B10_Ref }
  object { _Leaf1B1_1B2_1B3_1B11_Ref }
  object { _Leaf1B1_1B2_1B3_1B12_Ref }
  object { _Leaf1B1_1B3_2B1_1B1_Ref }
  object { _Leaf1B1_1B3_2B1_1B2_Ref }
  object { _Leaf1B1_1B3_2B1_1B3_Ref }
  object { _Leaf1B1_1B3_2B1_1B4_Ref }
  object { _Leaf1B1_1B3_2B1_1B5_Ref }
  object { _Leaf1B1_1B3_2B1_1B6_Ref }
  object { _Leaf1B1_1B3_2B1_1B7_Ref }
  object { _Leaf1B1_1B3_2B1_1B8_Ref }
  object { _Leaf1B1_1B3_2B1_1B9_Ref }
  object { _Leaf1B1_1B3_2B1_1B10_Ref }
  object { _Leaf1B1_1B3_2B1_1B11_Ref }
  object { _Leaf1B1_1B3_2B1_1B12_Ref }
  object { _Leaf1B1_1B3_2B2_1B1_Ref }
  object { _Leaf1B1_1B3_2B2_1B2_Ref }
  object { _Leaf1B1_1B3_2B2_1B3_Ref }
  object { _Leaf1B1_1B3_2B2_1B4_Ref }
  object { _Leaf1B1_1B3_2B2_1B5_Ref }
  object { _Leaf1B1_1B3_2B2_1B6_Ref }
  object { _Leaf1B1_1B3_2B2_1B7_Ref }
  object { _Leaf1B1_1B3_2B2_1B8_Ref }
  object { _Leaf1B1_1B3_2B2_1B9_Ref }
  object { _Leaf1B1_1B3_2B2_1B10_Ref }
  object { _Leaf1B1_1B3_2B2_1B11_Ref }
  object { _Leaf1B1_1B3_2B2_1B12_Ref }
  object { _Leaf1B1_1B3_2B3_1B1_Ref }
  object { _Leaf1B1_1B3_2B3_1B2_Ref }
  object { _Leaf1B1_1B3_2B3_1B3_Ref }
  object { _Leaf1B1_1B3_2B3_1B4_Ref }
  object { _Leaf1B1_1B3_2B3_1B5_Ref }
  object { _Leaf1B1_1B3_2B3_1B6_Ref }
  object { _Leaf1B1_1B3_2B3_1B7_Ref }
  object { _Leaf1B1_1B3_2B3_1B8_Ref }
  object { _Leaf1B1_1B3_2B3_1B9_Ref }
  object { _Leaf1B1_1B3_2B3_1B10_Ref }
  object { _Leaf1B1_1B3_2B3_1B11_Ref }
  object { _Leaf1B1_1B3_2B3_1B12_Ref }
  object { _Leaf1B1_1B3_2B4_1B1_Ref }
  object { _Leaf1B1_1B3_2B4_1B2_Ref }
  object { _Leaf1B1_1B3_2B4_1B3_Ref }
  object { _Leaf1B1_1B3_2B4_1B4_Ref }
  object { _Leaf1B1_1B3_2B4_1B5_Ref }
  object { _Leaf1B1_1B3_2B4_1B6_Ref }
  object { _Leaf1B1_1B3_2B4_1B7_Ref }
  object { _Leaf1B1_1B3_2B4_1B8_Ref }
  object { _Leaf1B1_1B3_2B4_1B9_Ref }
  object { _Leaf1B1_1B3_2B4_1B10_Ref }
  object { _Leaf1B1_1B3_2B4_1B11_Ref }
  object { _Leaf1B1_1B3_2B4_1B12_Ref }
  object { _Leaf1B1_1B3_2B5_1B1_Ref }
  object { _Leaf1B1_1B3_2B5_1B2_Ref }
  object { _Leaf1B1_1B3_2B5_1B3_Ref }
  object { _Leaf1B1_1B3_2B5_1B4_Ref }
  object { _Leaf1B1_1B3_2B5_1B5_Ref }
  object { _Leaf1B1_1B3_2B5_1B6_Ref }
  object { _Leaf1B1_1B3_2B5_1B7_Ref }
  object { _Leaf1B1_1B3_2B5_1B8_Ref }
  object { _Leaf1B1_1B3_2B5_1B9_Ref }
  object { _Leaf1B1_1B3_2B5_1B10_Ref }
  object { _Leaf1B1_1B3_2B5_1B11_Ref }
  object { _Leaf1B1_1B3_2B5_1B12_Ref }
  object { _Leaf1B1_1B3_1B1_1B1_Ref }
  object { _Leaf1B1_1B3_1B1_1B2_Ref }
  object { _Leaf1B1_1B3_1B1_1B3_Ref }
  object { _Leaf1B1_1B3_1B1_1B4_Ref }
  object { _Leaf1B1_1B3_1B1_1B5_Ref }
  object { _Leaf1B1_1B3_1B1_1B6_Ref }
  object { _Leaf1B1_1B3_1B1_1B7_Ref }
  object { _Leaf1B1_1B3_1B1_1B8_Ref }
  object { _Leaf1B1_1B3_1B1_1B9_Ref }
  object { _Leaf1B1_1B3_1B1_1B10_Ref }
  object { _Leaf1B1_1B3_1B1_1B11_Ref }
  object { _Leaf1B1_1B3_1B1_1B12_Ref }
  object { _Leaf1B1_1B3_1B2_1B1_Ref }
  object { _Leaf1B1_1B3_1B2_1B2_Ref }
  object { _Leaf1B1_1B3_1B2_1B3_Ref }
  object { _Leaf1B1_1B3_1B2_1B4_Ref }
  object { _Leaf1B1_1B3_1B2_1B5_Ref }
  object { _Leaf1B1_1B3_1B2_1B6_Ref }
  object { _Leaf1B1_1B3_1B2_1B7_Ref }
  object { _Leaf1B1_1B3_1B2_1B8_Ref }
  object { _Leaf1B1_1B3_1B2_1B9_Ref }
  object { _Leaf1B1_1B3_1B2_1B10_Ref }
  object { _Leaf1B1_1B3_1B2_1B11_Ref }
  object { _Leaf1B1_1B3_1B2_1B12_Ref }
  object { _Leaf1B1_1B3_1B3_1B1_Ref }
  object { _Leaf1B1_1B3_1B3_1B2_Ref }
  object { _Leaf1B1_1B3_1B3_1B3_Ref }
  object { _Leaf1B1_1B3_1B3_1B4_Ref }
  object { _Leaf1B1_1B3_1B3_1B5_Ref }
  object { _Leaf1B1_1B3_1B3_1B6_Ref }
  object { _Leaf1B1_1B3_1B3_1B7_Ref }
  object { _Leaf1B1_1B3_1B3_1B8_Ref }
  object { _Leaf1B1_1B3_1B3_1B9_Ref }
  object { _Leaf1B1_1B3_1B3_1B10_Ref }
  object { _Leaf1B1_1B3_1B3_1B11_Ref }
  object { _Leaf1B1_1B3_1B3_1B12_Ref }
  object { _Leaf1B1_1B4_2B1_1B1_Ref }
  object { _Leaf1B1_1B4_2B1_1B2_Ref }
  object { _Leaf1B1_1B4_2B1_1B3_Ref }
  object { _Leaf1B1_1B4_2B1_1B4_Ref }
  object { _Leaf1B1_1B4_2B1_1B5_Ref }
  object { _Leaf1B1_1B4_2B1_1B6_Ref }
  object { _Leaf1B1_1B4_2B1_1B7_Ref }
  object { _Leaf1B1_1B4_2B1_1B8_Ref }
  object { _Leaf1B1_1B4_2B1_1B9_Ref }
  object { _Leaf1B1_1B4_2B1_1B10_Ref }
  object { _Leaf1B1_1B4_2B1_1B11_Ref }
  object { _Leaf1B1_1B4_2B1_1B12_Ref }
  object { _Leaf1B1_1B4_2B2_1B1_Ref }
  object { _Leaf1B1_1B4_2B2_1B2_Ref }
  object { _Leaf1B1_1B4_2B2_1B3_Ref }
  object { _Leaf1B1_1B4_2B2_1B4_Ref }
  object { _Leaf1B1_1B4_2B2_1B5_Ref }
  object { _Leaf1B1_1B4_2B2_1B6_Ref }
  object { _Leaf1B1_1B4_2B2_1B7_Ref }
  object { _Leaf1B1_1B4_2B2_1B8_Ref }
  object { _Leaf1B1_1B4_2B2_1B9_Ref }
  object { _Leaf1B1_1B4_2B2_1B10_Ref }
  object { _Leaf1B1_1B4_2B2_1B11_Ref }
  object { _Leaf1B1_1B4_2B2_1B12_Ref }
  object { _Leaf1B1_1B4_2B3_1B1_Ref }
  object { _Leaf1B1_1B4_2B3_1B2_Ref }
  object { _Leaf1B1_1B4_2B3_1B3_Ref }
  object { _Leaf1B1_1B4_2B3_1B4_Ref }
  object { _Leaf1B1_1B4_2B3_1B5_Ref }
  object { _Leaf1B1_1B4_2B3_1B6_Ref }
  object { _Leaf1B1_1B4_2B3_1B7_Ref }
  object { _Leaf1B1_1B4_2B3_1B8_Ref }
  object { _Leaf1B1_1B4_2B3_1B9_Ref }
  object { _Leaf1B1_1B4_2B3_1B10_Ref }
  object { _Leaf1B1_1B4_2B3_1B11_Ref }
  object { _Leaf1B1_1B4_2B3_1B12_Ref }
  object { _Leaf1B1_1B4_2B4_1B1_Ref }
  object { _Leaf1B1_1B4_2B4_1B2_Ref }
  object { _Leaf1B1_1B4_2B4_1B3_Ref }
  object { _Leaf1B1_1B4_2B4_1B4_Ref }
  object { _Leaf1B1_1B4_2B4_1B5_Ref }
  object { _Leaf1B1_1B4_2B4_1B6_Ref }
  object { _Leaf1B1_1B4_2B4_1B7_Ref }
  object { _Leaf1B1_1B4_2B4_1B8_Ref }
  object { _Leaf1B1_1B4_2B4_1B9_Ref }
  object { _Leaf1B1_1B4_2B4_1B10_Ref }
  object { _Leaf1B1_1B4_2B4_1B11_Ref }
  object { _Leaf1B1_1B4_2B4_1B12_Ref }
  object { _Leaf1B1_1B4_2B5_1B1_Ref }
  object { _Leaf1B1_1B4_2B5_1B2_Ref }
  object { _Leaf1B1_1B4_2B5_1B3_Ref }
  object { _Leaf1B1_1B4_2B5_1B4_Ref }
  object { _Leaf1B1_1B4_2B5_1B5_Ref }
  object { _Leaf1B1_1B4_2B5_1B6_Ref }
  object { _Leaf1B1_1B4_2B5_1B7_Ref }
  object { _Leaf1B1_1B4_2B5_1B8_Ref }
  object { _Leaf1B1_1B4_2B5_1B9_Ref }
  object { _Leaf1B1_1B4_2B5_1B10_Ref }
  object { _Leaf1B1_1B4_2B5_1B11_Ref }
  object { _Leaf1B1_1B4_2B5_1B12_Ref }
  object { _Leaf1B1_1B4_1B1_1B1_Ref }
  object { _Leaf1B1_1B4_1B1_1B2_Ref }
  object { _Leaf1B1_1B4_1B1_1B3_Ref }
  object { _Leaf1B1_1B4_1B1_1B4_Ref }
  object { _Leaf1B1_1B4_1B1_1B5_Ref }
  object { _Leaf1B1_1B4_1B1_1B6_Ref }
  object { _Leaf1B1_1B4_1B1_1B7_Ref }
  object { _Leaf1B1_1B4_1B1_1B8_Ref }
  object { _Leaf1B1_1B4_1B1_1B9_Ref }
  object { _Leaf1B1_1B4_1B1_1B10_Ref }
  object { _Leaf1B1_1B4_1B1_1B11_Ref }
  object { _Leaf1B1_1B4_1B1_1B12_Ref }
  object { _Leaf1B1_1B4_1B2_1B1_Ref }
  object { _Leaf1B1_1B4_1B2_1B2_Ref }
  object { _Leaf1B1_1B4_1B2_1B3_Ref }
  object { _Leaf1B1_1B4_1B2_1B4_Ref }
  object { _Leaf1B1_1B4_1B2_1B5_Ref }
  object { _Leaf1B1_1B4_1B2_1B6_Ref }
  object { _Leaf1B1_1B4_1B2_1B7_Ref }
  object { _Leaf1B1_1B4_1B2_1B8_Ref }
  object { _Leaf1B1_1B4_1B2_1B9_Ref }
  object { _Leaf1B1_1B4_1B2_1B10_Ref }
  object { _Leaf1B1_1B4_1B2_1B11_Ref }
  object { _Leaf1B1_1B4_1B2_1B12_Ref }
  object { _Leaf1B1_1B4_1B3_1B1_Ref }
  object { _Leaf1B1_1B4_1B3_1B2_Ref }
  object { _Leaf1B1_1B4_1B3_1B3_Ref }
  object { _Leaf1B1_1B4_1B3_1B4_Ref }
  object { _Leaf1B1_1B4_1B3_1B5_Ref }
  object { _Leaf1B1_1B4_1B3_1B6_Ref }
  object { _Leaf1B1_1B4_1B3_1B7_Ref }
  object { _Leaf1B1_1B4_1B3_1B8_Ref }
  object { _Leaf1B1_1B4_1B3_1B9_Ref }
  object { _Leaf1B1_1B4_1B3_1B10_Ref }
  object { _Leaf1B1_1B4_1B3_1B11_Ref }
  object { _Leaf1B1_1B4_1B3_1B12_Ref }
  object { _Leaf1B1_1B5_2B1_1B1_Ref }
  object { _Leaf1B1_1B5_2B1_1B2_Ref }
  object { _Leaf1B1_1B5_2B1_1B3_Ref }
  object { _Leaf1B1_1B5_2B1_1B4_Ref }
  object { _Leaf1B1_1B5_2B1_1B5_Ref }
  object { _Leaf1B1_1B5_2B1_1B6_Ref }
  object { _Leaf1B1_1B5_2B1_1B7_Ref }
  object { _Leaf1B1_1B5_2B1_1B8_Ref }
  object { _Leaf1B1_1B5_2B1_1B9_Ref }
  object { _Leaf1B1_1B5_2B1_1B10_Ref }
  object { _Leaf1B1_1B5_2B1_1B11_Ref }
  object { _Leaf1B1_1B5_2B1_1B12_Ref }
  object { _Leaf1B1_1B5_2B2_1B1_Ref }
  object { _Leaf1B1_1B5_2B2_1B2_Ref }
  object { _Leaf1B1_1B5_2B2_1B3_Ref }
  object { _Leaf1B1_1B5_2B2_1B4_Ref }
  object { _Leaf1B1_1B5_2B2_1B5_Ref }
  object { _Leaf1B1_1B5_2B2_1B6_Ref }
  object { _Leaf1B1_1B5_2B2_1B7_Ref }
  object { _Leaf1B1_1B5_2B2_1B8_Ref }
  object { _Leaf1B1_1B5_2B2_1B9_Ref }
  object { _Leaf1B1_1B5_2B2_1B10_Ref }
  object { _Leaf1B1_1B5_2B2_1B11_Ref }
  object { _Leaf1B1_1B5_2B2_1B12_Ref }
  object { _Leaf1B1_1B5_2B3_1B1_Ref }
  object { _Leaf1B1_1B5_2B3_1B2_Ref }
  object { _Leaf1B1_1B5_2B3_1B3_Ref }
  object { _Leaf1B1_1B5_2B3_1B4_Ref }
  object { _Leaf1B1_1B5_2B3_1B5_Ref }
  object { _Leaf1B1_1B5_2B3_1B6_Ref }
  object { _Leaf1B1_1B5_2B3_1B7_Ref }
  object { _Leaf1B1_1B5_2B3_1B8_Ref }
  object { _Leaf1B1_1B5_2B3_1B9_Ref }
  object { _Leaf1B1_1B5_2B3_1B10_Ref }
  object { _Leaf1B1_1B5_2B3_1B11_Ref }
  object { _Leaf1B1_1B5_2B3_1B12_Ref }
  object { _Leaf1B1_1B5_2B4_1B1_Ref }
  object { _Leaf1B1_1B5_2B4_1B2_Ref }
  object { _Leaf1B1_1B5_2B4_1B3_Ref }
  object { _Leaf1B1_1B5_2B4_1B4_Ref }
  object { _Leaf1B1_1B5_2B4_1B5_Ref }
  object { _Leaf1B1_1B5_2B4_1B6_Ref }
  object { _Leaf1B1_1B5_2B4_1B7_Ref }
  object { _Leaf1B1_1B5_2B4_1B8_Ref }
  object { _Leaf1B1_1B5_2B4_1B9_Ref }
  object { _Leaf1B1_1B5_2B4_1B10_Ref }
  object { _Leaf1B1_1B5_2B4_1B11_Ref }
  object { _Leaf1B1_1B5_2B4_1B12_Ref }
  object { _Leaf1B1_1B5_2B5_1B1_Ref }
  object { _Leaf1B1_1B5_2B5_1B2_Ref }
  object { _Leaf1B1_1B5_2B5_1B3_Ref }
  object { _Leaf1B1_1B5_2B5_1B4_Ref }
  object { _Leaf1B1_1B5_2B5_1B5_Ref }
  object { _Leaf1B1_1B5_2B5_1B6_Ref }
  object { _Leaf1B1_1B5_2B5_1B7_Ref }
  object { _Leaf1B1_1B5_2B5_1B8_Ref }
  object { _Leaf1B1_1B5_2B5_1B9_Ref }
  object { _Leaf1B1_1B5_2B5_1B10_Ref }
  object { _Leaf1B1_1B5_2B5_1B11_Ref }
  object { _Leaf1B1_1B5_2B5_1B12_Ref }
  object { _Leaf1B1_1B5_1B1_1B1_Ref }
  object { _Leaf1B1_1B5_1B1_1B2_Ref }
  object { _Leaf1B1_1B5_1B1_1B3_Ref }
  object { _Leaf1B1_1B5_1B1_1B4_Ref }
  object { _Leaf1B1_1B5_1B1_1B5_Ref }
  object { _Leaf1B1_1B5_1B1_1B6_Ref }
  object { _Leaf1B1_1B5_1B1_1B7_Ref }
  object { _Leaf1B1_1B5_1B1_1B8_Ref }
  object { _Leaf1B1_1B5_1B1_1B9_Ref }
  object { _Leaf1B1_1B5_1B1_1B10_Ref }
  object { _Leaf1B1_1B5_1B1_1B11_Ref }
  object { _Leaf1B1_1B5_1B1_1B12_Ref }
  object { _Leaf1B1_1B5_1B2_1B1_Ref }
  object { _Leaf1B1_1B5_1B2_1B2_Ref }
  object { _Leaf1B1_1B5_1B2_1B3_Ref }
  object { _Leaf1B1_1B5_1B2_1B4_Ref }
  object { _Leaf1B1_1B5_1B2_1B5_Ref }
  object { _Leaf1B1_1B5_1B2_1B6_Ref }
  object { _Leaf1B1_1B5_1B2_1B7_Ref }
  object { _Leaf1B1_1B5_1B2_1B8_Ref }
  object { _Leaf1B1_1B5_1B2_1B9_Ref }
  object { _Leaf1B1_1B5_1B2_1B10_Ref }
  object { _Leaf1B1_1B5_1B2_1B11_Ref }
  object { _Leaf1B1_1B5_1B2_1B12_Ref }
  object { _Leaf1B1_1B5_1B3_1B1_Ref }
  object { _Leaf1B1_1B5_1B3_1B2_Ref }
  object { _Leaf1B1_1B5_1B3_1B3_Ref }
  object { _Leaf1B1_1B5_1B3_1B4_Ref }
  object { _Leaf1B1_1B5_1B3_1B5_Ref }
  object { _Leaf1B1_1B5_1B3_1B6_Ref }
  object { _Leaf1B1_1B5_1B3_1B7_Ref }
  object { _Leaf1B1_1B5_1B3_1B8_Ref }
  object { _Leaf1B1_1B5_1B3_1B9_Ref }
  object { _Leaf1B1_1B5_1B3_1B10_Ref }
  object { _Leaf1B1_1B5_1B3_1B11_Ref }
  object { _Leaf1B1_1B5_1B3_1B12_Ref }
  object { _Leaf1B1_1B6_2B1_1B1_Ref }
  object { _Leaf1B1_1B6_2B1_1B2_Ref }
  object { _Leaf1B1_1B6_2B1_1B3_Ref }
  object { _Leaf1B1_1B6_2B1_1B4_Ref }
  object { _Leaf1B1_1B6_2B1_1B5_Ref }
  object { _Leaf1B1_1B6_2B1_1B6_Ref }
  object { _Leaf1B1_1B6_2B1_1B7_Ref }
  object { _Leaf1B1_1B6_2B1_1B8_Ref }
  object { _Leaf1B1_1B6_2B1_1B9_Ref }
  object { _Leaf1B1_1B6_2B1_1B10_Ref }
  object { _Leaf1B1_1B6_2B1_1B11_Ref }
  object { _Leaf1B1_1B6_2B1_1B12_Ref }
  object { _Leaf1B1_1B6_2B2_1B1_Ref }
  object { _Leaf1B1_1B6_2B2_1B2_Ref }
  object { _Leaf1B1_1B6_2B2_1B3_Ref }
  object { _Leaf1B1_1B6_2B2_1B4_Ref }
  object { _Leaf1B1_1B6_2B2_1B5_Ref }
  object { _Leaf1B1_1B6_2B2_1B6_Ref }
  object { _Leaf1B1_1B6_2B2_1B7_Ref }
  object { _Leaf1B1_1B6_2B2_1B8_Ref }
  object { _Leaf1B1_1B6_2B2_1B9_Ref }
  object { _Leaf1B1_1B6_2B2_1B10_Ref }
  object { _Leaf1B1_1B6_2B2_1B11_Ref }
  object { _Leaf1B1_1B6_2B2_1B12_Ref }
  object { _Leaf1B1_1B6_2B3_1B1_Ref }
  object { _Leaf1B1_1B6_2B3_1B2_Ref }
  object { _Leaf1B1_1B6_2B3_1B3_Ref }
  object { _Leaf1B1_1B6_2B3_1B4_Ref }
  object { _Leaf1B1_1B6_2B3_1B5_Ref }
  object { _Leaf1B1_1B6_2B3_1B6_Ref }
  object { _Leaf1B1_1B6_2B3_1B7_Ref }
  object { _Leaf1B1_1B6_2B3_1B8_Ref }
  object { _Leaf1B1_1B6_2B3_1B9_Ref }
  object { _Leaf1B1_1B6_2B3_1B10_Ref }
  object { _Leaf1B1_1B6_2B3_1B11_Ref }
  object { _Leaf1B1_1B6_2B3_1B12_Ref }
  object { _Leaf1B1_1B6_2B4_1B1_Ref }
  object { _Leaf1B1_1B6_2B4_1B2_Ref }
  object { _Leaf1B1_1B6_2B4_1B3_Ref }
  object { _Leaf1B1_1B6_2B4_1B4_Ref }
  object { _Leaf1B1_1B6_2B4_1B5_Ref }
  object { _Leaf1B1_1B6_2B4_1B6_Ref }
  object { _Leaf1B1_1B6_2B4_1B7_Ref }
  object { _Leaf1B1_1B6_2B4_1B8_Ref }
  object { _Leaf1B1_1B6_2B4_1B9_Ref }
  object { _Leaf1B1_1B6_2B4_1B10_Ref }
  object { _Leaf1B1_1B6_2B4_1B11_Ref }
  object { _Leaf1B1_1B6_2B4_1B12_Ref }
  object { _Leaf1B1_1B6_2B5_1B1_Ref }
  object { _Leaf1B1_1B6_2B5_1B2_Ref }
  object { _Leaf1B1_1B6_2B5_1B3_Ref }
  object { _Leaf1B1_1B6_2B5_1B4_Ref }
  object { _Leaf1B1_1B6_2B5_1B5_Ref }
  object { _Leaf1B1_1B6_2B5_1B6_Ref }
  object { _Leaf1B1_1B6_2B5_1B7_Ref }
  object { _Leaf1B1_1B6_2B5_1B8_Ref }
  object { _Leaf1B1_1B6_2B5_1B9_Ref }
  object { _Leaf1B1_1B6_2B5_1B10_Ref }
  object { _Leaf1B1_1B6_2B5_1B11_Ref }
  object { _Leaf1B1_1B6_2B5_1B12_Ref }
  object { _Leaf1B1_1B6_1B1_1B1_Ref }
  object { _Leaf1B1_1B6_1B1_1B2_Ref }
  object { _Leaf1B1_1B6_1B1_1B3_Ref }
  object { _Leaf1B1_1B6_1B1_1B4_Ref }
  object { _Leaf1B1_1B6_1B1_1B5_Ref }
  object { _Leaf1B1_1B6_1B1_1B6_Ref }
  object { _Leaf1B1_1B6_1B1_1B7_Ref }
  object { _Leaf1B1_1B6_1B1_1B8_Ref }
  object { _Leaf1B1_1B6_1B1_1B9_Ref }
  object { _Leaf1B1_1B6_1B1_1B10_Ref }
  object { _Leaf1B1_1B6_1B1_1B11_Ref }
  object { _Leaf1B1_1B6_1B1_1B12_Ref }
  object { _Leaf1B1_1B6_1B2_1B1_Ref }
  object { _Leaf1B1_1B6_1B2_1B2_Ref }
  object { _Leaf1B1_1B6_1B2_1B3_Ref }
  object { _Leaf1B1_1B6_1B2_1B4_Ref }
  object { _Leaf1B1_1B6_1B2_1B5_Ref }
  object { _Leaf1B1_1B6_1B2_1B6_Ref }
  object { _Leaf1B1_1B6_1B2_1B7_Ref }
  object { _Leaf1B1_1B6_1B2_1B8_Ref }
  object { _Leaf1B1_1B6_1B2_1B9_Ref }
  object { _Leaf1B1_1B6_1B2_1B10_Ref }
  object { _Leaf1B1_1B6_1B2_1B11_Ref }
  object { _Leaf1B1_1B6_1B2_1B12_Ref }
  object { _Leaf1B1_1B6_1B3_1B1_Ref }
  object { _Leaf1B1_1B6_1B3_1B2_Ref }
  object { _Leaf1B1_1B6_1B3_1B3_Ref }
  object { _Leaf1B1_1B6_1B3_1B4_Ref }
  object { _Leaf1B1_1B6_1B3_1B5_Ref }
  object { _Leaf1B1_1B6_1B3_1B6_Ref }
  object { _Leaf1B1_1B6_1B3_1B7_Ref }
  object { _Leaf1B1_1B6_1B3_1B8_Ref }
  object { _Leaf1B1_1B6_1B3_1B9_Ref }
  object { _Leaf1B1_1B6_1B3_1B10_Ref }
  object { _Leaf1B1_1B6_1B3_1B11_Ref }
  object { _Leaf1B1_1B6_1B3_1B12_Ref }
  object { _Leaf1B2_1B1_2B1_1B1_Ref }
  object { _Leaf1B2_1B1_2B1_1B2_Ref }
  object { _Leaf1B2_1B1_2B1_1B3_Ref }
  object { _Leaf1B2_1B1_2B1_1B4_Ref }
  object { _Leaf1B2_1B1_2B1_1B5_Ref }
  object { _Leaf1B2_1B1_2B1_1B6_Ref }
  object { _Leaf1B2_1B1_2B1_1B7_Ref }
  object { _Leaf1B2_1B1_2B1_1B8_Ref }
  object { _Leaf1B2_1B1_2B1_1B9_Ref }
  object { _Leaf1B2_1B1_2B1_1B10_Ref }
  object { _Leaf1B2_1B1_2B1_1B11_Ref }
  object { _Leaf1B2_1B1_2B1_1B12_Ref }
  object { _Leaf1B2_1B1_2B2_1B1_Ref }
  object { _Leaf1B2_1B1_2B2_1B2_Ref }
  object { _Leaf1B2_1B1_2B2_1B3_Ref }
  object { _Leaf1B2_1B1_2B2_1B4_Ref }
  object { _Leaf1B2_1B1_2B2_1B5_Ref }
  object { _Leaf1B2_1B1_2B2_1B6_Ref }
  object { _Leaf1B2_1B1_2B2_1B7_Ref }
  object { _Leaf1B2_1B1_2B2_1B8_Ref }
  object { _Leaf1B2_1B1_2B2_1B9_Ref }
  object { _Leaf1B2_1B1_2B2_1B10_Ref }
  object { _Leaf1B2_1B1_2B2_1B11_Ref }
  object { _Leaf1B2_1B1_2B2_1B12_Ref }
  object { _Leaf1B2_1B1_2B3_1B1_Ref }
  object { _Leaf1B2_1B1_2B3_1B2_Ref }
  object { _Leaf1B2_1B1_2B3_1B3_Ref }
  object { _Leaf1B2_1B1_2B3_1B4_Ref }
  object { _Leaf1B2_1B1_2B3_1B5_Ref }
  object { _Leaf1B2_1B1_2B3_1B6_Ref }
  object { _Leaf1B2_1B1_2B3_1B7_Ref }
  object { _Leaf1B2_1B1_2B3_1B8_Ref }
  object { _Leaf1B2_1B1_2B3_1B9_Ref }
  object { _Leaf1B2_1B1_2B3_1B10_Ref }
  object { _Leaf1B2_1B1_2B3_1B11_Ref }
  object { _Leaf1B2_1B1_2B3_1B12_Ref }
  object { _Leaf1B2_1B1_2B4_1B1_Ref }
  object { _Leaf1B2_1B1_2B4_1B2_Ref }
  object { _Leaf1B2_1B1_2B4_1B3_Ref }
  object { _Leaf1B2_1B1_2B4_1B4_Ref }
  object { _Leaf1B2_1B1_2B4_1B5_Ref }
  object { _Leaf1B2_1B1_2B4_1B6_Ref }
  object { _Leaf1B2_1B1_2B4_1B7_Ref }
  object { _Leaf1B2_1B1_2B4_1B8_Ref }
  object { _Leaf1B2_1B1_2B4_1B9_Ref }
  object { _Leaf1B2_1B1_2B4_1B10_Ref }
  object { _Leaf1B2_1B1_2B4_1B11_Ref }
  object { _Leaf1B2_1B1_2B4_1B12_Ref }
  object { _Leaf1B2_1B1_2B5_1B1_Ref }
  object { _Leaf1B2_1B1_2B5_1B2_Ref }
  object { _Leaf1B2_1B1_2B5_1B3_Ref }
  object { _Leaf1B2_1B1_2B5_1B4_Ref }
  object { _Leaf1B2_1B1_2B5_1B5_Ref }
  object { _Leaf1B2_1B1_2B5_1B6_Ref }
  object { _Leaf1B2_1B1_2B5_1B7_Ref }
  object { _Leaf1B2_1B1_2B5_1B8_Ref }
  object { _Leaf1B2_1B1_2B5_1B9_Ref }
  object { _Leaf1B2_1B1_2B5_1B10_Ref }
  object { _Leaf1B2_1B1_2B5_1B11_Ref }
  object { _Leaf1B2_1B1_2B5_1B12_Ref }
  object { _Leaf1B2_1B1_1B1_1B1_Ref }
  object { _Leaf1B2_1B1_1B1_1B2_Ref }
  object { _Leaf1B2_1B1_1B1_1B3_Ref }
  object { _Leaf1B2_1B1_1B1_1B4_Ref }
  object { _Leaf1B2_1B1_1B1_1B5_Ref }
  object { _Leaf1B2_1B1_1B1_1B6_Ref }
  object { _Leaf1B2_1B1_1B1_1B7_Ref }
  object { _Leaf1B2_1B1_1B1_1B8_Ref }
  object { _Leaf1B2_1B1_1B1_1B9_Ref }
  object { _Leaf1B2_1B1_1B1_1B10_Ref }
  object { _Leaf1B2_1B1_1B1_1B11_Ref }
  object { _Leaf1B2_1B1_1B1_1B12_Ref }
  object { _Leaf1B2_1B1_1B2_1B1_Ref }
  object { _Leaf1B2_1B1_1B2_1B2_Ref }
  object { _Leaf1B2_1B1_1B2_1B3_Ref }
  object { _Leaf1B2_1B1_1B2_1B4_Ref }
  object { _Leaf1B2_1B1_1B2_1B5_Ref }
  object { _Leaf1B2_1B1_1B2_1B6_Ref }
  object { _Leaf1B2_1B1_1B2_1B7_Ref }
  object { _Leaf1B2_1B1_1B2_1B8_Ref }
  object { _Leaf1B2_1B1_1B2_1B9_Ref }
  object { _Leaf1B2_1B1_1B2_1B10_Ref }
  object { _Leaf1B2_1B1_1B2_1B11_Ref }
  object { _Leaf1B2_1B1_1B2_1B12_Ref }
  object { _Leaf1B2_1B1_1B3_1B1_Ref }
  object { _Leaf1B2_1B1_1B3_1B2_Ref }
  object { _Leaf1B2_1B1_1B3_1B3_Ref }
  object { _Leaf1B2_1B1_1B3_1B4_Ref }
  object { _Leaf1B2_1B1_1B3_1B5_Ref }
  object { _Leaf1B2_1B1_1B3_1B6_Ref }
  object { _Leaf1B2_1B1_1B3_1B7_Ref }
  object { _Leaf1B2_1B1_1B3_1B8_Ref }
  object { _Leaf1B2_1B1_1B3_1B9_Ref }
  object { _Leaf1B2_1B1_1B3_1B10_Ref }
  object { _Leaf1B2_1B1_1B3_1B11_Ref }
  object { _Leaf1B2_1B1_1B3_1B12_Ref }
  object { _Leaf1B2_1B2_2B1_1B1_Ref }
  object { _Leaf1B2_1B2_2B1_1B2_Ref }
  object { _Leaf1B2_1B2_2B1_1B3_Ref }
  object { _Leaf1B2_1B2_2B1_1B4_Ref }
  object { _Leaf1B2_1B2_2B1_1B5_Ref }
  object { _Leaf1B2_1B2_2B1_1B6_Ref }
  object { _Leaf1B2_1B2_2B1_1B7_Ref }
  object { _Leaf1B2_1B2_2B1_1B8_Ref }
  object { _Leaf1B2_1B2_2B1_1B9_Ref }
  object { _Leaf1B2_1B2_2B1_1B10_Ref }
  object { _Leaf1B2_1B2_2B1_1B11_Ref }
  object { _Leaf1B2_1B2_2B1_1B12_Ref }
  object { _Leaf1B2_1B2_2B2_1B1_Ref }
  object { _Leaf1B2_1B2_2B2_1B2_Ref }
  object { _Leaf1B2_1B2_2B2_1B3_Ref }
  object { _Leaf1B2_1B2_2B2_1B4_Ref }
  object { _Leaf1B2_1B2_2B2_1B5_Ref }
  object { _Leaf1B2_1B2_2B2_1B6_Ref }
  object { _Leaf1B2_1B2_2B2_1B7_Ref }
  object { _Leaf1B2_1B2_2B2_1B8_Ref }
  object { _Leaf1B2_1B2_2B2_1B9_Ref }
  object { _Leaf1B2_1B2_2B2_1B10_Ref }
  object { _Leaf1B2_1B2_2B2_1B11_Ref }
  object { _Leaf1B2_1B2_2B2_1B12_Ref }
  object { _Leaf1B2_1B2_2B3_1B1_Ref }
  object { _Leaf1B2_1B2_2B3_1B2_Ref }
  object { _Leaf1B2_1B2_2B3_1B3_Ref }
  object { _Leaf1B2_1B2_2B3_1B4_Ref }
  object { _Leaf1B2_1B2_2B3_1B5_Ref }
  object { _Leaf1B2_1B2_2B3_1B6_Ref }
  object { _Leaf1B2_1B2_2B3_1B7_Ref }
  object { _Leaf1B2_1B2_2B3_1B8_Ref }
  object { _Leaf1B2_1B2_2B3_1B9_Ref }
  object { _Leaf1B2_1B2_2B3_1B10_Ref }
  object { _Leaf1B2_1B2_2B3_1B11_Ref }
  object { _Leaf1B2_1B2_2B3_1B12_Ref }
  object { _Leaf1B2_1B2_2B4_1B1_Ref }
  object { _Leaf1B2_1B2_2B4_1B2_Ref }
  object { _Leaf1B2_1B2_2B4_1B3_Ref }
  object { _Leaf1B2_1B2_2B4_1B4_Ref }
  object { _Leaf1B2_1B2_2B4_1B5_Ref }
  object { _Leaf1B2_1B2_2B4_1B6_Ref }
  object { _Leaf1B2_1B2_2B4_1B7_Ref }
  object { _Leaf1B2_1B2_2B4_1B8_Ref }
  object { _Leaf1B2_1B2_2B4_1B9_Ref }
  object { _Leaf1B2_1B2_2B4_1B10_Ref }
  object { _Leaf1B2_1B2_2B4_1B11_Ref }
  object { _Leaf1B2_1B2_2B4_1B12_Ref }
  object { _Leaf1B2_1B2_2B5_1B1_Ref }
  object { _Leaf1B2_1B2_2B5_1B2_Ref }
  object { _Leaf1B2_1B2_2B5_1B3_Ref }
  object { _Leaf1B2_1B2_2B5_1B4_Ref }
  object { _Leaf1B2_1B2_2B5_1B5_Ref }
  object { _Leaf1B2_1B2_2B5_1B6_Ref }
  object { _Leaf1B2_1B2_2B5_1B7_Ref }
  object { _Leaf1B2_1B2_2B5_1B8_Ref }
  object { _Leaf1B2_1B2_2B5_1B9_Ref }
  object { _Leaf1B2_1B2_2B5_1B10_Ref }
  object { _Leaf1B2_1B2_2B5_1B11_Ref }
  object { _Leaf1B2_1B2_2B5_1B12_Ref }
  object { _Leaf1B2_1B2_1B1_1B1_Ref }
  object { _Leaf1B2_1B2_1B1_1B2_Ref }
  object { _Leaf1B2_1B2_1B1_1B3_Ref }
  object { _Leaf1B2_1B2_1B1_1B4_Ref }
  object { _Leaf1B2_1B2_1B1_1B5_Ref }
  object { _Leaf1B2_1B2_1B1_1B6_Ref }
  object { _Leaf1B2_1B2_1B1_1B7_Ref }
  object { _Leaf1B2_1B2_1B1_1B8_Ref }
  object { _Leaf1B2_1B2_1B1_1B9_Ref }
  object { _Leaf1B2_1B2_1B1_1B10_Ref }
  object { _Leaf1B2_1B2_1B1_1B11_Ref }
  object { _Leaf1B2_1B2_1B1_1B12_Ref }
  object { _Leaf1B2_1B2_1B2_1B1_Ref }
  object { _Leaf1B2_1B2_1B2_1B2_Ref }
  object { _Leaf1B2_1B2_1B2_1B3_Ref }
  object { _Leaf1B2_1B2_1B2_1B4_Ref }
  object { _Leaf1B2_1B2_1B2_1B5_Ref }
  object { _Leaf1B2_1B2_1B2_1B6_Ref }
  object { _Leaf1B2_1B2_1B2_1B7_Ref }
  object { _Leaf1B2_1B2_1B2_1B8_Ref }
  object { _Leaf1B2_1B2_1B2_1B9_Ref }
  object { _Leaf1B2_1B2_1B2_1B10_Ref }
  object { _Leaf1B2_1B2_1B2_1B11_Ref }
  object { _Leaf1B2_1B2_1B2_1B12_Ref }
  object { _Leaf1B2_1B2_1B3_1B1_Ref }
  object { _Leaf1B2_1B2_1B3_1B2_Ref }
  object { _Leaf1B2_1B2_1B3_1B3_Ref }
  object { _Leaf1B2_1B2_1B3_1B4_Ref }
  object { _Leaf1B2_1B2_1B3_1B5_Ref }
  object { _Leaf1B2_1B2_1B3_1B6_Ref }
  object { _Leaf1B2_1B2_1B3_1B7_Ref }
  object { _Leaf1B2_1B2_1B3_1B8_Ref }
  object { _Leaf1B2_1B2_1B3_1B9_Ref }
  object { _Leaf1B2_1B2_1B3_1B10_Ref }
  object { _Leaf1B2_1B2_1B3_1B11_Ref }
  object { _Leaf1B2_1B2_1B3_1B12_Ref }
  object { _Leaf1B2_1B3_2B1_1B1_Ref }
  object { _Leaf1B2_1B3_2B1_1B2_Ref }
  object { _Leaf1B2_1B3_2B1_1B3_Ref }
  object { _Leaf1B2_1B3_2B1_1B4_Ref }
  object { _Leaf1B2_1B3_2B1_1B5_Ref }
  object { _Leaf1B2_1B3_2B1_1B6_Ref }
  object { _Leaf1B2_1B3_2B1_1B7_Ref }
  object { _Leaf1B2_1B3_2B1_1B8_Ref }
  object { _Leaf1B2_1B3_2B1_1B9_Ref }
  object { _Leaf1B2_1B3_2B1_1B10_Ref }
  object { _Leaf1B2_1B3_2B1_1B11_Ref }
  object { _Leaf1B2_1B3_2B1_1B12_Ref }
  object { _Leaf1B2_1B3_2B2_1B1_Ref }
  object { _Leaf1B2_1B3_2B2_1B2_Ref }
  object { _Leaf1B2_1B3_2B2_1B3_Ref }
  object { _Leaf1B2_1B3_2B2_1B4_Ref }
  object { _Leaf1B2_1B3_2B2_1B5_Ref }
  object { _Leaf1B2_1B3_2B2_1B6_Ref }
  object { _Leaf1B2_1B3_2B2_1B7_Ref }
  object { _Leaf1B2_1B3_2B2_1B8_Ref }
  object { _Leaf1B2_1B3_2B2_1B9_Ref }
  object { _Leaf1B2_1B3_2B2_1B10_Ref }
  object { _Leaf1B2_1B3_2B2_1B11_Ref }
  object { _Leaf1B2_1B3_2B2_1B12_Ref }
  object { _Leaf1B2_1B3_2B3_1B1_Ref }
  object { _Leaf1B2_1B3_2B3_1B2_Ref }
  object { _Leaf1B2_1B3_2B3_1B3_Ref }
  object { _Leaf1B2_1B3_2B3_1B4_Ref }
  object { _Leaf1B2_1B3_2B3_1B5_Ref }
  object { _Leaf1B2_1B3_2B3_1B6_Ref }
  object { _Leaf1B2_1B3_2B3_1B7_Ref }
  object { _Leaf1B2_1B3_2B3_1B8_Ref }
  object { _Leaf1B2_1B3_2B3_1B9_Ref }
  object { _Leaf1B2_1B3_2B3_1B10_Ref }
  object { _Leaf1B2_1B3_2B3_1B11_Ref }
  object { _Leaf1B2_1B3_2B3_1B12_Ref }
  object { _Leaf1B2_1B3_2B4_1B1_Ref }
  object { _Leaf1B2_1B3_2B4_1B2_Ref }
  object { _Leaf1B2_1B3_2B4_1B3_Ref }
  object { _Leaf1B2_1B3_2B4_1B4_Ref }
  object { _Leaf1B2_1B3_2B4_1B5_Ref }
  object { _Leaf1B2_1B3_2B4_1B6_Ref }
  object { _Leaf1B2_1B3_2B4_1B7_Ref }
  object { _Leaf1B2_1B3_2B4_1B8_Ref }
  object { _Leaf1B2_1B3_2B4_1B9_Ref }
  object { _Leaf1B2_1B3_2B4_1B10_Ref }
  object { _Leaf1B2_1B3_2B4_1B11_Ref }
  object { _Leaf1B2_1B3_2B4_1B12_Ref }
  object { _Leaf1B2_1B3_2B5_1B1_Ref }
  object { _Leaf1B2_1B3_2B5_1B2_Ref }
  object { _Leaf1B2_1B3_2B5_1B3_Ref }
  object { _Leaf1B2_1B3_2B5_1B4_Ref }
  object { _Leaf1B2_1B3_2B5_1B5_Ref }
  object { _Leaf1B2_1B3_2B5_1B6_Ref }
  object { _Leaf1B2_1B3_2B5_1B7_Ref }
  object { _Leaf1B2_1B3_2B5_1B8_Ref }
  object { _Leaf1B2_1B3_2B5_1B9_Ref }
  object { _Leaf1B2_1B3_2B5_1B10_Ref }
  object { _Leaf1B2_1B3_2B5_1B11_Ref }
  object { _Leaf1B2_1B3_2B5_1B12_Ref }
  object { _Leaf1B2_1B3_1B1_1B1_Ref }
  object { _Leaf1B2_1B3_1B1_1B2_Ref }
  object { _Leaf1B2_1B3_1B1_1B3_Ref }
  object { _Leaf1B2_1B3_1B1_1B4_Ref }
  object { _Leaf1B2_1B3_1B1_1B5_Ref }
  object { _Leaf1B2_1B3_1B1_1B6_Ref }
  object { _Leaf1B2_1B3_1B1_1B7_Ref }
  object { _Leaf1B2_1B3_1B1_1B8_Ref }
  object { _Leaf1B2_1B3_1B1_1B9_Ref }
  object { _Leaf1B2_1B3_1B1_1B10_Ref }
  object { _Leaf1B2_1B3_1B1_1B11_Ref }
  object { _Leaf1B2_1B3_1B1_1B12_Ref }
  object { _Leaf1B2_1B3_1B2_1B1_Ref }
  object { _Leaf1B2_1B3_1B2_1B2_Ref }
  object { _Leaf1B2_1B3_1B2_1B3_Ref }
  object { _Leaf1B2_1B3_1B2_1B4_Ref }
  object { _Leaf1B2_1B3_1B2_1B5_Ref }
  object { _Leaf1B2_1B3_1B2_1B6_Ref }
  object { _Leaf1B2_1B3_1B2_1B7_Ref }
  object { _Leaf1B2_1B3_1B2_1B8_Ref }
  object { _Leaf1B2_1B3_1B2_1B9_Ref }
  object { _Leaf1B2_1B3_1B2_1B10_Ref }
  object { _Leaf1B2_1B3_1B2_1B11_Ref }
  object { _Leaf1B2_1B3_1B2_1B12_Ref }
  object { _Leaf1B2_1B3_1B3_1B1_Ref }
  object { _Leaf1B2_1B3_1B3_1B2_Ref }
  object { _Leaf1B2_1B3_1B3_1B3_Ref }
  object { _Leaf1B2_1B3_1B3_1B4_Ref }
  object { _Leaf1B2_1B3_1B3_1B5_Ref }
  object { _Leaf1B2_1B3_1B3_1B6_Ref }
  object { _Leaf1B2_1B3_1B3_1B7_Ref }
  object { _Leaf1B2_1B3_1B3_1B8_Ref }
  object { _Leaf1B2_1B3_1B3_1B9_Ref }
  object { _Leaf1B2_1B3_1B3_1B10_Ref }
  object { _Leaf1B2_1B3_1B3_1B11_Ref }
  object { _Leaf1B2_1B3_1B3_1B12_Ref }
  object { _Leaf1B2_1B4_2B1_1B1_Ref }
  object { _Leaf1B2_1B4_2B1_1B2_Ref }
  object { _Leaf1B2_1B4_2B1_1B3_Ref }
  object { _Leaf1B2_1B4_2B1_1B4_Ref }
  object { _Leaf1B2_1B4_2B1_1B5_Ref }
  object { _Leaf1B2_1B4_2B1_1B6_Ref }
  object { _Leaf1B2_1B4_2B1_1B7_Ref }
  object { _Leaf1B2_1B4_2B1_1B8_Ref }
  object { _Leaf1B2_1B4_2B1_1B9_Ref }
  object { _Leaf1B2_1B4_2B1_1B10_Ref }
  object { _Leaf1B2_1B4_2B1_1B11_Ref }
  object { _Leaf1B2_1B4_2B1_1B12_Ref }
  object { _Leaf1B2_1B4_2B2_1B1_Ref }
  object { _Leaf1B2_1B4_2B2_1B2_Ref }
  object { _Leaf1B2_1B4_2B2_1B3_Ref }
  object { _Leaf1B2_1B4_2B2_1B4_Ref }
  object { _Leaf1B2_1B4_2B2_1B5_Ref }
  object { _Leaf1B2_1B4_2B2_1B6_Ref }
  object { _Leaf1B2_1B4_2B2_1B7_Ref }
  object { _Leaf1B2_1B4_2B2_1B8_Ref }
  object { _Leaf1B2_1B4_2B2_1B9_Ref }
  object { _Leaf1B2_1B4_2B2_1B10_Ref }
  object { _Leaf1B2_1B4_2B2_1B11_Ref }
  object { _Leaf1B2_1B4_2B2_1B12_Ref }
  object { _Leaf1B2_1B4_2B3_1B1_Ref }
  object { _Leaf1B2_1B4_2B3_1B2_Ref }
  object { _Leaf1B2_1B4_2B3_1B3_Ref }
  object { _Leaf1B2_1B4_2B3_1B4_Ref }
  object { _Leaf1B2_1B4_2B3_1B5_Ref }
  object { _Leaf1B2_1B4_2B3_1B6_Ref }
  object { _Leaf1B2_1B4_2B3_1B7_Ref }
  object { _Leaf1B2_1B4_2B3_1B8_Ref }
  object { _Leaf1B2_1B4_2B3_1B9_Ref }
  object { _Leaf1B2_1B4_2B3_1B10_Ref }
  object { _Leaf1B2_1B4_2B3_1B11_Ref }
  object { _Leaf1B2_1B4_2B3_1B12_Ref }
  object { _Leaf1B2_1B4_2B4_1B1_Ref }
  object { _Leaf1B2_1B4_2B4_1B2_Ref }
  object { _Leaf1B2_1B4_2B4_1B3_Ref }
  object { _Leaf1B2_1B4_2B4_1B4_Ref }
  object { _Leaf1B2_1B4_2B4_1B5_Ref }
  object { _Leaf1B2_1B4_2B4_1B6_Ref }
  object { _Leaf1B2_1B4_2B4_1B7_Ref }
  object { _Leaf1B2_1B4_2B4_1B8_Ref }
  object { _Leaf1B2_1B4_2B4_1B9_Ref }
  object { _Leaf1B2_1B4_2B4_1B10_Ref }
  object { _Leaf1B2_1B4_2B4_1B11_Ref }
  object { _Leaf1B2_1B4_2B4_1B12_Ref }
  object { _Leaf1B2_1B4_2B5_1B1_Ref }
  object { _Leaf1B2_1B4_2B5_1B2_Ref }
  object { _Leaf1B2_1B4_2B5_1B3_Ref }
  object { _Leaf1B2_1B4_2B5_1B4_Ref }
  object { _Leaf1B2_1B4_2B5_1B5_Ref }
  object { _Leaf1B2_1B4_2B5_1B6_Ref }
  object { _Leaf1B2_1B4_2B5_1B7_Ref }
  object { _Leaf1B2_1B4_2B5_1B8_Ref }
  object { _Leaf1B2_1B4_2B5_1B9_Ref }
  object { _Leaf1B2_1B4_2B5_1B10_Ref }
  object { _Leaf1B2_1B4_2B5_1B11_Ref }
  object { _Leaf1B2_1B4_2B5_1B12_Ref }
  object { _Leaf1B2_1B4_1B1_1B1_Ref }
  object { _Leaf1B2_1B4_1B1_1B2_Ref }
  object { _Leaf1B2_1B4_1B1_1B3_Ref }
  object { _Leaf1B2_1B4_1B1_1B4_Ref }
  object { _Leaf1B2_1B4_1B1_1B5_Ref }
  object { _Leaf1B2_1B4_1B1_1B6_Ref }
  object { _Leaf1B2_1B4_1B1_1B7_Ref }
  object { _Leaf1B2_1B4_1B1_1B8_Ref }
  object { _Leaf1B2_1B4_1B1_1B9_Ref }
  object { _Leaf1B2_1B4_1B1_1B10_Ref }
  object { _Leaf1B2_1B4_1B1_1B11_Ref }
  object { _Leaf1B2_1B4_1B1_1B12_Ref }
  object { _Leaf1B2_1B4_1B2_1B1_Ref }
  object { _Leaf1B2_1B4_1B2_1B2_Ref }
  object { _Leaf1B2_1B4_1B2_1B3_Ref }
  object { _Leaf1B2_1B4_1B2_1B4_Ref }
  object { _Leaf1B2_1B4_1B2_1B5_Ref }
  object { _Leaf1B2_1B4_1B2_1B6_Ref }
  object { _Leaf1B2_1B4_1B2_1B7_Ref }
  object { _Leaf1B2_1B4_1B2_1B8_Ref }
  object { _Leaf1B2_1B4_1B2_1B9_Ref }
  object { _Leaf1B2_1B4_1B2_1B10_Ref }
  object { _Leaf1B2_1B4_1B2_1B11_Ref }
  object { _Leaf1B2_1B4_1B2_1B12_Ref }
  object { _Leaf1B2_1B4_1B3_1B1_Ref }
  object { _Leaf1B2_1B4_1B3_1B2_Ref }
  object { _Leaf1B2_1B4_1B3_1B3_Ref }
  object { _Leaf1B2_1B4_1B3_1B4_Ref }
  object { _Leaf1B2_1B4_1B3_1B5_Ref }
  object { _Leaf1B2_1B4_1B3_1B6_Ref }
  object { _Leaf1B2_1B4_1B3_1B7_Ref }
  object { _Leaf1B2_1B4_1B3_1B8_Ref }
  object { _Leaf1B2_1B4_1B3_1B9_Ref }
  object { _Leaf1B2_1B4_1B3_1B10_Ref }
  object { _Leaf1B2_1B4_1B3_1B11_Ref }
  object { _Leaf1B2_1B4_1B3_1B12_Ref }
  object { _Leaf1B2_1B5_2B1_1B1_Ref }
  object { _Leaf1B2_1B5_2B1_1B2_Ref }
  object { _Leaf1B2_1B5_2B1_1B3_Ref }
  object { _Leaf1B2_1B5_2B1_1B4_Ref }
  object { _Leaf1B2_1B5_2B1_1B5_Ref }
  object { _Leaf1B2_1B5_2B1_1B6_Ref }
  object { _Leaf1B2_1B5_2B1_1B7_Ref }
  object { _Leaf1B2_1B5_2B1_1B8_Ref }
  object { _Leaf1B2_1B5_2B1_1B9_Ref }
  object { _Leaf1B2_1B5_2B1_1B10_Ref }
  object { _Leaf1B2_1B5_2B1_1B11_Ref }
  object { _Leaf1B2_1B5_2B1_1B12_Ref }
  object { _Leaf1B2_1B5_2B2_1B1_Ref }
  object { _Leaf1B2_1B5_2B2_1B2_Ref }
  object { _Leaf1B2_1B5_2B2_1B3_Ref }
  object { _Leaf1B2_1B5_2B2_1B4_Ref }
  object { _Leaf1B2_1B5_2B2_1B5_Ref }
  object { _Leaf1B2_1B5_2B2_1B6_Ref }
  object { _Leaf1B2_1B5_2B2_1B7_Ref }
  object { _Leaf1B2_1B5_2B2_1B8_Ref }
  object { _Leaf1B2_1B5_2B2_1B9_Ref }
  object { _Leaf1B2_1B5_2B2_1B10_Ref }
  object { _Leaf1B2_1B5_2B2_1B11_Ref }
  object { _Leaf1B2_1B5_2B2_1B12_Ref }
  object { _Leaf1B2_1B5_2B3_1B1_Ref }
  object { _Leaf1B2_1B5_2B3_1B2_Ref }
  object { _Leaf1B2_1B5_2B3_1B3_Ref }
  object { _Leaf1B2_1B5_2B3_1B4_Ref }
  object { _Leaf1B2_1B5_2B3_1B5_Ref }
  object { _Leaf1B2_1B5_2B3_1B6_Ref }
  object { _Leaf1B2_1B5_2B3_1B7_Ref }
  object { _Leaf1B2_1B5_2B3_1B8_Ref }
  object { _Leaf1B2_1B5_2B3_1B9_Ref }
  object { _Leaf1B2_1B5_2B3_1B10_Ref }
  object { _Leaf1B2_1B5_2B3_1B11_Ref }
  object { _Leaf1B2_1B5_2B3_1B12_Ref }
  object { _Leaf1B2_1B5_2B4_1B1_Ref }
  object { _Leaf1B2_1B5_2B4_1B2_Ref }
  object { _Leaf1B2_1B5_2B4_1B3_Ref }
  object { _Leaf1B2_1B5_2B4_1B4_Ref }
  object { _Leaf1B2_1B5_2B4_1B5_Ref }
  object { _Leaf1B2_1B5_2B4_1B6_Ref }
  object { _Leaf1B2_1B5_2B4_1B7_Ref }
  object { _Leaf1B2_1B5_2B4_1B8_Ref }
  object { _Leaf1B2_1B5_2B4_1B9_Ref }
  object { _Leaf1B2_1B5_2B4_1B10_Ref }
  object { _Leaf1B2_1B5_2B4_1B11_Ref }
  object { _Leaf1B2_1B5_2B4_1B12_Ref }
  object { _Leaf1B2_1B5_2B5_1B1_Ref }
  object { _Leaf1B2_1B5_2B5_1B2_Ref }
  object { _Leaf1B2_1B5_2B5_1B3_Ref }
  object { _Leaf1B2_1B5_2B5_1B4_Ref }
  object { _Leaf1B2_1B5_2B5_1B5_Ref }
  object { _Leaf1B2_1B5_2B5_1B6_Ref }
  object { _Leaf1B2_1B5_2B5_1B7_Ref }
  object { _Leaf1B2_1B5_2B5_1B8_Ref }
  object { _Leaf1B2_1B5_2B5_1B9_Ref }
  object { _Leaf1B2_1B5_2B5_1B10_Ref }
  object { _Leaf1B2_1B5_2B5_1B11_Ref }
  object { _Leaf1B2_1B5_2B5_1B12_Ref }
  object { _Leaf1B2_1B5_1B1_1B1_Ref }
  object { _Leaf1B2_1B5_1B1_1B2_Ref }
  object { _Leaf1B2_1B5_1B1_1B3_Ref }
  object { _Leaf1B2_1B5_1B1_1B4_Ref }
  object { _Leaf1B2_1B5_1B1_1B5_Ref }
  object { _Leaf1B2_1B5_1B1_1B6_Ref }
  object { _Leaf1B2_1B5_1B1_1B7_Ref }
  object { _Leaf1B2_1B5_1B1_1B8_Ref }
  object { _Leaf1B2_1B5_1B1_1B9_Ref }
  object { _Leaf1B2_1B5_1B1_1B10_Ref }
  object { _Leaf1B2_1B5_1B1_1B11_Ref }
  object { _Leaf1B2_1B5_1B1_1B12_Ref }
  object { _Leaf1B2_1B5_1B2_1B1_Ref }
  object { _Leaf1B2_1B5_1B2_1B2_Ref }
  object { _Leaf1B2_1B5_1B2_1B3_Ref }
  object { _Leaf1B2_1B5_1B2_1B4_Ref }
  object { _Leaf1B2_1B5_1B2_1B5_Ref }
  object { _Leaf1B2_1B5_1B2_1B6_Ref }
  object { _Leaf1B2_1B5_1B2_1B7_Ref }
  object { _Leaf1B2_1B5_1B2_1B8_Ref }
  object { _Leaf1B2_1B5_1B2_1B9_Ref }
  object { _Leaf1B2_1B5_1B2_1B10_Ref }
  object { _Leaf1B2_1B5_1B2_1B11_Ref }
  object { _Leaf1B2_1B5_1B2_1B12_Ref }
  object { _Leaf1B2_1B5_1B3_1B1_Ref }
  object { _Leaf1B2_1B5_1B3_1B2_Ref }
  object { _Leaf1B2_1B5_1B3_1B3_Ref }
  object { _Leaf1B2_1B5_1B3_1B4_Ref }
  object { _Leaf1B2_1B5_1B3_1B5_Ref }
  object { _Leaf1B2_1B5_1B3_1B6_Ref }
  object { _Leaf1B2_1B5_1B3_1B7_Ref }
  object { _Leaf1B2_1B5_1B3_1B8_Ref }
  object { _Leaf1B2_1B5_1B3_1B9_Ref }
  object { _Leaf1B2_1B5_1B3_1B10_Ref }
  object { _Leaf1B2_1B5_1B3_1B11_Ref }
  object { _Leaf1B2_1B5_1B3_1B12_Ref }
  object { _Leaf1B2_1B6_2B1_1B1_Ref }
  object { _Leaf1B2_1B6_2B1_1B2_Ref }
  object { _Leaf1B2_1B6_2B1_1B3_Ref }
  object { _Leaf1B2_1B6_2B1_1B4_Ref }
  object { _Leaf1B2_1B6_2B1_1B5_Ref }
  object { _Leaf1B2_1B6_2B1_1B6_Ref }
  object { _Leaf1B2_1B6_2B1_1B7_Ref }
  object { _Leaf1B2_1B6_2B1_1B8_Ref }
  object { _Leaf1B2_1B6_2B1_1B9_Ref }
  object { _Leaf1B2_1B6_2B1_1B10_Ref }
  object { _Leaf1B2_1B6_2B1_1B11_Ref }
  object { _Leaf1B2_1B6_2B1_1B12_Ref }
  object { _Leaf1B2_1B6_2B2_1B1_Ref }
  object { _Leaf1B2_1B6_2B2_1B2_Ref }
  object { _Leaf1B2_1B6_2B2_1B3_Ref }
  object { _Leaf1B2_1B6_2B2_1B4_Ref }
  object { _Leaf1B2_1B6_2B2_1B5_Ref }
  object { _Leaf1B2_1B6_2B2_1B6_Ref }
  object { _Leaf1B2_1B6_2B2_1B7_Ref }
  object { _Leaf1B2_1B6_2B2_1B8_Ref }
  object { _Leaf1B2_1B6_2B2_1B9_Ref }
  object { _Leaf1B2_1B6_2B2_1B10_Ref }
  object { _Leaf1B2_1B6_2B2_1B11_Ref }
  object { _Leaf1B2_1B6_2B2_1B12_Ref }
  object { _Leaf1B2_1B6_2B3_1B1_Ref }
  object { _Leaf1B2_1B6_2B3_1B2_Ref }
  object { _Leaf1B2_1B6_2B3_1B3_Ref }
  object { _Leaf1B2_1B6_2B3_1B4_Ref }
  object { _Leaf1B2_1B6_2B3_1B5_Ref }
  object { _Leaf1B2_1B6_2B3_1B6_Ref }
  object { _Leaf1B2_1B6_2B3_1B7_Ref }
  object { _Leaf1B2_1B6_2B3_1B8_Ref }
  object { _Leaf1B2_1B6_2B3_1B9_Ref }
  object { _Leaf1B2_1B6_2B3_1B10_Ref }
  object { _Leaf1B2_1B6_2B3_1B11_Ref }
  object { _Leaf1B2_1B6_2B3_1B12_Ref }
  object { _Leaf1B2_1B6_2B4_1B1_Ref }
  object { _Leaf1B2_1B6_2B4_1B2_Ref }
  object { _Leaf1B2_1B6_2B4_1B3_Ref }
  object { _Leaf1B2_1B6_2B4_1B4_Ref }
  object { _Leaf1B2_1B6_2B4_1B5_Ref }
  object { _Leaf1B2_1B6_2B4_1B6_Ref }
  object { _Leaf1B2_1B6_2B4_1B7_Ref }
  object { _Leaf1B2_1B6_2B4_1B8_Ref }
  object { _Leaf1B2_1B6_2B4_1B9_Ref }
  object { _Leaf1B2_1B6_2B4_1B10_Ref }
  object { _Leaf1B2_1B6_2B4_1B11_Ref }
  object { _Leaf1B2_1B6_2B4_1B12_Ref }
  object { _Leaf1B2_1B6_2B5_1B1_Ref }
  object { _Leaf1B2_1B6_2B5_1B2_Ref }
  object { _Leaf1B2_1B6_2B5_1B3_Ref }
  object { _Leaf1B2_1B6_2B5_1B4_Ref }
  object { _Leaf1B2_1B6_2B5_1B5_Ref }
  object { _Leaf1B2_1B6_2B5_1B6_Ref }
  object { _Leaf1B2_1B6_2B5_1B7_Ref }
  object { _Leaf1B2_1B6_2B5_1B8_Ref }
  object { _Leaf1B2_1B6_2B5_1B9_Ref }
  object { _Leaf1B2_1B6_2B5_1B10_Ref }
  object { _Leaf1B2_1B6_2B5_1B11_Ref }
  object { _Leaf1B2_1B6_2B5_1B12_Ref }
  object { _Leaf1B2_1B6_1B1_1B1_Ref }
  object { _Leaf1B2_1B6_1B1_1B2_Ref }
  object { _Leaf1B2_1B6_1B1_1B3_Ref }
  object { _Leaf1B2_1B6_1B1_1B4_Ref }
  object { _Leaf1B2_1B6_1B1_1B5_Ref }
  object { _Leaf1B2_1B6_1B1_1B6_Ref }
  object { _Leaf1B2_1B6_1B1_1B7_Ref }
  object { _Leaf1B2_1B6_1B1_1B8_Ref }
  object { _Leaf1B2_1B6_1B1_1B9_Ref }
  object { _Leaf1B2_1B6_1B1_1B10_Ref }
  object { _Leaf1B2_1B6_1B1_1B11_Ref }
  object { _Leaf1B2_1B6_1B1_1B12_Ref }
  object { _Leaf1B2_1B6_1B2_1B1_Ref }
  object { _Leaf1B2_1B6_1B2_1B2_Ref }
  object { _Leaf1B2_1B6_1B2_1B3_Ref }
  object { _Leaf1B2_1B6_1B2_1B4_Ref }
  object { _Leaf1B2_1B6_1B2_1B5_Ref }
  object { _Leaf1B2_1B6_1B2_1B6_Ref }
  object { _Leaf1B2_1B6_1B2_1B7_Ref }
  object { _Leaf1B2_1B6_1B2_1B8_Ref }
  object { _Leaf1B2_1B6_1B2_1B9_Ref }
  object { _Leaf1B2_1B6_1B2_1B10_Ref }
  object { _Leaf1B2_1B6_1B2_1B11_Ref }
  object { _Leaf1B2_1B6_1B2_1B12_Ref }
  object { _Leaf1B2_1B6_1B3_1B1_Ref }
  object { _Leaf1B2_1B6_1B3_1B2_Ref }
  object { _Leaf1B2_1B6_1B3_1B3_Ref }
  object { _Leaf1B2_1B6_1B3_1B4_Ref }
  object { _Leaf1B2_1B6_1B3_1B5_Ref }
  object { _Leaf1B2_1B6_1B3_1B6_Ref }
  object { _Leaf1B2_1B6_1B3_1B7_Ref }
  object { _Leaf1B2_1B6_1B3_1B8_Ref }
  object { _Leaf1B2_1B6_1B3_1B9_Ref }
  object { _Leaf1B2_1B6_1B3_1B10_Ref }
  object { _Leaf1B2_1B6_1B3_1B11_Ref }
  object { _Leaf1B2_1B6_1B3_1B12_Ref }
  object { _Leaf1B3_1B1_2B1_1B1_Ref }
  object { _Leaf1B3_1B1_2B1_1B2_Ref }
  object { _Leaf1B3_1B1_2B1_1B3_Ref }
  object { _Leaf1B3_1B1_2B1_1B4_Ref }
  object { _Leaf1B3_1B1_2B1_1B5_Ref }
  object { _Leaf1B3_1B1_2B1_1B6_Ref }
  object { _Leaf1B3_1B1_2B1_1B7_Ref }
  object { _Leaf1B3_1B1_2B1_1B8_Ref }
  object { _Leaf1B3_1B1_2B1_1B9_Ref }
  object { _Leaf1B3_1B1_2B1_1B10_Ref }
  object { _Leaf1B3_1B1_2B1_1B11_Ref }
  object { _Leaf1B3_1B1_2B1_1B12_Ref }
  object { _Leaf1B3_1B1_2B2_1B1_Ref }
  object { _Leaf1B3_1B1_2B2_1B2_Ref }
  object { _Leaf1B3_1B1_2B2_1B3_Ref }
  object { _Leaf1B3_1B1_2B2_1B4_Ref }
  object { _Leaf1B3_1B1_2B2_1B5_Ref }
  object { _Leaf1B3_1B1_2B2_1B6_Ref }
  object { _Leaf1B3_1B1_2B2_1B7_Ref }
  object { _Leaf1B3_1B1_2B2_1B8_Ref }
  object { _Leaf1B3_1B1_2B2_1B9_Ref }
  object { _Leaf1B3_1B1_2B2_1B10_Ref }
  object { _Leaf1B3_1B1_2B2_1B11_Ref }
  object { _Leaf1B3_1B1_2B2_1B12_Ref }
  object { _Leaf1B3_1B1_2B3_1B1_Ref }
  object { _Leaf1B3_1B1_2B3_1B2_Ref }
  object { _Leaf1B3_1B1_2B3_1B3_Ref }
  object { _Leaf1B3_1B1_2B3_1B4_Ref }
  object { _Leaf1B3_1B1_2B3_1B5_Ref }
  object { _Leaf1B3_1B1_2B3_1B6_Ref }
  object { _Leaf1B3_1B1_2B3_1B7_Ref }
  object { _Leaf1B3_1B1_2B3_1B8_Ref }
  object { _Leaf1B3_1B1_2B3_1B9_Ref }
  object { _Leaf1B3_1B1_2B3_1B10_Ref }
  object { _Leaf1B3_1B1_2B3_1B11_Ref }
  object { _Leaf1B3_1B1_2B3_1B12_Ref }
  object { _Leaf1B3_1B1_2B4_1B1_Ref }
  object { _Leaf1B3_1B1_2B4_1B2_Ref }
  object { _Leaf1B3_1B1_2B4_1B3_Ref }
  object { _Leaf1B3_1B1_2B4_1B4_Ref }
  object { _Leaf1B3_1B1_2B4_1B5_Ref }
  object { _Leaf1B3_1B1_2B4_1B6_Ref }
  object { _Leaf1B3_1B1_2B4_1B7_Ref }
  object { _Leaf1B3_1B1_2B4_1B8_Ref }
  object { _Leaf1B3_1B1_2B4_1B9_Ref }
  object { _Leaf1B3_1B1_2B4_1B10_Ref }
  object { _Leaf1B3_1B1_2B4_1B11_Ref }
  object { _Leaf1B3_1B1_2B4_1B12_Ref }
  object { _Leaf1B3_1B1_2B5_1B1_Ref }
  object { _Leaf1B3_1B1_2B5_1B2_Ref }
  object { _Leaf1B3_1B1_2B5_1B3_Ref }
  object { _Leaf1B3_1B1_2B5_1B4_Ref }
  object { _Leaf1B3_1B1_2B5_1B5_Ref }
  object { _Leaf1B3_1B1_2B5_1B6_Ref }
  object { _Leaf1B3_1B1_2B5_1B7_Ref }
  object { _Leaf1B3_1B1_2B5_1B8_Ref }
  object { _Leaf1B3_1B1_2B5_1B9_Ref }
  object { _Leaf1B3_1B1_2B5_1B10_Ref }
  object { _Leaf1B3_1B1_2B5_1B11_Ref }
  object { _Leaf1B3_1B1_2B5_1B12_Ref }
  object { _Leaf1B3_1B1_1B1_1B1_Ref }
  object { _Leaf1B3_1B1_1B1_1B2_Ref }
  object { _Leaf1B3_1B1_1B1_1B3_Ref }
  object { _Leaf1B3_1B1_1B1_1B4_Ref }
  object { _Leaf1B3_1B1_1B1_1B5_Ref }
  object { _Leaf1B3_1B1_1B1_1B6_Ref }
  object { _Leaf1B3_1B1_1B1_1B7_Ref }
  object { _Leaf1B3_1B1_1B1_1B8_Ref }
  object { _Leaf1B3_1B1_1B1_1B9_Ref }
  object { _Leaf1B3_1B1_1B1_1B10_Ref }
  object { _Leaf1B3_1B1_1B1_1B11_Ref }
  object { _Leaf1B3_1B1_1B1_1B12_Ref }
  object { _Leaf1B3_1B1_1B2_1B1_Ref }
  object { _Leaf1B3_1B1_1B2_1B2_Ref }
  object { _Leaf1B3_1B1_1B2_1B3_Ref }
  object { _Leaf1B3_1B1_1B2_1B4_Ref }
  object { _Leaf1B3_1B1_1B2_1B5_Ref }
  object { _Leaf1B3_1B1_1B2_1B6_Ref }
  object { _Leaf1B3_1B1_1B2_1B7_Ref }
  object { _Leaf1B3_1B1_1B2_1B8_Ref }
  object { _Leaf1B3_1B1_1B2_1B9_Ref }
  object { _Leaf1B3_1B1_1B2_1B10_Ref }
  object { _Leaf1B3_1B1_1B2_1B11_Ref }
  object { _Leaf1B3_1B1_1B2_1B12_Ref }
  object { _Leaf1B3_1B1_1B3_1B1_Ref }
  object { _Leaf1B3_1B1_1B3_1B2_Ref }
  object { _Leaf1B3_1B1_1B3_1B3_Ref }
  object { _Leaf1B3_1B1_1B3_1B4_Ref }
  object { _Leaf1B3_1B1_1B3_1B5_Ref }
  object { _Leaf1B3_1B1_1B3_1B6_Ref }
  object { _Leaf1B3_1B1_1B3_1B7_Ref }
  object { _Leaf1B3_1B1_1B3_1B8_Ref }
  object { _Leaf1B3_1B1_1B3_1B9_Ref }
  object { _Leaf1B3_1B1_1B3_1B10_Ref }
  object { _Leaf1B3_1B1_1B3_1B11_Ref }
  object { _Leaf1B3_1B1_1B3_1B12_Ref }
  object { _Leaf1B3_1B2_2B1_1B1_Ref }
  object { _Leaf1B3_1B2_2B1_1B2_Ref }
  object { _Leaf1B3_1B2_2B1_1B3_Ref }
  object { _Leaf1B3_1B2_2B1_1B4_Ref }
  object { _Leaf1B3_1B2_2B1_1B5_Ref }
  object { _Leaf1B3_1B2_2B1_1B6_Ref }
  object { _Leaf1B3_1B2_2B1_1B7_Ref }
  object { _Leaf1B3_1B2_2B1_1B8_Ref }
  object { _Leaf1B3_1B2_2B1_1B9_Ref }
  object { _Leaf1B3_1B2_2B1_1B10_Ref }
  object { _Leaf1B3_1B2_2B1_1B11_Ref }
  object { _Leaf1B3_1B2_2B1_1B12_Ref }
  object { _Leaf1B3_1B2_2B2_1B1_Ref }
  object { _Leaf1B3_1B2_2B2_1B2_Ref }
  object { _Leaf1B3_1B2_2B2_1B3_Ref }
  object { _Leaf1B3_1B2_2B2_1B4_Ref }
  object { _Leaf1B3_1B2_2B2_1B5_Ref }
  object { _Leaf1B3_1B2_2B2_1B6_Ref }
  object { _Leaf1B3_1B2_2B2_1B7_Ref }
  object { _Leaf1B3_1B2_2B2_1B8_Ref }
  object { _Leaf1B3_1B2_2B2_1B9_Ref }
  object { _Leaf1B3_1B2_2B2_1B10_Ref }
  object { _Leaf1B3_1B2_2B2_1B11_Ref }
  object { _Leaf1B3_1B2_2B2_1B12_Ref }
  object { _Leaf1B3_1B2_2B3_1B1_Ref }
  object { _Leaf1B3_1B2_2B3_1B2_Ref }
  object { _Leaf1B3_1B2_2B3_1B3_Ref }
  object { _Leaf1B3_1B2_2B3_1B4_Ref }
  object { _Leaf1B3_1B2_2B3_1B5_Ref }
  object { _Leaf1B3_1B2_2B3_1B6_Ref }
  object { _Leaf1B3_1B2_2B3_1B7_Ref }
  object { _Leaf1B3_1B2_2B3_1B8_Ref }
  object { _Leaf1B3_1B2_2B3_1B9_Ref }
  object { _Leaf1B3_1B2_2B3_1B10_Ref }
  object { _Leaf1B3_1B2_2B3_1B11_Ref }
  object { _Leaf1B3_1B2_2B3_1B12_Ref }
  object { _Leaf1B3_1B2_2B4_1B1_Ref }
  object { _Leaf1B3_1B2_2B4_1B2_Ref }
  object { _Leaf1B3_1B2_2B4_1B3_Ref }
  object { _Leaf1B3_1B2_2B4_1B4_Ref }
  object { _Leaf1B3_1B2_2B4_1B5_Ref }
  object { _Leaf1B3_1B2_2B4_1B6_Ref }
  object { _Leaf1B3_1B2_2B4_1B7_Ref }
  object { _Leaf1B3_1B2_2B4_1B8_Ref }
  object { _Leaf1B3_1B2_2B4_1B9_Ref }
  object { _Leaf1B3_1B2_2B4_1B10_Ref }
  object { _Leaf1B3_1B2_2B4_1B11_Ref }
  object { _Leaf1B3_1B2_2B4_1B12_Ref }
  object { _Leaf1B3_1B2_2B5_1B1_Ref }
  object { _Leaf1B3_1B2_2B5_1B2_Ref }
  object { _Leaf1B3_1B2_2B5_1B3_Ref }
  object { _Leaf1B3_1B2_2B5_1B4_Ref }
  object { _Leaf1B3_1B2_2B5_1B5_Ref }
  object { _Leaf1B3_1B2_2B5_1B6_Ref }
  object { _Leaf1B3_1B2_2B5_1B7_Ref }
  object { _Leaf1B3_1B2_2B5_1B8_Ref }
  object { _Leaf1B3_1B2_2B5_1B9_Ref }
  object { _Leaf1B3_1B2_2B5_1B10_Ref }
  object { _Leaf1B3_1B2_2B5_1B11_Ref }
  object { _Leaf1B3_1B2_2B5_1B12_Ref }
  object { _Leaf1B3_1B2_1B1_1B1_Ref }
  object { _Leaf1B3_1B2_1B1_1B2_Ref }
  object { _Leaf1B3_1B2_1B1_1B3_Ref }
  object { _Leaf1B3_1B2_1B1_1B4_Ref }
  object { _Leaf1B3_1B2_1B1_1B5_Ref }
  object { _Leaf1B3_1B2_1B1_1B6_Ref }
  object { _Leaf1B3_1B2_1B1_1B7_Ref }
  object { _Leaf1B3_1B2_1B1_1B8_Ref }
  object { _Leaf1B3_1B2_1B1_1B9_Ref }
  object { _Leaf1B3_1B2_1B1_1B10_Ref }
  object { _Leaf1B3_1B2_1B1_1B11_Ref }
  object { _Leaf1B3_1B2_1B1_1B12_Ref }
  object { _Leaf1B3_1B2_1B2_1B1_Ref }
  object { _Leaf1B3_1B2_1B2_1B2_Ref }
  object { _Leaf1B3_1B2_1B2_1B3_Ref }
  object { _Leaf1B3_1B2_1B2_1B4_Ref }
  object { _Leaf1B3_1B2_1B2_1B5_Ref }
  object { _Leaf1B3_1B2_1B2_1B6_Ref }
  object { _Leaf1B3_1B2_1B2_1B7_Ref }
  object { _Leaf1B3_1B2_1B2_1B8_Ref }
  object { _Leaf1B3_1B2_1B2_1B9_Ref }
  object { _Leaf1B3_1B2_1B2_1B10_Ref }
  object { _Leaf1B3_1B2_1B2_1B11_Ref }
  object { _Leaf1B3_1B2_1B2_1B12_Ref }
  object { _Leaf1B3_1B2_1B3_1B1_Ref }
  object { _Leaf1B3_1B2_1B3_1B2_Ref }
  object { _Leaf1B3_1B2_1B3_1B3_Ref }
  object { _Leaf1B3_1B2_1B3_1B4_Ref }
  object { _Leaf1B3_1B2_1B3_1B5_Ref }
  object { _Leaf1B3_1B2_1B3_1B6_Ref }
  object { _Leaf1B3_1B2_1B3_1B7_Ref }
  object { _Leaf1B3_1B2_1B3_1B8_Ref }
  object { _Leaf1B3_1B2_1B3_1B9_Ref }
  object { _Leaf1B3_1B2_1B3_1B10_Ref }
  object { _Leaf1B3_1B2_1B3_1B11_Ref }
  object { _Leaf1B3_1B2_1B3_1B12_Ref }
  object { _Leaf1B3_1B3_2B1_1B1_Ref }
  object { _Leaf1B3_1B3_2B1_1B2_Ref }
  object { _Leaf1B3_1B3_2B1_1B3_Ref }
  object { _Leaf1B3_1B3_2B1_1B4_Ref }
  object { _Leaf1B3_1B3_2B1_1B5_Ref }
  object { _Leaf1B3_1B3_2B1_1B6_Ref }
  object { _Leaf1B3_1B3_2B1_1B7_Ref }
  object { _Leaf1B3_1B3_2B1_1B8_Ref }
  object { _Leaf1B3_1B3_2B1_1B9_Ref }
  object { _Leaf1B3_1B3_2B1_1B10_Ref }
  object { _Leaf1B3_1B3_2B1_1B11_Ref }
  object { _Leaf1B3_1B3_2B1_1B12_Ref }
  object { _Leaf1B3_1B3_2B2_1B1_Ref }
  object { _Leaf1B3_1B3_2B2_1B2_Ref }
  object { _Leaf1B3_1B3_2B2_1B3_Ref }
  object { _Leaf1B3_1B3_2B2_1B4_Ref }
  object { _Leaf1B3_1B3_2B2_1B5_Ref }
  object { _Leaf1B3_1B3_2B2_1B6_Ref }
  object { _Leaf1B3_1B3_2B2_1B7_Ref }
  object { _Leaf1B3_1B3_2B2_1B8_Ref }
  object { _Leaf1B3_1B3_2B2_1B9_Ref }
  object { _Leaf1B3_1B3_2B2_1B10_Ref }
  object { _Leaf1B3_1B3_2B2_1B11_Ref }
  object { _Leaf1B3_1B3_2B2_1B12_Ref }
  object { _Leaf1B3_1B3_2B3_1B1_Ref }
  object { _Leaf1B3_1B3_2B3_1B2_Ref }
  object { _Leaf1B3_1B3_2B3_1B3_Ref }
  object { _Leaf1B3_1B3_2B3_1B4_Ref }
  object { _Leaf1B3_1B3_2B3_1B5_Ref }
  object { _Leaf1B3_1B3_2B3_1B6_Ref }
  object { _Leaf1B3_1B3_2B3_1B7_Ref }
  object { _Leaf1B3_1B3_2B3_1B8_Ref }
  object { _Leaf1B3_1B3_2B3_1B9_Ref }
  object { _Leaf1B3_1B3_2B3_1B10_Ref }
  object { _Leaf1B3_1B3_2B3_1B11_Ref }
  object { _Leaf1B3_1B3_2B3_1B12_Ref }
  object { _Leaf1B3_1B3_2B4_1B1_Ref }
  object { _Leaf1B3_1B3_2B4_1B2_Ref }
  object { _Leaf1B3_1B3_2B4_1B3_Ref }
  object { _Leaf1B3_1B3_2B4_1B4_Ref }
  object { _Leaf1B3_1B3_2B4_1B5_Ref }
  object { _Leaf1B3_1B3_2B4_1B6_Ref }
  object { _Leaf1B3_1B3_2B4_1B7_Ref }
  object { _Leaf1B3_1B3_2B4_1B8_Ref }
  object { _Leaf1B3_1B3_2B4_1B9_Ref }
  object { _Leaf1B3_1B3_2B4_1B10_Ref }
  object { _Leaf1B3_1B3_2B4_1B11_Ref }
  object { _Leaf1B3_1B3_2B4_1B12_Ref }
  object { _Leaf1B3_1B3_2B5_1B1_Ref }
  object { _Leaf1B3_1B3_2B5_1B2_Ref }
  object { _Leaf1B3_1B3_2B5_1B3_Ref }
  object { _Leaf1B3_1B3_2B5_1B4_Ref }
  object { _Leaf1B3_1B3_2B5_1B5_Ref }
  object { _Leaf1B3_1B3_2B5_1B6_Ref }
  object { _Leaf1B3_1B3_2B5_1B7_Ref }
  object { _Leaf1B3_1B3_2B5_1B8_Ref }
  object { _Leaf1B3_1B3_2B5_1B9_Ref }
  object { _Leaf1B3_1B3_2B5_1B10_Ref }
  object { _Leaf1B3_1B3_2B5_1B11_Ref }
  object { _Leaf1B3_1B3_2B5_1B12_Ref }
  object { _Leaf1B3_1B3_1B1_1B1_Ref }
  object { _Leaf1B3_1B3_1B1_1B2_Ref }
  object { _Leaf1B3_1B3_1B1_1B3_Ref }
  object { _Leaf1B3_1B3_1B1_1B4_Ref }
  object { _Leaf1B3_1B3_1B1_1B5_Ref }
  object { _Leaf1B3_1B3_1B1_1B6_Ref }
  object { _Leaf1B3_1B3_1B1_1B7_Ref }
  object { _Leaf1B3_1B3_1B1_1B8_Ref }
  object { _Leaf1B3_1B3_1B1_1B9_Ref }
  object { _Leaf1B3_1B3_1B1_1B10_Ref }
  object { _Leaf1B3_1B3_1B1_1B11_Ref }
  object { _Leaf1B3_1B3_1B1_1B12_Ref }
  object { _Leaf1B3_1B3_1B2_1B1_Ref }
  object { _Leaf1B3_1B3_1B2_1B2_Ref }
  object { _Leaf1B3_1B3_1B2_1B3_Ref }
  object { _Leaf1B3_1B3_1B2_1B4_Ref }
  object { _Leaf1B3_1B3_1B2_1B5_Ref }
  object { _Leaf1B3_1B3_1B2_1B6_Ref }
  object { _Leaf1B3_1B3_1B2_1B7_Ref }
  object { _Leaf1B3_1B3_1B2_1B8_Ref }
  object { _Leaf1B3_1B3_1B2_1B9_Ref }
  object { _Leaf1B3_1B3_1B2_1B10_Ref }
  object { _Leaf1B3_1B3_1B2_1B11_Ref }
  object { _Leaf1B3_1B3_1B2_1B12_Ref }
  object { _Leaf1B3_1B3_1B3_1B1_Ref }
  object { _Leaf1B3_1B3_1B3_1B2_Ref }
  object { _Leaf1B3_1B3_1B3_1B3_Ref }
  object { _Leaf1B3_1B3_1B3_1B4_Ref }
  object { _Leaf1B3_1B3_1B3_1B5_Ref }
  object { _Leaf1B3_1B3_1B3_1B6_Ref }
  object { _Leaf1B3_1B3_1B3_1B7_Ref }
  object { _Leaf1B3_1B3_1B3_1B8_Ref }
  object { _Leaf1B3_1B3_1B3_1B9_Ref }
  object { _Leaf1B3_1B3_1B3_1B10_Ref }
  object { _Leaf1B3_1B3_1B3_1B11_Ref }
  object { _Leaf1B3_1B3_1B3_1B12_Ref }
  object { _Leaf1B3_1B4_2B1_1B1_Ref }
  object { _Leaf1B3_1B4_2B1_1B2_Ref }
  object { _Leaf1B3_1B4_2B1_1B3_Ref }
  object { _Leaf1B3_1B4_2B1_1B4_Ref }
  object { _Leaf1B3_1B4_2B1_1B5_Ref }
  object { _Leaf1B3_1B4_2B1_1B6_Ref }
  object { _Leaf1B3_1B4_2B1_1B7_Ref }
  object { _Leaf1B3_1B4_2B1_1B8_Ref }
  object { _Leaf1B3_1B4_2B1_1B9_Ref }
  object { _Leaf1B3_1B4_2B1_1B10_Ref }
  object { _Leaf1B3_1B4_2B1_1B11_Ref }
  object { _Leaf1B3_1B4_2B1_1B12_Ref }
  object { _Leaf1B3_1B4_2B2_1B1_Ref }
  object { _Leaf1B3_1B4_2B2_1B2_Ref }
  object { _Leaf1B3_1B4_2B2_1B3_Ref }
  object { _Leaf1B3_1B4_2B2_1B4_Ref }
  object { _Leaf1B3_1B4_2B2_1B5_Ref }
  object { _Leaf1B3_1B4_2B2_1B6_Ref }
  object { _Leaf1B3_1B4_2B2_1B7_Ref }
  object { _Leaf1B3_1B4_2B2_1B8_Ref }
  object { _Leaf1B3_1B4_2B2_1B9_Ref }
  object { _Leaf1B3_1B4_2B2_1B10_Ref }
  object { _Leaf1B3_1B4_2B2_1B11_Ref }
  object { _Leaf1B3_1B4_2B2_1B12_Ref }
  object { _Leaf1B3_1B4_2B3_1B1_Ref }
  object { _Leaf1B3_1B4_2B3_1B2_Ref }
  object { _Leaf1B3_1B4_2B3_1B3_Ref }
  object { _Leaf1B3_1B4_2B3_1B4_Ref }
  object { _Leaf1B3_1B4_2B3_1B5_Ref }
  object { _Leaf1B3_1B4_2B3_1B6_Ref }
  object { _Leaf1B3_1B4_2B3_1B7_Ref }
  object { _Leaf1B3_1B4_2B3_1B8_Ref }
  object { _Leaf1B3_1B4_2B3_1B9_Ref }
  object { _Leaf1B3_1B4_2B3_1B10_Ref }
  object { _Leaf1B3_1B4_2B3_1B11_Ref }
  object { _Leaf1B3_1B4_2B3_1B12_Ref }
  object { _Leaf1B3_1B4_2B4_1B1_Ref }
  object { _Leaf1B3_1B4_2B4_1B2_Ref }
  object { _Leaf1B3_1B4_2B4_1B3_Ref }
  object { _Leaf1B3_1B4_2B4_1B4_Ref }
  object { _Leaf1B3_1B4_2B4_1B5_Ref }
  object { _Leaf1B3_1B4_2B4_1B6_Ref }
  object { _Leaf1B3_1B4_2B4_1B7_Ref }
  object { _Leaf1B3_1B4_2B4_1B8_Ref }
  object { _Leaf1B3_1B4_2B4_1B9_Ref }
  object { _Leaf1B3_1B4_2B4_1B10_Ref }
  object { _Leaf1B3_1B4_2B4_1B11_Ref }
  object { _Leaf1B3_1B4_2B4_1B12_Ref }
  object { _Leaf1B3_1B4_2B5_1B1_Ref }
  object { _Leaf1B3_1B4_2B5_1B2_Ref }
  object { _Leaf1B3_1B4_2B5_1B3_Ref }
  object { _Leaf1B3_1B4_2B5_1B4_Ref }
  object { _Leaf1B3_1B4_2B5_1B5_Ref }
  object { _Leaf1B3_1B4_2B5_1B6_Ref }
  object { _Leaf1B3_1B4_2B5_1B7_Ref }
  object { _Leaf1B3_1B4_2B5_1B8_Ref }
  object { _Leaf1B3_1B4_2B5_1B9_Ref }
  object { _Leaf1B3_1B4_2B5_1B10_Ref }
  object { _Leaf1B3_1B4_2B5_1B11_Ref }
  object { _Leaf1B3_1B4_2B5_1B12_Ref }
  object { _Leaf1B3_1B4_1B1_1B1_Ref }
  object { _Leaf1B3_1B4_1B1_1B2_Ref }
  object { _Leaf1B3_1B4_1B1_1B3_Ref }
  object { _Leaf1B3_1B4_1B1_1B4_Ref }
  object { _Leaf1B3_1B4_1B1_1B5_Ref }
  object { _Leaf1B3_1B4_1B1_1B6_Ref }
  object { _Leaf1B3_1B4_1B1_1B7_Ref }
  object { _Leaf1B3_1B4_1B1_1B8_Ref }
  object { _Leaf1B3_1B4_1B1_1B9_Ref }
  object { _Leaf1B3_1B4_1B1_1B10_Ref }
  object { _Leaf1B3_1B4_1B1_1B11_Ref }
  object { _Leaf1B3_1B4_1B1_1B12_Ref }
  object { _Leaf1B3_1B4_1B2_1B1_Ref }
  object { _Leaf1B3_1B4_1B2_1B2_Ref }
  object { _Leaf1B3_1B4_1B2_1B3_Ref }
  object { _Leaf1B3_1B4_1B2_1B4_Ref }
  object { _Leaf1B3_1B4_1B2_1B5_Ref }
  object { _Leaf1B3_1B4_1B2_1B6_Ref }
  object { _Leaf1B3_1B4_1B2_1B7_Ref }
  object { _Leaf1B3_1B4_1B2_1B8_Ref }
  object { _Leaf1B3_1B4_1B2_1B9_Ref }
  object { _Leaf1B3_1B4_1B2_1B10_Ref }
  object { _Leaf1B3_1B4_1B2_1B11_Ref }
  object { _Leaf1B3_1B4_1B2_1B12_Ref }
  object { _Leaf1B3_1B4_1B3_1B1_Ref }
  object { _Leaf1B3_1B4_1B3_1B2_Ref }
  object { _Leaf1B3_1B4_1B3_1B3_Ref }
  object { _Leaf1B3_1B4_1B3_1B4_Ref }
  object { _Leaf1B3_1B4_1B3_1B5_Ref }
  object { _Leaf1B3_1B4_1B3_1B6_Ref }
  object { _Leaf1B3_1B4_1B3_1B7_Ref }
  object { _Leaf1B3_1B4_1B3_1B8_Ref }
  object { _Leaf1B3_1B4_1B3_1B9_Ref }
  object { _Leaf1B3_1B4_1B3_1B10_Ref }
  object { _Leaf1B3_1B4_1B3_1B11_Ref }
  object { _Leaf1B3_1B4_1B3_1B12_Ref }
  object { _Leaf1B3_1B5_2B1_1B1_Ref }
  object { _Leaf1B3_1B5_2B1_1B2_Ref }
  object { _Leaf1B3_1B5_2B1_1B3_Ref }
  object { _Leaf1B3_1B5_2B1_1B4_Ref }
  object { _Leaf1B3_1B5_2B1_1B5_Ref }
  object { _Leaf1B3_1B5_2B1_1B6_Ref }
  object { _Leaf1B3_1B5_2B1_1B7_Ref }
  object { _Leaf1B3_1B5_2B1_1B8_Ref }
  object { _Leaf1B3_1B5_2B1_1B9_Ref }
  object { _Leaf1B3_1B5_2B1_1B10_Ref }
  object { _Leaf1B3_1B5_2B1_1B11_Ref }
  object { _Leaf1B3_1B5_2B1_1B12_Ref }
  object { _Leaf1B3_1B5_2B2_1B1_Ref }
  object { _Leaf1B3_1B5_2B2_1B2_Ref }
  object { _Leaf1B3_1B5_2B2_1B3_Ref }
  object { _Leaf1B3_1B5_2B2_1B4_Ref }
  object { _Leaf1B3_1B5_2B2_1B5_Ref }
  object { _Leaf1B3_1B5_2B2_1B6_Ref }
  object { _Leaf1B3_1B5_2B2_1B7_Ref }
  object { _Leaf1B3_1B5_2B2_1B8_Ref }
  object { _Leaf1B3_1B5_2B2_1B9_Ref }
  object { _Leaf1B3_1B5_2B2_1B10_Ref }
  object { _Leaf1B3_1B5_2B2_1B11_Ref }
  object { _Leaf1B3_1B5_2B2_1B12_Ref }
  object { _Leaf1B3_1B5_2B3_1B1_Ref }
  object { _Leaf1B3_1B5_2B3_1B2_Ref }
  object { _Leaf1B3_1B5_2B3_1B3_Ref }
  object { _Leaf1B3_1B5_2B3_1B4_Ref }
  object { _Leaf1B3_1B5_2B3_1B5_Ref }
  object { _Leaf1B3_1B5_2B3_1B6_Ref }
  object { _Leaf1B3_1B5_2B3_1B7_Ref }
  object { _Leaf1B3_1B5_2B3_1B8_Ref }
  object { _Leaf1B3_1B5_2B3_1B9_Ref }
  object { _Leaf1B3_1B5_2B3_1B10_Ref }
  object { _Leaf1B3_1B5_2B3_1B11_Ref }
  object { _Leaf1B3_1B5_2B3_1B12_Ref }
  object { _Leaf1B3_1B5_2B4_1B1_Ref }
  object { _Leaf1B3_1B5_2B4_1B2_Ref }
  object { _Leaf1B3_1B5_2B4_1B3_Ref }
  object { _Leaf1B3_1B5_2B4_1B4_Ref }
  object { _Leaf1B3_1B5_2B4_1B5_Ref }
  object { _Leaf1B3_1B5_2B4_1B6_Ref }
  object { _Leaf1B3_1B5_2B4_1B7_Ref }
  object { _Leaf1B3_1B5_2B4_1B8_Ref }
  object { _Leaf1B3_1B5_2B4_1B9_Ref }
  object { _Leaf1B3_1B5_2B4_1B10_Ref }
  object { _Leaf1B3_1B5_2B4_1B11_Ref }
  object { _Leaf1B3_1B5_2B4_1B12_Ref }
  object { _Leaf1B3_1B5_2B5_1B1_Ref }
  object { _Leaf1B3_1B5_2B5_1B2_Ref }
  object { _Leaf1B3_1B5_2B5_1B3_Ref }
  object { _Leaf1B3_1B5_2B5_1B4_Ref }
  object { _Leaf1B3_1B5_2B5_1B5_Ref }
  object { _Leaf1B3_1B5_2B5_1B6_Ref }
  object { _Leaf1B3_1B5_2B5_1B7_Ref }
  object { _Leaf1B3_1B5_2B5_1B8_Ref }
  object { _Leaf1B3_1B5_2B5_1B9_Ref }
  object { _Leaf1B3_1B5_2B5_1B10_Ref }
  object { _Leaf1B3_1B5_2B5_1B11_Ref }
  object { _Leaf1B3_1B5_2B5_1B12_Ref }
  object { _Leaf1B3_1B5_1B1_1B1_Ref }
  object { _Leaf1B3_1B5_1B1_1B2_Ref }
  object { _Leaf1B3_1B5_1B1_1B3_Ref }
  object { _Leaf1B3_1B5_1B1_1B4_Ref }
  object { _Leaf1B3_1B5_1B1_1B5_Ref }
  object { _Leaf1B3_1B5_1B1_1B6_Ref }
  object { _Leaf1B3_1B5_1B1_1B7_Ref }
  object { _Leaf1B3_1B5_1B1_1B8_Ref }
  object { _Leaf1B3_1B5_1B1_1B9_Ref }
  object { _Leaf1B3_1B5_1B1_1B10_Ref }
  object { _Leaf1B3_1B5_1B1_1B11_Ref }
  object { _Leaf1B3_1B5_1B1_1B12_Ref }
  object { _Leaf1B3_1B5_1B2_1B1_Ref }
  object { _Leaf1B3_1B5_1B2_1B2_Ref }
  object { _Leaf1B3_1B5_1B2_1B3_Ref }
  object { _Leaf1B3_1B5_1B2_1B4_Ref }
  object { _Leaf1B3_1B5_1B2_1B5_Ref }
  object { _Leaf1B3_1B5_1B2_1B6_Ref }
  object { _Leaf1B3_1B5_1B2_1B7_Ref }
  object { _Leaf1B3_1B5_1B2_1B8_Ref }
  object { _Leaf1B3_1B5_1B2_1B9_Ref }
  object { _Leaf1B3_1B5_1B2_1B10_Ref }
  object { _Leaf1B3_1B5_1B2_1B11_Ref }
  object { _Leaf1B3_1B5_1B2_1B12_Ref }
  object { _Leaf1B3_1B5_1B3_1B1_Ref }
  object { _Leaf1B3_1B5_1B3_1B2_Ref }
  object { _Leaf1B3_1B5_1B3_1B3_Ref }
  object { _Leaf1B3_1B5_1B3_1B4_Ref }
  object { _Leaf1B3_1B5_1B3_1B5_Ref }
  object { _Leaf1B3_1B5_1B3_1B6_Ref }
  object { _Leaf1B3_1B5_1B3_1B7_Ref }
  object { _Leaf1B3_1B5_1B3_1B8_Ref }
  object { _Leaf1B3_1B5_1B3_1B9_Ref }
  object { _Leaf1B3_1B5_1B3_1B10_Ref }
  object { _Leaf1B3_1B5_1B3_1B11_Ref }
  object { _Leaf1B3_1B5_1B3_1B12_Ref }
  object { _Leaf1B3_1B6_2B1_1B1_Ref }
  object { _Leaf1B3_1B6_2B1_1B2_Ref }
  object { _Leaf1B3_1B6_2B1_1B3_Ref }
  object { _Leaf1B3_1B6_2B1_1B4_Ref }
  object { _Leaf1B3_1B6_2B1_1B5_Ref }
  object { _Leaf1B3_1B6_2B1_1B6_Ref }
  object { _Leaf1B3_1B6_2B1_1B7_Ref }
  object { _Leaf1B3_1B6_2B1_1B8_Ref }
  object { _Leaf1B3_1B6_2B1_1B9_Ref }
  object { _Leaf1B3_1B6_2B1_1B10_Ref }
  object { _Leaf1B3_1B6_2B1_1B11_Ref }
  object { _Leaf1B3_1B6_2B1_1B12_Ref }
  object { _Leaf1B3_1B6_2B2_1B1_Ref }
  object { _Leaf1B3_1B6_2B2_1B2_Ref }
  object { _Leaf1B3_1B6_2B2_1B3_Ref }
  object { _Leaf1B3_1B6_2B2_1B4_Ref }
  object { _Leaf1B3_1B6_2B2_1B5_Ref }
  object { _Leaf1B3_1B6_2B2_1B6_Ref }
  object { _Leaf1B3_1B6_2B2_1B7_Ref }
  object { _Leaf1B3_1B6_2B2_1B8_Ref }
  object { _Leaf1B3_1B6_2B2_1B9_Ref }
  object { _Leaf1B3_1B6_2B2_1B10_Ref }
  object { _Leaf1B3_1B6_2B2_1B11_Ref }
  object { _Leaf1B3_1B6_2B2_1B12_Ref }
  object { _Leaf1B3_1B6_2B3_1B1_Ref }
  object { _Leaf1B3_1B6_2B3_1B2_Ref }
  object { _Leaf1B3_1B6_2B3_1B3_Ref }
  object { _Leaf1B3_1B6_2B3_1B4_Ref }
  object { _Leaf1B3_1B6_2B3_1B5_Ref }
  object { _Leaf1B3_1B6_2B3_1B6_Ref }
  object { _Leaf1B3_1B6_2B3_1B7_Ref }
  object { _Leaf1B3_1B6_2B3_1B8_Ref }
  object { _Leaf1B3_1B6_2B3_1B9_Ref }
  object { _Leaf1B3_1B6_2B3_1B10_Ref }
  object { _Leaf1B3_1B6_2B3_1B11_Ref }
  object { _Leaf1B3_1B6_2B3_1B12_Ref }
  object { _Leaf1B3_1B6_2B4_1B1_Ref }
  object { _Leaf1B3_1B6_2B4_1B2_Ref }
  object { _Leaf1B3_1B6_2B4_1B3_Ref }
  object { _Leaf1B3_1B6_2B4_1B4_Ref }
  object { _Leaf1B3_1B6_2B4_1B5_Ref }
  object { _Leaf1B3_1B6_2B4_1B6_Ref }
  object { _Leaf1B3_1B6_2B4_1B7_Ref }
  object { _Leaf1B3_1B6_2B4_1B8_Ref }
  object { _Leaf1B3_1B6_2B4_1B9_Ref }
  object { _Leaf1B3_1B6_2B4_1B10_Ref }
  object { _Leaf1B3_1B6_2B4_1B11_Ref }
  object { _Leaf1B3_1B6_2B4_1B12_Ref }
  object { _Leaf1B3_1B6_2B5_1B1_Ref }
  object { _Leaf1B3_1B6_2B5_1B2_Ref }
  object { _Leaf1B3_1B6_2B5_1B3_Ref }
  object { _Leaf1B3_1B6_2B5_1B4_Ref }
  object { _Leaf1B3_1B6_2B5_1B5_Ref }
  object { _Leaf1B3_1B6_2B5_1B6_Ref }
  object { _Leaf1B3_1B6_2B5_1B7_Ref }
  object { _Leaf1B3_1B6_2B5_1B8_Ref }
  object { _Leaf1B3_1B6_2B5_1B9_Ref }
  object { _Leaf1B3_1B6_2B5_1B10_Ref }
  object { _Leaf1B3_1B6_2B5_1B11_Ref }
  object { _Leaf1B3_1B6_2B5_1B12_Ref }
  object { _Leaf1B3_1B6_1B1_1B1_Ref }
  object { _Leaf1B3_1B6_1B1_1B2_Ref }
  object { _Leaf1B3_1B6_1B1_1B3_Ref }
  object { _Leaf1B3_1B6_1B1_1B4_Ref }
  object { _Leaf1B3_1B6_1B1_1B5_Ref }
  object { _Leaf1B3_1B6_1B1_1B6_Ref }
  object { _Leaf1B3_1B6_1B1_1B7_Ref }
  object { _Leaf1B3_1B6_1B1_1B8_Ref }
  object { _Leaf1B3_1B6_1B1_1B9_Ref }
  object { _Leaf1B3_1B6_1B1_1B10_Ref }
  object { _Leaf1B3_1B6_1B1_1B11_Ref }
  object { _Leaf1B3_1B6_1B1_1B12_Ref }
  object { _Leaf1B3_1B6_1B2_1B1_Ref }
  object { _Leaf1B3_1B6_1B2_1B2_Ref }
  object { _Leaf1B3_1B6_1B2_1B3_Ref }
  object { _Leaf1B3_1B6_1B2_1B4_Ref }
  object { _Leaf1B3_1B6_1B2_1B5_Ref }
  object { _Leaf1B3_1B6_1B2_1B6_Ref }
  object { _Leaf1B3_1B6_1B2_1B7_Ref }
  object { _Leaf1B3_1B6_1B2_1B8_Ref }
  object { _Leaf1B3_1B6_1B2_1B9_Ref }
  object { _Leaf1B3_1B6_1B2_1B10_Ref }
  object { _Leaf1B3_1B6_1B2_1B11_Ref }
  object { _Leaf1B3_1B6_1B2_1B12_Ref }
  object { _Leaf1B3_1B6_1B3_1B1_Ref }
  object { _Leaf1B3_1B6_1B3_1B2_Ref }
  object { _Leaf1B3_1B6_1B3_1B3_Ref }
  object { _Leaf1B3_1B6_1B3_1B4_Ref }
  object { _Leaf1B3_1B6_1B3_1B5_Ref }
  object { _Leaf1B3_1B6_1B3_1B6_Ref }
  object { _Leaf1B3_1B6_1B3_1B7_Ref }
  object { _Leaf1B3_1B6_1B3_1B8_Ref }
  object { _Leaf1B3_1B6_1B3_1B9_Ref }
  object { _Leaf1B3_1B6_1B3_1B10_Ref }
  object { _Leaf1B3_1B6_1B3_1B11_Ref }
  object { _Leaf1B3_1B6_1B3_1B12_Ref }
  object { _Leaf1B4_1B1_2B1_1B1_Ref }
  object { _Leaf1B4_1B1_2B1_1B2_Ref }
  object { _Leaf1B4_1B1_2B1_1B3_Ref }
  object { _Leaf1B4_1B1_2B1_1B4_Ref }
  object { _Leaf1B4_1B1_2B1_1B5_Ref }
  object { _Leaf1B4_1B1_2B1_1B6_Ref }
  object { _Leaf1B4_1B1_2B1_1B7_Ref }
  object { _Leaf1B4_1B1_2B1_1B8_Ref }
  object { _Leaf1B4_1B1_2B1_1B9_Ref }
  object { _Leaf1B4_1B1_2B1_1B10_Ref }
  object { _Leaf1B4_1B1_2B1_1B11_Ref }
  object { _Leaf1B4_1B1_2B1_1B12_Ref }
  object { _Leaf1B4_1B1_2B2_1B1_Ref }
  object { _Leaf1B4_1B1_2B2_1B2_Ref }
  object { _Leaf1B4_1B1_2B2_1B3_Ref }
  object { _Leaf1B4_1B1_2B2_1B4_Ref }
  object { _Leaf1B4_1B1_2B2_1B5_Ref }
  object { _Leaf1B4_1B1_2B2_1B6_Ref }
  object { _Leaf1B4_1B1_2B2_1B7_Ref }
  object { _Leaf1B4_1B1_2B2_1B8_Ref }
  object { _Leaf1B4_1B1_2B2_1B9_Ref }
  object { _Leaf1B4_1B1_2B2_1B10_Ref }
  object { _Leaf1B4_1B1_2B2_1B11_Ref }
  object { _Leaf1B4_1B1_2B2_1B12_Ref }
  object { _Leaf1B4_1B1_2B3_1B1_Ref }
  object { _Leaf1B4_1B1_2B3_1B2_Ref }
  object { _Leaf1B4_1B1_2B3_1B3_Ref }
  object { _Leaf1B4_1B1_2B3_1B4_Ref }
  object { _Leaf1B4_1B1_2B3_1B5_Ref }
  object { _Leaf1B4_1B1_2B3_1B6_Ref }
  object { _Leaf1B4_1B1_2B3_1B7_Ref }
  object { _Leaf1B4_1B1_2B3_1B8_Ref }
  object { _Leaf1B4_1B1_2B3_1B9_Ref }
  object { _Leaf1B4_1B1_2B3_1B10_Ref }
  object { _Leaf1B4_1B1_2B3_1B11_Ref }
  object { _Leaf1B4_1B1_2B3_1B12_Ref }
  object { _Leaf1B4_1B1_2B4_1B1_Ref }
  object { _Leaf1B4_1B1_2B4_1B2_Ref }
  object { _Leaf1B4_1B1_2B4_1B3_Ref }
  object { _Leaf1B4_1B1_2B4_1B4_Ref }
  object { _Leaf1B4_1B1_2B4_1B5_Ref }
  object { _Leaf1B4_1B1_2B4_1B6_Ref }
  object { _Leaf1B4_1B1_2B4_1B7_Ref }
  object { _Leaf1B4_1B1_2B4_1B8_Ref }
  object { _Leaf1B4_1B1_2B4_1B9_Ref }
  object { _Leaf1B4_1B1_2B4_1B10_Ref }
  object { _Leaf1B4_1B1_2B4_1B11_Ref }
  object { _Leaf1B4_1B1_2B4_1B12_Ref }
  object { _Leaf1B4_1B1_2B5_1B1_Ref }
  object { _Leaf1B4_1B1_2B5_1B2_Ref }
  object { _Leaf1B4_1B1_2B5_1B3_Ref }
  object { _Leaf1B4_1B1_2B5_1B4_Ref }
  object { _Leaf1B4_1B1_2B5_1B5_Ref }
  object { _Leaf1B4_1B1_2B5_1B6_Ref }
  object { _Leaf1B4_1B1_2B5_1B7_Ref }
  object { _Leaf1B4_1B1_2B5_1B8_Ref }
  object { _Leaf1B4_1B1_2B5_1B9_Ref }
  object { _Leaf1B4_1B1_2B5_1B10_Ref }
  object { _Leaf1B4_1B1_2B5_1B11_Ref }
  object { _Leaf1B4_1B1_2B5_1B12_Ref }
  object { _Leaf1B4_1B1_1B1_1B1_Ref }
  object { _Leaf1B4_1B1_1B1_1B2_Ref }
  object { _Leaf1B4_1B1_1B1_1B3_Ref }
  object { _Leaf1B4_1B1_1B1_1B4_Ref }
  object { _Leaf1B4_1B1_1B1_1B5_Ref }
  object { _Leaf1B4_1B1_1B1_1B6_Ref }
  object { _Leaf1B4_1B1_1B1_1B7_Ref }
  object { _Leaf1B4_1B1_1B1_1B8_Ref }
  object { _Leaf1B4_1B1_1B1_1B9_Ref }
  object { _Leaf1B4_1B1_1B1_1B10_Ref }
  object { _Leaf1B4_1B1_1B1_1B11_Ref }
  object { _Leaf1B4_1B1_1B1_1B12_Ref }
  object { _Leaf1B4_1B1_1B2_1B1_Ref }
  object { _Leaf1B4_1B1_1B2_1B2_Ref }
  object { _Leaf1B4_1B1_1B2_1B3_Ref }
  object { _Leaf1B4_1B1_1B2_1B4_Ref }
  object { _Leaf1B4_1B1_1B2_1B5_Ref }
  object { _Leaf1B4_1B1_1B2_1B6_Ref }
  object { _Leaf1B4_1B1_1B2_1B7_Ref }
  object { _Leaf1B4_1B1_1B2_1B8_Ref }
  object { _Leaf1B4_1B1_1B2_1B9_Ref }
  object { _Leaf1B4_1B1_1B2_1B10_Ref }
  object { _Leaf1B4_1B1_1B2_1B11_Ref }
  object { _Leaf1B4_1B1_1B2_1B12_Ref }
  object { _Leaf1B4_1B1_1B3_1B1_Ref }
  object { _Leaf1B4_1B1_1B3_1B2_Ref }
  object { _Leaf1B4_1B1_1B3_1B3_Ref }
  object { _Leaf1B4_1B1_1B3_1B4_Ref }
  object { _Leaf1B4_1B1_1B3_1B5_Ref }
  object { _Leaf1B4_1B1_1B3_1B6_Ref }
  object { _Leaf1B4_1B1_1B3_1B7_Ref }
  object { _Leaf1B4_1B1_1B3_1B8_Ref }
  object { _Leaf1B4_1B1_1B3_1B9_Ref }
  object { _Leaf1B4_1B1_1B3_1B10_Ref }
  object { _Leaf1B4_1B1_1B3_1B11_Ref }
  object { _Leaf1B4_1B1_1B3_1B12_Ref }
  object { _Leaf1B4_1B2_2B1_1B1_Ref }
  object { _Leaf1B4_1B2_2B1_1B2_Ref }
  object { _Leaf1B4_1B2_2B1_1B3_Ref }
  object { _Leaf1B4_1B2_2B1_1B4_Ref }
  object { _Leaf1B4_1B2_2B1_1B5_Ref }
  object { _Leaf1B4_1B2_2B1_1B6_Ref }
  object { _Leaf1B4_1B2_2B1_1B7_Ref }
  object { _Leaf1B4_1B2_2B1_1B8_Ref }
  object { _Leaf1B4_1B2_2B1_1B9_Ref }
  object { _Leaf1B4_1B2_2B1_1B10_Ref }
  object { _Leaf1B4_1B2_2B1_1B11_Ref }
  object { _Leaf1B4_1B2_2B1_1B12_Ref }
  object { _Leaf1B4_1B2_2B2_1B1_Ref }
  object { _Leaf1B4_1B2_2B2_1B2_Ref }
  object { _Leaf1B4_1B2_2B2_1B3_Ref }
  object { _Leaf1B4_1B2_2B2_1B4_Ref }
  object { _Leaf1B4_1B2_2B2_1B5_Ref }
  object { _Leaf1B4_1B2_2B2_1B6_Ref }
  object { _Leaf1B4_1B2_2B2_1B7_Ref }
  object { _Leaf1B4_1B2_2B2_1B8_Ref }
  object { _Leaf1B4_1B2_2B2_1B9_Ref }
  object { _Leaf1B4_1B2_2B2_1B10_Ref }
  object { _Leaf1B4_1B2_2B2_1B11_Ref }
  object { _Leaf1B4_1B2_2B2_1B12_Ref }
  object { _Leaf1B4_1B2_2B3_1B1_Ref }
  object { _Leaf1B4_1B2_2B3_1B2_Ref }
  object { _Leaf1B4_1B2_2B3_1B3_Ref }
  object { _Leaf1B4_1B2_2B3_1B4_Ref }
  object { _Leaf1B4_1B2_2B3_1B5_Ref }
  object { _Leaf1B4_1B2_2B3_1B6_Ref }
  object { _Leaf1B4_1B2_2B3_1B7_Ref }
  object { _Leaf1B4_1B2_2B3_1B8_Ref }
  object { _Leaf1B4_1B2_2B3_1B9_Ref }
  object { _Leaf1B4_1B2_2B3_1B10_Ref }
  object { _Leaf1B4_1B2_2B3_1B11_Ref }
  object { _Leaf1B4_1B2_2B3_1B12_Ref }
  object { _Leaf1B4_1B2_2B4_1B1_Ref }
  object { _Leaf1B4_1B2_2B4_1B2_Ref }
  object { _Leaf1B4_1B2_2B4_1B3_Ref }
  object { _Leaf1B4_1B2_2B4_1B4_Ref }
  object { _Leaf1B4_1B2_2B4_1B5_Ref }
  object { _Leaf1B4_1B2_2B4_1B6_Ref }
  object { _Leaf1B4_1B2_2B4_1B7_Ref }
  object { _Leaf1B4_1B2_2B4_1B8_Ref }
  object { _Leaf1B4_1B2_2B4_1B9_Ref }
  object { _Leaf1B4_1B2_2B4_1B10_Ref }
  object { _Leaf1B4_1B2_2B4_1B11_Ref }
  object { _Leaf1B4_1B2_2B4_1B12_Ref }
  object { _Leaf1B4_1B2_2B5_1B1_Ref }
  object { _Leaf1B4_1B2_2B5_1B2_Ref }
  object { _Leaf1B4_1B2_2B5_1B3_Ref }
  object { _Leaf1B4_1B2_2B5_1B4_Ref }
  object { _Leaf1B4_1B2_2B5_1B5_Ref }
  object { _Leaf1B4_1B2_2B5_1B6_Ref }
  object { _Leaf1B4_1B2_2B5_1B7_Ref }
  object { _Leaf1B4_1B2_2B5_1B8_Ref }
  object { _Leaf1B4_1B2_2B5_1B9_Ref }
  object { _Leaf1B4_1B2_2B5_1B10_Ref }
  object { _Leaf1B4_1B2_2B5_1B11_Ref }
  object { _Leaf1B4_1B2_2B5_1B12_Ref }
  object { _Leaf1B4_1B2_1B1_1B1_Ref }
  object { _Leaf1B4_1B2_1B1_1B2_Ref }
  object { _Leaf1B4_1B2_1B1_1B3_Ref }
  object { _Leaf1B4_1B2_1B1_1B4_Ref }
  object { _Leaf1B4_1B2_1B1_1B5_Ref }
  object { _Leaf1B4_1B2_1B1_1B6_Ref }
  object { _Leaf1B4_1B2_1B1_1B7_Ref }
  object { _Leaf1B4_1B2_1B1_1B8_Ref }
  object { _Leaf1B4_1B2_1B1_1B9_Ref }
  object { _Leaf1B4_1B2_1B1_1B10_Ref }
  object { _Leaf1B4_1B2_1B1_1B11_Ref }
  object { _Leaf1B4_1B2_1B1_1B12_Ref }
  object { _Leaf1B4_1B2_1B2_1B1_Ref }
  object { _Leaf1B4_1B2_1B2_1B2_Ref }
  object { _Leaf1B4_1B2_1B2_1B3_Ref }
  object { _Leaf1B4_1B2_1B2_1B4_Ref }
  object { _Leaf1B4_1B2_1B2_1B5_Ref }
  object { _Leaf1B4_1B2_1B2_1B6_Ref }
  object { _Leaf1B4_1B2_1B2_1B7_Ref }
  object { _Leaf1B4_1B2_1B2_1B8_Ref }
  object { _Leaf1B4_1B2_1B2_1B9_Ref }
  object { _Leaf1B4_1B2_1B2_1B10_Ref }
  object { _Leaf1B4_1B2_1B2_1B11_Ref }
  object { _Leaf1B4_1B2_1B2_1B12_Ref }
  object { _Leaf1B4_1B2_1B3_1B1_Ref }
  object { _Leaf1B4_1B2_1B3_1B2_Ref }
  object { _Leaf1B4_1B2_1B3_1B3_Ref }
  object { _Leaf1B4_1B2_1B3_1B4_Ref }
  object { _Leaf1B4_1B2_1B3_1B5_Ref }
  object { _Leaf1B4_1B2_1B3_1B6_Ref }
  object { _Leaf1B4_1B2_1B3_1B7_Ref }
  object { _Leaf1B4_1B2_1B3_1B8_Ref }
  object { _Leaf1B4_1B2_1B3_1B9_Ref }
  object { _Leaf1B4_1B2_1B3_1B10_Ref }
  object { _Leaf1B4_1B2_1B3_1B11_Ref }
  object { _Leaf1B4_1B2_1B3_1B12_Ref }
  object { _Leaf1B4_1B3_2B1_1B1_Ref }
  object { _Leaf1B4_1B3_2B1_1B2_Ref }
  object { _Leaf1B4_1B3_2B1_1B3_Ref }
  object { _Leaf1B4_1B3_2B1_1B4_Ref }
  object { _Leaf1B4_1B3_2B1_1B5_Ref }
  object { _Leaf1B4_1B3_2B1_1B6_Ref }
  object { _Leaf1B4_1B3_2B1_1B7_Ref }
  object { _Leaf1B4_1B3_2B1_1B8_Ref }
  object { _Leaf1B4_1B3_2B1_1B9_Ref }
  object { _Leaf1B4_1B3_2B1_1B10_Ref }
  object { _Leaf1B4_1B3_2B1_1B11_Ref }
  object { _Leaf1B4_1B3_2B1_1B12_Ref }
  object { _Leaf1B4_1B3_2B2_1B1_Ref }
  object { _Leaf1B4_1B3_2B2_1B2_Ref }
  object { _Leaf1B4_1B3_2B2_1B3_Ref }
  object { _Leaf1B4_1B3_2B2_1B4_Ref }
  object { _Leaf1B4_1B3_2B2_1B5_Ref }
  object { _Leaf1B4_1B3_2B2_1B6_Ref }
  object { _Leaf1B4_1B3_2B2_1B7_Ref }
  object { _Leaf1B4_1B3_2B2_1B8_Ref }
  object { _Leaf1B4_1B3_2B2_1B9_Ref }
  object { _Leaf1B4_1B3_2B2_1B10_Ref }
  object { _Leaf1B4_1B3_2B2_1B11_Ref }
  object { _Leaf1B4_1B3_2B2_1B12_Ref }
  object { _Leaf1B4_1B3_2B3_1B1_Ref }
  object { _Leaf1B4_1B3_2B3_1B2_Ref }
  object { _Leaf1B4_1B3_2B3_1B3_Ref }
  object { _Leaf1B4_1B3_2B3_1B4_Ref }
  object { _Leaf1B4_1B3_2B3_1B5_Ref }
  object { _Leaf1B4_1B3_2B3_1B6_Ref }
  object { _Leaf1B4_1B3_2B3_1B7_Ref }
  object { _Leaf1B4_1B3_2B3_1B8_Ref }
  object { _Leaf1B4_1B3_2B3_1B9_Ref }
  object { _Leaf1B4_1B3_2B3_1B10_Ref }
  object { _Leaf1B4_1B3_2B3_1B11_Ref }
  object { _Leaf1B4_1B3_2B3_1B12_Ref }
  object { _Leaf1B4_1B3_2B4_1B1_Ref }
  object { _Leaf1B4_1B3_2B4_1B2_Ref }
  object { _Leaf1B4_1B3_2B4_1B3_Ref }
  object { _Leaf1B4_1B3_2B4_1B4_Ref }
  object { _Leaf1B4_1B3_2B4_1B5_Ref }
  object { _Leaf1B4_1B3_2B4_1B6_Ref }
  object { _Leaf1B4_1B3_2B4_1B7_Ref }
  object { _Leaf1B4_1B3_2B4_1B8_Ref }
  object { _Leaf1B4_1B3_2B4_1B9_Ref }
  object { _Leaf1B4_1B3_2B4_1B10_Ref }
  object { _Leaf1B4_1B3_2B4_1B11_Ref }
  object { _Leaf1B4_1B3_2B4_1B12_Ref }
  object { _Leaf1B4_1B3_2B5_1B1_Ref }
  object { _Leaf1B4_1B3_2B5_1B2_Ref }
  object { _Leaf1B4_1B3_2B5_1B3_Ref }
  object { _Leaf1B4_1B3_2B5_1B4_Ref }
  object { _Leaf1B4_1B3_2B5_1B5_Ref }
  object { _Leaf1B4_1B3_2B5_1B6_Ref }
  object { _Leaf1B4_1B3_2B5_1B7_Ref }
  object { _Leaf1B4_1B3_2B5_1B8_Ref }
  object { _Leaf1B4_1B3_2B5_1B9_Ref }
  object { _Leaf1B4_1B3_2B5_1B10_Ref }
  object { _Leaf1B4_1B3_2B5_1B11_Ref }
  object { _Leaf1B4_1B3_2B5_1B12_Ref }
  object { _Leaf1B4_1B3_1B1_1B1_Ref }
  object { _Leaf1B4_1B3_1B1_1B2_Ref }
  object { _Leaf1B4_1B3_1B1_1B3_Ref }
  object { _Leaf1B4_1B3_1B1_1B4_Ref }
  object { _Leaf1B4_1B3_1B1_1B5_Ref }
  object { _Leaf1B4_1B3_1B1_1B6_Ref }
  object { _Leaf1B4_1B3_1B1_1B7_Ref }
  object { _Leaf1B4_1B3_1B1_1B8_Ref }
  object { _Leaf1B4_1B3_1B1_1B9_Ref }
  object { _Leaf1B4_1B3_1B1_1B10_Ref }
  object { _Leaf1B4_1B3_1B1_1B11_Ref }
  object { _Leaf1B4_1B3_1B1_1B12_Ref }
  object { _Leaf1B4_1B3_1B2_1B1_Ref }
  object { _Leaf1B4_1B3_1B2_1B2_Ref }
  object { _Leaf1B4_1B3_1B2_1B3_Ref }
  object { _Leaf1B4_1B3_1B2_1B4_Ref }
  object { _Leaf1B4_1B3_1B2_1B5_Ref }
  object { _Leaf1B4_1B3_1B2_1B6_Ref }
  object { _Leaf1B4_1B3_1B2_1B7_Ref }
  object { _Leaf1B4_1B3_1B2_1B8_Ref }
  object { _Leaf1B4_1B3_1B2_1B9_Ref }
  object { _Leaf1B4_1B3_1B2_1B10_Ref }
  object { _Leaf1B4_1B3_1B2_1B11_Ref }
  object { _Leaf1B4_1B3_1B2_1B12_Ref }
  object { _Leaf1B4_1B3_1B3_1B1_Ref }
  object { _Leaf1B4_1B3_1B3_1B2_Ref }
  object { _Leaf1B4_1B3_1B3_1B3_Ref }
  object { _Leaf1B4_1B3_1B3_1B4_Ref }
  object { _Leaf1B4_1B3_1B3_1B5_Ref }
  object { _Leaf1B4_1B3_1B3_1B6_Ref }
  object { _Leaf1B4_1B3_1B3_1B7_Ref }
  object { _Leaf1B4_1B3_1B3_1B8_Ref }
  object { _Leaf1B4_1B3_1B3_1B9_Ref }
  object { _Leaf1B4_1B3_1B3_1B10_Ref }
  object { _Leaf1B4_1B3_1B3_1B11_Ref }
  object { _Leaf1B4_1B3_1B3_1B12_Ref }
  object { _Leaf1B4_1B4_2B1_1B1_Ref }
  object { _Leaf1B4_1B4_2B1_1B2_Ref }
  object { _Leaf1B4_1B4_2B1_1B3_Ref }
  object { _Leaf1B4_1B4_2B1_1B4_Ref }
  object { _Leaf1B4_1B4_2B1_1B5_Ref }
  object { _Leaf1B4_1B4_2B1_1B6_Ref }
  object { _Leaf1B4_1B4_2B1_1B7_Ref }
  object { _Leaf1B4_1B4_2B1_1B8_Ref }
  object { _Leaf1B4_1B4_2B1_1B9_Ref }
  object { _Leaf1B4_1B4_2B1_1B10_Ref }
  object { _Leaf1B4_1B4_2B1_1B11_Ref }
  object { _Leaf1B4_1B4_2B1_1B12_Ref }
  object { _Leaf1B4_1B4_2B2_1B1_Ref }
  object { _Leaf1B4_1B4_2B2_1B2_Ref }
  object { _Leaf1B4_1B4_2B2_1B3_Ref }
  object { _Leaf1B4_1B4_2B2_1B4_Ref }
  object { _Leaf1B4_1B4_2B2_1B5_Ref }
  object { _Leaf1B4_1B4_2B2_1B6_Ref }
  object { _Leaf1B4_1B4_2B2_1B7_Ref }
  object { _Leaf1B4_1B4_2B2_1B8_Ref }
  object { _Leaf1B4_1B4_2B2_1B9_Ref }
  object { _Leaf1B4_1B4_2B2_1B10_Ref }
  object { _Leaf1B4_1B4_2B2_1B11_Ref }
  object { _Leaf1B4_1B4_2B2_1B12_Ref }
  object { _Leaf1B4_1B4_2B3_1B1_Ref }
  object { _Leaf1B4_1B4_2B3_1B2_Ref }
  object { _Leaf1B4_1B4_2B3_1B3_Ref }
  object { _Leaf1B4_1B4_2B3_1B4_Ref }
  object { _Leaf1B4_1B4_2B3_1B5_Ref }
  object { _Leaf1B4_1B4_2B3_1B6_Ref }
  object { _Leaf1B4_1B4_2B3_1B7_Ref }
  object { _Leaf1B4_1B4_2B3_1B8_Ref }
  object { _Leaf1B4_1B4_2B3_1B9_Ref }
  object { _Leaf1B4_1B4_2B3_1B10_Ref }
  object { _Leaf1B4_1B4_2B3_1B11_Ref }
  object { _Leaf1B4_1B4_2B3_1B12_Ref }
  object { _Leaf1B4_1B4_2B4_1B1_Ref }
  object { _Leaf1B4_1B4_2B4_1B2_Ref }
  object { _Leaf1B4_1B4_2B4_1B3_Ref }
  object { _Leaf1B4_1B4_2B4_1B4_Ref }
  object { _Leaf1B4_1B4_2B4_1B5_Ref }
  object { _Leaf1B4_1B4_2B4_1B6_Ref }
  object { _Leaf1B4_1B4_2B4_1B7_Ref }
  object { _Leaf1B4_1B4_2B4_1B8_Ref }
  object { _Leaf1B4_1B4_2B4_1B9_Ref }
  object { _Leaf1B4_1B4_2B4_1B10_Ref }
  object { _Leaf1B4_1B4_2B4_1B11_Ref }
  object { _Leaf1B4_1B4_2B4_1B12_Ref }
  object { _Leaf1B4_1B4_2B5_1B1_Ref }
  object { _Leaf1B4_1B4_2B5_1B2_Ref }
  object { _Leaf1B4_1B4_2B5_1B3_Ref }
  object { _Leaf1B4_1B4_2B5_1B4_Ref }
  object { _Leaf1B4_1B4_2B5_1B5_Ref }
  object { _Leaf1B4_1B4_2B5_1B6_Ref }
  object { _Leaf1B4_1B4_2B5_1B7_Ref }
  object { _Leaf1B4_1B4_2B5_1B8_Ref }
  object { _Leaf1B4_1B4_2B5_1B9_Ref }
  object { _Leaf1B4_1B4_2B5_1B10_Ref }
  object { _Leaf1B4_1B4_2B5_1B11_Ref }
  object { _Leaf1B4_1B4_2B5_1B12_Ref }
  object { _Leaf1B4_1B4_1B1_1B1_Ref }
  object { _Leaf1B4_1B4_1B1_1B2_Ref }
  object { _Leaf1B4_1B4_1B1_1B3_Ref }
  object { _Leaf1B4_1B4_1B1_1B4_Ref }
  object { _Leaf1B4_1B4_1B1_1B5_Ref }
  object { _Leaf1B4_1B4_1B1_1B6_Ref }
  object { _Leaf1B4_1B4_1B1_1B7_Ref }
  object { _Leaf1B4_1B4_1B1_1B8_Ref }
  object { _Leaf1B4_1B4_1B1_1B9_Ref }
  object { _Leaf1B4_1B4_1B1_1B10_Ref }
  object { _Leaf1B4_1B4_1B1_1B11_Ref }
  object { _Leaf1B4_1B4_1B1_1B12_Ref }
  object { _Leaf1B4_1B4_1B2_1B1_Ref }
  object { _Leaf1B4_1B4_1B2_1B2_Ref }
  object { _Leaf1B4_1B4_1B2_1B3_Ref }
  object { _Leaf1B4_1B4_1B2_1B4_Ref }
  object { _Leaf1B4_1B4_1B2_1B5_Ref }
  object { _Leaf1B4_1B4_1B2_1B6_Ref }
  object { _Leaf1B4_1B4_1B2_1B7_Ref }
  object { _Leaf1B4_1B4_1B2_1B8_Ref }
  object { _Leaf1B4_1B4_1B2_1B9_Ref }
  object { _Leaf1B4_1B4_1B2_1B10_Ref }
  object { _Leaf1B4_1B4_1B2_1B11_Ref }
  object { _Leaf1B4_1B4_1B2_1B12_Ref }
  object { _Leaf1B4_1B4_1B3_1B1_Ref }
  object { _Leaf1B4_1B4_1B3_1B2_Ref }
  object { _Leaf1B4_1B4_1B3_1B3_Ref }
  object { _Leaf1B4_1B4_1B3_1B4_Ref }
  object { _Leaf1B4_1B4_1B3_1B5_Ref }
  object { _Leaf1B4_1B4_1B3_1B6_Ref }
  object { _Leaf1B4_1B4_1B3_1B7_Ref }
  object { _Leaf1B4_1B4_1B3_1B8_Ref }
  object { _Leaf1B4_1B4_1B3_1B9_Ref }
  object { _Leaf1B4_1B4_1B3_1B10_Ref }
  object { _Leaf1B4_1B4_1B3_1B11_Ref }
  object { _Leaf1B4_1B4_1B3_1B12_Ref }
  object { _Leaf1B4_1B5_2B1_1B1_Ref }
  object { _Leaf1B4_1B5_2B1_1B2_Ref }
  object { _Leaf1B4_1B5_2B1_1B3_Ref }
  object { _Leaf1B4_1B5_2B1_1B4_Ref }
  object { _Leaf1B4_1B5_2B1_1B5_Ref }
  object { _Leaf1B4_1B5_2B1_1B6_Ref }
  object { _Leaf1B4_1B5_2B1_1B7_Ref }
  object { _Leaf1B4_1B5_2B1_1B8_Ref }
  object { _Leaf1B4_1B5_2B1_1B9_Ref }
  object { _Leaf1B4_1B5_2B1_1B10_Ref }
  object { _Leaf1B4_1B5_2B1_1B11_Ref }
  object { _Leaf1B4_1B5_2B1_1B12_Ref }
  object { _Leaf1B4_1B5_2B2_1B1_Ref }
  object { _Leaf1B4_1B5_2B2_1B2_Ref }
  object { _Leaf1B4_1B5_2B2_1B3_Ref }
  object { _Leaf1B4_1B5_2B2_1B4_Ref }
  object { _Leaf1B4_1B5_2B2_1B5_Ref }
  object { _Leaf1B4_1B5_2B2_1B6_Ref }
  object { _Leaf1B4_1B5_2B2_1B7_Ref }
  object { _Leaf1B4_1B5_2B2_1B8_Ref }
  object { _Leaf1B4_1B5_2B2_1B9_Ref }
  object { _Leaf1B4_1B5_2B2_1B10_Ref }
  object { _Leaf1B4_1B5_2B2_1B11_Ref }
  object { _Leaf1B4_1B5_2B2_1B12_Ref }
  object { _Leaf1B4_1B5_2B3_1B1_Ref }
  object { _Leaf1B4_1B5_2B3_1B2_Ref }
  object { _Leaf1B4_1B5_2B3_1B3_Ref }
  object { _Leaf1B4_1B5_2B3_1B4_Ref }
  object { _Leaf1B4_1B5_2B3_1B5_Ref }
  object { _Leaf1B4_1B5_2B3_1B6_Ref }
  object { _Leaf1B4_1B5_2B3_1B7_Ref }
  object { _Leaf1B4_1B5_2B3_1B8_Ref }
  object { _Leaf1B4_1B5_2B3_1B9_Ref }
  object { _Leaf1B4_1B5_2B3_1B10_Ref }
  object { _Leaf1B4_1B5_2B3_1B11_Ref }
  object { _Leaf1B4_1B5_2B3_1B12_Ref }
  object { _Leaf1B4_1B5_2B4_1B1_Ref }
  object { _Leaf1B4_1B5_2B4_1B2_Ref }
  object { _Leaf1B4_1B5_2B4_1B3_Ref }
  object { _Leaf1B4_1B5_2B4_1B4_Ref }
  object { _Leaf1B4_1B5_2B4_1B5_Ref }
  object { _Leaf1B4_1B5_2B4_1B6_Ref }
  object { _Leaf1B4_1B5_2B4_1B7_Ref }
  object { _Leaf1B4_1B5_2B4_1B8_Ref }
  object { _Leaf1B4_1B5_2B4_1B9_Ref }
  object { _Leaf1B4_1B5_2B4_1B10_Ref }
  object { _Leaf1B4_1B5_2B4_1B11_Ref }
  object { _Leaf1B4_1B5_2B4_1B12_Ref }
  object { _Leaf1B4_1B5_2B5_1B1_Ref }
  object { _Leaf1B4_1B5_2B5_1B2_Ref }
  object { _Leaf1B4_1B5_2B5_1B3_Ref }
  object { _Leaf1B4_1B5_2B5_1B4_Ref }
  object { _Leaf1B4_1B5_2B5_1B5_Ref }
  object { _Leaf1B4_1B5_2B5_1B6_Ref }
  object { _Leaf1B4_1B5_2B5_1B7_Ref }
  object { _Leaf1B4_1B5_2B5_1B8_Ref }
  object { _Leaf1B4_1B5_2B5_1B9_Ref }
  object { _Leaf1B4_1B5_2B5_1B10_Ref }
  object { _Leaf1B4_1B5_2B5_1B11_Ref }
  object { _Leaf1B4_1B5_2B5_1B12_Ref }
  object { _Leaf1B4_1B5_1B1_1B1_Ref }
  object { _Leaf1B4_1B5_1B1_1B2_Ref }
  object { _Leaf1B4_1B5_1B1_1B3_Ref }
  object { _Leaf1B4_1B5_1B1_1B4_Ref }
  object { _Leaf1B4_1B5_1B1_1B5_Ref }
  object { _Leaf1B4_1B5_1B1_1B6_Ref }
  object { _Leaf1B4_1B5_1B1_1B7_Ref }
  object { _Leaf1B4_1B5_1B1_1B8_Ref }
  object { _Leaf1B4_1B5_1B1_1B9_Ref }
  object { _Leaf1B4_1B5_1B1_1B10_Ref }
  object { _Leaf1B4_1B5_1B1_1B11_Ref }
  object { _Leaf1B4_1B5_1B1_1B12_Ref }
  object { _Leaf1B4_1B5_1B2_1B1_Ref }
  object { _Leaf1B4_1B5_1B2_1B2_Ref }
  object { _Leaf1B4_1B5_1B2_1B3_Ref }
  object { _Leaf1B4_1B5_1B2_1B4_Ref }
  object { _Leaf1B4_1B5_1B2_1B5_Ref }
  object { _Leaf1B4_1B5_1B2_1B6_Ref }
  object { _Leaf1B4_1B5_1B2_1B7_Ref }
  object { _Leaf1B4_1B5_1B2_1B8_Ref }
  object { _Leaf1B4_1B5_1B2_1B9_Ref }
  object { _Leaf1B4_1B5_1B2_1B10_Ref }
  object { _Leaf1B4_1B5_1B2_1B11_Ref }
  object { _Leaf1B4_1B5_1B2_1B12_Ref }
  object { _Leaf1B4_1B5_1B3_1B1_Ref }
  object { _Leaf1B4_1B5_1B3_1B2_Ref }
  object { _Leaf1B4_1B5_1B3_1B3_Ref }
  object { _Leaf1B4_1B5_1B3_1B4_Ref }
  object { _Leaf1B4_1B5_1B3_1B5_Ref }
  object { _Leaf1B4_1B5_1B3_1B6_Ref }
  object { _Leaf1B4_1B5_1B3_1B7_Ref }
  object { _Leaf1B4_1B5_1B3_1B8_Ref }
  object { _Leaf1B4_1B5_1B3_1B9_Ref }
  object { _Leaf1B4_1B5_1B3_1B10_Ref }
  object { _Leaf1B4_1B5_1B3_1B11_Ref }
  object { _Leaf1B4_1B5_1B3_1B12_Ref }
  object { _Leaf1B4_1B6_2B1_1B1_Ref }
  object { _Leaf1B4_1B6_2B1_1B2_Ref }
  object { _Leaf1B4_1B6_2B1_1B3_Ref }
  object { _Leaf1B4_1B6_2B1_1B4_Ref }
  object { _Leaf1B4_1B6_2B1_1B5_Ref }
  object { _Leaf1B4_1B6_2B1_1B6_Ref }
  object { _Leaf1B4_1B6_2B1_1B7_Ref }
  object { _Leaf1B4_1B6_2B1_1B8_Ref }
  object { _Leaf1B4_1B6_2B1_1B9_Ref }
  object { _Leaf1B4_1B6_2B1_1B10_Ref }
  object { _Leaf1B4_1B6_2B1_1B11_Ref }
  object { _Leaf1B4_1B6_2B1_1B12_Ref }
  object { _Leaf1B4_1B6_2B2_1B1_Ref }
  object { _Leaf1B4_1B6_2B2_1B2_Ref }
  object { _Leaf1B4_1B6_2B2_1B3_Ref }
  object { _Leaf1B4_1B6_2B2_1B4_Ref }
  object { _Leaf1B4_1B6_2B2_1B5_Ref }
  object { _Leaf1B4_1B6_2B2_1B6_Ref }
  object { _Leaf1B4_1B6_2B2_1B7_Ref }
  object { _Leaf1B4_1B6_2B2_1B8_Ref }
  object { _Leaf1B4_1B6_2B2_1B9_Ref }
  object { _Leaf1B4_1B6_2B2_1B10_Ref }
  object { _Leaf1B4_1B6_2B2_1B11_Ref }
  object { _Leaf1B4_1B6_2B2_1B12_Ref }
  object { _Leaf1B4_1B6_2B3_1B1_Ref }
  object { _Leaf1B4_1B6_2B3_1B2_Ref }
  object { _Leaf1B4_1B6_2B3_1B3_Ref }
  object { _Leaf1B4_1B6_2B3_1B4_Ref }
  object { _Leaf1B4_1B6_2B3_1B5_Ref }
  object { _Leaf1B4_1B6_2B3_1B6_Ref }
  object { _Leaf1B4_1B6_2B3_1B7_Ref }
  object { _Leaf1B4_1B6_2B3_1B8_Ref }
  object { _Leaf1B4_1B6_2B3_1B9_Ref }
  object { _Leaf1B4_1B6_2B3_1B10_Ref }
  object { _Leaf1B4_1B6_2B3_1B11_Ref }
  object { _Leaf1B4_1B6_2B3_1B12_Ref }
  object { _Leaf1B4_1B6_2B4_1B1_Ref }
  object { _Leaf1B4_1B6_2B4_1B2_Ref }
  object { _Leaf1B4_1B6_2B4_1B3_Ref }
  object { _Leaf1B4_1B6_2B4_1B4_Ref }
  object { _Leaf1B4_1B6_2B4_1B5_Ref }
  object { _Leaf1B4_1B6_2B4_1B6_Ref }
  object { _Leaf1B4_1B6_2B4_1B7_Ref }
  object { _Leaf1B4_1B6_2B4_1B8_Ref }
  object { _Leaf1B4_1B6_2B4_1B9_Ref }
  object { _Leaf1B4_1B6_2B4_1B10_Ref }
  object { _Leaf1B4_1B6_2B4_1B11_Ref }
  object { _Leaf1B4_1B6_2B4_1B12_Ref }
  object { _Leaf1B4_1B6_2B5_1B1_Ref }
  object { _Leaf1B4_1B6_2B5_1B2_Ref }
  object { _Leaf1B4_1B6_2B5_1B3_Ref }
  object { _Leaf1B4_1B6_2B5_1B4_Ref }
  object { _Leaf1B4_1B6_2B5_1B5_Ref }
  object { _Leaf1B4_1B6_2B5_1B6_Ref }
  object { _Leaf1B4_1B6_2B5_1B7_Ref }
  object { _Leaf1B4_1B6_2B5_1B8_Ref }
  object { _Leaf1B4_1B6_2B5_1B9_Ref }
  object { _Leaf1B4_1B6_2B5_1B10_Ref }
  object { _Leaf1B4_1B6_2B5_1B11_Ref }
  object { _Leaf1B4_1B6_2B5_1B12_Ref }
  object { _Leaf1B4_1B6_1B1_1B1_Ref }
  object { _Leaf1B4_1B6_1B1_1B2_Ref }
  object { _Leaf1B4_1B6_1B1_1B3_Ref }
  object { _Leaf1B4_1B6_1B1_1B4_Ref }
  object { _Leaf1B4_1B6_1B1_1B5_Ref }
  object { _Leaf1B4_1B6_1B1_1B6_Ref }
  object { _Leaf1B4_1B6_1B1_1B7_Ref }
  object { _Leaf1B4_1B6_1B1_1B8_Ref }
  object { _Leaf1B4_1B6_1B1_1B9_Ref }
  object { _Leaf1B4_1B6_1B1_1B10_Ref }
  object { _Leaf1B4_1B6_1B1_1B11_Ref }
  object { _Leaf1B4_1B6_1B1_1B12_Ref }
  object { _Leaf1B4_1B6_1B2_1B1_Ref }
  object { _Leaf1B4_1B6_1B2_1B2_Ref }
  object { _Leaf1B4_1B6_1B2_1B3_Ref }
  object { _Leaf1B4_1B6_1B2_1B4_Ref }
  object { _Leaf1B4_1B6_1B2_1B5_Ref }
  object { _Leaf1B4_1B6_1B2_1B6_Ref }
  object { _Leaf1B4_1B6_1B2_1B7_Ref }
  object { _Leaf1B4_1B6_1B2_1B8_Ref }
  object { _Leaf1B4_1B6_1B2_1B9_Ref }
  object { _Leaf1B4_1B6_1B2_1B10_Ref }
  object { _Leaf1B4_1B6_1B2_1B11_Ref }
  object { _Leaf1B4_1B6_1B2_1B12_Ref }
  object { _Leaf1B4_1B6_1B3_1B1_Ref }
  object { _Leaf1B4_1B6_1B3_1B2_Ref }
  object { _Leaf1B4_1B6_1B3_1B3_Ref }
  object { _Leaf1B4_1B6_1B3_1B4_Ref }
  object { _Leaf1B4_1B6_1B3_1B5_Ref }
  object { _Leaf1B4_1B6_1B3_1B6_Ref }
  object { _Leaf1B4_1B6_1B3_1B7_Ref }
  object { _Leaf1B4_1B6_1B3_1B8_Ref }
  object { _Leaf1B4_1B6_1B3_1B9_Ref }
  object { _Leaf1B4_1B6_1B3_1B10_Ref }
  object { _Leaf1B4_1B6_1B3_1B11_Ref }
  object { _Leaf1B4_1B6_1B3_1B12_Ref }
  object { _Leaf1B5_1B1_2B1_1B1_Ref }
  object { _Leaf1B5_1B1_2B1_1B2_Ref }
  object { _Leaf1B5_1B1_2B1_1B3_Ref }
  object { _Leaf1B5_1B1_2B1_1B4_Ref }
  object { _Leaf1B5_1B1_2B1_1B5_Ref }
  object { _Leaf1B5_1B1_2B1_1B6_Ref }
  object { _Leaf1B5_1B1_2B1_1B7_Ref }
  object { _Leaf1B5_1B1_2B1_1B8_Ref }
  object { _Leaf1B5_1B1_2B1_1B9_Ref }
  object { _Leaf1B5_1B1_2B1_1B10_Ref }
  object { _Leaf1B5_1B1_2B1_1B11_Ref }
  object { _Leaf1B5_1B1_2B1_1B12_Ref }
  object { _Leaf1B5_1B1_2B2_1B1_Ref }
  object { _Leaf1B5_1B1_2B2_1B2_Ref }
  object { _Leaf1B5_1B1_2B2_1B3_Ref }
  object { _Leaf1B5_1B1_2B2_1B4_Ref }
  object { _Leaf1B5_1B1_2B2_1B5_Ref }
  object { _Leaf1B5_1B1_2B2_1B6_Ref }
  object { _Leaf1B5_1B1_2B2_1B7_Ref }
  object { _Leaf1B5_1B1_2B2_1B8_Ref }
  object { _Leaf1B5_1B1_2B2_1B9_Ref }
  object { _Leaf1B5_1B1_2B2_1B10_Ref }
  object { _Leaf1B5_1B1_2B2_1B11_Ref }
  object { _Leaf1B5_1B1_2B2_1B12_Ref }
  object { _Leaf1B5_1B1_2B3_1B1_Ref }
  object { _Leaf1B5_1B1_2B3_1B2_Ref }
  object { _Leaf1B5_1B1_2B3_1B3_Ref }
  object { _Leaf1B5_1B1_2B3_1B4_Ref }
  object { _Leaf1B5_1B1_2B3_1B5_Ref }
  object { _Leaf1B5_1B1_2B3_1B6_Ref }
  object { _Leaf1B5_1B1_2B3_1B7_Ref }
  object { _Leaf1B5_1B1_2B3_1B8_Ref }
  object { _Leaf1B5_1B1_2B3_1B9_Ref }
  object { _Leaf1B5_1B1_2B3_1B10_Ref }
  object { _Leaf1B5_1B1_2B3_1B11_Ref }
  object { _Leaf1B5_1B1_2B3_1B12_Ref }
  object { _Leaf1B5_1B1_2B4_1B1_Ref }
  object { _Leaf1B5_1B1_2B4_1B2_Ref }
  object { _Leaf1B5_1B1_2B4_1B3_Ref }
  object { _Leaf1B5_1B1_2B4_1B4_Ref }
  object { _Leaf1B5_1B1_2B4_1B5_Ref }
  object { _Leaf1B5_1B1_2B4_1B6_Ref }
  object { _Leaf1B5_1B1_2B4_1B7_Ref }
  object { _Leaf1B5_1B1_2B4_1B8_Ref }
  object { _Leaf1B5_1B1_2B4_1B9_Ref }
  object { _Leaf1B5_1B1_2B4_1B10_Ref }
  object { _Leaf1B5_1B1_2B4_1B11_Ref }
  object { _Leaf1B5_1B1_2B4_1B12_Ref }
  object { _Leaf1B5_1B1_2B5_1B1_Ref }
  object { _Leaf1B5_1B1_2B5_1B2_Ref }
  object { _Leaf1B5_1B1_2B5_1B3_Ref }
  object { _Leaf1B5_1B1_2B5_1B4_Ref }
  object { _Leaf1B5_1B1_2B5_1B5_Ref }
  object { _Leaf1B5_1B1_2B5_1B6_Ref }
  object { _Leaf1B5_1B1_2B5_1B7_Ref }
  object { _Leaf1B5_1B1_2B5_1B8_Ref }
  object { _Leaf1B5_1B1_2B5_1B9_Ref }
  object { _Leaf1B5_1B1_2B5_1B10_Ref }
  object { _Leaf1B5_1B1_2B5_1B11_Ref }
  object { _Leaf1B5_1B1_2B5_1B12_Ref }
  object { _Leaf1B5_1B1_1B1_1B1_Ref }
  object { _Leaf1B5_1B1_1B1_1B2_Ref }
  object { _Leaf1B5_1B1_1B1_1B3_Ref }
  object { _Leaf1B5_1B1_1B1_1B4_Ref }
  object { _Leaf1B5_1B1_1B1_1B5_Ref }
  object { _Leaf1B5_1B1_1B1_1B6_Ref }
  object { _Leaf1B5_1B1_1B1_1B7_Ref }
  object { _Leaf1B5_1B1_1B1_1B8_Ref }
  object { _Leaf1B5_1B1_1B1_1B9_Ref }
  object { _Leaf1B5_1B1_1B1_1B10_Ref }
  object { _Leaf1B5_1B1_1B1_1B11_Ref }
  object { _Leaf1B5_1B1_1B1_1B12_Ref }
  object { _Leaf1B5_1B1_1B2_1B1_Ref }
  object { _Leaf1B5_1B1_1B2_1B2_Ref }
  object { _Leaf1B5_1B1_1B2_1B3_Ref }
  object { _Leaf1B5_1B1_1B2_1B4_Ref }
  object { _Leaf1B5_1B1_1B2_1B5_Ref }
  object { _Leaf1B5_1B1_1B2_1B6_Ref }
  object { _Leaf1B5_1B1_1B2_1B7_Ref }
  object { _Leaf1B5_1B1_1B2_1B8_Ref }
  object { _Leaf1B5_1B1_1B2_1B9_Ref }
  object { _Leaf1B5_1B1_1B2_1B10_Ref }
  object { _Leaf1B5_1B1_1B2_1B11_Ref }
  object { _Leaf1B5_1B1_1B2_1B12_Ref }
  object { _Leaf1B5_1B1_1B3_1B1_Ref }
  object { _Leaf1B5_1B1_1B3_1B2_Ref }
  object { _Leaf1B5_1B1_1B3_1B3_Ref }
  object { _Leaf1B5_1B1_1B3_1B4_Ref }
  object { _Leaf1B5_1B1_1B3_1B5_Ref }
  object { _Leaf1B5_1B1_1B3_1B6_Ref }
  object { _Leaf1B5_1B1_1B3_1B7_Ref }
  object { _Leaf1B5_1B1_1B3_1B8_Ref }
  object { _Leaf1B5_1B1_1B3_1B9_Ref }
  object { _Leaf1B5_1B1_1B3_1B10_Ref }
  object { _Leaf1B5_1B1_1B3_1B11_Ref }
  object { _Leaf1B5_1B1_1B3_1B12_Ref }
  object { _Leaf1B5_1B2_2B1_1B1_Ref }
  object { _Leaf1B5_1B2_2B1_1B2_Ref }
  object { _Leaf1B5_1B2_2B1_1B3_Ref }
  object { _Leaf1B5_1B2_2B1_1B4_Ref }
  object { _Leaf1B5_1B2_2B1_1B5_Ref }
  object { _Leaf1B5_1B2_2B1_1B6_Ref }
  object { _Leaf1B5_1B2_2B1_1B7_Ref }
  object { _Leaf1B5_1B2_2B1_1B8_Ref }
  object { _Leaf1B5_1B2_2B1_1B9_Ref }
  object { _Leaf1B5_1B2_2B1_1B10_Ref }
  object { _Leaf1B5_1B2_2B1_1B11_Ref }
  object { _Leaf1B5_1B2_2B1_1B12_Ref }
  object { _Leaf1B5_1B2_2B2_1B1_Ref }
  object { _Leaf1B5_1B2_2B2_1B2_Ref }
  object { _Leaf1B5_1B2_2B2_1B3_Ref }
  object { _Leaf1B5_1B2_2B2_1B4_Ref }
  object { _Leaf1B5_1B2_2B2_1B5_Ref }
  object { _Leaf1B5_1B2_2B2_1B6_Ref }
  object { _Leaf1B5_1B2_2B2_1B7_Ref }
  object { _Leaf1B5_1B2_2B2_1B8_Ref }
  object { _Leaf1B5_1B2_2B2_1B9_Ref }
  object { _Leaf1B5_1B2_2B2_1B10_Ref }
  object { _Leaf1B5_1B2_2B2_1B11_Ref }
  object { _Leaf1B5_1B2_2B2_1B12_Ref }
  object { _Leaf1B5_1B2_2B3_1B1_Ref }
  object { _Leaf1B5_1B2_2B3_1B2_Ref }
  object { _Leaf1B5_1B2_2B3_1B3_Ref }
  object { _Leaf1B5_1B2_2B3_1B4_Ref }
  object { _Leaf1B5_1B2_2B3_1B5_Ref }
  object { _Leaf1B5_1B2_2B3_1B6_Ref }
  object { _Leaf1B5_1B2_2B3_1B7_Ref }
  object { _Leaf1B5_1B2_2B3_1B8_Ref }
  object { _Leaf1B5_1B2_2B3_1B9_Ref }
  object { _Leaf1B5_1B2_2B3_1B10_Ref }
  object { _Leaf1B5_1B2_2B3_1B11_Ref }
  object { _Leaf1B5_1B2_2B3_1B12_Ref }
  object { _Leaf1B5_1B2_2B4_1B1_Ref }
  object { _Leaf1B5_1B2_2B4_1B2_Ref }
  object { _Leaf1B5_1B2_2B4_1B3_Ref }
  object { _Leaf1B5_1B2_2B4_1B4_Ref }
  object { _Leaf1B5_1B2_2B4_1B5_Ref }
  object { _Leaf1B5_1B2_2B4_1B6_Ref }
  object { _Leaf1B5_1B2_2B4_1B7_Ref }
  object { _Leaf1B5_1B2_2B4_1B8_Ref }
  object { _Leaf1B5_1B2_2B4_1B9_Ref }
  object { _Leaf1B5_1B2_2B4_1B10_Ref }
  object { _Leaf1B5_1B2_2B4_1B11_Ref }
  object { _Leaf1B5_1B2_2B4_1B12_Ref }
  object { _Leaf1B5_1B2_2B5_1B1_Ref }
  object { _Leaf1B5_1B2_2B5_1B2_Ref }
  object { _Leaf1B5_1B2_2B5_1B3_Ref }
  object { _Leaf1B5_1B2_2B5_1B4_Ref }
  object { _Leaf1B5_1B2_2B5_1B5_Ref }
  object { _Leaf1B5_1B2_2B5_1B6_Ref }
  object { _Leaf1B5_1B2_2B5_1B7_Ref }
  object { _Leaf1B5_1B2_2B5_1B8_Ref }
  object { _Leaf1B5_1B2_2B5_1B9_Ref }
  object { _Leaf1B5_1B2_2B5_1B10_Ref }
  object { _Leaf1B5_1B2_2B5_1B11_Ref }
  object { _Leaf1B5_1B2_2B5_1B12_Ref }
  object { _Leaf1B5_1B2_1B1_1B1_Ref }
  object { _Leaf1B5_1B2_1B1_1B2_Ref }
  object { _Leaf1B5_1B2_1B1_1B3_Ref }
  object { _Leaf1B5_1B2_1B1_1B4_Ref }
  object { _Leaf1B5_1B2_1B1_1B5_Ref }
  object { _Leaf1B5_1B2_1B1_1B6_Ref }
  object { _Leaf1B5_1B2_1B1_1B7_Ref }
  object { _Leaf1B5_1B2_1B1_1B8_Ref }
  object { _Leaf1B5_1B2_1B1_1B9_Ref }
  object { _Leaf1B5_1B2_1B1_1B10_Ref }
  object { _Leaf1B5_1B2_1B1_1B11_Ref }
  object { _Leaf1B5_1B2_1B1_1B12_Ref }
  object { _Leaf1B5_1B2_1B2_1B1_Ref }
  object { _Leaf1B5_1B2_1B2_1B2_Ref }
  object { _Leaf1B5_1B2_1B2_1B3_Ref }
  object { _Leaf1B5_1B2_1B2_1B4_Ref }
  object { _Leaf1B5_1B2_1B2_1B5_Ref }
  object { _Leaf1B5_1B2_1B2_1B6_Ref }
  object { _Leaf1B5_1B2_1B2_1B7_Ref }
  object { _Leaf1B5_1B2_1B2_1B8_Ref }
  object { _Leaf1B5_1B2_1B2_1B9_Ref }
  object { _Leaf1B5_1B2_1B2_1B10_Ref }
  object { _Leaf1B5_1B2_1B2_1B11_Ref }
  object { _Leaf1B5_1B2_1B2_1B12_Ref }
  object { _Leaf1B5_1B2_1B3_1B1_Ref }
  object { _Leaf1B5_1B2_1B3_1B2_Ref }
  object { _Leaf1B5_1B2_1B3_1B3_Ref }
  object { _Leaf1B5_1B2_1B3_1B4_Ref }
  object { _Leaf1B5_1B2_1B3_1B5_Ref }
  object { _Leaf1B5_1B2_1B3_1B6_Ref }
  object { _Leaf1B5_1B2_1B3_1B7_Ref }
  object { _Leaf1B5_1B2_1B3_1B8_Ref }
  object { _Leaf1B5_1B2_1B3_1B9_Ref }
  object { _Leaf1B5_1B2_1B3_1B10_Ref }
  object { _Leaf1B5_1B2_1B3_1B11_Ref }
  object { _Leaf1B5_1B2_1B3_1B12_Ref }
  object { _Leaf1B5_1B3_2B1_1B1_Ref }
  object { _Leaf1B5_1B3_2B1_1B2_Ref }
  object { _Leaf1B5_1B3_2B1_1B3_Ref }
  object { _Leaf1B5_1B3_2B1_1B4_Ref }
  object { _Leaf1B5_1B3_2B1_1B5_Ref }
  object { _Leaf1B5_1B3_2B1_1B6_Ref }
  object { _Leaf1B5_1B3_2B1_1B7_Ref }
  object { _Leaf1B5_1B3_2B1_1B8_Ref }
  object { _Leaf1B5_1B3_2B1_1B9_Ref }
  object { _Leaf1B5_1B3_2B1_1B10_Ref }
  object { _Leaf1B5_1B3_2B1_1B11_Ref }
  object { _Leaf1B5_1B3_2B1_1B12_Ref }
  object { _Leaf1B5_1B3_2B2_1B1_Ref }
  object { _Leaf1B5_1B3_2B2_1B2_Ref }
  object { _Leaf1B5_1B3_2B2_1B3_Ref }
  object { _Leaf1B5_1B3_2B2_1B4_Ref }
  object { _Leaf1B5_1B3_2B2_1B5_Ref }
  object { _Leaf1B5_1B3_2B2_1B6_Ref }
  object { _Leaf1B5_1B3_2B2_1B7_Ref }
  object { _Leaf1B5_1B3_2B2_1B8_Ref }
  object { _Leaf1B5_1B3_2B2_1B9_Ref }
  object { _Leaf1B5_1B3_2B2_1B10_Ref }
  object { _Leaf1B5_1B3_2B2_1B11_Ref }
  object { _Leaf1B5_1B3_2B2_1B12_Ref }
  object { _Leaf1B5_1B3_2B3_1B1_Ref }
  object { _Leaf1B5_1B3_2B3_1B2_Ref }
  object { _Leaf1B5_1B3_2B3_1B3_Ref }
  object { _Leaf1B5_1B3_2B3_1B4_Ref }
  object { _Leaf1B5_1B3_2B3_1B5_Ref }
  object { _Leaf1B5_1B3_2B3_1B6_Ref }
  object { _Leaf1B5_1B3_2B3_1B7_Ref }
  object { _Leaf1B5_1B3_2B3_1B8_Ref }
  object { _Leaf1B5_1B3_2B3_1B9_Ref }
  object { _Leaf1B5_1B3_2B3_1B10_Ref }
  object { _Leaf1B5_1B3_2B3_1B11_Ref }
  object { _Leaf1B5_1B3_2B3_1B12_Ref }
  object { _Leaf1B5_1B3_2B4_1B1_Ref }
  object { _Leaf1B5_1B3_2B4_1B2_Ref }
  object { _Leaf1B5_1B3_2B4_1B3_Ref }
  object { _Leaf1B5_1B3_2B4_1B4_Ref }
  object { _Leaf1B5_1B3_2B4_1B5_Ref }
  object { _Leaf1B5_1B3_2B4_1B6_Ref }
  object { _Leaf1B5_1B3_2B4_1B7_Ref }
  object { _Leaf1B5_1B3_2B4_1B8_Ref }
  object { _Leaf1B5_1B3_2B4_1B9_Ref }
  object { _Leaf1B5_1B3_2B4_1B10_Ref }
  object { _Leaf1B5_1B3_2B4_1B11_Ref }
  object { _Leaf1B5_1B3_2B4_1B12_Ref }
  object { _Leaf1B5_1B3_2B5_1B1_Ref }
  object { _Leaf1B5_1B3_2B5_1B2_Ref }
  object { _Leaf1B5_1B3_2B5_1B3_Ref }
  object { _Leaf1B5_1B3_2B5_1B4_Ref }
  object { _Leaf1B5_1B3_2B5_1B5_Ref }
  object { _Leaf1B5_1B3_2B5_1B6_Ref }
  object { _Leaf1B5_1B3_2B5_1B7_Ref }
  object { _Leaf1B5_1B3_2B5_1B8_Ref }
  object { _Leaf1B5_1B3_2B5_1B9_Ref }
  object { _Leaf1B5_1B3_2B5_1B10_Ref }
  object { _Leaf1B5_1B3_2B5_1B11_Ref }
  object { _Leaf1B5_1B3_2B5_1B12_Ref }
  object { _Leaf1B5_1B3_1B1_1B1_Ref }
  object { _Leaf1B5_1B3_1B1_1B2_Ref }
  object { _Leaf1B5_1B3_1B1_1B3_Ref }
  object { _Leaf1B5_1B3_1B1_1B4_Ref }
  object { _Leaf1B5_1B3_1B1_1B5_Ref }
  object { _Leaf1B5_1B3_1B1_1B6_Ref }
  object { _Leaf1B5_1B3_1B1_1B7_Ref }
  object { _Leaf1B5_1B3_1B1_1B8_Ref }
  object { _Leaf1B5_1B3_1B1_1B9_Ref }
  object { _Leaf1B5_1B3_1B1_1B10_Ref }
  object { _Leaf1B5_1B3_1B1_1B11_Ref }
  object { _Leaf1B5_1B3_1B1_1B12_Ref }
  object { _Leaf1B5_1B3_1B2_1B1_Ref }
  object { _Leaf1B5_1B3_1B2_1B2_Ref }
  object { _Leaf1B5_1B3_1B2_1B3_Ref }
  object { _Leaf1B5_1B3_1B2_1B4_Ref }
  object { _Leaf1B5_1B3_1B2_1B5_Ref }
  object { _Leaf1B5_1B3_1B2_1B6_Ref }
  object { _Leaf1B5_1B3_1B2_1B7_Ref }
  object { _Leaf1B5_1B3_1B2_1B8_Ref }
  object { _Leaf1B5_1B3_1B2_1B9_Ref }
  object { _Leaf1B5_1B3_1B2_1B10_Ref }
  object { _Leaf1B5_1B3_1B2_1B11_Ref }
  object { _Leaf1B5_1B3_1B2_1B12_Ref }
  object { _Leaf1B5_1B3_1B3_1B1_Ref }
  object { _Leaf1B5_1B3_1B3_1B2_Ref }
  object { _Leaf1B5_1B3_1B3_1B3_Ref }
  object { _Leaf1B5_1B3_1B3_1B4_Ref }
  object { _Leaf1B5_1B3_1B3_1B5_Ref }
  object { _Leaf1B5_1B3_1B3_1B6_Ref }
  object { _Leaf1B5_1B3_1B3_1B7_Ref }
  object { _Leaf1B5_1B3_1B3_1B8_Ref }
  object { _Leaf1B5_1B3_1B3_1B9_Ref }
  object { _Leaf1B5_1B3_1B3_1B10_Ref }
  object { _Leaf1B5_1B3_1B3_1B11_Ref }
  object { _Leaf1B5_1B3_1B3_1B12_Ref }
  object { _Leaf1B5_1B4_2B1_1B1_Ref }
  object { _Leaf1B5_1B4_2B1_1B2_Ref }
  object { _Leaf1B5_1B4_2B1_1B3_Ref }
  object { _Leaf1B5_1B4_2B1_1B4_Ref }
  object { _Leaf1B5_1B4_2B1_1B5_Ref }
  object { _Leaf1B5_1B4_2B1_1B6_Ref }
  object { _Leaf1B5_1B4_2B1_1B7_Ref }
  object { _Leaf1B5_1B4_2B1_1B8_Ref }
  object { _Leaf1B5_1B4_2B1_1B9_Ref }
  object { _Leaf1B5_1B4_2B1_1B10_Ref }
  object { _Leaf1B5_1B4_2B1_1B11_Ref }
  object { _Leaf1B5_1B4_2B1_1B12_Ref }
  object { _Leaf1B5_1B4_2B2_1B1_Ref }
  object { _Leaf1B5_1B4_2B2_1B2_Ref }
  object { _Leaf1B5_1B4_2B2_1B3_Ref }
  object { _Leaf1B5_1B4_2B2_1B4_Ref }
  object { _Leaf1B5_1B4_2B2_1B5_Ref }
  object { _Leaf1B5_1B4_2B2_1B6_Ref }
  object { _Leaf1B5_1B4_2B2_1B7_Ref }
  object { _Leaf1B5_1B4_2B2_1B8_Ref }
  object { _Leaf1B5_1B4_2B2_1B9_Ref }
  object { _Leaf1B5_1B4_2B2_1B10_Ref }
  object { _Leaf1B5_1B4_2B2_1B11_Ref }
  object { _Leaf1B5_1B4_2B2_1B12_Ref }
  object { _Leaf1B5_1B4_2B3_1B1_Ref }
  object { _Leaf1B5_1B4_2B3_1B2_Ref }
  object { _Leaf1B5_1B4_2B3_1B3_Ref }
  object { _Leaf1B5_1B4_2B3_1B4_Ref }
  object { _Leaf1B5_1B4_2B3_1B5_Ref }
  object { _Leaf1B5_1B4_2B3_1B6_Ref }
  object { _Leaf1B5_1B4_2B3_1B7_Ref }
  object { _Leaf1B5_1B4_2B3_1B8_Ref }
  object { _Leaf1B5_1B4_2B3_1B9_Ref }
  object { _Leaf1B5_1B4_2B3_1B10_Ref }
  object { _Leaf1B5_1B4_2B3_1B11_Ref }
  object { _Leaf1B5_1B4_2B3_1B12_Ref }
  object { _Leaf1B5_1B4_2B4_1B1_Ref }
  object { _Leaf1B5_1B4_2B4_1B2_Ref }
  object { _Leaf1B5_1B4_2B4_1B3_Ref }
  object { _Leaf1B5_1B4_2B4_1B4_Ref }
  object { _Leaf1B5_1B4_2B4_1B5_Ref }
  object { _Leaf1B5_1B4_2B4_1B6_Ref }
  object { _Leaf1B5_1B4_2B4_1B7_Ref }
  object { _Leaf1B5_1B4_2B4_1B8_Ref }
  object { _Leaf1B5_1B4_2B4_1B9_Ref }
  object { _Leaf1B5_1B4_2B4_1B10_Ref }
  object { _Leaf1B5_1B4_2B4_1B11_Ref }
  object { _Leaf1B5_1B4_2B4_1B12_Ref }
  object { _Leaf1B5_1B4_2B5_1B1_Ref }
  object { _Leaf1B5_1B4_2B5_1B2_Ref }
  object { _Leaf1B5_1B4_2B5_1B3_Ref }
  object { _Leaf1B5_1B4_2B5_1B4_Ref }
  object { _Leaf1B5_1B4_2B5_1B5_Ref }
  object { _Leaf1B5_1B4_2B5_1B6_Ref }
  object { _Leaf1B5_1B4_2B5_1B7_Ref }
  object { _Leaf1B5_1B4_2B5_1B8_Ref }
  object { _Leaf1B5_1B4_2B5_1B9_Ref }
  object { _Leaf1B5_1B4_2B5_1B10_Ref }
  object { _Leaf1B5_1B4_2B5_1B11_Ref }
  object { _Leaf1B5_1B4_2B5_1B12_Ref }
  object { _Leaf1B5_1B4_1B1_1B1_Ref }
  object { _Leaf1B5_1B4_1B1_1B2_Ref }
  object { _Leaf1B5_1B4_1B1_1B3_Ref }
  object { _Leaf1B5_1B4_1B1_1B4_Ref }
  object { _Leaf1B5_1B4_1B1_1B5_Ref }
  object { _Leaf1B5_1B4_1B1_1B6_Ref }
  object { _Leaf1B5_1B4_1B1_1B7_Ref }
  object { _Leaf1B5_1B4_1B1_1B8_Ref }
  object { _Leaf1B5_1B4_1B1_1B9_Ref }
  object { _Leaf1B5_1B4_1B1_1B10_Ref }
  object { _Leaf1B5_1B4_1B1_1B11_Ref }
  object { _Leaf1B5_1B4_1B1_1B12_Ref }
  object { _Leaf1B5_1B4_1B2_1B1_Ref }
  object { _Leaf1B5_1B4_1B2_1B2_Ref }
  object { _Leaf1B5_1B4_1B2_1B3_Ref }
  object { _Leaf1B5_1B4_1B2_1B4_Ref }
  object { _Leaf1B5_1B4_1B2_1B5_Ref }
  object { _Leaf1B5_1B4_1B2_1B6_Ref }
  object { _Leaf1B5_1B4_1B2_1B7_Ref }
  object { _Leaf1B5_1B4_1B2_1B8_Ref }
  object { _Leaf1B5_1B4_1B2_1B9_Ref }
  object { _Leaf1B5_1B4_1B2_1B10_Ref }
  object { _Leaf1B5_1B4_1B2_1B11_Ref }
  object { _Leaf1B5_1B4_1B2_1B12_Ref }
  object { _Leaf1B5_1B4_1B3_1B1_Ref }
  object { _Leaf1B5_1B4_1B3_1B2_Ref }
  object { _Leaf1B5_1B4_1B3_1B3_Ref }
  object { _Leaf1B5_1B4_1B3_1B4_Ref }
  object { _Leaf1B5_1B4_1B3_1B5_Ref }
  object { _Leaf1B5_1B4_1B3_1B6_Ref }
  object { _Leaf1B5_1B4_1B3_1B7_Ref }
  object { _Leaf1B5_1B4_1B3_1B8_Ref }
  object { _Leaf1B5_1B4_1B3_1B9_Ref }
  object { _Leaf1B5_1B4_1B3_1B10_Ref }
  object { _Leaf1B5_1B4_1B3_1B11_Ref }
  object { _Leaf1B5_1B4_1B3_1B12_Ref }
  object { _Leaf1B5_1B5_2B1_1B1_Ref }
  object { _Leaf1B5_1B5_2B1_1B2_Ref }
  object { _Leaf1B5_1B5_2B1_1B3_Ref }
  object { _Leaf1B5_1B5_2B1_1B4_Ref }
  object { _Leaf1B5_1B5_2B1_1B5_Ref }
  object { _Leaf1B5_1B5_2B1_1B6_Ref }
  object { _Leaf1B5_1B5_2B1_1B7_Ref }
  object { _Leaf1B5_1B5_2B1_1B8_Ref }
  object { _Leaf1B5_1B5_2B1_1B9_Ref }
  object { _Leaf1B5_1B5_2B1_1B10_Ref }
  object { _Leaf1B5_1B5_2B1_1B11_Ref }
  object { _Leaf1B5_1B5_2B1_1B12_Ref }
  object { _Leaf1B5_1B5_2B2_1B1_Ref }
  object { _Leaf1B5_1B5_2B2_1B2_Ref }
  object { _Leaf1B5_1B5_2B2_1B3_Ref }
  object { _Leaf1B5_1B5_2B2_1B4_Ref }
  object { _Leaf1B5_1B5_2B2_1B5_Ref }
  object { _Leaf1B5_1B5_2B2_1B6_Ref }
  object { _Leaf1B5_1B5_2B2_1B7_Ref }
  object { _Leaf1B5_1B5_2B2_1B8_Ref }
  object { _Leaf1B5_1B5_2B2_1B9_Ref }
  object { _Leaf1B5_1B5_2B2_1B10_Ref }
  object { _Leaf1B5_1B5_2B2_1B11_Ref }
  object { _Leaf1B5_1B5_2B2_1B12_Ref }
  object { _Leaf1B5_1B5_2B3_1B1_Ref }
  object { _Leaf1B5_1B5_2B3_1B2_Ref }
  object { _Leaf1B5_1B5_2B3_1B3_Ref }
  object { _Leaf1B5_1B5_2B3_1B4_Ref }
  object { _Leaf1B5_1B5_2B3_1B5_Ref }
  object { _Leaf1B5_1B5_2B3_1B6_Ref }
  object { _Leaf1B5_1B5_2B3_1B7_Ref }
  object { _Leaf1B5_1B5_2B3_1B8_Ref }
  object { _Leaf1B5_1B5_2B3_1B9_Ref }
  object { _Leaf1B5_1B5_2B3_1B10_Ref }
  object { _Leaf1B5_1B5_2B3_1B11_Ref }
  object { _Leaf1B5_1B5_2B3_1B12_Ref }
  object { _Leaf1B5_1B5_2B4_1B1_Ref }
  object { _Leaf1B5_1B5_2B4_1B2_Ref }
  object { _Leaf1B5_1B5_2B4_1B3_Ref }
  object { _Leaf1B5_1B5_2B4_1B4_Ref }
  object { _Leaf1B5_1B5_2B4_1B5_Ref }
  object { _Leaf1B5_1B5_2B4_1B6_Ref }
  object { _Leaf1B5_1B5_2B4_1B7_Ref }
  object { _Leaf1B5_1B5_2B4_1B8_Ref }
  object { _Leaf1B5_1B5_2B4_1B9_Ref }
  object { _Leaf1B5_1B5_2B4_1B10_Ref }
  object { _Leaf1B5_1B5_2B4_1B11_Ref }
  object { _Leaf1B5_1B5_2B4_1B12_Ref }
  object { _Leaf1B5_1B5_2B5_1B1_Ref }
  object { _Leaf1B5_1B5_2B5_1B2_Ref }
  object { _Leaf1B5_1B5_2B5_1B3_Ref }
  object { _Leaf1B5_1B5_2B5_1B4_Ref }
  object { _Leaf1B5_1B5_2B5_1B5_Ref }
  object { _Leaf1B5_1B5_2B5_1B6_Ref }
  object { _Leaf1B5_1B5_2B5_1B7_Ref }
  object { _Leaf1B5_1B5_2B5_1B8_Ref }
  object { _Leaf1B5_1B5_2B5_1B9_Ref }
  object { _Leaf1B5_1B5_2B5_1B10_Ref }
  object { _Leaf1B5_1B5_2B5_1B11_Ref }
  object { _Leaf1B5_1B5_2B5_1B12_Ref }
  object { _Leaf1B5_1B5_1B1_1B1_Ref }
  object { _Leaf1B5_1B5_1B1_1B2_Ref }
  object { _Leaf1B5_1B5_1B1_1B3_Ref }
  object { _Leaf1B5_1B5_1B1_1B4_Ref }
  object { _Leaf1B5_1B5_1B1_1B5_Ref }
  object { _Leaf1B5_1B5_1B1_1B6_Ref }
  object { _Leaf1B5_1B5_1B1_1B7_Ref }
  object { _Leaf1B5_1B5_1B1_1B8_Ref }
  object { _Leaf1B5_1B5_1B1_1B9_Ref }
  object { _Leaf1B5_1B5_1B1_1B10_Ref }
  object { _Leaf1B5_1B5_1B1_1B11_Ref }
  object { _Leaf1B5_1B5_1B1_1B12_Ref }
  object { _Leaf1B5_1B5_1B2_1B1_Ref }
  object { _Leaf1B5_1B5_1B2_1B2_Ref }
  object { _Leaf1B5_1B5_1B2_1B3_Ref }
  object { _Leaf1B5_1B5_1B2_1B4_Ref }
  object { _Leaf1B5_1B5_1B2_1B5_Ref }
  object { _Leaf1B5_1B5_1B2_1B6_Ref }
  object { _Leaf1B5_1B5_1B2_1B7_Ref }
  object { _Leaf1B5_1B5_1B2_1B8_Ref }
  object { _Leaf1B5_1B5_1B2_1B9_Ref }
  object { _Leaf1B5_1B5_1B2_1B10_Ref }
  object { _Leaf1B5_1B5_1B2_1B11_Ref }
  object { _Leaf1B5_1B5_1B2_1B12_Ref }
  object { _Leaf1B5_1B5_1B3_1B1_Ref }
  object { _Leaf1B5_1B5_1B3_1B2_Ref }
  object { _Leaf1B5_1B5_1B3_1B3_Ref }
  object { _Leaf1B5_1B5_1B3_1B4_Ref }
  object { _Leaf1B5_1B5_1B3_1B5_Ref }
  object { _Leaf1B5_1B5_1B3_1B6_Ref }
  object { _Leaf1B5_1B5_1B3_1B7_Ref }
  object { _Leaf1B5_1B5_1B3_1B8_Ref }
  object { _Leaf1B5_1B5_1B3_1B9_Ref }
  object { _Leaf1B5_1B5_1B3_1B10_Ref }
  object { _Leaf1B5_1B5_1B3_1B11_Ref }
  object { _Leaf1B5_1B5_1B3_1B12_Ref }
  object { _Leaf1B5_1B6_2B1_1B1_Ref }
  object { _Leaf1B5_1B6_2B1_1B2_Ref }
  object { _Leaf1B5_1B6_2B1_1B3_Ref }
  object { _Leaf1B5_1B6_2B1_1B4_Ref }
  object { _Leaf1B5_1B6_2B1_1B5_Ref }
  object { _Leaf1B5_1B6_2B1_1B6_Ref }
  object { _Leaf1B5_1B6_2B1_1B7_Ref }
  object { _Leaf1B5_1B6_2B1_1B8_Ref }
  object { _Leaf1B5_1B6_2B1_1B9_Ref }
  object { _Leaf1B5_1B6_2B1_1B10_Ref }
  object { _Leaf1B5_1B6_2B1_1B11_Ref }
  object { _Leaf1B5_1B6_2B1_1B12_Ref }
  object { _Leaf1B5_1B6_2B2_1B1_Ref }
  object { _Leaf1B5_1B6_2B2_1B2_Ref }
  object { _Leaf1B5_1B6_2B2_1B3_Ref }
  object { _Leaf1B5_1B6_2B2_1B4_Ref }
  object { _Leaf1B5_1B6_2B2_1B5_Ref }
  object { _Leaf1B5_1B6_2B2_1B6_Ref }
  object { _Leaf1B5_1B6_2B2_1B7_Ref }
  object { _Leaf1B5_1B6_2B2_1B8_Ref }
  object { _Leaf1B5_1B6_2B2_1B9_Ref }
  object { _Leaf1B5_1B6_2B2_1B10_Ref }
  object { _Leaf1B5_1B6_2B2_1B11_Ref }
  object { _Leaf1B5_1B6_2B2_1B12_Ref }
  object { _Leaf1B5_1B6_2B3_1B1_Ref }
  object { _Leaf1B5_1B6_2B3_1B2_Ref }
  object { _Leaf1B5_1B6_2B3_1B3_Ref }
  object { _Leaf1B5_1B6_2B3_1B4_Ref }
  object { _Leaf1B5_1B6_2B3_1B5_Ref }
  object { _Leaf1B5_1B6_2B3_1B6_Ref }
  object { _Leaf1B5_1B6_2B3_1B7_Ref }
  object { _Leaf1B5_1B6_2B3_1B8_Ref }
  object { _Leaf1B5_1B6_2B3_1B9_Ref }
  object { _Leaf1B5_1B6_2B3_1B10_Ref }
  object { _Leaf1B5_1B6_2B3_1B11_Ref }
  object { _Leaf1B5_1B6_2B3_1B12_Ref }
  object { _Leaf1B5_1B6_2B4_1B1_Ref }
  object { _Leaf1B5_1B6_2B4_1B2_Ref }
  object { _Leaf1B5_1B6_2B4_1B3_Ref }
  object { _Leaf1B5_1B6_2B4_1B4_Ref }
  object { _Leaf1B5_1B6_2B4_1B5_Ref }
  object { _Leaf1B5_1B6_2B4_1B6_Ref }
  object { _Leaf1B5_1B6_2B4_1B7_Ref }
  object { _Leaf1B5_1B6_2B4_1B8_Ref }
  object { _Leaf1B5_1B6_2B4_1B9_Ref }
  object { _Leaf1B5_1B6_2B4_1B10_Ref }
  object { _Leaf1B5_1B6_2B4_1B11_Ref }
  object { _Leaf1B5_1B6_2B4_1B12_Ref }
  object { _Leaf1B5_1B6_2B5_1B1_Ref }
  object { _Leaf1B5_1B6_2B5_1B2_Ref }
  object { _Leaf1B5_1B6_2B5_1B3_Ref }
  object { _Leaf1B5_1B6_2B5_1B4_Ref }
  object { _Leaf1B5_1B6_2B5_1B5_Ref }
  object { _Leaf1B5_1B6_2B5_1B6_Ref }
  object { _Leaf1B5_1B6_2B5_1B7_Ref }
  object { _Leaf1B5_1B6_2B5_1B8_Ref }
  object { _Leaf1B5_1B6_2B5_1B9_Ref }
  object { _Leaf1B5_1B6_2B5_1B10_Ref }
  object { _Leaf1B5_1B6_2B5_1B11_Ref }
  object { _Leaf1B5_1B6_2B5_1B12_Ref }
  object { _Leaf1B5_1B6_1B1_1B1_Ref }
  object { _Leaf1B5_1B6_1B1_1B2_Ref }
  object { _Leaf1B5_1B6_1B1_1B3_Ref }
  object { _Leaf1B5_1B6_1B1_1B4_Ref }
  object { _Leaf1B5_1B6_1B1_1B5_Ref }
  object { _Leaf1B5_1B6_1B1_1B6_Ref }
  object { _Leaf1B5_1B6_1B1_1B7_Ref }
  object { _Leaf1B5_1B6_1B1_1B8_Ref }
  object { _Leaf1B5_1B6_1B1_1B9_Ref }
  object { _Leaf1B5_1B6_1B1_1B10_Ref }
  object { _Leaf1B5_1B6_1B1_1B11_Ref }
  object { _Leaf1B5_1B6_1B1_1B12_Ref }
  object { _Leaf1B5_1B6_1B2_1B1_Ref }
  object { _Leaf1B5_1B6_1B2_1B2_Ref }
  object { _Leaf1B5_1B6_1B2_1B3_Ref }
  object { _Leaf1B5_1B6_1B2_1B4_Ref }
  object { _Leaf1B5_1B6_1B2_1B5_Ref }
  object { _Leaf1B5_1B6_1B2_1B6_Ref }
  object { _Leaf1B5_1B6_1B2_1B7_Ref }
  object { _Leaf1B5_1B6_1B2_1B8_Ref }
  object { _Leaf1B5_1B6_1B2_1B9_Ref }
  object { _Leaf1B5_1B6_1B2_1B10_Ref }
  object { _Leaf1B5_1B6_1B2_1B11_Ref }
  object { _Leaf1B5_1B6_1B2_1B12_Ref }
  object { _Leaf1B5_1B6_1B3_1B1_Ref }
  object { _Leaf1B5_1B6_1B3_1B2_Ref }
  object { _Leaf1B5_1B6_1B3_1B3_Ref }
  object { _Leaf1B5_1B6_1B3_1B4_Ref }
  object { _Leaf1B5_1B6_1B3_1B5_Ref }
  object { _Leaf1B5_1B6_1B3_1B6_Ref }
  object { _Leaf1B5_1B6_1B3_1B7_Ref }
  object { _Leaf1B5_1B6_1B3_1B8_Ref }
  object { _Leaf1B5_1B6_1B3_1B9_Ref }
  object { _Leaf1B5_1B6_1B3_1B10_Ref }
  object { _Leaf1B5_1B6_1B3_1B11_Ref }
  object { _Leaf1B5_1B6_1B3_1B12_Ref }
  texture {
    HojasTex1
  }
}
union { // ArbolMA
  object { ArbolA_Limbs }
  object { ArbolA_Leafs }
  scale 0.6
  rotate -180.0*z
  translate  <-6.505511, -14.379094, -5.5>
}


#include "C:\MORAY FOR WINDOWS\POVScn\arbolb_limbs.inc"

#declare _Limb2_Ref = object {
  _Limb1
}
#declare _Limb3_Ref = object {
  _Limb2
  translate  12.0*z
}
#declare _Limb2B1_1_Ref = object {
  _Limb2B1_1
  rotate 65.0*y
  translate  12.0*z
}
#declare _Limb2B1_2_Ref = object {
  _Limb2B1_2
  rotate 65.0*y
  translate  <5.891, 0.0, 14.74702>
}
#declare _Limb2B1_2B1_1_Ref = object {
  _Limb2B1_2B1_1
  rotate <0.0, 117.236481, 48.358952>
  translate  <7.61299, 0.0, 15.54999>
}
#declare _Limb2B1_2B2_1_Ref = object {
  _Limb2B1_2B2_1
  rotate <0.0, 40.424461, 281.448395>
  translate  <7.61299, 0.0, 15.54999>
}
#declare _Limb2B1_2B3_1_Ref = object {
  _Limb2B1_2B3_1
  rotate <0.0, 41.191959, 84.56028>
  translate  <7.79425, 0.0, 15.63452>
}
#declare _Limb2B1_2B4_1_Ref = object {
  _Limb2B1_2B4_1
  rotate <0.0, 117.236481, 311.641052>
  translate  <7.79425, 0.0, 15.63452>
}
#declare _Limb2B1_2B5_1_Ref = object {
  _Limb2B1_2B5_1
  rotate 67.0*y
  translate  <8.60992, 0.0, 16.01487>
}
#declare _Limb2B1_1B1_1_Ref = object {
  _Limb2B1_1B1_1
  rotate 135.0*y
  translate  <2.17514, 0.0, 13.01428>
}
#declare _Limb2B1_1B2_1_Ref = object {
  _Limb2B1_1B2_1
  rotate <0.0, 3.0, 360.0>
  translate  <2.17514, 0.0, 13.01428>
}
#declare _Limb2B1_1B3_1_Ref = object {
  _Limb2B1_1B3_1
  rotate <0.0, 80.10202, 68.025223>
  translate  <2.3564, 0.0, 13.09881>
}
#declare _Limb2B1_1B4_1_Ref = object {
  _Limb2B1_1B4_1
  rotate <0.0, 78.55616, 295.729065>
  translate  <2.3564, 0.0, 13.09881>
}
#declare _Limb2B1_1B5_1_Ref = object {
  _Limb2B1_1B5_1
  rotate <0.0, 112.280579, 42.911812>
  translate  <3.98775, 0.0, 13.85952>
}
#declare _Limb2B1_1B6_1_Ref = object {
  _Limb2B1_1B6_1
  rotate <0.0, 40.424461, 281.448395>
  translate  <3.98775, 0.0, 13.85952>
}
#declare _Limb2B1_1B7_1_Ref = object {
  _Limb2B1_1B7_1
  rotate <0.0, 41.690201, 87.487068>
  translate  <4.16902, 0.0, 13.94404>
}
#declare _Limb2B1_1B8_1_Ref = object {
  _Limb2B1_1B8_1
  rotate <0.0, 115.136818, 314.029175>
  translate  <4.16902, 0.0, 13.94404>
}
#declare _Limb2B1_1B9_1_Ref = object {
  _Limb2B1_1B9_1
  rotate 135.0*y
  translate  <5.80037, 0.0, 14.70476>
}
#declare _Limb2B1_1B10_1_Ref = object {
  _Limb2B1_1B10_1
  rotate <0.0, 5.0, 180.0>
  translate  <5.80037, 0.0, 14.70476>
}
#declare _Limb2B1_1B11_1_Ref = object {
  _Limb2B1_1B11_1
  rotate <0.0, 79.711411, 67.090187>
  translate  <5.98163, 0.0, 14.78928>
}
#declare _Limb2B1_1B12_1_Ref = object {
  _Limb2B1_1B12_1
  rotate <0.0, 80.10202, 291.974792>
  translate  <5.98163, 0.0, 14.78928>
}
#declare _Limb2B2_1_Ref = object {
  _Limb2B2_1
  rotate <0.0, 65.0, 60.0>
  translate  12.0*z
}
#declare _Limb2B2_2_Ref = object {
  _Limb2B2_2
  rotate <0.0, 65.0, 60.0>
  translate  <2.9455, 5.10176, 14.74702>
}
#declare _Limb2B2_2B1_1_Ref = object {
  _Limb2B2_2B1_1
  rotate <0.0, 115.171021, 110.497498>
  translate  <3.80649, 6.59304, 15.54999>
}
#declare _Limb2B2_2B2_1_Ref = object {
  _Limb2B2_2B2_1
  rotate <0.0, 43.086201, 342.095032>
  translate  <3.80649, 6.59304, 15.54999>
}
#declare _Limb2B2_2B3_1_Ref = object {
  _Limb2B2_2B3_1
  rotate <0.0, 38.483212, 145.547333>
  translate  <3.89712, 6.75002, 15.63452>
}
#declare _Limb2B2_2B4_1_Ref = object {
  _Limb2B2_2B4_1
  rotate <0.0, 119.232582, 13.90075>
  translate  <3.89712, 6.75002, 15.63452>
}
#declare _Limb2B2_2B5_1_Ref = object {
  _Limb2B2_2B5_1
  rotate <0.0, 66.997299, 60.113689>
  translate  <4.30496, 7.45641, 16.01487>
}
#declare _Limb2B2_1B1_1_Ref = object {
  _Limb2B2_1B1_1
  rotate <0.0, 134.905502, 63.981602>
  translate  <1.08757, 1.88373, 13.01428>
}
#declare _Limb2B2_1B2_1_Ref = object {
  _Limb2B2_1B2_1
  rotate <0.0, 4.02554, 18.833441>
  translate  <1.08757, 1.88373, 13.01428>
}
#declare _Limb2B2_1B3_1_Ref = object {
  _Limb2B2_1B3_1
  rotate <0.0, 77.571213, 129.097168>
  translate  <1.1782, 2.0407, 13.09881>
}
#declare _Limb2B2_1B4_1_Ref = object {
  _Limb2B2_1B4_1
  rotate <0.0, 80.994637, 356.780182>
  translate  <1.1782, 2.0407, 13.09881>
}
#declare _Limb2B2_1B5_1_Ref = object {
  _Limb2B2_1B5_1
  rotate <0.0, 110.394119, 104.944969>
  translate  <1.99388, 3.4535, 13.85952>
}
#declare _Limb2B2_1B6_1_Ref = object {
  _Limb2B2_1B6_1
  rotate <0.0, 43.086201, 342.095032>
  translate  <1.99388, 3.4535, 13.85952>
}
#declare _Limb2B2_1B7_1_Ref = object {
  _Limb2B2_1B7_1
  rotate <0.0, 38.972881, 148.647125>
  translate  <2.08451, 3.61047, 13.94404>
}
#declare _Limb2B2_1B8_1_Ref = object {
  _Limb2B2_1B8_1
  rotate <0.0, 117.055054, 16.241341>
  translate  <2.08451, 3.61047, 13.94404>
}
#declare _Limb2B2_1B9_1_Ref = object {
  _Limb2B2_1B9_1
  rotate <0.0, 134.905502, 63.981602>
  translate  <2.90018, 5.02327, 14.70476>
}
#declare _Limb2B2_1B10_1_Ref = object {
  _Limb2B2_1B10_1
  rotate <0.0, 5.71615, 269.588776>
  translate  <2.90018, 5.02327, 14.70476>
}
#declare _Limb2B2_1B11_1_Ref = object {
  _Limb2B2_1B11_1
  rotate <0.0, 77.197289, 128.146759>
  translate  <2.99082, 5.18024, 14.78928>
}
#declare _Limb2B2_1B12_1_Ref = object {
  _Limb2B2_1B12_1
  rotate <0.0, 82.613457, 353.084503>
  translate  <2.99082, 5.18024, 14.78928>
}
#declare _Limb2B3_1_Ref = object {
  _Limb2B3_1
  rotate <0.0, 65.0, 120.0>
  translate  12.0*z
}
#declare _Limb2B3_2_Ref = object {
  _Limb2B3_2
  rotate <0.0, 65.0, 120.0>
  translate  <-2.9455, 5.10176, 14.74702>
}
#declare _Limb2B3_2B1_1_Ref = object {
  _Limb2B3_2B1_1
  rotate <0.0, 114.468269, 171.184814>
  translate  <-3.80649, 6.59304, 15.54999>
}
#declare _Limb2B3_2B2_1_Ref = object {
  _Limb2B3_2B2_1
  rotate <0.0, 43.972031, 42.315941>
  translate  <-3.80649, 6.59304, 15.54999>
}
#declare _Limb2B3_2B3_1_Ref = object {
  _Limb2B3_2B3_1
  rotate <0.0, 37.579441, 205.883392>
  translate  <-3.89712, 6.75002, 15.63452>
}
#declare _Limb2B3_2B4_1_Ref = object {
  _Limb2B3_2B4_1
  rotate <0.0, 119.881317, 74.682281>
  translate  <-3.89712, 6.75002, 15.63452>
}
#declare _Limb2B3_2B5_1_Ref = object {
  _Limb2B3_2B5_1
  rotate <0.0, 66.995201, 120.151543>
  translate  <-4.30496, 7.45641, 16.01487>
}
#declare _Limb2B3_1B1_1_Ref = object {
  _Limb2B3_1B1_1
  rotate <0.0, 134.832153, 125.303467>
  translate  <-1.08757, 1.88373, 13.01428>
}
#declare _Limb2B3_1B2_1_Ref = object {
  _Limb2B3_1B2_1
  rotate <0.0, 4.66994, 70.84301>
  translate  <-1.08757, 1.88373, 13.01428>
}
#declare _Limb2B3_1B3_1_Ref = object {
  _Limb2B3_1B3_1
  rotate <0.0, 76.723572, 189.446609>
  translate  <-1.1782, 2.0407, 13.09881>
}
#declare _Limb2B3_1B4_1_Ref = object {
  _Limb2B3_1B4_1
  rotate <0.0, 81.802452, 57.140652>
  translate  <-1.1782, 2.0407, 13.09881>
}
#declare _Limb2B3_1B5_1_Ref = object {
  _Limb2B3_1B5_1
  rotate <0.0, 109.750214, 165.600647>
  translate  <-1.99388, 3.4535, 13.85952>
}
#declare _Limb2B3_1B6_1_Ref = object {
  _Limb2B3_1B6_1
  rotate <0.0, 43.972031, 42.315941>
  translate  <-1.99388, 3.4535, 13.85952>
}
#declare _Limb2B3_1B7_1_Ref = object {
  _Limb2B3_1B7_1
  rotate <0.0, 38.06675, 209.046844>
  translate  <-2.08451, 3.61047, 13.94404>
}
#declare _Limb2B3_1B8_1_Ref = object {
  _Limb2B3_1B8_1
  rotate <0.0, 117.677513, 77.004936>
  translate  <-2.08451, 3.61047, 13.94404>
}
#declare _Limb2B3_1B9_1_Ref = object {
  _Limb2B3_1B9_1
  rotate <0.0, 134.832153, 125.303467>
  translate  <-2.90018, 5.02327, 14.70476>
}
#declare _Limb2B3_1B10_1_Ref = object {
  _Limb2B3_1B10_1
  rotate <0.0, 6.21634, 337.254425>
  translate  <-2.90018, 5.02327, 14.70476>
}
#declare _Limb2B3_1B11_1_Ref = object {
  _Limb2B3_1B11_1
  rotate <0.0, 76.355103, 188.490707>
  translate  <-2.99082, 5.18024, 14.78928>
}
#declare _Limb2B3_1B12_1_Ref = object {
  _Limb2B3_1B12_1
  rotate <0.0, 83.446022, 53.463348>
  translate  <-2.99082, 5.18024, 14.78928>
}
#declare _Limb2B4_1_Ref = object {
  _Limb2B4_1
  rotate <0.0, 65.0, 180.0>
  translate  12.0*z
}
#declare _Limb2B4_2_Ref = object {
  _Limb2B4_2
  rotate <0.0, 65.0, 180.0>
  translate  <-5.891, 0.0, 14.74702>
}
#declare _Limb2B4_2B1_1_Ref = object {
  _Limb2B4_2B1_1
  rotate <0.0, 119.232582, 226.099243>
  translate  <-7.61299, 0.0, 15.54999>
}
#declare _Limb2B4_2B2_1_Ref = object {
  _Limb2B4_2B2_1
  rotate <0.0, 37.756741, 100.826912>
  translate  <-7.61299, 0.0, 15.54999>
}
#declare _Limb2B4_2B3_1_Ref = object {
  _Limb2B4_2B3_1
  rotate <0.0, 43.896339, 263.597839>
  translate  <-7.79425, 0.0, 15.63452>
}
#declare _Limb2B4_2B4_1_Ref = object {
  _Limb2B4_2B4_1
  rotate <0.0, 115.171021, 129.502502>
  translate  <-7.79425, 0.0, 15.63452>
}
#declare _Limb2B4_2B5_1_Ref = object {
  _Limb2B4_2B5_1
  rotate <0.0, 66.997299, 179.886307>
  translate  <-8.60992, 0.0, 16.01487>
}
#declare _Limb2B4_1B1_1_Ref = object {
  _Limb2B4_1B1_1
  rotate <0.0, 134.905502, 176.018402>
  translate  <-2.17514, 0.0, 13.01428>
}
#declare _Limb2B4_1B2_1_Ref = object {
  _Limb2B4_1B2_1
  rotate <0.0, 4.02554, 221.166565>
  translate  <-2.17514, 0.0, 13.01428>
}
#declare _Limb2B4_1B3_1_Ref = object {
  _Limb2B4_1B3_1
  rotate <0.0, 82.613457, 246.915497>
  translate  <-2.3564, 0.0, 13.09881>
}
#declare _Limb2B4_1B4_1_Ref = object {
  _Limb2B4_1B4_1
  rotate <0.0, 76.096481, 114.721588>
  translate  <-2.3564, 0.0, 13.09881>
}
#declare _Limb2B4_1B5_1_Ref = object {
  _Limb2B4_1B5_1
  rotate <0.0, 114.094589, 220.775955>
  translate  <-3.98775, 0.0, 13.85952>
}
#declare _Limb2B4_1B6_1_Ref = object {
  _Limb2B4_1B6_1
  rotate <0.0, 37.756741, 100.826912>
  translate  <-3.98775, 0.0, 13.85952>
}
#declare _Limb2B4_1B7_1_Ref = object {
  _Limb2B4_1B7_1
  rotate <0.0, 44.40517, 266.374847>
  translate  <-4.16902, 0.0, 13.94404>
}
#declare _Limb2B4_1B8_1_Ref = object {
  _Limb2B4_1B8_1
  rotate <0.0, 113.147476, 131.930145>
  translate  <-4.16902, 0.0, 13.94404>
}
#declare _Limb2B4_1B9_1_Ref = object {
  _Limb2B4_1B9_1
  rotate <0.0, 134.905502, 176.018402>
  translate  <-5.80037, 0.0, 14.70476>
}
#declare _Limb2B4_1B10_1_Ref = object {
  _Limb2B4_1B10_1
  rotate <0.0, 5.71615, 330.411255>
  translate  <-5.80037, 0.0, 14.70476>
}
#declare _Limb2B4_1B11_1_Ref = object {
  _Limb2B4_1B11_1
  rotate <0.0, 82.205658, 245.994354>
  translate  <-5.98163, 0.0, 14.78928>
}
#declare _Limb2B4_1B12_1_Ref = object {
  _Limb2B4_1B12_1
  rotate <0.0, 77.571213, 110.902832>
  translate  <-5.98163, 0.0, 14.78928>
}
#declare _Limb2B5_1_Ref = object {
  _Limb2B5_1
  rotate <0.0, 60.0, 30.0>
  translate  15.5*z
}
#declare _Limb2B5_2_Ref = object {
  _Limb2B5_2
  rotate <0.0, 60.0, 30.0>
  translate  <4.875, 2.81458, 18.75>
}
#declare _Limb2B5_2B1_1_Ref = object {
  _Limb2B5_2B1_1
  rotate <0.0, 115.706383, 74.25425>
  translate  <6.3, 3.63731, 19.7>
}
#declare _Limb2B5_2B2_1_Ref = object {
  _Limb2B5_2B2_1
  rotate <0.0, 37.095291, 304.342926>
  translate  <6.3, 3.63731, 19.7>
}
#declare _Limb2B5_2B3_1_Ref = object {
  _Limb2B5_2B3_1
  rotate <0.0, 43.565121, 118.818108>
  translate  <6.45, 3.72391, 19.8>
}
#declare _Limb2B5_2B4_1_Ref = object {
  _Limb2B5_2B4_1
  rotate <0.0, 111.933289, 341.165009>
  translate  <6.45, 3.72391, 19.8>
}
#declare _Limb2B5_2B5_1_Ref = object {
  _Limb2B5_2B5_1
  rotate <0.0, 61.997311, 29.88147>
  translate  <7.125, 4.11362, 20.25>
}
#declare _Limb2B5_1B1_1_Ref = object {
  _Limb2B5_1B1_1
  rotate <0.0, 129.916626, 26.323601>
  translate  <1.8, 1.03923, 16.7>
}
#declare _Limb2B5_1B2_1_Ref = object {
  _Limb2B5_1B2_1
  rotate <0.0, 3.29893, 156.580795>
  translate  <1.8, 1.03923, 16.7>
}
#declare _Limb2B5_1B3_1_Ref = object {
  _Limb2B5_1B3_1
  rotate <0.0, 80.679169, 97.59304>
  translate  <1.95, 1.12583, 16.8>
}
#declare _Limb2B5_1B4_1_Ref = object {
  _Limb2B5_1B4_1
  rotate <0.0, 74.052597, 323.504303>
  translate  <1.95, 1.12583, 16.8>
}
#declare _Limb2B5_1B5_1_Ref = object {
  _Limb2B5_1B5_1
  rotate <0.0, 110.269768, 69.461441>
  translate  <3.3, 1.90526, 17.7>
}
#declare _Limb2B5_1B6_1_Ref = object {
  _Limb2B5_1B6_1
  rotate <0.0, 37.095291, 304.342926>
  translate  <3.3, 1.90526, 17.7>
}
#declare _Limb2B5_1B7_1_Ref = object {
  _Limb2B5_1B7_1
  rotate <0.0, 44.311951, 121.492126>
  translate  <3.45, 1.99186, 17.8>
}
#declare _Limb2B5_1B8_1_Ref = object {
  _Limb2B5_1B8_1
  rotate <0.0, 109.758263, 343.37616>
  translate  <3.45, 1.99186, 17.8>
}
#declare _Limb2B5_1B9_1_Ref = object {
  _Limb2B5_1B9_1
  rotate <0.0, 129.916626, 26.323601>
  translate  <4.8, 2.77128, 18.7>
}
#declare _Limb2B5_1B10_1_Ref = object {
  _Limb2B5_1B10_1
  rotate <0.0, 10.36152, 194.131195>
  translate  <4.8, 2.77128, 18.7>
}
#declare _Limb2B5_1B11_1_Ref = object {
  _Limb2B5_1B11_1
  rotate <0.0, 80.19873, 96.703659>
  translate  <4.95, 2.85788, 18.8>
}
#declare _Limb2B5_1B12_1_Ref = object {
  _Limb2B5_1B12_1
  rotate <0.0, 75.83152, 319.794037>
  translate  <4.95, 2.85788, 18.8>
}
#declare _Limb2B6_1_Ref = object {
  _Limb2B6_1
  rotate <0.0, 60.0, 90.0>
  translate  15.5*z
}
#declare _Limb2B6_2_Ref = object {
  _Limb2B6_2
  rotate <0.0, 60.0, 90.0>
  translate  <0.0, 5.62917, 18.75>
}
#declare _Limb2B6_2B1_1_Ref = object {
  _Limb2B6_2B1_1
  rotate <0.0, 115.706383, 134.254257>
  translate  <0.0, 7.27461, 19.7>
}
#declare _Limb2B6_2B2_1_Ref = object {
  _Limb2B6_2B2_1
  rotate <0.0, 37.095291, 4.34293>
  translate  <0.0, 7.27461, 19.7>
}
#declare _Limb2B6_2B3_1_Ref = object {
  _Limb2B6_2B3_1
  rotate <0.0, 43.565121, 178.818115>
  translate  <0.0, 7.44782, 19.8>
}
#declare _Limb2B6_2B4_1_Ref = object {
  _Limb2B6_2B4_1
  rotate <0.0, 111.933289, 41.165001>
  translate  <0.0, 7.44782, 19.8>
}
#declare _Limb2B6_2B5_1_Ref = object {
  _Limb2B6_2B5_1
  rotate <0.0, 61.997311, 89.88147>
  translate  <0.0, 8.22724, 20.25>
}
#declare _Limb2B6_1B1_1_Ref = object {
  _Limb2B6_1B1_1
  rotate <0.0, 129.916626, 86.323601>
  translate  <0.0, 2.07846, 16.7>
}
#declare _Limb2B6_1B2_1_Ref = object {
  _Limb2B6_1B2_1
  rotate <0.0, 3.29893, 216.580795>
  translate  <0.0, 2.07846, 16.7>
}
#declare _Limb2B6_1B3_1_Ref = object {
  _Limb2B6_1B3_1
  rotate <0.0, 80.679169, 157.593033>
  translate  <0.0, 2.25167, 16.8>
}
#declare _Limb2B6_1B4_1_Ref = object {
  _Limb2B6_1B4_1
  rotate <0.0, 74.052597, 23.504311>
  translate  <0.0, 2.25167, 16.8>
}
#declare _Limb2B6_1B5_1_Ref = object {
  _Limb2B6_1B5_1
  rotate <0.0, 110.269768, 129.461441>
  translate  <0.0, 3.81051, 17.7>
}
#declare _Limb2B6_1B6_1_Ref = object {
  _Limb2B6_1B6_1
  rotate <0.0, 37.095291, 4.34293>
  translate  <0.0, 3.81051, 17.7>
}
#declare _Limb2B6_1B7_1_Ref = object {
  _Limb2B6_1B7_1
  rotate <0.0, 44.311951, 181.492126>
  translate  <0.0, 3.98372, 17.8>
}
#declare _Limb2B6_1B8_1_Ref = object {
  _Limb2B6_1B8_1
  rotate <0.0, 109.758263, 43.376148>
  translate  <0.0, 3.98372, 17.8>
}
#declare _Limb2B6_1B9_1_Ref = object {
  _Limb2B6_1B9_1
  rotate <0.0, 129.916626, 86.323601>
  translate  <0.0, 5.54256, 18.7>
}
#declare _Limb2B6_1B10_1_Ref = object {
  _Limb2B6_1B10_1
  rotate <0.0, 10.36152, 254.131195>
  translate  <0.0, 5.54256, 18.7>
}
#declare _Limb2B6_1B11_1_Ref = object {
  _Limb2B6_1B11_1
  rotate <0.0, 80.19873, 156.703659>
  translate  <0.0, 5.71577, 18.8>
}
#declare _Limb2B6_1B12_1_Ref = object {
  _Limb2B6_1B12_1
  rotate <0.0, 75.83152, 19.794041>
  translate  <0.0, 5.71577, 18.8>
}
#declare _Limb2B7_1_Ref = object {
  _Limb2B7_1
  rotate <0.0, 60.0, 150.0>
  translate  15.5*z
}
#declare _Limb2B7_2_Ref = object {
  _Limb2B7_2
  rotate <0.0, 60.0, 150.0>
  translate  <-4.875, 2.81458, 18.75>
}
#declare _Limb2B7_2B1_1_Ref = object {
  _Limb2B7_2B1_1
  rotate <0.0, 110.615143, 200.272614>
  translate  <-6.3, 3.63731, 19.7>
}
#declare _Limb2B7_2B2_1_Ref = object {
  _Limb2B7_2B2_1
  rotate <0.0, 43.985329, 67.510536>
  translate  <-6.3, 3.63731, 19.7>
}
#declare _Limb2B7_2B3_1_Ref = object {
  _Limb2B7_2B3_1
  rotate <0.0, 36.639141, 242.950058>
  translate  <-6.45, 3.72391, 19.8>
}
#declare _Limb2B7_2B4_1_Ref = object {
  _Limb2B7_2B4_1
  rotate <0.0, 116.897461, 107.367447>
  translate  <-6.45, 3.72391, 19.8>
}
#declare _Limb2B7_2B5_1_Ref = object {
  _Limb2B7_2B5_1
  rotate <0.0, 61.992538, 150.197388>
  translate  <-7.125, 4.11362, 20.25>
}
#declare _Limb2B7_1B1_1_Ref = object {
  _Limb2B7_1B1_1
  rotate <0.0, 129.768768, 156.116608>
  translate  <-1.8, 1.03923, 16.7>
}
#declare _Limb2B7_1B2_1_Ref = object {
  _Limb2B7_1B2_1
  rotate <0.0, 4.80806, 36.651058>
  translate  <-1.8, 1.03923, 16.7>
}
#declare _Limb2B7_1B3_1_Ref = object {
  _Limb2B7_1B3_1
  rotate <0.0, 74.197517, 221.052246>
  translate  <-1.95, 1.12583, 16.8>
}
#declare _Limb2B7_1B4_1_Ref = object {
  _Limb2B7_1B4_1
  rotate <0.0, 80.323112, 86.838371>
  translate  <-1.95, 1.12583, 16.8>
}
#declare _Limb2B7_1B5_1_Ref = object {
  _Limb2B7_1B5_1
  rotate <0.0, 105.604874, 195.127014>
  translate  <-3.3, 1.90526, 17.7>
}
#declare _Limb2B7_1B6_1_Ref = object {
  _Limb2B7_1B6_1
  rotate <0.0, 43.985329, 67.510536>
  translate  <-3.3, 1.90526, 17.7>
}
#declare _Limb2B7_1B7_1_Ref = object {
  _Limb2B7_1B7_1
  rotate <0.0, 37.39994, 246.022491>
  translate  <-3.45, 1.99186, 17.8>
}
#declare _Limb2B7_1B8_1_Ref = object {
  _Limb2B7_1B8_1
  rotate <0.0, 114.538849, 109.425468>
  translate  <-3.45, 1.99186, 17.8>
}
#declare _Limb2B7_1B9_1_Ref = object {
  _Limb2B7_1B9_1
  rotate <0.0, 129.768768, 156.116608>
  translate  <-4.8, 2.77128, 18.7>
}
#declare _Limb2B7_1B10_1_Ref = object {
  _Limb2B7_1B10_1
  rotate <0.0, 10.9748, 355.480011>
  translate  <-4.8, 2.77128, 18.7>
}
#declare _Limb2B7_1B11_1_Ref = object {
  _Limb2B7_1B11_1
  rotate <0.0, 73.756721, 220.118362>
  translate  <-4.95, 2.85788, 18.8>
}
#declare _Limb2B7_1B12_1_Ref = object {
  _Limb2B7_1B12_1
  rotate <0.0, 82.275223, 83.306213>
  translate  <-4.95, 2.85788, 18.8>
}
#declare _Limb2B8_1_Ref = object {
  _Limb2B8_1
  translate  18.0*z
}
#declare _Limb2B8_2_Ref = object {
  _Limb2B8_2
  translate  22.5*z
}
#declare _Limb2B8_2B1_1_Ref = object {
  _Limb2B8_2B1_1
  rotate <0.0, 70.0, 45.0>
  translate  24.4*z
}
#declare _Limb2B8_2B2_1_Ref = object {
  _Limb2B8_2B2_1
  rotate <0.0, 64.0, 225.0>
  translate  24.4*z
}
#declare _Limb2B8_2B3_1_Ref = object {
  _Limb2B8_2B3_1
  rotate <0.0, 68.0, 135.0>
  translate  24.6*z
}
#declare _Limb2B8_2B4_1_Ref = object {
  _Limb2B8_2B4_1
  rotate <0.0, 70.0, 315.0>
  translate  24.6*z
}
#declare _Limb2B8_2B5_1_Ref = object {
  _Limb2B8_2B5_1
  rotate 2.0*y
  translate  25.5*z
}
#declare _Limb2B8_1B1_1_Ref = object {
  _Limb2B8_1B1_1
  rotate 70.0*y
  translate  20.4*z
}
#declare _Limb2B8_1B2_1_Ref = object {
  _Limb2B8_1B2_1
  rotate <0.0, 66.0, 90.0>
  translate  20.4*z
}
#declare _Limb2B8_1B3_1_Ref = object {
  _Limb2B8_1B3_1
  rotate <0.0, 62.0, 180.0>
  translate  20.6*z
}
#declare _Limb2B8_1B4_1_Ref = object {
  _Limb2B8_1B4_1
  rotate <0.0, 62.0, 270.0>
  translate  20.6*z
}
#declare _Limb2B8_1B5_1_Ref = object {
  _Limb2B8_1B5_1
  rotate 70.0*y
  translate  22.43077*z
}
#declare _Limb2B8_1B6_1_Ref = object {
  _Limb2B8_1B6_1
  rotate <0.0, 70.0, 180.0>
  translate  22.43077*z
}
#declare _Limb2B8_1B7_1_Ref = object {
  _Limb2B8_1B7_1
  rotate <0.0, 65.0, 90.0>
  translate  22.56923*z
}
#declare _Limb2B8_1B8_1_Ref = object {
  _Limb2B8_1B8_1
  rotate <0.0, 66.0, 270.0>
  translate  22.56923*z
}
#declare _Limb2B9_1_Ref = object {
  _Limb2B9_1
  rotate <0.0, 45.0, 50.0>
  translate  18.125*z
}
#declare _Limb2B9_2_Ref = object {
  _Limb2B9_2
  rotate <0.0, 45.0, 50.0>
  translate  <2.04534, 2.43754, 21.30698>
}
#declare _Limb2B9_2B1_1_Ref = object {
  _Limb2B9_2B1_1
  rotate <0.0, 104.592781, 90.521782>
  translate  <2.90892, 3.46672, 22.65048>
}
#declare _Limb2B9_2B2_1_Ref = object {
  _Limb2B9_2B2_1
  rotate <0.0, 38.53056, 304.895355>
  translate  <2.90892, 3.46672, 22.65048>
}
#declare _Limb2B9_2B3_1_Ref = object {
  _Limb2B9_2B3_1
  rotate <0.0, 45.284988, 154.157425>
  translate  <2.99983, 3.57506, 22.7919>
}
#declare _Limb2B9_2B4_1_Ref = object {
  _Limb2B9_2B4_1
  rotate <0.0, 101.69886, 4.50887>
  translate  <2.99983, 3.57506, 22.7919>
}
#declare _Limb2B9_2B5_1_Ref = object {
  _Limb2B9_2B5_1
  rotate <0.0, 46.997349, 49.856899>
  translate  <3.4089, 4.06256, 23.4283>
}
#declare _Limb2B9_1B1_1_Ref = object {
  _Limb2B9_1B1_1
  rotate <0.0, 114.942436, 46.890839>
  translate  <1.09085, 1.30002, 19.82206>
}
#declare _Limb2B9_1B2_1_Ref = object {
  _Limb2B9_1B2_1
  rotate <0.0, 75.297592, 120.591919>
  translate  <1.09085, 1.30002, 19.82206>
}
#declare _Limb2B9_1B3_1_Ref = object {
  _Limb2B9_1B3_1
  rotate <0.0, 17.16688, 220.992661>
  translate  <1.18175, 1.40836, 19.96348>
}
#declare _Limb2B9_1B4_1_Ref = object {
  _Limb2B9_1B4_1
  rotate <0.0, 68.614464, 338.748932>
  translate  <1.18175, 1.40836, 19.96348>
}
#declare _Limb2B9_1B5_1_Ref = object {
  _Limb2B9_1B5_1
  rotate <0.0, 114.942436, 46.890839>
  translate  <2.01387, 2.40004, 21.25803>
}
#declare _Limb2B9_1B6_1_Ref = object {
  _Limb2B9_1B6_1
  rotate <0.0, 25.123171, 223.34819>
  translate  <2.01387, 2.40004, 21.25803>
}
#declare _Limb2B9_1B7_1_Ref = object {
  _Limb2B9_1B7_1
  rotate <0.0, 74.615433, 119.834763>
  translate  <2.0768, 2.47504, 21.35593>
}
#declare _Limb2B9_1B8_1_Ref = object {
  _Limb2B9_1B8_1
  rotate <0.0, 71.251549, 335.546478>
  translate  <2.0768, 2.47504, 21.35593>
}
#declare _Limb2B10_1_Ref = object {
  _Limb2B10_1
  rotate <0.0, 45.0, 140.0>
  translate  18.125*z
}
#declare _Limb2B10_2_Ref = object {
  _Limb2B10_2
  rotate <0.0, 45.0, 140.0>
  translate  <-2.43754, 2.04534, 21.30698>
}
#declare _Limb2B10_2B1_1_Ref = object {
  _Limb2B10_2B1_1
  rotate <0.0, 100.676521, 187.098679>
  translate  <-3.46672, 2.90892, 22.65048>
}
#declare _Limb2B10_2B2_1_Ref = object {
  _Limb2B10_2B2_1
  rotate <0.0, 44.069672, 41.854832>
  translate  <-3.46672, 2.90892, 22.65048>
}
#declare _Limb2B10_2B3_1_Ref = object {
  _Limb2B10_2B3_1
  rotate <0.0, 39.904091, 251.714554>
  translate  <-3.57506, 2.99983, 22.7919>
}
#declare _Limb2B10_2B4_1_Ref = object {
  _Limb2B10_2B4_1
  rotate <0.0, 105.495537, 101.185097>
  translate  <-3.57506, 2.99983, 22.7919>
}
#declare _Limb2B10_2B5_1_Ref = object {
  _Limb2B10_2B5_1
  rotate <0.0, 46.992641, 140.238327>
  translate  <-4.06256, 3.4089, 23.4283>
}
#declare _Limb2B10_1B1_1_Ref = object {
  _Limb2B10_1B1_1
  rotate <0.0, 114.840263, 145.177948>
  translate  <-1.30002, 1.09085, 19.82206>
}
#declare _Limb2B10_1B2_1_Ref = object {
  _Limb2B10_1B2_1
  rotate <0.0, 69.884941, 215.739487>
  translate  <-1.30002, 1.09085, 19.82206>
}
#declare _Limb2B10_1B3_1_Ref = object {
  _Limb2B10_1B3_1
  rotate <0.0, 17.45956, 334.861633>
  translate  <-1.40836, 1.18175, 19.96348>
}
#declare _Limb2B10_1B4_1_Ref = object {
  _Limb2B10_1B4_1
  rotate <0.0, 73.885849, 73.714699>
  translate  <-1.40836, 1.18175, 19.96348>
}
#declare _Limb2B10_1B5_1_Ref = object {
  _Limb2B10_1B5_1
  rotate <0.0, 114.840263, 145.177948>
  translate  <-2.40004, 2.01387, 21.25803>
}
#declare _Limb2B10_1B6_1_Ref = object {
  _Limb2B10_1B6_1
  rotate <0.0, 25.34063, 331.03186>
  translate  <-2.40004, 2.01387, 21.25803>
}
#declare _Limb2B10_1B7_1_Ref = object {
  _Limb2B10_1B7_1
  rotate <0.0, 69.225517, 214.937164>
  translate  <-2.47504, 2.0768, 21.35593>
}
#declare _Limb2B10_1B8_1_Ref = object {
  _Limb2B10_1B8_1
  rotate <0.0, 76.62603, 70.701111>
  translate  <-2.47504, 2.0768, 21.35593>
}
#declare ArbolB_Limbs = union {
  object { _Limb2_Ref }
  object { _Limb3_Ref }
  object { _Limb2B1_1_Ref }
  object { _Limb2B1_2_Ref }
  object { _Limb2B1_2B1_1_Ref }
  object { _Limb2B1_2B2_1_Ref }
  object { _Limb2B1_2B3_1_Ref }
  object { _Limb2B1_2B4_1_Ref }
  object { _Limb2B1_2B5_1_Ref }
  object { _Limb2B1_1B1_1_Ref }
  object { _Limb2B1_1B2_1_Ref }
  object { _Limb2B1_1B3_1_Ref }
  object { _Limb2B1_1B4_1_Ref }
  object { _Limb2B1_1B5_1_Ref }
  object { _Limb2B1_1B6_1_Ref }
  object { _Limb2B1_1B7_1_Ref }
  object { _Limb2B1_1B8_1_Ref }
  object { _Limb2B1_1B9_1_Ref }
  object { _Limb2B1_1B10_1_Ref }
  object { _Limb2B1_1B11_1_Ref }
  object { _Limb2B1_1B12_1_Ref }
  object { _Limb2B2_1_Ref }
  object { _Limb2B2_2_Ref }
  object { _Limb2B2_2B1_1_Ref }
  object { _Limb2B2_2B2_1_Ref }
  object { _Limb2B2_2B3_1_Ref }
  object { _Limb2B2_2B4_1_Ref }
  object { _Limb2B2_2B5_1_Ref }
  object { _Limb2B2_1B1_1_Ref }
  object { _Limb2B2_1B2_1_Ref }
  object { _Limb2B2_1B3_1_Ref }
  object { _Limb2B2_1B4_1_Ref }
  object { _Limb2B2_1B5_1_Ref }
  object { _Limb2B2_1B6_1_Ref }
  object { _Limb2B2_1B7_1_Ref }
  object { _Limb2B2_1B8_1_Ref }
  object { _Limb2B2_1B9_1_Ref }
  object { _Limb2B2_1B10_1_Ref }
  object { _Limb2B2_1B11_1_Ref }
  object { _Limb2B2_1B12_1_Ref }
  object { _Limb2B3_1_Ref }
  object { _Limb2B3_2_Ref }
  object { _Limb2B3_2B1_1_Ref }
  object { _Limb2B3_2B2_1_Ref }
  object { _Limb2B3_2B3_1_Ref }
  object { _Limb2B3_2B4_1_Ref }
  object { _Limb2B3_2B5_1_Ref }
  object { _Limb2B3_1B1_1_Ref }
  object { _Limb2B3_1B2_1_Ref }
  object { _Limb2B3_1B3_1_Ref }
  object { _Limb2B3_1B4_1_Ref }
  object { _Limb2B3_1B5_1_Ref }
  object { _Limb2B3_1B6_1_Ref }
  object { _Limb2B3_1B7_1_Ref }
  object { _Limb2B3_1B8_1_Ref }
  object { _Limb2B3_1B9_1_Ref }
  object { _Limb2B3_1B10_1_Ref }
  object { _Limb2B3_1B11_1_Ref }
  object { _Limb2B3_1B12_1_Ref }
  object { _Limb2B4_1_Ref }
  object { _Limb2B4_2_Ref }
  object { _Limb2B4_2B1_1_Ref }
  object { _Limb2B4_2B2_1_Ref }
  object { _Limb2B4_2B3_1_Ref }
  object { _Limb2B4_2B4_1_Ref }
  object { _Limb2B4_2B5_1_Ref }
  object { _Limb2B4_1B1_1_Ref }
  object { _Limb2B4_1B2_1_Ref }
  object { _Limb2B4_1B3_1_Ref }
  object { _Limb2B4_1B4_1_Ref }
  object { _Limb2B4_1B5_1_Ref }
  object { _Limb2B4_1B6_1_Ref }
  object { _Limb2B4_1B7_1_Ref }
  object { _Limb2B4_1B8_1_Ref }
  object { _Limb2B4_1B9_1_Ref }
  object { _Limb2B4_1B10_1_Ref }
  object { _Limb2B4_1B11_1_Ref }
  object { _Limb2B4_1B12_1_Ref }
  object { _Limb2B5_1_Ref }
  object { _Limb2B5_2_Ref }
  object { _Limb2B5_2B1_1_Ref }
  object { _Limb2B5_2B2_1_Ref }
  object { _Limb2B5_2B3_1_Ref }
  object { _Limb2B5_2B4_1_Ref }
  object { _Limb2B5_2B5_1_Ref }
  object { _Limb2B5_1B1_1_Ref }
  object { _Limb2B5_1B2_1_Ref }
  object { _Limb2B5_1B3_1_Ref }
  object { _Limb2B5_1B4_1_Ref }
  object { _Limb2B5_1B5_1_Ref }
  object { _Limb2B5_1B6_1_Ref }
  object { _Limb2B5_1B7_1_Ref }
  object { _Limb2B5_1B8_1_Ref }
  object { _Limb2B5_1B9_1_Ref }
  object { _Limb2B5_1B10_1_Ref }
  object { _Limb2B5_1B11_1_Ref }
  object { _Limb2B5_1B12_1_Ref }
  object { _Limb2B6_1_Ref }
  object { _Limb2B6_2_Ref }
  object { _Limb2B6_2B1_1_Ref }
  object { _Limb2B6_2B2_1_Ref }
  object { _Limb2B6_2B3_1_Ref }
  object { _Limb2B6_2B4_1_Ref }
  object { _Limb2B6_2B5_1_Ref }
  object { _Limb2B6_1B1_1_Ref }
  object { _Limb2B6_1B2_1_Ref }
  object { _Limb2B6_1B3_1_Ref }
  object { _Limb2B6_1B4_1_Ref }
  object { _Limb2B6_1B5_1_Ref }
  object { _Limb2B6_1B6_1_Ref }
  object { _Limb2B6_1B7_1_Ref }
  object { _Limb2B6_1B8_1_Ref }
  object { _Limb2B6_1B9_1_Ref }
  object { _Limb2B6_1B10_1_Ref }
  object { _Limb2B6_1B11_1_Ref }
  object { _Limb2B6_1B12_1_Ref }
  object { _Limb2B7_1_Ref }
  object { _Limb2B7_2_Ref }
  object { _Limb2B7_2B1_1_Ref }
  object { _Limb2B7_2B2_1_Ref }
  object { _Limb2B7_2B3_1_Ref }
  object { _Limb2B7_2B4_1_Ref }
  object { _Limb2B7_2B5_1_Ref }
  object { _Limb2B7_1B1_1_Ref }
  object { _Limb2B7_1B2_1_Ref }
  object { _Limb2B7_1B3_1_Ref }
  object { _Limb2B7_1B4_1_Ref }
  object { _Limb2B7_1B5_1_Ref }
  object { _Limb2B7_1B6_1_Ref }
  object { _Limb2B7_1B7_1_Ref }
  object { _Limb2B7_1B8_1_Ref }
  object { _Limb2B7_1B9_1_Ref }
  object { _Limb2B7_1B10_1_Ref }
  object { _Limb2B7_1B11_1_Ref }
  object { _Limb2B7_1B12_1_Ref }
  object { _Limb2B8_1_Ref }
  object { _Limb2B8_2_Ref }
  object { _Limb2B8_2B1_1_Ref }
  object { _Limb2B8_2B2_1_Ref }
  object { _Limb2B8_2B3_1_Ref }
  object { _Limb2B8_2B4_1_Ref }
  object { _Limb2B8_2B5_1_Ref }
  object { _Limb2B8_1B1_1_Ref }
  object { _Limb2B8_1B2_1_Ref }
  object { _Limb2B8_1B3_1_Ref }
  object { _Limb2B8_1B4_1_Ref }
  object { _Limb2B8_1B5_1_Ref }
  object { _Limb2B8_1B6_1_Ref }
  object { _Limb2B8_1B7_1_Ref }
  object { _Limb2B8_1B8_1_Ref }
  object { _Limb2B9_1_Ref }
  object { _Limb2B9_2_Ref }
  object { _Limb2B9_2B1_1_Ref }
  object { _Limb2B9_2B2_1_Ref }
  object { _Limb2B9_2B3_1_Ref }
  object { _Limb2B9_2B4_1_Ref }
  object { _Limb2B9_2B5_1_Ref }
  object { _Limb2B9_1B1_1_Ref }
  object { _Limb2B9_1B2_1_Ref }
  object { _Limb2B9_1B3_1_Ref }
  object { _Limb2B9_1B4_1_Ref }
  object { _Limb2B9_1B5_1_Ref }
  object { _Limb2B9_1B6_1_Ref }
  object { _Limb2B9_1B7_1_Ref }
  object { _Limb2B9_1B8_1_Ref }
  object { _Limb2B10_1_Ref }
  object { _Limb2B10_2_Ref }
  object { _Limb2B10_2B1_1_Ref }
  object { _Limb2B10_2B2_1_Ref }
  object { _Limb2B10_2B3_1_Ref }
  object { _Limb2B10_2B4_1_Ref }
  object { _Limb2B10_2B5_1_Ref }
  object { _Limb2B10_1B1_1_Ref }
  object { _Limb2B10_1B2_1_Ref }
  object { _Limb2B10_1B3_1_Ref }
  object { _Limb2B10_1B4_1_Ref }
  object { _Limb2B10_1B5_1_Ref }
  object { _Limb2B10_1B6_1_Ref }
  object { _Limb2B10_1B7_1_Ref }
  object { _Limb2B10_1B8_1_Ref }
  texture {
    TroncoTex1
  }
}
#include "C:\MORAY FOR WINDOWS\POVScn\arbolb_leafs.inc"

#declare _Leaf2B1_2B1_1B1_Ref = object {
  _Leaf2B1_2B1_1B1
  rotate <0.0, 138.25766, 133.586868>
  translate  <7.98997, 0.47693, 15.19955>
}
#declare _Leaf2B1_2B1_1B2_Ref = object {
  _Leaf2B1_2B1_1B2
  rotate <0.0, 49.112839, 65.709343>
  translate  <8.09109, 0.55477, 15.2246>
}
#declare _Leaf2B1_2B1_1B3_Ref = object {
  _Leaf2B1_2B1_1B3
  rotate <0.0, 123.816071, 334.009979>
  translate  <8.17358, 0.56458, 15.12684>
}
#declare _Leaf2B1_2B1_1B4_Ref = object {
  _Leaf2B1_2B1_1B4
  rotate <0.0, 132.03299, 135.269943>
  translate  <8.65302, 1.20358, 14.70697>
}
#declare _Leaf2B1_2B1_1B5_Ref = object {
  _Leaf2B1_2B1_1B5
  rotate <0.0, 57.986469, 20.28977>
  translate  <8.75767, 1.25532, 14.69867>
}
#declare _Leaf2B1_2B1_1B6_Ref = object {
  _Leaf2B1_2B1_1B6
  rotate <0.0, 167.513626, 334.412781>
  translate  <8.79132, 1.31517, 14.6105>
}
#declare _Leaf2B1_2B1_1B7_Ref = object {
  _Leaf2B1_2B1_1B7
  rotate <0.0, 117.917587, 51.65522>
  translate  <9.07399, 1.67242, 14.40157>
}
#declare _Leaf2B1_2B2_1B1_Ref = object {
  _Leaf2B1_2B2_1B1
  rotate <0.0, 78.088661, 213.052261>
  translate  <7.65694, -0.46001, 16.07805>
}
#declare _Leaf2B1_2B2_1B2_Ref = object {
  _Leaf2B1_2B2_1B2
  rotate <0.0, 102.397133, 318.5>
  translate  <7.75048, -0.53002, 16.13514>
}
#declare _Leaf2B1_2B2_1B3_Ref = object {
  _Leaf2B1_2B2_1B3
  rotate <0.0, 24.17205, 76.385803>
  translate  <7.73858, -0.537, 16.26269>
}
#declare _Leaf2B1_2B2_1B4_Ref = object {
  _Leaf2B1_2B2_1B4
  rotate <0.0, 83.974007, 215.430359>
  translate  <7.81516, -1.15365, 16.91718>
}
#declare _Leaf2B1_2B2_1B5_Ref = object {
  _Leaf2B1_2B2_1B5
  rotate <0.0, 78.035049, 346.776093>
  translate  <7.88552, -1.19836, 16.99932>
}
#declare _Leaf2B1_2B2_1B6_Ref = object {
  _Leaf2B1_2B2_1B6
  rotate <0.0, 35.07085, 172.164322>
  translate  <7.84991, -1.25828, 17.08667>
}
#declare _Leaf2B1_2B2_1B7_Ref = object {
  _Leaf2B1_2B2_1B7
  rotate <0.0, 42.356659, 277.97644>
  translate  <7.92136, -1.6013, 17.44503>
}
#declare _Leaf2B1_2B3_1B1_Ref = object {
  _Leaf2B1_2B3_1B1
  rotate <0.0, 77.482048, 153.825073>
  translate  <7.79021, 0.46818, 16.15718>
}
#declare _Leaf2B1_2B3_1B2_Ref = object {
  _Leaf2B1_2B3_1B2
  rotate <0.0, 34.065208, 304.857513>
  translate  <7.8592, 0.49014, 16.26521>
}
#declare _Leaf2B1_2B3_1B3_Ref = object {
  _Leaf2B1_2B3_1B3
  rotate <0.0, 100.352219, 59.993118>
  translate  <7.88055, 0.6146, 16.28789>
}
#declare _Leaf2B1_2B3_1B4_Ref = object {
  _Leaf2B1_2B3_1B4
  rotate <0.0, 75.93203, 160.138504>
  translate  <7.8761, 1.18603, 16.98641>
}
#declare _Leaf2B1_2B3_1B5_Ref = object {
  _Leaf2B1_2B3_1B5
  rotate <0.0, 53.70063, 352.090851>
  translate  <7.94183, 1.24006, 17.06677>
}
#declare _Leaf2B1_2B3_1B6_Ref = object {
  _Leaf2B1_2B3_1B6
  rotate <0.0, 98.627419, 104.296509>
  translate  <7.91021, 1.33161, 17.12252>
}
#declare _Leaf2B1_2B3_1B7_Ref = object {
  _Leaf2B1_2B3_1B7
  rotate <0.0, 40.11401, 88.858566>
  translate  <7.93141, 1.63502, 17.52086>
}
#declare _Leaf2B1_2B4_1B1_Ref = object {
  _Leaf2B1_2B4_1B1
  rotate <0.0, 140.917816, 225.269363>
  translate  <8.17204, -0.4751, 15.28248>
}
#declare _Leaf2B1_2B4_1B2_Ref = object {
  _Leaf2B1_2B4_1B2
  rotate <0.0, 110.252472, 28.92625>
  translate  <8.29797, -0.49736, 15.25886>
}
#declare _Leaf2B1_2B4_1B3_Ref = object {
  _Leaf2B1_2B4_1B3
  rotate <0.0, 60.077011, 283.94162>
  translate  <8.32933, -0.62174, 15.26142>
}
#declare _Leaf2B1_2B4_1B4_Ref = object {
  _Leaf2B1_2B4_1B4
  rotate <0.0, 145.361511, 217.723785>
  translate  <8.83481, -1.20241, 14.79047>
}
#declare _Leaf2B1_2B4_1B5_Ref = object {
  _Leaf2B1_2B4_1B5
  rotate <0.0, 80.157791, 6.77079>
  translate  <8.93844, -1.25643, 14.78417>
}
#declare _Leaf2B1_2B4_1B6_Ref = object {
  _Leaf2B1_2B4_1B6
  rotate <0.0, 93.099533, 254.005417>
  translate  <8.95738, -1.34922, 14.72484>
}
#declare _Leaf2B1_2B4_1B7_Ref = object {
  _Leaf2B1_2B4_1B7
  rotate <0.0, 120.155983, 310.853943>
  translate  <9.26191, -1.65751, 14.47304>
}
#declare _Leaf2B1_2B5_1B1_Ref = object {
  _Leaf2B1_2B5_1B1
  rotate 134.0*y
  translate  <9.27335, 0.0, 16.24346>
}
#declare _Leaf2B1_2B5_1B2_Ref = object {
  _Leaf2B1_2B5_1B2
  rotate <0.0, 55.51894, 80.838341>
  translate  <9.33711, 0.04088, 16.34918>
}
#declare _Leaf2B1_2B5_1B3_Ref = object {
  _Leaf2B1_2B5_1B3
  rotate <0.0, 62.748001, 289.641815>
  translate  <9.42947, -0.03949, 16.38752>
}
#declare _Leaf2B1_2B5_1B4_Ref = object {
  _Leaf2B1_2B5_1B4
  rotate <0.0, 136.603378, 8.21956>
  translate  <10.27902, 0.0, 16.68947>
}
#declare _Leaf2B1_2B5_1B5_Ref = object {
  _Leaf2B1_2B5_1B5
  rotate <0.0, 18.363159, 79.713669>
  translate  <10.34732, 0.0, 16.78451>
}
#declare _Leaf2B1_2B5_1B6_Ref = object {
  _Leaf2B1_2B5_1B6
  rotate <0.0, 101.725601, 310.005341>
  translate  <10.4564, -0.02425, 16.78345>
}
#declare _Leaf2B1_2B5_1B7_Ref = object {
  _Leaf2B1_2B5_1B7
  rotate <0.0, 69.605972, 1.59979>
  translate  <10.91795, 0.01, 16.97576>
}
#declare _Leaf2B1_1B1_1B1_Ref = object {
  _Leaf2B1_1B1_1B1
  rotate <0.0, 157.863953, 172.654526>
  translate  <2.63565, 0.00255, 12.48485>
}
#declare _Leaf2B1_1B1_1B2_Ref = object {
  _Leaf2B1_1B1_1B2
  rotate <0.0, 83.105141, 52.545212>
  translate  <2.759, 0.03959, 12.46678>
}
#declare _Leaf2B1_1B1_1B3_Ref = object {
  _Leaf2B1_1B1_1B3
  rotate <0.0, 97.863579, 300.665192>
  translate  <2.82617, -0.04063, 12.39253>
}
#declare _Leaf2B1_1B1_1B4_Ref = object {
  _Leaf2B1_1B1_1B4
  rotate <0.0, 153.912964, 160.47049>
  translate  <3.4259, 0.00163, 11.71946>
}
#declare _Leaf2B1_1B1_1B5_Ref = object {
  _Leaf2B1_1B1_1B5
  rotate <0.0, 71.698471, 16.20627>
  translate  <3.53954, -0.00155, 11.69168>
}
#declare _Leaf2B1_1B1_1B6_Ref = object {
  _Leaf2B1_1B1_1B6
  rotate <0.0, 133.399033, 271.579803>
  translate  <3.57857, -0.02348, 11.58929>
}
#declare _Leaf2B1_1B1_1B7_Ref = object {
  _Leaf2B1_1B1_1B7
  rotate <0.0, 137.491287, 2.41771>
  translate  <3.93105, 0.01089, 11.23466>
}
#declare _Leaf2B1_1B2_1B1_Ref = object {
  _Leaf2B1_1B2_1B1
  rotate <0.0, 64.004211, 176.927567>
  translate  <2.16311, 0.00255, 13.71587>
}
#declare _Leaf2B1_1B2_1B2_Ref = object {
  _Leaf2B1_1B2_1B2
  rotate <0.0, 71.38398, 297.9328>
  translate  <2.23841, -0.04206, 13.81207>
}
#declare _Leaf2B1_1B2_1B3_Ref = object {
  _Leaf2B1_1B2_1B3
  rotate <0.0, 64.205299, 65.636009>
  translate  <2.24704, 0.03824, 13.91175>
}
#declare _Leaf2B1_1B2_1B4_Ref = object {
  _Leaf2B1_1B2_1B4
  rotate <0.0, 67.004204, 183.0625>
  translate  <2.23823, 0.00163, 14.81345>
}
#declare _Leaf2B1_1B2_1B5_Ref = object {
  _Leaf2B1_1B2_1B5
  rotate <0.0, 67.7668, 337.507294>
  translate  <2.3041, -0.00155, 14.91013>
}
#declare _Leaf2B1_1B2_1B6_Ref = object {
  _Leaf2B1_1B2_1B6
  rotate <0.0, 58.675018, 115.403732>
  translate  <2.26712, 0.02495, 15.01221>
}
#declare _Leaf2B1_1B2_1B7_Ref = object {
  _Leaf2B1_1B2_1B7
  rotate <0.0, 1.40007, 283.482178>
  translate  <2.28818, -0.00908, 15.51179>
}
#declare _Leaf2B1_1B3_1B1_Ref = object {
  _Leaf2B1_1B3_1B1
  rotate <0.0, 104.127243, 131.093903>
  translate  <2.57301, 0.6593, 13.20263>
}
#declare _Leaf2B1_1B3_1B2_Ref = object {
  _Leaf2B1_1B3_1B2
  rotate <0.0, 13.91837, 25.693069>
  translate  <2.65586, 0.72038, 13.28212>
}
#declare _Leaf2B1_1B3_1B3_Ref = object {
  _Leaf2B1_1B3_1B3
  rotate <0.0, 126.414787, 22.56345>
  translate  <2.72248, 0.81377, 13.22468>
}
#declare _Leaf2B1_1B3_1B4_Ref = object {
  _Leaf2B1_1B3_1B4
  rotate <0.0, 99.573463, 135.597275>
  translate  <2.99344, 1.65705, 13.39767>
}
#declare _Leaf2B1_1B3_1B5_Ref = object {
  _Leaf2B1_1B3_1B5
  rotate <0.0, 49.65287, 2.52377>
  translate  <3.08192, 1.72371, 13.43542>
}
#declare _Leaf2B1_1B3_1B6_Ref = object {
  _Leaf2B1_1B3_1B6
  rotate <0.0, 138.974426, 81.17128>
  translate  <3.09096, 1.83329, 13.41543>
}
#declare _Leaf2B1_1B3_1B7_Ref = object {
  _Leaf2B1_1B3_1B7
  rotate <0.0, 79.598419, 71.029694>
  translate  <3.25948, 2.29069, 13.53194>
}
#declare _Leaf2B1_1B4_1B1_Ref = object {
  _Leaf2B1_1B4_1B1
  rotate <0.0, 101.942528, 232.491486>
  translate  <2.61385, -0.64092, 13.22261>
}
#declare _Leaf2B1_1B4_1B2_Ref = object {
  _Leaf2B1_1B4_1B2
  rotate <0.0, 122.948578, 352.564575>
  translate  <2.73128, -0.69664, 13.22681>
}
#declare _Leaf2B1_1B4_1B3_Ref = object {
  _Leaf2B1_1B4_1B3
  rotate <0.0, 15.63073, 301.099365>
  translate  <2.74377, -0.78268, 13.32115>
}
#declare _Leaf2B1_1B4_1B4_Ref = object {
  _Leaf2B1_1B4_1B4
  rotate <0.0, 108.197617, 231.442886>
  translate  <3.09645, -1.60392, 13.4463>
}
#declare _Leaf2B1_1B4_1B5_Ref = object {
  _Leaf2B1_1B4_1B5
  rotate <0.0, 86.634216, 0.89257>
  translate  <3.18932, -1.66374, 13.48493>
}
#declare _Leaf2B1_1B4_1B6_Ref = object {
  _Leaf2B1_1B4_1B6
  rotate <0.0, 48.471588, 235.872147>
  translate  <3.18691, -1.77166, 13.51385>
}
#declare _Leaf2B1_1B4_1B7_Ref = object {
  _Leaf2B1_1B4_1B7
  rotate <0.0, 80.805313, 293.710999>
  translate  <3.40944, -2.21581, 13.58017>
}
#declare _Leaf2B1_1B5_1B1_Ref = object {
  _Leaf2B1_1B5_1B1
  rotate <0.0, 141.516876, 123.52243>
  translate  <4.4299, 0.45548, 13.56048>
}
#declare _Leaf2B1_1B5_1B2_Ref = object {
  _Leaf2B1_1B5_1B2
  rotate <0.0, 45.85181, 67.010399>
  translate  <4.53236, 0.52638, 13.59771>
}
#declare _Leaf2B1_1B5_1B3_Ref = object {
  _Leaf2B1_1B5_1B3
  rotate <0.0, 118.604462, 332.50824>
  translate  <4.62549, 0.53193, 13.50964>
}
#declare _Leaf2B1_1B5_1B4_Ref = object {
  _Leaf2B1_1B5_1B4
  rotate <0.0, 135.510742, 126.577217>
  translate  <5.18703, 1.14331, 13.15555>
}
#declare _Leaf2B1_1B5_1B5_Ref = object {
  _Leaf2B1_1B5_1B5
  rotate <0.0, 51.811401, 17.517429>
  translate  <5.29499, 1.1883, 13.15956>
}
#declare _Leaf2B1_1B5_1B6_Ref = object {
  _Leaf2B1_1B5_1B6
  rotate <0.0, 161.988235, 342.077118>
  translate  <5.34175, 1.24681, 13.07662>
}
#declare _Leaf2B1_1B5_1B7_Ref = object {
  _Leaf2B1_1B5_1B7
  rotate <0.0, 113.186287, 46.012829>
  translate  <5.66738, 1.5874, 12.90589>
}
#declare _Leaf2B1_1B6_1B1_Ref = object {
  _Leaf2B1_1B6_1B1
  rotate <0.0, 77.484299, 212.341858>
  translate  <4.03146, -0.4594, 14.38812>
}
#declare _Leaf2B1_1B6_1B2_Ref = object {
  _Leaf2B1_1B6_1B2
  rotate <0.0, 102.783859, 317.622467>
  translate  <4.12469, -0.53053, 14.44434>
}
#declare _Leaf2B1_1B6_1B3_Ref = object {
  _Leaf2B1_1B6_1B3
  rotate <0.0, 24.45722, 74.335541>
  translate  <4.11412, -0.53707, 14.57203>
}
#declare _Leaf2B1_1B6_1B4_Ref = object {
  _Leaf2B1_1B6_1B4
  rotate <0.0, 83.379883, 214.697876>
  translate  <4.18977, -1.15326, 15.22705>
}
#declare _Leaf2B1_1B6_1B5_Ref = object {
  _Leaf2B1_1B6_1B5
  rotate <0.0, 78.62262, 346.071472>
  translate  <4.26044, -1.19872, 15.30851>
}
#declare _Leaf2B1_1B6_1B6_Ref = object {
  _Leaf2B1_1B6_1B6
  rotate <0.0, 34.460831, 171.086243>
  translate  <4.22501, -1.25798, 15.39639>
}
#declare _Leaf2B1_1B6_1B7_Ref = object {
  _Leaf2B1_1B6_1B7
  rotate <0.0, 42.317101, 277.925537>
  translate  <4.29588, -1.60114, 15.75473>
}
#declare _Leaf2B1_1B7_1B1_Ref = object {
  _Leaf2B1_1B7_1B1
  rotate <0.0, 82.647141, 150.905975>
  translate  <4.14288, 0.47693, 14.45809>
}
#declare _Leaf2B1_1B7_1B2_Ref = object {
  _Leaf2B1_1B7_1B2
  rotate <0.0, 30.622881, 294.959442>
  translate  <4.20264, 0.49696, 14.57184>
}
#declare _Leaf2B1_1B7_1B3_Ref = object {
  _Leaf2B1_1B7_1B3
  rotate <0.0, 98.240318, 55.950569>
  translate  <4.22881, 0.62043, 14.59487>
}
#declare _Leaf2B1_1B7_1B4_Ref = object {
  _Leaf2B1_1B7_1B4
  rotate <0.0, 81.254021, 157.149078>
  translate  <4.19175, 1.20358, 15.28265>
}
#declare _Leaf2B1_1B7_1B5_Ref = object {
  _Leaf2B1_1B7_1B5
  rotate <0.0, 48.257179, 348.845978>
  translate  <4.25266, 1.25532, 15.36814>
}
#declare _Leaf2B1_1B7_1B6_Ref = object {
  _Leaf2B1_1B7_1B6
  rotate <0.0, 100.621429, 100.216263>
  translate  <4.22123, 1.34946, 15.41952>
}
#declare _Leaf2B1_1B7_1B7_Ref = object {
  _Leaf2B1_1B7_1B7
  rotate <0.0, 41.024132, 91.91478>
  translate  <4.22241, 1.65828, 15.81425>
}
#declare _Leaf2B1_1B8_1B1_Ref = object {
  _Leaf2B1_1B8_1B1
  rotate <0.0, 137.190964, 231.416656>
  translate  <4.57396, -0.47031, 13.6166>
}
#declare _Leaf2B1_1B8_1B2_Ref = object {
  _Leaf2B1_1B8_1B2
  rotate <0.0, 113.260612, 31.934389>
  translate  <4.70073, -0.48513, 13.59168>
}
#declare _Leaf2B1_1B8_1B3_Ref = object {
  _Leaf2B1_1B8_1B3
  rotate <0.0, 56.632488, 289.461945>
  translate  <4.74108, -0.60647, 13.60197>
}
#declare _Leaf2B1_1B8_1B4_Ref = object {
  _Leaf2B1_1B8_1B4
  rotate <0.0, 141.877319, 224.833832>
  translate  <5.27888, -1.181, 13.1602>
}
#declare _Leaf2B1_1B8_1B5_Ref = object {
  _Leaf2B1_1B8_1B5
  rotate <0.0, 81.939377, 11.48581>
  translate  <5.38603, -1.2278, 13.15521>
}
#declare _Leaf2B1_1B8_1B6_Ref = object {
  _Leaf2B1_1B8_1B6
  rotate <0.0, 88.987541, 258.132294>
  translate  <5.4106, -1.3229, 13.10192>
}
#declare _Leaf2B1_1B8_1B7_Ref = object {
  _Leaf2B1_1B8_1B7
  rotate <0.0, 118.001381, 313.032532>
  translate  <5.73216, -1.62548, 12.86478>
}
#declare _Leaf2B1_1B9_1B1_Ref = object {
  _Leaf2B1_1B9_1B1
  rotate <0.0, 158.0, 180.0>
  translate  <6.26084, 0.0, 14.17528>
}
#declare _Leaf2B1_1B9_1B2_Ref = object {
  _Leaf2B1_1B9_1B2
  rotate <0.0, 84.81414, 54.799759>
  translate  <6.38274, 0.04088, 14.15576>
}
#declare _Leaf2B1_1B9_1B3_Ref = object {
  _Leaf2B1_1B9_1B3
  rotate <0.0, 96.057961, 302.650818>
  translate  <6.45289, -0.03949, 14.08448>
}
#declare _Leaf2B1_1B9_1B4_Ref = object {
  _Leaf2B1_1B9_1B4
  rotate <0.0, 154.510986, 166.805939>
  translate  <7.0511, 0.0, 13.4099>
}
#declare _Leaf2B1_1B9_1B5_Ref = object {
  _Leaf2B1_1B9_1B5
  rotate <0.0, 72.339767, 18.98414>
  translate  <7.1648, 0.0, 13.38218>
}
#declare _Leaf2B1_1B9_1B6_Ref = object {
  _Leaf2B1_1B9_1B6
  rotate <0.0, 131.280014, 273.6138>
  translate  <7.20468, -0.02425, 13.28064>
}
#declare _Leaf2B1_1B9_1B7_Ref = object {
  _Leaf2B1_1B9_1B7
  rotate <0.0, 137.577194, 2.22309>
  translate  <7.55589, 0.01, 12.92474>
}
#declare _Leaf2B1_1B10_1B1_Ref = object {
  _Leaf2B1_1B10_1B1
  rotate <0.0, 72.0, 180.0>
  translate  <5.69075, 0.0, 15.39784>
}
#declare _Leaf2B1_1B10_1B2_Ref = object {
  _Leaf2B1_1B10_1B2
  rotate <0.0, 67.562927, 298.303528>
  translate  <5.75416, -0.04088, 15.50377>
}
#declare _Leaf2B1_1B10_1B3_Ref = object {
  _Leaf2B1_1B10_1B3
  rotate <0.0, 61.391441, 72.49852>
  translate  <5.74464, 0.03949, 15.60332>
}
#declare _Leaf2B1_1B10_1B4_Ref = object {
  _Leaf2B1_1B10_1B4
  rotate <0.0, 74.973389, 185.837204>
  translate  <5.61241, 0.0, 16.49519>
}
#declare _Leaf2B1_1B10_1B5_Ref = object {
  _Leaf2B1_1B10_1B5
  rotate <0.0, 60.314659, 339.096008>
  translate  <5.66426, 0.0, 16.60011>
}
#declare _Leaf2B1_1B10_1B6_Ref = object {
  _Leaf2B1_1B10_1B6
  rotate <0.0, 62.589802, 122.34433>
  translate  <5.61211, 0.02425, 16.69593>
}
#declare _Leaf2B1_1B10_1B7_Ref = object {
  _Leaf2B1_1B10_1B7
  rotate <0.0, 7.74436, 191.19751>
  translate  <5.56523, -0.01, 17.19373>
}
#declare _Leaf2B1_1B11_1B1_Ref = object {
  _Leaf2B1_1B11_1B1
  rotate <0.0, 103.806389, 130.119171>
  translate  <6.20864, 0.65501, 14.89795>
}
#declare _Leaf2B1_1B11_1B2_Ref = object {
  _Leaf2B1_1B11_1B2
  rotate <0.0, 13.74338, 23.224171>
  translate  <6.29244, 0.71418, 14.97789>
}
#declare _Leaf2B1_1B11_1B3_Ref = object {
  _Leaf2B1_1B11_1B3
  rotate <0.0, 126.254738, 21.94482>
  translate  <6.36053, 0.80693, 14.92113>
}
#declare _Leaf2B1_1B11_1B4_Ref = object {
  _Leaf2B1_1B11_1B4
  rotate <0.0, 99.275253, 134.641266>
  translate  <6.64479, 1.64452, 15.10032>
}
#declare _Leaf2B1_1B11_1B5_Ref = object {
  _Leaf2B1_1B11_1B5
  rotate <0.0, 49.638931, 1.25856>
  translate  <6.73431, 1.70949, 15.13855>
}
#declare _Leaf2B1_1B11_1B6_Ref = object {
  _Leaf2B1_1B11_1B6
  rotate <0.0, 138.557297, 80.342422>
  translate  <6.74507, 1.81906, 15.11937>
}
#declare _Leaf2B1_1B11_1B7_Ref = object {
  _Leaf2B1_1B11_1B7
  rotate <0.0, 79.19989, 70.097061>
  translate  <6.92081, 2.27286, 15.23924>
}
#declare _Leaf2B1_1B12_1B1_Ref = object {
  _Leaf2B1_1B12_1B1
  rotate <0.0, 101.482819, 228.090286>
  translate  <6.19733, -0.65922, 14.89549>
}
#declare _Leaf2B1_1B12_1B2_Ref = object {
  _Leaf2B1_1B12_1B2
  rotate <0.0, 124.86657, 348.968903>
  translate  <6.31065, -0.72303, 14.89513>
}
#declare _Leaf2B1_1B12_1B3_Ref = object {
  _Leaf2B1_1B12_1B3
  rotate <0.0, 17.323629, 300.761749>
  translate  <6.32, -0.81129, 14.98777>
}
#declare _Leaf2B1_1B12_1B4_Ref = object {
  _Leaf2B1_1B12_1B4
  rotate <0.0, 107.69838, 226.816849>
  translate  <6.61809, -1.657, 15.08967>
}
#declare _Leaf2B1_1B12_1B5_Ref = object {
  _Leaf2B1_1B12_1B5
  rotate <0.0, 88.449059, 356.859772>
  translate  <6.70771, -1.72376, 15.12444>
}
#declare _Leaf2B1_1B12_1B6_Ref = object {
  _Leaf2B1_1B12_1B6
  rotate <0.0, 48.16552, 233.643738>
  translate  <6.69865, -1.83172, 15.15185>
}
#declare _Leaf2B1_1B12_1B7_Ref = object {
  _Leaf2B1_1B12_1B7
  rotate <0.0, 82.304573, 289.913544>
  translate  <6.89151, -2.2913, 15.20459>
}
#declare _Leaf2B2_2B1_1B1_Ref = object {
  _Leaf2B2_2B1_1B1
  rotate <0.0, 136.275635, 192.839386>
  translate  <3.55549, 7.16075, 15.22277>
}
#declare _Leaf2B2_2B1_1B2_Ref = object {
  _Leaf2B2_2B1_1B2
  rotate <0.0, 46.63195, 125.970772>
  translate  <3.53696, 7.28622, 15.25153>
}
#declare _Leaf2B2_2B1_1B3_Ref = object {
  _Leaf2B2_2B1_1B3
  rotate <0.0, 124.944267, 36.971081>
  translate  <3.56398, 7.36554, 15.15439>
}
#declare _Leaf2B2_2B1_1B4_Ref = object {
  _Leaf2B2_2B1_1B4
  rotate <0.0, 130.112259, 194.86026>
  translate  <3.2174, 8.10254, 14.76555>
}
#declare _Leaf2B2_2B1_1B5_Ref = object {
  _Leaf2B2_2B1_1B5
  rotate <0.0, 57.051369, 79.93219>
  translate  <3.22204, 8.21934, 14.75978>
}
#declare _Leaf2B2_2B1_1B6_Ref = object {
  _Leaf2B2_2B1_1B6
  rotate <0.0, 168.399948, 47.761478>
  translate  <3.18216, 8.27963, 14.67455>
}
#declare _Leaf2B2_2B1_1B7_Ref = object {
  _Leaf2B2_2B1_1B7
  rotate <0.0, 115.754417, 113.75692>
  translate  <2.99649, 8.7039, 14.48295>
}
#declare _Leaf2B2_2B2_1B1_Ref = object {
  _Leaf2B2_2B2_1B1
  rotate <0.0, 79.605637, 274.765289>
  translate  <4.25237, 6.39842, 16.05566>
}
#declare _Leaf2B2_2B2_1B2_Ref = object {
  _Leaf2B2_2B2_1B2
  rotate <0.0, 104.167511, 20.255341>
  translate  <4.36103, 6.4455, 16.10941>
}
#declare _Leaf2B2_2B2_1B3_Ref = object {
  _Leaf2B2_2B2_1B3
  rotate <0.0, 21.5308, 136.120422>
  translate  <4.36669, 6.42875, 16.23648>
}
#declare _Leaf2B2_2B2_1B4_Ref = object {
  _Leaf2B2_2B2_1B4
  rotate <0.0, 85.578644, 276.89917>
  translate  <4.97068, 6.18458, 16.86102>
}
#declare _Leaf2B2_2B2_1B5_Ref = object {
  _Leaf2B2_2B2_1B5
  rotate <0.0, 78.640457, 47.496971>
  translate  <5.04706, 6.2229, 16.94099>
}
#declare _Leaf2B2_2B2_1B6_Ref = object {
  _Leaf2B2_2B2_1B6
  rotate <0.0, 34.821232, 237.308212>
  translate  <5.08604, 6.16087, 17.02538>
}
#declare _Leaf2B2_2B2_1B7_Ref = object {
  _Leaf2B2_2B2_1B7
  rotate <0.0, 45.046371, 338.828705>
  translate  <5.43565, 6.05049, 17.3671>
}
#declare _Leaf2B2_2B3_1B1_Ref = object {
  _Leaf2B2_2B3_1B1
  rotate <0.0, 76.321861, 215.665405>
  translate  <3.50671, 6.95912, 16.17879>
}
#declare _Leaf2B2_2B3_1B2_Ref = object {
  _Leaf2B2_2B3_1B2
  rotate <0.0, 36.309071, 3.94638>
  translate  <3.5251, 7.02765, 16.28778>
}
#declare _Leaf2B2_2B3_1B3_Ref = object {
  _Leaf2B2_2B3_1B3
  rotate <0.0, 97.98027, 121.475723>
  translate  <3.42729, 7.1056, 16.31635>
}
#declare _Leaf2B2_2B3_1B4_Ref = object {
  _Leaf2B2_2B3_1B4
  rotate <0.0, 75.051422, 222.072372>
  translate  <2.95352, 7.35983, 17.04119>
}
#declare _Leaf2B2_2B3_1B5_Ref = object {
  _Leaf2B2_2B3_1B5
  rotate <0.0, 54.091202, 51.396091>
  translate  <2.94111, 7.44154, 17.12405>
}
#declare _Leaf2B2_2B3_1B6_Ref = object {
  _Leaf2B2_2B3_1B6
  rotate <0.0, 95.999771, 165.474945>
  translate  <2.84803, 7.45647, 17.18406>
}
#declare _Leaf2B2_2B3_1B7_Ref = object {
  _Leaf2B2_2B3_1B7
  rotate <0.0, 37.395248, 150.095749>
  translate  <2.60893, 7.61148, 17.59636>
}
#declare _Leaf2B2_2B4_1B1_Ref = object {
  _Leaf2B2_2B4_1B1
  rotate <0.0, 142.82991, 284.073212>
  translate  <4.48033, 6.86136, 15.26054>
}
#declare _Leaf2B2_2B4_1B2_Ref = object {
  _Leaf2B2_2B4_1B2
  rotate <0.0, 108.893669, 91.031883>
  translate  <4.55939, 6.96165, 15.23596>
}
#declare _Leaf2B2_2B4_1B3_Ref = object {
  _Leaf2B2_2B4_1B3
  rotate <0.0, 62.710609, 344.841125>
  translate  <4.68351, 6.92936, 15.23263>
}
#declare _Leaf2B2_2B4_1B4_Ref = object {
  _Leaf2B2_2B4_1B4
  rotate <0.0, 146.988419, 275.738922>
  translate  <5.41564, 7.10474, 14.73494>
}
#declare _Leaf2B2_2B4_1B5_Ref = object {
  _Leaf2B2_2B4_1B5
  rotate <0.0, 79.818527, 67.562553>
  translate  <5.51251, 7.16982, 14.72613>
}
#declare _Leaf2B2_2B4_1B6_Ref = object {
  _Leaf2B2_2B4_1B6
  rotate <0.0, 95.720963, 315.217865>
  translate  <5.60044, 7.14325, 14.66248>
}
#declare _Leaf2B2_2B4_1B7_Ref = object {
  _Leaf2B2_2B4_1B7
  rotate <0.0, 122.175522, 13.22338>
  translate  <6.00646, 7.26811, 14.3965>
}
#declare _Leaf2B2_2B5_1B1_Ref = object {
  _Leaf2B2_2B5_1B1
  rotate <0.0, 133.907715, 63.88866>
  translate  <4.63333, 8.03283, 16.24356>
}
#declare _Leaf2B2_2B5_1B2_Ref = object {
  _Leaf2B2_2B5_1B2
  rotate <0.0, 52.831161, 141.810318>
  translate  <4.63255, 8.10591, 16.35113>
}
#declare _Leaf2B2_2B5_1B3_Ref = object {
  _Leaf2B2_2B5_1B3
  rotate <0.0, 65.302193, 350.45575>
  translate  <4.74893, 8.14742, 16.38566>
}
#declare _Leaf2B2_2B5_1B4_Ref = object {
  _Leaf2B2_2B5_1B4
  rotate <0.0, 136.119019, 72.294121>
  translate  <5.13522, 8.90431, 16.68959>
}
#declare _Leaf2B2_2B5_1B5_Ref = object {
  _Leaf2B2_2B5_1B5
  rotate <0.0, 15.68918, 139.369797>
  translate  <5.17198, 8.96198, 16.78456>
}
#declare _Leaf2B2_2B5_1B6_Ref = object {
  _Leaf2B2_2B5_1B6
  rotate <0.0, 103.782677, 11.67598>
  translate  <5.24562, 9.04602, 16.7824>
}
#declare _Leaf2B2_2B5_1B7_Ref = object {
  _Leaf2B2_2B5_1B7
  rotate <0.0, 69.523987, 61.85511>
  translate  <5.44545, 9.46271, 16.97636>
}
#declare _Leaf2B2_1B1_1B1_Ref = object {
  _Leaf2B2_1B1_1B1
  rotate <0.0, 157.392548, 227.411865>
  translate  <1.28483, 2.30108, 12.48581>
}
#declare _Leaf2B2_1B1_1B2_Ref = object {
  _Leaf2B2_1B1_1B2
  rotate <0.0, 80.931763, 113.584183>
  translate  <1.31094, 2.42744, 12.46958>
}
#declare _Leaf2B2_1B1_1B3_Ref = object {
  _Leaf2B2_1B1_1B3
  rotate <0.0, 100.184097, 2.15838>
  translate  <1.41042, 2.44955, 12.39164>
}
#declare _Leaf2B2_1B1_1B4_Ref = object {
  _Leaf2B2_1B1_1B4
  rotate <0.0, 152.918655, 216.678268>
  translate  <1.63388, 3.01139, 11.72165>
}
#declare _Leaf2B2_1B1_1B5_Ref = object {
  _Leaf2B2_1B1_1B5
  rotate <0.0, 70.93071, 76.592087>
  translate  <1.69015, 3.11016, 11.69381>
}
#declare _Leaf2B2_1B1_1B6_Ref = object {
  _Leaf2B2_1B1_1B6
  rotate <0.0, 136.115784, 332.954559>
  translate  <1.72389, 3.13623, 11.59051>
}
#declare _Leaf2B2_1B1_1B7_Ref = object {
  _Leaf2B2_1B1_1B7
  rotate <0.0, 137.276657, 66.632561>
  translate  <1.84856, 3.47006, 11.2381>
}
#declare _Leaf2B2_1B2_1B1_Ref = object {
  _Leaf2B2_1B2_1B1
  rotate <0.0, 63.919998, 239.523621>
  translate  <1.10855, 1.85808, 13.7152>
}
#declare _Leaf2B2_1B2_1B2_Ref = object {
  _Leaf2B2_1B2_1B2
  rotate <0.0, 73.77655, 358.795563>
  translate  <1.1878, 1.90045, 13.80921>
}
#declare _Leaf2B2_1B2_1B3_Ref = object {
  _Leaf2B2_1B2_1B3
  rotate <0.0, 61.721619, 126.339371>
  translate  <1.12574, 1.94426, 13.91259>
}
#declare _Leaf2B2_1B2_1B4_Ref = object {
  _Leaf2B2_1B2_1B4
  rotate <0.0, 67.206642, 245.47583>
  translate  <1.19085, 1.89798, 14.81153>
}
#declare _Leaf2B2_1B2_1B5_Ref = object {
  _Leaf2B2_1B2_1B5
  rotate <0.0, 68.801308, 37.77375>
  translate  <1.22929, 1.95196, 14.90799>
}
#declare _Leaf2B2_1B2_1B6_Ref = object {
  _Leaf2B2_1B2_1B6
  rotate <0.0, 56.240059, 177.444046>
  translate  <1.19253, 1.92988, 15.01119>
}
#declare _Leaf2B2_1B2_1B7_Ref = object {
  _Leaf2B2_1B2_1B7
  rotate <0.0, 4.09092, 335.425598>
  translate  <1.25311, 1.92039, 15.50861>
}
#declare _Leaf2B2_1B3_1B1_Ref = object {
  _Leaf2B2_1B3_1B1
  rotate <0.0, 102.091309, 191.942215>
  translate  <0.70914, 2.5448, 13.2339>
}
#declare _Leaf2B2_1B3_1B2_Ref = object {
  _Leaf2B2_1B3_1B2
  rotate <0.0, 12.9395, 76.313309>
  translate  <0.69876, 2.64492, 13.31624>
}
#declare _Leaf2B2_1B3_1B3_Ref = object {
  _Leaf2B2_1B3_1B3
  rotate <0.0, 125.304512, 85.625938>
  translate  <0.64661, 2.74952, 13.26333>
}
#declare _Leaf2B2_1B3_1B4_Ref = object {
  _Leaf2B2_1B3_1B4
  rotate <0.0, 97.687408, 196.568054>
  translate  <0.04539, 3.38801, 13.47626>
}
#declare _Leaf2B2_1B3_1B5_Ref = object {
  _Leaf2B2_1B3_1B5
  rotate <0.0, 49.55788, 61.479179>
  translate  <0.03109, 3.49672, 13.51718>
}
#declare _Leaf2B2_1B3_1B6_Ref = object {
  _Leaf2B2_1B3_1B6
  rotate <0.0, 136.281906, 142.853622>
  translate  <-0.06137, 3.55772, 13.50241>
}
#declare _Leaf2B2_1B3_1B7_Ref = object {
  _Leaf2B2_1B3_1B7
  rotate <0.0, 77.018883, 132.119934>
  translate  <-0.37617, 3.92241, 13.64058>
}
#declare _Leaf2B2_1B4_1B1_Ref = object {
  _Leaf2B2_1B4_1B1
  rotate <0.0, 104.112244, 293.380371>
  translate  <1.86846, 1.95583, 13.19221>
}
#declare _Leaf2B2_1B4_1B2_Ref = object {
  _Leaf2B2_1B4_1B2
  rotate <0.0, 123.229103, 55.595268>
  translate  <1.97389, 2.03194, 13.19381>
}
#declare _Leaf2B2_1B4_1B3_Ref = object {
  _Leaf2B2_1B4_1B3
  rotate <0.0, 17.99861, 357.932983>
  translate  <2.05916, 1.99939, 13.28398>
}
#declare _Leaf2B2_1B4_1B4_Ref = object {
  _Leaf2B2_1B4_1B4
  rotate <0.0, 110.333939, 292.122955>
  translate  <2.95319, 1.91141, 13.37022>
}
#declare _Leaf2B2_1B4_1B5_Ref = object {
  _Leaf2B2_1B4_1B5
  rotate <0.0, 86.565598, 61.999149>
  translate  <3.05183, 1.96323, 13.40602>
}
#declare _Leaf2B2_1B4_1B6_Ref = object {
  _Leaf2B2_1B4_1B6
  rotate <0.0, 50.755539, 298.395599>
  translate  <3.1464, 1.90862, 13.42978>
}
#declare _Leaf2B2_1B4_1B7_Ref = object {
  _Leaf2B2_1B4_1B7
  rotate <0.0, 83.284027, 354.822906>
  translate  <3.64514, 1.88894, 13.47508>
}
#declare _Leaf2B2_1B5_1B1_Ref = object {
  _Leaf2B2_1B5_1B1
  rotate <0.0, 139.242874, 182.989136>
  translate  <1.79511, 4.06686, 13.58265>
}
#declare _Leaf2B2_1B5_1B2_Ref = object {
  _Leaf2B2_1B5_1B2
  rotate <0.0, 43.346889, 127.20575>
  translate  <1.7838, 4.18989, 13.62325>
}
#declare _Leaf2B2_1B5_1B3_Ref = object {
  _Leaf2B2_1B5_1B3
  rotate <0.0, 119.804092, 35.140549>
  translate  <1.82007, 4.27626, 13.5356>
}
#declare _Leaf2B2_1B5_1B4_Ref = object {
  _Leaf2B2_1B5_1B4
  rotate <0.0, 133.322556, 186.263306>
  translate  <1.53987, 5.07045, 13.2112>
}
#declare _Leaf2B2_1B5_1B5_Ref = object {
  _Leaf2B2_1B5_1B5
  rotate <0.0, 51.011021, 76.71151>
  translate  <1.55253, 5.18663, 13.2174>
}
#declare _Leaf2B2_1B5_1B6_Ref = object {
  _Leaf2B2_1B5_1B6
  rotate <0.0, 162.607895, 51.649448>
  translate  <1.52033, 5.25766, 13.13735>
}
#declare _Leaf2B2_1B5_1B7_Ref = object {
  _Leaf2B2_1B5_1B7
  rotate <0.0, 111.196808, 108.037109>
  translate  <1.37149, 5.71071, 12.98314>
}
#declare _Leaf2B2_1B6_1B1_Ref = object {
  _Leaf2B2_1B6_1B1
  rotate <0.0, 78.97377, 274.084045>
  translate  <2.43913, 3.25894, 14.36576>
}
#declare _Leaf2B2_1B6_1B2_Ref = object {
  _Leaf2B2_1B6_1B2
  rotate <0.0, 104.585487, 19.38652>
  translate  <2.54858, 3.30523, 14.41859>
}
#declare _Leaf2B2_1B6_1B3_Ref = object {
  _Leaf2B2_1B6_1B3
  rotate <0.0, 21.842051, 133.860947>
  translate  <2.5545, 3.28985, 14.54582>
}
#declare _Leaf2B2_1B6_1B4_Ref = object {
  _Leaf2B2_1B6_1B4
  rotate <0.0, 84.95681, 276.19223>
  translate  <3.15766, 3.04507, 15.17092>
}
#declare _Leaf2B2_1B6_1B5_Ref = object {
  _Leaf2B2_1B6_1B5
  rotate <0.0, 79.25988, 46.82288>
  translate  <3.23482, 3.08332, 15.25017>
}
#declare _Leaf2B2_1B6_1B6_Ref = object {
  _Leaf2B2_1B6_1B6
  rotate <0.0, 34.1623, 236.315811>
  translate  <3.27333, 3.02176, 15.33512>
}
#declare _Leaf2B2_1B6_1B7_Ref = object {
  _Leaf2B2_1B6_1B7
  rotate <0.0, 45.00716, 338.779724>
  translate  <3.62278, 2.91079, 15.67681>
}
#declare _Leaf2B2_1B7_1B1_Ref = object {
  _Leaf2B2_1B7_1B1
  rotate <0.0, 81.358307, 212.510483>
  translate  <1.67546, 3.8046, 14.48012>
}
#declare _Leaf2B2_1B7_1B2_Ref = object {
  _Leaf2B2_1B7_1B2
  rotate <0.0, 33.093788, 354.400269>
  translate  <1.69134, 3.86397, 14.59472>
}
#declare _Leaf2B2_1B7_1B3_Ref = object {
  _Leaf2B2_1B7_1B3
  rotate <0.0, 95.968323, 117.404846>
  translate  <1.59673, 3.94567, 14.6236>
}
#declare _Leaf2B2_1B7_1B4_Ref = object {
  _Leaf2B2_1B7_1B4
  rotate <0.0, 80.23484, 218.828018>
  translate  <1.09656, 4.17718, 15.33824>
}
#declare _Leaf2B2_1B7_1B5_Ref = object {
  _Leaf2B2_1B7_1B5
  rotate <0.0, 48.80859, 47.760681>
  translate  <1.08406, 4.25344, 15.42612>
}
#declare _Leaf2B2_1B7_1B6_Ref = object {
  _Leaf2B2_1B7_1B6
  rotate <0.0, 97.950783, 161.40097>
  translate  <0.98862, 4.26989, 15.48189>
}
#declare _Leaf2B2_1B7_1B7_Ref = object {
  _Leaf2B2_1B7_1B7
  rotate <0.0, 38.308109, 153.333008>
  translate  <0.73501, 4.41003, 15.89083>
}
#declare _Leaf2B2_1B8_1B1_Ref = object {
  _Leaf2B2_1B8_1B1
  rotate <0.0, 139.307175, 290.77121>
  translate  <2.67758, 3.74735, 13.59488>
}
#declare _Leaf2B2_1B8_1B2_Ref = object {
  _Leaf2B2_1B8_1B2
  rotate <0.0, 111.777931, 94.147636>
  translate  <2.75047, 3.85198, 13.56935>
}
#declare _Leaf2B2_1B8_1B3_Ref = object {
  _Leaf2B2_1B8_1B3
  rotate <0.0, 59.190601, 350.152252>
  translate  <2.87658, 3.82885, 13.57389>
}
#declare _Leaf2B2_1B8_1B4_Ref = object {
  _Leaf2B2_1B8_1B4
  rotate <0.0, 143.772858, 283.530151>
  translate  <3.62007, 4.03485, 13.10564>
}
#declare _Leaf2B2_1B8_1B5_Ref = object {
  _Leaf2B2_1B8_1B5
  rotate <0.0, 81.37748, 72.363777>
  translate  <3.71237, 4.10645, 13.0985>
}
#declare _Leaf2B2_1B8_1B6_Ref = object {
  _Leaf2B2_1B8_1B6
  rotate <0.0, 91.654327, 319.3974>
  translate  <3.80528, 4.08357, 13.04077>
}
#declare _Leaf2B2_1B8_1B7_Ref = object {
  _Leaf2B2_1B8_1B7
  rotate <0.0, 119.951111, 15.35034>
  translate  <4.21508, 4.22577, 12.78972>
}
#declare _Leaf2B2_1B9_1B1_Ref = object {
  _Leaf2B2_1B9_1B1
  rotate <0.0, 157.870804, 234.562912>
  translate  <3.09965, 5.43936, 14.17611>
}
#declare _Leaf2B2_1B9_1B2_Ref = object {
  _Leaf2B2_1B9_1B2
  rotate <0.0, 82.5774, 115.897034>
  translate  <3.12165, 5.56633, 14.15862>
}
#declare _Leaf2B2_1B9_1B3_Ref = object {
  _Leaf2B2_1B9_1B3
  rotate <0.0, 98.328484, 4.10775>
  translate  <3.22281, 5.59091, 14.08365>
}
#declare _Leaf2B2_1B9_1B4_Ref = object {
  _Leaf2B2_1B9_1B4
  rotate <0.0, 153.794067, 222.656723>
  translate  <3.44791, 6.15012, 13.41202>
}
#declare _Leaf2B2_1B9_1B5_Ref = object {
  _Leaf2B2_1B9_1B5
  rotate <0.0, 71.445518, 79.412468>
  translate  <3.50142, 6.25047, 13.38439>
}
#declare _Leaf2B2_1B9_1B6_Ref = object {
  _Leaf2B2_1B9_1B6
  rotate <0.0, 133.991089, 335.071472>
  translate  <3.53764, 6.27616, 13.28183>
}
#declare _Leaf2B2_1B9_1B7_Ref = object {
  _Leaf2B2_1B9_1B7
  rotate <0.0, 137.371536, 66.448051>
  translate  <3.66176, 6.60884, 12.92814>
}
#declare _Leaf2B2_1B10_1B1_Ref = object {
  _Leaf2B2_1B10_1B1
  rotate <0.0, 72.051018, 242.150192>
  translate  <2.87614, 4.91102, 15.397>
}
#declare _Leaf2B2_1B10_1B2_Ref = object {
  _Leaf2B2_1B10_1B2
  rotate <0.0, 69.948273, 359.064178>
  translate  <2.9468, 4.94453, 15.50091>
}
#declare _Leaf2B2_1B10_1B3_Ref = object {
  _Leaf2B2_1B10_1B3
  rotate <0.0, 58.792671, 133.306747>
  translate  <2.87595, 4.97246, 15.60415>
}
#declare _Leaf2B2_1B10_1B4_Ref = object {
  _Leaf2B2_1B10_1B4
  rotate <0.0, 75.296768, 247.821976>
  translate  <2.88384, 4.8168, 16.49307>
}
#declare _Leaf2B2_1B10_1B5_Ref = object {
  _Leaf2B2_1B10_1B5
  rotate <0.0, 61.288342, 38.945099>
  translate  <2.91311, 4.85983, 16.5979>
}
#declare _Leaf2B2_1B10_1B6_Ref = object {
  _Leaf2B2_1B10_1B6
  rotate <0.0, 60.319389, 184.426437>
  translate  <2.87076, 4.82351, 16.69474>
}
#declare _Leaf2B2_1B10_1B7_Ref = object {
  _Leaf2B2_1B10_1B7
  rotate <0.0, 8.71542, 270.127716>
  translate  <2.8988, 4.75438, 17.19033>
}
#declare _Leaf2B2_1B11_1B1_Ref = object {
  _Leaf2B2_1B11_1B1
  rotate <0.0, 101.740402, 190.98645>
  translate  <2.53071, 5.69128, 14.92902>
}
#declare _Leaf2B2_1B11_1B2_Ref = object {
  _Leaf2B2_1B11_1B2
  rotate <0.0, 12.88124, 73.570374>
  translate  <2.52247, 5.79131, 15.01171>
}
#declare _Leaf2B2_1B11_1B3_Ref = object {
  _Leaf2B2_1B11_1B3
  rotate <0.0, 125.171356, 85.00618>
  translate  <2.47162, 5.89688, 14.95946>
}
#declare _Leaf2B2_1B11_1B4_Ref = object {
  _Leaf2B2_1B11_1B4
  rotate <0.0, 97.357048, 195.627625>
  translate  <1.88204, 6.54415, 15.17832>
}
#declare _Leaf2B2_1B11_1B5_Ref = object {
  _Leaf2B2_1B11_1B5
  rotate <0.0, 49.60397, 60.214069>
  translate  <1.86974, 6.65295, 15.21964>
}
#declare _Leaf2B2_1B11_1B6_Ref = object {
  _Leaf2B2_1B11_1B6
  rotate <0.0, 135.870392, 142.059937>
  translate  <1.77816, 6.71545, 15.20568>
}
#declare _Leaf2B2_1B11_1B7_Ref = object {
  _Leaf2B2_1B11_1B7
  rotate <0.0, 76.634789, 131.172134>
  translate  <1.47011, 7.08465, 15.34704>
}
#declare _Leaf2B2_1B12_1B1_Ref = object {
  _Leaf2B2_1B12_1B1
  rotate <0.0, 103.520088, 288.959045>
  translate  <3.67631, 5.05038, 14.86422>
}
#declare _Leaf2B2_1B12_1B2_Ref = object {
  _Leaf2B2_1B12_1B2
  rotate <0.0, 125.313339, 52.12162>
  translate  <3.78666, 5.11912, 14.86089>
}
#declare _Leaf2B2_1B12_1B3_Ref = object {
  _Leaf2B2_1B12_1B3
  rotate <0.0, 19.693859, 358.041107>
  translate  <3.87229, 5.08278, 14.94924>
}
#declare _Leaf2B2_1B12_1B4_Ref = object {
  _Leaf2B2_1B12_1B4
  rotate <0.0, 109.691498, 287.458984>
  translate  <4.76056, 4.93573, 15.01107>
}
#declare _Leaf2B2_1B12_1B5_Ref = object {
  _Leaf2B2_1B12_1B5
  rotate <0.0, 88.569641, 58.057171>
  translate  <4.86355, 4.98144, 15.04268>
}
#declare _Leaf2B2_1B12_1B6_Ref = object {
  _Leaf2B2_1B12_1B6
  rotate <0.0, 50.391609, 296.256165>
  translate  <4.95489, 4.92102, 15.06494>
}
#declare _Leaf2B2_1B12_1B7_Ref = object {
  _Leaf2B2_1B12_1B7
  rotate <0.0, 84.85141, 351.074463>
  translate  <5.45233, 4.86825, 15.09592>
}
#declare _Leaf2B3_2B1_1B1_Ref = object {
  _Leaf2B3_2B1_1B1
  rotate <0.0, 135.609924, 252.626419>
  translate  <-4.42854, 6.6524, 15.23076>
}
#declare _Leaf2B3_2B1_1B2_Ref = object {
  _Leaf2B3_2B1_1B2
  rotate <0.0, 45.803959, 186.040176>
  translate  <-4.5464, 6.69844, 15.26077>
}
#declare _Leaf2B3_2B1_1B3_Ref = object {
  _Leaf2B3_2B1_1B3
  rotate <0.0, 125.291451, 97.982491>
  translate  <-4.60338, 6.76032, 15.1639>
}
#declare _Leaf2B3_2B1_1B4_Ref = object {
  _Leaf2B3_2B1_1B4
  rotate <0.0, 129.469223, 254.750916>
  translate  <-5.42065, 6.81964, 14.78572>
}
#declare _Leaf2B3_2B1_1B5_Ref = object {
  _Leaf2B3_2B1_1B5
  rotate <0.0, 56.743382, 139.799088>
  translate  <-5.52001, 6.88128, 14.78081>
}
#declare _Leaf2B3_2B1_1B6_Ref = object {
  _Leaf2B3_2B1_1B6
  rotate <0.0, 168.554901, 112.565582>
  translate  <-5.59329, 6.87568, 14.69662>
}
#declare _Leaf2B3_2B1_1B7_Ref = object {
  _Leaf2B3_2B1_1B7
  rotate <0.0, 115.020317, 174.431793>
  translate  <-6.0565, 6.92212, 14.51096>
}
#declare _Leaf2B3_2B2_1B1_Ref = object {
  _Leaf2B3_2B2_1B1
  rotate <0.0, 80.126038, 335.320557>
  translate  <-3.41029, 6.88874, 16.04795>
}
#declare _Leaf2B3_2B2_1B2_Ref = object {
  _Leaf2B3_2B2_1B2
  rotate <0.0, 104.743301, 80.858398>
  translate  <-3.39687, 7.0069, 16.10059>
}
#declare _Leaf2B3_2B2_1B3_Ref = object {
  _Leaf2B3_2B2_1B3
  rotate <0.0, 20.65122, 195.976486>
  translate  <-3.37778, 7.00457, 16.22743>
}
#declare _Leaf2B3_2B2_1B4_Ref = object {
  _Leaf2B3_2B2_1B4
  rotate <0.0, 86.125801, 337.374176>
  translate  <-2.85883, 7.41426, 16.8417>
}
#declare _Leaf2B3_2B2_1B5_Ref = object {
  _Leaf2B3_2B2_1B5
  rotate <0.0, 78.83477, 107.743309>
  translate  <-2.85337, 7.50024, 16.92091>
}
#declare _Leaf2B3_2B2_1B6_Ref = object {
  _Leaf2B3_2B2_1B6
  rotate <0.0, 34.792309, 299.033905>
  translate  <-2.77904, 7.50419, 17.00427>
}
#declare _Leaf2B3_2B2_1B7_Ref = object {
  _Leaf2B3_2B2_1B7
  rotate <0.0, 45.941601, 39.112438>
  translate  <-2.50583, 7.75646, 17.34029>
}
#declare _Leaf2B3_2B3_1B1_Ref = object {
  _Leaf2B3_2B3_1B1
  rotate <0.0, 75.952919, 276.292328>
  translate  <-4.2642, 6.51805, 16.18572>
}
#declare _Leaf2B3_2B3_1B2_Ref = object {
  _Leaf2B3_2B3_1B2
  rotate <0.0, 37.06205, 63.691898>
  translate  <-4.31323, 6.56874, 16.29499>
}
#declare _Leaf2B3_2B3_1B3_Ref = object {
  _Leaf2B3_2B3_1B3
  rotate <0.0, 97.182159, 181.955505>
  translate  <-4.42889, 6.52239, 16.32552>
}
#declare _Leaf2B3_2B3_1B4_Ref = object {
  _Leaf2B3_2B3_1B4
  rotate <0.0, 74.777382, 282.727875>
  translate  <-4.87388, 6.24165, 17.05876>
}
#declare _Leaf2B3_2B3_1B5_Ref = object {
  _Leaf2B3_2B3_1B5
  rotate <0.0, 54.22855, 111.171654>
  translate  <-4.94993, 6.27184, 17.14244>
}
#declare _Leaf2B3_2B3_1B6_Ref = object {
  _Leaf2B3_2B3_1B6
  rotate <0.0, 95.127159, 225.873718>
  translate  <-5.00804, 6.19875, 17.20383>
}
#declare _Leaf2B3_2B3_1B7_Ref = object {
  _Leaf2B3_2B3_1B7
  rotate <0.0, 36.48896, 210.524902>
  translate  <-5.25519, 6.07062, 17.62058>
}
#declare _Leaf2B3_2B4_1B1_Ref = object {
  _Leaf2B3_2B4_1B1
  rotate <0.0, 143.457779, 343.623901>
  translate  <-3.71125, 7.30917, 15.2535>
}
#declare _Leaf2B3_2B4_1B2_Ref = object {
  _Leaf2B3_2B4_1B2
  rotate <0.0, 108.421822, 151.71579>
  translate  <-3.75978, 7.42724, 15.22864>
}
#declare _Leaf2B3_2B4_1B3_Ref = object {
  _Leaf2B3_2B4_1B3
  rotate <0.0, 63.58606, 45.145039>
  translate  <-3.6705, 7.51921, 15.22336>
}
#declare _Leaf2B3_2B4_1B4_Ref = object {
  _Leaf2B3_2B4_1B4
  rotate <0.0, 147.513153, 335.012604>
  translate  <-3.4685, 8.23851, 14.71711>
}
#declare _Leaf2B3_2B4_1B5_Ref = object {
  _Leaf2B3_2B4_1B5
  rotate <0.0, 79.697212, 127.822891>
  translate  <-3.47742, 8.35481, 14.7075>
}
#declare _Leaf2B3_2B4_1B6_Ref = object {
  _Leaf2B3_2B4_1B6
  rotate <0.0, 96.598068, 15.61585>
  translate  <-3.41179, 8.41766, 14.64245>
}
#declare _Leaf2B3_2B4_1B7_Ref = object {
  _Leaf2B3_2B4_1B7
  rotate <0.0, 122.83149, 74.044487>
  translate  <-3.32364, 8.83026, 14.37194>
}
#declare _Leaf2B3_2B5_1B1_Ref = object {
  _Leaf2B3_2B5_1B1
  rotate <0.0, 133.83606, 125.179878>
  translate  <-4.64106, 8.02833, 16.24363>
}
#declare _Leaf2B3_2B5_1B2_Ref = object {
  _Leaf2B3_2B5_1B2
  rotate <0.0, 51.933739, 202.135422>
  translate  <-4.70352, 8.06458, 16.35178>
}
#declare _Leaf2B3_2B5_1B3_Ref = object {
  _Leaf2B3_2B5_1B3
  rotate <0.0, 66.150574, 50.734589>
  translate  <-4.68172, 8.18656, 16.38504>
}
#declare _Leaf2B3_2B5_1B4_Ref = object {
  _Leaf2B3_2B5_1B4
  rotate <0.0, 135.91571, 133.631927>
  translate  <-5.14514, 8.89853, 16.68968>
}
#declare _Leaf2B3_2B5_1B5_Ref = object {
  _Leaf2B3_2B5_1B5
  rotate <0.0, 14.79871, 199.173309>
  translate  <-5.17586, 8.95973, 16.78459>
}
#declare _Leaf2B3_2B5_1B6_Ref = object {
  _Leaf2B3_2B5_1B6
  rotate <0.0, 104.456589, 72.251053>
  translate  <-5.21263, 9.06523, 16.7821>
}
#declare _Leaf2B3_2B5_1B7_Ref = object {
  _Leaf2B3_2B5_1B7
  rotate <0.0, 69.49398, 121.939217>
  translate  <-5.47373, 9.44624, 16.97662>
}
#declare _Leaf2B3_1B1_1B1_Ref = object {
  _Leaf2B3_1B1_1B1
  rotate <0.0, 157.182007, 285.728302>
  translate  <-1.36039, 2.25708, 12.4865>
}
#declare _Leaf2B3_1B1_1B2_Ref = object {
  _Leaf2B3_1B1_1B2
  rotate <0.0, 80.200859, 173.91777>
  translate  <-1.45762, 2.34203, 12.47092>
}
#declare _Leaf2B3_1B1_1B3_Ref = object {
  _Leaf2B3_1B1_1B3
  rotate <0.0, 100.949203, 62.671631>
  translate  <-1.42882, 2.43884, 12.39181>
}
#declare _Leaf2B3_1B1_1B4_Ref = object {
  _Leaf2B3_1B1_1B4
  rotate <0.0, 152.551224, 275.493225>
  translate  <-1.81629, 2.90518, 11.72332>
}
#declare _Leaf2B3_1B1_1B5_Ref = object {
  _Leaf2B3_1B1_1B5
  rotate <0.0, 70.67099, 136.712357>
  translate  <-1.87479, 3.00264, 11.6955>
}
#declare _Leaf2B3_1B1_1B6_Ref = object {
  _Leaf2B3_1B1_1B6
  rotate <0.0, 137.020676, 33.430511>
  translate  <-1.88222, 3.04403, 11.59196>
}
#declare _Leaf2B3_1B1_1B7_Ref = object {
  _Leaf2B3_1B1_1B7
  rotate <0.0, 137.161026, 128.026581>
  translate  <-2.11583, 3.31444, 11.24054>
}
#declare _Leaf2B3_1B2_1B1_Ref = object {
  _Leaf2B3_1B2_1B1
  rotate <0.0, 63.919319, 300.389862>
  translate  <-1.04533, 1.89489, 13.71462>
}
#declare _Leaf2B3_1B2_1B2_Ref = object {
  _Leaf2B3_1B2_1B2
  rotate <0.0, 74.569649, 59.093842>
  translate  <-1.04179, 1.98547, 13.80787>
}
#declare _Leaf2B3_1B2_1B3_Ref = object {
  _Leaf2B3_1B2_1B3
  rotate <0.0, 60.890781, 186.563797>
  translate  <-1.1091, 1.95395, 13.91244>
}
#declare _Leaf2B3_1B2_1B4_Ref = object {
  _Leaf2B3_1B2_1B4
  rotate <0.0, 67.299431, 306.276459>
  translate  <-1.02443, 1.99488, 14.81001>
}
#declare _Leaf2B3_1B2_1B5_Ref = object {
  _Leaf2B3_1B2_1B5
  rotate <0.0, 69.143402, 97.873741>
  translate  <-1.05108, 2.05573, 14.90636>
}
#declare _Leaf2B3_1B2_1B6_Ref = object {
  _Leaf2B3_1B2_1B6
  rotate <0.0, 55.438339, 238.153503>
  translate  <-1.04862, 2.01368, 15.00987>
}
#declare _Leaf2B3_1B2_1B7_Ref = object {
  _Leaf2B3_1B2_1B7
  rotate <0.0, 4.99364, 34.82869>
  translate  <-1.00367, 2.06564, 15.50632>
}
#declare _Leaf2B3_1B3_1B1_Ref = object {
  _Leaf2B3_1B3_1B1
  rotate <0.0, 101.418747, 252.238419>
  translate  <-1.84622, 1.8827, 13.24431>
}
#declare _Leaf2B3_1B3_1B2_Ref = object {
  _Leaf2B3_1B3_1B2
  rotate <0.0, 12.71094, 132.882645>
  translate  <-1.93729, 1.92375, 13.32758>
}
#declare _Leaf2B3_1B3_1B3_Ref = object {
  _Leaf2B3_1B3_1B3
  rotate <0.0, 124.905449, 146.620575>
  translate  <-2.05471, 1.92961, 13.27622>
}
#declare _Leaf2B3_1B3_1B4_Ref = object {
  _Leaf2B3_1B3_1B4
  rotate <0.0, 97.066261, 256.905243>
  translate  <-2.90376, 1.72364, 13.50242>
}
#declare _Leaf2B3_1B3_1B5_Ref = object {
  _Leaf2B3_1B3_1B5
  rotate <0.0, 49.537251, 121.129227>
  translate  <-3.00479, 1.7652, 13.54439>
}
#declare _Leaf2B3_1B3_1B6_Ref = object {
  _Leaf2B3_1B3_1B6
  rotate <0.0, 135.382126, 203.388>
  translate  <-3.10367, 1.71479, 13.53138>
}
#declare _Leaf2B3_1B3_1B7_Ref = object {
  _Leaf2B3_1B3_1B7
  rotate <0.0, 76.155479, 192.476837>
  translate  <-3.57428, 1.62215, 13.67673>
}
#declare _Leaf2B3_1B4_1B1_Ref = object {
  _Leaf2B3_1B4_1B1
  rotate <0.0, 104.841003, 353.663879>
  translate  <-0.76247, 2.59982, 13.18209>
}
#declare _Leaf2B3_1B4_1B2_Ref = object {
  _Leaf2B3_1B4_1B2
  rotate <0.0, 123.290688, 116.610962>
  translate  <-0.77661, 2.7291, 13.18286>
}
#declare _Leaf2B3_1B4_1B3_Ref = object {
  _Leaf2B3_1B4_1B3
  rotate <0.0, 18.80246, 57.096958>
  translate  <-0.70498, 2.78789, 13.27159>
}
#declare _Leaf2B3_1B4_1B4_Ref = object {
  _Leaf2B3_1B4_1B4
  rotate <0.0, 111.050346, 352.335907>
  translate  <-0.18609, 3.52264, 13.34489>
}
#declare _Leaf2B3_1B4_1B5_Ref = object {
  _Leaf2B3_1B4_1B5
  rotate <0.0, 86.531082, 122.367149>
  translate  <-0.18198, 3.63428, 13.37975>
}
#declare _Leaf2B3_1B4_1B6_Ref = object {
  _Leaf2B3_1B4_1B6
  rotate <0.0, 51.530739, 359.196533>
  translate  <-0.0875, 3.68975, 13.40179>
}
#declare _Leaf2B3_1B4_1B7_Ref = object {
  _Leaf2B3_1B4_1B7
  rotate <0.0, 84.105331, 55.20319>
  translate  <0.17637, 4.11412, 13.44011>
}
#declare _Leaf2B3_1B5_1B1_Ref = object {
  _Leaf2B3_1B5_1B1
  rotate <0.0, 138.482071, 242.847885>
  translate  <-2.62916, 3.58122, 13.59028>
}
#declare _Leaf2B3_1B5_1B2_Ref = object {
  _Leaf2B3_1B5_1B2
  rotate <0.0, 42.511219, 187.251266>
  translate  <-2.74117, 3.63243, 13.63202>
}
#declare _Leaf2B3_1B5_1B3_Ref = object {
  _Leaf2B3_1B5_1B3
  rotate <0.0, 120.178642, 96.039513>
  translate  <-2.79959, 3.70591, 13.54456>
}
#declare _Leaf2B3_1B5_1B4_Ref = object {
  _Leaf2B3_1B5_1B4
  rotate <0.0, 132.591431, 246.187225>
  translate  <-3.63295, 3.8517, 13.23036>
}
#declare _Leaf2B3_1B5_1B5_Ref = object {
  _Leaf2B3_1B5_1B5
  rotate <0.0, 50.752548, 136.427704>
  translate  <-3.72766, 3.9201, 13.2373>
}
#declare _Leaf2B3_1B5_1B6_Ref = object {
  _Leaf2B3_1B5_1B6
  rotate <0.0, 162.713623, 114.955437>
  translate  <-3.80641, 3.92652, 13.15827>
}
#declare _Leaf2B3_1B5_1B7_Ref = object {
  _Leaf2B3_1B5_1B7
  rotate <0.0, 110.519463, 168.689178>
  translate  <-4.27596, 4.0195, 13.00973>
}
#declare _Leaf2B3_1B6_1B1_Ref = object {
  _Leaf2B3_1B6_1B1
  rotate <0.0, 79.485382, 334.648987>
  translate  <-1.59803, 3.74869, 14.35806>
}
#declare _Leaf2B3_1B6_1B2_Ref = object {
  _Leaf2B3_1B6_1B2
  rotate <0.0, 105.171806, 79.99276>
  translate  <-1.58355, 3.86714, 14.40975>
}
#declare _Leaf2B3_1B6_1B3_Ref = object {
  _Leaf2B3_1B6_1B3
  rotate <0.0, 20.971939, 193.636597>
  translate  <-1.56551, 3.86571, 14.53677>
}
#declare _Leaf2B3_1B6_1B4_Ref = object {
  _Leaf2B3_1B6_1B4
  rotate <0.0, 85.495071, 336.675751>
  translate  <-1.04644, 4.27439, 15.1516>
}
#declare _Leaf2B3_1B6_1B5_Ref = object {
  _Leaf2B3_1B6_1B5
  rotate <0.0, 79.464508, 107.079674>
  translate  <-1.04054, 4.361, 15.23008>
}
#declare _Leaf2B3_1B6_1B6_Ref = object {
  _Leaf2B3_1B6_1B6
  rotate <0.0, 34.117931, 298.073486>
  translate  <-0.96684, 4.36478, 15.31401>
}
#declare _Leaf2B3_1B6_1B7_Ref = object {
  _Leaf2B3_1B6_1B7
  rotate <0.0, 45.9025, 39.063999>
  translate  <-0.69321, 4.61662, 15.65>
}
#declare _Leaf2B3_1B7_1B1_Ref = object {
  _Leaf2B3_1B7_1B1
  rotate <0.0, 80.943817, 273.058594>
  translate  <-2.44787, 3.35484, 14.48719>
}
#declare _Leaf2B3_1B7_1B2_Ref = object {
  _Leaf2B3_1B7_1B2
  rotate <0.0, 33.919621, 54.258911>
  translate  <-2.4901, 3.39888, 14.60203>
}
#declare _Leaf2B3_1B7_1B3_Ref = object {
  _Leaf2B3_1B7_1B3
  rotate <0.0, 95.202759, 177.874924>
  translate  <-2.60744, 3.35715, 14.63285>
}
#declare _Leaf2B3_1B7_1B4_Ref = object {
  _Leaf2B3_1B7_1B4
  rotate <0.0, 79.91172, 279.398834>
  translate  <-3.04583, 3.04216, 15.35608>
}
#declare _Leaf2B3_1B7_1B5_Ref = object {
  _Leaf2B3_1B7_1B5
  rotate <0.0, 49.003429, 107.411308>
  translate  <-3.11713, 3.06963, 15.44473>
}
#declare _Leaf2B3_1B7_1B6_Ref = object {
  _Leaf2B3_1B7_1B6
  rotate <0.0, 97.062981, 221.799576>
  translate  <-3.17777, 2.9952, 15.50193>
}
#declare _Leaf2B3_1B7_1B7_Ref = object {
  _Leaf2B3_1B7_1B7
  rotate <0.0, 37.403568, 213.828461>
  translate  <-3.4192, 2.84708, 15.9154>
}
#declare _Leaf2B3_1B8_1B1_Ref = object {
  _Leaf2B3_1B8_1B1
  rotate <0.0, 140.007965, 350.517151>
  translate  <-1.91563, 4.19101, 13.5879>
}
#declare _Leaf2B3_1B8_1B2_Ref = object {
  _Leaf2B3_1B8_1B2
  rotate <0.0, 111.264503, 154.864777>
  translate  <-1.971, 4.30585, 13.56221>
}
#declare _Leaf2B3_1B8_1B3_Ref = object {
  _Leaf2B3_1B8_1B3
  rotate <0.0, 60.040771, 50.390759>
  translate  <-1.88859, 4.40414, 13.56485>
}
#declare _Leaf2B3_1B8_1B4_Ref = object {
  _Leaf2B3_1B8_1B4
  rotate <0.0, 144.394287, 343.041901>
  translate  <-1.70721, 5.14867, 13.08814>
}
#declare _Leaf2B3_1B8_1B5_Ref = object {
  _Leaf2B3_1B8_1B5
  rotate <0.0, 81.181213, 132.650696>
  translate  <-1.72403, 5.26422, 13.0803>
}
#declare _Leaf2B3_1B8_1B6_Ref = object {
  _Leaf2B3_1B8_1B6
  rotate <0.0, 92.545761, 19.814039>
  translate  <-1.65907, 5.33326, 13.02113>
}
#declare _Leaf2B3_1B8_1B7_Ref = object {
  _Leaf2B3_1B8_1B7
  rotate <0.0, 120.583519, 76.15184>
  translate  <-1.58392, 5.75784, 12.76564>
}
#declare _Leaf2B3_1B9_1B1_Ref = object {
  _Leaf2B3_1B9_1B1
  rotate <0.0, 157.770844, 292.775757>
  translate  <-3.17082, 5.39792, 14.17676>
}
#declare _Leaf2B3_1B9_1B2_Ref = object {
  _Leaf2B3_1B9_1B2
  rotate <0.0, 81.825378, 176.250381>
  translate  <-3.27063, 5.47958, 14.15999>
}
#declare _Leaf2B3_1B9_1B3_Ref = object {
  _Leaf2B3_1B9_1B3
  rotate <0.0, 99.07666, 64.608673>
  translate  <-3.2431, 5.5791, 14.08384>
}
#declare _Leaf2B3_1B9_1B4_Ref = object {
  _Leaf2B3_1B9_1B4
  rotate <0.0, 153.513916, 281.338776>
  translate  <-3.6275, 6.04555, 13.41366>
}
#declare _Leaf2B3_1B9_1B5_Ref = object {
  _Leaf2B3_1B9_1B5
  rotate <0.0, 71.143303, 139.545776>
  translate  <-3.68873, 6.1414, 13.3861>
}
#declare _Leaf2B3_1B9_1B6_Ref = object {
  _Leaf2B3_1B9_1B6
  rotate <0.0, 134.893478, 35.576561>
  translate  <-3.69461, 6.18476, 13.28327>
}
#declare _Leaf2B3_1B9_1B7_Ref = object {
  _Leaf2B3_1B9_1B7
  rotate <0.0, 137.258774, 127.845749>
  translate  <-3.9275, 6.45411, 12.93057>
}
#declare _Leaf2B3_1B10_1B1_Ref = object {
  _Leaf2B3_1B10_1B1
  rotate <0.0, 72.090683, 302.865784>
  translate  <-2.80497, 4.95246, 15.39635>
}
#declare _Leaf2B3_1B10_1B2_Ref = object {
  _Leaf2B3_1B10_1B2
  rotate <0.0, 70.739441, 59.328892>
  translate  <-2.79782, 5.03128, 15.49954>
}
#declare _Leaf2B3_1B10_1B3_Ref = object {
  _Leaf2B3_1B10_1B3
  rotate <0.0, 57.923962, 193.570175>
  translate  <-2.85567, 4.98427, 15.60397>
}
#declare _Leaf2B3_1B10_1B4_Ref = object {
  _Leaf2B3_1B10_1B4
  rotate <0.0, 75.425262, 308.478943>
  translate  <-2.70425, 4.92137, 16.49143>
}
#declare _Leaf2B3_1B10_1B5_Ref = object {
  _Leaf2B3_1B10_1B5
  rotate <0.0, 61.614231, 98.907608>
  translate  <-2.7258, 4.9689, 16.59619>
}
#declare _Leaf2B3_1B10_1B6_Ref = object {
  _Leaf2B3_1B10_1B6
  rotate <0.0, 59.575062, 245.148239>
  translate  <-2.71379, 4.91491, 16.6933>
}
#declare _Leaf2B3_1B10_1B7_Ref = object {
  _Leaf2B3_1B10_1B7
  rotate <0.0, 9.20624, 335.385498>
  translate  <-2.63306, 4.90911, 17.1879>
}
#declare _Leaf2B3_1B11_1B1_Ref = object {
  _Leaf2B3_1B11_1B1
  rotate <0.0, 101.057831, 251.288864>
  translate  <-3.66039, 5.0335, 14.93936>
}
#declare _Leaf2B3_1B11_1B2_Ref = object {
  _Leaf2B3_1B11_1B2
  rotate <0.0, 12.69537, 130.08403>
  translate  <-3.75031, 5.07637, 15.02295>
}
#declare _Leaf2B3_1B11_1B3_Ref = object {
  _Leaf2B3_1B11_1B3
  rotate <0.0, 124.78112, 146.001083>
  translate  <-3.86792, 5.08384, 14.97224>
}
#declare _Leaf2B3_1B11_1B4_Ref = object {
  _Leaf2B3_1B11_1B4
  rotate <0.0, 96.725182, 255.969986>
  translate  <-4.71878, 4.89237, 15.20428>
}
#declare _Leaf2B3_1B11_1B5_Ref = object {
  _Leaf2B3_1B11_1B5
  rotate <0.0, 49.60334, 119.865448>
  translate  <-4.81891, 4.93572, 15.24663>
}
#declare _Leaf2B3_1B11_1B6_Ref = object {
  _Leaf2B3_1B11_1B6
  rotate <0.0, 134.972183, 202.605286>
  translate  <-4.91865, 4.88681, 15.23442>
}
#declare _Leaf2B3_1B11_1B7_Ref = object {
  _Leaf2B3_1B11_1B7
  rotate <0.0, 75.776093, 191.523575>
  translate  <-5.38981, 4.80229, 15.38291>
}
#declare _Leaf2B3_1B12_1B1_Ref = object {
  _Leaf2B3_1B12_1B1
  rotate <0.0, 104.205101, 349.235229>
  translate  <-2.53857, 5.71287, 14.8538>
}
#declare _Leaf2B3_1B12_1B2_Ref = object {
  _Leaf2B3_1B12_1B2
  rotate <0.0, 125.42926, 113.182381>
  translate  <-2.54393, 5.84274, 14.84951>
}
#declare _Leaf2B3_1B12_1B3_Ref = object {
  _Leaf2B3_1B12_1B3
  rotate <0.0, 20.49651, 57.313061>
  translate  <-2.46886, 5.89997, 14.9364>
}
#declare _Leaf2B3_1B12_1B4_Ref = object {
  _Leaf2B3_1B12_1B4
  rotate <0.0, 110.360329, 347.658691>
  translate  <-1.90177, 6.60034, 14.9849>
}
#declare _Leaf2B3_1B12_1B5_Ref = object {
  _Leaf2B3_1B12_1B5
  rotate <0.0, 88.597214, 118.45739>
  translate  <-1.89026, 6.71272, 15.01547>
}
#declare _Leaf2B3_1B12_1B6_Ref = object {
  _Leaf2B3_1B12_1B6
  rotate <0.0, 51.148861, 357.085358>
  translate  <-1.79234, 6.76251, 15.036>
}
#declare _Leaf2B3_1B12_1B7_Ref = object {
  _Leaf2B3_1B12_1B7
  rotate <0.0, 85.695969, 51.469898>
  translate  <-1.50053, 7.16929, 15.05975>
}
#declare _Leaf2B4_2B1_1B1_Ref = object {
  _Leaf2B4_2B1_1B1
  rotate <0.0, 140.212357, 314.512054>
  translate  <-8.00024, -0.45131, 15.17752>
}
#declare _Leaf2B4_2B1_1B2_Ref = object {
  _Leaf2B4_2B1_1B2
  rotate <0.0, 51.587891, 245.374313>
  translate  <-8.10307, -0.528, 15.19891>
}
#declare _Leaf2B4_2B1_1B3_Ref = object {
  _Leaf2B4_2B1_1B3
  rotate <0.0, 122.563957, 151.162735>
  translate  <-8.18571, -0.53133, 15.10083>
}
#declare _Leaf2B4_2B1_1B4_Ref = object {
  _Leaf2B4_2B1_1B4
  rotate <0.0, 133.937714, 315.810974>
  translate  <-8.67895, -1.13894, 14.65138>
}
#declare _Leaf2B4_2B1_1B5_Ref = object {
  _Leaf2B4_2B1_1B5
  rotate <0.0, 58.936119, 200.585648>
  translate  <-8.78471, -1.1879, 14.64069>
}
#declare _Leaf2B4_2B1_1B6_Ref = object {
  _Leaf2B4_2B1_1B6
  rotate <0.0, 166.100098, 143.208572>
  translate  <-8.81963, -1.24274, 14.54979>
}
#declare _Leaf2B4_2B1_1B7_Ref = object {
  _Leaf2B4_2B1_1B7
  rotate <0.0, 120.017059, 229.430466>
  translate  <-9.11002, -1.58334, 14.3243>
}
#declare _Leaf2B4_2B2_1B1_Ref = object {
  _Leaf2B4_2B2_1B1
  rotate <0.0, 76.641228, 31.268101>
  translate  <-7.64703, 0.4353, 16.0993>
}
#declare _Leaf2B4_2B2_1B2_Ref = object {
  _Leaf2B4_2B2_1B2
  rotate <0.0, 100.565758, 136.823624>
  translate  <-7.73903, 0.50458, 16.15969>
}
#declare _Leaf2B4_2B2_1B3_Ref = object {
  _Leaf2B4_2B2_1B3
  rotate <0.0, 26.81513, 256.456665>
  translate  <-7.72705, 0.50523, 16.28743>
}
#declare _Leaf2B4_2B2_1B4_Ref = object {
  _Leaf2B4_2B2_1B4
  rotate <0.0, 82.42746, 33.89558>
  translate  <-7.79031, 1.09169, 16.97047>
}
#declare _Leaf2B4_2B2_1B5_Ref = object {
  _Leaf2B4_2B2_1B5
  rotate <0.0, 77.39698, 166.083588>
  translate  <-7.85971, 1.134, 17.05467>
}
#declare _Leaf2B4_2B2_1B6_Ref = object {
  _Leaf2B4_2B2_1B6
  rotate <0.0, 35.560059, 347.119568>
  translate  <-7.82283, 1.18891, 17.14475>
}
#declare _Leaf2B4_2B2_1B7_Ref = object {
  _Leaf2B4_2B2_1B7
  rotate <0.0, 39.661331, 97.119118>
  translate  <-7.88686, 1.51604, 17.51901>
}
#declare _Leaf2B4_2B3_1B1_Ref = object {
  _Leaf2B4_2B3_1B1
  rotate <0.0, 78.719292, 332.046692>
  translate  <-7.80084, -0.49242, 16.13438>
}
#declare _Leaf2B4_2B3_1B2_Ref = object {
  _Leaf2B4_2B3_1B2
  rotate <0.0, 31.84943, 126.021629>
  translate  <-7.87036, -0.51795, 16.24128>
}
#declare _Leaf2B4_2B3_1B3_Ref = object {
  _Leaf2B4_2B3_1B3
  rotate <0.0, 102.688164, 238.44136>
  translate  <-7.89446, -0.64284, 16.25805>
}
#declare _Leaf2B4_2B3_1B4_Ref = object {
  _Leaf2B4_2B3_1B4
  rotate <0.0, 76.897812, 338.256104>
  translate  <-7.90303, -1.24671, 16.92868>
}
#declare _Leaf2B4_2B3_1B5_Ref = object {
  _Leaf2B4_2B3_1B5
  rotate <0.0, 53.343441, 172.816055>
  translate  <-7.96997, -1.30304, 17.00641>
}
#declare _Leaf2B4_2B3_1B6_Ref = object {
  _Leaf2B4_2B3_1B6
  rotate <0.0, 101.268753, 283.141541>
  translate  <-7.94042, -1.3978, 17.05774>
}
#declare _Leaf2B4_2B3_1B7_Ref = object {
  _Leaf2B4_2B3_1B7
  rotate <0.0, 42.831638, 267.683319>
  translate  <-7.96853, -1.71922, 17.44126>
}
#declare _Leaf2B4_2B4_1B1_Ref = object {
  _Leaf2B4_2B4_1B1
  rotate <0.0, 138.969284, 46.257778>
  translate  <-8.16125, 0.49951, 15.30561>
}
#declare _Leaf2B4_2B4_1B2_Ref = object {
  _Leaf2B4_2B4_1B2
  rotate <0.0, 111.522141, 206.740463>
  translate  <-8.28665, 0.52564, 15.28314>
}
#declare _Leaf2B4_2B4_1B3_Ref = object {
  _Leaf2B4_2B4_1B3
  rotate <0.0, 57.433231, 103.058693>
  translate  <-8.31525, 0.65042, 15.29161>
}
#declare _Leaf2B4_2B4_1B4_Ref = object {
  _Leaf2B4_2B4_1B4
  rotate <0.0, 143.665207, 39.437801>
  translate  <-8.80751, 1.26382, 14.849>
}
#declare _Leaf2B4_2B4_1B5_Ref = object {
  _Leaf2B4_2B4_1B5
  rotate <0.0, 80.459381, 185.964233>
  translate  <-8.90992, 1.32035, 14.84532>
}
#declare _Leaf2B4_2B4_1B6_Ref = object {
  _Leaf2B4_2B4_1B6
  rotate <0.0, 90.494164, 72.761711>
  translate  <-8.92678, 1.41624, 14.79047>
}
#declare _Leaf2B4_2B4_1B7_Ref = object {
  _Leaf2B4_2B4_1B7
  rotate <0.0, 118.064934, 128.617844>
  translate  <-9.22428, 1.74279, 14.55374>
}
#declare _Leaf2B4_2B5_1B1_Ref = object {
  _Leaf2B4_2B5_1B1
  rotate <0.0, 133.907715, 176.111343>
  translate  <-9.2733, 0.00383, 16.24356>
}
#declare _Leaf2B4_2B5_1B2_Ref = object {
  _Leaf2B4_2B5_1B2
  rotate <0.0, 58.19939, 259.867767>
  translate  <-9.33801, -0.04059, 16.34725>
}
#declare _Leaf2B4_2B5_1B3_Ref = object {
  _Leaf2B4_2B5_1B3
  rotate <0.0, 60.181099, 108.861282>
  translate  <-9.42859, 0.03989, 16.3894>
}
#declare _Leaf2B4_2B5_1B4_Ref = object {
  _Leaf2B4_2B5_1B4
  rotate <0.0, 136.894714, 184.077103>
  translate  <-10.27897, 0.00492, 16.68959>
}
#declare _Leaf2B4_2B5_1B5_Ref = object {
  _Leaf2B4_2B5_1B5
  rotate <0.0, 21.038879, 259.796356>
  translate  <-10.3473, 0.00192, 16.78456>
}
#declare _Leaf2B4_2B5_1B6_Ref = object {
  _Leaf2B4_2B5_1B6
  rotate <0.0, 99.618736, 128.4133>
  translate  <-10.45582, 0.0286, 16.7847>
}
#declare _Leaf2B4_2B5_1B7_Ref = object {
  _Leaf2B4_2B5_1B7
  rotate <0.0, 69.675743, 181.3405>
  translate  <-10.91811, -0.00451, 16.97541>
}
#declare _Leaf2B4_1B1_1B1_Ref = object {
  _Leaf2B4_1B1_1B1
  rotate <0.0, 158.08374, 358.09021>
  translate  <-2.63532, 0.03275, 12.48557>
}
#declare _Leaf2B4_1B1_1B2_Ref = object {
  _Leaf2B4_1B1_1B2
  rotate <0.0, 85.247688, 231.447891>
  translate  <-2.75945, -0.00065, 12.46582>
}
#declare _Leaf2B4_1B1_1B3_Ref = object {
  _Leaf2B4_1B1_1B3
  rotate <0.0, 95.507713, 119.237961>
  translate  <-2.82479, 0.08447, 12.3955>
}
#declare _Leaf2B4_1B1_1B4_Ref = object {
  _Leaf2B4_1B1_1B4
  rotate <0.0, 154.730011, 344.599548>
  translate  <-3.42495, 0.08745, 11.7215>
}
#declare _Leaf2B4_1B1_1B5_Ref = object {
  _Leaf2B4_1B1_1B5
  rotate <0.0, 72.447823, 195.783875>
  translate  <-3.53848, 0.09446, 11.69396>
}
#declare _Leaf2B4_1B1_1B6_Ref = object {
  _Leaf2B4_1B1_1B6
  rotate <0.0, 130.680527, 90.272087>
  translate  <-3.57696, 0.12208, 11.59274>
}
#declare _Leaf2B4_1B1_1B7_Ref = object {
  _Leaf2B4_1B1_1B7
  rotate <0.0, 137.505508, 178.181824>
  translate  <-3.92992, 0.11237, 11.23706>
}
#declare _Leaf2B4_1B2_1B1_Ref = object {
  _Leaf2B4_1B2_1B1
  rotate <0.0, 64.211166, 354.343262>
  translate  <-2.16354, -0.03609, 13.71496>
}
#declare _Leaf2B4_1B2_1B2_Ref = object {
  _Leaf2B4_1B2_1B2
  rotate <0.0, 68.972748, 117.117699>
  translate  <-2.23788, 0.00556, 13.8132>
}
#declare _Leaf2B4_1B2_1B3_Ref = object {
  _Leaf2B4_1B2_1B3
  rotate <0.0, 66.674759, 244.887955>
  translate  <-2.24834, -0.07917, 13.90896>
}
#declare _Leaf2B4_1B2_1B4_Ref = object {
  _Leaf2B4_1B2_1B4
  rotate <0.0, 66.916382, 0.63846>
  translate  <-2.23919, -0.08557, 14.81138>
}
#declare _Leaf2B4_1B2_1B5_Ref = object {
  _Leaf2B4_1B2_1B5
  rotate <0.0, 66.721733, 157.292267>
  translate  <-2.30503, -0.08553, 14.90814>
}
#declare _Leaf2B4_1B2_1B6_Ref = object {
  _Leaf2B4_1B2_1B6
  rotate <0.0, 61.150311, 293.483673>
  translate  <-2.26869, -0.11765, 15.00882>
}
#declare _Leaf2B4_1B2_1B7_Ref = object {
  _Leaf2B4_1B2_1B7
  rotate <0.0, 1.38916, 256.415253>
  translate  <-2.28927, -0.1069, 15.50947>
}
#declare _Leaf2B4_1B3_1B1_Ref = object {
  _Leaf2B4_1B3_1B1
  rotate <0.0, 106.18869, 310.306213>
  translate  <-2.5876, -0.65853, 13.17136>
}
#declare _Leaf2B4_1B3_1B2_Ref = object {
  _Leaf2B4_1B3_1B2
  rotate <0.0, 15.26597, 213.516571>
  translate  <-2.67181, -0.72146, 13.24791>
}
#declare _Leaf2B4_1B3_1B3_Ref = object {
  _Leaf2B4_1B3_1B3
  rotate <0.0, 127.388382, 199.388702>
  translate  <-2.74045, -0.81053, 13.18613>
}
#declare _Leaf2B4_1B3_1B4_Ref = object {
  _Leaf2B4_1B3_1B4
  rotate <0.0, 101.491386, 314.687592>
  translate  <-3.0301, -1.65487, 13.31907>
}
#declare _Leaf2B4_1B3_1B5_Ref = object {
  _Leaf2B4_1B3_1B5
  rotate <0.0, 49.797131, 183.556747>
  translate  <-3.12005, -1.72127, 13.35366>
}
#declare _Leaf2B4_1B3_1B6_Ref = object {
  _Leaf2B4_1B3_1B6
  rotate <0.0, 141.654144, 259.348755>
  translate  <-3.13149, -1.82955, 13.3285>
}
#declare _Leaf2B4_1B3_1B7_Ref = object {
  _Leaf2B4_1B3_1B7
  rotate <0.0, 82.160896, 249.907547>
  translate  <-3.31015, -2.28812, 13.42327>
}
#declare _Leaf2B4_1B4_1B1_Ref = object {
  _Leaf2B4_1B4_1B1
  rotate <0.0, 99.799339, 51.544788>
  translate  <-2.59967, 0.63986, 13.25301>
}
#declare _Leaf2B4_1B4_1B2_Ref = object {
  _Leaf2B4_1B4_1B2
  rotate <0.0, 122.526268, 169.569305>
  translate  <-2.71584, 0.69791, 13.2599>
}
#declare _Leaf2B4_1B4_1B3_Ref = object {
  _Leaf2B4_1B4_1B3
  rotate <0.0, 13.35679, 125.618378>
  translate  <-2.72648, 0.77963, 13.35823>
}
#declare _Leaf2B4_1B4_1B4_Ref = object {
  _Leaf2B4_1B4_1B4
  rotate <0.0, 106.082321, 50.701752>
  translate  <-3.06097, 1.60161, 13.52237>
}
#declare _Leaf2B4_1B4_1B5_Ref = object {
  _Leaf2B4_1B4_1B5
  rotate <0.0, 86.650269, 179.784027>
  translate  <-3.15252, 1.66157, 13.56385>
}
#declare _Leaf2B4_1B4_1B6_Ref = object {
  _Leaf2B4_1B4_1B6
  rotate <0.0, 46.257488, 53.150501>
  translate  <-3.14774, 1.76791, 13.59785>
}
#declare _Leaf2B4_1B4_1B7_Ref = object {
  _Leaf2B4_1B4_1B7
  rotate <0.0, 78.305771, 112.64019>
  translate  <-3.36042, 2.21323, 13.68528>
}
#declare _Leaf2B4_1B5_1B1_Ref = object {
  _Leaf2B4_1B5_1B1
  rotate <0.0, 143.774536, 304.24054>
  translate  <-4.43971, -0.43089, 13.53944>
}
#declare _Leaf2B4_1B5_1B2_Ref = object {
  _Leaf2B4_1B5_1B2
  rotate <0.0, 48.352329, 246.734787>
  translate  <-4.54374, -0.5012, 13.57332>
}
#declare _Leaf2B4_1B5_1B3_Ref = object {
  _Leaf2B4_1B5_1B3
  rotate <0.0, 117.296112, 149.975204>
  translate  <-4.63692, -0.5005, 13.48514>
}
#declare _Leaf2B4_1B5_1B4_Ref = object {
  _Leaf2B4_1B5_1B4
  rotate <0.0, 137.68808, 307.031921>
  translate  <-5.21165, -1.08182, 13.10274>
}
#declare _Leaf2B4_1B5_1B5_Ref = object {
  _Leaf2B4_1B5_1B5
  rotate <0.0, 52.646702, 198.254745>
  translate  <-5.32058, -1.12456, 13.10467>
}
#declare _Leaf2B4_1B5_1B6_Ref = object {
  _Leaf2B4_1B5_1B6
  rotate <0.0, 160.953583, 153.297485>
  translate  <-5.36859, -1.17802, 13.01907>
}
#declare _Leaf2B4_1B5_1B7_Ref = object {
  _Leaf2B4_1B5_1B7
  rotate <0.0, 115.107292, 223.881897>
  translate  <-5.70158, -1.50284, 12.83255>
}
#declare _Leaf2B4_1B6_1B1_Ref = object {
  _Leaf2B4_1B6_1B1
  rotate <0.0, 76.066109, 30.5285>
  translate  <-4.02156, 0.43467, 14.40934>
}
#declare _Leaf2B4_1B6_1B2_Ref = object {
  _Leaf2B4_1B6_1B2
  rotate <0.0, 100.921799, 135.938477>
  translate  <-4.11323, 0.50509, 14.46892>
}
#declare _Leaf2B4_1B6_1B3_Ref = object {
  _Leaf2B4_1B6_1B3
  rotate <0.0, 27.07691, 254.577133>
  translate  <-4.10258, 0.50533, 14.59677>
}
#declare _Leaf2B4_1B6_1B4_Ref = object {
  _Leaf2B4_1B6_1B4
  rotate <0.0, 81.862549, 33.137539>
  translate  <-4.16493, 1.09128, 15.28032>
}
#declare _Leaf2B4_1B6_1B5_Ref = object {
  _Leaf2B4_1B6_1B5
  rotate <0.0, 77.951424, 165.349747>
  translate  <-4.23462, 1.13438, 15.36388>
}
#declare _Leaf2B4_1B6_1B6_Ref = object {
  _Leaf2B4_1B6_1B6
  rotate <0.0, 35.001911, 345.973083>
  translate  <-4.19794, 1.1886, 15.45446>
}
#declare _Leaf2B4_1B6_1B7_Ref = object {
  _Leaf2B4_1B6_1B7
  rotate <0.0, 39.621441, 97.066002>
  translate  <-4.26138, 1.51586, 15.8287>
}
#declare _Leaf2B4_1B7_1B1_Ref = object {
  _Leaf2B4_1B7_1B1
  rotate <0.0, 84.001266, 329.361877>
  translate  <-4.15371, -0.50123, 14.43487>
}
#declare _Leaf2B4_1B7_1B2_Ref = object {
  _Leaf2B4_1B7_1B2
  rotate <0.0, 28.16552, 115.758926>
  translate  <-4.21395, -0.52531, 14.54758>
}
#declare _Leaf2B4_1B7_1B3_Ref = object {
  _Leaf2B4_1B7_1B3
  rotate <0.0, 100.472748, 234.426682>
  translate  <-4.24286, -0.64912, 14.56474>
}
#declare _Leaf2B4_1B7_1B4_Ref = object {
  _Leaf2B4_1B7_1B4
  rotate <0.0, 82.34549, 335.522064>
  translate  <-4.21906, -1.26492, 15.22406>
}
#declare _Leaf2B4_1B7_1B5_Ref = object {
  _Leaf2B4_1B7_1B5
  rotate <0.0, 47.757542, 169.984314>
  translate  <-4.28115, -1.3193, 15.30704>
}
#declare _Leaf2B4_1B7_1B6_Ref = object {
  _Leaf2B4_1B7_1B6
  rotate <0.0, 103.302002, 279.044556>
  translate  <-4.25184, -1.41644, 15.35388>
}
#declare _Leaf2B4_1B7_1B7_Ref = object {
  _Leaf2B4_1B7_1B7
  rotate <0.0, 43.742352, 270.581757>
  translate  <-4.26006, -1.74353, 15.73352>
}
#declare _Leaf2B4_1B8_1B1_Ref = object {
  _Leaf2B4_1B8_1B1
  rotate <0.0, 135.058029, 51.903099>
  translate  <-4.56328, 0.49415, 13.63949>
}
#declare _Leaf2B4_1B8_1B2_Ref = object {
  _Leaf2B4_1B8_1B2
  rotate <0.0, 114.652267, 209.628235>
  translate  <-4.68969, 0.51293, 13.61537>
}
#declare _Leaf2B4_1B8_1B3_Ref = object {
  _Leaf2B4_1B8_1B3
  rotate <0.0, 54.06377, 108.810013>
  translate  <-4.72735, 0.63452, 13.63143>
}
#declare _Leaf2B4_1B8_1B4_Ref = object {
  _Leaf2B4_1B8_1B4
  rotate <0.0, 139.941635, 45.917252>
  translate  <-5.25208, 1.24111, 13.21768>
}
#declare _Leaf2B4_1B8_1B5_Ref = object {
  _Leaf2B4_1B8_1B5
  rotate <0.0, 82.459869, 190.583359>
  translate  <-5.35817, 1.29045, 13.21498>
}
#declare _Leaf2B4_1B8_1B6_Ref = object {
  _Leaf2B4_1B8_1B6
  rotate <0.0, 86.333237, 76.840118>
  translate  <-5.3806, 1.3885, 13.16627>
}
#declare _Leaf2B4_1B8_1B7_Ref = object {
  _Leaf2B4_1B8_1B7
  rotate <0.0, 115.9786, 130.838837>
  translate  <-5.69526, 1.70902, 12.94392>
}
#declare _Leaf2B4_1B9_1B1_Ref = object {
  _Leaf2B4_1B9_1B1
  rotate <0.0, 157.870804, 5.43709>
  translate  <-6.26045, 0.0353, 14.17611>
}
#declare _Leaf2B4_1B9_1B2_Ref = object {
  _Leaf2B4_1B9_1B2
  rotate <0.0, 87.020081, 233.645157>
  translate  <-6.38322, -0.0019, 14.15474>
}
#declare _Leaf2B4_1B9_1B3_Ref = object {
  _Leaf2B4_1B9_1B3
  rotate <0.0, 93.750977, 121.259232>
  translate  <-6.45153, 0.08329, 14.0874>
}
#declare _Leaf2B4_1B9_1B4_Ref = object {
  _Leaf2B4_1B9_1B4
  rotate <0.0, 155.030228, 351.205505>
  translate  <-7.05011, 0.08908, 13.41202>
}
#declare _Leaf2B4_1B9_1B5_Ref = object {
  _Leaf2B4_1B9_1B5
  rotate <0.0, 73.213852, 198.514313>
  translate  <-7.16377, 0.09291, 13.38439>
}
#declare _Leaf2B4_1B9_1B6_Ref = object {
  _Leaf2B4_1B9_1B6
  rotate <0.0, 128.564682, 92.229698>
  translate  <-7.20306, 0.12283, 13.28413>
}
#declare _Leaf2B4_1B9_1B7_Ref = object {
  _Leaf2B4_1B9_1B7
  rotate <0.0, 137.581985, 177.978699>
  translate  <-7.55475, 0.11327, 12.92719>
}
#declare _Leaf2B4_1B10_1B1_Ref = object {
  _Leaf2B4_1B10_1B1
  rotate <0.0, 72.051018, 357.849823>
  translate  <-5.69114, -0.0353, 15.397>
}
#declare _Leaf2B4_1B10_1B2_Ref = object {
  _Leaf2B4_1B10_1B2
  rotate <0.0, 65.161041, 117.593246>
  translate  <-5.75368, 0.0019, 15.50478>
}
#declare _Leaf2B4_1B10_1B3_Ref = object {
  _Leaf2B4_1B10_1B3
  rotate <0.0, 63.978481, 251.662567>
  translate  <-5.746, -0.08329, 15.60041>
}
#declare _Leaf2B4_1B10_1B4_Ref = object {
  _Leaf2B4_1B10_1B4
  rotate <0.0, 74.744102, 3.83588>
  translate  <-5.61339, -0.08908, 16.49307>
}
#declare _Leaf2B4_1B10_1B5_Ref = object {
  _Leaf2B4_1B10_1B5
  rotate <0.0, 59.348969, 159.305649>
  translate  <-5.66529, -0.09291, 16.5979>
}
#declare _Leaf2B4_1B10_1B6_Ref = object {
  _Leaf2B4_1B10_1B6
  rotate <0.0, 64.911613, 300.378326>
  translate  <-5.61374, -0.12283, 16.69244>
}
#declare _Leaf2B4_1B10_1B7_Ref = object {
  _Leaf2B4_1B10_1B7
  rotate <0.0, 7.72034, 349.799011>
  translate  <-5.56637, -0.11327, 17.19128>
}
#declare _Leaf2B4_1B11_1B1_Ref = object {
  _Leaf2B4_1B11_1B1
  rotate <0.0, 105.897987, 309.311859>
  translate  <-6.22313, -0.65425, 14.86688>
}
#declare _Leaf2B4_1B11_1B2_Ref = object {
  _Leaf2B4_1B11_1B2
  rotate <0.0, 14.99529, 211.398346>
  translate  <-6.30825, -0.71527, 14.94396>
}
#declare _Leaf2B4_1B11_1B3_Ref = object {
  _Leaf2B4_1B11_1B3
  rotate <0.0, 127.200951, 198.774384>
  translate  <-6.37835, -0.8037, 14.88291>
}
#declare _Leaf2B4_1B11_1B4_Ref = object {
  _Leaf2B4_1B11_1B4
  rotate <0.0, 101.225327, 313.715881>
  translate  <-6.68116, -1.64235, 15.02231>
}
#declare _Leaf2B4_1B11_1B5_Ref = object {
  _Leaf2B4_1B11_1B5
  rotate <0.0, 49.723309, 182.297256>
  translate  <-6.77212, -1.70707, 15.05747>
}
#declare _Leaf2B4_1B11_1B6_Ref = object {
  _Leaf2B4_1B11_1B6
  rotate <0.0, 141.229919, 258.481049>
  translate  <-6.78529, -1.81534, 15.03312>
}
#declare _Leaf2B4_1B11_1B7_Ref = object {
  _Leaf2B4_1B11_1B7
  rotate <0.0, 81.747353, 248.988464>
  translate  <-6.97108, -2.27031, 15.13142>
}
#declare _Leaf2B4_1B12_1B1_Ref = object {
  _Leaf2B4_1B12_1B1
  rotate <0.0, 99.47406, 47.16116>
  translate  <-6.18276, 0.65805, 14.92675>
}
#declare _Leaf2B4_1B12_1B2_Ref = object {
  _Leaf2B4_1B12_1B2
  rotate <0.0, 124.274231, 165.871811>
  translate  <-6.29464, 0.72429, 14.92948>
}
#declare _Leaf2B4_1B12_1B3_Ref = object {
  _Leaf2B4_1B12_1B3
  rotate <0.0, 15.03223, 124.553482>
  translate  <-6.30208, 0.80825, 15.0262>
}
#declare _Leaf2B4_1B12_1B4_Ref = object {
  _Leaf2B4_1B12_1B4
  rotate <0.0, 105.727158, 46.111179>
  translate  <-6.58145, 1.65456, 15.16826>
}
#declare _Leaf2B4_1B12_1B5_Ref = object {
  _Leaf2B4_1B12_1B5
  rotate <0.0, 88.271889, 175.669357>
  translate  <-6.66958, 1.72156, 15.20621>
}
#declare _Leaf2B4_1B12_1B6_Ref = object {
  _Leaf2B4_1B12_1B6
  rotate <0.0, 46.015808, 50.827518>
  translate  <-6.65815, 1.82787, 15.23871>
}
#declare _Leaf2B4_1B12_1B7_Ref = object {
  _Leaf2B4_1B12_1B7
  rotate <0.0, 79.739243, 108.787804>
  translate  <-6.84083, 2.28858, 15.31328>
}
#declare _Leaf2B5_2B1_1B1_Ref = object {
  _Leaf2B5_2B1_1B1
  rotate <0.0, 143.571533, 159.781174>
  translate  <6.43655, 4.23728, 19.3627>
}
#declare _Leaf2B5_2B1_1B2_Ref = object {
  _Leaf2B5_2B1_1B2
  rotate <0.0, 49.653721, 99.162651>
  translate  <6.48531, 4.35398, 19.39296>
}
#declare _Leaf2B5_2B1_1B3_Ref = object {
  _Leaf2B5_2B1_1B3
  rotate <0.0, 118.154282, 2.54518>
  translate  <6.56234, 4.4023, 19.30246>
}
#declare _Leaf2B5_2B1_1B4_Ref = object {
  _Leaf2B5_2B1_1B4
  rotate <0.0, 137.411896, 162.123535>
  translate  <6.718, 5.19377, 18.89771>
}
#declare _Leaf2B5_2B1_1B5_Ref = object {
  _Leaf2B5_2B1_1B5
  rotate <0.0, 54.273281, 51.777451>
  translate  <6.78556, 5.28932, 18.89628>
}
#declare _Leaf2B5_2B1_1B6_Ref = object {
  _Leaf2B5_2B1_1B6
  rotate <0.0, 161.852188, 2.48924>
  translate  <6.79513, 5.35816, 18.80877>
}
#declare _Leaf2B5_2B1_1B7_Ref = object {
  _Leaf2B5_2B1_1B7
  rotate <0.0, 116.69706, 77.410393>
  translate  <6.89238, 5.8076, 18.60945>
}
#declare _Leaf2B5_2B2_1B1_Ref = object {
  _Leaf2B5_2B2_1B1
  rotate <0.0, 80.927261, 240.756943>
  translate  <6.50556, 3.25334, 20.25018>
}
#declare _Leaf2B5_2B2_1B2_Ref = object {
  _Leaf2B5_2B2_1B2
  rotate <0.0, 96.902802, 347.347015>
  translate  <6.61502, 3.23654, 20.31837>
}
#declare _Leaf2B5_2B2_1B3_Ref = object {
  _Leaf2B5_2B2_1B3
  rotate <0.0, 26.067369, 116.417717>
  translate  <6.59536, 3.22444, 20.44457>
}
#declare _Leaf2B5_2B2_1B4_Ref = object {
  _Leaf2B5_2B2_1B4
  rotate <0.0, 86.58506, 243.628159>
  translate  <6.89161, 2.7183, 21.13052>
}
#declare _Leaf2B5_2B2_1B5_Ref = object {
  _Leaf2B5_2B2_1B5
  rotate <0.0, 72.546989, 15.75682>
  translate  <6.96628, 2.71256, 21.22045>
}
#declare _Leaf2B5_2B2_1B6_Ref = object {
  _Leaf2B5_2B2_1B6
  rotate <0.0, 40.447552, 198.473099>
  translate  <6.95512, 2.64271, 21.30698>
}
#declare _Leaf2B5_2B2_1B7_Ref = object {
  _Leaf2B5_2B2_1B7
  rotate <0.0, 39.304081, 301.058685>
  translate  <7.14568, 2.37499, 21.68539>
}
#declare _Leaf2B5_2B3_1B1_Ref = object {
  _Leaf2B5_2B3_1B1
  rotate <0.0, 83.144157, 182.418716>
  translate  <6.17175, 4.13186, 20.29853>
}
#declare _Leaf2B5_2B3_1B2_Ref = object {
  _Leaf2B5_2B3_1B2
  rotate <0.0, 29.16119, 328.849854>
  translate  <6.21089, 4.18394, 20.41109>
}
#declare _Leaf2B5_2B3_1B3_Ref = object {
  _Leaf2B5_2B3_1B3
  rotate <0.0, 100.038383, 87.588516>
  translate  <6.16798, 4.30337, 20.42989>
}
#declare _Leaf2B5_2B3_1B4_Ref = object {
  _Leaf2B5_2B3_1B4
  rotate <0.0, 81.548111, 188.606216>
  translate  <5.82281, 4.80138, 21.09871>
}
#declare _Leaf2B5_2B3_1B5_Ref = object {
  _Leaf2B5_2B3_1B5
  rotate <0.0, 48.385509, 22.28833>
  translate  <5.84653, 4.88011, 21.18199>
}
#declare _Leaf2B5_2B3_1B6_Ref = object {
  _Leaf2B5_2B3_1B6
  rotate <0.0, 102.362801, 132.120193>
  translate  <5.76978, 4.94523, 21.23055>
}
#declare _Leaf2B5_2B3_1B7_Ref = object {
  _Leaf2B5_2B3_1B7
  rotate <0.0, 42.86496, 123.078987>
  translate  <5.60438, 5.22087, 21.61506>
}
#declare _Leaf2B5_2B4_1B1_Ref = object {
  _Leaf2B5_2B4_1B1
  rotate <0.0, 142.283386, 260.828156>
  translate  <7.04121, 3.48846, 19.50433>
}
#declare _Leaf2B5_2B4_1B2_Ref = object {
  _Leaf2B5_2B4_1B2
  rotate <0.0, 107.041061, 55.963531>
  translate  <7.16416, 3.52927, 19.49288>
}
#declare _Leaf2B5_2B4_1B3_Ref = object {
  _Leaf2B5_2B4_1B3
  rotate <0.0, 56.43861, 309.86618>
  translate  <7.25058, 3.43508, 19.5038>
}
#declare _Leaf2B5_2B4_1B4_Ref = object {
  _Leaf2B5_2B4_1B4
  rotate <0.0, 147.392883, 254.303345>
  translate  <8.01537, 3.16835, 19.10579>
}
#declare _Leaf2B5_2B4_1B5_Ref = object {
  _Leaf2B5_2B4_1B5
  rotate <0.0, 75.486923, 36.076031>
  translate  <8.13227, 3.17056, 19.11104>
}
#declare _Leaf2B5_2B4_1B6_Ref = object {
  _Leaf2B5_2B4_1B6
  rotate <0.0, 91.972458, 282.864624>
  translate  <8.1989, 3.0983, 19.05787>
}
#declare _Leaf2B5_2B4_1B7_Ref = object {
  _Leaf2B5_2B4_1B7
  rotate <0.0, 114.87764, 340.538177>
  translate  <8.6367, 2.974, 18.84797>
}
#declare _Leaf2B5_2B5_1B1_Ref = object {
  _Leaf2B5_2B5_1B1
  rotate <0.0, 128.918365, 26.39954>
  translate  <7.68197, 4.43076, 20.53563>
}
#declare _Leaf2B5_2B5_1B2_Ref = object {
  _Leaf2B5_2B5_1B2
  rotate <0.0, 57.453049, 112.980453>
  translate  <7.70776, 4.49695, 20.64457>
}
#declare _Leaf2B5_2B5_1B3_Ref = object {
  _Leaf2B5_2B5_1B3
  rotate <0.0, 58.680279, 316.041779>
  translate  <7.82296, 4.47053, 20.69446>
}
#declare _Leaf2B5_2B5_1B4_Ref = object {
  _Leaf2B5_2B5_1B4
  rotate <0.0, 131.906326, 33.743>
  translate  <8.51647, 4.9113, 21.06761>
}
#declare _Leaf2B5_2B5_1B5_Ref = object {
  _Leaf2B5_2B5_1B5
  rotate <0.0, 20.718781, 122.915024>
  translate  <8.56675, 4.9438, 21.16817>
}
#declare _Leaf2B5_2B5_1B6_Ref = object {
  _Leaf2B5_2B5_1B6
  rotate <0.0, 96.491982, 338.966003>
  translate  <8.6737, 4.97474, 21.17778>
}
#declare _Leaf2B5_2B5_1B7_Ref = object {
  _Leaf2B5_2B5_1B7
  rotate <0.0, 64.677162, 31.39068>
  translate  <9.04159, 5.22538, 21.40806>
}
#declare _Leaf2B5_1B1_1B1_Ref = object {
  _Leaf2B5_1B1_1B1
  rotate <0.0, 163.080185, 207.550385>
  translate  <2.25329, 1.26313, 16.2134>
}
#declare _Leaf2B5_1B1_1B2_Ref = object {
  _Leaf2B5_1B1_1B2
  rotate <0.0, 82.145142, 81.881401>
  translate  <2.34517, 1.35473, 16.20455>
}
#declare _Leaf2B5_1B1_1B3_Ref = object {
  _Leaf2B5_1B1_1B3
  rotate <0.0, 93.051918, 329.564148>
  translate  <2.44941, 1.31664, 16.14019>
}
#declare _Leaf2B5_1B1_1B4_Ref = object {
  _Leaf2B5_1B1_1B4
  rotate <0.0, 159.510208, 191.103317>
  translate  <3.01955, 1.64236, 15.52106>
}
#declare _Leaf2B5_1B1_1B5_Ref = object {
  _Leaf2B5_1B1_1B5
  rotate <0.0, 67.642067, 46.285648>
  translate  <3.12308, 1.69404, 15.50352>
}
#declare _Leaf2B5_1B1_1B6_Ref = object {
  _Leaf2B5_1B1_1B6
  rotate <0.0, 130.469742, 304.553772>
  translate  <3.17773, 1.69369, 15.40604>
}
#declare _Leaf2B5_1B1_1B7_Ref = object {
  _Leaf2B5_1B1_1B7
  rotate <0.0, 132.507813, 28.33395>
  translate  <3.50423, 1.89341, 15.08248>
}
#declare _Leaf2B5_1B2_1B1_Ref = object {
  _Leaf2B5_1B2_1B1
  rotate <0.0, 69.187752, 204.551758>
  translate  <1.71906, 1.03418, 17.397>
}
#declare _Leaf2B5_1B2_1B2_Ref = object {
  _Leaf2B5_1B2_1B2
  rotate <0.0, 66.763443, 325.291931>
  translate  <1.79661, 1.03085, 17.50134>
}
#declare _Leaf2B5_1B2_1B3_Ref = object {
  _Leaf2B5_1B2_1B3
  rotate <0.0, 64.633408, 96.954941>
  translate  <1.75604, 1.10527, 17.59766>
}
#declare _Leaf2B5_1B2_1B4_Ref = object {
  _Leaf2B5_1B2_1B4
  rotate <0.0, 71.916077, 210.617859>
  translate  <1.67683, 1.06693, 18.49584>
}
#declare _Leaf2B5_1B2_1B5_Ref = object {
  _Leaf2B5_1B2_1B5
  rotate <0.0, 62.124722, 6.34972>
  translate  <1.72635, 1.09546, 18.59797>
}
#declare _Leaf2B5_1B2_1B6_Ref = object {
  _Leaf2B5_1B2_1B6
  rotate <0.0, 63.239811, 145.88121>
  translate  <1.67134, 1.1008, 18.6951>
}
#declare _Leaf2B5_1B2_1B7_Ref = object {
  _Leaf2B5_1B2_1B7
  rotate <0.0, 4.86438, 193.865356>
  translate  <1.65668, 1.07992, 19.19564>
}
#declare _Leaf2B5_1B3_1B1_Ref = object {
  _Leaf2B5_1B3_1B1
  rotate <0.0, 109.383148, 159.071106>
  translate  <1.81472, 1.80814, 16.89242>
}
#declare _Leaf2B5_1B3_1B2_Ref = object {
  _Leaf2B5_1B3_1B2
  rotate <0.0, 11.42773, 77.205688>
  translate  <1.85013, 1.90125, 16.97602>
}
#declare _Leaf2B5_1B3_1B3_Ref = object {
  _Leaf2B5_1B3_1B3
  rotate <0.0, 122.655243, 48.25745>
  translate  <1.86948, 2.01526, 16.92047>
}
#declare _Leaf2B5_1B3_1B4_Ref = object {
  _Leaf2B5_1B3_1B4
  rotate <0.0, 104.98259, 163.844803>
  translate  <1.68716, 2.88496, 17.07814>
}
#declare _Leaf2B5_1B3_1B5_Ref = object {
  _Leaf2B5_1B3_1B5
  rotate <0.0, 44.80756, 33.855129>
  translate  <1.72895, 2.98576, 17.12044>
}
#declare _Leaf2B5_1B3_1B6_Ref = object {
  _Leaf2B5_1B3_1B6
  rotate <0.0, 140.470901, 103.328972>
  translate  <1.68658, 3.08633, 17.09637>
}
#declare _Leaf2B5_1B3_1B7_Ref = object {
  _Leaf2B5_1B3_1B7
  rotate <0.0, 80.471741, 100.626823>
  translate  <1.60428, 3.56832, 17.20636>
}
#declare _Leaf2B5_1B4_1B1_Ref = object {
  _Leaf2B5_1B4_1B1
  rotate <0.0, 102.883072, 262.3349>
  translate  <2.46817, 0.68615, 16.97482>
}
#declare _Leaf2B5_1B4_1B2_Ref = object {
  _Leaf2B5_1B4_1B2
  rotate <0.0, 117.604759, 20.080931>
  translate  <2.5969, 0.69344, 16.99181>
}
#declare _Leaf2B5_1B4_1B3_Ref = object {
  _Leaf2B5_1B4_1B3
  rotate <0.0, 11.19448, 314.689056>
  translate  <2.63951, 0.62368, 17.09069>
}
#declare _Leaf2B5_1B4_1B4_Ref = object {
  _Leaf2B5_1B4_1B4
  rotate <0.0, 109.208359, 261.944214>
  translate  <3.32669, 0.07129, 17.28336>
}
#declare _Leaf2B5_1B4_1B5_Ref = object {
  _Leaf2B5_1B4_1B5
  rotate <0.0, 81.650307, 29.78208>
  translate  <3.43252, 0.06316, 17.33266>
}
#declare _Leaf2B5_1B4_1B6_Ref = object {
  _Leaf2B5_1B4_1B6
  rotate <0.0, 49.381008, 259.60791>
  translate  <3.479, -0.03281, 17.36612>
}
#declare _Leaf2B5_1B4_1B7_Ref = object {
  _Leaf2B5_1B4_1B7
  rotate <0.0, 76.421883, 321.601074>
  translate  <3.87855, -0.31634, 17.47175>
}
#declare _Leaf2B5_1B5_1B1_Ref = object {
  _Leaf2B5_1B5_1B1
  rotate <0.0, 146.367676, 148.107986>
  translate  <3.49863, 2.51748, 17.42053>
}
#declare _Leaf2B5_1B5_1B2_Ref = object {
  _Leaf2B5_1B5_1B2
  rotate <0.0, 46.548241, 101.019783>
  translate  <3.55066, 2.62871, 17.46334>
}
#declare _Leaf2B5_1B5_1B3_Ref = object {
  _Leaf2B5_1B5_1B3
  rotate <0.0, 112.941208, 1.12842>
  translate  <3.63806, 2.67836, 17.38362>
}
#declare _Leaf2B5_1B5_1B4_Ref = object {
  _Leaf2B5_1B5_1B4
  rotate <0.0, 140.534897, 152.277496>
  translate  <3.8721, 3.48474, 17.05277>
}
#declare _Leaf2B5_1B5_1B5_Ref = object {
  _Leaf2B5_1B5_1B5
  rotate <0.0, 47.916451, 49.603111>
  translate  <3.94457, 3.57593, 17.06418>
}
#declare _Leaf2B5_1B5_1B6_Ref = object {
  _Leaf2B5_1B5_1B6
  rotate <0.0, 156.383728, 8.52812>
  translate  <3.96571, 3.64986, 16.9831>
}
#declare _Leaf2B5_1B5_1B7_Ref = object {
  _Leaf2B5_1B5_1B7
  rotate <0.0, 111.457817, 72.409592>
  translate  <4.10467, 4.10516, 16.82631>
}
#declare _Leaf2B5_1B6_1B1_Ref = object {
  _Leaf2B5_1B6_1B1
  rotate <0.0, 80.385338, 240.002884>
  translate  <3.505, 1.5217, 18.25068>
}
#declare _Leaf2B5_1B6_1B2_Ref = object {
  _Leaf2B5_1B6_1B2
  rotate <0.0, 97.310883, 346.493988>
  translate  <3.61481, 1.50378, 18.31801>
}
#declare _Leaf2B5_1B6_1B3_Ref = object {
  _Leaf2B5_1B6_1B3
  rotate <0.0, 26.16102, 114.404579>
  translate  <3.59609, 1.49269, 18.44445>
}
#declare _Leaf2B5_1B6_1B4_Ref = object {
  _Leaf2B5_1B6_1B4
  rotate <0.0, 86.057007, 242.849243>
  translate  <3.89125, 0.98651, 19.13084>
}
#declare _Leaf2B5_1B6_1B5_Ref = object {
  _Leaf2B5_1B6_1B5
  rotate <0.0, 73.117432, 15.0197>
  translate  <3.96662, 0.98026, 19.22015>
}
#declare _Leaf2B5_1B6_1B6_Ref = object {
  _Leaf2B5_1B6_1B6
  rotate <0.0, 39.868858, 197.474014>
  translate  <3.95525, 0.91108, 19.30719>
}
#declare _Leaf2B5_1B6_1B7_Ref = object {
  _Leaf2B5_1B6_1B7
  rotate <0.0, 39.269199, 300.99707>
  translate  <4.14537, 0.64296, 19.68554>
}
#declare _Leaf2B5_1B7_1B1_Ref = object {
  _Leaf2B5_1B7_1B1
  rotate <0.0, 88.307793, 179.532822>
  translate  <3.14913, 2.39692, 18.28763>
}
#declare _Leaf2B5_1B7_1B2_Ref = object {
  _Leaf2B5_1B7_1B2
  rotate <0.0, 26.34844, 316.697083>
  translate  <3.18056, 2.44287, 18.40516>
}
#declare _Leaf2B5_1B7_1B3_Ref = object {
  _Leaf2B5_1B7_1B3
  rotate <0.0, 97.540009, 83.784271>
  translate  <3.1423, 2.56375, 18.42477>
}
#declare _Leaf2B5_1B7_1B4_Ref = object {
  _Leaf2B5_1B7_1B4
  rotate <0.0, 86.900101, 185.716461>
  translate  <2.7641, 3.05646, 19.07951>
}
#declare _Leaf2B5_1B7_1B5_Ref = object {
  _Leaf2B5_1B7_1B5
  rotate <0.0, 42.840469, 19.084949>
  translate  <2.78421, 3.13086, 19.16758>
}
#declare _Leaf2B5_1B7_1B6_Ref = object {
  _Leaf2B5_1B7_1B6
  rotate <0.0, 104.036598, 127.840912>
  translate  <2.70682, 3.19835, 19.21168>
}
#declare _Leaf2B5_1B7_1B7_Ref = object {
  _Leaf2B5_1B7_1B7
  rotate <0.0, 44.020168, 125.778023>
  translate  <2.52171, 3.46917, 19.5906>
}
#declare _Leaf2B5_1B8_1B1_Ref = object {
  _Leaf2B5_1B8_1B1
  rotate <0.0, 137.997437, 266.17569>
  translate  <4.06021, 1.77357, 17.53097>
}
#declare _Leaf2B5_1B8_1B2_Ref = object {
  _Leaf2B5_1B8_1B2
  rotate <0.0, 110.28363, 58.621159>
  translate  <4.18047, 1.82131, 17.51795>
}
#declare _Leaf2B5_1B8_1B3_Ref = object {
  _Leaf2B5_1B8_1B3
  rotate <0.0, 52.59795, 315.247681>
  translate  <4.27254, 1.73407, 17.53723>
}
#declare _Leaf2B5_1B8_1B4_Ref = object {
  _Leaf2B5_1B8_1B4
  rotate <0.0, 143.273468, 260.631073>
  translate  <5.05977, 1.48815, 17.1708>
}
#declare _Leaf2B5_1B8_1B5_Ref = object {
  _Leaf2B5_1B8_1B5
  rotate <0.0, 77.546127, 40.746578>
  translate  <5.17617, 1.49838, 17.17735>
}
#declare _Leaf2B5_1B8_1B6_Ref = object {
  _Leaf2B5_1B8_1B6
  rotate <0.0, 87.483452, 286.577118>
  translate  <5.24822, 1.42676, 17.13078>
}
#declare _Leaf2B5_1B8_1B7_Ref = object {
  _Leaf2B5_1B8_1B7
  rotate <0.0, 112.652008, 342.527222>
  translate  <5.69673, 1.31561, 16.9367>
}
#declare _Leaf2B5_1B9_1B1_Ref = object {
  _Leaf2B5_1B9_1B1
  rotate <0.0, 162.842087, 216.949295>
  translate  <5.25447, 2.99291, 18.21347>
}
#declare _Leaf2B5_1B9_1B2_Ref = object {
  _Leaf2B5_1B9_1B2
  rotate <0.0, 84.066002, 83.959862>
  translate  <5.3434, 3.08721, 18.20288>
}
#declare _Leaf2B5_1B9_1B3_Ref = object {
  _Leaf2B5_1B9_1B3
  rotate <0.0, 91.148399, 331.442017>
  translate  <5.45002, 3.05039, 18.14174>
}
#declare _Leaf2B5_1B9_1B4_Ref = object {
  _Leaf2B5_1B9_1B4
  rotate <0.0, 159.957794, 199.144958>
  translate  <6.02031, 3.37296, 17.5211>
}
#declare _Leaf2B5_1B9_1B5_Ref = object {
  _Leaf2B5_1B9_1B5
  rotate <0.0, 68.48008, 49.07415>
  translate  <6.12237, 3.42746, 17.50349>
}
#declare _Leaf2B5_1B9_1B6_Ref = object {
  _Leaf2B5_1B9_1B6
  rotate <0.0, 128.197495, 306.182587>
  translate  <6.17878, 3.42549, 17.40704>
}
#declare _Leaf2B5_1B9_1B7_Ref = object {
  _Leaf2B5_1B9_1B7
  rotate <0.0, 132.584824, 28.14826>
  translate  <6.50436, 3.6245, 17.0821>
}
#declare _Leaf2B5_1B10_1B1_Ref = object {
  _Leaf2B5_1B10_1B1
  rotate <0.0, 77.047592, 207.901077>
  translate  <4.63586, 2.71728, 19.38009>
}
#declare _Leaf2B5_1B10_1B2_Ref = object {
  _Leaf2B5_1B10_1B2
  rotate <0.0, 62.928242, 325.413666>
  translate  <4.70029, 2.71152, 19.49291>
}
#declare _Leaf2B5_1B10_1B3_Ref = object {
  _Leaf2B5_1B10_1B3
  rotate <0.0, 62.50444, 104.073547>
  translate  <4.64385, 2.7773, 19.5875>
}
#declare _Leaf2B5_1B10_1B4_Ref = object {
  _Leaf2B5_1B10_1B4
  rotate <0.0, 79.733131, 213.760818>
  translate  <4.45917, 2.67737, 20.46522>
}
#declare _Leaf2B5_1B10_1B5_Ref = object {
  _Leaf2B5_1B10_1B5
  rotate <0.0, 54.689362, 8.12712>
  translate  <4.49411, 2.70196, 20.57417>
}
#declare _Leaf2B5_1B10_1B6_Ref = object {
  _Leaf2B5_1B10_1B6
  rotate <0.0, 67.512283, 152.262436>
  translate  <4.42755, 2.69807, 20.66385>
}
#declare _Leaf2B5_1B10_1B7_Ref = object {
  _Leaf2B5_1B10_1B7
  rotate <0.0, 12.67209, 203.773834>
  translate  <4.3538, 2.64447, 21.15667>
}
#declare _Leaf2B5_1B11_1B1_Ref = object {
  _Leaf2B5_1B11_1B1
  rotate <0.0, 109.025436, 158.083557>
  translate  <4.82537, 3.54139, 18.89835>
}
#declare _Leaf2B5_1B11_1B2_Ref = object {
  _Leaf2B5_1B11_1B2
  rotate <0.0, 11.03219, 74.783279>
  translate  <4.86247, 3.63328, 18.98256>
}
#declare _Leaf2B5_1B11_1B3_Ref = object {
  _Leaf2B5_1B11_1B3
  rotate <0.0, 122.451401, 47.68549>
  translate  <4.88335, 3.74743, 18.92785>
}
#declare _Leaf2B5_1B11_1B4_Ref = object {
  _Leaf2B5_1B11_1B4
  rotate <0.0, 104.65551, 162.879181>
  translate  <4.71474, 4.61848, 19.09311>
}
#declare _Leaf2B5_1B11_1B5_Ref = object {
  _Leaf2B5_1B11_1B5
  rotate <0.0, 44.727661, 32.490601>
  translate  <4.7582, 4.7183, 19.13606>
}
#declare _Leaf2B5_1B11_1B6_Ref = object {
  _Leaf2B5_1B11_1B6
  rotate <0.0, 139.978195, 102.579842>
  translate  <4.71727, 4.81969, 19.11295>
}
#declare _Leaf2B5_1B11_1B7_Ref = object {
  _Leaf2B5_1B11_1B7
  rotate <0.0, 79.984261, 99.741302>
  translate  <4.64265, 5.30197, 19.22708>
}
#declare _Leaf2B5_1B12_1B1_Ref = object {
  _Leaf2B5_1B12_1B1
  rotate <0.0, 102.851624, 257.889374>
  translate  <5.44216, 2.38218, 18.95448>
}
#declare _Leaf2B5_1B12_1B2_Ref = object {
  _Leaf2B5_1B12_1B2
  rotate <0.0, 119.417427, 16.61092>
  translate  <5.5716, 2.38042, 18.96694>
}
#declare _Leaf2B5_1B12_1B3_Ref = object {
  _Leaf2B5_1B12_1B3
  rotate <0.0, 12.85765, 316.276978>
  translate  <5.6127, 2.30721, 19.06395>
}
#declare _Leaf2B5_1B12_1B4_Ref = object {
  _Leaf2B5_1B12_1B4
  rotate <0.0, 109.158653, 257.254944>
  translate  <6.26615, 1.70724, 19.22981>
}
#declare _Leaf2B5_1B12_1B5_Ref = object {
  _Leaf2B5_1B12_1B5
  rotate <0.0, 83.28624, 25.64138>
  translate  <6.37282, 1.69146, 19.2753>
}
#declare _Leaf2B5_1B12_1B6_Ref = object {
  _Leaf2B5_1B12_1B6
  rotate <0.0, 49.291931, 257.380157>
  translate  <6.41367, 1.59229, 19.30668>
}
#declare _Leaf2B5_1B12_1B7_Ref = object {
  _Leaf2B5_1B12_1B7
  rotate <0.0, 78.166321, 317.860535>
  translate  <6.796, 1.28104, 19.39689>
}
#declare _Leaf2B6_2B1_1B1_Ref = object {
  _Leaf2B6_2B1_1B1
  rotate <0.0, 143.571533, 219.781174>
  translate  <-0.45131, 7.69286, 19.3627>
}
#declare _Leaf2B6_2B1_1B2_Ref = object {
  _Leaf2B6_2B1_1B2
  rotate <0.0, 49.653721, 159.162643>
  translate  <-0.528, 7.79343, 19.39296>
}
#declare _Leaf2B6_2B1_1B3_Ref = object {
  _Leaf2B6_2B1_1B3
  rotate <0.0, 118.154282, 62.545181>
  translate  <-0.53133, 7.88431, 19.30246>
}
#declare _Leaf2B6_2B1_1B4_Ref = object {
  _Leaf2B6_2B1_1B4
  rotate <0.0, 137.411896, 222.123535>
  translate  <-1.13894, 8.41484, 18.89771>
}
#declare _Leaf2B6_2B1_1B5_Ref = object {
  _Leaf2B6_2B1_1B5
  rotate <0.0, 54.273281, 111.777451>
  translate  <-1.1879, 8.52113, 18.89628>
}
#declare _Leaf2B6_2B1_1B6_Ref = object {
  _Leaf2B6_2B1_1B6
  rotate <0.0, 161.852188, 62.489239>
  translate  <-1.24274, 8.56384, 18.80877>
}
#declare _Leaf2B6_2B1_1B7_Ref = object {
  _Leaf2B6_2B1_1B7
  rotate <0.0, 116.69706, 137.410385>
  translate  <-1.58334, 8.87278, 18.60945>
}
#declare _Leaf2B6_2B2_1B1_Ref = object {
  _Leaf2B6_2B2_1B1
  rotate <0.0, 80.927261, 300.756958>
  translate  <0.4353, 7.26065, 20.25018>
}
#declare _Leaf2B6_2B2_1B2_Ref = object {
  _Leaf2B6_2B2_1B2
  rotate <0.0, 96.902802, 47.347012>
  translate  <0.50458, 7.34704, 20.31837>
}
#declare _Leaf2B6_2B2_1B3_Ref = object {
  _Leaf2B6_2B2_1B3
  rotate <0.0, 26.067369, 176.417725>
  translate  <0.50523, 7.32397, 20.44457>
}
#declare _Leaf2B6_2B2_1B4_Ref = object {
  _Leaf2B6_2B2_1B4
  rotate <0.0, 86.58506, 303.628174>
  translate  <1.09169, 7.32746, 21.13052>
}
#declare _Leaf2B6_2B2_1B5_Ref = object {
  _Leaf2B6_2B2_1B5
  rotate <0.0, 72.546989, 75.756821>
  translate  <1.134, 7.38925, 21.22045>
}
#declare _Leaf2B6_2B2_1B6_Ref = object {
  _Leaf2B6_2B2_1B6
  rotate <0.0, 40.447552, 258.473114>
  translate  <1.18891, 7.34467, 21.30698>
}
#declare _Leaf2B6_2B2_1B7_Ref = object {
  _Leaf2B6_2B2_1B7
  rotate <0.0, 39.304081, 1.05868>
  translate  <1.51604, 7.37584, 21.68539>
}
#declare _Leaf2B6_2B3_1B1_Ref = object {
  _Leaf2B6_2B3_1B1
  rotate <0.0, 83.144157, 242.418716>
  translate  <-0.49242, 7.41082, 20.29853>
}
#declare _Leaf2B6_2B3_1B2_Ref = object {
  _Leaf2B6_2B3_1B2
  rotate <0.0, 29.16119, 28.84984>
  translate  <-0.51795, 7.47076, 20.41109>
}
#declare _Leaf2B6_2B3_1B3_Ref = object {
  _Leaf2B6_2B3_1B3
  rotate <0.0, 100.038383, 147.588516>
  translate  <-0.64284, 7.49331, 20.42989>
}
#declare _Leaf2B6_2B3_1B4_Ref = object {
  _Leaf2B6_2B3_1B4
  rotate <0.0, 81.548111, 248.606216>
  translate  <-1.24671, 7.44339, 21.09871>
}
#declare _Leaf2B6_2B3_1B5_Ref = object {
  _Leaf2B6_2B3_1B5
  rotate <0.0, 48.385509, 82.28833>
  translate  <-1.30304, 7.5033, 21.18199>
}
#declare _Leaf2B6_2B3_1B6_Ref = object {
  _Leaf2B6_2B3_1B6
  rotate <0.0, 102.362801, 192.120193>
  translate  <-1.3978, 7.46939, 21.23055>
}
#declare _Leaf2B6_2B3_1B7_Ref = object {
  _Leaf2B6_2B3_1B7
  rotate <0.0, 42.86496, 183.078995>
  translate  <-1.71922, 7.46397, 21.61506>
}
#declare _Leaf2B6_2B4_1B1_Ref = object {
  _Leaf2B6_2B4_1B1
  rotate <0.0, 142.283386, 320.828156>
  translate  <0.49951, 7.8421, 19.50433>
}
#declare _Leaf2B6_2B4_1B2_Ref = object {
  _Leaf2B6_2B4_1B2
  rotate <0.0, 107.041061, 115.963531>
  translate  <0.52564, 7.96898, 19.49288>
}
#declare _Leaf2B6_2B4_1B3_Ref = object {
  _Leaf2B6_2B4_1B3
  rotate <0.0, 56.43861, 9.86617>
  translate  <0.65042, 7.99673, 19.5038>
}
#declare _Leaf2B6_2B4_1B4_Ref = object {
  _Leaf2B6_2B4_1B4
  rotate <0.0, 147.392883, 314.303345>
  translate  <1.26382, 8.52569, 19.10579>
}
#declare _Leaf2B6_2B4_1B5_Ref = object {
  _Leaf2B6_2B4_1B5
  rotate <0.0, 75.486923, 96.076027>
  translate  <1.32035, 8.62803, 19.11104>
}
#declare _Leaf2B6_2B4_1B6_Ref = object {
  _Leaf2B6_2B4_1B6
  rotate <0.0, 91.972458, 342.864624>
  translate  <1.41624, 8.6496, 19.05787>
}
#declare _Leaf2B6_2B4_1B7_Ref = object {
  _Leaf2B6_2B4_1B7
  rotate <0.0, 114.87764, 40.53817>
  translate  <1.74279, 8.9666, 18.84797>
}
#declare _Leaf2B6_2B5_1B1_Ref = object {
  _Leaf2B6_2B5_1B1
  rotate <0.0, 128.918365, 86.399544>
  translate  <0.00383, 8.86816, 20.53563>
}
#declare _Leaf2B6_2B5_1B2_Ref = object {
  _Leaf2B6_2B5_1B2
  rotate <0.0, 57.453049, 172.980453>
  translate  <-0.04059, 8.92359, 20.64457>
}
#declare _Leaf2B6_2B5_1B3_Ref = object {
  _Leaf2B6_2B5_1B3
  rotate <0.0, 58.680279, 16.041771>
  translate  <0.03989, 9.01015, 20.69446>
}
#declare _Leaf2B6_2B5_1B4_Ref = object {
  _Leaf2B6_2B5_1B4
  rotate <0.0, 131.906326, 93.742996>
  translate  <0.00492, 9.83113, 21.06761>
}
#declare _Leaf2B6_2B5_1B5_Ref = object {
  _Leaf2B6_2B5_1B5
  rotate <0.0, 20.718781, 182.915024>
  translate  <0.00192, 9.89092, 21.16817>
}
#declare _Leaf2B6_2B5_1B6_Ref = object {
  _Leaf2B6_2B5_1B6
  rotate <0.0, 96.491982, 38.965988>
  translate  <0.0286, 9.99902, 21.17778>
}
#declare _Leaf2B6_2B5_1B7_Ref = object {
  _Leaf2B6_2B5_1B7
  rotate <0.0, 64.677162, 91.390678>
  translate  <-0.00451, 10.44293, 21.40806>
}
#declare _Leaf2B6_1B1_1B1_Ref = object {
  _Leaf2B6_1B1_1B1
  rotate <0.0, 163.080185, 267.550385>
  translate  <0.03275, 2.58297, 16.2134>
}
#declare _Leaf2B6_1B1_1B2_Ref = object {
  _Leaf2B6_1B1_1B2
  rotate <0.0, 82.145142, 141.881393>
  translate  <-0.00065, 2.70835, 16.20455>
}
#declare _Leaf2B6_1B1_1B3_Ref = object {
  _Leaf2B6_1B1_1B3
  rotate <0.0, 93.051918, 29.564159>
  translate  <0.08447, 2.77957, 16.14019>
}
#declare _Leaf2B6_1B1_1B4_Ref = object {
  _Leaf2B6_1B1_1B4
  rotate <0.0, 159.510208, 251.103317>
  translate  <0.08745, 3.43619, 15.52106>
}
#declare _Leaf2B6_1B1_1B5_Ref = object {
  _Leaf2B6_1B1_1B5
  rotate <0.0, 67.642067, 106.285652>
  translate  <0.09446, 3.55169, 15.50352>
}
#declare _Leaf2B6_1B1_1B6_Ref = object {
  _Leaf2B6_1B1_1B6
  rotate <0.0, 130.469742, 4.55376>
  translate  <0.12208, 3.59884, 15.40604>
}
#declare _Leaf2B6_1B1_1B7_Ref = object {
  _Leaf2B6_1B1_1B7
  rotate <0.0, 132.507813, 88.333946>
  translate  <0.11237, 3.98146, 15.08248>
}
#declare _Leaf2B6_1B2_1B1_Ref = object {
  _Leaf2B6_1B2_1B1
  rotate <0.0, 69.187752, 264.551758>
  translate  <-0.03609, 2.00583, 17.397>
}
#declare _Leaf2B6_1B2_1B2_Ref = object {
  _Leaf2B6_1B2_1B2
  rotate <0.0, 66.763443, 25.291941>
  translate  <0.00556, 2.07133, 17.50134>
}
#declare _Leaf2B6_1B2_1B3_Ref = object {
  _Leaf2B6_1B2_1B3
  rotate <0.0, 64.633408, 156.954941>
  translate  <-0.07917, 2.07341, 17.59766>
}
#declare _Leaf2B6_1B2_1B4_Ref = object {
  _Leaf2B6_1B2_1B4
  rotate <0.0, 71.916077, 270.617859>
  translate  <-0.08557, 1.98565, 18.49584>
}
#declare _Leaf2B6_1B2_1B5_Ref = object {
  _Leaf2B6_1B2_1B5
  rotate <0.0, 62.124722, 66.349716>
  translate  <-0.08553, 2.04279, 18.59797>
}
#declare _Leaf2B6_1B2_1B6_Ref = object {
  _Leaf2B6_1B2_1B6
  rotate <0.0, 63.239811, 205.88121>
  translate  <-0.11765, 1.99782, 18.6951>
}
#declare _Leaf2B6_1B2_1B7_Ref = object {
  _Leaf2B6_1B2_1B7
  rotate <0.0, 4.86438, 253.865356>
  translate  <-0.1069, 1.97468, 19.19564>
}
#declare _Leaf2B6_1B3_1B1_Ref = object {
  _Leaf2B6_1B3_1B1
  rotate <0.0, 109.383148, 219.071106>
  translate  <-0.65853, 2.47566, 16.89242>
}
#declare _Leaf2B6_1B3_1B2_Ref = object {
  _Leaf2B6_1B3_1B2
  rotate <0.0, 11.42773, 137.205688>
  translate  <-0.72146, 2.55289, 16.97602>
}
#declare _Leaf2B6_1B3_1B3_Ref = object {
  _Leaf2B6_1B3_1B3
  rotate <0.0, 122.655243, 108.257446>
  translate  <-0.81053, 2.62665, 16.92047>
}
#declare _Leaf2B6_1B3_1B4_Ref = object {
  _Leaf2B6_1B3_1B4
  rotate <0.0, 104.98259, 223.844803>
  translate  <-1.65487, 2.9036, 17.07814>
}
#declare _Leaf2B6_1B3_1B5_Ref = object {
  _Leaf2B6_1B3_1B5
  rotate <0.0, 44.80756, 93.855133>
  translate  <-1.72127, 2.9902, 17.12044>
}
#declare _Leaf2B6_1B3_1B6_Ref = object {
  _Leaf2B6_1B3_1B6
  rotate <0.0, 140.470901, 163.328964>
  translate  <-1.82955, 3.00379, 17.09637>
}
#declare _Leaf2B6_1B3_1B7_Ref = object {
  _Leaf2B6_1B3_1B7
  rotate <0.0, 80.471741, 160.626816>
  translate  <-2.28812, 3.17351, 17.20636>
}
#declare _Leaf2B6_1B4_1B1_Ref = object {
  _Leaf2B6_1B4_1B1
  rotate <0.0, 102.883072, 322.3349>
  translate  <0.63986, 2.48057, 16.97482>
}
#declare _Leaf2B6_1B4_1B2_Ref = object {
  _Leaf2B6_1B4_1B2
  rotate <0.0, 117.604759, 80.080933>
  translate  <0.69791, 2.5957, 16.99181>
}
#declare _Leaf2B6_1B4_1B3_Ref = object {
  _Leaf2B6_1B4_1B3
  rotate <0.0, 11.19448, 14.68907>
  translate  <0.77963, 2.59772, 17.09069>
}
#declare _Leaf2B6_1B4_1B4_Ref = object {
  _Leaf2B6_1B4_1B4
  rotate <0.0, 109.208359, 321.944214>
  translate  <1.60161, 2.91664, 17.28336>
}
#declare _Leaf2B6_1B4_1B5_Ref = object {
  _Leaf2B6_1B4_1B5
  rotate <0.0, 81.650307, 89.782082>
  translate  <1.66157, 3.00423, 17.33266>
}
#declare _Leaf2B6_1B4_1B6_Ref = object {
  _Leaf2B6_1B4_1B6
  rotate <0.0, 49.381008, 319.60791>
  translate  <1.76791, 2.9965, 17.36612>
}
#declare _Leaf2B6_1B4_1B7_Ref = object {
  _Leaf2B6_1B4_1B7
  rotate <0.0, 76.421883, 21.60108>
  translate  <2.21323, 3.20075, 17.47175>
}
#declare _Leaf2B6_1B5_1B1_Ref = object {
  _Leaf2B6_1B5_1B1
  rotate <0.0, 146.367676, 208.107986>
  translate  <-0.43089, 4.28864, 17.42053>
}
#declare _Leaf2B6_1B5_1B2_Ref = object {
  _Leaf2B6_1B5_1B2
  rotate <0.0, 46.548241, 161.019775>
  translate  <-0.5012, 4.38932, 17.46334>
}
#declare _Leaf2B6_1B5_1B3_Ref = object {
  _Leaf2B6_1B5_1B3
  rotate <0.0, 112.941208, 61.128422>
  translate  <-0.5005, 4.48984, 17.38362>
}
#declare _Leaf2B6_1B5_1B4_Ref = object {
  _Leaf2B6_1B5_1B4
  rotate <0.0, 140.534897, 212.277496>
  translate  <-1.08182, 5.09571, 17.05277>
}
#declare _Leaf2B6_1B5_1B5_Ref = object {
  _Leaf2B6_1B5_1B5
  rotate <0.0, 47.916451, 109.603111>
  translate  <-1.12456, 5.20406, 17.06418>
}
#declare _Leaf2B6_1B5_1B6_Ref = object {
  _Leaf2B6_1B5_1B6
  rotate <0.0, 156.383728, 68.528122>
  translate  <-1.17802, 5.25934, 16.9831>
}
#declare _Leaf2B6_1B5_1B7_Ref = object {
  _Leaf2B6_1B5_1B7
  rotate <0.0, 111.457817, 132.409592>
  translate  <-1.50284, 5.60732, 16.82631>
}
#declare _Leaf2B6_1B6_1B1_Ref = object {
  _Leaf2B6_1B6_1B1
  rotate <0.0, 80.385338, 300.002869>
  translate  <0.43467, 3.79627, 18.25068>
}
#declare _Leaf2B6_1B6_1B2_Ref = object {
  _Leaf2B6_1B6_1B2
  rotate <0.0, 97.310883, 46.493992>
  translate  <0.50509, 3.8824, 18.31801>
}
#declare _Leaf2B6_1B6_1B3_Ref = object {
  _Leaf2B6_1B6_1B3
  rotate <0.0, 26.16102, 174.404587>
  translate  <0.50533, 3.86065, 18.44445>
}
#declare _Leaf2B6_1B6_1B4_Ref = object {
  _Leaf2B6_1B6_1B4
  rotate <0.0, 86.057007, 302.849243>
  translate  <1.09128, 3.86318, 19.13084>
}
#declare _Leaf2B6_1B6_1B5_Ref = object {
  _Leaf2B6_1B6_1B5
  rotate <0.0, 73.117432, 75.019699>
  translate  <1.13438, 3.92532, 19.22015>
}
#declare _Leaf2B6_1B6_1B6_Ref = object {
  _Leaf2B6_1B6_1B6
  rotate <0.0, 39.868858, 257.473999>
  translate  <1.1886, 3.88089, 19.30719>
}
#declare _Leaf2B6_1B6_1B7_Ref = object {
  _Leaf2B6_1B6_1B7
  rotate <0.0, 39.269199, 0.99706>
  translate  <1.51586, 3.91147, 19.68554>
}
#declare _Leaf2B6_1B7_1B1_Ref = object {
  _Leaf2B6_1B7_1B1
  rotate <0.0, 88.307793, 239.532822>
  translate  <-0.50123, 3.92569, 18.28763>
}
#declare _Leaf2B6_1B7_1B2_Ref = object {
  _Leaf2B6_1B7_1B2
  rotate <0.0, 26.34844, 16.697069>
  translate  <-0.52531, 3.97588, 18.40516>
}
#declare _Leaf2B6_1B7_1B3_Ref = object {
  _Leaf2B6_1B7_1B3
  rotate <0.0, 97.540009, 143.784271>
  translate  <-0.64912, 4.00318, 18.42477>
}
#declare _Leaf2B6_1B7_1B4_Ref = object {
  _Leaf2B6_1B7_1B4
  rotate <0.0, 86.900101, 245.716461>
  translate  <-1.26492, 3.92201, 19.07951>
}
#declare _Leaf2B6_1B7_1B5_Ref = object {
  _Leaf2B6_1B7_1B5
  rotate <0.0, 42.840469, 79.084953>
  translate  <-1.3193, 3.97663, 19.16758>
}
#declare _Leaf2B6_1B7_1B6_Ref = object {
  _Leaf2B6_1B7_1B6
  rotate <0.0, 104.036598, 187.840912>
  translate  <-1.41644, 3.94335, 19.21168>
}
#declare _Leaf2B6_1B7_1B7_Ref = object {
  _Leaf2B6_1B7_1B7
  rotate <0.0, 44.020168, 185.778015>
  translate  <-1.74353, 3.91845, 19.5906>
}
#declare _Leaf2B6_1B8_1B1_Ref = object {
  _Leaf2B6_1B8_1B1
  rotate <0.0, 137.997437, 326.17569>
  translate  <0.49415, 4.40303, 17.53097>
}
#declare _Leaf2B6_1B8_1B2_Ref = object {
  _Leaf2B6_1B8_1B2
  rotate <0.0, 110.28363, 118.621162>
  translate  <0.51293, 4.53105, 17.51795>
}
#declare _Leaf2B6_1B8_1B3_Ref = object {
  _Leaf2B6_1B8_1B3
  rotate <0.0, 52.59795, 15.24769>
  translate  <0.63452, 4.56717, 17.53723>
}
#declare _Leaf2B6_1B8_1B4_Ref = object {
  _Leaf2B6_1B8_1B4
  rotate <0.0, 143.273468, 320.631073>
  translate  <1.24111, 5.12597, 17.1708>
}
#declare _Leaf2B6_1B8_1B5_Ref = object {
  _Leaf2B6_1B8_1B5
  rotate <0.0, 77.546127, 100.746582>
  translate  <1.29045, 5.23188, 17.17735>
}
#declare _Leaf2B6_1B8_1B6_Ref = object {
  _Leaf2B6_1B8_1B6
  rotate <0.0, 87.483452, 346.577118>
  translate  <1.3885, 5.25847, 17.13078>
}
#declare _Leaf2B6_1B8_1B7_Ref = object {
  _Leaf2B6_1B8_1B7
  rotate <0.0, 112.652008, 42.527222>
  translate  <1.70902, 5.59132, 16.9367>
}
#declare _Leaf2B6_1B9_1B1_Ref = object {
  _Leaf2B6_1B9_1B1
  rotate <0.0, 162.842087, 276.94928>
  translate  <0.0353, 6.04696, 18.21347>
}
#declare _Leaf2B6_1B9_1B2_Ref = object {
  _Leaf2B6_1B9_1B2
  rotate <0.0, 84.066002, 143.959854>
  translate  <-0.0019, 6.17113, 18.20288>
}
#declare _Leaf2B6_1B9_1B3_Ref = object {
  _Leaf2B6_1B9_1B3
  rotate <0.0, 91.148399, 31.44202>
  translate  <0.08329, 6.24505, 18.14174>
}
#declare _Leaf2B6_1B9_1B4_Ref = object {
  _Leaf2B6_1B9_1B4
  rotate <0.0, 159.957794, 259.144958>
  translate  <0.08908, 6.90022, 17.5211>
}
#declare _Leaf2B6_1B9_1B5_Ref = object {
  _Leaf2B6_1B9_1B5
  rotate <0.0, 68.48008, 109.07415>
  translate  <0.09291, 7.01586, 17.50349>
}
#declare _Leaf2B6_1B9_1B6_Ref = object {
  _Leaf2B6_1B9_1B6
  rotate <0.0, 128.197495, 6.18259>
  translate  <0.12283, 7.06373, 17.40704>
}
#declare _Leaf2B6_1B9_1B7_Ref = object {
  _Leaf2B6_1B9_1B7
  rotate <0.0, 132.584824, 88.148262>
  translate  <0.11327, 7.44519, 17.0821>
}
#declare _Leaf2B6_1B10_1B1_Ref = object {
  _Leaf2B6_1B10_1B1
  rotate <0.0, 77.047592, 267.901093>
  translate  <-0.0353, 5.37341, 19.38009>
}
#declare _Leaf2B6_1B10_1B2_Ref = object {
  _Leaf2B6_1B10_1B2
  rotate <0.0, 62.928242, 25.413679>
  translate  <0.0019, 5.42633, 19.49291>
}
#declare _Leaf2B6_1B10_1B3_Ref = object {
  _Leaf2B6_1B10_1B3
  rotate <0.0, 62.50444, 164.073547>
  translate  <-0.08329, 5.41034, 19.5875>
}
#declare _Leaf2B6_1B10_1B4_Ref = object {
  _Leaf2B6_1B10_1B4
  rotate <0.0, 79.733131, 273.760834>
  translate  <-0.08908, 5.20044, 20.46522>
}
#declare _Leaf2B6_1B10_1B5_Ref = object {
  _Leaf2B6_1B10_1B5
  rotate <0.0, 54.689362, 68.127121>
  translate  <-0.09291, 5.243, 20.57417>
}
#declare _Leaf2B6_1B10_1B6_Ref = object {
  _Leaf2B6_1B10_1B6
  rotate <0.0, 67.512283, 212.262436>
  translate  <-0.12283, 5.1834, 20.66385>
}
#declare _Leaf2B6_1B10_1B7_Ref = object {
  _Leaf2B6_1B10_1B7
  rotate <0.0, 12.67209, 263.773834>
  translate  <-0.11327, 5.09274, 21.15667>
}
#declare _Leaf2B6_1B11_1B1_Ref = object {
  _Leaf2B6_1B11_1B1
  rotate <0.0, 109.025436, 218.083557>
  translate  <-0.65425, 5.94958, 18.89835>
}
#declare _Leaf2B6_1B11_1B2_Ref = object {
  _Leaf2B6_1B11_1B2
  rotate <0.0, 11.03219, 134.783279>
  translate  <-0.71527, 6.02767, 18.98256>
}
#declare _Leaf2B6_1B11_1B3_Ref = object {
  _Leaf2B6_1B11_1B3
  rotate <0.0, 122.451401, 107.685493>
  translate  <-0.8037, 6.10282, 18.92785>
}
#declare _Leaf2B6_1B11_1B4_Ref = object {
  _Leaf2B6_1B11_1B4
  rotate <0.0, 104.65551, 222.879181>
  translate  <-1.64235, 6.39233, 19.09311>
}
#declare _Leaf2B6_1B11_1B5_Ref = object {
  _Leaf2B6_1B11_1B5
  rotate <0.0, 44.727661, 92.490601>
  translate  <-1.70707, 6.47987, 19.13606>
}
#declare _Leaf2B6_1B11_1B6_Ref = object {
  _Leaf2B6_1B11_1B6
  rotate <0.0, 139.978195, 162.579834>
  translate  <-1.81534, 6.49512, 19.11295>
}
#declare _Leaf2B6_1B11_1B7_Ref = object {
  _Leaf2B6_1B11_1B7
  rotate <0.0, 79.984261, 159.741302>
  translate  <-2.27031, 6.67164, 19.22708>
}
#declare _Leaf2B6_1B12_1B1_Ref = object {
  _Leaf2B6_1B12_1B1
  rotate <0.0, 102.851624, 317.889374>
  translate  <0.65805, 5.90414, 18.95448>
}
#declare _Leaf2B6_1B12_1B2_Ref = object {
  _Leaf2B6_1B12_1B2
  rotate <0.0, 119.417427, 76.610924>
  translate  <0.72429, 6.01536, 18.96694>
}
#declare _Leaf2B6_1B12_1B3_Ref = object {
  _Leaf2B6_1B12_1B3
  rotate <0.0, 12.85765, 16.276991>
  translate  <0.80825, 6.01434, 19.06395>
}
#declare _Leaf2B6_1B12_1B4_Ref = object {
  _Leaf2B6_1B12_1B4
  rotate <0.0, 109.158653, 317.254944>
  translate  <1.65456, 6.28027, 19.22981>
}
#declare _Leaf2B6_1B12_1B5_Ref = object {
  _Leaf2B6_1B12_1B5
  rotate <0.0, 83.28624, 85.64138>
  translate  <1.72156, 6.36476, 19.2753>
}
#declare _Leaf2B6_1B12_1B6_Ref = object {
  _Leaf2B6_1B12_1B6
  rotate <0.0, 49.291931, 317.380157>
  translate  <1.82787, 6.35054, 19.30668>
}
#declare _Leaf2B6_1B12_1B7_Ref = object {
  _Leaf2B6_1B12_1B7
  rotate <0.0, 78.166321, 17.860519>
  translate  <2.28858, 6.52603, 19.39689>
}
#declare _Leaf2B7_2B1_1B1_Ref = object {
  _Leaf2B7_2B1_1B1
  rotate <0.0, 138.187027, 278.406677>
  translate  <-6.89124, 3.38205, 19.42132>
}
#declare _Leaf2B7_2B1_1B2_Ref = object {
  _Leaf2B7_2B1_1B2
  rotate <0.0, 43.14093, 220.912415>
  translate  <-7.01326, 3.36094, 19.46103>
}
#declare _Leaf2B7_2B1_1B3_Ref = object {
  _Leaf2B7_2B1_1B3
  rotate <0.0, 120.937347, 130.151535>
  translate  <-7.10151, 3.38818, 19.37197>
}
#declare _Leaf2B7_2B1_1B4_Ref = object {
  _Leaf2B7_2B1_1B4
  rotate <0.0, 132.243347, 281.529938>
  translate  <-7.86545, 3.03551, 19.04564>
}
#declare _Leaf2B7_2B1_1B5_Ref = object {
  _Leaf2B7_2B1_1B5
  rotate <0.0, 51.746948, 170.915085>
  translate  <-7.98234, 3.03827, 19.05057>
}
#declare _Leaf2B7_2B1_1B6_Ref = object {
  _Leaf2B7_2B1_1B6
  rotate <0.0, 163.637131, 148.226852>
  translate  <-8.04953, 2.99874, 18.97049>
}
#declare _Leaf2B7_2B1_1B7_Ref = object {
  _Leaf2B7_2B1_1B7
  rotate <0.0, 111.356583, 203.386139>
  translate  <-8.48658, 2.80905, 18.81498>
}
#declare _Leaf2B7_2B2_1B1_Ref = object {
  _Leaf2B7_2B2_1B1
  rotate <0.0, 84.715858, 5.49336>
  translate  <-6.067, 4.07823, 20.19364>
}
#declare _Leaf2B7_2B2_1B2_Ref = object {
  _Leaf2B7_2B2_1B2
  rotate <0.0, 101.379318, 112.203941>
  translate  <-6.11066, 4.1852, 20.25334>
}
#declare _Leaf2B7_2B2_1B3_Ref = object {
  _Leaf2B7_2B2_1B3
  rotate <0.0, 19.1441, 239.88533>
  translate  <-6.08249, 4.1891, 20.37845>
}
#declare _Leaf2B7_2B2_1B4_Ref = object {
  _Leaf2B7_2B2_1B4
  rotate <0.0, 90.630287, 7.76993>
  translate  <-5.79176, 4.78703, 20.98872>
}
#declare _Leaf2B7_2B2_1B5_Ref = object {
  _Leaf2B7_2B2_1B5
  rotate <0.0, 74.136787, 137.741684>
  translate  <-5.82381, 4.86146, 21.07316>
}
#declare _Leaf2B7_2B2_1B6_Ref = object {
  _Leaf2B7_2B2_1B6
  rotate <0.0, 39.790291, 330.678467>
  translate  <-5.75496, 4.90012, 21.15225>
}
#declare _Leaf2B7_2B2_1B7_Ref = object {
  _Leaf2B7_2B2_1B7
  rotate <0.0, 46.222229, 64.687668>
  translate  <-5.61929, 5.24601, 21.4886>
}
#declare _Leaf2B7_2B3_1B1_Ref = object {
  _Leaf2B7_2B3_1B1
  rotate <0.0, 80.200684, 307.342743>
  translate  <-6.60266, 3.32134, 20.35409>
}
#declare _Leaf2B7_2B3_1B2_Ref = object {
  _Leaf2B7_2B3_1B2
  rotate <0.0, 35.27108, 87.644028>
  translate  <-6.66126, 3.33683, 20.46915>
}
#declare _Leaf2B7_2B3_1B3_Ref = object {
  _Leaf2B7_2B3_1B3
  rotate <0.0, 94.049454, 212.024384>
  translate  <-6.73477, 3.23727, 20.50297>
}
#declare _Leaf2B7_2B3_1B4_Ref = object {
  _Leaf2B7_2B3_1B4
  rotate <0.0, 79.30896, 313.717926>
  translate  <-6.91465, 2.74771, 21.23948>
}
#declare _Leaf2B7_2B3_1B5_Ref = object {
  _Leaf2B7_2B3_1B5
  rotate <0.0, 49.435902, 140.312363>
  translate  <-6.98828, 2.73259, 21.32919>
}
#declare _Leaf2B7_2B3_1B6_Ref = object {
  _Leaf2B7_2B3_1B6
  rotate <0.0, 95.640968, 255.859467>
  translate  <-6.99626, 2.63832, 21.38867>
}
#declare _Leaf2B7_2B3_1B7_Ref = object {
  _Leaf2B7_2B3_1B7
  rotate <0.0, 35.969631, 247.890366>
  translate  <-7.10939, 2.39006, 21.80909>
}
#declare _Leaf2B7_2B4_1B1_Ref = object {
  _Leaf2B7_2B4_1B1
  rotate <0.0, 147.571686, 18.43154>
  translate  <-6.60386, 4.31108, 19.44795>
}
#declare _Leaf2B7_2B4_1B2_Ref = object {
  _Leaf2B7_2B4_1B2
  rotate <0.0, 103.700432, 181.639114>
  translate  <-6.70717, 4.38882, 19.43396>
}
#declare _Leaf2B7_2B4_1B3_Ref = object {
  _Leaf2B7_2B4_1B3
  rotate <0.0, 63.227612, 73.069603>
  translate  <-6.67723, 4.5135, 19.42989>
}
#declare _Leaf2B7_2B4_1B4_Ref = object {
  _Leaf2B7_2B4_1B4
  rotate <0.0, 152.034058, 9.45835>
  translate  <-6.9084, 5.25047, 18.96307>
}
#declare _Leaf2B7_2B4_1B5_Ref = object {
  _Leaf2B7_2B4_1B5
  rotate <0.0, 74.622414, 158.244064>
  translate  <-6.9755, 5.34636, 18.96191>
}
#declare _Leaf2B7_2B4_1B6_Ref = object {
  _Leaf2B7_2B4_1B6
  rotate <0.0, 98.656937, 46.70015>
  translate  <-6.95619, 5.43573, 18.89766>
}
#declare _Leaf2B7_2B4_1B7_Ref = object {
  _Leaf2B7_2B4_1B7
  rotate <0.0, 119.882607, 107.028557>
  translate  <-7.11096, 5.8438, 18.65126>
}
#declare _Leaf2B7_2B5_1B1_Ref = object {
  _Leaf2B7_2B5_1B1
  rotate <0.0, 128.773544, 155.990662>
  translate  <-7.68317, 4.42851, 20.53578>
}
#declare _Leaf2B7_2B5_1B2_Ref = object {
  _Leaf2B7_2B5_1B2
  rotate <0.0, 50.555161, 236.524567>
  translate  <-7.74613, 4.42477, 20.64951>
}
#declare _Leaf2B7_2B5_1B3_Ref = object {
  _Leaf2B7_2B5_1B3
  rotate <0.0, 65.287888, 78.93766>
  translate  <-7.7861, 4.53987, 20.6897>
}
#declare _Leaf2B7_2B5_1B4_Ref = object {
  _Leaf2B7_2B5_1B4
  rotate <0.0, 130.847977, 163.788651>
  translate  <-8.51801, 4.90841, 21.06781>
}
#declare _Leaf2B7_2B5_1B5_Ref = object {
  _Leaf2B7_2B5_1B5
  rotate <0.0, 13.82968, 249.291153>
  translate  <-8.56735, 4.94267, 21.16825>
}
#declare _Leaf2B7_2B5_1B6_Ref = object {
  _Leaf2B7_2B5_1B6
  rotate <0.0, 101.695908, 103.704041>
  translate  <-8.65235, 5.0149, 21.17503>
}
#declare _Leaf2B7_2B5_1B7_Ref = object {
  _Leaf2B7_2B5_1B7
  rotate <0.0, 64.465881, 152.099304>
  translate  <-9.05267, 5.20453, 21.40949>
}
#declare _Leaf2B7_1B1_1B1_Ref = object {
  _Leaf2B7_1B1_1B1
  rotate <0.0, 161.705582, 309.993286>
  translate  <-2.26672, 1.23788, 16.21513>
}
#declare _Leaf2B7_1B1_1B2_Ref = object {
  _Leaf2B7_1B1_1B2
  rotate <0.0, 76.57473, 205.111206>
  translate  <-2.39442, 1.26211, 16.2109>
}
#declare _Leaf2B7_1B1_1B3_Ref = object {
  _Leaf2B7_1B1_1B3
  rotate <0.0, 98.943619, 93.952553>
  translate  <-2.42506, 1.36244, 16.13705>
}
#declare _Leaf2B7_1B1_1B4_Ref = object {
  _Leaf2B7_1B1_1B4
  rotate <0.0, 156.58194, 299.432373>
  translate  <-3.04892, 1.58712, 15.52485>
}
#declare _Leaf2B7_1B1_1B5_Ref = object {
  _Leaf2B7_1B1_1B5
  rotate <0.0, 65.630852, 167.423004>
  translate  <-3.15067, 1.64216, 15.50708>
}
#declare _Leaf2B7_1B1_1B6_Ref = object {
  _Leaf2B7_1B1_1B6
  rotate <0.0, 137.345764, 69.367668>
  translate  <-3.18655, 1.6771, 15.40718>
}
#declare _Leaf2B7_1B1_1B7_Ref = object {
  _Leaf2B7_1B1_1B7
  rotate <0.0, 132.085358, 158.640167>
  translate  <-3.55296, 1.80177, 15.08876>
}
#declare _Leaf2B7_1B2_1B1_Ref = object {
  _Leaf2B7_1B2_1B1
  rotate <0.0, 68.931183, 331.209015>
  translate  <-1.71097, 1.04939, 17.39595>
}
#declare _Leaf2B7_1B2_1B2_Ref = object {
  _Leaf2B7_1B2_1B2
  rotate <0.0, 72.952248, 88.152962>
  translate  <-1.74581, 1.1264, 17.49479>
}
#declare _Leaf2B7_1B2_1B3_Ref = object {
  _Leaf2B7_1B2_1B3
  rotate <0.0, 58.197849, 219.559998>
  translate  <-1.77907, 1.06195, 17.60062>
}
#declare _Leaf2B7_1B2_1B4_Ref = object {
  _Leaf2B7_1B2_1B4
  rotate <0.0, 72.367958, 336.852539>
  translate  <-1.65213, 1.1134, 18.49265>
}
#declare _Leaf2B7_1B2_1B5_Ref = object {
  _Leaf2B7_1B2_1B5
  rotate <0.0, 64.861473, 127.175949>
  translate  <-1.69769, 1.14938, 18.59427>
}
#declare _Leaf2B7_1B2_1B6_Ref = object {
  _Leaf2B7_1B2_1B6
  rotate <0.0, 57.16967, 271.801788>
  translate  <-1.66574, 1.11134, 18.69438>
}
#declare _Leaf2B7_1B2_1B7_Ref = object {
  _Leaf2B7_1B2_1B7
  rotate <0.0, 7.42162, 22.46273>
  translate  <-1.61193, 1.16408, 19.18987>
}
#declare _Leaf2B7_1B3_1B1_Ref = object {
  _Leaf2B7_1B3_1B1
  rotate <0.0, 104.104858, 281.723724>
  translate  <-2.43245, 0.64623, 16.97206>
}
#declare _Leaf2B7_1B3_1B2_Ref = object {
  _Leaf2B7_1B3_1B2
  rotate <0.0, 7.64486, 165.344025>
  translate  <-2.52449, 0.63284, 17.06296>
}
#declare _Leaf2B7_1B3_1B3_Ref = object {
  _Leaf2B7_1B3_1B3
  rotate <0.0, 120.032021, 176.173477>
  translate  <-2.63265, 0.57979, 17.01886>
}
#declare _Leaf2B7_1B3_1B4_Ref = object {
  _Leaf2B7_1B3_1B4
  rotate <0.0, 100.106987, 286.752777>
  translate  <-3.23981, -0.03545, 17.27831>
}
#declare _Leaf2B7_1B3_1B5_Ref = object {
  _Leaf2B7_1B3_1B5
  rotate <0.0, 44.522659, 150.844742>
  translate  <-3.34411, -0.05223, 17.32867>
}
#declare _Leaf2B7_1B3_1B6_Ref = object {
  _Leaf2B7_1B3_1B6
  rotate <0.0, 133.742188, 229.111954>
  translate  <-3.40478, -0.14546, 17.31789>
}
#declare _Leaf2B7_1B3_1B7_Ref = object {
  _Leaf2B7_1B3_1B7
  rotate <0.0, 73.868752, 224.15387>
  translate  <-3.7505, -0.46854, 17.48306>
}
#declare _Leaf2B7_1B4_1B1_Ref = object {
  _Leaf2B7_1B4_1B1
  rotate <0.0, 108.472672, 25.189091>
  translate  <-1.86757, 1.81583, 16.89738>
}
#declare _Leaf2B7_1B4_1B2_Ref = object {
  _Leaf2B7_1B4_1B2
  rotate <0.0, 118.340286, 147.748947>
  translate  <-1.94483, 1.91993, 16.90774>
}
#declare _Leaf2B7_1B4_1B3_Ref = object {
  _Leaf2B7_1B4_1B3
  rotate <0.0, 17.93866, 72.432877>
  translate  <-1.90551, 2.00428, 16.99606>
}
#declare _Leaf2B7_1B4_1B4_Ref = object {
  _Leaf2B7_1B4_1B4
  rotate <0.0, 114.751099, 24.268591>
  translate  <-1.82377, 2.89817, 17.0896>
}
#declare _Leaf2B7_1B4_1B5_Ref = object {
  _Leaf2B7_1B4_1B5
  rotate <0.0, 81.496483, 152.759796>
  translate  <-1.87362, 2.99533, 17.13167>
}
#declare _Leaf2B7_1B4_1B6_Ref = object {
  _Leaf2B7_1B4_1B6
  rotate <0.0, 54.933819, 26.838869>
  translate  <-1.81853, 3.09041, 17.15204>
}
#declare _Leaf2B7_1B4_1B7_Ref = object {
  _Leaf2B7_1B4_1B7
  rotate <0.0, 82.782593, 85.101547>
  translate  <-1.80245, 3.58862, 17.20409>
}
#declare _Leaf2B7_1B5_1B1_Ref = object {
  _Leaf2B7_1B5_1B1
  rotate <0.0, 140.241669, 267.752899>
  translate  <-3.93291, 1.70064, 17.47652>
}
#declare _Leaf2B7_1B5_1B2_Ref = object {
  _Leaf2B7_1B5_1B2
  rotate <0.0, 39.963039, 222.731567>
  translate  <-4.05154, 1.68661, 17.52792>
}
#declare _Leaf2B7_1B5_1B3_Ref = object {
  _Leaf2B7_1B5_1B3
  rotate <0.0, 115.921318, 127.978477>
  translate  <-4.14608, 1.72282, 17.44912>
}
#declare _Leaf2B7_1B5_1B4_Ref = object {
  _Leaf2B7_1B5_1B4
  rotate <0.0, 134.671204, 272.227936>
  translate  <-4.96212, 1.43451, 17.1933>
}
#declare _Leaf2B7_1B5_1B5_Ref = object {
  _Leaf2B7_1B5_1B5
  rotate <0.0, 45.710892, 167.432526>
  translate  <-5.07743, 1.4451, 17.21024>
}
#declare _Leaf2B7_1B5_1B6_Ref = object {
  _Leaf2B7_1B5_1B6
  rotate <0.0, 157.768784, 148.661423>
  translate  <-5.15495, 1.413, 17.13642>
}
#declare _Leaf2B7_1B5_1B7_Ref = object {
  _Leaf2B7_1B5_1B7
  rotate <0.0, 106.534813, 198.095291>
  translate  <-5.61782, 1.25904, 17.02139>
}
#declare _Leaf2B7_1B6_1B1_Ref = object {
  _Leaf2B7_1B6_1B1
  rotate <0.0, 84.100632, 4.80537>
  translate  <-3.067, 2.34554, 18.19421>
}
#declare _Leaf2B7_1B6_1B2_Ref = object {
  _Leaf2B7_1B6_1B2
  rotate <0.0, 101.864197, 111.382156>
  translate  <-3.10997, 2.45333, 18.25293>
}
#declare _Leaf2B7_1B6_1B3_Ref = object {
  _Leaf2B7_1B6_1B3
  rotate <0.0, 19.252399, 237.195633>
  translate  <-3.08316, 2.45747, 18.37832>
}
#declare _Leaf2B7_1B6_1B4_Ref = object {
  _Leaf2B7_1B6_1B4
  rotate <0.0, 90.028252, 7.04841>
  translate  <-2.79176, 3.05457, 18.98909>
}
#declare _Leaf2B7_1B6_1B5_Ref = object {
  _Leaf2B7_1B6_1B5
  rotate <0.0, 74.788979, 137.088516>
  translate  <-2.82381, 3.12979, 19.07282>
}
#declare _Leaf2B7_1B6_1B6_Ref = object {
  _Leaf2B7_1B6_1B6
  rotate <0.0, 39.101372, 329.852478>
  translate  <-2.75537, 3.16796, 19.15249>
}
#declare _Leaf2B7_1B6_1B7_Ref = object {
  _Leaf2B7_1B6_1B7
  rotate <0.0, 46.187691, 64.633186>
  translate  <-2.61912, 3.51371, 19.48877>
}
#declare _Leaf2B7_1B7_1B1_Ref = object {
  _Leaf2B7_1B7_1B1
  rotate <0.0, 85.022163, 303.893585>
  translate  <-3.58821, 1.57104, 18.34423>
}
#declare _Leaf2B7_1B7_1B2_Ref = object {
  _Leaf2B7_1B7_1B2
  rotate <0.0, 32.979, 77.156181>
  translate  <-3.63714, 1.58408, 18.46402>
}
#declare _Leaf2B7_1B7_1B3_Ref = object {
  _Leaf2B7_1B7_1B3
  rotate <0.0, 91.79892, 208.106354>
  translate  <-3.71441, 1.48765, 18.49853>
}
#declare _Leaf2B7_1B7_1B4_Ref = object {
  _Leaf2B7_1B7_1B4
  rotate <0.0, 84.298752, 310.216064>
  translate  <-3.87218, 0.97225, 19.22237>
}
#declare _Leaf2B7_1B7_1B5_Ref = object {
  _Leaf2B7_1B7_1B5
  rotate <0.0, 44.340961, 135.972076>
  translate  <-3.93993, 0.95705, 19.31658>
}
#declare _Leaf2B7_1B7_1B6_Ref = object {
  _Leaf2B7_1B7_1B6
  rotate <0.0, 97.209259, 251.62587>
  translate  <-3.94977, 0.86047, 19.37193>
}
#declare _Leaf2B7_1B7_1B7_Ref = object {
  _Leaf2B7_1B7_1B7
  rotate <0.0, 37.166611, 250.960953>
  translate  <-4.04818, 0.598, 19.7874>
}
#declare _Leaf2B7_1B8_1B1_Ref = object {
  _Leaf2B7_1B8_1B1
  rotate <0.0, 143.732376, 25.38611>
  translate  <-3.62718, 2.58806, 17.47514>
}
#declare _Leaf2B7_1B8_1B2_Ref = object {
  _Leaf2B7_1B8_1B2
  rotate <0.0, 106.64933, 184.598526>
  translate  <-3.7348, 2.65958, 17.4605>
}
#declare _Leaf2B7_1B8_1B3_Ref = object {
  _Leaf2B7_1B8_1B3
  rotate <0.0, 59.237831, 77.913513>
  translate  <-3.7133, 2.78597, 17.46513>
}
#declare _Leaf2B7_1B8_1B4_Ref = object {
  _Leaf2B7_1B8_1B4
  rotate <0.0, 148.535828, 17.95006>
  translate  <-3.97245, 3.53331, 17.03061>
}
#declare _Leaf2B7_1B8_1B5_Ref = object {
  _Leaf2B7_1B8_1B5
  rotate <0.0, 76.109467, 163.163513>
  translate  <-4.04582, 3.62449, 17.03162>
}
#declare _Leaf2B7_1B8_1B6_Ref = object {
  _Leaf2B7_1B8_1B6
  rotate <0.0, 94.27317, 50.560928>
  translate  <-4.02971, 3.71868, 16.97368>
}
#declare _Leaf2B7_1B8_1B7_Ref = object {
  _Leaf2B7_1B8_1B7
  rotate <0.0, 117.494614, 108.854149>
  translate  <-4.20044, 4.13, 16.74379>
}
#declare _Leaf2B7_1B9_1B1_Ref = object {
  _Leaf2B7_1B9_1B1
  rotate <0.0, 162.564957, 318.557648>
  translate  <-5.26551, 2.97216, 18.21489>
}
#declare _Leaf2B7_1B9_1B2_Ref = object {
  _Leaf2B7_1B9_1B2
  rotate <0.0, 78.344238, 207.359451>
  translate  <-5.39387, 2.99229, 18.20938>
}
#declare _Leaf2B7_1B9_1B3_Ref = object {
  _Leaf2B7_1B9_1B3
  rotate <0.0, 96.921402, 95.717484>
  translate  <-5.42672, 3.09422, 18.13874>
}
#declare _Leaf2B7_1B9_1B4_Ref = object {
  _Leaf2B7_1B9_1B4
  rotate <0.0, 157.85347, 305.93512>
  translate  <-6.04815, 3.3206, 17.52469>
}
#declare _Leaf2B7_1B9_1B5_Ref = object {
  _Leaf2B7_1B9_1B5
  rotate <0.0, 66.140579, 170.349075>
  translate  <-6.1514, 3.37285, 17.50723>
}
#declare _Leaf2B7_1B9_1B6_Ref = object {
  _Leaf2B7_1B9_1B6
  rotate <0.0, 135.045944, 71.114082>
  translate  <-6.18688, 3.41027, 17.40808>
}
#declare _Leaf2B7_1B9_1B7_Ref = object {
  _Leaf2B7_1B9_1B7
  rotate <0.0, 132.183594, 158.475021>
  translate  <-6.55225, 3.53442, 17.08828>
}
#declare _Leaf2B7_1B10_1B1_Ref = object {
  _Leaf2B7_1B10_1B1
  rotate <0.0, 77.132133, 333.495575>
  translate  <-4.62483, 2.73803, 19.37867>
}
#declare _Leaf2B7_1B10_1B2_Ref = object {
  _Leaf2B7_1B10_1B2
  rotate <0.0, 69.117188, 88.031517>
  translate  <-4.64982, 2.80644, 19.48641>
}
#declare _Leaf2B7_1B10_1B3_Ref = object {
  _Leaf2B7_1B10_1B3
  rotate <0.0, 55.7957, 227.045395>
  translate  <-4.66715, 2.73348, 19.59051>
}
#declare _Leaf2B7_1B10_1B4_Ref = object {
  _Leaf2B7_1B10_1B4
  rotate <0.0, 80.501862, 338.966492>
  translate  <-4.43133, 2.72973, 20.46163>
}
#declare _Leaf2B7_1B10_1B5_Ref = object {
  _Leaf2B7_1B10_1B5
  rotate <0.0, 57.293221, 127.793503>
  translate  <-4.46508, 2.75658, 20.57042>
}
#declare _Leaf2B7_1B10_1B6_Ref = object {
  _Leaf2B7_1B10_1B6
  rotate <0.0, 61.849781, 278.159241>
  translate  <-4.41945, 2.7133, 20.66281>
}
#declare _Leaf2B7_1B10_1B7_Ref = object {
  _Leaf2B7_1B10_1B7
  rotate <0.0, 13.95893, 356.91803>
  translate  <-4.30591, 2.73454, 21.1505>
}
#declare _Leaf2B7_1B11_1B1_Ref = object {
  _Leaf2B7_1B11_1B1
  rotate <0.0, 103.672958, 280.795959>
  translate  <-5.43908, 2.38705, 18.97748>
}
#declare _Leaf2B7_1B11_1B2_Ref = object {
  _Leaf2B7_1B11_1B2
  rotate <0.0, 7.61747, 160.712036>
  translate  <-5.53102, 2.37579, 19.06875>
}
#declare _Leaf2B7_1B11_1B3_Ref = object {
  _Leaf2B7_1B11_1B3
  rotate <0.0, 119.892998, 175.591003>
  translate  <-5.64011, 2.32402, 19.02541>
}
#declare _Leaf2B7_1B11_1B4_Ref = object {
  _Leaf2B7_1B11_1B4
  rotate <0.0, 99.699829, 285.837677>
  translate  <-6.25565, 1.72016, 19.29177>
}
#declare _Leaf2B7_1B11_1B5_Ref = object {
  _Leaf2B7_1B11_1B5
  rotate <0.0, 44.608421, 149.476044>
  translate  <-6.36004, 1.70537, 19.34258>
}
#declare _Leaf2B7_1B11_1B6_Ref = object {
  _Leaf2B7_1B11_1B6
  rotate <0.0, 133.270615, 228.42247>
  translate  <-6.42213, 1.61298, 19.33275>
}
#declare _Leaf2B7_1B11_1B7_Ref = object {
  _Leaf2B7_1B11_1B7
  rotate <0.0, 73.415176, 223.225525>
  translate  <-6.77216, 1.29652, 19.50162>
}
#declare _Leaf2B7_1B12_1B1_Ref = object {
  _Leaf2B7_1B12_1B1
  rotate <0.0, 108.103348, 20.64106>
  translate  <-4.82438, 3.54418, 18.87483>
}
#declare _Leaf2B7_1B12_1B2_Ref = object {
  _Leaf2B7_1B12_1B2
  rotate <0.0, 120.552254, 144.564316>
  translate  <-4.89482, 3.65339, 18.87969>
}
#declare _Leaf2B7_1B12_1B3_Ref = object {
  _Leaf2B7_1B12_1B3
  rotate <0.0, 19.553921, 74.039192>
  translate  <-4.85191, 3.73819, 18.96587>
}
#declare _Leaf2B7_1B12_1B4_Ref = object {
  _Leaf2B7_1B12_1B4
  rotate <0.0, 114.336952, 19.42071>
  translate  <-4.71347, 4.62771, 19.02963>
}
#declare _Leaf2B7_1B12_1B5_Ref = object {
  _Leaf2B7_1B12_1B5
  rotate <0.0, 83.619438, 148.851227>
  translate  <-4.75769, 4.7294, 19.06707>
}
#declare _Leaf2B7_1B12_1B6_Ref = object {
  _Leaf2B7_1B12_1B6
  rotate <0.0, 54.686508, 24.79051>
  translate  <-4.69691, 4.82138, 19.08535>
}
#declare _Leaf2B7_1B12_1B7_Ref = object {
  _Leaf2B7_1B12_1B7
  rotate <0.0, 84.689163, 81.513222>
  translate  <-4.64916, 5.31907, 19.12011>
}
#declare _Leaf2B8_2B1_1B1_Ref = object {
  _Leaf2B8_2B1_1B1
  rotate <0.0, 137.0, 45.0>
  translate  <0.47693, 0.47693, 24.59356>
}
#declare _Leaf2B8_2B1_1B2_Ref = object {
  _Leaf2B8_2B1_1B2
  rotate <0.0, 56.048641, 123.829773>
  translate  <0.49696, 0.55477, 24.69579>
}
#declare _Leaf2B8_2B1_1B3_Ref = object {
  _Leaf2B8_2B1_1B3
  rotate <0.0, 63.791569, 336.058716>
  translate  <0.62043, 0.56458, 24.72924>
}
#declare _Leaf2B8_2B1_1B4_Ref = object {
  _Leaf2B8_2B1_1B4
  rotate <0.0, 139.570724, 53.711681>
  translate  <1.20358, 1.20358, 24.98632>
}
#declare _Leaf2B8_2B1_1B5_Ref = object {
  _Leaf2B8_2B1_1B5
  rotate <0.0, 19.120131, 116.146141>
  translate  <1.25532, 1.25532, 25.07765>
}
#declare _Leaf2B8_2B1_1B6_Ref = object {
  _Leaf2B8_2B1_1B6
  rotate <0.0, 103.64402, 354.486053>
  translate  <1.34946, 1.31517, 25.07088>
}
#declare _Leaf2B8_2B1_1B7_Ref = object {
  _Leaf2B8_2B1_1B7
  rotate <0.0, 72.60482, 46.571369>
  translate  <1.65828, 1.67242, 25.23877>
}
#declare _Leaf2B8_2B2_1B1_Ref = object {
  _Leaf2B8_2B2_1B1
  rotate <0.0, 131.0, 225.0>
  translate  <-0.46001, -0.46001, 24.663>
}
#declare _Leaf2B8_2B2_1B2_Ref = object {
  _Leaf2B8_2B2_1B2
  rotate <0.0, 55.094341, 307.894806>
  translate  <-0.47222, -0.53002, 24.77191>
}
#declare _Leaf2B8_2B2_1B3_Ref = object {
  _Leaf2B8_2B2_1B3
  rotate <0.0, 61.776199, 153.148895>
  translate  <-0.59285, -0.537, 24.81503>
}
#declare _Leaf2B8_2B2_1B4_Ref = object {
  _Leaf2B8_2B2_1B4
  rotate <0.0, 133.632614, 232.799713>
  translate  <-1.15365, -1.15365, 25.16103>
}
#declare _Leaf2B8_2B2_1B5_Ref = object {
  _Leaf2B8_2B2_1B5
  rotate <0.0, 18.061871, 313.797302>
  translate  <-1.19836, -1.19836, 25.25951>
}
#declare _Leaf2B8_2B2_1B6_Ref = object {
  _Leaf2B8_2B2_1B6
  rotate <0.0, 99.788033, 175.440613>
  translate  <-1.29257, -1.25828, 25.26416>
}
#declare _Leaf2B8_2B2_1B7_Ref = object {
  _Leaf2B8_2B2_1B7
  rotate <0.0, 66.607162, 226.633804>
  translate  <-1.58716, -1.6013, 25.48036>
}
#declare _Leaf2B8_2B3_1B1_Ref = object {
  _Leaf2B8_2B3_1B1
  rotate <0.0, 134.622406, 142.769394>
  translate  <-0.4754, 0.46818, 24.81723>
}
#declare _Leaf2B8_2B3_1B2_Ref = object {
  _Leaf2B8_2B3_1B2
  rotate <0.0, 50.190182, 216.751587>
  translate  <-0.54415, 0.49014, 24.92541>
}
#declare _Leaf2B8_2B3_1B3_Ref = object {
  _Leaf2B8_2B3_1B3
  rotate <0.0, 68.288948, 66.478973>
  translate  <-0.55569, 0.6146, 24.95434>
}
#declare _Leaf2B8_2B3_1B4_Ref = object {
  _Leaf2B8_2B3_1B4
  rotate <0.0, 136.394485, 151.455887>
  translate  <-1.19064, 1.18603, 25.24552>
}
#declare _Leaf2B8_2B3_1B5_Ref = object {
  _Leaf2B8_2B3_1B5
  rotate <0.0, 13.17747, 209.108658>
  translate  <-1.23569, 1.24006, 25.33905>
}
#declare _Leaf2B8_2B3_1B6_Ref = object {
  _Leaf2B8_2B3_1B6
  rotate <0.0, 106.538979, 88.040787>
  translate  <-1.29958, 1.33161, 25.33395>
}
#declare _Leaf2B8_2B3_1B7_Ref = object {
  _Leaf2B8_2B3_1B7
  rotate <0.0, 70.437462, 136.870865>
  translate  <-1.65164, 1.63502, 25.52151>
}
#declare _Leaf2B8_2B4_1B1_Ref = object {
  _Leaf2B8_2B4_1B1
  rotate <0.0, 136.900497, 319.043152>
  translate  <0.47872, -0.4751, 24.79362>
}
#declare _Leaf2B8_2B4_1B2_Ref = object {
  _Leaf2B8_2B4_1B2
  rotate <0.0, 53.279919, 34.479912>
  translate  <0.55334, -0.49736, 24.89777>
}
#declare _Leaf2B8_2B4_1B3_Ref = object {
  _Leaf2B8_2B4_1B3
  rotate <0.0, 66.417526, 246.608932>
  translate  <0.56428, -0.62174, 24.92727>
}
#declare _Leaf2B8_2B4_1B4_Ref = object {
  _Leaf2B8_2B4_1B4
  rotate <0.0, 139.040497, 327.958649>
  translate  <1.20472, -1.20241, 25.18636>
}
#declare _Leaf2B8_2B4_1B5_Ref = object {
  _Leaf2B8_2B4_1B5
  rotate <0.0, 16.46731, 24.19165>
  translate  <1.25424, -1.25643, 25.27762>
}
#declare _Leaf2B8_2B4_1B6_Ref = object {
  _Leaf2B8_2B4_1B6
  rotate <0.0, 105.796173, 265.990814>
  translate  <1.31601, -1.34922, 25.26971>
}
#declare _Leaf2B8_2B4_1B7_Ref = object {
  _Leaf2B8_2B4_1B7
  rotate <0.0, 72.524033, 316.712463>
  translate  <1.67292, -1.65751, 25.43929>
}
#declare _Leaf2B8_2B5_1B1_Ref = object {
  _Leaf2B8_2B5_1B1
  rotate 69.0*y
  translate  <0.0732, 0.0, 26.19787>
}
#declare _Leaf2B8_2B5_1B2_Ref = object {
  _Leaf2B8_2B5_1B2
  rotate <0.0, 69.009743, 119.350403>
  translate  <0.00433, 0.04088, 26.30034>
}
#declare _Leaf2B8_2B5_1B3_Ref = object {
  _Leaf2B8_2B5_1B3
  rotate <0.0, 62.331879, 250.974518>
  translate  <0.00862, -0.03949, 26.40025>
}
#declare _Leaf2B8_2B5_1B4_Ref = object {
  _Leaf2B8_2B5_1B4
  rotate <0.0, 71.989182, 5.92841>
  translate  <0.094, 0.0, 27.29781>
}
#declare _Leaf2B8_2B5_1B5_Ref = object {
  _Leaf2B8_2B5_1B5
  rotate <0.0, 63.122589, 159.664566>
  translate  <0.03673, 0.0, 27.39988>
}
#declare _Leaf2B8_2B5_1B6_Ref = object {
  _Leaf2B8_2B5_1B6
  rotate <0.0, 61.014809, 300.974915>
  translate  <0.08379, -0.02425, 27.49829>
}
#declare _Leaf2B8_2B5_1B7_Ref = object {
  _Leaf2B8_2B5_1B7
  rotate <0.0, 4.83646, 18.08157>
  translate  <0.10456, 0.01, 27.99787>
}
#declare _Leaf2B8_1B1_1B1_Ref = object {
  _Leaf2B8_1B1_1B1
  rotate <0.0, 136.900497, 4.04314>
  translate  <0.67445, 0.00255, 20.59362>
}
#declare _Leaf2B8_1B1_1B2_Ref = object {
  _Leaf2B8_1B1_1B2
  rotate <0.0, 53.279919, 79.479912>
  translate  <0.74296, 0.03959, 20.69777>
}
#declare _Leaf2B8_1B1_1B3_Ref = object {
  _Leaf2B8_1B1_1B3
  rotate <0.0, 66.417526, 291.608917>
  translate  <0.83864, -0.04063, 20.72727>
}
#declare _Leaf2B8_1B1_1B4_Ref = object {
  _Leaf2B8_1B1_1B4
  rotate <0.0, 139.040497, 12.95866>
  translate  <1.7021, 0.00163, 20.98636>
}
#declare _Leaf2B8_1B1_1B5_Ref = object {
  _Leaf2B8_1B1_1B5
  rotate <0.0, 16.46731, 69.19165>
  translate  <1.77531, -0.00155, 21.07762>
}
#declare _Leaf2B8_1B1_1B6_Ref = object {
  _Leaf2B8_1B1_1B6
  rotate <0.0, 105.796173, 310.990814>
  translate  <1.8846, -0.02348, 21.06971>
}
#declare _Leaf2B8_1B1_1B7_Ref = object {
  _Leaf2B8_1B1_1B7
  rotate <0.0, 72.524033, 1.71246>
  translate  <2.35497, 0.01089, 21.23929>
}
#declare _Leaf2B8_1B2_1B1_Ref = object {
  _Leaf2B8_1B2_1B1
  rotate <0.0, 132.909775, 93.771362>
  translate  <-0.00255, 0.6593, 20.6402>
}
#declare _Leaf2B8_1B2_1B2_Ref = object {
  _Leaf2B8_1B2_1B2
  rotate <0.0, 52.651718, 172.462021>
  translate  <-0.03959, 0.72038, 20.74887>
}
#declare _Leaf2B8_1B2_1B3_Ref = object {
  _Leaf2B8_1B2_1B3
  rotate <0.0, 64.998756, 19.920071>
  translate  <0.04063, 0.81377, 20.78498>
}
#declare _Leaf2B8_1B2_1B4_Ref = object {
  _Leaf2B8_1B2_1B4
  rotate <0.0, 135.134995, 102.027512>
  translate  <-0.00163, 1.65705, 21.10366>
}
#declare _Leaf2B8_1B2_1B5_Ref = object {
  _Leaf2B8_1B2_1B5
  rotate <0.0, 15.4915, 172.781876>
  translate  <0.00155, 1.72371, 21.1998>
}
#declare _Leaf2B8_1B2_1B6_Ref = object {
  _Leaf2B8_1B2_1B6
  rotate <0.0, 103.15139, 41.7659>
  translate  <0.02348, 1.83329, 21.19954>
}
#declare _Leaf2B8_1B2_1B7_Ref = object {
  _Leaf2B8_1B2_1B7
  rotate <0.0, 68.525864, 91.755272>
  translate  <-0.01089, 2.29069, 21.40152>
}
#declare _Leaf2B8_1B3_1B1_Ref = object {
  _Leaf2B8_1B3_1B1
  rotate <0.0, 128.917923, 176.450058>
  translate  <-0.64094, 0.00255, 20.8856>
}
#declare _Leaf2B8_1B3_1B2_Ref = object {
  _Leaf2B8_1B3_1B2
  rotate <0.0, 57.50375, 263.074188>
  translate  <-0.6963, -0.04206, 20.9945>
}
#declare _Leaf2B8_1B3_1B3_Ref = object {
  _Leaf2B8_1B3_1B3
  rotate <0.0, 58.63229, 106.143494>
  translate  <-0.78299, 0.03824, 21.04445>
}
#declare _Leaf2B8_1B3_1B4_Ref = object {
  _Leaf2B8_1B3_1B4
  rotate <0.0, 131.912384, 183.789261>
  translate  <-1.60393, 0.00163, 21.41754>
}
#declare _Leaf2B8_1B3_1B5_Ref = object {
  _Leaf2B8_1B3_1B5
  rotate <0.0, 20.76931, 272.992432>
  translate  <-1.66372, -0.00155, 21.5181>
}
#declare _Leaf2B8_1B3_1B6_Ref = object {
  _Leaf2B8_1B3_1B6
  rotate <0.0, 96.454277, 129.053665>
  translate  <-1.77186, 0.02495, 21.52772>
}
#declare _Leaf2B8_1B3_1B7_Ref = object {
  _Leaf2B8_1B3_1B7
  rotate <0.0, 64.681183, 181.506195>
  translate  <-2.21574, -0.00908, 21.75794>
}
#declare _Leaf2B8_1B4_1B1_Ref = object {
  _Leaf2B8_1B4_1B1
  rotate <0.0, 128.854187, 265.270325>
  translate  <-0.0034, -0.64092, 20.88565>
}
#declare _Leaf2B8_1B4_1B2_Ref = object {
  _Leaf2B8_1B4_1B2
  rotate <0.0, 58.379879, 352.673309>
  translate  <0.04242, -0.69664, 20.99385>
}
#declare _Leaf2B8_1B4_1B3_Ref = object {
  _Leaf2B8_1B4_1B3
  rotate <0.0, 57.783482, 195.824722>
  translate  <-0.0378, -0.78268, 21.04504>
}
#declare _Leaf2B8_1B4_1B4_Ref = object {
  _Leaf2B8_1B4_1B4
  rotate <0.0, 131.961044, 272.52771>
  translate  <-0.00218, -1.60392, 21.41757>
}
#declare _Leaf2B8_1B4_1B5_Ref = object {
  _Leaf2B8_1B4_1B5
  rotate <0.0, 21.65127, 2.41562>
  translate  <0.00206, -1.66374, 21.51807>
}
#declare _Leaf2B8_1B4_1B6_Ref = object {
  _Leaf2B8_1B4_1B6
  rotate <0.0, 95.76606, 218.524963>
  translate  <-0.02517, -1.77166, 21.52811>
}
#declare _Leaf2B8_1B4_1B7_Ref = object {
  _Leaf2B8_1B4_1B7
  rotate <0.0, 64.703987, 271.454071>
  translate  <0.00877, -2.21581, 21.75781>
}
#declare _Leaf2B8_1B5_1B1_Ref = object {
  _Leaf2B8_1B5_1B1
  rotate 137.0*y
  translate  <0.67448, 0.0, 22.62433>
}
#declare _Leaf2B8_1B5_1B2_Ref = object {
  _Leaf2B8_1B5_1B2
  rotate <0.0, 56.048641, 78.829773>
  translate  <0.74368, 0.04088, 22.72656>
}
#declare _Leaf2B8_1B5_1B3_Ref = object {
  _Leaf2B8_1B5_1B3
  rotate <0.0, 63.791569, 291.058716>
  translate  <0.83793, -0.03949, 22.76001>
}
#declare _Leaf2B8_1B5_1B4_Ref = object {
  _Leaf2B8_1B5_1B4
  rotate <0.0, 139.570724, 8.71168>
  translate  <1.70212, 0.0, 23.01709>
}
#declare _Leaf2B8_1B5_1B5_Ref = object {
  _Leaf2B8_1B5_1B5
  rotate <0.0, 19.120131, 71.146141>
  translate  <1.77529, 0.0, 23.10842>
}
#declare _Leaf2B8_1B5_1B6_Ref = object {
  _Leaf2B8_1B5_1B6
  rotate <0.0, 103.64402, 309.486053>
  translate  <1.88417, -0.02425, 23.10165>
}
#declare _Leaf2B8_1B5_1B7_Ref = object {
  _Leaf2B8_1B5_1B7
  rotate <0.0, 72.60482, 1.57137>
  translate  <2.35516, 0.01, 23.26954>
}
#declare _Leaf2B8_1B6_1B1_Ref = object {
  _Leaf2B8_1B6_1B1
  rotate <0.0, 137.0, 180.0>
  translate  <-0.67448, 0.0, 22.62433>
}
#declare _Leaf2B8_1B6_1B2_Ref = object {
  _Leaf2B8_1B6_1B2
  rotate <0.0, 56.048641, 258.829773>
  translate  <-0.74368, -0.04088, 22.72656>
}
#declare _Leaf2B8_1B6_1B3_Ref = object {
  _Leaf2B8_1B6_1B3
  rotate <0.0, 63.791569, 111.058723>
  translate  <-0.83793, 0.03949, 22.76001>
}
#declare _Leaf2B8_1B6_1B4_Ref = object {
  _Leaf2B8_1B6_1B4
  rotate <0.0, 139.570724, 188.711685>
  translate  <-1.70212, 0.0, 23.01709>
}
#declare _Leaf2B8_1B6_1B5_Ref = object {
  _Leaf2B8_1B6_1B5
  rotate <0.0, 19.120131, 251.146133>
  translate  <-1.77529, 0.0, 23.10842>
}
#declare _Leaf2B8_1B6_1B6_Ref = object {
  _Leaf2B8_1B6_1B6
  rotate <0.0, 103.64402, 129.486038>
  translate  <-1.88417, 0.02425, 23.10165>
}
#declare _Leaf2B8_1B6_1B7_Ref = object {
  _Leaf2B8_1B6_1B7
  rotate <0.0, 72.60482, 181.571365>
  translate  <-2.35516, -0.01, 23.26954>
}
#declare _Leaf2B8_1B7_1B1_Ref = object {
  _Leaf2B8_1B7_1B1
  rotate <0.0, 131.911911, 93.711746>
  translate  <-0.00255, 0.65501, 22.8209>
}
#declare _Leaf2B8_1B7_1B2_Ref = object {
  _Leaf2B8_1B7_1B2
  rotate <0.0, 52.527088, 173.220932>
  translate  <-0.03959, 0.71418, 22.93062>
}
#declare _Leaf2B8_1B7_1B3_Ref = object {
  _Leaf2B8_1B7_1B3
  rotate <0.0, 64.661682, 19.47764>
  translate  <0.04063, 0.80693, 22.96835>
}
#declare _Leaf2B8_1B7_1B4_Ref = object {
  _Leaf2B8_1B7_1B4
  rotate <0.0, 134.15657, 101.82341>
  translate  <-0.00163, 1.64452, 23.30171>
}
#declare _Leaf2B8_1B7_1B5_Ref = object {
  _Leaf2B8_1B7_1B5
  rotate <0.0, 15.39707, 176.385956>
  translate  <0.00155, 1.70949, 23.399>
}
#declare _Leaf2B8_1B7_1B6_Ref = object {
  _Leaf2B8_1B7_1B6
  rotate <0.0, 102.484192, 41.935379>
  translate  <0.02348, 1.81906, 23.40065>
}
#declare _Leaf2B8_1B7_1B7_Ref = object {
  _Leaf2B8_1B7_1B7
  rotate <0.0, 67.526329, 91.767677>
  translate  <-0.01089, 2.27286, 23.61057>
}
#declare _Leaf2B8_1B8_1B1_Ref = object {
  _Leaf2B8_1B8_1B1
  rotate <0.0, 132.640167, 262.484222>
  translate  <-0.0051, -0.65922, 22.80961>
}
#declare _Leaf2B8_1B8_1B2_Ref = object {
  _Leaf2B8_1B8_1B2
  rotate <0.0, 60.772671, 349.636322>
  translate  <0.04312, -0.72303, 22.91216>
}
#declare _Leaf2B8_1B8_1B3_Ref = object {
  _Leaf2B8_1B8_1B3
  rotate <0.0, 57.21571, 197.719162>
  translate  <-0.03689, -0.81129, 22.95978>
}
#declare _Leaf2B8_1B8_1B4_Ref = object {
  _Leaf2B8_1B8_1B4
  rotate <0.0, 136.0, 270.0>
  translate  <-0.00326, -1.657, 23.27301>
}
#declare _Leaf2B8_1B8_1B5_Ref = object {
  _Leaf2B8_1B8_1B5
  rotate <0.0, 23.644159, 352.152374>
  translate  <0.00309, -1.72376, 23.36892>
}
#declare _Leaf2B8_1B8_1B6_Ref = object {
  _Leaf2B8_1B8_1B6
  rotate <0.0, 96.801086, 217.178177>
  translate  <-0.02558, -1.83172, 23.3723>
}
#declare _Leaf2B8_1B8_1B7_Ref = object {
  _Leaf2B8_1B8_1B7
  rotate <0.0, 68.746101, 271.308777>
  translate  <0.00813, -2.2913, 23.56938>
}
#declare _Leaf2B9_2B1_1B1_Ref = object {
  _Leaf2B9_2B1_1B1
  rotate <0.0, 151.106995, 159.183243>
  translate  <2.879, 4.13317, 22.43292>
}
#declare _Leaf2B9_2B1_1B2_Ref = object {
  _Leaf2B9_2B1_1B2
  rotate <0.0, 45.931839, 132.45784>
  translate  <2.87766, 4.25088, 22.48819>
}
#declare _Leaf2B9_2B1_1B3_Ref = object {
  _Leaf2B9_2B1_1B3
  rotate <0.0, 104.671371, 25.15287>
  translate  <2.94659, 4.33821, 22.42429>
}
#declare _Leaf2B9_2B1_1B4_Ref = object {
  _Leaf2B9_2B1_1B4
  rotate <0.0, 145.95813, 166.282883>
  translate  <2.87787, 5.20159, 22.17064>
}
#declare _Leaf2B9_2B1_1B5_Ref = object {
  _Leaf2B9_2B1_1B5
  rotate <0.0, 40.611542, 77.561462>
  translate  <2.90659, 5.31199, 22.19677>
}
#declare _Leaf2B9_2B1_1B6_Ref = object {
  _Leaf2B9_2B1_1B6
  rotate <0.0, 147.819916, 34.32732>
  translate  <2.90566, 5.39619, 22.1233>
}
#declare _Leaf2B9_2B1_1B7_Ref = object {
  _Leaf2B9_2B1_1B7
  rotate <0.0, 106.110046, 93.205681>
  translate  <2.86973, 5.88324, 22.01072>
}
#declare _Leaf2B9_2B2_1B1_Ref = object {
  _Leaf2B9_2B2_1B1
  rotate <0.0, 93.859894, 260.407562>
  translate  <3.14219, 3.0675, 23.1783>
}
#declare _Leaf2B9_2B2_1B2_Ref = object {
  _Leaf2B9_2B2_1B2
  rotate <0.0, 85.820351, 7.58941>
  translate  <3.23755, 3.07337, 23.26653>
}
#declare _Leaf2B9_2B2_1B3_Ref = object {
  _Leaf2B9_2B2_1B3
  rotate <0.0, 28.98151, 165.156754>
  translate  <3.20273, 3.03086, 23.38245>
}
#declare _Leaf2B9_2B2_1B4_Ref = object {
  _Leaf2B9_2B2_1B4
  rotate <0.0, 99.066803, 264.042816>
  translate  <3.54003, 2.52047, 24.04594>
}
#declare _Leaf2B9_2B2_1B5_Ref = object {
  _Leaf2B9_2B2_1B5
  rotate <0.0, 58.060879, 33.94363>
  translate  <3.59584, 2.52117, 24.1488>
}
#declare _Leaf2B9_2B2_1B6_Ref = object {
  _Leaf2B9_2B2_1B6
  rotate <0.0, 55.21162, 220.917725>
  translate  <3.59583, 2.43573, 24.22084>
}
#declare _Leaf2B9_2B2_1B7_Ref = object {
  _Leaf2B9_2B2_1B7
  rotate <0.0, 41.369949, 303.386322>
  translate  <3.80283, 2.17349, 24.59442>
}
#declare _Leaf2B9_2B3_1B1_Ref = object {
  _Leaf2B9_2B3_1B1
  rotate <0.0, 96.457199, 202.442993>
  translate  <2.5167, 3.76536, 23.26388>
}
#declare _Leaf2B9_2B3_1B2_Ref = object {
  _Leaf2B9_2B3_1B2
  rotate <0.0, 25.26424, 320.146179>
  translate  <2.51563, 3.8038, 23.38811>
}
#declare _Leaf2B9_2B3_1B3_Ref = object {
  _Leaf2B9_2B3_1B3
  rotate <0.0, 91.820381, 106.275452>
  translate  <2.43084, 3.89704, 23.41211>
}
#declare _Leaf2B9_2B3_1B4_Ref = object {
  _Leaf2B9_2B3_1B4
  rotate <0.0, 95.531754, 208.746033>
  translate  <1.82598, 4.11566, 24.04522>
}
#declare _Leaf2B9_2B3_1B5_Ref = object {
  _Leaf2B9_2B3_1B5
  rotate <0.0, 33.567299, 39.54615>
  translate  <1.80618, 4.17969, 24.14116>
}
#declare _Leaf2B9_2B3_1B6_Ref = object {
  _Leaf2B9_2B3_1B6
  rotate <0.0, 105.063431, 148.497726>
  translate  <1.70445, 4.20588, 24.17929>
}
#declare _Leaf2B9_2B3_1B7_Ref = object {
  _Leaf2B9_2B3_1B7
  rotate <0.0, 45.691051, 158.326157>
  translate  <1.3909, 4.33223, 24.54929>
}
#declare _Leaf2B9_2B4_1B1_Ref = object {
  _Leaf2B9_2B4_1B1
  rotate <0.0, 149.780502, 300.439545>
  translate  <3.67646, 3.60434, 22.60836>
}
#declare _Leaf2B9_2B4_1B2_Ref = object {
  _Leaf2B9_2B4_1B2
  rotate <0.0, 93.473717, 74.793427>
  translate  <3.77717, 3.6837, 22.63013>
}
#declare _Leaf2B9_2B4_1B3_Ref = object {
  _Leaf2B9_2B4_1B3
  rotate <0.0, 55.183651, 319.639496>
  translate  <3.88817, 3.62186, 22.64787>
}
#declare _Leaf2B9_2B4_1B4_Ref = object {
  _Leaf2B9_2B4_1B4
  rotate <0.0, 155.992859, 297.684906>
  translate  <4.7527, 3.69789, 22.40032>
}
#declare _Leaf2B9_2B4_1B5_Ref = object {
  _Leaf2B9_2B4_1B5
  rotate <0.0, 60.579552, 56.75602>
  translate  <4.85867, 3.73624, 22.43188>
}
#declare _Leaf2B9_2B4_1B6_Ref = object {
  _Leaf2B9_2B4_1B6
  rotate <0.0, 96.284019, 303.908051>
  translate  <4.95437, 3.7011, 22.38611>
}
#declare _Leaf2B9_2B4_1B7_Ref = object {
  _Leaf2B9_2B4_1B7
  rotate <0.0, 104.698723, 4.53838>
  translate  <5.43626, 3.76738, 22.2654>
}
#declare _Leaf2B9_2B5_1B1_Ref = object {
  _Leaf2B9_2B5_1B1
  rotate <0.0, 113.943268, 46.935501>
  translate  <3.76225, 4.47772, 23.87008>
}
#declare _Leaf2B9_2B5_1B2_Ref = object {
  _Leaf2B9_2B5_1B2
  rotate <0.0, 56.884998, 142.719284>
  translate  <3.74451, 4.52568, 23.98965>
}
#declare _Leaf2B9_2B5_1B3_Ref = object {
  _Leaf2B9_2B5_1B3
  rotate <0.0, 55.722591, 326.496277>
  translate  <3.85161, 4.52811, 24.06024>
}
#declare _Leaf2B9_2B5_1B4_Ref = object {
  _Leaf2B9_2B5_1B4
  rotate <0.0, 116.932732, 53.123909>
  translate  <4.27247, 5.08408, 24.63317>
}
#declare _Leaf2B9_2B5_1B5_Ref = object {
  _Leaf2B9_2B5_1B5
  rotate <0.0, 25.999081, 176.291275>
  translate  <4.29057, 5.11031, 24.74578>
}
#declare _Leaf2B9_2B5_1B6_Ref = object {
  _Leaf2B9_2B5_1B6
  rotate <0.0, 86.99028, 359.321655>
  translate  <4.37652, 5.17124, 24.78304>
}
#declare _Leaf2B9_2B5_1B7_Ref = object {
  _Leaf2B9_2B5_1B7
  rotate <0.0, 49.682331, 51.64872>
  translate  <4.58847, 5.47534, 25.12036>
}
#declare _Leaf2B9_1B1_1B1_Ref = object {
  _Leaf2B9_1B1_1B1
  rotate <0.0, 177.965866, 209.485474>
  translate  <1.51013, 1.74876, 19.48262>
}
#declare _Leaf2B9_1B1_1B2_Ref = object {
  _Leaf2B9_1B1_1B2
  rotate <0.0, 73.125572, 104.529991>
  translate  <1.56386, 1.86475, 19.50652>
}
#declare _Leaf2B9_1B1_1B3_Ref = object {
  _Leaf2B9_1B1_1B3
  rotate <0.0, 85.635971, 349.413788>
  translate  <1.68399, 1.8755, 19.46278>
}
#declare _Leaf2B9_1B1_1B4_Ref = object {
  _Leaf2B9_1B1_1B4
  rotate <0.0, 172.108749, 174.338974>
  translate  <2.19697, 2.48219, 19.03469>
}
#declare _Leaf2B9_1B1_1B5_Ref = object {
  _Leaf2B9_1B1_1B5
  rotate <0.0, 53.33123, 68.864578>
  translate  <2.27696, 2.56663, 19.04765>
}
#declare _Leaf2B9_1B1_1B6_Ref = object {
  _Leaf2B9_1B1_1B6
  rotate <0.0, 127.683434, 336.617584>
  translate  <2.34362, 2.60309, 18.96569>
}
#declare _Leaf2B9_1B1_1B7_Ref = object {
  _Leaf2B9_1B1_1B7
  rotate <0.0, 117.513023, 48.615261>
  translate  <2.62757, 2.9566, 18.75219>
}
#declare _Leaf2B9_1B2_1B1_Ref = object {
  _Leaf2B9_1B2_1B1
  rotate <0.0, 118.324097, 173.698883>
  translate  <0.71008, 1.87073, 19.9693>
}
#declare _Leaf2B9_1B2_1B2_Ref = object {
  _Leaf2B9_1B2_1B2
  rotate <0.0, 11.00368, 180.385101>
  translate  <0.69591, 1.95175, 20.07004>
}
#declare _Leaf2B9_1B2_1B3_Ref = object {
  _Leaf2B9_1B2_1B3
  rotate <0.0, 108.316063, 66.131508>
  translate  <0.68272, 2.0746, 20.03547>
}
#declare _Leaf2B9_1B2_1B4_Ref = object {
  _Leaf2B9_1B2_1B4
  rotate <0.0, 115.01828, 179.750305>
  translate  <0.18165, 2.791, 20.25945>
}
#declare _Leaf2B9_1B2_1B5_Ref = object {
  _Leaf2B9_1B2_1B5
  rotate <0.0, 29.855089, 55.461712>
  translate  <0.17751, 2.88937, 20.32272>
}
#declare _Leaf2B9_1B2_1B6_Ref = object {
  _Leaf2B9_1B2_1B6
  rotate <0.0, 134.247787, 108.339149>
  translate  <0.107, 2.9738, 20.30299>
}
#declare _Leaf2B9_1B2_1B7_Ref = object {
  _Leaf2B9_1B2_1B7
  rotate <0.0, 75.843903, 123.637871>
  translate  <-0.1572, 3.37234, 20.45316>
}
#declare _Leaf2B9_1B3_1B1_Ref = object {
  _Leaf2B9_1B3_1B1
  rotate <0.0, 84.124802, 224.881271>
  translate  <0.99305, 1.23963, 20.61793>
}
#declare _Leaf2B9_1B3_1B2_Ref = object {
  _Leaf2B9_1B3_1B2
  rotate <0.0, 61.138691, 338.444458>
  translate  <1.04827, 1.24063, 20.73567>
}
#declare _Leaf2B9_1B3_1B3_Ref = object {
  _Leaf2B9_1B3_1B3
  rotate <0.0, 59.644859, 124.487762>
  translate  <0.96863, 1.27753, 20.82924>
}
#declare _Leaf2B9_1B3_1B4_Ref = object {
  _Leaf2B9_1B3_1B4
  rotate <0.0, 86.91526, 230.588196>
  translate  <0.7598, 1.03863, 21.6741>
}
#declare _Leaf2B9_1B3_1B5_Ref = object {
  _Leaf2B9_1B3_1B5
  rotate <0.0, 48.609379, 21.79225>
  translate  <0.77833, 1.06063, 21.78754>
}
#declare _Leaf2B9_1B3_1B6_Ref = object {
  _Leaf2B9_1B3_1B6
  rotate <0.0, 70.485909, 171.537445>
  translate  <0.70965, 1.02875, 21.86973>
}
#declare _Leaf2B9_1B3_1B7_Ref = object {
  _Leaf2B9_1B3_1B7
  rotate <0.0, 19.7181, 225.994965>
  translate  <0.62024, 0.90548, 22.34722>
}
#declare _Leaf2B9_1B4_1B1_Ref = object {
  _Leaf2B9_1B4_1B1
  rotate <0.0, 111.686867, 286.14505>
  translate  <1.78495, 1.13178, 20.19158>
}
#declare _Leaf2B9_1B4_1B2_Ref = object {
  _Leaf2B9_1B4_1B2
  rotate <0.0, 102.806122, 40.993759>
  translate  <1.89808, 1.17628, 20.23779>
}
#declare _Leaf2B9_1B4_1B3_Ref = object {
  _Leaf2B9_1B4_1B3
  rotate <0.0, 16.200899, 272.305542>
  translate  <1.94548, 1.10565, 20.33383>
}
#declare _Leaf2B9_1B4_1B4_Ref = object {
  _Leaf2B9_1B4_1B4
  rotate <0.0, 117.934082, 287.313263>
  translate  <2.74111, 0.77507, 20.60248>
}
#declare _Leaf2B9_1B4_1B5_Ref = object {
  _Leaf2B9_1B4_1B5
  rotate <0.0, 66.650429, 49.76516>
  translate  <2.83322, 0.79157, 20.67276>
}
#declare _Leaf2B9_1B4_1B6_Ref = object {
  _Leaf2B9_1B4_1B6
  rotate <0.0, 59.898392, 271.931244>
  translate  <2.90433, 0.71086, 20.70308>
}
#declare _Leaf2B9_1B4_1B7_Ref = object {
  _Leaf2B9_1B4_1B7
  rotate <0.0, 71.37394, 337.496216>
  translate  <3.3547, 0.5548, 20.85798>
}
#declare _Leaf2B9_1B5_1B1_Ref = object {
  _Leaf2B9_1B5_1B1
  rotate <0.0, 177.111984, 275.106659>
  translate  <2.43503, 2.84704, 20.91862>
}
#declare _Leaf2B9_1B5_1B2_Ref = object {
  _Leaf2B9_1B5_1B2
  rotate <0.0, 75.444313, 106.195648>
  translate  <2.48539, 2.96492, 20.94053>
}
#declare _Leaf2B9_1B5_1B3_Ref = object {
  _Leaf2B9_1B5_1B3
  rotate <0.0, 83.360443, 350.822754>
  translate  <2.60671, 2.97698, 20.90061>
}
#declare _Leaf2B9_1B5_1B4_Ref = object {
  _Leaf2B9_1B5_1B4
  rotate <0.0, 174.011627, 191.782715>
  translate  <3.12119, 3.5811, 20.47069>
}
#declare _Leaf2B9_1B5_1B5_Ref = object {
  _Leaf2B9_1B5_1B5
  rotate <0.0, 54.41692, 71.950897>
  translate  <3.19885, 3.6677, 20.4836>
}
#declare _Leaf2B9_1B5_1B6_Ref = object {
  _Leaf2B9_1B5_1B6
  rotate <0.0, 125.127487, 337.196259>
  translate  <3.26753, 3.70301, 20.40283>
}
#declare _Leaf2B9_1B5_1B7_Ref = object {
  _Leaf2B9_1B5_1B7
  rotate <0.0, 117.591263, 48.461739>
  translate  <3.55112, 4.05584, 20.1877>
}
#declare _Leaf2B9_1B6_1B1_Ref = object {
  _Leaf2B9_1B6_1B1
  rotate <0.0, 92.037888, 227.953217>
  translate  <1.76866, 2.16273, 21.87117>
}
#declare _Leaf2B9_1B6_1B2_Ref = object {
  _Leaf2B9_1B6_1B2
  rotate <0.0, 57.418301, 337.353088>
  translate  <1.81124, 2.1556, 21.99384>
}
#declare _Leaf2B9_1B6_1B3_Ref = object {
  _Leaf2B9_1B6_1B3
  rotate <0.0, 59.406261, 132.280655>
  translate  <1.72032, 2.17978, 22.08107>
}
#declare _Leaf2B9_1B6_1B4_Ref = object {
  _Leaf2B9_1B6_1B4
  rotate <0.0, 94.701599, 233.713013>
  translate  <1.43954, 1.85416, 22.87455>
}
#declare _Leaf2B9_1B6_1B5_Ref = object {
  _Leaf2B9_1B6_1B5
  rotate <0.0, 41.034531, 22.41469>
  translate  <1.4449, 1.86651, 22.9908>
}
#declare _Leaf2B9_1B6_1B6_Ref = object {
  _Leaf2B9_1B6_1B6
  rotate <0.0, 76.007156, 176.369781>
  translate  <1.37007, 1.82387, 23.062>
}
#declare _Leaf2B9_1B6_1B7_Ref = object {
  _Leaf2B9_1B6_1B7
  rotate <0.0, 27.630739, 227.059433>
  translate  <1.2391, 1.65293, 23.51456>
}
#declare _Leaf2B9_1B7_1B1_Ref = object {
  _Leaf2B9_1B7_1B1
  rotate <0.0, 117.762123, 172.763275>
  translate  <1.70443, 3.04909, 21.51145>
}
#declare _Leaf2B9_1B7_1B2_Ref = object {
  _Leaf2B9_1B7_1B2
  rotate <0.0, 10.50815, 182.342484>
  translate  <1.69215, 3.1294, 21.613>
}
#declare _Leaf2B9_1B7_1B3_Ref = object {
  _Leaf2B9_1B7_1B3
  rotate <0.0, 108.072411, 65.643883>
  translate  <1.68018, 3.25269, 21.5796>
}
#declare _Leaf2B9_1B7_1B4_Ref = object {
  _Leaf2B9_1B7_1B4
  rotate <0.0, 114.50486, 178.819244>
  translate  <1.18999, 3.97322, 21.81417>
}
#declare _Leaf2B9_1B7_1B5_Ref = object {
  _Leaf2B9_1B7_1B5
  rotate <0.0, 29.74754, 53.533581>
  translate  <1.18763, 4.07109, 21.87831>
}
#declare _Leaf2B9_1B7_1B6_Ref = object {
  _Leaf2B9_1B7_1B6
  rotate <0.0, 133.620377, 107.949249>
  translate  <1.118, 4.15654, 21.85993>
}
#declare _Leaf2B9_1B7_1B7_Ref = object {
  _Leaf2B9_1B7_1B7
  rotate <0.0, 75.152611, 122.892097>
  translate  <0.86008, 4.55698, 22.01586>
}
#declare _Leaf2B9_1B8_1B1_Ref = object {
  _Leaf2B9_1B8_1B1
  rotate <0.0, 112.585091, 281.567566>
  translate  <2.67216, 2.16081, 21.55391>
}
#declare _Leaf2B9_1B8_1B2_Ref = object {
  _Leaf2B9_1B8_1B2
  rotate <0.0, 104.780228, 37.959179>
  translate  <2.78989, 2.19805, 21.59473>
}
#declare _Leaf2B9_1B8_1B3_Ref = object {
  _Leaf2B9_1B8_1B3
  rotate <0.0, 16.694731, 278.037292>
  translate  <2.83743, 2.1241, 21.68817>
}
#declare _Leaf2B9_1B8_1B4_Ref = object {
  _Leaf2B9_1B8_1B4
  rotate <0.0, 118.877769, 282.393188>
  translate  <3.62326, 1.74399, 21.91721>
}
#declare _Leaf2B9_1B8_1B5_Ref = object {
  _Leaf2B9_1B8_1B5
  rotate <0.0, 68.332077, 45.341499>
  translate  <3.71947, 1.75442, 21.98301>
}
#declare _Leaf2B9_1B8_1B6_Ref = object {
  _Leaf2B9_1B8_1B6
  rotate <0.0, 60.18959, 270.007294>
  translate  <3.78686, 1.66934, 22.00964>
}
#declare _Leaf2B9_1B8_1B7_Ref = object {
  _Leaf2B9_1B8_1B7
  rotate <0.0, 73.991692, 334.266602>
  translate  <4.23373, 1.48517, 22.1422>
}
#declare _Leaf2B10_2B1_1B1_Ref = object {
  _Leaf2B10_2B1_1B1
  rotate <0.0, 145.804703, 251.629822>
  translate  <-4.13852, 2.79816, 22.48079>
}
#declare _Leaf2B10_2B1_1B2_Ref = object {
  _Leaf2B10_2B1_1B2
  rotate <0.0, 40.298481, 227.595276>
  translate  <-4.252, 2.78987, 22.54376>
}
#declare _Leaf2B10_2B1_1B3_Ref = object {
  _Leaf2B10_2B1_1B3
  rotate <0.0, 106.724739, 122.296471>
  translate  <-4.34948, 2.84486, 22.48105>
}
#declare _Leaf2B10_2B1_1B4_Ref = object {
  _Leaf2B10_2B1_1B4
  rotate <0.0, 140.932877, 258.436035>
  translate  <-5.21509, 2.67386, 22.29143>
}
#declare _Leaf2B10_2B1_1B5_Ref = object {
  _Leaf2B10_2B1_1B5
  rotate <0.0, 38.01088, 167.079544>
  translate  <-5.32608, 2.69382, 22.32275>
}
#declare _Leaf2B10_2B1_1B6_Ref = object {
  _Leaf2B10_2B1_1B6
  rotate <0.0, 148.640976, 139.040207>
  translate  <-5.41398, 2.67904, 22.25534>
}
#declare _Leaf2B10_2B1_1B7_Ref = object {
  _Leaf2B10_2B1_1B7
  rotate <0.0, 102.005028, 189.842133>
  translate  <-5.90076, 2.58778, 22.17854>
}
#declare _Leaf2B10_2B2_1B1_Ref = object {
  _Leaf2B10_2B2_1B1
  rotate <0.0, 96.94252, 355.620331>
  translate  <-3.06234, 3.22016, 23.13214>
}
#declare _Leaf2B10_2B2_1B2_Ref = object {
  _Leaf2B10_2B2_1B2
  rotate <0.0, 89.43177, 103.070267>
  translate  <-3.07253, 3.32115, 23.21343>
}
#declare _Leaf2B10_2B2_1B3_Ref = object {
  _Leaf2B10_2B2_1B3
  rotate <0.0, 24.122061, 266.635864>
  translate  <-3.0199, 3.29978, 23.32847>
}
#declare _Leaf2B10_2B2_1B4_Ref = object {
  _Leaf2B10_2B2_1B4
  rotate <0.0, 102.427467, 358.840149>
  translate  <-2.50753, 3.73557, 23.93016>
}
#declare _Leaf2B10_2B2_1B5_Ref = object {
  _Leaf2B10_2B2_1B5
  rotate <0.0, 59.514919, 126.290718>
  translate  <-2.50773, 3.79897, 24.02854>
}
#declare _Leaf2B10_2B2_1B6_Ref = object {
  _Leaf2B10_2B2_1B6
  rotate <0.0, 54.789478, 320.531433>
  translate  <-2.41859, 3.81281, 24.0945>
}
#declare _Leaf2B10_2B2_1B7_Ref = object {
  _Leaf2B10_2B2_1B7
  rotate <0.0, 46.877491, 40.372341>
  translate  <-2.15678, 4.07272, 24.43375>
}
#declare _Leaf2B10_2B3_1B1_Ref = object {
  _Leaf2B10_2B3_1B1
  rotate <0.0, 94.069221, 297.631836>
  translate  <-3.68725, 2.53922, 23.30924>
}
#declare _Leaf2B10_2B3_1B2_Ref = object {
  _Leaf2B10_2B3_1B2
  rotate <0.0, 30.91247, 55.303532>
  translate  <-3.71793, 2.54422, 23.43552>
}
#declare _Leaf2B10_2B3_1B3_Ref = object {
  _Leaf2B10_2B3_1B3
  rotate <0.0, 86.967827, 201.906158>
  translate  <-3.80055, 2.45301, 23.47177>
}
#declare _Leaf2B10_2B3_1B4_Ref = object {
  _Leaf2B10_2B3_1B4
  rotate <0.0, 93.723083, 303.97348>
  translate  <-3.919, 1.88154, 24.16016>
}
#declare _Leaf2B10_2B3_1B5_Ref = object {
  _Leaf2B10_2B3_1B5
  rotate <0.0, 34.718971, 127.029419>
  translate  <-3.97488, 1.86328, 24.26135>
}
#declare _Leaf2B10_2B3_1B6_Ref = object {
  _Leaf2B10_2B3_1B6
  rotate <0.0, 99.516548, 243.919525>
  translate  <-3.98837, 1.76281, 24.3084>
}
#declare _Leaf2B10_2B3_1B7_Ref = object {
  _Leaf2B10_2B3_1B7
  rotate <0.0, 40.457951, 256.285126>
  translate  <-4.06022, 1.4686, 24.70772>
}
#declare _Leaf2B10_2B4_1B1_Ref = object {
  _Leaf2B10_2B4_1B1
  rotate <0.0, 155.147324, 32.665771>
  translate  <-3.68328, 3.65402, 22.56232>
}
#declare _Leaf2B10_2B4_1B2_Ref = object {
  _Leaf2B10_2B4_1B2
  rotate <0.0, 90.841949, 170.643646>
  translate  <-3.77094, 3.74803, 22.58203>
}
#declare _Leaf2B10_2B4_1B3_Ref = object {
  _Leaf2B10_2B4_1B3
  rotate <0.0, 60.833271, 55.153149>
  translate  <-3.71966, 3.8655, 22.58752>
}
#declare _Leaf2B10_2B4_1B4_Ref = object {
  _Leaf2B10_2B4_1B4
  rotate <0.0, 161.234161, 27.88023>
  translate  <-3.89706, 4.69662, 22.28379>
}
#declare _Leaf2B10_2B4_1B5_Ref = object {
  _Leaf2B10_2B4_1B5
  rotate <0.0, 59.79353, 149.205673>
  translate  <-3.94395, 4.80057, 22.31012>
}
#declare _Leaf2B10_2B4_1B6_Ref = object {
  _Leaf2B10_2B4_1B6
  rotate <0.0, 101.785683, 39.361488>
  translate  <-3.92142, 4.89531, 22.25529>
}
#declare _Leaf2B10_2B4_1B7_Ref = object {
  _Leaf2B10_2B4_1B7
  rotate <0.0, 108.484596, 101.452843>
  translate  <-4.04301, 5.35765, 22.10479>
}
#declare _Leaf2B10_2B5_1B1_Ref = object {
  _Leaf2B10_2B5_1B1
  rotate <0.0, 113.842552, 145.103699>
  translate  <-4.48418, 3.75435, 23.87021>
}
#declare _Leaf2B10_2B5_1B2_Ref = object {
  _Leaf2B10_2B5_1B2
  rotate <0.0, 51.258869, 238.792007>
  translate  <-4.52291, 3.74152, 23.99369>
}
#declare _Leaf2B10_2B5_1B3_Ref = object {
  _Leaf2B10_2B5_1B3
  rotate <0.0, 61.306862, 61.612289>
  translate  <-4.53192, 3.85311, 24.05636>
}
#declare _Leaf2B10_2B5_1B4_Ref = object {
  _Leaf2B10_2B5_1B4
  rotate <0.0, 116.207741, 151.592545>
  translate  <-5.09239, 4.26232, 24.63333>
}
#declare _Leaf2B10_2B5_1B5_Ref = object {
  _Leaf2B10_2B5_1B5
  rotate <0.0, 21.88472, 280.736969>
  translate  <-5.11356, 4.2866, 24.74584>
}
#declare _Leaf2B10_2B5_1B6_Ref = object {
  _Leaf2B10_2B5_1B6
  rotate <0.0, 91.18589, 94.922691>
  translate  <-5.18052, 4.36897, 24.78079>
}
#declare _Leaf2B10_2B5_1B7_Ref = object {
  _Leaf2B10_2B5_1B7
  rotate <0.0, 49.477699, 142.492188>
  translate  <-5.48381, 4.57656, 25.12153>
}
#declare _Leaf2B10_1B1_1B1_Ref = object {
  _Leaf2B10_1B1_1B1
  rotate <0.0, 173.435898, 250.038055>
  translate  <-1.80814, 1.43716, 19.48403>
}
#declare _Leaf2B10_1B1_1B2_Ref = object {
  _Leaf2B10_1B1_1B2
  rotate <0.0, 68.391586, 199.110397>
  translate  <-1.92733, 1.48122, 19.5117>
}
#declare _Leaf2B10_1B1_1B3_Ref = object {
  _Leaf2B10_1B1_1B3
  rotate <0.0, 90.42231, 84.971489>
  translate  <-1.95272, 1.59595, 19.46021>
}
#declare _Leaf2B10_1B1_1B4_Ref = object {
  _Leaf2B10_1B1_1B4
  rotate <0.0, 167.143692, 254.718842>
  translate  <-2.63244, 2.0131, 19.03779>
}
#declare _Leaf2B10_1B1_1B5_Ref = object {
  _Leaf2B10_1B1_1B5
  rotate <0.0, 51.42799, 160.417572>
  translate  <-2.72359, 2.08539, 19.05055>
}
#declare _Leaf2B10_1B1_1B6_Ref = object {
  _Leaf2B10_1B1_1B6
  rotate <0.0, 132.988495, 73.944794>
  translate  <-2.77139, 2.1416, 18.96662>
}
#declare _Leaf2B10_1B1_1B7_Ref = object {
  _Leaf2B10_1B1_1B7
  rotate <0.0, 117.225731, 147.20285>
  translate  <-3.16381, 2.37265, 18.75732>
}
#declare _Leaf2B10_1B2_1B1_Ref = object {
  _Leaf2B10_1B2_1B1
  rotate <0.0, 113.73172, 267.746735>
  translate  <-1.81966, 0.66978, 20.03433>
}
#declare _Leaf2B10_1B2_1B2_Ref = object {
  _Leaf2B10_1B2_1B2
  rotate <0.0, 7.88544, 305.132202>
  translate  <-1.8927, 0.65586, 20.14103>
}
#declare _Leaf2B10_1B2_1B3_Ref = object {
  _Leaf2B10_1B2_1B3
  rotate <0.0, 106.399582, 163.457397>
  translate  <-2.01543, 0.62826, 20.11581>
}
#declare _Leaf2B10_1B2_1B4_Ref = object {
  _Leaf2B10_1B2_1B4
  rotate <0.0, 110.79998, 273.818115>
  translate  <-2.66306, 0.07986, 20.42289>
}
#declare _Leaf2B10_1B2_1B5_Ref = object {
  _Leaf2B10_1B2_1B5
  rotate <0.0, 29.52495, 141.201996>
  translate  <-2.75657, 0.07127, 20.49274>
}
#declare _Leaf2B10_1B2_1B6_Ref = object {
  _Leaf2B10_1B2_1B6
  rotate <0.0, 129.237427, 206.344788>
  translate  <-2.83448, -0.00835, 20.48386>
}
#declare _Leaf2B10_1B2_1B7_Ref = object {
  _Leaf2B10_1B2_1B7
  rotate <0.0, 70.350769, 218.891006>
  translate  <-3.19471, -0.29698, 20.67908>
}
#declare _Leaf2B10_1B3_1B1_Ref = object {
  _Leaf2B10_1B3_1B1
  rotate <0.0, 83.928078, 321.134521>
  translate  <-1.1828, 1.06209, 20.61708>
}
#declare _Leaf2B10_1B3_1B2_Ref = object {
  _Leaf2B10_1B3_1B2
  rotate <0.0, 66.426117, 73.117149>
  translate  <-1.18236, 1.12603, 20.73032>
}
#declare _Leaf2B10_1B3_1B3_Ref = object {
  _Leaf2B10_1B3_1B3
  rotate <0.0, 54.137081, 219.312775>
  translate  <-1.20541, 1.05081, 20.83166>
}
#declare _Leaf2B10_1B3_1B4_Ref = object {
  _Leaf2B10_1B3_1B4
  rotate <0.0, 87.266891, 326.536652>
  translate  <-0.8968, 0.93287, 21.6715>
}
#declare _Leaf2B10_1B3_1B5_Ref = object {
  _Leaf2B10_1B3_1B5
  rotate <0.0, 51.222931, 113.227768>
  translate  <-0.91377, 0.95805, 21.78453>
}
#declare _Leaf2B10_1B3_1B6_Ref = object {
  _Leaf2B10_1B3_1B6
  rotate <0.0, 65.853477, 268.499817>
  translate  <-0.87029, 0.89941, 21.86914>
}
#declare _Leaf2B10_1B3_1B7_Ref = object {
  _Leaf2B10_1B3_1B7
  rotate <0.0, 20.369949, 337.113159>
  translate  <-0.71043, 0.86002, 22.34251>
}
#declare _Leaf2B10_1B4_1B1_Ref = object {
  _Leaf2B10_1B4_1B1
  rotate <0.0, 116.499809, 20.4771>
  translate  <-1.18091, 1.82476, 20.12836>
}
#declare _Leaf2B10_1B4_1B2_Ref = object {
  _Leaf2B10_1B4_1B2
  rotate <0.0, 103.350647, 137.963821>
  translate  <-1.23376, 1.93636, 20.16915>
}
#declare _Leaf2B10_1B4_1B3_Ref = object {
  _Leaf2B10_1B4_1B3
  rotate <0.0, 20.588261, 18.795891>
  translate  <-1.16267, 1.99773, 20.25656>
}
#declare _Leaf2B10_1B4_1B4_Ref = object {
  _Leaf2B10_1B4_1B4
  rotate <0.0, 122.797592, 21.281719>
  translate  <-0.89858, 2.84005, 20.44427>
}
#declare _Leaf2B10_1B4_1B5_Ref = object {
  _Leaf2B10_1B4_1B5
  rotate <0.0, 66.51503, 142.976166>
  translate  <-0.92006, 2.93538, 20.50866>
}
#declare _Leaf2B10_1B4_1B6_Ref = object {
  _Leaf2B10_1B4_1B6
  rotate <0.0, 63.955441, 9.69652>
  translate  <-0.84527, 3.01606, 20.52829>
}
#declare _Leaf2B10_1B4_1B7_Ref = object {
  _Leaf2B10_1B4_1B7
  rotate <0.0, 76.686378, 72.60244>
  translate  <-0.72647, 3.49011, 20.63944>
}
#declare _Leaf2B10_1B5_1B1_Ref = object {
  _Leaf2B10_1B5_1B1
  rotate <0.0, 175.993179, 261.716492>
  translate  <-2.90663, 2.36221, 20.91978>
}
#declare _Leaf2B10_1B5_1B2_Ref = object {
  _Leaf2B10_1B5_1B2
  rotate <0.0, 70.617867, 200.956787>
  translate  <-3.02747, 2.40258, 20.94584>
}
#declare _Leaf2B10_1B5_1B3_Ref = object {
  _Leaf2B10_1B5_1B3
  rotate <0.0, 88.07489, 86.250076>
  translate  <-3.05406, 2.51868, 20.89816>
}
#declare _Leaf2B10_1B5_1B4_Ref = object {
  _Leaf2B10_1B5_1B4
  rotate <0.0, 169.657135, 261.107819>
  translate  <-3.73148, 2.93742, 20.47362>
}
#declare _Leaf2B10_1B5_1B5_Ref = object {
  _Leaf2B10_1B5_1B5
  rotate <0.0, 52.219391, 163.726685>
  translate  <-3.82453, 3.00718, 20.48666>
}
#declare _Leaf2B10_1B5_1B6_Ref = object {
  _Leaf2B10_1B5_1B6
  rotate <0.0, 130.414337, 74.415329>
  translate  <-3.87134, 3.0656, 20.40368>
}
#declare _Leaf2B10_1B5_1B7_Ref = object {
  _Leaf2B10_1B5_1B7
  rotate <0.0, 117.318558, 147.06041>
  translate  <-4.26313, 3.29623, 20.19274>
}
#declare _Leaf2B10_1B6_1B1_Ref = object {
  _Leaf2B10_1B6_1B1
  rotate <0.0, 92.105209, 323.409973>
  translate  <-2.10314, 1.84148, 21.87>
}
#declare _Leaf2B10_1B6_1B2_Ref = object {
  _Leaf2B10_1B6_1B2
  rotate <0.0, 62.744732, 71.920151>
  translate  <-2.09305, 1.89405, 21.98853>
}
#declare _Leaf2B10_1B6_1B3_Ref = object {
  _Leaf2B10_1B6_1B3
  rotate <0.0, 53.773628, 227.613327>
  translate  <-2.1027, 1.80836, 22.08352>
}
#declare _Leaf2B10_1B6_1B4_Ref = object {
  _Leaf2B10_1B6_1B4
  rotate <0.0, 95.322319, 328.881165>
  translate  <-1.70379, 1.6233, 22.87162>
}
#declare _Leaf2B10_1B6_1B5_Ref = object {
  _Leaf2B10_1B6_1B5
  rotate <0.0, 43.651039, 112.566162>
  translate  <-1.70968, 1.63657, 22.98774>
}
#declare _Leaf2B10_1B6_1B6_Ref = object {
  _Leaf2B10_1B6_1B6
  rotate <0.0, 71.656487, 273.079834>
  translate  <-1.65554, 1.572, 23.06115>
}
#declare _Leaf2B10_1B6_1B7_Ref = object {
  _Leaf2B10_1B6_1B7
  rotate <0.0, 28.14806, 333.384949>
  translate  <-1.44563, 1.49399, 23.50952>
}
#declare _Leaf2B10_1B7_1B1_Ref = object {
  _Leaf2B10_1B7_1B1
  rotate <0.0, 113.118668, 266.887329>
  translate  <-2.99835, 1.6644, 21.57605>
}
#declare _Leaf2B10_1B7_1B2_Ref = object {
  _Leaf2B10_1B7_1B2
  rotate <0.0, 7.6445, 309.32608>
  translate  <-3.07082, 1.65248, 21.68338>
}
#declare _Leaf2B10_1B7_1B3_Ref = object {
  _Leaf2B10_1B7_1B3
  rotate <0.0, 106.202133, 162.952347>
  translate  <-3.19405, 1.62614, 21.65926>
}
#declare _Leaf2B10_1B7_1B4_Ref = object {
  _Leaf2B10_1B7_1B4
  rotate <0.0, 110.228188, 272.95636>
  translate  <-3.84625, 1.08897, 21.97637>
}
#declare _Leaf2B10_1B7_1B5_Ref = object {
  _Leaf2B10_1B7_1B5
  rotate <0.0, 29.609301, 139.25528>
  translate  <-3.93938, 1.08226, 22.04693>
}
#declare _Leaf2B10_1B7_1B6_Ref = object {
  _Leaf2B10_1B7_1B6
  rotate <0.0, 128.628464, 205.934937>
  translate  <-4.01833, 1.00353, 22.0394>
}
#declare _Leaf2B10_1B7_1B7_Ref = object {
  _Leaf2B10_1B7_1B7
  rotate <0.0, 69.677887, 218.104431>
  translate  <-4.38072, 0.72139, 22.24002>
}
#declare _Leaf2B10_1B8_1B1_Ref = object {
  _Leaf2B10_1B8_1B1
  rotate <0.0, 117.139328, 15.67358>
  translate  <-2.2112, 2.71328, 21.48887>
}
#declare _Leaf2B10_1B8_1B2_Ref = object {
  _Leaf2B10_1B8_1B2
  rotate <0.0, 105.61187, 135.141129>
  translate  <-2.25763, 2.82972, 21.52349>
}
#declare _Leaf2B10_1B8_1B3_Ref = object {
  _Leaf2B10_1B8_1B3
  rotate <0.0, 21.37232, 22.996401>
  translate  <-2.18341, 2.89133, 21.60808>
}
#declare _Leaf2B10_1B8_1B4_Ref = object {
  _Leaf2B10_1B8_1B4
  rotate <0.0, 123.467278, 16.05299>
  translate  <-1.8715, 3.72557, 21.75376>
}
#declare _Leaf2B10_1B8_1B5_Ref = object {
  _Leaf2B10_1B8_1B5
  rotate <0.0, 68.62262, 138.773972>
  translate  <-1.88764, 3.82521, 21.81299>
}
#declare _Leaf2B10_1B8_1B6_Ref = object {
  _Leaf2B10_1B8_1B6
  rotate <0.0, 64.113869, 7.82264>
  translate  <-1.80835, 3.90234, 21.82892>
}
#declare _Leaf2B10_1B8_1B7_Ref = object {
  _Leaf2B10_1B8_1B7
  rotate <0.0, 79.402367, 69.539001>
  translate  <-1.6626, 4.37385, 21.91621>
}
#declare ArbolB_Leafs = union {
  object { _Leaf2B1_2B1_1B1_Ref }
  object { _Leaf2B1_2B1_1B2_Ref }
  object { _Leaf2B1_2B1_1B3_Ref }
  object { _Leaf2B1_2B1_1B4_Ref }
  object { _Leaf2B1_2B1_1B5_Ref }
  object { _Leaf2B1_2B1_1B6_Ref }
  object { _Leaf2B1_2B1_1B7_Ref }
  object { _Leaf2B1_2B2_1B1_Ref }
  object { _Leaf2B1_2B2_1B2_Ref }
  object { _Leaf2B1_2B2_1B3_Ref }
  object { _Leaf2B1_2B2_1B4_Ref }
  object { _Leaf2B1_2B2_1B5_Ref }
  object { _Leaf2B1_2B2_1B6_Ref }
  object { _Leaf2B1_2B2_1B7_Ref }
  object { _Leaf2B1_2B3_1B1_Ref }
  object { _Leaf2B1_2B3_1B2_Ref }
  object { _Leaf2B1_2B3_1B3_Ref }
  object { _Leaf2B1_2B3_1B4_Ref }
  object { _Leaf2B1_2B3_1B5_Ref }
  object { _Leaf2B1_2B3_1B6_Ref }
  object { _Leaf2B1_2B3_1B7_Ref }
  object { _Leaf2B1_2B4_1B1_Ref }
  object { _Leaf2B1_2B4_1B2_Ref }
  object { _Leaf2B1_2B4_1B3_Ref }
  object { _Leaf2B1_2B4_1B4_Ref }
  object { _Leaf2B1_2B4_1B5_Ref }
  object { _Leaf2B1_2B4_1B6_Ref }
  object { _Leaf2B1_2B4_1B7_Ref }
  object { _Leaf2B1_2B5_1B1_Ref }
  object { _Leaf2B1_2B5_1B2_Ref }
  object { _Leaf2B1_2B5_1B3_Ref }
  object { _Leaf2B1_2B5_1B4_Ref }
  object { _Leaf2B1_2B5_1B5_Ref }
  object { _Leaf2B1_2B5_1B6_Ref }
  object { _Leaf2B1_2B5_1B7_Ref }
  object { _Leaf2B1_1B1_1B1_Ref }
  object { _Leaf2B1_1B1_1B2_Ref }
  object { _Leaf2B1_1B1_1B3_Ref }
  object { _Leaf2B1_1B1_1B4_Ref }
  object { _Leaf2B1_1B1_1B5_Ref }
  object { _Leaf2B1_1B1_1B6_Ref }
  object { _Leaf2B1_1B1_1B7_Ref }
  object { _Leaf2B1_1B2_1B1_Ref }
  object { _Leaf2B1_1B2_1B2_Ref }
  object { _Leaf2B1_1B2_1B3_Ref }
  object { _Leaf2B1_1B2_1B4_Ref }
  object { _Leaf2B1_1B2_1B5_Ref }
  object { _Leaf2B1_1B2_1B6_Ref }
  object { _Leaf2B1_1B2_1B7_Ref }
  object { _Leaf2B1_1B3_1B1_Ref }
  object { _Leaf2B1_1B3_1B2_Ref }
  object { _Leaf2B1_1B3_1B3_Ref }
  object { _Leaf2B1_1B3_1B4_Ref }
  object { _Leaf2B1_1B3_1B5_Ref }
  object { _Leaf2B1_1B3_1B6_Ref }
  object { _Leaf2B1_1B3_1B7_Ref }
  object { _Leaf2B1_1B4_1B1_Ref }
  object { _Leaf2B1_1B4_1B2_Ref }
  object { _Leaf2B1_1B4_1B3_Ref }
  object { _Leaf2B1_1B4_1B4_Ref }
  object { _Leaf2B1_1B4_1B5_Ref }
  object { _Leaf2B1_1B4_1B6_Ref }
  object { _Leaf2B1_1B4_1B7_Ref }
  object { _Leaf2B1_1B5_1B1_Ref }
  object { _Leaf2B1_1B5_1B2_Ref }
  object { _Leaf2B1_1B5_1B3_Ref }
  object { _Leaf2B1_1B5_1B4_Ref }
  object { _Leaf2B1_1B5_1B5_Ref }
  object { _Leaf2B1_1B5_1B6_Ref }
  object { _Leaf2B1_1B5_1B7_Ref }
  object { _Leaf2B1_1B6_1B1_Ref }
  object { _Leaf2B1_1B6_1B2_Ref }
  object { _Leaf2B1_1B6_1B3_Ref }
  object { _Leaf2B1_1B6_1B4_Ref }
  object { _Leaf2B1_1B6_1B5_Ref }
  object { _Leaf2B1_1B6_1B6_Ref }
  object { _Leaf2B1_1B6_1B7_Ref }
  object { _Leaf2B1_1B7_1B1_Ref }
  object { _Leaf2B1_1B7_1B2_Ref }
  object { _Leaf2B1_1B7_1B3_Ref }
  object { _Leaf2B1_1B7_1B4_Ref }
  object { _Leaf2B1_1B7_1B5_Ref }
  object { _Leaf2B1_1B7_1B6_Ref }
  object { _Leaf2B1_1B7_1B7_Ref }
  object { _Leaf2B1_1B8_1B1_Ref }
  object { _Leaf2B1_1B8_1B2_Ref }
  object { _Leaf2B1_1B8_1B3_Ref }
  object { _Leaf2B1_1B8_1B4_Ref }
  object { _Leaf2B1_1B8_1B5_Ref }
  object { _Leaf2B1_1B8_1B6_Ref }
  object { _Leaf2B1_1B8_1B7_Ref }
  object { _Leaf2B1_1B9_1B1_Ref }
  object { _Leaf2B1_1B9_1B2_Ref }
  object { _Leaf2B1_1B9_1B3_Ref }
  object { _Leaf2B1_1B9_1B4_Ref }
  object { _Leaf2B1_1B9_1B5_Ref }
  object { _Leaf2B1_1B9_1B6_Ref }
  object { _Leaf2B1_1B9_1B7_Ref }
  object { _Leaf2B1_1B10_1B1_Ref }
  object { _Leaf2B1_1B10_1B2_Ref }
  object { _Leaf2B1_1B10_1B3_Ref }
  object { _Leaf2B1_1B10_1B4_Ref }
  object { _Leaf2B1_1B10_1B5_Ref }
  object { _Leaf2B1_1B10_1B6_Ref }
  object { _Leaf2B1_1B10_1B7_Ref }
  object { _Leaf2B1_1B11_1B1_Ref }
  object { _Leaf2B1_1B11_1B2_Ref }
  object { _Leaf2B1_1B11_1B3_Ref }
  object { _Leaf2B1_1B11_1B4_Ref }
  object { _Leaf2B1_1B11_1B5_Ref }
  object { _Leaf2B1_1B11_1B6_Ref }
  object { _Leaf2B1_1B11_1B7_Ref }
  object { _Leaf2B1_1B12_1B1_Ref }
  object { _Leaf2B1_1B12_1B2_Ref }
  object { _Leaf2B1_1B12_1B3_Ref }
  object { _Leaf2B1_1B12_1B4_Ref }
  object { _Leaf2B1_1B12_1B5_Ref }
  object { _Leaf2B1_1B12_1B6_Ref }
  object { _Leaf2B1_1B12_1B7_Ref }
  object { _Leaf2B2_2B1_1B1_Ref }
  object { _Leaf2B2_2B1_1B2_Ref }
  object { _Leaf2B2_2B1_1B3_Ref }
  object { _Leaf2B2_2B1_1B4_Ref }
  object { _Leaf2B2_2B1_1B5_Ref }
  object { _Leaf2B2_2B1_1B6_Ref }
  object { _Leaf2B2_2B1_1B7_Ref }
  object { _Leaf2B2_2B2_1B1_Ref }
  object { _Leaf2B2_2B2_1B2_Ref }
  object { _Leaf2B2_2B2_1B3_Ref }
  object { _Leaf2B2_2B2_1B4_Ref }
  object { _Leaf2B2_2B2_1B5_Ref }
  object { _Leaf2B2_2B2_1B6_Ref }
  object { _Leaf2B2_2B2_1B7_Ref }
  object { _Leaf2B2_2B3_1B1_Ref }
  object { _Leaf2B2_2B3_1B2_Ref }
  object { _Leaf2B2_2B3_1B3_Ref }
  object { _Leaf2B2_2B3_1B4_Ref }
  object { _Leaf2B2_2B3_1B5_Ref }
  object { _Leaf2B2_2B3_1B6_Ref }
  object { _Leaf2B2_2B3_1B7_Ref }
  object { _Leaf2B2_2B4_1B1_Ref }
  object { _Leaf2B2_2B4_1B2_Ref }
  object { _Leaf2B2_2B4_1B3_Ref }
  object { _Leaf2B2_2B4_1B4_Ref }
  object { _Leaf2B2_2B4_1B5_Ref }
  object { _Leaf2B2_2B4_1B6_Ref }
  object { _Leaf2B2_2B4_1B7_Ref }
  object { _Leaf2B2_2B5_1B1_Ref }
  object { _Leaf2B2_2B5_1B2_Ref }
  object { _Leaf2B2_2B5_1B3_Ref }
  object { _Leaf2B2_2B5_1B4_Ref }
  object { _Leaf2B2_2B5_1B5_Ref }
  object { _Leaf2B2_2B5_1B6_Ref }
  object { _Leaf2B2_2B5_1B7_Ref }
  object { _Leaf2B2_1B1_1B1_Ref }
  object { _Leaf2B2_1B1_1B2_Ref }
  object { _Leaf2B2_1B1_1B3_Ref }
  object { _Leaf2B2_1B1_1B4_Ref }
  object { _Leaf2B2_1B1_1B5_Ref }
  object { _Leaf2B2_1B1_1B6_Ref }
  object { _Leaf2B2_1B1_1B7_Ref }
  object { _Leaf2B2_1B2_1B1_Ref }
  object { _Leaf2B2_1B2_1B2_Ref }
  object { _Leaf2B2_1B2_1B3_Ref }
  object { _Leaf2B2_1B2_1B4_Ref }
  object { _Leaf2B2_1B2_1B5_Ref }
  object { _Leaf2B2_1B2_1B6_Ref }
  object { _Leaf2B2_1B2_1B7_Ref }
  object { _Leaf2B2_1B3_1B1_Ref }
  object { _Leaf2B2_1B3_1B2_Ref }
  object { _Leaf2B2_1B3_1B3_Ref }
  object { _Leaf2B2_1B3_1B4_Ref }
  object { _Leaf2B2_1B3_1B5_Ref }
  object { _Leaf2B2_1B3_1B6_Ref }
  object { _Leaf2B2_1B3_1B7_Ref }
  object { _Leaf2B2_1B4_1B1_Ref }
  object { _Leaf2B2_1B4_1B2_Ref }
  object { _Leaf2B2_1B4_1B3_Ref }
  object { _Leaf2B2_1B4_1B4_Ref }
  object { _Leaf2B2_1B4_1B5_Ref }
  object { _Leaf2B2_1B4_1B6_Ref }
  object { _Leaf2B2_1B4_1B7_Ref }
  object { _Leaf2B2_1B5_1B1_Ref }
  object { _Leaf2B2_1B5_1B2_Ref }
  object { _Leaf2B2_1B5_1B3_Ref }
  object { _Leaf2B2_1B5_1B4_Ref }
  object { _Leaf2B2_1B5_1B5_Ref }
  object { _Leaf2B2_1B5_1B6_Ref }
  object { _Leaf2B2_1B5_1B7_Ref }
  object { _Leaf2B2_1B6_1B1_Ref }
  object { _Leaf2B2_1B6_1B2_Ref }
  object { _Leaf2B2_1B6_1B3_Ref }
  object { _Leaf2B2_1B6_1B4_Ref }
  object { _Leaf2B2_1B6_1B5_Ref }
  object { _Leaf2B2_1B6_1B6_Ref }
  object { _Leaf2B2_1B6_1B7_Ref }
  object { _Leaf2B2_1B7_1B1_Ref }
  object { _Leaf2B2_1B7_1B2_Ref }
  object { _Leaf2B2_1B7_1B3_Ref }
  object { _Leaf2B2_1B7_1B4_Ref }
  object { _Leaf2B2_1B7_1B5_Ref }
  object { _Leaf2B2_1B7_1B6_Ref }
  object { _Leaf2B2_1B7_1B7_Ref }
  object { _Leaf2B2_1B8_1B1_Ref }
  object { _Leaf2B2_1B8_1B2_Ref }
  object { _Leaf2B2_1B8_1B3_Ref }
  object { _Leaf2B2_1B8_1B4_Ref }
  object { _Leaf2B2_1B8_1B5_Ref }
  object { _Leaf2B2_1B8_1B6_Ref }
  object { _Leaf2B2_1B8_1B7_Ref }
  object { _Leaf2B2_1B9_1B1_Ref }
  object { _Leaf2B2_1B9_1B2_Ref }
  object { _Leaf2B2_1B9_1B3_Ref }
  object { _Leaf2B2_1B9_1B4_Ref }
  object { _Leaf2B2_1B9_1B5_Ref }
  object { _Leaf2B2_1B9_1B6_Ref }
  object { _Leaf2B2_1B9_1B7_Ref }
  object { _Leaf2B2_1B10_1B1_Ref }
  object { _Leaf2B2_1B10_1B2_Ref }
  object { _Leaf2B2_1B10_1B3_Ref }
  object { _Leaf2B2_1B10_1B4_Ref }
  object { _Leaf2B2_1B10_1B5_Ref }
  object { _Leaf2B2_1B10_1B6_Ref }
  object { _Leaf2B2_1B10_1B7_Ref }
  object { _Leaf2B2_1B11_1B1_Ref }
  object { _Leaf2B2_1B11_1B2_Ref }
  object { _Leaf2B2_1B11_1B3_Ref }
  object { _Leaf2B2_1B11_1B4_Ref }
  object { _Leaf2B2_1B11_1B5_Ref }
  object { _Leaf2B2_1B11_1B6_Ref }
  object { _Leaf2B2_1B11_1B7_Ref }
  object { _Leaf2B2_1B12_1B1_Ref }
  object { _Leaf2B2_1B12_1B2_Ref }
  object { _Leaf2B2_1B12_1B3_Ref }
  object { _Leaf2B2_1B12_1B4_Ref }
  object { _Leaf2B2_1B12_1B5_Ref }
  object { _Leaf2B2_1B12_1B6_Ref }
  object { _Leaf2B2_1B12_1B7_Ref }
  object { _Leaf2B3_2B1_1B1_Ref }
  object { _Leaf2B3_2B1_1B2_Ref }
  object { _Leaf2B3_2B1_1B3_Ref }
  object { _Leaf2B3_2B1_1B4_Ref }
  object { _Leaf2B3_2B1_1B5_Ref }
  object { _Leaf2B3_2B1_1B6_Ref }
  object { _Leaf2B3_2B1_1B7_Ref }
  object { _Leaf2B3_2B2_1B1_Ref }
  object { _Leaf2B3_2B2_1B2_Ref }
  object { _Leaf2B3_2B2_1B3_Ref }
  object { _Leaf2B3_2B2_1B4_Ref }
  object { _Leaf2B3_2B2_1B5_Ref }
  object { _Leaf2B3_2B2_1B6_Ref }
  object { _Leaf2B3_2B2_1B7_Ref }
  object { _Leaf2B3_2B3_1B1_Ref }
  object { _Leaf2B3_2B3_1B2_Ref }
  object { _Leaf2B3_2B3_1B3_Ref }
  object { _Leaf2B3_2B3_1B4_Ref }
  object { _Leaf2B3_2B3_1B5_Ref }
  object { _Leaf2B3_2B3_1B6_Ref }
  object { _Leaf2B3_2B3_1B7_Ref }
  object { _Leaf2B3_2B4_1B1_Ref }
  object { _Leaf2B3_2B4_1B2_Ref }
  object { _Leaf2B3_2B4_1B3_Ref }
  object { _Leaf2B3_2B4_1B4_Ref }
  object { _Leaf2B3_2B4_1B5_Ref }
  object { _Leaf2B3_2B4_1B6_Ref }
  object { _Leaf2B3_2B4_1B7_Ref }
  object { _Leaf2B3_2B5_1B1_Ref }
  object { _Leaf2B3_2B5_1B2_Ref }
  object { _Leaf2B3_2B5_1B3_Ref }
  object { _Leaf2B3_2B5_1B4_Ref }
  object { _Leaf2B3_2B5_1B5_Ref }
  object { _Leaf2B3_2B5_1B6_Ref }
  object { _Leaf2B3_2B5_1B7_Ref }
  object { _Leaf2B3_1B1_1B1_Ref }
  object { _Leaf2B3_1B1_1B2_Ref }
  object { _Leaf2B3_1B1_1B3_Ref }
  object { _Leaf2B3_1B1_1B4_Ref }
  object { _Leaf2B3_1B1_1B5_Ref }
  object { _Leaf2B3_1B1_1B6_Ref }
  object { _Leaf2B3_1B1_1B7_Ref }
  object { _Leaf2B3_1B2_1B1_Ref }
  object { _Leaf2B3_1B2_1B2_Ref }
  object { _Leaf2B3_1B2_1B3_Ref }
  object { _Leaf2B3_1B2_1B4_Ref }
  object { _Leaf2B3_1B2_1B5_Ref }
  object { _Leaf2B3_1B2_1B6_Ref }
  object { _Leaf2B3_1B2_1B7_Ref }
  object { _Leaf2B3_1B3_1B1_Ref }
  object { _Leaf2B3_1B3_1B2_Ref }
  object { _Leaf2B3_1B3_1B3_Ref }
  object { _Leaf2B3_1B3_1B4_Ref }
  object { _Leaf2B3_1B3_1B5_Ref }
  object { _Leaf2B3_1B3_1B6_Ref }
  object { _Leaf2B3_1B3_1B7_Ref }
  object { _Leaf2B3_1B4_1B1_Ref }
  object { _Leaf2B3_1B4_1B2_Ref }
  object { _Leaf2B3_1B4_1B3_Ref }
  object { _Leaf2B3_1B4_1B4_Ref }
  object { _Leaf2B3_1B4_1B5_Ref }
  object { _Leaf2B3_1B4_1B6_Ref }
  object { _Leaf2B3_1B4_1B7_Ref }
  object { _Leaf2B3_1B5_1B1_Ref }
  object { _Leaf2B3_1B5_1B2_Ref }
  object { _Leaf2B3_1B5_1B3_Ref }
  object { _Leaf2B3_1B5_1B4_Ref }
  object { _Leaf2B3_1B5_1B5_Ref }
  object { _Leaf2B3_1B5_1B6_Ref }
  object { _Leaf2B3_1B5_1B7_Ref }
  object { _Leaf2B3_1B6_1B1_Ref }
  object { _Leaf2B3_1B6_1B2_Ref }
  object { _Leaf2B3_1B6_1B3_Ref }
  object { _Leaf2B3_1B6_1B4_Ref }
  object { _Leaf2B3_1B6_1B5_Ref }
  object { _Leaf2B3_1B6_1B6_Ref }
  object { _Leaf2B3_1B6_1B7_Ref }
  object { _Leaf2B3_1B7_1B1_Ref }
  object { _Leaf2B3_1B7_1B2_Ref }
  object { _Leaf2B3_1B7_1B3_Ref }
  object { _Leaf2B3_1B7_1B4_Ref }
  object { _Leaf2B3_1B7_1B5_Ref }
  object { _Leaf2B3_1B7_1B6_Ref }
  object { _Leaf2B3_1B7_1B7_Ref }
  object { _Leaf2B3_1B8_1B1_Ref }
  object { _Leaf2B3_1B8_1B2_Ref }
  object { _Leaf2B3_1B8_1B3_Ref }
  object { _Leaf2B3_1B8_1B4_Ref }
  object { _Leaf2B3_1B8_1B5_Ref }
  object { _Leaf2B3_1B8_1B6_Ref }
  object { _Leaf2B3_1B8_1B7_Ref }
  object { _Leaf2B3_1B9_1B1_Ref }
  object { _Leaf2B3_1B9_1B2_Ref }
  object { _Leaf2B3_1B9_1B3_Ref }
  object { _Leaf2B3_1B9_1B4_Ref }
  object { _Leaf2B3_1B9_1B5_Ref }
  object { _Leaf2B3_1B9_1B6_Ref }
  object { _Leaf2B3_1B9_1B7_Ref }
  object { _Leaf2B3_1B10_1B1_Ref }
  object { _Leaf2B3_1B10_1B2_Ref }
  object { _Leaf2B3_1B10_1B3_Ref }
  object { _Leaf2B3_1B10_1B4_Ref }
  object { _Leaf2B3_1B10_1B5_Ref }
  object { _Leaf2B3_1B10_1B6_Ref }
  object { _Leaf2B3_1B10_1B7_Ref }
  object { _Leaf2B3_1B11_1B1_Ref }
  object { _Leaf2B3_1B11_1B2_Ref }
  object { _Leaf2B3_1B11_1B3_Ref }
  object { _Leaf2B3_1B11_1B4_Ref }
  object { _Leaf2B3_1B11_1B5_Ref }
  object { _Leaf2B3_1B11_1B6_Ref }
  object { _Leaf2B3_1B11_1B7_Ref }
  object { _Leaf2B3_1B12_1B1_Ref }
  object { _Leaf2B3_1B12_1B2_Ref }
  object { _Leaf2B3_1B12_1B3_Ref }
  object { _Leaf2B3_1B12_1B4_Ref }
  object { _Leaf2B3_1B12_1B5_Ref }
  object { _Leaf2B3_1B12_1B6_Ref }
  object { _Leaf2B3_1B12_1B7_Ref }
  object { _Leaf2B4_2B1_1B1_Ref }
  object { _Leaf2B4_2B1_1B2_Ref }
  object { _Leaf2B4_2B1_1B3_Ref }
  object { _Leaf2B4_2B1_1B4_Ref }
  object { _Leaf2B4_2B1_1B5_Ref }
  object { _Leaf2B4_2B1_1B6_Ref }
  object { _Leaf2B4_2B1_1B7_Ref }
  object { _Leaf2B4_2B2_1B1_Ref }
  object { _Leaf2B4_2B2_1B2_Ref }
  object { _Leaf2B4_2B2_1B3_Ref }
  object { _Leaf2B4_2B2_1B4_Ref }
  object { _Leaf2B4_2B2_1B5_Ref }
  object { _Leaf2B4_2B2_1B6_Ref }
  object { _Leaf2B4_2B2_1B7_Ref }
  object { _Leaf2B4_2B3_1B1_Ref }
  object { _Leaf2B4_2B3_1B2_Ref }
  object { _Leaf2B4_2B3_1B3_Ref }
  object { _Leaf2B4_2B3_1B4_Ref }
  object { _Leaf2B4_2B3_1B5_Ref }
  object { _Leaf2B4_2B3_1B6_Ref }
  object { _Leaf2B4_2B3_1B7_Ref }
  object { _Leaf2B4_2B4_1B1_Ref }
  object { _Leaf2B4_2B4_1B2_Ref }
  object { _Leaf2B4_2B4_1B3_Ref }
  object { _Leaf2B4_2B4_1B4_Ref }
  object { _Leaf2B4_2B4_1B5_Ref }
  object { _Leaf2B4_2B4_1B6_Ref }
  object { _Leaf2B4_2B4_1B7_Ref }
  object { _Leaf2B4_2B5_1B1_Ref }
  object { _Leaf2B4_2B5_1B2_Ref }
  object { _Leaf2B4_2B5_1B3_Ref }
  object { _Leaf2B4_2B5_1B4_Ref }
  object { _Leaf2B4_2B5_1B5_Ref }
  object { _Leaf2B4_2B5_1B6_Ref }
  object { _Leaf2B4_2B5_1B7_Ref }
  object { _Leaf2B4_1B1_1B1_Ref }
  object { _Leaf2B4_1B1_1B2_Ref }
  object { _Leaf2B4_1B1_1B3_Ref }
  object { _Leaf2B4_1B1_1B4_Ref }
  object { _Leaf2B4_1B1_1B5_Ref }
  object { _Leaf2B4_1B1_1B6_Ref }
  object { _Leaf2B4_1B1_1B7_Ref }
  object { _Leaf2B4_1B2_1B1_Ref }
  object { _Leaf2B4_1B2_1B2_Ref }
  object { _Leaf2B4_1B2_1B3_Ref }
  object { _Leaf2B4_1B2_1B4_Ref }
  object { _Leaf2B4_1B2_1B5_Ref }
  object { _Leaf2B4_1B2_1B6_Ref }
  object { _Leaf2B4_1B2_1B7_Ref }
  object { _Leaf2B4_1B3_1B1_Ref }
  object { _Leaf2B4_1B3_1B2_Ref }
  object { _Leaf2B4_1B3_1B3_Ref }
  object { _Leaf2B4_1B3_1B4_Ref }
  object { _Leaf2B4_1B3_1B5_Ref }
  object { _Leaf2B4_1B3_1B6_Ref }
  object { _Leaf2B4_1B3_1B7_Ref }
  object { _Leaf2B4_1B4_1B1_Ref }
  object { _Leaf2B4_1B4_1B2_Ref }
  object { _Leaf2B4_1B4_1B3_Ref }
  object { _Leaf2B4_1B4_1B4_Ref }
  object { _Leaf2B4_1B4_1B5_Ref }
  object { _Leaf2B4_1B4_1B6_Ref }
  object { _Leaf2B4_1B4_1B7_Ref }
  object { _Leaf2B4_1B5_1B1_Ref }
  object { _Leaf2B4_1B5_1B2_Ref }
  object { _Leaf2B4_1B5_1B3_Ref }
  object { _Leaf2B4_1B5_1B4_Ref }
  object { _Leaf2B4_1B5_1B5_Ref }
  object { _Leaf2B4_1B5_1B6_Ref }
  object { _Leaf2B4_1B5_1B7_Ref }
  object { _Leaf2B4_1B6_1B1_Ref }
  object { _Leaf2B4_1B6_1B2_Ref }
  object { _Leaf2B4_1B6_1B3_Ref }
  object { _Leaf2B4_1B6_1B4_Ref }
  object { _Leaf2B4_1B6_1B5_Ref }
  object { _Leaf2B4_1B6_1B6_Ref }
  object { _Leaf2B4_1B6_1B7_Ref }
  object { _Leaf2B4_1B7_1B1_Ref }
  object { _Leaf2B4_1B7_1B2_Ref }
  object { _Leaf2B4_1B7_1B3_Ref }
  object { _Leaf2B4_1B7_1B4_Ref }
  object { _Leaf2B4_1B7_1B5_Ref }
  object { _Leaf2B4_1B7_1B6_Ref }
  object { _Leaf2B4_1B7_1B7_Ref }
  object { _Leaf2B4_1B8_1B1_Ref }
  object { _Leaf2B4_1B8_1B2_Ref }
  object { _Leaf2B4_1B8_1B3_Ref }
  object { _Leaf2B4_1B8_1B4_Ref }
  object { _Leaf2B4_1B8_1B5_Ref }
  object { _Leaf2B4_1B8_1B6_Ref }
  object { _Leaf2B4_1B8_1B7_Ref }
  object { _Leaf2B4_1B9_1B1_Ref }
  object { _Leaf2B4_1B9_1B2_Ref }
  object { _Leaf2B4_1B9_1B3_Ref }
  object { _Leaf2B4_1B9_1B4_Ref }
  object { _Leaf2B4_1B9_1B5_Ref }
  object { _Leaf2B4_1B9_1B6_Ref }
  object { _Leaf2B4_1B9_1B7_Ref }
  object { _Leaf2B4_1B10_1B1_Ref }
  object { _Leaf2B4_1B10_1B2_Ref }
  object { _Leaf2B4_1B10_1B3_Ref }
  object { _Leaf2B4_1B10_1B4_Ref }
  object { _Leaf2B4_1B10_1B5_Ref }
  object { _Leaf2B4_1B10_1B6_Ref }
  object { _Leaf2B4_1B10_1B7_Ref }
  object { _Leaf2B4_1B11_1B1_Ref }
  object { _Leaf2B4_1B11_1B2_Ref }
  object { _Leaf2B4_1B11_1B3_Ref }
  object { _Leaf2B4_1B11_1B4_Ref }
  object { _Leaf2B4_1B11_1B5_Ref }
  object { _Leaf2B4_1B11_1B6_Ref }
  object { _Leaf2B4_1B11_1B7_Ref }
  object { _Leaf2B4_1B12_1B1_Ref }
  object { _Leaf2B4_1B12_1B2_Ref }
  object { _Leaf2B4_1B12_1B3_Ref }
  object { _Leaf2B4_1B12_1B4_Ref }
  object { _Leaf2B4_1B12_1B5_Ref }
  object { _Leaf2B4_1B12_1B6_Ref }
  object { _Leaf2B4_1B12_1B7_Ref }
  object { _Leaf2B5_2B1_1B1_Ref }
  object { _Leaf2B5_2B1_1B2_Ref }
  object { _Leaf2B5_2B1_1B3_Ref }
  object { _Leaf2B5_2B1_1B4_Ref }
  object { _Leaf2B5_2B1_1B5_Ref }
  object { _Leaf2B5_2B1_1B6_Ref }
  object { _Leaf2B5_2B1_1B7_Ref }
  object { _Leaf2B5_2B2_1B1_Ref }
  object { _Leaf2B5_2B2_1B2_Ref }
  object { _Leaf2B5_2B2_1B3_Ref }
  object { _Leaf2B5_2B2_1B4_Ref }
  object { _Leaf2B5_2B2_1B5_Ref }
  object { _Leaf2B5_2B2_1B6_Ref }
  object { _Leaf2B5_2B2_1B7_Ref }
  object { _Leaf2B5_2B3_1B1_Ref }
  object { _Leaf2B5_2B3_1B2_Ref }
  object { _Leaf2B5_2B3_1B3_Ref }
  object { _Leaf2B5_2B3_1B4_Ref }
  object { _Leaf2B5_2B3_1B5_Ref }
  object { _Leaf2B5_2B3_1B6_Ref }
  object { _Leaf2B5_2B3_1B7_Ref }
  object { _Leaf2B5_2B4_1B1_Ref }
  object { _Leaf2B5_2B4_1B2_Ref }
  object { _Leaf2B5_2B4_1B3_Ref }
  object { _Leaf2B5_2B4_1B4_Ref }
  object { _Leaf2B5_2B4_1B5_Ref }
  object { _Leaf2B5_2B4_1B6_Ref }
  object { _Leaf2B5_2B4_1B7_Ref }
  object { _Leaf2B5_2B5_1B1_Ref }
  object { _Leaf2B5_2B5_1B2_Ref }
  object { _Leaf2B5_2B5_1B3_Ref }
  object { _Leaf2B5_2B5_1B4_Ref }
  object { _Leaf2B5_2B5_1B5_Ref }
  object { _Leaf2B5_2B5_1B6_Ref }
  object { _Leaf2B5_2B5_1B7_Ref }
  object { _Leaf2B5_1B1_1B1_Ref }
  object { _Leaf2B5_1B1_1B2_Ref }
  object { _Leaf2B5_1B1_1B3_Ref }
  object { _Leaf2B5_1B1_1B4_Ref }
  object { _Leaf2B5_1B1_1B5_Ref }
  object { _Leaf2B5_1B1_1B6_Ref }
  object { _Leaf2B5_1B1_1B7_Ref }
  object { _Leaf2B5_1B2_1B1_Ref }
  object { _Leaf2B5_1B2_1B2_Ref }
  object { _Leaf2B5_1B2_1B3_Ref }
  object { _Leaf2B5_1B2_1B4_Ref }
  object { _Leaf2B5_1B2_1B5_Ref }
  object { _Leaf2B5_1B2_1B6_Ref }
  object { _Leaf2B5_1B2_1B7_Ref }
  object { _Leaf2B5_1B3_1B1_Ref }
  object { _Leaf2B5_1B3_1B2_Ref }
  object { _Leaf2B5_1B3_1B3_Ref }
  object { _Leaf2B5_1B3_1B4_Ref }
  object { _Leaf2B5_1B3_1B5_Ref }
  object { _Leaf2B5_1B3_1B6_Ref }
  object { _Leaf2B5_1B3_1B7_Ref }
  object { _Leaf2B5_1B4_1B1_Ref }
  object { _Leaf2B5_1B4_1B2_Ref }
  object { _Leaf2B5_1B4_1B3_Ref }
  object { _Leaf2B5_1B4_1B4_Ref }
  object { _Leaf2B5_1B4_1B5_Ref }
  object { _Leaf2B5_1B4_1B6_Ref }
  object { _Leaf2B5_1B4_1B7_Ref }
  object { _Leaf2B5_1B5_1B1_Ref }
  object { _Leaf2B5_1B5_1B2_Ref }
  object { _Leaf2B5_1B5_1B3_Ref }
  object { _Leaf2B5_1B5_1B4_Ref }
  object { _Leaf2B5_1B5_1B5_Ref }
  object { _Leaf2B5_1B5_1B6_Ref }
  object { _Leaf2B5_1B5_1B7_Ref }
  object { _Leaf2B5_1B6_1B1_Ref }
  object { _Leaf2B5_1B6_1B2_Ref }
  object { _Leaf2B5_1B6_1B3_Ref }
  object { _Leaf2B5_1B6_1B4_Ref }
  object { _Leaf2B5_1B6_1B5_Ref }
  object { _Leaf2B5_1B6_1B6_Ref }
  object { _Leaf2B5_1B6_1B7_Ref }
  object { _Leaf2B5_1B7_1B1_Ref }
  object { _Leaf2B5_1B7_1B2_Ref }
  object { _Leaf2B5_1B7_1B3_Ref }
  object { _Leaf2B5_1B7_1B4_Ref }
  object { _Leaf2B5_1B7_1B5_Ref }
  object { _Leaf2B5_1B7_1B6_Ref }
  object { _Leaf2B5_1B7_1B7_Ref }
  object { _Leaf2B5_1B8_1B1_Ref }
  object { _Leaf2B5_1B8_1B2_Ref }
  object { _Leaf2B5_1B8_1B3_Ref }
  object { _Leaf2B5_1B8_1B4_Ref }
  object { _Leaf2B5_1B8_1B5_Ref }
  object { _Leaf2B5_1B8_1B6_Ref }
  object { _Leaf2B5_1B8_1B7_Ref }
  object { _Leaf2B5_1B9_1B1_Ref }
  object { _Leaf2B5_1B9_1B2_Ref }
  object { _Leaf2B5_1B9_1B3_Ref }
  object { _Leaf2B5_1B9_1B4_Ref }
  object { _Leaf2B5_1B9_1B5_Ref }
  object { _Leaf2B5_1B9_1B6_Ref }
  object { _Leaf2B5_1B9_1B7_Ref }
  object { _Leaf2B5_1B10_1B1_Ref }
  object { _Leaf2B5_1B10_1B2_Ref }
  object { _Leaf2B5_1B10_1B3_Ref }
  object { _Leaf2B5_1B10_1B4_Ref }
  object { _Leaf2B5_1B10_1B5_Ref }
  object { _Leaf2B5_1B10_1B6_Ref }
  object { _Leaf2B5_1B10_1B7_Ref }
  object { _Leaf2B5_1B11_1B1_Ref }
  object { _Leaf2B5_1B11_1B2_Ref }
  object { _Leaf2B5_1B11_1B3_Ref }
  object { _Leaf2B5_1B11_1B4_Ref }
  object { _Leaf2B5_1B11_1B5_Ref }
  object { _Leaf2B5_1B11_1B6_Ref }
  object { _Leaf2B5_1B11_1B7_Ref }
  object { _Leaf2B5_1B12_1B1_Ref }
  object { _Leaf2B5_1B12_1B2_Ref }
  object { _Leaf2B5_1B12_1B3_Ref }
  object { _Leaf2B5_1B12_1B4_Ref }
  object { _Leaf2B5_1B12_1B5_Ref }
  object { _Leaf2B5_1B12_1B6_Ref }
  object { _Leaf2B5_1B12_1B7_Ref }
  object { _Leaf2B6_2B1_1B1_Ref }
  object { _Leaf2B6_2B1_1B2_Ref }
  object { _Leaf2B6_2B1_1B3_Ref }
  object { _Leaf2B6_2B1_1B4_Ref }
  object { _Leaf2B6_2B1_1B5_Ref }
  object { _Leaf2B6_2B1_1B6_Ref }
  object { _Leaf2B6_2B1_1B7_Ref }
  object { _Leaf2B6_2B2_1B1_Ref }
  object { _Leaf2B6_2B2_1B2_Ref }
  object { _Leaf2B6_2B2_1B3_Ref }
  object { _Leaf2B6_2B2_1B4_Ref }
  object { _Leaf2B6_2B2_1B5_Ref }
  object { _Leaf2B6_2B2_1B6_Ref }
  object { _Leaf2B6_2B2_1B7_Ref }
  object { _Leaf2B6_2B3_1B1_Ref }
  object { _Leaf2B6_2B3_1B2_Ref }
  object { _Leaf2B6_2B3_1B3_Ref }
  object { _Leaf2B6_2B3_1B4_Ref }
  object { _Leaf2B6_2B3_1B5_Ref }
  object { _Leaf2B6_2B3_1B6_Ref }
  object { _Leaf2B6_2B3_1B7_Ref }
  object { _Leaf2B6_2B4_1B1_Ref }
  object { _Leaf2B6_2B4_1B2_Ref }
  object { _Leaf2B6_2B4_1B3_Ref }
  object { _Leaf2B6_2B4_1B4_Ref }
  object { _Leaf2B6_2B4_1B5_Ref }
  object { _Leaf2B6_2B4_1B6_Ref }
  object { _Leaf2B6_2B4_1B7_Ref }
  object { _Leaf2B6_2B5_1B1_Ref }
  object { _Leaf2B6_2B5_1B2_Ref }
  object { _Leaf2B6_2B5_1B3_Ref }
  object { _Leaf2B6_2B5_1B4_Ref }
  object { _Leaf2B6_2B5_1B5_Ref }
  object { _Leaf2B6_2B5_1B6_Ref }
  object { _Leaf2B6_2B5_1B7_Ref }
  object { _Leaf2B6_1B1_1B1_Ref }
  object { _Leaf2B6_1B1_1B2_Ref }
  object { _Leaf2B6_1B1_1B3_Ref }
  object { _Leaf2B6_1B1_1B4_Ref }
  object { _Leaf2B6_1B1_1B5_Ref }
  object { _Leaf2B6_1B1_1B6_Ref }
  object { _Leaf2B6_1B1_1B7_Ref }
  object { _Leaf2B6_1B2_1B1_Ref }
  object { _Leaf2B6_1B2_1B2_Ref }
  object { _Leaf2B6_1B2_1B3_Ref }
  object { _Leaf2B6_1B2_1B4_Ref }
  object { _Leaf2B6_1B2_1B5_Ref }
  object { _Leaf2B6_1B2_1B6_Ref }
  object { _Leaf2B6_1B2_1B7_Ref }
  object { _Leaf2B6_1B3_1B1_Ref }
  object { _Leaf2B6_1B3_1B2_Ref }
  object { _Leaf2B6_1B3_1B3_Ref }
  object { _Leaf2B6_1B3_1B4_Ref }
  object { _Leaf2B6_1B3_1B5_Ref }
  object { _Leaf2B6_1B3_1B6_Ref }
  object { _Leaf2B6_1B3_1B7_Ref }
  object { _Leaf2B6_1B4_1B1_Ref }
  object { _Leaf2B6_1B4_1B2_Ref }
  object { _Leaf2B6_1B4_1B3_Ref }
  object { _Leaf2B6_1B4_1B4_Ref }
  object { _Leaf2B6_1B4_1B5_Ref }
  object { _Leaf2B6_1B4_1B6_Ref }
  object { _Leaf2B6_1B4_1B7_Ref }
  object { _Leaf2B6_1B5_1B1_Ref }
  object { _Leaf2B6_1B5_1B2_Ref }
  object { _Leaf2B6_1B5_1B3_Ref }
  object { _Leaf2B6_1B5_1B4_Ref }
  object { _Leaf2B6_1B5_1B5_Ref }
  object { _Leaf2B6_1B5_1B6_Ref }
  object { _Leaf2B6_1B5_1B7_Ref }
  object { _Leaf2B6_1B6_1B1_Ref }
  object { _Leaf2B6_1B6_1B2_Ref }
  object { _Leaf2B6_1B6_1B3_Ref }
  object { _Leaf2B6_1B6_1B4_Ref }
  object { _Leaf2B6_1B6_1B5_Ref }
  object { _Leaf2B6_1B6_1B6_Ref }
  object { _Leaf2B6_1B6_1B7_Ref }
  object { _Leaf2B6_1B7_1B1_Ref }
  object { _Leaf2B6_1B7_1B2_Ref }
  object { _Leaf2B6_1B7_1B3_Ref }
  object { _Leaf2B6_1B7_1B4_Ref }
  object { _Leaf2B6_1B7_1B5_Ref }
  object { _Leaf2B6_1B7_1B6_Ref }
  object { _Leaf2B6_1B7_1B7_Ref }
  object { _Leaf2B6_1B8_1B1_Ref }
  object { _Leaf2B6_1B8_1B2_Ref }
  object { _Leaf2B6_1B8_1B3_Ref }
  object { _Leaf2B6_1B8_1B4_Ref }
  object { _Leaf2B6_1B8_1B5_Ref }
  object { _Leaf2B6_1B8_1B6_Ref }
  object { _Leaf2B6_1B8_1B7_Ref }
  object { _Leaf2B6_1B9_1B1_Ref }
  object { _Leaf2B6_1B9_1B2_Ref }
  object { _Leaf2B6_1B9_1B3_Ref }
  object { _Leaf2B6_1B9_1B4_Ref }
  object { _Leaf2B6_1B9_1B5_Ref }
  object { _Leaf2B6_1B9_1B6_Ref }
  object { _Leaf2B6_1B9_1B7_Ref }
  object { _Leaf2B6_1B10_1B1_Ref }
  object { _Leaf2B6_1B10_1B2_Ref }
  object { _Leaf2B6_1B10_1B3_Ref }
  object { _Leaf2B6_1B10_1B4_Ref }
  object { _Leaf2B6_1B10_1B5_Ref }
  object { _Leaf2B6_1B10_1B6_Ref }
  object { _Leaf2B6_1B10_1B7_Ref }
  object { _Leaf2B6_1B11_1B1_Ref }
  object { _Leaf2B6_1B11_1B2_Ref }
  object { _Leaf2B6_1B11_1B3_Ref }
  object { _Leaf2B6_1B11_1B4_Ref }
  object { _Leaf2B6_1B11_1B5_Ref }
  object { _Leaf2B6_1B11_1B6_Ref }
  object { _Leaf2B6_1B11_1B7_Ref }
  object { _Leaf2B6_1B12_1B1_Ref }
  object { _Leaf2B6_1B12_1B2_Ref }
  object { _Leaf2B6_1B12_1B3_Ref }
  object { _Leaf2B6_1B12_1B4_Ref }
  object { _Leaf2B6_1B12_1B5_Ref }
  object { _Leaf2B6_1B12_1B6_Ref }
  object { _Leaf2B6_1B12_1B7_Ref }
  object { _Leaf2B7_2B1_1B1_Ref }
  object { _Leaf2B7_2B1_1B2_Ref }
  object { _Leaf2B7_2B1_1B3_Ref }
  object { _Leaf2B7_2B1_1B4_Ref }
  object { _Leaf2B7_2B1_1B5_Ref }
  object { _Leaf2B7_2B1_1B6_Ref }
  object { _Leaf2B7_2B1_1B7_Ref }
  object { _Leaf2B7_2B2_1B1_Ref }
  object { _Leaf2B7_2B2_1B2_Ref }
  object { _Leaf2B7_2B2_1B3_Ref }
  object { _Leaf2B7_2B2_1B4_Ref }
  object { _Leaf2B7_2B2_1B5_Ref }
  object { _Leaf2B7_2B2_1B6_Ref }
  object { _Leaf2B7_2B2_1B7_Ref }
  object { _Leaf2B7_2B3_1B1_Ref }
  object { _Leaf2B7_2B3_1B2_Ref }
  object { _Leaf2B7_2B3_1B3_Ref }
  object { _Leaf2B7_2B3_1B4_Ref }
  object { _Leaf2B7_2B3_1B5_Ref }
  object { _Leaf2B7_2B3_1B6_Ref }
  object { _Leaf2B7_2B3_1B7_Ref }
  object { _Leaf2B7_2B4_1B1_Ref }
  object { _Leaf2B7_2B4_1B2_Ref }
  object { _Leaf2B7_2B4_1B3_Ref }
  object { _Leaf2B7_2B4_1B4_Ref }
  object { _Leaf2B7_2B4_1B5_Ref }
  object { _Leaf2B7_2B4_1B6_Ref }
  object { _Leaf2B7_2B4_1B7_Ref }
  object { _Leaf2B7_2B5_1B1_Ref }
  object { _Leaf2B7_2B5_1B2_Ref }
  object { _Leaf2B7_2B5_1B3_Ref }
  object { _Leaf2B7_2B5_1B4_Ref }
  object { _Leaf2B7_2B5_1B5_Ref }
  object { _Leaf2B7_2B5_1B6_Ref }
  object { _Leaf2B7_2B5_1B7_Ref }
  object { _Leaf2B7_1B1_1B1_Ref }
  object { _Leaf2B7_1B1_1B2_Ref }
  object { _Leaf2B7_1B1_1B3_Ref }
  object { _Leaf2B7_1B1_1B4_Ref }
  object { _Leaf2B7_1B1_1B5_Ref }
  object { _Leaf2B7_1B1_1B6_Ref }
  object { _Leaf2B7_1B1_1B7_Ref }
  object { _Leaf2B7_1B2_1B1_Ref }
  object { _Leaf2B7_1B2_1B2_Ref }
  object { _Leaf2B7_1B2_1B3_Ref }
  object { _Leaf2B7_1B2_1B4_Ref }
  object { _Leaf2B7_1B2_1B5_Ref }
  object { _Leaf2B7_1B2_1B6_Ref }
  object { _Leaf2B7_1B2_1B7_Ref }
  object { _Leaf2B7_1B3_1B1_Ref }
  object { _Leaf2B7_1B3_1B2_Ref }
  object { _Leaf2B7_1B3_1B3_Ref }
  object { _Leaf2B7_1B3_1B4_Ref }
  object { _Leaf2B7_1B3_1B5_Ref }
  object { _Leaf2B7_1B3_1B6_Ref }
  object { _Leaf2B7_1B3_1B7_Ref }
  object { _Leaf2B7_1B4_1B1_Ref }
  object { _Leaf2B7_1B4_1B2_Ref }
  object { _Leaf2B7_1B4_1B3_Ref }
  object { _Leaf2B7_1B4_1B4_Ref }
  object { _Leaf2B7_1B4_1B5_Ref }
  object { _Leaf2B7_1B4_1B6_Ref }
  object { _Leaf2B7_1B4_1B7_Ref }
  object { _Leaf2B7_1B5_1B1_Ref }
  object { _Leaf2B7_1B5_1B2_Ref }
  object { _Leaf2B7_1B5_1B3_Ref }
  object { _Leaf2B7_1B5_1B4_Ref }
  object { _Leaf2B7_1B5_1B5_Ref }
  object { _Leaf2B7_1B5_1B6_Ref }
  object { _Leaf2B7_1B5_1B7_Ref }
  object { _Leaf2B7_1B6_1B1_Ref }
  object { _Leaf2B7_1B6_1B2_Ref }
  object { _Leaf2B7_1B6_1B3_Ref }
  object { _Leaf2B7_1B6_1B4_Ref }
  object { _Leaf2B7_1B6_1B5_Ref }
  object { _Leaf2B7_1B6_1B6_Ref }
  object { _Leaf2B7_1B6_1B7_Ref }
  object { _Leaf2B7_1B7_1B1_Ref }
  object { _Leaf2B7_1B7_1B2_Ref }
  object { _Leaf2B7_1B7_1B3_Ref }
  object { _Leaf2B7_1B7_1B4_Ref }
  object { _Leaf2B7_1B7_1B5_Ref }
  object { _Leaf2B7_1B7_1B6_Ref }
  object { _Leaf2B7_1B7_1B7_Ref }
  object { _Leaf2B7_1B8_1B1_Ref }
  object { _Leaf2B7_1B8_1B2_Ref }
  object { _Leaf2B7_1B8_1B3_Ref }
  object { _Leaf2B7_1B8_1B4_Ref }
  object { _Leaf2B7_1B8_1B5_Ref }
  object { _Leaf2B7_1B8_1B6_Ref }
  object { _Leaf2B7_1B8_1B7_Ref }
  object { _Leaf2B7_1B9_1B1_Ref }
  object { _Leaf2B7_1B9_1B2_Ref }
  object { _Leaf2B7_1B9_1B3_Ref }
  object { _Leaf2B7_1B9_1B4_Ref }
  object { _Leaf2B7_1B9_1B5_Ref }
  object { _Leaf2B7_1B9_1B6_Ref }
  object { _Leaf2B7_1B9_1B7_Ref }
  object { _Leaf2B7_1B10_1B1_Ref }
  object { _Leaf2B7_1B10_1B2_Ref }
  object { _Leaf2B7_1B10_1B3_Ref }
  object { _Leaf2B7_1B10_1B4_Ref }
  object { _Leaf2B7_1B10_1B5_Ref }
  object { _Leaf2B7_1B10_1B6_Ref }
  object { _Leaf2B7_1B10_1B7_Ref }
  object { _Leaf2B7_1B11_1B1_Ref }
  object { _Leaf2B7_1B11_1B2_Ref }
  object { _Leaf2B7_1B11_1B3_Ref }
  object { _Leaf2B7_1B11_1B4_Ref }
  object { _Leaf2B7_1B11_1B5_Ref }
  object { _Leaf2B7_1B11_1B6_Ref }
  object { _Leaf2B7_1B11_1B7_Ref }
  object { _Leaf2B7_1B12_1B1_Ref }
  object { _Leaf2B7_1B12_1B2_Ref }
  object { _Leaf2B7_1B12_1B3_Ref }
  object { _Leaf2B7_1B12_1B4_Ref }
  object { _Leaf2B7_1B12_1B5_Ref }
  object { _Leaf2B7_1B12_1B6_Ref }
  object { _Leaf2B7_1B12_1B7_Ref }
  object { _Leaf2B8_2B1_1B1_Ref }
  object { _Leaf2B8_2B1_1B2_Ref }
  object { _Leaf2B8_2B1_1B3_Ref }
  object { _Leaf2B8_2B1_1B4_Ref }
  object { _Leaf2B8_2B1_1B5_Ref }
  object { _Leaf2B8_2B1_1B6_Ref }
  object { _Leaf2B8_2B1_1B7_Ref }
  object { _Leaf2B8_2B2_1B1_Ref }
  object { _Leaf2B8_2B2_1B2_Ref }
  object { _Leaf2B8_2B2_1B3_Ref }
  object { _Leaf2B8_2B2_1B4_Ref }
  object { _Leaf2B8_2B2_1B5_Ref }
  object { _Leaf2B8_2B2_1B6_Ref }
  object { _Leaf2B8_2B2_1B7_Ref }
  object { _Leaf2B8_2B3_1B1_Ref }
  object { _Leaf2B8_2B3_1B2_Ref }
  object { _Leaf2B8_2B3_1B3_Ref }
  object { _Leaf2B8_2B3_1B4_Ref }
  object { _Leaf2B8_2B3_1B5_Ref }
  object { _Leaf2B8_2B3_1B6_Ref }
  object { _Leaf2B8_2B3_1B7_Ref }
  object { _Leaf2B8_2B4_1B1_Ref }
  object { _Leaf2B8_2B4_1B2_Ref }
  object { _Leaf2B8_2B4_1B3_Ref }
  object { _Leaf2B8_2B4_1B4_Ref }
  object { _Leaf2B8_2B4_1B5_Ref }
  object { _Leaf2B8_2B4_1B6_Ref }
  object { _Leaf2B8_2B4_1B7_Ref }
  object { _Leaf2B8_2B5_1B1_Ref }
  object { _Leaf2B8_2B5_1B2_Ref }
  object { _Leaf2B8_2B5_1B3_Ref }
  object { _Leaf2B8_2B5_1B4_Ref }
  object { _Leaf2B8_2B5_1B5_Ref }
  object { _Leaf2B8_2B5_1B6_Ref }
  object { _Leaf2B8_2B5_1B7_Ref }
  object { _Leaf2B8_1B1_1B1_Ref }
  object { _Leaf2B8_1B1_1B2_Ref }
  object { _Leaf2B8_1B1_1B3_Ref }
  object { _Leaf2B8_1B1_1B4_Ref }
  object { _Leaf2B8_1B1_1B5_Ref }
  object { _Leaf2B8_1B1_1B6_Ref }
  object { _Leaf2B8_1B1_1B7_Ref }
  object { _Leaf2B8_1B2_1B1_Ref }
  object { _Leaf2B8_1B2_1B2_Ref }
  object { _Leaf2B8_1B2_1B3_Ref }
  object { _Leaf2B8_1B2_1B4_Ref }
  object { _Leaf2B8_1B2_1B5_Ref }
  object { _Leaf2B8_1B2_1B6_Ref }
  object { _Leaf2B8_1B2_1B7_Ref }
  object { _Leaf2B8_1B3_1B1_Ref }
  object { _Leaf2B8_1B3_1B2_Ref }
  object { _Leaf2B8_1B3_1B3_Ref }
  object { _Leaf2B8_1B3_1B4_Ref }
  object { _Leaf2B8_1B3_1B5_Ref }
  object { _Leaf2B8_1B3_1B6_Ref }
  object { _Leaf2B8_1B3_1B7_Ref }
  object { _Leaf2B8_1B4_1B1_Ref }
  object { _Leaf2B8_1B4_1B2_Ref }
  object { _Leaf2B8_1B4_1B3_Ref }
  object { _Leaf2B8_1B4_1B4_Ref }
  object { _Leaf2B8_1B4_1B5_Ref }
  object { _Leaf2B8_1B4_1B6_Ref }
  object { _Leaf2B8_1B4_1B7_Ref }
  object { _Leaf2B8_1B5_1B1_Ref }
  object { _Leaf2B8_1B5_1B2_Ref }
  object { _Leaf2B8_1B5_1B3_Ref }
  object { _Leaf2B8_1B5_1B4_Ref }
  object { _Leaf2B8_1B5_1B5_Ref }
  object { _Leaf2B8_1B5_1B6_Ref }
  object { _Leaf2B8_1B5_1B7_Ref }
  object { _Leaf2B8_1B6_1B1_Ref }
  object { _Leaf2B8_1B6_1B2_Ref }
  object { _Leaf2B8_1B6_1B3_Ref }
  object { _Leaf2B8_1B6_1B4_Ref }
  object { _Leaf2B8_1B6_1B5_Ref }
  object { _Leaf2B8_1B6_1B6_Ref }
  object { _Leaf2B8_1B6_1B7_Ref }
  object { _Leaf2B8_1B7_1B1_Ref }
  object { _Leaf2B8_1B7_1B2_Ref }
  object { _Leaf2B8_1B7_1B3_Ref }
  object { _Leaf2B8_1B7_1B4_Ref }
  object { _Leaf2B8_1B7_1B5_Ref }
  object { _Leaf2B8_1B7_1B6_Ref }
  object { _Leaf2B8_1B7_1B7_Ref }
  object { _Leaf2B8_1B8_1B1_Ref }
  object { _Leaf2B8_1B8_1B2_Ref }
  object { _Leaf2B8_1B8_1B3_Ref }
  object { _Leaf2B8_1B8_1B4_Ref }
  object { _Leaf2B8_1B8_1B5_Ref }
  object { _Leaf2B8_1B8_1B6_Ref }
  object { _Leaf2B8_1B8_1B7_Ref }
  object { _Leaf2B9_2B1_1B1_Ref }
  object { _Leaf2B9_2B1_1B2_Ref }
  object { _Leaf2B9_2B1_1B3_Ref }
  object { _Leaf2B9_2B1_1B4_Ref }
  object { _Leaf2B9_2B1_1B5_Ref }
  object { _Leaf2B9_2B1_1B6_Ref }
  object { _Leaf2B9_2B1_1B7_Ref }
  object { _Leaf2B9_2B2_1B1_Ref }
  object { _Leaf2B9_2B2_1B2_Ref }
  object { _Leaf2B9_2B2_1B3_Ref }
  object { _Leaf2B9_2B2_1B4_Ref }
  object { _Leaf2B9_2B2_1B5_Ref }
  object { _Leaf2B9_2B2_1B6_Ref }
  object { _Leaf2B9_2B2_1B7_Ref }
  object { _Leaf2B9_2B3_1B1_Ref }
  object { _Leaf2B9_2B3_1B2_Ref }
  object { _Leaf2B9_2B3_1B3_Ref }
  object { _Leaf2B9_2B3_1B4_Ref }
  object { _Leaf2B9_2B3_1B5_Ref }
  object { _Leaf2B9_2B3_1B6_Ref }
  object { _Leaf2B9_2B3_1B7_Ref }
  object { _Leaf2B9_2B4_1B1_Ref }
  object { _Leaf2B9_2B4_1B2_Ref }
  object { _Leaf2B9_2B4_1B3_Ref }
  object { _Leaf2B9_2B4_1B4_Ref }
  object { _Leaf2B9_2B4_1B5_Ref }
  object { _Leaf2B9_2B4_1B6_Ref }
  object { _Leaf2B9_2B4_1B7_Ref }
  object { _Leaf2B9_2B5_1B1_Ref }
  object { _Leaf2B9_2B5_1B2_Ref }
  object { _Leaf2B9_2B5_1B3_Ref }
  object { _Leaf2B9_2B5_1B4_Ref }
  object { _Leaf2B9_2B5_1B5_Ref }
  object { _Leaf2B9_2B5_1B6_Ref }
  object { _Leaf2B9_2B5_1B7_Ref }
  object { _Leaf2B9_1B1_1B1_Ref }
  object { _Leaf2B9_1B1_1B2_Ref }
  object { _Leaf2B9_1B1_1B3_Ref }
  object { _Leaf2B9_1B1_1B4_Ref }
  object { _Leaf2B9_1B1_1B5_Ref }
  object { _Leaf2B9_1B1_1B6_Ref }
  object { _Leaf2B9_1B1_1B7_Ref }
  object { _Leaf2B9_1B2_1B1_Ref }
  object { _Leaf2B9_1B2_1B2_Ref }
  object { _Leaf2B9_1B2_1B3_Ref }
  object { _Leaf2B9_1B2_1B4_Ref }
  object { _Leaf2B9_1B2_1B5_Ref }
  object { _Leaf2B9_1B2_1B6_Ref }
  object { _Leaf2B9_1B2_1B7_Ref }
  object { _Leaf2B9_1B3_1B1_Ref }
  object { _Leaf2B9_1B3_1B2_Ref }
  object { _Leaf2B9_1B3_1B3_Ref }
  object { _Leaf2B9_1B3_1B4_Ref }
  object { _Leaf2B9_1B3_1B5_Ref }
  object { _Leaf2B9_1B3_1B6_Ref }
  object { _Leaf2B9_1B3_1B7_Ref }
  object { _Leaf2B9_1B4_1B1_Ref }
  object { _Leaf2B9_1B4_1B2_Ref }
  object { _Leaf2B9_1B4_1B3_Ref }
  object { _Leaf2B9_1B4_1B4_Ref }
  object { _Leaf2B9_1B4_1B5_Ref }
  object { _Leaf2B9_1B4_1B6_Ref }
  object { _Leaf2B9_1B4_1B7_Ref }
  object { _Leaf2B9_1B5_1B1_Ref }
  object { _Leaf2B9_1B5_1B2_Ref }
  object { _Leaf2B9_1B5_1B3_Ref }
  object { _Leaf2B9_1B5_1B4_Ref }
  object { _Leaf2B9_1B5_1B5_Ref }
  object { _Leaf2B9_1B5_1B6_Ref }
  object { _Leaf2B9_1B5_1B7_Ref }
  object { _Leaf2B9_1B6_1B1_Ref }
  object { _Leaf2B9_1B6_1B2_Ref }
  object { _Leaf2B9_1B6_1B3_Ref }
  object { _Leaf2B9_1B6_1B4_Ref }
  object { _Leaf2B9_1B6_1B5_Ref }
  object { _Leaf2B9_1B6_1B6_Ref }
  object { _Leaf2B9_1B6_1B7_Ref }
  object { _Leaf2B9_1B7_1B1_Ref }
  object { _Leaf2B9_1B7_1B2_Ref }
  object { _Leaf2B9_1B7_1B3_Ref }
  object { _Leaf2B9_1B7_1B4_Ref }
  object { _Leaf2B9_1B7_1B5_Ref }
  object { _Leaf2B9_1B7_1B6_Ref }
  object { _Leaf2B9_1B7_1B7_Ref }
  object { _Leaf2B9_1B8_1B1_Ref }
  object { _Leaf2B9_1B8_1B2_Ref }
  object { _Leaf2B9_1B8_1B3_Ref }
  object { _Leaf2B9_1B8_1B4_Ref }
  object { _Leaf2B9_1B8_1B5_Ref }
  object { _Leaf2B9_1B8_1B6_Ref }
  object { _Leaf2B9_1B8_1B7_Ref }
  object { _Leaf2B10_2B1_1B1_Ref }
  object { _Leaf2B10_2B1_1B2_Ref }
  object { _Leaf2B10_2B1_1B3_Ref }
  object { _Leaf2B10_2B1_1B4_Ref }
  object { _Leaf2B10_2B1_1B5_Ref }
  object { _Leaf2B10_2B1_1B6_Ref }
  object { _Leaf2B10_2B1_1B7_Ref }
  object { _Leaf2B10_2B2_1B1_Ref }
  object { _Leaf2B10_2B2_1B2_Ref }
  object { _Leaf2B10_2B2_1B3_Ref }
  object { _Leaf2B10_2B2_1B4_Ref }
  object { _Leaf2B10_2B2_1B5_Ref }
  object { _Leaf2B10_2B2_1B6_Ref }
  object { _Leaf2B10_2B2_1B7_Ref }
  object { _Leaf2B10_2B3_1B1_Ref }
  object { _Leaf2B10_2B3_1B2_Ref }
  object { _Leaf2B10_2B3_1B3_Ref }
  object { _Leaf2B10_2B3_1B4_Ref }
  object { _Leaf2B10_2B3_1B5_Ref }
  object { _Leaf2B10_2B3_1B6_Ref }
  object { _Leaf2B10_2B3_1B7_Ref }
  object { _Leaf2B10_2B4_1B1_Ref }
  object { _Leaf2B10_2B4_1B2_Ref }
  object { _Leaf2B10_2B4_1B3_Ref }
  object { _Leaf2B10_2B4_1B4_Ref }
  object { _Leaf2B10_2B4_1B5_Ref }
  object { _Leaf2B10_2B4_1B6_Ref }
  object { _Leaf2B10_2B4_1B7_Ref }
  object { _Leaf2B10_2B5_1B1_Ref }
  object { _Leaf2B10_2B5_1B2_Ref }
  object { _Leaf2B10_2B5_1B3_Ref }
  object { _Leaf2B10_2B5_1B4_Ref }
  object { _Leaf2B10_2B5_1B5_Ref }
  object { _Leaf2B10_2B5_1B6_Ref }
  object { _Leaf2B10_2B5_1B7_Ref }
  object { _Leaf2B10_1B1_1B1_Ref }
  object { _Leaf2B10_1B1_1B2_Ref }
  object { _Leaf2B10_1B1_1B3_Ref }
  object { _Leaf2B10_1B1_1B4_Ref }
  object { _Leaf2B10_1B1_1B5_Ref }
  object { _Leaf2B10_1B1_1B6_Ref }
  object { _Leaf2B10_1B1_1B7_Ref }
  object { _Leaf2B10_1B2_1B1_Ref }
  object { _Leaf2B10_1B2_1B2_Ref }
  object { _Leaf2B10_1B2_1B3_Ref }
  object { _Leaf2B10_1B2_1B4_Ref }
  object { _Leaf2B10_1B2_1B5_Ref }
  object { _Leaf2B10_1B2_1B6_Ref }
  object { _Leaf2B10_1B2_1B7_Ref }
  object { _Leaf2B10_1B3_1B1_Ref }
  object { _Leaf2B10_1B3_1B2_Ref }
  object { _Leaf2B10_1B3_1B3_Ref }
  object { _Leaf2B10_1B3_1B4_Ref }
  object { _Leaf2B10_1B3_1B5_Ref }
  object { _Leaf2B10_1B3_1B6_Ref }
  object { _Leaf2B10_1B3_1B7_Ref }
  object { _Leaf2B10_1B4_1B1_Ref }
  object { _Leaf2B10_1B4_1B2_Ref }
  object { _Leaf2B10_1B4_1B3_Ref }
  object { _Leaf2B10_1B4_1B4_Ref }
  object { _Leaf2B10_1B4_1B5_Ref }
  object { _Leaf2B10_1B4_1B6_Ref }
  object { _Leaf2B10_1B4_1B7_Ref }
  object { _Leaf2B10_1B5_1B1_Ref }
  object { _Leaf2B10_1B5_1B2_Ref }
  object { _Leaf2B10_1B5_1B3_Ref }
  object { _Leaf2B10_1B5_1B4_Ref }
  object { _Leaf2B10_1B5_1B5_Ref }
  object { _Leaf2B10_1B5_1B6_Ref }
  object { _Leaf2B10_1B5_1B7_Ref }
  object { _Leaf2B10_1B6_1B1_Ref }
  object { _Leaf2B10_1B6_1B2_Ref }
  object { _Leaf2B10_1B6_1B3_Ref }
  object { _Leaf2B10_1B6_1B4_Ref }
  object { _Leaf2B10_1B6_1B5_Ref }
  object { _Leaf2B10_1B6_1B6_Ref }
  object { _Leaf2B10_1B6_1B7_Ref }
  object { _Leaf2B10_1B7_1B1_Ref }
  object { _Leaf2B10_1B7_1B2_Ref }
  object { _Leaf2B10_1B7_1B3_Ref }
  object { _Leaf2B10_1B7_1B4_Ref }
  object { _Leaf2B10_1B7_1B5_Ref }
  object { _Leaf2B10_1B7_1B6_Ref }
  object { _Leaf2B10_1B7_1B7_Ref }
  object { _Leaf2B10_1B8_1B1_Ref }
  object { _Leaf2B10_1B8_1B2_Ref }
  object { _Leaf2B10_1B8_1B3_Ref }
  object { _Leaf2B10_1B8_1B4_Ref }
  object { _Leaf2B10_1B8_1B5_Ref }
  object { _Leaf2B10_1B8_1B6_Ref }
  object { _Leaf2B10_1B8_1B7_Ref }
  texture {
    HojasTex1_4
  }
}
union { // ArbolMB
  object { ArbolB_Limbs }
  object { ArbolB_Leafs }
  scale 0.3
  rotate -180.0*z
  translate  <-16.216628, -26.056217, -10.918698>
}


#declare Tallo3 = union {
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.3, 0.3, 0.4>
    rotate 5.2*y
    translate  <-0.065345, 0.0, -1.479031>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.25, 0.25, 2.0>
    rotate <-180.0, 5.64439, -0.0>
    translate  <0.160309, 0.0, 0.779651>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 6.8>
    translate  -0.8*z
  }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 1.2>
    rotate <180.0, 5.64439, -0.0>
    translate  <0.060186, 0.0, -0.222232>
  }
  texture {
    TroncoTex
  }
}
#declare HojasPet = union {
  object { sPatchObj4 }
  object { // sPatchObj7->sPatchObj4
    sPatchObj4
    rotate <-0.0, -0.400002, -30.0>
    translate  <0.00086, -0.004112, 0.044414>
  }
  object { // sPatchObj17->sPatchObj4
    sPatchObj4
    rotate <-0.0, -0.800003, -60.0>
    translate  <-0.001626, -0.009455, 0.086035>
  }
  object { // sPatchObj18->sPatchObj4
    sPatchObj4
    rotate <-0.0, -1.199997, -90.0>
    translate  <-0.008031, -0.013538, 0.125617>
  }
  object { // sPatchObj19->sPatchObj4
    sPatchObj4
    rotate <-0.0, -1.599998, -120.0>
    translate  <-0.017235, -0.013789, 0.164467>
  }
  object { // sPatchObj20->sPatchObj4
    sPatchObj4
    rotate <-0.0, -2.0, -150.0>
    translate  <-0.026588, -0.008627, 0.204093>
  }
  object { // sPatchObj21->sPatchObj4
    sPatchObj4
    rotate <-0.0, -2.400002, -180.0>
    translate  <-0.032703, 0.001719, 0.2458>
  }
  object { // sPatchObj22->sPatchObj4
    sPatchObj4
    rotate <-0.0, -2.800003, 150.0>
    translate  <-0.032627, 0.014959, 0.290341>
  }
  object { // sPatchObj23->sPatchObj4
    sPatchObj4
    rotate <-0.0, -3.199997, 120.0>
    translate  <-0.02503, 0.027218, 0.337716>
  }
  object { // sPatchObj24->sPatchObj4
    sPatchObj4
    rotate <-0.0, -3.599998, 90.0>
    translate  <-0.010974, 0.03416, 0.38717>
  }
  object { // sPatchObj25->sPatchObj4
    sPatchObj4
    rotate <-0.0, -4.0, 60.0>
    translate  <0.00605, 0.032427, 0.437398>
  }
  object { // sPatchObj26->sPatchObj4
    sPatchObj4
    rotate <-0.0, -4.400002, 30.0>
    translate  <0.020918, 0.020947, 0.486892>
  }
  object { // sPatchObj27->sPatchObj4
    sPatchObj4
    rotate <-0.0, -4.800003, -0.0>
    translate  <0.028329, 0.001654, 0.534347>
  }
  object { // sPatchObj28->sPatchObj4
    sPatchObj4
    rotate <-0.0, -5.199997, -30.0>
    translate  <0.024523, -0.020699, 0.579012>
  }
  object { // sPatchObj29->sPatchObj4
    sPatchObj4
    rotate <-0.0, -5.599998, -60.0>
    translate  <0.008707, -0.039672, 0.620887>
  }
  object { // sPatchObj30->sPatchObj4
    sPatchObj4
    rotate <-0.0, -6.0, -90.0>
    translate  <-0.016286, -0.048953, 0.660729>
  }
  object { // sPatchObj31->sPatchObj4
    sPatchObj4
    rotate <-0.0, -6.400002, -120.0>
    translate  <-0.044411, -0.04435, 0.699842>
  }
  object { // sPatchObj32->sPatchObj4
    sPatchObj4
    rotate <-0.0, -6.799999, -150.0>
    translate  <-0.067887, -0.025357, 0.739736>
  }
  object { // sPatchObj33->sPatchObj4
    sPatchObj4
    rotate <-0.0, -7.200001, -180.0>
    translate  <-0.079375, 0.004253, 0.781715>
  }
  object { // sPatchObj34->sPatchObj4
    sPatchObj4
    rotate <-0.0, -7.599998, 150.0>
    translate  <-0.074259, 0.037085, 0.826532>
  }
  object { // sPatchObj35->sPatchObj4
    sPatchObj4
    rotate <-0.0, -8.0, 120.0>
    translate  <-0.052337, 0.063954, 0.874186>
  }
  object { // sPatchObj36->sPatchObj4
    sPatchObj4
    rotate <-0.0, -8.400002, 90.0>
    translate  <-0.018349, 0.076443, 0.92392>
  }
  object { // sPatchObj37->sPatchObj4
    sPatchObj4
    rotate <-0.0, -8.799999, 60.0>
    translate  <0.01893, 0.069486, 0.97443>
  }
  object { // sPatchObj38->sPatchObj4
    sPatchObj4
    rotate <-0.0, -9.200001, 30.0>
    translate  <0.048887, 0.043193, 1.024208>
  }
  object { // sPatchObj39->sPatchObj4
    sPatchObj4
    rotate <-0.0, -9.599998, -0.0>
    translate  <0.062016, 0.003309, 1.071949>
  }
  object { // sPatchObj40->sPatchObj4
    sPatchObj4
    rotate <-0.0, -10.0, -30.0>
    translate  <0.052806, -0.039954, 1.116902>
  }
  object { // sPatchObj41->sPatchObj4
    sPatchObj4
    rotate <-0.0, -10.400002, -60.0>
    translate  <0.021695, -0.07449, 1.159069>
  }
  object { // sPatchObj42->sPatchObj4
    sPatchObj4
    rotate <-0.0, -10.799999, -90.0>
    translate  <-0.024541, -0.089656, 1.199206>
  }
  object { // sPatchObj43->sPatchObj4
    sPatchObj4
    rotate <-0.0, -11.200001, -120.0>
    translate  <-0.074219, -0.07947, 1.23862>
  }
  object { // sPatchObj44->sPatchObj4
    sPatchObj4
    rotate <-0.0, -11.599998, -150.0>
    translate  <-0.113724, -0.044708, 1.278818>
  }
  object { // sPatchObj45->sPatchObj4
    sPatchObj4
    rotate <-0.0, -12.0, -180.0>
    translate  <-0.131264, 0.006787, 1.321106>
  }
  object { // sPatchObj46->sPatchObj4
    sPatchObj4
    rotate <-0.0, -12.400002, 150.0>
    translate  <-0.120388, 0.061807, 1.366236>
  }
  object { // sPatchObj47->sPatchObj4
    sPatchObj4
    rotate <-0.0, -12.799999, 120.0>
    translate  <-0.082229, 0.105164, 1.414204>
  }
  object { // sPatchObj48->sPatchObj4
    sPatchObj4
    rotate <-0.0, -13.200001, 90.0>
    translate  <-0.025724, 0.123868, 1.464255>
  }
  object { // sPatchObj49->sPatchObj4
    sPatchObj4
    rotate <-0.0, -13.599998, 60.0>
    translate  <0.034369, 0.110977, 1.515083>
  }
  object { // sPatchObj50->sPatchObj4
    sPatchObj4
    rotate <-0.0, -14.0, 30.0>
    translate  <0.081266, 0.067986, 1.56518>
  }
  object { // sPatchObj51->sPatchObj4
    sPatchObj4
    rotate <-0.0, -14.400002, -0.0>
    translate  <0.10077, 0.004963, 1.613242>
  }
  object { // sPatchObj52->sPatchObj4
    sPatchObj4
    rotate <-0.0, -14.799999, -30.0>
    translate  <0.085454, -0.061729, 1.658519>
  }
  object { // sPatchObj53->sPatchObj4
    sPatchObj4
    rotate <-0.0, -15.200001, -60.0>
    translate  <0.03719, -0.11365, 1.701012>
  }
  object { // sPatchObj54->sPatchObj4
    sPatchObj4
    rotate <-0.0, -15.599998, -90.0>
    translate  <-0.032795, -0.135348, 1.74148>
  }
  object { // sPatchObj55->sPatchObj4
    sPatchObj4
    rotate <-0.0, -16.0, -120.0>
    translate  <-0.106508, -0.118887, 1.781229>
  }
  object { // sPatchObj56->sPatchObj4
    sPatchObj4
    rotate <-0.0, -16.400002, -150.0>
    translate  <-0.163835, -0.066525, 1.821767>
  }
  object { // sPatchObj57->sPatchObj4
    sPatchObj4
    rotate <-0.0, -16.799999, -180.0>
    translate  <-0.188061, 0.00932, 1.864398>
  }
  object { // sPatchObj58->sPatchObj4
    sPatchObj4
    rotate <-0.0, -17.200001, 150.0>
    translate  <-0.170744, 0.08897, 1.909874>
  }
  object { // sPatchObj59->sPatchObj4
    sPatchObj4
    rotate <-0.0, -17.599998, 120.0>
    translate  <-0.114546, 0.150578, 1.958191>
  }
  object { // sPatchObj60->sPatchObj4
    sPatchObj4
    rotate <-0.0, -18.0, 90.0>
    translate  <-0.0331, 0.176118, 2.008592>
  }
  object { // sPatchObj61->sPatchObj4
    sPatchObj4
    rotate <-0.0, -18.400002, 60.0>
    translate  <0.052206, 0.156623, 2.059772>
  }
  object { // sPatchObj62->sPatchObj4
    sPatchObj4
    rotate <-0.0, -18.799999, 30.0>
    translate  <0.117775, 0.095162, 2.110221>
  }
  object { // sPatchObj63->sPatchObj4
    sPatchObj4
    rotate <-0.0, -19.200001, -0.0>
    translate  <0.144263, 0.006617, 2.158638>
  }
  object { // sPatchObj64->sPatchObj4
    sPatchObj4
    rotate <-0.0, -19.599998, -30.0>
    translate  <0.122182, -0.085859, 2.204271>
  }
  object { // sPatchObj65->sPatchObj4
    sPatchObj4
    rotate <-0.0, -20.0, -60.0>
    translate  <0.055026, -0.156864, 2.247124>
  }
  object { // sPatchObj66->sPatchObj4
    sPatchObj4
    rotate <-0.0, -20.400002, -90.0>
    translate  <-0.04105, -0.185692, 2.287955>
  }
  object { // sPatchObj67->sPatchObj4
    sPatchObj4
    rotate <-0.0, -20.799999, -120.0>
    translate  <-0.141109, -0.162308, 2.328071>
  }
  object { // sPatchObj68->sPatchObj4
    sPatchObj4
    rotate <-0.0, -21.200001, -150.0>
    translate  <-0.217924, -0.09064, 2.36898>
  }
  object { // sPatchObj69->sPatchObj4
    sPatchObj4
    rotate <-0.0, -21.599998, -180.0>
    translate  <-0.249421, 0.011854, 2.411987>
  }
  object { // sPatchObj70->sPatchObj4
    sPatchObj4
    rotate <-0.0, -22.0, 150.0>
    translate  <-0.225026, 0.118399, 2.457841>
  }
  object { // sPatchObj71->sPatchObj4
    sPatchObj4
    rotate <-0.0, -22.400002, 120.0>
    translate  <-0.149116, 0.199891, 2.506538>
  }
  object { // sPatchObj72->sPatchObj4
    sPatchObj4
    rotate <-0.0, -22.799999, 90.0>
    translate  <-0.040475, 0.232841, 2.557321>
  }
  object { // sPatchObj73->sPatchObj4
    sPatchObj4
    rotate <-0.0, -23.200001, 60.0>
    translate  <0.072264, 0.206115, 2.608883>
  }
  object { // sPatchObj74->sPatchObj4
    sPatchObj4
    rotate <-0.0, -23.599998, 30.0>
    translate  <0.158103, 0.124545, 2.659717>
  }
  object { // sPatchObj75->sPatchObj4
    sPatchObj4
    rotate <-0.0, -24.0, -0.0>
    translate  <0.192137, 0.008272, 2.708518>
  }
  object { // sPatchObj76->sPatchObj4
    sPatchObj4
    rotate <-0.0, -24.400002, -30.0>
    translate  <0.162676, -0.112164, 2.754538>
  }
  object { // sPatchObj77->sPatchObj4
    sPatchObj4
    rotate <-0.0, -24.799999, -60.0>
    translate  <0.075021, -0.203818, 2.79778>
  }
  object { // sPatchObj78->sPatchObj4
    sPatchObj4
    rotate <-0.0, -25.200001, -90.0>
    translate  <-0.049305, -0.240322, 2.839005>
  }
  object { // sPatchObj79->sPatchObj4
    sPatchObj4
    rotate <-0.0, -25.599998, -120.0>
    translate  <-0.177836, -0.209412, 2.879518>
  }
  object { // sPatchObj80->sPatchObj4
    sPatchObj4
    rotate <-0.0, -26.0, -150.0>
    translate  <-0.275669, -0.116865, 2.920829>
  }
  object { // sPatchObj81->sPatchObj4
    sPatchObj4
    rotate <-0.0, -26.400002, -180.0>
    translate  <-0.31497, 0.014388, 2.96424>
  }
  object { // sPatchObj82->sPatchObj4
    sPatchObj4
    rotate <-0.0, -26.799999, 150.0>
    translate  <-0.282907, 0.149906, 3.010501>
  }
  object { // sPatchObj83->sPatchObj4
    sPatchObj4
    rotate <-0.0, -27.200001, 120.0>
    translate  <-0.185747, 0.252775, 3.059607>
  }
  object { // sPatchObj84->sPatchObj4
    sPatchObj4
    rotate <-0.0, -27.599998, 90.0>
    translate  <-0.04785, 0.293654, 3.110801>
  }
  object { // sPatchObj85->sPatchObj4
    sPatchObj4
    rotate <-0.0, -28.0, 60.0>
    translate  <0.09435, 0.259121, 3.162774>
  }
  object { // sPatchObj86->sPatchObj4
    sPatchObj4
    rotate <-0.0, -28.400002, 30.0>
    translate  <0.201916, 0.155938, 3.214019>
  }
  object { // sPatchObj87->sPatchObj4
    sPatchObj4
    rotate <-0.0, -28.799999, -0.0>
    translate  <0.243999, 0.009926, 3.263233>
  }
  object { // sPatchObj88->sPatchObj4
    sPatchObj4
    rotate <-0.0, -29.200001, -30.0>
    translate  <0.206595, -0.140447, 3.309668>
  }
  object { // sPatchObj89->sPatchObj4
    sPatchObj4
    rotate <-0.0, -29.599998, -60.0>
    translate  <0.096977, -0.254167, 3.353328>
  }
  object { // sPatchObj90->sPatchObj4
    sPatchObj4
    rotate <-0.0, -30.0, -90.0>
    translate  <-0.057559, -0.298838, 3.394973>
  }
  object { // sPatchObj91->sPatchObj4
    sPatchObj4
    rotate <-0.0, -30.400002, -120.0>
    translate  <-0.21649, -0.259853, 3.43591>
  }
  object { // sPatchObj92->sPatchObj4
    sPatchObj4
    rotate <-0.0, -30.799999, -150.0>
    translate  <-0.33672, -0.144999, 3.477649>
  }
  object { // sPatchObj93->sPatchObj4
    sPatchObj4
    rotate <-0.0, -31.200001, -180.0>
    translate  <-0.384302, 0.016921, 3.521491>
  }
  object { // sPatchObj94->sPatchObj4
    sPatchObj4
    rotate <-0.0, -31.599998, 150.0>
    translate  <-0.344034, 0.183288, 3.568186>
  }
  object { // sPatchObj95->sPatchObj4
    sPatchObj4
    rotate <-0.0, -32.0, 120.0>
    translate  <-0.224234, 0.308875, 3.617727>
  }
  object { // sPatchObj96->sPatchObj4
    sPatchObj4
    rotate <-0.0, -32.400002, 90.0>
    translate  <-0.055226, 0.358144, 3.669357>
  }
  object { // sPatchObj97->sPatchObj4
    sPatchObj4
    rotate <-0.0, -32.799999, 60.0>
    translate  <0.118258, 0.31528, 3.721767>
  }
  object { // sPatchObj98->sPatchObj4
    sPatchObj4
    rotate <-0.0, -33.200001, 30.0>
    translate  <0.248853, 0.189135, 3.773449>
  }
  object { // sPatchObj99->sPatchObj4
    sPatchObj4
    rotate <-0.0, -33.599998, -0.0>
    translate  <0.299433, 0.01158, 3.823101>
  }
  object { // sPatchObj100->sPatchObj4
    sPatchObj4
    rotate <-0.0, -34.0, -30.0>
    translate  <0.253576, -0.170497, 3.869975>
  }
  object { // sPatchObj101->sPatchObj4
    sPatchObj4
    rotate <-0.0, -34.400002, -60.0>
    translate  <0.120682, -0.307547, 3.914077>
  }
  object { // sPatchObj102->sPatchObj4
    sPatchObj4
    rotate <-0.0, -34.799999, -90.0>
    translate  <-0.065814, -0.360817, 3.956166>
  }
  object { // sPatchObj103->sPatchObj4
    sPatchObj4
    rotate <-0.0, -35.200001, -120.0>
    translate  <-0.256856, -0.31326, 3.997552>
  }
  object { // sPatchObj104->sPatchObj4
    sPatchObj4
    rotate <-0.0, -35.599998, -150.0>
    translate  <-0.400706, -0.174828, 4.039743>
  }
  object { // sPatchObj105->sPatchObj4
    sPatchObj4
    rotate <-0.0, -36.0, -180.0>
    translate  <-0.456986, 0.019455, 4.084039>
  }
  object { // sPatchObj106->sPatchObj4
    sPatchObj4
    rotate <-0.0, -36.400002, 150.0>
    translate  <-0.408032, 0.218327, 4.131191>
  }
  object { // sPatchObj107->sPatchObj4
    sPatchObj4
    rotate <-0.0, -36.799999, 120.0>
    translate  <-0.26436, 0.367813, 4.181191>
  }
  object { // sPatchObj108->sPatchObj4
    sPatchObj4
    rotate <-0.0, -37.200001, 90.0>
    translate  <-0.062601, 0.425875, 4.23328>
  }
  object { // sPatchObj109->sPatchObj4
    sPatchObj4
    rotate <-0.0, -37.599998, 60.0>
    translate  <0.143767, 0.374214, 4.286148>
  }
  object { // sPatchObj110->sPatchObj4
    sPatchObj4
    rotate <-0.0, -38.0, 30.0>
    translate  <0.29853, 0.223915, 4.33829>
  }
  object { // sPatchObj111->sPatchObj4
    sPatchObj4
    rotate <-0.0, -38.400002, -0.0>
    translate  <0.357994, 0.013235, 4.388402>
  }
  object { // sPatchObj112->sPatchObj4
    sPatchObj4
    rotate <-0.0, -38.799999, -30.0>
    translate  <0.303232, -0.202091, 4.435737>
  }
  object { // sPatchObj113->sPatchObj4
    sPatchObj4
    rotate <-0.0, -39.200001, -60.0>
    translate  <0.145912, -0.363568, 4.480302>
  }
  object { // sPatchObj114->sPatchObj4
    sPatchObj4
    rotate <-0.0, -39.600002, -90.0>
    translate  <-0.074068, -0.425809, 4.522857>
  }
  object { // sPatchObj115->sPatchObj4
    sPatchObj4
    rotate <-0.0, -40.0, -120.0>
    translate  <-0.29871, -0.369243, 4.564713>
  }
  object { // sPatchObj116->sPatchObj4
    sPatchObj4
    rotate <-0.0, -40.400002, -150.0>
    translate  <-0.467234, -0.206124, 4.607375>
  }
  object { // sPatchObj117->sPatchObj4
    sPatchObj4
    rotate <-0.0, -40.799999, -180.0>
    translate  <-0.532567, 0.021989, 4.652147>
  }
  object { // sPatchObj118->sPatchObj4
    sPatchObj4
    rotate <-0.0, -41.200001, 150.0>
    translate  <-0.474504, 0.254795, 4.699776>
  }
  object { // sPatchObj119->sPatchObj4
    sPatchObj4
    rotate <-0.0, -41.600002, 120.0>
    translate  <-0.305896, 0.429192, 4.750253>
  }
  object { // sPatchObj120->sPatchObj4
    sPatchObj4
    rotate <-0.0, -42.0, 90.0>
    translate  <-0.069977, 0.496386, 4.802821>
  }
  object { // sPatchObj121->sPatchObj4
    sPatchObj4
    rotate <-0.0, -42.400002, 60.0>
    translate  <0.170646, 0.43552, 4.856168>
  }
  object { // sPatchObj122->sPatchObj4
    sPatchObj4
    rotate <-0.0, -42.799999, 30.0>
    translate  <0.350547, 0.260045, 4.908787>
  }
  object { // sPatchObj123->sPatchObj4
    sPatchObj4
    rotate <-0.0, -43.200001, -0.0>
    translate  <0.419216, 0.014889, 4.959378>
  }
  object { // sPatchObj124->sPatchObj4
    sPatchObj4
    rotate <-0.0, -43.600002, -30.0>
    translate  <0.355158, -0.234996, 5.007193>
  }
  object { // sPatchObj125->sPatchObj4
    sPatchObj4
    rotate <-0.0, -44.0, -60.0>
    translate  <0.172433, -0.421826, 5.052239>
  }
  object { // sPatchObj126->sPatchObj4
    sPatchObj4
    rotate <-0.0, -44.400002, -90.0>
    translate  <-0.082323, -0.493342, 5.095279>
  }
  object { // sPatchObj127->sPatchObj4
    sPatchObj4
    rotate <-0.0, -44.799999, -120.0>
    translate  <-0.341814, -0.427393, 5.137621>
  }
  object { // sPatchObj128->sPatchObj4
    sPatchObj4
    rotate <-0.0, -45.200001, -150.0>
    translate  <-0.535894, -0.238652, 5.180773>
  }
  object { // sPatchObj129->sPatchObj4
    sPatchObj4
    rotate <-0.0, -45.600002, -180.0>
    translate  <-0.610569, 0.024522, 5.226037>
  }
  object { // sPatchObj130->sPatchObj4
    sPatchObj4
    rotate <-0.0, -46.0, 150.0>
    translate  <-0.543039, 0.292453, 5.274159>
  }
  object { // sPatchObj131->sPatchObj4
    sPatchObj4
    rotate <-0.0, -46.400002, 120.0>
    translate  <-0.348602, 0.492598, 5.325132>
  }
  object { // sPatchObj132->sPatchObj4
    sPatchObj4
    rotate <-0.0, -46.799999, 90.0>
    translate  <-0.077352, 0.569196, 5.378193>
  }
  object { // sPatchObj133->sPatchObj4
    sPatchObj4
    rotate <-0.0, -47.200001, 60.0>
    translate  <0.198655, 0.498784, 5.432035>
  }
  object { // sPatchObj134->sPatchObj4
    sPatchObj4
    rotate <-0.0, -47.600002, 30.0>
    translate  <0.404484, 0.297284, 5.485148>
  }
  object { // sPatchObj135->sPatchObj4
    sPatchObj4
    rotate <-0.0, -48.0, -0.0>
    translate  <0.482615, 0.016543, 5.536233>
  }
  texture {
    PuntasTex
  }
}
union { // PlantaF
  object { Tallo3 }
  object { HojasPet }
  scale 0.6
  rotate <20.0, 20.0, -45.0>
  translate  <-13.521821, -20.940821, -7.237547>
}


