// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Un delfin tras un salto "loco".
//--
// This file contains:
//  A dolphin after a "mad" jump.


#include "colors.inc"
#include "textures.inc"


global_settings { assumed_gamma 2.4 }


light_source { <0, 50, 0> White }
light_source {
    <0, 6, -15> Gray50
    fade_power 1
    fade_distance 100
}


camera {
    direction z
    location <0, 6, -15>
    look_at <0, 2, 0>
}


// The sea floor
plane {
    y, 0
    pigment { Gray60 }
    finish { ambient 0.1 diffuse 0.7 }
    normal { wrinkles 2 }
}


// The water surface
plane {
    y, 10
    hollow
    texture {
//        pigment { rgbf <0, 1, .7, .9> }
        pigment { rgbf <0, .7, 1, .9> }
        finish {
            refraction 1
            ior 1.33
            reflection .7
            caustics 1
        }
        translate <5, 0, -10>
        normal {
            bumps .5
            scale .75
        }
    }
}


// To hide far parts
fog {
    fog_type 1
    distance 200
    color rgb .25 * <0, .7, 1>
}


// Dolphin
#declare Dolphin_Texture = 3
#include "dolphin1.inc"
object {
    Dolphin1
    rotate 200 * z
    rotate 180 * y
    translate <-.75, 4, -10>
}


// Test sphere for bubbles
/*
sphere {
    0, .25
    pigment { Red }
    translate <.25, 4, -10>
}
*/


// Basic bubble
#declare Bubble =
    sphere {
        0, .02
/*        texture {
            pigment { rgbt <1, 1, 1, .95> }
            finish {
                specular .5
                refraction 1
                ior 1/1.33
                reflection .3
                caustics 1
            }
        }*/
        texture {
            pigment { rgbt <1, 1, 1, .975> }
            finish {
                specular .5
                refraction 1
                ior 1/1.33
                reflection .1
                caustics 1
            }
        }
    }


// Far bubbles
#declare MaxBubbles1 = 400
#declare BubbleSeed1 = seed (102)
union {
    #while (MaxBubbles1 > 0)
        #declare Val1 = rand (BubbleSeed1)
        #declare BubbleY1 = .4 + (3.6 * cos (Val1 * pi * .5))
        #declare BubbleX1 = BubbleY1 * rand (BubbleSeed1) * .5
        #declare BubbleRot1 = 360 * rand (BubbleSeed1)
        #declare BubbleScale1 = .5 + rand (BubbleSeed1)
        object {
            Bubble
            scale BubbleScale1
            translate <BubbleX1, BubbleY1, 0>
            rotate BubbleRot1 * y
        }
        #declare MaxBubbles1 = MaxBubbles1 - 1
    #end  // while Maxbubbles1 > 0
    rotate -30 * z
    translate <.325, 3.8, -10>
}


// Body bubbles
#declare MaxBubbles2 = 60
#declare BubbleSeed2 = seed (103)
union {
    #while (MaxBubbles2 > 0)
        #declare Val2 = rand (BubbleSeed2)
        #declare BubbleY2 = 1.5 * cos (Val2 * pi * .5)
        #declare BubbleX2 = .3 + (BubbleY2 * rand (BubbleSeed2) * .2)
        #declare BubbleRot2 = 360 * rand (BubbleSeed2)
        #declare BubbleScale2 = .5 + rand (BubbleSeed2)
        object {
            Bubble
            scale BubbleScale2
            translate <BubbleX2, BubbleY2, 0>
            rotate BubbleRot2 * y
        }
        #declare MaxBubbles2 = MaxBubbles2 - 1
    #end  // while Maxbubbles2 > 0
    rotate -80 * z
    translate <-1, 4, -10>
}


// Test box for particles
/*
box {
    <-10, 0, -12>, <3, 8, 0>
    pigment { Green }
}
*/

// dust to add some "noise"
#declare RandDustRelease = 0.9
#declare RD_VolumeType = "RD_Box"
#declare RD_MaxScale = 2
#declare RD_MinScale = 1
#declare RD_NumberOfParticles = 100
#declare RD_CurrentSeed = 101
#declare RD_Particle =
    sphere {
        0, 1
        texture {
            pigment { Clear }
            halo {
                attenuating
                linear
                spherical_mapping
                color_map {
                    [ 0 color rgbt <0, 0, 0, 1> ]
                    [ 1 color rgbt <1, 1, 1, .4> ]
                }
                turbulence .1
                samples 5
                aa_level 0
                aa_threshold 0.3
                scale 1.5
            }
        }
        hollow
        scale .02
    }
#declare RD_GlobalTransf =
    transform {
        scale 1
    }
#declare RD_BoxMax = <10, 8, 0>
#declare RD_BoxMin = <-10, 0, -12>
#declare RD_BoxHoleMax = <0, 0, 0>
#declare RD_BoxHoleMin = <0, 0, 0>
#include "randdust.inc"


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
