/*
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------


*/


//-----------------worm2.inc-----------------------------
#ifndef (WsegRot) #declare WsegRot  = 0 #end

#ifndef (Wing_angle) #declare Wing_angle = 25 #end
#ifndef (Minus_Wing_angle) #declare Minus_Wing_angle = -25 #end
#ifndef (Tval) #declare Tval = 0.5 #end

#declare Wing_Texture = texture{
      pigment{
           radial
           frequency 15
           turbulence 0.15
                 color_map{
                      [0.00 color Red transmit Tval]
                      [0.15 color Orange transmit Tval]
                      [0.30 color Yellow transmit Tval]
                      [0.45 color Green transmit Tval]
                      [0.60 color Cyan transmit Tval]
                      [0.75 color Blue transmit Tval]
                      [0.90 color Magenta transmit Tval]
                      }
                      rotate x*90
          }
      finish{
      specular 0.75
        irid {
          0.3
          thickness .25
          turbulence .25
        }
     }
     scale 0.2
  }



#declare Spine = union{
#declare Rad = 20
#declare StAngle = 0.125//Increasing gives tighter curve
#declare Inc = 0.1
#declare SDiam = 0.55
#declare SDiam_inc = 0.01
#declare Count = 0.5

#while (Count <250)
       #declare Angle = radians(StAngle * Count)

            #declare Cox = (Rad + Inc) *(sin(Angle))
            #declare Coy = Rad*(cos(Angle))
            #declare Point = <Cox,Coy,0>

                object{sphere{<0,0,0>,SDiam - SDiam_inc
                        }
                        translate Point
                            scale <2,1,1>}

            #declare SDiam_inc = SDiam_inc + 0.01
        #declare Count = Count + 5
#end
}

#declare Wing_secV2 = object {
bicubic_patch  {
   type	1
   flatness	0.0
   u_steps	5
   v_steps	5
   <-3.260, 1.880, 0.000>,
   <-0.948, 1.365, 0.000>,
   <0.918, 0.933, 0.000>,
   <4.666, 0.202, 0.000>,
   <-3.062, 0.800, -1.149>,
   <-0.932, 0.534, -0.505>,
   <0.967, 0.335, -0.257>,
   <4.815, 0.069, 0.000>,
   <-3.045, -0.778, -1.116>,
   <-0.965, -0.529, -0.522>,
   <0.967, -0.396, -0.241>,
   <4.831, -0.097, 0.000>,
   <-3.343, -1.990, 0.000>,
   <-0.981, -1.459, 0.000>,
   <0.967, -0.927, 0.000>,
   <4.666, -0.180, 0.000>
}
scale 0.3
#if (WsegRot = 1) rotate x*180 #end
}




#declare Wing_Fan = union{
object{Wing_secV2
    texture {Wing_Texture}
	rotate < 0, 0, 25.5>
	scale < 0.5, 0.5, 0.5 >
    translate<0.075,-0.335,0>

}

object{Wing_secV2
    texture {Wing_Texture}
	rotate < 0, 0, 0>
	scale < 0.5, 0.5, 0.5 >

}

object{Wing_secV2
    texture {Wing_Texture}
	rotate < 0, 0, -25>
	scale < 0.5, 0.5, 0.5 >
    translate<0.1,0.335,0>

}

//top spine
object{Spine scale 0.075 rotate z*148 translate<1.5,1.375,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}

object{Spine scale 0.075 rotate z*175 translate<0.8175,1.55,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}

object{Spine scale 0.075 rotate z*200 translate<0.175,1.42,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}
//bottom
object{Spine scale 0.075 rotate z*225 translate<-0.36,1.03,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}

}

//-------------------------------Wing 2---------------------------------

#declare Spine2 = union{
#declare Rad = 20
#declare StAngle = 0.125//Increasing gives tighter curve
#declare Inc = 0.1
#declare SDiam = 0.55
#declare SDiam_inc = 0.01
#declare Count = 0.5

#while (Count <250)
       #declare Angle = radians(StAngle * Count)

            #declare Cox = (Rad + Inc) *(sin(Angle))
            #declare Coy = Rad*(cos(Angle))
            #declare Point = <Cox,Coy,0>

                object{sphere{<0,0,0>,SDiam - SDiam_inc
                        }
                        translate Point
                            scale <2,1,1>}

            #declare SDiam_inc = SDiam_inc + 0.01
        #declare Count = Count + 5
#end
rotate x*180
}






#declare Wing_Fan2 = union{
object{Wing_secV2
    texture {Wing_Texture}
	rotate < 0, 0, 25.>
	scale < 0.5, 0.5, 0.5 >
    translate<0.075,-0.335,0>

}

object{Wing_secV2
    texture {Wing_Texture}
	rotate < 0, 0, 0>
	scale < 0.5, 0.5, 0.5 >

}

object{Wing_secV2
    texture {Wing_Texture}
	rotate < 0, 0, -25.5>
	scale < 0.5, 0.5, 0.5 >
    translate<0.1,0.335,0>

}

//top spine
object{Spine2 scale 0.075 rotate z*135 translate<-0.345,-1.025,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}

object{Spine2 scale 0.075 rotate z*160 translate<0.19,-1.425,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}

object{Spine2 scale 0.075 rotate z*185 translate<0.85,-1.56,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}

//bottom
object{Spine2 scale 0.075 rotate z*211 translate<1.5,-1.39,0>
texture{pigment{radial frequency 10 rotate x*90}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}}

}

//------------------------------------------------------------------

#declare Fly_worm = union{
object{Wing_Fan
translate<-0.8,0,0>
rotate y*Minus_Wing_angle
rotate z*20
}

object{Wing_Fan2
rotate z*180
translate<0.8,0.0,0>
rotate y*Wing_angle
rotate z* -20
}
     rotate x*-90 //from front
     rotate y*90 //from side
     rotate z*10 //tilt Back
}
//-----------------------------Worm body-----------------------------------

#declare Eye =union{
sphere { 0.0, 1 texture {
       pigment {
       gradient x scale 1.75 translate<-0.5,0,0>
       pigment_map{
       [0.00 radial frequency 5]
       [0.5 radial color_map{
            [0.00, 0.55 color rgbt<0,0.75,0,0.5> color rgbt<0,0.75,0,0.5>]
            [0.55,0.6 color rgbt<3,0,0,0>  color rgbt<3,0,0,0>]
            [0.6, 0.65 color rgbt<2,2,0,0.2> color rgbt<2,2,0,0.2>]
            [0.65,1.00 color rgbt<0,0.75,0,0.5> color rgbt<0,0.75,0,0.5>]
            } frequency 4 rotate y*-55 turbulence 0.3 ]
            }
       }
       normal{
       gradient x scale 1.75 translate<-0.5,0,0>
       normal_map{
       [0.00 crackle 5 scale 1.5]
       [0.45 marble]}
       }
       }
       finish{specular 1 roughness 0.01}
}
torus{1.00,0.3
             texture{
             pigment{radial frequency 10}
             finish{ambient 0.5 diffuse 0.5 specular 1}
}
rotate <-90,90,0>
translate<0,0,0>
}

rotate y*25
rotate z*-30
scale 0.3
}



// ----------------------------------------
#declare Worm_body = union{
#declare Sdiam = 0.5
#declare Rad = 5
#declare Sdiam_inc = 0.01
#declare Inc = 0
#declare Count = 0
#declare Angle = 0

#while (Count<22)
       sphere{0,Sdiam
       translate <0,Rad + Inc,0>
       rotate z*Angle
       }

    #declare Sdiam = Sdiam - Sdiam_inc
    #declare Angle = Angle + 2
    #declare Count = Count + 1
    #declare Inc = Inc + 0.1
#end
}

#declare Worm_tail = union{
#declare Sdiam = 0
#declare Rad = 5
#declare Sdiam_inc = 0.01
#declare Inc = 0
#declare Count = 0
#declare Angle = 0

#while (Count<30)
       sphere{0,Sdiam
       translate <0,Rad + Inc,0>
       rotate z*Angle
       }

    #declare Sdiam = Sdiam + Sdiam_inc
    #declare Angle = Angle + 2
    #declare Count = Count + 1
    #declare Inc = Inc + 0.1
#end
rotate z*180
}

#declare Worm_head = union{
object{sphere{0,0.5 scale<2,1,1>}}
object{Eye  translate<0.5,0.35,-0.425>}
object{Eye  rotate y *-50 translate<0.5,0.35,0.425>}
}

#declare Worm = union{
object{Worm_body rotate z*5}
object{Worm_tail translate<-12.25,8.875,0>}
object{Worm_head
//texture{pigment{radial frequency 10 turbulence 1}finish{specular 1}}
rotate z*-25 translate<0.5,4.5,0>}
}

#declare beakR = difference{
object{sphere{<0,0,0> 1.00 }scale<1.5,1,1>}
object{sphere{<-0.25,-0.4,0> 1.00 }}
}
#declare beakL = difference{
object{sphere{<0,0,0> 1.00 }scale<1.5,1,1>}
object{sphere{<0.25,-0.4,0> 1.00 }}
}
#declare beak = union{
object{beakR clipped_by { object { plane {z,-0.3} } } translate<0,0,0.3> rotate y*-270 }
object{beakL clipped_by { object { plane {z,-0.3} } } translate<0,0,0.3> rotate y*-90 }
}
#declare underbeak = object{sphere{<0,-0.4,0> 0.4 }}

#declare pecker =union{
object{beak rotate y*-90}
object{underbeak scale<3,1,1.6> rotate z*-17.5}
object{torus{1,0.5 }scale 0.25 rotate x*55 rotate y*25 translate<-0.75,0.25,-0.5>}
object{torus{1,0.5 }scale 0.25 rotate x*-55 rotate y*-25 translate<-0.75,0.25,0.5>}
}

#declare fullbeak = object{pecker clipped_by { object { plane {x,0.3} } }
texture{
pigment{radial frequency 0.5 rotate x*90}
             finish{ambient 0.5 diffuse 0.5 specular 1}}
}
//--------------------------------------------------------------------
#declare Flying_worm = union{
        object{Fly_worm rotate y*-90}
        object{Worm
             texture{
             pigment{radial frequency 10 rotate x*90}
             normal{gradient x 0.15 frequency 20 scallop_wave}
             finish{ambient 0.5 diffuse 0.5 specular 1}
             }
       scale 0.2
       rotate y*90
       translate<0,-1.1,-0.25>
}
        object{ fullbeak scale <0.8,0.8,0.8>rotate y*-90 scale 0.1 rotate x*-33 translate<0,-0.3,-0.525>}
}
/*
object{Flying_worm
//rotate x*50
//rotate y*45
}


*/
