
// Persistence of Vision Ray Tracer Scene Description File
// File: Islands.pov
// Vers: 6
// Desc: IRTC Entry on theme of "Nature"
// Date: 3/5/98
// Auth:Mick Hazelgrove
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "METALS.INC"
#include "SHAPES.INC"
#include "GLASS.inc"
#include "tree.inc"
#include "Shell.inc"
#include "Starfish.inc"
#include "Dragonette.inc"
#include "wormy.inc"
#include "Crustacean.inc"
#include "SeaMonster.inc"
#include "Water Lilly.inc"
#include "Snail.inc"

global_settings {
 assumed_gamma 2.2
    ambient_light  color <0.8,0.2,0.2>
     radiosity {
       brightness 3.3
       count 250
       distance_maximum 3
       error_bound 0.4
       gray_threshold 0.3
       low_error_factor 0.8
       minimum_reuse 0.015
       nearest_count 6
       recursion_limit 1
     }
   }

// -------------------------Camera-----------------------

camera
{
  location  <0.0, 0.25, -5.0>
  direction 1.45*z
  right     4/3*x
  look_at   <0.0, 1,  0.0>
}

//-------------------------Lights------------------------

light_source { <-20, 20, -50 > Goldenrod}
light_source { <-20, 20, 20 >  Blue}
light_source { <20, 20, 20 >  Red}
light_source { <0, 10, -20 >  color <0.25,0.25,0.5> }
light_source { <0,20, -20 >  Gold} //middle

// ----------------------------------------

#declare Calm_Water = texture {
  pigment {
    color rgb <0.25, 0.25,0.0>
  }
  normal { bumps 0.1 }
  finish {
    reflection 0.9
    refraction 1.25
    ior 1.33
    phong 1.0
    phong_size 200
    metallic
  }
  scale <0.2,0.2,0.2>
}

#declare Purple_Rock = texture {
  pigment {
    granite
    turbulence 0.7
    color_map {
      [0.00 0.07 color rgbf <0.75, 0.00, 0.60,0.28 >
                 color rgbf <0.50, 0.00, 0.50,0.45 >]
      [0.07 0.13 color rgbf <0.50, 0.00, 0.50, 0.45>
                 color rgbf <0.65, 0.00, 0.65, 0.82>]
      [0.13 0.31 color rgbf <0.65, 0.00, 0.65, 0.82>
                 color rgbf <0.88, 0.00, 0.45, 0.01>]
      [0.31 0.39 color rgbf <0.88, 0.00, 0.45, 0.01>
                 color rgbf <0.80, 0.00, 0.65, 0.54>]
      [0.39 0.55 color rgbf <0.80, 0.00, 0.565, 0.54>
                 color rgbf <0.50, 0.00, 0.75, 0.69>]
      [0.55 1.00 color rgbf <0.50, 0.00, 0.75, 0.69>
                 color rgbf <0.70, 0.00, 0.45, 0.43>]
    }
  }
  finish {
  metallic
  phong 0.66
  phong_size 81
  //crand 0.2
  }
  scale <0.98 0.87 0.81>
}

//----------------------------------------------------------------

#declare Rocks = object{
height_field{
  tga  "C:\Graphics\tga\islands.tga"
  smooth
   water_level 0.1
    rotate y*150
    }
}

//---------------------------------Sky----------------------------------------

#include "Island sky.inc"

object {Sun scale 120
     translate<0,85,360>
     no_shadow
}

object {Sun3 scale 220
     translate<0,85,370>
     no_shadow
}

object {Sun2 scale 40
     translate<0,85,350>
     no_shadow
}

object {CSun scale 60
     translate<0,85,345>
     no_shadow
}

//--------------------------Fog------------------------------
fog {
distance 100
color rgbt <0.3,0.3,0.8, -1>
fog_type 2
fog_offset 1.5
fog_alt 0.5
turbulence 3
turb_depth 1
}

fog {
distance 150
color rgbt <0.4,0.3,0.6, -1>
fog_type 2
fog_offset 1.75
fog_alt 0.6
turbulence 5
turb_depth 2
}

fog {
distance 200
color rgbt <0.1,0.0,0.3, -1>
fog_type 2
fog_offset 2.00
fog_alt 0.8
turbulence 7
turb_depth 3
}

//----------------------water------------------------

plane{y,-1 texture{Calm_Water}hollow}

//---------------------Rocks------------------------
object{Rocks
  texture {Purple_Rock}
    scale <12,12,12>
    rotate y*120
    translate<6,-2.25,7>
}

object{Rocks
  texture {Purple_Rock}
    scale <12,12,12>
    rotate y*120
    translate<0,-2.25,0>
}

object{Rocks
  texture {Purple_Rock}
    scale <12,12,12>
    rotate y*120
    translate<13.5,-2.25,0>
}
//left rocks in the distance
object{Rocks
  texture {Purple_Rock}
    scale <12,12,12>
    rotate y*180
    translate<-20,-1.55,75>
}

//Right rocks in the distance
object{Rocks
  texture {Purple_Rock}
    scale <12,12,12>
    rotate y*100
    translate<32,-1.45,50>
}

//farthest rocks
object{Rocks
  texture {Purple_Rock}
    scale <12,12,12>
    rotate y*180
    translate<30,-1.45,125>
}

//farthest Island
object{Rocks
  texture {Purple_Rock}
    scale <12,12,12>
    rotate y*180
    translate<-15,-1.45,200>
}
//----------------------Trees---------------------------------

//Main Island
object {Tree scale <0.3,0.7,0.3> translate < 3,2,12>no_shadow}
object {Tree scale <0.4,0.9,0.4>  translate < -5,2,9>no_shadow}
object {Tree scale <0.45,0.9,0.45> translate < -2,2,14>no_shadow}
object {Tree scale <0.3,0.6,0.3>  translate < 1.75,2,16>no_shadow}
object {Tree scale <0.45,0.9,0.45>  translate < 5,2,8>no_shadow}
//Left Island
object {Tree scale <0.45,0.9,0.45> rotate z*-10 translate < -21,4,130>no_shadow}
object {Tree scale <0.5,1.2,0.5> rotate z*-5 translate < -23,4,130>no_shadow}
object {Tree scale <0.5,1,0.5> rotate z*7 translate < -33,4,130>no_shadow}
object {Tree scale <0.5,1.5,0.5> translate < -28,4,130>no_shadow}
//Right Island
object {Tree scale <0.45,1,0.45> rotate z*5 translate < 37,4,100>no_shadow}
object {Tree scale <0.45,1.5,0.45> rotate z*-7 translate < 44,4,100>no_shadow}
//far Island
object {Tree scale <0.45,0.9,0.45> rotate z*-10 translate <38,4,185>no_shadow}
object {Tree scale <0.5,1.2,0.5> rotate z*-5 translate <39,4,160>no_shadow}
object {Tree scale <0.5,1,0.5> rotate z*7 translate <43,4,160>no_shadow}
object {Tree scale <0.5,1.5,0.5> translate <37,4,160>no_shadow}
//Farthest Island
object {Tree scale <0.45,0.9,0.45> rotate z*-10 translate <-18,4,250>no_shadow}
object {Tree scale <0.5,1.2,0.5> rotate z*-5 translate <-8,4,1250>no_shadow}
object {Tree scale <0.5,1,0.5> rotate z*7 translate <-21,4,250>no_shadow}
object {Tree scale <0.5,1.5,0.5> translate <-15,4,250>no_shadow}
//---------------------Starfish-------------------------------------

object{Starfish scale 0.1 rotate x* 40 translate <-1.85,-0.375,0.15>}//left front
object{Starfish scale 0.1 rotate z*25 rotate x* 40 translate <0.7,-0.8,8.875>} //middle R back
object{Starfish scale 0.1 rotate z*-25 rotate x* 40 translate <-2.15,-0.18,5.25>} //middle L back
object{Starfish scale 0.07 rotate x* 50 rotate y*30  translate <4.3,-0.25,5>} //far right

//---------------------Shell----------------------------------------

object {Shell scale 0.15  rotate y*-30 translate<2.75,-0.75,6.5>}
object {Shell scale 0.1  rotate z*-50 rotate x*30 translate<2.25,-0.75,7.5>}
object {Shell scale 0.065  rotate y*30 rotate z*-190 translate<1.7,-1,7>}
object {Shell scale 0.02 rotate z*150  translate<-0.1,-0.95,3.5>}

//----------------------Dragonettes---------------------------------------

//lower right
#declare Tval = 0.3
#declare WsegRot = 1
#include "Dragonette.inc"
object{Flying_worm
rotate x*-30
rotate y*60
scale 0.6
translate<2.75,2,4>
}

//upper left
#declare Tval = 0.5
#declare WsegRot = 0
#include "Dragonette.inc"
object{Flying_worm
  scale 0.45
  rotate y*-50
  rotate x*-20
  rotate z*-30
  translate<-3,6,8>
}

//lower left
#declare Tval = 0.2
#declare WsegRot = 0
#include "Dragonette.inc"
object{Flying_worm
rotate x*-10
rotate y*-65
scale 0.5
translate<-3.5,2.8,5>
}

// upper right
#declare Tval = 0.3
#declare WsegRot = 1
#declare Minus_Wing_angle = -25
#declare Wing_angle = 25
#include "Dragonette.inc"
object{Flying_worm
  scale 0.8
  rotate y*30
  rotate z*30
  translate<1,6,7>
}

//lower middle
#declare Tval = 0.3
#declare Minus_Wing_angle = -25
#declare Wing_angle = 25
#declare WsegRot = 1
#include "Dragonette.inc"
object{Flying_worm
rotate x*30
rotate y*20
rotate z* -18
scale 0.75
translate<0.0,0.975,0>
}

// upper middle
#declare Tval = 0.5
#declare WsegRot = 0
#declare Minus_Wing_angle = 45
#declare Wing_angle = -45
#include "Dragonette.inc"
object{Flying_worm
  scale 0.65
  rotate z*10
  rotate x*-10
  rotate y*-20
  translate<-1.25,5.5,10>
  }

//-------------------------------Plants----------------------------------
#declare Plant_Texture = texture{
      pigment{
           bozo color_map{
                      [0.00 color Cyan ]
                      [0.20 color Green ]
                      [0.30 color Yellow ]
                      [0.45 color Cyan ]
                      [0.65 color ForestGreen]
                      [0.75 color Cyan ]
                      [0.90 color Yellow]}
                      frequency 3
                      turbulence 3
                      rotate x*90
                }
         finish{
            specular 1
            roughness 0.01
               }
         normal{
            radial 3
            turbulence 0.15
            frequency 35
            scallop_wave
               }
}   //end of tex def

#declare S = seed(123)
#include "plant.inc"
object{Trumpet_plant  //middle
texture{Plant_Texture}
scale 2
translate<-1.3,-1.00,6>
}

#declare S = seed(234)
#include "plant.inc"
object{Trumpet_plant   //left
texture{Plant_Texture}
scale 2
rotate y*90
translate<-4.5,-0.65,7.5>
}

#declare S = seed(345)
#include "plant.inc"
object{Trumpet_plant   //right
texture{Plant_Texture}
scale 2.05
rotate y*110
translate<2.15,-1.05,1.00>
}

#declare S = seed(456)
#include "plant.inc"
object{Trumpet_plant   //middle front
texture{Plant_Texture}
rotate y*15
scale 2
translate<-2.30,-1.25,5>
}

#declare S = seed(567)
#include "plant.inc"
object{Plant2
texture{Plant_Texture}
scale 0.3
scale <2,3,2>
translate<-2.8,1.25,5.5>
}

#declare S = seed(678)
#include "plant.inc"
object{Plant2
texture{Plant_Texture}
scale 0.25
scale <2,2.5,2>
rotate y*90
translate<-2.9,1.00,5.175>
}

#declare S = seed(789)
#include "plant.inc"
object{Plant2
texture{Plant_Texture}
scale 0.35
scale <2,2.5,2>
rotate y*60
translate<-3.15,0.5,5.2>
}

#declare S = seed(987)
#include "plant.inc"
object{Plant2
texture{Plant_Texture}
scale 0.25
scale <2,2.5,2>
rotate y*20
translate<-3.05,0.15,5.15>
}

#declare S = seed(876)
#include "plant.inc"
object{Plant2
texture{Plant_Texture}
scale 0.3
scale <2,2.5,2>
rotate y*40
translate<-2.65,0.35,5.25>
}

#declare S = seed(765)
#include "plant.inc"
object{Plant2
texture{Plant_Texture}
scale 0.25
scale <2,3,2>
translate<-3,-0.5,5.1>
}

//--------------------------------Wormy------------------------------------

object{Wormy
scale <0.017,0.02,0.0175>
rotate y*-40
translate<4.725,0.9,7.5>
no_shadow
}

//--------------------------------Crustaceans------------------------------

object{Crusty   //on leaf
scale 0.035
rotate y*-60
rotate x*-15
translate<1.55,-0.5,-0.45>
}

object{Crusty   //on middle plant
scale 0.035
rotate y*15
rotate x*-40
translate<-1.65,-0.5,2.5>
}

object{Crusty   //on tree
scale 0.0175
rotate x*-90
translate<-5,1.5,8>
}

object{Crusty   //on tree side
scale 0.0175
rotate x*-100
rotate y*90
translate<-5.1,0.75,7.74>
}

object{Crusty   //on left leaf
scale 0.03
rotate y*90
rotate z*30
rotate x*10
translate<-5.05,-0.225,7.25>
}

object{Crusty   //in Dragonettes beak
scale 0.03
rotate y*90
rotate x*-150
rotate z*-20
translate<-0.26,0.973,-0.35>
}

//-------------------------Monster-----------------------------

object{Sea_monster
pigment{radial frequency 50}
finish{specular 1}
normal{ripples 5 frequency 15}
scale 0.075
rotate z*15
rotate y*15
translate <-1,-0.9,5.25>}

//-----------------------Water Lilly---------------------------
#include "Water Lilly.inc"
object{Water_Lilly
scale 0.4
translate<0.7,-0.825,3.75>
}
//-----------------------Snail--------------------------------

object{Snail
            clipped_by { plane {x,2} }
                       scale 0.35
                       rotate y*-30
                       rotate z*-35
                       rotate x*-10
                       translate <2.75,0.15,6.65>
}
