#ifndef ( __JGB_LANDSCAPE__ )
#declare __JGB_LANDSCAPE = true

  #declare hf_grid_resolution = 12
  #declare tree_grid_resolution = 6

  #debug "Constructing a landscape...\n"

  union
  {
    #declare i = 0
    #while( i < hf_grid_resolution )
      #declare j = 0
      #while( j < hf_grid_resolution )
        object
        {
          Mountains
          translate i*MountainScale.x*x
          translate (j-2)*MountainScale.z*z
        }
        #if ( ( do_trees ) & ( i < tree_grid_resolution ) & ( j < tree_grid_resolution ) )
          object
          {
            Forests
            texture { pigment { color rgb <0.086,0.537,0.278> } normal { bumps 1.0 scale 0.002 turbulence 1.0 } }
            translate i*MountainScale.x*x
            translate (j-2)*MountainScale.z*z
          }
        #end
        #declare j = j + 1
      #end
      #declare i = i + 1
    #end
    texture { LandscapeTexture scale MountainScale.y*1.1 }
  }

#end
