/* these variables are for debugging purposes */
#declare do_trees      = yes
#declare do_fog        = yes

#declare MountainScale = <8,2,8>
#declare MountainFile  = "mountains2.tga"

#debug "Loading mountains...\n"

#declare Mountains =
  height_field
  {
    tga MountainFile
    hollow
    smooth
    water_level 0.25
    scale MountainScale
  }

#declare xpos          = 106/600
#declare zpos          = 1 - (278/600)
#declare height        = hf_height_at( xpos, zpos, Mountains ) + 0.02

#declare camera_location = <xpos,height,zpos>*MountainScale

#default { finish { ambient 0.2 } }

camera
{
  location camera_location
  //right <2,1,1>
  right <2.35,1,1>
  look_at  <8,0.3,8>
}

light_source
{
  <-1500,4500,-4500>
  color rgb 1.1
}

light_source
{
  <15,45,45>
  color rgb 0.4
  shadowless
  #if ( do_atmosphere )
    atmosphere off
  #end
}

/* the sky */
#include "jgbsky.inc"

/* the landscape textures */
#include "jgbtextures.inc"

/* the water */
plane
{
  y, 0.5
  texture {
    pigment { color rgb <0.008,0.282,0.502> }
    finish  { reflection 0.7 specular 0.8 roughness 0.05 ambient 0.0 diffuse 0.0 }
  }
}

/* build a mesh of trees */
#if ( do_trees )
  #include "jgbtrees.inc"
#end

#include "jgblandscape.inc"

#if ( do_fog )

  fog
  {
    fog_type 1
    distance 6
    color rgbft <0.9,0.9,0.9,0.8,0.5>
    use_color 0.4
  }

#end
