
// Persistence of Vision Ray Tracer Scene Description File
// File: Mesozoic.pov
// Vers: 3.02
// Desc: A time when Nature was in a turmoil of activity.
// Date: 3rd May, 1998
// Auth: Ewan Grant [ ewgr@abaddon.globalnet.co.uk


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"   // Additional Texture definitions
// ==== Personal POV-Ray Includes ====
#include "myskys.inc"    // Cloud Textures and Sky_Spheres
#include "snake.inc"     // An sPatch file, saved as INC to reduce .POV size
#include "mushrooms.inc" // An sPatch file      -"-
#include "dino2.inc"     // An sPatch file      -"-
#include "weed.inc"      // An sPatch file      -"-
#include "hill.inc"      // An sPatch file      -"-

global_settings { assumed_gamma 2.2 }

//Scene lighting

   light_source { < -4, 10, -15> color red .2 green .3 blue .3 shadowless }
  light_source { < 45, 45, 100>
                  color red .9 green .8 blue .9
                  area_light <6, 0, 0>, <0, 0, 6>, 10, 10
                  adaptive 2
                 jitter
                }

// A Viewpoint

   camera { ultra_wide_angle angle 225  location < -5, 7, -15 >  look_at < -1, 5.8, 1 > }

// A Cloudy Sky...

  object { Sky }  // The clouds from myskys.inc are on a plane at 9000*y

// ...And a sunset behind.

  sky_sphere { pigment { gradient y scale 1.05 turbulence .15
           color_map { [ 0.01  color White]
                       [ 0.1 colour Wheat]
                       [ 0.22  color Orange]
                       [ 0.4 colour Firebrick]
                       [ 0.57  color Violet]
                       [ 0.7 colour MidnightBlue]
                       [ 0.9  color Mica]
                     }
                  }
                 rotate 20*x //Bringing the lightest band of colour down to the horizon
               }


// A tranquil sea

   plane { y, -0.5
    pigment { rgbf <0.3, 0.46, 0.54, 0.3> }
    normal { waves  scale 3.2 turbulence .5 }
    finish {  diffuse .5 reflection .3 }
    rotate -1.8*x
        }

// The ocean floor... to counteract visible height-field borders.

plane { y, -10 pigment { color rgb <0.3, 0.46, 0.54> } hollow }

// A seaweed bed. (The vegetation upon which some feed.)

 height_field { gif "land2.gif"
   pigment { image_map { gif "land2.gif" }  }
   finish {ambient .7}
   rotate <-6, 0, 5>
   translate < -0.65, -0.78, .5 >
   scale <80, .52, 60>
            }

// Two textures created to simulate a beach and the rocks thereon.

       #declare PigBeach =
   texture { T_Grnt6 scale <2, 3, 2> rotate <0, -40, 0 >
    finish { ambient 0.2 diffuse 0.9 crand 0.08 }
           }
  texture { T_Grnt19a scale <1, 3, 1> rotate <0, 0, 40 >
   finish { ambient 0.3 diffuse 0.5 crand 0.09 }
          }

       #declare PigBeach2 =
   texture { T_Grnt6 scale <2, 3, 2> rotate <0, -65, 0 >
    finish { ambient 0.2 diffuse 0.9 crand 0.06 }
           }
  texture { T_Grnt13a scale <1, 3, 1> rotate <0, 0, 60 >
   finish { ambient 0.3 diffuse 0.5 }
          }

// The beach itself, if you look closely you can almost see the tracks of creatures
// amidst the damper sections of sand. (Vivid imagination needed!! :)

 height_field { gif "dena.gif"
   texture {PigBeach2} finish { reflection 0.05 }
   smooth
   rotate 1.9*x
   translate < -0.4, -0.5, -0.575 >
   scale <200, .2, 125>
            }

// The sharp outcrops of rock that litter the shore.

 height_field { gif "Hst_pill.gif"
   texture { PigBeach }
   smooth
   rotate 15*y
   translate < -0.7, -0.5, -0.54 >
   scale <120, 6, 90>
            }

// A distant Island, verdant in style.

# declare Island =
union {
object { Hill2 no_shadow  //shadows off due to light source position.
scale <1200, 400, 600> rotate <-15, 75, -13> translate <-1900, 200, 5800> }
object { Hill no_shadow  //the hills are simple sPatch grids
scale <1500, 1000, 1300> rotate 305*y translate <-500, 205, 6000> }
         }

 object { Island
    pigment { image_map { gif "land2.gif" } scale 2500 }
     finish {ambient .25 crand .15}
     scale < 1.4, .8, 1>
     translate 4*y }

// Centrepiece, a giant amongst Molluscs.

   #declare Shell=
   union{
   torus { 2, 1.35
   texture {finish {Metal} pigment {Gray85}} finish { reflection 0 irid { 0.25 thickness 0.25 turbulence 0.7 } }
   rotate < 90, -110, -5 > scale < 5, 2, 5 > translate < 8.2, 3, 3 >
         }
   torus { 2.4, 1.4
   texture {finish {Metal} pigment {Gray90}} finish { reflection 0 irid { 0.3 thickness 0.2 turbulence 0.6 } }
   rotate < 88, -109, -5 > scale < 4.6, 2.3, 5 > translate < 8.5, 3.1, 3.3 >
         }
   torus { 2.7, 1.4
   texture {finish {Metal} pigment {Gray95}} finish { reflection 0 irid { 0.3 thickness 0.25 turbulence 0.5 } }
   rotate < 86, -105, -5 > scale < 4.2, 2.5, 5 > translate < 9, 3.2, 3.6 >
         }
   torus { 2.9, 1.4
   texture {finish {Metal} pigment {White}} finish { reflection 0 irid { 0.3 thickness 0.3 turbulence 0.4 } }
   rotate < 82, -101, -5 > scale < 4, 2.7, 5 > translate < 9.9, 3.3, 3.8 >
         }
   sphere { < 0, 0, 0 > 3.2 no_shadow
   texture { pigment { Gray10 } finish { Metal irid { 0.4 thickness 0.4 turbulence 0.2 } } }
   translate < 7.5, 2.22, 3 >
         }
        }

// A more regular Mollusc, familiar with some we know today.

  #declare SeaShell=
    merge{
   torus { 2.1, 1  rotate < 90, -110, -8 > scale < 2, 1.45, 1> translate < 9, 3, 3 > }
   torus { 2.1, 1.4 rotate < 88, -109, -8 > scale < 1, 1.6, 1> translate < 8.8, 3, 3 > }
   torus { 1.9, 1.3 rotate < 86, -105, -8 > scale < 1, 1.5, 1> translate < 10, 2.9, 3 > }
   torus { 1.7, 1.25 rotate < 84, -101, -8 > scale < 1, 1.3, 1> translate < 11.5, 2.8, 3 > }
   torus { 1.5, 1.2 rotate < 82, -101, -8 > scale < 1, 1.1, 1> translate < 13, 2.7, 3 > }
   torus { 1.3, 1.15 rotate < 80, -101, -8 > scale < 1, .9, 1> translate < 14.5, 2.6, 3 > }
   torus { 1.1, 1.1 rotate < 78, -101, -8 > scale < 1, .7, 1> translate < 16, 2.5, 3 > }
   torus { 1, 1 rotate < 77, -100, -8 > scale < 1.6, .5, 1> translate < 17, 2.4, 3 > }
         }

    object { Shell rotate 7*y scale < .45, .5, .4 > translate < 0.2, .76, 4 > }
    object { SeaShell texture {PinkAlabaster scale .3} scale .22 rotate < 0, -22, -18 >  translate < -10, .5, -4 > }
    object { SeaShell texture {Sandalwood scale .5} scale <.45, .25, .25> rotate < 0, 162, 7 >  translate < 33, .5, 11 > }

// A pair of legs to scuttle with.
 #declare Legs=
     union{
  cone { .5*y,  0.1, -.6*y, 0.03 rotate -20*z translate < -9, 0.06, -4.3 >}
  cone { .5*y,  0.1, -.6*y, 0.03 rotate -30*z translate < -9.8, 0.05, -3.4 >}
  cone { .52*y,  0.08, <0.1, -.4, 2>, 0.1 rotate <0, 0, 80> translate < -8.3, .6, -4.3 >}
  cone { .56*y,  0.08, -.6*y, 0.1 rotate <0, 0, 90> translate < -8.9, .6, -3.4 >}
  sphere { < -9.52, .55, -3.42> .1 }
  sphere { < -8.81, .56, -4.28> .11 }
         }

  object { Legs
    pigment { crackle scale .5 turbulence .4
        color_map { [ 0.0 colour MediumVioletRed]
                    [ 0.3  color Firebrick]
                    [ 0.5  color Salmon]
                  }
                 }
                 finish { ambient .4 diffuse .4 crand .15 }
                translate < 0, .1, .3>
               }

// The beginnings of an eye.
  #declare Iris=
      difference {
  cylinder { <-0.04, 0, 0> <0.08, 0, 0>  .1  }

  cylinder { <-0.041, 0, 0> <0.09, 0, 0>  .07   }
   pigment { MediumVioletRed }
           }
// Eye made complete.
  #declare Eye=
   union {
  object { Iris }
  sphere { 0*y  .055 texture {pigment { Blue_Agate}  finish {ambient .4} } translate 0.1*x }
  sphere { 0*y  .11  pigment {White } finish {ambient .55} }
         }

   object { Eye  rotate <-10, 80, 10> translate <-8.4, 1.4, -3.5>}
   object { Eye  rotate <-5, 120, -33> translate <-8.9, 1.1, -3.1>}


//---------------------------------------------------------------------------------------------------
// Is Chris Colefax a genius? Certainly saved me a headache with his LINK.INC
//---------------------------------------------------------------------------------------------------
  // These create the eye-stalks which end within the shell.
   #declare link_point1 = <-8.8, 1, -3.0>
   #declare link_point2 = < -7.5, .29, -1.3 >
   #include "LINK.INC"

   #declare link_point1 = <-8.3, 1.3, -3.4>
   #declare link_point2 = < -7.76,-.5, -.9 >
   #include "LINK.INC"
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

// A nasty surprise, the noxious gas.

    cone { -1*y,  0.0, 1*y, 1.5 no_shadow
    pigment { Clear }
       halo { emitting
              spherical_mapping
              cubic
              turbulence 2
   color_map {[ 0.0 color rgbt <1, .3, .9, .99> ]
              [ 0.5 color rgbt <1, .0, .0, -1> ]
              [ 1.0 color rgbt <1, 1.5, .8,  0.2> ]
             }
              frequency 1.8
              scale .35
              samples 30
              aa_level 3
              aa_threshold 0.5
              jitter 0.2
            }
               hollow rotate < -27, 14, 93 > scale < 11.4, 3, 2.1 >  translate < -3, 2.4, 1.05 >
            }

// A piece of flotsam, possibly a gnarled old tree trunk.

     julia_fractal { <-0.083,0.0,-0.83,-0.025> //almost identical to Pov doc example.
                 quaternion
                 cube
                 max_iteration 8
                 precision 40
        texture {PigBeach}
       scale 2.34
     translate < -11, -.6, -5.6 >
               }

// Produced in SPatch and the resulting Bicubic Patches turned into an "INC" file
// All were made from  SOR objects

  #declare Fungi2=
 union {
object { Mushroom2 rotate -33*y scale <1, 1.5, 1> translate < 0, 0.4, -2.6>}
object { Mushroom2 scale <1, 1.5, 1> translate < 1.5, 0.5, -3>}
object { Mushroom2 rotate 33*y scale <1, 1.5, 1> translate < -1.5, 0.5, -2.5> }
object { Mushroom2 rotate 180*y scale <1, 1.5, 1> translate < 1, 0.6, -1>}
object { Mushroom2 rotate 66*y scale <1, 1.5, 1> translate < -1, 0.5, -1.5> }
       }
  #declare Fungi=
 union {
object { Mushroom rotate -33*y scale <.6, 1.1, .7> translate < .6, .3, -4.6>}
object { Mushroom scale <.6, 1, .7> translate < 2.2, .3, -6>}
object { Mushroom rotate 33*y scale <.6, 1.15, .7> translate < .9, .3, -5.75> }
object { Mushroom rotate 180*y scale <.6, 1, .7> translate < 1.4, .3, -4>}
object { Mushroom rotate 100*y scale <.6, .9, .7> translate < -.3, .3, -5>}
       }

    object { Fungi2 translate < -12, 0, 4> }
    object { Fungi2 rotate 180*y translate < -23, 0, 2> scale .5}
    object { Fungi }
    object { Fungi rotate 20*y translate -2*z }
    object { Fungi rotate -15*y translate <.5, -.1, -2.5> }

//---------------------------------------------------------------------------------------------------
// Another genius- thanks to her TREES.INC *** Sonya Roberts ***
//---------------------------------------------------------------------------------------------------
    object {
             #declare Tip=2
             #declare BarkTexture=4
             #declare BaseLen=.2
             #declare LeafShape=2
             #declare LeafTexture=0
             #declare FruitShape=5
             #declare FruitTexture=4
             #include "trees2.inc" // I just played with the values and renamed the file.
             rotate <-10,-25,30>
         translate <1.6, 2.2, -11.8>
       }
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

// Snake.inc... (an SPatch file-6 cones)

 object { Snake
  pigment { gradient x
              color_map { [ 0.0 DarkGreen]
                          [ 0.12 YellowGreen]
                          [ 0.3 DarkOliveGreen]
                          [ 0.306 Khaki]
                          [ 0.319 DarkGreen]
                          [ 0.5 DarkOliveGreen]
                          [ 0.506 YellowGreen]
                          [ 0.518 DarkGreen]
                          [ 0.7 DarkOliveGreen]
                          [ 0.706 Khaki]
                          [ 0.718 DarkGreen]
                          [ 0.9 DarkOliveGreen]
                         }
                       }
                finish { ambient .4 diffuse .5 crand .3 }
                   scale 3
                      rotate -199*y
                         translate <2.26, -.51, -4.1>
                       }
// A Pair of eyes for the snake

      sphere { 0*y  .08
        texture {
          pigment{ gradient x scale .4
                         color_map { [ 0 Firebrick]
                                     [ 0.1 Black ] }
                }
                finish { ambient .7 }
                }
        scale < 2, .8, 1>
        rotate -28*y
        translate < 2.34, .82, -3.94>}

      sphere { 0*y  .08
        texture {
          pigment{ gradient x scale .4
                         color_map { [ 0 Firebrick]
                                     [ 0.1 Black ] }
                }
                finish { ambient .7 }
                }
        scale < 2, .8, 1>
        rotate -28*y
        translate < 2.51, .8, -4.24>}

// A trio of temporarilly unguarded lizards eggs... snake food!!

#declare Egg=
  sphere { <0, 0, 0> .4  scale < 1.2, 1.2, 1.8 >
   pigment { crackle   frequency 2.5 turbulence 2
          colour_map { [ 0.1 Silver ]
                       [ 0.25 LightSteelBlue ]
                       [ 0.34 Silver ]
                       [ 0.47 DarkSlateBlue ]
                       [ 0.53 Silver ]
                       [ 0.67 LightSteelBlue ]
                       [ 0.78 Silver ]
                     }
                   }
                finish { ambient .3 diffuse .7 specular .1  } }

#declare Nest=
    union {
          object { Egg rotate -5*y translate < -1.9, 0.23, -6.2 > }
          object { Egg rotate <10, 70, 0> translate < -1.24, 0.24, -4.6 > }
          object { Egg rotate <-15, -30, 10 > translate < -.8, 0.27, -5.9 > }
          }

 object { Nest rotate 15*y translate <-3, .1, -.2> }

//Mother of Eggs, out to lunch...(created in sPatch from 10 objects.)

#declare Mother=
union{
  object { Lizard
     scale 5 rotate 10*y translate < -14, 4, 34 > }
  sphere { 0*y .3 pigment {Black} scale <1.2, .8, 1> translate < -5.58, 6.9, 31.1 > }
  sphere { 0*y .15 pigment {Gray55} scale <1.2, .8, 1> translate < -5.56, 6.8, 30.9 > }
          }

  object { Mother translate 10*z}

  // Mums mouthful of Seaweed (sPatch again)

  object { Weed finish {ambient .25 diffuse .4} scale <5, 4, 4> translate < -4, 4.8, 23 > }

