// octopussy arm
// by Robert Fremin
//
// objects:  none, this is used by octo.inc


#debug "Octopus arm"

#declare cup1 = 0
#declare cup2 = 0
#declare cup3 = 0
#declare cup4 = 0
#declare cup5 = 0
#declare cup6 = 0
#declare cup7 = 0
#declare cup8 = 0

#declare R = seed(rand(R) * 100000)
#declare N = 200		// number of blobs per arm
#declare Nr = N/10		// range
#declare cdiv = 100/N	// divisor
#declare rr = 9.5	// radius base
#declare a1 = 0
#declare a2 = 0

#declare c = 0
#while (c < N)
	#declare w1 = sin(a1)*8+cos(a2)*3		// y
	#declare w2 = sin(a2)*1+cos(a1)*3		// z
	#declare rr = rr - 7/N
	#declare c2 = c*cdiv
	#declare the_pos = vrotate(vrotate(<c2,w1,w2> + x*20, z*-10), y*aangle)

	sphere { 0 rr 1 translate the_pos }

	#switch (c)
		#range (2*Nr,3*Nr)
			#if (!cup1)
				#declare cup1v = the_pos-y*rr
				#declare cup1 = 1
			#end
		#break
		#range (3*Nr,4*Nr)
			#if (!cup2)
				#declare cup2v = the_pos-y*rr
				#declare cup2 = 1
			#end
		#break
		#range (4*Nr,5*Nr)
			#if (!cup3)
				#declare cup3v = the_pos-y*rr
				#declare cup3 = 1
			#end
		#break
		#range (5*Nr,6*Nr)
			#if (!cup4)
				#declare cup4v = the_pos-y*rr
				#declare cup4 = 1
			#end
		#break
		#range (6*Nr,7*Nr)
			#if (!cup5)
				#declare cup5v = the_pos-y*rr
				#declare cup5 = 1
			#end
		#break
		#range (7*Nr,8*Nr)
			#if (!cup6)
				#declare cup6v = the_pos-y*rr
				#declare cup6 = 1
			#end
		#break
		#range (8*Nr,9*Nr)
			#if (!cup7)
				#declare cup7v = the_pos-y*rr
				#declare cup7 = 1
			#end
		#break
		#range (9*Nr,10*Nr)
			#if (!cup8)
				#declare cup8v = the_pos-y*rr
				#declare cup8 = 1
			#end
		#break
	#end

	#declare c = c + 1
	#declare a1 = a1 + cdiv*rand(R)/6
	#declare a2 = a2 + cdiv*rand(R)/5
#end
