// octo.inc
// by Robert Fremin
//
// objects:  octopus


#declare skintexture =
//pigment { granite color_map { [0 rgb <.85,.6,.6>][.5 rgb <.95,.7,.7>][1 rgb <1,.75,.75>] } scale 20 turbulence .2 }
//pigment { granite color_map { [0 rgb <.85,.4,.5>][.5 rgb <.95,.5,.6>][1 rgb <1,.55,.65>] } scale 20 turbulence .2 }
pigment { granite color_map { [0 rgb <.4,.4,.4>][.5 rgb <.6,.6,.6>][1 rgb <.8,.8,.8>] } scale 20 turbulence .2 }

#declare spots =
//pigment { spotted color_map { [0 rgb <1,.75,.75>][.2 rgb <.5,.5,.7>][.4 White][.5 rgb <1,.75,.75>] } scale 5 }
//pigment { spotted color_map { [0 rgb <.85,.6,.6>][.5 rgb <.95,.7,.7>][1 rgb <1,.75,.75>] } scale 20 turbulence .2 }
pigment { gradient y color_map { [0 White][.5 Red][.6 White][.7 Blue] } scale 20 turbulence .2 }

#declare octo_eye =
union
{
  sphere { 0 1 scale 4*1.5 pigment { White } }
  sphere { 0 1 scale 4*1 translate z*-2.3 pigment { Black } }

  finish { specular .3 phong .2 ambient .1 }
}

#declare octopus =
union
{
  #debug "Octopus"

  blob
  {
    threshold .3

    // the head
    #declare h = 0
    #declare Rr = seed(34578)
    #while (h < 10)
      sphere { 0 28+h*2 1 scale <.7,1,1> translate x*-h*1.1+y*(25+h*2)+z*h*2 }
      sphere { 0 28+h*2 1 scale <.7,1,1> translate x*h*1.1+y*(25+h*2)+z*h*2 }
      #declare h = h + 1
    #end

    // eye sockets
    sphere { <-9  ,22.3,-17> 7*1.5 1 }
    sphere { < 9  ,22.3,-17> 7*1.5 1 }
    sphere { <-9.5,22,  -19> 5.5*1.5 strength -1 }
    sphere { < 9.5,22,  -19> 5.5*1.5 strength -1 }

    #ifndef (no_arms)
      // the arms
      #declare R = seed(63875-256)

      #declare aangle = 0*45
      #include "arm.inc"
      // copy vectors
      #declare c11 = cup1v
      #declare c12 = cup2v
      #declare c13 = cup3v
      #declare c14 = cup4v
      #declare c15 = cup5v
      #declare c16 = cup6v
      #declare c17 = cup7v
      #declare c18 = cup8v

      #declare aangle = 1*45
      #include "arm.inc"
      // copy vectors
      #declare c21 = cup1v
      #declare c22 = cup2v
      #declare c23 = cup3v
      #declare c24 = cup4v
      #declare c25 = cup5v
      #declare c26 = cup6v
      #declare c27 = cup7v
      #declare c28 = cup8v

      #declare aangle = 2*45
      #include "arm.inc"
      // copy vectors
      #declare c31 = cup1v
      #declare c32 = cup2v
      #declare c33 = cup3v
      #declare c34 = cup4v
      #declare c35 = cup5v
      #declare c36 = cup6v
      #declare c37 = cup7v
      #declare c38 = cup8v

      #declare aangle = 3*45
      #include "arm.inc"
      // copy vectors
      #declare c41 = cup1v
      #declare c42 = cup2v
      #declare c43 = cup3v
      #declare c44 = cup4v
      #declare c45 = cup5v
      #declare c46 = cup6v
      #declare c47 = cup7v
      #declare c48 = cup8v

      #declare aangle = 4*45
      #include "arm.inc"
      // copy vectors
      #declare c51 = cup1v
      #declare c52 = cup2v
      #declare c53 = cup3v
      #declare c54 = cup4v
      #declare c55 = cup5v
      #declare c56 = cup6v
      #declare c57 = cup7v
      #declare c58 = cup8v

      #declare aangle = 5*45
      #include "arm.inc"
      // copy vectors
      #declare c61 = cup1v
      #declare c62 = cup2v
      #declare c63 = cup3v
      #declare c64 = cup4v
      #declare c65 = cup5v
      #declare c66 = cup6v
      #declare c67 = cup7v
      #declare c68 = cup8v

      #declare aangle = 6*45
      #include "arm.inc"
      // copy vectors
      #declare c71 = cup1v
      #declare c72 = cup2v
      #declare c73 = cup3v
      #declare c74 = cup4v
      #declare c75 = cup5v
      #declare c76 = cup6v
      #declare c77 = cup7v
      #declare c78 = cup8v

      #declare aangle = 7*45
      #include "arm.inc"
      // copy vectors
      #declare c81 = cup1v
      #declare c82 = cup2v
      #declare c83 = cup3v
      #declare c84 = cup4v
      #declare c85 = cup5v
      #declare c86 = cup6v
      #declare c87 = cup7v
      #declare c88 = cup8v
    #end
  }

  #ifndef (no_arms)
    #declare cr = 6.5
    torus { cr*.31 cr*.275 translate c11 + y*.50 }
    torus { cr*.28 cr*.250 translate c12 + y*.40 }
    torus { cr*.25 cr*.225 translate c13 + y*.30 }
    torus { cr*.22 cr*.200 translate c14 + y*.25 }
    torus { cr*.19 cr*.175 translate c15 + y*.18 }
    torus { cr*.16 cr*.150 translate c16 + y*.11 }
    torus { cr*.13 cr*.125 translate c17 + y*.08 }
    torus { cr*.10 cr*.100 translate c18 + y*.05 }

    torus { cr*.31 cr*.275 translate c21 + y*.50 }
    torus { cr*.28 cr*.250 translate c22 + y*.40 }
    torus { cr*.25 cr*.225 translate c23 + y*.30 }
    torus { cr*.22 cr*.200 translate c24 + y*.25 }
    torus { cr*.19 cr*.175 translate c25 + y*.18 }
    torus { cr*.16 cr*.150 translate c26 + y*.11 }
    torus { cr*.13 cr*.125 translate c27 + y*.08 }
    torus { cr*.10 cr*.100 translate c28 + y*.05 }

    torus { cr*.31 cr*.275 translate c31 + y*.50 }
    torus { cr*.28 cr*.250 translate c32 + y*.40 }
    torus { cr*.25 cr*.225 translate c33 + y*.30 }
    torus { cr*.22 cr*.200 translate c34 + y*.25 }
    torus { cr*.19 cr*.175 translate c35 + y*.18 }
    torus { cr*.16 cr*.150 translate c36 + y*.11 }
    torus { cr*.13 cr*.125 translate c37 + y*.08 }
    torus { cr*.10 cr*.100 translate c38 + y*.05 }

    torus { cr*.31 cr*.275 translate c41 + y*.50 }
    torus { cr*.28 cr*.250 translate c42 + y*.40 }
    torus { cr*.25 cr*.225 translate c43 + y*.30 }
    torus { cr*.22 cr*.200 translate c44 + y*.25 }
    torus { cr*.19 cr*.175 translate c45 + y*.18 }
    torus { cr*.16 cr*.150 translate c46 + y*.11 }
    torus { cr*.13 cr*.125 translate c47 + y*.08 }
    torus { cr*.10 cr*.100 translate c48 + y*.05 }

    torus { cr*.31 cr*.275 translate c51 + y*.50 }
    torus { cr*.28 cr*.250 translate c52 + y*.40 }
    torus { cr*.25 cr*.225 translate c53 + y*.30 }
    torus { cr*.22 cr*.200 translate c54 + y*.25 }
    torus { cr*.19 cr*.175 translate c55 + y*.18 }
    torus { cr*.16 cr*.150 translate c56 + y*.11 }
    torus { cr*.13 cr*.125 translate c57 + y*.08 }
    torus { cr*.10 cr*.100 translate c58 + y*.05 }

    torus { cr*.31 cr*.275 translate c61 + y*.50 }
    torus { cr*.28 cr*.250 translate c62 + y*.40 }
    torus { cr*.25 cr*.225 translate c63 + y*.30 }
    torus { cr*.22 cr*.200 translate c64 + y*.25 }
    torus { cr*.19 cr*.175 translate c65 + y*.18 }
    torus { cr*.16 cr*.150 translate c66 + y*.11 }
    torus { cr*.13 cr*.125 translate c67 + y*.08 }
    torus { cr*.10 cr*.100 translate c68 + y*.05 }

    torus { cr*.31 cr*.275 translate c71 + y*.50 }
    torus { cr*.28 cr*.250 translate c72 + y*.40 }
    torus { cr*.25 cr*.225 translate c73 + y*.30 }
    torus { cr*.22 cr*.200 translate c74 + y*.25 }
    torus { cr*.19 cr*.175 translate c75 + y*.18 }
    torus { cr*.16 cr*.150 translate c76 + y*.11 }
    torus { cr*.13 cr*.125 translate c77 + y*.08 }
    torus { cr*.10 cr*.100 translate c78 + y*.05 }

    torus { cr*.31 cr*.275 translate c81 + y*.50 }
    torus { cr*.28 cr*.250 translate c82 + y*.40 }
    torus { cr*.25 cr*.225 translate c83 + y*.30 }
    torus { cr*.22 cr*.200 translate c84 + y*.25 }
    torus { cr*.19 cr*.175 translate c85 + y*.18 }
    torus { cr*.16 cr*.150 translate c86 + y*.11 }
    torus { cr*.13 cr*.125 translate c87 + y*.08 }
    torus { cr*.10 cr*.100 translate c88 + y*.05 }
  #end

  // eyes
  object { octo_eye rotate <20,-20,0> translate <-10,22,-20.5> }
  object { octo_eye rotate <20,-20,0> translate < 10,22,-20.5> }

  pigment { skintexture }
  normal { granite scale 20 turbulence .2 bump_size .15 }
  finish { specular .5 phong .8 phong_size 110 }
}
