#declare A = pi/180
#declare SpiderGrey=rgb < .6, .6, .3 >

#include "colors.inc"
#include "spiders.inc"
#include "web.inc"

#declare Bark = texture {
  pigment { hexagon rgb < .35, .24, .21 >, rgb < .35, .25, .2 >, rgb < .33, .23, .19 > scale 4*z turbulence 1.8 }
  normal {
    hexagon
    normal { marble turbulence .3 }
    normal { marble turbulence 1 }
    normal { marble turbulence .6 }
    scale 4*z
    turbulence 1.5
  }
  scale 4
}

plane { y, -2.5
  texture { Bark finish { ambient -.6 } }
}

camera {
  location <-1, 1, 1.2>
  look_at  <.35, 0,  0>
  focal_point < .35, 0, 0>
  aperture 0.1
    blur_samples 20
}

light_source {
  <0,5000,6000>
  rgb < 2, 1.8, 1.8 >
}
light_source {
  <-1,1,1.2>
  rgb .5
  shadowless
}
light_source {
  < 0, 5, -20 >
  rgb 1
  shadowless
}

#include "colors.inc"

cylinder {
  < 0, 0, -60 >,
  < 0, 0, 6000 >,
  10
  texture { Bark scale .25 }
  scale .1
  rotate -90*x
  translate 2.6*x
}

cylinder {
  < 0, 0, -60 >,
  < 0, 0, 6000 >,
  10
  texture { Bark }
  scale .1
  rotate -90*x
  translate -2.3*x
  translate < 8, 0, -7 >
}
cylinder {
  < 0, 0, -60 >,
  < 0, 0, 6000 >,
  10
  texture { Bark }
  scale .1
  rotate -90*x
  translate -2.3*x
  translate < 15, 0, -11 >
}

#declare RL = seed(7)

#declare Sky = 0
#while (Sky<=600)
#declare Sky = Sky+1
difference {
height_field {
  gif "oakleaf+.gif"
}
height_field {
  gif "oakleaf-.gif"
}
texture { pigment { rgbt < 0, 0, 0, .75 > } finish { fade_distance .1 fade_power 2 } }
scale < 1, .1, 1 >
scale < .8, .8, .8 >
rotate 360*rand(RL)*y
translate < 25-25.7*sqrt(1-sqrt(rand(RL))), -2.5, -30+30*sqrt(1-sqrt(rand(RL))) >
scale .5
translate < -3, 50, 63 >
}
#end

#declare Leaves = 0
#while (Leaves<=500)
#declare Leaves = Leaves+1
difference {
height_field {
  gif "oakleaf+.gif"
}
height_field {
  gif "oakleaf-.gif"
}
pigment {
  gradient x
  pigment_map {
    [ 0 rgb < .1+.3*rand(RL), .1+.2*rand(RL), 0 > ]
    [ .5 rgb < .1+.3*rand(RL), .1+.2*rand(RL), 0 > ]
    [ 1 rgb < .1+.3*rand(RL), .1+.2*rand(RL), 0 > ]
  }
  turbulence .5+.8*rand(RL)
}
normal { crackle .3 }
scale < 1, .1, 1 >
scale < .8, .8, .8 >
rotate 360*rand(RL)*y
translate < 25-25.7*sqrt(1-sqrt(rand(RL))), -2.5, -30+30*sqrt(1-sqrt(rand(RL))) >
translate < -3, 0, 3 >
}
#end
