/* Persistence Of Vision raytracer beta version 3.1 sample file.
File by A. BUCK

BUCHMANN Alexandre
Quartier Novellini
B.P. 222
04000 DIGNE LES BAINS
FRANCE
EMAIL ABUCHM7158.AOL.COM
*/

#version 3.1;

#macro rotation (Arry,Row)

#local Alpha=radians(Arry[Row][3]);

#local X=Arry[Row][0];
#local Y=Arry[Row][1];
#local Z=Arry[Row][2];

#local KX=X/sqrt(X*X+Y*Y+Z*Z);
#local KY=Y/sqrt(X*X+Y*Y+Z*Z);
#local KZ=Z/sqrt(X*X+Y*Y+Z*Z);

matrix <

(1-cos(Alpha))*KX*KX+cos(Alpha),
(1-cos(Alpha))*KX*KY+KZ*sin(Alpha),
(1-cos(Alpha))*KX*KZ-KY*sin(Alpha),

(1-cos(Alpha))*KX*KY-KZ*sin(Alpha),
(1-cos(Alpha))*KY*KY+cos(Alpha),
(1-cos(Alpha))*KY*KZ+KX*sin(Alpha),

(1-cos(Alpha))*KX*KZ+KY*sin(Alpha),
(1-cos(Alpha))*KY*KZ-KX*sin(Alpha),
(1-cos(Alpha))*KZ*KZ+cos(Alpha),

0, 0, 0 >

#end

#macro miny1 (Arry1,Vertex)

#local Count2=0;
#local Number=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

#macro miny2 (Arry1,Arry2,Vertex)

#local Number=0;
#local Count2=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]),
<Arry2[Count2][0],Arry2[Count2][1],Arry2[Count2][2]>,
Arry2[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

#macro miny3 (Arry1,Arry2,Arry3,Vertex)

#local Number=0;
#local Count2=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
vaxis_rotate(
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]),
<Arry2[Count2][0],Arry2[Count2][1],Arry2[Count2][2]>,
Arry2[Count2][3]),
<Arry3[Count2][0],Arry3[Count2][1],Arry3[Count2][2]>,
Arry3[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

#macro miny4 (Arry1,Arry2,Arry3,Arry4,Vertex)

#local Number=0;
#local Count2=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
vaxis_rotate(
vaxis_rotate(
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]),
<Arry2[Count2][0],Arry2[Count2][1],Arry2[Count2][2]>,
Arry2[Count2][3]),
<Arry3[Count2][0],Arry3[Count2][1],Arry3[Count2][2]>,
Arry3[Count2][3]),
<Arry4[Count2][0],Arry4[Count2][1],Arry4[Count2][2]>,
Arry4[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "woods.inc"
#include "glass.inc"
#include "skies.inc"

#declare Blanc = rgb < 1 1 1 >;
#declare Gris = rgb < 0.752941 0.7529 0.752941 >;
#declare Or = rgb < 0.933333 0.8667 0.509804 >;
#declare Orchidee_Moyen2 = rgb < 0.670588 0.5098 1 >;
#declare Vert_Printemps = rgb < 0 1 0.498039 >;
#declare Bleu = rgb < 0 0 1 >;
#declare Argent = rgb < 0.6 0.6 0.7 >;

#declare C1 = .06;
#declare C2 = .8*C1;
#declare C3 = 1.1*C1;

#declare mat3 = array[3][4]
{
{0,0,1,45},
{0,1,0,45},
{1,0,0,45}
}

#declare mat3a = array[3][4]
{
{1,0,0,degrees(asin(sqrt(2/3)))},
{1,0,0,degrees(asin(sqrt(2/3)))},
{1,0,0,degrees(asin(sqrt(2/3)))}
}

#declare mat3b = array[3][4]
{
{0,1,0,0},
{0,1,0,120},
{0,1,0,240}
}

#declare mat4a = array[4][4]
{
{1,1,1,180},
{1,1,-1,180},
{1,-1,-1,180},
{1,-1,1,180}
}

#declare mat4b = array[4][4]
{
{1,0,0,45},
{1,0,0,45},
{1,0,0,45},
{1,0,0,45}
}

#declare mat5a = array[5][4]
{
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))}
}

#declare mat5b = array[5][4]
{
{0,1,0,0},
{0,1,0,72},
{0,1,0,144},
{0,1,0,216},
{0,1,0,288}
}

#declare vcube = array[8][3]
{
{1,1,1},
{1,1,-1},
{1,-1,-1},
{1,-1,1},
{-1,-1,1},
{-1,-1,-1},
{-1,1,-1},
{-1,1,1}
}

#declare cube1 =
difference { box { -C1, C1 }
             box { <-C3, -C2, -C2>, <C3, C2, C2> }
             box { <-C2, -C3, -C2>, <C2, C3, C2> }
             box { <-C2, -C2, -C3>, <C2, C2, C3> }
             pigment { Or }
             finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
           }

camera {
   location  <-.45, .3, -1>
   up        <0.0,  .6,  0>
   right     <.8,  0.0,  0>
   look_at   <-.15, .1, 0>}

light_source { <.5, .84, -.45> rgb <.65, .65, .65> }
light_source { <-.4, .64, -.3> rgb <.7, .7, .7> }
light_source { <-.5, .24, -.3> rgb <.6, .6, .6> }

sky_sphere { S_Cloud2 }

// Compound of three cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat3,1))
object { cube1 rotation (mat3, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
translate <.04, miny1(mat3,vcube)*C1, .18>
}

// Compound of three cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat3a,1))
object { cube1 rotation (mat3a, Count) rotation (mat3b, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
translate <.25, miny1(mat3a,vcube)*C1, .12>
}

// Compound of four cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat4a,1))
object { cube1 rotation (mat4a, Count) rotation (mat4b, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
translate <-.2, miny2(mat4a,mat4b,vcube)*C1, .12>
}

// Compound of five cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat5a,1))
object { cube1 rotation (mat5a, Count) rotation (mat5b, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
translate <-.4, miny1(mat5a,vcube)*C1, .18>
}

// Le meuble en acajou verni, de chez
// BADEL ET CIE (anciennement AZUR*INOX)
// 249, av. R. POINCARE - 83700 SAINT-RAPHAEL
// Tl. : 04 94 95 18 35 - Fax : 04 94 95 26 36

#declare coin =
difference { box { < -.025, -.015, -.025 >, < .025, .001, .025 > }
             cylinder { < -.025, -.016, -.025 >, < -.025, .005, -.025 >, .04 }
             pigment { Or }
             finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
           }

#declare ferrure =
box { < -.025, -.015, -.025 >, < .025, 0, .025 >
      pigment { Or }
      finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
     }

#declare poignee =
union {
difference { box { <-.045, -.0225, 0> <.045, .0225, .02> }
             box { <-.031, -.0145, -.005> <.031, .0175, .008> }
             cylinder { < -.045, -.0225, -.005>, < -.045, -.0225, .03>, .01 }
             cylinder { < -.045, .0225, -.005>, < -.045, .0225, .03>, .01 }
             cylinder { < .045, -.0225, -.005>, < .045, -.0225, .03>, .01 }
             cylinder { < .045, .0225, -.005>, < .045, .0225, .03>, .01 }
             }
             box { <-.021, .0176, 0> <.021, .0075, .01> }
             box { <-.03, .0075, 0> <-.022, .0165, .006> }
             box { <.022, .0075, 0> <.03, .0175, .006> }

difference { box { <-.0285, -.012, .002> <.0285, .008, .006> }
             box { <-.0235, -.007, 0> <.0235, .01, .008> }
           }
             pigment { Or }
             finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
}

// Le dessus du meuble reprsente le niveau 0.
union {
// Le plateau
box { <-.55, -.025, 0> <.55, 0, .55> }
// La paroi verticale de gauche
box { <-.55, -1, 0> <-.525, -.02, .55> }
// La paroi verticale de droite
box { <.525, -1, 0> <.55, -.02, .55> }
texture { T_Wood14 rotate 90*y finish { reflection 0.05 } scale .075 }
}

// Les coins du meuble
object { coin translate <.526, 0, .526> }
object { coin rotate <0, 90, 0> translate <.526, 0, .024> }
object { coin rotate <0, 180, 0> translate <-.526, 0, .024> }
object { coin rotate <0, 270, 0> translate <-.526, 0, .526> }

// Les tiroirs
#declare tiroir =
union {
difference { box { <-.524, -.124, 0> <.524, -.027, .02> }
             box { <-.357, -.09, -.01> <-.293, -.057, .01> }
             box { <.357, -.09, -.01> <.293, -.057, .01> }
texture { T_Wood14 rotate 90*y finish { reflection 0.05 } scale .075 }
           }
// La planche infrieure
box { <-.55, -.15, 0> <.55, -.125, .55>
texture { T_Wood14 rotate 90*y finish { reflection 0.05 } scale .075 }
 }
// La poigne de gauche
object { poignee translate <-.325, -.075, -.001> }
// La poigne de droite
object { poignee translate <.325, -.075, -.001> }
// Les ferrures
object { ferrure translate <.526, -.13, .024> }
object { ferrure translate <-.526, -.13, .024> }
}

object { tiroir }
object { tiroir translate <0, -.125, 0> }
object { tiroir translate <0, -.25, 0> }
object { tiroir translate <0, -.375, 0> }
object { tiroir translate <0, -.5, 0> }
object { tiroir translate <0, -.625, 0> }
object { tiroir translate <0, -.75, 0> }

// L'encadrement de fentre
difference {
union {
box { <-2, -2, .62> <2, 2, 1.05> pigment { Orchidee_Moyen2 } }
box { <-.5, -.08, .6> <.5, 1.35, .63> pigment { Vert_Printemps } }
}
union {
box { <-.41, .02, .55> <.41, 1.25, 1.10> pigment { Vert_Printemps } }
box { <-.45, .025, .8> <.45, 1.25, .9> pigment { Gris } }
}
finish { reflection 0.1 diffuse .52 phong .75 phong_size 15 }
}

// La tablette de fentre
box { <-.52, .005, .58> <.52, .025, .9>
texture { T_Wood7 scale 5 rotate 90*y }  }

#declare fenetre =
union {
// la vitre
box { <-.4, .05, .82> <.40, .63, .83> texture {T_Glass4} }
// Montant verticaux du cadre
// gauche
difference {
box { <-.45, .02, .8> <-.39, .66, .845> }
cylinder { < -.39, .01, .8 >, < -.39, .67, .8 >, .005 }
}
// droit
difference {
box { <.39, .02, .8> <.45, .66, .845> }
cylinder { < .39, .01, .8 >, < .39, .67, .8 >, .005 }
}
// Partie basse du cadre
difference {
box { <-.45, .02, .8> <.45, .06, .845> }
cylinder { < -.46, .06, .8 >, < .46, .06, .8 >, .005 }
}
// Partie haute du cadre
difference {
box { <-.45, .62, .8> <.45, .66, .845> }
cylinder { < -.46, .62, .8 >, < .46, .62, .8 >, .005 }
}
// Sparateur vertical de gauche
difference {
box { <-.21, .02, .8> <-.19, .66, .845> }
cylinder { < -.21, .01, .8 >, < -.21, .67, .8 >, .005 }
cylinder { < -.19, .01, .8 >, < -.19, .67, .8 >, .005 }
}
// Sparateur vertical du milieu
difference {
box { <-.01, .02, .8> <.01, .66, .845> }
cylinder { < -.01, .01, .8 >, < -.01, .67, .8 >, .005 }
cylinder { < .01, .01, .8 >, < .01, .67, .8 >, .005 }
}
// Sparateur vertical de droite
difference {
box { <.19, .02, .8> <.21, .66, .845> }
cylinder { < .19, .01, .8 >, < .19, .67, .8 >, .005 }
cylinder { < .21, .01, .8 >, < .21, .67, .8 >, .005 }
}
// sparateur horizontal
difference {
box { <-.45, .33, .8> <.45, .35, .845> }
cylinder { < -.46, .33, .8 >, < .46, .33, .8 >, .005 }
cylinder { < -.46, .35, .8 >, < .46, .35, .8 >, .005 }
}
pigment { Blanc }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 }
}

// Service fixe
// object { fenetre translate <0, .59, .055> }
// Service coulissant
object { fenetre translate <0, .2, 0> }

// La mer
plane { y, -8.5 pigment { Bleu }
finish { reflection 0.1 diffuse .52 phong .75 phong_size 15 } }

// Le sol
polygon {
5,
<-1, 0>, <-1, 1>, <1, 1>, <1, 0>, <-1, 0>
rotate <-90, 0, 0>
translate <0, -1, 0>
texture {
pigment {checker color Blue color Red scale .05}
finish {reflection 0}
} }
