//////////////////////////
// TEXTURE DECLARATIONS //
//////////////////////////

#declare RockMarble1=
  texture {
    pigment {
      bozo
      turbulence 0.71
      color_map {
        [0.00 rgb<0.80, 0.78, 0.50>]
        [0.40 rgb<0.10, 0.03, 0.00>]
        [0.42 rgb<0.35, 0.08, 0.10>]
        [1.00 rgb<0.76, 0.74, 0.50>]
      }
    }
    normal {bozo 2 turbulence 0.71}
    finish {specular 0.173 roughness 0.1 ambient 0.25 diffuse 0.8632 brilliance 1.7}
    scale <4, 1, 2>
    rotate -62*z
  }
  texture {
    pigment {
      granite
      color_map {
        [0.00 rgbf<0.80, 0.78, 0.50, 0.80>]
        [0.40 rgbf<0.10, 0.03, 0.00, 0.20>]
        [0.42 rgbf<0.35, 0.08, 0.10, 0.50>]
        [1.00 rgbf<0.76, 0.74, 0.50, 0.70>]
      }
    }
    finish {specular 0.73 roughness 0.01 ambient 0.25 diffuse 0.8632 brilliance 1.42}
    scale 2
  }

#declare RockMarble2=
  texture {
    pigment {
      bozo
      turbulence 0.71
      color_map {
        [0.00 rgb<0.80, 0.78, 0.50>]
        [0.40 rgb<0.10, 0.03, 0.00>]
        [0.42 rgb<0.35, 0.08, 0.10>]
        [1.00 rgb<0.76, 0.74, 0.50>]
      }
    }
    normal {bozo 2 turbulence 0.71}
    finish {specular 0.075 roughness 0.1 ambient 0.25 diffuse 0.8632 brilliance 1.7}
    scale <4, 1, 2>
    rotate -62*z
  }
  texture {
    pigment {
      granite
      color_map {
        [0.00 rgbf<0.80, 0.78, 0.50, 0.80>]
        [0.40 rgbf<0.10, 0.03, 0.00, 0.20>]
        [0.42 rgbf<0.35, 0.08, 0.10, 0.50>]
        [1.00 rgbf<0.76, 0.74, 0.50, 0.70>]
      }
    }
    finish {specular 0.15 roughness 0.1 ambient 0.25 diffuse 0.8632 brilliance 1.42}
    scale 2
  }


#declare FlameTex1=
  texture {
    pigment {
      granite
      turbulence 0.5
      color_map {
        [0.0 rgb<1, 1, 0.7>]
        [0.14 rgb<1, 0.8, 0.5>]
        [0.27 rgb<0.8, 0.6, 0.3>]
        [0.63 rgb<0.6, 0.4, 0.1>]
        [1.0 rgb<0.4, 0.2, 0.0>]
      }
      scale 5
      translate 0.5*y
    }
    normal {
      granite 1
      turbulence 0.5
      scale 5
      translate 0.5*y
    }
    finish {
      ambient 0.4
      diffuse 0.8
    }
  }
  texture {
    pigment {
      granite
      turbulence 0.7
      color_map {
        [0.00 rgbf<0.4, 0.0, 0.0, 0.3>]
        [0.38 rgbf<0.6, 0.1, 0.0, 0.3>]
        [0.60 rgbf<0.8, 0.2, 0.0, 0.3>]
        [0.75 rgbf<1, 0.3, 0.0, 0.3>]
        [0.85 rgbf<1, 0.6, 0.0, 0.3>]
        [1.00 rgbf<1, 0.6, 0.4, 0.3>]
      }
      scale 5
      translate 0.5*y
    }
    normal {
      granite 3
      turbulence 0.7
      scale 5
      translate 0.5*y
    }
    finish {
      ambient 0.4
      diffuse 0.8
    }
  }
  texture {
     pigment {
      granite
      turbulence 0.25
      color_map {
        [0.00 rgbf<1.00, 0.80, 0.70, 0.5>]
        [0.35 rgbf<1.00, 0.50, 0.00, 0.6>]
        [0.65 rgbf<0.75, 0.74, 0.00, 0.5>]
        [0.70 rgbf<0.80, 0.60, 0.00, 0.4>]
        [0.83 rgbf<0.60, 0.30, 0.00, 0.5>]
        [1.00 rgbf<0.40, 0.00, 0.00, 0.6>]
      }
      scale 5
      translate 0.5*y
    }
    finish {
      specular 0.7
      roughness 0.003
      ambient 0.4
      diffuse 0.8
    }
  }


#declare AirTex1=
  texture {
    pigment {
      bozo
      color_map {
        [0.00 rgb<1.00, 1.00, 1.00>]
        [0.22 rgb<0.75, 0.75, 1.00>]
        [0.44 rgb<0.30, 0.30, 1.00>]
        [0.54 rgb<0.30, 0.30, 1.00>]
        [0.87 rgb<0.75, 0.75, 1.00>]
        [1.00 rgb<1.00, 1.00, 1.00>]
      }
      scale 0.5
      scale <1, 5, 1>
      rotate 45*z
      turbulence 0.941
    }
    finish {
      specular 0.3
      roughness 0.003
    }
  }


#declare WaterTex1=
  texture {
    pigment {color rgbt<0.00, 0.64, 0.725, 0.70>}
    finish {specular 0.75 roughness 0.007 refraction 1.0 ior 1.33}
  }

/////////////////////////
// OBJECT DECLARATIONS //
/////////////////////////

//////////////////// BROKEN COLUMN  \\\\\\\\\\\\\\\\\

#declare LCount1=0
#declare Rock1=
  union {
    cylinder {<0, -9, 0>, <0, 3, 0>, 1.2}
    #while (LCount1 < 361)
      cylinder {<0, -9, 0>, <0, 3, 0>, 0.2
        translate -1.1*z
        rotate (LCount1+18)*y
      }
      #declare LCount1=LCount1+36
    #end
  }

#declare LCount1=0

#declare Rock2=
  union {
    #while (LCount1 < 359)
      cylinder {<0, -9.1, 0>, <0, 3.1, 0>, 0.2
        scale <1.5, 1, 0.5>
        translate -1.2*z
        rotate LCount1*y
      }
      #declare LCount1=LCount1+36
    #end
  }

#declare Rock3=
  difference {
    object {Rock1}
    object {Rock2}
    texture {RockMarble1 scale 2}
  }

#declare Cutface1=
  height_field {
    tga "colmncut2.tga"
    translate <-.5, -.5, -.5>
    scale <13, 0.75, 4.2>
    rotate 35*z
    rotate -45*y
    inverse
    texture {RockMarble2 scale 2}
  }

#declare TopColumnPiece=
  difference {
    object {Rock3}
    object {Cutface1 inverse}
  }

#declare BottomColumnPiece=
  difference {
    object {Rock3}
    object {Cutface1}
  }

// ROUNDED COLUMN UNIT AS BASIS FOR CREATING COLUMN TOP

#declare Rock4=
  union {
    cylinder {<0, 0, -1.5>, <0, 0, 1.5>, 0.075}
    sphere {<0, 0, -1.5>, 0.075}
    sphere {<0, 0, 1.5>, 0.075}
  }

// CREATES COLUMN TOP

#declare LCounter1=0
#declare LCounter2=0.2
#declare LCounter3=0
#declare ColTop1=
  union {
    #while (LCounter1 < 378)
      object {Rock4
        translate LCounter2*x
        rotate LCounter3*z
        translate -1.5*x
      }
      #declare LCounter1=LCounter1+1
      #if (LCounter1 < 72)
        #declare LCounter2=LCounter2+0.003
        #declare LCounter3=LCounter3-5
      #else
        #if (LCounter1 < 216)
          #declare LCounter2=LCounter2+0.0014
          #declare LCounter3=LCounter3-2.5
        #else
          #declare LCounter2=LCounter2+0.000695139
          #declare LCounter3=LCounter3-1.75
        #end
      #end
    #end
    #declare LCounter1=0
    #while (LCounter1 < 200)
      object {Rock4
        translate LCounter2*x
        rotate LCounter3*z
        translate <(-1.5+(LCounter1*0.014)), 0, 0>
      }
      #declare LCounter1=LCounter1+1
    #end
    #declare LCounter1=0
    #declare LCounter2=0.2
    #declare LCounter3=0
    #while (LCounter1 < 378)
      object {Rock4
        translate LCounter2*x
        rotate LCounter3*z
        rotate 180*y
        translate 1.5*x
      }
      #declare LCounter1=LCounter1+1
      #if (LCounter1 < 72)
        #declare LCounter2=LCounter2+0.003
        #declare LCounter3=LCounter3-5
      #else
        #if (LCounter1 < 216)
          #declare LCounter2=LCounter2+0.0014
          #declare LCounter3=LCounter3-2.5
        #else
          #declare LCounter2=LCounter2+0.000695139
          #declare LCounter3=LCounter3-1.75
        #end
      #end
    #end
    cylinder {<0, 0, -1.5>, <0, 0, 1.5>, 0.7
      translate -1.5*x
    }
    cylinder {<0, 0, -1.5>, <0, 0, 1.5>, 0.7
      translate 1.5*x
    }
    superellipsoid {<0.25, 0.1>
      scale <1.75, 0.5, 1.5>
      translate 0.35*y
    }
    translate 3*y
    texture {RockMarble1 scale 2}
  }

#declare TopColumnPiece2=
  union {
    object {TopColumnPiece}
    object {ColTop1}
  }

#declare FullColumn1=
  union {
    object {ColTop1}
    object {Rock3}
  }


//////////////////// AIR ELEMENT    \\\\\\\\\\\\\\\\\

// COUNTER

#declare CT1=0

// Y TRANSLATION

#declare CT2=-3

// BLOB STRENGTH

#declare CT3=0.5

// X TRANSLATION

#declare CT4=1.1

// ROTATION

#declare CT5=0

// X VECTOR PULL-BACK

#declare CT6=0.1

#declare Air1=
  blob {
    threshold 0.65
    #while (CT1 < 200)
      sphere {<0, 0, 0>, CT3, 1
        translate <CT4, CT2, 0>
        rotate CT5*y
      }
      sphere {<0, 0, 0>, CT3, 1
        translate <CT4, CT2, 0>
        rotate (CT5+180)*y
      }
      sphere {<0, 0, 0>, CT3, 1
        translate <CT4, CT2, 0>
        rotate (CT5+90)*y
      }
      sphere {<0, 0, 0>, CT3, 1
        translate <CT4, CT2, 0>
        rotate (CT5-90)*y
      }
      sphere {<0, 0, 0>, (CT3/2), 1
        translate <(CT4+CT6), CT2, 0>
        rotate 45*y
        rotate CT5*y
      }
      sphere {<0, 0, 0>, (CT3/2), 1
        translate <(CT4+CT6), CT2, 0>
        rotate 45*y
        rotate (CT5+180)*y
      }
      sphere {<0, 0, 0>, (CT3/2), 1
        translate <(CT4+CT6), CT2, 0>
        rotate 45*y
        rotate (CT5+90)*y
      }
      sphere {<0, 0, 0>, (CT3/2), 1
        translate <(CT4+CT6), CT2, 0>
        rotate 45*y
        rotate (CT5-90)*y
      }
      #declare CT1=CT1+1
      #declare CT2=CT2+0.02
      #declare CT3=CT3-0.002375
      #declare CT4=CT4-0.0045
      #declare CT5=CT5+2.7
      #declare CT6=CT6-0.0005
    #end
  }

//////////////////// FIRE ELEMENT  \\\\\\\\\\\\\\\\\

// COUNTER

#declare Counter1=0

// BLOB STRENGTH

#declare Bstr1=0.375

// ROTATION

#declare Rot8r=0

// NEW Y VECTOR

#declare Ytran1=0

// X TRANSLATION

#declare Xtran1=0.5

#declare Fire1=
  blob {
    threshold 0.65
    #while (Counter1 < 100)
      sphere {<0, 0, 0>, Bstr1, 1
        scale <1, 1, 1.5>
        rotate -35*x
        translate <0, Ytran1, sin(Counter1/20)>
        rotate Rot8r*y
        rotate -80*y
        rotate -90*y
        translate -0.5*x
      }
      sphere {<0, 0, 0>, Bstr1, 1
        scale <1.5, 1, 1>
        rotate -35*x
        translate <0, Ytran1*1.5, cos(Counter1/30)>
        rotate -Rot8r*y
        rotate -35*y
        translate -1*z
        translate 1.2*x
        rotate -90*y
        translate -0.5*x
      }
      sphere {<0, 0, 0>, Bstr1, 1
        scale <1.5, 1, 1>
        rotate -35*x
        translate <0, Ytran1*0.5, -cos(Counter1/30)>
        rotate Rot8r*y
        rotate 150*y
        translate -0.35*z
        translate 0.35*y
        translate -0.6*x
        rotate -90*y
        translate -0.5*x
      }
      sphere {<0, 0, 0>, Bstr1, 1
        scale <1, 1, 1.5>
        rotate -35*x
        translate <0, Ytran1, sin(Counter1/20)>
        rotate Rot8r*y
        rotate -80*y
        rotate 90*y
        translate -0.5*x
      }
      sphere {<0, 0, 0>, Bstr1, 1
        scale <1.5, 1, 1>
        rotate -35*x
        translate <0, Ytran1*1.5, cos(Counter1/30)>
        rotate -Rot8r*y
        rotate -35*y
        translate -1*z
        translate 1.2*x
        rotate 90*y
        translate -0.5*x
      }
      sphere {<0, 0, 0>, Bstr1, 1
        scale <1.5, 1, 1>
        rotate -35*x
        translate <0, Ytran1*0.5, -cos(Counter1/30)>
        rotate Rot8r*y
        rotate 150*y
        translate -0.35*z
        translate 0.35*y
        translate -0.6*x
        rotate 90*y
        translate -0.5*x
      }
      sphere {<0, 0, 0>, Bstr1, 1
        scale <(1+cos(Counter1/40)), 1, 1>
        translate <(cos(Counter1/20)/2), Ytran1, -cos(Counter1/30)/4>
        translate -0.5*x
        scale <1, 1.5, 1>
      }
      #declare Counter1=Counter1+1
      #if (Counter1 < 30)
        #declare Bstr1=Bstr1+0.0125
      #else
        #declare Bstr1=Bstr1-0.0095
      #end
      #declare Xtran1=Xtran1+0.9
      #declare Ytran1=Ytran1+0.04
      #declare Rot8r=Rot8r+0.9
    #end
  }

//////////////////// WATER ELEMENT  \\\\\\\\\\\\\\\\\

// COUNTER

#declare CT1=0

// Y TRANSLATION

#declare CT2=-3

// BLOB STRENGTH

#declare CT3=0.5

// X TRANSLATION

#declare CT4=0.9

// ROTATION

#declare CT5=0

// Y TRANSLATION #2

#declare CT6=1

// X TRANSLATION #2

#declare CT7=0.2

#declare Water1=
  blob {
    threshold 0.65
    #while (CT1 < 100)
      sphere {<0, 0, 0>, CT3, 1
        scale <1, 0.5, 1.5>
        translate <CT4, CT2, 0>
        rotate CT5*y
      }
      sphere {<0, 0, 0>, CT3, 1
        scale <1, 0.5, 1.5>
        translate <CT4, CT2, 0>
        rotate (CT5+180)*y
      }
      sphere {<0, 0, 0>, CT3, 1
        scale <1, 0.5, 1.5>
        translate <CT4, CT2, 0>
        rotate (CT5+90)*y
      }
      sphere {<0, 0, 0>, CT3, 1
        scale <1, 0.5, 1.5>
        translate <CT4, CT2, 0>
        rotate (CT5-90)*y
      }
      sphere {<0, 0, 0>, CT3, 1
        scale <2, 0.5, 1>
        translate <CT4, CT6, 0>
        rotate 45*y
        rotate -CT5*y
      }
      sphere {<0, 0, 0>, CT3, 1
        scale <2, 0.5, 1>
        translate <CT4, CT6, 0>
        rotate 45*y
        rotate (-CT5+180)*y
      }
      sphere {<0, 0, 0>, CT3, 1
        scale <2, 0.5, 1>
        translate <CT4, CT6, 0>
        rotate 45*y
        rotate (-CT5+90)*y
      }
      sphere {<0, 0, 0>, CT3, 1
        scale <2, 0.5, 1>
        translate <CT4, CT6, 0>
        rotate 45*y
        rotate (-CT5-90)*y
      }
      #declare CT1=CT1+1
      #declare CT2=CT2+0.04
      #declare CT5=CT5+5.4
      #declare CT6=CT6-0.04
      #if (CT1 < 50)
        #declare CT3=CT3-0.00475
        #declare CT4=CT4-0.0105
        #declare CT7=CT7-0.014
      #else
        #declare CT3=CT3+0.00475
        #declare CT4=CT4+0.0105
        #declare CT7=CT7+0.014
      #end
    #end
    cylinder {<0, 0.5, 0>, <0, -2, 0>, 1, 1 }
    cylinder {<0, 0.5, 0>, <0, -2, 0>, 0.5, 1 rotate 20*x translate -1*y }
    cylinder {<0, 0.5, 0>, <0, -2, 0>, 0.5, 1 rotate 20*x rotate 90*y translate -1*y }
    cylinder {<0, 0.5, 0>, <0, -2, 0>, 0.5, 1 rotate 20*x rotate -90*y translate -1*y }
    cylinder {<0, 0.5, 0>, <0, -2, 0>, 0.5, 1 rotate 20*x rotate 180*y translate -1*y }
  }

