//////////////////////////
// TEXTURE DECLARATIONS //
//////////////////////////

#declare GoldRing1=
  texture {
    pigment {color rgb<0.80, 0.85, 0.45>}
    normal {bumps 1 scale <8, 0.5, 3> rotate 45*y scale 0.015}
    finish {specular 0.7 roughness 0.007 brilliance 3.42}
  }

#declare StoneRing1=
  texture {
    pigment {
      granite
      color_map {
        [0.00 rgb<0.8, 0.70, 0.6>]
        [0.34 rgb<0.4, 0.10, 0.0>]
        [1.00 rgb<0.1, 0.00, 0.0>]
      }
    }
    normal {crackle 1 turbulence 0.65}
    finish {specular 0.4 roughness 0.1}
  }

#declare Red_Leather=
  texture {
    pigment {
      quilted
      turbulence 0.14
      color_map {
        [0.20 rgb<0.25, 0.09, 0.09>]
        [0.50 rgb<0.75, 0.09, 0.09>]
        [0.55 rgb<3.75, 0.09, 0.09>]
        [0.60 rgb<0.75, 0.09, 0.09>]
        [0.47 rgb<0.25, 0.09, 0.09>]
      }
    }
    normal {
      quilted 1
      control0 1
      control1 0
      turbulence 0.14
    }
    finish {
      specular 0.3
      roughness 0.03
      brilliance 4
    }
      scale 0.075
  }


#declare StnWllTex1=
    texture {
      pigment {
        granite
        turbulence 0.8345
        color_map {
          [0.00 rgb<0.65, 0.75, 0.55>]
          [0.33 rgb<0.55, 0.65, 0.45>]
          [0.52 rgb<0.70, 0.80, 0.68>]
          [1.00 rgb<0.65, 0.75, 0.55>]
        }
      }
      normal {granite 0.43 turbulence 0.8345}
      finish {specular 0.43 roughness 0.03 brilliance 1.75}
      scale 2
    }

#declare StnWllTex2=
  texture {
    pigment {color rgb<0.45, 0.50, 0.21>}
    normal {dents 1 scale <1, 3, 1> scale 0.1}
    finish {
      specular 0.65
      roughness 0.03
      brilliance 3.42
      reflection 0.85
    }
  }

/////////////////////////
// OBJECT DECLARATIONS //
/////////////////////////

#declare FloorRing1=
  union {
    torus {23.5, 0.25
      texture {GoldRing1}
      translate -9*y
    }
    torus {20, 3.5
      texture {StoneRing1 scale 4}
      scale <1, 0.02857143, 1>
      translate -9*y
    }
    torus {16.5, 0.25
      texture {GoldRing1}
      translate -9*y
    }
    sphere {0, 16.5
      texture {Red_Leather scale 20}
      scale <1, 0.0060606, 1>
      translate -9*y
    }
  }

#declare StoneWell1=
  union {
    torus {5.2, 0.2
      clipped_by {box {<-6, 0, -6>, <6, 1, 6>}}
      translate -7.85*y
    }
    torus {6.9, 1.5
      clipped_by {cylinder {<0, 3, 0>, <0, -3, 0>, 6.9}}
      clipped_by {box {<-8, -3, -8>, <8, 0, 8>}}
      translate -7.85*y
    }
    texture {StnWllTex1}
  }

#declare StoneWell2=
  union {
    torus {5.9, 0.1
      translate -8.9*y
      texture {GoldRing1}
    }
    object {StoneWell1}
    sphere {0, 5
      clipped_by {box {<-6, -6, -6>, <6, 0, 6>}}
      scale <1, 0.2, 1>
      translate -7.85*y
      texture {StnWllTex2}
    }
  }

