// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"

#ifndef (UseAsIncludeFile)

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <-1, 2, -6>
  direction 1.5*z
  right     4/3*x
//  look_at   <0, 1,  0.0>
  look_at   <-.85, 1,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}
#end

#declare chairLeg=
union{
  difference{
    box{<0,0.167,-0.03>,<1.0,.36,0.03>}
    box{<-.5,0.25,-0.2>,<1.5,.5,0.2> rotate<0,0,-9> translate<0,0.13,0>}
    pigment{Silver}
  }
  cylinder{<1.03,.10,0>,<1.03,.25,0> .03 pigment{Black}}
  cylinder{<1.06,.09,.02>,<1.06,.09,-.02> .09 pigment{Black}}

}


#declare chair=
union{
  superellipsoid{ <.25,.25>
   pigment{Red}
   scale<21/12/2,3/12/2,19/12/2>
   translate<0,16/12,0>
  }

  superellipsoid{ <.25,.25>
    pigment{Red}
    scale<21/12/2,14/12/2,3/12/2>
    rotate<5,0,0>
    translate<0,2.2,.8>
  }

  cylinder{<0,0.167,0>,<0,1.4,0> ,0.08 pigment{Silver} }

  box{<-.125,0,0>,<.125,1.35,.02>
    rotate<5,0,0>
    translate<0,1.05,.85>
    pigment{Black}
  }

  box{<-.125,1.05,0>,<.125,1.052,0.85> pigment{Black}}

  cylinder{<0,2.2,0.8>,<0,2.2,0.5> ,0.02 rotate<5,0,0> pigment{Black} }
  cylinder{<0,2.2,0.85>,<0,2.2,0.75> ,0.08 rotate<5,0,0> pigment{Black} }


  object{chairLeg}
  object{chairLeg rotate<0,72,0>}
  object{chairLeg rotate<0,144,0>}
  object{chairLeg rotate<0,216,0>}
  object{chairLeg rotate<0,288,0>}
}

#ifndef (UseAsIncludeFile)
  object{chair}
}
