/*Persistance of Vision Raytracer include file
Written by: Alexander McClung
Main file: Pentacle.pov

   This file contains all of the objects (except the actual candles) used in PENTACLE.POV
*/


#version 3.0
#ifndef(Final)
  #declare Final = false
#end

/***************/////POINT\\\\\*******************************************************************************************\
#declare Point = difference {
  #declare th = 1
  prism {
    0,
    1,
    4,
    <-5, 0>, <5, 0>, <0, 20>, <-5, 0>
  }
  prism {
    -1,
    2,
    4,
    <-5+th, 0+th>, <5-th, 0+th>, <0, 20-(2*th)>, <-5+th, 0+th>
  }
}

/***************/////WHOLE_POINT\\\\\*************************************************************************************\
#declare Whole_Point =   prism {
    0,
    1,
    4,
    <-5, 0>, <5, 0>, <0, 20>, <-5, 0>
  }

/***************/////PENTACLE\\\\\****************************************************************************************\
#declare Pentacle = union {
  #declare number = 5
  #declare Degrees = 360
  #declare step = Degrees/number
  #declare Count = 0
  #while (Count <= Degrees )
    object { Point
      translate z*5.5
      rotate <0, Count, 0>
    }
   #declare Count = (Count + step)
  #end

  difference {
    cylinder {
      <0, 0, 0>, <0, 1, 0>, 25.5
    }
    cylinder {
      <0, -0.1, 0>, <0, 1.1, 0>, 25.5-th
    }
  }
}

/***************/////GALAXY\\\\\******************************************************************************************\
#if(Final=true)
  #declare galaxy_seed = 101979
  #declare galaxy_color1 = <1,1,1>
  #declare galaxy_color2 = <.8, .2, .5>
  #declare galaxy_color3 = <.8, .3, .4>
  #declare galaxy_bgnebula = 1
  #declare galaxy_rotate = <90, 90, 90>
  #declare galaxy_nebula_sphere = 5
  #declare galaxy_nebula_ambient = <1.2, 1.3, 1.2>
//  #declare galaxy_star_coloration = -1
  #declare galaxy_pattern_scale = 1.5
  #include "galaxy.bg"


/***************/////CANDLE EARTH\\\\\************************************************************************************\
#declare Candle_Earth = object {
  #declare RS1 = seed(101979)
  #declare RS2 = seed(516906)
  #declare RS3 = seed(640)
  #declare NumDrip = 17
  #declare CP = pigment { rgb <.125, .5, .26> }
  #include "candle.inc"
  scale <2,3,2>
}

/***************/////CANDLE FIRE\\\\\*************************************************************************************\
#declare Candle_Fire = object {
  #declare RS1 = seed(208783708)
  #declare RS2 = seed(217949344)
  #declare RS3 = seed(153094279)
  #declare NumDrip = 3
  #declare CP = pigment { rgb <1.75, 1, .5> }
  #include "candle.inc"
  scale <5, 2, 5>
}

/***************/////CANDLE WATER\\\\\************************************************************************************\
#declare Candle_Water = object {
  #declare RS1 = seed(40114051)
  #declare RS2 = seed(16739789)
  #declare RS3 = seed(39726987)
  #declare NumDrip = 5
  #declare CP = pigment { rgb <.14, 1, 1.5> }
  #include "candle.inc"
  scale <3, 3, 3>
}

/***************/////CANDLE WIND\\\\\*************************************************************************************\
#declare Candle_Wind = object {
  #declare RS1 = seed(1998)
  #declare RS2 = seed(3179)
  #declare RS3 = seed(6479)
  #declare NumDrip = 6
  #declare CP = pigment { rgb <1.7, 1.7, 1.5> }
  #include "candle.inc"
  scale <3, 2, 3>
}

/***************/////CANDLE VOID\\\\\*************************************************************************************\
#declare Candle_Void = object {
  #declare RS1 = seed(139789210)
  #declare RS2 = seed(185719861)
  #declare RS3 = seed(100000000)
  #declare NumDrip = 10
  #declare CP = pigment { rgb <1.5, 1, 1.5> }
  #include "candle.inc"
  scale <4, 4, 4>
}
#end //if Final=true


/***************/////LAMP\\\\\********************************************************************************************\

/////LAMP_BODY\\\\\
#declare Lamp_Body = union {
  sphere { //tiny sphere at the very bottom..attaches to a decorative ring
    <0, -3, 0>, .5
  }
  torus {
    1, .125
    rotate x*90
    translate y*-4
  }
  sphere { //large sphere at the bottom...
    <0, 0, 0>, 2.5
  }
  torus { //lumpy thing on top of it
    1, .25
    translate y*2.25
  }
  difference { //...and we taper up to where the arms will attach to....
    cylinder {
      <0, 2.5, 0>, <0, 3.5, 0>, 1.25
    }
    torus {
      2, 1
      translate y*2.75
    }
  }
  cylinder { //...the cylinder that the arms will attach to....
    <0, 3.5, 0>, <0, 5, 0>, 1.35
  }
  difference { //..taper to thin and thick again
    cylinder {
      <0, 5, 0>, <0, 7, 0>, 1.25
    }
    torus {
      2, 1.125
      translate y*6
    }
  }
  cylinder { //make a little platform....
    <0, 7, 0>, <0, 7.25, 0>, 1.35
  }
  sphere { //...stick a sphere on it....
    <0, 8, 0>, 1.5
  }
  difference { //..taper up once more...
    cylinder {
      <0, 8.5, 0>, <0, 10, 0>, 1.5
    }
    torus {
      2, 1
      translate y*9
    }
  }
  cylinder { //...and a platform on top where the chain will go..
    <0, 10, 0>, <0, 10.125, 0>, 2
  }
  cylinder { //..more platform...
    <0, 10.125, 0>, <0, 10.25, 0>, 3
  }
}

/////SQT\\\\\

#declare SQT = intersection { //quarter torus, small
  #declare R1 = 2
  #declare R2 = .25
  torus {
    R1, R2
    rotate x*90
  }
  box {
    <0, 0, R1+1>, <R1+1, R1+1, -R1-R1>
  }
}

/////LQT\\\\\

#declare LQT = intersection { //quarter torus, large
  #declare R1 = 4
  torus {
    R1, R2
    rotate x*90
  }
  box {
    <0, 0, R1+1>, <R1+1, R1+1, -R1-R1>
  }
}

/////RSQT\\\\\

#declare RSQT = intersection { //quarter torus, really small
  #declare R1 = 1
  torus {
    R1, R2
    rotate x*90
  }
  box {
    <0, 0, R1+1>, <R1+1, R1+1, -R1-R1>
  }
}

/////LAMP_ARM\\\\\

#declare Lamp_Arm = union {
  cylinder { //this part connects to the body of the lamp...
    <0, 0, 0>, <0, 1, 0>, .4
  }
  cylinder { //...begin the arm with a straight section...
    <0, 1, 0>, <0, 2, 0>, .25
  }
  object { SQT //...curve it around...
    rotate z*90
    translate <2, 2, 0>
  }
  object { SQT //...and down...
    translate <2, 2, 0>
  }
  object { LQT //...now we switch to a bigger piece...
    rotate z*180
    translate <8, 2, 0>
  }
  object { LQT //...our last curve...
    rotate z*-90
    translate <8, 2, 0>
  }
  cylinder { //...now make a platform for the candle to sit on...
    <0, 0, 0>, <0, .125, 0>, .5
    translate <12, 2, 0>
  }
  cylinder { //...and we're done!
    <0, .125, 0>, <0, .25, 0>, 1
    translate <12, 2, 0>
  }
  object { RSQT //...not quite, just a torus for decoration at the bottom...
    rotate z*180
    translate <1, 0, 0>
  }
  object { RSQT //...and another one...
    rotate z*-90
    translate <1, 0, 0>
  }
  sphere { //...and let's put a sphere on it for good measure...
    <2, .75, 0>, .75
  }
  //...let's not forget the candle...
  object {
    #declare Fade = 10
    #declare Power = 1.25
    #declare LightPigment = rgb <.5, .5, .5>
    #declare RS1 = seed(1035)
    #declare RS2 = seed(4026)
    #declare RS3 = seed(43885)
    #declare NumDrip = 3
    #declare CP = pigment { rgb <1.7, 1.7, 1.5> }
    #include "candle.inc"
    translate <12, 2.2, 0>
  }

} //NOW we're done!

/////LAMP_ARMS\\\\\

#declare Lamp_Arms = union {
  #declare NumberOfArms = 6
  #declare Degrees = 360
  #declare Step = Degrees/NumberOfArms
  #declare Count = 0
  #while ( Count <= Degrees )
    object { Lamp_Arm
      translate <1.8, 3.75, 0>
      rotate y*Count
    }
    #declare Count = (Count + Step)
  #end
}

/////LAMP\\\\\

#declare Lamp = union {
  object { Lamp_Body }
  object { Lamp_Arms }
}

/***************/////SIGNATURE\\\\\**************************************************************************************\

#declare Signature = text {
  ttf "neaten.ttf", "ALMc" 1, 0
  translate <-.85, 0.1, -5>
}

/***************/////ROOM\\\\\*******************************************************************************************\

/////ROOM_SHELL\\\\\
#declare Room_Shell =  difference {
  cylinder { //big guy
     <0, -1, 0>, <0, 101, 0>, 51
  }
  cylinder { //lil guy, cuts outta big guy
    <0, -.5, 0>, <0, 100, 0>, 50
  }
  object { Point translate z*5.5 texture { Wood } }
  #declare DW = 60
  #declare DH = 45
  #declare DD = 2.5
  box {
    <-DW/2, 0, -DD*2>, <DW/2, DH+5, DD*2>
    translate -z*(50-DD)
    rotate y*-35
  }
}


/////PLANK\\\\\
#declare Plank_Length = 35
#declare Plank_Width = Plank_Length/6
#declare Plank_Depth = 1
#declare Plank = box {
  <-Plank_Width/2, -Plank_Depth/2, -Plank_Length/2>, <Plank_Width/2, Plank_Depth/2, Plank_Length/2>
}

/////FLOORBOARDS\\\\\
#declare FloorBoards = difference {
  union {
    #declare Num_X = 19 //# of planks in x direction
    #declare Num_Z = 5 //# of planks in z direction
    #declare CounterX = -((Num_X/2)*Plank_Width)
    #declare CounterZ = -((Num_Z/2)*Plank_Length)
    #declare Gap = .25
    #declare Off = Plank_Length/4
    #declare S = -1
    #while ( CounterX <= (Num_X/2)*Plank_Width)
      #declare Max_Dev = 5
      #declare SD = seed(CounterX * CounterZ / (CounterZ/CounterX) )
      #declare Deviance = (rand(SD)*Max_Dev*(-Off/Off))
      #while ( CounterZ <= (Num_Z/2)*Plank_Length)
        #declare S1 = seed(15029349)
        #declare SX = seed(1089)
        #declare SY = seed(8283742)
        #declare SZ = seed(19812+CounterZ+CounterX)
        #declare MX = 2
        #declare MY = 3
        #declare MZ = 2
        #declare R1 = rand(S1)
        #declare RX = (rand(SX)*MX*S)
        #declare S = -S
        #declare RY = (rand(SY)*MY*S)
        #declare S = -S
        #declare RZ = (rand(SZ)*MZ*S)
        #declare S = -S

        object { Plank
          rotate <RX, RY, RZ>
          translate <CounterX, 0, CounterZ+Off+Deviance>
        }
        #declare CounterZ = (CounterZ + Plank_Length + Gap )
      #end
      #declare Off = -Off
      #declare CounterZ = -((Num_Z/2)*Plank_Length)
      #declare CounterX = (CounterX + Plank_Width + Gap )
    #end
  }
  object { Point translate z*5.5 }
}

/////FLOOR\\\\\
#declare Floor = intersection {
  object { FloorBoards }
  cylinder {
    <0, -Plank_Depth, 0>, <0, Plank_Depth, 0>, 50
  }
}

/////ROOM\\\\\
#declare Room = union {
  object { Room_Shell
    #if(Final=true)
     texture { Stone scale 25 }
   #else
     pigment { Gray75 }
   #end
  }
  object { Floor
    #if(Final=true)
      texture { Wood scale .5 }
    #else
      pigment { DarkBrown }
    #end

    normal { dents 1 scale <.1, 10, 100> }
    translate y*-.5
  }
}

/***************/////DOORS\\\\\******************************************************************************************\

#declare DW = 60
#declare DH = 45
#declare DD = 2.5
#declare BH = 10
#declare BD = 2.5/2
#declare NP = 3
#declare PlW = (DW/2)
#declare PlH = DH
#declare PlD = DD
#declare G = .25

/////FRAME\\\\\
#declare Frame = union {
  box { //right side of door frame
    <-(DW/2.25)-3, 0, DD+5>, <-((DW/2)*1.15), DH, -DD+5>
  }
  box { //left side of door frame
    <(DW/2.25)+3, 0, DD+5>, <((DW/2)*1.15), DH, -DD+5>
  }
  box { //top of door frame
    <-(DW/2)*1.15, DH, DD+5>, <(DW/2)*1.15, DH+5, -DD+5>
  }
}

/////BAR\\\\\
#declare Bar = object {
  box {
    <-DW-BD, -BH/4, DD+BD>, <0+BD, BH/4, -DD-BD>
  }
}

/////PLANK\\\\\
#declare Plank = box {
  <-(PlW/2)+G, 0, -PlD>, <0-G, PlH*2, PlD>
}

/////DOOR\\\\\
#declare Door = union {
  #declare Sc = 1.25
  object { Plank texture { Wood scale Sc rotate x*90 } }
  object { Plank texture { Wood scale Sc rotate x*90 }  translate x*((-PlW/2)-G) }
  object { Plank texture { Wood scale Sc rotate x*90 }  translate x*-(PlW+(G/2) ) }
  object { Plank texture { Wood scale Sc rotate x*90 }  translate x*(-(PlW+(PlW/2))-G) }

  object { Bar
    translate y*((DH)+(BH*2))
    texture { Tarnished_Bronze }
  }
  object { Bar
    translate y*((DH)-(BH*2))
    texture { Tarnished_Bronze }
  }
}

/////SMALL_POINT\\\\\
#declare Small_Point = prism {
  0,

  1,
  4,
  <-4/18,1/18>, <4/18, 1/18>, <0, 18/18>, <-4/18, 1/18>
  rotate x*-90
}

#if(Final=true)

#declare Small_Point = object {
  #declare bend_object = object { Small_Point }
  #declare bend_axis1 = -y
  #declare bend_axis2 = <0, 1, 0>
  #declare bend_angle = 90
  #declare bend_direction = x
  #declare bend_start = 0.75
  #declare bend_finish = 1
  #declare bend_smoothness = 100
  #include "bend.inc"
}

/////RAY\\\\\
#declare Ray = object {
  #declare bend_object = object { Small_Point }
  #declare bend_axis1 = -y
  #declare bend_axis2 = <0, 1, 0>
  #declare bend_angle = 90
  #declare bend_direction = -x
  #declare bend_start = 0
  #declare bend_finish = 0.75
  #declare bend_smoothness = 100
  #include "bend.inc"
  rotate z*-60
}

#else
  #declare Ray = object { Small_Point }
#end

/////RAYS\\\\\
#declare Rays = union {
  #declare Deg = 360
  #declare Step = 45
  #declare C = 0
  #while ( C <= Deg )
    object {
      Ray
      scale <18, 18, 1>
      translate <7, -1, 0>
      rotate z*C
    }
   #declare C = (C + Step)
  #end
}


/////SUN_KNOCKER\\\\\
#declare Sun_Knocker = union {
  sphere {
    0, 7
  }
  torus {
    7, 1
    rotate x*90
    scale <1.5, 1, 1>
    translate <0, -7, -2>
  }
  object { Rays }
  sphere {
    <0, -5.5, -1>, 1
    scale <1, 2.5, 2.5>
  }
  sphere {
    <0, -7, -1>, 1
    scale <2, 2, 2>
  }
}

/////MOON\\\\\
#declare Moon = intersection {
  difference {
    sphere { 0, 18 }
    sphere {
      0, 14
      translate <-4, 4, 0>
    }
    scale<1, 1, 100>
  }
  sphere {
    0, 18
   }
  scale <1, 1, .25>
}

/////STAR\\\\\
#declare Star = union {
  #declare Num = 5
  #declare Degrees = 360
  #declare Step = Degrees/Num
  #declare Counter = 0
  #while ( Counter <= Degrees )
    object { Whole_Point
      rotate x*90
      rotate z*Counter
    }
    #declare Counter = (Counter+Step)
  #end
  box {
    <-2, -2, -1>, <2, 2, 1/15> //fills in the little hole in the middle
  }
  #declare Z = 15
  scale <.5, .5, Z>
  translate <0, 0, -Z>
}

#declare Star = intersection {
  object { Star }
  sphere {
    0, 12
  }
}

/////MOON_KNOCKER\\\\\
#declare Moon_Knocker = union {
  object { Moon scale .75 }
  object { Star
    rotate z*35
    translate <-9, 8, 6>
    scale .75
  }
  torus {
    7, 1
    rotate x*90
    scale <1.5, 1, 1>
    translate <0, -17, -1>
  }
  sphere {
    <0, -9.5, -.5>, 1
    scale <1, 2.5, 2.5>
  }
  sphere {
    <0, -12, -.5>, 1
    scale <2, 2, 2>
  }
}

/////SUN_DOOR\\\\\
#declare Sun_Door = union {
  object { Door }
  object { Sun_Knocker
    texture { Tarnished_Gold } //CHANGE TO TARNISHED_GOLD!!!
    scale .75
    translate <-DW/2, DH, -DD>
 }
}

/////MOON_DOOR\\\\\
#declare Moon_Door = union {
  object { Door }
  object { Moon_Knocker
    texture { Tarnished_Gold }
    scale .75
    translate <-DW/2, DH+5, -DD>
  }
}

/////DOORS_AND_FRAME\\\\\
#declare Doors_And_Frame = union {
  object { Frame scale 2 texture { Wood scale Sc rotate x*90 } }
  object { Sun_Door
    rotate y*-75
    translate <-41, 0, 67>
  }
  object { Moon_Door
    rotate y*75
    translate <57, 0, 9>
   }
}


/***************/////EARTH\\\\\******************************************************************************************\
#declare Scal = 50
#declare Map = height_field {
  tga EarthMap_Path
  scale <Scal, Scal/4, Scal>
  translate <-Scal/2, 0, -Scal/2>
  #if(Final=true)
    smooth
  #end
  translate z*Z_Fact
}

#declare Point = prism {
  0,
  10,
  4,
  <-4, 1>, <4, 1>, <0, 18>, <-4, 1>
}


#declare Earth = intersection {
  object { Map }
  object { Point }
}

/***************/////FIRE\\\\\*******************************************************************************************\
/////FLAMES\\\\\
#declare Flames = halo {
    emitting
    spherical_mapping
    linear
    turbulence <.5, 2.5, .5>
    color_map {
      [ 0 rgbt <1, 0, 0,  1> ]
      [.5 rgbt <1, .8, 0, -1> ]
      [ 1 rgbt <1, 1, 0, 1> ]
    }
    frequency 1
    #if(Final=true)
      samples 25
    #else
      samples 10
    #end
    scale 0.5
}

/////BURNING_FIRE\\\\\
#declare Burning_Fire = object {
  cylinder {
    <0, 0.000001, 0>, <0, 1, 0>, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo { Flames }
    hollow
    scale 1.5
  }
  scale <5, 5, 5>
}

/////COAL\\\\\
#declare Coal = height_field {
  tga FireMap_Path
  #if(Final=true)
    smooth
  #end
  #declare Sc = 20
  scale <Sc, 2, Sc>
  translate <-Sc/2, 0, -Sc/2>
  translate z*10
}

/////FIRE\\\\\
#declare Fire = union {
  intersection {
    object { Coal }
    object { Point }
     texture { Coals }
  }
  #if(Final=true)
    object { Burning_Fire
      scale <1, 1, 2.5>
      translate z*8
    }
  #end
}

/***************/////E_WATER\\\\\*****************************************************************************************\
#declare E_Water = prism {
  0,
  .75,
  4,
    <-4, 1>, <4, 1>, <0, 18>, <-4, 1>
 }

/***************/////WIND\\\\\********************************************************************************************\
#declare Dunes = height_field {
  tga WindMap_Path
  #if(Final=true)
    smooth
  #end
  #declare Sc = 20
  scale <Sc, 5, Sc>
  translate <-Sc/2, -1.5, -Sc/2>
  translate z*10
}

#declare Dust = sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence <1, .5, 2>
    color_map {
      [ 0 color rgbt <.792, .537, .337,  1> ]
      [ 1 color rgbt <.788, .769, .420, -1> ]
    }
    samples 10
    scale 0.75
  }
  hollow
  scale <5, 1.75, 10>
  translate <0, 2, 10>
  finish { ambient .6 diffuse .8 }
}


#declare Wind = union {
  intersection {
    object { Point }
    object { Dunes }
    texture { Sand }
  }
  #if(Final=true)
    object { Dust }
  #end
}

