/*Persistance Of Vision Raytracer Scene File
Written by: Alexander McClung
Written on: (completed) 25 July, 1998
Render Time: 1 day, 7 hours, 8 minutes 41 seconds
*/

#version 3.0

//setting this to true activates all the textures, light sources, and blobs which drastically slow render time.
#declare Final = true

#include "colors.inc"
#include "ptex.inc"
//the following 5 variables MUST be declared BEFORE including "pentacle.inc"
#declare Z_Fact = 4.7
#declare EarthMap_Path = "c:\graphics\works\irtc-p~1\earthmap.tga" //
#declare FireMap_Path = "c:\graphics\works\irtc-p~1\firemap.tga"
#declare WindMap_Path = "c:\graphics\works\irtc-p~1\windmap.tga"
#include "pentacle.inc"

#declare Fade = 6 //attributes for the light sources from the candles
#declare Power = 1.5
//#declare LightPigment = rgb <1, 1, 1>
#include "textures.inc"

#declare cam_loc = <-25, 20, 40>
#declare lookat = <0,12,0>
#declare sky_vect = y
#declare flare_brightness = <1.125, 1, 1>
#declare light_loc = < 75, 50, -100>
#declare flare_size = <.5, .5, .5>

light_source { light_loc  White }  //NEVER *EVER* ERASE THIS LIGHT!!!!
#include "sports.flr"
#include "nkflare.inc"

camera {
  location cam_loc
  look_at lookat
  angle 85
}

background { SkyBlue }

object { Room }

object {
  Pentacle
  texture { Pent }
}


#if(Final=true)
  object { Candle_Earth scale .5 translate z*27.5  rotate y*step*1  }
  object { Candle_Fire scale .5 translate z*30.5 rotate y*step*2 }
  object { Candle_Water scale .5 translate z*28.5 rotate y*step*3  }
  object { Candle_Wind scale .5 translate z*27.5 rotate y*step*4  }
  object { Candle_Void scale .5 translate z*27.5 rotate y*step*5 }
#end

object { Earth  texture { Mountain_Vegetation scale 14 }  translate z*5.5  rotate y*step*1  scale <1,.25,1> }
light_source {  <3.25, 0, -4.5>  rgb <1.5, 1, 0>  looks_like { object { Fire rotate y*step*2 } } }
object { E_Water  texture { Wat }  translate z*5.5  rotate y*step*3 }
object { Wind  translate z*5.5  rotate y*step*4 }


#if(Final=false)
  light_source { <10, 10, 10> White }
#end





object {
  Lamp
  translate <0, 35, 0>
  rotate y*25
  pigment { OldGold }
  finish {
    ambient .2
    diffuse .46
    reflection .25
    specular .1
    roughness 0.1
    brilliance .75
    metallic .87
  }
}


difference {
  object { Doors_And_Frame
    scale .5
    rotate y*180
    translate -z*(50-(DD*6))
    rotate y*-35
  }
  object { Signature
    scale <4.5, 4.5, 1.75>
    translate <-25, 46, 46>
    rotate y*145
    texture { Pent }
  }
}

