/*Persistance Of Vision Raytracer include file
Written by: Alexander McClung
Main File: Pentacle.pov

   This file contains all of the textures used in PENTACLE.POV
*/

#version 3.0

/**********************/////WOOD TEXTURE\\\\\****************************************************************************\
#declare WM1 = color_map {
  [0.0, 0.8 color rgb <0.66, 0.31, 0.20>
            color rgb <0.66, 0.31, 0.20>]
  [0.8, 1.0 color rgb <0.40, 0.13, 0.06>
            color rgb <0.20, 0.06, 0.03>]
}

#declare WM2 = color_map {
  [0.0, 0.1 color rgbf <0.66, 0.31, 0.20, 0.100>
            color rgbf <0.66, 0.31, 0.20, 0.500>]
  [0.1 0.9  color rgbf <0.40, 0.13, 0.06, 0.650>
            color rgbf <0.20, 0.06, 0.03, 0.975>]
  [0.9, 1.0 color rgbf <0.20, 0.06, 0.03, 0.975>
            color rgbf <0.20, 0.03, 0.015, 1.000>]
}

#declare WM1Old = color_map {
  [0.0, 0.1 color rgb <0.88, 0.60, 0.4>
            color rgb <0.88, 0.60, 0.4>]
  [0.1, 0.9 color rgb <0.88, 0.60, 0.4>
            color rgb <0.60, 0.40, 0.3>]
  [0.9, 1.0 color rgb <0.60, 0.40, 0.3>
            color rgb <0.60, 0.40, 0.3>]
}

#declare WM2Old = color_map {
  [0.0, 0.1 color rgbf <0.7, 0.6, 0.4, 0.100>
            color rgbf <0.8, 0.6, 0.3, 0.500>]
  [0.1, 0.9 color rgbf <0.8, 0.6, 0.3, 0.650>
            color rgbf <0.6, 0.4, 0.2, 0.975>]
  [0.9, 1.0 color rgbf <0.6, 0.4, 0.2, 0.975>
            color rgbf <0.6, 0.4, 0.2, 1.000>]
}

#declare T1 = texture {
  pigment {
    wood  turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    color_map { WM1  }
  }
  finish {
    ambient 0.125
    diffuse 0.133
  }
}

#declare T2 = texture {
  pigment {
    wood  turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    color_map { WM2 }
    rotate <5, 10, 5>
    translate -x*2
  }
  finish {
    ambient .1
    diffuse 0.33
  }
}


#declare Scale = 15
#declare Wood = texture { T1 scale Scale } texture { T2 scale Scale }

/**********************/////PENT TEXTURE\\\\\****************************************************************************\

#declare Pent = texture {
  pigment {  rgb .25 }
  finish {
    ambient .6
    diffuse .8
    reflection .25
    specular 1
    roughness 0.0001
  }
}

/**********************/////STONE TEXTURE\\\\\***************************************************************************\
#declare Stone = texture {
  pigment {
    crackle
    turbulence 0.53
    lambda 2.5
    omega 0.75
    octaves 5
    scale <0.45, 1.5, .45>
    color_map {
      [0.02 color rgbf <0.15, 0.25, 0.15, 0.0> ] //green crud
      [0.06 color rgbf <0.22, 0.25, 0.20, 0.0> ] //more green crud
      [0.10 color rgbf <0.25, 0.25, 0.20, 0.0> ] //fading back to the stone
      [1.00 color rgbf <0.65, 0.65, 0.60, 0.0> ] //the stone
    } //c_map
  }//pigment
//  pigment { White }
} //Stone


/**********************/////SLIME TEXTURE\\\\\***************************************************************************\

#declare Slime = texture {
  pigment {
    crackle
    turbulence 0.53
    lambda 2.5
    omega 0.75
    octaves 5
    scale <0.45, 1.5, .45>
    color_map {
      [0.02 color rgbf <0.17, 0.25, 0.17, 0.125/2> ] //green crud
      [0.125 color rgbf <0.16, 0.26, 0.17, 0.25> ] //more green crud
      [0.25 color rgbf <0.20, 0.25, 0.20, 0.75> ] //fading back to clear
      [1.00 color rgbf <1.00, 1.00, 1.00, 1.0> ] //clear
    } //c_map
  }//pigment
  scale 100
} //texture

/**********************/////TARNISHED_BRONZE TEXTURE\\\\\****************************************************************\

#declare Tarnished_Bronze  = texture {
  pigment { color rgb <0.36, 0.28, 0.20> }
  finish {
      ambient 0.1
      diffuse 0.65
  }
}
texture { Slime }

/**********************/////TARNISHED_GOLD TEXTURE\\\\\******************************************************************\

#declare Tarnished_Gold = texture {
  pigment { OldGold }
  finish {
    reflection .25
    specular .25
    roughness 0.001
  }
}
texture { Slime scale 1 }


/**********************/////MOUNTAIN_VEGETATION TEXTURE\\\\\*************************************************************\
#declare Mountain_Vegetation =  texture {
  pigment {
    bozo
    color_map
    {
       [ 0.0     rgbft <0.403922, 0.45098, 0.521569, 0.0, 0.0> ]
       [ 0.5     rgbft <0.5104, 0.5104, 0.614567, 0.0, 0.0> ]
       [ 0.75    rgbft <0.5729, 0.5729, 0.6354, 0.0, 0.0> ]
       [ 1.0     rgbft <0.552067, 0.656233, 0.718733, 0.0, 0.0> ]
    }
    turbulence 0.7
    sine_wave
  }
}
texture {
  pigment {
    agate
    agate_turb 1.0
    turbulence .76
    color_map
    {
       [ 0.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
       [ 0.15    rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
       [ 0.16    rgbft <0.0, 0.25098, 0.0, 0.0, 0.0> ]
       [ 0.875   rgbft <0.0, 0.25098, 0.25098, 0.0, 0.0> ]
       [ 0.9375  rgbft <0.0, 0.407843, 0.0, 0.0, 0.0> ]
       [ 0.96875  rgbft <0.0, 0.415686, 0.156863, 0.0, 0.0> ]
       [ 1.0     rgbft <0.003922, 0.329412, 0.278431, 0.0, 0.0> ]
    }
  }
}

/**********************/////COALS TEXTURE\\\\\***************************************************************************\
#declare Coals = texture {
  pigment {
    bozo
    turbulence .75
    color_map {
      [0.00 rgb <0, 0, 0> ]
      [0.25 rgb <.75, .25, 0> ]
      [0.50 rgb <1, .5, .1> ]
      [0.75 rgb <1.5, .75, .5> ]
      [1.00 rgb <1.75, 1, .5> ]
    } //map
    scale 5
  } //pigment
  finish {
    ambient 1
    diffuse 1
  }
} //texture

/**********************/////WAT TEXTURE\\\\\******************************************************************************\

#declare Wat = texture { //TEXTURE FOR WATER ELEMENT
  pigment { rgbt <0, 1, 1.5, 0.75> }
  finish {
    ambient .6
    diffuse .8
    reflection .2
    refraction 1
    ior 1.33
    specular 1
    roughness 0.0001
    caustics 1
  }
  normal { ripples .125  turbulence .25  }
  normal { waves 1 turbulence .75 scale <1, 2, 1> translate z*2.5}
}

/**********************/////SAND TEXTURE\\\\\*****************************************************************************\

#declare Sand = texture
{
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<0.792, 0.537, 0.337>]
      [1.00 color rgb<0.788, 0.769, 0.420>]
    }
  }
  normal
  {
    ripples 0.47
    turbulence 0.54
    phase 0.12
  }
  finish {
    ambient .6
    diffuse .8
  }
}
