
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "glass.inc"
#include "textures.inc"
#include "beetle.inc"
#include "hopper.inc"
#include "hopper2.inc"
#include "hopper_j.inc"
#include "temple.inc"
#include "cart.inc"

global_settings
{
  assumed_gamma 1.1
}

// ----------------------------------------
camera
{
  location  <0.0, 10, -80.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-0.8, 8,  0.0>
}

light_source
{
  0*x // light's position (translated below)
  color rgb 0.9 0.9 0.7  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <40, 2000, -100>   // <x y z> position of light
}


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 0.95  // light's color
  translate <40, 2000, -100>
}


light_source
{
  0*x // light's position (translated below)
  color rgb 0.9 0.9 0.7  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <-40, 200, -600>   // <x y z> position of light
}

light_source
{
  0*x // light's position (translated below)
  color rgb 0.8 0.8 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <-40, 200, 5000>   // <x y z> position of light
}


// ----------------------------------------

#declare Floor_Tex=texture{T_Stone44 scale 30}

#declare Blue_Glass =
texture {
    pigment { color rgbf<0.35, 0.3, 1.0, 0.5> }
    finish  { F_Glass1 }
}

#declare cloud_tex_1=texture{pigment{color rgbt<1,1,1,1>} halo{emitting spherical_mapping linear turbulence 0.8 color_map{[0 1 color rgbt<1,1,1,1> color rgbt<1,1,1,0>]} samples 10}}
#declare cloud_tex_2=texture{pigment{color rgbt<1,1,1,1>} halo{emitting spherical_mapping linear turbulence 0.75 color_map{[0 1 color rgbt<1,1,1,1> color rgbt<1,1,1,0>]} samples 10 rotate x*45}}

#declare cloud_tex_3=texture{pigment{color rgbt<1,1,1,1>} halo{emitting spherical_mapping linear turbulence 0.675 color_map{[0 1 color rgbt<1,1,1,1> color rgbt<1,1,1,0>]} samples 10}}
#declare cloud_tex_4=texture{pigment{color rgbt<1,1,1,1>} halo{emitting spherical_mapping linear turbulence 0.9 color_map{[0 1 color rgbt<1,1,1,1> color rgbt<1,1,1,0>]} samples 10 rotate x*45}}



#declare cloud_1=object{
 union{
  sphere{0, 1 hollow scale 5 texture{cloud_tex_1 scale<2.5,2,1> } translate<0.5,1,0>}
  sphere{0, 1 hollow scale 5 texture{cloud_tex_2 scale<3,1,1> } translate<-1,0,0>}
 }
}

#declare cloud_2=object{
 union{
  sphere{0, 1 hollow scale 5 texture{cloud_tex_3 scale<2.5,3,1> } translate<-2,0,0>}
  sphere{0, 1 hollow scale 5 texture{cloud_tex_4 scale<4,2,1> } translate<1,1.5,0>}
 }
}


#declare bottle_1=object{
 union{
  merge{
   torus{4,1 sturm translate<0,-5,0>}
   cylinder{<0,-6,0>,<0,5,0>,4}
   cylinder{<0,-5,0>,<0,5,0>,5}
   sphere{<0,5,0>,5}
   cylinder{<0,0,0>,<0,12,0>,2}
   torus{2,0.5 sturm translate<0,12,0>}
  }
  difference{
   cone{<0,11.75,0>,2,<0,14,0>,2.25 texture{Cork scale 2}}
   sphere{<0,14,-2.25>,0.15}
   sphere{<0,14,-2.25>,0.35 rotate<0,3,0>}
   sphere{<0,14,-2.25>,0.2 rotate<0,7,0>}
   sphere{<0,14,2.25>,0.15}
   sphere{<0,14,2.25>,0.35 rotate<0,3,0>}
   sphere{<0,14,2.25>,0.2 rotate<0,7,0>}
   sphere{<-2.25,14,0>,0.15}
   sphere{<-2.25,14,0>,0.35 rotate<0,3,0>}
   sphere{<-2.25,14,0>,0.2 rotate<0,7,0>}
   sphere{<2.25,14,0>,0.15}
   sphere{<2.25,14,0>,0.35 rotate<0,10,0>}
   sphere{<2.25,14,0>,0.2 rotate<0,11,0>}
   sphere{<0,11.75,2>,0.15}
   sphere{<0,11.75,2>,0.35 rotate<0,3,0>}
   sphere{<0,11.75,2>,0.2 rotate<0,7,0>}
   sphere{<-2,11.75,0>,0.15}
   sphere{<-2,11.75,0>,0.35 rotate<0,3,0>}
   sphere{<-2,11.75,0>,0.2 rotate<0,7,0>}
   sphere{<2,11.75,0>,0.15}
   }
 }
}

#declare bottle_air=object{
 union{
  difference{
   object{bottle_1}
   object{bottle_1 scale 0.8}
   cylinder{<0,5,0>,<0,100,0>,1.6}
   texture{T_Glass3}
   translate<0,6,0>
  }
  object{cloud_1 scale 0.8 translate<0,3,0>}
  object{cloud_2 scale 0.8 translate<0,11,0>}
 }
}

#declare hopper_air=object{
 union{
  object{hopper}
  object{bottle_air scale 0.6 rotate<0,0,-12> translate<-0.5,5.75,0>}
  rotate y*20
  translate x*10
 }
}

#declare bottle_water=object{
 union{
  difference{
   object{bottle_1}
   object{bottle_1 scale 0.8}
   cylinder{<0,5,0>,<0,100,0>,1.6}
   texture{T_Glass3}
  }
  difference{
   object{bottle_1 scale 0.79}
   box{<-100,0,-100>,<100,100,100> rotate<-50,0,-30>} //rotate oposite of bottle
   texture{pigment{rgbf<0.5,0.55,1.0,0.4>} finish{reflection 0.3 refraction 0.5 ior 1.33}}
  }
  torus{2.2 0.25 rotate<0,0,0> translate<0,12.5,0> pigment{Brown}}
  scale 0.5
 }
}

#declare hopper_water=object{
 union{
  object{
   bottle_water
   finish{phong 1.0}
   rotate<50,0,30> //remember to rotate water as well
   translate<-1,6,-4>
  }
  object{hopper_j rotate<0,0,-18> translate<-10,20,0>}
 }
}

//***************************************************

object{hopper_water rotate<0,0,55> translate<-4,26,5>}
object{hopper_air translate<-30,0,32>}
union{
 object{hopper_plain}
 object{full_cart scale 0.75 translate<17,0,0> pigment{bozo color_map{[0.0 0.25 color rgb<0.01,0.01,0.01> color rgb<0.2,0.05,0.01>][0.25 0.5 color rgb<0.2,0.05,0.01> color rgb<0.03,0.03,0.01>][0.5 1.0 color rgb<0.03,0.03,0.01> color rgb<0.01,0.01,0.01>]} turbulence 0.15} finish{phong 1.0}}
 rotate<0,10,0>
 translate<-18,0,-47>
}

union{
 object{beetle scale 3 rotate<0,90,5>}
 object{full_cart_2 scale 0.75 translate<12,0,0> pigment{bozo color_map{[0.0 0.25 color rgb<0.01,0.01,0.01> color rgb<0.2,0.05,0.01>][0.25 0.5 color rgb<0.2,0.05,0.01> color rgb<0.03,0.03,0.01>][0.5 1.0 color rgb<0.03,0.03,0.01> color rgb<0.01,0.01,0.01>]} turbulence 0.15} finish{phong 1.0}}
 translate<8,0,-15>
}

object{temple scale 2 rotate<0,30,0> translate<-40,0,180> texture{T_Grnt15}}
object{temple scale 2 translate<800,0,2000> texture{T_Grnt15}}
plane{y, 0 texture{Floor_Tex}}

sky_sphere{pigment{gradient y color_map { [0.0 color Firebrick] [1.0 color Yellow]} turbulence 0.5 scale<2,2,1>}}
