
// Rope.inc  July 13 1998  Neil Alexander

// Objects Rope and Bag for Balloon.pov

//-------------------------- Rope ---------------------------------

#declare factx = 0.75               // radius factor 
#declare facty = 2                  // height factor 
#declare Y1 = 0                     // counter for main loop

#declare Rope = union {
  #while (Y1 < 10)                  // main loop,  unfactored height of rope
    #declare X1 = sin(Y1)*(12-Y1)   // rope follows sine wave, gets smaller as it gets higher
    sphere {<X1*factx,Y1*facty,0>,0.25
      rotate y*Y1*36                // rotated around y-axis as it rises
      }
    #declare Y1 = Y1 + 0.02         // increment main loop counter
    #end                            // end main loop
  texture {                         // rope texture
    pigment { color rgb <1,0.95,0.7>}
    }
  } // end Rope

//-------------------------- Bag ----------------------------------

#declare facty = 84                 // height factor 
#declare Y1 = 24                    // counter for main loop

#declare Bag = union {
  #while (Y1 < facty)               // main loop,  height of rope
    sphere {<0,Y1,0>,0.25}
    #declare Y1 = Y1 + 0.25         // increment main loop counter
    #end                            // end main loop
  blob {  // sandbag
    threshold 0.5
    sphere {0,1,1
      scale <9,14,9>
      translate y*7
      }
    sphere {0,1,1
      scale <7,16,7>
      translate y*16
      }
    sphere {0,2,0.5
      scale <3,6,3>
      rotate z*45
      translate <1.5,4,0>
      }
    sphere {0,2,0.5
      scale <3,6,3>
      rotate z*-45
      translate <-1.5,4,0>
      }
    texture {  // bag texture
      pigment { color rgb <1,0.8,0.5> }
      }
    }  // end sandbag
  texture {                         // rope texture
    pigment { color rgb <1,0.95,0.7>}
    }
  }  // end Bag














