//BUSHFIRE.pov
#include "colors.inc"

background { color rgb < 0.5, 0.2, 0 > }
camera { 
       location < 0, 0.5, -17.5 >  
       look_at < 0, 2, 0 >
       angle 30
       }
light_source { < 0.25, 2, -5.75 > color Red } 
light_source { < 1.5, 5, 1 > color Red } 
light_source { < -1.5, 5, 1 > color Yellow }   

// FAR  FIRE
#declare Far =
              height_field {
                           gif "fract009.gif"
                           translate < -0.5, -0.5, -0.5 >
                           scale < 8, 2.1, 3 > 
              pigment { 
                        granite 
                        color_map {
                                  [ 0.0 color rgbt < 1, 0.8, 0, 0.6 > ]
                                  [ 0.4 color rgbt < 1, 0.8, 0, 0.6 > ]  
                                  [ 0.5 color Red ]
                                  [ 0.6 color rgbt < 1, 0.8, 0, 0.6 > ]  
                                  [ 1.0 color rgbt < 1, 0.8, 0, 0.6 > ]
                                   }
                            scale  < 2, 15, 1 >   
                      }                
              finish { ambient 1
                       diffuse 0 }
                          }  
object { Far scale 0.5 }                          
object { Far translate < -3, -0.4, 1.8 > }                          
object { Far translate < 3, -0.4, 1.8 > } 

// MIDDLE DISTANCE
#declare Mid =
              height_field {
                           gif "fract009.gif"
                           translate < -0.5, -0.5, -0.5 >
                           scale < 10, 0.45, 3 > 
              pigment { 
                        bozo
                        turbulence 2
                        color_map {
                                   [ 0.0 color rgb < 1, 0.7, 0.1 > ]
                                   [ 0.3 color rgb < 1, 0.6, 0.1 > ]
                                   [ 0.6 color rgb < 1, 0.5, 0.1 > ]
                                   [ 1.0 color rgb < 1, 0.2, 0.1 > ]
                                   }
                         scale < 0.5, 1, 1 >
                      }
        normal { bumps 0.25 scale 0.05 }
        
        finish { ambient 0.2 }
         }
object { Mid translate < 0, -0.05, -2 > }

//SAPLING
#declare Leaf =
              disc { < 0, 0, 0 >,< 0, 0, 1 >,0.1  scale < 1, 3, 1 >
                    pigment { color rgb < 0.5, 0.6, 0.5 > }
                    finish { ambient 0.2 }
                   }

#declare Number_of_Cycles = 10
#declare Count_per_Cycle = 40
#declare Coefficient = 0.01
#declare Starting_Angle = 0
#declare Angle = 360 / Count_per_Cycle
#declare Count = Number_of_Cycles * Count_per_Cycle -1

#declare SD1 = seed(1)
#declare Clump =
         union {
         #while ( Count >= 0 )
                object { Leaf scale 1*rand(SD1)
                translate < 0.01 +0.1*( Starting_Angle * Coefficient ), 
                            3*rand(SD1), 0 >  
                       rotate < 0,  Starting_Angle * rand(SD1), 25*rand(SD1) >
                       }
         #declare Starting_Angle =  Starting_Angle + Angle
         #declare Count = Count - 1

         #end      
               }
#declare Folg =
        union {
object { Clump }
object { Clump scale < 0.5, 1, 1 > translate 2*y } 
               }

#declare Curv =    
              torus { 5, 0.08   rotate 90*x
                     clipped_by {
                             box { < -6, 0, -0.1 >,< 0, -6, 0.1 > }
                                }
                     scale < 1, 2, 1 >
                         pigment { color Gray75 }
                         finish { ambient 0.2 }

                    }

#declare Stick =
               cylinder { < 0, 0, 0 >,< 0, 2, 0 >,0.08
                         pigment { color Gray75 }
                         finish { ambient 0.2 }
                         }
#declare Fork =
           union { 
                 object { Stick }
                 object { Stick  rotate 40*z  translate 0.5*y }
                 object { Stick  rotate -40*z translate 0.25*y }
                 object { Curv translate 5*x }    
                 }
#declare Hifork =
           union { 
                 object { Stick }
                 object { Stick  rotate 40*z  translate 0.5*y }
                 object { Stick  rotate -40*z translate 0.25*y }
                 object { Curv scale  0.5 translate 2.5*x }    
                 }



#declare Bush =
            union {
                   object { Folg }
                   object { Fork translate -1*y }
                      translate < -5, 10, 0 >
                  }
#declare Hibush =
            union {
                   object { Folg scale 0.85 }
                   object { Hifork translate -1*y }
                      translate < -2.5, 5, 0 >
                  }
#declare Main =
             union {
                    cone { < 0, 0, 0 >,0.8,< 0, 0.8, 0 >,0.38
                             scale < 1, 1, 0.4 >
                         }
                    cone { < 0, -0.2, 0 >,1,< 0, 0.6, 0 >,0.38
                             scale < 0.3, 1, 1 >
                         }

                    cone { < 0, 0, 0 >,0.4,< 0, 12, 0 >,0.25   }
                    sphere { < 0, 0, 0 >,0.25  scale < 1, 2, 1 >   //A
                               translate 12*y }
                    cone { < 0, 12, 0 >,0.25,< -0.25, 15, 0 >,0.24  }
                    sphere { < 0, 0, 0 >,0.24  scale < 1, 2, 1 >
                               translate < -0.25, 15, 0 > }         //B
                    cone { < -0.25, 15, 0 >,0.24,< 0, 18, 0 >,0.22  }
                    sphere { < 0, 0, 0 >,0.22  scale < 1, 2, 1 >
                               translate 18*y }                     //C
                    cone { < 0, 18, 0 >,0.22,< 0.2, 20, 0 >,0.19  }
                    sphere { < 0, 0, 0 >,0.19  scale < 1, 2, 1 >
                               translate < 0.2, 20, 0 > }                     //D
                    cone { < 0.2, 20, 0 >,0.19,< 0, 22, 0 >,0.15  }
                    sphere { < 0, 0, 0 >,0.15  scale < 1, 2, 1 >
                               translate 22*y }                     //E
                    cone { < 0, 22, 0 >,0.15,< -0.1, 24, 0 >,0.125  }
                    sphere { < 0, 0, 0 >,0.125  scale < 1, 2, 1 >
                               translate < -0.1, 24, 0 > }                      //F
                    cone { < -0.1, 24, 0 >,0.125,< 0, 26, 0 >,0.1  }
                    sphere { < 0, 0, 0 >,0.1  scale < 1, 2, 1 >
                               translate 26*y }
                         pigment { color Gray75 }
                         finish { ambient 0.2 }
                   }

#declare Euco =
          union {
                object { Main }
                object { Bush translate  12*y }
                object { Bush rotate 120*y translate 15*y }
                object { Bush rotate 30*y translate 18*y } 
                object { Hibush rotate 160*y translate 20*y }
                object { Hibush scale 0.8 rotate 100*y translate 16.5*y }  
                object { Hibush scale 0.8  translate 22*y }
                object { Hibush scale 0.6 rotate 30*y  translate 24*y }  
                object { Hibush scale 0.6 rotate 150*y  translate 24*y } 
                
                object { Hibush scale 0.5 rotate -110*y  translate 26*y }
                      }
// SKY                       
 plane { z, 50         
        pigment { 
                  gradient y
                          color_map {
                                  [ 0.0 color rgb < 0.9, 0.85, 0 > ]
                                  [ 1.0 color rgb < 0.4, 0.2, 0.2 > ]
                                    }
                               scale 25
               }
       finish { ambient 0.8
                diffuse 0 }
     }

plane { z, 3.5                 // FAR FLAMES
          pigment {
                    bozo
                    turbulence 0.5
                        color_map {
                                  [ 0.0 color Clear ]
                                  [ 0.2 color rgbt < 0, 0, 1, 0.95 > ]
                                  [ 0.4 color rgbt < 0, 0, 1, 0.85 > ]
                                  [ 0.5 color rgbt < 1, 0.2, 0, 0.5 > ] 
                                  [ 0.6 color rgbt < 1, 1, 0, 0.5 >  ] 
                                  [ 0.7 color rgbt < 1, 0.2, 0, 0.5 > ] 
                                  [ 0.9 color Clear ]    
                                  [ 1.0 color Clear ]    
                                  }
                            scale < 4, 6, 1 >
                            rotate 10*z
                            translate < -1, -3, 0 >
                  }
          finish { ambient 1
                   diffuse 0
                 }
        }

plane { z, 0                 // NEAR FLAMES
          pigment {
                    wrinkles
                    turbulence 0.5
                        color_map {
                                  [ 0.0 color Clear ]
                                  [ 0.1 color Clear ]
                                  [ 0.3 color rgbt < 1, 1, 0, 0.5 > ]
                                  [ 0.5 color rgbt < 1, 0.2, 0, 0.4 > ]
                                  [ 0.55 color rgbt < 1, 0.3, 0, 0.5 > ]  
                                  [ 0.6 color rgbt < 1, 0.2, 0, 0.4 >  ] 
                                  [ 0.7 color rgbt < 1, 1, 0, 0.5 > ] 
                                  [ 0.95 color Clear ]    
                                  [ 1.0 color Clear ]    
                                  }
                            scale < 4, 7, 1 >
                            rotate 8*z
                            translate < 1, -1, 0 >
                  }
          finish { ambient 1
                   diffuse 0
                 }
        }

// PLAIN
plane { y, 0                            
              pigment { 
                        bozo
                        turbulence 2
                        color_map {
                                   [ 0.0 color rgb < 1, 0.7, 0.1 > ]
                                   [ 0.3 color rgb < 1, 0.6, 0.1 > ]
                                   [ 0.6 color rgb < 1, 0.5, 0.1 > ]
                                   [ 1.0 color rgb < 1, 0.4, 0.1 > ]
                                   }
                         scale < 0.5, 1, 1 >
                      }
        normal { bumps 0.25 scale 0.025 }
        
        finish { ambient 0.2 }
     }

// DEAD TREE 

#declare Runk =
           union {
              torus { 0.05, 0.005   rotate 90*x
                     clipped_by {
                             box { < -0.1, 0, -0.1 >,< 0, -0.1, 0.1 > }
                                }
                    }
              sphere { < 0, 0, 0 >,0.005 translate -0.05*x }          
              sphere { < 0, 0, 0 >,0.005 translate -0.05*y } 
                    translate 0.05*y
                    pigment { color White }
                    normal { bumps 0.3 scale < 0.001, 1, 0.001 > }
                    finish { ambient 0.15 }
                 }
#declare Wig =                            // quarter of a torus
          
              torus { 0.1, 0.007   rotate 90*x
                     clipped_by {
                             box { < -0.15, 0, -0.1 >,< 0, 0.1, 0.1 > }
                                }
                    pigment { color White }
                    normal { bumps 0.3 scale < 0.001, 1, 0.001 > }
                    finish { ambient 0.15 }   
                    }
#declare Twig =                           // eighth of a torus
           union {
              object { Wig
                     clipped_by {
                                 box { < -0.15, 0, -0.1 >,< 0, 0.15, 0.1 > 
                                    rotate 45*z 
                                     }
                                }
                    }
              sphere { < 0, 0, 0 >,0.007 translate -0.1*x }          
              sphere { < 0, 0, 0 >,0.007 translate < -0.071, 0.071, 0 > } 
                    translate 0.1*x
                    pigment { color White }
                    normal { bumps 0.3 scale < 0.001, 1, 0.001 > }
                    finish { ambient 0.15 }
                 }
#declare Aranch =
             union {
                   object { Twig }
                   object { Twig scale 0.8 rotate 180*y
                            translate < 0.0293, 0.071, 0 >
                           }
                   object { Twig scale 0.6 
                            translate < 0.0059, 0.128, 0 >
                          }
                   object { Twig scale 0.45 rotate 180*y
                            translate < 0.0234, 0.1704, 0 >
                           }   
                   }
#declare Branch =           
             union {
                   object { Aranch }
                   object { Aranch scale 0.3  rotate -40*z
                            translate  < 0.0293, 0.071, 0 > }
                   object { Aranch scale 0.3  rotate 20*z
                            translate  < 0.0293, 0.071, 0 > }
                   object { Aranch scale 0.2  
                            translate  < 0.01, 0.2023, 0 > }

                   object { Aranch scale 0.25 rotate -40*x
                            translate < 0.0059, 0.128, 0 > }
                   object { Aranch scale 0.15 rotate 40*x
                            translate < 0.0234, 0.1704, 0 > }
                   rotate 90*z
                   }
#declare Butt =
          union {
                object { Runk translate 0.05*x scale < 1.5, 1, 0.8 > }
                object { Runk translate 0.05*x rotate 15*y }
                object { Runk translate 0.05*x rotate 45*y }
                object { Runk translate < 0.05, -0.01, 0 > rotate 180*y }   
                sphere { < -0.005, 0.07, 0 >,0.009 }
                cone { < 0.003, 0, 0 >,0.01,< -0.005, 0.07, 0 >,0.009  }
                cone { < -0.005, 0.0697, 0 >,0.009,< 0, 0.12, 0 >,0.006  }  
                    pigment { color White }
                    normal { bumps 0.35 scale < 0.001, 1, 0.001 > 
                              rotate -45*z }
                    finish { ambient 0.15 }
                     
                 }
#declare Tree =
           union {
object { Butt translate < 0.05, 0.16, 0 > }           // base

object { Branch  scale 0.5 rotate -15*z
                 translate < 0.048, 0.23, 0 > }     // to the left

object { Branch scale 0.7 rotate < 30, 180, 30 > 
                 translate < 0.05, 0.25, 0 > }      // to the right

object { Branch scale 0.6 rotate < -20, -40, -30 >      // up to left 
              translate < 0.051, 0.27, 0 > }

object { Branch scale 0.8 rotate < 0, -30, -80 >        // straight up    
              translate < 0.051, 0.275,  > }
object { Branch  scale 0.5 rotate < 0, -110, -5 >
                 translate < 0.06, 0.168, -0.15 > }     // fallen branch
          translate -0.16*y
           }
object { Tree scale 15 translate < 1, -0.1, -6 > }

object { Tree scale < 10, 15, 10 > rotate 120*y  translate < -2, 0, 1.25 > }   
object { Tree scale < 20, 15, 20 > rotate 80*z  translate < 1, -1.2, 0.25 > }

object { Euco scale 0.075 rotate 180*y translate < 0, 0, -6 > } 
object { Euco scale 0.075 translate < -1.5, 0, -11 > }
                
// GRASS

#declare Number_of_Cycles = 2
#declare Count_per_Cycle = 50
#declare Coefficient = 0.5
#declare Starting_Angle = 0
#declare Angle = 360 / Count_per_Cycle
#declare Count = Number_of_Cycles * Count_per_Cycle -1

#declare SD1 = seed(1)

#declare Spinfx =
       union {
         sphere { < 0, 0, 0 >,0.1
                   pigment { color Red }
                }
         #while ( Count >= 0 )
                cone { < 0, 0, 0 >,0.15,< 0, 3 * rand(SD1), 0 >,0.0
                       scale < 0.25, 1.3, 0.25 >
                       translate 0.4*rand(SD1)*x
                       rotate < Starting_Angle * Coefficient,  
                                0, Starting_Angle * Coefficient  >
                       pigment { color rgb < 1, 0.8, 0.5 > }
                       finish { ambient 0.15 }

                       }
         #declare Starting_Angle =  Starting_Angle + Angle
         #declare Count = Count - 1

         #end      
                }

#declare Patch =
       union {
object { Spinfx scale < 0.2, 0.3, 0.2 > 
         translate < -3.75, 0, 1 > }   
object { Spinfx scale < 0.2, 0.3, 0.2 > 
         translate < -4.5, 0, 1 > }
object { Spinfx scale < 0.2, 0.3, 0.2 > 
         translate < 4.5, 0, 1 > } 
object { Spinfx scale < 0.2, 0.3, 0.2 > 
         translate < -1, 0, -6 > }
object { Spinfx scale < 0.2, 0.3, 0.2 > 
         translate < 0.6, 0, -5 > }   
object { Spinfx scale < 0.15, 0.17, 0.15 > 
         translate < 1.8, 0, -5 > }    
object { Spinfx scale < 0.2, 0.22, 0.2 > 
         translate < -2, 0, -5.5 > }   
object { Spinfx scale < 0.2, 0.22, 0.2 > 
         translate < -1.25, 0, -5 > }    
object { Spinfx scale < 0.25, 0.27, 0.25 >   
         translate < -1.5, 0, -5.1 > }   
object { Spinfx scale < 0.2, 0.22, 0.2 >   
         translate < 0, 0, -6.5 > }        
object { Spinfx scale < 0.2, 0.22, 0.2 >   
         translate < 2, 0, -5 > }   
object { Spinfx scale < 0.25, 0.27, 0.25 > 
         translate < 1.5, 0, -6 > }
object { Spinfx scale < 0.25, 0.27, 0.25 > 
         translate < -0.5, 0, -11.76 > }

         }
object { Patch }

#declare One =
             union {
                   cone { < 0, 0, 0 >,0.5,< 0, 1, 0 >,0.46 }
                   sphere { < 0, 0, 0 >,0.5 }
                         pigment { color White }
                         normal { dents 0.5 scale < 0.025, 0.08, 0.025 > }
                         finish { ambient 0.2 }
                   }
#declare Nlim =
     union {
       object { One }                                            //1
       object { One scale < 0.92, 1, 0.92 > 
                    translate 1*y }                              //2
       object { One scale < 0.8464, 1, 0.8464 > rotate -5*z 
                    translate 2*y }                              //3
       object { One scale < 0.7787, 1, 0.7787 > rotate -10*z 
                    translate < 0.0872, 3, 0 > }                 //4
       object { One scale < 0.7164, 1, 0.7164 > rotate -5*z 
                    translate < 0.2608, 4, 0 > }                 //5
       object { One scale < 0.6591, 1, 0.6591 >  
                    translate < 0.348, 5, 0 > }                  //6
       object { One scale < 0.6064, 1, 0.6064 > rotate 5*z 
                    translate < 0.348, 6, 0 > }                  //7
       object { One scale < 0.5579, 1, 0.5579 >  
                    translate < 0.2608, 7, 0 > }                 //8    
       object { One scale < 0.5132, 1, 0.5132 > rotate -5*z 
                    translate < 0.2608, 8, 0 > }                 //9    
       object { One scale < 0.4722, 1, 0.4722 > rotate -10*z 
                    translate < 0.348, 9, 0 > }                 //10    
       object { One scale < 0.4344, 1, 0.4344 > rotate -15*z 
                    translate < 0.5216, 10, 0 > }                 //11  
       object { One scale < 0.3996, 1, 0.3996 > rotate -10*z 
                    translate < 0.7804, 11, 0 > }                 //12    
       object { One scale < 0.3676, 1, 0.3676 > rotate -5*z 
                    translate < 0.954, 12, 0 > }                 //13  
       object { One scale < 0.3502, 1, 0.3502 >  
                    translate < 1.0412, 13, 0 > }                 //14  
       object { One scale < 0.3222, 1, 0.3222 > rotate 5*z 
                    translate < 1.0412, 14, 0 > }                 //15 

                     }
#declare Mlim =
        union {
               object { Nlim }
               object { Nlim scale < 0.3, 0.2, 0.3 >  rotate -32*x
                        translate < 0.954, 15, 0 > }
               object { Nlim scale < 0.25, 0.3, 0.25 > rotate 20*x
                        translate < 0.954, 15, 0 > } 
              }

#declare Ntree =
        union {
              object { Mlim rotate 7*z }
              object { Mlim scale 1.15 rotate < 0, -30, -10  > 
                        translate 0.5*x }
              object { Mlim scale 0.5 rotate < 0, 180, -45 >
                       translate < 1.55, 4.8, 0.1 > }
              object { Mlim scale 0.5 rotate < 0, 180, 15 >
                       translate < -0.7, 7, 0 > }
              object { Mlim scale 0.5 rotate < 30, 0, 5 >
                       translate < 2.4, 10, 0.2 > }
              object { Mlim scale 0.5 rotate < -30, 0, 5 >
                       translate < 2, 7.5, 0.15 > }
              object { Mlim scale 0.3 rotate < -30, 0, 5 >
                       translate < -0.5, 12, 0.1 > }  
              }
object { Ntree  scale 0.3 translate < 4.8, 0, 4 > }

//SPARKS
#declare Cindr =
            disc { < 0, 0, 0 >,< 0, 0, 1 >,0.1
                   clipped_by {
                             cylinder { < 0, 0, -1 >,< 0, 0, 1 >,0.1 
                                       translate < 0.15, 0, 0 >
                                      }
                              }
                  scale 0.3
                  pigment { color Yellow }
                  finish { ambient 1 
                           diffuse 0 }
                  }
#declare Sparks =
          union {
object { Cindr translate < -0.5, 1, -0.1 > }
object { Cindr translate < -0.71, 1.2, -0.1 > } 
object { Cindr translate < -0.81, 1.8, -0.1 > } 
object { Cindr rotate 75*z translate < -1, 2.14, -0.1 > } 
object { Cindr rotate -60*z translate < -1.2, 2.8, -0.1 > }
object { Cindr translate < -1.3, 3.22, -0.1 > } 
object { Cindr translate < -1.5, 3.5, -0.1 > } 
object { Cindr rotate 95*z translate < -1.9, 3.8, -0.1 > } 
object { Cindr rotate 75*z translate < -1.3, 2.4, -0.1 > } 
object { Cindr rotate -60*z translate < -1.6, 2.8, -0.1 > }
object { Cindr translate < -1.3, 2.75, -0.1 > } 
object { Cindr translate < -1.8, 3.5, -0.1 > } 
object { Cindr rotate 95*z translate < -1.9, 3.6, -0.1 > } 
              }

object { Sparks }
object { Sparks translate < 1.5, 1.2, 0 > } 
object { Sparks scale < 1.1, 0.8, 1 > translate < -0.5, 1.5, 0 > }
object { Sparks scale < 1.5, 0.5, 1 > translate < -1.5, 3, 0 > }
object { Sparks scale < 1.5, 0.75, 1 > translate < 1.5, 1.3, 0 > }  
object { Sparks scale < 1.5, 0.75, 1 > rotate 30*z
                translate < 4.5, 1.3, 0 > }  

#declare Bark =
             torus { 0.8, 0.1
                     clipped_by {
                                cylinder { < 0, -1, 0 >,< 0, 1, 0 >,0.2
                                         translate 1*x
                                         }
                                }
                     translate < -1, 0.05, 0 >
                     pigment { color rgb < 0.8, 0.6, 0.6 > } 
                     finish { ambient 0.2 }
                     }
object { Bark scale < 0.2, 0.15, 0.8 > translate < -1.3, 0, -11 > }
object { Bark scale < 0.1, 0.17, 0.6 > rotate 60*y translate < -1.4, 0, -11.5 > }
object { Bark scale < 0.2, 0.12, 1 > rotate -45*y translate < -1.1, 0, -12 > }
object { Bark scale < 0.2, 0.1, 0.8 > rotate 15*y translate < -1, 0, -11.5 > }
object { Bark scale < 0.2, 0.05, 1 > rotate -45*y translate < -1.23, 0, -12 > }
object { Bark scale < 0.2, 0.1, 0.8 > rotate 15*y translate < -0.5, 0, -13 > }

//GOANNA
#declare Skin =
         texture {
                  pigment { 
                           bozo
                           color_map {
                                     [ 0.0 color rgb < 0.4, 0.5, 0.2 > ]
                                     [ 0.25 color rgb < 0.6, 0.6, 0.2 > ]
                                     [ 0.5 color rgb < 0.4, 0.4, 0.1 > ]
                                     [ 0.75 color rgb < 0.6, 0.6, 0.2 > ]
                                     [ 0.9 color rgb < 0.4, 0.4, 0.1 > ]
                                     [ 1.0 color rgb < 0.6, 0.6, 0.2 > ]
                                      }
                             scale 0.05
                            }
                   normal { bumps 0.5 scale 0.005 }
                   finish { ambient 0.45 }
                  } 
#declare Mus =
           sphere { < 0, 0, 0 >,0.05
                   texture { Skin }
                  }
#declare Claw =
           union {
                  object { Mus scale < 0.85, 0.18, 0.18 > 
                            rotate 30*y
                            translate 0.015*z
                         }
                  object { Mus scale < 0.85, 0.18, 0.18 > 
                            rotate 10*y
                            translate 0.007*z
                         }
                  object { Mus scale < 0.85, 0.18, 0.18 > 
                            rotate -10*y
                            translate -0.007*z
                         }
                  object { Mus scale < 0.85, 0.18, 0.18 > 
                            rotate -30*y
                            translate -0.015*z
                         }
                   }



#declare Goanna =
            union {
                  sphere { < 0, 0, 0 >,0.15  scale < 1.3, 0.5, 1 > 
                            translate 0.05*x }
                  cone { < 0, 0, 0 >,0.15,< -0.25, 0, 0 >,0.05 
                        scale < 1, 0.5, 1 > }           
                  cone { < -0.2, 0, 0 >,0.05,< -0.5, 0.08, 0 >,0.035 
                        scale < 1, 0.5, 1 > }             
                  union {
                        sphere { < 0, 0, 0 >,0.04 }
                        sphere { < -0.08, 0, 0 >,0.02 }  
                        cone { < 0, 0, 0 >,0.04,< -0.08, 0, 0 >,0.02 }
                           scale < 1.5, 0.65, 1 >
                           translate < -0.5, 0.05, 0 >
                        }
                  union {
          cone { < 0, 0, 0 >,0.065,< 0.32, -0.02, 0 >,0.06 }
          cone { < 0.3, -0.02, 0 >,0.06,< 0.4, -0.03, -0.025 >,0.05 }
          cone { < 0.4, -0.03, -0.025 >,0.05,< 0.5, -0.04, -0.06 >,0.045 }
          cone { < 0.5, -0.04, -0.06 >,0.045,< 0.6, -0.05, -0.14 >,0.04 }
          cone { < 0.6, -0.05, -0.14 >,0.04,< 0.65, -0.05, -0.2 >,0.035 }
          cone { < 0.65, -0.05, -0.2 >,0.035,< 0.682, -0.05, -0.25 >,0.03 }
          cone { < 0.682, -0.05, -0.25 >,0.03,< 0.71, -0.05, -0.3 >,0.025 } 
          cone { < 0.71, -0.05, -0.3 >,0.025,< 0.73, -0.05, -0.35 >,0.02 }
          cone { < 0.73, -0.05, -0.35 >,0.02,< 0.75, -0.05, -0.4 >,0.015 }
          cone { < 0.75, -0.05, -0.4 >,0.015,< 0.77, -0.05, -0.5 >,0.0 }
                        }
              object { Mus scale < 3, 0.7, 0.65 >         // l hind  up
                      rotate < 0, -50, -27 >
                      translate < 0.2, 0, -0.1 >
                      }
              object { Mus scale < 3, 0.7, 0.65 >          // r hind  up
                      rotate 50*y
                      translate < 0.2, -0.02, 0.1 >
                      }
              object { Mus scale < 1.8, 0.6, 0.6 >          // l hind  low
                      rotate < 0, -10,  43 >
                      translate < 0.075, -0.02, -0.22 >
                      }
              object { Mus scale < 2, 0.6, 0.65 >           // r hind   low
                      rotate < 0, 10, 25 >
                      translate < 0.06, -0.035, 0.2 >
                      }
              object { Mus scale < 0.6, 0.6, 1.5 >          // l fore up
                      rotate < -30, -30, 0 >
                      translate < -0.13, -0.01, -0.1 >
                      }
              object { Mus scale < 0.6, 0.6, 1.5 >          // r fore up
                      rotate -30*y
                      translate < -0.2, -0.02, 0.08 >
                      }
              object { Mus scale < 1.4, 0.5, 0.5 >         // l fore low
                      rotate < 0, -10, 15 >
                      translate < -0.15, -0.05, -0.16 >
                      }
              object { Mus scale < 1.4, 0.5, 0.5 >         // r fore low
                      rotate < 0, 10, 15 >
                      translate < -0.28, -0.05, 0.16 >
                      }
              object { Claw translate < -0.22, -0.07, -0.16 > }
              object { Claw translate < 0, -0.07, -0.23 > } 
              object { Claw translate < -0.35, -0.07, 0.16 > }
              object { Claw translate < 0, -0.07, 0.23 > } 
                 texture { Skin }
                 }
object { Goanna scale 0.4 rotate < -80, 2, -85 > 
           translate <  1.7, 0.8, -6.15 > }
//BIRD
#declare Split =
             box { < -0.1, -0.1, -0.1 >,< 0.1, 0.1, 0.1 >
                    rotate 45*y
                    scale < 1, 1, 0.15 >
                    translate -0.18*x
                    pigment { color Gray75 }
                  }

#declare Spred =
             union {
               object { Split }
               object { Split rotate -20*y }
               object { Split rotate -40*y }
               object { Split rotate -60*y }
               object { Split rotate -80*y }
               object { Split rotate -100*y }
                   }
#declare Outer =
             difference {
                   cylinder { < 0, -0.001, 0 >,< 0, 0.001, 0 >,0.1 }
                   object { Spred }
                        pigment { color Gray75 }
                        finish { ambient 0.2 }
                         }
#declare Kite =
        union {
              disc { < 0, 0, 0 >,< 0, 1, 0 >,0.08        //inner wing  l
                      scale < 0.65, 1, 1 >
                      rotate -35*y
                      translate < -0.075, 0, 0.025 >
                   }
              
              object { Outer rotate 90*y                 //outer wing  l   
                      scale < 0.5, 1, 1 >
                      rotate -120*y
                      translate < -0.175, 0, 0.025 >
                          }
              
              disc { < 0, 0, 0 >,< 0, 1, 0 >,0.08        //inner wing  r
                      scale < 0.65, 1, 1 >
                      rotate 35*y
                      translate < 0.075, 0, 0.025 >
                   }
              object { Outer  rotate 180*y                           //outer wing  r
                      scale < 0.5, 1, 1 >
                      rotate 120*y
                      translate < 0.175, 0, 0.025 >
                   }

              disc { < 0, 0, 0 >,< 0, 1, 0 >,0.07          //tail
                      scale < 0.25, 1, 1 > 
                      translate < 0, 0, -0.1 >
                   }
              sphere { < 0, 0, 0 >,0.07               //body
                        scale < 0.4, 0.4, 1 >  
                     }
              sphere { < 0, 0, 0 >,0.04                //head
                        scale < 0.3, 0.3, 1 >
                        translate 0.065*z
                     }
                    pigment { color Gray75 }
                    finish { ambient 0.2 }
               }
#declare Bird = object { Kite rotate < -90, 0, 100 > }

object { Bird translate < -1.2, 3.5, -4.5 > }
object { Bird rotate < 20, 0, -10 > translate < -0.7, 4, -4 > } 



