
// Glenn's POV-Ray Object File - Distant Buildings
// This file does not render.  #include "DistantBuildings.inc" in another .pov file
// created 18-Mar-98  updated 22-Aug-98
// copyright 1998 Glenn McCarter

// A collection of various landscape elements
//
// Objects:
// Bldg1(dummy)
// Bldg2(dummy)
// Bldg3(dummy)
// DistantBuildings(XDistance,YDistance,Quantity)
//
// Intended scale is English system (inches)
// For POV-Ray version 3.1+


//===============================================
//             Textures
//===============================================

#declare BrownRock =
	texture {
		pigment {
			granite
			color_map {
				[0.0 color rgb<.45,.32,.08> ]
				[0.0 color rgb<.54,.42,.12> ]
				[0.0 color rgb<.50,.48,.16> ]
			}
		}
		normal { bumps .5 scale 3 }
		finish { ambient .1 specular .4 roughness .08 }
	}
#declare LtGreyRock =
	texture {
		pigment {
			granite
			color_map {
				[0.0 color rgb<.75,.85,.68> ]
				[0.0 color rgb<.84,.72,.82> ]
				[0.0 color rgb<.70,.68,.76> ]
			}
		}
		normal { bumps .5 scale 20 }
		finish { ambient .1 specular .6 roughness .02 }
	}


//===============================================
//             Objects
//===============================================

#macro DBldg1(dummy)
	#local DS = seed(2135);
	box {
		<0,0,0>,<60*Feet,50*Feet,22*Feet>
		scale <1,1,rand(DS)*9>
		texture { BrownRock }
	}
#end
#macro DBldg2(dummy)
	#local DS = seed(5132);
	box {
		<0,0,0>,<160*Feet,90*Feet,17*Feet>
		scale <1,1,rand(DS)*18>
		texture { LtGreyRock }
	}
#end
#macro DBldg3(dummy)
	#local DS = seed(3215);
	#local ScaleFactor = rand(DS)*20;
	box {
		<0,0,0>,<50*Feet,70*Feet,33*Feet>
		scale <ScaleFactor*.3,ScaleFactor*.3,ScaleFactor>
		texture { WhitePaint }
	}
#end
#declare TallPole =
	cone {
		<0,0,0>,21,<0,0,60*Feet>,14
		texture { WhitePaint }
	}
#declare Tower =
	union {
		cone {
			<0,0,0>,18*Feet,<0,0,360*Feet>,3*Feet
		}
		cylinder {
			<0,0,0>,<0,0,11*Feet>,33*Feet
			translate <0,0,240*Feet>
		}
		cylinder {
			<0,0,0>,<0,0,11*Feet>,33*Feet
			translate <0,0,255*Feet>
		}
		texture { WhitePaint }
	}

#declare SmokeStack =
	cone {
		<0,0,0>,8*Feet,<0,0,120*Feet>,5*Feet
		texture { BrownRock }
	}

#declare Fence =
	box {
		<0,-2,0>,<300*Feet,2,6*Feet>
		texture { LtGreyRock }
	}

#macro DistantBuildings(XDist,YDist,Quantity)
	#local BCount = 1;
	#local RS = seed(256983);
	union {
		#while ( BCount < Quantity )
			#declare Choice = int(rand(RS)*4);
//#debug concat("Choice = ",str(Choice,2,2),"  ")
			#switch ( Choice )
			#case ( 0 )
				object { DBldg1(1) rotate z*rand(RS)*360 translate <rand(RS)*XDist,rand(RS)*YDist,0> }
			#break
			#case ( 1 )
				object { DBldg2(1) rotate z*rand(RS)*360 translate <rand(RS)*XDist,rand(RS)*YDist,0> }
			#break
			#case ( 2 )
				object { DBldg3(1) rotate z*rand(RS)*360 translate <rand(RS)*XDist,rand(RS)*YDist,0> }
			#break
			#case ( 3 )
				object { TallPole translate <rand(RS)*XDist,rand(RS)*YDist,0> }
			#break
			#end
				#local BCount = BCount + 1;
		#end
	}
#end
