
// Glenn's POV-Ray Object File - Eiffel Tower
// created 29-Jul-98
// last update 30-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Eiffel.inc" in another .pov file
//
// Objects:
//
// ScaleBox - Just four boxes, the size of the tower, good for positioning
// SEiffelTower - simple version (requires "EiffelHF1.png")
// EiffelTower - the real thing
// FallingEiffelTower - center section is crumbling
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// For POV-Ray version 3.1+


//================================================================
//      Remove this section -- only used for test renders!
//================================================================
/*
#include "GIncludeRH.inc"
#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
  location <-5, 1, 70*Feet>
  look_at <500*Feet, 1, 180*Feet>
  }
camera {
    Special_Cam
  }
#declare Sun =
  light_source {
    <0,0,0>
	color rgb <1, 1, .85> * 2
	fade_distance 8*Miles
	fade_power 1
  }
#object { Sun translate <-12*Miles, -8*Miles, 4*Miles > }
background { color rgb <0.2, 0.4, 0.8> } // light blue

fog {
	fog_type 1 // general fog adds distance
		distance 2400*Feet
		color rgbt<.800,.800,.998,.366> // transmittance (lower trans dulls out sky)
		turbulence .001
	}

object {GroundPlaneWhite translate z*-0}
*/

//===============================================
//             Variables
//===============================================

#declare ShearXYn05 =
	transform {
  	matrix <  1,  0, 0, // shear along X and Y axis
             0,  1, 0,
            .5, .5, 1,
             0,  0, 0 >
	}
#declare ShearXn05 =
	transform {
  	matrix <  1,  0, 0, // shear along X axis
             0,  1, 0,
            .5,  0, 1,
             0,  0, 0 >
	}

#declare ShearXYn007 =
	transform {
  	matrix <  1,   0,  0, // shear along X and Y axis
             0,   1,  0,
            .07, .07, 1,
             0,   0,  0 >
	}

#declare ShearXYn010 =
	transform {
  	matrix <  1,   0,  0, // shear along X and Y axis
             0,   1,  0,
            .10, .10, 1,
             0,   0,  0 >
	}

#declare ShearXYn025 =
	transform {
  	matrix <  1,  0, 0, // shear along X and Y axis
             0,  1, 0,
            .25, .25, 1,
             0,  0, 0 >
	}

#declare ShearXn025 =
	transform {
  	matrix <  1,  0, 0, // shear along X axis
             0,  1, 0,
            .25,  0, 1,
             0,  0, 0 >
	}

//===============================================
//             Textures
//===============================================

#declare EiffelTex =
	texture {
		pigment { color rgb<.83,.71,.57>*.7 }
		finish { ambient .08 specular .5 roughness .005 }
	}

#declare GirderTex = // this is a layered texture
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.0 rgb<.83,.71,.57>*.7 ]
				[ 0.135 rgb<.83,.71,.57>*.7 ]
				[ 0.135 rgbt<1,1,1,1> ]
			}
			translate <0,9999,0> // eliminate the Y-symmetry
			scale 24
		}
		finish { ambient .08 specular .5 roughness .005 }
	}
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 rgb<.83,.71,.57>*.7 ]
				[ 0.28 rgb<.83,.71,.57>*.7 ]
				[ 0.28 rgbt<1,1,1,1> ]
			}
			translate <0,0,9999> // eliminate the Z-symmetry
			scale 18
		}
		finish { ambient .08 specular .5 roughness .005 }
	}

#declare SmallGirderTex = // this is a layered texture
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.0 rgb<.83,.71,.57>*.7 ]
				[ 0.135 rgb<.83,.71,.57>*.7 ]
				[ 0.135 rgbt<1,1,1,1> ]
			}
			translate <0,9999,0> // eliminate the Y-symmetry
			scale 12
		}
		finish { ambient .08 specular .5 roughness .005 }
	}
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 rgb<.83,.71,.57>*.7 ]
				[ 0.28 rgb<.83,.71,.57>*.7 ]
				[ 0.28 rgbt<1,1,1,1> ]
			}
			translate <0,0,9999> // eliminate the Z-symmetry
			scale 10
		}
		finish { ambient .08 specular .5 roughness .005 }
	}

#declare ConcreteTex =
	texture {
		pigment { color rgb<.83,.81,.77>*.6 }
		finish { ambient .12 specular .2 roughness .08 }
	}

//===============================================
//             Objects
//===============================================

//------------- ScaleBox ---------------
// NOTE: use the following simple structure to test the overall
// size and proportions of the tower:
#declare ScaleBox =
	union {
		box { <-180*Feet,-180*Feet,0>,<180*Feet,180*Feet,20*Feet> } // foot
		box { <-110*Feet,-110*Feet,0>,<110*Feet,110*Feet,170*Feet> } // base
		box { <-60*Feet,-60*Feet,0>,<60*Feet,60*Feet,180*Feet> translate <0,0,170*Feet> } // mid
		box { <-25*Feet,-25*Feet,0>,<25*Feet,25*Feet,480*Feet> translate <0,0,350*Feet> } // top
		texture { EiffelTex }
	}


//------------- SEiffel ---------------
#declare SEiffelFront =
	height_field {
		png "EiffelHF1.png" // along XZ axis
		water_level 0.1
		scale <1,.02,1>
		texture { BlackPaint }
	}
#declare SEiffelTower = // simple version
	union {
		object { SEiffelFront rotate x*-12 }
		object { SEiffelFront rotate x*12 translate <0,.4,0> }
//		object { EiffelFront rotate x*-12 rotate z*90 translate <0.7,0,0> }
//		object { EiffelFront rotate x*12 rotate z*90 translate <.3,0,0> }
// Yes, it is only two-sided!
	}


//------------- EiffelTower ---------------
#declare BasePole = box { <0,0,0>,<48,48,170*Feet> translate <-24,-24,0> }
#declare BaseElevator = box { <0,0,0>,<12*Feet,12*Feet,170*Feet> translate <-6*Feet,-6*Feet,0> }
#declare BaseFoot = box { <0,0,0>,<70*Feet,70*Feet,20*Feet> texture { ConcreteTex } }

#macro XBrace(YLength,Height)
	box { <-Height/2,-YLength/2,-Height/2>,<Height/2,YLength/2,Height/2> }
#end

#macro XGroup(Width,StrutHeight)
	union {
		object { XBrace(Width,StrutHeight) texture { GirderTex } }
		object { XBrace(Width*1.414,StrutHeight) texture { GirderTex } rotate < 45,0,0> translate <0,0,Width/2> }
		object { XBrace(Width*1.414,StrutHeight) texture { GirderTex } rotate <-45,0,0> translate <0,0,Width/2> }
	}
#end

#declare BotXGroup = // main support X-braces
	union {
		object { XBrace(50*Feet,6*Feet) texture { GirderTex } }
		object { XBrace(50*Feet,3*Feet) texture { GirderTex } translate <0,0,25*Feet> }
		object { XBrace(68*Feet,6*Feet) texture { GirderTex } rotate < 40,0,0> translate <0,0,25*Feet> }
		object { XBrace(68*Feet,6*Feet) texture { GirderTex } rotate <-40,0,0> translate <0,0,25*Feet> }
	}
#declare ArchGroup =
	difference {
	union {
		difference { // arch base
			cylinder { <0,0,0>,<8*Feet,0,0>,124*Feet }
			cylinder { <-1,0,0>,<9*Feet,0,0>,120*Feet }
		} // end difference
		difference { // arch top
			cylinder { <0,0,0>,<8*Feet,0,0>,134*Feet }
			cylinder { <-1,0,0>,<9*Feet,0,0>,130*Feet }
		} // end difference
		difference { // arch main grille
			cylinder { <1*Feet,0,0>,<7*Feet,0,0>,134*Feet }
			cylinder { <-1,0,0>,<9*Feet,0,0>,120*Feet }
			#local Degr = 0;
			#while ( Degr < 80 )
				box {
					<-1,-4.4*Feet,100*Feet>,<9*Feet,4.4*Feet,134*Feet>
					texture { GirderTex }
					rotate <-40+Degr,0,0>
				}
				#local Degr = Degr + 6;
			#end
		} // end difference
		box { // corner top
			<0,-90*Feet,132*Feet>,<8*Feet,90*Feet,136*Feet>
		}

		difference { // corners
			box { <1*Feet,-90*Feet,0>,<7*Feet,90*Feet,136*Feet> }
			cylinder { <-1,0,0>,<9*Feet,0,0>,134*Feet }
			#local Degr = 0;
			#while ( Degr < 80 )
				box {
//					<-1,-4.4*Feet,100*Feet>,<9*Feet,4.4*Feet,134*Feet>
					<-100,-5.4*Feet,10*Feet>,<19*Feet,5.4*Feet,144*Feet>
//					<-100,-14.4*Feet,10*Feet>,<19*Feet,14.4*Feet,144*Feet>
					rotate <-40+Degr,0,0>
				}
				#local Degr = Degr + 6;
			#end
		} // end difference

	} // end union
	box { // clip off side
		<-40*Feet,-40*Feet,0>,<40*Feet,40*Feet,200*Feet>
		transform ShearXn05 rotate <0,0,90> translate <0,-180*Feet,0>
	}
	box { // clip off side
		<-40*Feet,-40*Feet,0>,<40*Feet,40*Feet,200*Feet>
		transform ShearXn05 rotate <0,0,270> translate <0,180*Feet,0>
	}
	box { // clip off bottom
		<-40*Feet,-140*Feet,-200*Feet>,<40*Feet,140*Feet,0>
	}
	} // end difference
#declare DoubleXStrut =
	union {
		#local YCount = 0;
		#while (YCount < 17 )
			object { XBrace(18*Feet,2*Feet) texture { SmallGirderTex } rotate < 45,0,0> translate <0,YCount*12*Feet,6*Feet> }
			object { XBrace(18*Feet,2*Feet) texture { SmallGirderTex } rotate <-45,0,0> translate <0,YCount*12*Feet,6*Feet> }
			object { XBrace(18*Feet,2*Feet) texture { SmallGirderTex } rotate < 45,0,0> translate <0,YCount*12*Feet,16*Feet> }
			object { XBrace(18*Feet,2*Feet) texture { SmallGirderTex } rotate <-45,0,0> translate <0,YCount*12*Feet,16*Feet> }
			object { XBrace(28*Feet,2*Feet) texture { SmallGirderTex } rotate <90,0,0> translate <0,YCount*12*Feet-6*Feet,14*Feet> }
			#local YCount = YCount + 1;
		#end
			object { XBrace(28*Feet,4*Feet) rotate <90,0,0> translate <0,YCount*12*Feet+6*Feet,14*Feet> } // end cap
		translate <0,-(YCount/2)*12*Feet,0> // center it
	}
#declare TinyXGroup =
	union {
		object { XBrace(50*Feet,4*Feet) }
		object { XBrace(50*Feet,4*Feet) translate <0,0,-12*Feet> }
	}
#declare BaseGroup =
	union {
		object { BaseFoot translate <-15*Feet,-15*Feet,0> }
		object { BaseElevator translate <25*Feet,25*Feet,0> }
		object { BasePole }
		object { BasePole translate <50*Feet,0,0> }
		object { BasePole translate <50*Feet,50*Feet,0> }
		object { BasePole translate <0,50*Feet,0> }
		object { BotXGroup translate <0,25*Feet,20*Feet> }
		object { BotXGroup translate <0,25*Feet,56*Feet> }
		object { BotXGroup translate <0,25*Feet,92*Feet> }
		object { BotXGroup translate <50*Feet,25*Feet,20*Feet> }
		object { BotXGroup translate <50*Feet,25*Feet,56*Feet> }
		object { BotXGroup translate <50*Feet,25*Feet,92*Feet> }
		object { BotXGroup rotate <0,0,90> translate <25*Feet,0,20*Feet> }
		object { BotXGroup rotate <0,0,90> translate <25*Feet,0,56*Feet> }
		object { BotXGroup rotate <0,0,90> translate <25*Feet,0,92*Feet> }
		object { BotXGroup rotate <0,0,90> translate <25*Feet,50*Feet,20*Feet> }
		object { BotXGroup rotate <0,0,90> translate <25*Feet,50*Feet,56*Feet> }
		object { BotXGroup rotate <0,0,90> translate <25*Feet,50*Feet,92*Feet> }
		object { TinyXGroup translate <-4,25*Feet,132*Feet> }
		object { TinyXGroup rotate <0,0,90> translate <25*Feet,-4,132*Feet> }
	}
#declare RoofSupportGroup =
	union {
		#local SCount = 0;
		#while ( SCount < 220/10 )
			box { <0,0,0>,<10,10,21*Feet> translate <5,SCount*10*Feet,0> }
			#local SCount = SCount + 1;
		#end
	}
#declare RGlass =
	box {
		<6,0,0>,<7,220*Feet,21*Feet>
		texture { pigment { color rgbt<1,1,1,.85> } }
	}
#declare TGroup = // support triangles
	union  {
		#local TCount = 0;
		#while ( TCount < 220/12 )
			box {
				<0,0,0>,<8*Feet,16,18*Feet>
				rotate <0,-25,0>
				translate <5,TCount*12*Feet,0>
			}
			#local TCount = TCount + 1;
		#end
	}
#declare BigPlatform =
	union {
		box { <-110*Feet,-110*Feet,0>,<110*Feet,110*Feet,7*Feet> } // main
		difference {
			box { <-110*Feet,-110*Feet,0>,<110*Feet,110*Feet,4*Feet> translate <0,0,20*Feet> } // roof
			box { <-85*Feet,-85*Feet,-1>,<85*Feet,85*Feet,6*Feet> translate <0,0,20*Feet> } // cutout
		}
		object { RoofSupportGroup translate <-110*Feet,-110*Feet,0> }
		object { RoofSupportGroup rotate z*90 translate <110*Feet,-110*Feet,0> }
		object { RoofSupportGroup rotate z*180 translate <110*Feet,110*Feet,0> }
		object { RoofSupportGroup rotate z*270 translate <-110*Feet,-110*Feet,0> }
		object { RGlass translate <-110*Feet,-110*Feet,0> }
		object { RGlass rotate z*90 translate <110*Feet,-110*Feet,0> }
		object { RGlass rotate z*180 translate <110*Feet,110*Feet,0> }
		object { RGlass rotate z*270 translate <-110*Feet,-110*Feet,0> }
		box { <-90*Feet,-90*Feet,0>,<90*Feet,90*Feet,16*Feet> translate <0,0,-16*Feet> } // underside
		object { TGroup translate <-100*Feet,-100*Feet,-16*Feet> }
		object { TGroup rotate z*90 translate <100*Feet,-100*Feet,-16*Feet> }
		object { TGroup rotate z*180 translate <100*Feet,100*Feet,-16*Feet> }
		object { TGroup rotate z*270 translate <-100*Feet,-100*Feet,-16*Feet> }
	}
#declare BottomThird =
	union {
		object { BigPlatform translate <0,0,170*Feet> }
		object { BaseGroup transform ShearXYn05 translate <-180*Feet,-180*Feet,0> }
		object { BaseGroup transform ShearXYn05 rotate <0,0,90> translate <180*Feet,-180*Feet,0> }
		object { BaseGroup transform ShearXYn05 rotate <0,0,180> translate <180*Feet,180*Feet,0> }
		object { BaseGroup transform ShearXYn05 rotate <0,0,270> translate <-180*Feet,180*Feet,0> }
		object { ArchGroup translate <-180*Feet,0,0*Feet> transform ShearXn05 rotate <0,0,0> }
		object { ArchGroup translate <-180*Feet,0,0*Feet> transform ShearXn05 rotate <0,0,90> }
		object { ArchGroup translate <-180*Feet,0,0*Feet> transform ShearXn05 rotate <0,0,180> }
		object { ArchGroup translate <-180*Feet,0,0*Feet> transform ShearXn05 rotate <0,0,270> }
		object { DoubleXStrut translate <-180*Feet,0,136*Feet> transform ShearXn05 rotate <0,0,0> }
		object { DoubleXStrut translate <-180*Feet,0,136*Feet> transform ShearXn05 rotate <0,0,90> }
		object { DoubleXStrut translate <-180*Feet,0,136*Feet> transform ShearXn05 rotate <0,0,180> }
		object { DoubleXStrut translate <-180*Feet,0,136*Feet> transform ShearXn05 rotate <0,0,270> }
	}

#declare MidPole = box { <0,0,0>,<36,36,170*Feet> translate <-18,-18,0> }
#declare MidElevator = box { <0,0,0>,<8*Feet,8*Feet,180*Feet> translate <-4*Feet,-4*Feet,0> }
#declare MidXGroup = // main support X-braces
	union {
		object { XBrace(34*Feet,6*Feet) texture { GirderTex } }
		object { XBrace(42*Feet,6*Feet) texture { GirderTex } rotate < 40,0,0> translate <0,0,15*Feet> }
		object { XBrace(42*Feet,6*Feet) texture { GirderTex } rotate <-40,0,0> translate <0,0,15*Feet> }
	}
#declare Mid6XGroup = // under platform 6 X-braces
	union {
		object { XBrace(30*Feet,4*Feet) texture { SmallGirderTex } rotate < 60,0,0> }
		object { XBrace(30*Feet,4*Feet) texture { SmallGirderTex } rotate <-60,0,0> }
	}
#declare UnderStrut = // fine-grained horizontal support under mid platform
	union {
		box { <-12,-60*Feet,-12>,<12,60*Feet,12> }
		box { <-12,-60*Feet,-12>,<12,60*Feet,12> translate <0,0,12*Feet> }
		texture { GirderTex }
	}
#declare MidGroup =
	union {
		object { MidElevator translate <35/2*Feet,35/2*Feet,0> }
		object { MidPole }
		object { MidPole translate <35*Feet,0,0> }
		object { MidPole translate <35*Feet,35*Feet,0> }
		object { MidPole translate <0,35*Feet,0> }
		object { MidXGroup translate <0,17.5*Feet,0> }
		object { MidXGroup translate <0,17.5*Feet,30*Feet> }
		object { MidXGroup translate <0,17.5*Feet,60*Feet> }
		object { MidXGroup translate <0,17.5*Feet,90*Feet> }
		object { Mid6XGroup translate <0,12*Feet,140*Feet> }
		object { Mid6XGroup translate <0,24*Feet,140*Feet> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,0,0> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,0,30*Feet> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,0,60*Feet> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,0,90*Feet> }
		object { Mid6XGroup rotate <0,0,90> translate <12*Feet,0,140*Feet> }
		object { Mid6XGroup rotate <0,0,90> translate <24*Feet,0,140*Feet> }
		object { MidXGroup translate <35*Feet,17.5*Feet,0> }
		object { MidXGroup translate <35*Feet,17.5*Feet,30*Feet> }
		object { MidXGroup translate <35*Feet,17.5*Feet,60*Feet> }
		object { MidXGroup translate <35*Feet,17.5*Feet,90*Feet> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,35*Feet,0> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,35*Feet,30*Feet> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,35*Feet,60*Feet> }
		object { MidXGroup rotate <0,0,90> translate <17.5*Feet,35*Feet,90*Feet> }
	}
#declare MidStation =
	union {
		box { <-60*Feet,-60*Feet,0>,<60*Feet,60*Feet,6*Feet> translate <0,0,0> } // main
		box { <-35*Feet,-35*Feet,0>,<35*Feet,35*Feet,25*Feet> translate <0,0,6*Feet> } // restaurant
		box { <-50*Feet,-50*Feet,0>,<50*Feet,50*Feet,12*Feet> translate <0,0,-12*Feet> } // lower
	}
#declare MidSection =
	union {
		object { MidStation translate <0,0,180*Feet> }
		object { MidGroup transform ShearXYn025 translate <-90*Feet,-90*Feet,0> }
		object { MidGroup transform ShearXYn025 rotate <0,0,90> translate <90*Feet,-90*Feet,0> }
		object { MidGroup transform ShearXYn025 rotate <0,0,180> translate <90*Feet,90*Feet,0> }
		object { MidGroup transform ShearXYn025 rotate <0,0,270> translate <-90*Feet,90*Feet,0> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,0> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,0> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,90> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,90> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,180> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,180> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,270> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,270> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,0> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,90> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,180> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,270> }
	}
#macro UpperStrut(Height,Width)
	box { <-Width/2,-Width/2,0>,<Width/2,Width/2,Height> }
#end
#local AvgX = 200/7*Feet; // size of the Xbrace in lower tower
#declare LowTowerStraightFace =
	union {
		object { UpperStrut(200*Feet,28)  } // corner strut
		object { UpperStrut(200*Feet,28) translate <AvgX,0,0> } // corner strut
		object { UpperStrut(200*Feet,28) translate <0,AvgX,0> } // corner strut
		object { UpperStrut(200*Feet,28) translate <AvgX,AvgX,0> } // corner strut
		#local ZCount = 0;
		#while (ZCount < 7 )
			object { XGroup(AvgX,4*Feet) translate <0,AvgX/2,ZCount*AvgX> }
			object { XGroup(AvgX,4*Feet) rotate z*90 translate <AvgX/2,0,ZCount*AvgX> }
			#local ZCount = ZCount + 1;
		#end
	}
#declare LowTowerFace =
	object { LowTowerStraightFace
		transform ShearXYn010
		translate <-46*Feet,-46*Feet,0>
	}
#local AvgX = 230/10*Feet; // size of the Xbrace in lower tower
#declare HighTowerStraightFace =
	union {
		object { UpperStrut(230*Feet,20) } // corner strut
		#local ZCount = 0;
		#while (ZCount < 10 )
			#local YFactor = 1-((ZCount+1)*AvgX/(230*Feet)*.4); // scale from 1.0 to 0.6
			object { XGroup(AvgX,3.6*Feet) scale <1,YFactor,1> translate <0,AvgX/2*YFactor,ZCount*AvgX> }
			object { XGroup(AvgX,3.6*Feet) scale <1,YFactor,1> rotate z*90 translate <AvgX/2*YFactor,0,ZCount*AvgX> }
			#local ZCount = ZCount + 1;
		#end
	}
#declare HighTowerFace =
	object { HighTowerStraightFace
		transform ShearXYn007
		translate <-26*Feet,-26*Feet,0>
	}
#declare HighElevator =
	union {
		object { UpperStrut(430*Feet,6*Feet) rotate z*45 }
		object { UpperStrut(430*Feet,3*Feet) translate <6*Feet,0,0> rotate z*0 }
		object { UpperStrut(430*Feet,3*Feet) translate <6*Feet,0,0> rotate z*90 }
		object { UpperStrut(430*Feet,3*Feet) translate <6*Feet,0,0> rotate z*180 }
		object { UpperStrut(430*Feet,3*Feet) translate <6*Feet,0,0> rotate z*270 }
	}
#declare Tower =
	union {
		object { HighElevator }
		object { LowTowerFace }
		object { LowTowerFace rotate <0,0,90> }
		object { LowTowerFace rotate <0,0,180> }
		object { LowTowerFace rotate <0,0,270> }
		object { HighTowerFace translate <0,0,200*Feet> }
		object { HighTowerFace translate <0,0,200*Feet> rotate <0,0,90> }
		object { HighTowerFace translate <0,0,200*Feet> rotate <0,0,180> }
		object { HighTowerFace translate <0,0,200*Feet> rotate <0,0,270> }
	}
#declare Peak =
	union {
		box { <-20*Feet,-20*Feet,0>,<20*Feet,20*Feet,10*Feet> }
		box { <-14*Feet,-14*Feet,0>,<14*Feet,14*Feet,16*Feet> translate <0,0,10*Feet> }
		box { <-4*Feet,-4*Feet,0>,<4*Feet,4*Feet,40*Feet> translate <0,0,26*Feet> }
	}


//----------------- Eiffel Tower ---------------------

#declare EiffelTower =
	union {
		object { BottomThird } // 170 feet tall
		object { MidSection translate <0,0,180*Feet> } //180 feet tall
		object { Tower translate <0,0,350*Feet> } // 430 feet tall
		object { Peak translate <0,0,780*Feet> }
		texture { EiffelTex }
	}


//----------------- Falling Eiffel Tower ---------------------

#declare RandomDebris = // large beams
	union {
		#local RS = seed(674589);
		#local DCount = 0;
		#while ( DCount < 40 )
			object {
				XBrace(rand(RS)*50*Feet+8*Feet,rand(RS)*5*Feet+1*Feet)
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
				translate <rand(RS)*120*Feet-60*Feet,rand(RS)*80*Feet-40*Feet,rand(RS)*160*Feet-80*Feet>
			}
		#local DCount = DCount + 1;
		#end
		texture { EiffelTex }
	}
#declare FillDebris = // small parts
	union {
		#local RS = seed(39053);
		#local FCount = 0;
		#while ( FCount < 36 )
			object {
				XBrace(rand(RS)*26*Feet+6*Feet,rand(RS)*5*Feet+1*Feet)
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
				translate <rand(RS)*80*Feet-40*Feet,rand(RS)*60*Feet-30*Feet,rand(RS)*80*Feet-40*Feet>
			}
		#local FCount = FCount + 1;
		#end
		texture { GirderTex }
	}
#declare SubtractDebris =
	union {
//box { <-40*Feet,-35*Feet,-60*Feet>,<40*Feet,35*Feet,60*Feet> }

		#local RS = seed(30784);
		#local DCount = 0;
		#while ( DCount < 20 )
			box {
				<0,0,0>,<rand(RS)*50*Feet+25*Feet,rand(RS)*20*Feet+8*Feet,rand(RS)*120*Feet+48*Feet>
				rotate <rand(RS)*36-18,rand(RS)*20-10,rand(RS)*360>
				translate <rand(RS)*40*Feet-20*Feet,rand(RS)*40*Feet-20*Feet,rand(RS)*60*Feet-30*Feet>
			}
		#local DCount = DCount + 1;
		#end

		texture { EiffelTex }
	}
#declare FallingMidSection =
	union {
		object { MidStation rotate <-5,-8,0> translate <0,0,180*Feet> }
		object { MidGroup transform ShearXYn025 translate <-90*Feet,-90*Feet,0> }
		object { MidGroup transform ShearXYn025 rotate <0,0,90> translate <90*Feet,-90*Feet,0> }
		object { MidGroup transform ShearXYn025 rotate <0,0,180> translate <90*Feet,90*Feet,0> }
		object { MidGroup transform ShearXYn025 rotate <0,0,270> translate <-90*Feet,90*Feet,0> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,0> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,0> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,90> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,90> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,180> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,180> }
		object { Mid6XGroup translate <-90*Feet,-12*Feet,140*Feet> transform ShearXn025 rotate <0,0,270> }
		object { Mid6XGroup translate <-90*Feet, 12*Feet,140*Feet> transform ShearXn025 rotate <0,0,270> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,0> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,90> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,180> }
		object { UnderStrut translate <-90*Feet,0,130*Feet> transform ShearXn025 rotate <0,0,270> }
	}

#declare TopAssy =
	union {
		object { Tower rotate <0,0,45> } // 430 feet tall
		object { Peak translate <0,0,430*Feet> }
	}
#declare FallingEiffelTower =
	union {
		object { BottomThird } // 170 feet tall
		difference {
			object { FallingMidSection rotate <-4,0,0> translate <0,0,180*Feet> } //180 feet tall
			object { SubtractDebris translate <-60*Feet,50*Feet,350*Feet> }
		}
		difference {
			object { TopAssy rotate <12,0,35> translate <0,16*Feet,380*Feet> } // 430 feet tall
			object { SubtractDebris rotate z*180 translate <-40*Feet,40*Feet,390*Feet> }
		}
		object { RandomDebris translate <-60*Feet,30*Feet,360*Feet> }
		object { FillDebris translate <-50*Feet,40*Feet,370*Feet> }
		texture { EiffelTex }
		bounded_by { box { <-200*Feet,-200*Feet,-1>,<200*Feet,200*Feet,500*Feet> } }
	} // end union


// UNCOMMENT FOR TEST RENDERS ONLY
//object { EiffelTower scale <1,1,1> rotate <0,0,23> translate <1200*Feet,0*Feet,0*Feet> }
//object { FallingEiffelTower scale <1,1,1> rotate <0,0,0> translate <1200*Feet,0*Feet,0*Feet> }
//object { ScaleBox translate <1200*Feet,300*Feet,0> }
