
// Glenn's POV-Ray Object File - Eyeglasses
// created 10-Aug-98
// last update 21-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Eyeglasses.inc" in another .pov file
//
// Objects:
//
// Eyeglasses(LeftArmAngle,RightArmAngle) - steel frame, "aviator"-style
//
//
// Origin is at bridge of eyeglasses, arms extend into +X
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// For POV-Ray version 3.1+

// This file must be #included first: "GShapes31.inc"

//================================================================
//      Remove this section -- only used for test renders!
//================================================================
/*
#include "GIncludeRH.inc"
#include "GShapes31.inc"
#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
  location <-6, -1, 3>
  look_at <0, 0, .3>
  }
camera {
    Special_Cam
  }
#declare Sun =
  light_source {
    <0,0,0>
	color rgb <1, 1, .85> * 2
	fade_distance 48*Miles
	fade_power 1
  }
#object { Sun translate <-12*Miles, -8*Miles, 4*Miles > }
background { color rgb <0.2, 0.4, 0.8> } // light blue
//object {GroundPlaneWhite translate z*-0}
object {GroundPlaneCheck(White,Black,1.5) translate z*-0}
*/

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare OpticalGlass =
	texture {
		pigment { color rgbf<.97,.94,.92,.96> }
//		finish {  reflection .26 } // test
//		finish { phong .6 phong_size 200               } // test
		finish { phong .6 phong_size 200 reflection .13 } // render
	}

#declare GunmetalTex =
	texture {
		pigment { color rgb<.63,.51,.47>*.6 }
//		finish { ambient .12 specular .5 roughness .005                } // test
		finish { ambient .12 specular .5 roughness .005 metallic brilliance 5 reflection .35 } // render
	}

#declare ClearPlastic = // for nosepads
	texture {
//		pigment { color rgbf<.95,.94,.97,.16> }
//		pigment { color rgbf<.62,.60,.67,.76> } // too dark
		pigment { color rgbf<.72,.70,.77,.76> } // test
//		pigment { color rgb<.25,.24,.97,> }
		normal { bumps .3 scale .14 }
		finish { ambient .04 specular .14 roughness .08 }
	}


//===============================================
//             Objects
//===============================================

#macro Magnifier (Dia,Mrad,Thickness) // magnifying glass
	intersection {
		sphere {
			<0,0,0>,Mrad
			translate <0,0,Mrad-Thickness/2>
		}
		sphere {
			<0,0,0>,Mrad
			translate <0,0,-Mrad+Thickness/2>
		}
		cylinder {
			<0,0,12>,<0,0,-12>,Dia/2
		}
		texture { OpticalGlass }
	interior { ior 1.5 }
//		texture { WhitePaint }
	}
#end


	#declare Separation = 1.2; // distance between lenses
	#declare Tilt = 28; // degrees, top edge angle
	#declare D = .65; // distance between big and small diameters
	#declare R1 = .65; // big cyl rad
	#declare R2 = .38; // small cyl rad
	#local RD = R1 - R2;
	#local WireR = .035;
	#local KeyL = sqrt(D*D-RD*RD);
	#local Alpha = degrees( asin(RD/D) );

#declare FrameShape = // lies in XY plane
	union { // add together 4 parts
		difference { // cut away extra parts of torii
			union { // join the basic torii
				torus { R1,WireR rotate <90,0,0> }
				torus { R2,WireR rotate <90,0,0> translate <D,0,0> }
			} // end union
			box { // upper tangent
				<0,-RD,-WireR-.1>,<KeyL,R2,WireR+.1>
				translate <-KeyL,0,0> rotate <0,0,-Alpha> translate <D,0,0>
			}
			box { // lower tangent
				<0,RD,-WireR-.1>,<KeyL,-R2,WireR+.1>
				translate <-KeyL,0,0> rotate <0,0,Alpha> translate <D,0,0>
			}
			box { // center trim if Dist < R1
				<0,-R2,-WireR-.1>,<D+WireR,R2,WireR+.1>
			}
		} // end difference
		cylinder { // upper tangent
			<0,0,0>,<KeyL,0,0>,WireR
			translate <-KeyL,R2,0> rotate <0,0,-Alpha> translate <D,0,0>
		}
		cylinder { // lower tangent
			<0,0,0>,<KeyL,0,0>,WireR
			translate <-KeyL,-R2,0> rotate <0,0,Alpha> translate <D,0,0>
		}
	rotate <90,-Tilt,-90>
	scale <1.7,1,1>
	rotate z*-4 translate <0.1,Separation,0>
	} // end union

//#debug concat("R1=",str(R1,1,1)," R2=",str(R2,1,1)," D=",str(D,1,1)," Thickness=",str(Thickness,1,1))

#declare FrameLensCutout =
	union {
		object {
			FlatEgg(R1-WireR/2,R2-WireR/2,D,.3) // main cutout
			rotate <90,-Tilt,-90>
			translate <.15,0,0>
			rotate z*-4 translate <0.1,Separation,0>
		}
		object {
			FlatEgg(R1,R2,D,.05) // thin mounting area
			rotate <90,-Tilt,-90>
			translate <.025,0,0>
			rotate z*-4 translate <0.1,Separation,0>
		}
	}

#declare LeftFrame =
	difference {
		object { FrameShape }
		object { FrameLensCutout }
		texture { GunmetalTex }
	}


#macro Lens (Curvature,Thickness) // lies flat on XY plane
	intersection {
		sphere { // outer surf
			<0,0,0>,Curvature
			translate <0,0,Curvature-Thickness/2>
		}
		sphere { // inner surf
			<0,0,0>,Curvature
			translate <0,0,-Curvature+Thickness/2>
		}
		object { // frameshape
			FlatEgg(R1,R2,D,Thickness*2)
			translate <0,0,-Thickness>
		}
		texture { OpticalGlass }
		hollow
	interior { ior 1.5 }
//		texture { WhitePaint } // test
		rotate <90,-Tilt,-90>
		rotate z*-4 translate <0.1,Separation,0>
	}
#end

#declare Bridge =
	union {
		cylinder { // top of frame
			<0,-.64,0>,<0,.64,0>,.030
			scale <2,1,1>
			translate <.08,0,.74>
		}
		sphere { // top frame end
			<0,0,0>,.030
			scale <2,1,1>
			translate <.08,-.64,.74>
		}
		sphere { // top frame end
			<0,0,0>,.030
			scale <2,1,1>
			translate <.08,.64,.74>
		}
		cylinder { // nose bottom
			<0,-.25,0>,<0,.25,0>,.035
			scale <1,1,1>
			translate <.03,0,.30>
		}
		cylinder { // nose mid
			<0,-.25,0>,<0,.25,0>,.035
			scale <1,1,1>
			translate <.03,0,.35>
		}
		cylinder { // nose top
			<0,-.25,0>,<0,.25,0>,.035
			scale <1,1,1>
			translate <.03,0,.40>
		}
		texture { GunmetalTex }
	}

#declare NosePad =
	union {
		superellipsoid {
			<.4,.4>
			scale <.08,.04,.18,>
			translate <0.15,0,0>
			texture { ClearPlastic }
		}
		cylinder {
			<0,.15,0>,<0,.05,0>,.015
			scale <1,1,1>
			translate <0.15,0,.15>
			texture { GunmetalTex }
		}
		cylinder {
			<0,.15,0>,<0,.05,0>,.015
			scale <1,1,1>
			translate <0.15,0,.05>
			texture { GunmetalTex }
		}
		box {
			<0.06,.15+.035,.05-.035>,<.17,.15-.035,.15+.035>
			texture { GunmetalTex }
		}
		rotate <25,0,0>
		translate <0,.18,0>
	}

#declare MetalArm =
	union {
		cylinder { // top
			<0,0,0.05>,<2.5,0,0.05>,.015
		}
		box { // center
			<0,-.015,-0.05>,<2.5,.015,0.05>
		}
		cylinder { // bottom
			<0,0,-0.05>,<2.5,0,-0.05>,.015
		}
		texture { GunmetalTex }
	}
#local ER = .75; // earpiece large radius
#local ESR = .08; // earpiece small radius
#declare PlasticEarpiece = // origin at center of radius
	merge {
		cylinder { // attachment to arm
			<-.5,0,0>,<0,0,0>,ESR
			scale <1,.4,1>
			translate <0,0,ER>
		}
		difference { // cut off excess from torus
			torus {
				ER,ESR
				scale <1,.4,1>
			}
			box { <0,-.4,-2>,<2,.4,2> rotate y*38 } // cutoff at angle
			box { <-2,-.4,-2>,<0,.4,2> } // everything in front
		} // end difference
		merge { // cone and tip
			cone {
				<0,0,0>,ESR,<.85,0,0>,ESR*1.5
				scale <1,.4,1>
			}
			sphere {
				<.85,0,0>,ESR*1.5
				scale <1,.4,1>
			}
			translate <0,0,ER> // attach group to torus...
			rotate <0,38,0> // ...then rotate it
		} // end union
		texture { ClearPlastic }
	}
#declare EArm =
	union {
		object { MetalArm }
		object { PlasticEarpiece translate <2.5+0.5,0,-ER> }
	}

#declare ArmHinge =
	union {
		cylinder {
			<0,0,-0.05>,<0,0,0.1>,.06
		}
		box {
			<-.06,0,-0.05>,<.06,-.12,0.1>
		}
		rotate z*-4
		translate <0.2,1.9,0.3>
		texture { GunmetalTex }
	}


#macro Eyeglasses(LeftArmAngle,RightArmAngle)
	union {
		object { Lens(5,.2) } // curvature,thickness
		object { Lens(5,.2) transform InverseY }
		object { LeftFrame }
		object { LeftFrame transform InverseY }
		object { Bridge }
		object { NosePad }
		object { NosePad transform InverseY }
		object { ArmHinge }
		object { ArmHinge transform InverseY }
		object { EArm rotate <0,0,LeftArmAngle> translate <0.2,-1.9,.35> }
		object { EArm rotate <0,0,-RightArmAngle> translate <0.2, 1.9,.35> }
	}
#end


// UNCOMMENT FOR TEST RENDERS ONLY
//object { Eyeglasses(0,0) rotate <0,5,0> translate <0,-1,2> }
//object { Eyeglasses(30,30) rotate z*90 translate <-3,1,1.8> }
//object { Eyeglasses(20,70) rotate z*120 translate <-1.5,-1,1.0> }
