// Glenn's POV-Ray Shapes Include File
// first concept 2-June-97
// last update 19-Aug-98
// copyright 1997-1998 Glenn McCarter
// This file does not render.  #include "GShapes31.inc" in another .pov file
//
// A collection of various shapes:
//     RoundedBox(Roundedness)  unit box; centered on origin; all corners and edges rounded
//     RoundedHalfBox(Roundedness) same, but bottom is flat
//     FlatEgg(Radius1,Radius2,Distance,Height)
//        two cylinders, connected with flat sides, like two pulleys.  lies on XY plane
//
// Uses RH coordinate reference system
// For POV-Ray version 3.1+

//===============================================
//             Textures
//===============================================


//===============================================
//       Objects
//===============================================

// --------- Rounded Box --------------
// Usage: copy these lines to your .pov file:
//
// #include "GShapes31.inc"
// object { RoundedBox(.2) texture...} // roundness, range 0 to .5, larger = more rounded
//
// The default size is always 1x 1y 1z, regardless of
// the Roundness factor.

// set defaults
#ifndef ( Roundness )
#declare Roundness = .2;
#end

#declare RA = Roundness/2; // sph/cyl rads
#declare RB = .5-Roundness/2; // higher roundness = smaller sph/cyl centers

#macro RoundedBox(Roundness)
	union {
		box { <-RB,-RB,-.5>,<RB,RB,.5> }
		box { <-RB,-.5,-RB>,<RB,.5,RB> }
		box { <-.5,-RB,-RB>,<.5,RB,RB> }

		sphere { <-RB,-RB,-RB>, RA }
		sphere { < RB,-RB,-RB>, RA }
		sphere { <-RB, RB,-RB>, RA }
		sphere { <-RB,-RB, RB>, RA }

		sphere { < RB, RB,-RB>, RA }
		sphere { < RB,-RB, RB>, RA }
		sphere { <-RB, RB, RB>, RA }
		sphere { < RB, RB, RB>, RA }

		cylinder { <-RB,-RB,-RB>,<-RB,-RB, RB>,RA }
		cylinder { <-RB, RB,-RB>,<-RB, RB, RB>,RA }
		cylinder { < RB,-RB,-RB>,< RB,-RB, RB>,RA }
		cylinder { < RB, RB,-RB>,< RB, RB, RB>,RA }

		cylinder { <-RB,-RB,-RB>,<-RB, RB,-RB>,RA }
		cylinder { < RB,-RB,-RB>,< RB, RB,-RB>,RA }
		cylinder { <-RB,-RB, RB>,<-RB, RB, RB>,RA }
		cylinder { < RB,-RB, RB>,< RB, RB, RB>,RA }

		cylinder { <-RB,-RB,-RB>,< RB,-RB,-RB>,RA }
		cylinder { <-RB, RB,-RB>,< RB, RB,-RB>,RA }
		cylinder { <-RB,-RB, RB>,< RB,-RB, RB>,RA }
		cylinder { <-RB, RB, RB>,< RB, RB, RB>,RA }
	}
#end
#macro RoundedHalfBox(Roundness)
	union {
		box { <-RB,-RB,-.5>,<RB,RB,.5> }
		box { <-RB,-.5,-.5>,<RB,.5,RB> }
		box { <-.5,-RB,-.5>,<.5,RB,RB> }

//		sphere { <-RB,-RB,-RB>, RA }
//		sphere { < RB,-RB,-RB>, RA }
//		sphere { <-RB, RB,-RB>, RA }
		sphere { <-RB,-RB, RB>, RA }

//		sphere { < RB, RB,-RB>, RA }
		sphere { < RB,-RB, RB>, RA }
		sphere { <-RB, RB, RB>, RA }
		sphere { < RB, RB, RB>, RA }

		cylinder { <-RB,-RB,-.5>,<-RB,-RB, RB>,RA }
		cylinder { <-RB, RB,-.5>,<-RB, RB, RB>,RA }
		cylinder { < RB,-RB,-.5>,< RB,-RB, RB>,RA }
		cylinder { < RB, RB,-.5>,< RB, RB, RB>,RA }

//		cylinder { <-RB,-RB,-RB>,<-RB, RB,-RB>,RA }
//		cylinder { < RB,-RB,-RB>,< RB, RB,-RB>,RA }
		cylinder { <-RB,-RB, RB>,<-RB, RB, RB>,RA }
		cylinder { < RB,-RB, RB>,< RB, RB, RB>,RA }

//		cylinder { <-RB,-RB,-RB>,< RB,-RB,-RB>,RA }
//		cylinder { <-RB, RB,-RB>,< RB, RB,-RB>,RA }
		cylinder { <-RB,-RB, RB>,< RB,-RB, RB>,RA }
		cylinder { <-RB, RB, RB>,< RB, RB, RB>,RA }
	}
#end

// --------- FlatEgg --------------
/*
FlatEgg(Radius1,Radius2,Distance,Height)
Usage: copy these lines to your .pov file:

#include "GShapes31.inc"
// FlatEgg(Radius1,Radius2,Distance,Height)
object { FlatEgg(2.0,1.3,2.0,0.2) texture...}

*/
// Note, the structure sits on the XY plane,
// with the first cylinder at the origin,
// the second cylinder in the +X direction,
// and height extending into +Z

/*
// set defaults
#ifndef ( Radius1 )
#declare Radius1 = 1;
#end
#ifndef ( Radius2 )
#declare Radius2 = 1;
#end
*/

#macro FlatEgg(Radius1,Radius2,Distance,Height)
	#local D = Distance;
	#local R1 = Radius1; // cyl rad
	#local R2 = Radius2; // cyl rad
	#local RD = R1 - R2;
	#local KeyL = sqrt(D*D-RD*RD);
	#local Alpha = degrees( asin(RD/D) );
	merge {
		cylinder { <0,0,0>,<0,0,Height>,R1 }
		cylinder { <0,0,0>,<0,0,Height>,R2 translate <D,0,0> }
		difference {
			box {
				<0,-RD,0>,<KeyL,R2,Height+.2>
				translate <-KeyL,0,0> rotate <0,0,-Alpha> translate <D,0,0>
			}
			box { <-R1,-R1,-1>,<D,0,Height> }
		}
		difference {
			box {
				<0,RD,0>,<KeyL,-R2,Height>
				translate <-KeyL,0,0> rotate <0,0,Alpha> translate <D,0,0>
			}
			box { <-R1,R1,-1>,<D,0,Height+1> }
		}
	}
#end


