///////////////////////////////////////////
// camera.pov
// this section accepts the following:
//   Camera_Target   : a vector position
//   Camera_Location : a vector position
//   Camera_Angle    : degrees
//   Camera_Rotate   : degrees vector
//   Camera_Type     : 0 => perspective, 1 => orthographic
//   Light_At_Camera : the color value for a light at the camera, if non-zero

#ifndef (Camera_Inc)
  #include "camera.inc"
#end

#ifndef (Camera_Target)
  #declare Camera_Target = <0, 0, 0>;
  #render "Warning : Setting Camera_Target to default\n"
#end

#ifndef (Camera_Location)
  #declare Camera_Location = <0, 0, 0>;
  #render "Warning : Setting Camera_Location to default\n"
#end

#ifndef (Camera_Scale)
  #declare Camera_Scale = 1;
  #render "Warning : Setting Camera_Scale to default\n"
#end

camera {
  #ifndef (Camera_Type)
    #declare Camera_Type = Camera_Main;
  #end
  #switch (Camera_Type)
    #case (Camera_Front)
      orthographic
      right <1, 0, 0> * 4/3 * Camera_Scale
      up    <0, 1, 0> * Camera_Scale
      #declare Camera_Location = -100 * z + Camera_Target;
    #break
    #case (Camera_Top)
      orthographic
      right <1, 0, 0> * 4/3 * Camera_Scale
      up    <0, 1, 0> * Camera_Scale
      #declare Camera_Location = 100 * y + Camera_Target;
    #break
    #case (Camera_Right)
      orthographic
      right <1, 0, 0> * 4/3 * Camera_Scale
      up    <0, 1, 0> * Camera_Scale
      #declare Camera_Location = 100 * x + Camera_Target;
    #break
    #else
      // default to main camera
      #render "Main Camera :\n"
      perspective
      right <4/3, 0, 0>
      up <0, 1, 0>
    #break
  #end  // end switch

  #render concat("Camera_Location = <",
                  str(Camera_Location.x, 0, 3), ", ",
                  str(Camera_Location.y, 0, 3), ", ",
                  str(Camera_Location.z, 0, 3), ">\n")
  location Camera_Location - Camera_Target
  #ifdef (Camera_Angle)
    angle Camera_Angle
  #end
  look_at  <0, 0, 0>
  #ifdef (Camera_Rotate)
    rotate Camera_Rotate
  #end
  translate Camera_Target
}

#ifndef (Light_At_Camera)
  #declare Light_At_Camera = 0;
#end
#if (Light_At_Camera)
  light_source {
   Camera_Location
   color rgb Light_At_Camera
  }
#end
