

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"


camera
{
  location <-6.0, 2.0, -6.0>
  look_at <0.0, 0.0, 0.0>
}

light_source
{
  <0.0, 5.0, 0.0>
  rgb <1.0, 1.0, 1.0>
  spotlight
  point_at <0.0, 0.0, 0.0>
  radius 40.0
  tightness 1.0
  falloff 45.0
}

light_source
{
  <-6.0, -3.0, -5.0>
  rgb <1.5, 2.0, 1.5>
}

sky_sphere
{
  pigment
  {
    gradient x
    color_map
    {
      [ 0.0 color rgb <2.0, 2.0, 2.0> ]
      [ 0.01 color rgb <1.0, 1.0, 1.0> ]
      [ 0.5 color rgb <0.0, 0.0, 1.0> ]
      [ 0.9 color rgb <0.7, 0.3, 0.0> ]
      [ 0.99 color rgb <0.7, 0.0, 0.0> ]
      [ 1.0 color rgb <0.7, 0.0, 0.0> ]
    }
    turbulence 0.5
  }
}


//background { color red 0.1 green 0.3 blue 0.8 }


#declare LargeurDalle = 1.0
#declare EpaisseurDalle = 0.1
#declare Diametre1Dalle = 0.75
#declare Diametre2Dalle = 0.65
#declare ProfondeurGravureDalle = 0.01

#declare Truc = box
{
  <-LargeurDalle/2.0-0.1, -EpaisseurDalle/2.0-0.1, 0.0>
  <LargeurDalle/2.0+0.1, EpaisseurDalle/2.0+0.1, -1.0>
  rotate 45.0*x
  translate -z*LargeurDalle/2.0
}

#declare Dalle = difference
{
  box
  {
    <-LargeurDalle/2.0, -EpaisseurDalle/2.0, -LargeurDalle/2.0>
    <LargeurDalle/2.0, EpaisseurDalle/2.0, LargeurDalle/2.0>
  }
  object { Truc }
  object { Truc rotate 90.0*y }
  object { Truc rotate 180.0*y }
  object { Truc rotate -90.0*y }
  difference
  {
    cylinder
    {
      <0.0, EpaisseurDalle/2.0-ProfondeurGravureDalle, 0.0>
      <0.0, EpaisseurDalle/2.0+ProfondeurGravureDalle, 0.0>
      Diametre1Dalle/2.0
    }
    cylinder
    {
      <0.0, EpaisseurDalle/2.0-0.000001, 0.0>
      <0.0, EpaisseurDalle/2.0+2.0*ProfondeurGravureDalle, 0.0>
      Diametre2Dalle/2.0
    }
  }
  //translate -y*EpaisseurDalle/2.0
}

#declare SX = seed(1000)
#declare SZ = seed(1001)

#declare Damier = union
{
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-3.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-2.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-1.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, 3.5*LargeurDalle> }

  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-3.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-2.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-1.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, 2.5*LargeurDalle> }

  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-3.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-2.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-1.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, 1.5*LargeurDalle> }

  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-3.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-2.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-1.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, 0.5*LargeurDalle> }

  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-3.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-2.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-1.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, -0.5*LargeurDalle> }

  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } rotate <0.0, 0.0, 3.0> translate <-3.5*LargeurDalle, EpaisseurDalle/4.0, -1.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } rotate <-4.0, 0.0, 0.0> translate <-2.5*LargeurDalle, EpaisseurDalle/5.0, -1.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-1.5*LargeurDalle, 0.0, -1.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, -1.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, -1.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, -1.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, -1.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, -1.5*LargeurDalle> }

  //object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-3.5*LargeurDalle, 0.0, -2.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } rotate <4.0, 0.0, 8.0> translate <-2.5*LargeurDalle, EpaisseurDalle/4.0, -2.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-1.5*LargeurDalle, 0.0, -2.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, -2.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, -2.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, -2.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, -2.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, -2.5*LargeurDalle> }

  //object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-3.5*LargeurDalle, 0.0, -3.5*LargeurDalle> }
  //object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-2.5*LargeurDalle, 0.0, -3.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } rotate <-2.0, 0.0, 5.0> translate <-1.5*LargeurDalle, EpaisseurDalle/4.0, -3.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <-0.5*LargeurDalle, 0.0, -3.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <0.5*LargeurDalle, 0.0, -3.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <1.5*LargeurDalle, 0.0, -3.5*LargeurDalle> }
  object { Dalle texture { T_Stone15 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <2.5*LargeurDalle, 0.0, -3.5*LargeurDalle> }
  object { Dalle texture { T_Stone6 finish { reflection 0.5 } translate <10.0*rand(SX), 0.0, 10.0*rand(SZ)> } translate <3.5*LargeurDalle, 0.0, -3.5*LargeurDalle> }
}

#declare DalleCassee = difference
{
  object { Dalle }
  box
  {
    <-LargeurDalle, -EpaisseurDalle, -LargeurDalle>
    <LargeurDalle, EpaisseurDalle, 0.0>
  }
  box
  {
    <-LargeurDalle, -EpaisseurDalle, -LargeurDalle>
    <LargeurDalle, EpaisseurDalle, 0.0>
    rotate 30.0*y
  }
  texture
  {
    T_Stone15
    finish
    {
      reflection 0.2
    }
  }
  rotate 240.0*y
  translate <-2.2*LargeurDalle, EpaisseurDalle-0.000001, -1.3*LargeurDalle>
}

#declare TerreDessous = height_field
{
  tga "dessous3.tga"
  texture
  {
    pigment
    {
      image_map
      {
        tga "texture.tga"
        map_type 0
        interpolate 2
        once
      }
      rotate x*90
    }
    finish
    {
      ambient 0.2
    }
  }
  //pigment { Yellow }
  smooth
  water_level 0.0001
  scale <8.0*LargeurDalle, 4.0, 8.0*LargeurDalle>
  translate <-4.0*LargeurDalle, 0.0, -4.0*LargeurDalle>
  rotate 180.0*x
}

#declare Sable = height_field
{
  tga "sable.tga"
  texture
  {
    pigment
    {
      image_map
      {
        tga "texture.tga"
        map_type 0
        interpolate 2
        once
      }
      rotate x*90
    }
    finish
    {
      ambient 0.5
    }
  }
  //pigment { Yellow }
  smooth
  water_level 0.00001
  scale <3.0*LargeurDalle, 0.15, 3.0*LargeurDalle>
  translate <-4.0*LargeurDalle, EpaisseurDalle/2.0-0.00001, -4.0*LargeurDalle>
}

#declare Volcan = height_field
{
  tga "volcan.tga"
  smooth
  water_level 0.00001
  texture
  {
    pigment { rgb <0.28, 0.22, 0.22> }
    normal { granite 2.0 }
  }
  scale <4.0*LargeurDalle, 1.5, 4.0*LargeurDalle>
  translate <0.0, EpaisseurDalle/2.0-0.01, -4.0*LargeurDalle>
}

#declare Foyer = light_source
{
  <0.0, 0.0, 0.0>
  color rgb <5.0, 3.0, 0.0>
  translate <(281.0/400.0)*4.0*LargeurDalle, 1.5, ((400.0-281.0)/400.0)*4.0*LargeurDalle-4.0*LargeurDalle>
  fade_distance 1.0
  fade_power 1.5
}

#declare Brume = box
{
  <-1.0, -1.0, -1.0>
  <1.0, 1.0, 1.0>
  pigment { rgbt <1.0, 1.0, 1.0, 1.0> }
  hollow
  halo
  {
    attenuating
    max_value 1.0
    linear
    cylindrical_mapping
    color_map
    {
      [ 0 color rgbt <1.0, 1.0, 1.0, 1.0> ]
      [ 1 color rgbt <1.0, 1.0, 1.0, 0.5> ]
    }
    samples 20
    aa_level 5
    aa_threshold 0.1
    jitter 0.8
    turbulence 2.0
  }
  halo
  {
    attenuating
    max_value 1.0
    linear
    planar_mapping
    color_map
    {
      [ 0 color rgbt <1.0, 0.7, 0.5, 1.0> ]
      [ 1 color rgbt <1.0, 1.0, 1.0, 0.0> ]
    }
    samples 20
    aa_level 5
    aa_threshold 0.1
    jitter 0.8
    turbulence 3.0
  }
  scale <2.0*LargeurDalle, 0.5, 2.0*LargeurDalle>
  translate <2.0*LargeurDalle, 0.5, -2.0*LargeurDalle>
}


#declare Glacon = difference
{
  union
  {
    superellipsoid
    {
      <0.3, 0.3>
      rotate <45.0, 25.0, 25.0>
      translate <0.0, -0.1, 0.0>
    }
    superellipsoid
    {
      <0.3, 0.3>
      rotate <45.0, 45.0, 25.0>
      translate <-0.5, -0.5, -1.5>
    }
  }
  box
  {
    <-2.0, 0.0, -2.0>
    <2.0, -2.0, 2.0>
  }
}

#declare LargeurFlaque = 8.0
#declare HauteurFlaque = 0.1

#declare Flaque = difference
{
  blob
  {
    #declare NSPHERE = 200
    #declare COUNT = 1
    #declare R1 = seed(100)
    #declare R2 = seed(101)
    #declare R3 = seed(102)
    threshold 0.3
    #while (COUNT<NSPHERE)
      #declare X = LargeurFlaque*(rand(R1)-0.5)*cos(pi*rand(R2))
      #declare Z = LargeurFlaque*(rand(R1)-0.5)*sin(pi*rand(R2))
      #declare Y = 10.0*HauteurFlaque*0.5*(1.0+rand(R3))
      sphere { <X, 0.0, Z>, Y, 1.0 }
      #declare COUNT = COUNT+1
    #end
    sturm
    scale <1.0, 0.3, 1.0>
  }
  box { <-LargeurFlaque, HauteurFlaque, -LargeurFlaque> <LargeurFlaque, 5.0*HauteurFlaque, LargeurFlaque> }
}

#declare Eau = union
{
  object { Glacon }
  object { Flaque }
  texture
  {
    pigment { rgbf <1.0, 1.0, 1.0, 0.9> }
    normal { bumps 3.0 }
    finish
    {
      ambient <0.3, 0.0, 0.9>       //<0.2, 0.0, 0.7>
      diffuse 0.0
      reflection 0.01
      refraction 1.0
      ior 1.33
      specular 1.0
      roughness 0.001
      fade_distance 5.0
      fade_power 1.0
    }
  }
  scale <0.5, 0.5, 0.5>
  translate <-1.5, EpaisseurDalle/2.0-0.0001, 1.5>
}


#declare Hauteur_Tourbillon = 5.0
#declare RayonMin_Tourbillon = 0.25
#declare RayonMax_Tourbillon = 2.0
#declare NbSpirales_Tourbillon = 20.0
#declare AngleSpirale_Tourbillon = 7.33*360.0
#declare NbObjetsSpirale_Tourbillon = 500.0
#declare RObjectSpirale_Tourbillon = 0.02

#declare R0 = seed(1000)
#declare R1 = seed(1001)
#declare R2 = seed(1002)
#declare R3 = seed(1003)
#declare R4 = seed(1004)
#declare R5 = seed(1005)
#declare R6 = seed(1006)
#declare R7 = seed(1007)
#declare R8 = seed(1008)
#declare R9 = seed(1009)
#declare R10 = seed(1010)

#declare Count = 1.0

#declare Tourbillon = merge
{
#while (Count <= NbSpirales_Tourbillon)
  #declare Angle = 0.0
  #declare Numero = 0.0
  #declare AngleStart = 360.0*rand(R0)
  #declare Mul_Rayon = 0.5*(1.0+rand(R4))
  #while (Angle <= AngleSpirale_Tourbillon)
    #declare Angle_Utilise = AngleStart+Angle+4.0*rand(R1)
    #declare Rayon = RayonMin_Tourbillon+(RayonMax_Tourbillon-RayonMin_Tourbillon)*(Numero/NbObjetsSpirale_Tourbillon)
    #declare Rayon_Utilise = (Rayon+(RayonMax_Tourbillon-RayonMin_Tourbillon)*(10.0/100.0)*(rand(R2)-0.5))*Mul_Rayon
    #declare Altitude = Hauteur_Tourbillon*(Numero/NbObjetsSpirale_Tourbillon)
    #declare Altitude_Utilise = Altitude+Hauteur_Tourbillon*(5.0/100.0)*rand(R3)
    #declare XObjet = Rayon_Utilise*cos(Angle_Utilise*pi/180.0)
    #declare YObjet = Altitude_Utilise
    #declare ZObjet = Rayon_Utilise*sin(Angle_Utilise*pi/180.0)
    #declare RX = 360.0*rand(R5)
    #declare RY = 360.0*rand(R6)
    #declare RZ = 360.0*rand(R7)
    #declare SX = 0.5*(1.0+rand(R8))
    #declare SY = 0.5*(1.0+rand(R9))
    #declare SZ = 0.5*(1.0+rand(R10))
    sphere
    {
      <0.0, 0.0, 0.0>
      RObjectSpirale_Tourbillon
      pigment { rgbt <1.0, 1.0, 1.0, 0.8> }
      finish { reflection 0.05 }
      scale <SX, SY, SZ>
      rotate <RX, RY, RZ>
      translate <XObjet, YObjet, ZObjet>
    }
    #declare Numero = Numero+1.0
    #declare Angle = Angle+AngleSpirale_Tourbillon/NbObjetsSpirale_Tourbillon
  #end
  #declare Count = Count+1.0
#end
}

#include "tornade3.pov"

/*****************************************************/

object { Damier }
object { TerreDessous }
object { Sable }
object { DalleCassee }
object { Volcan }
object { Foyer }
object { Brume }
object { Eau }
object { Tornade rotate 45.0*y scale <7.0, 6.5, 7.0> translate <2.0, 0.0, 2.0> }
object { Tourbillon translate <2.0, 0.0, 2.0> }
