//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 7 textures and 14 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 08/18/1998    (18.08.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camara1
  location  <12.180, -106.260, 5.070>
  direction <0.0,     0.0,  1.6095>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <2.090, -12.470, 1.040>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera7
  location  <-54.130, -129.850, 19.750>
  direction <0.0,     0.0,  1.6095>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-12.400, -22.720, 5.920>
}

*/

/*
camera {  //  Camera Camera2
  location  <-37.060, -114.390, 20.960>
  direction <0.0,     0.0,  2.1144>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <4.110, 24.760, 7.150>
}

*/

/*
camera {  //  Camera Camera3
  location  <35.830, -52.440, 20.960>
  direction <0.0,     0.0,  2.1144>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-0.840, 24.760, 5.920>
}

*/

/*
camera {  //  Camera Camera4
  location  <0.460, -75.150, 173.690>
  direction <0.0,     0.0,  2.1144>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <4.110, 24.760, 7.150>
}

*/

/*
camera {  //  Camera Camera5
  location  <114.240, -5.980, 51.510>
  direction <0.0,     0.0,  2.1144>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <4.110, 24.760, 7.150>
}

*/

/*
camera {  //  Camera Camera6
  location  <-100.060, -49.360, 29.000>
  direction <0.0,     0.0,  2.1144>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <4.110, 24.760, 7.150>
}

*/

//
// *******  L I G H T S *******
//

light_source { // AreaLite3
  <-15.928, 11.819, 15.555>
  color  rgb<1.000, 0.483, 0.017>
  area_light <-0.000, 0.000, 29.322>, <0.000, 1.303, 0.000>, 2, 2
  adaptive 1
  jitter
}


light_source { // AreaLite001
  <0.814, 40.435, 19.204>
  color  rgb<1.000, 0.379, 0.017>
  area_light <-0.000, 0.000, 36.200>, <0.000, 3.620, 0.000>, 2, 2
  adaptive 1
  jitter
}


light_source { // AreaLite002
  <1.140, 50.500, 25.000>
  color  rgb<0.672, 0.121, 0.009>
  area_light <6.000, 0.000, 0.000>, <0.000, -0.000, -50.000>, 2, 32
  adaptive 1
  jitter
}



//
// ********  TEXTURES  *******
//

#include "kilawea8.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare Chorro1 = union {
  sphere { // Fuego3
    <0,0,0>,1
    texture {
      LavaCaliente
    }
    no_shadow
    hollow
    scale <20.0, 30.0, 35.0>
    translate  <0.0, 2.22, -2.3>
  }
  no_shadow
  hollow
  scale <0.36, 0.36, 0.81>
  translate  <-8.8, 6.53, 0.0>
}
#declare Chorro3 = union {
  sphere { // Fuego001
    <0,0,0>,1
    texture {
      LavaCaliente
    }
    no_shadow
    hollow
    scale <18.0, 18.0, 30.0>
    translate  -2.3*z
  }
  no_shadow
  hollow
  translate  <0.45, 22.34, 0.0>
}
#declare Chorro2 = union {
  sphere { // Fuego2
    <0,0,0>,1
    texture {
      LavaTibia
    }
    no_shadow
    hollow
    scale <18.0, 18.0, 30.0>
    translate  <-3.23, 1.26, -2.3>
  }
  no_shadow
  hollow
  scale <0.6, 0.6, 0.9>
  translate  <12.76, 32.33, 0.0>
}
#declare LlamaGrande = union {
  sphere { // FuegoGrande
    <0,0,0>,1
    texture {
      LavaTibia
    }
    no_shadow
    hollow
    scale <30.000002, 30.000002, 72.0>
  }
  no_shadow
  hollow
  scale 0.552486
  translate  <0.629834, 27.900553, 0.0>
}
union { // Llamas
  object { Chorro1 }
  object { Chorro3 }
  object { Chorro2 }
  sphere { // Cenizas1
    <0,0,0>,1
    texture {
      Polvo
    }
    no_shadow
    hollow
    scale <40.0, 40.0, 20.445717>
    translate  <1.39, 33.99, 0.0>
  }
  sphere { // Fuego4
    <0,0,0>,1
    texture {
      LavaMuyCaliente
    }
    no_shadow
    hollow
    scale <38.0, 38.0, 4.0>
    translate  <0.375, 32.149999, -0.575>
  }
  object { LlamaGrande }
  sphere { // Fuego5
    <0,0,0>,1
    texture {
      LavaCaliente
    }
    no_shadow
    hollow
    scale <3.580111, 5.966851, 16.574587>
    rotate <4.739422, 4.903824, 0.14296>
    translate  <18.91, 14.13, -1.95>
  }
  hollow
  scale 1.81
}


intersection { // RioLava
  plane { // Lava
    z,0
    scale <20.0, 40.0, 20.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.0>
  }
  texture {
    magma_t
    scale <1.0, 6.0, 2.635209>
    translate <0.950000, 43.000000, 0.000000>
  }
}


sphere { // Cielo
  <0,0,0>,1
  texture {
    Cielo_tarde
  }
  no_shadow
  hollow
  scale <1000.0, 1000.0, 500.0>
  translate  -300.0*z
}


object {   // Terreno
  height_field {
    gif "C:\POVRAY3\TERRAIN\lecho.gif"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    basalto
  }
  scale <100.0, 100.0, 9.0>
  translate  8.5*z
}


