// Sky Sphere

sky_sphere {
	pigment {
		bozo
		turbulence 1
		color_map {
			[ 0 rgb<0.37, 0.42, 0.24> ]
			[ 0.5 rgb<0.45, 0.43, 0.28> ]
			[ 1 rgb<0.5, 0.45, 0.36> ]
		}
	}
}

// Mercury Textures

#declare seatext = texture {
	pigment {
		color rgb<0.4, 0.4, 0.4>
	}
	finish {
		ambient 0.2
		diffuse 0.8
		specular 4
		roughness 0.002
		reflection 0.3
	}
	normal {
		waves 0.06
		frequency 1000
		scale 1000
	}
}

// Path Textures

#declare GratedMetalTexture = texture {
	pigment { color rgb<0.3, 0.3, 0.3> }
	finish {
		brilliance 1
		specular 1
		roughness 0.01
		metallic
	}
	normal {
		dents 0.1
		scale 0.05
	}
}

#declare RustedMetalTexture = texture {
	pigment {
		granite
		turbulence 2
		color_map {
			[ 0 rgb<0.59, 0.39, 0.2> ]
			[ 1 rgb<0.71, 0.54, 0.2> ]
		}
	}
	finish {
		specular 0.01
		roughness 0.1
		metallic
	}
	normal {
		granite 0.2
		scale 0.1
	}
}

#declare RailTexture = texture {
	pigment { color rgb<0.35, 0.33, 0.15> }
	finish {
		brilliance 2
		specular 1
		roughness 0.05
		reflection 0.2
		metallic
	}
}

// Rock textures

#declare DarkRock = texture {
	pigment {
		bozo
		turbulence 1
		color_map {
			[ 0 rgb<0.37, 0.42, 0.24> ]
			[ 0.5 rgb<0.45, 0.43, 0.28> ]
			[ 1 rgb<0.5, 0.45, 0.36> ]
		}
	}
	finish {
		specular 0.05
		roughness 0.1
		crand 0.1
	}
	scale 10
}

#declare LightRock = texture {
	pigment {
		bozo
		turbulence 1
		color_map {
			[ 0 rgb<0.37, 0.42, 0.24>*1.5 ]
			[ 0.5 rgb<0.42, 0.39, 0.28>*1.5 ]
			[ 1 rgb<0.42, 0.39, 0.36>*1.5 ]
		}
	}
	finish {
		specular 0.05
		roughness 0.1
		crand 0.1
	}
	scale 10
}

#declare LightCoated = texture {
	bozo
	texture_map {
		[ 0 LightRock ]
		[ 0.6 LightRock ]
		[ 1 seatext ]
	}
}

#declare RockTexture = texture {
	gradient y
	texture_map {
		[ 0 seatext ]
		[ 0.3 LightCoated ]
		[ 0.6 DarkRock ]
		[ 1 DarkRock ]
	}
}

// Machine Textures

#declare ReflectiveText = texture {
	pigment { color rgb 0.5 }
	finish {
		reflection 0.5
		diffuse 0.5
		specular 0.5
		roughness 0.01
	}
}

#declare ReflectiveIrid = texture {
	pigment { color rgb 0.5 }
	finish {
		reflection 0.5
		diffuse 0.5
		specular 1
		roughness 0.01
		irid { 0.2 thickness 0.2 turbulence 0.5 }
	}
}

#declare rustypig = pigment {
	granite
	turbulence 2
	color_map {
		[ 0 rgb<0.75, 0.65, 0.15> ]
		[ 1 rgb<0.8, 0.7, 0.15> ]
	}
}

#declare SpottedYellow = texture {
	pigment {
		bozo
		pigment_map {
			[ 0 rgb<0.9, 0.9, 0.1> ]
			[ 0.8 rgb<0.8, 0.9, 0.1> ]
			[ 1 rustypig ]
		}
		scale 0.1
		turbulence 1
	}
	finish {
		specular 1
		roughness 0.01
	}
	normal {
		marble 0.02
		cubic_wave
		scale 0.5
		turbulence 5
	}
}

#declare MauveGreen = texture {
	pigment { color rgb<0.6, 0.7, 0.3> }
	finish {
		specular 1
		roughness 0.01
	}
	normal {
		marble 0.02
		cubic_wave
		scale 0.5
		turbulence 5
	}
}

#declare YellowText = texture {
	gradient y
	texture_map {
		[ 0 MauveGreen ]
		[ 0.3 SpottedYellow ]
		[ 1 SpottedYellow ]
	}
}

#declare CopperText = texture {
	pigment { color rgb<0.65, 0.35, 0.15> }
	finish {
		diffuse 0.7
		brilliance 3
		specular 1
		roughness 0.01
		reflection 0.2
	}
}

#declare Stripedpig = texture {
pigment {
	radial
	frequency 20
	color_map {
		[ 0 rgb <0, 0, 0> ]
		[ 0.5 rgb <0, 0, 0> ]
		[ 0.5 rgb <1, 1, 0> ]
		[ 1 rgb <1, 1, 0> ]
	}
}
}

#declare StripedOverlay = texture {
pigment {
	bozo
	color_map {
		[ 0 rgbt<1, 1, 1, 1> ]
		[ 1 rgbt<1, 1, 1, 0.5> ]
	}
	scale 0.2
}
}

#declare BodyText = texture {
	pigment {
		color rgb<0.4, 0.4, 0.45>
	}
	finish {
		reflection 0.1
		specular 0.5
		roughness 0.01
	}
	normal {
		dents 0.1
		scale 0.1
	}
}

#declare GreenLightText = texture {
	pigment { color rgbf<0.5, 1, 0.5, 0.5> }
	finish {
		ambient 0.9
		diffuse 0.1
		ior 1.45
	}
}

#declare BrightMerc = texture {
	pigment { color rgb 1 }
	finish {
		reflection 0.5
		specular 1
		roughness 0.01
		diffuse 0.5
	}
}

#declare ibeamTexture = texture {
	pigment { color rgb 0.3 }
	finish {
		brilliance 1
		specular 1
		roughness 0.01
		metallic
	}
	normal {
		dents 0.1
		scale 0.05
	}
}

#declare WhiteText = texture {
	pigment { color rgb 0.5 }
	finish {
		specular 0.2
		roughness 0.1
	}
}

#declare glassyText = texture {
	pigment { color rgbf<0.98, 1, 0.98, 0.9> }
	finish {
		ambient 0
		diffuse 0.1
		reflection 0.1
	}
}

// Canister Textures

#declare CannisterTexture = texture {
	pigment { color rgb<0.6, 0.6, 0.2> }
	finish {
		specular 0.5
		roughness 0.01
	}
	normal {
		dents 0.2
		scale 0.1
	}
}

#declare RubberText = texture {
	pigment { color rgb<0.2, 0.2, 0.2> }
	finish {
		specular 0.3
		roughness 0.01
	}
	normal {
		bumps 0.01
		scale 0.01
	}
}

#declare BrightYellow = texture {
	pigment { color rgb<1, 1, 0> }
	finish {
		crand 0.1
		specular 0.3
		roughness 0.01
	}
}

#declare FuzzyScreen = texture {
	pigment {
		bozo
		color_map {
			[ 0 rgb 1 ]
			[ 1 rgb 0 ]
		}
		scale 0.1
	}
	finish {
		specular 0.5
		roughness 0.01
		ambient 0.8
		diffuse 0.2
	}
}

#declare PipeTexture = texture {
	pigment {
		color rgb<0.5, 0.5, 0.5>
	}
	finish {
		brilliance 1
		specular 0.5
		roughness 0.1
		reflection 0.1
		metallic
	}
	normal {
		dents 0.4
		scale 0.1
	}
}
