// Persistence of Vision Ray Tracer Include File File
// File: defaults.inc
// Vers: 3.01 Watcom Win32
// Desc: Resets all default values for the trees.inc file
// Date: April 1, 1997
// Auth: Sonya Roberts
// Note:

#declare True=1
#declare False=0
#declare MaxSplits=4		// Maximum number of forks in a section of Tree (minimum of 1)
#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
#declare BaseLen=1		// Base Length (length of smallest twig - determines scale of tree)
#declare LengthInc=1.2		// Factor By Which to Increase Base Length
#declare MinXDeg=35		// Minimum X-rotation of forks
#declare MaxXDeg=55		// Maximum X-rotation of forks
#declare IncXDeg=0		// Number of degrees to increment X by at each level
#declare MinYDeg=0		// Minimum Y-rotation of forks
#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
#declare IncYDeg=0		// Number of degrees to increment Y by at each level
#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
#declare MaxZDeg=0		// Maximum Z-rotation of forks
#declare IncZDeg=0		// Number of degrees to increment Z by at each level
#declare PlusMinus=20		// Angle of change of terminal fork
#declare SD1=seed(2)		// Seed for random numbers - changing only this will create a different tree of the same species
#declare SD2=seed(1997)		// Seed for additional randum numbers - so tree shape won't change from optional code
#declare SD3=seed(1)		// Seed for additional randum numbers - so tree shape won't change from optional code
#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
#declare LeafRosette=False	// No rosettes
#declare LeafRandRot=False	// No randomizarion
#declare TipPercent=1		// Always
#declare Tip=1			// Default Leaf
#declare TipOther=1		// Default Leaf
#declare LeafShape=0		// Default Oval
#declare LeafTexture=0		// Default PaleGreen
#declare FruitShape=0		// Default Small Sphere
#declare FruitTexture=0		// Default Red
#declare BarkTexture=0		// Default Brown
#declare FlowerShape=0		// Default 5-Petalled Flower
#declare FlowerTexture=0	// Default White/Orchid Gradient

