
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"

camera
{
// location  <0 , 9 ,0>
//  look_at   <0 , 0 ,0>
location <0.2,3,-4.3>
look_at <0.2,0,0>

}

#declare r1=seed(191)


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <1,1.5,-1.5>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1  green 1  blue 1  // light's color
  translate <1,6,3>
shadowless
}


// Set a color of the background (sky)
//background { color red 0.1 green 0.3 blue 0.8 }
#declare wand=plane{<0,0,-1>,1
texture{White_Marble}
finish{reflection 0.15 diffuse 0.3}
scale 2.0
translate <0,0,15>}

plane {y,0
texture{Water pigment{rgbf<0.3,0.3,1,0.5>}}
scale 10
finish{reflection 0.65 diffuse 0.3 refraction 1 ior 1.55}
translate <10,0.005,30>
 }

plane {y,0
pigment{rgb <0.3,0.3,0.3>}
translate <0,-10,0>}


#declare b_obj=union{

#declare z2=0
#while (z2<20)
#declare z2=z2+1

#declare xkor=0
#declare ykor=0
#declare zkor=0
#declare zahler=-1
#declare winkel1=0
#declare winkel2=0

blob{threshold 0.2
#while (zahler<40)
#declare zahler=zahler+1
#declare dwinkel2=-13.5/2
#declare dwinkel1=15/2
#declare winkel1=winkel1+dwinkel1
#declare winkel2=winkel2+dwinkel2

 cylinder{<0,0,0>,<0,0,0.065+zahler*0.004625>,(0.2-(zahler*0.0049))*1.3,1
// scale <4,1,1>
 rotate x*winkel2
 rotate y*winkel1
 translate <xkor,ykor,zkor>}

#declare zkor=zkor+cos(radians(winkel1))*cos(radians(winkel2))*0.5*0.5
#declare xkor=xkor+cos(radians(winkel2))*sin(radians(winkel1))*0.5*0.5
#declare ykor=ykor+sin(radians(-winkel2))*0.5*0.5
#end

//pigment {Red}
scale 0.35

//#declare rotatex=(rand(r1)*-90)-45
//#declare rotatey=rand(r1)*360
//#declare rotatez=rand(r1)*360
#declare rotatex=0
rotate x*rotatex
//rotate y*rotatey
rotate y*z2*14.4*1.25
//rotate z*rotatez
//translate <0,0,1.5>
}
#end
}

//#declare oz#=0
//#while (oz#<0) 

union{
b_obj 
pigment{
   wood
   pigment_map{
	[0 rgb<0.2,0,0>]
	[0.6 rgb<1,0,0>]
	[1 rgb<1,0.5,0>]
	[1 Yellow]}
	rotate x*90
	scale 3}
scale 0.7
translate <0.6,0,0>}

union{
b_obj 
pigment{
   wood
   pigment_map{
	[0 rgb<1,0,0>]
	[0.8 rgb<1,1,0>]
	[1 rgb<0.7,1,0>]
	[1 Yellow]}
	rotate x*90
	scale 3}
scale 0.7
rotate z*-5
rotate x*10
translate <2.5,0,4.2>}

union{
b_obj 
pigment{
   wood
   pigment_map{
	[0 rgb<0.35,0.35,0>]
	[0.65 rgb<1,1,0>]
	[1 rgb<0.4,1,0>]
	[1 Yellow]}
	rotate x*90
	scale 3}
scale 0.7
rotate z*15
rotate x*-5
translate <1.5,0,-1.5>}

union{
b_obj 
pigment{
   wood
   pigment_map{
	[0 rgb<0,0,1>]
	[0.8 rgb<0,1,0>]
	[1 rgb<0.2,1,0>]
	[1 Yellow]}
	rotate x*90
	scale 3}
scale 0.7
rotate z*1
rotate x*-15
translate <-0.2,0,2.5>}

union{
b_obj 
pigment{
   wood
   pigment_map{
	[0 rgb<1,0,1>]
	[0.8 rgb<1,0,0>]
	[1 rgb<1,0,0>]
	[1 Yellow]}
	rotate x*90
	scale 3}
scale 0.7
translate <-2.5,0,4.3>}

union{
b_obj 
pigment{
   wood
   pigment_map{
	[0 rgb<1,0.5,0>]
	[0.30 rgb<1,0.5,0>]
	[0.52 rgb<1,1,0>]
	[1 Yellow]}
//	turbulence 0.1
	rotate x*90
	scale 3.5}
scale 0.7
rotate z*-10
rotate x*5
translate <-1.4,0,-0.85>}

