// desk.inc
// by Robert Fremin
#version 3.1;

#include "woods.inc"
#include "stones.inc"

#ifndef (DESK_INC)
#declare DESC_INC = true;

#debug "=#= included desk.inc =#=\n"

// HiQuality = boolean if high quality is wanted
// Drawers = boolean if include drawers beneath desk
// --- The desk is placed with the center top surface at origo,
//     and against a wall at z*35 and a floor at Y*-71.5 .
//
#macro Desk(HiQuality, Drawers)
union
{
	#if (HiQuality)
		superellipsoid
		{
			<.15,.01>
			scale .5
	#else
		box
		{
			-.5 .5
	#end
		scale <150,3,70>
		translate y*-1.5

		#if (HiQuality)
			texture { T_Stone3 rotate y*91 scale 10 }
		#else
			pigment { rgb <.7,.6,.5> }
		#end
		finish { specular .3 phong .7 reflection .016 }
	}

	#if (Drawers)
		#declare Drawer =
		union
		{
			#if (HiQuality)
				superellipsoid
				{
					<.1,.01>
					scale .5
					rotate x*90
			#else
				box
				{
					-.5 .5
			#end
					scale <35,15,2>
					translate <0,21.5,-26>

					texture { T_Wood3 rotate <98,24,34> scale 10 }
					finish { specular .3 phong .6 reflection .005 }
				}

			union
			{
				cylinder { y*0 y*.5 1.5 }
				sor { 7 <1.5,.5> <1.49,.5> <.5,1> <2,2> <2,2.25> <0,2.999> <0,3> }
				rotate x*-90
				translate <0,22.5,-27>
				texture { T_Chrome_3C }
			}
		}

		#local OneSide =
		union
		{
			#if (HiQuality)
				superellipsoid
				{
					<.1,.003>
					scale .5
					rotate x*90
			#else
				box
				{
					-.5 .5
			#end
				scale <40,70,50>
			}

			#local i = 0;
			#while (i < 3)
				object { Drawer translate y*i*-20 }
				#local i = i + 1;
			#end

			texture { T_Wood3 rotate <98,24,34> scale 10 }
			finish { specular .2 phong .8 reflection .005 }
		}

		object { OneSide translate <-52,-36.5,0> }	// left
//@@@		object { OneSide translate < 52,-36.5,0> }	// right
	#end
}
#end


// HiQuality = boolean if high quality is wanted
// --- Placed on the desk
//
#macro Shelves(HiQuality)
union
{
	#local Width = 70;

	// shelves
	union
	{
		#local Shelf =
		#if (HiQuality)
			superellipsoid
			{
				<.1,.01>
				scale .5
		#else
			box
			{
				-.5 .5
		#end
				scale <Width,2,30>
			}

		object { Shelf translate y*20 }
		object { Shelf translate y*40 }
		#if (HiQuality)
			texture { T_Wood3 rotate y*89 scale 10 }
		#else
			pigment { Brown }
		#end
		finish { specular .1 phong .5 reflection .009 }
	}

	// bolts and feet
	#if (HiQuality)
		union
		{
			cylinder { x*-1 x*2.3 .4 translate < Width/2,20,-13> }
			cylinder { x*-1 x*2.3 .4 translate < Width/2,20, 13> }
			cylinder { x*-2.3 x*1 .4 translate <-Width/2,20,-13> }
			cylinder { x*-2.3 x*1 .4 translate <-Width/2,20, 13> }

			cylinder { x*-1 x*2.3 .4 translate < Width/2,40,-13> }
			cylinder { x*-1 x*2.3 .4 translate < Width/2,40, 13> }
			cylinder { x*-2.3 x*1 .4 translate <-Width/2,40,-13> }
			cylinder { x*-2.3 x*1 .4 translate <-Width/2,40, 13> }

			superellipsoid { <1,.15> rotate x*90 scale <1.2,.25,1.2> translate < (Width/2+1),.25,-13> }
			superellipsoid { <1,.15> rotate x*90 scale <1.2,.25,1.2> translate < (Width/2+1),.25, 13> }
			superellipsoid { <1,.15> rotate x*90 scale <1.2,.25,1.2> translate <-(Width/2+1),.25,-13> }
			superellipsoid { <1,.15> rotate x*90 scale <1.2,.25,1.2> translate <-(Width/2+1),.25, 13> }

			pigment { White }
			finish { Phong_Shiny ambient .3 }
		}
	#end

	// frame
	#local SPipes =
	union
	{
		cylinder { y*0 y*40 1 translate <0,0,-13> }
		cylinder { y*0 y*40 1 translate <0,0, 13> }
		torus
		{
			13 1
			rotate z*90
			clipped_by { plane { -y,0 } }
			translate y*40
		}
		#if (HiQuality)
			texture { T_Chrome_3B }
		#else
			pigment { Grey }
		#end
	}

	object { SPipes translate x*-(Width/2+1) }
	object { SPipes translate x*(Width/2+1) }
}
#end

#end	// ifndef
