// ljus.inc
// by Robert Fremin
//
#version 3.1;

#include "metals.inc"

#ifndef (CANDLE_INC)
#declare CANDLE_INC = true;
#debug "=#= included ljus.inc =#=\n"

#macro Flame()
union
{
	merge
	{
		sphere
		{
			0 1
		}
		cone
		{
			y*.3 .95 y*1.6 .4+.1
		}
		sphere
		{
			0 .4+.1
			clipped_by { plane { -y,-.05 } }
			translate y*1.55
		}

		pigment { White filter .97 }

		interior
		{
			caustics .3
			media
			{
				emission 10
				intervals 5
				samples 1, 10
				confidence 0.9999
				variance 1/1000
				density
				{
					spherical
					ramp_wave
					turbulence 0.1
					color_map
					{
						[0. rgb <.0, .0, .001>]
						[.5 rgb <.2,.15,.1>]
						[1. rgb <.8,.5,.3>]
					}
					scale <1,2,1>
				}
			}
		}
		finish { diffuse 1 }
		hollow yes
	}

	sphere
	{
		0 .9
		pigment { White filter .9 }
		interior
		{
			caustics .3
			media
			{
				emission 2
				intervals 5
				samples 1, 10
				confidence 0.9999
				variance 1/1000
				density
				{
					spherical
					ramp_wave
					turbulence 0.1
					color_map
					{
						[0. rgb <0,0,0>]
						[.2 rgb <.1,0,1>]
						[1. rgb <0,0,1>]
					}
					scale <1,2,1>
				}
			}
		}
		hollow on
		finish { ambient 3 }
		scale <1,.85,1>
		translate y*-.175
	}

	no_shadow

	scale <.55,1.2,.55>
	rotate z*2
	translate x*-.01-y*.05
}
#end


#macro Heat()
cone
{
	y*0 1 y*1 2
	open
	pigment
	{
		gradient y scale 1
		color_map
		{
			[.0 rgbft <1,1,1,.95,0>]
			[.7 rgbft <1,1,1,1,0>]
		}
	}

	normal { bumps scale .6 }

	interior
	{
		ior 1.02
		caustics .3
	}
	hollow on
	no_shadow

	scale <1,15,1>
}
#end


// Unused = boolean if the candle never has been lit
// Lit = boolean if the wick is glowing
//
#macro Wick(Unused, Lit)
#if (Unused)
	cylinder
	{
		x*-.1 x*1.5 .1
		rotate z*2
		translate y*-.8
		pigment { White }
		finish { ambient .5 specular .3 phong .5 }
		translate x*.45
	}
#else
	intersection
	{
		torus
		{
			1 .1
			rotate x*90
		}
		sphere
		{
			<-.8,.6,0> 1
			#if (Lit)
				pigment { rgb <.8,.5,.2> }
				finish { ambient 1 }
			#end
		}
		translate <.5,-1.2,0>
		pigment { Black }
		finish { specular .3 }
		translate x*.45
	}
#end
#end


// Unused = boolean if the candle never has been lit
//
#macro Candle(Unused)
#local CBody =
union
{
	cylinder
	{
		y*0 y*-1.9 3
	}
	sphere
	{
		0 3
		scale <1,.01,1>
	}
}

#if (Unused)
	object
	{
		CBody
#else
	difference
	{
		object { CBody }
		sphere
		{
			0 1.5
			scale <1,.2,1>
		}
#end
	translate y*-.9
	pigment { White }
	finish { ambient .3 specular .25 phong .2 reflection .03 }
}
#end


// HiQuality = boolean if high quality is wanted
//
#macro Candle_casing(HiQuality)
union
{
	difference
	{
		cylinder
		{
			y*.3 y*-2 3.05
		}
		cylinder
		{
			y*1 y*-3 3.02
		}
	}
	torus
	{
		2.85 .2
		scale <1,1.5,1>
		translate y*-2
	}
	// legs
	sphere { < 2.5,-2.2,   0> .4 }
	sphere { <   0,-2.2, 2.5> .4 }
	sphere { <-2.5,-2.2,   0> .4 }
	sphere { <   0,-2.2,-2.5> .4 }

	translate y*-1
	#if (HiQuality)
		texture { T_Chrome_4A }
		normal { dents scale <.01,100,.01> bump_size .1 }
	#else
		pigment { Grey }
	#end
}
#end


// --- Main macro to make a heating candle (i.e. "vrmeljus") ---

// Is_Final		= boolean if high quality is wanted
// Unused		= boolean if the candle never has been lit
// With_Flame	= boolean if flame is visible
// Light		= boolean if light emitts from the flame
// Hot			= boolean if vapors above the flame
//
#macro Varmeljus(Is_Final, Unused, With_Flame, Light,Hot)
union
{
	#local CandleColor = rgb <247/255,233/255,232/255>;

	// sort out the strangest fenomenon
	#if (Unused & (With_Flame | Light | Hot))
		#local Unused = false;	// not unused if lit!
	#end

	#if (With_Flame)
		#if (Light)
			light_source { 0 color CandleColor area_light x*.1 y*3 2 8 adaptive 0 jitter fade_distance 12 fade_power 2 looks_like { Flame() } }
		#else
			object { Flame() }
		#end
	#end
	#if (Hot)
		object { Heat() }
	#end
	object { Wick(Unused,With_Flame) no_shadow }
	object { Candle(Unused) }
	object { Candle_casing(Is_Final) }

	translate y*3.6
	scale (3.05/3.8)	// last minute adjustment
}
#end


#end	// ifdef
