
#include "colors.inc"
#include "glass.inc"
#include "woods.inc"
#include "textures.inc"

#declare Teapot_Texture = texture {
   pigment { Red }
   finish {
      phong 1.0
      phong_size 100
      ambient 0.15
      diffuse 0.8
   }
}
#declare Teapot_Orientation = <-90, 0, 0>
#declare Teapot_Scale = 0.1
#declare Teapot_Translate = <0.55,1,0.25>


camera
{
    location <0.75,2,-3> //FINAL
    look_at   <0.0 , 0.0 , 0.0> //FINAL

//    location  <-0.2, 1.1, -0.5>//DEBUG
//    look_at   <-0.2,1.1,0.7> //DEBUG


}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <4, 6, -5>
}

//*****************************************************
//*                   OBJECTS                         *
//*****************************************************

//Room
#declare R = union {
       plane {y, -1
              pigment { checker Black, White
                        scale 0.3}}
       plane {y, 10}
       plane {z, 1

//       texture { pigment { image_map {gif "wall2.gif"}}}

       texture { pigment { color Cyan}}
            }
}//R

// Oven
#declare oR = 0.05
#declare O1 = difference { union {
      box {<-1,-1,-1>,<1,1,1>}       // Square
      box {<-1,-1,0.75>,<1,1.4,1>}   // Back
      cylinder {<1,1-oR,1>,<1,1-oR,-1>, oR}
      cylinder {<-1,1-oR,-1>,<1,1-oR,-1>, oR}
      sphere {<1,1-oR,-1>, oR}


      #declare dDepth = -1                      //Door Defs
      #declare dC = 0.25
      #declare dT = 0.75
      #declare dB = -0.5
      #declare dL = -0.75
      #declare dR = -dL
      cylinder {<dL,dB,dDepth>,<dR,dB,dDepth>, oR} //Door
      cylinder {<dR,dB,dDepth>,<dR,dT,dDepth>, oR}
      cylinder {<dL,dB,dDepth>,<dL,dT,dDepth>, oR}
      cylinder {<dL,dT,dDepth>,<dR,dT,dDepth>, oR}
      sphere {<dL,dT,dDepth>,oR}
      sphere {<dR,dT,dDepth>,oR}
      sphere {<dL,dB,dDepth>,oR}
      sphere {<dR,dB,dDepth>,oR}

      #declare dC2 = 0.1
      sphere {<dL+dC2, dT-dC2, dDepth-dC2>,oR}   // Part of Handle
      sphere {<dR-dC2, dT-dC2, dDepth-dC2>,oR}
      cylinder {<dL+dC2, dT-dC2, dDepth-dC2>,<dL+dC2, dT-dC2, 0>,oR}
      cylinder {<dR-dC2, dT-dC2, dDepth-dC2>,<dR+dC2, dT-dC2, 0>,oR}
      box {<dL,dB,dDepth-oR>,<dR,dT,dDepth>}     // Part of Door
      no_shadow
}

      box {<dL+dC,dB+dC,-5>,<dR-dC, dT-dC,-0.9>} // Negative Object
      no_shadow
      texture {pigment { White } finish { phong 1.0 phong_size 100 reflection 0.02 ambient 0.15 diffuse 0.8 }}}

//Handle
#declare H = union {
cylinder {<dL+dC2, dT-dC2, dDepth-dC2>,<dR-dC2, dT-dC2, dDepth-dC2>, oR/2
         texture {pigment {color Black}}
         }
box {<dL+dC,dB+dC,dDepth>,<dR-dC, dT-dC,dDepth+0.1> // Glass
texture { T_Glass4 }
        }
}

// Element not included in Oven definition, must be placed
#declare E = height_field { gif "polar.gif"
  water_level 0.01
  texture {pigment {color Black}}
  translate <0.25,0,-0.1>
  scale <0.75,1,0.75>
  no_shadow
}
#declare Ctrl = union {
         cylinder {<0.5,1.2,0.75>, <0.5,1.2,0.7>, 0.1
            texture { pigment { White } finish { phong 1.0 phong_size 100 reflection 0.01 ambient 0.15 diffuse 0.8 }}
         }
         cylinder {<0.5,1.2,0.7>, <0.5,1.299,0.7>, 0.01
                  texture {pigment {color Black}}
                  no_shadow
         }
         }


// OVEN ALL PUT TOGETHER
#declare Oven = union {
         object {O1}
         object {H}

         object {Ctrl
                 translate <-0.15,0,0>}
         object {Ctrl
                 translate <0.15,0,0>}
         object {Ctrl
                 translate <-1-0.15,0,0>}
         object {Ctrl
                 translate <-1+0.15,0,0>}


         #declare eH = 1     //Element Height
         #declare eS = 0.8     //Scale Value of Smaller Element

         #declare eT = 0     //Element Top
         #declare eB = -0.85 //Element Bottom
         #declare eL = -1.1    //Element Left
         #declare eR = 0     //Element Right

         object { E
           translate <eR+0.1,eH,eT+0.1>  // TopRight
           scale<eS,1,eS>
           }
         object { E
           translate <eL,eH,eT> // TopLeft
           }
         object { E
           translate <eR,eH,eB>  // BottomRight
           }
         object { E
           translate <eL-0.1,eH,eB-0.1> // BottomLeft
             scale<eS,1,eS>
             }
}//End Oven

//CounterTop
#declare cTop = union {
      box {<-10,0.9,-1>,<-1.1,1,1>}                // Left
      cylinder {<-2,0.95,-1>, <-1.1,0.95,-1>, 0.05}
      cylinder {<-1.1,0.95,-1>, <-1.1,0.95,1>, 0.05}
      sphere {<-1.1,0.95,-1>, 0.05}

      box {<1.5,0.9,-1>,<2,1,1>}                // Right
      cylinder {<1.1,0.95,-1>, <2,0.95,-1>, 0.05}
      cylinder {<1.1,0.95,-1>, <1.1,0.95,1>, 0.05}
      sphere {<1.1,0.95,-1>, 0.05}
      pigment {color Brown}
}

#declare CounterTop = union {
         object { cTop }
                                                    // Left Lower Cupboards
         box {<-10,-1,-1>,<-1.1, 1, 1>
         pigment {color Brown}
           }
                                                    // Right Lower Cupboards
         box {<1.1,-1,-1>,<10, 1, 1>
         pigment {color Brown}
           }
         }


//*****************************************************
//*                      SCENE                        *
//*****************************************************

object { R }

object { Oven }

#include "teapot.inc"

object { CounterTop }

//Clock
//box {<-0.2,1.1,0.7>, <0.2,1.3,0.71> //FINAL
box {<0,1.1,0.7>, <0.4,1.3,0.71> //TEMP
    no_shadow
    pigment {image_map {gif "clock"}}
    translate <-0.2,0,0>
    }
//Top of oven
union {
box {<-1,1.4,0.7>,<1,1.5,1>}
cylinder {<-1,1.45,0.7><1,1.45,0.7>,0.05}
    pigment {color Black}
    no_shadow
    }


