#include "kolors.inc" #include "mestex.inc" #include "metals.inc"

camera {location <50,20,24> direction <0,0,1.5> look_at <0,20,9>}
//camera {location <50,20,24> direction <0,0,10> look_at <0,10,16>}

//for final render, everything must be "on"

#declare TasseSwitch=on          //Cup of tea
#declare LoupeSwitch=on          //Magnifying Glass
#declare AreaSwitch=off          //area lights
#declare HPSwitch=off            //speaker holes in monitor
#declare ScreenMapSwitch=on      //image on the screen
#declare MoniSwitch=on           //monitor
#declare PlinthSwitch=on         //wooden plinth
//=============================================================================
//      LITTLE SPOTLIGHT
//=============================================================================
union {
  light_source {0 rgb <1,1,.9>*2
  #if (AreaSwitch=on) area_light x*20,z*20,4,4 adaptive 0 jitter #else #end
   fade_distance 30 fade_power 1
               }
 cone {<.1,0,0>,4,<.5,0,0>,3.8}
 cone {<1.5,0,0>,2.5,<.5,0,0>,3.4}
 cone {<1.5,0,0>,1,<3.5,0,0>,2.5}
 cylinder {<.5,3,0>,<.5,30,0>,.2}
 pigment {Gray70}
 finish {phong .8 metallic reflection .2}
 normal {bumps .1 scale .5}
 rotate y*-20 translate <-20,35,30>
}
//=============================================================================
//      PRE-DEFINITIONS
//=============================================================================
#declare BefSkew=union {
                   cylinder {<-14,0,-14>,<-14,10,-14>,.5}
                   cylinder {<14,0,-14>,<14,10,-14>,.5}
                   cylinder {<-14,0,14>,<-14,10,14>,.5}
                   cylinder {<14,0,14>,<14,10,14>,.5}
                   box {<-14.5,0,-14>,<14.5,10,14>}
                   box {<-14,0,-14.5>,<14,10,14.5>}
                   }

#declare AfSkew1=object {BefSkew matrix <1,0,0,.2,1,.2,0,0,1,0,0,0>}
#declare AfSkew2=object {BefSkew matrix <1,0,0,-.2,1,-.2,0,0,1,0,0,0>}

#declare TrouMatrice=union {
 #declare boucle =0;
 #while (boucle < 7)
    #declare boucle2=0;
    #while (boucle2 < 7)
       cylinder {<0,boucle*.5,boucle2*.5>,<10,boucle*.5,boucle2*.5,>,.2}
       #declare boucle2=boucle2+1;
    #end
    #declare boucle=boucle+1;
 #end
rotate x*-20
}
//=============================================================================
//      TABLE WHERE SITS THE MONITOR
//=============================================================================
box {<15,0,-40>,<-45,-3,40> pigment {Tan} finish {specular .4 reflection .3} normal {crackle .1 scale .3}}
//=============================================================================
//      CUP OF TEA
//=============================================================================
#if (TasseSwitch=on)
#declare TasseThe=union {
 difference {
  cylinder {<0,1.2,0>,<0,6,0>,4.2}
  cylinder {<0,1,0>,<0,6.2,0>,3.8}
            }
 difference {
  cylinder {<0,.2,0>,<0,2.5,0>,4}
  torus {2.8 1 translate y*2.5}
  torus {4 1 translate y*0}
  cylinder {<0,1.5,0>,<0,2.6,0>,2.8}
            }
union {
 torus {.3 .03 rotate x*90 translate <4,6,0> clipped_by {plane {y,0 inverse}}}
 cylinder {<4.3,6-.3,0>,<4.3,4,0>,.03}
 box {<0,0,0>,<3,3,.01> pigment {image_map {png "povtea"} scale <3,3,1>}
 rotate y*-90 translate <4.3,1,-1.5> finish {ambient .6}}
 pigment {White}
  }

difference {
 #declare LiquidLevel=5
  cylinder {<0,1.4,0>,<0,LiquidLevel,0>,4}
  torus {3.6 .2 translate y*LiquidLevel}
  cylinder {<0,LiquidLevel-.2,0>,<0,LiquidLevel+.3,0>,3.6}
  pigment {Orange*.8 filter .6}
  finish {phong .7 reflection .15}
  normal {bumps .05 scale 1}
}

torus {4 .2 translate y*6}
torus {4 .2 translate y*1.2}
torus {2.8 .2 translate y*.2}

union {
 difference {
        cylinder {<.2,0,0>,<-.2,0,0>,.5}
        torus {.5 .2 rotate z*90 translate x*.2}
             translate y*1.25
             }
 difference {
        cylinder {<.2,0,0>,<-.2,0,0>,.5}
        torus {.5 .2 rotate z*90 translate x*.2}
             translate y*-1.25
             }
 torus {1.25 .3 rotate x*90 clipped_by {plane {x,0 inverse}} translate x*.8}
 cylinder {<0,-1.25,0>,<.8,-1.25,0>,.3}
 cylinder {<0,1.25,0>,<.8,1.25,0>,.3}
 scale <1,1,1.5> translate <4.2,4,0> rotate y*-90
}

pigment {White}
finish {phong .8 reflection .1}
normal {bumps .05 scale 3}

//clipped_by {plane {x,0}}

scale <1,1,1>
}

object {TasseThe translate <-15,0,25>}

#else
#end

//=============================================================================
//      PLINTH
//=============================================================================
#if (PlinthSwitch=on)
#declare BasePlinthe=union {
        box {<0,0,0>,<3,15,1>}
        cylinder {<3,.5,0>,<3,.5,1>,.5}
        difference {
                box {<3,.5,0>,<4,1.5,1>}
                cylinder {<4,.5,-.1>,<4,.5,1.1>,.5}
                }
        cylinder {<4,1.25,0>,<4,1.25,1>,.25}
        box {<3,1.25,0>,<4.25,3,1>}
        cylinder {<4,3,0>,<4,3,1>,.25}
        difference {
                box {<4,3,0>,<3,4.25,1>}
                cylinder {<4,4.25,-.1>,<4,4.25,1.1>,1}
                }
        difference {
                union {
                        box {<3.75,9.25,0>,<3,14.5,1>}
                        box {<4.75,13.25,0>,<3,11,1>}
                        box {<3,13.25,0>,<4.25,14,1>}
                        box {<3,13.25,0>,<3.75,14.5,1>}
                        }
                cylinder {<3.75,9.25,-.1>,<3.75,9.25,1.1>,.75}
                cylinder {<4.25,14,-.1>,<4.25,14,1.1>,.25}
                cylinder {<3.75,14.5,-.1>,<3.75,14.5,1.1>,.25}
                }
        cylinder {<3,14.5,0>,<3,14.5,1>,.5}
        cylinder {<3.75,14,0>,<3.75,14,1>,.25}
        cylinder {<4.25,13.25,0>,<4.25,13.25,1>,.5}
        cylinder {<3.75,11,0>,<3.75,11,1>,1}
}

#declare r1=seed(0)
#declare Lamelle=union {
                    box {<0,10,0>,<1.8,-70,9>}
                    box {<0,10,10>,<1.2,-70,9>}
                    translate x*-50
                    }
#declare boucle=0;
#while (boucle < 15)
  object {
        Lamelle
        translate z*(-70+(boucle*10))
        texture {
          T_Wood23 scale 5 rotate x*90 finish {phong .3 reflection .05}
          translate <rand(r1)*10,rand(r1)*10,rand(r1)*10>
          rotate <rand(r1)*10,rand(r1)*10,rand(r1)*10>
                }
   }
#declare boucle=boucle+1;
#end

object {BasePlinthe
        scale <1,1,120> translate <-50,10,-80>
        texture {T_Wood23 scale 5 finish {phong .3 reflection .05}}
        }
#else
#end
//=============================================================================
//      MAGNIFYING GLASS4
//=============================================================================
#if (LoupeSwitch=on)

#declare MancheLoupe=union {
cylinder {<0,-3,0>,<0,-14,0>,.6
          texture {T_Wood24 scale 1 rotate x*85
          finish {phong .2 specular .4 reflection .2}
          normal {dents .1 scale .2}}
          }
cylinder {<0,-3,0>,<0,0,0>,.55}
cylinder {<0,-3,0>,<0,-2.7,0>,.7}
torus {.65 .05 translate y*-2.7}
torus {.6 .1 translate y*-2.7}
cylinder {<0,0,0>,<0,-.8,0>,.8}
torus {.7 .1 translate y*-.8}
cylinder {<0,0,0>,<0,-.1,0>,.7 translate y*-1}
cylinder {<0,0,0>,<0,-.1,0>,.6 translate y*-1.2}
cylinder {<0,0,0>,<0,-.1,0>,.6 translate y*-1.4}
cylinder {<0,0,0>,<0,-.1,0>,.6 translate y*-1.6}
cylinder {<0,0,0>,<0,-.1,0>,.81 translate y*-.5}

texture {T_Brass_4D}
}

#declare CercleLoupe=
union {
 difference {
  cylinder {<0,-.7,0>,<0,.7,0>,3.6}
  cylinder {<0,-.8,0>,<0,.8,0>,3.4}
  torus {7 3.57}
        }
 torus {3.45 .05 translate y*-.7}
 torus {3.45 .05 translate y*.7}
 sphere {<0,0,0>,3.4 scale <1,.3,1>
  pigment {MediumAquamarine transmit .9}
  finish {phong .4 phong_size 25 reflection .1 ior 1.5}
         }
 cylinder {<0,0,0>,<0,.01,0>,3.4
           pigment {
                image_map {
                        png "povtea.png"}
                                rotate x*90 translate <-.5,0,-.5>
                                rotate y*-90 scale <6.8,1,6.8*(4/3)>
                                rotate y*-40
                   }
        finish {ambient 1 diffuse 0}
        no_shadow
        }

texture {T_Brass_5B}
}

#declare Loupe=union {
object {CercleLoupe}
object {MancheLoupe rotate z*90 translate x*3.5}
}

object {Loupe
        rotate <80,90,10> rotate x*-50 rotate y*-20
        translate <35,22,16.5>
        }

#else #end
//=============================================================================
//      MONITOR'S FOOT
//=============================================================================
#declare PiedMonit=union {
 cylinder {<0,0,0>,<0,.8,0>,10}
 torus {10 .2 translate y*.4}
 cylinder {<0,0,0>,<0,.9,0>,9.5}
 cone {<0,0,0>,9.5,<0,1.5,0>,7}
 difference {
        cone {<0,0,0>,8.5,<0,3,0>,6.5}
        cone {<0,1,0>,5,<0,4,0>,6.5}
        }
 sphere {<0,4,0>,6}
}
//=============================================================================
//      THE MONITOR
//=============================================================================
#if (MoniSwitch=on)
#declare Moniteur=union {

//maintenant, l'arriere :

intersection {
 cylinder {<-10,9,0>,<-10,39,0>,16 scale <1.3,1,1>}
 cylinder {<-30,0,30>,<-30,40,30>,20 inverse}
 cylinder {<-30,0,-30>,<-30,40,-30>,20 inverse}
 plane {y,0 rotate z*-30 translate y*5 inverse}
 plane {x,-10}
 cylinder {<-10,-40,30>,<-10,-40,-30>,78}
}


sphere {<2.5,6.5,0>,1.5 pigment {LightBlue filter .5}}
sphere {<2.5,6.5,0>,1.25 pigment {LightBlue filter .8}}
sphere {<2.5,6.5,0>,1 pigment {Green*1.5 filter .6}}

light_source {<2.5,6.5,0> White*2 fade_distance 1 fade_power 3}

//torus {17 .1 translate <-13.5,12,0> pigment {Green*2}}

difference {
 union {
  intersection {
        box {<0,9,-18>,<-10,39,18>}
        cylinder {<0,0,0>,<0,40,0>,100 translate x*-100}
        cylinder {<0,0,0>,<-50,0,0>,100.3 translate y*-90 inverse}
        torus {100 .1 translate <-100,35.5,0> inverse}
        torus {100 .1 translate <-100,12,0> inverse}
        cylinder {<0,0,0>,<0,50,0>,20 translate x*-10.8}
                }

        height_field {png "pxl_hf1"
                        scale <2.2*2,.2,.7*2> rotate <-90,-90,0> translate z*-2.2
                        translate x*100 rotate y*-8.5 translate x*-100.1
                        translate y*10
                        //pigment {Red*2}
                        }

  intersection {
        cone {<-21,0,0>,35,<-2,30,0>,2}
        cone {<10,40,0>,60,<-25,20,0>,2}
        cone {<10,8,0>,2,<-5,6,0>,0 inverse}
        torus {17 .2 scale <.96,.5,1> translate <-13.3,12,0> inverse}
        #if (HPSwitch=on)
         object {TrouMatrice inverse translate <0,7,5>}
         object {TrouMatrice inverse scale <1,1,-1> translate <0,7,-5>}
        #else #end
                }
       }

intersection {object {AfSkew1} object {AfSkew2}
scale <.8,2,.8*(4/3)>rotate z*90 translate <5,34-10,0>
}

}

intersection {
        box {<0,9,-18>,<-10,39,18>}
        cylinder {<0,0,0>,<0,40,0>,100 translate x*-102}

#if (ScreenMapSwitch=on)

  pigment {
        image_map {png "povtea" once filter all .1}
        scale <14.5+14.5,35-13,1>
        rotate y*-90 translate <0,13,-14.5>
        }
  finish {ambient .7 phong .7 reflection .1}
  no_shadow

#else
pigment {LightBlue}
#end
} //monitors' screen

#if (ScreenMapSwitch=on)
 light_source {<-9,25,0> SkyBlue/3}
#else #end

 pigment {rgb <.929,.906,.918>}
 finish {phong .6 specular .1 phong_size 25}
 normal {bozo .01 scale .02}
}

object {Moniteur rotate z*10}
object {PiedMonit translate x*-10 pigment {rgb <.929,.906,.918>}}

#else #end
//=============================================================================
//      ROOM
//=============================================================================
box {<-50,-70,-160>,<350,250-70,160> pigment {White}}
//=============================================================================
//      ENVIRONNEMENT
//=============================================================================

union {
  height_field {gif "taplein" rotate <0,-90,-90>
                scale <1,10,110> translate <-50,25,-65>}

box {<-49.9,-71,-159.9>,<349.9,250-69,159.9>}
     texture { checker
                texture {
                        pigment {
                                checker
                                color SteelBlue
                                color SteelBlue/2 scale .1
                                }
                        }
                texture {
                        pigment {
                                checker
                                color SteelBlue*1.2
                                color SteelBlue*.7 scale .1
                                }
                        }
                scale 10
                }
}

//=============================================================================
//      ENVIRONNEMENT
//=============================================================================
light_source {<100,100,100> Wheat*.7
#if (AreaSwitch=on)
 area_light x*50,z*50,3,3 jitter adaptive 0
#else #end
}

global_settings {max_trace_level 35}
