#include "chem_text.inc"   //Textures

#declare Jar_Outer =
intersection{
  blob {
    threshold .5
    sphere{ < 0, 4.6, 0>, 0.8, 2.0}
    cylinder{ < 0, 0, 0>, < 0, 7, 0>, 1.0, 1.2 }
    sphere{ < 0, 0.4, 0>, 1.25, -1.1 scale< 1, 0.3, 18>}
    sphere{ < 0,   0, 0>, 1.5, 1.7 scale< 1, 0.4, 1>}
    scale 1.6
  }
  plane{
    y, -0.2
    inverse
  }
  plane{
    y, 7.0
  }
  translate< 0, 0.2, 0>
}

#declare Jar_Inner =
intersection{
  blob {
    threshold .5
    sphere{ < 0, 5.66, 0>, 0.8, 2.0}
    cylinder{ < 0, 0.7, 0>, < 0, 7, 0>, 1.0, 1.2 }
    scale 1.3
  }
  plane{
    y, 0.0
    inverse
  }
  plane{
    y, 8.0
  }
}

//Jar height is 7.3 with torus bit
#declare Jar =
merge{
  intersection{
    object{
      Jar_Inner
      inverse
    }
    object{ Jar_Outer}
  }
  torus{
    0.95, 0.1
    translate< 0, 7.2, 0>
  }
  texture{ Glass}
}

#declare Jar_Water =
intersection{
  cylinder{
    <0, 0, 0>, < 0, 8, 0>, 2
    texture{ Water}
  }
  object{
    Jar_Inner
    texture{ Glass}
  }
  plane{
    y, 7.3
    texture{ Water}
  }
  plane{
    y, 3.0
    inverse
    texture{ Water}
  }
}

//_______________________________
//
//Jar bubbles

#declare r1 = seed(0)
#declare r2 = seed(12345)
#declare r3 = seed(54321)
#declare r4 = seed(9430)
#declare r5 = seed(65956)
#declare ybot = 1.68+0.2
#declare ytop = 5.98-0.2
#declare nsph = 7
#declare ravg = 0.2
#declare i=0

#declare Bubbles =
union{
  #while (i < nsph)
    #declare u1 = rand( r1)
    #declare u2 = rand( r2)
    #declare u3 = rand( r3)
    #declare u4 = rand( r4)
    #declare u5 = rand( r5)
    #declare g1 = sqrt(-2*log(u1))*cos(2*pi*u2)   //Gaussian random numbers
    #declare g2 = sqrt(-2*log(u1))*sin(2*pi*u2)
    #declare g3 = sqrt(-2*log(u4))*cos(2*pi*u5)
    #declare g4 = sqrt(-2*log(u4))*sin(2*pi*u5)
    #declare r  = ravg + 0.01*g3
    #declare h  = (ybot) + i*(ytop-ybot)/(nsph-1) //evenly spaced
    #declare h  = h+0.2*g4                        //add Gaussian
    #if( h > ytop)                                //Check out if out of water
      #declare h = ytop
    #end
    #if( h < ybot)
      #declare h = ybot
    #end

    sphere{                                       //1st bubble is centred on y=z=0
      #if( i = 0)
        < 0, h, 0>, r
      #else
        < 0.1*g1, h, 0.1*g2>, r
      #end
    }

    #declare i=i+1
  #end
  texture{ Water finish{ ior 1.0}}
}

#declare Jar_Lid =
cylinder{
  < 0, 0, 0>, < 0, 0.1, 0>, 1.5
  texture{
    Ground_Glass
  }
}
