// Author: Frank Epple.
// Use FAST_RENDER for previews of the scene with less details.

//#declare FAST_RENDER = 1

#include "colors.inc"
#include "stones.inc"
#include "spheres.inc"
#include "greek.inc"

global_settings { max_trace_level 15 }

// ----------------------------------------------------------------------------------------
// Material declarations
// ----------------------------------------------------------------------------------------

#declare P_Cloud2 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 color red 0.55 green 0.55 blue 0.95]
        [0.1 color red 0.75 green 0.75 blue 0.75]
        [0.5 color rgb <0.99, 0.99, 0.99>]
    }
    scale <6, 1, 6>
}
#declare P_Cloud3 =
pigment {
    bozo
    color_map {
        [0.0 color red 0.3 green 0.3 blue 0.85]
        [0.1 color red 0.5 green 0.5 blue 0.95]
        [0.5 color rgb <0.88, 0.88, 0.88>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

#declare SKY_TEXTURE =
texture {
    pigment {
        gradient y
        pigment_map {
            [0.02 rgb <0.347, 0.349, 0.87> ] // horizon
            [0.04 rgb <0.447, 0.449, 0.87> ] // horizon
            [0.25 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}

#declare Rocktext = pigment {
  granite
  color_map {
    [0.00 rgb <0.2,0.25,0>]
    [0.30 rgb <1,0.85,0.8>]
    [0.7 rgb <1,0.85,0.8>]
    [1.00 rgb <1,1,1>]
    }
  scale 1
  }

#declare Rocktext2 = pigment {
  bozo
  color_map {
    [0.25 rgbt <1,1,1,1>]
    [0.375 rgbt <1,1,1,0.3>]
    [0.5 rgbt <1,1,1,1>]
    [0.625 rgbt <0,0,0,1>]
    [0.75 rgbt <0,0,0,0.7>]
    [1 rgbt <0,0,0,1>]
    }
  scale 50
  }

#declare GRAY_ROCK = texture
{
  pigment
    {
      bozo
      color_map
        {
          [0.05 color rgb<0.5, 0.5, 0.5>]
          [0.30 color rgb<0.4, 0.4, 0.4>]
          [0.70 color rgb<0.8, 0.8, 0.8>]
          [0.80 color rgb<0.9, 0.9, 0.9>]
          [1.00 color rgb<0.8, 0.8, 0.8>]
        }
      scale 0.03
    }
  normal
    {
      bumps 1
      scale 0.9
    }
  finish
    {
      ambient 0.4
      diffuse 0.6
    }
}

#declare LANDSCAPE_TEXTURE =
texture { pigment {Rocktext} scale 0.01 }// rocks
texture { pigment {Rocktext2} scale 0.01 }
texture { // grass
  pigment
    {
      granite
      color_map {
        [0.05 color rgbt<0,1,0,0.0>]
        [0.10 color rgbt<0,1,0,0.4>]
        [1.00 color rgbt<1,1,1,1.0>]
        }
      scale 0.02
    }
  }  // end texture

#declare GRASS_TEXTURE =
texture
{
  pigment
    {
      bozo
      color_map
        {
          [0.05 color rgb<0.9, 0.9, 0.8>]
          [0.25 color rgb<0.9, 0.9, 0.7>]
          [0.40 color rgb<0.8, 0.8, 0.6>]
          [0.80 color rgb<0.7, 0.7, 0.5>]
          [1.00 color rgb<0.6, 0.6, 0.4>]
        }
      scale 0.005
    }
  finish
    {
      ambient 0.4
      diffuse 0.6
    }
}  // end texture

#declare SAND_TEXTURE =
texture
{
  pigment
    {
      bozo
      color_map
        {
          [0.05 color rgb<0.9, 0.9, 0.9>]
          [0.25 color rgb<1.0, 1.0, 1.0>]
          [0.40 color rgb<0.9, 0.9, 0.8>]
          [0.80 color rgb<0.9, 0.9, 0.7>]
          [1.00 color rgb<0.9, 0.8, 0.7>]
        }
      scale 0.005
    }
  finish
    {
      ambient 0.4
      diffuse 0.6
    }
}  // end texture

// ----------------------------------------------------------------------------------------
// Parameters
// ----------------------------------------------------------------------------------------

#declare Pod_H = 1

#declare TEMPLE_HEIGHT   = 10                                   
#declare TEMPLE_POSITION = <500,TEMPLE_HEIGHT,500>
#declare TEMPLE_ROTATION = -95

// ----------------------------------------------------------------------------------------
// SCENE
// ----------------------------------------------------------------------------------------

//camera { location CAM_POSITION + <-18*sin(radians(CAM_ROTATION)), 0,-18*cos(radians(CAM_ROTATION))> up <0,  1,  0> look_at CAM_POSITION + <0, -3,0> }    // Scene camera: Competition
//camera { location <750, 600, 750> look_at   < 0, 0, 0> }    // Scene camera: Landscape
//camera { location <0, 2000,0> up <0,  1,  0> look_at <0, 0,0> }    // Scene camera: Upside
//camera { location < 7, 6, -10> up <0,  1,  0> look_at <0, 5, 0> }  // Test camera for Temple on <0,0,0>
//camera { location < 50, 13, 25> up <0,  1,  0> look_at <0, 10, 25> }  // Test camera for Temple Side
//camera { location TEMPLE_POSITION + <35*sin(radians(TEMPLE_ROTATION-215)),35,35*cos(radians(TEMPLE_ROTATION-215))> look_at TEMPLE_POSITION + <0,6,0> }    // Scene camera: Test
camera { location TEMPLE_POSITION + <12.2*sin(radians(TEMPLE_ROTATION-215)),6,12.2*cos(radians(TEMPLE_ROTATION-215))> look_at TEMPLE_POSITION + <0,5,0> }    // Scene camera: Contest
//camera { location TEMPLE_POSITION + <12.2*sin(radians(TEMPLE_ROTATION-260)),6,12.2*cos(radians(TEMPLE_ROTATION-260))> look_at TEMPLE_POSITION + <0,5,0> }    // Scene camera: Side

light_source
  {
    <700,700,2000>
//    color rgb <1,0.925,0.8>
    color rgb <1,0.9,0.7>
    //rgb 1
  }

#ifndef (FAST_RENDER)
  fog 
    {
      rgbt <0.9, 0.9, 0.9, 0.2> // 20% are always visible.
      distance 700
      turbulence 0.2
      turb_depth 0.3
      fog_type 2
      fog_offset 25
      fog_alt 5
    }
#end

sphere
{
  <0,0,0>
  4000

  texture
    {
      SKY_TEXTURE

      scale 2000
    }

  finish { ambient 1.0 diffuse 0.0 }

  hollow
}

#declare TEMPLE_SPHERES =
union
{
  #ifndef (FAST_RENDER)
  object
    {
      BOWL
      scale 2
      rotate <0,15,0>
      translate <-5, Pod_H, -5>
    }

  object
    {
      BOWL
      scale 2
      rotate <0,-15,0>
      translate <-5, Pod_H,  5>
    }

  object
    {
      BOWL
      scale 2
      rotate <0,60,0>
      translate < 5, Pod_H,  5>
    }

  object
    {
      BOWL
      scale 2
      rotate <0,30,0>
      translate < 5, Pod_H, -5>
    }

  object
    {
      SPHERE_WATER
      scale 2
      translate <-5,Pod_H+0.1+4,-5>
    }

  object
    {
      SPHERE_AIR
      scale 2
      translate <-5,Pod_H+0.1+4,5>
    }

  object
    {
      SPHERE_EARTH
      scale 2
      translate < 5,Pod_H+0.1+4,-5>
    }

  object
    {
      SPHERE_FIRE
      scale 2
      translate < 5,Pod_H+0.1+4,5>
    }

  #end

  difference
  {
    cylinder {<0.0, 0.0, 0.0> <0.0, 1.0, 0.0> 10.0}

    cylinder
      {
        <0, -0.1,   0>
        <0, 1.1, 0>
        5
      }

    texture { MATERIAL_SAEULE }
  }

  #ifndef (FAST_RENDER)
  disc
    {
      <0,0.7,0>
      y
      5

      texture
        {
          pigment { color rgb< 0.1, 0.3, 0.2 > }
          normal { bumps 0.2  scale < 0.3, 0.15, 0.15 > }
          finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
        }
    }
  #end
}

#declare TEMPLE_BUILDING = union
{
  box
  {
    <-7,0,-2>
    < 7,1,18>
    texture {MATERIAL_SAEULE}
  }
  box
  {
    <-7,SAEULE_HEIGHT+1, 0>
    < 7,SAEULE_HEIGHT+1.5,18>
    texture {MATERIAL_SAEULE}
  }

  object
  {
    SAEULE
    translate <-5, 1, 0>
  }
  object
  {
    SAEULE
    translate <-5, 1, 4>
  }
  object
  {
    SAEULE
    translate <-5, 1, 8>
  }
  object
  {
    SAEULE
    translate <-5, 1, 12>
  }
  object
  {
    SAEULE
    translate <-5, 1, 16>
  }

  object
  {
    SAEULE
    translate <5, 1, 0>
  }
  object
  {
    SAEULE
    translate <5, 1, 4>
  }
  object
  {
    SAEULE
    translate <5, 1, 8>
  }
  object
  {
    SAEULE
    translate <5, 1, 12>
  }
  object
  {
    SAEULE
    translate <5, 1, 16>
  }

  object
  {
    FRONT
    scale 0.7
    translate <0,SAEULE_HEIGHT+1,0.7*1.5>
  }

#ifndef (FAST_RENDER)
/*  object
    {
      SPHERE_FIFTH
      scale 3.7
      translate < 0,6,8>
    }
*/
#end
}

#declare TEMPLE = union
{
  object
  {
    TEMPLE_SPHERES
    scale 0.5
    translate <0,0,0>
  }

  object
  {
    TEMPLE_BUILDING
    translate <0,0,15>
  }

//  #ifndef (FAST_RENDER)
    // The plates, where the temple is standing on:
    difference
    {
      union
        {
          #declare X = 0
          #while (X<20)
            #declare Y = 0
            #while (Y<48)
              box
                {
                  <-10.0 + X, 0.2, -7.0 + Y>
                  < -8.1 + X, 0.0, -5.1 + Y>
                }
            #declare Y = Y + 2
            #end
          #declare X = X + 2
          #end
        }

      cylinder {<0.0, -0.1, 0.0> <0.0, 1.0, 0.0> 5.1}  // Subtracting the cylinder from the bowls...

      box // ...and the box of the temple.
        {
          <-7.1,-0.1,-2.1  + 14.7>
          < 7.1, 1.0, 18.1 + 14.7>
        }

      texture { MATERIAL_SAEULE } //T_Stone17 }
    }

    box
    {
      <-10.0, 0.15, -7.0>
      < 10.0, 0.00, 32.0>

      texture { SAND_TEXTURE }
    }
//  #end
}

#declare PLATFORM = union
{
  prism {
    conic_sweep
    quadratic_spline
    0.85,1.0
    13
    <-1.96517, -0.509388>,
    <-1.653061, -0.632653>,
    <-0.959184, -0.445578>,
    <-0.264626, -1.061395>,
    <0.548707, -1.417789>,
    <1.122449, -1.0>,
    <1.639456, -0.496599>,
    <1.938776, 1.013605>,
    <-2.217687, 1.183673>,
    <-1.993605, 0.526803>,
    <-2.144218, -0.035374>,
    <-1.96517, -0.509388>,
    <-1.653061, -0.632653>

    translate<0,-0.85,0>    // Set to water level
    scale <15,10/0.15,16>   // Scale to fit exactly under temple-scene
    translate <17,0,-7>    // Translate to the middle of the temple-scene
    rotate <0,0,180>        // Prism must be flipped...
    rotate <0,90,0>         // and rotated by 90 degrees.

    texture { GRASS_TEXTURE }
  }

  blob
    {
      threshold 0.600000
      component 1.000000, 1.422823, <-0.004202, 0.033248, 0.000000>
      component 1.000000, 0.377772, <0.456201, 0.322251, 0.577744>
      component 1.000000, 0.382103, <-0.374188, 0.000000, 0.687179>
      component 1.000000, 0.672683, <-0.076888, 0.485934, 0.332331>
      component 1.000000, 0.533380, <0.311880, 0.025575, -0.656410>
      component 1.000000, 0.670938, <0.015338, -0.547315, 0.000000>
      component 1.000000, 0.376174, <0.495940, -0.291560, 0.000000>
      component 1.000000, 0.640504, <0.270977, 0.741688, 0.000000>
      component 1.000000, 0.936166, <-0.620229, 1.130435, -0.307692>
      component 1.000000, 0.685655, <0.066466, 1.191816, 0.000000>
      component 1.000000, 0.177612, <0.393684, 1.222506, 0.000000>
      component 1.000000, 0.204337, <0.567519, 0.700767, 0.000000>
      component 1.000000, 0.198609, <0.690226, 0.046036, 0.000000>
      component 1.000000, 0.233043, <-0.567519, -0.363171, 0.000000>
      component 1.000000, 0.320266, <-0.219850, 0.905371, 0.000000>
      component 1.000000, 0.252110, <-0.608421, 0.445013, 0.000000>
      component 1.000000, 0.418255, <0.000000, 0.537084, -0.669774>
      component 1.000000, 0.245641, <0.000000, 0.649616, -0.332331>

      scale 4
      translate <-14,1,1>
      rotate <90,0,0>
      texture { GRAY_ROCK }
    }

  blob 
    {
      threshold 0.600000
      component 1.000000, 2.339375, <0.046133, 0.000000, 0.010256>
      component 1.000000, 1.249664, <1.081556, 0.000000, 0.717949>
      component 1.000000, 0.449462, <0.948284, -0.465473, -0.646154>
      component -1.000000, 0.504206, <1.235332, 0.762148, 0.051282>
      component -1.000000, 0.629791, <0.456201, 0.000000, 1.312821>
      component -2.000000, 0.623040, <1.553135, 0.000000, 1.005128>
      component -1.000000, 0.274899, <-1.040549, 0.000000, 0.564103>
      component 1.000000, 0.609643, <-0.281922, 0.557545, -0.833383>
      component -1.000000, 0.589440, <-0.025564, -0.700767, -0.215385>
      component 1.000000, 0.642144, <-0.476705, -0.557545, 0.717949>

      scale 4
      translate <-18.7,0,12>
      texture { GRAY_ROCK }
  }
}

// Putting everything into this beutiful landscape...

object
{
  PLATFORM

  rotate <0,TEMPLE_ROTATION,0>
  translate TEMPLE_POSITION
}

object
{
  TEMPLE

  rotate <0,TEMPLE_ROTATION,0>
  translate TEMPLE_POSITION
}

#declare LAND_MAX  = 200
#declare WATER_LEV = 120

#ifndef (FAST_RENDER)
height_field
  {
    gif "elem1.ghf"
    smooth
    water_level WATER_LEV/LAND_MAX

    translate <-0.5,0,-0.5>   // First translate that the middle of the landscape
                              // is in <0,0,0>
    scale <1000.0, LAND_MAX, 1000.0>

    translate <0,-WATER_LEV,0>  // Translate back to ground level.

    texture { LANDSCAPE_TEXTURE }
  }
#end

plane
{
  y,0

  texture
    {
      #ifdef (FAST_RENDER)
        pigment { color rgb< 0.4, 0.6, 1.0 > }
        finish { ambient 0.3  diffuse 0.7 }
      #else
        pigment { color rgb< 0.1, 0.3, 0.2 > }
        normal { bumps 0.2  scale < 0.9, 0.31, 0.45 > }
        finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
      #end
    }
}
