/*
** Unobtainium.POV
**   Originally created for the 'Elements' stills image IRTC for July/August 1998
**
** Galileo discovers unobtainium and the decides that it is much too dangerous
**  a substance for mankind to have and hides the discovery.
**
** Emory R. Stagmer
** Began 17-Jul-1998
*/
#declare moonlight = true;
#declare show_stars = false;    // can't see them in final viewpoint anyway - leave off
#declare show_candles = true;   // actually only show the one on the table...
#declare show_cube = true;
#declare show_hand = true;
#declare show_book = true;

#declare ft=12;
#declare mi=5280*ft;

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "stones1.inc"
#include "woods.inc"
#include "candle31.inc"
#include "handslev.inc"

#declare room_size = 10*ft; // actually that's the half size...room is 20x20

// set viewer's position in the scene

camera
    {
    location <-(4*ft+3), 5*ft+8, 5*ft>
//    location <-2.2*ft,6*ft,7*ft> // above table
//    location <-(2*ft+3), 4*ft, 3*ft+6> // at table level
    direction <0,0,1>
    sky <0,0,1>
    look_at <-2*ft,6*ft+6,3*ft> // center of table?
    }

// moonlight from outside - use area light for final
light_source
{
  <400, 6000, 5000>
  color rgb <.5,.5,.6>
#if (moonlight)
  area_light x*100 z*100 6 6
#end
}

#if (show_stars)
#include "starfld.inc"
#end

// All the stuff around the perimeter
#declare Column = union
    {
    cylinder { 0  z*10*ft 1*ft/2 }
    torus{ 1*ft/2 1.5 rotate x*90 translate z*6 }
    torus{ 1*ft/2 1.5 rotate x*90 translate z*2 }
    torus{ 1*ft/2 1.5 rotate x*90 translate z*(10*ft-6) }
    torus{ 1*ft/2 1.5 rotate x*90 translate z*(10*ft-2) }
    texture{ T_Stone14 }
    }


// Hollow room
difference
    {
    box {<-(room_size+ft),-(room_size+ft),-1> <room_size+ft, room_size+ft, 10*ft+1> }
    box {<-(room_size),  -(room_size),   0> <room_size, room_size, 10*ft>   }
    // Window cutout
    box {<-4*ft,room_size-ft,3*ft><0*ft,room_size+ft+2,7*ft>}
    texture{ T_Stone8 finish{reflection 0 phong 0} scale 1*ft }
//    hollow
    }

#declare i = -(room_size-2*ft);
#while( i < room_size-2*ft )
object {Column translate<i,room_size,0> }
//object {Column translate<i,-room_size,0> }
//object {Column translate< room_size,i,0> }
//object {Column translate<-room_size,i,0> }
#if (show_candles)
object {Candle scale 1/2*ft translate<i,room_size-1/2*ft,4*ft> }
#else
light_source{ <i,room_size-1*ft,4*ft> color Yellow fade_distance 1*ft fade_power 2  media_attenuation false}
//object {Candle scale 1*ft translate<room_size-1*ft,i,4*ft> }
#end
#declare i = i + 4*ft;
#end


// Work table
// Legs
#declare leg = box
    {
    <0,0,0> <3*ft,2,2> // along X
    texture{ T_Wood4 scale 6  }
    rotate y*-90
    translate <4,4,0>
    }

#declare top = box
    {
    <0,0,0> <2*ft, 3*ft, 1>
    texture{ T_Wood4 rotate x*90 scale 6 }
    }

union
    {
    object { leg translate <2,2,0> }
    object { leg translate <2*ft-4,2,0> }
    object { leg translate <2*ft-4,3*ft-4,0> }
    object { leg translate <2,3*ft-4,0> }
    object { top translate y*2+z*(3*ft) }
    translate x*-3*ft+y*5*ft
    finish { phong 0.1 phong_size 100 ambient 1 reflection 0.01 }
    }

// Candle on table
light_source{ <-1.5*ft,6*ft,4*ft+.5> color rgb (Yellow+White) fade_distance 1*ft fade_power 1.5 media_attenuation off }
#if (show_candles)
union
    {
    cone
        {
        <-1.5*ft,6*ft,3*ft+1> 1/3 <-1.5*ft,6*ft,3*ft+10> 1/8
        texture { pigment { color rgb (Yellow+White) } }
        finish{ phong 0 reflection 0 ambient 0.5 }
        }
    // flame - copied from candle31.inc
    cylinder
        {
        0 z .5
        hollow
        no_shadow
        texture
            {
            pigment { color Clear }
            finish { ambient 0 diffuse 0 phong 0 }
            }

        interior
            {
            media
                {
                emission 2
                density
                    {
                    spherical
                    color_map
                        {
                        [0.0 rgb <0,0,0.5>]
                        [0.2 rgb <0.8, 0.8, 0.4>]
                        [1.0 rgb <1,1,1>]
                        }
                    }
                }
            }
        scale <0.5,0.5,1.5>
        translate <-1.5*ft,6*ft,3*ft+10.1>
        }
    }

#declare candlebase = lathe
    {
    cubic_spline
    18
 <.2   ,    0          >,
 <.2   ,    .1         >,
 <.5236,   .1176   >,
 <.4294,   .5642   >,
 <.483 ,   1.0064   >,
 <.6304,   1.0406  >,
 <.6645,   1.0524  >,
 <.6699,   1.0844  >,
 <.6517,   1.078   >,
 <.6667,   1.0545  >,
 <.5545,   1.0406  >,
 <.469 ,  .9434    >,
 <.4188,   .5908   >,
 <.5106,   .1324   >,
 <.2286,   .1079   >,
 <.1859,   .0438   >,
 <.1848,   0       >,
 <.2008,   0       >
     }

object
    {
    candlebase
    rotate x*90
    scale <4,4,1>
    texture { T_Brass_4E }
    translate <-1.5*ft,6*ft,3*ft+1>
    }
#end

// The Unobtainium....
#if (show_cube)
box
    {
    -1 1
    hollow
    no_shadow
    texture{ pigment{ color Clear } }
    interior
        {
        media
            {
            emission 0.3
//            scattering {1, 0.25}
//            absorption rgb<1,0,1>
            density
                {
                boxed
                color_map
                    {
                    [0.0 rgb <0,0.2,0.1>]
                    [0.8 rgb <0,0.4,0.2>]
                    [1.0 rgb <0,0.6,0.2>]
                    }
                scale 4
                turbulence 0.15
                }
            }
        }
    scale 3
    rotate z*15 // purely subjective so it's not square onto the desk
    translate <3,3,3>
    translate <-(2*ft+10),7*ft+5,3*ft+1.01>
    }

 light_source { <-(3*ft),7*ft+7,3*ft+3>+7 color rgb <0,3,.6> fade_distance 6 fade_power 2  }
#end

#if (show_book)
#declare IMPORT_SPATCH = 1;
#declare bookpatch =
#include "book.inc"

object
    {
    bookpatch
    rotate x*90
    texture {pigment { color White }}
    rotate z*100
    scale 8
    translate <-(3*ft),5*ft+4,3*ft+4>
    texture {pigment
        {
        image_map
            {
            gif "unobtain_text.gif"
            filter 9 1 // erase color 9 (white)
            once
            }
        rotate z*100
        scale <6,9,1>
        translate <-(2*ft),5*ft+6.5,3*ft+4.5>
        }}
    }

#end

#if (show_hand)
union
    {
    object
        {
        rhand
        texture{ pigment {color Flesh} }
        finish{ phong 0 reflection 0 }
        }
    object
        {
        sleeve
        texture{ pigment {color Red} }
        }
    rotate y*180
    rotate z*-30
    rotate x*25
    scale 2/3
    translate <-(3*ft),6*ft,3*ft+4.9>
    }
#end

// floor
#declare floorboard =
    box
        {
        <0,  -(room_size),   0> <6, room_size, 1>
        }

#declare i = -room_size;
#while (i < room_size +6)
    object { floorboard texture { T_Wood21 scale 20 translate z*i } translate x*i }
#declare i = i + 6;
#end

// pen - it's simple, it's LATE, and I'm desperate...
cone
    {
    0 1/16 z*6 1/6
    open
    texture { T_Silver_1A }
    rotate y*-15
    rotate x*-35
    translate <-(3*ft-.75),6*ft,3*ft+5>
    }
