// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Ballistic Macro Version 3.0
// Date: Nov 98
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 

// Designed for short "animal" fur.

// SUBFUNCTIONS

// CALCULATE THE AREA OF A TRIANGLE
#macro Triangle_Area(P1,P2,P3)
  #local V12 = (P2 - P1);
  #local V23 = (P3 - P2);
  #declare Tri_Area = (vlength(vcross(V12, V23)) / 2);
#end

// CALCULATE TRIANGLE NORMAL
#macro Triangle_Normal (P1,P2,P3,Nsign)
	#local P4 = (P1 - P3);
	#local P5 = (P2 - P3);
	#local N1 = vcross (P4,P5);
	#local N2 = vnormalize (N1);
	#declare First_Normal = (N2 * Nsign);
#end 

// STARTING POINT IN TRIANGLE
#macro Start_point (P1,P2,P3)
	#declare First_Start = ((P1 + P2 + P3) / 3);
#end 

// RANDOM POINT IN TRIANGLE
#macro Get_New_Start (P1,P2,P3)
	#local R1 = rand(B_Rand);
	#local R2 = rand(B_Rand);
	#if ((R1 + R2) > 1)
		#local R1 = (1 - R1);
		#local R2 = (1 - R2);
	#end
	#local R3 = (1 - R1 - R2);
	#declare New_Start = ((R1 * P1) + (R2 * P2) + (R3 * P3));
#end

// CALCULATES THE END POINT OF THE CONE
#macro Get_End_Point (P1,D1,N1)
	#declare End_Point = (P1 + (N1 * D1));
#end

// DRAWS A CONE
#macro Make_Cone (P1,P2,R1) 
	cone {P1,R1,P2,0 
		#if (Mcolour = 1) pigment{rgb <2,2,2>} #end
		#if (Mcolour = 2) pigment{rgb <1.8431,1.4117,1.0274>} #end
		#if (Mcolour = 3) pigment{rgb <1.6156,1.0666,0.7058>} #end 
	finish{phong 1 ambient .2 diffuse .7}}
#end                          

// DRAWS A TRIANGLE
#macro Make_Triangle (P1,P2,R1) 
	#local S1 = rand(B_Rand);
	#if (S1 < .5) #local S1 = 1; #else #local S1 = -1; #end
	#local S2 = rand(B_Rand);
	#if (S2 < .5) #local S2 = 1; #else #local S2 = -1; #end
	#local S3 = rand(B_Rand);
	#if (S3 < .5) #local S3 = 1; #else #local S3 = -1; #end     
	#local Temp_Normal = <(rand(B_Rand) * J1 * S1),(rand(B_Rand) * J1 * S2),(rand(B_Rand) * J1 * S3)>;
	#local Temp_Normal2 = (vnormalize (Temp_Normal) * R1);
	#local P3 = (P1 + Temp_Normal2);
	triangle {P1,P2,P3 
	#if (Mcolour = 1) pigment{rgb <2,2,2>} #end
	#if (Mcolour = 2) pigment{rgb <1.8431,1.4117,1.0274>} #end
	#if (Mcolour = 3) pigment{rgb <1.6156,1.0666,0.7058>} #end 
	finish{phong 1 ambient .2 diffuse .7}}
#end 
	
// ADDS TWO NORMALS TOGETHER
#macro Add_Normal (N1,N2)
	#local N3 = (N1 + N2);
	#declare New_Normal = vnormalize (N3);
#end

// CALCULATES THE QUANTITY OF VECTORS PER TRIANGLE
#macro Loop_Quantity (P1,P2,P3,R1,DN1)
	Triangle_Area(P1,P2,P3)
	#declare Loops = abs((Tri_Area * DN1) / R1);
#end

// JITTER FUNCTION
#macro Jitter_Normal (N1,J1)
	#if (J1 = 0)
		#declare New_Normal = N1;
	#else
		#local S1 = rand(B_Rand);
		#if (S1 < .5) #local S1 = 1; #else #local S1 = -1; #end
		#local S2 = rand(B_Rand);
		#if (S2 < .5) #local S2 = 1; #else #local S2 = -1; #end
		#local S3 = rand(B_Rand);
		#if (S3 < .5) #local S3 = 1; #else #local S3 = -1; #end     
		#local Temp_Normal = <(rand(B_Rand) * J1 * S1),(rand(B_Rand) * J1 * S2),(rand(B_Rand) * J1 * S3)>;
		#declare New_Normal = vnormalize (N1 + Temp_Normal);
	#end  
#end

// LENGTH VARIATION FUNCTION
#macro Get_New_Length (D1,L1) 
	#local S1 = rand(B_Rand);
	#if (S1 < .5) #local S1 = 1; #else #local S1 = -1; #end 
	#declare New_Length = (D1 + (D1 * L1 * rand(B_Rand) * S1));
#end

// COLOUR VARIATION ROUTINE
#macro Get_Colour ()
	#local Test1 = rand(B_Rand);
	#if (Test1 < 0.002)               // select new colour
		#local Test2 = rand(B_Rand);
		#if (Test2 < .5)
			#local Dir = -1;
		#else
			#local Dir = 1;
		#end
	#else
		#local Dir = 0;
	#end
	#declare Mcolour = (Mcolour + Dir);
	#if (Mcolour > 3) #declare Mcolour = 1; #end
	#if (Mcolour < 1) #declare Mcolour = 3; #end
#end

// X,Y,Z COMPONENT OF VECTOR V1 
#macro V_Component (V1,Axis)
	#if (Axis = 1) #local Factor = <0,-1,-1>; #local Factor2 = <0.0001,0,0>; #end
	#if (Axis = 2) #local Factor = <-1,0,-1>; #local Factor2 = <0,0.0001,0>; #end
	#if (Axis = 3) #local Factor = <-1,-1,0>; #local Factor2 = <0,0,0.0001>; #end 
	#local Isolated = (V1 + (V1 * Factor));
	#if (vlength(Isolated) > vlength(Isolated - Factor2))
		#local S1 = 1;
	#else
		#local S1 = -1;
	#end        
	
	(vlength(Isolated) * S1);
#end

// 4 COMPONENT TEST CONDITION. RETURNS 1 IF TRUE 0 IF FALSE
#macro Zone (Y1,Y2,Z1,Z2,VY,VZ)
	#if (VY >= Y1)
		#if (VY <= Y2)
			#if (VZ >= Z1)
				#if (VZ <= Z2) 
					#local Zone_Result = 1;
				#else
					#local Zone_Result = 0;
				#end
			#else
				#local Zone_Result = 0;
			#end
		#else
			#local Zone_Result = 0;
		#end
	#else
		#local Zone_Result = 0;
	#end
	
	Zone_Result 
		
#end

// LENGTH VARIATION FUNCTIONS
// Head Zone
#macro Head_Length (Z_Limit)  
	#local Fix_Zone = 0.228;
	#local Fix_Start = 0.1675;
	#local Lvariation = (Strand_Length - Min_Length);
	#local LGradient = (Fix_Zone - Fix_Start);
	#local Steps = (Lvariation / LGradient);
	
	#if (Z_Limit <= Fix_Zone) 
		#declare Zone_Length = (((Fix_Zone - Z_Limit) * Steps) + Min_Length);
	#end
	#if (Z_Limit > Fix_Zone) #declare Zone_Length = Min_Length; #end	

	// debug stuff
	#if (Fur_Debug = on)
		#declare DDD = 1;
	#end

#end 
// Front Horizontal Paw
#macro Paw1_Length (Z_Limit) 
#local Fix_Zone = 0.245;
	#local Fix_Start = 0.173;
	#local Lvariation = (Strand_Length - Min_Length);
	#local LGradient = (Fix_Zone - Fix_Start);
	#local Steps = (Lvariation / LGradient);
	
	#if (Z_Limit <= Fix_Zone) 
		#declare Zone_Length = (((Fix_Zone - Z_Limit) * Steps) + Min_Length);
	#end
	#if (Z_Limit > Fix_Zone) #declare Zone_Length = Min_Length; #end	
	
	// debug stuff
	#if (Fur_Debug = on)
		#declare DDD = 1;
	#end
	
#end       

// Front Vertical Paw
#macro Paw2_Length (Y_Limit)
	#local Fix_Zone = 0.074;
	#local Fix_Start = 0.13;
	#local Lvariation = (Strand_Length - Min_Length);
	#local LGradient = (Fix_Start - Fix_Zone);
	#local Steps = (Lvariation / LGradient);
	
	#if (Y_Limit >= Fix_Zone) 
		#declare Zone_Length = (((Y_Limit - Fix_Zone) * Steps) + Min_Length);
	#end
	#if (Y_Limit < Fix_Zone) #declare Zone_Length = Min_Length; #end	
	
	// debug stuff
	#if (Fur_Debug = on)
		#declare DDD = 1;
	#end
	
#end

// REAR LEGS
#macro Rear_Length (Y_Limit)
	#local Fix_Zone = 0.04;
	#local Fix_Start = 0.108;
	#local Lvariation = (Strand_Length - Min_Length);
	#local LGradient = (Fix_Start - Fix_Zone);
	#local Steps = (Lvariation / LGradient);
	
	#if (Y_Limit >= Fix_Zone) 
		#declare Zone_Length = (((Y_Limit - Fix_Zone) * Steps) + Min_Length);
	#end
	#if (Y_Limit < Fix_Zone) #declare Zone_Length = Min_Length; #end  
	
	// debug stuff   
	#if (Fur_Debug = on)
		#declare DDD = 1;
	#end
#end

// LENGTH VARIATION ROUTINE SHAPED TO GEOMETRY OF KITTEN BODY
#macro Find_New_Length (P1,D1) 
	#local ZC = V_Component (P1,3)
	#local YC = V_Component (P1,2)
	
	// Set Zone_Length to Original Length.
	#declare Zone_Length = D1;
	
	// Head Zone
	#if (Zone (0.265,0.413,0.1675,0.283,YC,ZC) = 1) Head_Length (ZC) #end 
	// Front Horizontal Paw
	#if (Zone (0.137,0.265,0.173,0.327,YC,ZC) = 1) Paw1_Length (ZC) #end
	// Front Vertical Paw
	#if (Zone (0.0,0.13,0.085,0.137,YC,ZC) = 1) Paw2_Length (YC) #end
	// Rear Legs 
	#if (Zone (0.0,0.108,-0.155,0.074,YC,ZC) = 1) Rear_Length (YC) #end	 
	
	
#end

// FIRST STAGE BALLISTIC ROUTINE
#macro Ballistic_One (P1,P2,P3,D1,R1)
	Start_point (P1,P2,P3)  
	Get_End_Point (First_Start,D1,First_Normal)  
	#if (Strand_Type = 0)
		Make_Cone (First_Start,End_Point,R1) 
	#else  
		Make_Triangle (First_Start,End_Point,R1)
	#end
#end         

// SECOND STAGE BALLISTIC ROUTINE 
// P1 = FIRST POINT IN TRIANGLE
// P2 = SECOND POINT IN TRIANGLE
// P3 = THIRD POINT IN TRIANGLE
// D1 = LENGTH OF STRAND
// R1 = RADIUS OF STRAND
// DN1 = DENSITY OF STRANDS ON TRIANGLE
// NS1 = SIGN OF NORMAL 
// NV1 = DIRECTION VECTOR IF = 0 THEN NO EFFECT
// J1 = JITTER AMOUNT
// L1 = LENGTH VARIATION OF STRAND AS A PERCENTAGE OF ORIGINAL. 1 = 100%
// PG1 = COLOUR VECTOR
#macro Ballistic_Two (P1,P2,P3,D1,R1,DN1,NS1,J1,L1)

	#if (DN1 = 0) #declare Loops = 1; #else Loop_Quantity (P1,P2,P3,R1,DN1) #end	// density 
	Triangle_Normal (P1,P2,P3,NS1)													// triangle normal
    
    // debug stuff
    #if (Fur_Debug = on)
    	#declare DDD = 0;
    #end
    
	Find_New_Length (P1,D1)	
															// fur depth stuff
	// debug stuff 
	#if (Fur_Debug = on)
		#if (DDD = 1) 
			sphere {P1,0.01 pigment{Red}} #declare DDD = 0;
			#fopen Debugfile "degub.txt" append
			#write (Debugfile,P1) 
			#fclose Debugfile 
		#end
	#end

	// debug stuff 
	#if (Fur_Debug = off)
	
	#local Count1 = 0;
	#while (Count1 < Loops)    
	
		#if (Count1 = 0)
			Ballistic_One (P1,P2,P3,Zone_Length,R1)
		#else
			Get_New_Start (P1,P2,P3)
			Jitter_Normal (First_Normal,J1) 
			Get_New_Length (Zone_Length,L1)
			Get_End_Point (New_Start,New_Length,New_Normal)    
			Get_Colour()  
			#if (Strand_Type = 0)
				Make_Cone (New_Start,End_Point,R1)
			#else
				Make_Triangle (New_Start,End_Point,R1)
			#end
		#end
	
		#local Count1 = (Count1 + 1);
	#end

	#end	// end debug

#end    

//eof