

#include "torspline.inc"

#declare Count1 = 0;
#declare Qty = 300;        

#declare Start_Rad = .19;
#declare End_Rad = .2;

#declare Origin_alsin = <-.2,.2,.8>;



#declare Monica = seed(13);   
#declare Gradient = (End_Rad - Start_Rad);
#declare Step = (Gradient / Qty);
#declare Step1 = Step; 

#fopen Datafile "datapoint.inc" write 
#write (Datafile, "#declare Wool = array[Qty]{") 
	#while (Count1 < Qty)
	
		#local President = rand(Monica);
		#if (President < .5) #local President = 1; #else #local President = -1; #end 
	
		#local Bill = rand(Monica);
		#if (Bill < .5) #local Bill = 1; #else #local Bill = -1; #end 
		
		#local Clinton = rand(Monica);
		#if (Clinton < .5) #local Clinton = 1; #else #local Clinton = -1; #end  
		
		#local Truth = <(rand(Monica) * President),
						(rand(Monica) * Bill),
						(rand(Monica) * Clinton)
						>; 
		
		#local Apparant_Truth = vaxis_rotate (<0,0,(Start_Rad + Step1)>,Truth,(rand(Monica) * 360));						
						
		#write (Datafile, (Apparant_Truth + Origin_alsin)) 
		#if (Count1 < (Qty - 1))
			#write (Datafile, ",\n")
		#end		
	                           
		#declare Step1 = (Step1 + Step);	                           
		#declare Count1 = (Count1 + 1);
	#end
#write (Datafile, "}")
#fclose Datafile   

#include "datapoint.inc"

TorusSpline( .005, Wool, 0 )
light_source {<-.15,.5,.75> color Gray50 fade_distance .25 fade_power 2 shadowless}


sphere {Origin_alsin,Start_Rad 
	pigment{rgb <.8,.5,.35>}
	normal {gradient x+y+z .75 scale 0.02 
		scallop_wave rotate <-20,30,25> 
		turbulence .5
		octaves 1
		omega 4
	} 
	
}   

#declare Logo = array[22]{<-.2,.005,.8>,<-.1,.005,.7>,<-.2,.005,.6>,<-.2,.005,.4><-.2,.005,.35><-.3,.005,.36><-.3,.005,.42>,
	<-.3,.015,.36>,<-.3,.007,.19>,<-.2,.005,.2>,<-.1,.005,.3>,<-.2,.015,.3>,<-.2,.015,.2>,<-.15,.012,.1>,<-.15,.01,-.1>,
	<-.14,.007,-.05>,<-.15,.005,-.1>,<-.3,.005,.18>,<-.2,.005,-.1>,<-.3,.005,.16>,<-.2,.005,-.08>,<-.3,.015,-.12>}   

#declare Logo1 = array[3]{<-.2,.005,.1>,<-.25,.005,.1>,<-.32,.005,.1>}  

#declare Logo2 = array[7]{<-.2,.005,.075>,<-.2,.005,0>,<-.22,.005,0>,<-.235,.005,0.05><-.25,.005,0.05>,<-.26,.005,0>,<-.3,.005,.075>}

#declare Logo3 = array[3]{<-.3,.005,-.3>,<-.1,.005,-.3>,<-.2,.005,-.4>}

TorusSpline( .005, Logo, 0 )
TorusSpline( .005, Logo1, 0 )
TorusSpline( .005, Logo2, 0 ) 
TorusSpline( .005, Logo3, 0 )
