// *****************************************************
// LENS FLARE INCLUDE FILE FOR PERSISTENCE OF VISION 3.x
// *****************************************************
//
// Created by Chris Colefax, November 1996
// Last Updated March 1997
//
// Basic usage:
//
//   #declare camera_location = < [camera location vector] >
//   #declare camera_look_at = < [camera look-at vector] >
//   #declare flare_position = < [light source location vector] >
//   #include "LensFlar.inc"
//
// See "LensFlar.txt" for more information.
//
// *****************************************************

// CHECK DECLARED VARIABLES
// ************************
   #declare _LF_tempver = version #version 3.0
   #declare _LF_noflare = false
   #ifndef (camera_location) #warning "Lens flare camera_location not specified.  " #declare _LF_noflare = true #end
   #ifndef (camera_look_at) #warning "Lens flare camera_look_at not specified.  "   #declare _LF_noflare = true #end
   #ifndef (flare_position) #warning "Lens flare_position not specified.  "         #declare _LF_noflare = true #end
   #ifndef (_LF_count) #declare _LF_count = 1 #end
   #if (_LF_noflare = false)

// ASSIGN DEFAULT VALUES
// *********************
   #ifndef (flare_type)         #declare flare_type = 1              #end
   #ifndef (flare_size)         #declare flare_size = 1              #end
   #ifndef (flare_brightness)   #declare flare_brightness = 1        #end
   #ifndef (flare_spots)        #declare flare_spots = true          #end
   #ifndef (flare_spot_spacing) #declare flare_spot_spacing = 1      #end
   #ifndef (flare_glow)         #declare flare_glow = true           #end
   #ifndef (flare_rays)         #declare flare_rays = true           #end
   #ifndef (flare_seed)         #declare flare_seed = 0              #end
   #ifdef  (flare_color)        #declare flare_colour = flare_color  #end
   #ifndef (flare_colour)       #declare flare_colour = <1,1,1>      #end
   #ifndef (flare_rotate)       #declare flare_rotate = 0            #end
   #ifndef (flare_count)        #declare flare_count = 1             #end
   #ifndef (_LF_rand)           #declare _LF_rand = seed(flare_seed) #end
   #ifndef (_LF_finish)         #declare _LF_finish = finish {
     ambient 1 diffuse 0 reflection 0 refraction 0 phong 0 specular 0 crand 0 caustics 0
     } #end

// CALCULATE DISTANCES, ANGLES, AND TRANSPARENCY
// *********************************************
   #ifdef (camera_direction) #declare _LF_cscale = 1 / vlength(camera_direction * <1, 1, 1>)
      #else #ifdef (camera_angle) #declare _LF_cscale = tan(radians(camera_angle) / 2) / .6667
      #else #declare _LF_cscale = 1
   #end #end

   #declare _LF_scale = _LF_cscale * flare_size * <1, 1, 1>
   #declare _LF_rellook = (camera_look_at * <1, 1, 1>) - (camera_location * <1, 1, 1>)
   #declare _LF_relpos = vrotate (
     vrotate ((flare_position * <1, 1, 1>) - (camera_location * <1, 1, 1>),
             -y * degrees( atan2( _LF_rellook.x, _LF_rellook.z))),
              x * degrees( atan2( _LF_rellook.y, vlength(_LF_rellook * <1,0,1>))))

   #declare _LF_ctrdist = degrees (atan2 (vlength(_LF_relpos * <1,1,0>), _LF_relpos.z))
   #declare _LF_angle = degrees (atan2 (_LF_relpos.y, _LF_relpos.x))
   #declare _LF_armsize = flare_spot_spacing * _LF_scale * ((_LF_ctrdist / 45) + 1) / flare_size
   #declare _LF_frot1 = <0, _LF_ctrdist, _LF_angle>
   #declare _LF_frot2 = <-degrees (atan2 (_LF_relpos.y, vlength (_LF_relpos * <1,0,1>))),
                         degrees (atan2 (_LF_relpos.x, _LF_relpos.z)), 0>
   #declare _LF_lrot = <-degrees (atan2 (_LF_rellook.y, vlength (_LF_rellook * <1,0,1>))),
                        degrees (atan2 (_LF_rellook.x, _LF_rellook.z)), 0>

   #declare _LF_trans = (60 - _LF_ctrdist) / 20
   #if (_LF_trans > 1) #declare _LF_trans = 1 #end
   #declare _LF_trans = 1 - (_LF_trans * flare_brightness)

// CANCEL FLARE IF INVISIBLE
// *************************
   #if (_LF_trans >= 1) #warning "Lens flare transparent.  " #declare _LF_noflare = true
   #else

// CREATE LENS SPHERE FOR FIRST LENS FLARE ONLY
// ********************************************
   #ifndef (_LF_created) #declare _LF_created = true
   sphere {<0, 0, 0>, 1 #end

// SELECT FLARE TYPE
// *****************
   #switch (flare_type)

// LENS FLARE TYPE 1
// *****************
   #case (1)

// RIGHT LENS FLARE ARM SPOTS
// **************************
   #if (flare_spots != false)
   #declare _LF_srot = .1 #while (_LF_srot <= 1)
   #declare _LF_ssize = rand (_LF_rand) * _LF_srot * 3
   #declare _LF_strans = .85 + (_LF_ssize * .15 / 3)
   #declare _LF_strans = _LF_strans + (_LF_trans * (1 - _LF_strans))
   #declare _LF_scol = <rand(_LF_rand), rand(_LF_rand), rand(_LF_rand)> * .5 + .5
   #declare _LF_scol = _LF_scol * flare_colour
      texture {pigment {wood color_map {
         [0    rgb _LF_scol transmit _LF_strans + .05]
         [.01  rgb _LF_scol transmit _LF_strans]
         [.011 rgb _LF_scol transmit 1]}}
      finish {_LF_finish}
      scale (_LF_ssize * 10 + 5) * _LF_scale
      rotate y * _LF_srot * 40 * _LF_armsize rotate _LF_frot1}
   #declare _LF_srot = _LF_srot + rand(_LF_rand) * .1 + .05 #end

// LEFT LENS FLARE ARM SPOTS
// *************************
   #declare _LF_srot = .1 #while (_LF_srot <= 1)
   #declare _LF_ssize = rand (_LF_rand) * _LF_srot * 3
   #declare _LF_strans = .85 + (_LF_ssize * .15 / 3)
   #declare _LF_strans = _LF_strans + (_LF_trans * (1 - _LF_strans))
   #declare _LF_scol = <rand(_LF_rand), rand(_LF_rand), rand(_LF_rand)> * .5 + .5
   #declare _LF_scol = _LF_scol * flare_colour
      texture {pigment {wood color_map {
         [0    rgb _LF_scol transmit _LF_strans + .05]
         [.01  rgb _LF_scol transmit _LF_strans]
         [.011 rgb _LF_scol transmit 1]}
      scale (_LF_ssize * 10 + 5) * _LF_scale
      rotate -y * _LF_srot * 40 * _LF_armsize rotate _LF_frot1}
      finish {_LF_finish}}
   #declare _LF_srot = _LF_srot + rand(_LF_rand) * .1 + .05 #end
   #end

// PRIMARY LENS FLARE RAYS
// ***********************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0  rgbt <1, 1, 1, .3 + (_LF_trans * .7)>]
         [.1 rgbt <1, 1, 1, 1>]}
         frequency 6 triangle_wave rotate <90,0,30>]
      [.1 rgbt <1,1,1,1>]}}
      finish {_LF_finish} scale 10 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}

// SECONDARY LENS FLARE RAYS
// *************************
   texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0 rgbt <1, 1, 1, .6 + (_LF_trans * .4)>]
         [1 rgbt <1, 1, 1, 1>]}
         frequency 26 triangle_wave rotate <90,0,-15>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 4 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW AND HALO
// ************************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [0    rgbt <1, 1, 1, _LF_trans>]
      [.02  rgb <.8, .9, 1> * flare_colour transmit .4 + (_LF_trans * .6)]
      [.05  rgb <.8, .9, 1> * flare_colour transmit 1]
      [.1   rgbt <1, 0, 0, 1>]
      [.112 rgbt <1, 0, 0, .9 + (_LF_trans * .1)>]
      [.114 rgbt <1, 1, 0, .9 + (_LF_trans * .1)>]
      [.116 rgbt <0, 1, 0, .9 + (_LF_trans * .1)>]
      [.118 rgbt <0, 1, 1, .9 + (_LF_trans * .1)>]
      [.120 rgbt <0, 0, 1, .9 + (_LF_trans * .1)>]
      [.122 rgbt <1, 0, 1, .9 + (_LF_trans * .1)>]
      [.13  rgbt <1, 0, 1, 1>]}}
      finish {_LF_finish} scale 4 * _LF_scale rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 2
// *****************
   #case (2)

// RIGHT LENS FLARE ARM SPOTS
// **************************
   #if (flare_spots != false)
   #declare _LF_srot = .1 #while (_LF_srot <= 1)
   #declare _LF_ssize = _LF_srot + (rand (_LF_rand) * .2 - .1)
   #declare _LF_strans = .7 + (.2 * _LF_srot)
   #declare _LF_strans = _LF_strans + (_LF_trans * (1 - _LF_strans))
      texture {pigment {wood color_map {
         [0    rgb <1, 1, .8> * flare_colour transmit _LF_strans + .1]
         [.005 rgb <1, 1, .8> * flare_colour transmit _LF_strans]
         [.006 rgb <1, 1, .8> * flare_colour transmit 1]}
      scale (_LF_ssize * 40 + 4) * _LF_scale
      rotate y * _LF_srot * 40 * _LF_armsize rotate _LF_frot1}
      finish {_LF_finish}}
   #declare _LF_srot = _LF_srot + (_LF_ssize * 20 + 2) / 50 #end

// LEFT LENS FLARE ARM SPOTS
// **************************
   #declare _LF_srot = .1 #while (_LF_srot <= 1)
   #declare _LF_ssize = _LF_srot + (rand (_LF_rand) * .2 - .1)
   #declare _LF_strans = .7 + (.2 * _LF_srot)
   #declare _LF_strans = _LF_strans + (_LF_trans * (1 - _LF_strans))
      texture {pigment {wood color_map {
         [0    rgb <1, 1, .8> * flare_colour transmit _LF_strans + .1]
         [.005 rgb <1, 1, .8> * flare_colour transmit _LF_strans]
         [.006 rgb <1, 1, .8> * flare_colour transmit 1]}
      scale (_LF_ssize * 40 + 4) * _LF_scale
      rotate -y * _LF_srot * 40 * _LF_armsize rotate _LF_frot1}
      finish {_LF_finish}}
   #declare _LF_srot = _LF_srot + (_LF_ssize * 20 + 2) / 50 #end
   #end

// PRIMARY LENS FLARE RAYS
// ***********************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0  rgbt <1, 1, 1, .4 + (_LF_trans * .6)>]
         [.4 rgb <1, 1, 0> * flare_colour transmit 1]
         [.8 rgb <1, 1, 0> * flare_colour transmit 1]
         [1  rgbt <1, 1, 1, .8 + (_LF_trans * .2)>]}
         frequency 9 triangle_wave rotate <90,0,0>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 8 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW AND HALO
// ************************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [.01 rgbt <1, 1, 1, _LF_trans>]
      [.02 rgb <1, 1, .5> * flare_colour transmit .3 + (_LF_trans * .7)]
      [.1  rgb <1, .5, .5> * flare_colour transmit 1]
      [.12 rgb <.8, .3, .3> * flare_colour transmit .7 + (_LF_trans * .3)]
      [.13 rgb <.8, .3, .3> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 4 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 3
// *****************
   #case (3)

// RIGHT LENS FLARE ARM SPOTS
// **************************
   #if (flare_spots != false)
   #declare _LF_srot = .1 #while (_LF_srot <= 1)
   #declare _LF_ssize = _LF_srot + (rand (_LF_rand) * .2 - .1)
   #declare _LF_strans = .8 + (.15 * _LF_srot)
   #declare _LF_strans = _LF_strans + (_LF_trans * (1 - _LF_strans))
   #declare _LF_scol = <rand (_LF_rand), 0, 1> * .3 + .7
   #declare _LF_scol = _LF_scol * flare_colour
      texture {pigment {gradient x pigment_map {
         [.005 gradient y color_map {
            [.005 rgb _LF_scol transmit _LF_strans]
            [.007 rgbt <1, 1, 1, 1>]}]
         [.007 rgbt <1, 1, 1, 1>]} rotate z * 45 scale <6, 4, 1>
      scale (_LF_ssize * 3 + 1) * _LF_scale
      rotate y * _LF_srot * 40 * _LF_armsize rotate _LF_frot1}
      finish {_LF_finish}}
   #declare _LF_srot = _LF_srot + (_LF_ssize * 3 + 1) / 15 #end

// LEFT LENS FLARE ARM SPOTS
// *************************
   #declare _LF_srot = .1 #while (_LF_srot <= 1)
   #declare _LF_ssize = _LF_srot + (rand (_LF_rand) * .2 - .1)
   #declare _LF_strans = .8 + (.15 * _LF_srot)
   #declare _LF_strans = _LF_strans + (_LF_trans * (1 - _LF_strans))
   #declare _LF_scol = <rand (_LF_rand), 0, 1> * .3 + .7
   #declare _LF_scol = _LF_scol * flare_colour
      texture {pigment {gradient x pigment_map {
         [.005 gradient y color_map {
            [.005 rgb _LF_scol transmit _LF_strans]
            [.007 rgbt <1, 1, 1, 1>]}]
         [.007 rgbt <1, 1, 1, 1>]} rotate z * 45 scale <6, 4, 1>
      scale (_LF_ssize * 3 + 1) * _LF_scale
      rotate -y * _LF_srot * 40 * _LF_armsize rotate _LF_frot1}
      finish {_LF_finish}}
   #declare _LF_srot = _LF_srot + (_LF_ssize * 3 + 1) / 15 #end
   #end

// LENS FLARE RAYS
// ***************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0  rgbt <1, 1, 1, .5 + (_LF_trans * .5)>]
         [.4 rgbt <1, 1, 1, 1>]
         [.5 rgbt <1, 1, 1, .8 + (_LF_trans * .2)>]
         [.6 rgbt <1, 1, 1, 1>]
         [.8 rgbt <1, 1, 1, 1>]
         [1  rgbt <1, 1, 1, .7 + (_LF_trans * .3)>]}
         frequency 8 triangle_wave rotate <90,0,22.5>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 10 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW
// ***************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [.005 rgbt <1, 1, 1, _LF_trans>]
      [.015 rgb <.6, .5, 1> * flare_colour transmit .4 + (_LF_trans * .6)]
      [.1   rgb <1, .5, 1> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 6 * _LF_scale rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 4
// *****************
   #case (4)

// PRIMARY LENS FLARE RAYS
// ***********************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0   rgbt <1, 1, 1, 1>]
         [.03 rgbt <1, 1, 1, .3 + (_LF_trans * .7)>]
         [.06 rgbt <1, 1, 1, 1>]}
         frequency 2 triangle_wave rotate <90,0,0>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 15 * _LF_scale rotate _LF_frot1}
   texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0   rgbt <1, 1, 1, 1>]
         [.03 rgbt <1, 1, 1, .2 + (_LF_trans * .8)>]
         [.06 rgbt <1, 1, 1, 1>]}
         frequency 2 triangle_wave rotate <90,0,90>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 10 * _LF_scale rotate _LF_frot1}

// SECONDARY LENS FLARE RAYS
// *************************
   texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0 rgbt <1, 1, 1, .6 + (_LF_trans * .4)>]
         [1 rgbt <1, 1, 1, 1>]}
         frequency 67 triangle_wave rotate <90,0,0>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 6 * _LF_scale rotate _LF_frot1}
   texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0  rgbt <1, 1, 1, .5 + (_LF_trans * .5)>]
         [.1 rgbt <1, 1, 1, 1>]}
         frequency 4 triangle_wave rotate <90,0,45>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 10 * _LF_scale rotate _LF_frot1}
   #end

// LENS FLARE GLOW
// ***************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [.005 rgbt <1, 1, 1, _LF_trans>]
      [.03  rgb <.6, 1, .6> * flare_colour transmit .5 + (_LF_trans * .5)]
      [.1   rgb <.6, 1, .6> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 6 * _LF_scale rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 5
// *****************
   #case (5)

// LENS FLARE RAYS
// ***************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0   rgbt <1, 1, 1, .3 + (_LF_trans * .7)>]
         [.2  rgbt <1, 1, 1, 1>]
         [.6  rgbt <1, 1, 1, 1>]
         [.67 rgbt <1, 1, 1, .7 + (_LF_trans * .3)>]
         [.74 rgbt <1, 1, 1, 1>]}
         frequency 6 triangle_wave rotate <90,0,15>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 8 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW AND HALO
// ************************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [.005 rgbt <1, 1, 1, _LF_trans>]
      [.015 rgb <1, 1, 1> * flare_colour transmit .5 + (_LF_trans * .5)]
      [.1   rgb <1, 1, 1> * flare_colour transmit 1]
      [.12  rgb <1, 1, 1> * flare_colour transmit .9 + (_LF_trans * .1)]
      [.13  rgb <1, 1, 1> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 4 * _LF_scale rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 6
// *****************
   #case (6)

// LENS FLARE RAYS
// ***************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0 rgbt <1, 1, 1, .7 + (_LF_trans * .3)>]
         [1 rgbt <1, 1, 1, 1>]}
         frequency 37 triangle_wave rotate <90,0,0>]
      [.1 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 5 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW AND HALO
// ************************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [.005 rgbt <1, 1, 1, _LF_trans>]
      [.02  rgb <1, 1, .5> * flare_colour transmit .5 + (_LF_trans * .5)]
      [.1   rgb <1, .2, .2> * flare_colour transmit 1]
      [.11  rgb <1, .5, .5> * flare_colour transmit .7 + (_LF_trans * .3)]
      [.12  rgb <1, .5, .5> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 3 * _LF_scale rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 7
// *****************
   #case (7)

// LENS FLARE RAYS
// ***************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0   rgbt <1, 1, 1, .2 + (_LF_trans * .8)>]
         [.4  rgb <1, 1, 0> * flare_colour transmit 1]
         [.85 rgb <1, 1, 0> * flare_colour transmit 1]
         [1   rgb <1, 1, .7> * flare_colour transmit .7 + (_LF_trans * .3)]}
         frequency 8 triangle_wave rotate <90,0,0>]
      [.05 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 6 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW
// ***************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [0   rgbt <1, 1, 1, _LF_trans>]
      [.01 rgb <1, 1, .8> * flare_colour transmit .5 + (_LF_trans * .5)]
      [.03 rgb <1, .5, 0> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 6 * _LF_scale rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 8
// *****************
   #case (8)

// LENS FLARE RAYS
// ***************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0   rgbt <1, 1, 1, .2 + (_LF_trans * .8)>]
         [.05 rgb <.1, .3, .6> * flare_colour transmit .2 + (_LF_trans * .8)]
         [.4  rgb <.1, .3, .6> * flare_colour transmit 1]}
         frequency 6 triangle_wave rotate <90,0,15>]
      [.05 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 6 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW
// ***************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [0   rgbt <1, 1, 1, _LF_trans>]
      [.02 rgb <.1, .3, .6> * flare_colour transmit .7 + (_LF_trans * .3)]
      [.05 rgb <.1, .3, .6> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 6 * _LF_scale rotate _LF_frot2}
   #end
   #break

// LENS FLARE TYPE 9
// *****************
   #case (9)

// LENS FLARE RAYS
// ***************
   #if (flare_rays != false) texture {pigment {wood pigment_map {
      [0 radial color_map {
         [0  rgbt <1, 1, 1, .2 + (_LF_trans * .8)>]
         [.2 rgb <1, 1, 1> * flare_colour transmit 1]}
         frequency 4 triangle_wave rotate <90,0,25>]
      [.03 rgbt <1, 1, 1, 1>]}}
      finish {_LF_finish} scale 6 * _LF_scale
      rotate z * flare_rotate rotate _LF_frot2}
   #end

// LENS FLARE GLOW
// ***************
   #if (flare_glow != false) texture {pigment {wood color_map {
      [0    rgbt <1, 1, 1, _LF_trans>]
      [.005 rgb <1, 1, 1> * flare_colour transmit .7 + (_LF_trans * .3)]
      [.01  rgb <1, 1, 1> * flare_colour transmit 1]}}
      finish {_LF_finish} scale 6 * _LF_scale rotate _LF_frot2}
   #end
   #break

// CANCEL IF UNKNOWN FLARE TYPE
// ****************************
   #else #warning "Unknown lens flare_type specified.  "
   #declare _LF_noflare = true #end

// SHOW MESSAGE IF NO FLARE CREATED
// ********************************
   #end #end
   #if (_LF_noflare = true) #warning "Lens flare not created.\n\r" #end

// CLOSE LENS SPHERE FOR LAST LENS FLARE
// *************************************
   #ifdef (_LF_created) #if (_LF_count >= flare_count)
   rotate _LF_lrot scale .01 translate camera_location no_shadow hollow}
   #end #end

   #declare _LF_count = _LF_count + 1
   #version _LF_tempver
