#declare Is_Inc_File = true

#if ( Is_Inc_File = false )

// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: Chris Hernandez


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
//#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
//#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"

// -------------------------------- light sources ---------------
light_source { <0, 0.1, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, 50, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, -50, -50> color rgb <0.6, 0.6, 0.6> }
light_source { <-50, 0, -50> color rgb <0.6, 0.6, 0.6> }


background { color rgb <0.6, 0.6, 0.6> }

// ------------------------------------ Camera -------------------
camera {
  location  <0.0 , -0.1 ,-5.0>
  look_at   <0.0 , 0.180 , 0.0>
  //blur_samples 150  aperture 0.050  focal_point <0, 0, -2.75>  confidence 0.95
  angle 11.5
}

#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.70, 0.9 > }
	finish {
	   ambient 0.3
	   diffuse 0.25
	   specular 0.10
	   roughness 0.05
	   //reflection 0.05
       crand 0.015
	}
    //normal { bozo 1.30 ramp_wave translate <1,1,1> scale <1, 1.5, 1> scale 0.30 rotate z*15 }
}

#declare RedT = texture { pigment { color rgb <1,0,0> } }

//#default { texture { TempTexture } }


#end



#declare Blind_Texture = texture {
   pigment { color rgb <0.99, 0.90, 0.75> }
   finish  { ambient 0.30 diffuse 0.30 specular 0.35 roughness 0.075 crand 0.1 }
}


#declare Blind_Spacing = 0.034
#declare Blind_Rotation = 43 //37.5 //35 //25

#declare Blind_Unit = object {
   difference {
      union {
         cylinder { -0.400*x, 0.400*x, 0.03 }
         sphere { 0*x, 0.03 scale <0.5, 1, 1> translate  x*0.400 }
         sphere { 0*x, 0.03 scale <0.5, 1, 1> translate -x*0.400 }
      }
      plane { y, 0 }
      box { <-0.01, 100, -0.018> <0.01, -100, 0.018> translate  x*0.30 }
      box { <-0.01, 100, -0.018> <0.01, -100, 0.018> translate -x*0.30 }
      scale <1, 0.2, 0.5>
      rotate -x*Blind_Rotation
      //translate -x*0.175 //0.20
   }
   texture { Blind_Texture }
}

#declare Blind_Group = object {
   union {
      object { Blind_Unit translate y*00*Blind_Spacing }
      object { Blind_Unit translate y*01*Blind_Spacing }
      object { Blind_Unit translate y*02*Blind_Spacing }
      object { Blind_Unit translate y*03*Blind_Spacing }
      object { Blind_Unit translate y*04*Blind_Spacing }
      object { Blind_Unit translate y*05*Blind_Spacing }
      object { Blind_Unit translate y*06*Blind_Spacing }
      object { Blind_Unit translate y*07*Blind_Spacing }
      object { Blind_Unit translate y*08*Blind_Spacing }
      object { Blind_Unit translate y*09*Blind_Spacing }
      object { Blind_Unit translate y*10*Blind_Spacing }
   }
}

#declare Blind_Top = object {
   union {
      box { <-0.425, 0, 0> <0.425, -0.05, 0.05> }
      cylinder { -0.425*x, 0.425*x 0.0025 scale <1, 1, 1.2> translate -y*0.0075 }
      cylinder { -0.425*x, 0.425*x 0.0025 scale <1, 1, 1.2> translate -y*0.0425 }
   }
   texture { Blind_Texture }
}

#declare Blind_Support = object {
   union {
      cylinder { 0.425*y, 0*y, 0.0015 translate -z*0.015 }
      cylinder { 0.425*y, 0*y, 0.0015 translate  z*0.015 }
   }
   texture {
      pigment { color rgb <0.95, 0.85, 0.5>*0.75 }
      finish  { ambient 0.30 diffuse 0.35 specular 0.1 roughness 0.075 crand 0.1 }
   }
}


#declare Blinds = object {
   union {
      object { Blind_Group translate z*0.025}
      object { Blind_Top translate y*0.425 }
      object { Blind_Support translate < 0.30, 0, 0.025> }
      object { Blind_Support translate <-0.30, 0, 0.025> }
   }
   texture { TempTexture }
}



#if ( Is_Inc_File = false )
object { Blinds rotate y*40 }
#end
